<?php 
namespace app\admin\system;
use cjzy\Admin;
use service\NodeService;
use service\ToolsService;

/**
* 
*/
class Auth extends Admin
{
	public $table = 'system_auth';


    /**
     * 权限列表
     */
    public function index()
    {



        
        $this->title = '系统权限管理';
        
        $db=db($this->table)->where('sid',$this->sid);

        return $this->_list($db);
    }
   
 
     /**
     * 权限添加
     */
    public function add()
    {
        return $this->_form($this->table,'form','',[],['sid'=>$this->sid]);
    }



    /**
     * 权限编辑
     */
    public function edit()
    {
       return $this->_form($this->table,'form');
    }


    /**
     * 权限授权
     * @return string
     */
    public function apply()
    {
        
        $auth_id=input('get.id');
        $method = '_apply_' . strtolower(input('get.act'));

        if (method_exists($this, $method)) {

           return $this->$method($auth_id);
        }
       
        $this->title='节点授权';
        return $this->_form($this->table, 'apply');
    }

    /**
     * 读取授权节点
     * @param $auth_id
     */
    protected function _apply_getnode($auth_id)
    {
        
        

        $nodes = NodeService::get();
        
        $mynode = db($this->table.'_node')->where('auth',$auth_id)->field('node')->select();
        $checked=array();
        foreach ($mynode as &$v) {
        	$checked[]=$v['node'];
        }
       
       
        foreach ($nodes as &$node) {
            $node['checked'] = in_array($node['node'], $checked);
        }
        $all = $this->_apply_filter(ToolsService::arr2tree($nodes, 'node', 'pnode', '_sub_'));
        $this->success('获取节点成功！',  '',$all);


    }

    /**
     * 保存授权节点
     * @param $auth_id
    */
    protected function _apply_save($auth_id)
    {
        list($data, $post) = [[], $_POST];

         db($this->table.'_node')->where('auth',$auth_id)->delete();
         
        foreach (isset($post['nodes']) ? $post['nodes'] : [] as $node) {
           $arr= ['auth' => $auth_id, 'node' => $node];
           db($this->table.'_node')->insert($arr);
        }
         
        list($spm, $url) = [input('get.spm'), iurl('system/auth/index')];

        $this->success('节点授权更新成功！', "#{$url}&spm={$spm}");

      
    }

    /**
     * 节点数据拼装
     * @param array $nodes
     * @param int $level
     * @return array
     */
    protected function _apply_filter($nodes, $level = 1)
    {
        foreach ($nodes as $key => &$node) {
            if (!empty($node['_sub_']) && is_array($node['_sub_'])) {
                $node['_sub_'] = $this->_apply_filter($node['_sub_'], $level + 1);
            }
        }
        return $nodes;
    }




     /**
     * 权限禁用
     */
    public function forbid()
    {
        
        if ($this->update($this->table)) {

            $this->success("权限禁用成功！");
        }

        $this->error("权限禁用失败，请稍候再试！");
    }

    /**
     * 权限恢复
     */
    public function resume()
    {
        
        if ($this->update($this->table)) {

            $this->success("权限启用成功！");
        }
         $this->error("权限启用失败，请稍候再试！");
    }

    /**
     * 权限删除
     */
    public function del()
    {
       
       if ($this->update($this->table)) {

           $this->success("权限删除成功！", '');
        }
      
       $this->error("权限删除失败，请稍候再试！");
    }


}




 ?>