<?php
namespace app\admin\system;
use cjzy\Admin;
use service\NodeService;
use service\ToolsService;



class Menu extends Admin
{

    /**
     * 绑定操作模型
     * @var string
     */
    public $table = 'system_menu';
    public $name='系统菜单';

    /**
     * 菜单列表
     */
    public function index()
    {
        
        
        return parent::_list(db($this->table)->order('sort','desc'),false);
    }

    /**
     * 列表数据处理
     * @param array $data
     */
    protected function _index_data_filter(&$data)
    {
       
       foreach ($data as &$vo) {
          
            $vo['ids'] = join(',', ToolsService::getArrSubIds($data, $vo['id']));
        }
        $data = ToolsService::arr2table($data);
    
    }

    /**
     * 添加菜单
     */
    public function add()
    {   
        
        return $this->_form($this->table,'form');
    }

    /**
     * 编辑菜单
     */
    public function edit()
    {   

        return $this->_form($this->table, 'form');
    }
        /**
     * 表单数据前缀方法
     * @param array $vo
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    protected function _form_filter(&$vo)
    {
        if (!$this->isPost) {
            // 上级菜单处理
            $_menus = db($this->table)->where(['status' => '1'])->order(['sort'=>'asc','id'=>'asc'])->select();
            $_menus[] = ['title' => '顶级菜单', 'id' => '0', 'pid' => '-1'];
            $menus = ToolsService::arr2table($_menus);
            foreach ($menus as $key => &$menu) {
                if (substr_count($menu['path'], '-') > 3) {
                    unset($menus[$key]);
                    continue;
                }
                if (isset($vo['pid'])) {
                    $current_path = "-{$vo['pid']}-{$vo['id']}";
                    if ($vo['pid'] !== '' && (stripos("{$menu['path']}-", "{$current_path}-") !== false || $menu['path'] === $current_path)) {
                        unset($menus[$key]);
                        continue;
                    }
                }
            }
            // 读取系统功能节点
            $nodes = NodeService::get();
            foreach ($nodes as $key => $node) {
                if (empty($node['is_menu'])) {
                    unset($nodes[$key]);
                }
            }
            // 设置上级菜单
            if (!isset($vo['pid']) && input('get.pid', '0')) {
                $vo['pid'] = input('get.pid', '0');
            }
            $this->assign(['nodes' => array_column($nodes, 'node'), 'menus' => $menus]);
        }
    }
    

    /**
     * 删除菜单
     */
    public function del()
    {
        if ($this->update($this->table)) {
            $this->success($this->name."删除成功!", '');
        }
        $this->error($this->name."删除失败, 请稍候再试!");
    }

    /**
     * 菜单禁用
     */
    public function forbid()
    {
        if ($this->update($this->table)) {
            $this->success($this->name."禁用成功!", '');
        }
        $this->error($this->name."禁用失败, 请稍候再试!");
    }

    /**
     * 菜单禁用
     */
    public function resume()
    {
        if ($this->update($this->table)) {
            $this->success($this->name."启用成功!", '');
        }
        $this->error($this->name."启用失败, 请稍候再试!");
    }

}
