<?php 
namespace app\admin\system;
use cjzy\Admin;

class User extends Admin
{
	
   public $table = 'system_user';

  function index(){

       $this->title = '系统用户管理';
       $get =input('get.');
       $w=array('sid'=>$this->sid,'is_deleted'=>'0');

       
        foreach (['username', 'phone', 'mail'] as $key) {
            (isset($get[$key]) && $get[$key] !== '') && $w[$key.' like']="%{$get[$key]}%";
        }

        if (isset($get['date']) && $get['date'] !== '') {
            list($start, $end) = explode('-',str_replace('+', '', $get['date']));
            $start=strtotime($start .' 00:00:00');
            $end=strtotime($end .' 23:59:59');
            $w['login_at >=']=$start;
            $w['login_at <=']=$end;
        }
      
        $admin=session('adminuser');

        if($admin['type']!=1){
           $w['type']=0;
        } 

        return $this->_list(db($this->table)->where($w));


  }





    /**
     * 用户添加
     */
    public function add()
    {
          
        return $this->_form($this->table, 'form','',[],['sid'=>$this->sid]);
    }

    /**
     * 用户编辑
     */
    public function edit()
    {
         
       return $this->_form($this->table, 'form');
    }

    /**
     * 用户密码修改
     */
    public function pass()
    {
    	
         if (!$this->isPost) { 

             $verify=false;
             return $this->_form($this->table, 'pass');
          }

          $post = input('post.');

          if ($post['password'] !== $post['repassword']) {
             $this->error('两次输入的密码不一致！');
          }

        $data = ['id' => $post['id'], 'password' => md5($post['password'])];
        if ($this->save($this->table, $data, 'id')) {
            $this->success('密码修改成功，下次请使用新密码登录！');
        }
        $this->error('密码修改失败，请稍候再试！');
    }

    /**
     * 表单数据默认处理
     * @param array $data
     */
    public function _form_filter(&$data)
    {
       
      
         if ($this->isPost) {

            if (isset($data['authorize']) && is_array($data['authorize'])) {
                $data['authorize'] = join(',', $data['authorize']);
            }
            if (isset($data['id'])) {
                unset($data['username']);
            } elseif (db($this->table)->where(['sid'=>sid(),'username' =>$data['username']])->count()) {
                $this->error('用户账号已经存在，请使用其它账号！','');
            }
         } else {

            $data['authorize'] = explode(',', isset($data['authorize']) ? $data['authorize'] : '');
            $this->assign('auth', db('system_auth')->where(['status' => '1'])->select());
            
          }
    }
       /**
     * 授权管理
     * @return array|string
     */
    public function auth()
    {

        
      
        return $this->_form($this->table,'auth');
    }


    /**
     * 删除用户
     */
    public function del()
    {

       

        if ($this->update($this->table)) {
            $this->success("用户删除成功！", '');
         }
        $this->error("用户删除失败，请稍候再试！");
    }

    /**
     * 用户禁用
     */
    public function forbid()
    {
        
        
        
        if ($this->update($this->table)) {
            $this->success("用户禁用成功！", '');
        }
        $this->error("用户禁用失败，请稍候再试！");
    }

    /**
     * 用户启用
     */
    public function resume()
    {
      if ($this->update($this->table)) {
            $this->success("用户启用成功！", '');
         }
        $this->error("用户启用失败，请稍候再试！");

    }


	
}




 ?>