<?php 
namespace app\admin\web;
require_once root('extend/aop/AopClient.php');
require_once root('extend/aop/request/AlipayFundTransToaccountTransferRequest.php');
use cjzy\Admin;
use service\NodeService;
use pay\WechatPay;
use aop\AopClient;
use aop\request\AlipayFundTransToaccountTransferRequest;

class txmoney extends Admin
{
	public $table="tixian";

	function index(){
        $this->title="提现列表";
        $get=input('get.');
        $w=array('sid'=>sid());
       
        if (isset($get['status']) && $get['status']!='') {
            $w['status']=$get['status']-1;
        }
        if (isset($get['date']) && $get['date'] !== '') {

            list($start, $end) = explode('-',$get['date']);
            $start=strtotime($start .' 00:00:00');
            $end=strtotime($end .' 23:59:59');
            $w['time >=']=$start;
            $w['time <=']=$end;
        }



        $this->money=0;
        $this->sxf=0;
        $where=$w;
        $where['status !=']=3;
        $orders=db($this->table)->where($where)->field('sxf,money')->select();//pdo_getall(,$where,array('sxf','money'));
        foreach ($orders as $k => $v) {
        	$this->money+=$v['money'];
        	$this->sxf+=$v['sxf'];
        }
        
        $db=db($this->table)->where($w)->order('id','DESC');

        return $this->_list($db);
	}

	protected function _index_data_filter(&$data){
		
        foreach ($data as &$vo) {
            $vo['user']=db('user')->where(['id'=>$vo['uid']])->field('headimgurl,nickname')->find();
        }
    }



	function see(){

	    return $this->_form($this->table,'info');
    }
    
    protected function _see_form_filter(&$vo){
	    if($vo['uid']!=0){
	    	$vo['user']=db('user')->where(['id'=>$vo['uid']])->field('headimgurl,nickname')->find();
	    }
    }

    function chuli(){

		$id=$_GET['id'];
	    $tx = db($this->table)->where(array('id' => $id,'sid'=>sid()))->find();
        $config=config();

        if($tx['txtype']==1){
            //提款
            $res=['openid'=>$tx['openid'],'money'=>$tx['money'],'sn'=>$tx['sn'],'remark'=>'资金提现'];
            $config['ssl_cret']=IA_ROOT.$config['ssl_cret'];
            $config['ssl_key']=IA_ROOT.$config['ssl_key'];
            $pc=new WechatPay($config);
            
            $pay= $pc->transfers($res['openid'],$res['money'],$res['sn'],$res['remark']);
            //p($ay);die;
        }else{
		    $res=[
		        "sn"=>$tx['sn'],
			    "zfb"=>$tx['zfb'],
			    "money"=>$tx['money']/100,
			    "body"=>'资金提现',
			    "name"=>$tx['name'],
			    "remark"=>'资金提现'
		    ];
		    $aop = new AopClient ();
            $aop->gatewayUrl = 'https://openapi.alipay.com/gateway.do';
            $aop->appId = $config['zfb_appid'];
            $aop->rsaPrivateKey =$config['zfb_private'];
            $aop->alipayrsaPublicKey=$config['zfb_public'];
            $aop->apiVersion = '1.0';
            $aop->signType = 'RSA2';
            $aop->postCharset='utf-8';
            $aop->format='json';
            $request = new AlipayFundTransToaccountTransferRequest ();
            $arr=[
                "out_biz_no"=>$res['sn'],
                "payee_type"=>"ALIPAY_LOGONID",
                "payee_account"=>$res['zfb'],
                "amount"=>$res['money'],
                "payer_show_name"=>$res['body'],
                "payee_real_name"=>$res['name'],
                "remark"=>$res['remark']
            ];
           
            $request->setBizContent(json_encode($arr));
            $result = $aop->execute ($request); 
            $msg=json_decode(json_encode($result->alipay_fund_trans_toaccount_transfer_response),true);
            if($msg['code']=='10000'){
                  $pay=1;
            }
            if($msg['sub_code']=='PAYEE_NOT_EXIST'||$msg['sub_code']=='PAYEE_USER_INFO_ERROR'){
                   $pay=0;
            }
      
            $pay=$this->zfbs($res,$config);
        }
       
        if($pay){
            db($this->table)->where(['id'=>$id])->update(['status'=>1,'paytime'=>time()]);
	        NodeService::log('用户操作','处理提现申请');
	        $this->success('处理成功');
        }else{
      		$this->error('提现失败,请检查配置信息与账户余额');
        }
	    
    }


    function bohui(){

        $id=input('get.id');
        $item=db($this->table)->where(['id'=>$id])->find();
        $m=$item['money']/100;
        $m1=$item['sxf']/100;
        $credit2=$m+$m1;

        user_up($item['uid'],"credit2",$credit2,"提现驳回");
        db($this->table)->where(['id'=>$id])->update(['status'=>2,'paytime'=>time()]);
        
        NodeService::log('用户操作',"驳回用户ID:{$id}，提现请求");
        
        $this->success('处理成功');



    }

    public function zfbs($res,$config){


          $aop = new AopClient ();
          $aop->gatewayUrl = 'https://openapi.alipay.com/gateway.do';
          $aop->appId = $config['zfb_appid'];
          $aop->rsaPrivateKey =$config['zfb_private'];
          $aop->alipayrsaPublicKey=$config['zfb_public'];
          $aop->apiVersion = '1.0';
          $aop->signType = 'RSA2';
          $aop->postCharset='utf-8';
          $aop->format='json';
          $request = new AlipayFundTransToaccountTransferRequest ();
          $arr=[
            "out_biz_no"=>$res['sn'],
            "payee_type"=>"ALIPAY_LOGONID",
            "payee_account"=>$res['zfb'],
            "amount"=>$res['money'],
            "payer_show_name"=>$res['body'],
            "payee_real_name"=>$res['name'],
            "remark"=>$res['remark']
          ];
          $request->setBizContent(json_encode($arr));
          $result = $aop->execute ($request); 
         $msg=json_decode(json_encode($result->alipay_fund_trans_toaccount_transfer_response),true);



         if($msg['code']=='10000'){
              return 1;
          }


        if($msg['sub_code']=='PAYEE_NOT_EXIST'||$msg['sub_code']=='PAYEE_USER_INFO_ERROR'){
              return 0;
        }
        
        return 2;
    }


    function rengong(){

        if ($this->update($this->table)) {

            $id=input('post.id');

            db($this->table)->where('id',$id)->update(['paytime'=>time()]);
            

            $this->success("成功！", '');
        }
      
       $this->error("失败，请稍候再试！");


    }


}


?>