<?php 
namespace app\mobile\user;

use cjzy\Mobile;
use app\mobile\common\Common;
use service\AlismsService;
/**
* 
*/
class Agent extends Common
{
	
  	public 	function index(){

        $uid=$this->user['id'];

        $sid=sid();

  		
        if (!$this->isAjax) {

            $user=user($uid);

            if ($user['agent']==0) {

                return $this->fetch('userapply',['user'=>$user]);   

            }
 
            $users=db('user')->where('sid',$sid)->order('id','DESC')->field('nickname')->paginate(50);
            
            foreach ($users as $k => $v) {
                $users[$k]['nickname']=$v['nickname'].'刚刚加入了'; 
            }
            return $this->fetch('',['user'=>$user,'users'=>json_encode($users,true)]);

        }


        $day=mktime(0,0,0,date('m'),date('d'),date('Y'));

        $jin_ren=db('user')->where(['sid'=>$sid,'agent_id'=>$uid,'time >='=>$day])->count();

        $ren=db('user')->where(['sid'=>$sid,'agent_id'=>$uid])->count();

        $sucai=db('article')->where('sid',$sid)->count();
 
        if ($sucai>=100000) {
            $sucai='10万';
        }

        return $this->json(['data'=>['jin'=>$jin_ren,'ren'=>$ren,'sucai'=>$sucai]]);
	    
	}

    /**
     * 添加代理申请订单
     * [add description]
     */
    public function add(){

        if ($this->isAjax) {
            
            $data=array(

                    'sn'=>rand(100,999).time().random(5,true),
                    'price'=>config('daili_config_price')*100,
                    'uid'=>$this->user['id'],
                    'sid'=>sid(),

                );
            db('user_agent_order')->insert($data);
            $this->success('成功',['sn'=>$data['sn'],'price'=>config('daili_config_price')]);
        }


    }

    /**
     * 下级订单
     * @return [type] [description]
     */
    public function order(){

        $uid=$this->user['id'];

        if (!$this->isAjax) {
            

            return $this->fetch();
        }

        $order=db('order')->where(['sid'=>sid(),'agent_id'=>$uid])->order('id','DESC')->paginate(10);

        foreach ($order as &$v) {
            
            $v['user']=db('user')->where('id',$v['uid'])->field('headimgurl,nickname')->find();
            $v['title']=db('vip')->where('id',$v['vid'])->field('title')->find();
            $v['vip']=vip($v['uid']);
            $v['money']=$v['fee']/100;
            if($v['status']==1){

                $v['jiang']=$v['agent_money'];
                $v['status']="<span style='color:#39a0ff'> 已付款 </span>";
                $v['time']="<span style='color:#39a0ff'> ".date("Y年m月d日 H:i",$v['paytime'])." </span>";

            }else{

                $v['jiang']=0;
                $v['status']="<span style='color:#ea413c'> 未付款 </span>";
                $v['time']="<span style='color:#ea413c'> 未付款 </span>";

            }

            
            
        }

        $this->json(['data'=>$order]);
    }

    /**
     * 推广金钱
     * @return [type] [description]
     */
    public function task(){

        if (!$this->isAjax) {
            

            return $this->fetch();
        }

        $list=db('order')->where(['agent_id'=>$this->user['id'],'status'=>1,'agent_money !='=>'0.00'])->order('id','DESC')->paginate(10);

        foreach ($list as $k => $v) {
             
            $list[$k]['status']=1;

            $list[$k]['time']=date('Y-m-d H:i',$v['addtime']);

        }

        return $this->json(['data'=>$list]);


    }

    /**
     * 
     * 总人数
     * @return [type] [description]
     */
    public function ren(){

        if (!$this->isAjax) {
            

            return $this->fetch();
        }

        $user=db('user')->where(['agent_id'=>$this->user['id']])->order('id','DESC')->paginate(10);

        foreach ($user as $k => &$v) {
            
            $v['times']=time_shijian($v['time']);
            $v['vips']=vip($v['id']);
        }

       

        $this->json(['data'=>$user]);
             

    }

    /**
     * 今日新增
     * @return [type] [description]
     */
    public function jin(){

        if (!$this->isAjax) {
            

            return $this->fetch();
        }
        $day=mktime(0,0,0,date('m'),date('d'),date('Y'));

        $user=db('user')->where(['agent_id'=>$this->user['id'],'time >='=>$day])->order('id','DESC')->paginate(10);

        foreach ($user as $k => &$v) {
            
            $v['times']=time_shijian($v['time']);
            $v['vips']=vip($v['id']);
        }

        $this->json(['data'=>$user]);
            


    }
}


?>