<?php 

namespace store;

/**
* 
*/
class Datetime 
{
	
    /**
     * 获取当前七天
     * @return [type] [description]
    */
	public static function seven($time = '', $format='Y-m-d'){

          $time = $time != '' ? $time : time();
		  
		  $date = [];
		  for ($i=0; $i<7; $i++){
		    $date[$i] = date($format ,strtotime( '+' . $i .' days', $time));
		  }
		  return $date;

	}


   /**
     * 获取当前开始7天的星期
     * @return [type] [description]
    */
	public static function week($time = ''){

          $weekarray=array("日","一","二","三","四","五","六");
          $time = $time != '' ? $time : time();
		  
		  $date = [];
		  for ($i=0; $i<7; $i++){

		    $date[$i] =$weekarray[date("w",strtotime( '+' . $i .' days', $time))]; 
		  }
		  return $date;

	}


	/**
	 * yuetime
	 * 预约时间表
	 */
   
   public static function yue($m=9){
      
      $time=time();
      $weekarray=array("日","一","二","三","四","五","六");
      $name=['今天','明天','后天'];
      $date = [];
      for ($i=0; $i<$m; $i++){
		    $date[$i]['time'] = date('m/d' ,strtotime( '+' . $i .' days', $time));
		    $date[$i]['times'] = date('Y/m/d' ,strtotime( '+' . $i .' days', $time));
		    if($i<3){
                $date[$i]['week'] =$name[$i]; 
		    }else{
		    	$date[$i]['week'] ="周".$weekarray[date("w",strtotime( '+' . $i .' days', $time))]; 
		    }
		    
		  }
	  return $date;


   }

/**
 * staff id  员工id
 * 今年的 月 日
 * $tm  年月日
 */
  
  public static function table($staff,$tm=''){

  	        $yytq=store('yytq'); //提前预约几个小时
            $yysd=store('yysd'); //时间间隔
            $yytime=store('yytime');  //起止时间

            $gq=time()+$yytq*3600;  //提前预约时间戳  要大于当前时间才可以约

            //年月日
            $nyr=empty($tm)?date('Y-m-d',time()):$tm; //那一天的年月日

            list($start,$end)=explode('-',$yytime);  //拆分出 时间开始结束

            $start=strtotime($nyr." ".$start); //开始时间戳
            $end=strtotime($nyr." ".$end);     //结束时间戳

            $noon=strtotime($nyr." "."12:00"); //中午时间戳
            $afternoon=strtotime($nyr." "."18:00");//下午时间戳
            $night=strtotime($nyr." "."23:59"); //晚上时间戳

            $i=$start;
            $data=[];//noon afternoon night

            $yuyue=db('yue_order')->where(['staff'=>$staff,'sid'=>sid(),'did'=>did()])->whereBetween('yue', ["{$nyr} 00:00:00", "{$nyr} 23:59:59"])->field('yue,end')->select();

          
            while ($i<$end) {

            	$i=$i+$yysd*60;

            
                         
                   $status=self::compare($yuyue,$i);

                   $arr=['status'=>($i>$gq)?$status:2,'time'=>date('H:i',$i)];
		            	if($i<=$noon){

		                  $data['noon'][]=$arr;
		                 
		            	}elseif ($i<=$afternoon) {
		            		 $data['afternoon'][]=$arr;
		            		 
		            	}else{
		                 $data['night'][]=$arr;
		                     
		            	}
            
            	
            }

            return $data;



  }


  public static function compare($arr,$i){

      foreach ($arr as $key => $v) {

          if($i>=$v['yue']&&$i<=$v['end']){

              return 1;
          }
          
         
      }

      return 0;

  }




  



	
}