CREATE TABLE IF NOT EXISTS `ims_aide_actad` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) NOT NULL,
  `aid` bigint(20) NOT NULL,
  `openid` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_actcate` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `name` varchar(128) NOT NULL DEFAULT '',
  `icon` varchar(128) NOT NULL DEFAULT '',
  `sort` int(10) unsigned NOT NULL DEFAULT '0',
  `url` varchar(128) NOT NULL DEFAULT '',
  `binding` tinyint(2) NOT NULL DEFAULT '1',
  `cai` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_actmsg` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `aid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `sid` int(10) unsigned NOT NULL DEFAULT '0',
  `tuid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `fuid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `content` varchar(1000) NOT NULL DEFAULT '',
  `time` int(10) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `zan` int(10) NOT NULL DEFAULT '0',
  `reply` varchar(1000) NOT NULL DEFAULT '',
  `rtime` int(10) NOT NULL DEFAULT '0',
  `rzan` int(10) NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_actmsg_zan` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `mid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `openid` varchar(128) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_actzan` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `aid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `openid` varchar(128) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_ad` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `uid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(2) NOT NULL DEFAULT '1',
  `img` varchar(256) NOT NULL DEFAULT '',
  `title` varchar(128) NOT NULL DEFAULT '',
  `depict` varchar(256) NOT NULL DEFAULT '',
  `url` varchar(256) NOT NULL DEFAULT '',
  `ewm` varchar(256) NOT NULL DEFAULT '',
  `phone` char(11) NOT NULL DEFAULT '',
  `company` varchar(64) NOT NULL DEFAULT '',
  `job` varchar(32) NOT NULL DEFAULT '',
  `name` varchar(32) NOT NULL DEFAULT '',
  `qq` varchar(18) NOT NULL DEFAULT '',
  `weixin` varchar(32) NOT NULL DEFAULT '',
  `ons` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_adchong` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sid` int(10) unsigned NOT NULL,
  `name` varchar(64) NOT NULL,
  `price` int(10) unsigned NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1.时常、2次数',
  `num` int(11) NOT NULL,
  `unit` tinyint(1) NOT NULL,
  `addtime` int(10) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_adchong_order` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` int(10) unsigned NOT NULL,
  `uid` bigint(20) unsigned NOT NULL,
  `price` int(11) NOT NULL,
  `cid` int(11) NOT NULL,
  `sn` varchar(32) NOT NULL DEFAULT '',
  `time` int(10) NOT NULL DEFAULT '0',
  `transaction_id` varchar(64) NOT NULL DEFAULT '',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `paytime` int(10) NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_adminad` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sid` int(11) NOT NULL,
  `img` varchar(256) NOT NULL DEFAULT '',
  `time` int(10) NOT NULL DEFAULT '0',
  `url` varchar(256) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_article` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `cid` bigint(20) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `abstract` varchar(500) NOT NULL DEFAULT '',
  `img` varchar(1000) NOT NULL DEFAULT '',
  `content` longtext NOT NULL,
  `eye` int(10) unsigned NOT NULL DEFAULT '0',
  `zan` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) NOT NULL DEFAULT '0',
  `author` varchar(32) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `share` int(10) unsigned NOT NULL DEFAULT '0',
  `ad` tinyint(1) NOT NULL DEFAULT '0',
  `adname` varchar(32) NOT NULL DEFAULT '',
  `adimg` varchar(256) NOT NULL DEFAULT '',
  `adphone` char(11) NOT NULL DEFAULT '',
  `kfewm` varchar(256) NOT NULL DEFAULT '',
  `top` tinyint(1) NOT NULL DEFAULT '0' COMMENT '设顶',
  `toptime` int(10) NOT NULL DEFAULT '0' COMMENT '到期时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_article_cai` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` int(11) NOT NULL DEFAULT '0',
  `cid` int(10) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1搜狗分类  2公众号',
  `url` varchar(500) NOT NULL DEFAULT '',
  `num` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `time` int(10) NOT NULL DEFAULT '0',
  `begin` varchar(64) NOT NULL DEFAULT '' COMMENT '开始时间',
  `title` varchar(256) DEFAULT '',
  `exetime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='采集计划';

CREATE TABLE IF NOT EXISTS `ims_aide_article_renwu` (
  `url` varchar(500) NOT NULL DEFAULT '',
  `title` varchar(256) NOT NULL DEFAULT '',
  `cid` bigint(20) NOT NULL DEFAULT '0',
  `sid` bigint(20) NOT NULL DEFAULT '0',
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='采集任务';

CREATE TABLE IF NOT EXISTS `ims_aide_article_zan` (
  `act_uid` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '作者',
  `aid` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '文章',
  `uid` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '点赞人',
  `time` int(10) NOT NULL DEFAULT '0' COMMENT '时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_baogao_tui` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) unsigned NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `begin` varchar(18) NOT NULL DEFAULT '',
  `name` varchar(64) NOT NULL DEFAULT '',
  `time` int(10) NOT NULL DEFAULT '0',
  `exetime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_config` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `name` varchar(128) NOT NULL DEFAULT '',
  `resume` varchar(255) NOT NULL DEFAULT '',
  `logo` varchar(256) NOT NULL DEFAULT '',
  `appid` varchar(64) NOT NULL DEFAULT '',
  `mch_id` varchar(32) NOT NULL DEFAULT '',
  `partnerkey` char(32) NOT NULL DEFAULT '',
  `ssl_key` varchar(128) NOT NULL DEFAULT '',
  `ssl_cret` varchar(128) NOT NULL DEFAULT '',
  `regmoney` int(10) unsigned NOT NULL DEFAULT '0',
  `regintegral` int(10) unsigned NOT NULL DEFAULT '0',
  `reggold` int(10) unsigned NOT NULL DEFAULT '0',
  `regonemoney` int(10) unsigned NOT NULL DEFAULT '0',
  `regoneintegral` int(10) unsigned NOT NULL DEFAULT '0',
  `regonegold` int(10) unsigned NOT NULL DEFAULT '0',
  `regtwomoney` int(10) unsigned NOT NULL DEFAULT '0',
  `regtwointegral` int(10) unsigned NOT NULL DEFAULT '0',
  `regtwogold` int(10) unsigned NOT NULL DEFAULT '0',
  `cost` smallint(5) unsigned NOT NULL DEFAULT '0',
  `lowest` smallint(6) NOT NULL DEFAULT '0',
  `txtype` tinyint(1) NOT NULL DEFAULT '1',
  `zfb_appid` varchar(64) NOT NULL DEFAULT '',
  `zfb_private` varchar(2000) NOT NULL DEFAULT '',
  `zfb_public` varchar(2000) NOT NULL DEFAULT '',
  `shenhe` tinyint(1) NOT NULL DEFAULT '1',
  `goldprice` int(11) NOT NULL DEFAULT '0',
  `minuse` int(11) NOT NULL DEFAULT '0',
  `eyegold` int(11) NOT NULL DEFAULT '0',
  `goldtomoney` int(11) NOT NULL DEFAULT '0',
  `mingold` int(11) NOT NULL DEFAULT '0',
  `open_appid` varchar(64) NOT NULL DEFAULT '',
  `app_mchid` varchar(32) NOT NULL DEFAULT '',
  `app_partnerkey` char(32) NOT NULL DEFAULT '',
  `app_ssl_key` varchar(128) NOT NULL DEFAULT '',
  `app_ssl_cret` varchar(128) NOT NULL DEFAULT '',
  `pc_name` varchar(32) NOT NULL DEFAULT '',
  `pc_code` varchar(128) NOT NULL DEFAULT '',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `sort` int(11) NOT NULL DEFAULT '0',
  `sms_appkey` varchar(64) NOT NULL DEFAULT '',
  `sms_appsecret` varchar(64) NOT NULL DEFAULT '',
  `sms_name` varchar(64) NOT NULL DEFAULT '',
  `sms_tmp` varchar(64) NOT NULL DEFAULT '',
  `kftel` varchar(32) NOT NULL DEFAULT '' COMMENT '客服电话',
  `msgid` varchar(128) NOT NULL DEFAULT '',
  `kehumsgid` varchar(64) NOT NULL DEFAULT '',
  `choicemsgid` varchar(64) NOT NULL DEFAULT '',
  `protocol` longtext NOT NULL COMMENT '协议',
  `jieshao` longtext NOT NULL,
  `app_token` varchar(255) NOT NULL DEFAULT '',
  `app_key` varchar(255) NOT NULL DEFAULT '',
  `dev_key` varchar(128) NOT NULL DEFAULT '',
  `dev_secret` varchar(128) NOT NULL DEFAULT '',
  `push_key` varchar(128) NOT NULL DEFAULT '',
  `push_secret` varchar(128) NOT NULL DEFAULT '',
  `rules` longtext NOT NULL COMMENT '推广规则',
  `qslogo` varchar(255) NOT NULL DEFAULT '',
  `qsname` varchar(64) NOT NULL DEFAULT '',
  `qsid` varchar(128) NOT NULL DEFAULT '',
  `open_appsecret` varchar(128) NOT NULL,
  `gongsi` varchar(128) NOT NULL DEFAULT '',
  `ios` varchar(255) NOT NULL DEFAULT '',
  `android` varchar(255) NOT NULL DEFAULT '',
  `iosversion` varchar(128) NOT NULL DEFAULT '',
  `bundleid` varchar(64) NOT NULL DEFAULT '',
  `ipa` varchar(256) NOT NULL DEFAULT '',
  `force_gz` tinyint(1) NOT NULL DEFAULT '2' COMMENT '关注     2',
  `force_uinfo` tinyint(1) NOT NULL DEFAULT '2' COMMENT '2信息必填',
  `readtime` int(11) NOT NULL DEFAULT '1',
  `nums` int(11) NOT NULL,
  `signonemoney` int(11) NOT NULL DEFAULT '0' COMMENT '一等奖金钱',
  `signoneintegral` int(11) NOT NULL DEFAULT '0' COMMENT '积分',
  `signonegold` int(11) NOT NULL DEFAULT '0' COMMENT '金币',
  `signtowmoney` int(11) NOT NULL DEFAULT '0' COMMENT '二等奖金钱',
  `signtowintegral` int(11) NOT NULL DEFAULT '0' COMMENT '积分',
  `signtowgold` int(11) NOT NULL DEFAULT '0' COMMENT '金币',
  `signthreemoney` int(11) NOT NULL DEFAULT '0' COMMENT '三等奖金钱',
  `signthreeintegral` int(11) NOT NULL DEFAULT '0' COMMENT '积分',
  `signthreegold` int(11) NOT NULL DEFAULT '0' COMMENT '金币',
  `renwu` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_eye` (
  `openid` varchar(128) NOT NULL DEFAULT '',
  `aid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_feedback` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `uid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `phone` varchar(32) NOT NULL DEFAULT '',
  `time` int(10) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `content` varchar(500) NOT NULL DEFAULT '',
  `hui` varchar(256) NOT NULL DEFAULT '',
  `hui_time` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_gold_order` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` int(10) unsigned NOT NULL DEFAULT '0',
  `uid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `sn` varchar(32) NOT NULL DEFAULT '',
  `money` int(10) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `transaction_id` varchar(128) NOT NULL DEFAULT '',
  `addtime` int(10) NOT NULL DEFAULT '0',
  `paytime` int(10) NOT NULL DEFAULT '0',
  `app` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_guide` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` int(10) unsigned NOT NULL DEFAULT '0',
  `aid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `sort` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='只能推送';

CREATE TABLE IF NOT EXISTS `ims_aide_help` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `cid` bigint(20) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `abstract` varchar(500) NOT NULL DEFAULT '',
  `img` varchar(1000) NOT NULL DEFAULT '',
  `content` longtext NOT NULL,
  `eye` int(10) unsigned NOT NULL DEFAULT '0',
  `zan` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) NOT NULL DEFAULT '0',
  `author` varchar(32) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `share` int(10) unsigned NOT NULL DEFAULT '0',
  `ad` tinyint(1) NOT NULL DEFAULT '0',
  `adname` varchar(32) NOT NULL DEFAULT '',
  `adimg` varchar(256) NOT NULL DEFAULT '',
  `adphone` char(11) NOT NULL DEFAULT '',
  `kfewm` varchar(256) NOT NULL DEFAULT '',
  `top` tinyint(1) NOT NULL DEFAULT '0' COMMENT '设顶',
  `toptime` int(10) NOT NULL DEFAULT '0' COMMENT '到期时间',
  `guide` tinyint(1) NOT NULL DEFAULT '0',
  `sort` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_help_cate` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) unsigned NOT NULL,
  `image` varchar(512) NOT NULL DEFAULT '',
  `name` varchar(64) NOT NULL DEFAULT '',
  `time` int(10) NOT NULL DEFAULT '0',
  `url` varchar(1024) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `ims_aide_indexad` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sid` int(10) unsigned NOT NULL,
  `time` int(10) NOT NULL DEFAULT '0',
  `img` varchar(216) NOT NULL DEFAULT '',
  `url` varchar(512) NOT NULL DEFAULT '',
  `image` varchar(216) NOT NULL DEFAULT '',
  `type` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_index_card` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) unsigned NOT NULL,
  `time` int(10) NOT NULL DEFAULT '0',
  `url` varchar(255) NOT NULL DEFAULT '',
  `img` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_industry` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `name` varchar(64) NOT NULL DEFAULT '',
  `sort` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_kefuact` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) unsigned NOT NULL,
  `title` varchar(108) NOT NULL DEFAULT '',
  `img` varchar(216) NOT NULL DEFAULT '',
  `abstract` varchar(300) NOT NULL DEFAULT '',
  `content` longtext NOT NULL,
  `eye` int(11) NOT NULL DEFAULT '0',
  `time` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_km` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `phone` char(11) NOT NULL DEFAULT '',
  `pwd` char(32) NOT NULL DEFAULT '',
  `vip` tinyint(1) NOT NULL DEFAULT '0',
  `viptime` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `cid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_message` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `fuid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `tuid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `name` varchar(32) NOT NULL DEFAULT '',
  `phone` char(11) NOT NULL DEFAULT '',
  `time` int(10) NOT NULL DEFAULT '0',
  `content` varchar(500) NOT NULL DEFAULT '',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_moban` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) unsigned NOT NULL,
  `first` varchar(128) NOT NULL DEFAULT '',
  `first_color` varchar(16) NOT NULL DEFAULT '#ff510',
  `url` varchar(216) NOT NULL DEFAULT '',
  `keyword2` varchar(128) NOT NULL DEFAULT '',
  `keyword2_color` varchar(16) NOT NULL DEFAULT '#ff510',
  `keyword3` varchar(128) NOT NULL,
  `keyword3_color` varchar(16) NOT NULL DEFAULT '#ff510',
  `keyword1` varchar(128) NOT NULL DEFAULT '',
  `keyword1_color` varchar(16) NOT NULL DEFAULT '#ff510',
  `remark` varchar(128) NOT NULL DEFAULT '',
  `remark_color` varchar(16) NOT NULL DEFAULT '#ff510',
  `add_time` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_order` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `uid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `transaction_id` varchar(128) NOT NULL DEFAULT '',
  `vid` bigint(20) NOT NULL DEFAULT '0',
  `addtime` int(10) NOT NULL DEFAULT '0',
  `paytime` int(10) NOT NULL DEFAULT '0',
  `sn` varchar(32) NOT NULL DEFAULT '',
  `fee` int(10) NOT NULL DEFAULT '0',
  `app` tinyint(1) NOT NULL DEFAULT '0',
  `num` smallint(5) NOT NULL,
  `unit` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `sn` (`sn`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_procate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sid` int(11) NOT NULL DEFAULT '0',
  `name` varchar(12) NOT NULL DEFAULT '',
  `sort` int(11) NOT NULL DEFAULT '0',
  `icon` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='项目分类';

CREATE TABLE IF NOT EXISTS `ims_aide_remen` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sid` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1文章2视频',
  `begin` varchar(128) NOT NULL DEFAULT '' COMMENT '开始时间',
  `time` int(10) NOT NULL DEFAULT '0',
  `header` varchar(64) NOT NULL DEFAULT '',
  `footer` varchar(128) NOT NULL DEFAULT '',
  `token` char(32) NOT NULL DEFAULT '' COMMENT 'token',
  `content` longtext NOT NULL COMMENT '推送内容',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='热门推送';

CREATE TABLE IF NOT EXISTS `ims_aide_remen_act` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1热文 2视频',
  `content` longtext NOT NULL,
  `time` int(10) NOT NULL DEFAULT '0',
  `sid` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='推送热文';

CREATE TABLE IF NOT EXISTS `ims_aide_renwu` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` int(10) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1 热门推送 2每日报告生成3每周',
  `time` int(10) NOT NULL DEFAULT '0',
  `zid` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='任务执行记录';

CREATE TABLE IF NOT EXISTS `ims_aide_reward` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `uid` bigint(20) unsigned DEFAULT '0',
  `aid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `total` int(10) NOT NULL DEFAULT '0',
  `consume` int(10) NOT NULL DEFAULT '0',
  `time` int(10) NOT NULL DEFAULT '0',
  `ren` int(11) NOT NULL DEFAULT '0',
  `surplus` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `eye` int(10) unsigned NOT NULL DEFAULT '0',
  `eye_type` tinyint(1) NOT NULL DEFAULT '1',
  `jin` int(11) NOT NULL,
  `top` tinyint(1) NOT NULL DEFAULT '0' COMMENT '置顶',
  `toptime` int(10) NOT NULL DEFAULT '0',
  `toptype` tinyint(1) NOT NULL DEFAULT '1',
  `cid` int(11) NOT NULL COMMENT '文章分类id',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_share` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) unsigned NOT NULL,
  `tuid` bigint(20) unsigned NOT NULL,
  `time` int(10) NOT NULL DEFAULT '0',
  `aid` bigint(20) unsigned NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1.文章2.黑马爆文.3.项目',
  `img` varchar(256) NOT NULL DEFAULT '',
  `title` varchar(256) NOT NULL DEFAULT '',
  `sid` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='访客分享统计表';

CREATE TABLE IF NOT EXISTS `ims_aide_shop` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) unsigned NOT NULL,
  `img` varchar(264) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `title` varchar(264) NOT NULL,
  `abstract` varchar(264) NOT NULL DEFAULT '',
  `price` int(11) NOT NULL,
  `stock` int(11) NOT NULL COMMENT '库存',
  `gouintegral` int(11) NOT NULL COMMENT '积分',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '推荐1/置顶2/不显示0',
  `endtime` int(11) NOT NULL COMMENT '0不限',
  `cid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `time` int(10) NOT NULL DEFAULT '0',
  `songintegral` int(11) NOT NULL,
  `numstick` int(11) NOT NULL DEFAULT '0',
  `numtui` int(11) NOT NULL DEFAULT '0',
  `sales` int(11) NOT NULL DEFAULT '0' COMMENT '销量',
  `shiwu` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1实物0bushi',
  `image` text NOT NULL,
  `tui_time` int(10) NOT NULL DEFAULT '0',
  `tui` tinyint(1) NOT NULL DEFAULT '0',
  `eye` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_shopad` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) unsigned NOT NULL,
  `image` varchar(512) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(512) NOT NULL DEFAULT '',
  `time` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_shop_card` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) unsigned NOT NULL,
  `title` varchar(64) NOT NULL DEFAULT '',
  `time` int(10) NOT NULL DEFAULT '0',
  `image` varchar(512) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_shop_order` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) unsigned NOT NULL,
  `uid` bigint(20) unsigned NOT NULL,
  `gid` bigint(20) unsigned NOT NULL,
  `sn` varchar(32) NOT NULL DEFAULT '',
  `price` int(11) NOT NULL,
  `addtime` int(10) NOT NULL DEFAULT '0',
  `paytime` int(10) NOT NULL DEFAULT '0',
  `transaction_id` varchar(64) NOT NULL DEFAULT '',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `img` varchar(256) NOT NULL DEFAULT '',
  `goodtitle` varchar(64) NOT NULL DEFAULT '',
  `num` int(11) NOT NULL,
  `jifen` int(11) NOT NULL,
  `jifenfan` int(11) NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(32) NOT NULL DEFAULT '',
  `phone` char(11) NOT NULL DEFAULT '',
  `shiwu` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1实物0bushi',
  `address` varchar(512) NOT NULL DEFAULT '',
  `zhifu` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1微信支付2余额',
  `fahuo_time` int(10) NOT NULL DEFAULT '0',
  `danhao` varchar(256) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_shop_trace` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) unsigned NOT NULL,
  `sid` bigint(20) unsigned NOT NULL,
  `title` varchar(512) NOT NULL DEFAULT '',
  `img` varchar(512) NOT NULL DEFAULT '',
  `addtime` int(10) NOT NULL DEFAULT '0',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `gid` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `ims_aide_system_article` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `abstract` varchar(500) NOT NULL DEFAULT '',
  `img` varchar(1024) NOT NULL DEFAULT '',
  `content` longtext NOT NULL,
  `eye` int(10) unsigned NOT NULL DEFAULT '0',
  `share` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) NOT NULL DEFAULT '0',
  `author` varchar(32) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `type` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_system_auth` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `hid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `title` varchar(20) NOT NULL COMMENT '权限名称',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态(1:禁用,2:启用)',
  `sort` smallint(6) unsigned DEFAULT '0' COMMENT '排序权重',
  `desc` varchar(255) DEFAULT NULL COMMENT '备注说明',
  `create_by` bigint(11) unsigned DEFAULT '0' COMMENT '创建人',
  `create_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `hid` (`hid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='系统权限表';

CREATE TABLE IF NOT EXISTS `ims_aide_system_auth_node` (
  `auth` bigint(20) unsigned DEFAULT NULL COMMENT '角色ID',
  `node` varchar(200) DEFAULT NULL COMMENT '节点路径',
  KEY `index_ism_aide_system_auth_auth` (`auth`) USING BTREE,
  KEY `index_ism_aide_system_auth_node` (`node`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='角色与节点关系表';

CREATE TABLE IF NOT EXISTS `ims_aide_system_config` (
  `sid` int(10) unsigned NOT NULL,
  `name` longtext NOT NULL,
  `value` longtext NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='基本配置表';

CREATE TABLE IF NOT EXISTS `ims_aide_system_cop` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content` varchar(128) NOT NULL DEFAULT '',
  `time` int(10) NOT NULL DEFAULT '0',
  `sid` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_system_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '总用户id',
  `uid` bigint(20) NOT NULL DEFAULT '0' COMMENT '用户id',
  `ip` char(15) NOT NULL DEFAULT '' COMMENT '操作者IP地址',
  `node` char(200) NOT NULL DEFAULT '' COMMENT '当前操作节点',
  `username` varchar(32) NOT NULL DEFAULT '' COMMENT '操作人用户名',
  `action` varchar(200) NOT NULL DEFAULT '' COMMENT '操作行为',
  `content` text NOT NULL COMMENT '操作内容描述',
  `create_at` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `sid` (`sid`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='系统操作日志表';

CREATE TABLE IF NOT EXISTS `ims_aide_system_menu` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `pid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `title` varchar(100) NOT NULL DEFAULT '',
  `node` varchar(200) NOT NULL DEFAULT '',
  `icon` varchar(100) NOT NULL DEFAULT '',
  `url` varchar(400) NOT NULL DEFAULT '',
  `params` varchar(500) NOT NULL DEFAULT '',
  `target` varchar(20) NOT NULL DEFAULT '',
  `sort` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `create_by` bigint(20) unsigned NOT NULL DEFAULT '0',
  `create_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `colors` char(9) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_system_node` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `node` varchar(100) DEFAULT NULL COMMENT '节点代码',
  `title` varchar(500) DEFAULT NULL COMMENT '节点标题',
  `is_menu` tinyint(1) unsigned DEFAULT '0' COMMENT '是否可设置为菜单',
  `is_auth` tinyint(1) unsigned DEFAULT '1' COMMENT '是否启动RBAC权限控制',
  `is_login` tinyint(1) unsigned DEFAULT '1' COMMENT '是否启动登录控制',
  `create_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `index_ims_aide_system_node_node` (`node`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='系统节点表';

CREATE TABLE IF NOT EXISTS `ims_aide_system_poster` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sid` int(11) NOT NULL,
  `ewmtop` int(11) NOT NULL,
  `ewmleft` int(11) NOT NULL,
  `ewmwidth` int(11) NOT NULL,
  `img` varchar(500) NOT NULL DEFAULT '',
  `headimgwidth` int(11) NOT NULL,
  `headimgleft` int(11) NOT NULL,
  `headimgtop` int(11) NOT NULL,
  `headimgstatus` tinyint(1) NOT NULL DEFAULT '0',
  `add_time` int(10) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `title` varchar(128) NOT NULL DEFAULT '',
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `cid` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_system_user` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `pid` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '父级id',
  `username` varchar(50) NOT NULL DEFAULT '' COMMENT '用户登录名',
  `password` char(32) NOT NULL DEFAULT '' COMMENT '用户登录密码',
  `qq` varchar(16) DEFAULT '' COMMENT '联系QQ',
  `mail` varchar(32) DEFAULT '' COMMENT '联系邮箱',
  `phone` varchar(16) DEFAULT '' COMMENT '联系手机号',
  `remark` varchar(255) DEFAULT '' COMMENT '备注说明',
  `login_num` bigint(20) unsigned DEFAULT '0' COMMENT '登录次数',
  `login_at` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态(0:禁用,1:启用)',
  `authorize` varchar(255) DEFAULT '',
  `is_deleted` tinyint(1) unsigned DEFAULT '0' COMMENT '删除状态(1:删除,0:未删)',
  `create_by` bigint(20) unsigned DEFAULT '0' COMMENT '创建人',
  `create_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '超级管理员1 0否',
  `gid` int(10) unsigned NOT NULL DEFAULT '0',
  `sid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `root` tinyint(1) NOT NULL DEFAULT '0',
  `token` char(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `username` (`username`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='系统用户表';

CREATE TABLE IF NOT EXISTS `ims_aide_tasklst` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(32) NOT NULL DEFAULT '',
  `abstract` varchar(64) NOT NULL DEFAULT '',
  `industry` int(11) NOT NULL DEFAULT '0',
  `num` tinyint(4) NOT NULL DEFAULT '0',
  `sid` int(11) NOT NULL DEFAULT '0',
  `time` int(10) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `img` varchar(256) NOT NULL DEFAULT '',
  `cid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_tasklst_renwu` (
  `uid` bigint(20) unsigned NOT NULL,
  `openid` varchar(64) NOT NULL DEFAULT '',
  `headimgurl` varchar(256) NOT NULL DEFAULT '',
  `cid` int(11) NOT NULL COMMENT '0签到，1发布文章，2推广，3文章评论',
  `time` int(11) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_tixian` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `uid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `txtype` tinyint(1) NOT NULL DEFAULT '1',
  `headimgurl` varchar(256) NOT NULL DEFAULT '',
  `nickname` varchar(64) NOT NULL DEFAULT '',
  `openid` varchar(128) NOT NULL DEFAULT '',
  `name` varchar(16) NOT NULL DEFAULT '',
  `zfb` varchar(32) NOT NULL DEFAULT '',
  `money` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `paytime` int(10) NOT NULL DEFAULT '0',
  `sn` char(32) NOT NULL DEFAULT '',
  `sxf` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_tuima` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sid` int(11) NOT NULL,
  `ma` varchar(32) NOT NULL,
  `time` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_user` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `openid` varchar(64) NOT NULL DEFAULT '',
  `unionid` varchar(64) NOT NULL DEFAULT '',
  `nickname` varchar(32) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  `headimgurl` varchar(256) NOT NULL DEFAULT '',
  `subscribe` tinyint(1) NOT NULL DEFAULT '1',
  `sex` tinyint(1) NOT NULL DEFAULT '1',
  `one` bigint(20) unsigned NOT NULL DEFAULT '0',
  `name` varchar(8) NOT NULL DEFAULT '',
  `province` varchar(64) NOT NULL DEFAULT '',
  `city` varchar(64) NOT NULL DEFAULT '',
  `district` varchar(64) NOT NULL DEFAULT '',
  `industry` bigint(20) unsigned NOT NULL,
  `company` varchar(128) NOT NULL DEFAULT '',
  `job` varchar(128) NOT NULL DEFAULT '',
  `wxcode` varchar(256) NOT NULL DEFAULT '',
  `phone` char(11) NOT NULL DEFAULT '',
  `weixin` varchar(32) NOT NULL DEFAULT '',
  `qq` varchar(16) NOT NULL DEFAULT '',
  `motto` varchar(256) NOT NULL DEFAULT '',
  `time` int(10) NOT NULL DEFAULT '0',
  `lattime` int(10) NOT NULL DEFAULT '0',
  `sid` bigint(20) NOT NULL DEFAULT '0',
  `tgcode` varchar(128) NOT NULL DEFAULT '',
  `vip` tinyint(1) NOT NULL DEFAULT '0',
  `viptime` int(10) NOT NULL DEFAULT '0',
  `two` bigint(20) unsigned NOT NULL DEFAULT '0',
  `tmoney` int(10) NOT NULL DEFAULT '0',
  `tintegral` int(10) NOT NULL DEFAULT '0',
  `tgold` int(10) NOT NULL DEFAULT '0',
  `tone` int(10) NOT NULL DEFAULT '0',
  `ttwo` int(10) NOT NULL DEFAULT '0',
  `stencil` tinyint(2) NOT NULL DEFAULT '1',
  `tgewm` varchar(128) NOT NULL DEFAULT '',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `pwd` char(32) NOT NULL DEFAULT '',
  `account` char(11) NOT NULL DEFAULT '',
  `fk` int(11) NOT NULL DEFAULT '0',
  `rid` varchar(128) NOT NULL DEFAULT '' COMMENT 'app设备id',
  `credit1` int(11) NOT NULL COMMENT '积分',
  `credit2` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '金钱',
  `credit3` int(11) NOT NULL COMMENT '金币',
  `on` tinyint(1) NOT NULL DEFAULT '0',
  `tuser` varchar(256) NOT NULL DEFAULT '' COMMENT '事业海报二维码',
  `old_and_new` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'ui新1',
  `record_status` tinyint(1) NOT NULL DEFAULT '1',
  `recommend_act` tinyint(1) NOT NULL DEFAULT '1',
  `adtype` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1时间，2次数',
  `adendtime` int(10) NOT NULL DEFAULT '0',
  `adyiyong` int(11) NOT NULL DEFAULT '0',
  `adzong` int(11) NOT NULL DEFAULT '0',
  `recommend` int(11) NOT NULL DEFAULT '0' COMMENT '推荐卡',
  `recommendzong` int(11) NOT NULL DEFAULT '0',
  `stick` int(11) NOT NULL DEFAULT '0' COMMENT '置顶',
  `stickzong` int(11) NOT NULL DEFAULT '0',
  `singday` int(10) NOT NULL DEFAULT '0' COMMENT '签到时间',
  `singdayci` int(11) NOT NULL DEFAULT '0' COMMENT '次数',
  `lottery` int(11) NOT NULL DEFAULT '0' COMMENT '抽奖次数',
  `actedit` int(11) NOT NULL DEFAULT '0' COMMENT '试用次数',
  `age` varchar(32) NOT NULL DEFAULT '',
  `wxapp` tinyint(1) NOT NULL DEFAULT '0',
  `token` char(32) NOT NULL DEFAULT '',
  `code` char(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_userpro` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` int(10) unsigned NOT NULL DEFAULT '0',
  `uid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `content` text CHARACTER SET utf8mb4 NOT NULL,
  `imgs` varchar(2000) NOT NULL DEFAULT '',
  `minprice` int(11) NOT NULL DEFAULT '0',
  `maxprice` int(11) NOT NULL DEFAULT '0',
  `cid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `eye` int(10) unsigned NOT NULL DEFAULT '0',
  `zan` int(10) unsigned NOT NULL DEFAULT '0',
  `time` int(10) NOT NULL DEFAULT '0',
  `on` tinyint(1) NOT NULL DEFAULT '0',
  `onid` bigint(20) NOT NULL DEFAULT '0',
  `top` tinyint(1) NOT NULL DEFAULT '0',
  `toptime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='用户项目';

CREATE TABLE IF NOT EXISTS `ims_aide_userpro_zan` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `pid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `uid` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_usersdao` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `headimgurl` varchar(256) CHARACTER SET utf8mb4 NOT NULL,
  `nickname` varchar(64) CHARACTER SET utf8mb4 NOT NULL,
  `phone` char(11) NOT NULL,
  `weixin` varchar(64) NOT NULL,
  `city` varchar(64) NOT NULL,
  `province` varchar(64) NOT NULL COMMENT '省份',
  `district` varchar(64) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_user_article` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) NOT NULL DEFAULT '0',
  `uid` bigint(20) NOT NULL DEFAULT '0',
  `title` varchar(128) NOT NULL DEFAULT '',
  `img` varchar(128) NOT NULL DEFAULT '',
  `abstract` varchar(255) NOT NULL DEFAULT '',
  `content` longtext NOT NULL,
  `eye` int(11) NOT NULL DEFAULT '0',
  `zan` int(11) NOT NULL DEFAULT '0',
  `time` int(10) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `addeye` int(10) unsigned NOT NULL DEFAULT '0',
  `addzan` int(10) unsigned NOT NULL DEFAULT '0',
  `adid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `gzh` varchar(64) NOT NULL DEFAULT '',
  `author` varchar(64) NOT NULL DEFAULT '',
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `url` varchar(500) NOT NULL DEFAULT '',
  `imgs` text NOT NULL,
  `ads` tinyint(1) NOT NULL DEFAULT '1',
  `cid` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_user_article_card` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `pid` bigint(20) unsigned NOT NULL,
  `title` varchar(32) NOT NULL DEFAULT '',
  `time` int(10) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `sid` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_user_article_complaint` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(20) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `aid` int(11) NOT NULL,
  `content` varchar(200) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `url` varchar(500) CHARACTER SET utf8 NOT NULL,
  `imgs` text CHARACTER SET utf8 NOT NULL,
  `tou` tinyint(2) NOT NULL DEFAULT '1',
  `uid` bigint(20) NOT NULL,
  `sid` int(11) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `add_time` int(10) NOT NULL DEFAULT '0',
  `end_time` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `ims_aide_user_chat` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) unsigned NOT NULL,
  `uid` bigint(20) unsigned NOT NULL,
  `tuid` bigint(20) unsigned NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `add_time` int(10) NOT NULL DEFAULT '0',
  `content` text NOT NULL,
  `img` varchar(512) NOT NULL DEFAULT '',
  `cid` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_user_chat_card` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) unsigned NOT NULL,
  `tuid` bigint(20) unsigned NOT NULL,
  `add_time` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_user_chong` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) unsigned NOT NULL,
  `uid` bigint(20) unsigned NOT NULL,
  `sn` char(32) NOT NULL DEFAULT '',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '没哟用',
  `fel` decimal(10,2) NOT NULL DEFAULT '0.00',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `time` int(10) NOT NULL DEFAULT '0',
  `paytime` int(10) NOT NULL DEFAULT '0',
  `transaction_id` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_user_follow` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) unsigned NOT NULL COMMENT '自己',
  `tuid` bigint(20) unsigned NOT NULL COMMENT '关注着',
  `time` int(10) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_user_huo` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) NOT NULL DEFAULT '0',
  `openid` varchar(64) NOT NULL DEFAULT '',
  `time` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_user_info` (
  `uid` bigint(20) NOT NULL,
  `name` varchar(64) NOT NULL DEFAULT '',
  `value` longtext NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `ims_aide_user_item` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` int(10) NOT NULL,
  `uid` bigint(20) unsigned NOT NULL,
  `name` varchar(50) NOT NULL,
  `money` int(11) NOT NULL,
  `content` text NOT NULL,
  `imgs` text NOT NULL,
  `abstract` varchar(200) NOT NULL,
  `province` varchar(18) NOT NULL,
  `city` varchar(18) NOT NULL,
  `district` varchar(18) NOT NULL,
  `add_time` int(10) NOT NULL DEFAULT '0',
  `eye` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_user_item_ad` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `img` varchar(500) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `url` varchar(500) CHARACTER SET utf8 NOT NULL DEFAULT '#',
  `title` varchar(50) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `sid` int(11) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `add_time` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `ims_aide_user_item_massage` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `aid` bigint(20) unsigned NOT NULL,
  `sid` int(11) NOT NULL,
  `fuid` bigint(20) unsigned NOT NULL,
  `uid` bigint(20) unsigned NOT NULL,
  `name` varchar(4) NOT NULL DEFAULT '',
  `phone` char(11) NOT NULL,
  `add_time` int(10) NOT NULL DEFAULT '0',
  `content` text NOT NULL,
  `tuid` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_user_kan` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) unsigned NOT NULL,
  `tuid` bigint(20) unsigned NOT NULL,
  `add_time` int(10) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `sid` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `tuid` (`tuid`),
  KEY `sid` (`sid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_user_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) unsigned NOT NULL,
  `type` varchar(18) NOT NULL DEFAULT '',
  `num` decimal(10,2) NOT NULL DEFAULT '0.00',
  `time` int(10) NOT NULL DEFAULT '0',
  `desc` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_user_photo` (
  `sid` int(11) NOT NULL,
  `uid` int(11) NOT NULL,
  `imgs` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_user_photos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `uid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `content` text NOT NULL,
  `imgs` text NOT NULL,
  `time` int(10) NOT NULL DEFAULT '0',
  `zan` int(10) NOT NULL DEFAULT '0',
  `eye` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='相册';

CREATE TABLE IF NOT EXISTS `ims_aide_user_poster` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sid` int(11) NOT NULL,
  `ewmtop` int(11) NOT NULL,
  `ewmleft` int(11) NOT NULL,
  `ewmwidth` int(11) NOT NULL,
  `img` varchar(500) NOT NULL DEFAULT '',
  `headimgwidth` int(11) NOT NULL,
  `headimgleft` int(11) NOT NULL,
  `headimgtop` int(11) NOT NULL,
  `headimgstatus` tinyint(1) NOT NULL DEFAULT '0',
  `add_time` int(10) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `title` varchar(128) NOT NULL DEFAULT '',
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `cid` int(11) NOT NULL,
  `app` tinyint(1) NOT NULL DEFAULT '0',
  `weixin` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_user_poster_card` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` int(10) unsigned NOT NULL,
  `name` varchar(32) NOT NULL,
  `sort` int(5) unsigned NOT NULL DEFAULT '0',
  `pid` bigint(20) unsigned NOT NULL,
  `add_time` int(10) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_user_record` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) unsigned NOT NULL COMMENT '用户',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `tuid` bigint(20) unsigned NOT NULL COMMENT '看',
  `add_time` int(10) NOT NULL DEFAULT '0',
  `aid` bigint(20) unsigned NOT NULL COMMENT '文',
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `sid` bigint(20) unsigned NOT NULL,
  `atitle` varchar(256) NOT NULL DEFAULT '',
  `aimg` varchar(256) NOT NULL DEFAULT '',
  `time` varchar(12) NOT NULL DEFAULT '' COMMENT '时间 00分00秒',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_user_share` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` int(10) unsigned NOT NULL DEFAULT '0',
  `uid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `aid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `time` int(10) NOT NULL DEFAULT '0',
  `eye` int(10) unsigned NOT NULL DEFAULT '0',
  `gold` int(10) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_user_video` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '那个店铺',
  `uid` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '哪个用户',
  `adid` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '广告',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '视频标题',
  `img` varchar(256) NOT NULL DEFAULT '' COMMENT '视频照片',
  `video` varchar(500) NOT NULL DEFAULT '' COMMENT '视频地址',
  `mark` varchar(64) NOT NULL DEFAULT '' COMMENT '视频标签',
  `time` int(10) NOT NULL DEFAULT '0' COMMENT '时间',
  `eye` int(11) NOT NULL DEFAULT '0' COMMENT '浏览量',
  `zan` int(11) NOT NULL DEFAULT '0' COMMENT '点赞量',
  `sort` int(6) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `cid` bigint(20) NOT NULL DEFAULT '0' COMMENT '标签id',
  `ewm` varchar(500) NOT NULL,
  `type` varchar(11) NOT NULL DEFAULT '1' COMMENT '1视频采集 2用户上传',
  `state` varchar(2) NOT NULL DEFAULT '0' COMMENT '状态 0：待审核 1审核通过 -1审核不通过',
  `url` varchar(500) NOT NULL DEFAULT '',
  `desc` varchar(500) NOT NULL DEFAULT '',
  `good` tinyint(1) NOT NULL DEFAULT '0' COMMENT '加精进入视频广场',
  `verify` tinyint(1) NOT NULL DEFAULT '1',
  `thumb` varchar(512) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='用户视频';

CREATE TABLE IF NOT EXISTS `ims_aide_video` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `md5` char(32) NOT NULL DEFAULT '',
  `url` varchar(256) NOT NULL DEFAULT '',
  `video` varchar(256) NOT NULL DEFAULT '',
  `title` varchar(256) NOT NULL DEFAULT '',
  `img` varchar(256) NOT NULL DEFAULT '',
  `thumb` varchar(512) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='video 库防止重复';

CREATE TABLE IF NOT EXISTS `ims_aide_video_ad` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '平台id',
  `uid` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `cate` varchar(64) NOT NULL DEFAULT '' COMMENT '分类',
  `type` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '类型',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `img` varchar(255) NOT NULL DEFAULT '' COMMENT '展示图片头像',
  `link` varchar(255) NOT NULL DEFAULT '' COMMENT '跳转链接',
  `desc` varchar(1000) NOT NULL DEFAULT '' COMMENT '描述',
  `imgs` text NOT NULL COMMENT '多图,分开',
  `ewm` varchar(255) NOT NULL DEFAULT '',
  `tel` varchar(32) NOT NULL DEFAULT '',
  `cost` float unsigned NOT NULL DEFAULT '0' COMMENT '成本价原价',
  `price` float unsigned NOT NULL DEFAULT '0' COMMENT '折扣价券后价',
  `address` varchar(500) NOT NULL DEFAULT '' COMMENT '地址',
  `pointx` varchar(128) NOT NULL DEFAULT '' COMMENT 'x坐标',
  `pointy` varchar(128) NOT NULL DEFAULT '' COMMENT 'y坐标',
  `time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `eye` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '浏览量',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='用户广告';

CREATE TABLE IF NOT EXISTS `ims_aide_video_cate` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sid` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(128) NOT NULL DEFAULT '',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `sort` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='视频分类';

CREATE TABLE IF NOT EXISTS `ims_aide_video_tousu` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) unsigned NOT NULL,
  `aid` bigint(20) unsigned NOT NULL,
  `vtitle` varchar(512) NOT NULL DEFAULT '',
  `vimg` varchar(512) NOT NULL DEFAULT '',
  `vvideo` varchar(512) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `time` int(10) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0,未处理、1.虚假举报、2.删除',
  `imgs` text NOT NULL,
  `sid` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_video_visitor` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `vid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `fuid` bigint(20) NOT NULL DEFAULT '0',
  `time` int(10) NOT NULL DEFAULT '0',
  `nickname` varchar(128) NOT NULL DEFAULT '',
  `headimgurl` varchar(255) NOT NULL DEFAULT '',
  `type` tinyint(1) DEFAULT '0' COMMENT '0直接访问1间接访问2赞3分享',
  `img` varchar(256) NOT NULL DEFAULT '' COMMENT '视频图片',
  `title` varchar(500) NOT NULL DEFAULT '' COMMENT '视频标题',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='访客';

CREATE TABLE IF NOT EXISTS `ims_aide_vip` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(128) NOT NULL,
  `sid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `num` smallint(5) unsigned NOT NULL DEFAULT '1',
  `unit` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `orderprice` int(10) unsigned NOT NULL DEFAULT '0',
  `price` int(10) unsigned NOT NULL DEFAULT '0',
  `integral` int(11) NOT NULL DEFAULT '0',
  `gold` int(11) NOT NULL DEFAULT '0',
  `onemoney` int(10) unsigned NOT NULL DEFAULT '0',
  `oneintegral` int(11) NOT NULL DEFAULT '0',
  `onegold` int(11) NOT NULL DEFAULT '0',
  `twomoney` int(11) NOT NULL DEFAULT '0',
  `twointegral` int(11) NOT NULL DEFAULT '0',
  `twogold` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `sort` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ims_aide_vipka` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sid` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `num` int(10) unsigned NOT NULL DEFAULT '0',
  `unit` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `integral` int(11) NOT NULL DEFAULT '0',
  `gold` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1',
  `time` int(11) NOT NULL DEFAULT '0',
  `ka` char(16) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='卡密表';

CREATE TABLE IF NOT EXISTS `ims_aide_vip_auth` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sid` int(10) unsigned NOT NULL,
  `vip` tinyint(1) NOT NULL DEFAULT '0',
  `url` varchar(32) NOT NULL DEFAULT '',
  `remark` varchar(64) NOT NULL DEFAULT '',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `prob` tinyint(1) NOT NULL DEFAULT '0',
  `num` int(11) NOT NULL DEFAULT '0',
  `pid` int(11) NOT NULL,
  `sort` int(11) NOT NULL,
  `title` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
