
  
if (!window.console) window.console = { log: function() {} };

if (typeof getComputedStyle == 'undefined') {
    if (document.div.currentStyle) {
        window.getComputedStyle = function(el) {
            return el.currentStyle;
        }
    } else {    
        window.getComputedStyle = {};
    }
}
(function(){ 
    window.__zoom = 1;
    
    (function(){
        var validArr = ","+([0.875, 1, 1.125, 1.25, 1.375]).join(",")+",";
        var match = window.location.href.match(/winzoom=(\d+(?:\.\d+)?)/);
        if (match && match[1]) {
            var winzoom = parseFloat(match[1]);
            if (validArr.indexOf(","+winzoom+",")>=0) {
                window.__zoom = winzoom;
            }
        }
    })();

    var ua = navigator.userAgent.toLowerCase();
    var re = new RegExp("msie ([0-9]+[\.0-9]*)");
    var version;
    if (re.exec(ua) != null) {
        version = parseInt(RegExp.$1);
    }
    var isIE = false;
    if (typeof version != 'undefined' && version >= 6 && version <= 9) {
        isIE = true;
    }
    var getMaxWith=function(){
        var container = document.getElementById('img-content');
        var max_width = container.offsetWidth;
        var container_padding = 0;
        var container_style = getComputedStyle(container);
        container_padding = parseFloat(container_style.paddingLeft) + parseFloat(container_style.paddingRight);
        max_width -= container_padding;
        if (!max_width) {
            max_width = window.innerWidth - 30;      
        }
        return max_width;
    };
    var getParentWidth = function(dom){
        var parent_width = 0;
        var parent = dom.parentNode;
        var outerWidth = 0;
        while (true) {
            if(!parent||parent.nodeType!=1) break;
            var parent_style = getComputedStyle(parent);
            if (!parent_style) break;
            parent_width = parent.clientWidth - parseFloat(parent_style.paddingLeft) - parseFloat(parent_style.paddingRight) - outerWidth;
            if (parent_width > 0) break;
            outerWidth += parseFloat(parent_style.paddingLeft) + parseFloat(parent_style.paddingRight) + parseFloat(parent_style.marginLeft) + parseFloat(parent_style.marginRight) + parseFloat(parent_style.borderLeftWidth) + parseFloat(parent_style.borderRightWidth);
            parent = parent.parentNode;
        }
        return parent_width;
    }
    var getOuterW=function(dom){
        var style=getComputedStyle(dom),
            w=0;
        if(!!style){
            w = parseFloat(style.paddingLeft) + parseFloat(style.paddingRight) + parseFloat(style.borderLeftWidth) + parseFloat(style.borderRightWidth);
        }
        return w;
    };
    var getOuterH =function(dom){
        var style=getComputedStyle(dom),
            h=0;
        if(!!style){
            h = parseFloat(style.paddingTop) + parseFloat(style.paddingBottom) + parseFloat(style.borderTopWidth) + parseFloat(style.borderBottomWidth);
        }
        return h;
    };
    var insertAfter = function(dom,afterDom){
        var _p = afterDom.parentNode;
        if(!_p){
            return;
        }
        if(_p.lastChild === afterDom){
            _p.appendChild(dom);
        }else{
            _p.insertBefore(dom,afterDom.nextSibling);
        }
    };
    var getQuery = function(name,url){
        
        var u  = arguments[1] || window.location.search,
            reg = new RegExp("(^|&)"+ name +"=([^&]*)(&|$)"),
            r = u.substr(u.indexOf("\?")+1).match(reg);
        return r!=null?r[2]:"";
    };

    
    function setImgSize(item, widthNum, widthUnit, ratio, breakParentWidth) {
        setTimeout(function () {
            var img_padding_border = getOuterW(item) || 0;
            var img_padding_border_top_bottom = getOuterH(item) || 0;
            
            if (widthNum > getParentWidth(item) && !breakParentWidth) {
                widthNum = getParentWidth(item);
            }

            height = (widthNum - img_padding_border) * ratio + img_padding_border_top_bottom;

            if (isIE) {
                var url = item.getAttribute('data-src');
                item.src = url;
            } else {
                if(parseFloat(widthNum, 10) > 40 && height > 40 && breakParentWidth) {
                    item.className += ' img_loading';
                }
                item.src = "data:image/gif;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVQImWNgYGBgAAAABQABh6FO1AAAAABJRU5ErkJggg==";
            }
            item.style.cssText += ";width: " + widthNum + widthUnit + " !important;";
            item.style.cssText += ";height: " + height + widthUnit + " !important;";
        }, 10);
    }

    (function(){
        var images = document.getElementsByTagName('img');
        var length = images.length;
        var max_width = getMaxWith();
        for (var i = 0; i < length; ++i) {
            if (window.__second_open__ && images[i].getAttribute('__sec_open_place_holder__')) {
                continue;
            }
            var imageItem = images[i];
            var src_ = imageItem.getAttribute('data-src');
            var realSrc = imageItem.getAttribute('src');
            if (!src_ || realSrc) continue;
            
            var originWidth = imageItem.getAttribute('data-w');
            var ratio_ = 1 * imageItem.getAttribute('data-ratio');

            var height = 100;
            if (ratio_ && ratio_ > 0) {
                var parent_width = getParentWidth(imageItem) || max_width;
                var initWidth = imageItem.style.width || imageItem.getAttribute('width') || originWidth || parent_width;
                initWidth = parseFloat(initWidth, 10) > max_width ? max_width : initWidth;
                
                if (initWidth) {
                    imageItem.setAttribute('_width', !isNaN(initWidth * 1) ? initWidth + 'px' : initWidth);
                }
                
                if (typeof initWidth === 'string' && initWidth.indexOf('%') !== -1) {
                    initWidth = parseFloat(initWidth.replace('%', ''), 10) / 100 * parent_width;
                }
                
                if (initWidth === 'auto') {
                    initWidth = originWidth;
                }

                var res = /^(\d+(?:\.\d+)?)([a-zA-Z%]+)?$/.exec(initWidth);
                var widthNum = res && res.length >= 2 ? res[1] : 0;
                var widthUnit = res && res.length >= 3 && res[2] ? res[2] : 'px';

                
                setImgSize(imageItem, widthNum, widthUnit, ratio_, true);
                
                (function (item, widthNumber, unit, ratio) {
                    setTimeout(function () {
                        setImgSize(item, widthNumber, unit, ratio, false);
                    });
                })(imageItem, widthNum, widthUnit, ratio_);
            } else {
                imageItem.style.cssText += ";visibility: hidden !important;";
            }

        }
    })();
    window.__videoDefaultRatio=16/9;
    window.__getVideoWh = function(dom){
        var max_width = getMaxWith(),
            width = max_width,
            ratio_ = dom.getAttribute('data-ratio')*1,
            arr = [4/3, 16/9],
            ret = arr[0],
            abs = Math.abs(ret - ratio_);
        if (!ratio_) { 
            if (dom.getAttribute("data-mpvid")) { 
                ratio_ = 16/9;
            } else { 
                ratio_ = 4/3;
            }
        } else { 
            for (var j = 1, jl = arr.length; j < jl; j++) {
                var _abs = Math.abs(arr[j] - ratio_);
                if (_abs < abs) {
                    abs = _abs;
                    ret = arr[j];
                }
            }
            ratio_ = ret;
        }

        var parent_width = getParentWidth(dom)||max_width,
            width = width > parent_width ? parent_width : width,
            outerW = getOuterW(dom)||0,
            outerH = getOuterH(dom)||0,
            videoW = width - outerW,
            videoH = videoW/ratio_,
            height = videoH + outerH;
        return {w:Math.ceil(width),h:Math.ceil(height),vh:videoH,vw:videoW,ratio:ratio_};
    };


    (function(){
        var iframe = document.getElementsByTagName('iframe');
        for (var i=0,il=iframe.length;i<il;i++) {
            if (window.__second_open__ && iframe[i].getAttribute('__sec_open_place_holder__')) {
                continue;
            }
            var a = iframe[i];
            var src_ = a.getAttribute('src')||a.getAttribute('data-src')||"";
            if(!/^http(s)*\:\/\/v\.qq\.com\/iframe\/(preview|player)\.html\?/.test(src_)
                && !/^http(s)*\:\/\/mp\.weixin\.qq\.com\/mp\/readtemplate\?t=pages\/video_player_tmpl/.test(src_)
            ){
                continue;
            }
            var vid = getQuery("vid",src_);
            if(!vid){
                continue;
            }
            vid=vid.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,"");
            a.removeAttribute('src');
            a.style.display = "none";
            var obj = window.__getVideoWh(a),
                videoPlaceHolderSpan = document.createElement('span'),
                videoPlayerIconSpan = document.createElement('span'),
                mydiv = document.createElement('img');

            videoPlaceHolderSpan.className = "js_img_loading db";
            videoPlaceHolderSpan.setAttribute("data-vid", vid);
            

            videoPlayerIconSpan.className = 'wx_video_context db'; 
            videoPlayerIconSpan.style.display = 'none';
            videoPlayerIconSpan.innerHTML = '<span class="wx_video_thumb_primary"></span><button class="wx_video_play_btn">播放</button><span class="wx_video_mask"></span>'; 

            mydiv.className = "img_loading";

            mydiv.src="data:image/gif;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVQImWNgYGBgAAAABQABh6FO1AAAAABJRU5ErkJggg==";
            
            
            videoPlaceHolderSpan.style.cssText = "width: " + obj.w + "px !important;";
            mydiv.style.cssText += ";width: " + obj.w + "px";
            videoPlaceHolderSpan.appendChild(videoPlayerIconSpan);
            videoPlaceHolderSpan.appendChild(mydiv);
            insertAfter(videoPlaceHolderSpan, a); 

            a.style.cssText += ";width: " + obj.w + "px !important;";
            a.setAttribute("width",obj.w);
            if(window.__zoom!=1){
                a.style.display = "block";
                videoPlaceHolderSpan.style.display = "none";
                a.setAttribute("_ratio",obj.ratio);
                a.setAttribute("_vid",vid);
            }else{
                videoPlaceHolderSpan.style.cssText += "height: " + obj.h + "px !important;";
                mydiv.style.cssText += "height: " + obj.h + "px !important;";
                a.style.cssText += "height: " + obj.h + "px !important;";
                a.setAttribute("height",obj.h);
            }
            a.setAttribute("data-vh",obj.vh);
            a.setAttribute("data-vw",obj.vw);
            if(a.getAttribute("data-mpvid")){
                a.setAttribute("data-src",location.protocol+"//mp.weixin.qq.com/mp/readtemplate?t=pages/video_player_tmpl&auto=0&vid="+vid);
            }else{
                a.setAttribute("data-src",location.protocol+"//v.qq.com/iframe/player.html?vid="+ vid + "&width="+obj.vw+"&height="+obj.vh+"&auto=0");
            }
        }
    })();

    (function(){
        if(window.__zoom!=1){
            if (!window.__second_open__) {
                document.getElementById('page-content').style.zoom = window.__zoom;
                var a = document.getElementById('activity-name');
                var b = document.getElementById('meta_content');
                if(!!a){
                    a.style.zoom = 1/window.__zoom;
                }
                if(!!b){
                    b.style.zoom = 1/window.__zoom;
                }
            }
            var images = document.getElementsByTagName('img');
            for (var i = 0,il=images.length;i<il;i++) {
                if (window.__second_open__ && images[i].getAttribute('__sec_open_place_holder__')) {
                    continue;
                }
                images[i].style.zoom = 1/window.__zoom;
            }
            var iframe = document.getElementsByTagName('iframe');
            for (var i = 0,il=iframe.length;i<il;i++) {
                if (window.__second_open__ && iframe[i].getAttribute('__sec_open_place_holder__')) {
                    continue;
                }
                var a = iframe[i];
                a.style.zoom = 1/window.__zoom;
                var src_ = a.getAttribute('data-src')||"";
                if(!/http(s)*\:\/\/v\.qq\.com\/iframe\/(preview|player)\.html\?/.test(src_)){
                    continue;
                }
                var ratio = a.getAttribute("_ratio");
                var vid = a.getAttribute("_vid");
                a.removeAttribute("_ratio");
                a.removeAttribute("_vid");
                var vw = a.offsetWidth - (getOuterW(a)||0);
                var vh = vw/ratio;
                var h = vh + (getOuterH(a)||0)
                a.style.cssText += "height: " + h + "px !important;"
                a.setAttribute("height",h);
                a.setAttribute("data-src",location.protocol+"//v.qq.com/iframe/player.html?vid="+ vid + "&width="+vw+"&height="+vh+"&auto=0");
                a.style.display = "none";
                var parent = a.parentNode;
                if(!parent){
                    continue;
                }
                for(var j=0,jl=parent.children.length;j<jl;j++){
                    var child = parent.children[j];
                    if(child.className.indexOf("img_loading")>=0 && child.getAttribute("data-vid")==vid){
                        child.style.cssText += "height: " + h + "px !important;";
                        child.style.display = "";
                    }
                }
            }
        }
    })();
})();

           //**** 音频播放
       var jsaudio=$('.js_audio_frame');
       var audioplay=null;
       var audio=null;

       if(jsaudio.length>0){

              var mediaid=$(jsaudio[0]).data('id')
              var audiostr='<audio style="height:0;width:0;display:none"  src="//res.wx.qq.com/voice/getvoice?mediaid='+mediaid+'" data-id="'+mediaid+'"></audio>';

              $('main').append(audiostr);

              audio=document.querySelector('audio');
              


             audio.addEventListener("timeupdate",function(){

              
                    var percent  = audio.currentTime / audio.duration;
                   
                    audioplay.find('.audio_card_progress_inner').attr('style',"width:"+percent*100+"%");
                    audioplay.find('.audio_card_length_current').text(my.bftime(audio.currentTime));
                    audioplay.find('.audio_card_progress_handle').css({'display':'block','left':percent*100+"%"});
            
                
             })


       }

     
      $('.weui-audio-btn').click(function(r){

                 // 判断是不是当前视频
                   var t=$(this);

                 if(audioplay!=null){

                        if(audioplay.data('sort')!=t.parents('.js_audio_frame').data('sort')){

                            console.log(222222)

                                    audioplay.find('.appmsg_card_context').removeClass('share_audio_playing');
                                    audioplay.find('.audio_card_progress_inner').attr('style',"width:0%");
                                    audioplay.find('.audio_card_length_current').text("00:00");
                                    audioplay.find('.audio_card_progress_handle').css({'display':'none','left':'0%'});

                                   audioplay=t.parents('.js_audio_frame');
                                   audio.src='//res.wx.qq.com/voice/getvoice?mediaid='+audioplay.data('id');
                                   audio.play();
                        }else{

                            

                            if(audio.paused) {
                              audio.play();
                               audioplay.addClass('share_audio_playing');
                              
                            } else {
                              audio.pause();
                             
                              audioplay.removeClass('share_audio_playing');
                            
                              
                            }

                          

                        }
                 }else{

                    audioplay=t.parents('.js_audio_frame');
                   audio.src='//res.wx.qq.com/voice/getvoice?mediaid='+audioplay.data('id');
                   audio.play();
                   audioplay.addClass('share_audio_playing');
                 }


       })
