<?php

namespace app\mobile\add;

use cjzy\Mobile;
use query\QueryList;
use video\Rules;
use WeAccount;
/**
* 
*/
class Caiji extends Mobile
{
    public function index()
    {
        $cai = iurl('article', [], true);
        ihttp_get($cai);
        $rewen = iurl('rewen', [], true);
        ihttp_get($rewen);
        $baogao = iurl('baogao', [], true);
        ihttp_get($baogao);
        $jiaohu = iurl('jiaohu', [], true);
        ihttp_get($jiaohu);
    }
    public function article()
    {
        set_time_limit(0);
        fastcgi_finish_request();
        $sid = sid();
        //今天开始时间戳
        $day = mktime(0, 0, 0, date('m'), date('d'), date('Y'));
        $renwu = db('article_cai')->where(['sid' => sid(), 'exetime <' => $day])->select();
        if (empty($renwu)) {
            return false;
        }
        foreach ($renwu as $k1 => $v1) {
            $begin = strtotime(date('Y/m/d') . ' ' . $v1['begin']);
            if (time() >= $begin) {
                $token = random(16);
                $jiami = md5($token . $v1['id']);
                db('article_cai')->where('id', $v1['id'])->update(['exetime' => time(), 'token' => $jiami]);
                $this->acturl($v1);
                // $url=iurl('acturl',['id'=>$v1['id'],'token'=>$token],true);
                // ihttp_get($url);
            }
        }
    }
    protected function acturl($renwu)
    {
        $sid = sid();
        if ($renwu['type'] == 1) {
            $html = $this->geturl($renwu['url']);
            $data = QueryList::Query($html, ["title" => ['li .txt-box h3 a', 'text'], 'url' => ['li .img-box a', 'href']])->data;
            if (empty($data)) {
                return false;
            }
            $pa = 0;
            $num = $renwu['num'];
            $res = [];
            $cid = $renwu['cid'];
            foreach ($data as $k3 => $v3) {
                $aid = db('article')->where(['sid' => $sid, 'title' => $v3['title']])->value('id');
                if (!$aid) {
                    $this->caiji(['url' => $v3['url'], 'cid' => $cid]);
                    $pa++;
                }
                if ($pa >= $num) {
                    break;
                }
            }
            //db('article_renwu')->insertAll($res);
        }
        if ($renwu['type'] == 2) {
            // echo 1111;
            // $this->_wechat($renwu['title']);
        }
    }
    protected function caiji($renwu)
    {
        $sid = sid();
        // $renwu= db('article_renwu')->where('sid',$sid)->find();
        // db('article_renwu')->where('id',$renwu['id'])->delete();
        if (empty($renwu)) {
            return false;
        }
        $html = ihttp_get($renwu['url']);
        $content = $html['content'];
        $data = QueryList::Query($content, ["title" => array('#activity-name', 'text'), 'content' => array('#js_content', 'html')])->data;
        $title = trim($data[0]["title"]);
        //$title = trim(get_tag_data($content, '<h2 class="rich_media_title" id="activity-name">', '</h2>'));
        $desc = get_tag_data($content, 'var msg_desc = "', '";');
        $imgurl = getimg(get_tag_data($content, 'msg_cdn_url = "', '";'), true);
        //$body = get_tag_data($content, 'id="js_content">', '</div>');
		$body = $data[0]["content"];
        $imgs = [];
        $imgs[] = replaceimg($body, '#<img.*?data-src="([^"]*)"[^>]*>#i');
        $imgs[] = replaceimg($body, '#<img.*? src="([^"]*)"[^>]*>#i');
        $imgs[] = replaceimg($body, '#border-image-source: url.*?([^(][^)]*)#i');
        $imgs[] = replaceimg($body, '#background-image: url.*?([^(][^)]*)#i');
        $imgdata = [];
        foreach ($imgs as $key => $vo) {
            if (!empty($vo)) {
                $imgdata = array_merge($imgdata, $vo);
            }
        }
        $imgdata = array_unique($imgdata);
        $body = dimg($body, $imgdata);
        $body = video($body);
        $body = str_replace("data-src", "src", $body);
        $time = time();
        $act = array('title' => $title, 'img' => $imgurl, 'abstract' => $desc, 'content' => $body . '<p><span style="text-align:centent">本文来源于网络,版权归原作者所有,如有侵权请联系管理员删除</span></p>', 'sid' => $sid, 'cid' => $renwu['cid'], 'time' => $time, 'zan' => rand(600, 3000), 'eye' => rand(10000, 100000), 'share' => rand(30, 1200));
        db('article')->insert($act);
        //$this->success('成功');
    }
    public function geturl($url)
    {
        $str = "Accept:text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8\r\n        Accept-Encoding: deflate, br\r\n        Accept-Language:zh-CN,zh;q=0.8\r\n        Cache-Control:no-cache\r\n        Connection:keep-alive\r\n        Pragma:no-cache\r\n        Upgrade-Insecure-Requests:1\r\n        User-Agent:Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36";
        $arr = explode("\n", $str);
        return Rules::doRequest('get', $url, ['headers' => $arr]);
    }
    /**
     * 每日热文推送
     */
    public function rewen()
    {
        set_time_limit(0);
        fastcgi_finish_request();
        $sid = sid();
        $rewen = db('remen')->where('sid', $sid)->select();
        if (empty($rewen)) {
            return false;
        }
        $time = time();
        $day = date('Y-m-d', $time);
        //今天的年与日
        $jinri = strtotime(date('Y/m/d') . ' 00:00:00');
        foreach ($rewen as $k => $v) {
            $begin = strtotime(date('Y/m/d') . ' ' . $v['begin']);
            if ($time >= $begin && $v['endtime'] < $jinri) {
                $token = random(16);
                $jiami = md5($token . $v['id']);
                db('remen')->where(['sid' => $sid, 'id' => $v['id']])->update(['token' => $jiami, 'endtime' => $time, 'content' => '']);
                // $url=iurl('tuiwen',['id'=>$v['id'],'token'=>$token],true);
                // ihttp_get($url);
                //
                $this->tuiwen($v);
            }
        }
    }
    /**
     * 推广文章或者视频
     * 
     */
    protected function tuiwen($renwu)
    {
        $sid = sid();
        $content = $renwu['header'] . "\n\n";
        if ($renwu['type'] == 1) {
            $act = db('article')->where('sid', $sid)->order('time desc')->field('id,title')->paginate(6);
            $url = iurl('tokeract/index/item', [], true);
            foreach ($act as $k2 => $v2) {
                $content .= "\n<a href='{$url}&id={$v2['id']}'>{$v2['title']}</a>\n";
            }
        }
        if ($renwu['type'] == 2) {
            $video = db('user_video')->where(['sid' => $sid, 'good' => 1])->order('time desc')->field('id,title')->paginate(6);
            $vurl = iurl('video/video/play', [], true);
            foreach ($video as $k3 => $v3) {
                $content .= "\n<a href='{$vurl}&id={$v3['id']}'>{$v3['title']}</a>\n\n";
            }
        }
        $content .= $renwu['footer'];
        $user = db('user')->where(['sid' => $sid, 'subscribe' => 1, 'openid !=' => ''])->field('openid')->order('time asc')->select();
        if (empty($user)) {
            return false;
        }
        $account_api = WeAccount::create();
        foreach ($user as $ku => $vu) {
            if ($vu['openid'] != '') {
                $message = array('msgtype' => 'text', 'text' => array('content' => urlencode($content)), 'touser' => $vu['openid']);
                $status = $account_api->sendCustomNotice($message);
                // pr($status);
            }
        }
    }
    /**
     * 报告推送
     */
    public function baogao()
    {
        set_time_limit(0);
        fastcgi_finish_request();
        $v = config();
        $sid = sid();
        $baogao_day = $v['baogao_day'];
        $baogao_day_time = $v['baogao_day_time'];
        //每日报告
        $day = date('Y-m-d', time());
        $time = time();
        $new = strtotime($day . ' 00:00:00');
        if (!empty($baogao_day) && !empty($baogao_day_time)) {
            $day_time = strtotime($day . ' ' . $baogao_day_time);
            if ($time > $day_time) {
                //判断是否已经执行
                $yzx = db('renwu')->where(['sid' => $sid, 'type' => 2, 'time >=' => $new])->count();
                if (!$yzx) {
                    db('renwu')->insert(['sid' => $sid, 'type' => 2, 'time' => $time]);
                    // //执行
                    //   $token=random(16);
                    //   $jiami=md5($token);
                    //   config('baogao_day_token',$jiami);
                    //   $url=iurl('tuibg',['type'=>1,'token'=>$token],true);
                    //   ihttp_get($url);
                    $this->tuibg(1);
                }
            }
        }
        $baogao_week = $v['baogao_week'];
        $baogao_week_num = $v['baogao_week_num'];
        $baogao_week_time = $v['baogao_week_time'];
        if (!empty($baogao_week) && !empty($baogao_week_num) && !empty($baogao_week_time)) {
            //判断今天星期几  与定时是否一致
            //
            $week = date("w");
            if ($week == $baogao_week_num - 1) {
                //今天是发送周报的那一天
                $week_time = strtotime($day . ' ' . $baogao_week_time);
                if ($week_time < $time) {
                    //判断是否已经执行
                    $wyzx = db('renwu')->where(['sid' => $sid, 'type' => 3, 'time >=' => $new])->count();
                    if (!$wyzx) {
                        db('renwu')->insert(['sid' => $sid, 'type' => 3, 'time' => $time]);
                        $this->tuibg(2);
                    }
                }
            }
        }
    }
    /**
     * 报告推送
     */
    protected function tuibg($type)
    {
        $sid = sid();
        $begin = $type == 1 ? mktime(0, 0, 0, date('m'), date('d') - 1, date('Y')) : mktime(0, 0, 0, date('m'), date('d') - date('w') + 1 - 7, date('Y'));
        $end = $type == 1 ? mktime(0, 0, 0, date('m'), date('d') + 1, date('Y')) - 1 : mktime(23, 59, 59, date('m'), date('d') - date('w') + 7 - 7, date('Y'));
        //循环推送消息
        $users = db('user')->where(['sid' => sid(), 'openid !=' => '', 'subscribe' => 1])->field('id,openid')->order('time asc')->select();
        if (empty($users)) {
            return false;
        }
        $url = iurl('user/index/index', [], true);
        $gt = $type == 1 ? "昨天" : "上周";
        $gk = $type == 1 ? "每日报表" : "每周报表";
        $account_api = WeAccount::create();
        foreach ($users as $k => $v) {
            $ac = db('user_article')->where(['sid' => $sid, 'uid' => $v['id'], 'time >=' => $begin, 'time <=' => $end])->count();
            $ae = db('user_record')->where(['sid' => $sid, 'uid' => $v['id'], 'add_time >=' => $begin, 'add_time <=' => $end])->count();
            $vc = db('user_video')->where(['sid' => $sid, 'uid' => $v['id'], 'time >=' => $begin, 'time <=' => $end])->count();
            $ve = db('video_visitor')->where(['uid' => $v['id'], 'time >=' => $begin, 'time <=' => $end, 'type <' => 2])->count();
            $str = "【{$gk}】\n\n";
            $str .= "您{$gt} 新增了 {$ac} 篇文章，获得了 {$ae} 次跟进机会，制作了 {$vc} 个视频，获得了 {$ve} 次跟进机会。\n\n";
            $str .= "<a href='{$url}'>【点击继续使用】</a>";
            $message = array('msgtype' => 'text', 'text' => array('content' => urlencode($str)), 'touser' => $v['openid']);
            $account_api->sendCustomNotice($message);
            // pr($status);
        }
    }
    public function jiaohu()
    {
        set_time_limit(0);
        fastcgi_finish_request();
        $time = time();
        //早上6点时间戳
        $tm1 = strtotime(date('Y-m-d 06:00'));
        $tm2 = strtotime(date('Y-m-d 22:00'));
        if ($time < $tm1 || $time > $tm2) {
            return false;
        }
        $content = "❗❗❗紧急求助\n老师您好，您已经一天多没有搭理小编了。\n\n由于微信平台规则限制，我们将无法与您发送消息通知啦！\n\n☛<a href='weixin://bizmsgmenu?msgmenucontent=解除限制&msgmenuid=1'>点击解除限制</a>☚";
        $t1 = time() - 48 * 3600;
        $t2 = time() - 24 * 3600;
        $s1 = time() - 4 * 3600;
        $users = db('interact')->where(['sid' => sid(), 'time >' => $t1, 'time <=' => $t2, 'tixing <=' => $s1])->select();
        foreach ($users as $key => $v) {
            sendText($v['openid'], $content);
            db('interact')->where('id', $v['id'])->update(['tixing' => time()]);
        }
    }
}