﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace 全民k歌作品批量下载工具
{
    class Program
    {
        private static int count = 0;
        private static ArrayList lst = new ArrayList();//定义集合储存歌手对象
        /// <summary>
        /// 将"uid:备注"的格式转换成Singer对象
        /// </summary>
        /// <param name="s"></param>
        /// <returns></returns>
        private static Singer GetSinger(string s)
        {
            string[] temp = s.Split(':');
            return (new Singer(temp[0], temp[1]));
        }
        /// <summary>
        /// 主方法
        /// </summary>
        /// <param name="args">运行参数</param>
        static void Main(string[] args)
        {
            Console.WriteLine("全民k歌作品批量下载工具v1.0\t作者:遗憾迟香\t吾爱破解论坛");
            try
            {
                if (args.Length != 1)
                {
                    Console.WriteLine("参数错误");
                    return;
                }
                string[] str = File.ReadAllLines(args[0], Encoding.Default);//读取文件
                foreach (string t in str)
                {//添加歌手
                    if (t == "" || t.Contains("//")) { continue; }
                    if (t.Contains(":"))
                    { lst.Add(GetSinger(t)); }//带备注
                    else { lst.Add(new Singer(t)); }//不带备注
                }
                if (lst.Count == 0)
                {
                    Console.WriteLine("您未添加任何歌手");
                    return;
                }
                foreach (Singer t in lst)
                {//循环遍历下载所有作品
                    t.DownloadAll();
                    count += t.SongList.Count;
                }
                Console.WriteLine("本次运行一共下载了{0}首作品",count);
            }
            catch (Exception err)
            { Console.WriteLine(err.Message); }
            finally
            {
                Console.WriteLine("按任意键退出");
                Console.ReadKey();
            }
        }
    }
}
