﻿using System;
using System.Collections.Generic;
using System.Collections;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Net;
using System.IO;
using System.Runtime.InteropServices;
using System.Diagnostics;

namespace 全民k歌作品批量下载工具
{
    public class Singer
    {
        //查询链接
        public static string[] CGI = { "http://cgi.kg.qq.com/fcgi-bin/kg_ugc_get_homepage?jsonpCallback=callback_0&inCharset=GB2312&outCharset=utf-8&g_tk=5381&g_tk_openkey=5381&type=get_uinfo&start=", "&num=8&touin=&share_uid=" };
        private string uid;

        public string Uid
        {
            get { return uid; }
            set { uid = value; }
        }
        private string name;

        public string Name
        {
            get { return name; }
            set { name = value; }
        }
        private string src;//个人主页源码

        public string Src
        {
            get { return src; }
            set { src = value; }
        }
        private string srcPP;//源码累加

        public string SrcPP
        {
            get { return srcPP; }
            set { srcPP = value; }
        }

        private ArrayList songList;//所有作品

        public ArrayList SongList
        {
            get { return songList; }
            set { songList = value; }
        }
        /// <summary>
        /// Singer有参构造
        /// </summary>
        /// <param name="uid">歌手uid</param>
        public Singer(string uid)
        {
            Console.Write("正在获取歌手信息:");
            this.uid = uid;
            this.src = GetS(string.Format("{0}1{1}{2}", CGI[0], CGI[1], uid));
            if (this.src.Contains("参数错误") || !src.Contains("ok"))
            {
                Console.WriteLine("{0}\nuid:{1}\n请检查网络连接以及输入的uid是否正确\n按任意键退出", src, uid);
                Console.ReadKey();
                Process.GetCurrentProcess().Kill();
            }
            this.name = GetMiddleText(this.src, "\"nickname\": \"", "\", \"sCityId");
            Console.WriteLine(name);
            string temp = null;
            for (int i = 1; true; i++)
            {
                string str = GetS(string.Format("{0}{1}{2}{3}", CGI[0], i, CGI[1], uid));
                if (!str.Contains("shareid"))
                { break; }
                temp += str.Substring(str.IndexOf("ugclist"));
            }
            this.srcPP = temp;
            this.songList = GetSong(getson(srcPP));
        }
        /// <summary>
        /// Singer有参构造(有备注)
        /// </summary>
        /// <param name="uid">uid</param>
        /// <param name="name">备注</param>
        public Singer(string uid, string name)
        {
            Console.Write("正在获取歌手信息:");
            this.uid = uid;
            this.src = GetS(string.Format("{0}1{1}{2}", CGI[0], CGI[1], uid));
            if (this.src.Contains("参数错误") || !src.Contains("ok"))
            {
                Console.WriteLine("{0}\nuid:{1}\n请检查网络连接以及输入的uid是否正确\n按任意键退出", src, uid);
                Console.ReadKey();
                Process.GetCurrentProcess().Kill();
            }
            this.name = name;
            Console.WriteLine(name);
            string temp = null;
            for (int i = 1; true; i++)
            {
                string str = GetS(string.Format("{0}{1}{2}{3}", CGI[0], i, CGI[1], uid));
                if (!str.Contains("shareid"))
                { break; }
                temp += str.Substring(str.IndexOf("ugclist"));
            }
            this.srcPP = temp;
            this.songList = GetSong(getson(srcPP));
        }
        /// <summary>
        /// 下载歌手所有作品
        /// </summary>
        public void DownloadAll()
        {
            if (songList.Count == 0)
            {
                Console.WriteLine("{0}没有任何歌曲",name);
                return;
            }
            Console.WriteLine("开始下载{0}的所有作品",name);
            foreach (Song i in songList)
            { i.Download(); }
            Console.WriteLine("一共下载了{0}首歌",songList.Count);
        }

        /// <summary>
        /// 获取网页源码
        /// </summary>
        /// <param name="url">url</param>
        /// <returns></returns>
        public static string GetS(string url)
        {
            string message = string.Empty;
            HttpWebRequest request;
            try
            {
                request = (HttpWebRequest)WebRequest.Create(url);
                request.Accept = "text/html, application/xhtml+xml, */*";
                request.UserAgent = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)";
                request.KeepAlive = true;
                request.ProtocolVersion = HttpVersion.Version11;
                ServicePointManager.Expect100Continue = false;
                HttpWebResponse response = (HttpWebResponse)request.GetResponse();
                Stream responseStream = response.GetResponseStream();
                StreamReader reader = new StreamReader(responseStream, Encoding.GetEncoding("UTF-8"));
                message = reader.ReadToEnd();
                reader.Close();
                responseStream.Close();
            }
            catch (Exception err)
            {
                message = err.Message;
            }
            finally { GC.Collect(); }
            return message;
        }


        /// <summary>
        /// 取出中间字符串
        /// </summary>
        /// <param name="str">源字符串</param>
        /// <param name="leftStr">左</param>
        /// <param name="rightStr">右</param>
        /// <returns></returns>
        public static string GetMiddleText(string str, string leftStr, string rightStr)
        {
            if (str == "" || leftStr == "" || rightStr == "") { return null; }
            int a = str.IndexOf(leftStr, 0);
            int b = str.IndexOf(rightStr, a + 1);
            if (a < 0 || b < 0)
            { return null; }
            else
            {
                a = a + leftStr.Length;
                b = b - a;
                if (a < 0 || b < 0)
                { return null; }
                return str.Substring(a, b);
            }
        }

        [DllImport("Wesing.dll")]
        private static extern IntPtr getsong(string srcPP);


        private static string getson(string srcPP)
        {
            return Marshal.PtrToStringAnsi(getsong(srcPP));
        }
        /// <summary>
        /// 获取歌手所有作品
        /// </summary>
        /// <param name="result">易语言dll的返回值</param>
        /// <returns>返回Song类型的集合</returns>
        private ArrayList GetSong(string result)
        {
            string[] str = result.Split(' ');
            ArrayList arr = new ArrayList();
            foreach (string i in str)
            {
                if (i.Trim() != "")
                { arr.Add(new Song(i.Trim(), name)); }
            }
            return arr;
        }
    }
}
