﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;

namespace 全民k歌作品批量下载工具
{
    public class Song
    {
        private const string url = "https://node.kg.qq.com/play?s=";
        private string shareid;

        public string Shareid
        {
            get { return shareid; }
            set { shareid = value; }
        }
        private string title;//歌名

        public string Title
        {
            get { return title; }
            set { title = value; }
        }

        private string singerName;//歌手名

        public string SingerName
        {
            get { return singerName; }
            set { singerName = value; }
        }
        private string src;//网页源码

        public string Src
        {
            get { return src; }
            set { src = value; }
        }

        /// <summary>
        /// Song有参构造
        /// </summary>
        /// <param name="shareid">作品id</param>
        public Song(string shareid, string singerName)
        {
            this.shareid = shareid;
            this.singerName = singerName;
            this.src = Singer.GetS(url + shareid);
            this.title = Singer.GetMiddleText(this.src, "<h2 class=\"play_name\">", "</h2>");
        }

        /// <summary>
        /// 下载歌曲
        /// </summary>
        public void Download()
        {
            Console.WriteLine("{0} 正在下载中:{1}-{2}", DateTime.Now, singerName, title);
            Random rd = new Random();
            try
            {
                string dir = Directory.GetCurrentDirectory();
                if (!Directory.Exists(string.Format("{0}\\{1}", dir, singerName)))
                { Directory.CreateDirectory(string.Format("{0}\\{1}", dir, singerName)); }//创建文件夹
                dir = string.Format("{0}\\{1}", Directory.GetCurrentDirectory(), singerName);
                string DownUrl;
                if (src.Contains(".mp4")) { DownUrl = Singer.GetMiddleText(src, "playurl_video\":\"", "&fromtag"); }
                else
                { DownUrl = Singer.GetMiddleText(src, "playurl\":\"", "&fromtag"); }//下载地址
                string rand = rd.Next().ToString();//生成随机数
                if (File.Exists(string.Format("{0}\\{1}-{2}.m4a", dir, singerName, title)))
                { singerName += rand; }//目标文件已存在,使用随机数重命名
                Down(string.Format("{0}\\{1}-{2}.m4a", dir, singerName, title), DownUrl);
                if (!File.Exists(string.Format("{0}\\{1}-{2}.m4a", dir, singerName, title)))
                { //歌手名存在非法字符,启动备用下载
                    Down(string.Format("{0}\\{1}-{2}.m4a", dir, rand, title), DownUrl);
                    if (!File.Exists(string.Format("{0}\\{1}-{2}.m4a", dir, rand, title)))
                    {//歌名存在非法字符,启动备用下载
                        Down(string.Format("{0}\\{1}-{2}.m4a", dir, rand, rd.Next()), DownUrl);
                    }
                }
                if (!DownUrl.Contains("http"))
                { Console.WriteLine("下载失败,下载地址有误:{0}", DownUrl); }
            }
            catch (Exception err)
            {
                Console.WriteLine("下载失败," + err.Message);
            }
        }

        /// <summary>
        /// 下载文件，若目标已存在则覆盖，文件名非法则不会下载
        /// </summary>
        /// <param name="path">目录</param>
        /// <param name="url">下载地址</param>
        [DllImport("Wesing.dll")]
        public static extern void Down(string path, string url);
    }
}
