<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <title><?php echo $app->trans('talk.transcript.mail.title') ?></title>

        <style>
            /* Reset styles *******************************************************************************************************/
            html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font:inherit;vertical-align:baseline}article,aside,details,figcaption,figure,footer,header,hgroup,menu,nav,section{display:block}body{line-height:1}ol,ul{list-style:none}blockquote,q{quotes:none}blockquote:before,blockquote:after,q:before,q:after{content:'';content:none}table{border-spacing:0}
            /* /Reset styles ******************************************************************************************************/

            /* Fonts **************************************************************************************************************/
            @font-face
            {
                font-family: 'Open Sans';
                src: url(data:application/x-font-woff;charset=utf-8;base64,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) format('woff');
                font-weight: 400;
                font-style: normal;
            }

            @font-face
            {
                font-family: 'Open Sans';
                src: url(data:application/x-font-woff;charset=utf-8;base64,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) format('woff');
                font-weight: 600;
                font-style: normal;
            }
            /* /Fonts *************************************************************************************************************/

            /* /Emoticons *************************************************************************************************************/
            .emot
            {
                display: inline-block;
                width: 18px;
                height: 18px;
                background-image: url(data:image/png;base64,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);
            }

            .emot.emot-1  { background-position:  -18px -0px; }
            .emot.emot-2  { background-position: -198px -0px; }
            .emot.emot-3  { background-position: -234px -0px; }
            .emot.emot-4  { background-position: -252px -0px; }
            .emot.emot-5  { background-position: -270px -0px; }
            .emot.emot-6  { background-position: -288px -0px; }
            .emot.emot-7  { background-position: -306px -0px; }
            .emot.emot-8  { background-position: -324px -0px; }
            .emot.emot-9  { background-position: -342px -0px; }
            .emot.emot-10 { background-position: -180px -0px; }
            .emot.emot-11 { background-position:  -36px -0px; }
            .emot.emot-12 { background-position:  -54px -0px; }
            .emot.emot-13 { background-position:  -72px -0px; }
            .emot.emot-14 { background-position:  -90px -0px; }
            .emot.emot-15 { background-position: -108px -0px; }
            .emot.emot-16 { background-position: -126px -0px; }
            .emot.emot-17 { background-position: -144px -0px; }
            .emot.emot-18 { background-position: -162px -0px; }
            .emot.emot-19 { background-position:   -0px -0px; }
            .emot.emot-20 { background-position: -216px -0px; }
            /* /Emoticons *************************************************************************************************************/

            /* Transcript styles **************************************************************************************************/
            *
            {
                box-sizing: border-box;
            }

            html
            {
                font: 14px 'Open Sans', Arial, sans-serif;
            }

            body
            {
                min-width: 500px;
                padding: 20px;
            }

            [row]:before,
            [row]:after
            {
                content: '';
                display: table;
                clear: both;
            }

            [logo]
            {
                display: block;
                width: 350px;
                height: 103px;
                background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAV4AAABnCAYAAABIKSrLAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA2ZpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDo2RTQxODQyRjQ4MTRFNTExOTQ1N0E0RkY4M0E1QUMxMiIgeG1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDoyQjRDMDkzQzMxQ0UxMUU3QTYzN0E5QzhERDc4Mjg0OCIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDoyQjRDMDkzQjMxQ0UxMUU3QTYzN0E5QzhERDc4Mjg0OCIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ1M2IChXaW5kb3dzKSI+IDx4bXBNTTpEZXJpdmVkRnJvbSBzdFJlZjppbnN0YW5jZUlEPSJ4bXAuaWlkOjg5MEVFREFFQ0QzMUU3MTE4MTZBRDAwMUJBMDE1MzYzIiBzdFJlZjpkb2N1bWVudElEPSJ4bXAuZGlkOjZFNDE4NDJGNDgxNEU1MTE5NDU3QTRGRjgzQTVBQzEyIi8+IDwvcmRmOkRlc2NyaXB0aW9uPiA8L3JkZjpSREY+IDwveDp4bXBtZXRhPiA8P3hwYWNrZXQgZW5kPSJyIj8+LUSydgAAL/xJREFUeNrsfQecHMWZb1X3bFJAAQTSBkkgcjow0iObNUECabVa4OAId7bs3/l3Ptt3xr7zc8IP4wtO2ICP8wMbHuAzNjYYa6MAgVkwwQhhlmSiYaQNEpKQVmnD7EzX+77u6p6ang7VPbOrmVV9+rV2eqa7uqq7+l9f/esLlCgpOfnrrr6b4c8p+JkymqQaSZqfKR3UDNpjHpQg5FdL5z2p7pYSJfGEMbbfrp1Qt78EO4RBTqEabaQm2uIXCLpmTyEGtb4iGUKufnjA/GwdwnoooYP8c5JSLalpsGOQJKMWcFcktMH/d/5hL6s7rETJ/hUFvCU7GluIynE3C758n5LsZwufqakhM/Mc/McQwFFLdo7NpA2yet1mZx+k296hjPVoGh20rq0DaFMTrDViDN6hwFqJkqIKVbeg9OTyjr4nADEbbaClwoOiNPvYKN+n4sP0PIfmPGyvc8R99/Guc7qz9SCmlm3uA1Br1AJrQo3B/zpXgbUSRTUo4C1D4BUAzgFSSrOPLiqQeoGvUFzeOW7g9R4EsjUR65Gzz1g3tdRn/LLb+qjB18hXs0Gcdhl6IvnDs2dtVE9fiQJeJftFLgXg1TjwegGrG3y9QDEMfIPOETVlH63XVQ8J8PU5x6se8DoMwvc9WrYe3c7LQmiPRpmpZWsskfwPBdZKFPAqKRbwUsoX1wIBjPoDaQDlIEtThFAOoUBKfLRrr3PC6RIO7n6aNyOD8EWPcyy1KBEd1WzGeqimW2CdIMnrP6LAWokCXiUuaRE0Xho61Zfne4MohzCaIrwe3kAah6bwrodwvC/94tcu6lkeatYAyzZYAzBTR8tmTOvGpWeTBjFYz1cXz96leqYCXgW8kxx4ASwawwAsiO8tBuUgniNXj/iUg1zdhZYGlueuI/WhUvzuL/XVvOFDUmMsaVMiuo48tQXX/3LqrBtV71XAKyPKnKykO0YuwDCXSVnWxIwh9+lhYmbtsJwymAO+YhnMNRLnmKzxC4fXI7cmuWWQAPO43HP8644/8GM9fvOqE+PfeJUfdn8p/108B7aFjNKFNhgbBmmh1LDLV8CrREo0dQtKFHT9PrP8ffE4e595lMF8Rnp3GSSgDK96sLwyWE49SEAZXueQgLrbx3q3iwS0i0Vol3dF3PeX+NRJiRIFvGUOvn6zoXzAYZGBlLjKYD4IyQSwlgXSoH2vevgBuj/wMeKDjxHb5Q+kTDgwSjuVKFHAW64UgwtIg7RcL71LFkgDtcu86zJpILVrIquhe2myxKMeeYNRoObtbheLBKTMpceyAEBX4KtEAe8k0nmDXnR5wAkHUtky8JxCgTQYjFkgXeJJCRQA7kyqTsRXu1Z4q0QB7yQRIwQEgwGMRQbSKFP9QoE0mC4JB75C+F5GwmmKML6XSdBASpQo4J0klIMs3+uGD1kgJSSYF2U+NEUcII1LUxTK90aiMFz1CeJ7Ff4qUcA7KQgGOSANnlazCIATj++V452Lw/dKLXSF0C+5YB+HBiFSNIUSJQp4yx2AJYCURQIcvzKKw/cySSCNSlOEA59/+YHgHpFPDps1KFGigLeMEVfWVpcEgEUg31sE0y6pqX0AkEahKeTqwWK0i8Wz1VV8rxIFvJOfcgiy1SUkiDOV53uDKAcZmiK4HtGn80E0RZiJmaz2LgukQSZmSpQo4J0soBsApLImUFH53iDKIYymKKaJWSF8b1QTs4L4XolBRokSLynpWA1NrX0/JJQci587mutXHIjgKxubwSsmQlAZXrEZ7P1PHHsQWTSz0tz/9du7yZ93pEJjGATVwys2AwZasOtBXYDuXffsOXnHCfXIiefg8ZsYTMddPuXBH8LbJdx9dwPKUJra+jr5ALqzc1XD3ypYPMA1XngZlkC/vgQ6+4wDjWKQ1brGw6W4fnqCLIBtZpVGevemfaf6KDpGjTmogiRoNJdiL76XFZV33n8uxWUFuu29deY7hhulLypIVBovKhKLTYVCdQgPzS2raoVG2cqBC+oZmcs+8OBqndRNqzC/6gPQ3Z0yfDXj2QDMf3fsDHLyIVXkle2j5PZXd5I0o3kapVuDzANbqQhs/pHPxEhl7nOCfsvXmsMjn+W2yyqhnBVeSnRQbgzeME0B74Gu8V7S2n8qjMDV+NkgbMOB9FAMo/DYDHFdiuumJcjUhAUlfXvGfLU/3JYcVmOCLgr+rZ1aoVyKy62vMWOx/VnXyAH1ning9RCdZDsEM/QDciSOC6TBABbsUtwwLTsJQo03KIRk7dTcCZNRBCANpkvCgW+/uhSXZSdji/ls5NX2lbVDChIPeKpBW2KpKmz32pZ5fz6wABfBSHbxyfomb4odg6Yw+V1OM6D07h3LK0ekKTThWgP70mT7cIbXg+VkuvCvR/70XYamsCkHP7rETVOIC2f59Et+u6QojDxwL1PCgZIl1v2enLPKpvbeRmJoJ1KNPgsDy5+UxhsOP9ZIfIDyu9EWnwoLISn+Vs813g8ARE2Nl/jb976xI0Uy8AXSwN19Q2RfWqxH+bkU55YXXXsvN1nZPnAsvGGzLACepPwuI9cyyn6cqsgklcYbImf+prcGNI1TeM8+oAn/QtL/yJl2ZfeROmiYzhfW9oyRkQwLTBn09OZhkoTjMgYjHwxl8kyxvFIGyab/kTOPyzVLEzXjMBMz6cW8CCZm5SaGkVlsN5ZSY9JpvJd0sSqS7r8GWvjWIxc37Cip+Xwp3rDZU3SH3zUoPSAJ/0IM++O6FDdMT5jmYSbw2mZkJNi0C4/bMpQpeghJ7/vhrWXKx84dX5fi8mMZqDWrhEbWDNdPOgVHzwxcA8+oBj6+UGp1K0ngpRljidPRExUHtsYbafGpMJfiHH4XLRrGwaVYFkjL1aW4zAZ3i9+lbMMDV9LMpHt3DHYN7yMKeKVuGGX2SLxt7fLD/nKAIq5kepriuRTbFg0GI47jRFgIyWK4FHvXvvxcistP47XeM3jhJp1ys7yz72ho4AVmfya05IBXiuNd9nDvbPzrx5OsbNtyeIakl8KDrIXdWZTRJNW099pX1q6JOwVi1ofnvX5f+tCWQysr0osAIY5ghB4B191iEL23a1Xtw3GuN9Htk6EZvAz7i833imVUapTUc34XQRc3SvzTvZ/E7XdR/vxhKsdi4MTZldnf0N04pB5BLsXHzsqW9dZgKtSluDpByXFwDjqCTK/USAW0a1/aIJv3pcm7O1NkGFcDx9GleKLkgof6Dq7StSWEGnM1RuZBDfYYlG3VYNs7rWpD98cO3RsITK0Dixk17CmO53u2ouODI0g6fQTT2CKN0oMMxrbAO9fT1dLwarHasbJt8wkZYhwJbWiAe1zFKB0gOnuja0V9j997mkhPZ51NM3f6lXnhuh0ztKF91zBcX4BCjSr2tn2uS3aULPBe0tp/tpZif4CPOBWpyHkwa/ovhAf/TYOkz6VCV8T+yZhBVrT2vQy713euqu+UrdAlXZvnsHTmSN6hczrE8jW9p1ONfJqQ9KesF5cKsATXa+v9gFJ6Y8fK+tulrzfB7YsEvjnmUXEWn0hObAbqoZHagNMwXSfzpuhZmsGjHuI5Vxw53XQV3pUyyP95brv5F3+YVkHJp46fabobo9fbDX/cTvaMGY6JWZTYDCfOriKfOWmmuf/urjHyDgCvQbxNzGYAyDbWTzWB+jDeDregyRtaX7z64WggkIr1kjdZmyBNrr3376lB/8bS5gynP1pvATHNEKfuScG70PcY1OzRzua6mzynupqx2NbqNU3Lfc/a+q+mjH2aGGONOCe2F0rNy8BAtqK190XY/TwA8PNx29HU2vsFKPFKg2TOpE4buGEkvInwbj1nUPLNtc31v7fPqUjR/0HXZkL2fA12vye8w6dqhN0GD3QuvCNz2fBQDaPOu0oTKbq91Gb8oReGEXQJfyvecN2424jGHoVed66jqTLSBw9sl6C6/hVs7XATr5CtkJ5JO/wuMaj5YBufYAl42HdRjT4HhX6KX4uZ1yMsCdcc4Rc8DDrET6DT/bv0DZjg9smI4cstsoJjM/hN9Rty7HfTgTEMENhst+J+OHYwla3x3jFGtg1bdOFBAIaza/QcykGOLrHknNopzudnB4ZN0zUvSuAjc6rJ358wk5xXV5MDuikjt1S02rjq6IPISQdXxeJ7ZbMUj4c0tfddAO/AUzBY/NSeQvOL74b/34QPbg3wQtBoUwH8p/2ebYeZ25u2YtPU1tcD79R9cI1G/vsQQNi7BLVdp9/T0/BdNG1kI8olbX1nYDsAGG+Ga5wp1OgDuKkbhXfrTACnx1a09pvv+xW/YZVwm5daL0iu6RvVjNOssujhfDGt5CWcakDPFhw9KH2D72tN7f2t0MAVfP9FuIk/yFSyx+ypOvIrNMO+Dyc1W8+J3ATH/RZtVsIvpy22u/VYjf4cdgZtT/8dcI2T+Yh4l8H033YKtAIC89Td/dfCb/+Xuxl/HTrFYx0rG7pLrX1RNF5HC/OIHVBobAb3VB8tGhzgdWm87nqgyVkFH7L7BesHW/vbNpwmR820gBmn/MndY4J2nW9i5qWhn35YNTnxYItmeAU01Be2jnjW/VwA28sWTXfqi6C/AY7dCNfcMZohVaChzYf6nlc/hRwKgwA6fTTC5zd2jJI0C4/NEGb2Js4axk3Lbev7Oyj/Xsf0i7Cn4PP9qbHEQ49eNnerQ8E9smVqZSp9smGwFqhjC0tU+s7EYPaxmLftOXN219b/Wdi5jVNbg3BDbs4Q1vrwqoZXsrzpwAItw74E9+CfLPCmd8CfYyK040powf1CII02SrVfZfTaNWuX01H7XZ6yt281KDlfQyCFGedNyx7etnZ4bGAx1NUcVSvYlBxLJ53oj4IKtchRXDSjmhjG63y96DqdVbSXHfA6fCthb1ojb/8vbVCC0fefO1bV3+Y+p2tF/dvwpwVGtrVwk5fhTBYe7DegF/ybDOHPfbE2QCc6Es5fB/vT4Ka/THT6uY6m+mfd53R/jOLbfy9cA9rDfsa15b/Bn0qtfVKgKxPIhUSz1Q3jWW2LhqE0szTegDLqpopuxWN5dd8+kl0gP7hKzwfwELoEQ0WcLWi7z4C268Wlnt8whTQfPs3ZfxqOe6x3H9mTYhxcrOPR3G0H1Gn18TNIlU5Nzff42VUmoAcBqZvvzd7fYE+44mq6/Z+Dweq/+C4aS3+ho7n+J17HPrps7j748xzfvuJXZuMTW6exPamT+DTuWZghXget+BFvzO0VxrSvr7l01mB+v69FjfQLoBVjRLPLoNFHregYWNbZVPuIhMb+cbiH9/A7thPu4L90NTfc4/Mu3wnKzVNamrSB0nN0xejoP8E9n84fyJvuuoHGvinvWs4Ao21oXzn3fd8XrRSpBiTwoX8dbVVSewPj40JVr4SdUY1ql3WsqrstmDfQvyS08kI5Tc+aAsGDeQo63C/g+gi6jxN92vmdTXXPBp3b2Vx3lz0lgnqeIbNAMdHtiwK+/uEPWcHpf0TBRSjbcQK1XdRYg+phL8KJGq947W1DWeCdDRqvn1man3kcUgyLZljX+OOWEfL6h6m8uiP/u2JhFnS7kvvIQ3/ZY/LKXiZmf9k1Zi70iW2OmqU4zGSt2LKio/+sLOiyQUrZRdDHf1JoudP2ji7Oar46KhE/4lTaf3Suqv+sF+jmNFvTbs3yYtmYKr4LaO0DH7FBF66x12Bac1dz/T1B55jKjUau589nFZy5lA+KG8LfHebUacpQbUn6AQQCb3WltljoZNsBpL7INYnLZVb0YSSE6Tt7nT/hc2EaUR3c0T44Anlafj10ZzwBbvRa6AwXBa1i5k6hyNv8AdWGHTvR7SuEcpDhe+O6FKMZGYZ4tPldAY7yzkEHi3qu8X4IWiTGc3CbmNkcr0U1aD68qDffi4tkZ9fWOBztMwNDeUA6G8q8eOFUx9nj971D5NFN+0JNzMQBpVKn+UpPHJficTQpo4bx0+ybqq+Sos7kXnub34Wba/zCAkT2RZjdfVOqT9LEOyJ1Hg6Exn8L927V2lV1z8hcp2Nl/YNw8mvwbh2H2rU1kQ2PKWE7hiBN+MCVNFV2wCuOZlRjP+Sf/jd0gC7pzkM0Z1WyZteWIwIfkDG2WDhxOWqe0COui9imUdffkmlfVMCVD3/oPXuSTf8jLqxt2jMWCDgYNrKO2/ui19pQmuUBKQIvuhubwFuTiJSl+Jy6KU7UM6QO3uP8sHgk0hC2zfHL20dJR3KvT/tzZwazqrILb5ZmLN7DmFmKx0njXdHW/68w6zueg+JXYZD/Q/FmU45GOMVcjGKkvWNVw62y51emKkac/s/ISCDF0Nr3NbjG6fzY74IS9US00Yc8kosRITElGKPMibhWul6vIVYNbInQsU6C/+/3M08JAJAPHUJZZ7MDKyNMETjdcB2A4DsRp+gHu69bKu2LSzkQD8pB1rA/LN07yvzpLo+1AJqi3m394AE6yPFu51ovaqeoxcq4FM8DwD1nnqXtoqUEcrtuoJtbo5Mz5loTCzRaeLJvyLJ2IMGecNjRD6nJB95iuxQXQ3AFH9Djy3zm9gqA4veLqkkL/R7AcJ9GE5GUm7GK1Oys9utvC2taIvBZJNyjd0Cj/nrkulKa60BVEUwdrGzfgovlCY4fL5Qp8JJc/kbT/y36jcsCE3TSWSEHZzsEIc90NdffEb1T0WP4h7clDp/Y9sWkGYLT00Tne93gNJ9bNOwYNcgme2HNh6aoF6wf+vMCpedqvSaXWqFZPK/vdD57zrm1Nab9r63tot2tu66nAzBP5yYVz20ZNu17ZTzhzgVN+vCDrEHjPTjnTYHvzR2MWGyX4mLJUHXfPwBgzeFtv7mYfWp559a5AEgLs32efru92WfxyX9merzQbF/FaF9NH66BHMLBPhY3zQy2VcCEl2zrB99JLMs473SGGOWn8a5sH5gPTa3NjozsJovTjC+GQcdCkEbgXNnt0TtV39FoP85r/HrwyLgf2hdXy/WYphfLpXgOaIHiwpqd6sePphA1XjOQjg+Q5vC8cI0wl+IjZlSY4IiCXmZP9w/lHZeA3nqc4BX33OZhKS3/7Npq0wLClpe2jYTfw5guxUUaca/gF90CU/N7i/rCG2OCtstGNKMy8numMXJSFhj113yVEkY/zo/aubmuPhbwYjYq4b5LAKkzax4STeFKTXzNyTIss0TMJjVWRb4bD43YXMfshhq+q6UXt/ae7IAmY+/B9Oq+yNfK0NPs10WjNPCmT3T74oCvvy1p8VyKkWaYwlP9OPyuTxnojmtzq5uHMjmB0t0uxeJC1myBW/XzhPsogG4lVwP+ANruTtC+qcs87rhZVY4p29s7U2TjnrRzvrseuHaGJmMnHFJl2gTb0g2AjpYShBQ/S3FxNNK+o0FVO4dPp9qKT13huobt1UVvb2uesycGGp5mA7dfkoKm9t7/xZiVIRyu9tCLi+MpJfAk5goDRfjCGrdPpiUYkUwKeDWiLbY7E/TD38aOZ0kBmPiD1jRtl99hOsk6TjCN3Fkwd2VUrA9W9Se2fZGwHOqlcSD1tyUtjkuxmOpn05580zAxawUuws3hPCnG6x0zHJ4wD0hFjRe51aC6Y9yHMzlvi2Zff+gf9gT0o2bmxm1AygHtctFCAUF7BgD8oVN0S4uHutYLbcNyHtm4j6zbNJQD6NTlAkwFHT+WS3HBGik5n2X7QWuxX/is3TrUXSe3xyxmCS9svT/Aa5c5d47SR+JXmB1n312qBacAE+2TWYnnaUz43zj06HJQ6tcFPOq5whRlYxBoZo2e9XUxh/PFllcUS7atmjMQfOjEti/6SM9y8tfKpafJBpfx44vd6X/EhbVNwsKaV3DxHO82zgX7xTDYNpQF8YOrdU8gtet+Xl2WBkBt13b1dddjruC4gd5n5zdMNYP7VISsVGAG5D9tGzH/xslSTKRnHkVRSU+zS01Qvehamx0KEoODd1qOQJHkkq6+epYmDbyw9QHv80eZM5hUPVLA+3UWr/loWOoetE+2Q/ej40RZAq/lQWZ2xVTHyoYHC7jGMbxDvdHe7J9Mj5ncjHm9gc6m2nhh6nj+KPiwXkI7ntD2RXw5PIGU+UyPC3Epns8XnHAha5O4WOZBU+Tyu2OB9UCNF60bDgHQxcU1r4AyeNyZc2vIX/FIZxi8Bu12qYdLMdIh8wTgnR6AtkhTJ3enyMbdafI2aMbvwiabtcKdVSKqS3ERdNKP8FlEH/Sn7cV82WH6fxTU/RB+H2IpN3pGc9LBB1kNQPmn8unC46AE7YlzLdOu3xibz3mRUEwQww1k9ET5Ae8lazYfz2hmBp+aPBe38BUdW05kRvpIawQiPX7HodnJEO0/jXe8dfGuNXAaMYyqsJF4f7SvEPAtJt/rdilecFDCsWhAmsGOdeMH4DYtgV/37kkHujZj+EX0YEPgRaphVpVGBkeNnHN0LVfbfap/yLf9CN62kwfWdftw2qQ6xkA7xg3thncC0OM10D14G3dbph78rOeA5kGXeFE4QXxvkWY6R/IYXW8V+2U3AJioTa9RLd6s0jCWODOAhOb5nuF6DVyhit+s12IPQZmxlmzUMiLhOGGHGyBbSz2Otyfw6nrGCRlnB9GId+PSS+0bZxD6lN9xQ1MGFtshuaAzPxHrWszIUhWaFgi8E92+GCSvaW/ijs2QO7pH53vd+/NBg7X1xo18Yc2PppiZ41aczqYGCqgHar3Hwd+poK0i3WAumAnnNALo2sF0cMHrpW2jTuPcISSrE9mKjQLI3vn6Lqeu1Jle5rbVL0ux3D0kkbMUFyqggOhDpJ9H/DGjjhVV0E7e7q+pSv33BVEVoJF3WrEb8t8voi0kzvoJ21wAv3uVsxAowdla4QZMpaPk04V5zteEkHHY5V4p4MYtyz6NylZ/AMum+slk9Fg3TfTPrh6eFwi8E92+2CqvoHVFT08T7lLsx+96mVEh6M6otN2Kx6zyhWO86iFaNhxckxssB8v6KNd20QECtd0gl+JqPdtVRzJGHh8eVHenzTJeZ0XIUhxXdiT6Z2YHDbqr2C+7HQcFnTJ4QJ04pYQurFGNzcwiDN0S5ypmoHbb9ReL0YJxobn1g8PMaGaW5luewIsmGdn7psUasTBrA9y4i/juY10rDvV9AIzaSffYLj/zlPBpBl1i3/Qw/+yJbl8h4CtvS+oDzAFl2MCbNrgpWUAZ9SFhI/PqAR+25sRsyF1gQ4rBtjp4EkD3rZ2pvDJEl2JNUCkTXBuWAVLZ5JosoC2yLsWFik4S+ni+7JQ7DMVd8cdsEfDyHMTLeMF/wpYFXsOgsd4vSjNiAKpBO2aw7zW11GnO5zJIkJvwUB0pa+8XPbpiEfwGSX8uqxiye8M6hNXR492w5tZt0zNk9CQZfnd/tC+usuvH3frbkrq5Sn8TM5y62wtrCLoWdUB9s1bMdzlOiJYRfrzzNhfw2ini507Rzfi4KJidAt1+g027CNk3ltVyayqoT/ujWHXI3kN5E7NCBWPrNrX2YRIJLHZOMfsUZmmAnl/Ne0Usa4kMQdt3R1ta76/NaVXOLISyyEk0Meg7PJOrBM1MYmGNnuJ8TljrLS0d/YHnXNrpafiE3qfnw9YIG3ro4eI5hsHDNSGchWBgEOTfUUF8ErbHYdsZtY15Gm9TR98Sc/C1AYZlDo1a6LKHt82D5n+ed8xXg5whMBcS45YBcY2eAXQXC1ObQOCd6PYVDMABHlKFuBQvAG3XTvWTDYzjH0LS1niRXxWtH/win9kmZZiRAuUQQeNFisFeKEPQ3SSElvTzhNs3lr0OWjSglcN4Zyn2nl0EuxQXgQ74gP89tJh9SSdiQKh4plbUtt8FGatOrPdXSgwHiHSqzYh8DwzyDdcMVWZh7QRbkVq7vL4vRvOQNvwdbO/B9knYkrB9BzY0Z1vAx9gFfB+/Rzfr1fz4Nfx8Ght4LZOMnCYdHlmNTo38EM6r5HftlsBj07rAt7KYHUJwnCDBC2sT3b542rQckIZN9YOmxPMF6mBjCJBi5gZb40X7XQwsLhP5DBfTtnOe9xDuNlw/TQfgtQLhYDndfcMSdAkjg6MZR4NG7XkRd6aQBdJiZSmW4XsLogMo4Ykk6RKYydUWr1fZoSBZKra5JnGyf/cEccTUEALnGKwuyhVWtPXdZKYdYqRLAHKJGLx0EceCZMRGYfohxAyMidEB20LUz2DDaIWPoV7CNV3C/27i3/+IH4fHt/Pzn+flRQdeSnIjhMF0cnmkG2fmSKJX8bJaO1bW3R2MMtmReIxpMQ3GbX6XfBjGBU14+wrUeGVAIIzv9QKjBcLCGrreBgEpLqzVcKuCXjcXHFKPrU6UMt2MVIbcrm2Di9oumn0FR2CzZF+amTa5thwDwCsLpFH5XhKT7y3OM9ecRdo0HV1ZxJLtUImx3rHTNrAK+z1jNJjOYwn6XpYlYKdHe7eIze1m6Ttdl3AVtmYI8Hw+lLwc0i4YJxht+FF5OhG2uwSQlZVd/LwTeTkP8nKrI2q82VGNMoYTvMswgrwUN9Paey2ceKdNiKcM7Z8ltFX7en2PttT1xupSjuMEC+1UE92+2IArEYQ7NIllABgt4PwuUgFJl+OEux7zcxbW0p5g5Bf5zNZSkRrAeLhn8rCPGGe3W7TbDcy4YWm9b+/MAi8GvTlhdqU0kJIAICUBmrF/KEu5EJLRNV6jVXg3/hP65iGFlnnmb3pr4B05hdc11qxy7paBJUItA98znpqdr52w5Zd0sapw0O37x+y7ZYKvFeeBsc1dPmZrLhDgndRa/AsR9LxDM9I5nMf9JXHlmI05Uf0lL28OL79BCnhxkQqe/IlW/dmL8Pl3llKawQ4wJWSK8A1G6f9wUGNQi2tlgNS2C4xLMzS19+JUhnu3BI/E+6N9BQFwSPofWb7XbWKGoRdtjRdpBoydGwSkuRmIx6Qjn7lNyk6dU+1ou5hm3Qmi7kMxuKfzf9wyTF77MGXzjeSyI6c74BsUOxcDq69YOJVcNH+KFN8bVg/mW+HCpWNlQz8UysOT0lmMZe7DdRCZc9EEy+v72VN00YonlsYrmnwyw1gvccojdhv0sf4vhyg034IHamepuLWzuf4WK0aDORLJ0SLUSvlFKVkUAvRY7tMcJK+MoeHKaMBX8vKf5tfLpyvFnZxFKrPB7E8wklwJn5cyZjy2orX3ps5VDQ+JQAbToWtgVLoGdu006BmDaCvXNmezAPt2lM6BBXB0bSFTIEp0x4URhpHADjHR7StU6/VyZQ2KzSDrUrwAgNSOe4vZeMOyFNsaL2rHjsYrEfkMZauQf+0sru2+9uGoCbzWY6B5Zfi58mIIh3Wb9pJjZ802Q0RipLLVx80gf9o2Sl7ePkJ2jRpkTypj5lObWmENLocfVEmOP7iSVOuUtL+/Nzuw+CYGje9SXCzpbG64YUVb78U4tUeTxUSKPbm8vfdnCaP6brf7LboBE0NbBnW5lJEMLlLXe4GmXb+MFi9GrW3yienku1oaXg0nMRPfI0b6Wj4j/XZTW//UscrKHz9y8RzTvAwXqCtGR5rg1n0Fyj7Cwk56Z8eqOh443Uz3I23pxMxMMKbn2qFauv+7UM8vkc4BZ1gcNdgZGmXnVlANMyTfANvdZHzlB1zrxwEIF+T6fIHXClRDOfWqbehaVbthRVv/t6BB3zKTR1L6IIATvHn0fYyTmaGjsykfZvhDeYToFV/uapor5yaYyTgh6oyYpmQGM4SFNX19CK0xse0rAviGgVEwCHq7FNs0g63xBoERugnbHmtozYCcrGxMCNuWFx0kMEyjHdns97b5GKcQKPUzD8s37cKElfe+uYtcvmi6OXggyJ5XV2NuKGieNhVQWQswKSOh9zCeS3FRRZt+MTX2/tzKeE1PgOvfAv3xFgDknXDJLXDN6XD1wxijFVblTBnwBk0rDgqugcQJjMNneRZ4U7peavCAdwRmiZis8t/5ffpKIjX6FdBuN2MULJYaPZTl2v19B0D3G8IFjzXrTOUGCuhjd+tmmjBz0RszIf9DmtA3iZUsdy70h2kAuqgV3zoBoGsLXgdzSOLiGy66jXhSDbanCHKfCErW6Fv3bXisV6G3C1dREph4Dh7C7CygEXQ//Axoi5d0RgAljWQtDCqNKXEjMdkujG+3rwwOKjLR7YuPuEYw3ysRhDuIpsAYDbYkd495nkMEftdOKtm7Z0ySM82WsnUonWPP+/yWEbL+gxFfIPSjS8SPf9w8TO768y7TxdhdBlIZIugim4H0xH1v7nbSxIvcrnyKHyJtYlYUrbdp5s6O5npcXLse+qsQd4DOwuSP0D/rAbgqhMr+TqP65/1AU3YNxEuQZ3aycROyXroNzfX/iTkMCTeR45rzPNRKhRv5OPT2s+BYB3SXtfYeacd6SI1VSAHvw6vq3gI8vxrauo1fpxp5bbjWkZipXKem1Tniw/fIxArG+Ua735tylUBx2tLW+56ZFoSR5zpX1Z+dx3N2DJzLDGMhaI616NII+NBrVFS8GTcgBaYhyRLy8Ty/opQx0e2LK+c8kHyCUq3R/ZDEWASU5GqblOQ6DlBBUafig4YPdmBwPGfD1hHX4k7uOZhm3UrdQ8lI2iCv70h5xkSgHte1oyicOqfKOQYzXGDqHZJ3DpWqO825H9Ss3zGzKk0X5Bk84Pow1HMYEBcjqPXtSZPNAP5B8Ry86557T73qIZ6Dx37n7Dl0vPpEU3vvcoPRBpyEmNouM3YCuAxqRH8JkPUFUDqGJuI9w0SXYenfPc9v67+aUGMBNSiux6DWOwDa7MMWp+1/vaj1xUzf0/b2XwmD4tGAtOj48AEGu9M1igvhx4wDpysjaMuMDhd/TaxFt2xfQs4FpgL9fIT8cceq+uvIJJJyat/ZCLyENkYBI2nwzdmPCkY0r8zgc2hkICV5gJY70LjLEENIRgVS9znUNfj4gq9nPUC1OftQSpSUjHDPNXwmz3OK4b79WB3ku5FfPiOHaqgYSwkrouyFyfYQyrF9YqCYKLEZiM/+eGUp9q8H86dLPGkKFmmqH1b3/PYHJwZlse6hkhKXpcRy+f3Vfq4HXh9N3S7KAV4rF5MlRoJOOuAtp/YZIWAkA6TynCkrGEiDOVMWGUjD6u6XpTgOkBJSXJdiJSUnnyGWF5pRAq811uOzOcAr+GFv74q58lnKUo7ti7f4xMY9S7GcdhnuUhwGpL51J/kuxYXGZiiGS7GSkhMMeNMI2wOu7xv5ZgtGU0MTM4wFjrb9LT7lrebHOmwGP6/R41g87jpeJm7oUvwmP3ZWVuO1V/xLPDtnfBArn/axOGBUZJfiuEAahaYIAlISUAaJGA5zIl2KlZSUXADbM7C5g8p/Abbz+OdTODCid9yNsPVw8F3tUd7N/PiZ/BwbdE/xAGgMorOAl3kj/76DX+cC067IMt+wcjFB75p0wFuO7cu3kWWezgb2/niGkJRJGR+UlUEMIRlej7jZIvKzVnjXQwDfmCEk/eqhpOTko8QyBfXSRjdywEQw/RhstqVGtwCy93icl+S/4WLdGh+t2C5TTAeG5bZywL7c1Hh1qokZGSYd8JZz++IvPhWf75WJzRBGU8ja6gZp+TI0RXA9ZLVcOZpCUQ4lKxgewCvDzEIOtAiQlwqga8utHGRFCuEUgaZ40gd0FwpleuVg7OYaeKMJvJqQNseo0NdPtrtfru1jBS8+FZfvJRGANApN4V+POFYdrOD0P7H4XiWlKDjTfccHIG/gFICXTfKgj5ZMOEVxj8/1buCA2x1QJwycfojGOxP3wybvrF0+b9tku/vl3L7x5Hu9y4iz+ERCASyoHsFpd6JYdYTXwwtI5a06AgY0hcClKOi4sNMDdIkEQBKf84JyK7ZwbTlI0KY4YQJvNgcZm5QLa+XYvmAQYJGBNAzQSezFJ38Ts6g0RZiNbFSaQhZIo9ElAfdQSakJ2s3u9gHQqOm6cKEs6UMx2BTETAkwNz0MteWdfejPbEYYYRqZdDRDObaPGUUAgXHIUiwLpHKcaXH4XhmaIuweFjVLsZJSkt0cfN3AmwwByFMErVg8rztEIx70oSlEQYeOTIIyTaeUrcJvjIz+l8l258u1feHWBLlWDnFCSMpGPguqhzuEJPU5xz8Mo1woy2hWHdnIZ0RwKQ6O4hbHqiM/hKSSkhKMyzDLpfXammuQNHLQHYwAvAuI94KaWzDpwkiC5196cbLe+XJsHyq8mhQIskjxbMPBJ7qJWRgIypiYRQFSdwjJIBOz6ANJLpBSDyU8LEuxkpKSd2E7ilimY26NN0g+4UFFLCTBAXZ2CTSGnyAVgcG53tPUsylRjZcQSdOu+C7FUWmKA92lOIymUFJygiFcT/ahGvykhR9zj8d5QRptDz9mZsAx6LiBKVSeVMBbDpSDNAj4g5EXkOaBpw+ARatHCbgUs/FxKfauu/+ApmS/y1Owne+hdS4M0EgxePkXXTSDDaZB/G03B/TVPr8jb4wuxG8r4C0DrVcOBJRLcVj7vcC32C7FSkpOHudT+4NcAGiDoCiNsL1ELKuFezxAk5BwDhcB+waSH+sB99Fj7evESuL5uALeMgHfcBCIbmJW7BCSYYAeh6aQDcMYJ4Skdz28ZwayNIWSkpKdXBO9wqW5fpJYi2E7OSAi4GJ8hlv5b16asEzw9zX8fPRee5+X/T4H40s5zYD12ZlQz6ZMwNdnASf+4lNurrBsDjSSs/hEXOfILz55x2YQ9/NjM+SeIxObwVXFAKuO3HOC60E876Fzjqn5sEGD0m5Lc9G6VS8tWbmdA+HdLs0VtxuF77pDAHWN5PXsY+1gOkm+YVf5CbF4XqKAt5wAWNq0KxhIC81SHAVIg0zMZLIU+wEpIXGtOqRMzHrgzyDUpAeOHCQa/tUHR6foPT9dPHuX6ollJY/Chumlr4Ztn0tzHSTRvNeiiJuWwOtjhuh1CnjLTOsNM48K0wRlgDRK5DMSs4w4kc8IkTcxk4h8ljQYScJ5SdhPMoMmDQ0+ZwBYL1LAOglfHdQyH4Tt50TO1rbYgq7L3xcoDwW85Uo5BNvIFieEpAxNEQ6k3ra6JAZNERZCUoouYaxHY1WNP1MAeyAJJphEDvcyYiWdnGi5g9MPz9pfqMW1MgTfosQVkAgh6f5c7i7FBkwrdVLdqLTaA1K+TCwvtrEJvu5XiZXd+F/FL5XGW64APFldihnyq2xQozQJx8NGkjrSApUs+csLajde/fDA7zQ0z4nK9zJyz90Xzfuk6jkHrAwTy10XtU4vz7TxkNXEyrF2Fr++At5y13rlQLAkXYpNiwCKAEvpoLlPtcFERVXPAyGa6BXrdsygmZGWKC7FZnsRdJcq0FVC+mBbBtvDsM0mlrXDeAna9F7Hr9fn/lEBbxmDbxDfGwZGYUDqp1178b0uE7NuXlI3PxY0WG1wuLqq57ECp/iJ9GgLk4jNIO4j6N6rQFdJVt6A7RzY2mA7E7ZPk+AYDFEFF9J+CtvRxEo9tNGzL6vnUP6Ug5xpV3RbXR/tupvvWsBK8S8jXc0NT453Ww3GWjQqb6sL33/r5xfNu1H1EiUu6eWgi+nWcbEN+d/7SWEp4HG97CrYfkCshTSkM0Z8lQj1DMqfciiE73XAGRefKBsEyO0BTXLQoKQHvh/UmGV+8+il4w+sYTQDSY+0MElbXWjH6p8vnXev6iVKfARB8XOw/QK2W2C7ngPxgxE1YNRwLyfW4hna6aLJ2LOhszd1/ycH+OaDD/Hge9EpgJrOARr8JcwYNDStJ0Ho4BOX1b9cyu2k6aEWVCrCeWeT5lh93zIFukqkBE3NToftIg7EN8H2NLHcfTFR5lsciO2g6gi0aKWAUc8wk/C5xJoFIp/7qOxFFfBOEvA1wYiwJEyvk/ApCTvmZ2poSarryWcvr91Y3o2kLYSGuxQr0FUSU9bxDU3OLiBWUssmDrLTOOju4RuC8evEsoz4OMnP6xauSKj7XXqy5P7kE5TSxnyAZaClopsjTVJq+YAzqiXTAKwvlTuwhtAMdGx4MMtlW0uA9r75GWMnaFrLr5bOe1L1ICVSY/l+jHCkNN5SnFZTeg9OXwxGe6hGBw0ytefFKw9co38jPdSiu7zrcq062GCGJBp/vfSwl1XvUVIW77i6BUpKXS7v6jedJqgzMGW1XtBaBokGoHuxAl0l5aPxKuBVUvI0A0OaQeiwAuWQJFRvUaCrRFENSpQUk2YYHWoxkdblCQfSwyqqGx9QcReUlKGoIDlKSlsobbG0k5zAOwC6NQp0lZRvt1a3QEmpCtIMRmp4MIvBprbbQysV6CopXPYn1aA0XiUlK+nRoRZXCMk1CnSVTAZRHK+SEtZIaIvgHnzPQyvqVLAbJZNCFNWgpCQFaYaxUcuaAcBXga6ScRjYFdWgREmOIM1gvhxK01UyCUUBr5JS1UZaCDOuW9OkQFeJEiVKxl0uXLdjRnNH3yfUnVAyzoP7ftv+vwADAAzFOeDxncmyAAAAAElFTkSuQmCC);

                margin: 30px auto;
            }

            h2
            {
                font-size: 16px;
                color: #0879B1;
                text-align: center;
                margin-bottom: 20px;
            }

            [participants]
            {
                line-height: 1.5em;
                text-align: left;

                margin: 20px auto 0 auto;
            }

            [participants] li
            {
                margin-bottom: 20px;
            }

            [participants] li:last-child
            {
                margin-bottom: 0;
            }

            [participants] b
            {
                color: #0879B1;
            }

            [panel]
            {
                background: #fff;
                padding: 30px 0;

                margin: 0 auto;
                max-width: 600px;
            }

            [panel-body]
            {
                border: 1px solid #eee;
                border-radius: 3px;
                padding: 20px;
            }

            [date-info]
            {
                text-align: center;
            }

            [message]
            {
                border-bottom: 1px solid #eee;
                padding: 16px;
            }

            [message]:last-child
            {
                border-bottom: none;
            }

            [author]
            {
                font-weight: 600;
                color: #0879B1;

                float: left;
            }

            [time]
            {
                color: #ccc;

                float: right;
            }

            [body]
            {
                font-size: 12px;
                line-height: 1.75em;
                word-break: break-word;
                word-wrap: break-word;

                margin-top: 10px;
            }

            [files]
            {
                display: inline-block;
                border: 1px solid #ddd;
                max-width: 100%;
                padding: 5px 10px;
                margin-top: 10px;
                border-radius: 3px;
                clear: both;
            }
            /* /Transcript styles *************************************************************************************************/
        </style>
    </head>
    <body>
        <header>
            <i logo></i>
            <div panel>
                <h2><?php echo $app->trans('talk.transcript.time') ?></h2>
                <div panel-body>
                    <div date-info><?php echo $vars['dateStart'] ?> — <?php echo $vars['dateEnd'] ?></div>
                </div>
            </div>

            <div participants panel>
                <h2><?php echo $app->trans('participants') ?></h2>
                <ul panel-body>
                <?php foreach($vars['users'] as &$u) { ?>
                    <li>
                        <p><b><?php echo $app->trans('name') ?></b>: <?php echo $u->getReadableName() ?></p>
                        <p><b><?php echo $app->trans('mail') ?></b>: <?php echo $u->mail ?></p>
                    </li>
                <?php } ?>
                </ul>
            </div>
        </header>
        <section>
            <div panel>
                <h2><?php echo $app->trans('talk') ?></h2>
                <div panel-body>
                <?php foreach($vars['messages'] as &$m) { ?>
                    <div message>
                        <i avatar></i>
                        <div row>
                            <div author><?php echo $m->author; ?></div>
                            <div time><?php echo $m->datetime; ?></div>
                        </div>
                        <div body>
                            <?php if(isset($m->extra) && $m->extra->type === MessageModel::EXTRA_FILES) { ?>
                                <div files>
                                <?php foreach($m->extra->files as &$file) { ?>
                                    <div file>
                                        <?php echo $file->name; ?>
                                    </div>
                                <?php } ?>
                                </div>
                            <?php } else { ?>
                                <?php echo $m->body; ?>
                            <?php } ?>
                        </div>
                    </div>
                <?php } ?>
                </div>
            </div>
        </section>
    </body>
</html>
