//
//  EditEnhance_f.shader
//  BeautyPlus
//
//  Created by Webster Wu on 2/18/16.
//  Copyright © 2016 美图网. All rights reserved.
//

#ifdef GL_ES//for discriminate GLES & GL\n")
#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif
#else
#define highp
#define mediump
#define lowp
#endif

// texture to draw
uniform lowp sampler2D inputImageTexture0;

// Uniforms related to sharpening.
uniform lowp sampler2D sharpenBlurTexture;
uniform float sharpenStrength;

// Uniforms related to structure.
uniform lowp sampler2D structureHistogramTexture;
uniform float structureStrength;
uniform vec2 structureCountTiles;
// Vector containing LSC texture pixels width, LSC texture pixels height,
// LSC texture height for 0.5 x one y pixel (0.5 / lookupTextureSize.y).
uniform vec3 structureHistogramTextureSize;

varying vec2 texcoordOut;

const float kStructureLookupBlurFactor = 0.066667;

void main() {
    vec3 color = texture2D(inputImageTexture0, texcoordOut).rgb;

    // Perform sharpening.
    float sharpenLumOrig = color.r * 0.3333 + color.g * 0.5 + color.b * 0.1667;
    float sharpenDLum =
    sharpenLumOrig - texture2D(sharpenBlurTexture, texcoordOut).a;
    color = clamp(color + sharpenDLum * sharpenStrength, 0.0, 1.0);

    // Apply structure. For the lsc histogram lookup we mix in the blurred
    // luminance to reduce edge artifacts.
    // float structureLookupLum = clamp(sharpenLumOrig + clamp(-sharpenDLum, -kStructureLookupBlurFactor, kStructureLookupBlurFactor), 0.01, 0.99);

    // // Structure sample positions. One histogram is 64 pixels wide.
    // vec2 tilePos = texcoordOut * structureCountTiles;
    // vec2 low = floor(tilePos - 0.5);
    // vec2 high = low + 1.0;
    // low = max(low, 0.0);
    // high = min(high, structureCountTiles - 1.0);

    // vec2 lookupX = (vec2(low.x, high.x) * 64.0 + 0.1 + structureLookupLum * 63.8) / structureHistogramTextureSize.x;
    // vec2 lookupY = vec2(low.y, high.y)  / structureHistogramTextureSize.y + structureHistogramTextureSize.z;
    // tilePos -= low + 0.5;

    // vec2 resultYLowYHigh = mix(
    // vec2(texture2D(structureHistogramTexture, vec2(lookupX.x, lookupY.y)).a, texture2D(structureHistogramTexture, vec2(lookupX.x, lookupY.x)).a),
    // vec2(texture2D(structureHistogramTexture, vec2(lookupX.y, lookupY.y)).a, texture2D(structureHistogramTexture, vec2(lookupX.y, lookupY.x)).a), tilePos.x);

    // float lsc_lum = mix(resultYLowYHigh.y, resultYLowYHigh.x, tilePos.y);
    // float lum_new1 = sharpenLumOrig + structureStrength * (sharpenLumOrig * 1.4 - lsc_lum * 1.484 + 0.042) - 0.5;
    // float lo = sharpenLumOrig - 0.5;
    // float saerf = min((0.275 - lum_new1 * lum_new1) / (0.275 - lo * lo) * (1.0 + structureStrength / 5.0), 5.0);

    // gl_FragColor.rgb = lum_new1 + (color - sharpenLumOrig) * saerf + 0.5;
    gl_FragColor.rgb = color;
    gl_FragColor.a = 1.0;
}
