; **************************************************************************
; === Define constants ===
; **************************************************************************
!define /date VER	"%Y.%m.%d.%H"
; !define VER 		"0.0.0.0"	; version of launcher
!define APPNAME 	"Calibre"	; complete name of program
!define APP 		"Calibre"	; short name of program without space and accent  this one is used for the final executable an in the directory structure
!define APPEXE 		"calibre.exe"	; main exe name
!define APPDIR 		"App\Calibre"	; main exe relative path
!define APPEXE64 		"calibre.exe"	; main exe name
!define APPDIR64 		"App\Calibre64"	; main exe relative path
!define APPSWITCH 	``	; some default Parameters

; --- Define RegKeys ---
	!define REGKEY1 "HKEY_CURRENT_USER\Software\Trolltech"

; ---Define Local Dirs, SubDirs (if any) beginnig with back-slash and Portable Dirs ---
	!define LOCALDIR1 "$LOCALAPPDATA\calibre-cache"
	!define SUBDIR1 ""
	!define PORTABLEDIR1 "$EXEDIR\Data\CalibreCache"
	!define DEFAULTPORTABLEDIR1 "$EXEDIR\App\DefaultData\CalibreCache" ; can be empty folder but not empty string

; **************************************************************************
; === Best Compression ===
; **************************************************************************
SetCompressor /SOLID lzma
SetCompressorDictSize 32

; **************************************************************************
; === Includes ===
; **************************************************************************
!include "..\_Include\Launcher.nsh" 
!include "LogicLib.nsh"
!include "x64.nsh"

; **************************************************************************
; === Set basic information ===
; **************************************************************************
Name "${APPNAME} Portable"
OutFile "..\..\..\${APP}Portable\${APP}Portable.exe"
Icon "${APP}.ico"

; **************************************************************************
; === Other Actions ===
; **************************************************************************
Var LIBRARYPATH
Function Init
StrCpy $2 $EXEDIR 3
ReadINIStr $0 "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "Library"
${If} $0 == ''
	CreateDirectory "$EXEDIR\Library"
	StrCpy $1 "$EXEDIR\Library" "" 3
	WriteINIStr "$EXEDIR\${APP}Portable.ini" "${APP}Portable" "Library" "$1"
	StrCpy $LIBRARYPATH "$2$1"
${Else}
	StrCpy $LIBRARYPATH "$2$0"
${EndIf}

	CreateDirectory "$EXEDIR\Data\${APP}"
	System::Call 'Kernel32::SetEnvironmentVariableA(t, t) i("CALIBRE_CONFIG_DIRECTORY", "$EXEDIR\Data\${APP}").r0'
	CreateDirectory "$TEMP\${APP}PortableTemp"
	System::Call 'Kernel32::SetEnvironmentVariableA(t, t) i("CALIBRE_TEMP_DIR", "$TEMP\${APP}PortableTemp").r0'

FunctionEnd

Function Close
	RMDir "/r" "$TEMP\${APP}PortableTemp"
FunctionEnd

; **************************************************************************
; ==== Running ====
; **************************************************************************

Section "Main"

	Call CheckStart

	Call BackupLocalKeys
	Call RestorePortableKeys

	Call BackupLocalDirs
	Call RestorePortableDirs

	Call Init

		Call SplashLogo
		Call Launch

	Call Restore

SectionEnd

Function Restore

	Call Close

	Call BackupPortableDirs
	Call RestoreLocalDirs

	Call BackupPortableKeys
	Call RestoreLocalKeys

FunctionEnd

; **************************************************************************
; === Run Application ===
; **************************************************************************
Function Launch
${GetParameters} $0
${If} ${RunningX64}
${AndIf} ${FileExists} "$EXEDIR\${APPDIR64}\${APPEXE64}"
SetOutPath "$EXEDIR\${APPDIR}64"
ExecWait `"$EXEDIR\${APPDIR64}\${APPEXE64}" --with-library "$LIBRARYPATH"${APPSWITCH} $0`
${Else}
SetOutPath "$EXEDIR\${APPDIR}"
ExecWait `"$EXEDIR\${APPDIR}\${APPEXE}" --with-library "$LIBRARYPATH"${APPSWITCH} $0`
${EndIf}
WriteINIStr "$EXEDIR\Data\${APP}Portable.ini" "${APP}Portable" "GoodExit" "true"
newadvsplash::stop
FunctionEnd

; **************************************************************************
; ==== Actions on Registry Keys =====
; **************************************************************************
Function BackupLocalKeys
	${registry::BackupKey} "${REGKEY1}"
FunctionEnd

Function RestorePortableKeys
${registry::RestoreKey} "$EXEDIR\Data\${APP}.reg" $R0
Sleep 200
${registry::Unload}
FunctionEnd

Function BackupPortableKeys
Delete "$EXEDIR\Data\${APP}.reg"
CreateDirectory "$EXEDIR\Data"
	${registry::SaveKey} "${REGKEY1}" "$EXEDIR\Data\${APP}.reg" "/A=1" $R0
Sleep 100
FunctionEnd

Function RestoreLocalKeys
	${registry::RestoreBackupKey} "${REGKEY1}"
${registry::Unload}
FunctionEnd

; **************************************************************************
; ==== Actions on Folders =====
; **************************************************************************
Function BackupLocalDirs
	${directory::BackupLocal} "${LOCALDIR1}" "${SUBDIR1}"
FunctionEnd

Function RestorePortableDirs
	${directory::RestorePortable} "${PORTABLEDIR1}" "${DEFAULTPORTABLEDIR1}" "${LOCALDIR1}" "${SUBDIR1}"
FunctionEnd

Function BackupPortableDirs
	${directory::BackupPortable} "${PORTABLEDIR1}" "${LOCALDIR1}" "${SUBDIR1}"
FunctionEnd

Function RestoreLocalDirs
	${directory::RestoreLocal} "${LOCALDIR1}" "${SUBDIR1}"
FunctionEnd
