/*
http://status.calibre-ebook.com/dist/win32
http://download.calibre-ebook.com/2.50.1/calibre-2.50.1.msi
http://status.calibre-ebook.com/dist/win64
http://download.calibre-ebook.com/2.50.1/calibre-64bit-2.50.1.msi
http://status.calibre-ebook.com/dist/portable
http://download.calibre-ebook.com/2.22.0/calibre-portable-installer-2.22.0.exe
*/
; !define TEST
!define RELEASURL	"http://status.calibre-ebook.com"
!define DOWNLOADURL	"http://download.calibre-ebook.com"
!define MSI
!define DLVER	"MultiVersion"
!define APPVER 	"0.0.0.0"
!define APPNAME "Calibre"
!define APP 	"Calibre"
!define DLNAME	"Calibre"
!define APPLANG	"32-64-bit_Multilingual_Online"
!define FOLDER	"CalibrePortable"
; !define FINISHRUN ; Delete if not Finish pages
!define OPTIONS ; Delete if no Components
!define SOURCES ; Delete if no Sources
; !define DESCRIPTION	"E-book management" ; Delete if no AppInfo
!define INPUTBOX ; Delete if no InputBox

SetCompressor /SOLID lzma
SetCompressorDictSize 32

!include "..\_Include\Installer.nsh"
!include "LogicLib.nsh"
!include "x64.nsh"

!insertmacro MUI_LANGUAGE "Afrikaans"
!insertmacro MUI_LANGUAGE "Arabic"
!insertmacro MUI_LANGUAGE "Belarusian"
!insertmacro MUI_LANGUAGE "Bulgarian"
!insertmacro MUI_LANGUAGE "Bosnian"
!insertmacro MUI_LANGUAGE "Catalan"
!insertmacro MUI_LANGUAGE "Czech"
!insertmacro MUI_LANGUAGE "Welsh"
!insertmacro MUI_LANGUAGE "Danish"
!insertmacro MUI_LANGUAGE "German"
!insertmacro MUI_LANGUAGE "Greek"
!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "SpanishInternational"
!insertmacro MUI_LANGUAGE "Estonian"
!insertmacro MUI_LANGUAGE "Basque"
!insertmacro MUI_LANGUAGE "Farsi"
!insertmacro MUI_LANGUAGE "Finnish"
!insertmacro MUI_LANGUAGE "French"
!insertmacro MUI_LANGUAGE "Galician"
!insertmacro MUI_LANGUAGE "Hebrew"
!insertmacro MUI_LANGUAGE "Croatian"
!insertmacro MUI_LANGUAGE "Hungarian"
!insertmacro MUI_LANGUAGE "Indonesian"
!insertmacro MUI_LANGUAGE "Icelandic"
!insertmacro MUI_LANGUAGE "Italian"
!insertmacro MUI_LANGUAGE "Japanese"
!insertmacro MUI_LANGUAGE "Korean"
!insertmacro MUI_LANGUAGE "Lithuanian"
!insertmacro MUI_LANGUAGE "Latvian"
!insertmacro MUI_LANGUAGE "Macedonian"
!insertmacro MUI_LANGUAGE "Dutch"
!insertmacro MUI_LANGUAGE "NorwegianNynorsk"
!insertmacro MUI_LANGUAGE "Polish"
!insertmacro MUI_LANGUAGE "Portuguese"
!insertmacro MUI_LANGUAGE "PortugueseBR"
!insertmacro MUI_LANGUAGE "Romanian"
!insertmacro MUI_LANGUAGE "Russian"
!insertmacro MUI_LANGUAGE "Slovak"
!insertmacro MUI_LANGUAGE "Slovenian"
!insertmacro MUI_LANGUAGE "Albanian"
!insertmacro MUI_LANGUAGE "Serbian"
!insertmacro MUI_LANGUAGE "SerbianLatin"
!insertmacro MUI_LANGUAGE "Swedish"
!insertmacro MUI_LANGUAGE "Thai"
!insertmacro MUI_LANGUAGE "Turkish"
!insertmacro MUI_LANGUAGE "Ukrainian"
!insertmacro MUI_LANGUAGE "Vietnamese"
!insertmacro MUI_LANGUAGE "SimpChinese"
!insertmacro MUI_LANGUAGE "TradChinese"

Var InputVer
Var VER
Function nsDialogsPage
	nsDialogs::Create 1018
	Pop $0
	${NSD_CreateLabel} 0 0 100% 12u "Enter Version Number or Skip for Latest"
	Pop $0
	${NSD_CreateText} 0 13u 100% 12u ""
	Pop $InputVer
	nsDialogs::Show
FunctionEnd
Function nsDialogsPageLeave
	${NSD_GetText} $InputVer $R0
; StrCmp $R0 "" 0 +3
	; MessageBox MB_ICONEXCLAMATION `You must enter a version number!`
; Abort
	StrCpy $VER "$R0"
FunctionEnd

Section  /o "${APPNAME} Portable 32 bit" x32

DetailPrint "Installing ${APPNAME} Portable 32 bit"
${If} $VER == ""
Call CheckConnected
	inetc::get "${RELEASURL}/dist/win32" "$TEMP\${APP}PortableTemp\calibre.msi" /END
	Pop $0
StrCmp $0 "OK" +3
	MessageBox MB_USERICON "Download of calibre.msi: $0"
	Abort
	nsExec::Exec `"$SYSDIR\msiexec.exe" /a "$TEMP\${APP}PortableTemp\calibre.msi" TARGETDIR="$TEMP\${APP}PortableTemp\${APP}Setup" /qn`
${Else}

${If} ${FileExists} "$EXEDIR\calibre-$VER.msi"
	nsExec::Exec `"$SYSDIR\msiexec.exe" /a "$EXEDIR\calibre-$VER.msi" TARGETDIR="$TEMP\${APP}PortableTemp\${APP}Setup" /qn`
${Else}
Call CheckConnected
	inetc::get "${DOWNLOADURL}/$VER/calibre-$VER.msi" "$TEMP\${APP}PortableTemp\calibre-$VER.msi" /END
	Pop $0
StrCmp $0 "OK" +3
	MessageBox MB_USERICON "Download of calibre-$VER.msi: $0"
	Abort
	nsExec::Exec `"$SYSDIR\msiexec.exe" /a "$TEMP\${APP}PortableTemp\calibre-$VER.msi" TARGETDIR="$TEMP\${APP}PortableTemp\${APP}Setup" /qn`
${EndIf}

${EndIf}


IfFileExists "$TEMP\${APP}PortableTemp\${APP}Setup\PFiles\calibre\calibre.exe" +2
	Abort
	RMDir "/r" "$INSTDIR\App\${APP}"
	SetOutPath "$INSTDIR\App\${APP}"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup\PFiles\calibre\*.*" "$INSTDIR\App\${APP}"

	SetOutPath "$INSTDIR"
		File "..\..\..\${FOLDER}\${APP}Portable.exe"
		File "..\..\..\${FOLDER}\EbookEditPortable.exe"

SectionEnd

Function .onGUIEnd

!ifdef DESCRIPTION
Call AppInfo
!endif
!ifdef SOURCES
Call Sources
!endif
!ifdef SOURCES & DESCRIPTION
Call SourceInfo
!endif
!ifndef TEST
	RMDir "/r" "$TEMP\${APP}PortableTemp"
!endif
FunctionEnd

Section /o "${APPNAME} Portable 64 bit" x64
DetailPrint "Installing ${APPNAME} Portable 64 bit"
${If} $VER == ""
Call CheckConnected
	inetc::get "${RELEASURL}/dist/win64" "$TEMP\${APP}PortableTemp\calibre-64bit.msi" /END
	Pop $0
StrCmp $0 "OK" +3
	MessageBox MB_USERICON "Download of calibre-64bit.msi: $0"
	Abort
	nsExec::Exec `"$SYSDIR\msiexec.exe" /a "$TEMP\${APP}PortableTemp\calibre-64bit.msi" TARGETDIR="$TEMP\${APP}PortableTemp\${APP}Setup64" /qn`
${Else}
${If} ${FileExists} "$EXEDIR\calibre-64bit-$VER.msi"
	nsExec::Exec `"$SYSDIR\msiexec.exe" /a "$EXEDIR\calibre-64bit-$VER.msi" TARGETDIR="$TEMP\${APP}PortableTemp\${APP}Setup64" /qn`
${Else}
Call CheckConnected
	inetc::get "${DOWNLOADURL}/$VER/calibre-64bit-$VER.msi" "$TEMP\${APP}PortableTemp\calibre-64bit-$VER.msi" /END
	Pop $0
StrCmp $0 "OK" +3
	MessageBox MB_USERICON "Download of calibre-64bit-$VER.msi: $0"
	Abort
	nsExec::Exec `"$SYSDIR\msiexec.exe" /a "$TEMP\${APP}PortableTemp\calibre-64bit-$VER.msi" TARGETDIR="$TEMP\${APP}PortableTemp\${APP}Setup64" /qn`
${EndIf}
${EndIf}
IfFileExists "$TEMP\${APP}PortableTemp\${APP}Setup64\PFiles\Calibre2\calibre.exe" +2
	Abort
	RMDir "/r" "$INSTDIR\App\${APP}64"
	SetOutPath "$INSTDIR\App\${APP}64"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup64\PFiles\Calibre2\*.*" "$INSTDIR\App\${APP}64"
	SetOutPath "$INSTDIR"
		File "..\..\..\${FOLDER}\${APP}Portable.exe"
		File "..\..\..\${FOLDER}\EbookEditPortable.exe"

SectionEnd

Function Init
SectionSetSize ${x32} 174000 # kB
SectionSetSize ${x64} 202000 # kB
${If} ${RunningX64}
SectionSetFlags ${x64} 1
${Else}
	SectionSetFlags ${x32} 1
${EndIf}
FunctionEnd

