/**
 * 提供对话框功能
 * Date: 2014/06/30
 * Author: luxing@iflytek.com
 * @version 1.0
 * @module dialogutil
 */

var DialogUtil = {};

/**
 * 打开对话框
 * @param {object=}  opt_params  可选参数  eg: {accept: ".doc,.ppt"}
 */
DialogUtil.openFileDialog = function (opt_params) {
    var defer = jQuery.Deferred();
    var fileDialog = jQuery('<input style="display:none;"  type="file" />');
    //动态创建，不用依赖于界面
    if (fileDialog.length) {
        if (opt_params) {
            for (var attr in opt_params)
                fileDialog.attr(attr, opt_params[attr]);
        }
        fileDialog.one('change', function () {
            defer.resolve(fileDialog.val());
        });
        fileDialog.trigger('click');
        if (opt_params) {
            for (var attr in opt_params)
                fileDialog.removeAttr(attr);
        }
    }
    return defer.promise();
}

/**
 * 保存对话框
 * @param opt_params
 * @returns {*}
 */
DialogUtil.saveFileDialog = function (opt_params) {
    opt_params = opt_params || {};
    if (!opt_params.nwsaveas)
        opt_params.nwsaveas = "";
    var defer = jQuery.Deferred();
    this.openFileDialog(opt_params).done(function (ret) {
        console.log("save file: " + ret);
        defer.resolve(ret);
    });
    return defer.promise();
};