/**
 * Created with JetBrains WebStorm.
 * User: Cmma
 * Date: 7/11/14
 * Time: 4:46 PM
 * To change this template use File | Settings | File Templates.
 */

define(function (require, exports, module) {
    function PPTTemplate() { }

    PPTTemplate.init = function() {
        this.controls = {
            pptDes: $("#pptDescription"),
            pptFile:$("#filePath"),
            pptTitle:$("#pptTitle")
        }

        this.PPTContext = {
            "ClickToAddTittle": "单击此处添加标题",
            "ClickToAddDescription": "单击此处添加描述"
        }

        this.pptFilePath = "";

        $("#pptDescriptionPanel").focus(function () {
            if (this.value == "单击此处添加描述")
                this.value = '';
        });

        $("#pptDescriptionPanel").blur(function () {
            if (this.value == '')
                this.value = "单击此处添加描述";
        });

        $("#pptTitle").bind('input propertychange', function() {
            var titleLengthArr= _calcStrLength(this.value);
            var titleStrLength = titleLengthArr[0];
            var mostIndex = titleLengthArr[1];
            if (titleStrLength>62) {
                //标题过长，截断处理
                this.value = this.value.substr(0, mostIndex+1);
            }
        });

        $("#pptDescription").bind('input propertychange', function() {
            var descriptLengthArr= _calcStrLength( $("#pptDescription").val());
            var descriptStrLength = descriptLengthArr[0];
            var mostIndex = descriptLengthArr[1];
            if (descriptStrLength>62) {
                //标题过长，截断处理
                $("#pptDescription").val($("#pptDescription").val().substr(0, mostIndex+1));
            }
        });

        //计算标题整体字符所占长度
        function _calcStrLength(str){
            var len = 0;
            //最多实际能放下的“当前”字符串的长度位置
            var mostIndex = 0;
            for (var i = 0; i < str.length; i++) {
                var char = str.charCodeAt(i);
                //单字节加1
                if ((char >= 0x0001 && char <= 0x007e) || (0xff60 <= char && char <= 0xff9f)) {
                    len++;
                }
                else {
                    len += 1.7;
                }
                if(len<62){
                    mostIndex = i;
                }
            }
            return [len,mostIndex];
        }
    }

    PPTTemplate.setFilePath = function(path) {
        this.pptFilePath = path;
        $("#pptFilePanel")[0].innerHTML = path;
    }

    PPTTemplate.getFilePath = function() {
        return this.pptFilePath;
    }


    PPTTemplate.setOperMsg = function(msg) {
        $("#pptMsg")[0].innerHTML = msg;
    }
    PPTTemplate.cleanOperMsg = function() {
        $("#pptMsg")[0].innerHTML = "";
    }

    PPTTemplate.setThumbNailPath = function(path) {
        $("#pptImgBtn")[0].src = path;
    }

    PPTTemplate.SetBusyStatus = function() {
        $("#pptConverting").show();
        $("#pptImgBtn").hide();
    }

    PPTTemplate.SetFinishedStatus = function() {
        $("#pptConverting").hide();
        $("#pptImgBtn").show();
    }

    PPTTemplate.UpdateWidgetInfo = function(jsonObj) {
        this.controls.pptTitle.val(jsonObj.title);
        this.controls.pptDes.val(jsonObj.des);
        this.setThumbNailPath(jsonObj.thumbnail);
    }

    PPTTemplate.PPT2Images = function(filePath, desDir, modulePath,baseName, callback) {
    }

    PPTTemplate.getpptInfo = function(callback) {
        var imgArrJson = [];
        var pptInfo = {"cardtype": "PPT", "file":"", "title": this.controls.pptTitle.val(), "thumbnail": '', "des": this.controls.pptDes.val(), "images": imgArrJson};
        this.getThumbImgCanvasData().done(function (thumbData) {
            if(callback) {
                callback(pptInfo, thumbData);
            }
        });
    }

    PPTTemplate.getThumbImgCanvasData = function() {
        var def = $.Deferred();

        var titleCss = {
            'height': '40px',
            'border': '0',
            'width': '538px',
            'background': '-webkit-linear-gradient(top, #f9f9f9, #e7e7e7)',
            'border-bottom': '1px solid #a6a7a6',
            'font-size':'18px',
            'font-weight': 'bold',
            'font-family': 'microsoft yahei',
            'color': '#222',
            'text-overflow': 'ellipsis',
            'white-space': 'nowrap',
            'overflow': 'hidden'};

        $("#pptTitle").css(titleCss);
        $("#pptTitlePanel").css("border","1px solid #bec3c7");
        $("#pptDescription").css("border","0px");
        $("#pptDescriptionPanel").css("border","1px solid #bec3c7");
        $("#galleryImgBtnExt").css("border","0px");

        if($("#pptTitle").val() == this.PPTContext.ClickToAddTittle || $("#pptTitle").val() == ""){$("#pptTitle").val(" ");}
        if($("#pptDescription").val() == this.PPTContext.ClickToAddDescription || $("#pptDescription").val() == ""){$("#pptDescription").val(" ");}

        var pptPanel = document.getElementById("pptEditPanel");
        html2canvas(pptPanel, {
            onrendered: function (canvas) {
                var data = canvas.toDataURL("image/jpeg");
                //console.log(data);
                def.resolve(data);
                $("#pptTitle").show();
                $("#pptDescription").show();
            }
        });
        return def.promise();
    }

    exports.PPTTemplate = PPTTemplate;
});
