/**
 * 英文评测卡片播放模块
 * Date: 2014/07/14
 * Author: luxing@iflytek.com
 * @version 1.0
 * @module eneval.play
 */
define(function(require, exports) {
    var IOUtil;
    if (RunningPlatform === "NodeWebkit") {
        IOUtil = require("../../../../share/assert/js/ioutil_desktop.js").IOUtil;
    }
    else if (RunningPlatform === "Android") {
        IOUtil = require("../../../../share/assert/js/ioutil_android.js").IOUtil;
    }
    else if (RunningPlatform === "CEF") {
        IOUtil = require("../../../../share/assert/js/ioutil_cef.js").IOUtil;
    }
    else{
        IOUtil = require("../../../../share/assert/js/ioutil_web.js").IOUtil;
    }

    fabric.EnEval.prototype.getRenderDOM=function(relatedResPath){
        var iframeID;
        window.gSpeechCardLoadReady = false;
        var intervalID=0;
        var def = $.Deferred();
        this.getCardOptions(relatedResPath).done(function(cardOptions){
            console.log(cardOptions);
            var cardContainerDiv = $("<div></div>");
            iframeID="cardFrm"+new Date().getTime();
            var cardIframe = $('<iframe src="./share/assert/js/cloudcard/index.html" frameborder="no" width="100%" height="100%"></iframe>')
            cardIframe.attr("id",iframeID);
            cardContainerDiv.append(cardIframe);
            cardIframe[0].onload = function(){
                sendMessage(cardIframe[0],{evt:'loadCard', data:cardOptions, RunningPlatform:window.RunningPlatform});

            };
            /*
            function checkLoaded(){
                console.log(gSpeechCardLoadReady);
                if(window.gSpeechCardLoadReady){
                    window.gSpeechCardLoadReady=false;
                    def.resolve(cardContainerDiv);
                }else{
                    setTimeout(checkLoaded,200);
                }
            }
            setTimeout(checkLoaded,200);
            */
            if (RunningPlatform === "Android") {
                def.resolve(cardContainerDiv);
            }
            else{
                setTimeout(function(){
                    def.resolve(cardContainerDiv);
                },500);
            }

        });
        return def.promise();
    };

    fabric.EnEval.prototype.getCardOptions=function(relatedResPath){
        var def = $.Deferred();
        IOUtil.readFile(relatedResPath+"/meta.json").done(function(jsonStr){
            var cardInfo = JSON.parse(jsonStr);
            var wordsArr=cardInfo.words;
            var constFilePath = relatedResPath+"/";
            var audioPaths = new Array();
            var words=new Array();

            for (var i = 0; i < wordsArr.length; i++) {
                var audioPath = constFilePath + wordsArr[i].audio;
                audioPaths[i] = audioPath.replace('file:/','');
                words.push(wordsArr[i].word);
            }
            var options = {
                paperContent: '[word]\n' + words.join('\n'),
                audios: audioPaths
            };
            var cardOptions={"cardName":"enwordeval","options":options};
            def.resolve(cardOptions);
        });

        return def.promise();

    }

    function sendMessage(cardIframe,msg)
    {
        //var ifr = document.getElementById(iframeID);
        msg = JSON.stringify(msg);
        var targetOrigin = '*';
        cardIframe.contentWindow.postMessage(msg, targetOrigin);
    }
});