/**
 * Created by ythuang on 14-7-3.
 */
define(function (require, exports) {
    var FlipCard = require("../../../../share/assert/js/cloudcard/js-debug/speechui/code/cards/flipcard").Constructor;
    var IOUtil;
    if (RunningPlatform === "NodeWebkit") {
        IOUtil = require("../../../../share/assert/js/ioutil_desktop.js").IOUtil;
    }
    else if (RunningPlatform === "Android") {
        IOUtil = require("../../../../share/assert/js/ioutil_android.js").IOUtil;
    }
    else if (RunningPlatform === "CEF") {
        IOUtil = require("../../../../share/assert/js/ioutil_cef.js").IOUtil;
    }
    else {
        IOUtil = require("../../../../share/assert/js/ioutil_web.js").IOUtil;
    }
    var AppCtx = require("../../../../share/assert/js/appcontext").AppContext;

    fabric.Flipcard.prototype.getRenderDOM = function (relatedResPath) {
        var _dom;
        var _this = this;
        var _scale = AppCtx.zoomRate.y;

        var def = $.Deferred();
        this.getCardOptions(relatedResPath).done(function (cardOptions) {
            var ctxZoomX = AppCtx.zoomRate.x;
            var ctxZoomY = AppCtx.zoomRate.y;

            var zoomX = ctxZoomX * _this.scaleX;
            var zoomY = ctxZoomY * _this.scaleY;

//            if(zoomX < 1 || zoomY < 1){
                var flipCard = new FlipCard(cardOptions, _this.width, _this.height);
//            }else{
//                var flipCard = new FlipCard(cardOptions, _this.currentWidth * AppCtx.zoomRate.x, _this.currentHeight * AppCtx.zoomRate.y);
//            }

            var flipCardDiv = flipCard.getContent();
            _dom = flipCardDiv;
            def.resolve(_dom);
        });
        return def.promise();
    }

    fabric.Flipcard.prototype.getCardOptions = function (relatedResPath) {
        var def = $.Deferred();
        IOUtil.readFile(relatedResPath + "/meta.json").done(function (jsonStr) {
            jsonStr = jsonStr.replace(/\n/g, '\\n');
            var jsonObj = JSON.parse(jsonStr);
            for (var i = 0; i < jsonObj.cards.length; i++) {
                if (RunningPlatform === "Android") {
                    if (jsonObj.cards[i].front.type == 'img') {
                        jsonObj.cards[i].front.value = relatedResPath + "/" + jsonObj.cards[i].front.value;
                    }
                    if (jsonObj.cards[i].back.type == 'img') {
                        jsonObj.cards[i].back.value = relatedResPath + "/" + jsonObj.cards[i].back.value;
                    }
                }
                else {
                    if (jsonObj.cards[i].front.type == 'img') {
                        jsonObj.cards[i].front.value = relatedResPath + '/' + jsonObj.cards[i].front.value;
                    }
                    if (jsonObj.cards[i].back.type == 'img') {
                        jsonObj.cards[i].back.value = relatedResPath + '/' + jsonObj.cards[i].back.value;
                    }
                }
            }
            def.resolve(jsonObj);
        });
        return def.promise();
    }
});