/**
 * 连线题播放
 * Created by hyt on 14-9-15.
 * @vision 1.0
 */
define(function (require, exports) {
    var MatchCard = require("../../../../share/assert/js/cloudcard/js-debug/speechui/code/cards/matchcard").Constructor;
    var IOUtil;
    if (RunningPlatform === "NodeWebkit") {
        IOUtil = require("../../../../share/assert/js/ioutil_desktop.js").IOUtil;
    }
    else if (RunningPlatform === "Android") {
        IOUtil = require("../../../../share/assert/js/ioutil_android.js").IOUtil;
    }
    else if (RunningPlatform === "CEF") {
        IOUtil = require("../../../../share/assert/js/ioutil_cef.js").IOUtil;
    }
    else {
        IOUtil = require("../../../../share/assert/js/ioutil_web.js").IOUtil;
    }
    var AppCtx = require("../../../../share/assert/js/appcontext").AppContext;

    fabric.Matchcard.prototype.getRenderDOM = function (relatedResPath) {
        var _self = this;
        var _dom;
        var def = $.Deferred();
        this.getCardOptions(relatedResPath).done(function (cardOptions) {
            var ctxZoomX = AppCtx.zoomRate.x;
            var ctxZoomY = AppCtx.zoomRate.y;

            var zoomX = ctxZoomX * _self.scaleX;
            var zoomY = ctxZoomY * _self.scaleY;

//            if(zoomX < 1 || zoomY < 1){
            var matchcard = new MatchCard(cardOptions, _self.height, _self.width, zoomX, zoomY);
//            }else{
//                var matchcard = new MatchCard(cardOptions, _self.currentHeight*AppCtx.zoomRate.y, _self.currentWidth*AppCtx.zoomRate.x);
//            }

            var matchcardDiv = matchcard.getContent();
            _dom = matchcardDiv;
            def.resolve(_dom);
        });
        return def.promise();
    }

    fabric.Matchcard.prototype.getCardOptions = function (relatedResPath) {
        var def = $.Deferred();
        IOUtil.readFile(relatedResPath + "/meta.json").done(function (jsonStr) {
            jsonStr = jsonStr.replace(/\n/g, '\\n');
            var jsonObj = JSON.parse(jsonStr);
            for (var i = 0; i < jsonObj.items.question.length; i++) {
                if (jsonObj.items.question[i].type === 'img') {
                    jsonObj.items.question[i].value = relatedResPath + "/" + jsonObj.items.question[i].value;
                }
                if (jsonObj.items.answer[i].type === 'img') {
                    jsonObj.items.answer[i].value = relatedResPath + "/" + jsonObj.items.answer[i].value;
                }
            }
            def.resolve(jsonObj);
        });
        return def.promise();
    }

});