/**
 * 情景对话卡片播放模块
 * Date: 2014/07/14
 * Author: luxing@iflytek.com
 * @version 1.0
 * @module situ.play
 */
define(function(require, exports) {
    var IOUtil;
    if (RunningPlatform === "NodeWebkit") {
        IOUtil = require("../../../../share/assert/js/ioutil_desktop.js").IOUtil;
    }
    else if (RunningPlatform === "Android") {
        IOUtil = require("../../../../share/assert/js/ioutil_android.js").IOUtil;
    }
    else if (RunningPlatform === "CEF") {
        IOUtil = require("../../../../share/assert/js/ioutil_cef.js").IOUtil;
    }
    else{
        IOUtil = require("../../../../share/assert/js/ioutil_web.js").IOUtil;
    }

    fabric.Situdlg.prototype.getRenderDOM=function(relatedResPath){
        var iframeID;
        window.gSpeechCardLoadReady = false;
        var intervalID=0;
        var def = $.Deferred();
        this.getCardOptions(relatedResPath).done(function(cardOptions){
            console.log(JSON.stringify(cardOptions));
            var cardContainerDiv = $("<div></div>");
            iframeID="cardFrm"+new Date().getTime();
            var cardIframe = $('<iframe src="./share/assert/js/cloudcard/index.html" frameborder="0" width="100%" height="100%"></iframe>')
            cardIframe.attr("id",iframeID);
            cardContainerDiv.append(cardIframe);
            cardIframe[0].onload = function(){
                console.log("load iframe finish!!!");
                sendMessage(cardIframe[0],{evt:'loadCard', data:cardOptions, RunningPlatform:window.RunningPlatform});

            };
            /*
            function checkLoaded(){
                console.log(gSpeechCardLoadReady);
                if(window.gSpeechCardLoadReady){
                    window.gSpeechCardLoadReady=false;
                    def.resolve(cardContainerDiv);
                }else{
                    setTimeout(checkLoaded,200);
                }
            }
            setTimeout(checkLoaded,200);
            */
            if (RunningPlatform === "Android") {
               def.resolve(cardContainerDiv);
            }
            else{
                setTimeout(function(){
                    //console.log("%c %s",'color:red;',gSpeechCardLoadReady);
                    def.resolve(cardContainerDiv);
                },500);
            }
        });
        return def.promise();
    };

    fabric.Situdlg.prototype.getCardOptions=function(relatedResPath){
        var def = $.Deferred();
        IOUtil.readFile(relatedResPath+"/meta.json").done(function(jsonStr){
            var cardInfo = JSON.parse(jsonStr);
            var constFilePath = relatedResPath+"/";
            for(var i=0; i<cardInfo.sens.length; i++){
                cardInfo.sens[i].audio = constFilePath + cardInfo.sens[i].audio;
            }
            if(cardInfo.backgroundimg != ""){
                cardInfo.backgroundimg = constFilePath + cardInfo.backgroundimg + "?" + Math.random();
            }
            var options=cardInfo;
            var cardOptions={"cardName":"situ","options":options};
            def.resolve(cardOptions);
        });

        return def.promise();
    }

    function sendMessage(cardIframe,msg)
    {
        //var ifr = document.getElementById(iframeID);
        msg = JSON.stringify(msg);
        var targetOrigin = '*';
        cardIframe.contentWindow.postMessage(msg, targetOrigin);
    }
});