/**
 * Android程序中的文件读写
 * Date: 2014/07/7
 * Author: luxing@iflytek.com
 * @version 1.0
 * @module ioutil
 */
define(function (require, exports) {
    var IOUtilBase = require('./ioutil').IOUtilBase;
    var Appcontext = require('share/assert/js/appcontext').AppContext;
    function IOUtil() {
    }

    IOUtil.prototype = new IOUtilBase();
    IOUtil.prototype.constructor = IOUtil;
    /**
     *   读文件
     * @param filePath
     * @returns {*}
     */
    IOUtil.prototype.readFile = function (filePath) {
        var def = jQuery.Deferred();
        if (!filePath)
            throw new Error("error argument");
        var newBlankSlideName = filePath.match(/newBlank\d{1,}.sco/);
        var newBlankSlideBackImg = null;
        if(newBlankSlideName){
            //找一下，该新建页是否设置了背景图
            for(var i=0; i<Appcontext.newBlankSlides.length; i++){
                if(Appcontext.newBlankSlides[i][0] == newBlankSlideName){
                    newBlankSlideBackImg = Appcontext.newBlankSlides[i][1];
                }
            }
            if(newBlankSlideBackImg){
                //console.log(newBlankSlideBackImg);
                var tempImg = new Image();
                tempImg.src = newBlankSlideBackImg;
                $("body").append(tempImg);
                tempImg.onload = function(){
                    $(tempImg).css("visibility","hidden");
                    var tempImgWidth = $(tempImg).width();
                    var tempImgHeight = $(tempImg).height();
                    var backImgWidth,backImgHeight;
                    //计算一下图片的宽高比，宽高比大于屏幕的，则自适应宽度
                    var imgRate = tempImgWidth/tempImgHeight;
                    var containerRate = Appcontext.containerOffset.width/Appcontext.containerOffset.height;
                    if(imgRate>=containerRate){
                        backImgWidth = tempImgWidth < Appcontext.containerOffset.width ? tempImgWidth : Appcontext.containerOffset.width;
                        backImgHeight = backImgWidth/imgRate;
                    }
                    //宽高比小于屏幕的，则自适应高度
                    if(imgRate<containerRate){
                        backImgHeight = tempImgHeight < Appcontext.containerOffset.height ? tempImgHeight : Appcontext.containerOffset.height;
                        backImgWidth = backImgHeight*imgRate;
                    }

                    $(tempImg).css({height:backImgHeight,width:backImgWidth});
                    var backImgTop = (Appcontext.containerOffset.height-backImgHeight)/2;
                    var backImgLeft = (Appcontext.containerOffset.width-backImgWidth)/2;
                    $(tempImg).remove();
                    def.resolve('{"canvas":{"objects":[],"background":null,"backgroundImage":{"type":"image","originX":"left","originY":"top","left":'+backImgLeft+',"top":'+backImgTop+',"width":'+backImgWidth+',"height":'+backImgHeight+',"fill":"rgb(0,0,0)","stroke":null,"strokeWidth":1,"strokeDashArray":null,"strokeLineCap":"butt","strokeLineJoin":"miter","strokeMiterLimit":10,"scaleX":1,"scaleY":1,"angle":0,"flipX":false,"flipY":false,"opacity":1,"shadow":null,"visible":true,"clipTo":null,"backgroundColor":"","src":"'+newBlankSlideBackImg+'","filters":[],"crossOrigin":""}},"rels":[],"animationInfo":[],"presentfmt":"840:525"}');
                }
            }else{
                def.resolve('{"canvas":{"objects":[],"background":"white"},"rels":[],"animationInfo":[],"presentfmt":"840:525"}');
            }
        }else{
            androidSink.execute('com.iflytek.teachingMachine.mcv.slide.androidSink.IOUtil', 'readFile', filePath, false, function (err, ret) {
                if (err) {
                    console.error(err);
                }
                ret = ret.replace(/\\n/g, "\n");
                //console.log(ret);
                def.resolve(ret);
            });
        }
        return def.promise();
    };

    /**
     * 写文件
     * @param filePath
     * @param content
     * @returns {*}
     */
    IOUtil.prototype.writeFile = function (filePath, content) {
        throw new Error("writeFile need impl");
    };

    /**
     * 使用系统自带的程序打开某个文件
     * @param filePath
     * @returns {*}
     */
    IOUtil.prototype.shellexecute = function (filePath) {
        var def = jQuery.Deferred();
        if (!filePath)
            throw new Error("error argument");
        androidSink.execute('com.iflytek.teachingMachine.mcv.slide.androidSink.IOUtil', 'shellexecute', filePath, false, function (err, ret) {
            if (err) {
                console.error(err);
            }
            //console.log(ret);
            def.resolve(ret);
        });
        return def.promise();
    };

    exports.IOUtil = new IOUtil();
});