/**
 * Created by jhwang on 14-8-18.
 */

define(function (require, exports) {
    var IOUtilBase = require('./ioutil').IOUtilBase;
    var Appcontext = require('share/assert/js/appcontext').AppContext;
    var WdtType = require('share/assert/js/widgettype');

    function IOUtil() {
    }

    IOUtil.prototype = new IOUtilBase();
    IOUtil.prototype.constructor = IOUtil;
    /**
     *   读文件
     * @param filePath
     * @returns {*}
     */
    IOUtil.prototype.readFile = function (filePath) {
        var def = jQuery.Deferred();
        if (!filePath)
            throw new Error("error argument");
        var slideJsonFlag = filePath.match(/slide.json/);
        if(Appcontext.isSingleWidgetPlayMode && slideJsonFlag){
            var widgetType="";
            var widgetWidth=800;
            var widgetHeight=600;
            switch (Appcontext.singleWidgetType){
                case "cn_word":
                    widgetType = WdtType.Types.CnEval;
                    widgetWidth = 900;
                    break;
                case "en_word":
                    widgetType = WdtType.Types.EnEval;
                    widgetWidth = 900;
                    break;
                case "situ":
                    widgetType = WdtType.Types.Situdlg;
                    widgetWidth = 1000;
                    break;
                case "exercise":
                    widgetType = WdtType.Types.Exercise;
                    break;
                case "flipcard":
                    widgetType = WdtType.Types.Flipcard;
                    break;
                case "gallery":
                    widgetType = WdtType.Types.Gallery;
                    break;
                case "history":
                    widgetType = WdtType.Types.History;
                    break;
                case "pickcard":
                    widgetType = WdtType.Types.Pickcard;
                    break;
                case "matchcard":
                    widgetType = WdtType.Types.Matchcard;
                    break;
                case "ppt":
                    widgetType = WdtType.Types.PPT;
                    break;
            }
            var jsonObj = {"canvas":{"objects":[{"type":widgetType,"originX":"left","originY":"top","left":0,"top":0,"width":widgetWidth,"height":widgetHeight,"fill":"rgb(0,0,0)","stroke":"#d0cece","strokeWidth":1,"strokeDashArray":null,"strokeLineCap":"butt","strokeLineJoin":"miter","strokeMiterLimit":10,"scaleX":1,"scaleY":1,"angle":0,"flipX":false,"flipY":false,"opacity":1,"shadow":{"color":"rgba(0,0,0,0.4)","blur":5,"offsetX":0,"offsetY":0},"visible":true,"clipTo":null,"backgroundColor":"","id":widgetType,"rid":"r1","src":"","filters":[],"crossOrigin":""}],"background":"white"},"rels":[{"id":"r1","src":"","title":"","des":"","type":"dir"}],"animationInfo":[],"presentfmt":"800:500"};
            var data = JSON.stringify(jsonObj);
            def.resolve(data);
        }else{
            //增加单独widget的获取json数据方式判断，需要向路由发送请求
            if (Appcontext.singleWidgetRouteAddress) {
                $.ajax({
                    url: Appcontext.singleWidgetRouteAddress,
                    type: 'POST',
                    data: {prewUrl: filePath},
                    success: function (data) {
                        if (typeof data === "object") {
                            data = JSON.stringify(data);
                        }
                        def.resolve(data);
                    },
                    error: function () {
                        def.resolve('');
                    }
                });
            } else {
                $.post(filePath, null,function (data) {
                    if (typeof data === "object") {
                        data = JSON.stringify(data);
                    }
                    def.resolve(data);
                }).fail(function () {
                        def.resolve('');
                    });
            }
        }

        return def.promise();
    };

    /**
     * 写文件
     * @param filePath
     * @param content
     * @returns {*}
     */
    IOUtil.prototype.writeFile = function (filePath, content) {
        throw new Error("writeFile need impl");
    };

    /**
     * 使用系统自带的程序打开某个文件
     * @param filePath
     * @returns {*}
     */
    IOUtil.prototype.shellexecute = function (filePath) {
        throw new Error('shellexecute is not implemented !');
    };

    exports.IOUtil = new IOUtil();
});
