## Extensity

### Quickly enable/disable Google Chrome extensions

Tired of having too many extensions in your toolbar? Try Extensity, the ultimate tool
for lightning fast enabling and disabling all your extensions for Google Chrome.
Just enable the extension when you want to use it, and disable when you want to
get rid of it for a little while. You can also launch Chrome Apps right from the list.

* Keep your browser lean and fast - disable extensions that you won't use right away.
* Keep your toolbar clean.
* Turn all extensions off (and back on) with a single click.
* Quick switch between several extensions groups using the Profiles feature.
* Allow your most important extensions to be always enabled.
* Keep computers in sync with Chrome Cloud Storage support.
* Ideal companion for extensions collectors.

Extensity is open source software. Full source code at GitHub https://github.com/sergiokas/Extensity

Install it from the [Chrome Web Store](https://chrome.google.com/webstore/detail/extensity/jjmflmamggggndanpgfnpelongoepncg).

Website: [http://sergiokas.github.com/Extensity/](http://sergiokas.github.com/Extensity/)

Follow us in Twitter: [@ExtensityChrome](https://twitter.com/ExtensityChrome)

### What's new:

v1.11.0 (Sep 2020)
- **New Feature**: Added "Always On" profile

v1.10.0 (Jan 2019)
- Save Profiles locally when the amount of data exceeds Google's quota.

v1.9.0 (Sep 2018)
- Removed `chrome.tabs` API dependency

v1.8.0 (Ago 2018)
- Removed jQuery dependency
- Updated build system

v1.7.0 (Ago 2018)
- Added icon for developer extensions

v1.6.0 (Jul 2018)
- **New Feature**: Added extension/app icon to access the options page

v1.5.0 (Jun 2018)
- Added visual indication of the currently active profile

v1.4.0 (Jan 2018)
- **New Feature**: Sync between computers through Chrome Storage

v1.3.1 (Nov 2017)
- Changed profiles icon, minor visual changes

v1.3.0 (Feb 2017)
- **New Feature**: Search box for extensions and apps
- Temporary workaround for [Chromium bug](https://bugs.chromium.org/p/chromium/issues/detail?id=307912)

v1.2.4 (Sept 2016)
- Added option to show enabled Extensions first

v1.2.3 (May 2016)
- Updated compatibility for ChromeOS

v1.2.2 (Apr 2016)
- Updated toggle switch style

v1.2.1 (Apr 2016)
- Backwards compatibility for toggle switch
- Small text fixes

v1.2.0 (Apr 2016)
- **New Feature**: Profiles! Our top-most requested feature is here. Quick switch between groups of extensions with a single click.
- Major overhaul of the engine
- New retina icons
- Minor style changes

v1.1.11 (Jun 2015)
- **New Feature**: turn all enabled extensions off, then turn them back on
- Style changes
- New icons

v1.1.10 (Feb 2015)
- More performance improvements
- Fixed Chrome's extensions page link

v0.1.9 (Jan 2015)
- Added option to show apps first

v0.1.8 (Dec 2014)
- Updated to flat icons
- Updated library versions
- Code cleanup
- Cosmetic fixes (e.g. extensions with very long names)
- Updated license

v0.1.7 (Jul 2013)
- Excluding Chrome themes from the list

v0.1.6 (Jul 2012)
- Added separate page initializer files
- Added underscore.js and underscore.string
- Removed deprecated jQuery templates dependency
- Added some performance improvements
- Added support for Chrome Extensions v2 manifest

v0.1.5 (Mar 2012)
- Updated font styles

v0.1.4 (Mar 2012)
- Updated styles
- Added makefile for extension distribution
- Fixed Twitter share link

v0.1.3 (Jun 2011)
- Added share and rate icons

v0.1.2 (Jun 2011)
- Added header with link to chrome://extensions/ and Extensity options
- Added section headers for grouping Apps and Extensions
- Added ability to launch apps (as disabling them didn't make any real sense)
- Added options page to configure grouping and header display

v0.1.1 (May 2011)
- Fixed scrollbar for really long extension lists
