/*! knockout-secure-binding - v0.5.5 - 2016-04-03
 *  https://github.com/brianmhunt/knockout-secure-binding
 *  Copyright (c) 2013 - 2016 Brian M Hunt; License: MIT */
;(function(factory) {
    //AMD
    if (typeof define === "function" && define.amd) {
        define(["knockout", "exports"], factory);
        //normal script tag
    } else {
        factory(ko);
    }
}(function(ko, exports, undefined) {
function value_of(e){return e instanceof Identifier||e instanceof Expression?e.get_value():e}function _object_map(e,t){if(!e)return e;var n={};for(var r in e)e.hasOwnProperty(r)&&(n[r]=t(e[r],r,e));return n}function _virtualNodeBindingValue(e){var t=(commentNodesHaveTextProperty?e.text:e.nodeValue).match(startCommentRegex);return t?t[1]:null}function is_identifier_char(e){return e>="A"&&"Z">=e||e>="a"&&"z">=e||e>="0"&&9>=e||"_"===e||"$"===e}function secureBindingsProvider(e){new ko.bindingProvider;e=e||{},this.attribute=e.attribute||"data-sbind",this.noVirtualElements=e.noVirtualElements||!1,this.globals=e.globals||{},this.bindings=e.bindings||ko.bindingHandlers}function registerBindings(e){ko.utils.extend(this.bindings,e)}function nodeHasBindings(e){var t;return e.nodeType===e.ELEMENT_NODE?e.getAttribute(this.attribute)||ko.components&&ko.components.getComponentNameForNode(e):e.nodeType===e.COMMENT_NODE?this.noVirtualElements?!1:(t=(""+e.nodeValue||e.text).trim(),0===t.indexOf("ko ")):void 0}function getBindingsString(e){switch(e.nodeType){case e.ELEMENT_NODE:return e.getAttribute(this.attribute);case e.COMMENT_NODE:return _virtualNodeBindingValue(e);default:return null}}function nodeParamsToObject(e,t){var n=t.parse(e.getAttribute("params"));if(!n||0===Object.keys(n).length)return{$raw:{}};var r=_object_map(n,function(t,n){return ko.computed(t,null,{disposeWhenNodeIsRemoved:e})}),i=_object_map(r,function(t,n){var r=t.peek();return t.isActive()?ko.computed({read:function(){return ko.unwrap(t())},write:ko.isWriteableObservable(r)&&function(e){t()(e)},disposeWhenNodeIsRemoved:e}):r});return i.hasOwnProperty("$raw")||(i.$raw=r),i}function getBindingAccessors(e,t){var n,r={},i=new Parser(e,t,this.globals),o=this.getBindingsString(e);if(e.nodeType===e.ELEMENT_NODE&&ko.components&&(n=ko.components.getComponentNameForNode(e)),o&&(r=i.parse(o||"")),n){if(r.component)throw new Error("Cannot use a component binding on custom elements");var s={name:n,params:nodeParamsToObject(e,i)};r.component=function(){return s}}return r}var Identifier,Expression,Parser,Node,originalBindingProviderInstance=new ko.bindingProvider,commentNodesHaveTextProperty=document&&"<!--test-->"===document.createComment("test").text,startCommentRegex=commentNodesHaveTextProperty?/^<!--\s*ko(?:\s+([\s\S]+))?\s*-->$/:/^\s*ko(?:\s+([\s\S]+))?\s*$/;Identifier=function(){function e(e,t,n){this.token=t,this.dereferences=n,this.parser=e}return e.prototype.lookup_value=function(e){var t=this.token,n=this.parser,r=n.context,i=r.$data||{},o=n.globals||{};if(e)return value_of(e)[t];switch(t){case"$element":return n.node;case"$context":return r;case"$data":return i}return i[t]||r[t]||o[t]},e.prototype.dereference=function(e){var t,n,r,i,o=this.dereferences||[],s=this.parser,u=s.context||{},a=u.$data||{},c={$context:u,$data:a,globals:s.globals||{},$element:s.node};for(r=0,i=o.length;i>r;++r)t=o[r],t===!0?(e=e.call(n||c),n=e):(n=e,e=e[value_of(t)]);return e},e.prototype.get_value=function(e){return this.dereference(this.lookup_value(e))},e.prototype.set_value=function(e){var t,n,r,i=this.parser,o=i.context,s=o.$data||{},u=i.globals||{},a=this.dereferences||[],c=this.token;if(Object.hasOwnProperty.call(s,c))r=s;else if(Object.hasOwnProperty.call(o,c))r=o;else{if(!Object.hasOwnProperty.call(u,c))throw new Error("Identifier::set_value -- The property '"+c+"' does not exist on the $data, $context, or globals.");r=u}for(n=a.length,0===n&&(r[c]=e),r=r[c],t=0;n-1>t;++t)c=a[t],r=c===!0?r():r[value_of(c)];if(a[t]===!0)throw new Error("Cannot assign a value to a function.");r[value_of(a[t])]=e},e}(),Node=function(){function e(e,t,n){this.lhs=e,this.op=t,this.rhs=n}var t={"!":function(e,t){return!t},"!!":function(e,t){return!!t},"*":function(e,t){return e*t},"/":function(e,t){return e/t},"%":function(e,t){return e%t},"+":function(e,t){return e+t},"-":function(e,t){return e-t},"<":function(e,t){return t>e},"<=":function(e,t){return t>=e},">":function(e,t){return e>t},">=":function(e,t){return e>=t},"==":function(e,t){return e===t},"!=":function(e,t){return e!==t},"===":function(e,t){return e===t},"!==":function(e,t){return e!==t},"&":function(e,t){return e&t},"^":function(e,t){return e^t},"|":function(e,t){return e|t},"&&":function(e,t){return e&&t},"||":function(e,t){return e||t}};return t["!"].precedence=4,t["!!"].precedence=4,t["*"].precedence=5,t["/"].precedence=5,t["%"].precedence=5,t["+"].precedence=6,t["-"].precedence=6,t["<"].precedence=8,t["<="].precedence=8,t[">"].precedence=8,t[">="].precedence=8,t["=="].precedence=9,t["!="].precedence=9,t["==="].precedence=9,t["!=="].precedence=9,t["&"].precedence=10,t["^"].precedence=11,t["|"].precedence=12,t["&&"].precedence=13,t["||"].precedence=14,e.operators=t,e.prototype.get_leaf_value=function(t,n){if("function"==typeof t)return ko.unwrap(t());if("object"!=typeof t)return n?n[t]:t;if(t instanceof Identifier||t instanceof Expression)return ko.unwrap(t.get_value(n));if(t instanceof e)return t.get_node_value(n);throw new Error("Invalid type of leaf node: "+t)},e.prototype.get_node_value=function(){return this.op(this.get_leaf_value(this.lhs),this.get_leaf_value(this.rhs))},e}(),Expression=function(){function e(e){this.nodes=e,this.root=this.build_tree(e)}return e.operators=Node.operators,e.Node=Node,e.prototype.build_tree=function(e){var t,n,r,i;for(n=t=new Node(e.shift(),e.shift(),e.shift());e&&(r=e.shift(),i=e.shift(),r);)r.precedence>t.op.precedence?(t=new Node(t,r,i),n=t):(n.rhs=new Node(n.rhs,r,i),n=n.rhs);return t},e.prototype.get_value=function(){return this.root||(this.root=this.build_tree(this.nodes)),this.root.get_node_value()},e}(),Parser=function(){function e(e,t,n){this.node=e,this.context=t,this.globals=n||{}}var t={"'":"'",'"':'"',"\\":"\\","/":"/",b:"\b",f:"\f",n:"\n",r:"\r",t:"	"},n=Expression.operators;return e.Expression=Expression,e.Identifier=Identifier,e.Node=Node,e.prototype.white=function(){for(var e=this.ch;e&&" ">=e;)e=this.next();return e},e.prototype.next=function(e){return e&&e!==this.ch&&this.error("Expected '"+e+"' but got '"+this.ch+"'"),this.ch=this.text.charAt(this.at),this.at+=1,this.ch},e.prototype.error=function(e){throw{name:"SyntaxError",message:e,at:this.at,text:this.text}},e.prototype.name=function(){var e="";this.white();for(var t=this.ch;t;){if(":"===t||" ">=t||","===t)return e;e+=t,t=this.next()}return e},e.prototype.number=function(){var e,t="",n=this.ch;for("-"===n&&(t="-",n=this.next("-"));n>="0"&&"9">=n;)t+=n,n=this.next();if("."===n)for(t+=".",n=this.next();n&&n>="0"&&"9">=n;)t+=n,n=this.next();if("e"===n||"E"===n)for(t+=n,n=this.next(),"-"!==n&&"+"!==n||(t+=n,n=this.next());n>="0"&&"9">=n;)t+=n,n=this.next();return e=+t,isFinite(e)?e:void error("Bad number")},e.prototype.object_add_value=function(e,t,n){n instanceof Identifier||n instanceof Expression?Object.defineProperty(e,t,{get:function(){return n.get_value()},enumerable:!0}):e[t]=n},e.prototype.object=function(){var e,t={},n=this.ch;if("{"===n){if(this.next("{"),n=this.white(),"}"===n)return n=this.next("}"),t;for(;n;){if(e='"'===n||"'"===n?this.string():this.name(),this.white(),n=this.next(":"),Object.hasOwnProperty.call(t,e)&&this.error('Duplicate key "'+e+'"'),this.object_add_value(t,e,this.expression()),n=this.white(),"}"===n)return n=this.next("}"),t;this.next(","),n=this.white()}}this.error("Bad object")},e.prototype.read_string=function(e){for(var n,r,i,o="",s=this.next();s;){if(s===e)return s=this.next(),o;if("\\"===s)if(s=this.next(),"u"===s){for(i=0,r=0;4>r&&(n=parseInt(s=this.next(),16),isFinite(n));r+=1)i=16*i+n;o+=String.fromCharCode(i)}else{if("string"!=typeof t[s])break;o+=t[s]}else o+=s;s=this.next()}this.error("Bad string")},e.prototype.string=function(){var e=this.ch;return'"'===e?this.read_string('"'):"'"===e?this.read_string("'"):void this.error("Bad string")},e.prototype.array=function(){var e=[],t=this.ch;if("["===t){if(t=this.next("["),this.white(),"]"===t)return t=this.next("]"),e;for(;t;){if(e.push(this.expression()),t=this.white(),"]"===t)return t=this.next("]"),e;this.next(","),t=this.white()}}this.error("Bad array")},e.prototype.value=function(){var e;switch(this.white(),e=this.ch){case"{":return this.object();case"[":return this.array();case'"':case"'":return this.string();case"-":return this.number();default:return e>="0"&&"9">=e?this.number():this.identifier()}},e.prototype.operator=function(){for(var e,t="",r=this.white();r&&!(is_identifier_char(r)||" ">=r||""===r||'"'===r||"'"===r||"{"===r||"["===r||"("===r);)t+=r,r=this.next();return""!==t&&(e=n[t],e||this.error("Bad operator: '"+t+"'.")),e},e.prototype.expression=function(){for(var e,t=[],n=this.white();n&&(op=this.operator(),op&&(t.push(void 0),t.push(op)),"("===n?(this.next(),t.push(this.expression()),this.next(")")):(e=this.value(),t.push(e)),n=this.white(),":"!==n&&"}"!==n&&","!==n&&"]"!==n&&")"!==n&&""!==n);)op=this.operator(),op&&t.push(op),n=this.white();return 0!==t.length?1===t.length?t[0]:new Expression(t):void 0},e.prototype.dereference=function(){for(var e,t=this.white();t;){if("("===t)return this.next("("),this.white(),this.next(")"),!0;if("["===t)return this.next("["),e=this.expression(),this.white(),this.next("]"),e;if("."===t){for(e="",this.next("."),t=this.white();t&&is_identifier_char(t);)e+=t,t=this.next();return e}break}},e.prototype.identifier=function(){var e,t,n="",r=[];for(e=this.white();e&&is_identifier_char(e);)n+=e,e=this.next();switch(n){case"true":return!0;case"false":return!1;case"null":return null;case"undefined":return}for(;e&&(t=this.dereference(),void 0!==t);)r.push(t);return new Identifier(this,n,r)},e.prototype.bindings=function(){for(var e,t,n={},r=this.ch;r;)e=this.name(),t=this.white(),t&&","!==t?(r=this.next(":"),n[e]=this.expression(),this.white(),r=this.ch?this.next(","):""):(r=t?this.next(","):"",n[e]=null);return n},e.prototype.convert_to_accessors=function(e){var t={};return ko.utils.objectForEach(e,function(n,r){r instanceof Identifier?(e[n]=function(){return r.get_value()},ko.expressionRewriting._twoWayBindings[n]&&(t[n]=function(e){r.set_value(e)})):r instanceof Expression?e[n]=function(){return r.get_value()}:"function"!=typeof r&&(e[n]=function(){return r})}),Object.keys(t).length>0&&(e._ko_property_writers=function(){return t}),e},e.prototype.parse=function(e){if(this.text=(e||"").trim(),this.at=0,this.ch=" ",!this.text)return null;var t=this.bindings();return this.white(),this.ch&&this.error("Syntax Error"),this.convert_to_accessors(t)},e}(),ko.utils.extend(secureBindingsProvider.prototype,{registerBindings:registerBindings,nodeHasBindings:nodeHasBindings,getBindingAccessors:getBindingAccessors,getBindingsString:getBindingsString,nodeParamsToObject:nodeParamsToObject,Parser:Parser});    if (!exports) {
        ko.secureBindingsProvider = secureBindingsProvider;
    }
    return secureBindingsProvider;
}));