#include "stdafx.h"
#include <Windows.h>
#include <iostream>
#include <map>
#include <io.h>

#include "SysLog.h"
#include "Common.h"
#include "PlayManager.h"
#include "player_sdk_func.h"
#include "rm/ezr_rm_ex.h"
#include "rtmp/rtmp_sdk_func.h"

#ifdef USE_PARAM
#include "Internal/Internal.h"
#endif

/*̬Ա*/
LONG                      CPlayManager::sm_InitRefCount = 0;

CRITICAL_SECTION          CPlayManager::sm_stLock = {0};

std::map<ULONG, ULONG_32> CPlayManager::sm_oSessionPortMap;

/*ͨȫֱ*/
ULONG gulLastError = 0;/**/

bool gabIsFishEye[16] = {false};/*ϱ״̬*/

/**/
char *w2c(char *pcstr,wchar_t *pwstr, size_t len)
{
    int nlength = wcslen(pwstr);
    int nbytes = WideCharToMultiByte( 0, 0, pwstr, nlength, NULL, 0, NULL, NULL );

    if((size_t)nbytes > len)
    {
        nbytes = len;
    }

    WideCharToMultiByte( 0, 0, pwstr, nlength, pcstr, nbytes, NULL, NULL );

    return pcstr ;
}

/*ص*/
VOID STDCALL pfnSyslog(IN LONG lLevel, IN const CHAR *pcFileName, IN LONG lLine, IN const CHAR *pcFormat, ...)
{
    if (lLevel < LOG_LEVEL_DEBUG) 
    {
        return;
    }

    va_list arglist;
    va_start(arglist, pcFormat);

    char szLogBuf[BUFF_LARGE_SIZE] = {0};
    vsprintf(szLogBuf, pcFormat, arglist);
    LogThread::SysLog((LOGLEVEL_E)lLevel, pcFileName, lLine, szLogBuf);
}

VOID STDCALL pfnSyslog2(IN ULONG_32 ulLogLevel,
                        IN ULONG_32 ulErrCode,
                        IN ULONG_32 ulCmdModuleID,
                        IN const CHAR *pcFileName,
                        IN ULONG_32 ulFileLine,
                        IN const CHAR *pcLogDescription)
{
    LogThread::SysLog((LOGLEVEL_E)ulLogLevel, pcFileName, ulFileLine, pcLogDescription);
}

/*Ϣϱص*/
VOID STDCALL pfnRunInfo(IN ULONG_32 ulRunInfoType,
                        IN VOID *pParam)
{
    PLAYER_RUN_INFO_S *pstRunInfo = NULL;
    pstRunInfo = (PLAYER_RUN_INFO_S *)pParam;
    if (NULL != pstRunInfo)
    {
        switch(ulRunInfoType)
        {
        case PLAYER_RUN_INFO_MEDIA_PROCESS:
            {
                CHAR szInfo[256] = {0};
                int iSize;
                wchar_t* pwszUnicode ;

                switch (pstRunInfo->ulErrCode)
                {
                case ERR_FISHEYE_STREAM_EXIST:
                    {
                        gabIsFishEye[0] = BOOL_TRUE;
                        return;
                    }
                case ERR_FILE_READ_END:
                    {
                        sprintf(szInfo, "Port[%03d] report %d, %s", pstRunInfo->ulPort, pstRunInfo->ulErrCode, "Read file end.");
                        break;
                    }
                case ERR_CLOUD_NETWORK_POOR:
                    {
                        sprintf(szInfo, "Port[%03d] report %d, %s", pstRunInfo->ulPort, pstRunInfo->ulErrCode, "Network poor.");
                        break;
                    }
                case ERR_CLOUD_PLAY_FINISH:
                    {
                        sprintf(szInfo, "Port[%03d] report %d, %s", pstRunInfo->ulPort, pstRunInfo->ulErrCode, "HLS play finish.");
                        break;
                    }
                case ERR_FAIL_TO_DECODE:
                    {
                        sprintf(szInfo, "Port[%03d] report %d, %s", pstRunInfo->ulPort, pstRunInfo->ulErrCode, "Decord failed.");
                        break;
                    }
                case ERR_PLAYER_MEDIA_EXCEPTION:
                    {
                        IMCP_RM_StopStream(pstRunInfo->ulPort);
                        NDPlayer_StopPlay(pstRunInfo->ulPort, NULL);
                        NDPlayer_CloseInputStream(pstRunInfo->ulPort);
                        NDPlayer_FreePort(pstRunInfo->ulPort);

                        EnterCriticalSection(&CPlayManager::sm_stLock);
                        CPlayManager::sm_oSessionPortMap.erase(pstRunInfo->ulPort);
                        LeaveCriticalSection(&CPlayManager::sm_stLock);

                        sprintf(szInfo, "Port[%03d] report %d, %s", pstRunInfo->ulPort, pstRunInfo->ulErrCode, "Exception Occurred.");
                        break;
                    }
                default:
                    {
                        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] Other Report, Error Code[%d].", pstRunInfo->ulPort, pstRunInfo->ulErrCode);
                        return;
                    }
                }

                /*ؽַ軺ĴСѾַβ'\0'*/
                iSize = MultiByteToWideChar(CP_ACP, 0, szInfo , -1, NULL, 0); /*iSize =wcslen(pwsUnicode)+1=6 */
                pwszUnicode = (wchar_t *)malloc(iSize*sizeof(wchar_t)); 
                MultiByteToWideChar(CP_ACP, 0, szInfo , -1, pwszUnicode , iSize);
                MessageBox(NULL, pwszUnicode, _T("PLAY INFO"), MB_OK);
                free(pwszUnicode);
                pwszUnicode = NULL;
                break;
            }
        default:
            {
                LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] Other Report, Error Code[%d].", pstRunInfo->ulPort, pstRunInfo->ulErrCode);
                break;
            }
        }
    }

    return;
}

/*ԭʼݻص*/
VOID STDCALL SaveRtpDataCallBack(IN ULONG_32 ulPort,
                                IN const UCHAR *pucBuffer,
                                IN ULONG_32 ulBufSize,
                                IN ULONG_32 ulMediaDataType,
                                IN VOID* pUserParam,
                                IN LONG_REAL lReserved)
{
    INPUT_DATA_FD_S *pstFd = (INPUT_DATA_FD_S *)pUserParam;

    if (NULL != pstFd)
    {
        /*дݣʽΪRTP*/
        if(NULL != pucBuffer)
        {
            fwrite(pucBuffer, ulBufSize, 1, pstFd->m_pDatafd);

            /*дݳ*/
            CHAR szTemp[16] = {0};
            sprintf(szTemp, "%d\r\n", ulBufSize);
            fwrite(szTemp, strlen(szTemp), 1, pstFd->m_pLenfd);
        }
    }

    return;
}

/*ƴ֡*/
VOID STDCALL SaveSpellDataCallBack(IN ULONG_32 ulPort,
                              IN const PLAYER_PARSE_VIDEO_DATA_S *pstSpellVideoData,
                              IN VOID* pUserParam,
                              IN LONG_REAL lReserved)
{
    INPUT_DATA_FD_S *pstFd = (INPUT_DATA_FD_S *)pUserParam;

    if (NULL != pstFd)
    {
        /*дݣʽΪ֡*/
        fwrite(pstSpellVideoData->pucData, pstSpellVideoData->ulDataLen, 1, pstFd->m_pDatafd);

        /*дݳ*/
        CHAR szTemp[16];
        memset(szTemp, 0, 16);
        sprintf(szTemp, "%d\r\n", pstSpellVideoData->ulDataLen);
        fwrite(szTemp, strlen(szTemp), 1, pstFd->m_pLenfd);
    }

    return;
}

/**/
VOID STDCALL SaveYUVDataCallBack(IN ULONG_32 ulPort,
                              IN const PLAYER_PICTURE_DATA_S *pstDecodeVideoData,
                              IN VOID* pUserParam,
                              IN LONG_REAL lReserved)
{
    FILE *pfd = (FILE *)pUserParam;

    if (NULL != pfd)
    {
        //дyuv
        fwrite(pstDecodeVideoData->pucData[0],
               pstDecodeVideoData->ulPicHeight * pstDecodeVideoData->ulLineSize[0], 1, pfd);
        fwrite(pstDecodeVideoData->pucData[1],
               pstDecodeVideoData->ulPicHeight * pstDecodeVideoData->ulLineSize[1] / 2, 1, pfd);
        fwrite(pstDecodeVideoData->pucData[2],
               pstDecodeVideoData->ulPicHeight * pstDecodeVideoData->ulLineSize[2] / 2, 1, pfd);
    }

    return;
}

/*RTMPϱص*/
VOID _RtmpErrReportCB(IN ULONG_32 ulSessionNo, IN NDRTMP_ERROR_TYPE_E enErrorType)
{
    int iSize = 0;
    wchar_t* pwszUnicode = NULL;
    CHAR szInfo[256] = {0};
    sprintf(szInfo,  "Session[S%03d] report %d", ulSessionNo, enErrorType);

    //ؽַ軺ĴСѾַβ'\0'
    iSize = MultiByteToWideChar(CP_ACP, 0, szInfo , -1, NULL, 0);
    pwszUnicode = (wchar_t *)malloc(iSize*sizeof(wchar_t));
    MultiByteToWideChar(CP_ACP, 0, szInfo , -1, pwszUnicode , iSize);

    MessageBox(NULL, pwszUnicode, _T("RTMP INFO"), MB_OK);

    free(pwszUnicode);

    pwszUnicode = NULL;

    return;
}

/*RMϱص*/
VOID _RmErrReportCB( IN ULONG ulSessionNo, IN IMCP_RM_ERROR_TYPE_E enErrorType )
{
        int iSize = 0;
    wchar_t* pwszUnicode = NULL;
    CHAR szInfo[256] = {0};
    sprintf(szInfo,  "Session[S%03d] report %d", ulSessionNo, enErrorType);

    //ؽַ軺ĴСѾַβ'\0'
    iSize = MultiByteToWideChar(CP_ACP, 0, szInfo , -1, NULL, 0);
    pwszUnicode = (wchar_t *)malloc(iSize*sizeof(wchar_t));
    MultiByteToWideChar(CP_ACP, 0, szInfo , -1, pwszUnicode , iSize);

    MessageBox(NULL, pwszUnicode, _T("RM INFO"), MB_OK);

    free(pwszUnicode);
    pwszUnicode = NULL;

    return;
}

VOID InputRtmpData( IN ULONG_32 ulSessionNo, IN CHAR *pcRtmpDataBuf, IN LONG_32 lBufLen )
{
    EnterCriticalSection(&CPlayManager::sm_stLock);

    std::map<ULONG, ULONG_32>::iterator it =  CPlayManager::sm_oSessionPortMap.begin();
    for (; it != CPlayManager::sm_oSessionPortMap.end(); it++)
    {
        if (ulSessionNo == it->first)
        {
            NDPlayer_InputMediaData(it->second, (UCHAR *)pcRtmpDataBuf, (ULONG_32)lBufLen);
            break;
        }
    }

    LeaveCriticalSection(&CPlayManager::sm_stLock);

    return;
}

VOID InputData( IN ULONG ulSessionNo, IN CHAR *pcDataBuf, IN INT lBufLen )
{
    EnterCriticalSection(&CPlayManager::sm_stLock);
    std::map<ULONG, ULONG_32>::iterator it =  CPlayManager::sm_oSessionPortMap.begin();
    for (; it != CPlayManager::sm_oSessionPortMap.end(); it++)
    {
        if (ulSessionNo == it->first)
        {
            NDPlayer_InputMediaData(it->second, (UCHAR *)pcDataBuf, (ULONG_32)lBufLen);
            break;
        }
    }
    LeaveCriticalSection(&CPlayManager::sm_stLock);

    return;
}

VOID STDCALL IVA_DATA_CallBack(IN ULONG_32 ulPort,
                          IN IVA_REPORT_RULE_HEAD_V2_S *pRuleHead,
                          IN const VOID *pRuleData,
                          IN ULONG_32 ulRuleLen,
                          IN IVA_REPORT_RESULT_HEAD_V2_S *pResultHead,
                          IN const VOID *pResultData,
                          IN ULONG_32 ulResultLen,
                          IN VOID* pUserParam,
                          IN LONG_REAL lReserved)
{
    return;
}

ULONG Dll_FindDllPath(OUT CHAR szDllPath[], ULONG ulPathLenth)
{
    /* DLLڵ· */
    std::string strCheckDllPath;
    CHAR szPath[MAX_PATH] = {0};

    /* õǰDLLľ */
    std::string strDllName = "NDPlayer.dll";
    HMODULE hModule = GetModuleHandleA(strDllName.c_str());

    (VOID)GetModuleFileNameA(hModule, szPath, MAX_PATH);

    std::string strTmp = szPath;
    std::string::size_type uiPosition = strTmp.find_last_of("\\");
    if (uiPosition == std::string::npos)
    {
        uiPosition = strTmp.find_last_of("/");
        if (uiPosition == std::string::npos)
        {
            return ERR_PLAYER_FAIL;
        }
    }
    strCheckDllPath = strTmp.substr(0, uiPosition);

    if (strCheckDllPath.length() <= ulPathLenth)
    {
        strcpy(szDllPath, strCheckDllPath.c_str());
    }
    else
    {
        return ERR_PLAYER_NO_MEMORY;
    }

    return ERR_PLAYER_SUCCEED;
}

CPlayManager::CPlayManager()
{
    m_hWnd = NULL;
    m_ulPort = 0xFFFFFFFF;
    m_ulSession = 0xFFFFFFFF;
    m_ulLocalPort = 0xFFFFFFFF;
    m_bIvaOsd = BOOL_FALSE;
    m_bWaterMark = BOOL_FALSE;
    m_bPause = BOOL_FALSE;
    m_ulSpeed = PLAYER_SPEED_1_FORWARD;
    m_bSaveRtpData = BOOL_FALSE;
    m_bSaveYUVData = BOOL_FALSE;
    m_bSaveSpellData = BOOL_FALSE;
    m_bIvaData = BOOL_FALSE;
    m_pfd = NULL;
    m_hThread = 0;
    m_ulStartType = START_TYPE_STOP_PLAY;

    InterlockedIncrement(&sm_InitRefCount);
    if (1 == sm_InitRefCount)
    {
        InitializeCriticalSection(&sm_stLock);

        NDPlayer_SetWriteLogCB(pfnSyslog2);
        NDPlayer_Init();
        NDRtmp_Init(PLAYER_MAX_SESSION, _RtmpErrReportCB, NULL, (NDRTMP_SYS_LOG_PF)pfnSyslog);
#ifdef USE_PARAM
        SetMaxCacheIn(100);
#endif
        NDPlayer_SetPlayerRunMsgCB(pfnRunInfo);
        IMCP_RM_Init(32, _RmErrReportCB, (IMCP_RM_RTSPDATA_OUTPUT_PF)InputData, (IMCP_RM_UNVDATA_OUTPUT_PF)InputData, (IMCP_RM_SYS_LOG_PF)pfnSyslog);
    }
}

CPlayManager::~CPlayManager()
{
    if (0 == InterlockedDecrement(&sm_InitRefCount))
    {
        IMCP_RM_Cleanup();
        NDRtmp_Cleanup();
        NDPlayer_Cleanup();
        DeleteCriticalSection(&sm_stLock);
    }
}

ULONG_32 CPlayManager::GetVersion()
{
    return NDPlayer_GetVersion();
}

BOOL_T CPlayManager::OpenSound()
{
    return NDPlayer_OpenSound(m_ulPort);
}

BOOL_T CPlayManager::CloseSound()
{
    return NDPlayer_CloseSound(m_ulPort);
}

ULONG CPlayManager::SetSoundVulue( IN LONG_32 lVolume )
{
    BOOL_T ulRet = NDPlayer_SetSoundVolume(m_ulPort, lVolume);
    if(BOOL_TRUE != ulRet)
    {
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] StartPlay::NDPlayer_SetSoundVolume Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }
    return ERR_PLAYER_SUCCEED;
}

ULONG CPlayManager::SetMicValue( IN LONG_32 lVolume )
{
    ULONG ulRet = NDPlayer_SetMicVolume(m_ulPort, lVolume);
    if(ERR_PLAYER_SUCCEED != ulRet)
    {
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] StartPlay::NDPlayer_SetMicVolume Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }
    return ERR_PLAYER_SUCCEED;
}

BOOL_T CPlayManager::SetRenderScale(IN HANDLE hWnd, IN LONG_32 lRenderScale)
{
    return NDPlayer_SetRenderScale(m_ulPort, hWnd, lRenderScale);
}

BOOL_T CPlayManager::GetFrameRate( OUT LONG_32 *plFrameRate )
{
    return NDPlayer_GetFrameRate(m_ulPort, plFrameRate);
}

BOOL_T CPlayManager::GetBitRate( OUT LONG_32 *plBitRate )
{
    return NDPlayer_GetBitRate(m_ulPort, plBitRate);
}

BOOL_T CPlayManager::GetLostPacketRate( OUT FLOAT *pfLostRate )
{
    BOOL_T bRet = BOOL_TRUE;
    LONG_32 lLostPktNum = 0, lRecvPktNum = 0;
    NDPlayer_GetLostPacketRate(m_ulPort, &lRecvPktNum, &lLostPktNum);
    *pfLostRate = (PLAYER_RECV_PKT_NUM_ZERO == lRecvPktNum)? 0 : (FLOAT)lLostPktNum / (FLOAT) lRecvPktNum;

    return bRet;
}

BOOL_T CPlayManager::ResetLostPacketRate()
{
    return NDPlayer_ResetLostPacketRate(m_ulPort);
}

BOOL_T CPlayManager::GetEncodeType( OUT ULONG_32 *pulVideoEncodeType, OUT ULONG_32 *pulAudioEncodeType )
{
    return NDPlayer_GetEncodeType(m_ulPort, pulVideoEncodeType, pulAudioEncodeType);
}

BOOL_T CPlayManager::GetPictureSize( OUT LONG_32 *plWidth, OUT LONG_32 *plHeight )
{
    return NDPlayer_GetPictureSize(m_ulPort, plWidth, plHeight);
}

BOOL_T CPlayManager::GetPacketQueueStart(INOUT ULONG_32 *pulFrameCount, INOUT ULONG_32 *pulPacketCount )
{
    BOOL_T bRet = BOOL_TRUE;
#ifdef USE_PARAM
    bRet = GetPacketQueueStartIn(m_ulPort, pulFrameCount, pulPacketCount);
#endif
    return bRet;
}

ULONG CPlayManager::GetPlayTime( INOUT ULONG_32 *pulPlayTime )
{
    ULONG ulRet = NDPlayer_GetPlayTime(m_ulPort, pulPlayTime);
    if(ERR_PLAYER_SUCCEED != ulRet)
    {
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] StartPlay::NDPlayer_GetPlayTime Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }
    return ERR_PLAYER_SUCCEED;
}

ULONG CPlayManager::GetFileTime( INOUT ULONG_32 *pulTotalTime )
{
    ULONG ulRet = NDPlayer_GetFileTime(m_ulPort, pulTotalTime);
    if(ERR_PLAYER_SUCCEED != ulRet)
    {
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] StartPlay::NDPlayer_GetFileTime Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }
    return ERR_PLAYER_SUCCEED;
}

ULONG CPlayManager::SetPlayTime( INOUT ULONG_32 ulPlayTime )
{
    ULONG ulRet = NDPlayer_SetPlayedTime(m_ulPort, ulPlayTime);
    if(ERR_PLAYER_SUCCEED != ulRet)
    {
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] StartPlay::NDPlayer_SetPlayedTime Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }
    return ERR_PLAYER_SUCCEED;
}

ULONG CPlayManager::StartVoice( IN CString strIpAddr, IN CString strName, IN CString strPassWD, IN LONG_32 lProtl )
{
    CHAR szUrl[MAX_PATH] = {0};
    CHAR szAddr[MAX_PATH] = {0};
    CHAR szName[MAX_PATH] = {0};
    CHAR szPassWD[MAX_PATH] = {0};
    CHAR szSessionId[IMCP_RM_SESSIONID_LEN] = {0};
    ULONG ulPort = m_ulPort;
    ULONG_32 ulVoiceSvcType = PLAYER_VOICE_SERVICE_TALKBACK_CAPTURE;

    (VOID)w2c(szAddr,   (wchar_t *)strIpAddr.GetBuffer(0), MAX_PATH);
    (VOID)w2c(szName,   (wchar_t *)strName.GetBuffer(0), MAX_PATH);
    (VOID)w2c(szPassWD, (wchar_t *)strPassWD.GetBuffer(0), MAX_PATH);

    m_ulPort = 0;
    if (BOOL_TRUE != NDPlayer_AllocPort(&m_ulPort))
    {
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] StartVoice::NDPlayer_AllocPort Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (BOOL_TRUE != NDPlayer_SetPacketBuffer(m_ulPort, PLAYER_BUFFER_SIZE, 0))
    {
        NDPlayer_FreePort(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] StartVoice::NDPlayer_SetPacketBuffer Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    _snprintf_s(szUrl, sizeof(szUrl), _TRUNCATE, RTSP_URLFMT_MAIN, szName, szPassWD, szAddr);

    if (0 != lProtl)
    {
        return ERR_PLAYER_FAIL;
    }

    gulLastError = IMCP_RM_StartStreamEx2(szUrl, IMCP_RM_VOICE_TCP, szAddr, 5050, BOOL_TRUE, 1, 0, 0, NULL, NULL, IMCP_RM_EXECUTE_TYPE_STANDARD, &m_ulSession,  szSessionId);
    if (EZR_COMMON_SUCCEED != gulLastError)
    {
        NDPlayer_FreePort(m_ulPort);
        LOG_MSG2(LOG_LEVEL_ERROR, "Session[%d] StartVoice::IMCP_RM_StartStreamEx2 Failed, Error Code[%d].", m_ulSession, gulLastError);
        return gulLastError;
    }

    gulLastError = IMCP_RM_GetSendSocket(m_ulSession, &m_hSocet);
    if (ERR_PLAYER_SUCCEED != gulLastError)
    {
        NDPlayer_FreePort(m_ulPort);
        IMCP_RM_StopStream(m_ulSession);
        LOG_MSG2(LOG_LEVEL_ERROR, "Session[%d] StartVoice::IMCP_RM_GetSendSocket Failed, Error Code[%d].", m_ulSession, gulLastError);
        return gulLastError;
    }

    if (BOOL_TRUE != NDPlayer_SetVoiceEncodeType(m_ulPort, PLAYER_AUDIO_ENCODE_G711U, PLAYER_WAVE_FORMAT_PCM8M16, 1))
    {
        NDPlayer_FreePort(m_ulPort);
        IMCP_RM_StopStream(m_ulSession);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] StartVoice::NDPlayer_SetVoiceEncodeType Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (BOOL_TRUE != NDPlayer_OpenVoiceSvc(m_ulPort, ulVoiceSvcType, m_hSocet, NULL, 0, NULL, 0, PLAYER_PROTOCOL_TCP))
    {
        CPlayManager::sm_oSessionPortMap.erase(m_ulSession);

        NDPlayer_FreePort(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_INFO, "Port[%d] StartVoice::NDPlayer_FreePort, Error Code[%d].", m_ulPort, gulLastError);

        m_ulPort = ulPort;
        
        IMCP_RM_StopStream(m_ulSession);
        LOG_MSG1(LOG_LEVEL_INFO, "Session[%d] StartVoice::IMCP_RM_StopStream.", m_ulSession);

        MessageBox(NULL, _T("Open Voice error"), _T("error"), 0);
        return gulLastError;
    }

    CPlayManager::sm_oSessionPortMap.insert(std::pair<ULONG, ULONG_32>(m_ulSession, m_ulPort));

    return ERR_PLAYER_SUCCEED;
}

ULONG CPlayManager::StopVoice()
{
    NDPlayer_CloseVoiceSvc(m_ulPort);

    gulLastError = IMCP_RM_StopStream(m_ulSession);
    if (EZR_COMMON_SUCCEED != gulLastError)
    {
        LOG_MSG2(LOG_LEVEL_INFO, "Session[%d] StopVoice::IMCP_RM_StopStream , Error Code[%d].", m_ulSession, gulLastError);
        return gulLastError;
    }

    CPlayManager::sm_oSessionPortMap.erase(m_ulSession);
    return EZR_COMMON_SUCCEED;
}

BOOL_T CPlayManager::SpeedSlow()
{
    if (PLAYER_SPEED_QUARTER_FORWARD != m_ulSpeed)
    {
        m_ulSpeed--;
        return NDPlayer_SpeedPlay(m_ulPort, m_ulSpeed);
    }
    else
    {
        return BOOL_FALSE;
    }
}

BOOL_T CPlayManager::SpeedFast()
{
    if (PLAYER_SPEED_16_FORWARD != m_ulSpeed)
    {
        m_ulSpeed++;
        return NDPlayer_SpeedPlay(m_ulPort, m_ulSpeed);
    }
    else
    {
        return BOOL_FALSE;
    }
}

ULONG CPlayManager::AFrameGo()
{
    PausePlay();

    ULONG ulRet = NDPlayer_AFrameGo(m_ulPort);
    if(ERR_PLAYER_SUCCEED != ulRet)
    {
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] AFrameGo::NDPlayer_AFrameGo Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }
    return ERR_PLAYER_SUCCEED;
}

BOOL_T CPlayManager::SaveRtpData(CString cSavePath)
{
    if (BOOL_FALSE == m_bSaveRtpData)
    {
        if (START_TYPE_STOP_PLAY != m_ulStartType)
        {
            SYSTEMTIME stTime = {0};
            CHAR szDataPath[MAX_PATH] = {0};
            CHAR szLenPath[MAX_PATH] = {0};
            w2c(szDataPath, (wchar_t *)cSavePath.GetBuffer(0), MAX_PATH);
            GetLocalTime(&stTime);

            CHAR szTemp[512] = {0};
            w2c(szTemp, (wchar_t *)cSavePath.GetBuffer(0), 512);
            if(0 != access(szTemp, 0))
            {
                CreateDirectoryW(cSavePath, NULL);
                MessageBox(NULL, _T("Create Dir"), _T("info"), MB_OK);
            }
            sprintf(szDataPath, "%s\\data%02d%02d%02d%02d%02d.rtp", 
                szTemp, stTime.wMonth, stTime.wDay, stTime.wHour, stTime.wMinute, stTime.wSecond);
            sprintf(szLenPath, "%s.len", szDataPath);/*ļֱӼ.len׺ʶ*/

            stInputDataFd.m_pDatafd = fopen(szDataPath, "wb");
            stInputDataFd.m_pLenfd = fopen(szLenPath, "w");
            if (NULL == stInputDataFd.m_pDatafd || NULL == stInputDataFd.m_pLenfd)
            {
                MessageBox(NULL, _T("SaveRtpData error"), _T("error"), MB_OK);
                return BOOL_FALSE;
            }

            if (BOOL_FALSE == NDPlayer_SetSourceMediaDataCB(m_ulPort, SaveRtpDataCallBack, BOOL_TRUE, &stInputDataFd))
            {
                MessageBox(NULL, _T("SaveRtpData error"), _T("error"), MB_OK);
                fclose(stInputDataFd.m_pDatafd);
                fclose(stInputDataFd.m_pLenfd);
                remove(szDataPath);
                remove(szLenPath);
                return BOOL_FALSE;
            }

            m_bSaveRtpData = BOOL_TRUE;
            MessageBox(NULL, _T("SaveRtpData start"), _T("info"), MB_OK);
        }
        else
        {
            MessageBox(NULL, _T("Please start play before savedata"), _T("error"), MB_OK);
        }
    }
    else
    {
        (VOID)NDPlayer_SetSourceMediaDataCB(m_ulPort, NULL, BOOL_TRUE, NULL);

        fflush(stInputDataFd.m_pDatafd);
        fflush(stInputDataFd.m_pLenfd);
        fclose(stInputDataFd.m_pDatafd);
        fclose(stInputDataFd.m_pLenfd);
        
                stInputDataFd.m_pDatafd = NULL;
        stInputDataFd.m_pLenfd = NULL; 

        m_bSaveRtpData = BOOL_FALSE;

        MessageBox(NULL, _T("SaveRtpData stop"), _T("info"), MB_OK);
    }

    return BOOL_TRUE;
}

BOOL_T CPlayManager::SaveSpellData(CString cSavePath)
{
    if (BOOL_FALSE == m_bSaveSpellData)
    {
        if (START_TYPE_STOP_PLAY != m_ulStartType)
        {
            SYSTEMTIME stTime = {0};
            CHAR szDataPath[MAX_PATH] = {0};
            CHAR szLenPath[MAX_PATH] = {0};
            w2c(szDataPath, (wchar_t *)cSavePath.GetBuffer(0), MAX_PATH);
            GetLocalTime(&stTime);

            CHAR szTemp[512] = {0};
            w2c(szTemp, (wchar_t *)cSavePath.GetBuffer(0), 512);
            if(0 != access(szTemp, 0))
            {
                CreateDirectoryW(cSavePath, NULL);
                MessageBox(NULL, _T("Create Dir"), _T("info"), MB_OK);
            }
            sprintf(szDataPath, "%s\\data%02d%02d%02d%02d%02d.h26x", 
                szTemp, stTime.wMonth, stTime.wDay, stTime.wHour, stTime.wMinute, stTime.wSecond);
            sprintf(szLenPath, "%s.len", szDataPath);/*ļֱӼ.len׺ʶ*/

            stInputDataFd.m_pDatafd = fopen(szDataPath, "wb");
            stInputDataFd.m_pLenfd = fopen(szLenPath, "w");
            if (NULL == stInputDataFd.m_pDatafd || NULL == stInputDataFd.m_pLenfd)
            {
                MessageBox(NULL, _T("SaveSpellData error"), _T("error"), MB_OK);
                return BOOL_FALSE;
            }

            if (BOOL_FALSE == NDPlayer_SetParseVideoDataCB(m_ulPort, SaveSpellDataCallBack, BOOL_TRUE, &stInputDataFd))
            {
                MessageBox(NULL, _T("SaveSpellData error"), _T("error"), MB_OK);
                fclose(stInputDataFd.m_pDatafd);
                fclose(stInputDataFd.m_pLenfd);
                remove(szDataPath);
                remove(szLenPath);
                return BOOL_FALSE;
            }

            m_bSaveSpellData = BOOL_TRUE;
            MessageBox(NULL, _T("SaveSpellData start"), _T("info"), MB_OK);
        }
        else
        {
            MessageBox(NULL, _T("Please start play before savedata"), _T("error"), MB_OK);
        }
    }
    else
    {
        (VOID)NDPlayer_SetParseVideoDataCB(m_ulPort, NULL, BOOL_TRUE, NULL);

        fflush(stInputDataFd.m_pDatafd);
        fflush(stInputDataFd.m_pLenfd);
        fclose(stInputDataFd.m_pDatafd);
        fclose(stInputDataFd.m_pLenfd);
        stInputDataFd.m_pDatafd = NULL;
        stInputDataFd.m_pLenfd = NULL; 

        m_bSaveSpellData = BOOL_FALSE;

        MessageBox(NULL, _T("SaveSpellData stop"), _T("info"), MB_OK);
    }

    return BOOL_TRUE;
}

BOOL_T CPlayManager::SaveYUVData(CString cSavePath)
{
    if (BOOL_FALSE == m_bSaveYUVData)
    {
        if (START_TYPE_STOP_PLAY != m_ulStartType)
        {
            SYSTEMTIME stTime = {0};
            CHAR szPath[512] = {0};
            w2c(szPath, (wchar_t *)cSavePath.GetBuffer(0), 512);
            GetLocalTime(&stTime);

            CHAR szTemp[512] = {0};
            w2c(szTemp, (wchar_t *)cSavePath.GetBuffer(0), 512);
            if(0 != access(szTemp, 0))
            {
                CreateDirectoryW(cSavePath, NULL);
                MessageBox(NULL, _T("Create Dir"), _T("info"), MB_OK);
            }
            sprintf(szPath, "%s\\data%02d%02d%02d%02d%02d.yuv", 
                szPath, stTime.wMonth, stTime.wDay, stTime.wHour, stTime.wMinute, stTime.wSecond);

            m_pfd = fopen(szPath, "wb");
            if (NULL == m_pfd)
            {
                MessageBox(NULL, _T("SaveYUVData error"), _T("error"), MB_OK);
                return BOOL_FALSE;
            }

            if (BOOL_FALSE == NDPlayer_SetDecodeVideoMediaDataCB(m_ulPort, SaveYUVDataCallBack, BOOL_TRUE, m_pfd))
            {
                MessageBox(NULL, _T("SaveYUVData error"), _T("error"), MB_OK);
                fclose(m_pfd);
                m_pfd = NULL;
                remove(szPath);
                return BOOL_FALSE;
            }

            m_bSaveYUVData = BOOL_TRUE;
            MessageBox(NULL, _T("SaveYUVData start"), _T("info"), MB_OK);
        }
        else
        {
            MessageBox(NULL, _T("Please start play before saveYUVdata"), _T("error"), MB_OK);
        }
    }
    else
    {
        (VOID)NDPlayer_SetDecodeVideoMediaDataCB(m_ulPort, NULL, BOOL_TRUE, NULL);

        fflush(m_pfd);
        fclose(m_pfd);
        m_pfd = NULL;

        m_bSaveYUVData = BOOL_FALSE;

        MessageBox(NULL, _T("SaveYUVData stop"), _T("info"), MB_OK);
    }

    return BOOL_TRUE;
}

ULONG CPlayManager::PausePlay()
{
    m_bPause = ((BOOL_FALSE == m_bPause) ? BOOL_TRUE : BOOL_FALSE);

    ULONG ulRet = NDPlayer_PausePlay(m_ulPort, m_bPause);
    if(ERR_PLAYER_SUCCEED != ulRet)
    {
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] PausePlay::NDPlayer_PausePlay Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }
    return ERR_PLAYER_SUCCEED;
}

ULONG CPlayManager::Snaponce(CString cSnapPath, LONG_32 lSnapFmt)
{
    SYSTEMTIME stTime = {0};
    CHAR szPath[255] = {0};
    GetLocalTime(&stTime);
    CHAR szTemp[MAX_PATH] = {0};
    (VOID)w2c(szTemp, (wchar_t *)cSnapPath.GetBuffer(), MAX_PATH);

    sprintf_s(szPath, 255, "%s\\Record%04d%02d%02d-%02d%02d%02d", szTemp, stTime.wYear, stTime.wMonth, stTime.wDay, stTime.wHour, stTime.wMinute,
        stTime.wSecond);

    BOOL_T bRet = NDPlayer_SnatchOnce(m_ulPort, szPath, lSnapFmt, NULL);
    if(BOOL_TRUE != bRet)
    {
        gulLastError = NDPlayer_GetLastError();
        MessageBox(NULL, _T("Snap Failed"), _T("error"), MB_OK);
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] Snaponce::NDPlayer_SnatchOnce Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }
    MessageBox(NULL, _T("Snap OK"), _T("info"), MB_OK);

    return ERR_PLAYER_SUCCEED;
}

BOOL_T CPlayManager::IsFishEyeStream()
{
    return gabIsFishEye[0];
}

BOOL_T CPlayManager::SetDigital(HWND hWnd, PLAYER_RECT_S *pstRect)
{
    return NDPlayer_SetDigitalZoom(m_ulPort, hWnd, pstRect);
}

ULONG CPlayManager::SetPtzAndMode(ULONG_32 ulFixMode, ULONG_32 ulPtzMode)
{
    BOOL_T ulRet = NDPlayer_SetPtzAndFixMode(m_ulPort, ulPtzMode, ulFixMode);
    if(BOOL_TRUE != ulRet)
    {
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] SetPtzAndMode::NDPlayer_SetPtzAndFixMode Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }
    return ERR_PLAYER_SUCCEED;
}

ULONG CPlayManager::CheckMark( IN CString strFileAddr )
{
    BOOL_T bRet = BOOL_TRUE;
    PLAYER_MARK_INFO_S stMarkInfo ={0};
    CHAR szAddr[MAX_PATH] = {0};
    (VOID)w2c(szAddr, (wchar_t *)strFileAddr.GetBuffer(0), MAX_PATH);

    bRet = NDPlayer_AllocPort(&m_ulPort);
    if (BOOL_TRUE != bRet)
    {   
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] CheckMark::NDPlayer_AllocPort Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

     bRet = NDPlayer_CheckMark(m_ulPort, szAddr, &stMarkInfo);
    if (BOOL_TRUE == bRet)
    {
        if (0 == stMarkInfo.ulUnmarkCount)
        {
            WCHAR szwMarkInfo[32] = {0};
            int nLen = MultiByteToWideChar( CP_ACP, MB_PRECOMPOSED, stMarkInfo.szMarkInfo, -1, NULL, 0 );
            if (nLen == 0)
            {
                return ERR_PLAYER_FAIL;
            }
            MultiByteToWideChar( CP_ACP, MB_PRECOMPOSED, stMarkInfo.szMarkInfo, -1, szwMarkInfo, nLen );
            WCHAR szwMsg[64] = {0};
            swprintf(szwMsg, L"success, mark:%s", szwMarkInfo);
            MessageBox(NULL, szwMsg, _T("info"), MB_OK);
        }
        else
        {
            for (int i = 0; i < stMarkInfo.ulUnmarkCount; i++)
            {
                if (CHECK_STATE_MISMARCH == stMarkInfo.pastUnmarkTimeList[i].ulState )
                {
                    MessageBox(NULL, _T("mark error"), _T("error"), MB_OK);
                    return ERR_PLAYER_FAIL;
                }
            }

            MessageBox(NULL, _T("have no mark"), _T("warm"), MB_OK);
        }
    }
    else
    {
        MessageBox(NULL, _T("error"), _T("error"), MB_OK);
        gulLastError = NDPlayer_GetLastError();
    }

    NDPlayer_FreeMarkInfo(&stMarkInfo);

    NDPlayer_FreePort(m_ulPort);

    return gulLastError;
}

ULONG CPlayManager::RecordStart(CString cRecordPath, ULONG_32 ulMediaType)
{
    BOOL_T bRet = BOOL_TRUE;
    SYSTEMTIME stTime = {0};
    CHAR szPath[255] = {0};
    CHAR szTemp[MAX_PATH] = {0};
    (VOID)w2c(szTemp, (wchar_t *)cRecordPath.GetBuffer(), MAX_PATH);
        GetLocalTime(&stTime);

    sprintf_s(szPath, 255, "%s\\Record%04d%02d%02d-%02d%02d%02d",szTemp, stTime.wYear, stTime.wMonth, stTime.wDay, stTime.wHour, stTime.wMinute,
        stTime.wSecond);

    bRet = NDPlayer_SetRecordSize(m_ulPort, 1024);
    if(BOOL_TRUE != bRet)
    {
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] RecordStart::NDPlayer_SetRecordSize Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    bRet = NDPlayer_StartRecord(m_ulPort, szPath, ulMediaType, NULL);
    if(BOOL_TRUE != bRet)
    {
       gulLastError = NDPlayer_GetLastError();
       LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] RecordStart::NDPlayer_StartRecord Failed, Error Code[%d].", m_ulPort, gulLastError);
       return gulLastError;
    }

    //MessageBox(NULL, _T("Record Start!"), _T("info"), MB_OK);

    return ERR_PLAYER_SUCCEED;
}

ULONG CPlayManager::RecordStop()
{
    BOOL_T bRet = BOOL_TRUE;

    bRet = NDPlayer_StopRecord(m_ulPort);
    if(BOOL_TRUE != bRet)
    {
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] RecordStop::NDPlayer_StopRecord Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    //MessageBox(NULL, _T("Record Over!"), _T("info"), MB_OK);

    return ERR_PLAYER_SUCCEED;
}

//ļ
ULONG CPlayManager::StartFile( IN CString strFileAddr, IN HWND hWnd, BOOL_T bEnableVCA)
{
    CHAR szAddr[MAX_PATH] = {0};
    WCHAR szTime[256] = {0};
    ULONG_32 ulTime = 0;
    (VOID)w2c(szAddr, (wchar_t *)strFileAddr.GetBuffer(0), MAX_PATH);

    m_ulPort = 0;
    m_ulStartType = START_TYPE_FILE_PLAY;

    if (BOOL_TRUE == NDPlayer_MP4GetRealTime(szAddr, &ulTime))
    {
        swprintf(szTime, L"Start Time: %d", ulTime);
        MessageBox(NULL, szTime, L"Time", MB_OK);
    }

    if (BOOL_TRUE != NDPlayer_AllocPort(&m_ulPort))
    {
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] StartFile::NDPlayer_AllocPort Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (BOOL_TRUE != NDPlayer_SetPacketBuffer(m_ulPort, 3000, 0))
    {
        NDPlayer_FreePort(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] StartFile::NDPlayer_SetPacketBuffer Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (BOOL_TRUE != NDPlayer_SetIVAEnable(m_ulPort, bEnableVCA))
    {
        NDPlayer_FreePort(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] StartFile::NDPlayer_SetIVAEnable Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (BOOL_TRUE != NDPlayer_OpenMediaFile(m_ulPort, szAddr))
    {
        NDPlayer_FreePort(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] StartFile::NDPlayer_OpenMediaFile Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (BOOL_TRUE != NDPlayer_StartPlay(m_ulPort, hWnd))
    {
        NDPlayer_FreePort(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] StartFile::NDPlayer_StartPlay Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    m_hWnd = hWnd;
    m_ulSpeed = PLAYER_SPEED_1_FORWARD;
    m_bPause = BOOL_FALSE;

    return BOOL_TRUE;
}

//ͼƬ
ULONG CPlayManager::StartPic( IN CString strPicAddr, IN HWND hWnd )
{
    CHAR szAddr[MAX_PATH] = {0};
    (VOID)w2c(szAddr, (wchar_t *)strPicAddr.GetBuffer(0), MAX_PATH);

    if (BOOL_TRUE != NDPlayer_AllocPort(&m_ulPort))
    {
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] StartPic::NDPlayer_AllocPort Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (BOOL_TRUE != NDPlayer_SetPacketBuffer(m_ulPort, 3000, 0))
    {
        NDPlayer_FreePort(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] StartPic::NDPlayer_SetPacketBuffer Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (BOOL_TRUE != NDPlayer_OpenInputStream(m_ulPort, NULL, 0, 0))
    {
        NDPlayer_FreePort(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] StartPic::NDPlayer_OpenInputStream Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (BOOL_TRUE != NDPlayer_StartPlay(m_ulPort, hWnd))
    {
        NDPlayer_FreePort(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] StartPic::NDPlayer_StartPlay Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    FILE *fp = fopen(szAddr, "rb");
    if (NULL != fp)
    {
        fseek(fp, 0, SEEK_END);
        LONG lLen = ftell(fp);
        fseek(fp, 0, SEEK_SET);

        UCHAR *pucBuffer = (UCHAR*)malloc(lLen);
        if (NULL != pucBuffer)
        {
            fread(pucBuffer, lLen, 1, fp);
            (VOID)NDPlayer_InputMediaData(m_ulPort, pucBuffer, lLen);
            free(pucBuffer);
        }

        fclose(fp);
    }

    m_hWnd = hWnd;
    m_ulStartType = START_TYPE_RTSP_TCP_PLAY;
    m_ulSpeed = PLAYER_SPEED_1_FORWARD;
    m_bPause = BOOL_FALSE;

    return ERR_PLAYER_SUCCEED;
}

//ͨſвŰť
ULONG CPlayManager::StartPlay(IN CString strIpAddr,
                              IN CString strName,
                              IN CString strPassWD,
                              IN HWND hWnd,
                              IN LONG_32 lProtl,
                              IN LONG_32 lStream,
                              IN LONG_32 lFluency,
                              IN BOOL_T bEnableVCA)
{
    ULONG ulRet = ERR_PLAYER_SUCCEED;
    CHAR szUrl[MAX_PATH] = {0};
    CHAR szAddr[MAX_PATH] = {0};
    CHAR szName[MAX_PATH] = {0};
    CHAR szPassWD[MAX_PATH] = {0};
    CHAR szSessionId[IMCP_RM_SESSIONID_LEN] = {0};

    (VOID)w2c(szAddr, (wchar_t *)strIpAddr.GetBuffer(0), MAX_PATH);
    (VOID)w2c(szName, (wchar_t *)strName.GetBuffer(0), MAX_PATH);
    (VOID)w2c(szPassWD, (wchar_t *)strPassWD.GetBuffer(0), MAX_PATH);

    m_ulPort = 0;
    if (BOOL_TRUE != NDPlayer_AllocPort(&m_ulPort))
    {
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] StartPlay::NDPlayer_AllocPort Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (BOOL_TRUE != NDPlayer_SetPacketBuffer(m_ulPort, 1000, 0))
    {
        NDPlayer_FreePort(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] StartPlay::NDPlayer_SetPacketBuffer Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (BOOL_TRUE != NDPlayer_SetPictureFluency(m_ulPort, lFluency))
    {
        NDPlayer_FreePort(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] StartPlay::NDPlayer_SetPictureFluency Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (BOOL_TRUE != NDPlayer_SetIVAEnable(m_ulPort, bEnableVCA))
    {
        NDPlayer_FreePort(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] StartPlay::NDPlayer_SetIVAEnable Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (STREAM_TYPE_MAIN_STREAM == lStream)
    {
        _snprintf_s(szUrl, sizeof(szUrl), _TRUNCATE, RTSP_URLFMT_MAIN, szName, szPassWD, szAddr);
    }
    else if (STREAM_TYPE_SUB_STREAM == lStream)
    {
        _snprintf_s(szUrl, sizeof(szUrl), _TRUNCATE, RTSP_URLFMT_SECOND, szName, szPassWD, szAddr);
    }
    else
    {
        _snprintf_s(szUrl, sizeof(szUrl), _TRUNCATE, RTSP_URLFMT_THRID, szName, szPassWD, szAddr);
    }

    /* TCP */
    if (0 == lProtl)
    {
        if (BOOL_TRUE != NDPlayer_OpenInputStream(m_ulPort, NULL, 0, 0))
        {
            NDPlayer_FreePort(m_ulPort);
            gulLastError = NDPlayer_GetLastError();
            LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] StartPlay::NDPlayer_OpenInputStream Failed, Error Code[%d].", m_ulPort, gulLastError);
            return gulLastError;
        }

        IMCP_RM_GetSpareSessionNo(&m_ulSession);

        ULONG ulRet = IMCP_RM_StartStreamV2(m_ulSession, szUrl, IMCP_RM_RTP_TCP, szAddr, 
            0, 0, BOOL_TRUE, IMCP_RM_SCALE_1_FORWARD, 0,  0, NULL, NULL, IMCP_RM_EXECUTE_TYPE_STANDARD, &m_ulSession,  szSessionId);
        if (EZR_COMMON_SUCCEED != ulRet)
        {
            NDPlayer_FreePort(m_ulPort);
            LOG_MSG2(LOG_LEVEL_ERROR, "Session[%d] StartPlay::IMCP_RM_StartStreamV2 Failed, Error Code[%d].", m_ulSession, ulRet);
            return ulRet;
        }
    }
    else    /*UDP*/
    {
        if (BOOL_TRUE != NDPlayer_OpenNetStream(m_ulPort, NULL, 53016, szAddr, 0, PLAYER_PROTOCOL_UDP))
        {
            NDPlayer_FreePort(m_ulPort);
            gulLastError = NDPlayer_GetLastError();
            LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] StartPlay::NDPlayer_OpenNetStream Failed, Error Code[%d].", m_ulPort, gulLastError);
            return gulLastError;
        }

        IMCP_RM_GetSpareSessionNo(&m_ulSession);
        ULONG ulRet = IMCP_RM_StartStreamV2(m_ulSession, szUrl, IMCP_RM_RTP_UDP, "", 53016,53016, BOOL_TRUE, IMCP_RM_SCALE_1_FORWARD, 0, 0, NULL, NULL, (IMCP_RM_RTSP_EXECUTE_TYPE_E)IMCP_RM_EXECUTE_TYPE_STANDARD, &m_ulSession, szSessionId);
        if (0 != ulRet)
        {
            NDPlayer_FreePort(m_ulPort);
            LOG_MSG2(LOG_LEVEL_ERROR, "Session[%d] StartPlay::IMCP_RM_StartStreamV2 Failed, Error Code[%d].", m_ulSession, ulRet);
            return ulRet;
        }
    }

    if (BOOL_TRUE != NDPlayer_StartPlay(m_ulPort, hWnd))
    {
        NDPlayer_FreePort(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG1(LOG_LEVEL_ERROR, "StartPlay::NDPlayer_StartPlay Failed, Error Code[%d].", gulLastError);
        return gulLastError;
    }
    ulRet = SetPayloadType();
    if(ERR_PLAYER_SUCCEED != ulRet)
    {
        LOG_MSG1(LOG_LEVEL_ERROR, "StartPlay::SetPayloadType Failed, Error Code[%d].", ulRet);
    }
    SetAudioInfo();

    m_hWnd = hWnd;
    m_ulStartType = (0 == lProtl ? START_TYPE_RTSP_TCP_PLAY : START_TYPE_RTSP_UDP_PLAY);
    EnterCriticalSection(&CPlayManager::sm_stLock);
    CPlayManager::sm_oSessionPortMap.insert(std::pair<ULONG, ULONG_32>(m_ulSession, m_ulPort));
    LeaveCriticalSection(&CPlayManager::sm_stLock);

    return ERR_PLAYER_SUCCEED;
}

//ת
ULONG CPlayManager::StartLocalPlay(IN CString strIpAddr, IN CString strLocalPort, IN HWND hWnd, IN BOOL_T bEnableVCA)
{
    CHAR szUrl[MAX_PATH] = {0};
    CHAR szAddr[MAX_PATH] = {0};
    CHAR szLocalPort[MAX_PATH] = {0};
    ULONG ulRet = ERR_PLAYER_SUCCEED;
    USHORT usLocalPort = 0;

    (VOID)w2c(szAddr, (wchar_t *)strIpAddr.GetBuffer(0), MAX_PATH);
    (VOID)w2c(szLocalPort, (wchar_t *)strLocalPort.GetBuffer(0), MAX_PATH);
    usLocalPort = atol(szLocalPort);

    if (BOOL_TRUE != NDPlayer_AllocPort(&m_ulPort))
    {
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] StartPlay::NDPlayer_AllocPort Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (BOOL_TRUE != NDPlayer_SetPacketBuffer(m_ulPort, 3000, 1000))
    {
        NDPlayer_FreePort(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] StartPlay::NDPlayer_SetPacketBuffer Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (BOOL_TRUE != NDPlayer_SetIVAEnable(m_ulPort, bEnableVCA))
    {
        NDPlayer_FreePort(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] StartPlay::NDPlayer_SetIVAEnable Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (BOOL_TRUE != NDPlayer_OpenNetStream(m_ulPort, NULL, usLocalPort, szAddr, 0, PLAYER_PROTOCOL_UDP))
    {
        NDPlayer_FreePort(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] StartPlay::NDPlayer_OpenNetStream Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (BOOL_TRUE != NDPlayer_StartPlay(m_ulPort, hWnd))
    {
        NDPlayer_FreePort(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] StartPlay::NDPlayer_StartPlay Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    ulRet = SetPayloadType();
    if(ERR_PLAYER_SUCCEED != ulRet)
    {
        LOG_MSG1(LOG_LEVEL_ERROR, "StartPlay::SetPayloadType Failed, Error Code[%d].", ulRet);
    }
    SetAudioInfo();

    m_ulStartType = START_TYPE_LOCAL_PLAY;
    m_hWnd = hWnd;

    return ERR_PLAYER_SUCCEED;
}

VOID CPlayManager::StopPlay()
{
    gabIsFishEye[0] = BOOL_FALSE;

    //ԭʼݹǿйرƵʱҪԴ
    if(BOOL_TRUE == m_bSaveRtpData)
    {
        (VOID)NDPlayer_SetSourceMediaDataCB(m_ulPort, NULL, BOOL_TRUE, NULL);

        fflush(stInputDataFd.m_pDatafd);
        fflush(stInputDataFd.m_pLenfd);
        fclose(stInputDataFd.m_pDatafd);
        fclose(stInputDataFd.m_pLenfd);
        m_pfd = NULL;

        m_bSaveRtpData = BOOL_FALSE;

        MessageBox(NULL, _T("SaveRtpData stop"), _T("info"), MB_OK);
    }

    if(BOOL_TRUE == m_bSaveSpellData)
    {
        (VOID)NDPlayer_SetParseVideoDataCB(m_ulPort, NULL, BOOL_TRUE, NULL);

        fflush(stInputDataFd.m_pDatafd);
        fflush(stInputDataFd.m_pLenfd);
        fclose(stInputDataFd.m_pDatafd);
        fclose(stInputDataFd.m_pLenfd);
        m_pfd = NULL;

        m_bSaveSpellData = BOOL_FALSE;

        MessageBox(NULL, _T("SaveSpellData stop"), _T("info"), MB_OK);
    }

    if(BOOL_TRUE == m_bSaveYUVData)
    {
        (VOID)NDPlayer_SetDecodeVideoMediaDataCB(m_ulPort, NULL, BOOL_TRUE, NULL);

        fflush(m_pfd);
        fclose(m_pfd);
        m_pfd = NULL;

        m_bSaveYUVData = BOOL_FALSE;

        MessageBox(NULL, _T("SaveYUVData stop"), _T("info"), MB_OK);
    }

    //ݲͽйر
    switch(m_ulStartType)
    {
    case START_TYPE_RTSP_TCP_PLAY:
        {
            (VOID)IMCP_RM_StopStream(m_ulSession);
            (VOID)NDPlayer_StopPlay(m_ulPort, m_hWnd);
            (VOID)NDPlayer_CloseInputStream(m_ulPort);
            (VOID)NDPlayer_FreePort(m_ulPort);

            EnterCriticalSection(&CPlayManager::sm_stLock);
            CPlayManager::sm_oSessionPortMap.erase(m_ulSession);
            LeaveCriticalSection(&CPlayManager::sm_stLock);
            m_ulStartType = START_TYPE_STOP_PLAY;
            break;
        }
    case START_TYPE_FILE_PLAY:
        {
            (VOID)NDPlayer_StopPlay(m_ulPort, m_hWnd);
            (VOID)NDPlayer_CloseMediaFile(m_ulPort);
            (VOID)NDPlayer_FreePort(m_ulPort);

            m_ulStartType = START_TYPE_STOP_PLAY;
            break;
        }
    case START_TYPE_RTSP_UDP_PLAY:
        {
            (VOID)IMCP_RM_StopStream(m_ulSession);
            (VOID)NDPlayer_StopPlay(m_ulPort, m_hWnd);
            (VOID)NDPlayer_CloseNetStream(m_ulPort);
            (VOID)NDPlayer_FreePort(m_ulPort);

            EnterCriticalSection(&CPlayManager::sm_stLock);
            CPlayManager::sm_oSessionPortMap.erase(m_ulSession);
            LeaveCriticalSection(&CPlayManager::sm_stLock);

            m_ulStartType = START_TYPE_STOP_PLAY;
            break;
        }
    case START_TYPE_LOCAL_PLAY:
        {
            (VOID)NDPlayer_StopPlay(m_ulPort, m_hWnd);
            (VOID)NDPlayer_CloseNetStream(m_ulPort);
            (VOID)NDPlayer_FreePort(m_ulPort);

            m_ulStartType = START_TYPE_STOP_PLAY;
            break;
        }
    case START_TYPE_INPUT_PLAY:
        {
            m_bRun = BOOL_FALSE;
            (VOID)NDPlayer_StopPlay(m_ulPort, m_hWnd);
            (VOID)NDPlayer_CloseInputStream(m_ulPort);
            (VOID)NDPlayer_FreePort(m_ulPort);

            m_ulStartType = START_TYPE_STOP_PLAY;
            break;
        }
    case START_TYPE_RTMP_PLAY:
        {
            (VOID)NDRtmp_StopStream(m_ulSession);
            (VOID)NDPlayer_StopPlay(m_ulPort, m_hWnd);
            (VOID)NDPlayer_CloseInputStream(m_ulPort);
            (VOID)NDPlayer_FreePort(m_ulPort);

            EnterCriticalSection(&CPlayManager::sm_stLock);
            CPlayManager::sm_oSessionPortMap.erase(m_ulSession);
            LeaveCriticalSection(&CPlayManager::sm_stLock);

            m_ulStartType = START_TYPE_STOP_PLAY;
            break;
        }
    case START_TYPE_HLS_PLAY:
        {
            (VOID)NDPlayer_StopPlay(m_ulPort, m_hWnd);
#ifdef USE_PARAM
            CloseHlsStreamIn(m_ulPort);
#endif
            (VOID)NDPlayer_FreePort(m_ulPort);

            m_ulStartType = START_TYPE_STOP_PLAY;
            break;
        }
    case START_TYPE_STOP_PLAY:
    default:
        {
            return;
        }
    }

    InvalidateRect(m_hWnd, NULL, TRUE);

    return;
}

//rtmp url
ULONG CPlayManager::OpenRtmp(IN CString strIpAddr, 
                             IN HWND hWnd, 
                             IN LONG_32 lProtl, 
                             IN LONG_32 lStream, 
                             IN LONG_32 lFluency,
                             IN BOOL_T bEnableVCA)
{
    CHAR szAddr[MAX_PATH] = {0};
    ULONG ulRet = ERR_PLAYER_SUCCEED;
    (VOID)w2c(szAddr, (wchar_t *)strIpAddr.GetBuffer(0), MAX_PATH);
    m_ulStartType = START_TYPE_RTMP_PLAY;

    if (BOOL_TRUE != NDPlayer_AllocPort(&m_ulPort))
    {
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] OpenRtmp::NDPlayer_AllocPort Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (BOOL_TRUE != NDPlayer_SetPacketBuffer(m_ulPort, 8000, 0))
    {
        NDPlayer_FreePort(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] OpenRtmp::NDPlayer_SetPacketBuffer Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (BOOL_TRUE != NDPlayer_SetPictureFluency(m_ulPort, lFluency))
    {
        NDPlayer_FreePort(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] OpenRtmp::NDPlayer_SetPictureFluency Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (BOOL_TRUE != NDPlayer_SetIVAEnable(m_ulPort, bEnableVCA))
    {
        NDPlayer_FreePort(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] OpenRtmp::NDPlayer_SetIVAEnable Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (BOOL_TRUE != NDPlayer_OpenInputStream(m_ulPort, NULL, 0, 0))
    {
        NDPlayer_FreePort(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] OpenRtmp::NDPlayer_OpenInputStream Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (BOOL_TRUE != NDPlayer_StartPlay(m_ulPort, hWnd))
    {
        NDPlayer_FreePort(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] OpenRtmp::NDPlayer_StartPlay Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    LONG_32 lRet = NDRtmp_StartStream(szAddr, NDRTMP_STREAM_TCP, NULL, 0, NDRTMP_SPEED_NORMAL, 
        0, 0, NULL, InputRtmpData, NDRTMP_EXECUTE_NORMAL, NULL, (ULONG_32 *)&m_ulSession, NULL);
    if (ERR_RTMP_SUCCEED != lRet)
    {
        NDPlayer_FreePort(m_ulPort);
        MessageBox(NULL, _T("Start error"), _T("error"), MB_OK);
        LOG_MSG2(LOG_LEVEL_ERROR, "Session[%d] OpenRtmp::NDRtmp_StartStream Failed, Error Code[%d].", m_ulSession, lRet);
        return (ULONG)lRet;
    }

    ulRet = SetPayloadType();
    if(ERR_PLAYER_SUCCEED != ulRet)
    {
        LOG_MSG1(LOG_LEVEL_ERROR, "StartPlay::SetPayloadType Failed, Error Code[%d].", ulRet);
    }
    SetAudioInfo();

    m_hWnd = hWnd;
    m_ulStartType = START_TYPE_RTMP_PLAY;

    EnterCriticalSection(&CPlayManager::sm_stLock);
    CPlayManager::sm_oSessionPortMap.insert(std::pair<ULONG, ULONG_32>(m_ulSession, m_ulPort));
    LeaveCriticalSection(&CPlayManager::sm_stLock);

    return ERR_PLAYER_SUCCEED;
}

//rtsp url
ULONG CPlayManager::OpenRtsp(IN CString strIpAddr,
                             IN CString strURL,
                             IN HWND hWnd,
                             IN LONG_32 lProtl,
                             IN LONG_32 lExecute,
                             IN LONG_32 lFluency,
                             IN CString strStartTime,
                             IN CString strEndTime,
                             IN BOOL_T bEnableVCA)
{
    int nStartTime = _ttoi(strStartTime);
    int nEndTime = _ttoi(strEndTime);
    CHAR szAddr[MAX_PATH] = {0};
    CHAR szRUL[MAX_PATH] = {0};
    CHAR szSessionId[IMCP_RM_SESSIONID_LEN] = {0};
    ULONG ulRet = ERR_PLAYER_SUCCEED;

    (VOID)w2c(szAddr, (wchar_t *)strIpAddr.GetBuffer(0), MAX_PATH);
    (VOID)w2c(szRUL, (wchar_t *)strURL.GetBuffer(0), MAX_PATH);

    if (BOOL_TRUE != NDPlayer_AllocPort(&m_ulPort))
    {
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] OpenRtsp::NDPlayer_AllocPort Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (BOOL_TRUE != NDPlayer_SetPictureFluency(m_ulPort, lFluency))
    {
        NDPlayer_FreePort(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] OpenRtsp::NDPlayer_SetPictureFluency Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (BOOL_TRUE != NDPlayer_SetIVAEnable(m_ulPort, bEnableVCA))
    {
        NDPlayer_FreePort(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] OpenRtsp::NDPlayer_SetIVAEnable Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (0 == lProtl)
    {
        if (BOOL_TRUE != NDPlayer_OpenInputStream(m_ulPort, NULL, 0, 0))
        {
            NDPlayer_FreePort(m_ulPort);
            gulLastError = NDPlayer_GetLastError();
            LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] OpenRtsp::NDPlayer_OpenInputStream Failed, Error Code[%d].", m_ulPort, gulLastError);
            return gulLastError;
        }

        if (0 == lExecute)
        {
            lExecute = IMCP_RM_EXECUTE_TYPE_FASTPLAY;
        }

        /* TCP */
        IMCP_RM_GetSpareSessionNo(&m_ulSession);
        ULONG ulRet = IMCP_RM_StartStreamV2(m_ulSession, szRUL, IMCP_RM_TS_TCP, szAddr, 
            0, 0, BOOL_TRUE, IMCP_RM_SCALE_1_FORWARD, nStartTime,  nEndTime, NULL, NULL, (IMCP_RM_RTSP_EXECUTE_TYPE_E)lExecute, &m_ulSession,  szSessionId);
        if (EZR_COMMON_SUCCEED != ulRet)
        {
            (VOID)NDPlayer_CloseInputStream(m_ulPort);
             NDPlayer_FreePort(m_ulPort);
             LOG_MSG2(LOG_LEVEL_ERROR, "Session[%d] OpenRtsp::IMCP_RM_StartStreamV2 Failed, Error Code[%d].", m_ulSession, ulRet);
             return ulRet;
        }
    }
    else
    {
        /* UDP */
        if (BOOL_TRUE != NDPlayer_OpenNetStream(m_ulPort, NULL, 53016, szAddr, 0, PLAYER_PROTOCOL_UDP))
        {
            NDPlayer_FreePort(m_ulPort);
            gulLastError = NDPlayer_GetLastError();
            LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] OpenRtsp::NDPlayer_OpenNetStream Failed, Error Code[%d].", m_ulPort, gulLastError);
            return gulLastError;
        }

        if (0xE0000000 == (ntohl(inet_addr(szAddr)) & 0xF0000000))
        {

        }
        else
        {
            IMCP_RM_GetSpareSessionNo(&m_ulSession);
            ULONG ulRet = IMCP_RM_StartStreamV2(m_ulSession, szRUL, IMCP_RM_RTP_UDP, "", 53016, 53016, BOOL_TRUE, IMCP_RM_SCALE_1_FORWARD, nStartTime, nEndTime, NULL, NULL, (IMCP_RM_RTSP_EXECUTE_TYPE_E)lExecute, &m_ulSession, szSessionId);
            if (0 != ulRet)
            {
                (VOID)NDPlayer_CloseNetStream(m_ulPort);
                NDPlayer_FreePort(m_ulPort);
                LOG_MSG2(LOG_LEVEL_ERROR, "Session[%d] OpenRtsp::IMCP_RM_StartStreamV2 Failed, Error Code[%d].", m_ulSession, ulRet);
                return ulRet;
            }
        }
    }

    if (BOOL_TRUE != NDPlayer_StartPlay(m_ulPort, hWnd))
    {
        if (0 == lProtl)
        {
            NDPlayer_CloseInputStream(m_ulPort);
        }
        else
        {
            NDPlayer_CloseNetStream(m_ulPort);
        }
        IMCP_RM_StopStream(m_ulSession);
        NDPlayer_FreePort(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] OpenRtsp::NDPlayer_StartPlay Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    ulRet = SetPayloadType();
    if(ERR_PLAYER_SUCCEED != ulRet)
    {
        LOG_MSG1(LOG_LEVEL_ERROR, "StartPlay::SetPayloadType Failed, Error Code[%d].", ulRet);
    }
    SetAudioInfo();

    m_hWnd = hWnd;
    m_ulStartType = (0 == lProtl ? START_TYPE_RTSP_TCP_PLAY : START_TYPE_RTSP_UDP_PLAY);
    EnterCriticalSection(&CPlayManager::sm_stLock);
    CPlayManager::sm_oSessionPortMap.insert(std::pair<ULONG, ULONG_32>(m_ulSession, m_ulPort));
    LeaveCriticalSection(&CPlayManager::sm_stLock);

    IMCP_RM_FUNC_SUP_INFO_S stInfo;
    stInfo.enFuncType = IMCP_RM_FUNC_SUP_TYPE_SCRAMBLING;
    IMCP_RM_IsSupport(m_ulSession, &stInfo);

    if (BOOL_TRUE == stInfo.bIsSupport)
    {
        MessageBox(NULL, _T("scrambling support"), _T("info"), MB_OK);
    }

    return ERR_PLAYER_SUCCEED;
}

BOOL_T CPlayManager::SetAudioInfo()
{
    IMCP_RM_AUDIO_INFO_S stAudioInfo = {0};
    PLAYER_AUDIO_INFO_S stPlayerAudioInfo = {0};

    IMCP_RM_GetAudioInfo(m_ulSession, &stAudioInfo);
    stPlayerAudioInfo.ucAudioType = stAudioInfo.ucAudioType;
    stPlayerAudioInfo.ucFrequencyIndex = stAudioInfo.ucFrequencyIndex;
    stPlayerAudioInfo.ucChannelNum = stAudioInfo.ucChannelNum;

    return NDPlayer_SetAudioInfo(m_ulPort, &stPlayerAudioInfo);

    return BOOL_FALSE;
}

ULONG CPlayManager::SetPayloadType()
{
    IMCP_RM_PAYLOAD_TYPE_S astRtspInfo[2] = {0};
    ULONG ulSizeRm = 2;
    ULONG ulIndex = 0;
    IMCP_RM_GetPayloadType(m_ulSession, &ulSizeRm, astRtspInfo);

    PLAYER_PAYLOAD_TYPE_S *pstPlayerInfo = (PLAYER_PAYLOAD_TYPE_S *)malloc(ulSizeRm * sizeof(PLAYER_PAYLOAD_TYPE_S));
    if (NULL == pstPlayerInfo)
    {
        return ERR_PLAYER_NO_MEMORY;
    }

    memset(pstPlayerInfo, 0, ulSizeRm * sizeof(PLAYER_PAYLOAD_TYPE_S));
    for (ulIndex = 0; ulIndex < ulSizeRm; ulIndex++)
    {
        pstPlayerInfo[ulIndex].ucPayloadType = astRtspInfo[ulIndex].ucPayloadType;
        pstPlayerInfo[ulIndex].ulSampleRate = astRtspInfo[ulIndex].ulSampleRate;

        switch (astRtspInfo[ulIndex].enPayloadType)
        {
        case IMCP_RM_STREAM_TYPE_G711U:
            {
                pstPlayerInfo[ulIndex].ulType = 1;
                pstPlayerInfo[ulIndex].enAudioPayloadType =  PLAYER_AUDIO_ENCODE_G711U;
                break;
            }
        case IMCP_RM_STREAM_TYPE_MP1L2:
            {
                pstPlayerInfo[ulIndex].ulType = 1;
                pstPlayerInfo[ulIndex].enAudioPayloadType =  PLAYER_AUDIO_ENCODE_MP2;
                break;
            }
        case IMCP_RM_STREAM_TYPE_AAC:
            {
                pstPlayerInfo[ulIndex].ulType = 1;
                pstPlayerInfo[ulIndex].enAudioPayloadType =  PLAYER_AUDIO_ENCODE_AAC;
                break;
            }
        case IMCP_RM_STREAM_TYPE_H264:
            {
                pstPlayerInfo[ulIndex].ulType = 0;
                pstPlayerInfo[ulIndex].enVideoPayloadType =  PLAYER_VIDEO_ENCODE_H264;
                break;
            }
        case IMCP_RM_STREAM_TYPE_JPEG:
            {
                pstPlayerInfo[ulIndex].ulType = 0;
                pstPlayerInfo[ulIndex].enVideoPayloadType =  PLAYER_VIDEO_ENCODE_MJPEG;
                break;
            }
        case IMCP_RM_STREAM_TYPE_G711A:
            {
                pstPlayerInfo[ulIndex].ulType = 1;
                pstPlayerInfo[ulIndex].enAudioPayloadType =  PLAYER_AUDIO_ENCODE_G711A;
                break;
            }
        case IMCP_RM_STREAM_TYPE_PCM:
            {
                pstPlayerInfo[ulIndex].ulType = 1;
                pstPlayerInfo[ulIndex].enAudioPayloadType =  PLAYER_AUDIO_ENCODE_PCM;
                break;
            }
        case IMCP_RM_STREAM_TYPE_H265:
            {
                pstPlayerInfo[ulIndex].ulType = 0;
                pstPlayerInfo[ulIndex].enVideoPayloadType =  PLAYER_VIDEO_ENCODE_H265;
                break;
            }
        default:
            {
                break;
            }

        }

    }

    NDPlayer_SetPayloadType(m_ulPort, ulSizeRm, pstPlayerInfo);
    free(pstPlayerInfo);

    return ERR_PLAYER_SUCCEED;
}

BOOL_T CPlayManager::OnMouseMove( IN ULONG_32 ulFlags, IN CPoint point)
{
     if (START_TYPE_STOP_PLAY != m_ulStartType)
     {
        PLAYER_POINT_S stPoint ={0};
        stPoint.usX = point.x;
        stPoint.usY = point.y;

        return NDPlayer_OnMouseMove(m_ulPort, ulFlags, stPoint);
    }

    return BOOL_FALSE;
}

BOOL_T CPlayManager::OnLButtonUp( IN ULONG_32 ulFlags, IN CPoint point )
{
    if (START_TYPE_STOP_PLAY != m_ulStartType)
    {
        PLAYER_POINT_S stPoint ={0};
        stPoint.usX = point.x;
        stPoint.usY = point.y;

        return NDPlayer_OnLButtonUp(m_ulPort, ulFlags, stPoint);
    }

    return BOOL_FALSE;
}

BOOL_T CPlayManager::OnLButtonDown( IN ULONG_32 ulFlags, IN CPoint point )
{
    if (START_TYPE_STOP_PLAY != m_ulStartType)
    {
        PLAYER_POINT_S stPoint ={0};
        stPoint.usX = point.x;
        stPoint.usY = point.y;

        return NDPlayer_OnLButtonDown(m_ulPort, ulFlags, stPoint);
    }

    return BOOL_FALSE;
}

BOOL_T CPlayManager::OnMouseHWheel( IN ULONG_32 ulFlags, IN short zDelta, IN CPoint pt )
{
    if (START_TYPE_STOP_PLAY != m_ulStartType)
    {
        PLAYER_POINT_S stPoint ={0};
        stPoint.usX = pt.x;
        stPoint.usY = pt.y;

        return NDPlayer_OnMouseWheel(m_ulPort, ulFlags, zDelta, stPoint);
    }

    return BOOL_FALSE;
}

ULONG CPlayManager::OpenHls( IN CString strIpAddr, IN HWND hWnd, IN CString strPlayTime)
{
    BOOL_T bRet = BOOL_TRUE;
    m_ulStartType = START_TYPE_HLS_PLAY;
    if (BOOL_TRUE != NDPlayer_AllocPort(&m_ulPort))
    {
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] OpenHls::NDPlayer_AllocPort Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }
#ifdef USE_PARAM
    bRet = OpenHlsStreamIn(m_ulPort);
#endif
    if (BOOL_TRUE != bRet)
    {
        NDPlayer_FreePort(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] OpenHls::NDPlayer_OpenHlsStream Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (BOOL_TRUE != NDPlayer_StartPlay(m_ulPort, hWnd))
    {
        NDPlayer_FreePort(m_ulPort);
#ifdef USE_PARAM
        CloseHlsStreamIn(m_ulPort);
#endif
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] OpenHls::NDPlayer_StartPlay Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    char* buffer = "#EXTM3U\n\
                   #EXT-X-VERSION:3\n\
                   #EXT-X-ALLOW-CACHE:NO\n\
                   #EXT-X-MEDIA-SEQUENCE:210235C2JP316B0000020623369403\n\
                   #EXT-X-TARGETDURATION:10\n\
                   #EXTINF:10.0,\n\
                   #EXT-X-PROGRAM-DATE-TIME:2019-03-04T05:25:32.000+08:00,\n\
                   http://costest0703.s3.ap-southeast-1.amazonaws.com/Video/210235C1V3F16B00092048ea634213/31995594450303213544?X-Amz-Algorithm=AWS4-HMAC-SHA256&X-Amz-Credential=AKIAJQ2QDSCREIGUWMCA%2F20190304%2Fap-southeast-1%2Fs3%2Faws4_request&X-Amz-Date=20190304T012539Z&X-Amz-Expires=3600&X-Amz-SignedHeaders=host&X-Amz-Signature=5325cd4107e0952b6c6ade00a144caf8a3ed5e85ca7d59f7ac05a40550825238\n\
                   #EXTINF:10.0,\n\
                   #EXT-X-PROGRAM-DATE-TIME:2019-03-04T05:25:42.000+08:00,\n\
                   http://costest0703.s3.ap-southeast-1.amazonaws.com/Video/210235C1V3F16B00092048ea634213/59542341990303213554?X-Amz-Algorithm=AWS4-HMAC-SHA256&X-Amz-Credential=AKIAJQ2QDSCREIGUWMCA%2F20190304%2Fap-southeast-1%2Fs3%2Faws4_request&X-Amz-Date=20190304T012539Z&X-Amz-Expires=3600&X-Amz-SignedHeaders=host&X-Amz-Signature=5f36cde090c4213d9ab355138a47db4adb155b93a1d36d213145496747389258\n\
                   #EXTINF:10.0,\n\
                   #EXT-X-PROGRAM-DATE-TIME:2019-03-04T05:25:52.000+08:00,\n\
                   http://costest0703.s3.ap-southeast-1.amazonaws.com/Video/210235C1V3F16B00092048ea634213/15957141580303213604?X-Amz-Algorithm=AWS4-HMAC-SHA256&X-Amz-Credential=AKIAJQ2QDSCREIGUWMCA%2F20190304%2Fap-southeast-1%2Fs3%2Faws4_request&X-Amz-Date=20190304T012539Z&X-Amz-Expires=3600&X-Amz-SignedHeaders=host&X-Amz-Signature=ff8b235d2499443f1dced1fc6d285d87f185b29b9f7d97bc9f61e2837241300b\n\
                   #EXTINF:10.0,\n\
                   #EXT-X-PROGRAM-DATE-TIME:2019-03-04T05:26:02.000+08:00,\n\
                   http://costest0703.s3.ap-southeast-1.amazonaws.com/Video/210235C1V3F16B00092048ea634213/17589677640303213614?X-Amz-Algorithm=AWS4-HMAC-SHA256&X-Amz-Credential=AKIAJQ2QDSCREIGUWMCA%2F20190304%2Fap-southeast-1%2Fs3%2Faws4_request&X-Amz-Date=20190304T012539Z&X-Amz-Expires=3600&X-Amz-SignedHeaders=host&X-Amz-Signature=ea6323f5b2cf47e6e456b02a1e3704dfce34d45a7a79a14b81d32294935fb67a\n\
                   #EXTINF:10.0,\n\
                   #EXT-X-PROGRAM-DATE-TIME:2019-03-04T05:26:12.000+08:00,\n\
                   http://costest0703.s3.ap-southeast-1.amazonaws.com/Video/210235C1V3F16B00092048ea634213/25864212770303213624?X-Amz-Algorithm=AWS4-HMAC-SHA256&X-Amz-Credential=AKIAJQ2QDSCREIGUWMCA%2F20190304%2Fap-southeast-1%2Fs3%2Faws4_request&X-Amz-Date=20190304T012539Z&X-Amz-Expires=3600&X-Amz-SignedHeaders=host&X-Amz-Signature=8a2147c79c94391c664d333274346a23afb4299dbe4c61a5feb79721243ba537\n\
                   #EXTINF:10.0,\n\
                   #EXT-X-PROGRAM-DATE-TIME:2019-03-04T05:26:22.000+08:00,\n\
                   http://costest0703.s3.ap-southeast-1.amazonaws.com/Video/210235C1V3F16B00092048ea634213/95564778230303213634?X-Amz-Algorithm=AWS4-HMAC-SHA256&X-Amz-Credential=AKIAJQ2QDSCREIGUWMCA%2F20190304%2Fap-southeast-1%2Fs3%2Faws4_request&X-Amz-Date=20190304T012539Z&X-Amz-Expires=3600&X-Amz-SignedHeaders=host&X-Amz-Signature=d3a3266398641a32dfaf63eef902e9d301920c84697ab6b77b74a5b0a205ace8\n\
                   #EXTINF:10.0,\n\
                   #EXT-X-PROGRAM-DATE-TIME:2019-03-04T05:26:32.000+08:00,\n\
                   http://costest0703.s3.ap-southeast-1.amazonaws.com/Video/210235C1V3F16B00092048ea634213/68132998840303213644?X-Amz-Algorithm=AWS4-HMAC-SHA256&X-Amz-Credential=AKIAJQ2QDSCREIGUWMCA%2F20190304%2Fap-southeast-1%2Fs3%2Faws4_request&X-Amz-Date=20190304T012539Z&X-Amz-Expires=3600&X-Amz-SignedHeaders=host&X-Amz-Signature=70d31bf0f18fb5c6e93f846cf1009c55b9799979f5ae5ac900df369cdec9e2f6\n\
                   #EXTINF:10.0,\n\
                   #EXT-X-PROGRAM-DATE-TIME:2019-03-04T05:26:42.000+08:00,\n\
                   http://costest0703.s3.ap-southeast-1.amazonaws.com/Video/210235C1V3F16B00092048ea634213/49822739990303213654?X-Amz-Algorithm=AWS4-HMAC-SHA256&X-Amz-Credential=AKIAJQ2QDSCREIGUWMCA%2F20190304%2Fap-southeast-1%2Fs3%2Faws4_request&X-Amz-Date=20190304T012539Z&X-Amz-Expires=3600&X-Amz-SignedHeaders=host&X-Amz-Signature=7a55d8bb32aaa6b90f56ebe5ccbbebcffa37e3844ee962b01cf538e4a263d4dd\n\
                   #EXT-X-ENDLIST\n";

#ifdef USE_PARAM
    bRet = UpdatePlayInfoIn(m_ulPort, buffer, 1551648332);
#endif
    if (BOOL_TRUE != bRet)
    {
        NDPlayer_FreePort(m_ulPort);
#ifdef USE_PARAM
        CloseHlsStreamIn(m_ulPort);
#endif
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] OpenHls::NDPlayer_UpdatePlayInfo Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    m_ulSpeed = PLAYER_SPEED_1_FORWARD;

    return ERR_PLAYER_SUCCEED;
}

ULONG CPlayManager::SetHlsTime( IN CString strPlayTime)
{
    int nTime = _ttoi(strPlayTime);
    BOOL_T bRet = BOOL_TRUE;

#ifdef USE_PARAM
    bRet = UpdatePlayInfoIn(m_ulPort, NULL, nTime);
#endif
    if (BOOL_TRUE != bRet)
    {
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] SetHlsTime::NDPlayer_UpdatePlayInfo Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }
    return ERR_PLAYER_SUCCEED;
}

BOOL_T CPlayManager::Open5ePtz()
{
    (void)NDPlayer_SetIVAEnable(m_ulPort, BOOL_TRUE);

    if(BOOL_FALSE == NDPlayer_SetPtzKeepAliveTime(m_ulPort, 3000))
    {
        return BOOL_FALSE;
    }
    if(BOOL_FALSE == NDPlayer_SetPtzDisplayMode(m_ulPort, PLAYER_PTZ_DISPLAY_5PTZ))
    {
        return BOOL_FALSE;
    }
    return BOOL_TRUE;
}

BOOL_T CPlayManager::Close5ePtz()
{
    (void)NDPlayer_SetIVAEnable(m_ulPort, BOOL_FALSE);
    return NDPlayer_SetPtzDisplayMode(m_ulPort, PLAYER_PTZ_DISPLAY_ORIGINAL);
}

ULONG_32 __h26xFileThreadEntry(VOID *pParam)
{
    CPlayManager *poManager = (CPlayManager *)pParam;
    if (NULL != poManager)
    {
        (VOID)poManager->h26xFileThreadEntry();
    }

    return ERR_PLAYER_SUCCEED;
}

VOID CPlayManager::h26xFileThreadEntry()
{
    UCHAR *pucBuffer = NULL;
    CHAR pcDataLen[16];
    CHAR *strDataLen = NULL;
    LONG_32 lDataLen = 0, lFrameRate = 0;
    FILE *fp1 = NULL, *fp2 = NULL;
    CHAR szLenPath[MAX_PATH];

    pucBuffer = (UCHAR * )malloc(4 * 1024 *1024);
    if (NULL == pucBuffer)
    {
        LOG_MSG0(LOG_LEVEL_ERROR, "h26xFileThreadEntry::No Memory.");
        return;
    }
    /*1lenļĳ 2ݳȶdat*/
    memset(szLenPath, 0, MAX_PATH);
    sprintf(szLenPath, "%s.len", szInputPath);

    fp1 = fopen(szInputPath, "rb");
    fp2 = fopen(szLenPath, "r");
    if(NULL == fp1 || NULL == fp2)
    {
        LOG_MSG0(LOG_LEVEL_ERROR, "h26xFileThreadEntry::Invaild Param.");
        return ;
    }

    while (1)
    {
        if (BOOL_FALSE == m_bRun)
        {
            fclose(fp1);
            fclose(fp2);
            free(pucBuffer);
            fp1 = NULL;
            fp2 = NULL;
            pucBuffer = NULL;
            ExitThread(0);
            return;
        }

        if (BOOL_TRUE == m_bPause)
        {
            Sleep(100);
            continue;
        }

        memset(pcDataLen,0,16);
        fgets(pcDataLen, 16 - 1, fp2);/*жȡļ*/
        strDataLen = strtok(pcDataLen, "\n");/*ַָ*/
        if(NULL != strDataLen)
        {
            lDataLen = atoi(strDataLen);
            if(lDataLen != fread(pucBuffer, 1, lDataLen, fp1))
            {
                MessageBox(NULL,  _T("File read finish"), _T("info"), MB_OK);
                break;
            }
            NDPlayer_InputMediaData(m_ulPort, pucBuffer, lDataLen);

            GetFrameRate(&lFrameRate);
            lFrameRate = (0 == lFrameRate) ? 25 : lFrameRate;
            Sleep(1000 / lFrameRate);
        }
        else
        {
            MessageBox(NULL,  _T("File read finish"), _T("info"), MB_OK);
            break;
        }
    }

    fclose(fp1);
    fclose(fp2);
    free(pucBuffer);
    fp1 = NULL;
    fp2 = NULL;
    pucBuffer = NULL;

    return;
}

ULONG_32 __RtpFileThreadEntry(VOID *pParam)
{
    CPlayManager *poManager = (CPlayManager *)pParam;
    if (NULL != poManager)
    {
        (VOID)poManager->RtpFileThreadEntry();
    }

    return ERR_PLAYER_SUCCEED;
}

VOID CPlayManager::RtpFileThreadEntry()
{
    UCHAR *pucBuffer = NULL;
    CHAR pcDataLen[16];
    CHAR *strDataLen = NULL;
    LONG_32 lDataLen = 0, lFrameRate = 0;
    FILE *fp1 = NULL, *fp2 = NULL;
    CHAR szLenPath[MAX_PATH];
    int i = 0;

    pucBuffer = (UCHAR * )malloc(4 * 1024 *1024);
    if (NULL == pucBuffer)
    {
        LOG_MSG0(LOG_LEVEL_ERROR, "h26xFileThreadEntry::No Memory.");
        return;
    }
    /*1lenļĳ 2ݳȶdat*/
    memset(szLenPath, 0, MAX_PATH);
    sprintf(szLenPath, "%s.len", szInputPath);

    fp1 = fopen(szInputPath, "rb");
    fp2 = fopen(szLenPath, "r");
    if(NULL == fp1 || NULL == fp2)
    {
        LOG_MSG0(LOG_LEVEL_ERROR, "h26xFileThreadEntry::Invaild Param.");
        return ;
    }

    while (1)
    {
        if (BOOL_FALSE == m_bRun)
        {
            fclose(fp1);
            fclose(fp2);
            free(pucBuffer);

            fp1 = NULL;
            fp2 = NULL;
            pucBuffer = NULL;

            ExitThread(0);
            return;
        }

        if (BOOL_TRUE == m_bPause)
        {
            Sleep(100);
            continue;
        }

        memset(pcDataLen,0,16);
        fgets(pcDataLen, 16 - 1, fp2);/*жȡļ*/
        strDataLen = strtok(pcDataLen, "\n");/*ַָ*/
        if(NULL != strDataLen)
        {
            lDataLen = atoi(strDataLen);
            if(lDataLen != fread(pucBuffer, 1, lDataLen, fp1))
            {
                MessageBox(NULL,  _T("File read finish"), _T("info"), MB_OK);
                break;
            }
            NDPlayer_InputMediaData(m_ulPort, pucBuffer, lDataLen);
            BOOL_T bMark1 = (pucBuffer[1] & 0x80) ? BOOL_TRUE : BOOL_FALSE;
            BOOL_T bMark = (pucBuffer[14] & 0x40) ? BOOL_TRUE : BOOL_FALSE;/*οrtpзƬģʽ֡βʶ*/
            if(BOOL_TRUE == bMark)/*Get Frame Over flag*/
            {
                GetFrameRate(&lFrameRate);
                lFrameRate = (0 == lFrameRate) ? 25 : lFrameRate;
                Sleep(1000 / lFrameRate / 2);
            }
        }
        else
        {
            MessageBox(NULL,  _T("File read finish"), _T("info"), MB_OK);
            break;
        }
    }

    fclose(fp1);
    fclose(fp2);
    free(pucBuffer);

    fp1 = NULL;
    fp2 = NULL;
    pucBuffer = NULL;

    return;
}

ULONG CPlayManager::PlayInputData(IN CString m_strFilePath, IN HWND hWnd)
{
    ULONG ulRet = ERR_PLAYER_SUCCEED;
    m_ulStartType = START_TYPE_INPUT_PLAY;
    m_hWnd = hWnd;

    if (BOOL_TRUE != NDPlayer_AllocPort(&m_ulPort))
    {
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] PlayInputData::NDPlayer_AllocPort Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (BOOL_TRUE != NDPlayer_SetPictureFluency(m_ulPort, 0))
    {
        NDPlayer_FreePort(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] PlayInputData::NDPlayer_SetPictureFluency Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (BOOL_TRUE != NDPlayer_SetIVAEnable(m_ulPort,BOOL_TRUE))
    {
        NDPlayer_FreePort(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] PlayInputData::NDPlayer_SetIVAEnable Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (BOOL_TRUE != NDPlayer_OpenInputStream(m_ulPort, NULL, 0, 0))
    {
        NDPlayer_FreePort(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] PlayInputData::NDPlayer_OpenInputStream Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    if (BOOL_TRUE != NDPlayer_StartPlay(m_ulPort, m_hWnd))
    {
        NDPlayer_FreePort(m_ulPort);
        NDPlayer_CloseInputStream(m_ulPort);
        gulLastError = NDPlayer_GetLastError();
        LOG_MSG2(LOG_LEVEL_ERROR, "Port[%d] PlayInputData::NDPlayer_StartPlay Failed, Error Code[%d].", m_ulPort, gulLastError);
        return gulLastError;
    }

    ulRet = SetPayloadType();
    if(ERR_PLAYER_SUCCEED != ulRet)
    {
        LOG_MSG1(LOG_LEVEL_ERROR, "StartPlay::SetPayloadType Failed, Error Code[%d].", ulRet);
    }
    SetAudioInfo();
     
     m_bRun = BOOL_TRUE;
     m_bPause = BOOL_FALSE;
    /*жǲesݻSpell*/
    memset(szInputPath, 0, MAX_PATH);
    (VOID)w2c(szInputPath, (wchar_t *)m_strFilePath.GetBuffer(0), MAX_PATH);

    CHAR *pcTail = strstr(szInputPath, ".h26x");
    if(NULL != pcTail)
    {
        m_hThread = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)__h26xFileThreadEntry, (VOID *)this, 0, NULL);
        return ERR_PLAYER_SUCCEED;
    }

    pcTail = strstr(szInputPath, ".rtp");
    if(NULL != pcTail)
    {
        int dwThreadid = 0;
        m_hThread = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)__RtpFileThreadEntry, (VOID*)this, 0, NULL);
        return ERR_PLAYER_SUCCEED;
    }

    return ERR_PLAYER_SUCCEED;
}

BOOL_T CPlayManager::IvaOSD()
{
    if (BOOL_FALSE == m_bIvaOsd)
    {
        NDPlayer_EnableTargetTag(m_ulPort, 1, 1, 1);
        NDPlayer_EnableIvaOsd(m_ulPort, BOOL_TRUE);
        m_bIvaOsd = BOOL_TRUE;
    }
    else
    {
        NDPlayer_EnableTargetTag(m_ulPort, 0, 0, 0);
        NDPlayer_EnableIvaOsd(m_ulPort, BOOL_FALSE);
        m_bIvaOsd = BOOL_FALSE;
    }

    return BOOL_TRUE;
}

VOID STDCALL DRAW_DATA_CALLBACK_PF(IN HANDLE hWnd,
                                   IN HANDLE hdc,
                                   IN VOID* pUserParam,
                                   IN LONG_REAL lReserved)
{
    /* Set Font*/
    CFont font;
    font.CreatePointFont(260, L"Arial");
    (VOID)::SelectObject((HDC)hdc, (HFONT)font);

    (VOID)::SetBkMode((HDC)hdc,TRANSPARENT); //Set Transparent
    (VOID)::SetTextColor((HDC)hdc,RGB(173,255,47));//Set Color

    CString strText = L"WATER MARK-WATER MARK";
    for (int lCount = 0; lCount < 5; lCount++)
    {
        (VOID)::TextOut((HDC)hdc, 70 * lCount, 100 * lCount, strText.GetBuffer(0), strText.GetLength());
    }

    return;
}

BOOL_T CPlayManager::VideoDrawWaterMark()
{
    if (BOOL_FALSE == m_bWaterMark)
    {
        NDPlayer_SetDrawMediaDataCB(m_ulPort, DRAW_DATA_CALLBACK_PF, NULL);
        m_bWaterMark = BOOL_TRUE;
    }
    else
    {
        NDPlayer_SetDrawMediaDataCB(m_ulPort, NULL, NULL);
        m_bWaterMark = BOOL_FALSE;
    }

    return BOOL_TRUE;
}

BOOL_T CPlayManager::SetVideoIvaDataCB()
{
    if (BOOL_FALSE == m_bIvaData)
    {
        NDPlayer_SetIvaDataCB(m_ulPort, IVA_DATA_CallBack,  NULL);
        m_bIvaData = BOOL_TRUE;
    }
    else
    {
        NDPlayer_SetIvaDataCB(m_ulPort, NULL,  NULL);
        m_bIvaData = BOOL_FALSE;
    }

    return BOOL_TRUE;
}