#ifndef __PLAYER_SDK_FUNC_H__
#define __PLAYER_SDK_FUNC_H__

#ifdef  __cplusplus
extern "C"{
#endif

#ifndef IN
    #define     IN
#endif

#ifndef OUT
    #define     OUT
#endif

#ifndef INOUT
    #define     INOUT
#endif

/* ׼Լ Standard function calling convention */
#ifdef WIN32
    #define STDCALL                 __stdcall
    #ifdef ND_PLAYER_DLL_EXPORTS
        #define ND_PLAYER_EXPORT    __declspec( dllexport )
    #else
        #define ND_PLAYER_EXPORT    __declspec( dllimport )
    #endif
#else
    #ifdef i386
        #define STDCALL             __attribute__((stdcall))
    #else
        #define STDCALL
    #endif
    #define ND_PLAYER_EXPORT
#endif

#ifndef CHAR_DEF
#define CHAR_DEF
    typedef char                    CHAR;
#endif

#ifndef UCHAR_DEF
#define UCHAR_DEF
    typedef unsigned char           UCHAR;
#endif

#ifndef HANDLE_DEF
#define HANDLE_DEF
    typedef void*                   HANDLE;
#endif

#ifndef SHORT_DEF
#define SHORT_DEF
    typedef short                   SHORT;
#endif

#ifndef USHORT_DEF
#define USHORT_DEF
    typedef unsigned short          USHORT;
#endif

#ifndef LONG_32_DEF
#define LONG_32_DEF
    typedef int                     LONG_32;
#endif

#ifndef ULONG_32_DEF
#define ULONG_32_DEF
    typedef unsigned int            ULONG_32;
#endif

#ifndef LONG_DEF
#define LONG_DEF
    typedef long                    LONG;
#endif

#ifndef ULONG_DEF
#define ULONG_DEF
    typedef unsigned long           ULONG;
#endif

#ifndef TIME_DEF
#define TIME_DEF
    typedef long                    TIME_T;
#endif

#ifndef LONG_REAL_DEF
#define LONG_REAL_DEF
    typedef long                    LONG_REAL;
#endif

#ifndef DLONG_DEF
#define DLONG_DEF
    #if defined (_MSC_VER)
        typedef __int64             DLONG;
    #else
        typedef long long           DLONG;
    #endif
#endif

#ifndef DULONG_DEF
#define DULONG_DEF
    #if defined (_MSC_VER)
        typedef unsigned __int64    DULONG;
    #else
        typedef unsigned long long  DULONG;
    #endif
#endif

#ifndef DOUBLE_DEF
#define DOUBLE_DEF
    typedef double                  DOUBLE;
#endif

#ifndef BOOL_T_DEF
#define BOOL_T_DEF
    typedef unsigned int            BOOL_T;
#endif

#ifndef BOOL_TRUE
    #define BOOL_TRUE               ((BOOL_T) 1)
#endif

#ifndef BOOL_FALSE
    #define BOOL_FALSE              ((BOOL_T) 0)
#endif

#ifndef VOID_DEF
#define VOID_DEF
    #define VOID                    void
#endif

/*********************** Player ͨóɹ**********************************  */
#define ERR_PLAYER_SUCCEED                      0x00000000      /**< ִгɹ */

/*********************** Player ͨô***********************************/
#define ERR_PLAYER_FAIL                         0x00000001      /**< ִʧ */
#define ERR_PLAYER_INVALID_PARAM                0x00000002      /**< Ƿ */
#define ERR_PLAYER_NO_MEMORY                    0x00000003      /**< ϵͳڴ治 */
#define ERR_PLAYER_SOCKET_FAIL                  0x00000004      /**< SOCKETʧ */
#define ERR_PLAYER_RECV_FAIL                    0x00000005      /**< ʧ */
#define ERR_PLAYER_RECV_ZERO                    0x00000006      /**< Ϊ */
#define ERR_PLAYER_NOT_SUPPORT                  0x00000007      /**< ݲ֧ */
#define ERR_PLAYER_CREATETHREAD_FAILED          0x00000008      /**< ߳ʧ */
#define ERR_PLAYER_OPENDL_FAILED                0x00000009      /**< ض̬ʧ */
#define ERR_PLAYER_SYMDL_FAILED                 0x0000000A      /**< ȡ̬ʧ */
#define ERR_PLAYER_SEND_FAILED                  0x0000000B      /**< ʧ */
#define ERR_PLAYER_EACCES                       0x0000000C      /**< ļȨ޲ */
#define ERR_PLAYER_FILE_NOT_FIND                0x0000000D      /**< ļδҵ */
#define ERR_PLAYER_LOG_CLOSE                    0x0000000E      /**< Player ־ر */
#define ERR_PLAYER_BUFFER_NOT_ENOUGH            0x0000000F      /**< 治 */
#define ERR_PLAYER_RES_NOT_ENOUGH               0x00000010      /**< Դ */
#define ERR_PLAYER_MEDIA_EXCEPTION              0x00000011      /**< ڲ쳣 */

/*********************** Player Դ********************************/
#define ERR_FAIL_TO_INIT_EZPLAYER               0x00000101      /**< ʼʧ */
#define ERR_FAIL_TO_ALLOC_PORT_RES              0x00000102      /**< 䲥ͨԴʧ */
#define ERR_FAIL_TO_GET_PORT_RES                0x00000103      /**< òͨԴʧ */
#define ERR_BUFFER_QUEUE_FULL                   0x00000104      /**<  */
#define ERR_BUFFER_QUEUE_EMPTY                  0x00000105      /**< п */
#define ERR_OPEN_FILE_FAILED                    0x00000106      /**< ļʧ */
#define ERR_FILE_READ_END                       0x00000107      /**< ļѾȡ */
#define ERR_FILE_DISKSPACE_FULL                 0x00000108      /**< ̿ռ */
#define ERR_FILE_READ_FAIL                      0x00000109      /**< ȡʧ */
#define ERR_MCM_MIC_NOT_EXIST                   0x0000010A      /**< ˷粻 */
#define ERR_TS_PACKET_IN_THE_ROUGH              0x0000010B      /**< TSδ */
#define ERR_FILE_RECORD_FINISH                  0x0000010C      /**< ¼񱣴 */
#define ERR_VIDEO_RESOLUTION_CHANGE             0x0000010D      /**< ֱʷ仯 */
#define ERR_VIDEO_RECORD_PART                   0x0000010E      /**< ¼ֶ */
#define ERR_FILE_DESTROY                        0x0000010F      /**< ýļѱƻ */
#define ERR_FILE_FSEEK_FAIL                     0x00000110      /**< ƶļָʧ */
#define ERR_FILE_NOT_OPEN                       0x00000111      /**< δ򿪵ļ */
#define ERR_FILE_END                            0x00000112      /**< Ѿŵļĩβ */
#define ERR_FILE_JUMP_OVER_LEN                  0x00000113      /**< ļתļ */
#define ERR_FILE_READ_TOO_FAST                  0x00000114      /**< ȡļٶȹ */
#define ERR_FILE_STEP_READ_COMPLETE             0x00000115      /**< ȡλݽ */
#define ERR_FILE_PAUSE                          0x00000116      /**< ǰģ鴦ֹͣ״̬ */
#define ERR_FILE_HAVE_OPEN                      0x00000117      /**< Ѿļ */
#define ERR_FILE_SPELL_FAIL                     0x00000118      /**< ƴ֡ʧ*/
#define ERR_PACKET_OVERSIZE                     0x00000119      /**< ݰ*/
#define ERR_MCM_SPEAKER_NOT_EXIST               0x0000011A      /**<  */
#define ERR_MCM_SPEAKER_MORE_THAN_ONE           0x0000011B      /**< 1 */

/*********************** Player ý********************************/
#define ERR_FAIL_TO_OPEN_STREAM                 0x00000201      /**< ýʧ */
#define ERR_FAIL_TO_CLOSE_STREAM                0x00000202      /**< رýʧ */
#define ERR_FAIL_TO_RECV_DATA                   0x00000203      /**< ϵ½ʧ */
#define ERR_FAIL_TO_PROCESS_MEDIA_DATA          0x00000204      /**< ýݴʧ */
#define ERR_NOT_START_PLAY                      0x00000205      /**< ͨδʼŲ */
#define ERR_FAIL_TO_INPUT_DATA                  0x00000206      /**< ýʧ */
#define ERR_INPUTDATA_BUFFER_FULL               0x00000207      /**< ݻ */
#define ERR_FAIL_TO_SET_PROCESS_DATA_CB         0x00000208      /**< ýݻصʧ */
#define ERR_VOICE_RUNNING_ERROR                 0x00000209      /**< ҵйг*/
#define ERR_FAIL_TO_OPEN_VOICE_SVC              0x0000020A      /**< ҵʧ */
#define ERR_FAIL_TO_CLOSE_VOICE_SVC             0x0000020B      /**< رҵʧ */
#define ERR_UNKNOWN_STREAM_TYPE                 0x0000020C      /**< δ֪ý */
#define ERR_PACKET_LOSE                         0x0000020D      /**<  */
#define ERR_NEED_MORE_PACKET                    0x0000020E      /**< ƴδɣҪ */
#define ERR_FAIL_TO_CREATE_DECODE               0x0000020F      /**< ʧ */
#define ERR_FAIL_TO_DECODE                      0x00000210      /**< ʧ */
#define ERR_RECV_DATA_NOTENOUGH                 0x00000211      /**< ݲ */
#define ERR_RENDER_RES_FULL                     0x00000212      /**< ʾԴ */
#define ERR_RENDER_RES_NOT_EXIST                0x00000213      /**< ʾԴ */
#define ERR_CREATE_DEV_FAILED                   0x00000214      /**< Դʧ */
#define ERR_AUDIO_RES_NOT_EXIST                 0x00000215      /**< ƵԴ */
#define ERR_IHW265D_NEED_MORE_BITS              0x00000216      /**< Ҫ */
#define ERR_FAIL_TO_CREATE_ENCODE               0x00000217      /**< ʧ */
#define ERR_CAPTURE_RES_EXIST                   0x00000218      /**< ɼԴ */
#define ERR_RECORD_STARTED                      0x00000219      /**< ¼Ѵ */
#define ERR_NEED_WAIT_DECODEC                   0x0000021A      /**< δɣҪȴ */
#define ERR_MORE_DATA_NEED_PACKET               0x0000021B      /**< ݹ࣬Ҫ */
#define ERR_AAC_LC_DECODE_FAIL                  0x0000021C      /**< AAC_LCʧ */
#define ERR_RENDER_SURFACELOST                  0x0000021D      /**< ʾ涪ʧ */
#define ERR_PLAYBACK_FINISH                     0x0000021E      /**< طŽ */
#define ERR_FILE_ENCRYPED                       0x0000021F      /**< ļѼ */
#define ERR_SCRAMBLING_INFO_FAILED              0x00000220      /**< Ϣ쳣 */
#define ERR_SNATCH_FINISH                       0x00000221      /**< ͼ */
#define ERR_GPU_DECODEC_FAIL                    0x00000222      /**< Ӳ

/*********************** Player IPC¼ϱ********************************/
#define ERR_DISK_CAPCITY_NOT_ENOUGH             0x0000029F      /**< Ӳʣռ䲻 */
#define ERR_VIDEO_STREAM_FULL                   0x00000301      /**< 豸 */
#define ERR_DISK_CAPCITY_WARN                   0x00000302      /**< Ӳʣؼֵ*/
#define ERR_NOT_SUPPORT_MEDIA_ENCODE_TYPE       0x00000303      /**< ýʽ֧¼ */
#define ERR_MEDIA_RESOLUTION_CHANGE             0x00000304      /**< ýֱʷ仯 */
#define ERR_AUDIO_DEVICE_UNRIPE                 0x00000305      /**< Ƶ豸δ׼ */
#define ERR_RECORDSTATE_MANUAL                  0x00000306      /**< ֶֹͣ */
#define ERR_RECORDSTATE_SUBSECTION              0x00000307      /**< ָ */
#define ERR_RECORDSTATE_CAPCITYLIMIT            0x00000308      /**< Ƶ */
#define ERR_WRITE_FILE_FAILED                   0x00000309      /**< дļʧ */ 
#define ERR_CREATE_DIR_FAIL                     0x0000030A      /**< Ŀ¼ʧ */

/*********************** Player Ԫݻͼ********************************/
#define ERR_COMMON_INVALIDPARAM                 0x00000401      /**< Ч */
#define ERR_SYS_NO_MEMORY                       0x00000402      /**< ûڴ */
#define ERR_LOAD_DLL_FAILED                     0x00000403      /**< ض̬ʧ */
#define ERR_FIND_PATH_FAILED                    0x00000404      /**< ļ·ʧ */

#define ERR_INIT_CREATEGRAPHINFO_FAILED         0x00000405      /**< ͼϢʧ */
#define ERR_INIT_CREATEOSDINFO_FAILED           0x00000406      /**< OSDϢʧ */
#define ERR_INIT_NO_GRAPHINFO                   0x00000407      /**< δûͼϢ */
#define ERR_INIT_NO_OSDDATA                     0x00000408      /**< δOSDϢ */
#define ERR_INIT_CREATEDATA_FAILED              0x00000409      /**< ͼݽṹʧ */

#define ERR_DRAW_NEWGRAPHICS_FAILED             0x0000040A      /**< ͼʧ */
#define ERR_DRAW_NO_GRAPHICS                    0x0000040B      /**< δûͼ */
#define ERR_DRAW_CREATEDIBSECTION_FAILED        0x0000040C      /**< 豸޹صλͼʧ */

#define ERR_CONVERSION_NO_YUVMEMORY             0x0000040D      /**< δתYUVڴռ */
#define ERR_CONVERSION_TOYUV_FAILED             0x0000040E      /**< תYUVʧ*/
#define ERR_CONVERSION_OUT_PICTURE              0x0000040F      /**< ԴͼƬ*/

/*********************** Player ۽********************************/
#define ERR_FISHEYE_RESOUCE_FAIL                0x00000501      /**< Դ */
#define ERR_GET_WNDID_FROM_POINT_FAIL           0x00000502      /**< ͨѰPTZںʧ */
#define ERR_NEED_NOT_FISHEYE_ADJUST             0x00000503      /**< Ҫ۽ */
#define ERR_FISHEYE_ADJUST_FAIL                 0x00000504      /**< ۽ʧ */
#define ERR_FISHEYE_STREAM_EXIST                0x00000505      /**< ڣϱ */
#define ERR_FISHEYE_STREAM_NOT_EXIST            0x00000506      /**< ڣϱ */

/*********************** Player Ŀȫptz********************************/
#define ERR_PTZ_RESOUCE_FAIL                    0x00000601      /**< Ŀȫ ptzԴ */
#define ERR_PTZ_STREAM_EXIST                    0x00000602      /**< Ŀȫ ptzڣϱ */
#define ERR_PTZ_STREAM_NOT_EXIST                0x00000603      /**< Ŀȫ ptzڣϱ */
#define ERR_PTZ_GET_WNDID_FROM_POINT_FAIL       0x00000604      /**< ͨPTZںʧ */

/*********************** Player ý********************************/
#define ERR_CLOUD_DOWNLOAD_FINISH               0x00000701      /**<  */
#define ERR_CLOUD_PARSE_DOMAIN_FAIL             0x00000702      /**< ʧ */
#define ERR_CLOUD_CONNECT_FAIL                  0x00000703      /**< ʧ */
#define ERR_CLOUD_CONNECT_TIMEOUT               0x00000704      /**< ӳʱ */
#define ERR_CLOUD_DOWNLOAD_TIMEOUT              0x00000705      /**< سʱ */
#define ERR_CLOUD_DOWNLOAD_FAIL                 0x00000706      /**< ʧ */
#define ERR_CLOUD_NETWORK_POOR                  0x00000707      /**< ϲ */
#define ERR_CLOUD_PLAY_FINISH                   0x00000708      /**<  */
#define ERR_CLOUD_DISK_FULL                     0x00000709      /**< ̿ռ */
#define ERR_CLOUD_AUTH_FAIL                     0x0000070A      /**< Ȩʧ */
#define ERR_CLOUD_CURRENT_TIME                  0x0000070B      /**< ǰʱ䣬ϱ */
#define ERR_CLOUD_PRIOR_DISK_FULL               0x0000070C      /**< Ԥֵ */
#define ERR_CLOUD_NODE_NOT_EXIST                0x0000070D      /**< ʱڵ㲻 */
#define ERR_CLOUD_NO_CACHE_PATH                 0x0000070E      /**< δû· */
#define ERR_CLOUD_MSG_SEND_FAIL                 0x0000070F      /**< Ϣʧ */
#define ERR_CLOUD_TASK_CANCELLED                0x00000710      /**< ȡ */
#define ERR_CLOUD_STREAM_CONTINUE               0x00000711      /**<  */

/*********************** Player POSϢ********************************/
#define ERR_POS_STREAM_EXIST                    0x00000801      /**< POSϢڣϱ */
#define ERR_POS_STREAM_NOT_EXIST                0x00000802      /**< POSϢڣϱ */

/*@brief ڴ */
#define MAX_MALLOC_NUM                          42
#define MAX_MALLOC_WIN7                         14
#define MAX_MALLOC_WIN8                         28

/*@brief ý */
#define PLAYER_PAYLOAD_TYPE_NUM                 2

/* һ */
#define IVA_REPORT_COORD_NUM                    16

/*@brief ͨCODEȣƽֵ̨֧ЧλΪ47λ */
#define PLAYER_CODE_LEN                         48 

/*@brief ͨ */
#define PLAYER_MAXPORT_NUM                      256

/*@brief ·󳤶 */
#define PLAYER_PATH_MAX_LEN                     256

/*@brief ˮӡϢMax */
#define WATRE_MARK_MAX_LEN                      512

/*@brief URLַ */
#define PLAYER_URL_LEN                          512

/**@brief ʾԪݲ PLAYER_IVA_SHOW_RULE */
#define PLAYER_SHOW_RULE                        0x00000001      /**< ʾ߿ */
#define PLAYER_SHOW_RESULT_TOUTH_RULE           0x00000002      /**< ʾĿ */
#define PLAYER_SHOW_RESULT_UNTOUTH_RULE         0x00000004      /**< ʾδĿ */
#define PLAYER_SHOW_TRACK                       0x00000008      /**< ʾĿ켣 */

/**
* @enum tagPlayerLogLevel
* @brief ־ȼö
* @attention 
*/
typedef enum tagPlayerLogLevel
{
    PLAYER_LOG_CLOSE        = 0,        /**< ӡ */
    PLAYER_LOG_DEBUG        = 1,        /**< debug */
    PLAYER_LOG_INFO         = 2,        /**< info */
    PLAYER_LOG_WARN         = 3,        /**< warn */
    PLAYER_LOG_ERROR        = 4,        /**< error */
    PLAYER_LOG_FATAL        = 5         /**< fatal */
}PLAYER_LOGLEVEL_E;

/**
* @enum tagPlayerVideoFrameType
* @brief Ƶ֡͵öٶ
* @attention 
*/
typedef enum tagPlayerVideoFrameType
{
    PLAYER_VIDEO_FRAME_I    = 0,        /**< Ƶ֡ΪI֡ */
    PLAYER_VIDEO_FRAME_P    = 1,        /**< Ƶ֡ΪP֡ */
    PLAYER_VIDEO_FRAME_B    = 2         /**< Ƶ֡ΪB֡ */
}PLAYER_VIDEO_FRAME_TYPE_E;

/**
* @enum tagPlayerVideoEncodeType
* @brief Ƶʽöٶ
* @attention 
*/
typedef enum tagPlayerVideoEncodeType
{
    PLAYER_VIDEO_ENCODE_MPEG2   = 0,      /**< ƵMPEG-2׼ */
    PLAYER_VIDEO_ENCODE_MPEG4   = 1,      /**< ƵMPEG-4׼ */
    PLAYER_VIDEO_ENCODE_H264    = 2,      /**< ƵH.264׼ */
    PLAYER_VIDEO_ENCODE_MJPEG   = 3,      /**< ƵMJPEG׼ */
    PLAYER_VIDEO_ENCODE_H265    = 4,      /**< ƵH.265׼ */
    PLAYER_VIDEO_ENCODE_NULL    = 5       /**< Ƶ */
}PLAYER_VIDEO_ENCODE_TYPE_E;

/**
* @enum tagPlayerAudioEncodeType
* @brief Ƶʽöٶ
* @attention 
*/
typedef enum tagPlayerAudioEncodeType
{
    PLAYER_AUDIO_ENCODE_G711U   = 0,      /**< ƵG.711Uɱ׼ */
    PLAYER_AUDIO_ENCODE_MP2     = 1,      /**< ƵMP2׼ */
    PLAYER_AUDIO_ENCODE_AAC     = 2,      /**< ƵAAC׼ */
    PLAYER_AUDIO_ENCODE_G711A   = 3,      /**< ƵG.711Aɱ׼ */
    PLAYER_AUDIO_ENCODE_PCM     = 4,      /**< ƵPCMɱ׼ */
    PLAYER_AUDIO_ENCODE_NULL    = 5       /**< Ƶ */
}PLAYER_AUDIO_ENCODE_TYPE_E;

/**
* @enum tagPlayerWaveFormatInfo
* @brief ƵʽöͶ
* @attention 
*/
typedef enum tagPlayerWaveFormatInfo
{
    PLAYER_WAVE_FORMAT_PCM8M16          = 0,        /**< PCM8KʣM16λ */
    PLAYER_WAVE_FORMAT_PCM16M16         = 1,        /**< PCM16KʣM16λ */
    PLAYER_WAVE_FORMAT_PCM441M16        = 2,        /**< PCM44.1KʣM16λ */
    PLAYER_WAVE_FORMAT_PCM11025M16      = 3,        /**< PCM11.025KʣM16λ */
    PLAYER_WAVE_FORMAT_PCM8_RIGHT       = 4,        /**< PCM8Kʣ */
    PLAYER_WAVE_FORMAT_PCM_NORMAL       = 5,        /**< PCMͨģʽ */
    PLAYER_WAVE_FORMAT_PCM48000M16      = 6,        /**< PCM48.0KʣM16λ */
    PLAYER_WAVE_FORMAT_UNKNOWN
}PLAYER_WAVE_FORMAT_INFO_E;

/**
* @enum tagPlayerRenderTimeType
* @brief ʱöͶ
* @attention 
*/
typedef enum tagPlayerRenderTimeType
{
    PLAYER_RENDER_FRAME_RATE            = 0,        /**< ʹ֡ݽƵȾ */
    PLAYER_RENDER_ABSOLUTE_TIME         = 1         /**< ʹþʱݽƵȾ */
}PLAYER_RENDER_TIME_TYPE_E;

/**
* @enum tagPlayerAudioSampleFormatType
* @brief Ƶλ
* @attention 
*/
typedef enum tagPlayerAudioSampleFormatType
{
    PLAYER_AUDIO_SAMPLE_FMT_NONE        = -1,
    PLAYER_AUDIO_SAMPLE_FMT_U8          = 0,        /**< ޷8λ */
    PLAYER_AUDIO_SAMPLE_FMT_S16         = 1,        /**< з16λ */
    PLAYER_AUDIO_SAMPLE_FMT_S32         = 2,        /**< з32λ */
    PLAYER_AUDIO_SAMPLE_FMT_FLT         = 3,        /**<  */
    PLAYER_AUDIO_SAMPLE_FMT_DBL         = 4         /**< double */
} PLAYER_AUDIO_SAMPLE_FORMAT_E;

/* Ƶͼʾöٶ */
typedef enum tagPlayerRenderScaleE
{
    PLAYER_RENDER_SCALE_FULL            = 0,        /**< ʾ */
    PLAYER_RENDER_SCALE_PROPORTION      = 1,        /**< ձʾ */
    PLAYER_RENDER_SCALE_REAL            = 2         /**< ʵʴСʾ */
}PLAYER_RENDER_SCALE_E;

/**
* @enum tagPictureFluency
* @brief ͼ񲥷öͶ
* @attention: ö2
*/
typedef enum tagPictureFluencyE
{
    PLAYER_PICTURE_REAL                 = 0,        /**< ʵʱ */
    PLAYER_PICTURE_FLUENCY              = 1,        /**<  */
    PLAYER_PICTURE_BALANCE              = 2,        /**< ⣨ã */
    PLAYER_PICTURE_BALANCE_NEW          = 3,        /**<  */
    PLAYER_PICTURE_RTMP_FLUENCY         = 4,        /**< RTMP */
    PLAYER_PICTURE_MAX
}PLAYER_PICTURE_FLUENCY_E;

/**
* @enum tagPictureFluency
* @brief ʱƲ
* @attention 
*/
typedef enum tagBufferCtrlE
{
    PLAYER_BUFFER_CTRL_GIVEUP           = 0,        /**<  */
    PLAYER_BUFFER_CTRL_BLOCK            = 1,        /**<  */
    PLAYER_BUFFER_CTRL_MAX
}PLAYER_BUFFER_CTRL_E;

/**
* @enum tagPlayerPicFormateE
* @brief ͼʽ
* @attention 
*/
typedef enum tagPlayerPicFormateE
{
    PLAYER_PIC_FORMATE_BMP              = 0,        /**< JPEG */
    PLAYER_PIC_FORMATE_JPEG             = 1,        /**< BMP */
    PLAYER_PIC_FORMATE_JPEG_AND_BMP     = 2,        /**< JPEG & BMP */
    PLAYER_PIC_FORMATE_MAX
}PLAYER_PIC_FORMATE_E;

/**
* @enum tagPlayerDigitalZoomE
* @brief ַŴö
* @attention 
*/
typedef enum tagPlayerDigitalZoomE
{
    PLAYER_DIGITAL_ZOOM_CLOSE           = 0,        /**< ر */
    PLAYER_DIGITAL_ZOOM_OPEN            = 1         /**<  */
}PLAYER_DIGITAL_ZOOM_E;

/**
* @enum tagPlayerMediaRunInfoType
* @brief ϱϢ͵öٶ
* @attention 
*/
typedef enum tagPlayerMediaRunInfoType
{
    PLAYER_RUN_INFO_RECORD_VIDEO        = 0,        /**< ¼ϱϢ */
    PLAYER_RUN_INFO_MEDIA_PROCESS       = 1,        /**< Ƶý崦еϱϢ */
    PLAYER_RUN_INFO_SERIES_SNATCH       = 2,        /**< ץĹϱϢ */
    PLAYER_RUN_INFO_MEDIA_VOICE         = 3,        /**< ҵϱϢ */
    PLAYER_RUN_INFO_MEDIA_NOT_IDENTIFY  = 4,        /**< ޷ʶ */
    PLAYER_RUN_INFO_RECV_PACKET_NUM     = 5,        /**< ڽյİ */
    PLAYER_RUN_INFO_RECV_BYTE_NUM       = 6,        /**< ڽյֽ */
    PLAYER_RUN_INFO_VIDEO_FRAME_NUM     = 7,        /**< ڽƵ֡ */
    PLAYER_RUN_INFO_AUDIO_FRAME_NUM     = 8,        /**< ڽƵ֡ */
    PLAYER_RUN_INFO_LOST_PACKET_RATIO   = 9,        /**< ڶͳϢλΪ0.01% */
    PLAYER_RUN_INFO_MEDIA_PLAY_PROGRESS = 10,       /**< ýЯĽϢ */
    PLAYER_RUN_INFO_MEDIA_PLAY_END      = 11,       /**< ýЯĲŽ */
    PLAYER_RUN_INFO_MEDIA_ABNORMAL      = 12,       /**< ý崦쳣 */
    PLAYER_RUN_INFO_CODEC               = 13,       /**<  */
    PLAYER_RUN_INFO_STREAM              = 14,       /**<  */
    PLAYER_RUN_INFO_PLAYBACK_FINISH     = 15,       /**< طŽ */
    PLAYER_RUN_INFO_SNATCH              = 16,       /**< ͼеϱϢ */
    PLAYER_RUN_INFO_MAX
}PLAYER_MEDIA_PLAYER_RUN_INFO_TYPE_E;

/**
* @enum tagPlayerMediaDataFormat
* @brief ýʽ
* @attention 
*/
typedef enum tagPlayerMediaDataFormat
{
    PLAYER_MEDIA_DATA_TS                = 0,        /**< TSװ */
    PLAYER_MEDIA_DATA_ES12              = 1,        /**< RTP + /Ƶ˽ͷ12ֽڣ + ES */
    PLAYER_MEDIA_DATA_ES12_TIME         = 2,        /**< RTP + ʱ8ֽڣ + /Ƶ˽ͷ12ֽڣ + ES */
    PLAYER_MEDIA_DATA_RTP_ES            = 3,        /**< RTP + ES */
    PLAYER_MEDIA_DATA_HIK               = 4,        /**< صĵһǺ40ֽϵͳͷ */
    PLAYER_MEDIA_DATA_DH                = 5,        /**<  */
    PLAYER_MEDIA_DATA_RM                = 6,        /**< صĵһ40ֽϵͳͷ */
    PLAYER_MEDIA_DATA_TDY_SWALLOW       = 7,        /**< TDY-SWALLOW */
    PLAYER_MEDIA_DATA_DMA_SWALLOW       = 8,        /**< DMA-SWALLOW */
    PLAYER_MEDIA_DATA_NANZI             = 9,        /**<  */
    PLAYER_MEDIA_DATA_RTP3984           = 10,       /**< rfc3984 */
    PLAYER_MEDIA_DATA_RTP_PS            = 11,       /**< RTP+PS */
    PLAYER_MEDIA_DATA_RTP_H264          = 12        /**< RTP+H264 */
}PLAYER_MEDIA_DATA_FORMAT_E;


/**
* @enum tagPlayerProtocol
* @brief Э
* @attention 
*/
typedef enum tagPlayerProtocol
{
    PLAYER_PROTOCOL_UDP                 = 0,        /**< UDPЭ */
    PLAYER_PROTOCOL_TCP                 = 1,        /**< TCPЭClient*/
    PLAYER_PROTOCOL_TCP_SERVER          = 2,        /**< TCPЭServer*/
    PLAYER_PROTOCOL_PIPE                = 3,        /**< ܵڲʹ */
    PLAYER_PROTOCOL_TCP_REPALY          = 4,        /**< طţֱʹdvr */
    PLAYER_PROTOCOL_MAX                             /**< Ч */

}PLAYER_PROTOCOL_E;
/**
* @enum tagPlayerFileFormateE
* @brief ¼ʽ
* @attention 
*/
typedef enum tagPlayerFileFormateE
{
    PLAYER_FILE_FORMATE_MP4             = 0,        /**< MP4ʽýļ(Ƶ+Ƶ)ļɽӿָ */
    PLAYER_FILE_FORMATE_TS,                         /**< TS ʽýļ(Ƶ+Ƶ)ļɽӿָ */
    PLAYER_FILE_FORMATE_MP4_ADD_TIME,               /**< MP4ʽýļ(Ƶ+Ƶ) ,ļϵͳʱԶ */
    PLAYER_FILE_FORMATE_TS_ADD_TIME,                /**< TS ʽýļ(Ƶ+Ƶ) ,ļϵͳʱԶ */
    PLAYER_FILE_FORMATE_AUDIO_TS,                   /**< TS ʽƵļ(Ƶ)ļɽӿָ */
    PLAYER_FILE_FORMATE_AUDIO_MP4,                  /**< MP4ʽƵļ(Ƶ)ļɽӿָ */ 
    PLAYER_FILE_FORMATE_AUDIO_TS_ADD_TIME,          /**< TS ʽƵļ(Ƶ) ,ļϵͳʱԶ */
    PLAYER_FILE_FORMATE_AUDIO_MP4_ADD_TIME,         /**< MP4ʽƵļ(Ƶ) ,ļϵͳʱԶ */
    PLAYER_FILE_FORMATE_MP4_ADD_RCD_TIME,           /**< MP4ʽýļ(Ƶ+Ƶ)ļ¼ʼʱԶ */
    PLAYER_FILE_FORMATE_TS_ADD_RCD_TIME,            /**< TS ʽýļ(Ƶ+Ƶ)ļ¼ʼʱԶ */
    PLAYER_FILE_FORMATE_AUDIO_MP4_ADD_RCD_TIME,     /**< MP4ʽƵļ(Ƶ)ļ¼ʼʱԶ */
    PLAYER_FILE_FORMATE_AUDIO_TS_ADD_RCD_TIME,      /**< TS ʽƵļ(Ƶ)ļ¼ʼʱԶ */
    PLAYER_FILE_FORMATE_VIDEO_MP4_ADD_RCD_TIME,     /**< MP4ʽƵļ(Ƶ)ļ¼ʼʱԶ */
    PLAYER_FILE_FORMATE_VIDEO_TS_ADD_RCD_TIME,      /**< TS ʽƵļ(Ƶ)ļ¼ʼʱԶ */
    PLAYER_FILE_FORMATE_AVI,                        /**< AVIʽýļ(Ƶ+Ƶ)ļɽӿָ */
    PLAYER_FILE_FORMATE_AVI_ADD_TIME,               /**< AVIʽýļ(Ƶ+Ƶ) ,ļϵͳʱԶ */
    PLAYER_FILE_FORMATE_AUDIO_AVI,                  /**< AVIʽƵļ(Ƶ)ļɽӿָ */ 
    PLAYER_FILE_FORMATE_AUDIO_AVI_ADD_TIME,         /**< AVIʽƵļ(Ƶ) ,ļϵͳʱԶ */
    PLAYER_FILE_FORMATE_AVI_ADD_RCD_TIME,           /**< AVIʽýļ(Ƶ+Ƶ)ļ¼ʼʱԶ */
    PLAYER_FILE_FORMATE_AUDIO_AVI_ADD_RCD_TIME,     /**< AVIʽƵļ(Ƶ)ļ¼ʼʱԶ */
    PLAYER_FILE_FORMATE_VIDEO_AVI_ADD_RCD_TIME,     /**< AVIʽƵļ(Ƶ)ļ¼ʼʱԶ */
    PLAYER_FILE_FORMATE_MAX
}PLAYER_FILE_FORMATE_E;

/**
 * @enum tagPlayerPlaySpeedE
 * @brief ļٶ
 * @attention:ıϽʹó֡
 */
typedef enum tagPlayerPlaySpeedE
{
    PLAYER_SPEED_QUARTER_FORWARD        = 0,        /**< 1/4ٲ */
    PLAYER_SPEED_HALF_FORWARD,                      /**< 1/2ٲ */
    PLAYER_SPEED_1_FORWARD,                         /**< ٶǰ */
    PLAYER_SPEED_2_FORWARD,                         /**< 2ǰ */
    PLAYER_SPEED_4_FORWARD,                         /**< 4ǰ */
    PLAYER_SPEED_8_FORWARD,                         /**< 8ǰ */
    PLAYER_SPEED_16_FORWARD,                        /**< 16ǰ */

    PLAYER_SPEED_16_BACKWARD,                       /**< 16ٺ˲ */
    PLAYER_SPEED_8_BACKWARD,                        /**< 8ٺ˲ */
    PLAYER_SPEED_4_BACKWARD,                        /**< 4ٺ˲ */
    PLAYER_SPEED_2_BACKWARD,                        /**< 2ٺ˲ */
    PLAYER_SPEED_1_BACKWARD,                        /**< ٶȺ˲ */
    PLAYER_SPEED_HALF_BACKWARD,                     /**< 1/2ٺ˲ */
    PLAYER_SPEED_QUARTER_BACKWARD,                  /**< 1/4ٺ˲ */

    PLAYER_SPEED_2_FORWARD_IFRAME,                  /**< 2ǰ(I֡) */
    PLAYER_SPEED_4_FORWARD_IFRAME,                  /**< 4ǰ(I֡) */
    PLAYER_SPEED_8_FORWARD_IFRAME,                  /**< 8ǰ(I֡) */
    PLAYER_SPEED_16_FORWARD_IFRAME,                 /**< 16ǰ(I֡) */

    PLAYER_SPEED_2_BACKWARD_IFRAME,                 /**< 2ٺ˲(I֡) */
    PLAYER_SPEED_4_BACKWARD_IFRAME,                 /**< 4ٺ˲(I֡) */
    PLAYER_SPEED_8_BACKWARD_IFRAME,                 /**< 8ٺ˲(I֡) */
    PLAYER_SPEED_16_BACKWARD_IFRAME,                /**< 16ٺ˲(I֡) */

    PLAYER_SPEED_INTELLIGENT_FORWARD,               /**< ܲ */
    PLAYER_SPEED_1_FRAME_FORWARD,                   /**< ֡ǰ */
    PLAYER_SPEED_I_FRAME_BACKWARD,                  /**< ֡(I֡)> */

    PLAYER_SPEED_40_FORWARD,                        /**< 40ǰ */

    PLAYER_SPEED_32_FORWARD_IFRAME,                 /**< 32ٳ֡ǰ */
    PLAYER_SPEED_32_BACKWARD_IFRAME,                /**< 32ٳ֡˲ */
    PLAYER_SPEED_64_FORWARD_IFRAME,                 /**< 64ٳ֡ǰ */
    PLAYER_SPEED_64_BACKWARD_IFRAME,                /**< 64ٳ֡˲ */
    PLAYER_SPEED_128_FORWARD_IFRAME,                /**< 128ٳ֡ǰ */
    PLAYER_SPEED_128_BACKWARD_IFRAME,               /**< 128ٳ֡˲ */
    PLAYER_SPEED_256_FORWARD_IFRAME,                /**< 256ٳ֡ǰ */
    PLAYER_SPEED_256_BACKWARD_IFRAME,               /**< 256ٳ֡˲ */

    PLAYER_SPEED_32_FORWARD,                        /**< 32ǰ */
    PLAYER_SPEED_32_BACKWARD,                       /**< 32ٺ˲ */
    PLAYER_SPEED_MAX
}PLAYER_PLAY_SPEED_E;

/**
* @enum tagPlayerVoiceSvcType
* @brief ҵöٶ
* @attention 
*/
typedef enum tagPlayerVoiceSvcType
{
    PLAYER_VOICE_SERVICE_BROADCAST_INPUT    = 0,    /**< 㲥ҵͣͣԴȴûƵ */
    PLAYER_VOICE_SERVICE_BROADCAST_CAPTURE  = 1,    /**< 㲥ҵͣͣԴͨ˷豸ɼ */
    PLAYER_VOICE_SERVICE_TALKBACK_INPUT     = 2,    /**< ԽҵͣշԴȴûƵ */
    PLAYER_VOICE_SERVICE_TALKBACK_CAPTURE   = 3,    /**< ԽҵͣշԴͨ˷豸ɼ */
    PLAYER_VOICE_SERVICE_BE_BROADCASTED     = 4     /**< 㲥ҵͣ */
}PLAYER_VOICE_SERVICE_TYPE_E;

/**
* @enum tagPlayerPtzMode
* @brief 豸ģʽö
* @attention 
*/
typedef enum tagPlayerPtzMode
{
    PLAYER_ORIGINAL                 = 0,        /**< ԭʼͼ*/
    PLAYER_180                      = 1,        /**< 2*180ģʽ*/
    PLAYER_360_1PTZ                 = 2,        /**< 360+1PTZģʽ*/
    PLAYER_360_6PTZ                 = 3,        /**< 360+6PTZģʽ*/
    PLAYER_FISH_3PTZ                = 4,        /**< +3PTZģʽ*/
    PLAYER_FISH_MID_ON_4PTZ         = 5,        /**< ͼмʾ+4PTZģʽ*/
    PLAYER_FISH_MID_OFF_4PTZ        = 6,        /**< ͼм䵫ʾ+4PTZģʽ*/
    PLAYER_FISH_LEFT_4PTZ           = 7,        /**< +4PTZģʽ*/
    PLAYER_FISH_8PTZ                = 8,        /**< +8PTZģʽ*/
    PLAYER_PANORAMA                 = 9,        /**< ȫģʽ*/
    PLAYER_PR_3PTZ                  = 10,       /**< ȫ+3PTZģʽ*/
    PLAYER_PR_4PTZ                  = 11,       /**< ȫ+4PTZģʽ*/
    PLAYER_PR_8PTZ                  = 12        /**< ȫ+8PTZģʽ*/
}PLAYER_PTZ_MODE;

/**
* @enum tagPlayerfFixMode
* @brief 豸װģʽö
* @attention 
*/
typedef enum tagPlayerfFixMode
{
    PLAYER_TOP_INSTALLATION         = 0,        /**< װ*/
    PLAYER_BOTTOM_INSTALLATION      = 1,        /**< ײװ*/
    PLAYER_SIDE_INSTALLATION        = 2         /**< 氲װ*/
}PLAYER_FIX_MODE;

/**
* @enum tagPlayerPtzDisplayMode
* @brief ĿȫPTZģʽ
* @attention 
*/
typedef enum tagPlayerPtzDisplayMode
{
    PLAYER_PTZ_DISPLAY_ORIGINAL     = 0,        /**< ԭʼͼ*/
    PLAYER_PTZ_DISPLAY_5PTZ         = 1         /**< ȫ+5ePTZģʽ*/
}PLAYER_PTZ_DISPLAY_MODE;

/**
 * @struct tagPlayerCheckStateE
 * @brief ˮӡУö
 * @attention 
 */
typedef enum tagPlayerCheckStateE
{
    CHECK_STATE_RIGHT               = 0,        /**< Уƥ */
    CHECK_STATE_NOMARK              = 1,        /**< ˮӡϢУ */
    CHECK_STATE_MISMARCH            = 2         /**< ˮӡУ */
}PLAYER_CHECK_STATE_E;

/**
* @enum tagVideoCBType
* @brief ص
* @attention 
*/
typedef enum tagVideoCBType
{
    PLAYER_VIDEO_CB_DEFAULT         = 0,        /**< ݻصĬϣ */
    PLAYER_VIDEO_CB_FISH_RECTIFY    = 1,        /**< ۽ݻص */
    PLAYER_VIDEO_CB_MAX
}PLAYER_VIDEO_CB_TYPE_E;


/*  */
typedef enum tagIVAReportRuleType
{
    IVA_REPORT_RULE_LINE            = 0,        /* ιֱߡߣ */
    IVA_REPORT_RULE_POLY            = 1,        /* ι򣨶ΡΣ */
    IVA_REPORT_RULE_BUT
}IVA_REPORT_RULE_TYPE_E;

/* 򴥷 */
typedef enum tagIVAReportTrigType
{
    IVA_REPORT_TRIG_NONE            = 0,        /* ޴ */
    IVA_REPORT_TRIG_BOTH            = 1,        /* ˫򴥷 */
    IVA_REPORT_TRIG_CW              = 2,        /* ˳ʱ봥 */
    IVA_REPORT_TRIG_CCW             = 3,        /* ʱ봥 */
    IVA_REPORT_TRIG_IN              = 4,        /* 봥 */
    IVA_REPORT_TRIG_OUT             = 5,        /* 뿪 */
    IVA_REPORT_TRIG_BUT
}IVA_REPORT_TRIG_TYPE_E;

/* ɫ */
typedef enum tagIVAReportColorType
{
    IVA_REPORT_COLOR_NONE           = 0,        /* ɫ ͼ */
    IVA_REPORT_COLOR_DEEP           = 1,        /* ɫ */
    IVA_REPORT_COLOR_LIGHT          = 2,        /* ǳɫ */
    IVA_REPORT_COLOR_WHITE          = 3,        /* ɫ */
    IVA_REPORT_COLOR_BLACK          = 4,        /* ɫ */
    IVA_REPORT_COLOR_RED            = 5,        /* ɫ */
    IVA_REPORT_COLOR_GREEN          = 6,        /* ɫ */
    IVA_REPORT_COLOR_BLUE           = 7,        /* ɫ */
    IVA_REPORT_COLOR_ORANGE         = 8,        /* ɫ */
    IVA_REPORT_COLOR_PURPLE         = 9,        /* ɫ */
    IVA_REPORT_COLOR_PINK           = 10,       /* ɫ */
    IVA_REPORT_COLOR_YELLOW         = 11,       /* ɫ */
    IVA_REPORT_COLOR_BROWN          = 12,       /* ɫ */
    IVA_REPORT_COLOR_GRAY           = 13,       /* ɫ */
    IVA_REPORT_COLOR_BUT
}IVA_REPORT_COLOR_E;

/**
* @struct tagRunInfo
* @brief ϱϢĽṹ嶨塣
* @attention 
*/
typedef struct tagPlayerRunInfo
{
    ULONG_32 ulPort;                            /**< ͨ */
    ULONG_32 ulErrCode;                         /**< ϱĴ */
    ULONG_32 ulReserved;                        /**<  */
    CHAR szFilePath[PLAYER_PATH_MAX_LEN];       /**< ַ */
}PLAYER_RUN_INFO_S;

/**
* @struct tagPlayerRecvPktNum
* @brief ϱڽհϢĽṹ嶨塣
* @attention 
*/
typedef struct tagPlayerRecvPktNum
{
    ULONG_32 ulPort;                    /**< ͨ */
    ULONG_32 ulRecvPktNum;              /**< յİ */
    ULONG_32 ulStatPeriod;              /**< ͳƵڣ룩 */
}PLAYER_RECV_PACKET_NUM_S;

/**
* @struct tagPlayerRecvByteNum
* @brief ϱڽֽϢĽṹ嶨塣
* @attention 
*/
typedef struct tagPlayerRecvByteNum
{
    ULONG_32 ulPort;                    /**< ͨ */
    ULONG_32 ulRecvByteNum;             /**< յֽ */
    ULONG_32 ulStatPeriod;              /**< ͳƵڣ룩 */
}PLAYER_RECV_BYTE_NUM_S;

/**
* @struct tagPlayerVideoFrameNum
* @brief ϱڽƵ֡ϢĽṹ嶨塣
* @attention 
*/
typedef struct tagPlayerVideoFrameNum
{
    ULONG_32 ulPort;                    /**< ͨ */
    ULONG_32 ulVideoFrameNum;           /**< Ƶ֡ */
    ULONG_32 ulStatPeriod;              /**< ͳƵڣ룩 */
}PLAYER_VIDEO_FRAME_NUM_S;

/**
* @struct tagPlayerAudioFrameNum
* @brief ϱڽƵ֡ϢĽṹ嶨塣
* @attention 
*/
typedef struct tagPlayerAudioFrameNum
{
    ULONG_32 ulPort;                    /**< ͨ */
    ULONG_32 ulAudioFrameNum;           /**< Ƶ֡ */
    ULONG_32 ulStatPeriod;              /**< ͳƵڣ룩 */
}PLAYER_AUDIO_FRAME_NUM_S;

/**
* @struct tagPlayerLostPktRatio
* @brief ϱڶϢĽṹ嶨塣
* @attention 
*/
typedef struct tagPlayerLostPktRatio
{
    ULONG_32 ulPort;                    /**< ͨ */
    ULONG_32 ulLostPktRatio;            /**< ϢλΪ0.01% */
    ULONG_32 ulStatPeriod;              /**< ͳƵڣ룩 */
}PLAYER_LOST_PAKCET_RATIO_S;

/**
* @struct tagPlayerMediaProgress
* @brief ϱýЯĽϢ
* @attention 
*/
typedef struct tagPlayerMediaProgress
{
    ULONG_32 ulPort;                    /**< ͨ */
    ULONG_32 ulMediaProgress;           /**< ϢλΪ룩 */
}PLAYER_MEDIA_PROGRESS_S;

/**
* @struct tagPlayerParseVideoData
* @brief ƴ֡ƵݵָͳȵϢĽṹ嶨
* @attention 
*/
typedef struct tagPlayerParseVideoData
{
    UCHAR *pucData;                     /**< Ƶָ */
    ULONG_32 ulDataLen;                 /**< Ƶݳ */
    ULONG_32 ulVideoFrameType;          /**< Ƶ֡ͣ# PLAYER_VIDEO_FRAME_TYPE_E ȡֵ */
    ULONG_32 ulVideoCodeFormat;         /**< Ƶʽ# PLAYER_VIDEO_ENCODE_TYPE_E ȡֵ */
    ULONG_32 ulHeight;                  /**< Ƶͼ߶ */
    ULONG_32 ulWidth;                   /**< Ƶͼ */
    DLONG dlTimeStamp;                  /**< ʱ룩*/
    ULONG_32 ulAbsTime;                 /**< ʱ(Unixʱ)ǰط */
    ULONG_32 ulReserved2;               /**<  */
}PLAYER_PARSE_VIDEO_DATA_S;

/**
* @struct tagPlayerParseAudioData
* @brief ƴ֡ƵݵָͳȵϢĽṹ嶨
* @attention 
*/
typedef struct tagPlayerParseAudioData
{
    UCHAR *pucData;                     /**< Ƶָ */
    ULONG_32 ulDataLen;                 /**< Ƶݳ */
    ULONG_32 ulAudioCodeFormat;         /**< Ƶʽ# PLAYER_AUDIO_ENCODE_TYPE_E ȡֵ */
    ULONG_32 ulWaveFormat;              /**< ƵݽƵʽӦ# PLAYER_WAVE_FORMAT_INFO_E öеֵ */
    DLONG dlTimeStamp;                  /**< ʱ룩*/
    ULONG_32 ulReserved1;               /**<  */
    ULONG_32 ulReserved2;               /**<  */
}PLAYER_PARSE_AUDIO_DATA_S;

/**
* @struct tagPlayerPictureData
* @brief ŽͼݵָͳȵϢĽṹ嶨
* @attention 
*/
typedef struct tagPlayerPictureData
{
    UCHAR *pucData[4];                  /**< pucData[0]:Y ƽָ,pucData[1]:U ƽָ,pucData[2]:V ƽָ */
    ULONG_32 ulLineSize[4];             /**< ulLineSize[0]:Yƽÿп, ulLineSize[1]:Uƽÿп, ulLineSize[2]:Vƽÿп */
    ULONG_32 ulPicHeight;               /**< ͼƬ߶ */
    ULONG_32 ulPicWidth;                /**< ͼƬ */
    ULONG_32 ulRenderTimeType;          /**< ȾʱͣӦ# PLAYER_RENDER_TIME_TYPE_E öеֵ */
    ULONG_32 ulFrameRate;               /**< ֡ */
    DLONG dlRenderTime;                 /**< Ⱦʱ */
}PLAYER_PICTURE_DATA_S;

/**
 * @struct tagPlayerRectS
 * @brief ԭʼͼṹ嶨
 * @attention 
 */
typedef struct tagPlayerRectS
{
    LONG_32 lLeft;                      /**< xֵ[0,10000]  */
    LONG_32 lTop;                       /**< yᶥֵ[0,10000]  */
    LONG_32 lRight;                     /**< xҵֵ[0,10000] */
    LONG_32 lBottom;                    /**< y׵ֵ[0,10000] */
} PLAYER_RECT_S;

/**
 * @struct tagPlayerPayloadTypeS
 * @brief ƵϢṹ
 * @attention 
 */
typedef struct tagPlayerAudioInfoS
{
    UCHAR ucAudioType;                  /**< ƵЭ*/
    UCHAR ucFrequencyIndex;             /**< Ƶ*/
    UCHAR ucChannelNum;                 /**< Ƶ*/
    UCHAR ucReserved;                   /**< λ*/
}PLAYER_AUDIO_INFO_S;

/**
* @struct tagWaveData
* @brief ŽƵݵָͳȵϢĽṹ嶨
* @attention 
*/
typedef struct tagPlayerWaveData
{
    CHAR *pcData;                       /**< Ƶָ */
    ULONG_32 ulDataLen;                 /**< Ƶݳ */
    ULONG_32 ulWaveFormat;              /**< ƵʽӦ# PLAYER_WAVE_FORMAT_INFO_E öеֵ */
}PLAYER_WAVE_DATA_S;

/**
* @struct tagPlayerAudioSampleParamType
* @brief Ƶ
* @attention 
*/
typedef struct tagPlayerAudioSampleParamType
{
    ULONG_32 ulChannels;                            /**< Ϊ1Ϊ2 */
    ULONG_32 ulSampleRate;                          /**<  */
    PLAYER_AUDIO_SAMPLE_FORMAT_E enSampleFormat;    /**< λ */
} PLAYER_AUDIO_SAMPLE_PARAM_S;

/**
 * @struct tagPlayerPayloadTypeS
 * @brief Ϣṹ
 * @attention 
 */
typedef struct tagPlayerPayloadTypeS
{
    UCHAR ucPayloadType;                                /**< payloadֵ*/
    UCHAR ucReserved[3];                                /**< λ*/
    ULONG_32 ulType;                                    /**< 0Ƶ1Ƶ*/
    union
    {
        PLAYER_VIDEO_ENCODE_TYPE_E enVideoPayloadType;  /**< Ƶöٱ*/
        PLAYER_AUDIO_ENCODE_TYPE_E enAudioPayloadType;  /**< Ƶöٱ*/
    };
    ULONG_32 ulSampleRate;                              /**< */
}PLAYER_PAYLOAD_TYPE_S;

/**
* @struct tagPlayerCheckMarkInfo
* @brief ˮӡУϢ
* @attention
*/
typedef struct tagPlayerCheckMarkInfo
{
    ULONG_32 ulPlayTime;               /**< ü¼Ӧʱ */
    ULONG_32 ulState;                  /**< ˮӡУ飬ο# PLAYER_CHECK_STATE_E */
}PLAYER_CHECK_MARK_INFO;

/**
* @struct tagPlayerMarkInfo
* @brief ˮӡУϢ
* @attention
* @note
* -    1ulUnmarkCount¼УΪʾУɹpstUnmarkTimeListҲulUnmarkCountָ
* -    21¼ʾ1000ˮӡУ鲻ɵļ¼ulUnmarkCountֵ1000
* -    3ɹΪûˮӡϢУ󣬺߽Ϊأʾʱ
*/
typedef struct tagPlayerMarkInfo
{
    CHAR szMarkInfo[WATRE_MARK_MAX_LEN];            /**< ˮӡϢֵ */
    ULONG ulUnmarkCount;                            /**< ˮӡУ */
    PLAYER_CHECK_MARK_INFO *pastUnmarkTimeList;     /**< ˮӡб */
    BOOL_T bHaveWaterMark;                          /**< Ƿˮӡ */
}PLAYER_MARK_INFO_S;

/*********************** Player Ԫݻͼ********************************/
/**
 * @struct tagFisheyePointS
 * @brief 
 * @attention
 */
typedef struct tagPlayerPointS
{
    USHORT usX;                     /**< ֱ꣬[0,10000] */
    USHORT usY;                     /**< ֱ꣬[0,10000] */
}PLAYER_POINT_S;

/**
* @struct tagGpuAbleState
* @brief GPUʹ״̬ṹ
* @attention 
*/
typedef struct tagGpuAbleState
{
    BOOL_T bGpuAbleH264;            /**< GPUʹ-H.264׼*/
    BOOL_T bGpuAbleH265;            /**< GPUʹ-H.265׼ */
    BOOL_T bGpuAbleMJPEG;           /**< GPUʹ-MJEGP׼ */
    BOOL_T bGpuAbleMPEG2;           /**< GPUʹ-MPEG-2׼ */
    BOOL_T bGpuAbleMPEG4;           /**< GPUʹ-MPEG-4׼ */
    BOOL_T bReserved1;              /**< Ԥ1 */
    BOOL_T bReserved2;              /**< Ԥ2 */
    BOOL_T bReserved3;              /**< Ԥ3 */
}PLAYER_GPU_ABLE_STATE_S;

/**
* @struct tagRsaInfo
* @brief RSAӽϢ
* @attention 
*/
typedef struct tagRsaInfo
{
    ULONG_32 ulBit;                 /**< Կbitֵ */
    ULONG_32 ulPub;                 /**< Կֵ */
    CHAR cN[260];                   /**< n */
    CHAR cPri[260];                 /**< ˽Կֵ */
    CHAR cP[132];                   /**< p */
    CHAR cQ[132];                   /**< q */
    CHAR cDP[132];                  /**< dp */
    CHAR cDQ[132];                  /**< dq */
    CHAR cQP[132];                  /**< qp */
}PLAYER_RSA_INFO_S;

/**
 * @struct tagPlayerPosInfoS
 * @brief PosϢṹ
 * @attention 
 */
typedef struct tagPlayerPosInfoS
{
    PLAYER_RECT_S stArea;           /* ʾֱȣ*/
    ULONG_32 ulFontSize;            /* С */
    ULONG_32 ulPosColor;            /* ɫ */
    ULONG_32 ullKeepAliveTime;      /* ʱ */
    VOID *pParm;                    /* Ԥ */
}PLAYER_POS_INFO_S;

/* V2汾Ϣͷ */
typedef struct tagIVAReportRuleHeadV2S
{
    ULONG_32 ulChannel;             /* ͨ */
    BOOL_T bEnable;                 /* ʹ״̬ */
    USHORT usRuleNum;               /*  */
    USHORT usDisplayHoldTime;       /* ʾʱ ms */
}IVA_REPORT_RULE_HEAD_V2_S;

/* V2汾Ϣͷ */
typedef struct tagIVAReportResultHeadV2S
{
    ULONG_32 ulChannel;             /* ͨ */
    BOOL_T bEnable;                 /* ʹ״̬ */
    USHORT usTargetNum;             /* Ŀ */
    USHORT usDisplayHoldTime;       /* ʾʱ ms */
}IVA_REPORT_RESULT_HEAD_V2_S;

/* ṹ */
typedef struct tagIVAReportCoordInfo
{
    USHORT usX;                     /* X  0-10000 ֱ */
    USHORT usY;                     /* Y  0-10000 ֱ */
}IVA_REPORT_COORD_S;

/* V2汾Ϣ */
typedef struct tagIVAReportRuleInfoV2S
{
    ULONG_32 ulRuleID;                                  /* ID */
    ULONG_32 bTriggered;                                /* Ƿ񱻴 */
    IVA_REPORT_RULE_TYPE_E enRuleType;                  /*  */
    IVA_REPORT_TRIG_TYPE_E enTrigType;                  /* 򴥷 */
    IVA_REPORT_COORD_S astCoord[IVA_REPORT_COORD_NUM];  /* */
    ULONG_32 ulCoordNum;                                /*  */
    IVA_REPORT_COLOR_E enLineColor;                     /* ɫ */
    IVA_REPORT_COLOR_E enFillColor;                     /* ɫ */
    ULONG_32 ulLineAlpha;                               /* ͸ 0-100 */
    ULONG_32 ulFillAlpha;                               /* ͸ 0-100 */
    ULONG_32 ulAttachLen;                               /* Ϣ  */
    ULONG_32 ulAttachType;                              /* Ϣ  */
}IVA_REPORT_RULE_INFO_V2_S;

/* V2汾Ϣ չȫṹ */
typedef struct tagIVAReportResultInfoV2ExS
{
    ULONG_32 ulTargetID;                                /* ĿID*/
    ULONG_32 ulTrigRule;                                /* Ϣ 1bit1 */
    IVA_REPORT_COORD_S stStart;                         /* Ŀʼ꣬ʼͽ궼Ϊ0,0ʱʾٽ*/
    IVA_REPORT_COORD_S stEnd;                           /* Ŀ */
    IVA_REPORT_COLOR_E enLineColor;                     /* ɫ */
    ULONG_32 ulLineAlpha;                               /* ͸ 0-100 */ 
    ULONG_32 ulTrailHoldTime;                           /* ʷ켣ʾʱ ms */
    ULONG_32 ulAttachLen;                               /* Ϣ  */
    ULONG_32 ulAttachType;                              /* Ϣ -0x01ȫṹϢ */
    CHAR szMsgData[0];                                  /* Ϣ- */
}IVA_REPORT_RESULT_INFO_V2_EX_S;

/**
* @enum tagPlayerTempeType
* @brief ȳ¶
* @attention 
* ϶ = 32 + ϶  1.8
* ϶ = (϶ - 32)  1.8
*/
typedef enum tagPlayerTempeType
{
    PLAYER_TEMPE_TYPE_CENTIGRADE = 0,       /*¶ȡ*/
    PLAYER_TEMPE_TYPE_FAHRENHEIT = 1,       /*¶ȨH*/
}PLAYER_TEMPE_TYPE;

/**
* ¼־ĻصͶ \n
* @param [IN] ulLogLevel        ־, Ӧ# PLAYER_LOGLEVEL_E öеֵ
* @param [IN] ulErrCode         ־Ϣ
* @param [IN] ulCmdModuleID     ģID
* @param [IN] pcFileName        ļ
* @param [IN] ulFileLine        
* @param [IN] pcLogDescription  ־ַ
* @return VOID
* @note
* -    1) ڲ¼־;
* -    2) ڲ̵߳øûصû¼־Ҫ߳ͬ;
* -    3) ڲ־ַĩβûд"\r\n"ûд־ļʱҪд
*/
typedef VOID (STDCALL* PLAYER_WRITE_LOG_CALLBACK_PF)(IN ULONG_32 ulLogLevel,
                                                     IN ULONG_32 ulErrCode,
                                                     IN ULONG_32 ulCmdModuleID,
                                                     IN const CHAR *pcFileName,
                                                     IN ULONG_32 ulFileLine,
                                                     IN const CHAR *pcLogDescription);

/**
* Ϣ쳣Ϣصָ \n
* @param [IN] enRunInfoType Ϣ쳣ϢͣӦ# PLAYER_MEDIA_PLAYER_RUN_INFO_TYPE_E öеֵ
* @param [IN] pParam        Ϣ쳣ϢݵĻָ루ŵϢ쳣Ϣйأ
* @return VOID
* @note
* -     1) ûҪȷûص췵ء
* -     2) ûڸûصֱӵòSDKκνӿں
* -     3) pParamָĻдŵݵϢ쳣ϢͶûҪϢ쳣ϢͶת
* -        ulRunInfoTypeֵΪ# PLAYER_RUN_INFO_RECORD_VIDEO
                              # PLAYER_RUN_INFO_MEDIA_PROCESS
                              # PLAYER_RUN_INFO_SERIES_SNATCH
                              # PLAYER_RUN_INFO_MEDIA_VOICE ʱû轫pParamתΪ# PLAYER_RUN_INFO_S ṹָ롣
* -        ulRunInfoTypeֵΪ# PLAYER_RUN_INFO_MEDIA_NOT_IDENTIFY ʱû轫pParamתΪ# PLAYER_RUN_INFO_S ṹָ롣
* -        ulRunInfoTypeֵΪ# PLAYER_RUN_INFO_RECV_PACKET_NUM ʱû轫pParamתΪ# PLAYER_RECV_PACKET_NUM_S ṹָ롣
* -        ulRunInfoTypeֵΪ# PLAYER_RUN_INFO_VIDEO_FRAME_NUM ʱû轫pParamתΪ# PLAYER_VIDEO_FRAME_NUM_S ṹָ롣
* -        ulRunInfoTypeֵΪ# PLAYER_RUN_INFO_AUDIO_FRAME_NUM ʱû轫pParamתΪ# PLAYER_AUDIO_FRAME_NUM_S ṹָ롣
* -        ulRunInfoTypeֵΪ# PLAYER_RUN_INFO_RECV_BYTE_NUM ʱû轫pParamתΪ# PLAYER_RECV_BYTE_NUM_S ṹָ롣
* -        ulRunInfoTypeֵΪ# PLAYER_RUN_INFO_LOST_PACKET_RATIO ʱû轫pParamתΪ# PLAYER_LOST_PAKCET_RATIO_S ṹָ롣
* -        ulRunInfoTypeֵΪ# PLAYER_RUN_INFO_MEDIA_PLAY_PROGRESS ʱû轫pParamתΪ# PLAYER_MEDIA_PROGRESS_S ṹָ롣
* -        ulRunInfoTypeֵΪ# PLAYER_RUN_INFO_MEDIA_PLAY_END ʱû轫pParamתΪ# PLAYER_MEDIA_PROGRESS_S ṹָ롣
* -        ulRunInfoTypeֵΪ# PLAYER_RUN_INFO_MEDIA_ABNORMAL ʱû轫pParamתΪ# PLAYER_RUN_INFO_S ṹָ롣
*/
typedef VOID (STDCALL* PLAYER_RUN_INFO_CALLBACK_PF)(IN ULONG_32 ulRunInfoType,
                                                    IN VOID *pParam);

/**
* ƴ֡ǰýݻصָ \n
* @param [IN] ulPort           ͨ
* @param [IN] pucBuffer        ƴ֡ǰýݻָ
* @param [IN] ulBufSize        С
* @param [IN] ulMediaDataType  ýͣμýöٶ# PLAYER_MEDIA_DATA_FORMAT_E
* @param [IN] lUserParam       ûòûڵ# NDPlayer_SetSourceMediaDataCB ʱָû
* @param [IN] lReserved        
* @return ޡ
* @note  1) ûӦʱýݣȷ췵أӰ첥ڵý
*/
typedef VOID (STDCALL* PLAYER_SOURCE_MEDIA_DATA_CALLBACK_PF)(IN ULONG_32 ulPort,
                                                             IN const UCHAR *pucBuffer,
                                                             IN ULONG_32 ulBufSize,
                                                             IN ULONG_32 ulMediaDataType,
                                                             IN VOID* pUserParam,
                                                             IN LONG_REAL lReserved);

/**
* ƴ֡Ƶݻصָ \n
* @param [IN] ulPort                ͨ
* @param [IN] pstParseVideoData     ƴ֡ƵϢָ
* @param [IN] lUserParam            ûòûڵ# NDPlayer_SetParseVideoDataCB ʱָû
* @param [IN] lReserved             
* @return ޡ
* @note
* -     1) ûӦʱݣȷ췵أӰ첥ڵý
*/
typedef VOID (STDCALL *PLAYER_PARSE_VIDEO_DATA_CALLBACK_PF)(IN ULONG_32 ulPort,
                                                            IN const PLAYER_PARSE_VIDEO_DATA_S *pstParseVideoData,
                                                            IN VOID* pUserParam,
                                                            IN LONG_REAL lReserved);

/**
* ƴ֡Ƶݻصָ \n
* @param [IN] ulPort                ͨ
* @param [IN] pstParseAudioData     ƴ֡ƵϢָ
* @param [IN] lUserParam            ûòûڵ# NDPlayer_SetParseAudioDataCB ʱָû
* @param [IN] lReserved             
* @return ޡ
* @note
* -     1) ûӦʱݣȷ췵أӰ첥ڵý
*/
typedef VOID (STDCALL *PLAYER_PARSE_AUDIO_DATA_CALLBACK_PF)(IN ULONG_32 ulPort,
                                                            IN const PLAYER_PARSE_AUDIO_DATA_S *pstParseAudioData,
                                                            IN VOID* pUserParam,
                                                            IN LONG_REAL lReserved);

/**
* Ƶݻصָ \n
* @param [IN] ulPort         ͨ
* @param [IN] pPictureData   ŽƵϢָ
* @param [IN] lUserParam     ûòûڵ# NDPlayer_SetDecodeVideoMediaDataCB ʱָû
* @param [IN] lReserved      
* @return ޡ
* @note
* -     1) ûӦʱƵݣȷ췵أӰ첥ڵý
* -     2) Ƶyv12ʽ˳Y0-Y1-......U0-U1-......V0-V1-......
*/
typedef VOID (STDCALL* PLAYER_DECODE_VIDEO_DATA_CALLBACK_PF)(IN ULONG_32 ulPort,
                                                             IN const PLAYER_PICTURE_DATA_S *pPictureData,
                                                             IN VOID* pUserParam,
                                                             IN LONG_REAL lReserved);

/**
* Ƶݻصָ \n
* @param [IN] ulPort         ͨ
* @param [IN] pWaveData      ŽƵϢָ
* @param [IN] lUserParam     ûòûڵ# NDPlayer_SetDecodeAudioMediaDataCB ʱָû
* @param [IN] lReserved      
* @return ޡ
* @note
* -     1) ûӦʱƵݣȷ췵أӰ첥ڵý
*/
typedef VOID (STDCALL* PLAYER_DECODE_AUDIO_DATA_CALLBACK_PF)(IN ULONG_32 ulPort,
                                                             IN const PLAYER_WAVE_DATA_S *pWaveData,
                                                             IN VOID* pUserParam,
                                                             IN LONG_REAL lReserved);

/**
* ͼصָ \n
* @param [IN] hWnd           ھ
* @param [IN] hDc            ͼ豸
* @param [IN] lUserParam     ûò
* @param [IN] lReserved      
* @return ޡ
* @note
* -     1) ûӦʱƵݣȷ췵أӰ첥ڵý
*/
typedef VOID (STDCALL* PLAYER_DRAW_DATA_CALLBACK_PF)(IN HANDLE hWnd,
                                                     IN HANDLE hDc,
                                                     IN VOID* pUserParam,
                                                     IN LONG_REAL lReserved);

/**
* Խݻصָ \n
* @param [IN] ulPort         ͨ
* @param [IN] pWaveData      ŽƵϢָ
* @param [IN] lUserParam     ûòûڵ# NDPlayer_SetDecodeAudioMediaDataCB ʱָû
* @param [IN] lReserved      
* @return ޡ
* @note
* -     1) ûӦʱݣȷ췵أӰ첥ڵý
*/
typedef VOID (STDCALL *PLAYER_PARSE_VOICE_DATA_CALLBACK_PF)(IN ULONG_32 ulPort,
                                                            IN const PLAYER_WAVE_DATA_S *pWaveData,
                                                            IN VOID* pUserParam,
                                                            IN LONG_REAL lReserved);

/**
* Ԫݻصָ \n
* @param [IN] ulPort         ͨ
* @param [IN] pRuleHead      ŹϢͷ
* @param [IN] pRuleData      ŹϢָ룬IVA_REPORT_RULE_INFO_V2_SͣοŹϢͷĹ
* @param [IN] ulRuleLen      Ϣ
* @param [IN] pResultHead    ŽϢͷ
* @param [IN] pResultData    ŽϢָ룬IVA_REPORT_RESULT_INFO_V2_EX_SͣοŽϢͷĿ
* @param [IN] ulResultLen    Ϣ
* @param [IN] lUserParam     ûòûڵ# NDPlayer_SetDecodeAudioMediaDataCB ʱָû
* @param [IN] lReserved      
* @return ޡ
* @note
* -     1) ûӦʱݣȷ췵أӰ첥ڵý
*/
typedef VOID (STDCALL *PLAYER_IVA_DATA_CALLBACK_PF)(IN ULONG_32 ulPort,
                                                    IN IVA_REPORT_RULE_HEAD_V2_S *pRuleHead,
                                                    IN const VOID *pRuleData,
                                                    IN ULONG_32 ulRuleLen,
                                                    IN IVA_REPORT_RESULT_HEAD_V2_S *pResultHead,
                                                    IN const VOID *pResultData,
                                                    IN ULONG_32 ulResultLen,
                                                    IN VOID* pUserParam,
                                                    IN LONG_REAL lReserved);
/*************************************************************************************
Player init
***************************************************************************************/
/**
 * ȡ汾 \n
 * @param [IN] 
 * @return ǰ汾
 * @note 
 * -    1)  16 λʾǰ Build ţ 16 λʾ汾ţе 8 λʾ汾ţ 8 λʾΰ汾ţ
 * -    2) ֵ 0x00810502 ʾBuild Ϊ0081汾Ϊ2.5V2.5.0081
 */
ND_PLAYER_EXPORT ULONG_32 NDPlayer_GetVersion(VOID);

/**
* ȡ \n
* @param [IN] 
* @return:
          룬ERR_COMMON_SUCCEED
* @note
*-      1) ȡǰĴ룬ûڵĳʧʱô˺ôϸϢ
*/
ND_PLAYER_EXPORT ULONG_32 NDPlayer_GetLastError(VOID);

/**
* ò־ \n
* @param [IN] ulLogLevel        ־𣬲ο# PLAYER_LOGLEVEL_E
         [IN] pcLogPath         ־ļ·
         [IN] ulLogSize         ־С(λ KB)
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetLog(IN ULONG_32 ulLogLevel,
                                                IN CHAR *pcLogPath,
                                                IN ULONG_32 ulLogSize);

/**
* עᲥ־Ļص \n
* @param [IN] pfnWriteLogFunc ־صָ롣
* @return:
          BOOL_TRUE         ɹ
          BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) Ϊ˷ֹ־Ϣ¼©ûӦڵòӿں֮ǰøú
* -    2) ûøú־Ļص򲥷ڲ¼κ־Ϣ
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetWriteLogCB(IN PLAYER_WRITE_LOG_CALLBACK_PF pfnWriteLogFunc);

/**
* עϢ쳣Ϣص \n
* @param [IN] pfRunInfoFunc Ϣ쳣Ϣصָ
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) øĻصеòӿڣ
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetPlayerRunMsgCB(IN PLAYER_RUN_INFO_CALLBACK_PF pfnRunInfoFunc);

/**
* ʼSDKԴ \n
* @param [IN] ޡ
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_Init(VOID);

/**
* ͷŲSDKԴڽʹòSDK֮ǰ \n
* @param [IN] ޡ
* @return 
* @note
*/
ND_PLAYER_EXPORT VOID STDCALL NDPlayer_Cleanup(VOID);

/**
* ʼSDKԴ \n
* @param [IN] ޡ
* @return:ʼSDKԴĴ
* @note
*/
ND_PLAYER_EXPORT ULONG_32 STDCALL NDPlayer_GetInitCount(VOID);

/**
* H.264Ӳʹ \n
* @param [IN] bAble           BOOL_TRUEʾʹܣBOOL_FALSEʾȡ
* @return:bAbleΪBOOL_TRUEʱأΪBOOL_FALSEʱȻɹ
* -         BOOL_TRUE         ɹڽH.264ʱʹӲ
* -         BOOL_FALSE        ʧܣPC֧Ӳ
* @note
* -    1) ʹܺ´򿪵Ч֮ǰ򿪵Ȼʹԭ뷽ʽ
* -    2) ˽ӿڽʹInter H264Ӳ⣬ʹʹNDPlayer_AbleGpuDecodeExӿڡ
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_AbleGpuDecode(IN BOOL_T bAble);

/**
* Ӳʹܽӿ\n
* @param [IN] bAble               BOOL_TRUEʾʹܣBOOL_FALSEʾȡ
* @param [INOUT] pstGpuAbleState    ʹʱӳνGPUʹ״̬£
                                    BOOL_TRUEɹӦʹӲ
                                    BOOL_FALSEPCָ֧ñӲ
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ʹܺ´򿪵Ч֮ǰ򿪵Ȼʹԭ뷽ʽ
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_AbleGpuDecodeEx(IN BOOL_T bAble, INOUT PLAYER_GPU_ABLE_STATE_S *pstGpuAbleState);

/**
* GPUԻͼܿ \n
* @param [IN] ulPort         ͨ
* @param [IN] bAble          ʹܱ־BOOL_TRUEʹܣBOOL_FALSEرգ
* @return:
* -         BOOL_TRUE        ɹ
* -         BOOL_FALSE       ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetGpuDrawEnable(IN ULONG_32 ulPort, IN BOOL_T bAble);

/*************************************************************************************
Port manager(need init)
***************************************************************************************/
/**
* ж˿ں \n
* @param [INOUT] pulPort    ͨ
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_AllocPort(INOUT ULONG_32 *pulPort);

/**
* ͷŶ˿ں \n
* @param [IN] ulPort    ͨ
* @return 
* @note
*/
ND_PLAYER_EXPORT VOID STDCALL NDPlayer_FreePort(IN ULONG_32 ulPort);

/*************************************************************************************
Stream recv parse and decode(need port)
***************************************************************************************/
/**
* û \n
* @param [IN] ulPort                ͨ
* @param [IN] ulBufferSize          , λĬ1000, ÿ2048ֽ, 2MB, 鲻500
* @param [IN] ulDelayRenderTime     ӳʾʱ䣬ڻݣλ룬Ĭ5000룬ӳ٣0
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ˽ӿڱڻȡ֮ͨڴݲŻݲ֮ǰòЧ;
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetPacketBuffer(IN ULONG_32 ulPort,
                                                         IN ULONG_32 ulBufferSize,
                                                         IN ULONG_32 ulDelayRenderTime);

/**
* ûʱ \n
* @param [IN] ulPort                ͨ
* @param [IN] ulBufferCtrl          Ʒʽο# PLAYER_BUFFER_CTRL_E ĬΪPLAYER_BUFFER_CTRL_BLOCK
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ˽ӿڱڻȡ֮ͨڴݲŻݲ֮ǰòЧ;
* -    2) ĿǰڸٻʱԴڴʱʹã²ʹ
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetBufferCtrl(IN ULONG_32 ulPort,
                                                       IN ULONG_32 ulBufferCtrl);

/**
* òͼԻʵʱ \n
* @param [IN] ulPort                ͨ
* @param [IN] ulFluency             ͼʵʱȻȣ# PLAYER_PICTURE_FLUENCY_E öȡֵ
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ˽ӿڱڻȡ֮ͨڴݲŻݲ֮ǰòЧ;
* -    2) ûøúòͼԣ򲥷ڲĬʹͼȡ
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetPictureFluency(IN ULONG_32 ulPort,
                                                           IN ULONG_32 ulFluency);

/**
* ݲ \n
* @param [IN] ulPort           ͨ
* @param [IN] pucFileHeadBuf   ļͷݣ޿NULL
* @param [IN] ulSize           ļͷȣ޿0
* @param [IN] ulBufPoolSize    ýĻС0
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) źڲŹУͨ#NDPlayer_SetPlayerRunMsgCBõĻصϱϢ
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_OpenInputStream(IN ULONG_32 ulPort,
                                                         IN const UCHAR *pucFileHeadBuf,
                                                         IN ULONG_32 ulSize,
                                                         IN ULONG_32 ulBufPoolSize);

/**
* ݣ \n
* @param [IN] ulPort          ͨ
* @param [IN] pucDataBuf      ݻַ
* @param [IN] ulDataLen       ݻ
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ݲ֮
* -    2) ͨNDPlayer_SetBufferCtrlӿû
* -    3) Ϊýӿڷشڲȴһʱٴ
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_InputMediaData(IN ULONG_32 ulPort,
                                                        IN const UCHAR *pucDataBuf,
                                                        IN ULONG_32 ulDataLen);

/**
* رݲ \n
* @param [IN] ulPort    ͨ
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_CloseInputStream(IN ULONG_32 ulPort);

/**
* ݲ \n
* @param [IN] ulPort          ͨ
* @param [IN] pcLocalIP       IPַ
* @param [IN] usLocalPort     ؼ˿
* @param [IN] pcRemoteIP      ԶIPַ
* @param [IN] usRemotePort    Զ˶˿
* @param [IN] ulTransProtl    ýĴЭ飬#EZPLAYER_PROTOCOL_Eöȡֵ
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) Ŀǰ֧UDPЭý
* -    2) úֵ֧鲥ַʽʱʹñĬϵIPַ򱾵IPַַɣ
* -       ʱԶ˵IPַͶ˿ڿڶԽյݰУ顢ˣֹûҪֹ
* -       ɽԶIPַͶ˿ڷֱдΪ0.0.0.00鲥ʱԶ˵IPַͶ˿ڱд鲥ַͶ˿ڣ
* -       ʱIPַҲҪдһʵЧıIPַض˿ڿдֵ(ʹ)
* -    3) źڲŹУͨ#NDPlayer_SetPlayerRunMsgCBõĻصϱϢ
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_OpenNetStream(IN ULONG_32 ulPort,
                                                       IN const CHAR *pcLocalIP,
                                                       IN USHORT usLocalPort,
                                                       IN const CHAR *pcRemoteIP,
                                                       IN USHORT usRemotePort,
                                                       IN ULONG_32 ulTransProtl);

/**
* رݲ \n
* @param [IN] ulPort       ͨ
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_CloseNetStream(IN ULONG_32 ulPort);

/**
* payloadͱʽ \n
* @param [IN] ulPort            ͨ
* @param [IN] ulNum             ýƵƵΪ1ͬʱƵΪ2
* @param [IN] pstPayloadType    Payloadṹָ οPLAYER_PAYLOAD_TYPE_S
* @return ´룺
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) PayloadͲһͨýӿPayloadͣ
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetPayloadType(IN ULONG_32 ulPort,
                                                        IN ULONG_32 ulNum,
                                                        IN PLAYER_PAYLOAD_TYPE_S *pstPayloadType);

/**
* ƵϢ \n
* @param [IN] ulPort        ͨ
* @param [IN] pstAudioInfo  ƵϢṹָ οPLAYER_AUDIO_INFO_S
* @return ´룺
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ƵûƵͷҪͨýӿýƵϢ
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetAudioInfo(IN ULONG_32 ulPort, IN PLAYER_AUDIO_INFO_S *pstAudioInfo);

/**
* ͣ/ָţʵͣ/ָ \n
* @param [IN] ulPort    ͨ
* @param [IN] bPause    ͣ־BOOL_TRUEͣBOOL_FALSEָ
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) øýӿںڲ벥
* -    2) ýӿڽ֧ͣļͣ
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_PauseLive(IN ULONG_32 ulPort, IN BOOL_T bPause);
/*************************************************************************************
Voice play(need port)
***************************************************************************************/
/**
* ҵ \n
* @param [IN] ulPort          ͨ
* @param [IN] ulAudioEncType  Ƶͣ# PLAYER_AUDIO_ENCODE_TYPE_E öȡֵ
* @param [IN] ulSampleRate    Ƶ,ο# PLAYER_WAVE_FORMAT_PCM8M16
* @param [IN] ulChannels      Ƶ
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetVoiceEncodeType(IN ULONG_32 ulPort,
                                                            IN ULONG_32 ulAudioEncType,
                                                            IN ULONG_32 ulSampleRate,
                                                            IN ULONG_32 ulChannels);

/**
* ҵ \n
* @param [IN] ulPort            ͨ
* @param [IN] ulVoiceSvcType    ҵͣ# PLAYER_VOICE_SERVICE_TYPE_E öȡֵ
* @param [IN] stSocket          socketTCPҪṩ
* @param [IN] pcLocalIP         IPַUDPҪṩ
* @param [IN] usLocalPort       ˼˿ڣUDPҪṩ
* @param [IN] pcRemoteIP        ԶIPַUDPҪṩ
* @param [IN] usRemotePort      Զ˶˿ڣUDPҪṩ
* @param [IN] ulTransProtl      շýĴЭ飬# PLAYER_PROTOCOL_E öȡֵ
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ʹñĬϵIPַ򱾵IPַpcLocalIPַ;
* -    2) ҵڲŹУͨ# NDPlayer_SetPlayerRunMsgCB õĻصϱϢ# PLAYER_RUN_INFO_MEDIA_VOICE
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_OpenVoiceSvc(IN ULONG_32 ulPort,
                                                      IN ULONG_32 ulVoiceSvcType,
                                                      IN ULONG_32 stSocket,
                                                      IN const CHAR *pcLocalIP,
                                                      IN USHORT usLocalPort,
                                                      IN const CHAR *pcRemoteIP,
                                                      IN USHORT usRemotePort,
                                                      IN ULONG_32 ulTransProtl);

/**
* رҵ \n
* @param [IN] ulPort        ҵͨ
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_CloseVoiceSvc(IN ULONG_32 ulPort);

/**
* ˷ \n
* @param [IN] ulPort        ҵͨ
* @param [IN] lVolume       ˷
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ýӿں֧WindowsLinux
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetMicVolume(IN ULONG_32 ulPort, IN LONG_32 lVolume);

/**
* ȡ˷ \n
* @param [IN] ulPort        ҵͨ
* @param [IN] plVolume      ˷
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ýӿں֧WindowsLinux
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_GetMicVolume(IN ULONG_32 ulPort, INOUT LONG_32 *plVolume);

/**
 * ˷羲״̬ \n
 * @param [IN] ulPort                   ͨ
 * @param [IN] bQuiet                   ǷBOOL_TRUE
 * @return:
 * -         BOOL_TRUE         ɹ
 * -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
 * @note
 * -    1) ýӿں֧WindowsLinux
 */
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetMicQuietStatus(IN ULONG_32 ulPort, IN BOOL_T bQuiet);

/**
 * ȡ˷羲״̬ \n
 * @param [IN] ulPort                   ͨ
 * @param [IN] pbQuiet                  ǷBOOL_TRUE
 * @return:
 * -         BOOL_TRUE         ɹ
 * -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
 * @note
 * -    1) ýӿں֧WindowsLinux
 */
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_GetMicQuietStatus(IN ULONG_32 ulPort, INOUT BOOL_T *pbQuiet);

/**
* 
* @param [IN] ulPort    ͨ
* @param [IN] pucDataBuf            ݵַ
* @param [IN] ulDataLen             ݳ
* @param [IN] pstVoiceParam         
* @return Ƿɹ
*         ERR_COMMON_SUCCEED        ɹ
*         ERR_COMMON_INVALID_PARAM  Ч
* @note
* -    1) PCMƵݳС1600Ϊ160
*/
ND_PLAYER_EXPORT ULONG_32 STDCALL NDPlayer_VoiceInputData(IN ULONG_32 ulPort,
                                                          IN const UCHAR *pucDataBuf,
                                                          IN ULONG_32 ulDataLen,
                                                          IN PLAYER_AUDIO_SAMPLE_PARAM_S *pstVoiceParam);

/**
* ýݻص\n
* @param [IN] ulPort                    ͨ
* @param [IN] pfnParseVoiceDataCBFun    ݻصָ
* @param [IN] bContinue                 ǷкĲŲ
* @param [IN] lUserParam                ûò
* @return ´룺
* -         #ERR_COMMON_SUCCEED                      ɹ
* -         #ERR_FAIL_TO_GET_PORT_RES                òͨԴʧ
* -         #ERR_FAIL_TO_SET_PROCESS_DATA_CB         ýݻصʧ
* @note
*      1) صҪ췵أҪֹͣص԰ѻصָΪNULL
*/
ND_PLAYER_EXPORT ULONG_32 STDCALL NDPlayer_SetParseVoiceDataCB(IN ULONG_32 ulPort,
                                                               IN PLAYER_PARSE_VOICE_DATA_CALLBACK_PF pfnParseVoiceDataCBFun,
                                                               IN BOOL_T bContinue,
                                                               IN VOID* pUserParam);

/*************************************************************************************
File recv parse, decode and control(need port)
***************************************************************************************/
/**
 * ýļ \n
 * @param [IN] ulPort                   ͨ
 * @param [IN] pcFilename               ýļ鳤Ȳ256ֽ
 * @return:
 * -         BOOL_TRUE         ɹ
 * -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
 * @note
  * -    1) ýӿļ
 */
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_OpenMediaFile(IN ULONG_32 ulPort, 
                                                       IN const CHAR *pcFilename);

/**
 * رýļ \n
 * @param [IN] ulPort                    ͨ
 * @return:
 * -         BOOL_TRUE         ɹ
 * -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
 * @note
  * -    1) ýӿļ
 */
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_CloseMediaFile(IN ULONG_32 ulPort);

/**
* ȡMp4ļľʱ \n
* @param [IN] fMp4File              MP4ļ
* @param [INOUT] pulRealTime        ʱ
* @return ´룺
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
 * -    1) ýӿļ
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_MP4GetRealTime(IN const CHAR *pcFileName, INOUT ULONG_32 *pulRealTime);

/**
 * ͣ/ָ \n
 * @param [IN] ulPort                   ͨ
 * @param [IN] bPause                   BOOL_TRUE: ͣ, BOOL_FLASE: ָ
 * @return:
 * -         BOOL_TRUE         ɹ
 * -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
 * @note
 * -    1) ýӿļ
 */
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_PausePlay(IN ULONG_32 ulPort, IN BOOL_T bPause);

/**
 * òٶ \n
 * @param [IN] ulPort                   ͨ
 * @param [IN] ulSpeed                  ٶ(# PLAYER_PLAY_SPEED_E)
 * @return:
 * -         BOOL_TRUE         ɹ
 * -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
 * @note
 * -    1) ýӿļ
 * -    2) ٶ£Ƶ
 */
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SpeedPlay(IN ULONG_32 ulPort, IN ULONG_32 ulSpeed);

/**
 * ȡļʱ \n
 * @param [IN] ulPort                    ͨ
 * @param [INOUT] pulTotalTime             ļܵʱ䳤ȵָ루λ: s
 * @return:
 * -         BOOL_TRUE         ɹ
 * -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
 * @note
 * -    1) ýӿļ
 */
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_GetFileTime(IN ULONG_32 ulPort, INOUT ULONG_32 *pulTotalTime);

/**
 * ǰʱ \n
 * @param [IN] ulPort                   ͨ
 * @param [INOUT] pulPlayTime           ǰʱ䣬UTCʱ
 * @return:
 * -         BOOL_TRUE         ɹ
 * -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
 * @note
* -    1) NVRطԼļ
 */
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_GetPlayTime(IN ULONG_32 ulPort, 
                                                     INOUT ULONG_32 *pulPlayTime);

/**
 * õǰʱ \n
 * @param [IN] ulPort                    ͨ
 * @param [IN] ulTime                    תĿʱ䣨λ: s
 * @return:
 * -         BOOL_TRUE         ɹ
 * -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
 * @note
 * -    1) ýӿļ
 */
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetPlayedTime(IN ULONG_32 ulPort, IN  ULONG_32 ulTime);

/**
 * ֡ \n
 * @param [IN] ulPort                    ͨ
 * @return:
 * -         BOOL_TRUE         ɹ
 * -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
 * @note
 * -    1) ýӿļ
 * -    2) ٶ£Ƶ
 */
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_AFrameGo(IN ULONG_32 ulPort);

/**
 * ˮӡУ \n
 * @param [IN] ulPort                   ͨ
 * @param [IN] pcFilename               ýļ鳤260ֽ
 * @param [INOUT] pstMarkInfo           У˵ο # PLAYER_MARK_INFO_S ˵
 * @return:
 * -         BOOL_TRUE         ɹ
 * -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
 * @note
 * -    1) ҪͨNDPlayer_AllocPort½һͨԴд
 * -    2) ýӿͬạ̃߳鴴һ̵߳ãУпɵPlayer_CheckMarkCancelȡ
 * -    3) PLAYER_MARK_INFO_SµpstUnmarkTimeListҪûýPlayer_FreeMarkInfoͷţڴй©
 */
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_CheckMark(IN ULONG_32 ulPort, 
                                                   IN const CHAR *pcFilename, 
                                                   INOUT PLAYER_MARK_INFO_S *pstMarkInfo);

/**
 * ˮӡУȡ \n
 * @param [IN] ulPort                   ͨ
 * @return:
 * -         BOOL_TRUE         ɹ
 * -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
 * @note
 */
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_CheckMarkCancel(IN ULONG_32 ulPort);

/**
 * ͷˮӡԴ \n
 * @param [INOUT] pstMarkInfo           У˵ο # PLAYER_MARK_INFO_S ˵
 * @return 
 */
ND_PLAYER_EXPORT VOID STDCALL NDPlayer_FreeMarkInfo(INOUT PLAYER_MARK_INFO_S *pstMarkInfo);

/*************************************************************************************
video play(need port and stream/file)
***************************************************************************************/
/**
* ʼ \n
* @param [IN] ulPort    ͨ
* @param [IN] hWnd      ھ
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ھռδͷǰظʹã᷵ERR_CREATE_DEV_FAILED;
* -    2) ȡʾ¿ɲøýӿ;
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_StartPlay(IN ULONG_32 ulPort, 
                                                   IN HANDLE hWnd);

/**
* ֹͣ \n
* @param [IN] ulPort ͨ
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ýӿڻͷŴھռãͷźٴʹ
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_StopPlay(IN ULONG_32 ulPort, 
                                                  IN HANDLE hWnd);

/*************************************************************************************
Render control(need video play)
***************************************************************************************/
/**
 * ôʾ \n
 * @param [IN] ulPort                   ͨ
 * @param [IN] hWnd                     Ŵھ
 * @param [IN] lRenderScale             Ƶʾ# PLAYER_RENDER_SCALE_E 
 * @return:
 * -         BOOL_TRUE         ɹ
 * -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
 * @note
 * -    1) ڲŹеã
 * -    2) ָھѱ󶨺õģʧܣ
 * -    3) ýӿں֧WindowsLinux
 */
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetRenderScale(IN ULONG_32 ulPort, 
                                                        IN HANDLE hWnd, 
                                                        IN LONG_32 lRenderScale);

/**
 * ȡʾ \n
 * @param [IN] ulPort                   ͨ
 * @param [IN] hWnd                     Ŵھ
 * @param [INOUT] plRenderScale         Ƶʾο#PLAYER_RENDER_SCALE_E 
 * @return:
 * -         BOOL_TRUE         ɹ
 * -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
 * @note
 * -    1) ڲŹеã
 * -    2) ָھѱ󶨺õģʧܣ
 * -    3) ýӿں֧WindowsLinux
 */
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_GetRenderScale(IN ULONG_32 ulPort, 
                                                        IN HANDLE hWnd, 
                                                        INOUT LONG_32 *plRenderScale);

/**
 * ַŴʾ \n
 * @param [IN] ulPort                   ͨ
 * @param [IN] hWnd                     Ŵھ
 * @param [IN] pstRect                  ԭʼͼƬķŴֱȣϵ£ҾΪ0-10000NULLΪȫʾ
 * @return:
 * -         BOOL_TRUE         ɹ
 * -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
 * @note
 * -    1) ԭͼƬĳΪ׼ֱȣڴʾ򣩣
           ʾͼ°벿֣left = 5000right = 10000 top = 5000bottom = 10000
 */
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetDigitalZoom(IN ULONG_32 ulPort, 
                                                        IN HANDLE hWnd, 
                                                        IN PLAYER_RECT_S *pstRect);

/*************************************************************************************
Audio play(need port and stream/file)
***************************************************************************************/
/**
 * Ƶ \n
 * @param [IN] ulPort        ͨ
 * @return:
 * -         BOOL_TRUE         ɹ
 * -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
 * @note
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_OpenSound(IN ULONG_32 ulPort);

/**
 * رƵ \n
 * @param [IN] ulPort        ͨ
 * @return:
 * -         BOOL_TRUE         ɹ
 * -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
 * @note
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_CloseSound(IN ULONG_32 ulPort);

/**
 * ȡ \n
 * @param [IN] ulPort                     ͨ
 * @param [INOUT] plVolume                
 * @return:
 * -         BOOL_TRUE         ɹ
 * -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
 * @note
 * -    1) ýӿں֧WindowsLinux
 */
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_GetSoundVolume(IN ULONG_32 ulPort, 
                                                        INOUT LONG_32 *plVolume);

/**
 *  \n
 * @param [IN] ulPort               ͨ
 * @param [IN] lVolume              (0-255Ĭ128
 * @return:
 * -         BOOL_TRUE         ɹ
 * -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
 * @note
 * -    1) ýӿں֧WindowsLinux
 */
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetSoundVolume(IN ULONG_32 ulPort, 
                                                        IN LONG_32 lVolume);

/**
 * ״̬ \n
 * @param [IN] ulPort                   ͨ
 * @param [IN] bQuiet                   ǷBOOL_TRUE
 * @return:
 * -         BOOL_TRUE         ɹ
 * -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
 * @note
 * -    1) ýӿں֧WindowsLinux
 */
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetSoundQuietStatus(IN ULONG_32 ulPort, 
                                                             IN BOOL_T bQuiet);

/**
 * ȡ״̬ \n
 * @param [IN]    ulPort                ͨ
 * @param [INOUT] pbQuiet               ǷBOOL_TRUE
 * @return:
 * -         BOOL_TRUE         ɹ
 * -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
 * @note
 * -    1) ýӿں֧WindowsLinux
 */
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_GetSoundQuietStatus(IN ULONG_32 ulPort, 
                                                             INOUT BOOL_T *pbQuiet);

/*************************************************************************************
call back(need port and stream/file)
***************************************************************************************/
/**
* ƴ֡ǰýݻص \n
* @param [IN] ulPort                  ͨ
* @param [IN] pfnSourceMediaDataCBFun ƴ֡ǰýݻصָ
* @param [IN] bContinue               Ƿкƴ֡ʾ
* @param [IN] pUserParam              ûò
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -     1) ú# NDPlayer_StartPlay֮ǰ֮ã# NDPlayer_StopPlayʱԶʧЧ;
* -     2) صҪ췵أҪֹͣص԰ѻصָΪNULL
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetSourceMediaDataCB(IN ULONG_32 ulPort,
                                                              IN PLAYER_SOURCE_MEDIA_DATA_CALLBACK_PF pfnSourceMediaDataCBFun,
                                                              IN BOOL_T bContinue,
                                                              IN VOID* pUserParam);

/**
* ƴ֡Ƶݻص \n
* @param [IN] ulPort                    ͨ
* @param [IN] pfnParseVideoDataCBFun    ƴ֡Ƶݻصָ
* @param [IN] bContinue                 Ƿнʾ
* @param [IN] lUserParam                ûò
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ú# NDPlayer_StartPlay֮ǰ֮ã# NDPlayer_StopPlayʱԶʧЧ;
* -    2) صҪ췵أҪֹͣص԰ѻصָΪNULL
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetParseVideoDataCB(IN ULONG_32 ulPort,
                                                             IN PLAYER_PARSE_VIDEO_DATA_CALLBACK_PF pfnParseVideoDataCBFun,
                                                             IN BOOL_T bContinue,
                                                             IN VOID* pUserParam);

/**
* ƴ֡Ƶݻص \n
* @param [IN] ulPort                    ͨ
* @param [IN] pfnParseAudioDataCBFun    ƴ֡Ƶݻصָ
* @param [IN] bContinue                 ǷнͲŲ
* @param [IN] lUserParam                ûò
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ú# NDPlayer_StartPlay֮ǰ֮ã# NDPlayer_StopPlayʱԶʧЧ;
* -    2) صҪ췵أҪֹͣص԰ѻصָΪNULL
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetParseAudioDataCB(IN ULONG_32 ulPort,
                                                             IN PLAYER_PARSE_AUDIO_DATA_CALLBACK_PF pfnParseAudioDataCBFun,
                                                             IN BOOL_T bContinue,
                                                             IN VOID* pUserParam);
/**
* ýƵýݻص \n
* @param [IN] ulPort                    ͨ
* @param [IN] pfnDecodeVideoDataCBFun   Ƶýݻصָ
* @param [IN] bContinue                 Ƿкʾ
* @param [IN] lUserParam                ûò
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ú# NDPlayer_StartPlay֮ǰ֮ã# NDPlayer_StopPlayʱԶʧЧ;
* -    2) صҪ췵أҪֹͣص԰ѻصָΪNULL
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetDecodeVideoMediaDataCB(IN ULONG_32 ulPort,
                                                                   IN PLAYER_DECODE_VIDEO_DATA_CALLBACK_PF pfnDecodeVideoDataCBFun,
                                                                   IN BOOL_T bContinue,
                                                                   IN VOID* pUserParam);
/**
* ýƵýݻص \n
* @param [IN] ulPort                    ͨ
* @param [IN] pfnDecodeAudioDataCBFun   Ƶýݻصָ
* @param [IN] bContinue                 ǷкĲŲ
* @param [IN] lUserParam                ûò
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ú# NDPlayer_StartPlay֮ǰ֮ã# NDPlayer_StopPlayʱԶʧЧ;
* -    2) صҪ췵أҪֹͣص԰ѻصָΪNULL
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetDecodeAudioMediaDataCB(IN ULONG_32 ulPort,
                                                                   IN PLAYER_DECODE_AUDIO_DATA_CALLBACK_PF pfnDecodeAudioDataCBFun,
                                                                   IN BOOL_T bContinue,
                                                                   IN VOID* pUserParam);

/**
* ûͼص \n
* @param [IN] ulPort                    ͨ
* @param [IN] pfnDecodeAudioDataCBFun   ͼصָ
* @param [IN] lUserParam                ûò
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ú# NDPlayer_StartPlay֮ǰ֮ã# NDPlayer_StopPlayʱԶʧЧ;
* -    2) صҪ췵أҪֹͣص԰ѻصָΪNULL
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetDrawMediaDataCB(IN ULONG_32 ulPort,
                                                            IN PLAYER_DRAW_DATA_CALLBACK_PF pfnDrawDataCBFun,
                                                            IN VOID* pUserParam);

/*************************************************************************************
Media Statistics
***************************************************************************************/
/**
 * ȡ֡ \n
 * @param [IN]    ulPort                ͨ
 * @param [INOUT] plFrameRate           ֡
 * @return:
 * -         BOOL_TRUE         ɹ
 * -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
 * @note
 */
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_GetFrameRate(IN ULONG_32 ulPort, 
                                                      INOUT LONG_32 *plFrameRate);

/**
 * ȡ \n
 * @param [IN]  ulPort                  ͨ
 * @param [OUT] plBitRate               
 * @return ´
 * -         BOOL_TRUE         ɹ
 * -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
 * @note
 */
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_GetBitRate(IN ULONG_32 ulPort, 
                                                    OUT LONG_32 *plBitRate);

/**
 * ȡ \n
 * @param [IN]      ulPort                  ͨ
 * @param [INOUT]   plRecvPktNum            ܰ
 * @param [INOUT]   plLostPktNum            
 * @return:
 * -         BOOL_TRUE         ɹ
 * -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
 * @note
 */
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_GetLostPacketRate(IN ULONG_32 ulPort, 
                                                           INOUT LONG_32 *plRecvPktNum, 
                                                           INOUT LONG_32 *plLostPktNum);

/**
 * ö \n
 * @param [IN] ulPort                   ͨ
 * @return:
 * -         BOOL_TRUE         ɹ
 * -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
 * @note
 */
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_ResetLostPacketRate(IN ULONG_32 ulPort);

/**
 * ȡͼƬС \n
 * @param [IN]    ulPort            ͨ
 * @param [INOUT] plWidth           ͼ
 * @param [INOUT] plHeight          ͼ߶
 * @return:
 * -         BOOL_TRUE         ɹ
 * -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
 * @note
 */
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_GetPictureSize(IN ULONG_32 ulPort, 
                                                        INOUT LONG_32 *plWidth, 
                                                        INOUT LONG_32 *plHeight);

/**
 * ȡ/Ƶ \n
 * @param [IN]    ulPort                ͨ
 * @param [INOUT] pulVideoEncodeType    Ƶʽָ룬ο# PLAYER_VIDEO_ENCODE_TYPE_E
 * @param [INOUT] pulAudioEncodeType    Ƶʽָ룬ο# PLAYER_AUDIO_ENCODE_TYPE_E
 * @return:
 * -         BOOL_TRUE         ɹ
 * -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
 * @note
 */
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_GetEncodeType(IN ULONG_32 ulPort, 
                                                       INOUT ULONG_32 *pulVideoEncodeType,
                                                       INOUT ULONG_32 *pulAudioEncodeType);

/*************************************************************************************
Record and Snap(need port and stream/file)
***************************************************************************************/
/**
* ¼ļС \n
* @param [IN] ulPort        ͨ
* @param [IN] ulFileSize    ¼ļСλMBΧ10MB4000MB
* @return ´룺
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ¼ʼǰ
* -    2) ǷãСﵽֵ4000MBʱԶֶ
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetRecordSize(IN ULONG_32 ulPort, IN ULONG_32 ulFileSize);

/**
* ¼ļʱ \n
* @param [IN] ulPort        ͨ
* @param [IN] ulTime        ¼ļʱλ:ӣ
* @return ´룺
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ¼ʼǰ
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetRecordDivByTime( IN ULONG_32 ulPort, IN ULONG_32 ulTime);

/**
* ʼ¼ \n
* @param [IN] ulPort            ͨ
* @param [IN] pcFileName        ¼ļ·ļ׺
* @param [IN] ulMediaFileFormat ¼ļĸʽ# PLAYER_FILE_FORMATE_E öȡֵ
* @param [INOUT] pcFilePostfix  ¼ļ׺ָ
*                               ûҪغ׺ɽòΪNULL
* @return ´룺
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ýʽļ׷ӶӦĺ׺TS¼ļĺ׺Ϊ.ts
* -    2) ŴͣšٲšٲŻ֡״̬ʱ֧¼
* -    3) ¼¼Уͨ#NDPlayer_SetPlayerRunMsgCBõĻصϱϢ# PLAYER_RUN_INFO_RECORD_VIDEO ЯĴ룺
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_StartRecord(IN ULONG_32 ulPort,
                                                     IN const CHAR *pcFileName,
                                                     IN ULONG_32 ulMediaFileFormat,
                                                     INOUT CHAR *pcFilePostfix);

/**
* ֹͣ¼ \n
* @param [IN] ulPort    ͨ
* @return ´룺
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_StopRecord(IN ULONG_32 ulPort);

/**
* ȡͨ¼״̬ \n
* @param [IN]    ulPort         ͨ
* @param [INOUT] pbRecording    Ƿ¼
* @return ´룺
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_GetRecordStatus(IN ULONG_32 ulPort, 
                                                         INOUT BOOL_T *pbRecording);

/**
* ȡ¼ļС \n
* @param [IN]    ulPort                 ͨ
* @param [INOUT] pulRecordFileSize      ¼ļС
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ýӿڽ֧Windows
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_GetRecordFileSize( IN ULONG_32 ulPort, INOUT DULONG *pulRecordFileSize);

/**
* ʵʱץ \n
* @param [IN] ulPort            ͨ
* @param [IN] pcFileName        ͼļ·ļ׺
* @param [IN] ulPicFormat       ͼʽ# PLAYER_PIC_FORMATE_E öȡֵ
* @param [INOUT] pcFilePostfix  ͼļ׺ָ
*                               ûҪغ׺ɽòΪNULL
* @return ´룺
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ͼʽļ׷ӶӦĺ׺BMPͼļĺ׺Ϊ.bmp
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SnatchOnce(IN ULONG_32 ulPort,
                                                    IN const CHAR *pcFileName,
                                                    IN ULONG_32 ulPicFormat,
                                                    INOUT CHAR *pcFilePostfix);

/**
* ʵʱץչ(֧첽) \n
* @param [IN] ulPort            ͨš
* @param [IN] pcFileName        ͼļ·ļ׺
* @param [IN] ulPicFormat       ͼʽ# PLAYER_PIC_FORMATE_E öȡֵ
* @param [IN] bAsync            첽־ΪBOOL_TRUEʱΪ첽ᵥ߳̽нͼ
*                               ΪBOOL_FALSEʱNDPlayer_SnatchOnceӿͬ
* @return ´룺
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ͼʽļ׷ӶӦĺ׺BMPͼļĺ׺Ϊ.bmp
* -    2) ֱƵͼʹ첽ܻƵ
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SnatchOnceEx(IN ULONG_32 ulPort,
                                                      IN const CHAR *pcFileName,
                                                      IN ULONG_32 ulPicFormat,
                                                      IN BOOL_T bAsync);

/*************************************************************************************
Picture Adjust And Enhance(need video play)
***************************************************************************************/

/**
* Ԫݻͼʹ \n
* @param [IN] ulPort            ͨ
* @param [IN] bAble             ʹܱ־BOOL_TRUEʹܣBOOL_FALSEرգ
* @return ´룺
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ýӿں֧Windows
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetIVAEnable(IN ULONG_32 ulPort, IN BOOL_T bAble);

/**
* ԪݻͼʾͲ \n
* @param [IN] ulShowParam       ԪʾͲο PLAYER_IVA_SHOW_RULE
* @return ´룺
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ýӿں֧Windows
* -    1) ýӿͨͨʹNDPlayer_SetIVAShowParamExӿ
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetIVAShowParam(IN ULONG_32 ulShowParam);

/**
* ԪݻͼʾͲչ \n
* @param [IN] ulPort        ͨ
* @param [IN] ulShowParam   ԪʾͲο PLAYER_IVA_SHOW_RULE
* @param [IN] bFlag         ͨ־ΪBOOL_TRUEulPortͨпƣ
*                           ΪBOOL_FALSEͨulPortʵ
* @return ´룺
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ýӿں֧Windows
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetIVAShowParamEx(IN ULONG_32 ulPort, IN ULONG_32 ulShowParam, BOOL_T bFlag);

/**
* ʹܱ \n
* @param [IN] ulPort            ͨ
* @param [IN] bTargetVeh        Ŀǡ
* @param [IN] bTargetNonVeh     Ŀǡǻ
* @param [IN] bTargetPerson     Ŀǡ

* @return ´룺
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ýӿں֧Windows
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_EnableTargetTag(IN ULONG_32 ulPort, BOOL_T bTargetVeh, BOOL_T bTargetNonVeh, BOOL_T bTargetPerson);

/**
* ʹOSD \n
* @param [IN] ulPort            ͨ
* @param [IN] bEnable           ʹܲBOOL_TRUEʹܣBOOL_FALSEرգ
* @return ´룺
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ԪʹܿʱøýӿڿʾOSDϢ
* -    2) ýӿں֧Windows
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_EnableIvaOsd(IN ULONG_32 ulPort, BOOL_T bEnable);

/**
* POSϢʹܡ\n
* @param [IN] ulPort                    ͨ
* @param [IN] bAble                     ʹܱ־BOOL_TRUEʹܣBOOL_FALSEرգ
* @return ´룺
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨNDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ýӿں֧Windows
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetPosEnable(IN ULONG_32 ulPort, IN BOOL_T bAble);

/**
* ȡPOSϢʹ״̬\n
* @param [IN] ulPort                    ͨ
* @param [OUT] bAble                    ʹܱ־BOOL_TRUEʹܣBOOL_FALSEرգ
* @return ´룺
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨNDPlayer_GetLastError ȡϸϢ
* @note
* -    3ýӿں֧Windows
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_GetPosEnable(IN ULONG_32 ulPort, IN BOOL_T *pbAble);

/**
* POSϢá\n
* @param [IN] ulPort                     ͨ
* @param [IN] stPosInfo                  POSϢ
* @return ´룺
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨNDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ýӿں֧Windows
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetPosInfo(IN ULONG_32 ulPort, IN PLAYER_POS_INFO_S *pstPosInfo);

/**
* Ԫݻص \n
* @param [IN] ulPort                    ͨ
* @param [IN] pfnIVADataCBFun           ͼصָ
* @param [IN] lUserParam                ûò
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ú# NDPlayer_StartPlay֮ǰ֮ã# NDPlayer_StopPlayʱԶʧЧ;
* -    2) صҪ췵أҪֹͣص԰ѻصָΪNULL
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetIvaDataCB(IN ULONG_32 ulPort,
                                                      IN PLAYER_IVA_DATA_CALLBACK_PF pfnIVADataCBFun,
                                                      IN VOID* pUserParam);
/*************************************************************************************
fish eye and ptz(need port and stream/file)
***************************************************************************************/
/**
* ȡ۽\n
* @param [IN]    ulPort             ͨ
* @param [INOUT] pstCenterPoint     ͼԲԲ
* @param [INOUT] pulRadius          ͼԲİ뾶
* @param [INOUT] pParm              Ԥ۾ͷ
* @return ´룺
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ýӿݲ֧Linux
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_GetFishEyeParam(IN ULONG_32 ulPort, 
                                                         INOUT PLAYER_POINT_S *pstCenterPoint, 
                                                         INOUT ULONG_32 *pulRadius,
                                                         INOUT VOID *pParm);

/**
* ģʽͰװλ\n
* @param [IN] ulPort                ͨ
* @param [IN] ulPtzMode             PTZģʽο# PLAYER_PTZ_MODE
* @param [IN] ulFixMode             װλãο# PLAYER_FIX_MODE
* @return ´룺
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ýӿݲ֧Linux
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetPtzAndFixMode(IN ULONG_32 ulPort, 
                                                          IN ULONG_32 ulPtzMode, 
                                                          IN ULONG_32 ulFixMode);

/**
* ȡģʽͰװλ\n
* @param [IN]    ulPort                 ͨ
* @param [INOUT] pulPtzMode             PTZģʽο# PLAYER_PTZ_MODE
* @param [INOUT] pulFixMode             װλãο# PLAYER_FIX_MODE
* @return ´룺
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ýӿݲ֧Linux
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_GetPtzAndFixMode(IN ULONG_32 ulPort, 
                                                          INOUT ULONG_32 *pulPtzMode, 
                                                          INOUT ULONG_32 *pulFixMode);

/**
* ýصʽ\n
* @param [IN] ulPort                ͨ
* @param [IN] lRectify              ýص
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) lRectifyοöPLAYER_VIDEO_CB_TYPE_EĬΪֱӻص
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetVideoCallBackMode(IN ULONG_32 ulPort, IN ULONG_32 lRectify);

/**
* λƲ\n
* @param [IN] ulPort                ͨ
* @param [IN] ulFlags               ʵʱ־λʱ
* @param [IN] stPoint               λ
* @return ´룺
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ýӿݲ֧Linux
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_OnMouseMove(IN ULONG_32 ulPort, IN ULONG_32 ulFlags, IN PLAYER_POINT_S stPoint);

/**
* \n
* @param [IN] ulPort                ͨ
* @param [IN] ulFlags               ʵʱ־λʱ
* @param [IN] stPoint               λ
* @return ´룺
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ýӿݲ֧Linux
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_OnLButtonDown(IN ULONG_32 ulPort, IN ULONG_32 ulFlags, IN PLAYER_POINT_S stPoint);

/**
* \n
* @param [IN] ulPort                ͨ
* @param [IN] ulFlags               ʵʱ־λʱ
* @param [IN] stPoint               λ
* @return ´룺
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ýӿݲ֧Linux
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_OnLButtonUp(IN ULONG_32 ulPort, IN ULONG_32 ulFlags, IN PLAYER_POINT_S stPoint);

/**
* м\n
* @param [IN] ulPort                ͨ
* @param [IN] ulFlags               ʵʱ־λʱ
* @param [IN] sDelta                ƫƶ
* @param [IN] stPoint               λ
* @return ´룺
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ýӿݲ֧Linux
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_OnMouseWheel(IN ULONG_32 ulPort, IN ULONG_32 ulFlags, IN SHORT sDelta, IN PLAYER_POINT_S stPoint);

/**
* 5ePtzʾģʽ\n
* @param [IN] ulPort                ͨ
* @param [IN] ulPtzMode             5ePtzʾģʽο# PLAYER_PTZ_DISPLAY_MODE
* @return ´룺
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ýӿں֧Windows
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetPtzDisplayMode(IN ULONG_32 ulPort, IN ULONG_32 ulPtzMode);

/**
* ֶģʽʱ\n
* @param [IN] ulPort                ͨ
* @param [IN] ulKeepAliveTime       ñʱ
* @return ´룺
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ýӿں֧Windows
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetPtzKeepAliveTime(IN ULONG_32 ulPort, IN ULONG_32 ulKeepAliveTime);

/*************************************************************************************
Scramble(need port and stream/file)
***************************************************************************************/
/**
* RSA˽Կ\n
* @param [IN] pstRsaInfo                RSAϢ
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ڼ
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetRsaKey(IN PLAYER_RSA_INFO_S *pstRsaInfo);

/**
* ȡRSA˽Կ\n
* @param [INOUT] pstRsaInfo             RSAϢ
* @return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ڼ
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_GetRsaKey(INOUT PLAYER_RSA_INFO_S *pstRsaInfo);

/**
* ļ\n
* @param [IN] ulPort                    ͨ
* @param [IN] pcPassword                û
* @param [IN] lPasswordLen              û볤
*@return:
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ýӿڼļ
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetFilePassword(IN ULONG_32 ulPort, IN CHAR *pcPassword, IN LONG_32 lPasswordLen);

/*************************************************************************************
Buffer Queue(need port)
***************************************************************************************/
/**
 *ԭʼݻ\n
 * @param [IN] ulPort                   ͨ
 * @return:
 * -         BOOL_TRUE         ɹ
 * -         BOOL_FALSE        ʧܣͨNDPlayer_GetLastError ȡϸϢ
 * @note
 * -    1) ǰͨĻ
 */
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_CleanSrcMediaDataQueue(IN ULONG_32 ulPort);

/**
* ¶\n
* @param [IN] ulPort            ͨ
* @param [IN] ulTempeType       ¶ͣ˵ο #PLAYER_TEMPE_TYPE
* @param [IN] ulReserved1       Ԥ1չ
* @param [IN] ulReserved2       Ԥ2չ
* @return ´룺
* -         BOOL_TRUE         ɹ
* -         BOOL_FALSE        ʧܣͨ NDPlayer_GetLastError ȡϸϢ
* @note
* -    1) ȳ¶ͣ
* -    2) ýӿں֧Windows
*/
ND_PLAYER_EXPORT BOOL_T STDCALL NDPlayer_SetTempeType(IN ULONG_32 ulPort, IN ULONG_32 ulTempeType,
                                                      IN ULONG_32 ulReserved1, IN ULONG_32 ulReserved2);

#ifdef  __cplusplus
}
#endif /* end of __cplusplus */

#endif /* __PLAYER_SDK_FUNC_H__ */

