#ifndef __RTMP_SDK_FUNC_H__
#define __RTMP_SDK_FUNC_H__

#ifdef  __cplusplus
extern "C"{
#endif

#ifndef IN
    #define     IN
#endif

#ifndef OUT
    #define     OUT
#endif

#ifndef INOUT
    #define     INOUT
#endif

/** ѡ */
#if defined(WIN32)
    #define STDCALL                 __stdcall
    #if defined(ND_RTMP_DLL_EXPORTS)
        #define ND_RTMP_EXPORT      __declspec( dllexport )
    #else
        #define ND_RTMP_EXPORT      __declspec( dllimport )
    #endif
#else
    #ifdef i386
        #define STDCALL             __attribute__((stdcall))
    #else
        #define STDCALL
    #endif
    #define ND_RTMP_EXPORT
#endif

/** @brief 8λз */
#ifndef CHAR_DEF
#define CHAR_DEF
    typedef char                CHAR;
#endif

    /** @brief 8λ޷ */
#ifndef UCHAR_DEF
#define UCHAR_DEF
    typedef unsigned char       UCHAR;
#endif

    /** @brief 16λз */
#ifndef SHORT_DEF
#define SHORT_DEF
    typedef short               SHORT;
#endif

    /** @brief 16λ޷ */
#ifndef USHORT_DEF
#define USHORT_DEF
    typedef unsigned short      USHORT;
#endif

    /** @brief 32λз */
#ifndef LONG_DEF
#define LONG_DEF
    typedef long                LONG;
#endif

    /** @brief 32λ޷ */
#ifndef ULONG_DEF
#define ULONG_DEF
    typedef unsigned long       ULONG;
#endif

    /** @brief 32λз */
#ifndef LONG_32_DEF
#define LONG_32_DEF
    typedef int                 LONG_32;
#endif

    /** @brief 32λ޷ */
#ifndef ULONG_32_DEF
#define ULONG_32_DEF
    typedef unsigned int        ULONG_32;
#endif

    /** @brief  */
#ifndef BOOL_T_DEF
#define BOOL_T_DEF
    typedef unsigned int        BOOL_T;
#endif

    /** @brief ʾʱ */
#ifndef TIME_T_DEF
#define TIME_T_DEF
    typedef long                TIME_T;
#endif

/** @brief VOID */
#ifndef VOID_DEF
#define VOID_DEF
    #define VOID                void
#endif

    /** @brief ʾͨþ */
#ifndef HANDLE_DEF
#define HANDLE_DEF
    typedef VOID*               HANDLE;
#endif

    /** @brief ̹淶ֵ */
#ifndef BOOL_TRUE
    #define BOOL_TRUE           ((BOOL_T) 1)
#endif

#ifndef BOOL_FALSE
    #define BOOL_FALSE          ((BOOL_T) 0)
#endif

/*********************** RTMP ģ***********************************/
#define ERR_RTMP_SUCCEED                        0x00000000      /**< ִгɹ */
#define ERR_RTMP_FAIL                           0x00000001      /**< ִʧ */
#define ERR_RTMP_INVALID_PARAM                  0x00000002      /**< Ƿ */
#define ERR_RTMP_NO_MEMORY                      0x00000003      /**< ϵͳڴ治 */
#define ERR_RTMP_NET_INIT_FAIL                  0x00000004      /**< ʼʧ */
#define ERR_RTMP_SESSION_FULL                   0x00000005      /**< Ự */
#define ERR_RTMP_CONNECT_FAIL                   0x00000006      /**< RTMP ʧ */
#define ERR_RTMP_CREATETHREAD_FAIL              0x00000007      /**< ߳ʧ */
#define ERR_RTMP_RECV_DATA_NOTENOUGH            0x00000008      /**< ݲ */
#define ERR_RTMP_RECV_DATA_ABNORMAL             0x00000009      /**< 쳣 */
#define ERR_RTMP_FLV_PARSE_FAIL                 0x0000000A      /**< FLVʽʧ */

/**
* @enum tagRtmpnErrorType
* @brief Ự
* @attention
*/
typedef enum tagRtmpErrorType
{
    NDRTMP_ERROR_NET_FAILED = 0,                    /**< Ự */
    NDRTMP_ERROR_NET_TIMEOUT,                       /**< Ự糬ʱ */
    NDRTMP_ERROR_STREAM_NUM_FULL,                   /**< Ѿ */
    NDRTMP_ERROR_STREAM_THIRDSTOP,                  /**< ֹͣ */
    NDRTMP_ERROR_RTMP_CONNECT_FAIL,                 /**< RTMPʧ */
    NDRTMP_ERROR_RTMP_INIT_FAIL,                    /**< RTMPʼʧ */
    NDRTMP_ERROR_BUT
}NDRTMP_ERROR_TYPE_E;

/**
* @enum tagRtmpStreamType
* @brief ʽ
* @attention
*/
typedef enum tagRtmpStreamType
{
    NDRTMP_STREAM_TCP = 0,                          /**< TCP */
    NDRTMP_STREAM_UDP,                              /**< UDPݲ֧ */
    NDRTMP_STREAM_BUT
}NDRTMP_STREAM_TYPE_E;

/**
* @enum tagRtmpStreamType
* @brief ʽ
* @attention
*/
typedef enum tagRtmpSpeedType
{
    NDRTMP_SPEED_NORMAL = 0,                          /**< ٶ */
    NDRTMP_SPEED_BUT
}NDRTMP_SPEED_TYPE_E;

/**
* @enum tagRtmpStreamType
* @brief ִзʽ
* @attention
*/
typedef enum tagRtmpExecuteType
{
    NDRTMP_EXECUTE_NORMAL = 0,                          /**< ʽ */
    NDRTMP_EXECUTE_QUICK,                               /**< ģʽݲ֧ */
    NDRTMP_EXECUTE_BUT
}NDRTMP_EXECUTE_TYPE_E;

/**
* ⲿģṩRTMPģĻỰ״̬ص  \n
* @param [IN] ulSessionNo           Ự
* @param [IN] enErrorType           ״̬
* @param [IN] pParm                 չֶ
* @return
* - VOID
* @note
*/
typedef VOID (*NDRTMP_ERROR_REPORT_PF)(IN ULONG_32 ulSessionNo, IN NDRTMP_ERROR_TYPE_E enErrorType);

/**
* ⲿģṩRTMPģRTSPص  \n
* @param [IN] ulSessionNo           Ự
* @param [IN] pcDataBuf             
* @param [IN] lBufLen               ݴС
* @return
* - VOID
* @note
* - úڲʵֱ ʱֻ̣򵥿
*/
typedef VOID (*NDRTMP_DATA_OUTPUT_PF)(IN ULONG_32 ulSessionNo, IN CHAR *pcDataBuf, IN LONG_32 lBufLen);


/**
* ⲿģṩRTMPģ־LOGص   \n
* @param [IN] ulLogLevel            ӡ
* @param [IN] pszFileName           ļ
* @param [IN] ulLineNo              к
* @param [IN] pszFmt                ɱʽ
* @param [IN] "..."                 ɱ
* @return
* - VOID
* @note
* - ulLogLevel:DEBUG=1 INFO=2 WARNING=3 ERROR=4
*/
typedef VOID (*NDRTMP_SYS_LOG_PF)(IN ULONG_32 ulLogLevel, 
                                  IN const char *pszFileName, 
                                  IN ULONG_32 ulLineNo, 
                                  IN const char *pszFmt, ...);

/**
* RTMP ͨģ ģʼ \n
* @param [IN] ulMaxSession              Ự鲻128
* @param [IN] pfErrorReportFunction     Ự󱨸ص
* @param [IN] pfDataOutputFunction      ص
* @param [IN] pfSysLogFunction          ־ص
* @return
* - ERR_RTMP_SUCCEED        ɹ
* - οģ
* @note
*/
ND_RTMP_EXPORT LONG_32 STDCALL NDRtmp_Init(IN ULONG_32 ulMaxSession,
                                           IN NDRTMP_ERROR_REPORT_PF pfErrorReportFunction,
                                           IN NDRTMP_DATA_OUTPUT_PF pfDataOutputFunction,
                                           IN NDRTMP_SYS_LOG_PF pfSysLogFunction);

/**
* RTMP ͨģ ģ鷴ʼ \n
* @return
* - VOID
* @note
*/
ND_RTMP_EXPORT VOID STDCALL NDRtmp_Cleanup();

/**
* RTMP ͨģ  \n
* @param [IN] pcURL                     URI
* @param [IN] enStreamType              ͣĿǰ֧ NDRTMP_STREAM_TCP
* @param [IN] pcDestIpAddr              ĿIPΪUDPչãǰΪNULL
* @param [IN] usRecvPort                ؽն˿ڣΪUDPչãǰΪ0
* @param [IN] enSpeedType               ٶȣطãĿǰ֧ NDRTMP_SPEED_NORMAL
* @param [IN] tiStartPlayTime           ʼʱ䣬طãݲ֧֣ǰΪ0
* @param [IN] tiEndPlayTime             ʱ䣬طãݲ֧֣ǰΪ0
* @param [IN] pfErrorReportFunction     Ự󱨸صΪ֮չãʱãǰΪNULL
* @param [IN] pfDataOutputFunction      صΪ֮չãʱãǰΪNULL
* @param [IN] enExecuteType             ִģʽĿǰ֧ NDRTMP_EXECUTE_NORMAL
* @param [IN] pInParm                   չΪ֮չãʱãǰΪNULL
* @param [OUT] pulSessionNo             Ựţ
* @param [OUT] pOutParm                 չΪ֮չãʱãǰΪNULL
* @return
* - ERR_RTMP_SUCCEED  ɹ
* - οģ
* @note
*- ÿһ·ô˽ӿһΣȡĻỰŽڿƵǰ
*/
ND_RTMP_EXPORT LONG_32 STDCALL NDRtmp_StartStream(IN CHAR *pcURL,
                                                  IN NDRTMP_STREAM_TYPE_E enStreamType,
                                                  IN CHAR *pcDestIpAddr, 
                                                  IN USHORT usRecvPort,
                                                  IN NDRTMP_SPEED_TYPE_E enSpeedType,
                                                  IN TIME_T tiStartPlayTime,
                                                  IN TIME_T tiEndPlayTime,
                                                  IN NDRTMP_ERROR_REPORT_PF pfErrorReportFunction,
                                                  IN NDRTMP_DATA_OUTPUT_PF pfDataOutputFunction,
                                                  IN NDRTMP_EXECUTE_TYPE_E enExecuteType,
                                                  IN VOID *pInParm,
                                                  OUT ULONG_32 *pulSessionNo,
                                                  OUT VOID *pOutParm);

/**
* RTMP ͨģ ͣ \n
* @param [IN] ulSessionNo               Ự
* @return
* - VOID
* @note
*/
ND_RTMP_EXPORT VOID STDCALL NDRtmp_StopStream(IN ULONG_32 ulSessionNo);

#ifdef  __cplusplus
}
#endif /* end of __cplusplus */

#endif /* __RTMP_SDK_FUNC_H__ */

