#ifndef _IPCPLAYER_COMMON_H
#define _IPCPLAYER_COMMON_H

/**************************************************************
ԭ: SAFE_FREE(ptr)
˵: ͷָ,ͷCͨmallocڴ
: pt        ͷŵָ
壺
**************************************************************/
#define SAFE_FREE(ptr)\
    if ((ptr))                          \
    {                                   \
        free((ptr));                    \
        (ptr) = NULL;                   \
    }

/**************************************************************
ԭ: SAFE_DELETE(ptr)
˵: ͷָ,ͷC++ͨnewڴ
: ptr       ͷŵĶָ
壺
**************************************************************/
#define SAFE_DELETE(ptr)\
    if ((ptr))                          \
    {                                   \
        delete (ptr);                   \
        (ptr) = NULL;                   \
    }

/**************************************************************
ԭ: SAFE_DELETE_OBJECT(ptr)
˵: ͷGDI
: ptr       ͷŵGDIָ
壺
**************************************************************/
#define SAFE_DELETE_OBJECT(ptr)\
    if ((ptr))                          \
    {                                   \
        (ptr)->DeleteObject();          \
        delete (ptr);                   \
        (ptr) = NULL;                   \
    }


/**************************************************************
ԭ: SAFE_DESTROY_WINDOW(ptr)
˵: ͷMFCڶ
: ptr       ͷŵĴڶָ
壺
**************************************************************/
#define SAFE_DESTROY_WINDOW(ptr)\
    if ((ptr))                          \
    {                                   \
        (ptr)->DestroyWindow();         \
        delete (ptr);                   \
        (ptr) = NULL;                   \
    }

/**************************************************************
ԭ: CLOSE_SOCKET(s)
˵: رsocket
: s       رյsocket
壺
**************************************************************/
#define CLOSE_SOCKET(s)\
    if ((s) != INVALID_SOCKET)          \
    {                                   \
        closesocket((s));               \
        (s) = INVALID_SOCKET;           \
    }

/**************************************************************
ԭ: CLOSE_HANDLE(s)
˵: رվ
: h       رյľ
壺
**************************************************************/
#define CLOSE_HANDLE(h)\
    if ((h) != INVALID_HANDLE_VALUE)    \
    {                                   \
        (VOID)CloseHandle((h));               \
        (h) = INVALID_HANDLE_VALUE;     \
    }

/**************************************************************
ԭ: CHECK_PTR(ptr, ret, err)
˵: ָǷΪ
: ptr     ָ
      ret     ֵ
      err     Ϣ
壺
**************************************************************/
#define CHECK_PTR(ptr, ret, err)\
    if (NULL == ptr)                                    \
    {                                                   \
        LOG_MSG(LOG_LEVEL_ERROR, err);                  \
        return ret;                                     \
    }

/**************************************************************
ԭ: CHECK_PTR_NORET(ptr, err)
˵: ָǷΪ
: ptr     ָ
      err     Ϣ
壺
**************************************************************/
#define CHECK_PTR_NORET(ptr, err)\
    if (NULL == ptr)                                    \
    {                                                   \
        LOG_MSG(LOG_LEVEL_ERROR, err);                  \
        return;                                         \
    }

/**************************************************************
ԭ: CHECK_PTR_CUSTOM(ptr, err, st)
˵: ָǷΪ
: ptr     ָ
      err     Ϣ
      st      Զ(continue,break)
壺
**************************************************************/
#define CHECK_PTR_CUSTOM(ptr, st, err)\
    if (NULL == ptr)                                    \
    {                                                   \
        LOG_MSG(LOG_LEVEL_ERROR, err);                  \
        st;                                             \
    }

/******************************************************************************
ԭͣARGUMENT_USED
˵вδʹ
壺
******************************************************************************/
#define ARGUMENT_USED(x)        ((VOID)(x))

#ifndef STDCALL
#define STDCALL     __stdcall
#endif

#ifndef IN
#define IN
#endif

#ifndef OUT
#define OUT
#endif

#ifndef INOUT
#define INOUT
#endif


#define INVALID_VALUE           (-1)
#define BUFF_SMALL_SIZE         128
//#define BUFF_LARGE_SIZE         1024

typedef enum tagPlayStatus
{
    PLAY_STATUS_IDLE,               /* ״̬ */
    PLAY_STATUS_PAUSE,              /* ͣ״̬ */
    PLAY_STATUS_PLAYING             /*    */
}PLAY_STATUS_E;

typedef enum tagPlayType
{
    PLAY_FILE,                      /* ļ */
    PLAY_NETSTREAM,                 /*  */
}PLAY_TYPE_E;

/* ԶϢ */
#define WM_PLAYVOLUMESETTING        (WM_USER + 10)
#define WM_MICVOLUMESETTING         (WM_USER + 11)
#define WM_PLAYTIMESETTING          (WM_USER + 12)
#define WM_OPENNETSTREAM            (WM_USER + 13)
#define WM_SETBRIGHTNESS            (WM_USER + 14)
#define WM_SETCONTRAST              (WM_USER + 15)
#define WM_SETGAMMA                 (WM_USER + 16)
#define WM_SETHUE                   (WM_USER + 17)
#define WM_SETSATURATION            (WM_USER + 18)
#define WM_SETRADIOSOFT             (WM_USER + 19)
#define WM_SETRADIOBRIGHT           (WM_USER + 20)
#define WM_SETDYNAMICCONTRAST       (WM_USER + 21)
#define WM_SETMOTIONBLUR            (WM_USER + 22)
#define WM_SETVIDEOSHARPEN          (WM_USER + 23)
#define WM_SETWINSIZE               (WM_USER + 24)
#define WM_SETSOFTEN                (WM_USER + 25)
#define WM_SETDEFOGHIGH             (WM_USER + 26)
#define WM_SETDEFOGLOW              (WM_USER + 27)
#define WM_RESETVIDEOADJUST         (WM_USER + 28)
#define WM_RESETLOSTPKTRATE         (WM_USER + 29)
#define WM_RESETLOSTFRAMERATE       (WM_USER + 30)
#define WM_SETMODE                  (WM_USER + 31)
#define WM_SETRENDERSCALE           (WM_USER + 32)
#define WM_SETDIGITALZOOM           (WM_USER + 33)
#define WM_OPENSOUND                (WM_USER + 34)
#define WM_OPENMULTICAST            (WM_USER + 35)
#define WM_OPENMIC                  (WM_USER + 36)

/* ӰڲĬֵ */
#define BRIGHTNESS_DEFAULT     100
#define CONTRAST_DEFAULT       100
#define GAMMA_DEFAULT          10
#define HUE_DEFAULT            0
#define SATURATION_DEFAULT      100
#define DYNAMICCONTRASTMODE     0
#define MOTIONBLUR_DEFAULT      80
#define VIDEOSHARPEN_DEFAULT    5
#define DEFOGHIGHVALUE_DEFAULT  100
#define DEFOGLOWVALUE_DEFAULT   0

#endif


#include <string>

#include "Error.h"
//#include "Common.h"
#include "ThreadBase.h"
#include "SysLog.h"

long GetModulePath(char szPath[MAX_PATH]);
void MakeDir(const CHAR *pszPath);
void AppendTimeString(IN const CHAR* pszFormat, INOUT std::string& strBuf);
CString t2c(IN CString strUserPasswd, IN CString strPublicKey, IN CString strPublicElement);
long long cp(IN long long s, IN long long pk, IN long long rn);

#define OWNER_SENDMESSAGE(m, w, l) \
{                                                   \
    CWnd* pWnd = GetOwner();                        \
    if (pWnd)                                       \
{                                               \
    pWnd->SendMessage(m, w, l);                 \
}                                               \
}

#define OWNER_SENDCOMMAND(m) \
    OWNER_SENDMESSAGE(WM_COMMAND, m, 0)

