// DlgFish.cpp : ʵļ
#include "stdafx.h"
#include "EZMediaDemo.h"
#include "DlgIntellect.h"
#include "EZMediaDemoDlg.h"

extern CEZMediaDemoDlg *ga_pMainDlg;

// CDlgIntellect Ի

IMPLEMENT_DYNAMIC(CDlgIntellect, CDialog)

CDlgIntellect::CDlgIntellect(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgIntellect::IDD, pParent)
{
    m_hTopEnableIcon = AfxGetApp()->LoadIcon(IDI_TOP_ENABLE);
    m_hTopDisableIcon = AfxGetApp()->LoadIcon(IDI_TOP_DISABLE);

    m_hRightEnableIcon = AfxGetApp()->LoadIcon(IDI_RIGHT_ENABLE);
    m_hRightDisableIcon = AfxGetApp()->LoadIcon(IDI_RIGHT_DISABLE);

    m_hBottomEnableIcon = AfxGetApp()->LoadIcon(IDI_BOTTOM_ENABLE);
    m_hBottomDisableIcon = AfxGetApp()->LoadIcon(IDI_BOTTOM_DISABLE);

    m_h1PTZEnableIcon = AfxGetApp()->LoadIcon(IDI_1PTZ_ENABLE);
    m_h1PTZDisableIcon = AfxGetApp()->LoadIcon(IDI_1PTZ_DISABLE);

    m_h2PTZEnableIcon = AfxGetApp()->LoadIcon(IDI_2PTZ_ENABLE);
    m_h2PTZDisableIcon = AfxGetApp()->LoadIcon(IDI_2PTZ_DISABLE);

    m_h3PTZEnableIcon = AfxGetApp()->LoadIcon(IDI_3PTZ_ENABLE);
    m_h3PTZDisableIcon = AfxGetApp()->LoadIcon(IDI_3PTZ_DISABLE);

    m_h4PTZEnableIcon = AfxGetApp()->LoadIcon(IDI_4PTZ_ENABLE);
    m_h4PTZDisableIcon = AfxGetApp()->LoadIcon(IDI_4PTZ_DISABLE);

    m_h6PTZEnableIcon = AfxGetApp()->LoadIcon(IDI_6PTZ_ENABLE);
    m_h6PTZDisableIcon = AfxGetApp()->LoadIcon(IDI_6PTZ_DISABLE);

    m_h8PTZEnableIcon = AfxGetApp()->LoadIcon(IDI_8PTZ_ENABLE);
    m_h8PTZDisableIcon = AfxGetApp()->LoadIcon(IDI_8PTZ_DISABLE);

    m_hORGEnableIcon = AfxGetApp()->LoadIcon(IDI_ORG_ENABLE);
    m_hORGDisableIcon = AfxGetApp()->LoadIcon(IDI_ORG_DISABLE);

}

CDlgIntellect::~CDlgIntellect()
{
}

BOOL CDlgIntellect::OnInitDialog()
{
    CDialog::OnInitDialog();

    CButton * pButton = (CButton *)GetDlgItem(IDC_MOUNT_TOP);
    pButton->SetIcon(m_hTopDisableIcon);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_MOUNT_RIGHT);
    pButton->SetIcon(m_hRightDisableIcon);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_MOUNT_BOTTOM);
    pButton->SetIcon(m_hBottomDisableIcon);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_MODE_ORG);
    pButton->SetIcon(m_hORGDisableIcon);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_FISH_1PTZ);
    pButton->SetIcon(m_h1PTZDisableIcon);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_FISH_2PTZ);
    pButton->SetIcon(m_h2PTZDisableIcon);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_FISH_3PTZ);
    pButton->SetIcon(m_h3PTZDisableIcon);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_FISH_4PTZ);
    pButton->SetIcon(m_h4PTZDisableIcon);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_FISH_6PTZ);
    pButton->SetIcon(m_h6PTZDisableIcon);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_FISH_8PTZ);
    pButton->SetIcon(m_h8PTZDisableIcon);
    pButton->EnableWindow(FALSE);

    /*ť*/
    m_tooltip.Create(this);
    m_tooltip.AddTool(GetDlgItem(IDC_MOUNT_TOP), _T("Top"));
    m_tooltip.AddTool(GetDlgItem(IDC_MOUNT_RIGHT), _T("Right"));
    m_tooltip.AddTool(GetDlgItem(IDC_MOUNT_BOTTOM), _T("Bottom"));
    m_tooltip.AddTool(GetDlgItem(IDC_MODE_ORG), _T("Org"));
    m_tooltip.AddTool(GetDlgItem(IDC_FISH_1PTZ), _T("1Ptz"));
    m_tooltip.AddTool(GetDlgItem(IDC_FISH_2PTZ), _T("2Ptz"));
    m_tooltip.AddTool(GetDlgItem(IDC_FISH_3PTZ), _T("3Ptz"));
    m_tooltip.AddTool(GetDlgItem(IDC_FISH_4PTZ), _T("4Ptz"));
    m_tooltip.AddTool(GetDlgItem(IDC_FISH_6PTZ), _T("6Ptz"));
    m_tooltip.AddTool(GetDlgItem(IDC_FISH_8PTZ), _T("8Ptz"));

    m_tooltip.SetMaxTipWidth(123);
    m_tooltip.Activate(TRUE);

    return TRUE;
}

/*밴ť¼ʾ*/
BOOL CDlgIntellect::PreTranslateMessage(MSG* pMsg)
{    
    ASSERT(pMsg != NULL);    
    if (pMsg->message == WM_MOUSEMOVE || pMsg->message == WM_LBUTTONDOWN ||
        pMsg->message == WM_LBUTTONUP)
    {        
        m_tooltip.RelayEvent(pMsg);
    }    
    return CDialog::PreTranslateMessage(pMsg);
}

void CDlgIntellect::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
}

void CDlgIntellect::EnableIcon()
{
    CButton* pButton = (CButton *)GetDlgItem(IDC_MOUNT_TOP);
    pButton->SetIcon(m_hTopEnableIcon);
    pButton->EnableWindow(TRUE);

    pButton = (CButton *)GetDlgItem(IDC_MOUNT_RIGHT);
    pButton->EnableWindow(TRUE);

    pButton = (CButton *)GetDlgItem(IDC_MOUNT_BOTTOM);
    pButton->EnableWindow(TRUE);

    pButton = (CButton *)GetDlgItem(IDC_MODE_ORG);
    pButton->SetIcon(m_hORGEnableIcon);
    pButton->EnableWindow(TRUE);

    pButton = (CButton *)GetDlgItem(IDC_FISH_1PTZ);
    pButton->EnableWindow(TRUE);

    pButton = (CButton *)GetDlgItem(IDC_FISH_2PTZ);
    pButton->EnableWindow(TRUE);

    pButton = (CButton *)GetDlgItem(IDC_FISH_3PTZ);
    pButton->EnableWindow(TRUE);

    pButton = (CButton *)GetDlgItem(IDC_FISH_4PTZ);
    pButton->EnableWindow(TRUE);

    pButton = (CButton *)GetDlgItem(IDC_FISH_6PTZ);
    pButton->EnableWindow(TRUE);

    pButton = (CButton *)GetDlgItem(IDC_FISH_8PTZ);
    pButton->EnableWindow(TRUE);
}

void CDlgIntellect::DisableIcon()
{
    CButton *pButton = (CButton *)GetDlgItem(IDC_MOUNT_TOP);
    pButton->SetIcon(m_hTopDisableIcon);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_MOUNT_RIGHT);
    pButton->SetIcon(m_hRightDisableIcon);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_MOUNT_BOTTOM);
    pButton->SetIcon(m_hBottomDisableIcon);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_MODE_ORG);
    pButton->SetIcon(m_hORGDisableIcon);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_FISH_1PTZ);
    pButton->SetIcon(m_h1PTZDisableIcon);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_FISH_2PTZ);
    pButton->SetIcon(m_h2PTZDisableIcon);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_FISH_3PTZ);
    pButton->SetIcon(m_h3PTZDisableIcon);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_FISH_4PTZ);
    pButton->SetIcon(m_h4PTZDisableIcon);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_FISH_6PTZ);
    pButton->SetIcon(m_h6PTZDisableIcon);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_FISH_8PTZ);
    pButton->SetIcon(m_h8PTZDisableIcon);
    pButton->EnableWindow(FALSE);
}

BEGIN_MESSAGE_MAP(CDlgIntellect, CDialog)
    ON_BN_CLICKED(IDC_MOUNT_TOP, &CDlgIntellect::OnBnClickedMountTop)
    ON_BN_CLICKED(IDC_MOUNT_RIGHT, &CDlgIntellect::OnBnClickedMountRight)
    ON_BN_CLICKED(IDC_MOUNT_BOTTOM, &CDlgIntellect::OnBnClickedMountBottom)
    ON_BN_CLICKED(IDC_MODE_ORG, &CDlgIntellect::OnBnClickedModeOrg)
    ON_BN_CLICKED(IDC_FISH_1PTZ, &CDlgIntellect::OnBnClickedFish1ptz)
    ON_BN_CLICKED(IDC_FISH_2PTZ, &CDlgIntellect::OnBnClickedFish2ptz)
    ON_BN_CLICKED(IDC_FISH_3PTZ, &CDlgIntellect::OnBnClickedFish3ptz)
    ON_BN_CLICKED(IDC_FISH_4PTZ, &CDlgIntellect::OnBnClickedFish4ptz)
    ON_BN_CLICKED(IDC_FISH_6PTZ, &CDlgIntellect::OnBnClickedFish6ptz)
    ON_BN_CLICKED(IDC_FISH_8PTZ, &CDlgIntellect::OnBnClickedFish8ptz)
    ON_BN_CLICKED(IDC_BUTTON_OPEN_OSD, &CDlgIntellect::OnBnClickedButtonOpenOsd)
    ON_BN_CLICKED(IDC_BUTTON_OPEN_WATERMARK, &CDlgIntellect::OnBnClickedButtonOpenWatermark)
    ON_BN_CLICKED(IDC_BUTTON_IVADATA_CB, &CDlgIntellect::OnBnClickedButtonIvadataCb)
END_MESSAGE_MAP()

/*װ*/
void CDlgIntellect::OnBnClickedMountTop()
{
    ULONG_32 ulFixMode = ga_pMainDlg->m_ulFixMode;
    ULONG_32 ulPTZMode = ga_pMainDlg->m_ulPTZMode;

    CButton *pButton = (CButton *)GetDlgItem(IDC_MOUNT_TOP);
    pButton->SetIcon(m_hTopEnableIcon);

    pButton = (CButton *)GetDlgItem(IDC_MOUNT_RIGHT);
    pButton->SetIcon(m_hRightDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_MOUNT_BOTTOM);
    pButton->SetIcon(m_hBottomDisableIcon);

    OnBnClickedModeOrg();

    ulFixMode = TOP_INSTALLATION;
    ulPTZMode = MODE_ORIGINAL;
    ga_pMainDlg->m_poPlayManager[0]->SetPtzAndMode(ulFixMode, ulPTZMode);
}

/*װ*/
void CDlgIntellect::OnBnClickedMountRight()
{
    ULONG_32 ulFixMode = ga_pMainDlg->m_ulFixMode;
    ULONG_32 ulPTZMode = ga_pMainDlg->m_ulPTZMode;
    CButton *pButton = (CButton *)GetDlgItem(IDC_MOUNT_TOP);
    pButton->SetIcon(m_hTopDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_MOUNT_RIGHT);
    pButton->SetIcon(m_hRightEnableIcon);

    pButton = (CButton *)GetDlgItem(IDC_MOUNT_BOTTOM);
    pButton->SetIcon(m_hBottomDisableIcon);

    OnBnClickedModeOrg();

    ulFixMode = SIDE_INSTALLATION;
    ulPTZMode = MODE_ORIGINAL;
    ga_pMainDlg->m_poPlayManager[0]->SetPtzAndMode(ulFixMode, ulPTZMode);
}

/*װ*/
void CDlgIntellect::OnBnClickedMountBottom()
{
    ULONG_32 ulFixMode = ga_pMainDlg->m_ulFixMode;
    ULONG_32 ulPTZMode = ga_pMainDlg->m_ulPTZMode;

    CButton *pButton = (CButton *)GetDlgItem(IDC_MOUNT_TOP);
    pButton->SetIcon(m_hTopDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_MOUNT_RIGHT);
    pButton->SetIcon(m_hRightDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_MOUNT_BOTTOM);
    pButton->SetIcon(m_hBottomEnableIcon);

    OnBnClickedModeOrg();

    ulFixMode = BOTTOM_INSTALLATION;
    ulPTZMode = MODE_ORIGINAL;
    ga_pMainDlg->m_poPlayManager[0]->SetPtzAndMode(ulFixMode, ulPTZMode);
}

/*ԭʼͼ*/
void CDlgIntellect::OnBnClickedModeOrg()
{
    ULONG_32 ulFixMode = ga_pMainDlg->m_ulFixMode;
    ULONG_32 ulPTZMode = ga_pMainDlg->m_ulPTZMode;

    CButton *pButton = (CButton *)GetDlgItem(IDC_MODE_ORG);
    pButton->SetIcon(m_hORGEnableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_1PTZ);
    pButton->SetIcon(m_h1PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_2PTZ);
    pButton->SetIcon(m_h2PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_3PTZ);
    pButton->SetIcon(m_h3PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_4PTZ);
    pButton->SetIcon(m_h4PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_6PTZ);
    pButton->SetIcon(m_h6PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_8PTZ);
    pButton->SetIcon(m_h8PTZDisableIcon);
    
    ga_pMainDlg->EnAbleDIG();//ַŴť

    ulPTZMode = MODE_ORIGINAL;
    ga_pMainDlg->m_poPlayManager[0]->SetPtzAndMode(ulFixMode, ulPTZMode);
}

/*1PTZģʽ*/
void CDlgIntellect::OnBnClickedFish1ptz()
{
    ULONG_32 ulFixMode = ga_pMainDlg->m_ulFixMode;
    ULONG_32 ulPTZMode = ga_pMainDlg->m_ulPTZMode;

    CButton *pButton = (CButton *)GetDlgItem(IDC_MODE_ORG);
    pButton->SetIcon(m_hORGDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_1PTZ);
    pButton->SetIcon(m_h1PTZEnableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_2PTZ);
    pButton->SetIcon(m_h2PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_3PTZ);
    pButton->SetIcon(m_h3PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_4PTZ);
    pButton->SetIcon(m_h4PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_6PTZ);
    pButton->SetIcon(m_h6PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_8PTZ);
    pButton->SetIcon(m_h8PTZDisableIcon);

    ga_pMainDlg->DisAbleDIG();//رַŴť

    ulPTZMode = MODE_360_1PTZ;
    ga_pMainDlg->m_poPlayManager[0]->SetPtzAndMode(ulFixMode, ulPTZMode);
}

/*2PTZģʽ*/
void CDlgIntellect::OnBnClickedFish2ptz()
{
    ULONG_32 ulFixMode = ga_pMainDlg->m_ulFixMode;
    ULONG_32 ulPTZMode = ga_pMainDlg->m_ulPTZMode;

    CButton *pButton = (CButton *)GetDlgItem(IDC_MODE_ORG);
    pButton->SetIcon(m_hORGDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_1PTZ);
    pButton->SetIcon(m_h1PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_2PTZ);
    pButton->SetIcon(m_h2PTZEnableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_3PTZ);
    pButton->SetIcon(m_h3PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_4PTZ);
    pButton->SetIcon(m_h4PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_6PTZ);
    pButton->SetIcon(m_h6PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_8PTZ);
    pButton->SetIcon(m_h8PTZDisableIcon);

    ga_pMainDlg->DisAbleDIG();//رַŴť

    ulPTZMode = MODE_180;
    ga_pMainDlg->m_poPlayManager[0]->SetPtzAndMode(ulFixMode, ulPTZMode);
}

/*3PTZģʽ*/
void CDlgIntellect::OnBnClickedFish3ptz()
{
    ULONG_32 ulFixMode = ga_pMainDlg->m_ulFixMode;
    ULONG_32 ulPTZMode = ga_pMainDlg->m_ulPTZMode;

    CButton *pButton = (CButton *)GetDlgItem(IDC_MODE_ORG);
    pButton->SetIcon(m_hORGDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_1PTZ);
    pButton->SetIcon(m_h1PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_2PTZ);
    pButton->SetIcon(m_h2PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_3PTZ);
    pButton->SetIcon(m_h3PTZEnableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_4PTZ);
    pButton->SetIcon(m_h4PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_6PTZ);
    pButton->SetIcon(m_h6PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_8PTZ);
    pButton->SetIcon(m_h8PTZDisableIcon);

    ga_pMainDlg->DisAbleDIG();//رַŴť

    ulPTZMode = MODE_FISH_3PTZ;
    ga_pMainDlg->m_poPlayManager[0]->SetPtzAndMode(ulFixMode, ulPTZMode);
}

/*4PTZģʽ*/
void CDlgIntellect::OnBnClickedFish4ptz()
{
    ULONG_32 ulFixMode = ga_pMainDlg->m_ulFixMode;
    ULONG_32 ulPTZMode = ga_pMainDlg->m_ulPTZMode;

    CButton *pButton = (CButton *)GetDlgItem(IDC_MODE_ORG);
    pButton->SetIcon(m_hORGDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_1PTZ);
    pButton->SetIcon(m_h1PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_2PTZ);
    pButton->SetIcon(m_h2PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_3PTZ);
    pButton->SetIcon(m_h3PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_4PTZ);
    pButton->SetIcon(m_h4PTZEnableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_6PTZ);
    pButton->SetIcon(m_h6PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_8PTZ);
    pButton->SetIcon(m_h8PTZDisableIcon);

    ga_pMainDlg->DisAbleDIG();//رַŴť

    ulPTZMode = MODE_FISH_LEFT_4PTZ;
    ga_pMainDlg->m_poPlayManager[0]->SetPtzAndMode(ulFixMode, ulPTZMode);
}

/*6PTZģʽ*/
void CDlgIntellect::OnBnClickedFish6ptz()
{
    ULONG_32 ulFixMode = ga_pMainDlg->m_ulFixMode;
    ULONG_32 ulPTZMode = ga_pMainDlg->m_ulPTZMode;

    CButton *pButton = (CButton *)GetDlgItem(IDC_MODE_ORG);
    pButton->SetIcon(m_hORGDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_1PTZ);
    pButton->SetIcon(m_h1PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_2PTZ);
    pButton->SetIcon(m_h2PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_3PTZ);
    pButton->SetIcon(m_h3PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_4PTZ);
    pButton->SetIcon(m_h4PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_6PTZ);
    pButton->SetIcon(m_h6PTZEnableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_8PTZ);
    pButton->SetIcon(m_h8PTZDisableIcon);

    ga_pMainDlg->DisAbleDIG();//رַŴť

    ulPTZMode = MODE_360_6PTZ;
    ga_pMainDlg->m_poPlayManager[0]->SetPtzAndMode(ulFixMode, ulPTZMode);
}

/*8PTZģʽ*/
void CDlgIntellect::OnBnClickedFish8ptz()
{
    ULONG_32 ulFixMode = ga_pMainDlg->m_ulFixMode;
    ULONG_32 ulPTZMode = ga_pMainDlg->m_ulPTZMode;

    CButton *pButton = (CButton *)GetDlgItem(IDC_MODE_ORG);
    pButton->SetIcon(m_hORGDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_1PTZ);
    pButton->SetIcon(m_h1PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_2PTZ);
    pButton->SetIcon(m_h2PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_3PTZ);
    pButton->SetIcon(m_h3PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_4PTZ);
    pButton->SetIcon(m_h4PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_6PTZ);
    pButton->SetIcon(m_h6PTZDisableIcon);

    pButton = (CButton *)GetDlgItem(IDC_FISH_8PTZ);
    pButton->SetIcon(m_h8PTZEnableIcon);

    ga_pMainDlg->DisAbleDIG();//رַŴť

    ulPTZMode = MODE_FISH_8PTZ;
    ga_pMainDlg->m_poPlayManager[0]->SetPtzAndMode(ulFixMode, ulPTZMode);
}

/*OSD*/
void CDlgIntellect::OnBnClickedButtonOpenOsd()
{
    ga_pMainDlg->m_poPlayManager[0]->IvaOSD();
}

/* Draw Video WaterMark */
void CDlgIntellect::OnBnClickedButtonOpenWatermark()
{
    ga_pMainDlg->m_poPlayManager[0]->VideoDrawWaterMark();
}

/* Ԫݻص */
void CDlgIntellect::OnBnClickedButtonIvadataCb()
{
    ga_pMainDlg->m_poPlayManager[0]->SetVideoIvaDataCB();
}
