// DlgLocalSetting.cpp : ʵļ
#include "stdafx.h"
#include "EZMediaDemo.h"
#include "DlgLocalSetting.h"
#include "EZMediaDemoDlg.h"

extern CEZMediaDemoDlg *ga_pMainDlg;

// CDlgLocalSetting Ի
IMPLEMENT_DYNAMIC(CDlgLocalSetting, CDialog)

CDlgLocalSetting::CDlgLocalSetting(CWnd* pParent /*=NULL*/)
    : CDialog(CDlgLocalSetting::IDD, pParent)
{
    m_strSnapPath = ga_pMainDlg->GetCurrentPath() + CString("Pic");
    m_strRecordPath = ga_pMainDlg->GetCurrentPath() + CString("Record");
}

CDlgLocalSetting::~CDlgLocalSetting()
{
}

void CDlgLocalSetting::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);

    DDX_Text(pDX, IDC_EDIT_SNAP_PATH, m_strSnapPath);
    DDX_Text(pDX, IDC_EDIT_RECORD_PATH, m_strRecordPath);

    DDX_Control(pDX, IDC_COMBO_RATIO_FORMAT, m_ComboDisRatio);
    DDX_Control(pDX, IDC_COMBO_EXCUTE_TYPE, m_ComboExcuteType);
    DDX_Control(pDX, IDC_COMBO_SNAP_FORMAT, m_ComboSnapFmt);
    DDX_Control(pDX, IDC_COMBO_RECORD_FORMAT, m_ComboRecordFmt);
}

BOOL CDlgLocalSetting::OnInitDialog()
{
    CDialog::OnInitDialog();

    m_ComboDisRatio.AddString(_T("Stretch"));//
    m_ComboDisRatio.AddString(_T("Scale"));  //
    m_ComboDisRatio.SetCurSel(ga_pMainDlg->m_lDisRatio);

    m_ComboExcuteType.AddString(_T("Fast Play"));//
    m_ComboExcuteType.AddString(_T("Standard")); //׼
    m_ComboExcuteType.SetCurSel(ga_pMainDlg->m_lExcuteType);

    m_ComboSnapFmt.AddString(_T("BMP"));
    m_ComboSnapFmt.AddString(_T("JPG"));
    m_ComboSnapFmt.AddString(_T("JPG&BMP"));
    m_ComboSnapFmt.SetCurSel(ga_pMainDlg->m_lSnapFmt);


    m_ComboRecordFmt.AddString(_T("MP4"));
    m_ComboRecordFmt.AddString(_T("TS"));
    m_ComboRecordFmt.AddString(_T("AVI"));
    m_ComboRecordFmt.SetCurSel(ga_pMainDlg->m_ulRecordFmt);

    ((CButton*)GetDlgItem(IDC_CHECK_GPU))->SetCheck(ga_pMainDlg->m_bEnableGPU);
    ((CButton*)GetDlgItem(IDC_CHECK_IVA))->SetCheck(ga_pMainDlg->m_bEnableVCA);

    return TRUE;  // ǽõؼ򷵻 TRUE
}

BEGIN_MESSAGE_MAP(CDlgLocalSetting, CDialog)
    ON_BN_CLICKED(IDC_BUTTON_SET_BROWSE1, &CDlgLocalSetting::OnBnClickedButtonSetBrowse1)
    ON_BN_CLICKED(IDC_BUTTON_SET_BROWSE2, &CDlgLocalSetting::OnBnClickedButtonSetBrowse2)
    ON_BN_CLICKED(IDC_BUTTON_SET_SAVE, &CDlgLocalSetting::OnBnClickedButtonSetSave)
    ON_BN_CLICKED(IDC_CHECK_GPU, &CDlgLocalSetting::OnBnClickedCheckGpu)
    ON_BN_CLICKED(IDC_BUTTON_ABOUT, &CDlgLocalSetting::OnBnClickedAbout)
END_MESSAGE_MAP()

// CDlgLocalSetting Ϣ
void CDlgLocalSetting::OnBnClickedButtonSetBrowse1()
{
    BROWSEINFO bi;
    wchar_t wcSnapPath[MAX_PATH] = {0};

    //ʼڲ bi
    bi.hwndOwner = NULL;
    bi.pidlRoot = NULL;
    bi.pszDisplayName = wcSnapPath;
    bi.lpszTitle = L"ļ·ѡ";
    bi.ulFlags = BIF_EDITBOX;
    bi.lpfn = NULL;
    bi.iImage = IDR_MAINFRAME;

    //ע ڴ ͷ Ҫֶͷ
    LPITEMIDLIST pIDList = SHBrowseForFolder(&bi); //ʾѡԻ 
    if (pIDList)
    {
        SHGetPathFromIDList(pIDList, wcSnapPath);
        m_strSnapPath = wcSnapPath;
         SetDlgItemText(IDC_EDIT_SNAP_PATH, m_strSnapPath);
    }

    CoTaskMemFree(pIDList); //ͷpIDListָڴռ;
    TRACE("%d", pIDList);
    UpdateData(FALSE);
}

void CDlgLocalSetting::OnBnClickedButtonSetBrowse2()
{
    BROWSEINFO bi;
    wchar_t wcRecordPath[MAX_PATH] = {0};

    //ʼڲ bi
    bi.hwndOwner = NULL;
    bi.pidlRoot = NULL;
    bi.pszDisplayName = wcRecordPath;
    bi.lpszTitle = L"ļ·ѡ";
    bi.ulFlags = BIF_EDITBOX;
    bi.lpfn = NULL;
    bi.iImage = IDR_MAINFRAME;

    //ע ڴ ͷ Ҫֶͷ
    LPITEMIDLIST pIDList = SHBrowseForFolder(&bi); //ʾѡԻ 
    if (pIDList)
    {
        SHGetPathFromIDList(pIDList, wcRecordPath);
        m_strRecordPath = wcRecordPath;
        SetDlgItemText(IDC_EDIT_SNAP_PATH, m_strRecordPath);
    }

    CoTaskMemFree(pIDList); //ͷpIDListָڴռ;
    TRACE("%d", pIDList);
    UpdateData(FALSE);
}

void CDlgLocalSetting::OnBnClickedButtonSetSave()
{
    UpdateData(TRUE);
    ga_pMainDlg->m_lSnapFmt = m_ComboSnapFmt.GetCurSel();
    ga_pMainDlg->m_lDisRatio = m_ComboDisRatio.GetCurSel();
    ga_pMainDlg->m_ulRecordFmt = m_ComboRecordFmt.GetCurSel();
    ga_pMainDlg->m_lExcuteType = m_ComboExcuteType.GetCurSel();
    ga_pMainDlg->m_strSnapPath = m_strSnapPath;
    ga_pMainDlg->m_strRecordPath = m_strRecordPath;
    ga_pMainDlg->m_bEnableGPU = ((CButton*)GetDlgItem(IDC_CHECK_GPU))->GetCheck();
    ga_pMainDlg->m_bEnableVCA = ((CButton*)GetDlgItem(IDC_CHECK_IVA))->GetCheck();

    //òű
    for (int i = 0; i < ga_pMainDlg->m_lWndCount; i++)
    {
        HWND    hWnd = ga_pMainDlg->m_oWnd[i]->m_hWnd;
        LONG_32 lDisRatio = ga_pMainDlg->m_lDisRatio;
        ga_pMainDlg->m_poPlayManager[i]->SetRenderScale(hWnd, lDisRatio);
    }

    UpdateData(FALSE);
    DestroyWindow();
    EndDialog(0);
}

void CDlgLocalSetting::OnBnClickedCheckGpu()
{
    //ѡGPUѡʱǷ֧GPU
    BOOL_T bRet = BOOL_TRUE;
    if(BOOL_FALSE == ga_pMainDlg->m_bEnableGPU)
    {
        bRet = ga_pMainDlg->CheckAbleGPU(TRUE);
        if (BOOL_FALSE == bRet)
        {
            ga_pMainDlg->m_bEnableGPU = FALSE;
            ((CButton*)GetDlgItem(IDC_CHECK_GPU))->SetCheck(0);
        }
        else
        {
            ga_pMainDlg->m_bEnableGPU = TRUE;
            ((CButton*)GetDlgItem(IDC_CHECK_GPU))->SetCheck(1);
        }
    }
    else
    {
        ((CButton*)GetDlgItem(IDC_CHECK_GPU))->SetCheck(0);
        ga_pMainDlg->m_bEnableGPU = FALSE;
        ga_pMainDlg->CheckAbleGPU(ga_pMainDlg->m_bEnableGPU);
    }
}

void CDlgLocalSetting::OnBnClickedAbout()
{
    m_oDlgAboutBox.DoModal();
}
