// EZMediaDemoDlg.cpp : ʵļ
#include "stdafx.h"
#include "Common.h"
#include "SysLog.h"
#include "EZMediaDemo.h"
#include "player_sdk_func.h"
#include "EZMediaDemoDlg.h"
#include <io.h>
#include <vector>
#include <Windows.h>
#include <WinUser.h>
#include <iostream>
using namespace std;

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#ifdef USE_PARAM
#include "Internal/Internal.h"
#endif

CEZMediaDemoDlg *ga_pMainDlg = NULL;
std::vector<CStatic*> m_oVideoList;

/*ͨ*/
#define PLAYER_MAX_CHANNEL               16

/*ǩҳ*/
#define MANU_TAB_INDEX_FILE              0
#define MANU_TAB_INDEX_MEDIA             1
#define MANU_TAB_INDEX_INPUT             2
#define MANU_TAB_INDEX_LOCAL             3
#define MANU_TAB_INDEX_INTELLECT         4


CEZMediaDemoDlg::CEZMediaDemoDlg(CWnd* pParent /*=NULL*/)
: CDialog(CEZMediaDemoDlg::IDD, pParent)
, m_strAddress(_T(""))
, m_nVoiceValue(0)
, m_strVideoType(_T(""))
, m_strAudioType(_T(""))
, m_strBitRate(_T(""))
, m_strFrameCount(_T(""))
, m_strPacketCount(_T(""))
, m_strFrameRate(_T(""))
, m_strLoseRate(_T(""))
, m_strSize(_T(""))
, m_strPlayTime(_T(""))
, m_strFilePlayTime(_T("--:--|--:--"))
, m_strLoginInfo(_T(""))
, m_strLocalIP(_T(""))
,m_strVolume(_T(""))
,m_strMicVol(_T(""))
,m_strSpeed(_T(""))
,m_strFilePath(_T(""))
{
    m_hRecordStart = AfxGetApp()->LoadIcon(IDI_RECORD_ENABLE);
    m_hRecordStop = AfxGetApp()->LoadIcon(IDI_RECORD_DISABLE);

    m_hCaptureIcon = AfxGetApp()->LoadIcon(IDI_SNAP);

    m_hStartIcon = AfxGetApp()->LoadIcon(IDI_PLAY_ENABLE);
    m_hStopIcon = AfxGetApp()->LoadIcon(IDI_STOP_ENABLE);

    m_hAFrameGo = AfxGetApp()->LoadIcon(IDI_AFRAMEGO);

    m_hSpeedFast = AfxGetApp()->LoadIcon(IDI_SPEED_FAST);
    m_hSpeedSlow = AfxGetApp()->LoadIcon(IDI_SPEED_SLOW);

    m_hSoundStartIcon = AfxGetApp()->LoadIcon(IDI_SOUND_ENABLE);
    m_hSoundStopIcon = AfxGetApp()->LoadIcon(IDI_SOUND_DISABLE);

    m_hMicStartIcon = AfxGetApp()->LoadIcon(IDI_MIC_ENABLE);
    m_hMicStopIcon = AfxGetApp()->LoadIcon(IDI_MIC_DISABLED);

    m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

    m_hDigEnableIcon = AfxGetApp()->LoadIcon(IDI_DIG_ENABLE);
    m_hDigDisableIcon = AfxGetApp()->LoadIcon(IDI_DIG_DISABLED);

    m_hGoIE = AfxGetApp()->LoadIcon(IDI_IE);

    m_lMaxChannel = PLAYER_MAX_CHANNEL;
    m_lWndCount = 1;
}

CEZMediaDemoDlg::~CEZMediaDemoDlg()
{
    for (int i = 0; i < PLAYER_MAX_CHANNEL; i++)
    {
        delete m_oWnd[i];
        m_oWnd[i] = NULL;
        delete m_poPlayManager[i];
        m_poPlayManager[i] = NULL;
    }
}

void CEZMediaDemoDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    DDX_Text(pDX, IDC_EDIT_IP, m_strIP);
    DDX_Text(pDX, IDC_EDIT_USERNAME, m_strName);
    DDX_Text(pDX, IDC_EDIT_PASSWORD, m_strPassWD);
    DDX_Control(pDX, IDC_STREAM, m_ctlStream);
    DDX_Control(pDX, IDC_STATIC_VIDEO_PLAY, m_ctlVideo);
    DDX_Control(pDX, IDC_PROTL, m_ctlProtL);
    DDX_Control(pDX, IDC_FLUENCY, m_ctlFluency);
    DDX_Control(pDX, IDC_WIND_NUM, m_ctlWindNum);

    DDX_Text(pDX, IDC_STATIC_VIDEO_TYPE, m_strVideoType);
    DDX_Text(pDX, IDC_STATIC_AUDIO_TYPE, m_strAudioType);
    DDX_Text(pDX, IDC_STATIC_BIT_RATE, m_strBitRate);
    DDX_Text(pDX, IDC_STATIC_SOUND, m_strVolume);
    DDX_Text(pDX, IDC_STATIC_MIC_SOUND, m_strMicVol);
    DDX_Text(pDX, IDC_STATIC_FRAME_RATE, m_strFrameRate);
    DDX_Text(pDX, IDC_STATIC_LOSE_RATE, m_strLoseRate);
    DDX_Text(pDX, IDC_STATIC_SIZE, m_strSize);
    DDX_Text(pDX, IDC_STATIC_SPEEDTEXT, m_strSpeed);
    DDX_Text(pDX, IDC_STATIC_VERSION, m_strVersion);
    DDX_Text(pDX, IDC_STATIC_FILEPLAY_TIME, m_strFilePlayTime);
    DDX_Text(pDX, IDC_STATIC_FRAMECOUNT, m_strFrameCount);
    DDX_Text(pDX, IDC_STATIC_PACKETCOUNT, m_strPacketCount);

    DDX_Slider(pDX, IDC_SLIDER_SOUND, m_nVoiceValue);
    DDX_Slider(pDX, IDC_SLIDER_VIC_SOUND, m_nMicValue);

    DDV_MinMaxInt(pDX, m_nVoiceValue, 0, 255);
    DDV_MinMaxInt(pDX, m_nMicValue, 0, 255);

    DDX_Control(pDX, IDC_SLIDER_SOUND, m_ctSlider);
    DDX_Control(pDX, IDC_SLIDER_VIC_SOUND, m_ctMicSlider);
    DDX_Control(pDX, IDC_SLIDER_PEOCESS, m_ctSliderProcess);
    DDX_Control(pDX, IDC_TAB_MAIN_MENU, m_oTabManu);
}

BEGIN_MESSAGE_MAP(CEZMediaDemoDlg, CDialog)
    ON_WM_SYSCOMMAND()
    ON_WM_PAINT()
    ON_WM_TIMER()
    ON_WM_MOUSEMOVE()
    ON_WM_MOUSELEAVE()
    ON_WM_MOUSEWHEEL()
    ON_WM_MOUSEHWHEEL()
    ON_WM_LBUTTONUP()
    ON_WM_LBUTTONDOWN()
    ON_WM_RBUTTONUP()
    ON_WM_LBUTTONDBLCLK()
    ON_WM_QUERYDRAGICON()
    ON_BN_CLICKED(IDC_START_PLAY, &CEZMediaDemoDlg::OnBnClickedStartPlay)
    ON_BN_CLICKED(IDC_STOP_PLAY, &CEZMediaDemoDlg::OnBnClickedStopPlay)
    ON_BN_CLICKED(IDC_BTN_RESET, &CEZMediaDemoDlg::OnBnClickedBtnReset)
    ON_BN_CLICKED(IDC_START_SOUND, &CEZMediaDemoDlg::OnBnClickedStartSound)
    ON_BN_CLICKED(IDC_START_VOICE, &CEZMediaDemoDlg::OnBnClickedStartVoice)
    ON_BN_CLICKED(IDC_START_RECORD, &CEZMediaDemoDlg::OnBnClickedStartRecord)
    ON_BN_CLICKED(IDC_BTN_PICPLAY, &CEZMediaDemoDlg::OnBnClickedBtnPicplay)
    ON_BN_CLICKED(IDC_WATER_MARK, &CEZMediaDemoDlg::OnBnClickedWaterMark)
    ON_BN_CLICKED(IDC_SPEED_FAST, &CEZMediaDemoDlg::OnBnClickedSpeedFast)
    ON_BN_CLICKED(IDC_SPEED_SLOW, &CEZMediaDemoDlg::OnBnClickedSpeedSlow)
    ON_BN_CLICKED(IDC_SNAP, &CEZMediaDemoDlg::OnBnClickedSnap)
    ON_BN_CLICKED(IDC_FRAMEGO, &CEZMediaDemoDlg::OnBnClickedFramego)
    ON_BN_CLICKED(IDC_BTN_DIG, &CEZMediaDemoDlg::OnBnClickedBtnDig)
    ON_BN_CLICKED(IDC_BTN_FILEOPEN, &CEZMediaDemoDlg::OnBnClickedBtnFileopen)
    ON_BN_CLICKED(IDC_BTN_SETTING, &CEZMediaDemoDlg::OnBnClickedBtnSetting)
    ON_BN_CLICKED(IDC_OPENLOG, &CEZMediaDemoDlg::OnBnClickedOpenLog)
    ON_BN_CLICKED(IDC_BUTTON_OPEN_PTZ, &CEZMediaDemoDlg::OnBnClickedButtonOpenPtz)
    ON_BN_CLICKED(IDC_PLAYGO, &CEZMediaDemoDlg::OnBnClickedPlaygo)
    ON_CBN_SELCHANGE(IDC_WIND_NUM, &CEZMediaDemoDlg::OnCbnSelchangeWindNum)
    ON_NOTIFY(TCN_SELCHANGE, IDC_TAB_MAIN_MENU, &CEZMediaDemoDlg::OnTcnSelchangeTabMain)
    ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_SOUND, &CEZMediaDemoDlg::OnNMCustomdrawSliderSound)/*NM_CUSTOMDRAWڻƻʱһζӦϢ*/
    ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_VIC_SOUND, &CEZMediaDemoDlg::OnNMCustomdrawSliderMicSound)
    ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_PEOCESS, &CEZMediaDemoDlg::OnNMReleasedcaptureSliderPeocess)
    ON_BN_CLICKED(IDC_BUTTON_GOIE, &CEZMediaDemoDlg::OnBnClickedButtonGoie)
END_MESSAGE_MAP()

// CEZMediaDemoDlg Ϣ
BOOL CEZMediaDemoDlg::OnInitDialog()
{
    CDialog::OnInitDialog();

    // IDM_ABOUTBOX ϵͳΧڡ
    ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
    ASSERT(IDM_ABOUTBOX < 0xF000);

    CMenu* pSysMenu = GetSystemMenu(FALSE);
    if (pSysMenu != NULL)
    {
        BOOL bNameValid;
        CString strAboutMenu;
        bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
        ASSERT(bNameValid);
        if (!strAboutMenu.IsEmpty())
        {
            pSysMenu->AppendMenu(MF_SEPARATOR);
            pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
        }
    }
    /*ʼȫֶԻָ*/
    InitGlobalSysInfo();

    /*־߳*/
    //CLogThread::GetInstance()->StartLogThread();
    LogThread::InitInstance();


    /*ťͼ*/
    CButton *pButton = (CButton *)GetDlgItem(IDC_SNAP);
    pButton->SetIcon(m_hCaptureIcon);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_START_PLAY);
    pButton->SetIcon(m_hStartIcon);
    pButton->EnableWindow(TRUE);

    pButton = (CButton *)GetDlgItem(IDC_STOP_PLAY);
    pButton->SetIcon(m_hStopIcon);

    pButton = (CButton *)GetDlgItem(IDC_START_SOUND);
    pButton->SetIcon(m_hSoundStopIcon);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_START_VOICE);
    pButton->SetIcon(m_hMicStartIcon);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_BUTTON_OPEN_PTZ);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_START_RECORD);
    pButton->SetIcon(m_hRecordStart);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_FRAMEGO);
    pButton->SetIcon(m_hAFrameGo);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_PLAYGO);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_SPEED_FAST);
    pButton->SetIcon(m_hSpeedFast);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_SPEED_SLOW);
    pButton->SetIcon(m_hSpeedSlow);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_BTN_DIG);
    pButton->SetIcon(m_hDigEnableIcon);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_BUTTON_GOIE);
    pButton->SetIcon(m_hGoIE);
    pButton->EnableWindow(TRUE);

    SetIcon(m_hIcon, TRUE);             // ôͼ
    SetIcon(m_hIcon, FALSE);            // Сͼ

    ULONG_32 ulVersion = NDPlayer_GetVersion();
    CHAR szMessage[40] = {0};
    sprintf(szMessage, "%d.%d.%04d", LOBYTE(LOWORD(ulVersion)), HIBYTE(LOWORD(ulVersion)), HIWORD(ulVersion));
    m_strVersion = szMessage;
    m_nVoiceValue = 100;
    m_nMicValue = 100;
    m_strVolume = "100";
    m_strMicVol = "100";
    m_strSpeed = "1x";

    /*˵ҳUIʼ*/
    InitMainMenuUI();

    m_MainFileDlg.Create(IDD_DIALOG_FILE, this);
    m_MainInputDlg.Create(IDD_DIALOG_INPUT, this);
    m_MainMediaDlg.Create(IDD_DIALOG_MEDIA, this);
    m_MainLocalDlg.Create(IDD_DIALOG_LOCAL, this);
    m_MainFishDlg.Create(IDD_DIALOG_INTELLECT, this);

    /*ȡҳǩλ*/
    GetDlgItem(IDC_TAB_MAIN_MENU)->GetWindowRect(&m_oPrimaryLabelRect);

    m_oPrimaryLabelRect.top -= 2;
    m_oPrimaryLabelRect.right -= 7;
    m_oPrimaryLabelRect.bottom -= 30;

    /*ǩλ*/
    m_MainFileDlg.MoveWindow(m_oPrimaryLabelRect);
    m_MainFishDlg.MoveWindow(m_oPrimaryLabelRect);
    m_MainInputDlg.MoveWindow(m_oPrimaryLabelRect);
    m_MainMediaDlg.MoveWindow(m_oPrimaryLabelRect);
    m_MainLocalDlg.MoveWindow(m_oPrimaryLabelRect);

    m_MainFileDlg.ShowWindow(SW_SHOW);
    m_MainFishDlg.ShowWindow(SW_HIDE);
    m_MainInputDlg.ShowWindow(SW_HIDE);
    m_MainMediaDlg.ShowWindow(SW_HIDE);
    m_MainLocalDlg.ShowWindow(SW_HIDE);

    m_ctSlider.EnableWindow(FALSE);
    m_ctSlider.SetRangeMax(255);

    m_ctMicSlider.EnableWindow(FALSE);
    m_ctMicSlider.SetRangeMax(255);

    m_ctSliderProcess.SetRange(0, 1000);

    /*Ŵλ*/
    m_ctlVideo.GetClientRect(&m_stRect);
    m_stRect.left  += 265;
    m_stRect.right += 265;
    m_stRect.top   += 6;
    m_stRect.bottom += 6;

    /*־λ*/
    m_bMicOn = FALSE;
    m_bSoundOn = FALSE;
    m_bRecordOn = FALSE;
    m_bDigital = FALSE;
    m_b5ePtzOn = FALSE;
    m_bFullSceen = FALSE;

    for (int i = 0; i < 16; i++)
    {
        m_oWnd[i] = new CEZPlayerWnd(i);
        m_oWnd[i]->Create(_T(""), WS_CHILD | WS_VISIBLE | SS_BLACKRECT | WS_CLIPSIBLINGS, CRect(0,0,0,0), this);
        m_oWnd[i]->ShowWindow(SW_SHOW);
    }

    /*ƶŴ*/
    m_oWnd[0]->MoveWindow(&m_stRect, TRUE);
    m_ctlVideo.ShowWindow(SW_HIDE);

    m_strIP = "206.9.8.12";
    m_strName = "admin";
    m_strPassWD = "Ndplayer123";
    m_strLocalPort = "5050";
    m_strStartTime.Format(_T("%d"),_time32(NULL) - 3600);
    m_strEndTime.Format(_T("%d"),_time32(NULL));
    m_strHLSTime = "1551648342";
    m_strFilePath = "";
    m_strSnapPath = m_oDlgLocalSetting.m_strSnapPath;
    m_strRecordPath = m_oDlgLocalSetting.m_strRecordPath;
    m_strRtpDataPath = m_MainLocalDlg.m_strRtpDataPath;
    m_strSpellDataPath = m_MainLocalDlg.m_strSpellDataPath;
    m_strYUVDataPath = m_MainLocalDlg.m_strYUVDataPath;
    m_lDisRatio = 0;                        //Ĭ
    m_lExcuteType = 1;                      //Ĭϱ׼RTSP
    m_lSnapFmt = PLAYER_PIC_FORMATE_JPEG;    //ĬJPEGʽͼ
    m_ulRecordFmt = 0;                       //ĬTSʽ¼
    m_bEnableGPU = BOOL_FALSE;
#ifdef _WIN64
    m_bEnableGPU = BOOL_TRUE;
#endif
    m_bEnableVCA = BOOL_TRUE;//ĬϿԪݻͼ
    m_bPlayNone = BOOL_TRUE;

    for (int i = 0; i < 16; i++)
    {
        m_poPlayManager[i] = new CPlayManager;
    }
    PLAYER_GPU_ABLE_STATE_S stGpuAbleState = {0};
    NDPlayer_AbleGpuDecodeEx(m_bEnableGPU, &stGpuAbleState);

    /*ͳʼΪ*/
    m_ctlStream.AddString(_T("Main Stream"));
    m_ctlStream.AddString(_T("Sub Stream"));
    m_ctlStream.AddString(_T("Thrid Stream"));
    m_ctlStream.SetCurSel(0);

    /*ЭʼΪTCP*/
    m_ctlProtL.AddString(_T("TCP"));
    m_ctlProtL.AddString(_T("UDP"));
    m_ctlProtL.SetCurSel(0);

    /**/
    m_ctlFluency.AddString(_T("Short Delay"));
    m_ctlFluency.AddString(_T("Fluent"));
    m_ctlFluency.AddString(_T("Balance"));
    m_ctlFluency.SetCurSel(1);

    /*ѡ*/
    m_ctlWindNum.AddString(_T("1"));
    m_ctlWindNum.AddString(_T("2"));
    m_ctlWindNum.AddString(_T("4"));
    m_ctlWindNum.AddString(_T("9"));
    m_ctlWindNum.AddString(_T("16"));
    m_ctlWindNum.SetCurSel(0);

    /*ť*/
    m_tooltip.Create(this);
    m_tooltip.AddTool(GetDlgItem(IDC_START_PLAY), _T("Play Stream"));
    m_tooltip.AddTool(GetDlgItem(IDC_STOP_PLAY), _T("Stop Stream"));
    m_tooltip.AddTool(GetDlgItem(IDC_SNAP), _T("Snap"));
    m_tooltip.AddTool(GetDlgItem(IDC_START_RECORD), _T("Record"));
    m_tooltip.AddTool(GetDlgItem(IDC_BTN_DIG), _T("Digital Zoom"));
    m_tooltip.AddTool(GetDlgItem(IDC_START_SOUND), _T("Audio Sound"));
    m_tooltip.AddTool(GetDlgItem(IDC_START_VOICE), _T("Voice"));
    m_tooltip.AddTool(GetDlgItem(IDC_BUTTON_OPEN_PTZ), _T("5ePTZ"));  
    m_tooltip.AddTool(GetDlgItem(IDC_BUTTON_OPEN_OSD), _T("IvaOsd"));
    m_tooltip.AddTool(GetDlgItem(IDC_SPEED_SLOW), _T("Slow Speed"));
    m_tooltip.AddTool(GetDlgItem(IDC_SPEED_FAST), _T("Fast Speed"));
    m_tooltip.AddTool(GetDlgItem(IDC_PLAYGO), _T("AFrame Resume"));
    m_tooltip.AddTool(GetDlgItem(IDC_FRAMEGO), _T("AFrame Go"));
    m_tooltip.AddTool(GetDlgItem(IDC_BTN_SETTING), _T("Function settings"));
    m_tooltip.AddTool(GetDlgItem(IDC_ABOUTBOX), _T("About..."));
    m_tooltip.AddTool(GetDlgItem(IDC_BTN_RESET), _T("Reset Packet Loss Rate"));

    m_tooltip.SetMaxTipWidth(123);
    m_tooltip.Activate(TRUE);
#ifdef USE_PARAM
    m_DlgIn.Create(IDD_DIALOG_IN, this);
    m_DlgIn.InitDialog();
#endif
    /*־ʼ*/
    LogThread::InitInstance();

    UpdateData(FALSE);

    return TRUE;  // ǽõؼ򷵻 TRUE
}

void CEZMediaDemoDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
    if ((nID & 0xFFF0) == IDM_ABOUTBOX)
    {
        CAboutDlg dlgAbout;
        dlgAbout.DoModal();
    }
    else
    {
        CDialog::OnSysCommand(nID, lParam);
    }
}

void CEZMediaDemoDlg::InitMainMenuUI()
{
    m_oTabManu.InsertItem(MANU_TAB_INDEX_FILE, L"FILE");

    m_oTabManu.InsertItem(MANU_TAB_INDEX_MEDIA, L"MEDIA");

    m_oTabManu.InsertItem(MANU_TAB_INDEX_INPUT, L"INPUT");

    m_oTabManu.InsertItem(MANU_TAB_INDEX_LOCAL, L"LOCAL");

    //INTELLECT OPERATION
    m_oTabManu.InsertItem(MANU_TAB_INDEX_INTELLECT, L" INO ");
}

void CEZMediaDemoDlg::InitPlayCtrlUI(void)
{
    m_MainFishDlg.DisableIcon();

    CButton *pButton = (CButton *)GetDlgItem(IDC_SNAP);
    pButton->EnableWindow(TRUE);

    pButton = (CButton *)GetDlgItem(IDC_START_RECORD);
    pButton->EnableWindow(TRUE);

    pButton = (CButton *)GetDlgItem(IDC_START_SOUND);
    pButton->EnableWindow(TRUE);

    pButton = (CButton *)GetDlgItem(IDC_START_VOICE);
    pButton->EnableWindow(TRUE);

    pButton = (CButton *)GetDlgItem(IDC_BUTTON_OPEN_PTZ);
    pButton->EnableWindow(TRUE);

    pButton = (CButton *)m_MainFishDlg.GetDlgItem(IDC_BUTTON_OPEN_OSD);
    pButton->EnableWindow(TRUE);

    if (m_lWndCount == 1)
    {
        pButton = (CButton *)GetDlgItem(IDC_BTN_DIG);
        pButton->SetIcon(m_hDigEnableIcon);
        pButton->EnableWindow(TRUE);
    }

    m_strBitRate = "--";
    m_strVideoType = "--";
    m_strAudioType = "--";
    m_strFrameRate = "--";
    m_strLoseRate = "--";
    m_strSize = "--";
    m_strFrameCount = "--";
    m_strPacketCount = "--";
    m_strFilePlayTime = "--:--|--:--";
    m_ulTotalTime = 0;
    m_ctSliderProcess.SetPos(0);
    (CButton *)GetDlgItem(IDC_BTN_RESET)->ShowWindow(TRUE);

    return;
}

void CEZMediaDemoDlg::UnInitPlayCtrlUI(void)
{
    CButton* pButton = (CButton *)GetDlgItem(IDC_BTN_DIG);
    pButton->SetIcon(m_hDigEnableIcon);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_FRAMEGO);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_PLAYGO);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_SPEED_FAST);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_SPEED_SLOW);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_SNAP);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_START_RECORD);
    pButton->SetIcon(m_hRecordStart);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_START_SOUND);
    pButton->SetIcon(m_hSoundStopIcon);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)GetDlgItem(IDC_START_VOICE);
    pButton->SetIcon(m_hMicStartIcon);
    pButton->EnableWindow(FALSE);

    pButton = (CButton*)GetDlgItem(IDC_BUTTON_OPEN_PTZ);
    pButton->EnableWindow(FALSE);

    pButton = (CButton *)m_MainFishDlg.GetDlgItem(IDC_BUTTON_OPEN_OSD);
    pButton->EnableWindow(FALSE);

    m_MainFishDlg.DisableIcon();
    m_ctSlider.EnableWindow(FALSE);
    m_ctMicSlider.EnableWindow(FALSE);

    UpdateData(TRUE);
    m_strBitRate = "--";
    m_strVideoType = "--";
    m_strAudioType = "--";
    m_strFrameRate = "--";
    m_strLoseRate = "--";
    m_strSize = "--";
    m_strFilePlayTime = "--:--|--:--";
    m_strFrameCount = "--";
    m_strPacketCount = "--";
    m_ctSliderProcess.SetPos(0);
    (CButton *)GetDlgItem(IDC_BTN_RESET)->ShowWindow(FALSE);

    return;
}

void CEZMediaDemoDlg::EnAbleDIG(void)
{
    CButton* pButton = (CButton *)GetDlgItem(IDC_BTN_DIG);
    pButton->SetIcon(m_hDigEnableIcon);
    pButton->EnableWindow(TRUE);

    return;
}

void CEZMediaDemoDlg::DisAbleDIG(void)
{
    CButton* pButton = (CButton *)GetDlgItem(IDC_BTN_DIG);
    pButton->SetIcon(m_hDigEnableIcon);
    pButton->EnableWindow(FALSE);

    return;
}

BOOL_T CEZMediaDemoDlg::CheckAbleGPU(IN BOOL_T bAbleGPU)
{
    PLAYER_GPU_ABLE_STATE_S stGpuAbleState = {0};
    NDPlayer_AbleGpuDecodeEx(bAbleGPU, &stGpuAbleState);
    
    if (TRUE == stGpuAbleState.bGpuAbleH264 && FALSE == stGpuAbleState.bGpuAbleH265)
    {
        ::MessageBox(NULL, _T("Gpu Is Only Support H264!"), _T("GPU info"), MB_OK);
    }
    else if (FALSE == stGpuAbleState.bGpuAbleH264 && TRUE == stGpuAbleState.bGpuAbleH265)
    {
        ::MessageBox(NULL, _T("Gpu Is Only Support H265!"), _T("GPU info"), MB_OK);
    }
    else if (TRUE == stGpuAbleState.bGpuAbleH264 && TRUE == stGpuAbleState.bGpuAbleH265)
    {
        ::MessageBox(NULL, _T("Gpu Is Support H265 And H264!"), _T("GPU info"), MB_OK);
    }
    else
    {
        ::MessageBox(NULL, _T("Gpu Is Not Support!"), _T("GPU info"), MB_OK);
        return FALSE;
    }

    return TRUE;
}

CString CEZMediaDemoDlg::GetCurrentPath()
{
    char szExePathName[255] = {0};
    char szExePath[255] = {0};
    char szExeName[255] = {0};
    char szExeDrive[16] = {0};
    char szExeExt[16] = {0};

    GetModuleFileNameA(NULL, szExePathName, sizeof(szExePathName));
    _splitpath(szExePathName,szExeDrive,szExePath,szExeName,szExeExt);

    char szIniPathName[255] = {0};
    char szTmpFolderName[255] = {0};
    char szCurrentExePath[260] = {0};

    strncpy(szIniPathName,szExeDrive, sizeof(szIniPathName) - 1);
    strcat(szIniPathName,szExePath);

    strncpy(szTmpFolderName, szIniPathName, sizeof(szTmpFolderName) - 1);
    strncpy(szCurrentExePath, szIniPathName, sizeof(szCurrentExePath) - 1);

    CString strCurrentPath;
    strCurrentPath = szCurrentExePath;

    return strCurrentPath;
}

void CEZMediaDemoDlg::OnPaint()
{
    if (IsIconic())
    {
        CPaintDC dc(this); // ڻƵ豸

        SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

        // ʹͼڹо
        int cxIcon = GetSystemMetrics(SM_CXICON);
        int cyIcon = GetSystemMetrics(SM_CYICON);
        CRect rect;
        GetClientRect(&rect);
        int x = (rect.Width() - cxIcon + 1) / 2;
        int y = (rect.Height() - cyIcon + 1) / 2;

        // ͼ
        dc.DrawIcon(x, y, m_hIcon);
    }
    else
    {
        CDialog::OnPaint();
    }
}

//û϶Сʱϵͳô˺ȡù
//ʾ
HCURSOR CEZMediaDemoDlg::OnQueryDragIcon()
{
    return static_cast<HCURSOR>(m_hIcon);
}

/*ʼ*/
void CEZMediaDemoDlg::InitGlobalSysInfo()
{
    ga_pMainDlg = this;
    return;
}

/* ʱˢ¼صϢ */
void CEZMediaDemoDlg::OnTimer(UINT_PTR nIDEvent)
{
    CHAR szMessage[255] = {0};

    if (TIMER_REFRESH == nIDEvent)//ʱϢ
    {
        UpdateData(TRUE);
        LONG_32 lBitRate = 0;
        m_poPlayManager[0]->GetBitRate(&lBitRate);
        if (0 <= lBitRate && 1024 > lBitRate)
        {
            sprintf(szMessage, "%d bps", lBitRate);
        }
        else if (1024 <= lBitRate && 1048576 > lBitRate)
        {
            sprintf(szMessage, "%.02f Kbps", (FLOAT)lBitRate / 1024);
        }
        else if (1048576 <= lBitRate)
        {
            sprintf(szMessage, "%.02f Mbps", (FLOAT)lBitRate / 1048576);
        }
        else
        {
            sprintf(szMessage, "--");
        }
        m_strBitRate = szMessage;

        ULONG_32 ulVideoType = PLAYER_VIDEO_ENCODE_NULL, ulAudioType = PLAYER_AUDIO_ENCODE_NULL;
        m_poPlayManager[0]->GetEncodeType(&ulVideoType, &ulAudioType);
        switch(ulVideoType)
        {
        case PLAYER_VIDEO_ENCODE_H264:
            {
                m_strVideoType = "H264";
                break;
            }
        case PLAYER_VIDEO_ENCODE_MJPEG:
            {
                m_strVideoType = "MJPEG";
                break;
            }
        case PLAYER_VIDEO_ENCODE_H265:
            {
                m_strVideoType = "H265";
                break;
            }
        case PLAYER_VIDEO_ENCODE_NULL:
        default:
            {
                m_strVideoType = "--";
                break;
            }
        }

        switch(ulAudioType)
        {
        case PLAYER_AUDIO_ENCODE_G711U:
            {
                m_strAudioType = "G711U";
                break;
            }
        case PLAYER_AUDIO_ENCODE_MP2:
            {
                m_strAudioType = "MP2";
                break;
            }
        case PLAYER_AUDIO_ENCODE_AAC:
            {
                m_strAudioType = "AAC";
                break;
            }
        case PLAYER_AUDIO_ENCODE_G711A:
            {
                m_strAudioType = "G711A";
                break;
            }
        case PLAYER_AUDIO_ENCODE_PCM:
            {
                m_strAudioType = "PCM";
                break;
            }
        case PLAYER_AUDIO_ENCODE_NULL:
        default:
            {
                m_strAudioType = "--";
                break;
            }
        }

        LONG_32 lFrameRate = 0;
        m_poPlayManager[0]->GetFrameRate(&lFrameRate);
        sprintf(szMessage, "%d fps", lFrameRate);
        m_strFrameRate = szMessage;

        FLOAT fLostRate = 0.0f;
        m_poPlayManager[0]->GetLostPacketRate(&fLostRate);
        sprintf(szMessage, "%.02f%%", fLostRate);
        m_strLoseRate = szMessage;

        LONG_32 lWidth = 0, lHeight = 0;
        m_poPlayManager[0]->GetPictureSize(&lWidth, &lHeight);
        sprintf(szMessage, "%d * %d", lWidth, lHeight);
        m_strSize = szMessage;

        ULONG_32 ulFrameCount = 0, ulPacketCount = 0;
        m_poPlayManager[0]->GetPacketQueueStart(&ulFrameCount, &ulPacketCount);
        sprintf(szMessage, "%d", ulFrameCount);
        m_strFrameCount = szMessage;
        sprintf(szMessage, "%d", ulPacketCount);
        m_strPacketCount = szMessage;

        UpdateData(FALSE);
    }
    else if (TIMER_PROCESSRESH == nIDEvent)//ļʱ
    {
        ULONG_32 ulPlaytime = 0;
        ULONG ulProcess = 0;
        UpdateData(TRUE);

        if (0 == m_ulTotalTime)
        {
            m_poPlayManager[0]->GetFileTime(&m_ulTotalTime);
            if (0 == m_ulTotalTime)
            {
                return;
            }
        }

        m_poPlayManager[0]->GetPlayTime(&ulPlaytime);

        sprintf(szMessage, "%02d:%02d|%02d:%02d", ulPlaytime / 60, ulPlaytime % 60, m_ulTotalTime / 60, m_ulTotalTime % 60);
        m_strFilePlayTime = szMessage;

        ulProcess = ulPlaytime * 1000 / m_ulTotalTime;
        m_ctSliderProcess.SetPos(ulProcess);

        UpdateData(FALSE);
    }
    else if(TIMER_ISFISHEYE == nIDEvent)//
    {
        if(BOOL_TRUE == m_poPlayManager[0]->IsFishEyeStream())
        {
            m_MainFishDlg.EnableIcon();
            m_ulFixMode = TOP_INSTALLATION;
            m_ulPTZMode = MODE_ORIGINAL;
            KillTimer(TIMER_ISFISHEYE);
        }

        static int siCount = 0;
        if(5 < siCount++)/*5sϱرնʱ*/
        {
            KillTimer(TIMER_ISFISHEYE);
            siCount = 0;
        }
    }

    return ;
}

void CEZMediaDemoDlg::OnBnClickedWinnumOne()
{
    RECT stRect = {0};
    for (int i = 1; i < 16; i++)
    {
        m_oWnd[i]->MoveWindow(&stRect, TRUE);
    }
    m_oWnd[0]->MoveWindow(&m_stRect, TRUE);

    InvalidateRect(NULL, TRUE);
    CButton *pButton = (CButton *)GetDlgItem(IDC_BTN_DIG);
    if(FALSE == m_bPlayNone)
    {
        pButton->EnableWindow(TRUE);
    }
    else
    {
        pButton->EnableWindow(FALSE);
    }
    
    m_lWndCount = 1;
}

void CEZMediaDemoDlg::OnBnClickedWinnumTwo()
{
    RECT stRect = {0};
    for (int i = 1; i < 16; i++)
    {
        m_oWnd[i]->MoveWindow(&stRect, TRUE);
    }

    stRect = m_stRect;
    stRect.right = (stRect.right + stRect.left) / 2 - 1;
    m_oWnd[0]->MoveWindow(&stRect, TRUE);

    stRect = m_stRect;
    stRect.left = (stRect.right + stRect.left) / 2 + 1;
    m_oWnd[1]->MoveWindow(&stRect, TRUE);

    InvalidateRect(NULL, TRUE);
    CButton *pButton = (CButton *)GetDlgItem(IDC_BTN_DIG);
    pButton->EnableWindow(FALSE);
    m_lWndCount = 2;
}

void CEZMediaDemoDlg::OnBnClickedWinnumFour()
{
    RECT stRect = {0};
    for (int i = 1; i < 16; i++)
    {
        m_oWnd[i]->MoveWindow(&stRect, TRUE);
    }

    stRect = m_stRect;
    stRect.right = (stRect.right + stRect.left) / 2 - 1;
    stRect.bottom = (stRect.top + stRect.bottom) / 2 - 1;
    m_oWnd[0]->MoveWindow(&stRect, TRUE);

    stRect = m_stRect;
    stRect.left = (stRect.right + stRect.left) / 2 + 1;
    stRect.bottom = (stRect.top + stRect.bottom) / 2 - 1;
    m_oWnd[1]->MoveWindow(&stRect, TRUE);

    stRect = m_stRect;
    stRect.right = (stRect.right + stRect.left) / 2 - 1;
    stRect.top = (stRect.top + stRect.bottom) / 2 + 1;
    m_oWnd[2]->MoveWindow(&stRect, TRUE);

    stRect = m_stRect;
    stRect.left = (stRect.right + stRect.left) / 2 + 1;
    stRect.top = (stRect.top + stRect.bottom) / 2 + 1;
    m_oWnd[3]->MoveWindow(&stRect, TRUE);

    InvalidateRect(NULL, TRUE);
    CButton *pButton = (CButton *)GetDlgItem(IDC_BTN_DIG);
    pButton->EnableWindow(FALSE);
    m_lWndCount = 4;
}

void CEZMediaDemoDlg::OnBnClickedWinnumNine()
{
    RECT stRect = {0};
    for (int i = 0; i < 16; i++)
    {
        m_oWnd[i]->MoveWindow(&stRect, TRUE);
    }

    int id = 0;
    int width = (m_stRect.right - m_stRect.left) / 3;
    int hight = (m_stRect.bottom - m_stRect.top) / 3;
    for (int i = 0; i < 3; i++)
    {
        for (int j = 0; j < 3; j++)
        {
            stRect.left = i * width + m_stRect.left;
            stRect.right = (i + 1) * width - 1 + m_stRect.left;
            stRect.top = j * hight + m_stRect.top;
            stRect.bottom = (j + 1) * hight - 1 + m_stRect.top;
            id = i * 4 + j;
            m_oWnd[id]->MoveWindow(&stRect, TRUE);
        }
    }

    CButton *pButton = (CButton *)GetDlgItem(IDC_BTN_DIG);
    pButton->EnableWindow(FALSE);
    m_lWndCount = 9;
}

void CEZMediaDemoDlg::OnBnClickedWinnumSixteen()
{
    RECT stRect = {0};
    for (int i = 0; i < 9; i++)
    {
        m_oWnd[i]->MoveWindow(&stRect, TRUE);
    }

    int id = 0;
    int width = (m_stRect.right - m_stRect.left) / 4;
    int hight = (m_stRect.bottom - m_stRect.top) / 4;
    for (int i = 0; i < 4; i++)
    {
        for (int j = 0; j < 4; j++)
        {
            stRect.left = i * width + m_stRect.left;
            stRect.right = (i + 1) * width - 1 + m_stRect.left;
            stRect.top = j * hight + m_stRect.top;
            stRect.bottom = (j + 1) * hight - 1 + m_stRect.top;
            id = i * 4 + j;
            m_oWnd[id]->MoveWindow(&stRect, TRUE);
        }
    }

    CButton *pButton = (CButton *)GetDlgItem(IDC_BTN_DIG);
    pButton->EnableWindow(FALSE);
    m_lWndCount = 16;
}

/*ѡ*/
void CEZMediaDemoDlg::OnCbnSelchangeWindNum()
{
    switch(m_ctlWindNum.GetCurSel())
    {
    case 0:
        OnBnClickedWinnumOne();
        break;
    case 1:
        OnBnClickedWinnumTwo();
        break;
    case 2:
        OnBnClickedWinnumFour();
        break;
    case 3:
        OnBnClickedWinnumNine();
        break;
    case 4:
        OnBnClickedWinnumSixteen();
        break;
    default:
        OnBnClickedWinnumOne();
        break;
    }

    return;
}

void CEZMediaDemoDlg::OnBnClickedStartPlay()
{
    UpdateData(TRUE);
    m_bPlayNone = FALSE;

    KillTimer(TIMER_PROCESSRESH);
    SetTimer(TIMER_REFRESH, 1000, NULL);
    SetTimer(TIMER_ISFISHEYE, 1000, NULL);
    //AbleGpuDecodeEx(m_bEnableGPU);

    LONG_32 lStream = STREAM_TYPE_MAIN_STREAM;
    switch(m_ctlStream.GetCurSel())
    {
    case 0:
        lStream = STREAM_TYPE_MAIN_STREAM;
        break;
    case 1:
        lStream = STREAM_TYPE_SUB_STREAM;
        break;
    case 2:
        lStream = STREAM_TYPE_THIRD_STREAM;
        break;
    default:
        lStream = STREAM_TYPE_MAIN_STREAM;
        break;
    }

    for (int i = 0; i< m_lWndCount; i++)
    {
        m_poPlayManager[i]->StopPlay();
        m_poPlayManager[i]->StartPlay(m_strIP, 
                                      m_strName, 
                                      m_strPassWD, 
                                      m_oWnd[i]->m_hWnd, 
                                      m_ctlProtL.GetCurSel(), 
                                      lStream,
                                      m_ctlFluency.GetCurSel(),
                                      m_bEnableVCA);
        m_poPlayManager[i]->SetRenderScale(m_oWnd[i]->m_hWnd, m_lDisRatio);
    }

    InitPlayCtrlUI();//ſťʼ

    UpdateData(FALSE);

    return;
}

void CEZMediaDemoDlg::OnBnClickedStopPlay()
{
    KillTimer(TIMER_REFRESH);
    KillTimer(TIMER_PROCESSRESH);

    m_bMicOn = FALSE;
    m_b5ePtzOn = FALSE;
    m_bSoundOn = FALSE;
    m_bRecordOn = FALSE;
    m_bPlayNone = TRUE;
    m_ulTotalTime = 0;

    for (int i = 0; i< 16; i++)
    {
        m_poPlayManager[i]->StopPlay();
    }

    UnInitPlayCtrlUI();//ſťʼ

    UpdateData(FALSE);
    return;
}

void CEZMediaDemoDlg::OnBnClickedBtnReset()
{
    m_poPlayManager[0]->ResetLostPacketRate();
}

void CEZMediaDemoDlg::OnBnClickedStartSound()
{
    CButton *pButton = (CButton *)GetDlgItem(IDC_START_SOUND);
    if (FALSE == m_bSoundOn)
    {
        m_ctSlider.EnableWindow(TRUE);
        m_poPlayManager[0]->OpenSound();
        UpdateData(TRUE);
        m_poPlayManager[0]->SetSoundVulue(m_nVoiceValue);
        pButton->SetIcon(m_hSoundStartIcon);
        m_bSoundOn = TRUE;
    } 
    else
    {
        m_ctSlider.EnableWindow(FALSE);
        m_poPlayManager[0]->CloseSound();
        pButton->SetIcon(m_hSoundStopIcon);
        m_bSoundOn = FALSE;
    }

    return;
}

void CEZMediaDemoDlg::OnNMCustomdrawSliderSound(NMHDR *pNMHDR, LRESULT *pResult)
{
    (VOID)pNMHDR;
    UpdateData(TRUE);
    int nVol = m_nVoiceValue;
    CHAR szMessage[5] = {0};
    sprintf(szMessage, "%d", m_nVoiceValue);
    m_strVolume = szMessage;
    m_poPlayManager[0]->SetSoundVulue(nVol);
    UpdateData(FALSE);
    *pResult = 0;
}

void CEZMediaDemoDlg::OnNMCustomdrawSliderMicSound(NMHDR *pNMHDR, LRESULT *pResult)
{
    (VOID)pNMHDR;
    UpdateData(TRUE);
    int nVol = m_nMicValue;
    CHAR szMessage[5] = {0};
    sprintf(szMessage, "%d", m_nMicValue);
    m_strMicVol = szMessage;
    m_poPlayManager[0]->SetMicValue(nVol);
    UpdateData(FALSE);

    *pResult = 0;
}

void CEZMediaDemoDlg::OnBnClickedStartVoice()
{
    CButton *pButton = (CButton *)GetDlgItem(IDC_START_VOICE);
    if (FALSE == m_bMicOn)
    {
        if(ERR_PLAYER_SUCCEED != m_poPlayManager[0]->StartVoice(m_strIP, m_strName, m_strPassWD, m_ctlProtL.GetCurSel()))
        {
            return;
        }
        UpdateData(TRUE);
        m_poPlayManager[0]->SetMicValue(m_nMicValue);
        pButton->SetIcon(m_hMicStopIcon);
        m_ctMicSlider.EnableWindow(TRUE);
        m_bMicOn = TRUE;
    } 
    else
    {
        m_poPlayManager[0]->StopVoice();
        pButton->SetIcon(m_hMicStartIcon);
        m_ctMicSlider.EnableWindow(FALSE);
        m_bMicOn = FALSE;
    }

    return;
}

void CEZMediaDemoDlg::OnBnClickedButtonOpenPtz()
{
    if (FALSE == m_b5ePtzOn)
    {
        if(TRUE == m_poPlayManager[0]->Open5ePtz())
        {
            m_b5ePtzOn = TRUE;
        }
    }
    else
    {
        if(TRUE == m_poPlayManager[0]->Close5ePtz())
        {
            m_b5ePtzOn = FALSE;
        }
    }

    return;
}

void CEZMediaDemoDlg::OnBnClickedStartRecord()
{
    CButton *pButton = (CButton *)GetDlgItem(IDC_START_RECORD);
    ULONG_32 ulMediaFormat = 0;
    switch(m_ulRecordFmt)
    {
    case 0 :
        ulMediaFormat = PLAYER_FILE_FORMATE_MP4_ADD_TIME;
        break;
    case 1 :
        ulMediaFormat = PLAYER_FILE_FORMATE_TS_ADD_TIME;
        break;
    case 2 :
        ulMediaFormat = PLAYER_FILE_FORMATE_AVI_ADD_TIME;
        break;
    default:
        ulMediaFormat = PLAYER_FILE_FORMATE_MP4_ADD_TIME;
        break;
    }

    if (FALSE == m_bRecordOn)
    {
        m_poPlayManager[0]->RecordStart(m_strRecordPath, ulMediaFormat);
        pButton->SetIcon(m_hRecordStop);
        m_bRecordOn = TRUE;
        
    } 
    else
    {
        m_poPlayManager[0]->RecordStop();
        pButton->SetIcon(m_hRecordStart);
        m_bRecordOn = FALSE;
    }

    return;
}

void CEZMediaDemoDlg::OnBnClickedBtnFileplay()
{
    HWND hWnd = m_oWnd[0]->m_hWnd;
    m_bPlayNone = FALSE;

    SetTimer(TIMER_REFRESH, 1000, NULL);
    SetTimer(TIMER_ISFISHEYE, 1000, NULL);
    SetTimer(TIMER_PROCESSRESH, 1000, NULL);

    m_poPlayManager[0]->StopPlay();
    m_poPlayManager[0]->StartFile(m_strFilePath, hWnd, m_bEnableVCA);
    m_poPlayManager[0]->SetRenderScale(m_oWnd[0]->m_hWnd, m_lDisRatio);

    /*ť״̬ʼ*/
    InitPlayCtrlUI();
    CButton *pButton = (CButton *)GetDlgItem(IDC_FRAMEGO);
    pButton->EnableWindow(TRUE);
    pButton = (CButton *)GetDlgItem(IDC_PLAYGO);
    pButton->EnableWindow(TRUE);
    pButton = (CButton *)GetDlgItem(IDC_SPEED_FAST);
    pButton->EnableWindow(TRUE);
    pButton = (CButton *)GetDlgItem(IDC_SPEED_SLOW);
    pButton->EnableWindow(TRUE);

    return;
}

void CEZMediaDemoDlg::OnBnClickedBtnPicplay()
{
    HWND hWnd = m_oWnd[0]->m_hWnd;
    UpdateData(TRUE);

    m_poPlayManager[0]->StopPlay();
    m_poPlayManager[0]->StartPic(m_strFilePath, hWnd);
    m_poPlayManager[0]->SetRenderScale(m_oWnd[0]->m_hWnd, m_lDisRatio);

    UnInitPlayCtrlUI();

    UpdateData(FALSE);

    return;
}

void CEZMediaDemoDlg::OnBnClickedSnap()
{
    UpdateData(FALSE);
    m_poPlayManager[0]->Snaponce(m_strSnapPath, m_lSnapFmt);
}

void CEZMediaDemoDlg::OnBnClickedWaterMark()
{
    UpdateData(TRUE);
    m_poPlayManager[0]->StopPlay();
    m_poPlayManager[0]->CheckMark(m_strFilePath);
    UpdateData(FALSE);
}

void CEZMediaDemoDlg::OnNMReleasedcaptureSliderPeocess(NMHDR *pNMHDR, LRESULT *pResult)
{
    int nProcess = m_ctSliderProcess.GetPos();

    if (0 != m_ulTotalTime)
    {
        int nPlayTime = m_ulTotalTime * nProcess / 1000;

        m_poPlayManager[0]->SetPlayTime(nPlayTime);
    }

    return;
}

void CEZMediaDemoDlg::OnBnClickedSpeedFast()
{
    UpdateData(TRUE);
    m_poPlayManager[0]->SpeedFast();

    switch(m_poPlayManager[0]->m_ulSpeed)
    {
    case PLAYER_SPEED_QUARTER_FORWARD:
        m_strSpeed = "1/4x";
        break;
    case PLAYER_SPEED_HALF_FORWARD:
        m_strSpeed = "1/2x";
        break;
    case PLAYER_SPEED_1_FORWARD:
        m_strSpeed = "1x";
        break;
    case PLAYER_SPEED_2_FORWARD:
        m_strSpeed = "2x";
        break;
    case PLAYER_SPEED_4_FORWARD:
        m_strSpeed = "4x";
        break;
    case PLAYER_SPEED_8_FORWARD:
        m_strSpeed = "8x";
        break;
    case PLAYER_SPEED_16_FORWARD:
        m_strSpeed = "16x";
        break;
    default:
        break;
    }
    UpdateData(FALSE);
}

void CEZMediaDemoDlg::OnBnClickedSpeedSlow()
{
    UpdateData(TRUE);
    m_poPlayManager[0]->SpeedSlow();

    switch(m_poPlayManager[0]->m_ulSpeed)
    {
    case PLAYER_SPEED_QUARTER_FORWARD:
        m_strSpeed = "1/4x";
        break;
    case PLAYER_SPEED_HALF_FORWARD:
        m_strSpeed = "1/2x";
        break;
    case PLAYER_SPEED_1_FORWARD:
        m_strSpeed = "1x";
        break;
    case PLAYER_SPEED_2_FORWARD:
        m_strSpeed = "2x";
        break;
    case PLAYER_SPEED_4_FORWARD:
        m_strSpeed = "4x";
        break;
    case PLAYER_SPEED_8_FORWARD:
        m_strSpeed = "8x";
        break;
    case PLAYER_SPEED_16_FORWARD:
        m_strSpeed = "16x";
        break;
    default:
        break;
    }
    UpdateData(FALSE);
}

void CEZMediaDemoDlg::OnBnClickedFramego()
{
    m_poPlayManager[0]->AFrameGo();
}

void CEZMediaDemoDlg::OnBnClickedPlaygo()
{
    m_poPlayManager[0]->PausePlay();
}

void CEZMediaDemoDlg::OnBnClickedBtnDig()
{
    if (FALSE == m_bDigital)
    {
        m_bDigital = TRUE;
        CButton *pButton = (CButton *)GetDlgItem(IDC_BTN_DIG);
        pButton->SetIcon(m_hDigDisableIcon);
    }
    else
    {
        PLAYER_RECT_S stRect = {0};
        stRect.lLeft = 0;
        stRect.lTop = 0;
        stRect.lBottom = 10000;
        stRect.lRight = 10000;

        m_poPlayManager[0]->SetDigital(m_oWnd[0]->m_hWnd, NULL);
        m_bDigital = FALSE;
        CButton *pButton = (CButton *)GetDlgItem(IDC_BTN_DIG);
        pButton->SetIcon(m_hDigEnableIcon);
    }

    return;
}

void CEZMediaDemoDlg::OnMouseLeave()
{
    CPoint oPoint;
    if(!m_bFullSceen)
    {
        oPoint.x = 215;
        oPoint.y = 6;
    }
    else
    {
        oPoint.x = 0;
        oPoint.y = 0;
    }
    this->OnLButtonUp(0, oPoint);
 
    CDialog::OnMouseLeave();
}

void CEZMediaDemoDlg::OnMouseMove(UINT nFlags, CPoint point)
{
    CPoint oPoint = point;
    if(!m_bFullSceen)
    {
        if (m_lWndCount != 1 || point.x < 265 || point.x > 1035 || point.y < 6 || point.y > 548)
        {
            return;
        }
        oPoint.x = (point.x - 265) * 10000 / (770);
        oPoint.y = (point.y - 6) * 10000 / (542);
    }
    else
    {
        oPoint.x = (point.x) * 10000 / (m_iDeskTopWidth);
        oPoint.y = (point.y) * 10000 / (m_iDeskTopHeight);
    }

    m_poPlayManager[0]->OnMouseMove(nFlags, oPoint);
    CDialog::OnMouseMove(nFlags, point);
}

LONG CEZMediaDemoDlg::GetWndIdFromPoint( CPoint &point )
{
    RECT stRect = {0};

    m_oWnd[0]->GetWindowRect(&stRect);

    point.x = (point.x) * 10000 / (stRect.right - stRect.left);
    point.y = (point.y) * 10000 / (stRect.bottom - stRect.top);

    return 0;
}

BOOL CEZMediaDemoDlg::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt)
{
    CPoint oPoint = pt;
    GetWndIdFromPoint(oPoint);
    m_poPlayManager[0]->OnMouseHWheel(nFlags, zDelta, oPoint);
    return CDialog::OnMouseWheel(nFlags, zDelta, oPoint);
}

void CEZMediaDemoDlg::OnLButtonDown(UINT nFlags, CPoint point)
{
    CPoint oPoint = point;

    //˫ʱĵ¼
    m_ulLBtnDownClk = GetTickCount();

    if(!m_bFullSceen)
    {
        if (m_lWndCount != 1 || point.x < 265 || point.x > 1035 || point.y < 6 || point.y > 548)
        {
            return;
        }

        oPoint.x = (point.x - 265) * 10000 / (770);
        oPoint.y = (point.y - 6) * 10000 / (542);
    }
    else
    {
        oPoint.x = (point.x) * 10000 / (m_iDeskTopWidth);
        oPoint.y = (point.y) * 10000 / (m_iDeskTopHeight);
    }

    if (TRUE == m_bDigital)
    {
        m_stDigRect.lTop = oPoint.y;
        m_stDigRect.lLeft = oPoint.x;
        return;
    }
    m_poPlayManager[0]->OnLButtonDown(nFlags, oPoint);

    CDialog::OnLButtonDown(nFlags, point);
}

void CEZMediaDemoDlg::OnLButtonUp(UINT nFlags, CPoint point)
{
    CPoint oPoint = point;

    //˫ʱĵ¼
    m_ulLBtnUpClk = GetTickCount();
    if(m_ulLBtnUpClk - m_ulLBtnDownClk < 500)
    {
        return;
    }

    if(!m_bFullSceen)
    {
        if (m_lWndCount != 1 || point.x < 265 || point.x > 1035 || point.y < 6 || point.y > 548)
        {
            return;
        }

        oPoint.x = (point.x - 265) * 10000 / (770);
        oPoint.y = (point.y - 6) * 10000 / (542);
    }
    else
    {
        oPoint.x = (point.x) * 10000 / (m_iDeskTopWidth);
        oPoint.y = (point.y) * 10000 / (m_iDeskTopHeight);
    }

    if (TRUE == m_bDigital)
    {
        m_stDigRect.lRight = oPoint.x;
        m_stDigRect.lBottom = oPoint.y;
        m_poPlayManager[0]->SetDigital(m_oWnd[0]->m_hWnd, &m_stDigRect);
        return;
    }
    m_poPlayManager[0]->OnLButtonUp(nFlags, oPoint);

    CDialog::OnLButtonUp(nFlags, point);
}

void CEZMediaDemoDlg::OnRButtonUp(UINT nFlags, CPoint point)
{
    CPoint oPoint = point;

    if(!m_bFullSceen)
    {
        if (m_lWndCount != 1 || point.x < 265 || point.x > 1035 || point.y < 6 || point.y > 548)
        {
            return;
        }
    }

    PLAYER_RECT_S stRect = {0};
    stRect.lLeft = 0;
    stRect.lTop = 0;
    stRect.lBottom = 10000;
    stRect.lRight = 10000;

    m_poPlayManager[0]->SetDigital(m_oWnd[0]->m_hWnd, &stRect);

    CDialog::OnRButtonUp(nFlags, point);
}

void CEZMediaDemoDlg::OnLButtonDblClk(UINT nFlags, CPoint point)
{
    int nCtrlID = 0;
    CWnd* pChildWnd = FindWindow(NULL,_T("EZMediaDemo"))->GetWindow(GW_CHILD);  //Ҷ㴰;
    CPoint oPoint = point;

    if(!m_bFullSceen)
    {
        if (m_lWndCount != 1 || point.x < 265 || point.x > 1035 || point.y < 6 || point.y > 548)
        {
            return;
        }
    }

    if(TRUE == m_bFullSceen)//ָ
    {   
        while(NULL != pChildWnd)
        {        
            nCtrlID = pChildWnd->GetDlgCtrlID();//IDԴƥ
            pChildWnd = pChildWnd->GetWindow(GW_HWNDNEXT);//ѰӴڣIDC_STATIC
            if(IDC_STATIC_VIDEO_PLAY == nCtrlID)//˵Ŵ
            {
                continue;
            }
            GetDlgItem(nCtrlID)->ShowWindow(SW_SHOW);
        }

        m_oTabManu.ShowWindow(SW_SHOW);
        OnTcnSelchangeTabMain(NULL, NULL);//ǩҳѡĻָ

        m_pWndSave->ShowWindow(SW_SHOW);
        SetParent(m_pWndSave);
        SetWindowPlacement(&m_WPMSave);//ԭ
        m_oWnd[0]->ShowWindow(SW_SHOW);//ָʾ
        m_oWnd[0]->MoveWindow(&m_stRect, TRUE); 

        m_bFullSceen = FALSE;
    }
    else//ȫ
    {
        while(NULL != pChildWnd)
        {        
            nCtrlID = pChildWnd->GetDlgCtrlID();      //IDԴƥ
            GetDlgItem(nCtrlID)->ShowWindow(SW_HIDE);
            pChildWnd = pChildWnd->GetWindow(GW_HWNDNEXT);
        }

        m_iDeskTopWidth = ::GetSystemMetrics(SM_CXSCREEN);
        m_iDeskTopHeight = ::GetSystemMetrics(SM_CYSCREEN);//õĻС
        GetWindowPlacement(&m_WPMSave);//Ļλ

        m_MainFileDlg.ShowWindow(SW_HIDE);
        m_MainFishDlg.ShowWindow(SW_HIDE);
        m_MainInputDlg.ShowWindow(SW_HIDE);
        m_MainMediaDlg.ShowWindow(SW_HIDE);
        m_MainLocalDlg.ShowWindow(SW_HIDE);
        m_oTabManu.ShowWindow(SW_HIDE);//ǩҳ

        m_pWndSave = SetParent(NULL);//øΪNULL,ԭ
        m_pWndSave->ShowWindow(SW_HIDE);//ԭ 
        MoveWindow(0, 0, m_iDeskTopWidth, m_iDeskTopHeight);//ƶ

        m_oWnd[0]->ShowWindow(SW_SHOW);//ʾ
        m_oWnd[0]->MoveWindow(&CRect(0, 0, m_iDeskTopWidth, m_iDeskTopHeight), TRUE);

        m_bFullSceen = TRUE;
    }

    CDialog::OnLButtonDblClk(nFlags, point);
}


void CEZMediaDemoDlg::OnBnClickedBtnFileopen()
{
    TCHAR szFilter[] = _T("MP4 Files (*.mp4)|*.mp4|TS Files (*.ts)|*.ts|UVRD Files (*.uvrd)|*.uvrd|JPEG Files (*.jpg)|*.jpg|BMP Files (*.bmp)|*.bmp|All Files (*.*)|*.*||");
    // ļԻ   
    CFileDialog fileDlg(TRUE, _T("jpg"), NULL, 0, szFilter, this);

    // ʾļԻ   
    if (IDOK == fileDlg.DoModal()) 
    {
        // ļԻϵġ򿪡ťѡļ·ʾ༭
        m_strFilePath = fileDlg.GetPathName();
        SetDlgItemText(IDC_FILE_NAME, m_strFilePath);
    }
}

void CEZMediaDemoDlg::OnBnClickedBtnInputFileopen()
{
    TCHAR szFilter[] = _T("h26x Files(*.h26x)|*.h26x|RTP Files(*.rtp)|*.rtp||");
    // ļԻ   
    CFileDialog fileDlg(TRUE, _T("*.h26x"), NULL, 0, szFilter, this);

    // ʾļԻ   
    if (IDOK == fileDlg.DoModal()) 
    {
        // ļԻϵġ򿪡ťѡļ·ʾ༭
        m_strFilePath = fileDlg.GetPathName();
        SetDlgItemText(IDC_FILE_NAME, m_strFilePath);
    }
}

void CEZMediaDemoDlg::OnTcnSelchangeTabMain(NMHDR *pNMHDR, LRESULT *pResult)
{
    UpdateData(TRUE);
    ULONG_32 ulMainMenuType = m_oTabManu.GetCurSel();
    switch(ulMainMenuType)
    {
    case MANU_TAB_INDEX_FILE:
        m_MainFileDlg.ShowWindow(SW_SHOW);
        m_MainFishDlg.ShowWindow(SW_HIDE);
        m_MainInputDlg.ShowWindow(SW_HIDE);
        m_MainMediaDlg.ShowWindow(SW_HIDE);
        m_MainLocalDlg.ShowWindow(SW_HIDE);

        break;
    case MANU_TAB_INDEX_MEDIA:
        m_MainFileDlg.ShowWindow(SW_HIDE);
        m_MainFishDlg.ShowWindow(SW_HIDE);
        m_MainInputDlg.ShowWindow(SW_HIDE);
        m_MainMediaDlg.ShowWindow(SW_SHOW);
        m_MainLocalDlg.ShowWindow(SW_HIDE);
        break;
    case MANU_TAB_INDEX_INPUT:
        m_MainFileDlg.ShowWindow(SW_HIDE);
        m_MainFishDlg.ShowWindow(SW_HIDE);
        m_MainInputDlg.ShowWindow(SW_SHOW);
        m_MainMediaDlg.ShowWindow(SW_HIDE);
        m_MainLocalDlg.ShowWindow(SW_HIDE);
        break;
    case MANU_TAB_INDEX_LOCAL:
        m_MainFileDlg.ShowWindow(SW_HIDE);
        m_MainFishDlg.ShowWindow(SW_HIDE);
        m_MainInputDlg.ShowWindow(SW_HIDE);
        m_MainMediaDlg.ShowWindow(SW_HIDE);
        m_MainLocalDlg.ShowWindow(SW_SHOW);
        break;
    case MANU_TAB_INDEX_INTELLECT:
        m_MainFileDlg.ShowWindow(SW_HIDE);
        m_MainFishDlg.ShowWindow(SW_SHOW);
        m_MainInputDlg.ShowWindow(SW_HIDE);
        m_MainMediaDlg.ShowWindow(SW_HIDE);
        m_MainLocalDlg.ShowWindow(SW_HIDE);
        break;
    default:
        break;
    }

    //*pResult = 0;
}

void CEZMediaDemoDlg::OnBnClickedOpenLog()
{
    //־ļ
    CString strLogPath = ga_pMainDlg->GetCurrentPath() + CString("Log");
    ShellExecute(NULL, NULL, _T("explorer"), strLogPath, NULL, SW_SHOW);
}

void CEZMediaDemoDlg::OnBnClickedBtnSetting()
{
    m_oDlgLocalSetting.DoModal();
}

void CEZMediaDemoDlg::OnBnClickedBtnOpenRtmp()
{
    HWND hWnd = m_oWnd[0]->m_hWnd;

    KillTimer(TIMER_PROCESSRESH);
    SetTimer(TIMER_REFRESH, 1000, NULL);
    SetTimer(TIMER_ISFISHEYE, 1000, NULL);

    LONG_32 lStream = STREAM_TYPE_MAIN_STREAM;
    switch(m_ctlStream.GetCurSel())
    {
    case 0:
        lStream = STREAM_TYPE_MAIN_STREAM;
        break;
    case 1:
        lStream = STREAM_TYPE_SUB_STREAM;
        break;
    case 2:
        lStream = STREAM_TYPE_THIRD_STREAM;
        break;
    default:
        lStream = STREAM_TYPE_MAIN_STREAM;
        break;
    }

    for (int i = 0; i< m_lWndCount; i++)
    {
        hWnd = m_oWnd[i]->m_hWnd;
        m_poPlayManager[i]->StopPlay();
        m_poPlayManager[i]->OpenRtmp(m_strFilePath, 
                                     hWnd, 
                                     m_ctlProtL.GetCurSel(), 
                                     lStream, 
                                     m_ctlFluency.GetCurSel(),
                                     m_bEnableVCA);
        m_poPlayManager[i]->SetRenderScale(hWnd, m_lDisRatio);
    }


    UpdateData(TRUE);

    InitPlayCtrlUI();//ʼſ״̬

    UpdateData(FALSE);

    return;
}

void CEZMediaDemoDlg::OnBnClickedBtnOpenRtsp()
{
    HWND hWnd = m_oWnd[0]->m_hWnd;

    KillTimer(TIMER_PROCESSRESH);
    SetTimer(TIMER_REFRESH, 1000, NULL);
    SetTimer(TIMER_ISFISHEYE, 1000, NULL);

    for (int i = 0; i< m_lWndCount; i++)
    {
        hWnd = m_oWnd[i]->m_hWnd;
        m_poPlayManager[i]->StopPlay();
        m_poPlayManager[i]->OpenRtsp(
            m_strAddress, 
            m_strFilePath, 
            hWnd, 
            m_ctlProtL.GetCurSel(), 
            m_lExcuteType, 
            m_ctlFluency.GetCurSel(), 
            m_strStartTime, m_strEndTime,
            m_bEnableVCA);
        m_poPlayManager[i]->SetRenderScale(hWnd, m_lDisRatio);
    }


    UpdateData(TRUE);

    InitPlayCtrlUI();

    UpdateData(FALSE);
}

void CEZMediaDemoDlg::OnBnClickedBtnLocalPlay()
{
    HWND hWnd = m_oWnd[0]->m_hWnd;
    m_bPlayNone = FALSE;

    KillTimer(TIMER_PROCESSRESH);
    SetTimer(TIMER_REFRESH, 1000, NULL);
    SetTimer(TIMER_ISFISHEYE, 1000, NULL);

    m_poPlayManager[0]->StopPlay();
    m_poPlayManager[0]->StartLocalPlay(m_strAddress, m_strLocalPort, hWnd, m_bEnableVCA);
    m_poPlayManager[0]->SetRenderScale(hWnd, m_lDisRatio);

    UpdateData(TRUE);

    InitPlayCtrlUI();
 
    UpdateData(FALSE);
}

void CEZMediaDemoDlg::OnBnClickedButtonOpenhls()
{
    HWND hWnd = m_oWnd[0]->m_hWnd;

    KillTimer(TIMER_PROCESSRESH);
    SetTimer(TIMER_REFRESH, 1000, NULL);
    SetTimer(TIMER_ISFISHEYE, 1000, NULL);

    for (int i = 0; i< m_lWndCount; i++)
    {
        hWnd = m_oWnd[i]->m_hWnd;
        m_poPlayManager[i]->StopPlay();
        m_poPlayManager[i]->OpenHls(m_strFilePath, hWnd, m_strEndTime);
        m_poPlayManager[i]->SetRenderScale(hWnd, m_lDisRatio);
    }

    UpdateData(TRUE);

    InitPlayCtrlUI();

    UpdateData(FALSE);
}

void CEZMediaDemoDlg::OnBnClickedButtonHlsTime()
{
    UpdateData(TRUE);
    m_poPlayManager[0]->SetHlsTime(m_strHLSTime);
}

void CEZMediaDemoDlg::OnBnClickedBtnInputPlay()
{
    HWND hWnd = m_oWnd[0]->m_hWnd;
    m_bPlayNone = FALSE;

    m_poPlayManager[0]->StopPlay();
    m_poPlayManager[0]->PlayInputData(m_strFilePath, hWnd);

    KillTimer(TIMER_PROCESSRESH);
    SetTimer(TIMER_REFRESH, 1000, NULL);
    SetTimer(TIMER_ISFISHEYE, 100, NULL);

    UpdateData(TRUE);

    InitPlayCtrlUI();

    UpdateData(FALSE);
}

BOOL CEZMediaDemoDlg::PreTranslateMessage(MSG* pMsg)
{    
    ASSERT(pMsg != NULL);    
    if (pMsg->message == WM_MOUSEMOVE || pMsg->message == WM_LBUTTONDOWN ||
        pMsg->message == WM_LBUTTONUP)    
    {        
        m_tooltip.RelayEvent(pMsg);    
    }    
    return CDialog::PreTranslateMessage(pMsg);
}

void CEZMediaDemoDlg::OnBnClickedButtonGoie()
{
    CHAR szIP[32] = {0};
    CHAR szMsg[64] = {0};
    (VOID)w2c(szIP, (wchar_t *)m_strIP.GetBuffer(0), MAX_PATH);
    _snprintf_s(szMsg, sizeof(szMsg), _TRUNCATE, "start iexplore.exe http://%s", szIP);
    system(szMsg);
}
