#include "stdafx.h"
#include "Resource.h"
#include "EZMediaWnd.h"

CEZPlayerWnd::CEZPlayerWnd( int index ) : m_oBkBrush(RGB(34, 34, 34)), m_nWndIndex(index)
{
    m_nPlayStatus = PLAYSTATE_IDLE;
    m_strTaskNo = _T("");
    m_oBkBitmap.LoadBitmap(IDB_LOGO);
}
CEZPlayerWnd::~CEZPlayerWnd()
{
    m_oBkBrush.DeleteObject();
    m_oBkBitmap.DeleteObject();
}

BEGIN_MESSAGE_MAP(CEZPlayerWnd, CStatic)
    ON_WM_ERASEBKGND()
    ON_WM_PAINT()
END_MESSAGE_MAP()

BOOL CEZPlayerWnd::OnEraseBkgnd(CDC* pDC)
{
    DrawBkgnd(pDC);
    return FALSE;
}

void CEZPlayerWnd::OnPaint()
{
    CPaintDC dc(this); // device context for painting

    CBrush *pOldBrush = dc.SelectObject(&m_oBkBrush);
    CRect rcWnd; 
    GetClientRect(rcWnd);
    dc.FrameRect(rcWnd, &m_oBkBrush);
    dc.SelectObject(pOldBrush);
}

void CEZPlayerWnd::DrawBkgnd( CDC *pDC )
{
    CRect rcClient;
    GetClientRect(&rcClient);

    CDC memdc;
    memdc.CreateCompatibleDC(pDC);
    memdc.SelectObject(&m_oBkBitmap);

    /* ƺɫ */
    CBrush* pOldBrush = pDC->SelectObject(&m_oBkBrush);
    pDC->Rectangle(rcClient);
    pDC->SelectObject(pOldBrush);

    /* ʱƱλͼ */
    if (m_nPlayStatus == PLAYSTATE_IDLE)
    {
        int x = (rcClient.Width() - BKGNDBMP_W / 2) / 2 + rcClient.left;
        int y = (rcClient.Height() - BKGNDBMP_H) / 2 + rcClient.top;
        pDC->BitBlt(x, y, BKGNDBMP_W - 2, BKGNDBMP_H - 2, &memdc, 1, 1, SRCCOPY);
    }

    /* ͷDC */
    memdc.DeleteDC();
}
