// InputDlg.cpp : ʵļ

#include "stdafx.h"
#include "EZMediaDemo.h"
#include "InputDlg.h"
#include "EZMediaDemoDlg.h"

extern CEZMediaDemoDlg *ga_pMainDlg;

// CInputDlg Ի
IMPLEMENT_DYNAMIC(CInputDlg, CDialog)

CInputDlg::CInputDlg(CWnd* pParent /*=NULL*/)
    : CDialog(CInputDlg::IDD, pParent)
{
    m_strInputFile = "C:\\EZMedia\\RtpData\\data1029200950.rtp";

}

CInputDlg::~CInputDlg()
{
}

BOOL CInputDlg::OnInitDialog()
{
    /*ť*/
    m_tooltip.Create(this);
    m_tooltip.AddTool(GetDlgItem(IDC_BTN_OPEN_INPUTFILE), _T("Browse Input File"));
    m_tooltip.AddTool(GetDlgItem(IDC_BTN_PLAY_INPUT), _T("Play Input Stream"));

    m_tooltip.SetMaxTipWidth(123);
    m_tooltip.Activate(TRUE);

    CDialog::OnInitDialog();
    return TRUE;  // ǽõؼ򷵻 TRUE
}

BOOL CInputDlg::PreTranslateMessage(MSG* pMsg)
{    
    ASSERT(pMsg != NULL);    
    if (pMsg->message == WM_MOUSEMOVE || pMsg->message == WM_LBUTTONDOWN ||
        pMsg->message == WM_LBUTTONUP)    
    {        
        m_tooltip.RelayEvent(pMsg);    
    }    
    return CDialog::PreTranslateMessage(pMsg);
}

void CInputDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
    DDX_Text(pDX, IDC_TEXT_EDIT, m_strInputFile);
}

BEGIN_MESSAGE_MAP(CInputDlg, CDialog)
    ON_BN_CLICKED(IDC_BTN_OPEN_INPUTFILE, &CInputDlg::OnBnClickedBtnOpenInputfile)
    ON_BN_CLICKED(IDC_BTN_PLAY_INPUT, &CInputDlg::OnBnClickedBtnPlayInput)
END_MESSAGE_MAP()

// CInputDlg Ϣ
void CInputDlg::OnBnClickedBtnOpenInputfile()
{
    UpdateData(TRUE);
    ga_pMainDlg->OnBnClickedBtnInputFileopen();
    m_strInputFile = ga_pMainDlg->m_strFilePath;
    SetDlgItemText(IDC_FILE_NAME, m_strInputFile);
    UpdateData(FALSE);
}

void CInputDlg::OnBnClickedBtnPlayInput()
{
    ga_pMainDlg->m_strFilePath = m_strInputFile;
    ga_pMainDlg->OnBnClickedBtnInputPlay();
}