// LocalDlg.cpp : ʵļ

#include "stdafx.h"
#include "EZMediaDemo.h"
#include "LocalDlg.h"
#include "EZMediaDemoDlg.h"

extern CEZMediaDemoDlg *ga_pMainDlg;
// CLocalDlg Ի

IMPLEMENT_DYNAMIC(CLocalDlg, CDialog)

CLocalDlg::CLocalDlg(CWnd* pParent /*=NULL*/)
    : CDialog(CLocalDlg::IDD, pParent)
{
    m_strLocalIP = "127.0.0.1";
    m_strLocalPort = "127.0.0.1:5050";
    m_strRtpDataPath = ga_pMainDlg->GetCurrentPath() + CString("RtpData");
    m_strSpellDataPath = ga_pMainDlg->GetCurrentPath() + CString("SpellData");
    m_strYUVDataPath = ga_pMainDlg->GetCurrentPath() + CString("YUVData");
}

CLocalDlg::~CLocalDlg()
{
}


BOOL CLocalDlg::OnInitDialog()
{
    /*ť*/
    m_tooltip.Create(this);
    m_tooltip.AddTool(GetDlgItem(IDC_BTN_SAVE_YUV_DATA), _T("Save Yuv Data"));
    m_tooltip.AddTool(GetDlgItem(IDC_BTN_SAVE_RTP_DATA), _T("Save Rtp Data"));
    m_tooltip.AddTool(GetDlgItem(IDC_BTN_SAVE_PARSE_DATA), _T("Sava Spell Data"));
    m_tooltip.AddTool(GetDlgItem(IDC_BTN_LOACLPLAY), _T("Play Local Stream"));

    m_tooltip.SetMaxTipWidth(123);
    m_tooltip.Activate(TRUE);

    CDialog::OnInitDialog();
    return TRUE;  // ǽõؼ򷵻 TRUE
}

BOOL CLocalDlg::PreTranslateMessage(MSG* pMsg)
{    
    ASSERT(pMsg != NULL);    
    if (pMsg->message == WM_MOUSEMOVE || pMsg->message == WM_LBUTTONDOWN ||
        pMsg->message == WM_LBUTTONUP)    
    {        
        m_tooltip.RelayEvent(pMsg);    
    }    
    return CDialog::PreTranslateMessage(pMsg);
}

void CLocalDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);

    DDX_Text(pDX, IDC_TEXT_PORT, m_strLocalPort);
    DDX_Text(pDX, IDC_EDIT_SAVE_RTP_DATA, m_strRtpDataPath);
    DDX_Text(pDX, IDC_EDIT_SAVE_PARSE_DATA, m_strSpellDataPath);
    DDX_Text(pDX, IDC_EDIT_SAVE_YUV, m_strYUVDataPath);
}

BEGIN_MESSAGE_MAP(CLocalDlg, CDialog)
    ON_BN_CLICKED(IDC_BTN_LOACLPLAY, &CLocalDlg::OnBnClickedBtnLoaclplay)
    ON_BN_CLICKED(IDC_BTN_SAVE_YUV_DATA, &CLocalDlg::OnBnClickedBtnSaveYuvData)
    ON_BN_CLICKED(IDC_BTN_SAVE_RTP_DATA, &CLocalDlg::OnBnClickedBtnSaveRtpData)
    ON_BN_CLICKED(IDC_BTN_SAVE_PARSE_DATA, &CLocalDlg::OnBnClickedBtnSaveSpellData)
END_MESSAGE_MAP()

// CLocalDlg Ϣ
void CLocalDlg::OnBnClickedBtnLoaclplay()
{
    ga_pMainDlg->m_strAddress = m_strLocalIP;
    GetDlgItemText(IDC_TEXT_PORT, m_strLocalPort);
    ga_pMainDlg->m_strLocalPort = m_strLocalPort.Mid(m_strLocalPort.Find(_T(":")) + 1);
    ga_pMainDlg->OnBnClickedBtnLocalPlay();
}

void CLocalDlg::OnBnClickedBtnSaveYuvData()
{
    GetDlgItemText(IDC_EDIT_SAVE_YUV, m_strYUVDataPath);
    ga_pMainDlg->m_strYUVDataPath = m_strYUVDataPath;
    ga_pMainDlg->m_poPlayManager[0]->SaveYUVData(m_strYUVDataPath);
}

void CLocalDlg::OnBnClickedBtnSaveRtpData()
{
    GetDlgItemText(IDC_EDIT_SAVE_RTP_DATA, m_strRtpDataPath);
    ga_pMainDlg->m_strRtpDataPath = m_strRtpDataPath;
    ga_pMainDlg->m_poPlayManager[0]->SaveRtpData(m_strRtpDataPath);
}

void CLocalDlg::OnBnClickedBtnSaveSpellData()
{
    GetDlgItemText(IDC_EDIT_SAVE_PARSE_DATA, m_strSpellDataPath);
    ga_pMainDlg->m_strSpellDataPath = m_strSpellDataPath;
    ga_pMainDlg->m_poPlayManager[0]->SaveSpellData(m_strSpellDataPath);
}