#include <map>
#include "player_sdk_func.h"

typedef int LONG_32;
typedef unsigned int ULONG_32;
typedef unsigned int BOOL_T;
#define BOOL_FALSE                      ((BOOL_T) 0)
#define BOOL_TRUE                       ((BOOL_T) 1)
#ifndef IN
#define IN
#endif

#ifndef OUT
#define OUT
#endif

#define INOUT

#define INVALID_VALUE       (-1)
//#define RTSP_URLFMT_MAIN    "rtsp://%s:%s@%s/h264"
#define RTSP_URLFMT_MAIN    "rtsp://%s:%s@%s/media/video1"
#define RTSP_URLFMT_SECOND  "rtsp://%s:%s@%s/media/video2"
#define RTSP_URLFMT_THRID   "rtsp://%s:%s@%s/media/video3"
#define RECORD_FILENAME     "record"
#define SNAPSHOT_FILENSME   "snapshot"
#define NVR_GET_LOGIN_INFO "lLan=0&szUserName=%s&szUserLoginCert=%s&szUserLoginCertEx=%s&szServIpAddr=%s&wanlanswitch=1"
#define NVR_QUERY_RESOURCE_LIST "json={\"cmd\":26,\"szUserName\":\"%s\",\"u32UserLoginHandle\":%s}"
#define NVR_GET_NAT_PARAM "json={\"cmd\":50,\"stIPAddress\":\"%s\",\"u8RecvSendFlag\":2,\"u32TransportProtocal\":%d,\"u32StreamIndex\":%d,\"stResourceCode\":\"%s\",\"u16Port\":%d,\"szUserName\":\"%s\",\"u32UserLoginHandle\":%s}"
#define NVR_STOP_PLAY "json={\"cmd\":51,\"u32Task_No\":%s,\"szUserName\":\"%s\",\"u32UserLoginHandle\":%s}"
#define NVR_KEEP_LIVE "json={\"cmd\":12,\"szUserName\":\"%s\",\"u32UserLoginHandle\":%s}"
#define NVR_GET_DEV_TYPE "json={\"cmd\":116}"
#define NVR_QUERY_VIDEO_CHL_LIST "json={\"cmd\":20,\"szUserName\":\"%s\",\"u32UserLoginHandle\":%s}"
#define NVR_VOD_GROUP_OPEN "json={\"cmd\":88,\"szUserName\":\"%s\",\"u32UserLoginHandle\":%s}"
#define NVR_VOD_QRY "json={\"cmd\":78,\"astResourceCode\":[%s],\"focusCamCode\":%s,\"u32RecordType\":0,\"u32StoretypeCount\":0,\"u32Task_No\":%s,\"u32Begin\":%u,\"u32End\":%u, \"szUserName\":\"%s\",\"u32UserLoginHandle\":%s}"
#define NVR_VOD_QRY_MONTH "json={\"cmd\":80,\"astResourceCode\":[%s],\"astTime\":[%s],\"szUserName\":\"%s\",\"u32UserLoginHandle\":%s}"
#define NVR_TIME_DETIAL "[%u,%u]"
#define NVR_VOD_JOIN "json={\"cmd\":800,\"stIPAddress\":\"%s\",\"astCamInfo\":[%s],\"u32Task_No\":%s,\"bHasEncodeType\":true,\"u8EncodeType\":4,\"szUserName\":\"%s\",\"u32UserLoginHandle\":%s}"
#define NVR_CAMINFO_DETIAL "{\"winIndex\":%d,\"u16Port\":%d,\"stResourceCode\":\"%s\"}"
#define NVR_VOD_PLAY "json={\"cmd\":83,\"u32PlayStatus\":2015,\"u32Task_No\":%s,\"u32PlayTime\":%u, \"szUserName\":\"%s\",\"u32UserLoginHandle\":%s}"
#define NVR_VOD_STOP "json={\"cmd\":84,\"u32Task_No\":%s,\"szUserName\":\"%s\",\"u32UserLoginHandle\":%s}"

#define LOWORD(l)           ((WORD)(((DWORD_PTR)(l)) & 0xffff))
#define HIWORD(l)           ((WORD)((((DWORD_PTR)(l)) >> 16) & 0xffff))
#define LOBYTE(w)           ((BYTE)(((DWORD_PTR)(w)) & 0xff))
#define HIBYTE(w)           ((BYTE)((((DWORD_PTR)(w)) >> 8) & 0xff))

#define PLAYER_LOG_SIZE     1024        /* ־С(sKB) */
#define PLAYER_BUFFER_SIZE  3000        /* */
#define PLAYER_MAX_SESSION  64          /* */
#define PLAYER_RECV_PKT_NUM_ZERO 0      /*հΪ0*/


#define START_TYPE_STOP_PLAY      0    /*ֹͣ*/
#define START_TYPE_RTSP_TCP_PLAY  1    /*RTSP TCP*/
#define START_TYPE_FILE_PLAY      2    /*ļ*/
#define START_TYPE_RTSP_UDP_PLAY  3    /*RTSP UDP*/
#define START_TYPE_LOCAL_PLAY     4    /*ת*/
#define START_TYPE_INPUT_PLAY     5    /**/
#define START_TYPE_RTMP_PLAY      6    /*RTMP*/
#define START_TYPE_HLS_PLAY       7    /*HLS*/

#define STREAM_TYPE_MAIN_STREAM     1  /**/
#define STREAM_TYPE_SUB_STREAM      2  /**/
#define STREAM_TYPE_THIRD_STREAM    3  /**/

char *w2c(char *pcstr,wchar_t *pwstr, size_t len);

/*豸װģʽ*/
typedef enum tagIsfFixMode
{
    TOP_INSTALLATION = 0,      /*װ*/
    BOTTOM_INSTALLATION,       /*ײװ*/
    SIDE_INSTALLATION          /*氲װ*/
} ISF_FIX_MODE;

/*ģʽöٱ*/
typedef enum tagIsfPtzMode
{
    MODE_ORIGINAL = 0,      /*ԭʼͼ*/
    MODE_180,               /*2*180ģʽ*/
    MODE_360_1PTZ,          /*360+1PTZģʽ*/
    MODE_360_6PTZ,          /*360+6PTZģʽ*/
    MODE_FISH_3PTZ,         /*+3PTZģʽ*/
    MODE_FISH_MID_ON_4PTZ,  /*ͼмʾ+4PTZģʽ*/
    MODE_FISH_MID_OFF_4PTZ, /*ͼм䵫ʾ+4PTZģʽ*/
    MODE_FISH_LEFT_4PTZ,    /*+4PTZģʽ*/
    MODE_FISH_8PTZ,         /*+8PTZģʽ*/
    MODE_PANORAMA,          /*ȫģʽ*/
    MODE_PR_3PTZ,           /*ȫ+3PTZģʽ*/
    MODE_PR_4PTZ,           /*ȫ+4PTZģʽ*/
    MODE_PR_8PTZ            /*ȫ+8PTZģʽ*/

} ISF_PTZ_MODE;

typedef enum tagInputDataMode
{
    MODE_ES_DATA = 0,
    MODE_PARSE_DATA
}INPUT_DATA_MODE;

typedef struct tagInputDataFd
{
    FILE *m_pDatafd;
    FILE *m_pLenfd;
}INPUT_DATA_FD_S;

class CPlayManager
{
public:
    CPlayManager();
    ~CPlayManager();

    VOID StopPlay();
    VOID h26xFileThreadEntry();
    VOID RtpFileThreadEntry();

    ULONG_32 GetVersion();
    ULONG StartPlay(IN CString strIpAddr, 
                    IN CString strName, 
                    IN CString strPassWD, 
                    IN HWND hWnd, 
                    IN LONG_32 lProtl, 
                    IN LONG_32 lStream,
                    IN LONG_32 lFluency,
                    IN BOOL_T bEnableVCA);

    ULONG StartLocalPlay(IN CString strIpAddr, IN CString strLocalPort, IN HWND hWnd, IN BOOL_T bEnableVCA);
    ULONG StartFile(IN CString strFileAddr, IN HWND hWnd, BOOL_T bEnableVCA);
    ULONG StartPic(IN CString strPicAddr, IN HWND hWnd);
    ULONG OpenHls( IN CString strIpAddr, IN HWND hWnd, IN CString strPlayTime);
    ULONG SetHlsTime( IN CString strPlayTime);
    ULONG OpenRtmp( IN CString strIpAddr, 
                    IN HWND hWnd, 
                    IN LONG_32 lProtl, 
                    IN LONG_32 lStream, 
                    IN LONG_32 lFluency, 
                    IN BOOL_T bEnableVCA);

    ULONG OpenRtsp(IN CString strIpAddr, 
                    IN CString strURL,  
                    IN HWND hWnd, 
                    IN LONG_32 lProtl, 
                    IN LONG_32 lExecute, 
                    IN LONG_32 lFluency, 
                    IN CString strStartTime,  
                    IN CString strEndTime,
                    IN BOOL_T bEnableVCA);

    ULONG SetSoundVulue(IN LONG_32 lVolume);
    ULONG SetMicValue( IN LONG_32 lVolume );
    ULONG Snaponce(CString cSnapPath, LONG_32 lSnapFmt);
    ULONG SetPtzAndMode(ULONG_32 ulPtzMode, ULONG_32 ulFixMode);
    ULONG RecordStart(CString cRecordPath, ULONG_32 ulMediaType);
    ULONG RecordStop();
    ULONG GetFileTime(INOUT ULONG_32 *pulTotalTime);
    ULONG GetPlayTime(INOUT ULONG_32 *pulPlayTime);
    ULONG SetPlayTime(INOUT ULONG_32 ulPlayTime);
    ULONG PausePlay();
    ULONG CheckMark(IN CString strFileAddr);
    ULONG StartVoice(IN CString strIpAddr, IN CString strName, IN CString strPassWD, IN LONG_32 lProtl);
    ULONG StopVoice();
    ULONG AFrameGo();
    ULONG SetPayloadType();

    BOOL_T OpenSound();
    BOOL_T CloseSound();
    BOOL_T SetRenderScale(IN HANDLE hwnd, IN LONG_32 lRenderScale);
    BOOL_T GetFrameRate(OUT LONG_32 *plFrameRate);
    BOOL_T GetBitRate(OUT LONG_32 *plBitRate);
    BOOL_T GetLostPacketRate(OUT FLOAT *pfLostRate);
    BOOL_T ResetLostPacketRate();
    BOOL_T GetPictureSize( OUT LONG_32 *plWidth, OUT LONG_32 *plHeight );
    BOOL_T GetPacketQueueStart(INOUT ULONG_32 *pulFrameCount, INOUT ULONG_32 *pulPacketCount );
    BOOL_T GetEncodeType(OUT ULONG_32 *pulVideoEncodeType, OUT ULONG_32 *pulAudioEncodeType);
    BOOL_T IsFishEyeStream();
    BOOL_T SetDigital(HWND hWnd, PLAYER_RECT_S *pstRect);
    BOOL_T SpeedSlow();
    BOOL_T SpeedFast();
    BOOL_T SaveRtpData(CString cSavePath);
    BOOL_T SaveSpellData(CString cSavePath);
    BOOL_T SaveYUVData(CString cSavePath);
    BOOL_T SetAudioInfo();
    BOOL_T OnMouseMove(IN ULONG_32 ulFlags, IN CPoint point);
    BOOL_T OnLButtonUp(IN ULONG_32 ulFlags, IN CPoint point);
    BOOL_T OnLButtonDown(IN ULONG_32 ulFlags, IN CPoint point);
    BOOL_T OnMouseHWheel(IN ULONG_32 ulFlags, IN short zDelta, IN CPoint pt);
    BOOL_T Open5ePtz();
    BOOL_T Close5ePtz();
    ULONG PlayInputData(IN CString m_strFilePath, IN HWND hWnd);
    BOOL_T IvaOSD();
    BOOL_T VideoDrawWaterMark();
    BOOL_T SetVideoIvaDataCB();

    BOOL_T NVRGetLoginInfo(IN CString strUserName, 
        IN CString strPasswd, 
        IN CString strServerIP,
        IN CString strUserLoginCertEx,
        OUT CString& strLoginInfo);
    BOOL_T NVRGetIPCList(IN CString strUserName, 
        IN CString strLoginInfo, 
        IN CString strServerIP, 
        OUT CString& strResult);
    BOOL_T NVRGetNatParam(IN CString strUserName, 
        IN CString strLoginInfo, 
        IN CString strServerIP, 
        IN LONG Protocol, 
        IN LONG Stream, 
        IN LONG Port, 
        IN CHAR* szResourceCode, 
        IN CString strLocalIP,
        OUT CString& SessionID,
        OUT CString& taskNo);
    BOOL_T NVRKeepLive(IN CString strUserName, IN CString strServerIP, IN CString strLoginInfo);

    BOOL_T NVRGetDevType(IN CString strServerIP, OUT CString& PublicKey, OUT CString& PublicElement);

    BOOL_T NVRStopLive(IN CString strUserName, IN CString strLoginInfo, IN CString strServerIP, IN CString strTaskNo);

    BOOL_T NVRGetVideoChlList(IN CString strUserName, IN CString strLoginInfo, IN CString strServerIP, OUT CString& strResult);

    BOOL_T NVRVODGroupOpen(IN CString strUserName, IN CString strLoginInfo, IN CString strServerIP, OUT CString& strTaskNO);

    BOOL_T NVRStartReplay(IN CString strUserName, 
        IN CString strLoginInfo,
        IN CString strServerIP, 
        IN CString strTaskNo,
        IN CString strPlayTime);

    BOOL_T NVRVODJoin(IN CString strUserName, 
        IN CString strLoginInfo,
        IN CString strServerIP, 
        IN CString strTaskNo,
        IN CString strLocalIP,
        IN CString strCamInfo,
        OUT CString& SessionIDArr);

    BOOL_T NVRVODQry(IN CString strUserName, 
        IN CString strLoginInfo,
        IN CString strServerIP, 
        IN CString strTaskNo,
        IN CString strPlayTime,
        IN CString strResourceCodeArr,
        IN CString strFocusResourceCode);

    BOOL_T NVRVODQryMonth(IN CString strUserName, 
        IN CString strLoginInfo,
        IN CString strServerIP, 
        IN CString strPlayTime,
        IN CString strResourceCodeArr);

    BOOL_T NVRStopReplay(IN CString strUserName, IN CString strLoginInfo, IN CString strServerIP, IN CString strTaskNo);

public:
    static std::map<ULONG, ULONG_32> sm_oSessionPortMap;
    static CRITICAL_SECTION sm_stLock;

    ULONG_32 m_ulSpeed;

private:
    static LONG sm_InitRefCount;

    FILE *m_pfd;

    HWND m_hWnd;
    HANDLE m_hThread;

    CHAR szInputPath[MAX_PATH];

    ULONG m_ulSession;
    ULONG m_hSocet; 
    ULONG m_ulStartType;

    BOOL_T m_bRun;
    BOOL_T m_bPause;
    BOOL_T m_bIvaOsd;
    BOOL_T m_bWaterMark;
    BOOL_T m_bSaveYUVData;
    BOOL_T m_bSaveRtpData;
    BOOL_T m_bSaveSpellData;
    BOOL_T m_bIvaData;

    ULONG_32 m_ulRes;
    ULONG_32 m_ulPort;
    ULONG_32 m_ulLocalPort;

    INPUT_DATA_FD_S stInputDataFd; 
};