/*****************************************************************************
                ݻͨż޹˾(2012)Ȩ
------------------------------------------------------------------------------
                            common_log.cpp
    Ʒ: EZStation
    ģ: EZS_COMMON
  : 2012/2/9 
      : liwenliang 00389
  ļ: ־ʵ 

------------------------------------------------------------------------------
   ޸ʷ
                        
  --------------------------------------------------------------------------

*****************************************************************************/
#include "StdAfx.h"

#include <stdio.h>

#include <Windows.h>
#include <sys/stat.h>
#include <string>

#include "Common.h"
#include "ThreadBase.h"
#include "SysLog.h"

/* ߳Ϣ:¼ı־ */
#define WM_SYSLOG_WRITE             (WM_USER + 1000)

/* Ĭ־(λ:M) */
#define DEFAULT_LOGCAPACITY         10

/* ־ļ󳤶(λ:Bytes */
#define LOG_FILE_MAX_LENGTH         (2 * 1024 * 1024)

#define DEFAULT_PATH            "C:\\"


CHAR *LOG_LEVEL_STRING[] = {"NOLOG", "DEBUG", "INFO", "WARN", "ERROR", "FATAL"};


const CHAR* GetFileName(IN const CHAR* pszFileName)
{
    const CHAR* pszCurrent = pszFileName + strlen(pszFileName);     // ʱָ'\0';    
    while ((pszFileName != pszCurrent) && ('\\' != *--pszCurrent)); // ҵһ '\'
    return '\\' == *pszCurrent ? ++pszCurrent : pszCurrent;         // û '\' 
}

VOID GetCurrentPath(CHAR * pcCurrentExePath)
{
    CHAR szExePathName[255] = {0};
    CHAR szExePath[255] = {0};
    CHAR szExeName[255] = {0};
    CHAR szExeDrive[16] = {0};
    CHAR szExeExt[16] = {0};

    GetModuleFileNameA(NULL, szExePathName, sizeof(szExePathName));
    _splitpath(szExePathName,szExeDrive,szExePath,szExeName,szExeExt);

    CHAR szIniPathName[255] = {0};
    CHAR szTmpFolderName[255] = {0};

    strncpy(szIniPathName,szExeDrive, sizeof(szIniPathName) - 1);
    strcat(szIniPathName,szExePath);

    sprintf(pcCurrentExePath, "%s", szIniPathName);

    return;
}

//////////////////////////////////////////////////////////////////////////
// CSysLog : ʵ

/*****************************************************************************
    : CSysLog
  : 201229 
      : liwenliang 00389
  : ı־ĬϹ캯
  : 
  : 
    ֵ: 
    ע: 
------------------------------------------------------------------------------
    ޸ʷ                                                                  
                                                                  
  --------------------------------------------------------------------------
                                                                              
*****************************************************************************/
CSysLog::CSysLog()
{
    m_enLogLevel   = LOG_LEVEL_INFO;
    m_hLogFile     = INVALID_HANDLE_VALUE;
    m_lLogCapacity = DEFAULT_LOGCAPACITY;
    CHAR szTmpPath[MAX_PATH] = {0};

    memset(m_szLogBuff, 0, sizeof(m_szLogBuff));

    GetCurrentPath(szTmpPath);
    sprintf(szTmpPath, "%slog\\", szTmpPath);
    strncpy(m_szLogPath, szTmpPath, sizeof(m_szLogPath));

    MakeDir(m_szLogPath);
    return;
};

/*****************************************************************************
    : CSysLog
  : 201229 
      : liwenliang 00389
  : ı־չ캯
  : const CHAR* pszPath : ־·
            LOGLEVEL_E enLevel  : ־
  : 
    ֵ: 
    ע: 
------------------------------------------------------------------------------
    ޸ʷ                                                                  
                                                                  
  --------------------------------------------------------------------------
                                                                              
*****************************************************************************/
CSysLog::CSysLog(IN const CHAR* pszPath, IN LOGLEVEL_E enLevel, IN LONG lMaxCapacity)
{
    m_enLogLevel   = enLevel;
    m_hLogFile     = INVALID_HANDLE_VALUE;
    m_lLogCapacity = lMaxCapacity;

    memset(m_szLogBuff, 0, sizeof(m_szLogBuff));
    strncpy(m_szLogPath, pszPath, sizeof(m_szLogPath));
}

/*****************************************************************************
    : ~CSysLog
  : 201229 
      : liwenliang 00389
  : ı־Ĭ
  : 
  : 
    ֵ: 
    ע: 
------------------------------------------------------------------------------
    ޸ʷ                                                                  
                                                                  
  --------------------------------------------------------------------------
                                                                              
*****************************************************************************/
CSysLog::~CSysLog()
{
    Close();
}

/*****************************************************************************
    : CSysLog.Log
  : 201229 
      : liwenliang 00389
  : ¼ı־
  : LOGLEVEL_E enLevel       
            const CHAR* pszFile      
            LONG lLine               
            const CHAR* pszDescribe  
  : 
    ֵ: LONG
    ע: 
------------------------------------------------------------------------------
    ޸ʷ                                                                  
                                                                  
  --------------------------------------------------------------------------
                                                                              
*****************************************************************************/
LONG CSysLog::Log(IN LOGLEVEL_E enLevel, IN const CHAR* pszFile, IN LONG lLine, IN const CHAR* pszDescribe)
{
    if (enLevel < LOG_LEVEL_NOLOG || enLevel > LOG_LEVEL_FATAL)
    {
        return ERR_INVALIDPARAM;
    }
    
    if (enLevel < m_enLogLevel)
    {
        return ERR_SUCCEED;
    }

    std::string strTime;
    AppendTimeString("%04d-%02d-%02d %02d:%02d:%02d.%03d", strTime);

    /*
     * ־ӡʽ
     * yyyy-mm-dd HH:MM:SS.sss [Level] [file:line] describe
     */
    LONG lCount = _snprintf(m_szLogBuff, sizeof(m_szLogBuff) - 1, "%s [%s] [%s:%d] %s\r\n", 
                            strTime.c_str(), LOG_LEVEL_STRING[enLevel],
                            GetFileName(pszFile), lLine, pszDescribe);

    /* ־󳤶Ϊ1024(),ֽض */
    if (0 > lCount)
    {
        lCount = sizeof(m_szLogBuff) - 1;
    }

    /* ־ļСޣдļ */
    struct _stat stStat = {0};
    _stat(m_szLogFile, &stStat);
    if (stStat.st_size > LOG_FILE_MAX_LENGTH)
    {
        Close();
        Open();
    }

    TRACE("%s\n", m_szLogBuff);
    if (!WriteFile(m_hLogFile, m_szLogBuff, lCount, (LPDWORD)&lCount, NULL))
    {
        return ERR_IOFAIL;
    }

    return ERR_SUCCEED;
}

LONG CSysLog::Open()
{
    _snprintf(m_szLogFile, sizeof(m_szLogFile), "%sEZplayer.log", m_szLogPath);

    if (INVALID_HANDLE_VALUE == m_hLogFile)
    {
        m_hLogFile = CreateFileA(m_szLogFile, 
                                GENERIC_READ | GENERIC_WRITE,   // open for writing
                                FILE_SHARE_READ,                // share for reading
                                NULL,                           // default security
                                OPEN_ALWAYS,                    // overwrite existing
                                FILE_ATTRIBUTE_NORMAL,          // normal file
                                NULL);                          // no attr. template
    }

    if (INVALID_HANDLE_VALUE == m_hLogFile)
    {
        return ERR_IOFAIL;
    }

    DWORD dwSize = GetFileSize(m_hLogFile, NULL) ; 
    SetFilePointer(m_hLogFile, 0, NULL, FILE_END);

    return ERR_SUCCEED;
}

void CSysLog::Close()
{
    if (INVALID_HANDLE_VALUE != m_hLogFile)
    {
        CloseHandle(m_hLogFile);
        m_hLogFile = INVALID_HANDLE_VALUE;
    }

    return;
}

//////////////////////////////////////////////////////////////////////////
// CLogThread : ʵ
typedef struct tagSysLogS
{
    LOGLEVEL_E enLevel;                     /* ־ */
    LONG       lLine;                       /*  */
    CHAR       szFile[MAX_PATH];            /* Դļ */
    CHAR       szDescribe[BUFF_LARGE_SIZE]; /* ־Ϣ */
} EZS_SYSLOG_S;

CLogThread* CLogThread::sm_pInstance = NULL;
CLogThread::CLogThread()
{
    /* do nothing */
}

CLogThread* CLogThread::GetInstance()
{
    if (NULL == sm_pInstance)
    {
        sm_pInstance = new CLogThread;
    }
    return sm_pInstance;
}

/*****************************************************************************
    : CLogThread.ThreadHandler
  : 2012326 
      : liwenliang 00389
  : ̴߳
  : 
  : 
    ֵ: DWORD
    ע: 
------------------------------------------------------------------------------
    ޸ʷ                                                                  
                                                                  
  --------------------------------------------------------------------------
                                                                              
*****************************************************************************/
DWORD CLogThread::ThreadHandler()
{
    MSG stMsg;
    memset(&stMsg, 0, sizeof(stMsg));
    
    TRACE("Log Thread startup.\n");
    BOOL bRet = FALSE;
    while ((bRet = GetMessage(&stMsg, NULL, 0, 0)) != 0)
    { 
        if (-1 == bRet)
        {
            LOG_MSG1(LOG_LEVEL_ERROR, "GetMessage failed(errorcode:%d)", GetLastError());
            return ERR_FAIL;
        }
        else
        {
            ProcessMessage(&stMsg);
        }
    }

    TRACE("Log Thread exit normally.\n");
    return ERR_SUCCEED;
}

/*****************************************************************************
    : CLogThread.ProcessMessage
  : 2012326 
      : liwenliang 00389
  : windows߳Ϣ
  : LPMSG pstMsg  
  : 
    ֵ: void
    ע: 
------------------------------------------------------------------------------
    ޸ʷ                                                                  
                                                                  
  --------------------------------------------------------------------------
                                                                              
*****************************************************************************/
void CLogThread::ProcessMessage(LPMSG pstMsg)
{
    CHECK_PTR_NORET(pstMsg, "invalid param");

    if (WM_SYSLOG_WRITE == pstMsg->message)
    {
        EZS_SYSLOG_S *pstSysLog = (EZS_SYSLOG_S*)pstMsg->lParam;
        CHECK_PTR_NORET(pstSysLog, "invalid param, message struct error");
        m_oSysLog.Log(pstSysLog->enLevel, pstSysLog->szFile, pstSysLog->lLine, pstSysLog->szDescribe);
        SAFE_FREE(pstSysLog);
        return;
    }

    TranslateMessage(pstMsg);
    DispatchMessage(pstMsg);
    return;
}

/*****************************************************************************
    : CLogThread.SysLog
  : 2012326 
      : liwenliang 00389
  : ¼ı־
  : LOGLEVEL_E enLevel     
            const CHAR* pszFile    
            LONG lLine             
            const CHAR* pszFormat  
            ...                    
  : 
    ֵ: LONG
    ע: 
------------------------------------------------------------------------------
    ޸ʷ                                                                  
                                                                  
  --------------------------------------------------------------------------
                                                                              
*****************************************************************************/
LONG CLogThread::SysLog(LOGLEVEL_E enLevel, const CHAR* pszFile, LONG lLine, const CHAR* pszFormat, ...)
{
    EZS_SYSLOG_S *pstSysLog = (EZS_SYSLOG_S*)malloc(sizeof(EZS_SYSLOG_S));
    if (NULL == pstSysLog)
    {
        TRACE("log failed");
        return ERR_FAIL;
    }
    memset(pstSysLog, 0, sizeof(EZS_SYSLOG_S));

    pstSysLog->enLevel = enLevel;
    pstSysLog->lLine = lLine;
    strncpy(pstSysLog->szFile, GetFileName(pszFile), sizeof(pstSysLog->szFile));
    va_list args;
    va_start(args, pszFormat);
    _vsnprintf(pstSysLog->szDescribe, sizeof(pstSysLog->szDescribe), pszFormat, args);
    va_end(args);

    if (!PostThreadMessage(LogThread::GetCurrentThreadId(), WM_SYSLOG_WRITE, 0, (LPARAM)pstSysLog))
    {
        TRACE("PostThreadMessage<threadid:%d> failed(errcode:%d)\n", LogThread::GetCurrentThreadId(), GetLastError());
        SAFE_FREE(pstSysLog);
        return ERR_FAIL;
    }

    return ERR_SUCCEED;
}


/*****************************************************************************
    : CLogThread.WriteSysLog
  : 2012326 
      : liwenliang 00389
  : дı־
  : LOGLEVEL_E enLevel       
            const CHAR* pszFile      
            LONG lLine               
            const CHAR* pszDescribe  
  : 
    ֵ: LONG
    ע: 
------------------------------------------------------------------------------
    ޸ʷ                                                                  
                                                                  
  --------------------------------------------------------------------------
                                                                              
*****************************************************************************/
LONG CLogThread::WriteSysLog(LOGLEVEL_E enLevel, const CHAR* pszFile, LONG lLine, const CHAR* pszDescribe)
{
    return m_oSysLog.Log(enLevel, pszFile, lLine, pszDescribe);
}

LONG CLogThread::InitInstance()
{
    m_oSysLog.Open();
    LONG lRet = StartThread();
    if (ERR_SUCCEED != lRet)
    {
        LOG_MSG(LOG_LEVEL_INFO, "start log thread failed");
        return lRet;
    }

    WaitForSingleObject(m_hThread, 1000); /* ȴ߳̿ʼִ,ȴʱΪ1s */
    LOG_MSG(LOG_LEVEL_INFO, "log thread started");

    return ERR_SUCCEED;
}

void CLogThread::ExitInstance()
{
    StopThread();
    SAFE_DELETE(sm_pInstance);
}