/*****************************************************************************
                ݻͨż޹˾(2012)Ȩ
------------------------------------------------------------------------------
                            common_log.h
    Ʒ: EZStation
    ģ: EZS_COMMON
  : 2012/2/9 
      : liwenliang 00389
  ļ: common_log.cpp ͷļ 

------------------------------------------------------------------------------
   ޸ʷ
                        
  --------------------------------------------------------------------------

*****************************************************************************/
#ifndef _IPCPLAYER_SYSLOG_H
#define _IPCPLAYER_SYSLOG_H
#include "ThreadBase.h"

/* ־̵߳ */
#define LogThread                               CLogThread::GetInstance()->CLogThread

/* ־ӡ */
#define LOG_MSG0(level, fmt)                    CLogThread::SysLog(level, __FILE__, __LINE__, fmt)
#define LOG_MSG1(level, fmt, arg1)              CLogThread::SysLog(level, __FILE__, __LINE__, fmt, arg1)
#define LOG_MSG2(level, fmt, arg1, arg2)        CLogThread::SysLog(level, __FILE__, __LINE__, fmt, arg1, arg2)

#define LOG_MSG                                 LOG_MSG0

#define BUFF_LARGE_SIZE         8196

/* ־ */
typedef enum tagLogLevel
{
    LOG_LEVEL_NOLOG = 0,        /* ӡ  */
    LOG_LEVEL_DEBUG = 1,        /* DEBUG   */
    LOG_LEVEL_INFO = 2,         /* INFO    */
    LOG_LEVEL_WARNING = 3,      /* WARNING */
    LOG_LEVEL_ERROR = 4,        /* ERROR   */
    LOG_LEVEL_FATAL = 5,        /* FATAL   */
} LOGLEVEL_E;

/**
 * @class CSysLog
 * @brief ı־
 * @attention 
 */
class CSysLog
{
public:
    CSysLog();
    CSysLog(IN const CHAR* pszPath, IN LOGLEVEL_E enLevel, IN LONG lMaxCapacity);
    virtual ~CSysLog();

    /* ¼ı־ */
    LONG Log(IN LOGLEVEL_E lLevel, IN const CHAR* pszFile, IN LONG lLine, IN const CHAR* pszDescribe);

    /* ־ */
    void SetLevel(IN LOGLEVEL_E enLevel)
    {
        m_enLogLevel = enLevel;
    }

    /* ־· */
    void SetPath(IN const CHAR* pszPath)
    {
        if (0 == strcmp(m_szLogPath, pszPath))
        {
            return;
        }

        strncpy(m_szLogPath, pszPath, sizeof(m_szLogPath));
        Close();
        Open();
    }

    /* ־ */
    void SetCapacity(IN LONG lCapacity)
    {
        m_lLogCapacity = lCapacity;
    }

    LONG Open();
    void Close();
    void Cleanup();

private:
    CHAR        m_szLogFile[MAX_PATH];          /* ־ļ */        
    CHAR        m_szLogPath[MAX_PATH];          /* ־· */
    LOGLEVEL_E  m_enLogLevel;                   /* ־ */
    CHAR        m_szLogBuff[BUFF_LARGE_SIZE];   /* ־ݻ */
    HANDLE      m_hLogFile;                     /* ־ļ */
    LONG        m_lLogCapacity;                 /* ־(λ:M) */
};

/**
 * @class CLogThread
 * @brief ־̴߳
 * @attention 
 */
class CLogThread : public CThreadBase
{
public:
    /* ȡָ */
    static CLogThread* GetInstance();
    
    /* ¼ı־ */
    static LONG SysLog(IN LOGLEVEL_E enLevel, IN const CHAR* pszFile, IN LONG lLine, IN const CHAR* pszFormat, IN ...);
    
    /* ־ */
    void SetLogParam(IN LOGLEVEL_E enLevel, IN const CHAR* pszPath)
    {
        m_oSysLog.SetLevel(enLevel);
        m_oSysLog.SetPath(pszPath);
    }

    LONG InitInstance();
    void ExitInstance();

protected:
    /* ̴߳ */
    virtual DWORD ThreadHandler();
    
    /* ߳Ϣ */
    void ProcessMessage(IN LPMSG pstMsg);

    /* ¼ı־ */
    LONG WriteSysLog(IN LOGLEVEL_E enLevel, IN const CHAR* pszFile, IN LONG lLine, IN const CHAR* pszDescribe);
    
    /* 캯(ΪܱԱ) */
    CLogThread();

private:
    static CLogThread* sm_pInstance;    /* ָ */
    CSysLog m_oSysLog;                  /* ı־ */
};

#endif
