#ifndef __EZR_RM_EX_H__
#define __EZR_RM_EX_H__

#ifdef  __cplusplus
extern "C"{
#endif

#ifndef IN
    #define     IN
#endif

#ifndef OUT
    #define     OUT
#endif

#ifndef INOUT
    #define     INOUT
#endif

/* ׼Լ Standard function calling convention */
#ifdef WIN32
    #define STDCALL                 __stdcall
    #ifdef IMCP_EXPORTS_DLL
        #define IMCP_EXPORT         __declspec( dllexport )
    #else
        #define IMCP_EXPORT         __declspec( dllimport )
    #endif
#else
    #ifdef i386
        #define STDCALL             __attribute__((stdcall))
    #else
        #define STDCALL
    #endif
    #define IMCP_EXPORT
#endif

#ifndef CHAR_DEF
#define CHAR_DEF
    typedef char                    CHAR;
#endif

#ifndef UCHAR_DEF
#define UCHAR_DEF
    typedef unsigned char           UCHAR;
#endif

#ifndef SHORT_DEF
#define SHORT_DEF
    typedef short                   SHORT;
#endif

#ifndef USHORT_DEF
#define USHORT_DEF
    typedef unsigned short          USHORT;
#endif

#ifndef LONG_32_DEF
#define LONG_32_DEF
    typedef int                     LONG_32;
#endif

#ifndef ULONG_32_DEF
#define ULONG_32_DEF
    typedef unsigned int            ULONG_32;
#endif

#ifndef LONG_DEF
#define LONG_DEF
    typedef long                    LONG;
#endif

#ifndef ULONG_DEF
#define ULONG_DEF
    typedef unsigned long           ULONG;
#endif

#ifndef TIME_DEF
#define TIME_DEF
    typedef long                    TIME_T;
#endif

#ifndef INT_DEF
#define INT_DEF
    typedef int                     INT;
#endif

#ifndef BOOL_T_DEF
#define BOOL_T_DEF
    typedef unsigned int            BOOL_T;
#endif

#ifndef BOOL_TRUE
    #define BOOL_TRUE               ((BOOL_T) 1)
#endif

#ifndef BOOL_FALSE
    #define BOOL_FALSE              ((BOOL_T) 0)
#endif

#ifndef NULL
    #define NULL                    ((void *) 0)
#endif

#ifndef VOID_DEF
#define VOID_DEF
    #define VOID                    void
#endif

/** @brief ý */
#define EZR_RTSP_PAYLOAD_NUM                2

/** @brief RTSP Session ID  */
#define IMCP_RM_SESSIONID_LEN               64

/** 
 * @enum tagEZRecordReturnResult
 * @brief ö
 * @attention
 */
typedef enum tagEZRecordReturnResult
{
    /** @brief EZR ͨô */
    EZR_COMMON_SUCCEED              = 0,        /**< ִгɹ */

    EZR_COMMON_FAILED               = 100,      /**< ִʧ */
    EZR_COMMON_INVALID_PARAM,                   /**< Ƿ */
    EZR_COMMON_MALLOC_FAILED,                   /**< ڴʧ */
    EZR_COMMON_REALLOC_FAILED,                  /**< ڴٷʧ */
    EZR_COMMON_SYS_FAIL,                        /**< ϵͳͨô */
    EZR_COMMON_INIT_DONE,                       /**< Ѿʼ */
    EZR_COMMON_SYS_RES_FAILED,                  /**< ϵͳԴʧ */
    EZR_COMMON_NOT_SUPPORT,                     /**< ݲ֧ */
    EZR_COMMON_UPNP_FULL,                       /**< ·˿ӳﵽ */

    /* FILE */
    EZR_COMMON_FILE_WR_FAIL         = 200,      /**< ļд */

    /* MasAgent */
    EZR_COMMON_SRC_MISS             = 300,      /**< ҲָԴ */
    EZR_COMMON_AUTHORIZE_FAIL,                  /**< Ȩʧ */
    EZR_COMMON_LESS_MEMORY,                     /**< ڴ治 */ 
    EZR_COMMON_NO_STOR_CHANNEL,                 /**< ޿д洢ͨ*/ 
    EZR_COMMON_NO_STOR_NODE,                    /**< ޿д洢ڵ */ 
    EZR_COMMON_TASK_FULL,                       /**<  */ 
    EZR_COMMON_INVALID_CFG,                     /**<  */ 
    EZR_COMMON_USR_LOGIN,                       /**< ûѾ¼ */ 
    EZR_COMMON_INVALID_IP,                      /**< IP */  
    EZR_COMMON_SOAP_ERROR,                      /**< SOAP */ 
    EZR_COMMON_NET_FAILED,                      /**<  */
    EZR_COMMON_NET_TIMEOUT,                     /**< 糬ʱ */
    EZR_COMMON_SHAKE_ERROR,                     /**<  */
    EZR_COMMON_STREAMNUM_FULL,                  /**<  */
    EZR_COMMON_SERVICE_DOWN,                    /**< ֹͣ */
    EZR_COMMON_SERVICE_RUNNING,                 /**<  */
    EZR_COMMON_PORT_CONFLICT,                   /**< ˿ڳͻ */
    EZR_COMMON_EZSTREAMER_FULL,                 /**< EZStreamer  */
    EZR_COMMON_VOD_OVER_ABILITY,                /**< һ */

    /* store execute */
    EZR_COMMON_STREAM_START_FAIL    = 400,      /**< 洢ʧ */
    EZR_COMMON_STREAM_STOP_FAIL,                /**< ֹͣ洢ʧ */
    EZR_COMMON_STREAM_IN_PROCESS,               /**< 洢Ѿ */
    EZR_COMMON_STREAM_CLOSED,                   /**< 洢Ѿر */
    EZR_COMMON_STREAM_FULL_STOP,                /**< ֹͣ */
    EZR_COMMON_STREAM_GOING_FULL,               /**<  */

    /* rm server */
    EZR_COMMON_NO_SPARE_SESSION     = 700,      /**< ޿лỰ */ 
    EZR_COMMON_NEED_AUTHENTICATE,               /**< ҪȨ */ 
    EZR_COMMON_GET_AUTHENTICATE_FAID,           /**< ȡȨʧ */ 
    EZR_COMMON_MAKE_AUTHENTICATE_FAID,          /**< Ȩʧ */ 
    EZR_COMMON_AUTHENTICATEINFO_DIFF,           /**< ȨϢһ */
    EZR_COMMON_AUTHENTICATE_FAID,               /**< Ȩʧ */
    EZR_COMMON_SESSION_CLOSED,                  /**< Ựѹر */

    /* rm server */
    EZR_COMMON_RTSP_INNER_ERROR     = 800,      /**< 豸ڲ */
    EZR_COMMON_RTSP_INNER_TIMEOUT,              /**< ڲʱ */
    EZR_COMMON_RTSP_STREAM_NOT_READY,           /**< δ */
    EZR_COMMON_RTSP_KEEP_ALIVE_FAILED,          /**< ʧ */
    EZR_COMMON_RTSP_OVER_ABILITY,               /**< ط */
    EZR_COMMON_RTSP_BAD_REQUEST,                /**<  */
    EZR_COMMON_RTSP_UNAUTHORIZED,               /**< δ֤ͨ */
    EZR_COMMON_RTSP_PAYMENT_REQUIRED,           /**< Ҫ */
    EZR_COMMON_RTSP_FORIBIDDEN,                 /**< ֹ */
    EZR_COMMON_RTSP_NOT_FOUND,                  /**< ûҵ */
    EZR_COMMON_RTSP_METHOD_NOT_ALLOWED,         /**< ÷ */
    EZR_COMMON_RTSP_NOT_ACCEPTABLE,             /**<  */
    EZR_COMMON_RTSP_PROXY_REQUIRED,             /**< Ҫ֤ */
    EZR_COMMON_RTSP_REQUEST_TIMEOUT,            /**< ʱ */
    EZR_COMMON_RTSP_GONE,                       /**< ڷ */
    EZR_COMMON_RTSP_LENGTH_REQUIRED,            /**< Ҫ */
    EZR_COMMON_RTSP_PRECONDITION_FAILED,        /**< Ԥʧ */
    EZR_COMMON_RTSP_ENTITY_TOO_LARGE,           /**< ʵ */
    EZR_COMMON_RTSP_URI_TOO_LARGE,              /**< -URI */
    EZR_COMMON_RTSP_UNSUPPORTED_TYPE,           /**< ýͲ֧ */
    EZR_COMMON_RTSP_NOT_UNDERSTOOD,             /**< ˲ */
    EZR_COMMON_RTSP_CONFERENCE_NOT_FOUND,       /**< Ҳ */
    EZR_COMMON_RTSP_NOT_ENOUGH_BANDWIDTH,       /**< (RTSP) */
    EZR_COMMON_RTSP_SESSION_NOT_FOUND,          /**< ҲỰ */
    EZR_COMMON_RTSP_METHOD_NOT_VALID,           /**< ״̬´˷Ч */
    EZR_COMMON_RTSP_HEADER_NOT_VALID,           /**< ͷԸԴЧ */
    EZR_COMMON_RTSP_INVALID_RANGE,              /**< ЧΧ */
    EZR_COMMON_RTSP_PARAMETER_READ_ONLY,        /**< ֻ */
    EZR_COMMON_RTSP_AO_NOT_ALLOWED,             /**< Ͽ */
    EZR_COMMON_RTSP_ONLY_AO_ALLOWED,            /**< ֻϿ */
    EZR_COMMON_RTSP_UNSUPPORTED_TRANSPORT,      /**< ䷽ʽ֧ */
    EZR_COMMON_RTSP_DESTINATION_UNREACHABLE,    /**< ޷Ŀĵַ */
    EZR_COMMON_RTSP_INTERNAL_SERVER_ERROR,      /**< ڲ */
    EZR_COMMON_RTSP_NOT_IMPLEMENTED,            /**< δʵ */
    EZR_COMMON_RTSP_BAD_GATEWAY,                /**< ش */
    EZR_COMMON_RTSP_SERVICE_UNAVAILABLE,        /**< ޷õ */
    EZR_COMMON_RTSP_GATEWAY_TIMEOUT,            /**< سʱ */
    EZR_COMMON_RTSP_VERSION_NOT_SUPPORTED,      /**< ִ֧RTSP汾 */
    EZR_COMMON_RTSP_OPTION_NOT_SUPPORTED,       /**< ֧ѡ */
    EZR_COMMON_RTSP_SESSION_NOT_EXIST,          /**< Ự */
    EZR_COMMON_RTSP_NOT_ENOUGH_BANDWIDTH2,      /**<  */
    EZR_COMMON_RTSP_REALPLAY_ESTABLISHED,       /**< ʵҵѾ */
    EZR_COMMON_RTSP_REALPLAY_RES_BUSY,          /**< ʵҵʾԴæ */
    EZR_COMMON_RTSP_MULTICAST_DISABLED,         /**< 鲥ʹܹر */
    EZR_COMMON_RTSP_MULTICAST_PORT_OCCUPIED,    /**< 鲥˿ѱռ */
    EZR_COMMON_RTSP_MULTICAST_PORT_EXHAUSTED,   /**< 鲥˿Ѻľ */
    EZR_COMMON_RTSP_MULTICAST_USER_NOT_EXIST,   /**< 鲥û */
    EZR_COMMON_RTSP_CHANNEL_NOT_ONLINE,         /**< ͨ */
    EZR_COMMON_RTSP_TALKBACK_ENCODED_INVALID,   /**< ԽԴЧ */
    EZR_COMMON_RTSP_VOICE_RES_USED_BY_TALKBACK, /**< ԴѱԽʹ */
    EZR_COMMON_RTSP_TALKBACK_EXISTS,            /**< ԽѴ */
    EZR_COMMON_RTSP_VOICE_WORK_NOT_EXIST,       /**< ҵ񲻴 */
    EZR_COMMON_RTSP_TALKBACK_TIMEOUT,           /**< Խҵʱ */
    EZR_COMMON_RTSP_TALKBACK_ERROR,             /**< Խʧ */
    EZR_COMMON_RTSP_UNDEFINED_ERROR,            /**< δ */
    EZR_COMMON_BUT
}EZR_RESULT_E;

/**
 * @enum tagRMSessionErrorType
 * @brief Ự
 * @attention
 */
typedef enum tagRMSessionErrorType
{
    IMCP_RM_ERROR_NET_FAILED            = 0,        /**< Ự */
    IMCP_RM_ERROR_NET_TIMEOUT,                      /**< Ự糬ʱ */
    IMCP_RM_ERROR_SHAKE_FAILED,                     /**< Ự */
    IMCP_RM_ERROR_STREAMNUM_FULL,                   /**< Ѿ */
    IMCP_RM_ERROR_STREAM_THIRDSTOP,                 /**< ֹͣ */
    IMCP_RM_ERROR_FILE_END,                         /**< ļ */
    IMCP_RM_ERROR_STREAM_UPDATE,                    /**< ͸ */
    IMCP_RM_ERROR_STREAM_DOWNLOAD_OVER,             /**< һ */
    IMCP_RM_ERROR_AUTH_FAILED,                      /**< Ȩʧ */

    /* NVR RTSPӦ */
    IMCP_RM_ERROR_RTSP_INNER_ERROR      = 200,      /**< 豸ڲ */
    IMCP_RM_ERROR_RTSP_INNER_TIMEOUT,               /**< ڲʱ */
    IMCP_RM_ERROR_RTSP_STREAM_NOT_READY,            /**< δ */
    IMCP_RM_ERROR_RTSP_KEEP_ALIVE_FAILED,           /**< ʧ */
    IMCP_RM_ERROR_RTSP_OVER_ABILITY,                /**< ط */
    IMCP_RM_ERROR_RTSP_BAD_REQUEST,                 /**<  */
    IMCP_RM_ERROR_RTSP_UNAUTHORIZED,                /**< δ֤ͨ */
    IMCP_RM_ERROR_RTSP_PAYMENT_REQUIRED,            /**< Ҫ */
    IMCP_RM_ERROR_RTSP_FORIBIDDEN,                  /**< ֹ */
    IMCP_RM_ERROR_RTSP_NOT_FOUND,                   /**< ûҵ */
    IMCP_RM_ERROR_RTSP_METHOD_NOT_ALLOWED,          /**< ÷ */
    IMCP_RM_ERROR_RTSP_NOT_ACCEPTABLE,              /**<  */
    IMCP_RM_ERROR_RTSP_PROXY_REQUIRED,              /**< Ҫ֤ */
    IMCP_RM_ERROR_RTSP_REQUEST_TIMEOUT,             /**< ʱ */
    IMCP_RM_ERROR_RTSP_GONE,                        /**< ڷ */
    IMCP_RM_ERROR_RTSP_LENGTH_REQUIRED,             /**< Ҫ */
    IMCP_RM_ERROR_RTSP_PRECONDITION_FAILED,         /**< Ԥʧ */
    IMCP_RM_ERROR_RTSP_ENTITY_TOO_LARGE,            /**< ʵ */
    IMCP_RM_ERROR_RTSP_URI_TOO_LARGE,               /**< -URI */
    IMCP_RM_ERROR_RTSP_UNSUPPORTED_TYPE,            /**< ýͲ֧ */
    IMCP_RM_ERROR_RTSP_NOT_UNDERSTOOD,              /**< ˲ */
    IMCP_RM_ERROR_RTSP_CONFERENCE_NOT_FOUND,        /**< Ҳ */
    IMCP_RM_ERROR_RTSP_NOT_ENOUGH_BANDWIDTH,        /**< (RTSP) */
    IMCP_RM_ERROR_RTSP_SESSION_NOT_FOUND,           /**< ҲỰ */
    IMCP_RM_ERROR_RTSP_METHOD_NOT_VALID,            /**< ״̬´˷Ч */
    IMCP_RM_ERROR_RTSP_HEADER_NOT_VALID,            /**< ͷԸԴЧ */
    IMCP_RM_ERROR_RTSP_INVALID_RANGE,               /**< ЧΧ */
    IMCP_RM_ERROR_RTSP_PARAMETER_READ_ONLY,         /**< ֻ */
    IMCP_RM_ERROR_RTSP_AO_NOT_ALLOWED,              /**< Ͽ */
    IMCP_RM_ERROR_RTSP_ONLY_AO_ALLOWED,             /**< ֻϿ */
    IMCP_RM_ERROR_RTSP_UNSUPPORTED_TRANSPORT,       /**< ䷽ʽ֧ */
    IMCP_RM_ERROR_RTSP_DESTINATION_UNREACHABLE,     /**< ޷Ŀĵַ */
    IMCP_RM_ERROR_RTSP_INTERNAL_SERVER_ERROR,       /**< ڲ */
    IMCP_RM_ERROR_RTSP_NOT_IMPLEMENTED,             /**< δʵ */
    IMCP_RM_ERROR_RTSP_BAD_GATEWAY,                 /**< ش */
    IMCP_RM_ERROR_RTSP_SERVICE_UNAVAILABLE,         /**< ޷õ */
    IMCP_RM_ERROR_RTSP_GATEWAY_TIMEOUT,             /**< سʱ */
    IMCP_RM_ERROR_RTSP_VERSION_NOT_SUPPORTED,       /**< ִ֧RTSP汾 */
    IMCP_RM_ERROR_RTSP_OPTION_NOT_SUPPORTED,        /**< ֧ѡ */
    IMCP_RM_ERROR_RTSP_SESSION_NOT_EXIST,           /**< Ự */
    IMCP_RM_ERROR_RTSP_NOT_ENOUGH_BANDWIDTH2,       /**<  */
    IMCP_RM_ERROR_RTSP_REALPLAY_ESTABLISHED,        /**< ʵҵѾ */
    IMCP_RM_ERROR_RTSP_REALPLAY_RES_BUSY,           /**< ʵҵʾԴæ */
    IMCP_RM_ERROR_RTSP_MULTICAST_DISABLED,          /**< 鲥ʹܹر */
    IMCP_RM_ERROR_RTSP_MULTICAST_PORT_OCCUPIED,     /**< 鲥˿ѱռ */
    IMCP_RM_ERROR_RTSP_MULTICAST_PORT_EXHAUSTED,    /**< 鲥˿Ѻľ */
    IMCP_RM_ERROR_RTSP_MULTICAST_USER_NOT_EXIST,    /**< 鲥û */
    IMCP_RM_ERROR_RTSP_CHANNEL_NOT_ONLINE,          /**< ͨ */
    IMCP_RM_ERROR_RTSP_TALKBACK_ENCODED_INVALID,    /**< ԽԴЧ */
    IMCP_RM_ERROR_RTSP_VOICE_RES_USED_BY_TALKBACK,  /**< ԴѱԽʹ */
    IMCP_RM_ERROR_RTSP_TALKBACK_EXISTS,             /**< ԽѴ */
    IMCP_RM_ERROR_RTSP_VOICE_WORK_NOT_EXIST,        /**< ҵ񲻴 */
    IMCP_RM_ERROR_RTSP_TALKBACK_TIMEOUT,            /**< Խҵʱ */
    IMCP_RM_ERROR_RTSP_TALKBACK_ERROR,              /**< Խʧ */
    IMCP_RM_ERROR_RTSP_UNDEFINED_ERROR,             /**< δ */
    IMCP_RM_ERROR_BUT
}IMCP_RM_ERROR_TYPE_E;

/**
 * @enum tagRMStreamType
 * @brief Ự
 * @attention 
 */
typedef enum tagRMStreamType
{
    IMCP_RM_RTP_TCP             = 0,                /**< RTP over TCP */
    IMCP_RM_RTP_UDP,                                /**< RTP over UDP */
    IMCP_RM_TS_TCP,                                 /**< TS over TCP */
    IMCP_RM_TS_UDP,                                 /**< TS over UDP */
    IMCP_RM_UNIJPEG_TCP,                            /**< Uniview Jpeg Protocol over TCP */
    IMCP_RM_UNIMJPG_TCP,                            /**< Uniview Motion-Jpeg Protocol over TCP */
    IMCP_RM_SMS_TCP,                                /**< SMS over TCP */
    IMCP_RM_MA_UNIJPEG_TCP,                         /**< MA JPEG Data over TCP */
    IMCP_RM_MA_TCP,                                 /**< MA Playback Data over TCP */
    IMCP_RM_ES_UDP,                                 /**< ES over UDP */
    IMCP_RM_VOICE_TCP,                              /**< Խ */
    IMCP_RM_VOICE_BROADCAST_TCP,                    /**< 㲥 */
    IMCP_RM_STREAM_BUT
}IMCP_RM_STREAM_TYPE_E;

/** 
 * @enum tagRtspDealType 
 * @brief 
 * @attention 
 */ 
typedef enum tagRMRtspExecuteType 
{ 
    IMCP_RM_EXECUTE_TYPE_QUICK      = 0,            /**< ģʽã */ 
    IMCP_RM_EXECUTE_TYPE_STANDARD,                  /**< ׼RTSP */ 
    IMCP_RM_EXECUTE_TYPE_FASTPLAY,                  /**< ʺ˾IPC/NVR */ 
    IMCP_RM_EXECUTE_TYPE_MAX 
}IMCP_RM_RTSP_EXECUTE_TYPE_E; 

/**
* @enum tagRMPlayScale
* @brief űöٶ壬߱ٽʹó֡I֡ģʽ
* @attention 
*/
typedef enum tagRMPlayScale
{
    IMCP_RM_SCALE_16_BACKWARD       = 0,        /**< 16ٺ˲ */
    IMCP_RM_SCALE_8_BACKWARD,                   /**< 8ٺ˲ */
    IMCP_RM_SCALE_4_BACKWARD,                   /**< 4ٺ˲ */
    IMCP_RM_SCALE_2_BACKWARD,                   /**< 2ٺ˲ */
    IMCP_RM_SCALE_1_BACKWARD,                   /**< ٶȺ˲ */
    IMCP_RM_SCALE_HALF_BACKWARD,                /**< 1/2ٺ˲ */
    IMCP_RM_SCALE_QUARTER_BACKWARD,             /**< 1/4ٺ˲ */
    IMCP_RM_SCALE_QUARTER_FORWARD,              /**< 1/4ٲ */
    IMCP_RM_SCALE_HALF_FORWARD,                 /**< 1/2ٲ */
    IMCP_RM_SCALE_1_FORWARD,                    /**< ٶǰ */
    IMCP_RM_SCALE_2_FORWARD,                    /**< 2ǰ */
    IMCP_RM_SCALE_4_FORWARD,                    /**< 4ǰ */
    IMCP_RM_SCALE_8_FORWARD,                    /**< 8ǰ */
    IMCP_RM_SCALE_16_FORWARD,                   /**< 16ǰ */

    IMCP_RM_SCALE_2_FORWARD_IFRAME,             /**< 2ǰ(I֡) */
    IMCP_RM_SCALE_4_FORWARD_IFRAME,             /**< 4ǰ(I֡) */
    IMCP_RM_SCALE_8_FORWARD_IFRAME,             /**< 8ǰ(I֡) */
    IMCP_RM_SCALE_16_FORWARD_IFRAME,            /**< 16ǰ(I֡) */

    IMCP_RM_SCALE_2_BACKWARD_IFRAME,            /**< 2ٺ˲(I֡) */
    IMCP_RM_SCALE_4_BACKWARD_IFRAME,            /**< 4ٺ˲(I֡) */
    IMCP_RM_SCALE_8_BACKWARD_IFRAME,            /**< 8ٺ˲(I֡) */
    IMCP_RM_SCALE_16_BACKWARD_IFRAME,           /**< 16ٺ˲(I֡) */

    IMCP_RM_SCALE_INTELLIGENT_FORWARD,          /**< ܲ */
    IMCP_RM_SCALE_1_FRAME_FORWARD,              /**< ֡ǰ */
    IMCP_RM_SCALE_I_FRAME_BACKWARD,             /**< ֡(I֡)> */

    IMCP_RM_SCALE_40_FORWARD,                   /**< 40ǰ */

    IMCP_RM_SCALE_32_FORWARD_IFRAME,            /**< 32ٳ֡ǰ */
    IMCP_RM_SCALE_32_BACKWARD_IFRAME,           /**< 32ٳ֡˲ */
    IMCP_RM_SCALE_64_FORWARD_IFRAME,            /**< 64ٳ֡ǰ */
    IMCP_RM_SCALE_64_BACKWARD_IFRAME,           /**< 64ٳ֡˲ */
    IMCP_RM_SCALE_128_FORWARD_IFRAME,           /**< 128ٳ֡ǰ */
    IMCP_RM_SCALE_128_BACKWARD_IFRAME,          /**< 128ٳ֡˲ */
    IMCP_RM_SCALE_256_FORWARD_IFRAME,           /**< 256ٳ֡ǰ */
    IMCP_RM_SCALE_256_BACKWARD_IFRAME,          /**< 256ٳ֡˲ */

    IMCP_RM_SCALE_32_FORWARD,                   /**< 32ǰ */
    IMCP_RM_SCALE_32_BACKWARD,                  /**< 32ٺ˲ */

    IMCP_RM_SCALE_BUT
}IMCP_RM_PLAY_SCALE_E;

/**
 * @enum tagRMPayloadTypeE
 * @brief  ö
 * @attention
 */
typedef enum tagRMPayloadTypeE
{
    IMCP_RM_STREAM_TYPE_NONE    = 0,            /**<  */
    IMCP_RM_STREAM_TYPE_G711U,                  /**< G.711U */
    IMCP_RM_STREAM_TYPE_MP1L2,                  /**< MPEG1 Layer2 */
    IMCP_RM_STREAM_TYPE_AAC,                    /**< AAC */
    IMCP_RM_STREAM_TYPE_H264,                   /**< H.264 */
    IMCP_RM_STREAM_TYPE_JPEG,                   /**< JPEG(MJPEG) */
    IMCP_RM_STREAM_TYPE_G711A,                  /**< G.711A */
    IMCP_RM_STREAM_TYPE_DATA,                   /**< Ӧǿ */
    IMCP_RM_STREAM_TYPE_PCM,                    /**< PCMƵ44.1k */
    IMCP_RM_STREAM_TYPE_H265,                   /**< H265 */
    IMCP_RM_STREAM_TYPE_NULL                    /**< ޱ */
}IMCP_RM_PAYLOAD_TYPE_E;

/**
 * @enum tagRMSupportTypeE
 * @brief  ͨǷ֧ö
 * @attention
 */
typedef enum tagRMfuncSupportTypeE
{
    IMCP_RM_FUNC_SUP_TYPE_SCRAMBLING = 0,       /**<  */
    IMCP_RM_FUNC_SUP_TYPE_MAX                   /**<  */
}IMCP_RM_FUNC_SUP_TYPE_E;

/**
 * @struct tagRMRtspPayloadType
 * @brief EZR RTSPýϢṹ
 * @attention
 */
typedef struct tagRMRtspPayloadTypeS
{
    UCHAR ucPayloadType;                        /**< payloadֵ*/
    UCHAR ucReserved[3];                        /**< λ*/
    IMCP_RM_PAYLOAD_TYPE_E enPayloadType;       /**< */
    ULONG ulSampleRate;                         /**< Ƶ*/
}IMCP_RM_PAYLOAD_TYPE_S;

/**
 * @struct tagRMRtspPayloadType
 * @brief EZR RTSPƵϢṹ
 * @attention
 */
typedef struct tagRMRtspAudioInfoS
{
    UCHAR ucAudioType;                        /**< ƵЭ*/
    UCHAR ucFrequencyIndex;                   /**< Ƶ*/
    UCHAR ucChannelNum;                       /**< Ƶ*/
    UCHAR ucReserved;                         /**< λ*/
}IMCP_RM_AUDIO_INFO_S;

/**
* @struct tagRsaInfo
 * @brief EZR RSAӽϢ
* @attention 
*/
typedef struct tagEZRRsaInfo
{
    ULONG_32 ulBit;                     /**< Կbitֵ */
    ULONG_32 ulPub;                     /**< Կֵ */
    CHAR cN[260];                       /**< n */
    CHAR cPri[260];                     /**< ˽Կֵ */
    CHAR cP[132];                       /**< p */
    CHAR cQ[132];                       /**< q */
    CHAR cDP[132];                      /**< dp */
    CHAR cDQ[132];                      /**< dq */
    CHAR cQP[132];                      /**< qp */
}IMCP_RM_RSA_INFO_S;

/**
* @struct tagRMFuncSupInfo
 * @brief EZR ֧Ϣ
* @attention 
*/
typedef struct tagRMFuncSupInfo
{
    IMCP_RM_FUNC_SUP_TYPE_E enFuncType; /**< */
    BOOL_T bIsSupport;                  /**< Ƿֱ֧־*/
    VOID *ParamEx;                      /**< չ*/
}IMCP_RM_FUNC_SUP_INFO_S;

/**
* @struct tagUpnpMapList
 * @brief UpnpӳϢ
* @attention 
*/
typedef struct tagUpnpMapList
{
    struct tagUpnpMapList *pstNext;         /**< һ*/
    CHAR *pcProto;                          /**< ӳЭTCP/UDP*/
    USHORT usExPort;                        /**< ⲿ˿*/
    USHORT usInPort;                        /**< ڲ˿*/
    CHAR pcInIP[64];                        /**< ڲIP*/
}IMCP_RM_UPNP_MAP_LIST_S;

/**
* ⲿģṩRMģRTSPص \n
* @param [in] CHAR *pcDataBuf RTSP 
* @param [in] INT lBufLen RTSP ݴС
* @return VOID
* @note ע:úڲʵֱ ʱֻ̣򵥿 TCPʽʱýӿЧ
*/
typedef VOID (*IMCP_RM_RTSPDATA_OUTPUT_PF)(IN ULONG ulSessionNo, IN CHAR *pcDataBuf, IN INT lBufLen);

/**
* ⲿģṩRMģUniview JPEGص \n
* @param [in] CHAR *pcDataBuf uniview jpeg
* @param [in] INT lBufLen uniview jpegݴС
* @return VOID
* @note ע:úڲʵֱ ʱֻ̣򵥿 univiewʽʱýӿЧ
*/
typedef VOID (*IMCP_RM_UNVDATA_OUTPUT_PF)(IN ULONG ulSessionNo, IN CHAR *pcDataBuf, IN INT lBufLen);

/**
* ⲿģṩRMģĻỰ״̬ص \n
* @param [in] ULONG ulSessionNo Ự
* @param [in] IMCP_RM_ERROR_TYPE_E enErrorType ״̬
* @return ULONG
* @note 
*/
typedef VOID (*IMCP_RM_ERROR_REPORT_PF)(IN ULONG ulSessionNo, IN IMCP_RM_ERROR_TYPE_E enErrorType);

/**
* RMģ־LOGص \n
* @param [in] ULONG ulLogLevel  ӡ
* @param [in] char *pszFileName ļ
* @param [in] ULONG ulLineNo    к
* @param [in] const char *pszFmt, ... ɱ ַ
* @return VOID
* @note ulLogLevel:DEBUG=1 INFO=2 WARNING=3 ERROR=4
*/
typedef VOID (*IMCP_RM_SYS_LOG_PF)(IN ULONG ulLogLevel, IN const char *pszFileName, 
                                   IN ULONG ulLineNo, IN const char *pszFmt, ...);

/**
* RTSP ͨģ  RMģʼ \n
* @param [in] ULONG ulMaxSession Ự
* @param [in] IMCP_RM_ERROR_REPORT_PF pfErrorReportFunction Ự󱨸ص
* @param [in] IMCP_RM_RTSPDATA_OUTPUT_PF pfRtspDataOutputFunction RTSP ص
* @param [in] IMCP_RM_UNVDATA_OUTPUT_PF pfUnvDataOutputFunction   Uniview JPEGص
* @param [in] IMCP_RM_SYS_LOG_PF pfSysLogFunction ־ص
* @return ½
* - EZR_COMMON_SUCCEED  ɹ
* - EZR_COMMON_FAILED     ʧ
* - EZR_COMMON_INVALID_PARAM 
* @note  
*/
IMCP_EXPORT ULONG STDCALL IMCP_RM_Init(IN ULONG ulMaxSession,
                                       IN IMCP_RM_ERROR_REPORT_PF pfErrorReportFunction,
                                       IN IMCP_RM_RTSPDATA_OUTPUT_PF pfRtspDataOutputFunction,
                                       IN IMCP_RM_UNVDATA_OUTPUT_PF pfUnvDataOutputFunction,
                                       IN IMCP_RM_SYS_LOG_PF pfSysLogFunction);

/**
* RTSP ͨģ  RMģ鷴ʼ \n
* @return ½NO
* @note  
*/
IMCP_EXPORT VOID STDCALL IMCP_RM_Cleanup();

/**
* RTSP ͨģ   \n
* @param [in] CHAR *pcURL             URI
* @param [in] IMCP_RM_STREAM_TYPE_E   enStreamType 
* @param [in] CHAR *pcDestIpAddr      udpĿip  ĬϱΪ:""
* @param [in] USHORT usRecvPort       udpն˿
* @param [in] BOOL_T bKeepAlive       ǷҪ
* @param [out] ULONG *pulSessionNo    Ự
* @param [out] CHAR *pcSessionID      ỰID
* @return ½
* - EZR_COMMON_SUCCEED  ɹ
* - EZR_COMMON_FAILED     ʧ
* - EZR_COMMON_STREAMNUM_FULL  
* - EZR_COMMON_INVALID_PARAM 
* - EZR_COMMON_STREAM_IN_PROCESS /رУ
* - EZR_COMMON_NET_FAILED  ͨŴ
* - EZR_COMMON_NET_TIMEOUT  糬ʱ
* - EZR_COMMON_SHAKE_ERROR  罻
* @note  1.ǰ ÿ洢ͨӦ1Ự
*          SessionIDڴ IMCP_RM_SESSIONID_LEN 64
*        2.enStreamType֧֡ģʽ&͡ϲʽȡenStreamType16λǰ2λʾģʽ14λʾ xx xxxxxxxxxxxxxx
*          ģʽƵ(IMCP_RM_STREAM_ONLY_VIDEO)Ƶ(IMCP_RM_STREAM_ONLY_AUDIO)Ƶ+Ƶ(ֵ)
*          ͣο# IMCP_RM_STREAM_TYPE_E
*          ˵ģʽ&͡ΪƵ&UDP·enStreamTypeΪ0x8001Ʊʾ10 00000000000001
*          ȡģʽ10 00000000000000жΪƵȡ00 00000000000001жΪUDP
*          ȱݣƵģʽݲ֧֣IPC֧֡ƵNDPlayer֧֡Ƶ¼
*        3.fSpeedΪٶȣIMCP_RM_PLAY_SCALE_Eö٣ٶֵΪ1.0
*/
IMCP_EXPORT ULONG STDCALL IMCP_RM_StartStream(IN CHAR *pcURL,
                                              IN IMCP_RM_STREAM_TYPE_E enStreamType,
                                              IN CHAR *pcDestIpAddr,
                                              IN USHORT usRecvPort,
                                              IN BOOL_T bKeepAlive,
                                              OUT ULONG *pulSessionNo,
                                              OUT CHAR szSessionID[IMCP_RM_SESSIONID_LEN]);

/**
* RTSP ͨģ ȡȨϢ\n
* @param [in] CHAR *pcURL             URI
* @param [in] IMCP_RM_STREAM_TYPE_E   enStreamType 
* @param [in] CHAR *pcDestIpAddr      udpĿip  ĬϱΪ:""
* @param [in] USHORT usRecvPort       udpն˿
* @param [in] BOOL_T bKeepAlive       ǷҪ
* @param [in] ULONG ulSessionType     Ự,μ#RM_SESSION_TYPE_E
* @param [in] ULONG ulBufferLen       ȨС
* @param [in] IN IMCP_RM_RTSP_EXECUTE_TYPE_E enRtspExecuteType      RTSPִģʽο# IMCP_RM_RTSP_EXECUTE_TYPE_E
* @param [inout] CHAR *pcAuthenticateInfo ȨϢʧʱؼȨֶΣ´εʱдȨϢ
* @param [inout] ULONG *pulSessionNo    Ựţһεд0xFFFFFFFFҪȨʱ¼˻Ựţ´μȨʱд˻Ự
* @param [out] CHAR *pcSessionID      ỰID
* @return ½
* - EZR_COMMON_SUCCEED              ɹ
* - EZR_COMMON_NEED_AUTHENTICATE    ҪȨ
* - EZR_COMMON_FAILED               ʧ
* - EZR_COMMON_STREAMNUM_FULL       
* - EZR_COMMON_INVALID_PARAM        
* - EZR_COMMON_STREAM_IN_PROCESS    /رУ
* - EZR_COMMON_NET_FAILED           ͨŴ
* - EZR_COMMON_NET_TIMEOUT          糬ʱ
* - EZR_COMMON_SHAKE_ERROR          罻
* @note  1.ʧΪEZR_COMMON_NEED_AUTHENTICATEҪȨʱ뱣pulSessionNo´εʱҪд
*         SessionIDڴIMCP_RM_SESSIONID_LEN 64
*         Windows 32λ
*        2.enStreamType֧֡ģʽ&͡ϲʽȡenStreamType16λǰ2λʾģʽ14λʾ xx xxxxxxxxxxxxxx
*          ģʽƵ(IMCP_RM_STREAM_ONLY_VIDEO)Ƶ(IMCP_RM_STREAM_ONLY_AUDIO)Ƶ+Ƶ(ֵ)
*          ͣο# IMCP_RM_STREAM_TYPE_E
*          ˵ģʽ&͡ΪƵ&UDP·enStreamTypeΪ0x8001Ʊʾ10 00000000000001
*          ȡģʽ10 00000000000000жΪƵȡ00 00000000000001жΪUDP
*          ȱݣƵģʽݲ֧֣IPC֧֡ƵNDPlayer֧֡Ƶ¼
*/
#ifdef WIN32
IMCP_EXPORT ULONG STDCALL IMCP_RM_StartStreamCatchAuthenticate(IN CHAR *pcURL,
                                                               IN IMCP_RM_STREAM_TYPE_E enStreamType,
                                                               IN CHAR *pcDestIpAddr,
                                                               IN USHORT usRecvPort,
                                                               IN BOOL_T bKeepAlive,
                                                               IN ULONG ulSessionType,
                                                               IN ULONG ulBufferLen,
                                                               IN IMCP_RM_RTSP_EXECUTE_TYPE_E enRtspExecuteType, 
                                                               INOUT CHAR *pcAuthenticateInfo,
                                                               INOUT ULONG *pulSessionNo,
                                                               OUT CHAR szSessionID[IMCP_RM_SESSIONID_LEN]);
#endif

/**
* RTSP ͨģ   չ \n
* @param [in] CHAR *pcURL             URI,ʽ:rtsp://username:password@ip:port/xxxxxxxxxxxx
* @param [in] IMCP_RM_STREAM_TYPE_E   enStreamType 
* @param [in] CHAR *pcDestIpAddr      udpĿip  ĬϱΪ:""
* @param [in] USHORT usRecvPort       udpն˿
* @param [in] BOOL_T bKeepAlive       ǷҪ
* @param [in] IN FLOAT fSpeed         ٶ
* @param [in] IN TIME_T tiStartPlayTime ʼʱ
* @param [in] IN TIME_T tiEndPlayTime ʱ
* @param [in] IN IMCP_RM_ERROR_REPORT_PF pfErrorReportFunction      ϱص
* @param [in] IN IMCP_RM_RTSPDATA_OUTPUT_PF pfStreamOutputFunction  ϱص
* @param [in] IN IMCP_RM_RTSP_EXECUTE_TYPE_E enRtspExecuteType      RTSPִģʽο# IMCP_RM_RTSP_EXECUTE_TYPE_E
* @param [out] ULONG *pulSessionNo    Ự
* @param [out] CHAR *pcSessionID      ỰID
* @return ½
* - EZR_COMMON_SUCCEED  ɹ
* - EZR_COMMON_FAILED     ʧ
* - EZR_COMMON_STREAMNUM_FULL  
* - EZR_COMMON_INVALID_PARAM 
* - EZR_COMMON_STREAM_IN_PROCESS /رУ
* - EZR_COMMON_NET_FAILED  ͨŴ
* - EZR_COMMON_NET_TIMEOUT  糬ʱ
* - EZR_COMMON_SHAKE_ERROR  罻
* @note  1.ǰ ÿ洢ͨӦ1Ự
*         SessionIDڴ IMCP_RM_SESSIONID_LEN 64
*        2.enStreamType֧֡ģʽ&͡ϲʽȡenStreamType16λǰ2λʾģʽ14λʾ xx xxxxxxxxxxxxxx
*          ģʽƵ(IMCP_RM_STREAM_ONLY_VIDEO)Ƶ(IMCP_RM_STREAM_ONLY_AUDIO)Ƶ+Ƶ(ֵ)
*          ͣο# IMCP_RM_STREAM_TYPE_E
*          ˵ģʽ&͡ΪƵ&UDP·enStreamTypeΪ0x8001Ʊʾ10 00000000000001
*          ȡģʽ10 00000000000000жΪƵȡ00 00000000000001жΪUDP
*          ȱݣƵģʽݲ֧֣IPC֧֡ƵNDPlayer֧֡Ƶ¼
*        3.fSpeedΪٶȣIMCP_RM_PLAY_SCALE_Eö٣ٶֵΪ1.0
*/
IMCP_EXPORT ULONG STDCALL IMCP_RM_StartStreamEx2(IN CHAR *pcURL,
                                                 IN IMCP_RM_STREAM_TYPE_E enStreamType,
                                                 IN CHAR *pcDestIpAddr, 
                                                 IN USHORT usRecvPort,
                                                 IN BOOL_T bKeepAlive,
                                                 IN FLOAT fSpeed,
                                                 IN TIME_T tiStartPlayTime,
                                                 IN TIME_T tiEndPlayTime,
                                                 IN IMCP_RM_ERROR_REPORT_PF pfErrorReportFunction,
                                                 IN IMCP_RM_RTSPDATA_OUTPUT_PF pfStreamOutputFunction,
                                                 IN IMCP_RM_RTSP_EXECUTE_TYPE_E enRtspExecuteType,
                                                 OUT ULONG *pulSessionNo,
                                                 OUT CHAR szSessionID[IMCP_RM_SESSIONID_LEN]);

/**
* RTSP ͨģ  ȡsession׽ \n
* @param [in] ulSessionNo Ự
* @param [out] phSessionSocket  ׽
* @return ½
* - EZR_COMMON_SUCCEED  ɹ
* - EZR_COMMON_FAILED     ʧ
* @note  
*/
IMCP_EXPORT ULONG STDCALL IMCP_RM_GetSendSocket(IN ULONG ulSessionNo, OUT ULONG *phSessionSocket);

/**
* RTSP ͨģ  ֹͣ \n
* @param [in] ulSessionNo Ự
* @return ½
* - EZR_COMMON_SUCCEED  ɹ
* - EZR_COMMON_FAILED     ʧ
* - EZR_COMMON_INVALID_PARAM 
* - EZR_COMMON_STREAM_IN_PROCESS /رУ
* - EZR_COMMON_NET_FAILED  ͨŴ
* - EZR_COMMON_NET_TIMEOUT  糬ʱ
* - EZR_COMMON_SHAKE_ERROR  罻
* @note  
*/
IMCP_EXPORT ULONG STDCALL IMCP_RM_StopStream(IN ULONG ulSessionNo);

/**
* RTSP ͨģ  ͣ \n
* @param [in] ulSessionNo Ự
* @return ½
* - EZR_COMMON_SUCCEED  ɹ
* - EZR_COMMON_FAILED     ʧ
* - EZR_COMMON_INVALID_PARAM 
* - EZR_COMMON_STREAM_IN_PROCESS /رУ
* @note  
*/
IMCP_EXPORT ULONG STDCALL IMCP_RM_PauseStream(IN ULONG ulSessionNo);

/**
* RTSP ͨģ   \n
* @param [in] ulSessionNo Ự
* @param [in] IMCP_RM_PLAY_SCALE_E enScale  ٶȱ
* @return ½
* - EZR_COMMON_SUCCEED  ɹ
* - EZR_COMMON_FAILED     ʧ
* - EZR_COMMON_INVALID_PARAM 
* @note  Play & DragPlay & ScalePlay
*/
IMCP_EXPORT ULONG STDCALL IMCP_RM_PlayStream(IN ULONG ulSessionNo,
                                             IN IMCP_RM_PLAY_SCALE_E enScale);

/**
* RTSP ͨģ  ûطʱ \n
* @param [in] ulSessionNo Ự
* @param [in] TIME_T tiPlayTime ʱ
* @return ½
* - EZR_COMMON_SUCCEED  ɹ
* - EZR_COMMON_FAILED     ʧ
* - EZR_COMMON_INVALID_PARAM 
* @note  
*/
IMCP_EXPORT ULONG STDCALL IMCP_RM_SetPlayTime(IN ULONG ulSessionNo,
                                              IN TIME_T tiPlayTime);

/**
* RTSP ͨģ  ͬʱ޸ĲٶȺʱ \n
* @param [in] ulSessionNo Ự
* @param [in] IMCP_RM_PLAY_SCALE_E enScale  ٶȱ߱ٽʹó֡I֡ģʽ
* @param [in] TIME_T tiPlayTime ʱ
* @return ½
* - EZR_COMMON_SUCCEED  ɹ
* - EZR_COMMON_FAILED     ʧ
* - EZR_COMMON_INVALID_PARAM 
* @note
*/
IMCP_EXPORT ULONG STDCALL IMCP_RM_PlayStreamWithTime(IN ULONG ulSessionNo,
                                                     IN IMCP_RM_PLAY_SCALE_E enScale,
                                                     IN TIME_T tiPlayTime);

/**
* RTSP ͨģ  ȡطʱ \n
* @param [in] ulSessionNo Ự
* @param [out] OUT TIME_T *ptiPlayTime ʱ
* @return ½
* - EZR_COMMON_SUCCEED  ɹ
* - EZR_COMMON_FAILED     ʧ
* - EZR_COMMON_INVALID_PARAM 
* @note  
*/
IMCP_EXPORT ULONG STDCALL IMCP_RM_GetPlayTime(IN ULONG ulSessionNo,
                                              OUT TIME_T *ptiPlayTime);

/**
* RTSP ͨģ  ý \n
* @param [in] ULONG ulSessionNo     Ự
* @param [in] CHAR *pcPassword      
* @return ½
* - EZR_COMMON_SUCCEED  ɹ
* - EZR_COMMON_FAILED     ʧ
* - EZR_COMMON_INVALID_PARAM 
* @note  
*/
IMCP_EXPORT ULONG STDCALL IMCP_RM_SetPassword(IN ULONG ulSessionNo,
                                              OUT CHAR *pcPassword);

/**
* RTSP ͨģ  ȡSourceIPPort \n
* @param [in] ULONG ulSessionNo        Ự
* @param [out] OUT USHORT *pusPortS    豸ʼ˿
* @param [out] OUT USHORT *pusPortE    豸˿
* @param [out]  OUT CHAR *pcSourceAdrr 豸IP
* @return ½
* - EZR_COMMON_SUCCEED  ɹ
* - EZR_COMMON_FAILED     ʧ
* - EZR_COMMON_INVALID_PARAM 
* @note 
* 豸IPɵ߷洢ռ
* SourceAdrr ڴ EZR_MA_IPADDR_LEN 64
*/
IMCP_EXPORT ULONG STDCALL IMCP_RM_GetPortWithIP(IN ULONG ulSessionNo,
                                                OUT USHORT *pusPortS,
                                                OUT USHORT *pusPortE,
                                                OUT CHAR *pcSourceAdrr);

/**
* RTSP ͨģ  ȡpayloadֵ \n
* @param [IN] ULONG ulSessionNo     Ự
* @param [INOUT] ULONG *ulNum       ý
* @param [OUT] IMCP_RM_PAYLOAD_TYPE_S *pstPayloadType     Ϣṹָ
* @return ½
* - EZR_COMMON_SUCCEED  ɹ
* - EZR_COMMON_FAILED     ʧ
* - EZR_COMMON_INVALID_PARAM 
* @note  
*/
IMCP_EXPORT ULONG STDCALL IMCP_RM_GetPayloadType(IN ULONG ulSessionNo, 
                                                 INOUT ULONG *pulNum,
                                                 OUT IMCP_RM_PAYLOAD_TYPE_S *pstPayloadType);

/**
* RTSP ͨģ  ȡƵϢ \n
* @param [IN] ULONG ulSessionNo     Ự
* @param [OUT] IMCP_RM_AUDIO_INFO_S *pstAudioInfo     ƵϢṹ
* @return ½
* - EZR_COMMON_SUCCEED  ɹ
* - EZR_COMMON_FAILED     ʧ
* - EZR_COMMON_INVALID_PARAM 
* @note  
*/
IMCP_EXPORT ULONG STDCALL IMCP_RM_GetAudioInfo(IN ULONG ulSessionNo, OUT IMCP_RM_AUDIO_INFO_S *pstAudioInfo);

/**
* RTSP ͨģ  ȡSessionID \n
* @param [OUT] ULONG *pulSessionNo  Ự
* @return
* - EZR_COMMON_SUCCEED  ɹ
* - οֵ
* @note
*/
IMCP_EXPORT ULONG STDCALL IMCP_RM_GetSpareSessionNo(OUT ULONG *pulSessionNo);

/**
* RTSP ͨģ   (ҪȻȡSessionID) \n
* @param [IN] ULONG ulSessionNo                                     Ự
* @param [IN] CHAR *pcURL                                           URI
* @param [IN] IMCP_RM_STREAM_TYPE_E                                 enStreamType 
* @param [IN] CHAR *pcDestIpAddr                                    udpĿip  ĬϱΪ:""
* @param [IN] USHORT usRecvPort                                     udpն˿
* @param [IN] BOOL_T bKeepAlive                                     ǷҪ
* @param [IN] IN FLOAT fSpeed                                       ٶ
* @param [IN] IN TIME_T tiStartPlayTime                             ʼʱ
* @param [IN] IN TIME_T tiEndPlayTime                               ʱ
* @param [IN] IN IMCP_RM_ERROR_REPORT_PF pfErrorReportFunction      ϱص
* @param [IN] IN IMCP_RM_RTSPDATA_OUTPUT_PF pfStreamOutputFunction  ϱص
* @param [IN] IN IMCP_RM_RTSP_EXECUTE_TYPE_E enRtspExecuteType      RTSPִģʽο# IMCP_RM_RTSP_EXECUTE_TYPE_E
* @param [OUT] CHAR *pcSessionID                                    ỰID
* @return
* - EZR_COMMON_SUCCEED  ɹ
* - οֵ
* @note
* 1.ǰ ÿ洢ͨӦ1Ự SessionIDڴ IMCP_RM_SESSIONID_LEN 64
* 2.enStreamType֧֡ģʽ&͡ϲʽȡenStreamType16λǰ2λʾģʽ14λʾ xx xxxxxxxxxxxxxx
*  ģʽƵ(IMCP_RM_STREAM_ONLY_VIDEO)Ƶ(IMCP_RM_STREAM_ONLY_AUDIO)Ƶ+Ƶ(ֵ)
*  ͣο# IMCP_RM_STREAM_TYPE_E
*  ˵ģʽ&͡ΪƵ&UDP·enStreamTypeΪ0x8001Ʊʾ10 00000000000001
*  ȡģʽ10 00000000000000жΪƵȡ00 00000000000001жΪUDP
*  ȱݣƵģʽݲ֧֣IPC֧֡ƵNDPlayer֧֡Ƶ¼
*/
IMCP_EXPORT ULONG STDCALL IMCP_RM_StartStreamBySession(IN ULONG ulSessionNo,
                                                       IN CHAR *pcURL,
                                                       IN IMCP_RM_STREAM_TYPE_E enStreamType,
                                                       IN CHAR *pcDestIpAddr, 
                                                       IN USHORT usRecvPort,
                                                       IN BOOL_T bKeepAlive,
                                                       IN FLOAT fSpeed,
                                                       IN TIME_T tiStartPlayTime,
                                                       IN TIME_T tiEndPlayTime,
                                                       IN IMCP_RM_ERROR_REPORT_PF pfErrorReportFunction,
                                                       IN IMCP_RM_RTSPDATA_OUTPUT_PF pfStreamOutputFunction,
                                                       IN IMCP_RM_RTSP_EXECUTE_TYPE_E enRtspExecuteType,
                                                       OUT CHAR szSessionID[IMCP_RM_SESSIONID_LEN]);

/**
* RTSP ͨģ  ӳ\n
* @param [IN] CHAR *pcURL                                           URI
* @param [IN] IMCP_RM_STREAM_TYPE_E                                 enStreamType 
* @param [IN] CHAR *pcDestIpAddr                                    udpĿip  ĬϱΪ:""
* @param [IN] USHORT usRecvPort                                     udpն˿
* @param [IN] USHORT usExPort                                       udpⲿ˿
* @param [IN] BOOL_T bKeepAlive                                     ǷҪ
* @param [IN] IN FLOAT fSpeed                                       ٶ
* @param [IN] IN TIME_T tiStartPlayTime                             ʼʱ
* @param [IN] IN TIME_T tiEndPlayTime                               ʱ
* @param [IN] IN IMCP_RM_ERROR_REPORT_PF pfErrorReportFunction      ϱص
* @param [IN] IN IMCP_RM_RTSPDATA_OUTPUT_PF pfStreamOutputFunction  ϱص
* @param [IN] IN IMCP_RM_RTSP_EXECUTE_TYPE_E enRtspExecuteType      RTSPִģʽο# IMCP_RM_RTSP_EXECUTE_TYPE_E
* @param [OUT] CHAR *pcSessionID                                    ỰID
* @return
* - EZR_COMMON_SUCCEED  ɹ
* - οֵ
* @note
* 1.ǰ ÿ洢ͨӦ1Ự SessionIDڴ IMCP_RM_SESSIONID_LEN 64
* 2.enStreamType֧֡ģʽ&͡ϲʽȡenStreamType16λǰ2λʾģʽ14λʾ xx xxxxxxxxxxxxxx
*  ģʽƵ(IMCP_RM_STREAM_ONLY_VIDEO)Ƶ(IMCP_RM_STREAM_ONLY_AUDIO)Ƶ+Ƶ(ֵ)
*  ͣο# IMCP_RM_STREAM_TYPE_E
*  ˵ģʽ&͡ΪƵ&UDP·enStreamTypeΪ0x8001Ʊʾ10 00000000000001
*  ȡģʽ10 00000000000000жΪƵȡ00 00000000000001жΪUDP
*  ȱݣƵģʽݲ֧֣IPC֧֡ƵNDPlayer֧֡Ƶ¼
* 3.fSpeedΪٶȣIMCP_RM_PLAY_SCALE_Eö٣ٶֵΪ1.0
*/
IMCP_EXPORT ULONG STDCALL IMCP_RM_StartStreamWan(IN CHAR *pcURL,
                                                 IN IMCP_RM_STREAM_TYPE_E enStreamType,
                                                 IN CHAR *pcDestIpAddr, 
                                                 IN USHORT usExPort,
                                                 IN USHORT usRecvPort,
                                                 IN BOOL_T bKeepAlive,
                                                 IN FLOAT fSpeed,
                                                 IN TIME_T tiStartPlayTime,
                                                 IN TIME_T tiEndPlayTime,
                                                 IN IMCP_RM_ERROR_REPORT_PF pfErrorReportFunction,
                                                 IN IMCP_RM_RTSPDATA_OUTPUT_PF pfStreamOutputFunction,
                                                 IN IMCP_RM_RTSP_EXECUTE_TYPE_E enRtspExecuteType,
                                                 OUT ULONG *pulSessionNo,
                                                 OUT CHAR szSessionID[IMCP_RM_SESSIONID_LEN]);

/**
* RTSP ͨģ òٶ \n
* @param [IN] ULONG ulSessionNo             Ự
* @param [IN] IMCP_RM_PLAY_SCALE_E enScale  ٶȱ߱ٽʹó֡I֡ģʽ
* @return
* - EZR_COMMON_SUCCEED              ɹ
* - EZR_COMMON_FAILED               ʧ
* - ļ
*/
IMCP_EXPORT ULONG STDCALL IMCP_RM_SetStreamSpeed(IN ULONG ulSessionNo, IN IMCP_RM_PLAY_SCALE_E enScale);

/**
* RTSP ͨģ òٶ \n
* @param [IN] ULONG ulSessionNo     Ự
* @param [IN] TIME_T tiPlayTime     ʱ
* @return
* - EZR_COMMON_SUCCEED              ɹ
* - EZR_COMMON_FAILED               ʧ
* - ļ
*/
IMCP_EXPORT ULONG STDCALL IMCP_RM_SetStreamTime(IN ULONG ulSessionNo, IN TIME_T tiPlayTime);

/**
* RTSP ͨģ õ֡ڵǰʱ䣩 \n
* @param [IN] ULONG ulSessionNo     Ự
* @param [IN] BOOL_T bForward       ǰ־TUREʾǰFALSEʾˣ
* @return
* - EZR_COMMON_SUCCEED              ɹ
* - EZR_COMMON_FAILED               ʧ
* - ļ
*/
IMCP_EXPORT ULONG STDCALL IMCP_RM_SetStreamOneframe(IN ULONG ulSessionNo, IN BOOL_T bForward);

/**
* RTSP ͨģ õ֡ضʱ㵥֡ \n
* @param [IN] ULONG ulSessionNo     Ự
* @param [IN] TIME_T tiPlayTime     ʱ
* @return
* - EZR_COMMON_SUCCEED              ɹ
* - EZR_COMMON_FAILED               ʧ
* - ļ
*/
IMCP_EXPORT ULONG STDCALL IMCP_RM_SetStreamOneframeWithTime(IN ULONG ulSessionNo, IN TIME_T tiPlayTime);

/**
* RTSP ͨģ òŻָ \n
* @param [IN] ULONG ulSessionNo     Ự
* @return
* - EZR_COMMON_SUCCEED              ɹ
* - EZR_COMMON_FAILED               ʧ
* - ļ
*/
IMCP_EXPORT ULONG STDCALL IMCP_RM_SetStreamResume(IN ULONG ulSessionNo);

/**
* RTSP ͨģ  䣩\n
* @param [IN] LONG lSessionNo                                       Ựţ˵note2
* @param [IN] CHAR *pcURL                                           URI,ʽ:rtsp://username:password@ip:port/xxxxxxxxxxxx
* @param [IN] IMCP_RM_STREAM_TYPE_E enStreamType                    
* @param [IN] CHAR *pcDestIpAddr                                    udpĿip  ĬϱΪ:""
* @param [IN] USHORT usRecvPort                                     udpն˿
* @param [IN] USHORT usExPort                                       udpӳ˿
* @param [IN] BOOL_T bKeepAlive                                     ǷҪ
* @param [IN] IN IMCP_RM_PLAY_SCALE_E eSpeed                        ٶ
* @param [IN] IN TIME_T tiStartPlayTime                             ʼʱ
* @param [IN] IN TIME_T tiEndPlayTime                               ʱ
* @param [IN] IN IMCP_RM_ERROR_REPORT_PF pfErrorReportFunction      ϱص
* @param [IN] IN IMCP_RM_RTSPDATA_OUTPUT_PF pfStreamOutputFunction  ϱص
* @param [IN] IN IMCP_RM_RTSP_EXECUTE_TYPE_E enRtspExecuteType      RTSPִģʽο# IMCP_RM_RTSP_EXECUTE_TYPE_E
* @param [out] ULONG *pulSessionNo                                  Ự
* @param [OUT] CHAR *pcSessionID                                    ỰID
* @return
* - EZR_COMMON_SUCCEED  ɹ
* - οֵ
* @note
* 1.ΪӿڣIMCP_RM_StartStreamEx2, IMCP_RM_StartStreamBySession, IMCP_RM_StartStreamWanӿһ
* 2.lSessionNo˽ӿ֧ͨSessionֱٻȡSessionַʽ£
*   IMCP_RM_GetSpareSessionNoȡSessionźô˽ӿʱlSessionNo贫ȡSession
*   Ҳֱӵô˽ӿɹSessionͨpulSessionNoأʱlSession贫-1
* 3.ǰ ÿ洢ͨӦ1Ự SessionIDڴ IMCP_RM_SESSIONID_LEN 64
* 4.enStreamType֧֡ģʽ&͡ϲʽȡenStreamType16λǰ2λʾģʽ14λʾ xx xxxxxxxxxxxxxx
*  ģʽƵ(IMCP_RM_STREAM_ONLY_VIDEO)Ƶ(IMCP_RM_STREAM_ONLY_AUDIO)Ƶ+Ƶ(ֵ)
*  ͣο# IMCP_RM_STREAM_TYPE_E
*  ˵ģʽ&͡ΪƵ&UDP·enStreamTypeΪ0x8001Ʊʾ10 00000000000001
*  ȡģʽ10 00000000000000жΪƵȡ00 00000000000001жΪUDP
*  ȱݣƵģʽݲ֧֣IPC֧֡ƵNDPlayer֧֡Ƶ¼
* 5.usRecvPortusExPortudpʱõֱΪudpն˿ںӳ˿ڣӳӳ˿Ӧն˿ͬ
*/
IMCP_EXPORT ULONG STDCALL IMCP_RM_StartStreamV2(IN LONG lSessionNo,
                                                IN CHAR *pcURL,
                                                IN IMCP_RM_STREAM_TYPE_E enStreamType,
                                                IN CHAR *pcDestIpAddr, 
                                                IN USHORT usExPort,
                                                IN USHORT usRecvPort,
                                                IN BOOL_T bKeepAlive,
                                                IN IMCP_RM_PLAY_SCALE_E eSpeed,
                                                IN TIME_T tiStartPlayTime,
                                                IN TIME_T tiEndPlayTime,
                                                IN IMCP_RM_ERROR_REPORT_PF pfErrorReportFunction,
                                                IN IMCP_RM_RTSPDATA_OUTPUT_PF pfStreamOutputFunction,
                                                IN IMCP_RM_RTSP_EXECUTE_TYPE_E enRtspExecuteType,
                                                OUT ULONG *pulSessionNo,
                                                OUT CHAR szSessionID[IMCP_RM_SESSIONID_LEN]);

/**
* RTSP ͨģ ù˽Կ \n
* @param [IN] pstRsaInfo            RSAϢ
* @return
* - EZR_COMMON_SUCCEED              ɹ
* - EZR_COMMON_FAILED               ʧ
* - ļ
*/
IMCP_EXPORT ULONG STDCALL IMCP_RM_SetRsaKey(IN IMCP_RM_RSA_INFO_S *pstRsaInfo);

/**
* RTSP ͨģ ȡ˽Կ \n
* @param [INOUT] pstRsaInfo         RSAϢ
* @return
* - EZR_COMMON_SUCCEED              ɹ
* - EZR_COMMON_FAILED               ʧ
* - ļ
*/
IMCP_EXPORT ULONG STDCALL IMCP_RM_GetRsaKey(INOUT IMCP_RM_RSA_INFO_S *pstRsaInfo);

/**
* RTSP ͨģ ѯͨǷֹ֧ \n
* @param [IN] ULONG ulSessionNo     Ự
* @param [IN] INOUT IMCP_RM_FUNC_SUP_INFO_S *pstFuncInfo    Ϣ
* @return
* - EZR_COMMON_SUCCEED              ɹ
* - EZR_COMMON_FAILED               ʧ
* - ļ
*/
IMCP_EXPORT ULONG STDCALL IMCP_RM_IsSupport(IN ULONG ulSessionNo, INOUT IMCP_RM_FUNC_SUP_INFO_S *pstFuncInfo);

/**
* RTSP ͨģ ȡUPNPӳĶ˿ںIP \n
* @param [IN] CONST CHAR *proto         ʹõЭTCP/UDP
* @param [IN] CONST CHAR *pcRemoteIP    IP
* @param [IN] CONST USHORT usLocalPort  ڲ˿
* @return
* - EZR_COMMON_SUCCEED              ɹ
* - EZR_COMMON_FAILED               ʧ
* - ļ
*/
IMCP_EXPORT ULONG STDCALL IMCP_RM_GetUpnpExIPAndExPort(IN CONST CHAR *proto,
                                                       IN CONST CHAR *pcRemoteIP, 
                                                       IN CONST USHORT usLocalPort);

/**
* RTSP ͨģ ӳɾӳ䵫δʹõĶ˿\n
* @param [IN] CHAR *azLocalIP     IP
* @return
* - EZR_COMMON_SUCCEED              ɹɾһӳ˿ڣ
* - EZR_COMMON_FAILED               ʧ(δɾӳĶ˿ڶʹ)
* - ļ
*/
IMCP_EXPORT ULONG STDCALL IMCP_FreeExternalPort( IN CHAR *pcLocalIP);

#ifdef  __cplusplus
}
#endif /* end of __cplusplus */

#endif   /* __EZR_RM_EX_H__ */

