# MultiMedia\_MediaCommon<a name="ZH-CN_TOPIC_0000001055678046"></a>

## **Overview**<a name="section1916393949084827"></a>

Provides data types and media formats required for recording and playing audio and videos. 

**Since:**

1.0

**Version:**

1.0

## **Summary**<a name="section1676009426084827"></a>

## Files<a name="files"></a>

<a name="table817776964084827"></a>
<table><thead align="left"><tr id="row991566946084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2068275732084827"><a name="p2068275732084827"></a><a name="p2068275732084827"></a>File Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p926437027084827"><a name="p926437027084827"></a><a name="p926437027084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row188450381084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2009664976084827"><a name="p2009664976084827"></a><a name="p2009664976084827"></a><a href="format-h.md">format.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p186054862084827"><a name="p186054862084827"></a><a name="p186054862084827"></a>Declares the media formats provided in the Format class. </p>
</td>
</tr>
<tr id="row726967037084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1431574576084827"><a name="p1431574576084827"></a><a name="p1431574576084827"></a><a href="media_errors-h.md">media_errors.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1687475882084827"><a name="p1687475882084827"></a><a name="p1687475882084827"></a>Declares the <strong id="b46568378084827"><a name="b46568378084827"></a><a name="b46568378084827"></a>media_errors</strong> class to define errors that may occur during media operations. </p>
</td>
</tr>
<tr id="row64992901084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1687449833084827"><a name="p1687449833084827"></a><a name="p1687449833084827"></a><a href="media_info-h.md">media_info.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1939947960084827"><a name="p1939947960084827"></a><a name="p1939947960084827"></a>Declares the <strong id="b581384654084827"><a name="b581384654084827"></a><a name="b581384654084827"></a>media_info</strong> class and provides various audio, video, and codec types. </p>
</td>
</tr>
<tr id="row1012608857084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1295308986084827"><a name="p1295308986084827"></a><a name="p1295308986084827"></a><a href="source-h.md">source.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p379730230084827"><a name="p379730230084827"></a><a name="p379730230084827"></a>Declares the <strong id="b1441229056084827"><a name="b1441229056084827"></a><a name="b1441229056084827"></a>Source</strong> class, which is used to implement source-related operations. </p>
</td>
</tr>
</tbody>
</table>

## Data Structures<a name="nested-classes"></a>

<a name="table1341799076084827"></a>
<table><thead align="left"><tr id="row1895537073084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1357239390084827"><a name="p1357239390084827"></a><a name="p1357239390084827"></a>Data Structure Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1196331422084827"><a name="p1196331422084827"></a><a name="p1196331422084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1149790529084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1910045023084827"><a name="p1910045023084827"></a><a name="p1910045023084827"></a><a href="OHOS-Media-FormatData.md">OHOS::Media::FormatData</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p545540399084827"><a name="p545540399084827"></a><a name="p545540399084827"></a>Represents the data format. </p>
</td>
</tr>
<tr id="row173718177084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p484725220084827"><a name="p484725220084827"></a><a name="p484725220084827"></a><a href="OHOS-Media-Format.md">OHOS::Media::Format</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p627627291084827"><a name="p627627291084827"></a><a name="p627627291084827"></a>Saves and sets media metadata, such as the media playback duration. </p>
</td>
</tr>
<tr id="row2064231343084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1829086945084827"><a name="p1829086945084827"></a><a name="p1829086945084827"></a><a href="AudioDeviceDesc.md">AudioDeviceDesc</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2060437737084827"><a name="p2060437737084827"></a><a name="p2060437737084827"></a>Defines the audio Device Descriptor. </p>
</td>
</tr>
<tr id="row1476772528084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p209398253084827"><a name="p209398253084827"></a><a name="p209398253084827"></a><a href="OHOS-Media-StreamCallback.md">OHOS::Media::StreamCallback</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p849390852084827"><a name="p849390852084827"></a><a name="p849390852084827"></a>Provides functions to obtain the address of a buffer memory and write the filled buffers into the playback queue. You need to implement the <strong id="b1983208394084827"><a name="b1983208394084827"></a><a name="b1983208394084827"></a><a href="OHOS-Media-StreamCallback.md">StreamCallback</a></strong> functions in a player object. </p>
</td>
</tr>
<tr id="row1738471904084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p715071265084827"><a name="p715071265084827"></a><a name="p715071265084827"></a><a href="OHOS-Media-StreamSource.md">OHOS::Media::StreamSource</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p939133967084827"><a name="p939133967084827"></a><a name="p939133967084827"></a>Provides functions related to the stream source for upper-layer applications. </p>
</td>
</tr>
<tr id="row717165486084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1528188158084827"><a name="p1528188158084827"></a><a name="p1528188158084827"></a><a href="OHOS-Media-Source.md">OHOS::Media::Source</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1337165028084827"><a name="p1337165028084827"></a><a name="p1337165028084827"></a>Provides functions to implement source-related operations. </p>
</td>
</tr>
</tbody>
</table>

## Enumerations<a name="enum-members"></a>

<a name="table775382237084827"></a>
<table><thead align="left"><tr id="row68679246084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1790096882084827"><a name="p1790096882084827"></a><a name="p1790096882084827"></a>Enumeration Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1469448984084827"><a name="p1469448984084827"></a><a name="p1469448984084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1655484453084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p212944375084827"><a name="p212944375084827"></a><a name="p212944375084827"></a><a href="MultiMedia_MediaCommon.md#gaa3bfacc6563d8ec8bc870f4b216b4f46">OHOS::Media::FormatDataType</a> : uint32_t { &nbsp;&nbsp;<a href="MultiMedia_MediaCommon.md#ggaa3bfacc6563d8ec8bc870f4b216b4f46a3a3f84f7e1a28c0f91a12f8a3bcfe8ec">OHOS::Media::FORMAT_TYPE_NONE</a>, <a href="MultiMedia_MediaCommon.md#ggaa3bfacc6563d8ec8bc870f4b216b4f46a48d8e70734d5c29f8766ad12037ca3ae">OHOS::Media::FORMAT_TYPE_INT32</a>, <a href="MultiMedia_MediaCommon.md#ggaa3bfacc6563d8ec8bc870f4b216b4f46a108496713fc9bb4b77a8acf38a1396c9">OHOS::Media::FORMAT_TYPE_INT64</a>, <a href="MultiMedia_MediaCommon.md#ggaa3bfacc6563d8ec8bc870f4b216b4f46a3fd208a39e6c4f22d10882b03a547db1">OHOS::Media::FORMAT_TYPE_FLOAT</a>, &nbsp;&nbsp;<a href="MultiMedia_MediaCommon.md#ggaa3bfacc6563d8ec8bc870f4b216b4f46abb224970f66920c7a443d19051fdc57f">OHOS::Media::FORMAT_TYPE_DOUBLE</a>, <a href="MultiMedia_MediaCommon.md#ggaa3bfacc6563d8ec8bc870f4b216b4f46a21c29eb61b772af7bead2a77a8c87cf6">OHOS::Media::FORMAT_TYPE_STRING</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p214732076084827"><a name="p214732076084827"></a><a name="p214732076084827"></a>Enumerates formats. </p>
</td>
</tr>
<tr id="row1575146260084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p652051002084827"><a name="p652051002084827"></a><a name="p652051002084827"></a><a href="MultiMedia_MediaCommon.md#gadc3158e093b995ca7b9b6aa32388ccdd">AudioSourceType</a> { &nbsp;&nbsp;<a href="MultiMedia_MediaCommon.md#ggadc3158e093b995ca7b9b6aa32388ccddad728113cb6300764f0131e28290706c0">AUDIO_SOURCE_INVALID</a> = -1, <a href="MultiMedia_MediaCommon.md#ggadc3158e093b995ca7b9b6aa32388ccdda159b69cc6a9b75d6fed0da3e3db9a62f">AUDIO_SOURCE_DEFAULT</a> = 0, <a href="MultiMedia_MediaCommon.md#ggadc3158e093b995ca7b9b6aa32388ccdda732604b3a24d137429e2b83b31849bce">AUDIO_MIC</a> = 1, <a href="MultiMedia_MediaCommon.md#ggadc3158e093b995ca7b9b6aa32388ccddac94b34dbaa3e19d53b34096fbcd64d8d">AUDIO_VOICE_UPLINK</a> = 2, &nbsp;&nbsp;<a href="MultiMedia_MediaCommon.md#ggadc3158e093b995ca7b9b6aa32388ccdda076ef2fc169a0b5f640e8433d77d1f45">AUDIO_VOICE_DOWNLINK</a> = 3, <a href="MultiMedia_MediaCommon.md#ggadc3158e093b995ca7b9b6aa32388ccdda3d978f472db3ff575a1b4ab84acbc15c">AUDIO_VOICE_CALL</a> = 4, <a href="MultiMedia_MediaCommon.md#ggadc3158e093b995ca7b9b6aa32388ccdda0d2b7337a260ae5c32abd843f5d52ec8">AUDIO_CAMCORDER</a> = 5, <a href="MultiMedia_MediaCommon.md#ggadc3158e093b995ca7b9b6aa32388ccdda2491fee4b6ca4dce9c05babc3c1168e8">AUDIO_VOICE_RECOGNITION</a> = 6, &nbsp;&nbsp;<a href="MultiMedia_MediaCommon.md#ggadc3158e093b995ca7b9b6aa32388ccdda09ce48df53dbaea4ef4273614bdc5445">AUDIO_VOICE_COMMUNICATION</a> = 7, <a href="MultiMedia_MediaCommon.md#ggadc3158e093b995ca7b9b6aa32388ccddaef3dbfe38c377d77d0e40a9808012981">AUDIO_REMOTE_SUBMIX</a> = 8, <a href="MultiMedia_MediaCommon.md#ggadc3158e093b995ca7b9b6aa32388ccdda2fd32b7e954f7988ae41b63167948caf">AUDIO_UNPROCESSED</a> = 9, <a href="MultiMedia_MediaCommon.md#ggadc3158e093b995ca7b9b6aa32388ccdda532f7c38a1feb89c8cb3a4e07f0c2cbe">AUDIO_VOICE_PERFORMANCE</a> = 10, &nbsp;&nbsp;<a href="MultiMedia_MediaCommon.md#ggadc3158e093b995ca7b9b6aa32388ccdda295b4d6de2ba41d7783fddbf1543e830">AUDIO_ECHO_REFERENCE</a> = 1997, <a href="MultiMedia_MediaCommon.md#ggadc3158e093b995ca7b9b6aa32388ccdda5492fbdf785a745195f80020dba4f37e">AUDIO_RADIO_TUNER</a> = 1998, <a href="MultiMedia_MediaCommon.md#ggadc3158e093b995ca7b9b6aa32388ccdda210886d5f821c08c5a36e71363d330f6">AUDIO_HOTWORD</a> = 1999, <a href="MultiMedia_MediaCommon.md#ggadc3158e093b995ca7b9b6aa32388ccddad0b4097d682e6cc4d7d92e5f0612a831">AUDIO_REMOTE_SUBMIX_EXTEND</a> = 10007 }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p214723278084827"><a name="p214723278084827"></a><a name="p214723278084827"></a>Enumerates audio source types. </p>
</td>
</tr>
<tr id="row497816649084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p481391125084827"><a name="p481391125084827"></a><a name="p481391125084827"></a><a href="MultiMedia_MediaCommon.md#gae7077e4211e48131ae544adb20fc494a">AudioStreamType</a> { &nbsp;&nbsp;<a href="MultiMedia_MediaCommon.md#ggae7077e4211e48131ae544adb20fc494aa80d7bb9558588a28f24aec4c019fdbd6">TYPE_DEFAULT</a> = -1, <a href="MultiMedia_MediaCommon.md#ggae7077e4211e48131ae544adb20fc494aa431e273affaa22e18ec5a2a548b70e90">TYPE_MEDIA</a> = 0, <a href="MultiMedia_MediaCommon.md#ggae7077e4211e48131ae544adb20fc494aa5bfd254bb72236e9c463aefeb4343194">TYPE_VOICE_COMMUNICATION</a> = 1, <a href="MultiMedia_MediaCommon.md#ggae7077e4211e48131ae544adb20fc494aa0ae2b45a2675c159915c1e76f2f2c846">TYPE_SYSTEM</a> = 2, &nbsp;&nbsp;<a href="MultiMedia_MediaCommon.md#ggae7077e4211e48131ae544adb20fc494aafe3e3697e6e9f7880cb90d40e1d4d708">TYPE_RING</a> = 3, <a href="MultiMedia_MediaCommon.md#ggae7077e4211e48131ae544adb20fc494aa801a700d4c9f12285930e9eeace6feb4">TYPE_MUSIC</a> = 4, <a href="MultiMedia_MediaCommon.md#ggae7077e4211e48131ae544adb20fc494aae93097f5314613a0eb5465187102bd5f">TYPE_ALARM</a> = 5, <a href="MultiMedia_MediaCommon.md#ggae7077e4211e48131ae544adb20fc494aa7f3c9297ca35f503b5f7b6cb36610ef6">TYPE_NOTIFICATION</a> = 6, &nbsp;&nbsp;<a href="MultiMedia_MediaCommon.md#ggae7077e4211e48131ae544adb20fc494aac47f3bf77df994414bd9514f8264e277">TYPE_BLUETOOTH_SCO</a> = 7, <a href="MultiMedia_MediaCommon.md#ggae7077e4211e48131ae544adb20fc494aa00376353eb14c2d326026e6a7cdf6674">TYPE_ENFORCED_AUDIBLE</a> = 8, <a href="MultiMedia_MediaCommon.md#ggae7077e4211e48131ae544adb20fc494aad61d97f9466b24094407016ce4231f7b">TYPE_DTMF</a> = 9, <a href="MultiMedia_MediaCommon.md#ggae7077e4211e48131ae544adb20fc494aa8e6eb63161413e4bbb207dfb29efe95f">TYPE_TTS</a> = 10, &nbsp;&nbsp;<a href="MultiMedia_MediaCommon.md#ggae7077e4211e48131ae544adb20fc494aa38333aca1beda5f77cc1ce3d0c322262">TYPE_ACCESSIBILITY</a> = 11 }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p698096372084827"><a name="p698096372084827"></a><a name="p698096372084827"></a>Enumerates audio stream types. </p>
</td>
</tr>
<tr id="row936043822084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1127018414084827"><a name="p1127018414084827"></a><a name="p1127018414084827"></a><a href="MultiMedia_MediaCommon.md#ga797e6c5e38e23e730eff5bcc41427d7e">VideoCodecFormat</a> { <a href="MultiMedia_MediaCommon.md#gga797e6c5e38e23e730eff5bcc41427d7ea54ef59464d0b6788c6212bb1b5074503">VIDEO_DEFAULT</a> = 0, <a href="MultiMedia_MediaCommon.md#gga797e6c5e38e23e730eff5bcc41427d7eac3f3371ea9f44c4076fec8f0d8f818cf">H264</a> = 2, <a href="MultiMedia_MediaCommon.md#gga797e6c5e38e23e730eff5bcc41427d7eac2489c86e2690559ce3a00a03b15c324">HEVC</a> = 5 }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p409190891084827"><a name="p409190891084827"></a><a name="p409190891084827"></a>Enumerates video codec formats. </p>
</td>
</tr>
<tr id="row704751597084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p931324873084827"><a name="p931324873084827"></a><a name="p931324873084827"></a><a href="MultiMedia_MediaCommon.md#gaa4ea6f314644ed287e0704be26c768b7">AudioCodecFormat</a> { &nbsp;&nbsp;<a href="MultiMedia_MediaCommon.md#ggaa4ea6f314644ed287e0704be26c768b7a4c4c5829b054bc468274700c56d65546">AUDIO_DEFAULT</a> = 0, <a href="MultiMedia_MediaCommon.md#ggaa4ea6f314644ed287e0704be26c768b7a9f7c5945c7d9d679395a7b06652c51ec">AAC_LC</a> = 1, <a href="MultiMedia_MediaCommon.md#ggaa4ea6f314644ed287e0704be26c768b7ac711be17b9264c9f814b11b7fcc3f1b6">AAC_HE_V1</a> = 2, <a href="MultiMedia_MediaCommon.md#ggaa4ea6f314644ed287e0704be26c768b7abf3ac142be84c7ee471a84570745a136">AAC_HE_V2</a> = 3, &nbsp;&nbsp;<a href="MultiMedia_MediaCommon.md#ggaa4ea6f314644ed287e0704be26c768b7a1ba0b2e0c3a69a989dec92fc6132d8f2">AAC_LD</a> = 4, <a href="MultiMedia_MediaCommon.md#ggaa4ea6f314644ed287e0704be26c768b7a05b8c66394143a26c66268a39115c48a">AAC_ELD</a> = 5, <a href="MultiMedia_MediaCommon.md#ggaa4ea6f314644ed287e0704be26c768b7a5945910833e0d7ff1a9ff73208d9406a">FORMAT_BUTT</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2092971210084827"><a name="p2092971210084827"></a><a name="p2092971210084827"></a>Enumerates audio codec formats. </p>
</td>
</tr>
<tr id="row1697164755084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1323758371084827"><a name="p1323758371084827"></a><a name="p1323758371084827"></a><a href="MultiMedia_MediaCommon.md#gae3e35ee2a2222a667fdebbc5b793ca7c">AudioBitWidth</a> { <a href="MultiMedia_MediaCommon.md#ggae3e35ee2a2222a667fdebbc5b793ca7cac790b3e4ae89aa667da7dad7e79df6a8">BIT_WIDTH_8</a> = 8, <a href="MultiMedia_MediaCommon.md#ggae3e35ee2a2222a667fdebbc5b793ca7ca036f0b45813f96cb6b0f90de1722a780">BIT_WIDTH_16</a> = 16, <a href="MultiMedia_MediaCommon.md#ggae3e35ee2a2222a667fdebbc5b793ca7ca3d613870d00dad5bc83927eaef3c6ade">BIT_WIDTH_24</a> = 24, <a href="MultiMedia_MediaCommon.md#ggae3e35ee2a2222a667fdebbc5b793ca7cafe508a98e81909dc5985e7edc76104d4">BIT_WIDTH_BUTT</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p833190047084827"><a name="p833190047084827"></a><a name="p833190047084827"></a>Enumerates audio bit widths. </p>
</td>
</tr>
<tr id="row647224379084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1065163295084827"><a name="p1065163295084827"></a><a name="p1065163295084827"></a><a href="MultiMedia_MediaCommon.md#ga4052b7b55dfd94f1d07678e79d80b507">OHOS::Media::SourceType</a> : int32_t { <a href="MultiMedia_MediaCommon.md#gga4052b7b55dfd94f1d07678e79d80b507ae456eda14b2359e13cc36f77af92c11b">OHOS::Media::SourceType::SOURCE_TYPE_URI</a> = 0, <a href="MultiMedia_MediaCommon.md#gga4052b7b55dfd94f1d07678e79d80b507a4134c6ec0b1a7fda26c38b8932e606e5">OHOS::Media::SourceType::SOURCE_TYPE_FD</a>, <a href="MultiMedia_MediaCommon.md#gga4052b7b55dfd94f1d07678e79d80b507a538f01f856d995123459a44642a7dc86">OHOS::Media::SourceType::SOURCE_TYPE_STREAM</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1097276717084827"><a name="p1097276717084827"></a><a name="p1097276717084827"></a>Enumerates media source types. </p>
</td>
</tr>
<tr id="row1819893268084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1717692932084827"><a name="p1717692932084827"></a><a name="p1717692932084827"></a><a href="MultiMedia_MediaCommon.md#ga6f4847f443de5cdf3641386011335e21">OHOS::Media::StreamCallback::BufferFlags</a> : uint32_t { &nbsp;&nbsp;<a href="MultiMedia_MediaCommon.md#gga6f4847f443de5cdf3641386011335e21ac1a3ce4ddd663c55f87a8275ccf285ad">OHOS::Media::StreamCallback::STREAM_FLAG_SYNCFRAME</a> = 1, <a href="MultiMedia_MediaCommon.md#gga6f4847f443de5cdf3641386011335e21afd0d977a6a5d48657d694c9acb8ac2b5">OHOS::Media::StreamCallback::STREAM_FLAG_CODECCONFIG</a> = 2, <a href="MultiMedia_MediaCommon.md#gga6f4847f443de5cdf3641386011335e21aa76ecb4ee6077a1ad3ceac569b875487">OHOS::Media::StreamCallback::STREAM_FLAG_EOS</a> = 4, <a href="MultiMedia_MediaCommon.md#gga6f4847f443de5cdf3641386011335e21a29e735a1e41790c24cc9ac9e7342dd2a">OHOS::Media::StreamCallback::STREAM_FLAG_PARTIAL_FRAME</a> = 8, &nbsp;&nbsp;<a href="MultiMedia_MediaCommon.md#gga6f4847f443de5cdf3641386011335e21a8b2c1f065ce398ac48bac2b8e62e481b">OHOS::Media::StreamCallback::STREAM_FLAG_ENDOFFRAME</a> = 16, <a href="MultiMedia_MediaCommon.md#gga6f4847f443de5cdf3641386011335e21a9001c389dd39f08025e76ae2872fad02">OHOS::Media::StreamCallback::STREAM_FLAG_MUXER_DATA</a> = 32 }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p662109413084827"><a name="p662109413084827"></a><a name="p662109413084827"></a>Enumerates buffer types of stream sources. </p>
</td>
</tr>
</tbody>
</table>

## Functions<a name="func-members"></a>

<a name="table448660956084827"></a>
<table><thead align="left"><tr id="row1829425583084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1762494295084827"><a name="p1762494295084827"></a><a name="p1762494295084827"></a>Function Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p389100524084827"><a name="p389100524084827"></a><a name="p389100524084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1208496223084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1576746861084827"><a name="p1576746861084827"></a><a name="p1576746861084827"></a><a href="MultiMedia_MediaCommon.md#ga178a65e0d58071de84e2dbc09ac93407">OHOS::Media::FormatData::GetType</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1858780129084827"><a name="p1858780129084827"></a><a name="p1858780129084827"></a><a href="MultiMedia_MediaCommon.md#gaa3bfacc6563d8ec8bc870f4b216b4f46">FormatDataType</a>&nbsp;</p>
<p id="p1747895377084827"><a name="p1747895377084827"></a><a name="p1747895377084827"></a>Obtains the format type. </p>
</td>
</tr>
<tr id="row1404549875084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p498516991084827"><a name="p498516991084827"></a><a name="p498516991084827"></a><a href="MultiMedia_MediaCommon.md#gaa1a80e9075010faca14c5c71855efe2d">OHOS::Media::FormatData::SetValue</a> (int32_t val)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1386859275084827"><a name="p1386859275084827"></a><a name="p1386859275084827"></a>bool&nbsp;</p>
<p id="p222709966084827"><a name="p222709966084827"></a><a name="p222709966084827"></a>Sets a 32-bit integer. </p>
</td>
</tr>
<tr id="row1099860876084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1955751391084827"><a name="p1955751391084827"></a><a name="p1955751391084827"></a><a href="MultiMedia_MediaCommon.md#gabb73fee1739b96b402a430f7879b2ca6">OHOS::Media::FormatData::SetValue</a> (int64_t val)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1122720013084827"><a name="p1122720013084827"></a><a name="p1122720013084827"></a>bool&nbsp;</p>
<p id="p315162975084827"><a name="p315162975084827"></a><a name="p315162975084827"></a>Sets a 64-bit long integer. </p>
</td>
</tr>
<tr id="row1876200170084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1831797463084827"><a name="p1831797463084827"></a><a name="p1831797463084827"></a><a href="MultiMedia_MediaCommon.md#gaa5ca8643885118cd0b3668d5497a90da">OHOS::Media::FormatData::SetValue</a> (float val)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p149864359084827"><a name="p149864359084827"></a><a name="p149864359084827"></a>bool&nbsp;</p>
<p id="p747084930084827"><a name="p747084930084827"></a><a name="p747084930084827"></a>Sets a single-precision floating-point number. </p>
</td>
</tr>
<tr id="row1001868488084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p988777130084827"><a name="p988777130084827"></a><a name="p988777130084827"></a><a href="MultiMedia_MediaCommon.md#ga5e9360adeb46e7b147757ca22c65c268">OHOS::Media::FormatData::SetValue</a> (double val)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1926775043084827"><a name="p1926775043084827"></a><a name="p1926775043084827"></a>bool&nbsp;</p>
<p id="p695985446084827"><a name="p695985446084827"></a><a name="p695985446084827"></a>Sets a double-precision floating-point number. </p>
</td>
</tr>
<tr id="row780824776084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p920487278084827"><a name="p920487278084827"></a><a name="p920487278084827"></a><a href="MultiMedia_MediaCommon.md#gacbbf1dca947de8bce2e1a323a1c2664a">OHOS::Media::FormatData::SetValue</a> (const std::string &amp;val)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1805063897084827"><a name="p1805063897084827"></a><a name="p1805063897084827"></a>bool&nbsp;</p>
<p id="p1025247525084827"><a name="p1025247525084827"></a><a name="p1025247525084827"></a>Sets a string. </p>
</td>
</tr>
<tr id="row45618949084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p156525716084827"><a name="p156525716084827"></a><a name="p156525716084827"></a><a href="MultiMedia_MediaCommon.md#gac116d67e5e80f1f9c1c573ceb24df36a">OHOS::Media::FormatData::GetInt32Value</a> (int32_t &amp;val) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1656212090084827"><a name="p1656212090084827"></a><a name="p1656212090084827"></a>bool&nbsp;</p>
<p id="p1538558342084827"><a name="p1538558342084827"></a><a name="p1538558342084827"></a>Obtains a 32-bit integer. </p>
</td>
</tr>
<tr id="row2002198027084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1909423117084827"><a name="p1909423117084827"></a><a name="p1909423117084827"></a><a href="MultiMedia_MediaCommon.md#ga1f24cb15577c40f7044f4beb96515cfc">OHOS::Media::FormatData::GetInt64Value</a> (int64_t &amp;val) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p544685991084827"><a name="p544685991084827"></a><a name="p544685991084827"></a>bool&nbsp;</p>
<p id="p710019838084827"><a name="p710019838084827"></a><a name="p710019838084827"></a>Obtains a long integer. </p>
</td>
</tr>
<tr id="row1671413232084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1971478591084827"><a name="p1971478591084827"></a><a name="p1971478591084827"></a><a href="MultiMedia_MediaCommon.md#gada31b9cf5daa944104417442a5e459dc">OHOS::Media::FormatData::GetFloatValue</a> (float &amp;val) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1452861389084827"><a name="p1452861389084827"></a><a name="p1452861389084827"></a>bool&nbsp;</p>
<p id="p1253579993084827"><a name="p1253579993084827"></a><a name="p1253579993084827"></a>Obtains a single-precision floating-point number. </p>
</td>
</tr>
<tr id="row1676696796084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p876801087084827"><a name="p876801087084827"></a><a name="p876801087084827"></a><a href="MultiMedia_MediaCommon.md#gac1ed56f6d35982f770d083dc16e97dbd">OHOS::Media::FormatData::GetDoubleValue</a> (double &amp;val) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1957214181084827"><a name="p1957214181084827"></a><a name="p1957214181084827"></a>bool&nbsp;</p>
<p id="p1699618346084827"><a name="p1699618346084827"></a><a name="p1699618346084827"></a>Obtains a double-precision floating-point number. </p>
</td>
</tr>
<tr id="row465783191084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p906623792084827"><a name="p906623792084827"></a><a name="p906623792084827"></a><a href="MultiMedia_MediaCommon.md#ga9687bb5d98a92e7beb53dfe4ac44eec1">OHOS::Media::FormatData::GetStringValue</a> (std::string &amp;val) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1506898782084827"><a name="p1506898782084827"></a><a name="p1506898782084827"></a>bool&nbsp;</p>
<p id="p1183253781084827"><a name="p1183253781084827"></a><a name="p1183253781084827"></a>Obtains a string. </p>
</td>
</tr>
<tr id="row1648039214084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p597404017084827"><a name="p597404017084827"></a><a name="p597404017084827"></a><a href="MultiMedia_MediaCommon.md#ga42435567c8fd61fd2da4834465aca98e">OHOS::Media::Format::Format</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1230970824084827"><a name="p1230970824084827"></a><a name="p1230970824084827"></a>&nbsp;</p>
<p id="p1256763989084827"><a name="p1256763989084827"></a><a name="p1256763989084827"></a>Default constructor of the <a href="OHOS-Media-Format.md">Format</a> instance. </p>
</td>
</tr>
<tr id="row1481273341084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2028325969084827"><a name="p2028325969084827"></a><a name="p2028325969084827"></a><a href="MultiMedia_MediaCommon.md#ga66771efe315d001e79a14d316c58718e">OHOS::Media::Format::PutIntValue</a> (const std::string &amp;key, int32_t value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1963352432084827"><a name="p1963352432084827"></a><a name="p1963352432084827"></a>bool&nbsp;</p>
<p id="p936673365084827"><a name="p936673365084827"></a><a name="p936673365084827"></a>Sets metadata of the integer type. </p>
</td>
</tr>
<tr id="row1877054754084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1135290752084827"><a name="p1135290752084827"></a><a name="p1135290752084827"></a><a href="MultiMedia_MediaCommon.md#ga5b4477636095d80ec4e65c1be617c61c">OHOS::Media::Format::PutLongValue</a> (const std::string &amp;key, int64_t value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1051239958084827"><a name="p1051239958084827"></a><a name="p1051239958084827"></a>bool&nbsp;</p>
<p id="p1284895382084827"><a name="p1284895382084827"></a><a name="p1284895382084827"></a>Sets metadata of the long integer type. </p>
</td>
</tr>
<tr id="row200464641084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p594233438084827"><a name="p594233438084827"></a><a name="p594233438084827"></a><a href="MultiMedia_MediaCommon.md#gabec9417120824f5bb9eb676be380016f">OHOS::Media::Format::PutFloatValue</a> (const std::string &amp;key, float value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1209781737084827"><a name="p1209781737084827"></a><a name="p1209781737084827"></a>bool&nbsp;</p>
<p id="p1457092823084827"><a name="p1457092823084827"></a><a name="p1457092823084827"></a>Sets metadata of the single-precision floating-point type. </p>
</td>
</tr>
<tr id="row1418187343084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1457410943084827"><a name="p1457410943084827"></a><a name="p1457410943084827"></a><a href="MultiMedia_MediaCommon.md#ga9a98a92eb4436301853a049b5f3313c6">OHOS::Media::Format::PutDoubleValue</a> (const std::string &amp;key, double value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1211197303084827"><a name="p1211197303084827"></a><a name="p1211197303084827"></a>bool&nbsp;</p>
<p id="p1917277944084827"><a name="p1917277944084827"></a><a name="p1917277944084827"></a>Sets metadata of the double-precision floating-point type. </p>
</td>
</tr>
<tr id="row1606268105084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1993019541084827"><a name="p1993019541084827"></a><a name="p1993019541084827"></a><a href="MultiMedia_MediaCommon.md#gabdc104597559320256930f420eaab82f">OHOS::Media::Format::PutStringValue</a> (const std::string &amp;key, const std::string &amp;value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1275693372084827"><a name="p1275693372084827"></a><a name="p1275693372084827"></a>bool&nbsp;</p>
<p id="p1094391661084827"><a name="p1094391661084827"></a><a name="p1094391661084827"></a>Sets metadata of the string type. </p>
</td>
</tr>
<tr id="row1959321286084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p142744867084827"><a name="p142744867084827"></a><a name="p142744867084827"></a><a href="MultiMedia_MediaCommon.md#ga798ef733a253558757f49714090b3969">OHOS::Media::Format::GetIntValue</a> (const std::string &amp;key, int32_t &amp;value) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1942762522084827"><a name="p1942762522084827"></a><a name="p1942762522084827"></a>bool&nbsp;</p>
<p id="p999613351084827"><a name="p999613351084827"></a><a name="p999613351084827"></a>Obtains the metadata value of the integer type. </p>
</td>
</tr>
<tr id="row1500577172084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p283263659084827"><a name="p283263659084827"></a><a name="p283263659084827"></a><a href="MultiMedia_MediaCommon.md#ga7f1c503f40b78083cb9b9ae9ce93d3b4">OHOS::Media::Format::GetLongValue</a> (const std::string &amp;key, int64_t &amp;value) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1559714951084827"><a name="p1559714951084827"></a><a name="p1559714951084827"></a>bool&nbsp;</p>
<p id="p1886127623084827"><a name="p1886127623084827"></a><a name="p1886127623084827"></a>Obtains the metadata value of the long integer type. </p>
</td>
</tr>
<tr id="row967247333084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p313910302084827"><a name="p313910302084827"></a><a name="p313910302084827"></a><a href="MultiMedia_MediaCommon.md#gac4e963a9fe320c0143ed33df5f737cb3">OHOS::Media::Format::GetFloatValue</a> (const std::string &amp;key, float &amp;value) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p570092260084827"><a name="p570092260084827"></a><a name="p570092260084827"></a>bool&nbsp;</p>
<p id="p864733540084827"><a name="p864733540084827"></a><a name="p864733540084827"></a>Obtains the metadata value of the single-precision floating-point type. </p>
</td>
</tr>
<tr id="row1025318109084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2023280664084827"><a name="p2023280664084827"></a><a name="p2023280664084827"></a><a href="MultiMedia_MediaCommon.md#gafe949ed0c2d9dcb5c5e57c7fde226f3e">OHOS::Media::Format::GetDoubleValue</a> (const std::string &amp;key, double &amp;value) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1689181460084827"><a name="p1689181460084827"></a><a name="p1689181460084827"></a>bool&nbsp;</p>
<p id="p1131287955084827"><a name="p1131287955084827"></a><a name="p1131287955084827"></a>Obtains the metadata value of the double-precision floating-point type. </p>
</td>
</tr>
<tr id="row1805133860084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1129103434084827"><a name="p1129103434084827"></a><a name="p1129103434084827"></a><a href="MultiMedia_MediaCommon.md#ga089a3e44e128fb662b72c56b53c7068b">OHOS::Media::Format::GetStringValue</a> (const std::string &amp;key, std::string &amp;value) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1631251285084827"><a name="p1631251285084827"></a><a name="p1631251285084827"></a>bool&nbsp;</p>
<p id="p818469946084827"><a name="p818469946084827"></a><a name="p818469946084827"></a>Obtains the metadata value of the string type. </p>
</td>
</tr>
<tr id="row974577903084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1204396485084827"><a name="p1204396485084827"></a><a name="p1204396485084827"></a><a href="MultiMedia_MediaCommon.md#ga4adff4846515cef00987a360a4d117af">OHOS::Media::Format::GetFormatMap</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p51963138084827"><a name="p51963138084827"></a><a name="p51963138084827"></a>const std::map&lt; std::string, <a href="OHOS-Media-FormatData.md">FormatData</a> * &gt; &amp;&nbsp;</p>
<p id="p179298613084827"><a name="p179298613084827"></a><a name="p179298613084827"></a>Obtains the metadata map. </p>
</td>
</tr>
<tr id="row224418396084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p209633386084827"><a name="p209633386084827"></a><a name="p209633386084827"></a><a href="MultiMedia_MediaCommon.md#ga528134c9f87bf755077b3ef51d64e198">OHOS::Media::Format::CopyFrom</a> (const <a href="OHOS-Media-Format.md">Format</a> &amp;format)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p215061048084827"><a name="p215061048084827"></a><a name="p215061048084827"></a>bool&nbsp;</p>
<p id="p292387981084827"><a name="p292387981084827"></a><a name="p292387981084827"></a>Sets all metadata to a specified format. </p>
</td>
</tr>
<tr id="row165985543084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p69615345084827"><a name="p69615345084827"></a><a name="p69615345084827"></a><a href="MultiMedia_MediaCommon.md#ga5534cc5ecbcb6eb719f55d8695bbb481">OHOS::Media::ErrCodeOffset</a> (unsigned int subsystem, unsigned int module=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p706580413084827"><a name="p706580413084827"></a><a name="p706580413084827"></a>constexpr ErrCode&nbsp;</p>
<p id="p1632961577084827"><a name="p1632961577084827"></a><a name="p1632961577084827"></a>Generates a start error code with a unique identifier based on specified subsystem and module bit numbers. </p>
</td>
</tr>
<tr id="row439269229084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p572559835084827"><a name="p572559835084827"></a><a name="p572559835084827"></a><a href="MultiMedia_MediaCommon.md#ga8f897b8b2d5baf06e15accfeb97892ae">OHOS::Media::StreamCallback::GetBuffer</a> (size_t <a href="UTILS.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p671717955084827"><a name="p671717955084827"></a><a name="p671717955084827"></a>virtual uint8_t *&nbsp;</p>
<p id="p1207310978084827"><a name="p1207310978084827"></a><a name="p1207310978084827"></a>Obtains the virtual address of a buffer memory block based on its index. </p>
</td>
</tr>
<tr id="row1546699916084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1233314200084827"><a name="p1233314200084827"></a><a name="p1233314200084827"></a><a href="MultiMedia_MediaCommon.md#gaa62705632557f47f9fd9632157e53a21">OHOS::Media::StreamCallback::QueueBuffer</a> (size_t <a href="UTILS.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>, size_t offset, size_t size, int64_t timestampUs, uint32_t flags)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2103981577084827"><a name="p2103981577084827"></a><a name="p2103981577084827"></a>virtual void&nbsp;</p>
<p id="p1784857602084827"><a name="p1784857602084827"></a><a name="p1784857602084827"></a>Writes the filled buffer memory block into the player memory. </p>
</td>
</tr>
<tr id="row247945677084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p870968310084827"><a name="p870968310084827"></a><a name="p870968310084827"></a><a href="MultiMedia_MediaCommon.md#ga29f8c86744bda61f84920654c5f40df0">OHOS::Media::StreamCallback::SetParameters</a> (const <a href="OHOS-Media-Format.md">Format</a> &amp;params)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p327419034084827"><a name="p327419034084827"></a><a name="p327419034084827"></a>virtual void&nbsp;</p>
<p id="p1198478693084827"><a name="p1198478693084827"></a><a name="p1198478693084827"></a>Sets additional information about a stream. </p>
</td>
</tr>
<tr id="row1136776548084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p469015001084827"><a name="p469015001084827"></a><a name="p469015001084827"></a><a href="MultiMedia_MediaCommon.md#gaaebd4fe9df44b434f410aec32cf23467">OHOS::Media::StreamSource::OnBufferAvailable</a> (size_t <a href="UTILS.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>, size_t offset, size_t size)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p639569089084827"><a name="p639569089084827"></a><a name="p639569089084827"></a>virtual void&nbsp;</p>
<p id="p1437618986084827"><a name="p1437618986084827"></a><a name="p1437618986084827"></a>Notifies your application of the information about the buffer memory block that can be filled with data. </p>
</td>
</tr>
<tr id="row1541077271084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p617396472084827"><a name="p617396472084827"></a><a name="p617396472084827"></a><a href="MultiMedia_MediaCommon.md#ga078516891396a86226c945e02c79c1f5">OHOS::Media::StreamSource::SetStreamCallback</a> (const std::shared_ptr&lt; <a href="OHOS-Media-StreamCallback.md">StreamCallback</a> &gt; &amp;callback)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1026202152084827"><a name="p1026202152084827"></a><a name="p1026202152084827"></a>virtual void&nbsp;</p>
<p id="p305329925084827"><a name="p305329925084827"></a><a name="p305329925084827"></a>Sets a callback function for your application. </p>
</td>
</tr>
<tr id="row1568223746084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1510088460084827"><a name="p1510088460084827"></a><a name="p1510088460084827"></a><a href="MultiMedia_MediaCommon.md#gab9bfa209ae382e3ba5d5242e8dfe5b20">OHOS::Media::Source::Source</a> (const std::string &amp;uri)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p607297401084827"><a name="p607297401084827"></a><a name="p607297401084827"></a>&nbsp;</p>
<p id="p2121943601084827"><a name="p2121943601084827"></a><a name="p2121943601084827"></a>A constructor used to create a <a href="OHOS-Media-Source.md">Source</a> instance based on a specified URI. </p>
</td>
</tr>
<tr id="row1640292803084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1938355310084827"><a name="p1938355310084827"></a><a name="p1938355310084827"></a><a href="MultiMedia_MediaCommon.md#ga84e570aa39e0810815e3f90419b2a0f0">OHOS::Media::Source::Source</a> (const std::string &amp;uri, const std::map&lt; std::string, std::string &gt; &amp;header)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p148698131084827"><a name="p148698131084827"></a><a name="p148698131084827"></a>&nbsp;</p>
<p id="p1583779615084827"><a name="p1583779615084827"></a><a name="p1583779615084827"></a>A constructor used to create a <a href="OHOS-Media-Source.md">Source</a> instance based on a specified URI and header. </p>
</td>
</tr>
<tr id="row1762681969084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p605008062084827"><a name="p605008062084827"></a><a name="p605008062084827"></a><a href="MultiMedia_MediaCommon.md#gae3640fec3bb0f33f4076dc30e88dac61">OHOS::Media::Source::Source</a> (const std::shared_ptr&lt; <a href="OHOS-Media-StreamSource.md">StreamSource</a> &gt; &amp;stream, const <a href="OHOS-Media-Format.md">Format</a> &amp;formats)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p970713679084827"><a name="p970713679084827"></a><a name="p970713679084827"></a>&nbsp;</p>
<p id="p1692666437084827"><a name="p1692666437084827"></a><a name="p1692666437084827"></a>A constructor used to create a <a href="OHOS-Media-Source.md">Source</a> instance based on the stream source and format information. </p>
</td>
</tr>
<tr id="row1050522667084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1901736619084827"><a name="p1901736619084827"></a><a name="p1901736619084827"></a><a href="MultiMedia_MediaCommon.md#ga93a8f8b86a9385436f6bbce10a860770">OHOS::Media::Source::GetSourceType</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1401648517084827"><a name="p1401648517084827"></a><a name="p1401648517084827"></a><a href="MultiMedia_MediaCommon.md#ga4052b7b55dfd94f1d07678e79d80b507">SourceType</a>&nbsp;</p>
<p id="p1673128623084827"><a name="p1673128623084827"></a><a name="p1673128623084827"></a>Obtains the source type. </p>
</td>
</tr>
<tr id="row1845343457084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p505158296084827"><a name="p505158296084827"></a><a name="p505158296084827"></a><a href="MultiMedia_MediaCommon.md#ga69ed2683ce3a632f6b2295fb398e4b7b">OHOS::Media::Source::GetSourceUri</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1251860965084827"><a name="p1251860965084827"></a><a name="p1251860965084827"></a>const std::string &amp;&nbsp;</p>
<p id="p1111036066084827"><a name="p1111036066084827"></a><a name="p1111036066084827"></a>Obtains the media source URI. </p>
</td>
</tr>
<tr id="row1395411659084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1287323293084827"><a name="p1287323293084827"></a><a name="p1287323293084827"></a><a href="MultiMedia_MediaCommon.md#ga6bb820da4b770311efc550ad27d7ce4a">OHOS::Media::Source::GetSourceHeader</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p780645539084827"><a name="p780645539084827"></a><a name="p780645539084827"></a>const std::map&lt; std::string, std::string &gt; &amp;&nbsp;</p>
<p id="p954678996084827"><a name="p954678996084827"></a><a name="p954678996084827"></a>Obtains the HTTP header for the media source. </p>
</td>
</tr>
<tr id="row1198264541084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1496804063084827"><a name="p1496804063084827"></a><a name="p1496804063084827"></a><a href="MultiMedia_MediaCommon.md#ga395325402881ad38ef40c9ebd13f174d">OHOS::Media::Source::GetSourceStream</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p470581897084827"><a name="p470581897084827"></a><a name="p470581897084827"></a>const std::shared_ptr&lt; <a href="OHOS-Media-StreamSource.md">StreamSource</a> &gt; &amp;&nbsp;</p>
<p id="p1271805460084827"><a name="p1271805460084827"></a><a name="p1271805460084827"></a>Obtains information about the media source stream. </p>
</td>
</tr>
<tr id="row1781367125084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p39877880084827"><a name="p39877880084827"></a><a name="p39877880084827"></a><a href="MultiMedia_MediaCommon.md#gafbd3c732660124a1dc1d9dd0dfb51393">OHOS::Media::Source::GetSourceStreamFormat</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1526183150084827"><a name="p1526183150084827"></a><a name="p1526183150084827"></a>const <a href="OHOS-Media-Format.md">Format</a> &amp;&nbsp;</p>
<p id="p875626829084827"><a name="p875626829084827"></a><a name="p875626829084827"></a>Obtains the media source stream format. </p>
</td>
</tr>
</tbody>
</table>

## **Details**<a name="section1926620100084827"></a>

## **Enumeration Type Documentation**<a name="section1907434680084827"></a>

## AudioBitWidth<a name="gae3e35ee2a2222a667fdebbc5b793ca7c"></a>

```
enum [AudioBitWidth](MultiMedia_MediaCommon.md#gae3e35ee2a2222a667fdebbc5b793ca7c)
```

 **Description:**

Enumerates audio bit widths. 

<a name="table1508996260084827"></a>
<table><thead align="left"><tr id="row1642402540084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p630672731084827"><a name="p630672731084827"></a><a name="p630672731084827"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p14532304084827"><a name="p14532304084827"></a><a name="p14532304084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row243739813084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae3e35ee2a2222a667fdebbc5b793ca7cac790b3e4ae89aa667da7dad7e79df6a8"><a name="ggae3e35ee2a2222a667fdebbc5b793ca7cac790b3e4ae89aa667da7dad7e79df6a8"></a><a name="ggae3e35ee2a2222a667fdebbc5b793ca7cac790b3e4ae89aa667da7dad7e79df6a8"></a></strong>BIT_WIDTH_8&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p397520133084827"><a name="p397520133084827"></a><a name="p397520133084827"></a>8-bit width </p>
 </td>
</tr>
<tr id="row2013067914084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae3e35ee2a2222a667fdebbc5b793ca7ca036f0b45813f96cb6b0f90de1722a780"><a name="ggae3e35ee2a2222a667fdebbc5b793ca7ca036f0b45813f96cb6b0f90de1722a780"></a><a name="ggae3e35ee2a2222a667fdebbc5b793ca7ca036f0b45813f96cb6b0f90de1722a780"></a></strong>BIT_WIDTH_16&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p886149899084827"><a name="p886149899084827"></a><a name="p886149899084827"></a>16-bit width </p>
 </td>
</tr>
<tr id="row296125945084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae3e35ee2a2222a667fdebbc5b793ca7ca3d613870d00dad5bc83927eaef3c6ade"><a name="ggae3e35ee2a2222a667fdebbc5b793ca7ca3d613870d00dad5bc83927eaef3c6ade"></a><a name="ggae3e35ee2a2222a667fdebbc5b793ca7ca3d613870d00dad5bc83927eaef3c6ade"></a></strong>BIT_WIDTH_24&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p628051670084827"><a name="p628051670084827"></a><a name="p628051670084827"></a>24-bit width </p>
 </td>
</tr>
<tr id="row389118618084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae3e35ee2a2222a667fdebbc5b793ca7cafe508a98e81909dc5985e7edc76104d4"><a name="ggae3e35ee2a2222a667fdebbc5b793ca7cafe508a98e81909dc5985e7edc76104d4"></a><a name="ggae3e35ee2a2222a667fdebbc5b793ca7cafe508a98e81909dc5985e7edc76104d4"></a></strong>BIT_WIDTH_BUTT&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1443131942084827"><a name="p1443131942084827"></a><a name="p1443131942084827"></a>Invalid value </p>
 </td>
</tr>
</tbody>
</table>

## AudioCodecFormat<a name="gaa4ea6f314644ed287e0704be26c768b7"></a>

```
enum [AudioCodecFormat](MultiMedia_MediaCommon.md#gaa4ea6f314644ed287e0704be26c768b7)
```

 **Description:**

Enumerates audio codec formats. 

<a name="table1569169319084827"></a>
<table><thead align="left"><tr id="row1259244727084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1253489136084827"><a name="p1253489136084827"></a><a name="p1253489136084827"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1647658131084827"><a name="p1647658131084827"></a><a name="p1647658131084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row169302084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa4ea6f314644ed287e0704be26c768b7a4c4c5829b054bc468274700c56d65546"><a name="ggaa4ea6f314644ed287e0704be26c768b7a4c4c5829b054bc468274700c56d65546"></a><a name="ggaa4ea6f314644ed287e0704be26c768b7a4c4c5829b054bc468274700c56d65546"></a></strong>AUDIO_DEFAULT&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1355549982084827"><a name="p1355549982084827"></a><a name="p1355549982084827"></a>Default format </p>
 </td>
</tr>
<tr id="row56947221084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa4ea6f314644ed287e0704be26c768b7a9f7c5945c7d9d679395a7b06652c51ec"><a name="ggaa4ea6f314644ed287e0704be26c768b7a9f7c5945c7d9d679395a7b06652c51ec"></a><a name="ggaa4ea6f314644ed287e0704be26c768b7a9f7c5945c7d9d679395a7b06652c51ec"></a></strong>AAC_LC&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2048995581084827"><a name="p2048995581084827"></a><a name="p2048995581084827"></a>Advanced Audio Coding Low Complexity (AAC-LC) </p>
 </td>
</tr>
<tr id="row569328757084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa4ea6f314644ed287e0704be26c768b7ac711be17b9264c9f814b11b7fcc3f1b6"><a name="ggaa4ea6f314644ed287e0704be26c768b7ac711be17b9264c9f814b11b7fcc3f1b6"></a><a name="ggaa4ea6f314644ed287e0704be26c768b7ac711be17b9264c9f814b11b7fcc3f1b6"></a></strong>AAC_HE_V1&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p14475054084827"><a name="p14475054084827"></a><a name="p14475054084827"></a>High-Efficiency Advanced Audio Coding (AAC-HE), previously known as AAC+ or aacPlus v1 </p>
 </td>
</tr>
<tr id="row526896944084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa4ea6f314644ed287e0704be26c768b7abf3ac142be84c7ee471a84570745a136"><a name="ggaa4ea6f314644ed287e0704be26c768b7abf3ac142be84c7ee471a84570745a136"></a><a name="ggaa4ea6f314644ed287e0704be26c768b7abf3ac142be84c7ee471a84570745a136"></a></strong>AAC_HE_V2&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p512773077084827"><a name="p512773077084827"></a><a name="p512773077084827"></a>AAC++ or aacPlus v2 </p>
 </td>
</tr>
<tr id="row2085896853084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa4ea6f314644ed287e0704be26c768b7a1ba0b2e0c3a69a989dec92fc6132d8f2"><a name="ggaa4ea6f314644ed287e0704be26c768b7a1ba0b2e0c3a69a989dec92fc6132d8f2"></a><a name="ggaa4ea6f314644ed287e0704be26c768b7a1ba0b2e0c3a69a989dec92fc6132d8f2"></a></strong>AAC_LD&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1008947317084827"><a name="p1008947317084827"></a><a name="p1008947317084827"></a>Advanced Audio Coding Low Delay (AAC-LD) </p>
 </td>
</tr>
<tr id="row1846768846084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa4ea6f314644ed287e0704be26c768b7a05b8c66394143a26c66268a39115c48a"><a name="ggaa4ea6f314644ed287e0704be26c768b7a05b8c66394143a26c66268a39115c48a"></a><a name="ggaa4ea6f314644ed287e0704be26c768b7a05b8c66394143a26c66268a39115c48a"></a></strong>AAC_ELD&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p123592899084827"><a name="p123592899084827"></a><a name="p123592899084827"></a>Advanced Audio Coding Enhanced Low Delay (AAC-ELD) </p>
 </td>
</tr>
<tr id="row8677200084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa4ea6f314644ed287e0704be26c768b7a5945910833e0d7ff1a9ff73208d9406a"><a name="ggaa4ea6f314644ed287e0704be26c768b7a5945910833e0d7ff1a9ff73208d9406a"></a><a name="ggaa4ea6f314644ed287e0704be26c768b7a5945910833e0d7ff1a9ff73208d9406a"></a></strong>FORMAT_BUTT&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p209546915084827"><a name="p209546915084827"></a><a name="p209546915084827"></a>Invalid value </p>
 </td>
</tr>
</tbody>
</table>

## AudioSourceType<a name="gadc3158e093b995ca7b9b6aa32388ccdd"></a>

```
enum [AudioSourceType](MultiMedia_MediaCommon.md#gadc3158e093b995ca7b9b6aa32388ccdd)
```

 **Description:**

Enumerates audio source types. 

<a name="table168902651084827"></a>
<table><thead align="left"><tr id="row826916425084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1738069264084827"><a name="p1738069264084827"></a><a name="p1738069264084827"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p772655879084827"><a name="p772655879084827"></a><a name="p772655879084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1227252871084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggadc3158e093b995ca7b9b6aa32388ccddad728113cb6300764f0131e28290706c0"><a name="ggadc3158e093b995ca7b9b6aa32388ccddad728113cb6300764f0131e28290706c0"></a><a name="ggadc3158e093b995ca7b9b6aa32388ccddad728113cb6300764f0131e28290706c0"></a></strong>AUDIO_SOURCE_INVALID&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p626980007084827"><a name="p626980007084827"></a><a name="p626980007084827"></a>Invalid audio source </p>
 </td>
</tr>
<tr id="row870154974084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggadc3158e093b995ca7b9b6aa32388ccdda159b69cc6a9b75d6fed0da3e3db9a62f"><a name="ggadc3158e093b995ca7b9b6aa32388ccdda159b69cc6a9b75d6fed0da3e3db9a62f"></a><a name="ggadc3158e093b995ca7b9b6aa32388ccdda159b69cc6a9b75d6fed0da3e3db9a62f"></a></strong>AUDIO_SOURCE_DEFAULT&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p515125915084827"><a name="p515125915084827"></a><a name="p515125915084827"></a>Default audio source </p>
 </td>
</tr>
<tr id="row165885920084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggadc3158e093b995ca7b9b6aa32388ccdda732604b3a24d137429e2b83b31849bce"><a name="ggadc3158e093b995ca7b9b6aa32388ccdda732604b3a24d137429e2b83b31849bce"></a><a name="ggadc3158e093b995ca7b9b6aa32388ccdda732604b3a24d137429e2b83b31849bce"></a></strong>AUDIO_MIC&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p581137067084827"><a name="p581137067084827"></a><a name="p581137067084827"></a>Microphone </p>
 </td>
</tr>
<tr id="row787308136084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggadc3158e093b995ca7b9b6aa32388ccddac94b34dbaa3e19d53b34096fbcd64d8d"><a name="ggadc3158e093b995ca7b9b6aa32388ccddac94b34dbaa3e19d53b34096fbcd64d8d"></a><a name="ggadc3158e093b995ca7b9b6aa32388ccddac94b34dbaa3e19d53b34096fbcd64d8d"></a></strong>AUDIO_VOICE_UPLINK&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1583656367084827"><a name="p1583656367084827"></a><a name="p1583656367084827"></a>Uplink voice </p>
 </td>
</tr>
<tr id="row2028841609084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggadc3158e093b995ca7b9b6aa32388ccdda076ef2fc169a0b5f640e8433d77d1f45"><a name="ggadc3158e093b995ca7b9b6aa32388ccdda076ef2fc169a0b5f640e8433d77d1f45"></a><a name="ggadc3158e093b995ca7b9b6aa32388ccdda076ef2fc169a0b5f640e8433d77d1f45"></a></strong>AUDIO_VOICE_DOWNLINK&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1756250209084827"><a name="p1756250209084827"></a><a name="p1756250209084827"></a>Downlink voice </p>
 </td>
</tr>
<tr id="row682730574084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggadc3158e093b995ca7b9b6aa32388ccdda3d978f472db3ff575a1b4ab84acbc15c"><a name="ggadc3158e093b995ca7b9b6aa32388ccdda3d978f472db3ff575a1b4ab84acbc15c"></a><a name="ggadc3158e093b995ca7b9b6aa32388ccdda3d978f472db3ff575a1b4ab84acbc15c"></a></strong>AUDIO_VOICE_CALL&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1037653139084827"><a name="p1037653139084827"></a><a name="p1037653139084827"></a>Voice call </p>
 </td>
</tr>
<tr id="row1614492320084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggadc3158e093b995ca7b9b6aa32388ccdda0d2b7337a260ae5c32abd843f5d52ec8"><a name="ggadc3158e093b995ca7b9b6aa32388ccdda0d2b7337a260ae5c32abd843f5d52ec8"></a><a name="ggadc3158e093b995ca7b9b6aa32388ccdda0d2b7337a260ae5c32abd843f5d52ec8"></a></strong>AUDIO_CAMCORDER&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1955837540084827"><a name="p1955837540084827"></a><a name="p1955837540084827"></a>Camcorder </p>
 </td>
</tr>
<tr id="row1561306753084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggadc3158e093b995ca7b9b6aa32388ccdda2491fee4b6ca4dce9c05babc3c1168e8"><a name="ggadc3158e093b995ca7b9b6aa32388ccdda2491fee4b6ca4dce9c05babc3c1168e8"></a><a name="ggadc3158e093b995ca7b9b6aa32388ccdda2491fee4b6ca4dce9c05babc3c1168e8"></a></strong>AUDIO_VOICE_RECOGNITION&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p131139367084827"><a name="p131139367084827"></a><a name="p131139367084827"></a>Voice recognition </p>
 </td>
</tr>
<tr id="row227131797084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggadc3158e093b995ca7b9b6aa32388ccdda09ce48df53dbaea4ef4273614bdc5445"><a name="ggadc3158e093b995ca7b9b6aa32388ccdda09ce48df53dbaea4ef4273614bdc5445"></a><a name="ggadc3158e093b995ca7b9b6aa32388ccdda09ce48df53dbaea4ef4273614bdc5445"></a></strong>AUDIO_VOICE_COMMUNICATION&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1538598650084827"><a name="p1538598650084827"></a><a name="p1538598650084827"></a>Voice communication </p>
 </td>
</tr>
<tr id="row1549573602084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggadc3158e093b995ca7b9b6aa32388ccddaef3dbfe38c377d77d0e40a9808012981"><a name="ggadc3158e093b995ca7b9b6aa32388ccddaef3dbfe38c377d77d0e40a9808012981"></a><a name="ggadc3158e093b995ca7b9b6aa32388ccddaef3dbfe38c377d77d0e40a9808012981"></a></strong>AUDIO_REMOTE_SUBMIX&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1378178517084827"><a name="p1378178517084827"></a><a name="p1378178517084827"></a>Remote submix </p>
 </td>
</tr>
<tr id="row1528876226084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggadc3158e093b995ca7b9b6aa32388ccdda2fd32b7e954f7988ae41b63167948caf"><a name="ggadc3158e093b995ca7b9b6aa32388ccdda2fd32b7e954f7988ae41b63167948caf"></a><a name="ggadc3158e093b995ca7b9b6aa32388ccdda2fd32b7e954f7988ae41b63167948caf"></a></strong>AUDIO_UNPROCESSED&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p978811267084827"><a name="p978811267084827"></a><a name="p978811267084827"></a>Unprocessed audio </p>
 </td>
</tr>
<tr id="row659306662084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggadc3158e093b995ca7b9b6aa32388ccdda532f7c38a1feb89c8cb3a4e07f0c2cbe"><a name="ggadc3158e093b995ca7b9b6aa32388ccdda532f7c38a1feb89c8cb3a4e07f0c2cbe"></a><a name="ggadc3158e093b995ca7b9b6aa32388ccdda532f7c38a1feb89c8cb3a4e07f0c2cbe"></a></strong>AUDIO_VOICE_PERFORMANCE&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p26559340084827"><a name="p26559340084827"></a><a name="p26559340084827"></a>Voice performance </p>
 </td>
</tr>
<tr id="row647740092084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggadc3158e093b995ca7b9b6aa32388ccdda295b4d6de2ba41d7783fddbf1543e830"><a name="ggadc3158e093b995ca7b9b6aa32388ccdda295b4d6de2ba41d7783fddbf1543e830"></a><a name="ggadc3158e093b995ca7b9b6aa32388ccdda295b4d6de2ba41d7783fddbf1543e830"></a></strong>AUDIO_ECHO_REFERENCE&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1721242153084827"><a name="p1721242153084827"></a><a name="p1721242153084827"></a>Echo reference </p>
 </td>
</tr>
<tr id="row2137001924084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggadc3158e093b995ca7b9b6aa32388ccdda5492fbdf785a745195f80020dba4f37e"><a name="ggadc3158e093b995ca7b9b6aa32388ccdda5492fbdf785a745195f80020dba4f37e"></a><a name="ggadc3158e093b995ca7b9b6aa32388ccdda5492fbdf785a745195f80020dba4f37e"></a></strong>AUDIO_RADIO_TUNER&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1802499418084827"><a name="p1802499418084827"></a><a name="p1802499418084827"></a>Radio tuner </p>
 </td>
</tr>
<tr id="row145194901084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggadc3158e093b995ca7b9b6aa32388ccdda210886d5f821c08c5a36e71363d330f6"><a name="ggadc3158e093b995ca7b9b6aa32388ccdda210886d5f821c08c5a36e71363d330f6"></a><a name="ggadc3158e093b995ca7b9b6aa32388ccdda210886d5f821c08c5a36e71363d330f6"></a></strong>AUDIO_HOTWORD&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1766576183084827"><a name="p1766576183084827"></a><a name="p1766576183084827"></a>Hotword </p>
 </td>
</tr>
<tr id="row1873188327084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggadc3158e093b995ca7b9b6aa32388ccddad0b4097d682e6cc4d7d92e5f0612a831"><a name="ggadc3158e093b995ca7b9b6aa32388ccddad0b4097d682e6cc4d7d92e5f0612a831"></a><a name="ggadc3158e093b995ca7b9b6aa32388ccddad0b4097d682e6cc4d7d92e5f0612a831"></a></strong>AUDIO_REMOTE_SUBMIX_EXTEND&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p185229038084827"><a name="p185229038084827"></a><a name="p185229038084827"></a>Extended remote submix </p>
 </td>
</tr>
</tbody>
</table>

## AudioStreamType<a name="gae7077e4211e48131ae544adb20fc494a"></a>

```
enum [AudioStreamType](MultiMedia_MediaCommon.md#gae7077e4211e48131ae544adb20fc494a)
```

 **Description:**

Enumerates audio stream types. 

<a name="table648937939084827"></a>
<table><thead align="left"><tr id="row1419911604084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1926368104084827"><a name="p1926368104084827"></a><a name="p1926368104084827"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p686005502084827"><a name="p686005502084827"></a><a name="p686005502084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1592310288084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae7077e4211e48131ae544adb20fc494aa80d7bb9558588a28f24aec4c019fdbd6"><a name="ggae7077e4211e48131ae544adb20fc494aa80d7bb9558588a28f24aec4c019fdbd6"></a><a name="ggae7077e4211e48131ae544adb20fc494aa80d7bb9558588a28f24aec4c019fdbd6"></a></strong>TYPE_DEFAULT&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1999392407084827"><a name="p1999392407084827"></a><a name="p1999392407084827"></a>Default audio stream type </p>
 </td>
</tr>
<tr id="row604486176084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae7077e4211e48131ae544adb20fc494aa431e273affaa22e18ec5a2a548b70e90"><a name="ggae7077e4211e48131ae544adb20fc494aa431e273affaa22e18ec5a2a548b70e90"></a><a name="ggae7077e4211e48131ae544adb20fc494aa431e273affaa22e18ec5a2a548b70e90"></a></strong>TYPE_MEDIA&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1518664205084827"><a name="p1518664205084827"></a><a name="p1518664205084827"></a>Media </p>
 </td>
</tr>
<tr id="row777278713084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae7077e4211e48131ae544adb20fc494aa5bfd254bb72236e9c463aefeb4343194"><a name="ggae7077e4211e48131ae544adb20fc494aa5bfd254bb72236e9c463aefeb4343194"></a><a name="ggae7077e4211e48131ae544adb20fc494aa5bfd254bb72236e9c463aefeb4343194"></a></strong>TYPE_VOICE_COMMUNICATION&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p942672087084827"><a name="p942672087084827"></a><a name="p942672087084827"></a>Voice call </p>
 </td>
</tr>
<tr id="row1189069652084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae7077e4211e48131ae544adb20fc494aa0ae2b45a2675c159915c1e76f2f2c846"><a name="ggae7077e4211e48131ae544adb20fc494aa0ae2b45a2675c159915c1e76f2f2c846"></a><a name="ggae7077e4211e48131ae544adb20fc494aa0ae2b45a2675c159915c1e76f2f2c846"></a></strong>TYPE_SYSTEM&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p185342364084827"><a name="p185342364084827"></a><a name="p185342364084827"></a>System sound </p>
 </td>
</tr>
<tr id="row455497482084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae7077e4211e48131ae544adb20fc494aafe3e3697e6e9f7880cb90d40e1d4d708"><a name="ggae7077e4211e48131ae544adb20fc494aafe3e3697e6e9f7880cb90d40e1d4d708"></a><a name="ggae7077e4211e48131ae544adb20fc494aafe3e3697e6e9f7880cb90d40e1d4d708"></a></strong>TYPE_RING&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p242881533084827"><a name="p242881533084827"></a><a name="p242881533084827"></a>Ringtone </p>
 </td>
</tr>
<tr id="row1195871794084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae7077e4211e48131ae544adb20fc494aa801a700d4c9f12285930e9eeace6feb4"><a name="ggae7077e4211e48131ae544adb20fc494aa801a700d4c9f12285930e9eeace6feb4"></a><a name="ggae7077e4211e48131ae544adb20fc494aa801a700d4c9f12285930e9eeace6feb4"></a></strong>TYPE_MUSIC&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1258370223084827"><a name="p1258370223084827"></a><a name="p1258370223084827"></a>Music </p>
 </td>
</tr>
<tr id="row1307219755084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae7077e4211e48131ae544adb20fc494aae93097f5314613a0eb5465187102bd5f"><a name="ggae7077e4211e48131ae544adb20fc494aae93097f5314613a0eb5465187102bd5f"></a><a name="ggae7077e4211e48131ae544adb20fc494aae93097f5314613a0eb5465187102bd5f"></a></strong>TYPE_ALARM&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2094611352084827"><a name="p2094611352084827"></a><a name="p2094611352084827"></a>Alarm </p>
 </td>
</tr>
<tr id="row1527488017084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae7077e4211e48131ae544adb20fc494aa7f3c9297ca35f503b5f7b6cb36610ef6"><a name="ggae7077e4211e48131ae544adb20fc494aa7f3c9297ca35f503b5f7b6cb36610ef6"></a><a name="ggae7077e4211e48131ae544adb20fc494aa7f3c9297ca35f503b5f7b6cb36610ef6"></a></strong>TYPE_NOTIFICATION&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1897682662084827"><a name="p1897682662084827"></a><a name="p1897682662084827"></a>Notification </p>
 </td>
</tr>
<tr id="row55830084084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae7077e4211e48131ae544adb20fc494aac47f3bf77df994414bd9514f8264e277"><a name="ggae7077e4211e48131ae544adb20fc494aac47f3bf77df994414bd9514f8264e277"></a><a name="ggae7077e4211e48131ae544adb20fc494aac47f3bf77df994414bd9514f8264e277"></a></strong>TYPE_BLUETOOTH_SCO&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1250911583084827"><a name="p1250911583084827"></a><a name="p1250911583084827"></a>Bluetooth Synchronous Connection-Oriented (SCO) </p>
 </td>
</tr>
<tr id="row1010839783084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae7077e4211e48131ae544adb20fc494aa00376353eb14c2d326026e6a7cdf6674"><a name="ggae7077e4211e48131ae544adb20fc494aa00376353eb14c2d326026e6a7cdf6674"></a><a name="ggae7077e4211e48131ae544adb20fc494aa00376353eb14c2d326026e6a7cdf6674"></a></strong>TYPE_ENFORCED_AUDIBLE&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1010411595084827"><a name="p1010411595084827"></a><a name="p1010411595084827"></a>Enforced audible </p>
 </td>
</tr>
<tr id="row828459079084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae7077e4211e48131ae544adb20fc494aad61d97f9466b24094407016ce4231f7b"><a name="ggae7077e4211e48131ae544adb20fc494aad61d97f9466b24094407016ce4231f7b"></a><a name="ggae7077e4211e48131ae544adb20fc494aad61d97f9466b24094407016ce4231f7b"></a></strong>TYPE_DTMF&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1356384379084827"><a name="p1356384379084827"></a><a name="p1356384379084827"></a>Dual-tone multi-frequency (DTMF) </p>
 </td>
</tr>
<tr id="row24923961084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae7077e4211e48131ae544adb20fc494aa8e6eb63161413e4bbb207dfb29efe95f"><a name="ggae7077e4211e48131ae544adb20fc494aa8e6eb63161413e4bbb207dfb29efe95f"></a><a name="ggae7077e4211e48131ae544adb20fc494aa8e6eb63161413e4bbb207dfb29efe95f"></a></strong>TYPE_TTS&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1498443688084827"><a name="p1498443688084827"></a><a name="p1498443688084827"></a>Text-To-Speech (TTS) </p>
 </td>
</tr>
<tr id="row642607653084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae7077e4211e48131ae544adb20fc494aa38333aca1beda5f77cc1ce3d0c322262"><a name="ggae7077e4211e48131ae544adb20fc494aa38333aca1beda5f77cc1ce3d0c322262"></a><a name="ggae7077e4211e48131ae544adb20fc494aa38333aca1beda5f77cc1ce3d0c322262"></a></strong>TYPE_ACCESSIBILITY&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p722048713084827"><a name="p722048713084827"></a><a name="p722048713084827"></a>Accessibility </p>
 </td>
</tr>
</tbody>
</table>

## BufferFlags<a name="ga6f4847f443de5cdf3641386011335e21"></a>

```
enum [OHOS::Media::StreamCallback::BufferFlags](MultiMedia_MediaCommon.md#ga6f4847f443de5cdf3641386011335e21) : uint32_t
```

 **Description:**

Enumerates buffer types of stream sources. 

<a name="table791134478084827"></a>
<table><thead align="left"><tr id="row422407479084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p38454147084827"><a name="p38454147084827"></a><a name="p38454147084827"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p424613242084827"><a name="p424613242084827"></a><a name="p424613242084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row189124761084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga6f4847f443de5cdf3641386011335e21ac1a3ce4ddd663c55f87a8275ccf285ad"><a name="gga6f4847f443de5cdf3641386011335e21ac1a3ce4ddd663c55f87a8275ccf285ad"></a><a name="gga6f4847f443de5cdf3641386011335e21ac1a3ce4ddd663c55f87a8275ccf285ad"></a></strong>STREAM_FLAG_SYNCFRAME&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p112431522084827"><a name="p112431522084827"></a><a name="p112431522084827"></a>Synchronous frame </p>
 </td>
</tr>
<tr id="row1804773199084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga6f4847f443de5cdf3641386011335e21afd0d977a6a5d48657d694c9acb8ac2b5"><a name="gga6f4847f443de5cdf3641386011335e21afd0d977a6a5d48657d694c9acb8ac2b5"></a><a name="gga6f4847f443de5cdf3641386011335e21afd0d977a6a5d48657d694c9acb8ac2b5"></a></strong>STREAM_FLAG_CODECCONFIG&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1145003979084827"><a name="p1145003979084827"></a><a name="p1145003979084827"></a>Codec configuration information </p>
 </td>
</tr>
<tr id="row600113275084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga6f4847f443de5cdf3641386011335e21aa76ecb4ee6077a1ad3ceac569b875487"><a name="gga6f4847f443de5cdf3641386011335e21aa76ecb4ee6077a1ad3ceac569b875487"></a><a name="gga6f4847f443de5cdf3641386011335e21aa76ecb4ee6077a1ad3ceac569b875487"></a></strong>STREAM_FLAG_EOS&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1386613422084827"><a name="p1386613422084827"></a><a name="p1386613422084827"></a>End of Stream (EOS) </p>
 </td>
</tr>
<tr id="row160213229084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga6f4847f443de5cdf3641386011335e21a29e735a1e41790c24cc9ac9e7342dd2a"><a name="gga6f4847f443de5cdf3641386011335e21a29e735a1e41790c24cc9ac9e7342dd2a"></a><a name="gga6f4847f443de5cdf3641386011335e21a29e735a1e41790c24cc9ac9e7342dd2a"></a></strong>STREAM_FLAG_PARTIAL_FRAME&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1134015961084827"><a name="p1134015961084827"></a><a name="p1134015961084827"></a>Part of a frame </p>
 </td>
</tr>
<tr id="row2127820454084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga6f4847f443de5cdf3641386011335e21a8b2c1f065ce398ac48bac2b8e62e481b"><a name="gga6f4847f443de5cdf3641386011335e21a8b2c1f065ce398ac48bac2b8e62e481b"></a><a name="gga6f4847f443de5cdf3641386011335e21a8b2c1f065ce398ac48bac2b8e62e481b"></a></strong>STREAM_FLAG_ENDOFFRAME&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1909688815084827"><a name="p1909688815084827"></a><a name="p1909688815084827"></a>End of a frame. It is used in pair with <strong id="b471952525084827"><a name="b471952525084827"></a><a name="b471952525084827"></a>STREAM_FLAG_PARTIAL_FRAME</strong>. </p>
 </td>
</tr>
<tr id="row307349003084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga6f4847f443de5cdf3641386011335e21a9001c389dd39f08025e76ae2872fad02"><a name="gga6f4847f443de5cdf3641386011335e21a9001c389dd39f08025e76ae2872fad02"></a><a name="gga6f4847f443de5cdf3641386011335e21a9001c389dd39f08025e76ae2872fad02"></a></strong>STREAM_FLAG_MUXER_DATA&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p17817557084827"><a name="p17817557084827"></a><a name="p17817557084827"></a>Container file data, such as MP4 file data (not supported yet) </p>
 </td>
</tr>
</tbody>
</table>

## FormatDataType<a name="gaa3bfacc6563d8ec8bc870f4b216b4f46"></a>

```
enum [OHOS::Media::FormatDataType](MultiMedia_MediaCommon.md#gaa3bfacc6563d8ec8bc870f4b216b4f46) : uint32_t
```

 **Description:**

Enumerates formats. 

<a name="table1729189659084827"></a>
<table><thead align="left"><tr id="row1884199724084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1862078903084827"><a name="p1862078903084827"></a><a name="p1862078903084827"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1114579288084827"><a name="p1114579288084827"></a><a name="p1114579288084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1541119343084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa3bfacc6563d8ec8bc870f4b216b4f46a3a3f84f7e1a28c0f91a12f8a3bcfe8ec"><a name="ggaa3bfacc6563d8ec8bc870f4b216b4f46a3a3f84f7e1a28c0f91a12f8a3bcfe8ec"></a><a name="ggaa3bfacc6563d8ec8bc870f4b216b4f46a3a3f84f7e1a28c0f91a12f8a3bcfe8ec"></a></strong>FORMAT_TYPE_NONE&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p855446464084827"><a name="p855446464084827"></a><a name="p855446464084827"></a>None </p>
 </td>
</tr>
<tr id="row1562072175084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa3bfacc6563d8ec8bc870f4b216b4f46a48d8e70734d5c29f8766ad12037ca3ae"><a name="ggaa3bfacc6563d8ec8bc870f4b216b4f46a48d8e70734d5c29f8766ad12037ca3ae"></a><a name="ggaa3bfacc6563d8ec8bc870f4b216b4f46a48d8e70734d5c29f8766ad12037ca3ae"></a></strong>FORMAT_TYPE_INT32&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p310697696084827"><a name="p310697696084827"></a><a name="p310697696084827"></a>Int32 </p>
 </td>
</tr>
<tr id="row1675735983084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa3bfacc6563d8ec8bc870f4b216b4f46a108496713fc9bb4b77a8acf38a1396c9"><a name="ggaa3bfacc6563d8ec8bc870f4b216b4f46a108496713fc9bb4b77a8acf38a1396c9"></a><a name="ggaa3bfacc6563d8ec8bc870f4b216b4f46a108496713fc9bb4b77a8acf38a1396c9"></a></strong>FORMAT_TYPE_INT64&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1416055937084827"><a name="p1416055937084827"></a><a name="p1416055937084827"></a>Int64 </p>
 </td>
</tr>
<tr id="row364669055084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa3bfacc6563d8ec8bc870f4b216b4f46a3fd208a39e6c4f22d10882b03a547db1"><a name="ggaa3bfacc6563d8ec8bc870f4b216b4f46a3fd208a39e6c4f22d10882b03a547db1"></a><a name="ggaa3bfacc6563d8ec8bc870f4b216b4f46a3fd208a39e6c4f22d10882b03a547db1"></a></strong>FORMAT_TYPE_FLOAT&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1752753398084827"><a name="p1752753398084827"></a><a name="p1752753398084827"></a>Float </p>
 </td>
</tr>
<tr id="row1984391186084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa3bfacc6563d8ec8bc870f4b216b4f46abb224970f66920c7a443d19051fdc57f"><a name="ggaa3bfacc6563d8ec8bc870f4b216b4f46abb224970f66920c7a443d19051fdc57f"></a><a name="ggaa3bfacc6563d8ec8bc870f4b216b4f46abb224970f66920c7a443d19051fdc57f"></a></strong>FORMAT_TYPE_DOUBLE&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p97072231084827"><a name="p97072231084827"></a><a name="p97072231084827"></a>Double </p>
 </td>
</tr>
<tr id="row887182281084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa3bfacc6563d8ec8bc870f4b216b4f46a21c29eb61b772af7bead2a77a8c87cf6"><a name="ggaa3bfacc6563d8ec8bc870f4b216b4f46a21c29eb61b772af7bead2a77a8c87cf6"></a><a name="ggaa3bfacc6563d8ec8bc870f4b216b4f46a21c29eb61b772af7bead2a77a8c87cf6"></a></strong>FORMAT_TYPE_STRING&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1760781688084827"><a name="p1760781688084827"></a><a name="p1760781688084827"></a>String </p>
 </td>
</tr>
</tbody>
</table>

## SourceType<a name="ga4052b7b55dfd94f1d07678e79d80b507"></a>

```
enum [OHOS::Media::SourceType](MultiMedia_MediaCommon.md#ga4052b7b55dfd94f1d07678e79d80b507) : int32_t
```

 **Description:**

Enumerates media source types. 

<a name="table666313436084827"></a>
<table><thead align="left"><tr id="row1545036840084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1011297914084827"><a name="p1011297914084827"></a><a name="p1011297914084827"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1911016444084827"><a name="p1911016444084827"></a><a name="p1911016444084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row465427253084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga4052b7b55dfd94f1d07678e79d80b507ae456eda14b2359e13cc36f77af92c11b"><a name="gga4052b7b55dfd94f1d07678e79d80b507ae456eda14b2359e13cc36f77af92c11b"></a><a name="gga4052b7b55dfd94f1d07678e79d80b507ae456eda14b2359e13cc36f77af92c11b"></a></strong>SOURCE_TYPE_URI&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p598678038084827"><a name="p598678038084827"></a><a name="p598678038084827"></a>Local file path or network address </p>
 </td>
</tr>
<tr id="row1553608527084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga4052b7b55dfd94f1d07678e79d80b507a4134c6ec0b1a7fda26c38b8932e606e5"><a name="gga4052b7b55dfd94f1d07678e79d80b507a4134c6ec0b1a7fda26c38b8932e606e5"></a><a name="gga4052b7b55dfd94f1d07678e79d80b507a4134c6ec0b1a7fda26c38b8932e606e5"></a></strong>SOURCE_TYPE_FD&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p319103243084827"><a name="p319103243084827"></a><a name="p319103243084827"></a>Local file descriptor </p>
 </td>
</tr>
<tr id="row1681733945084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga4052b7b55dfd94f1d07678e79d80b507a538f01f856d995123459a44642a7dc86"><a name="gga4052b7b55dfd94f1d07678e79d80b507a538f01f856d995123459a44642a7dc86"></a><a name="gga4052b7b55dfd94f1d07678e79d80b507a538f01f856d995123459a44642a7dc86"></a></strong>SOURCE_TYPE_STREAM&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1605854539084827"><a name="p1605854539084827"></a><a name="p1605854539084827"></a>Stream data, such as Advanced Audio Coding (AAC) stream data </p>
 </td>
</tr>
</tbody>
</table>

## VideoCodecFormat<a name="ga797e6c5e38e23e730eff5bcc41427d7e"></a>

```
enum [VideoCodecFormat](MultiMedia_MediaCommon.md#ga797e6c5e38e23e730eff5bcc41427d7e)
```

 **Description:**

Enumerates video codec formats. 

<a name="table1691287843084827"></a>
<table><thead align="left"><tr id="row1185522903084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1831332001084827"><a name="p1831332001084827"></a><a name="p1831332001084827"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1693340674084827"><a name="p1693340674084827"></a><a name="p1693340674084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row427213262084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga797e6c5e38e23e730eff5bcc41427d7ea54ef59464d0b6788c6212bb1b5074503"><a name="gga797e6c5e38e23e730eff5bcc41427d7ea54ef59464d0b6788c6212bb1b5074503"></a><a name="gga797e6c5e38e23e730eff5bcc41427d7ea54ef59464d0b6788c6212bb1b5074503"></a></strong>VIDEO_DEFAULT&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1065966010084827"><a name="p1065966010084827"></a><a name="p1065966010084827"></a>Default format </p>
 </td>
</tr>
<tr id="row1445901875084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga797e6c5e38e23e730eff5bcc41427d7eac3f3371ea9f44c4076fec8f0d8f818cf"><a name="gga797e6c5e38e23e730eff5bcc41427d7eac3f3371ea9f44c4076fec8f0d8f818cf"></a><a name="gga797e6c5e38e23e730eff5bcc41427d7eac3f3371ea9f44c4076fec8f0d8f818cf"></a></strong>H264&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1187966369084827"><a name="p1187966369084827"></a><a name="p1187966369084827"></a>H.264 </p>
 </td>
</tr>
<tr id="row122830516084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga797e6c5e38e23e730eff5bcc41427d7eac2489c86e2690559ce3a00a03b15c324"><a name="gga797e6c5e38e23e730eff5bcc41427d7eac2489c86e2690559ce3a00a03b15c324"></a><a name="gga797e6c5e38e23e730eff5bcc41427d7eac2489c86e2690559ce3a00a03b15c324"></a></strong>HEVC&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p821233050084827"><a name="p821233050084827"></a><a name="p821233050084827"></a>High Efficiency Video Coding (HEVC) </p>
 </td>
</tr>
</tbody>
</table>

## **Function Documentation**<a name="section1482028229084827"></a>

## CopyFrom\(\)<a name="ga528134c9f87bf755077b3ef51d64e198"></a>

```
bool OHOS::Media::Format::CopyFrom (const [Format](OHOS-Media-Format.md) & format)
```

 **Description:**

Sets all metadata to a specified format. 

**Parameters:**

<a name="table1223418887084827"></a>
<table><thead align="left"><tr id="row1003934195084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1364152221084827"><a name="p1364152221084827"></a><a name="p1364152221084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p96944858084827"><a name="p96944858084827"></a><a name="p96944858084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row60114808084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">format</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the format. For details, see <a href="OHOS-Media-Format.md">Format</a>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the setting is successful; returns  **false**  otherwise. 



## ErrCodeOffset\(\)<a name="ga5534cc5ecbcb6eb719f55d8695bbb481"></a>

```
constexpr ErrCode OHOS::Media::ErrCodeOffset (unsigned int subsystem, unsigned int module = [/topic/body/section/screen/code
     {""}) 0 (code] )
```

 **Description:**

Generates a start error code with a unique identifier based on specified subsystem and module bit numbers. 

**Parameters:**

<a name="table1487741987084827"></a>
<table><thead align="left"><tr id="row1778556984084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1629590038084827"><a name="p1629590038084827"></a><a name="p1629590038084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p206126263084827"><a name="p206126263084827"></a><a name="p206126263084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2112699515084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">subsystem</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the subsystem bit number. </td>
</tr>
<tr id="row866939603084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">module</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the module bit number. </td>
</tr>
</tbody>
</table>

**Returns:**

## Format\(\)<a name="ga42435567c8fd61fd2da4834465aca98e"></a>

```
OHOS::Media::Format::Format ()
```

 **Description:**

Default constructor of the  [Format](OHOS-Media-Format.md)  instance. 

## GetBuffer\(\)<a name="ga8f897b8b2d5baf06e15accfeb97892ae"></a>

```
virtual uint8_t* OHOS::Media::StreamCallback::GetBuffer (size_t index)
```

 **Description:**

Obtains the virtual address of a buffer memory block based on its index. 

**Parameters:**

<a name="table1915855774084827"></a>
<table><thead align="left"><tr id="row692552529084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p714169067084827"><a name="p714169067084827"></a><a name="p714169067084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2061653012084827"><a name="p2061653012084827"></a><a name="p2061653012084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row229735302084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">index</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the index of the buffer memory block. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the virtual address of the buffer memory block. 



## GetDoubleValue\(\) \[1/2\]<a name="gafe949ed0c2d9dcb5c5e57c7fde226f3e"></a>

```
bool OHOS::Media::Format::GetDoubleValue (const std::string & key, double & value ) const
```

 **Description:**

Obtains the metadata value of the double-precision floating-point type. 

**Parameters:**

<a name="table306123497084827"></a>
<table><thead align="left"><tr id="row1583238156084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p209397585084827"><a name="p209397585084827"></a><a name="p209397585084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p593357016084827"><a name="p593357016084827"></a><a name="p593357016084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1257884333084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">key</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the metadata key. </td>
</tr>
<tr id="row1010970669084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">value</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the metadata value to obtain, which is a double-precision floating-point number. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the double-precision number is successfully obtained; returns  **false**  otherwise. 



## GetDoubleValue\(\) \[2/2\]<a name="gac1ed56f6d35982f770d083dc16e97dbd"></a>

```
bool OHOS::Media::FormatData::GetDoubleValue (double & val) const
```

 **Description:**

Obtains a double-precision floating-point number. 

**Parameters:**

<a name="table1623406514084827"></a>
<table><thead align="left"><tr id="row1037975223084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1670741716084827"><a name="p1670741716084827"></a><a name="p1670741716084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1648809297084827"><a name="p1648809297084827"></a><a name="p1648809297084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1538077344084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">val</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the double-precision floating-point number to obtain. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the double-precision number is successfully obtained; returns  **false**  otherwise. 



## GetFloatValue\(\) \[1/2\]<a name="gac4e963a9fe320c0143ed33df5f737cb3"></a>

```
bool OHOS::Media::Format::GetFloatValue (const std::string & key, float & value ) const
```

 **Description:**

Obtains the metadata value of the single-precision floating-point type. 

**Parameters:**

<a name="table1207456323084827"></a>
<table><thead align="left"><tr id="row9215632084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1819108599084827"><a name="p1819108599084827"></a><a name="p1819108599084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1673534505084827"><a name="p1673534505084827"></a><a name="p1673534505084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1668725450084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">key</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the metadata key. </td>
</tr>
<tr id="row329897612084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">value</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the metadata value to obtain, which is a single-precision floating-point number. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the single-precision number is successfully obtained; returns  **false**  otherwise. 



## GetFloatValue\(\) \[2/2\]<a name="gada31b9cf5daa944104417442a5e459dc"></a>

```
bool OHOS::Media::FormatData::GetFloatValue (float & val) const
```

 **Description:**

Obtains a single-precision floating-point number. 

**Parameters:**

<a name="table2102723691084827"></a>
<table><thead align="left"><tr id="row823802121084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2056588304084827"><a name="p2056588304084827"></a><a name="p2056588304084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p158237626084827"><a name="p158237626084827"></a><a name="p158237626084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row781251317084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">val</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the single-precision floating-point number to obtain. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the single-precision number is successfully obtained; returns  **false**  otherwise. 



## GetFormatMap\(\)<a name="ga4adff4846515cef00987a360a4d117af"></a>

```
const std::map<std::string, [FormatData](OHOS-Media-FormatData.md) *>& OHOS::Media::Format::GetFormatMap () const
```

 **Description:**

Obtains the metadata map. 

**Returns:**

Returns the map object. 



## GetInt32Value\(\)<a name="gac116d67e5e80f1f9c1c573ceb24df36a"></a>

```
bool OHOS::Media::FormatData::GetInt32Value (int32_t & val) const
```

 **Description:**

Obtains a 32-bit integer. 

**Parameters:**

<a name="table346791400084827"></a>
<table><thead align="left"><tr id="row304632793084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1505317525084827"><a name="p1505317525084827"></a><a name="p1505317525084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1769650920084827"><a name="p1769650920084827"></a><a name="p1769650920084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row458031999084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">val</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the 32-bit integer to obtain. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the integer is successfully obtained; returns  **false**  otherwise. 



## GetInt64Value\(\)<a name="ga1f24cb15577c40f7044f4beb96515cfc"></a>

```
bool OHOS::Media::FormatData::GetInt64Value (int64_t & val) const
```

 **Description:**

Obtains a long integer. 

**Parameters:**

<a name="table565811961084827"></a>
<table><thead align="left"><tr id="row193889095084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2045504034084827"><a name="p2045504034084827"></a><a name="p2045504034084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p167310057084827"><a name="p167310057084827"></a><a name="p167310057084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row163588946084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">val</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the long integer to obtain. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the integer is successfully obtained; returns  **false**  otherwise. 



## GetIntValue\(\)<a name="ga798ef733a253558757f49714090b3969"></a>

```
bool OHOS::Media::Format::GetIntValue (const std::string & key, int32_t & value ) const
```

 **Description:**

Obtains the metadata value of the integer type. 

**Parameters:**

<a name="table144264433084827"></a>
<table><thead align="left"><tr id="row1923341308084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p312697399084827"><a name="p312697399084827"></a><a name="p312697399084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1767876810084827"><a name="p1767876810084827"></a><a name="p1767876810084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row239731335084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">key</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the metadata key. </td>
</tr>
<tr id="row299469951084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">value</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the metadata value to obtain, which is a 32-bit integer. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the integer is successfully obtained; returns  **false**  otherwise. 



## GetLongValue\(\)<a name="ga7f1c503f40b78083cb9b9ae9ce93d3b4"></a>

```
bool OHOS::Media::Format::GetLongValue (const std::string & key, int64_t & value ) const
```

 **Description:**

Obtains the metadata value of the long integer type. 

**Parameters:**

<a name="table1445624835084827"></a>
<table><thead align="left"><tr id="row300664917084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p855154353084827"><a name="p855154353084827"></a><a name="p855154353084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p227404236084827"><a name="p227404236084827"></a><a name="p227404236084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row36698075084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">key</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the metadata key. </td>
</tr>
<tr id="row784830089084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">value</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the metadata value to obtain, which is a 64-bit long integer. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the integer is successfully obtained; returns  **false**  otherwise. 



## GetSourceHeader\(\)<a name="ga6bb820da4b770311efc550ad27d7ce4a"></a>

```
const std::map<std::string, std::string>& OHOS::Media::Source::GetSourceHeader () const
```

 **Description:**

Obtains the HTTP header for the media source. 

This function is called only when the  [SourceType](Format.md#ga3ae727773c367ac1041d72ac770a0ab1)  is  [SOURCE\_TYPE\_URI](Format.md#gga3ae727773c367ac1041d72ac770a0ab1a70d32ea5aeaa325764508722ba31403c).

**Returns:**

Returns the media source header. 



## GetSourceStream\(\)<a name="ga395325402881ad38ef40c9ebd13f174d"></a>

```
const std::shared_ptr<[StreamSource](OHOS-Media-StreamSource.md)>& OHOS::Media::Source::GetSourceStream () const
```

 **Description:**

Obtains information about the media source stream. 

This function is called only when the  [SourceType](Format.md#ga3ae727773c367ac1041d72ac770a0ab1)  is  [SOURCE\_TYPE\_STREAM](Format.md#gga3ae727773c367ac1041d72ac770a0ab1a7f632a791d8f6dfbe5940b5648d29e6c).

**Returns:**

Returns information about the media source stream. For details, see  [StreamSource](OHOS-Media-StreamSource.md). 



## GetSourceStreamFormat\(\)<a name="gafbd3c732660124a1dc1d9dd0dfb51393"></a>

```
const [Format](OHOS-Media-Format.md)& OHOS::Media::Source::GetSourceStreamFormat () const
```

 **Description:**

Obtains the media source stream format. 

**Returns:**

Returns the media source stream format. For details, see  [Format](OHOS-Media-Format.md). 



## GetSourceType\(\)<a name="ga93a8f8b86a9385436f6bbce10a860770"></a>

```
[SourceType](MultiMedia_MediaCommon.md#ga4052b7b55dfd94f1d07678e79d80b507) OHOS::Media::Source::GetSourceType () const
```

 **Description:**

Obtains the source type. 

**Returns:**

Returns the source type. For details, see  [SourceType](Format.md#ga3ae727773c367ac1041d72ac770a0ab1). 



## GetSourceUri\(\)<a name="ga69ed2683ce3a632f6b2295fb398e4b7b"></a>

```
const std::string& OHOS::Media::Source::GetSourceUri () const
```

 **Description:**

Obtains the media source URI. 

This function is called only when the  [SourceType](Format.md#ga3ae727773c367ac1041d72ac770a0ab1)  is  [SOURCE\_TYPE\_URI](Format.md#gga3ae727773c367ac1041d72ac770a0ab1a70d32ea5aeaa325764508722ba31403c).

**Returns:**

Returns the media source URI. 



## GetStringValue\(\) \[1/2\]<a name="ga089a3e44e128fb662b72c56b53c7068b"></a>

```
bool OHOS::Media::Format::GetStringValue (const std::string & key, std::string & value ) const
```

 **Description:**

Obtains the metadata value of the string type. 

**Parameters:**

<a name="table1853575487084827"></a>
<table><thead align="left"><tr id="row823562522084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1745415787084827"><a name="p1745415787084827"></a><a name="p1745415787084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1648069532084827"><a name="p1648069532084827"></a><a name="p1648069532084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row380547693084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">key</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the metadata key. </td>
</tr>
<tr id="row765604528084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">value</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the metadata value to obtain, which is a string. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the string is successfully obtained; returns  **false**  otherwise. 



## GetStringValue\(\) \[2/2\]<a name="ga9687bb5d98a92e7beb53dfe4ac44eec1"></a>

```
bool OHOS::Media::FormatData::GetStringValue (std::string & val) const
```

 **Description:**

Obtains a string. 

**Parameters:**

<a name="table587222854084827"></a>
<table><thead align="left"><tr id="row1377942074084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1959406678084827"><a name="p1959406678084827"></a><a name="p1959406678084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1521211221084827"><a name="p1521211221084827"></a><a name="p1521211221084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1554306443084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">val</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the string to obtain. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the string is successfully obtained; returns  **false**  otherwise. 



## GetType\(\)<a name="ga178a65e0d58071de84e2dbc09ac93407"></a>

```
[FormatDataType](MultiMedia_MediaCommon.md#gaa3bfacc6563d8ec8bc870f4b216b4f46) OHOS::Media::FormatData::GetType () const
```

 **Description:**

Obtains the format type. 

**Returns:**

Returns the format type. For details, see  **OHOS::Media::FormatDataType**. 



## OnBufferAvailable\(\)<a name="gaaebd4fe9df44b434f410aec32cf23467"></a>

```
virtual void OHOS::Media::StreamSource::OnBufferAvailable (size_t index, size_t offset, size_t size )
```

 **Description:**

Notifies your application of the information about the buffer memory block that can be filled with data. 

**Parameters:**

<a name="table193691144084827"></a>
<table><thead align="left"><tr id="row1230751493084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p690597296084827"><a name="p690597296084827"></a><a name="p690597296084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1897341030084827"><a name="p1897341030084827"></a><a name="p1897341030084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row650777896084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">index</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the index of the buffer memory block. </td>
</tr>
<tr id="row733064938084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">offset</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the start offset into which the data will be written. </td>
</tr>
<tr id="row1522243471084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">size</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of data that the buffer memory block can store. </td>
</tr>
</tbody>
</table>

## PutDoubleValue\(\)<a name="ga9a98a92eb4436301853a049b5f3313c6"></a>

```
bool OHOS::Media::Format::PutDoubleValue (const std::string & key, double value )
```

 **Description:**

Sets metadata of the double-precision floating-point type. 

**Parameters:**

<a name="table339672723084827"></a>
<table><thead align="left"><tr id="row701591480084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p543889068084827"><a name="p543889068084827"></a><a name="p543889068084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1942162896084827"><a name="p1942162896084827"></a><a name="p1942162896084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1494010133084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">key</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the metadata key. </td>
</tr>
<tr id="row1539941719084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">value</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the metadata value, which is a double-precision floating-point number. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the setting is successful; returns  **false**  otherwise. 



## PutFloatValue\(\)<a name="gabec9417120824f5bb9eb676be380016f"></a>

```
bool OHOS::Media::Format::PutFloatValue (const std::string & key, float value )
```

 **Description:**

Sets metadata of the single-precision floating-point type. 

**Parameters:**

<a name="table1453605608084827"></a>
<table><thead align="left"><tr id="row1803431125084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p691755615084827"><a name="p691755615084827"></a><a name="p691755615084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p679674636084827"><a name="p679674636084827"></a><a name="p679674636084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1429899081084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">key</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the metadata key. </td>
</tr>
<tr id="row1592516618084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">value</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the metadata value, which is a single-precision floating-point number. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the metadata is successfully set; returns  **false**  otherwise. 



## PutIntValue\(\)<a name="ga66771efe315d001e79a14d316c58718e"></a>

```
bool OHOS::Media::Format::PutIntValue (const std::string & key, int32_t value )
```

 **Description:**

Sets metadata of the integer type. 

**Parameters:**

<a name="table1519475327084827"></a>
<table><thead align="left"><tr id="row224624037084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p844788498084827"><a name="p844788498084827"></a><a name="p844788498084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1124434656084827"><a name="p1124434656084827"></a><a name="p1124434656084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1917047706084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">key</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the metadata key. </td>
</tr>
<tr id="row1112840411084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">value</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the metadata value, which is a 32-bit integer. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the setting is successful; returns  **false**  otherwise. 



## PutLongValue\(\)<a name="ga5b4477636095d80ec4e65c1be617c61c"></a>

```
bool OHOS::Media::Format::PutLongValue (const std::string & key, int64_t value )
```

 **Description:**

Sets metadata of the long integer type. 

**Parameters:**

<a name="table1960325155084827"></a>
<table><thead align="left"><tr id="row215211800084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p312402398084827"><a name="p312402398084827"></a><a name="p312402398084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2099424252084827"><a name="p2099424252084827"></a><a name="p2099424252084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1134181052084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">key</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the metadata key. </td>
</tr>
<tr id="row668593143084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">value</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the metadata value, which is a 64-bit integer. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the setting is successful; returns  **false**  otherwise. 



## PutStringValue\(\)<a name="gabdc104597559320256930f420eaab82f"></a>

```
bool OHOS::Media::Format::PutStringValue (const std::string & key, const std::string & value )
```

 **Description:**

Sets metadata of the string type. 

**Parameters:**

<a name="table1986647005084827"></a>
<table><thead align="left"><tr id="row357965652084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p290477630084827"><a name="p290477630084827"></a><a name="p290477630084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p947266387084827"><a name="p947266387084827"></a><a name="p947266387084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1175259231084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">key</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the metadata key. </td>
</tr>
<tr id="row198001923084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">value</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the metadata value, which is a string. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the metadata is successfully set; returns  **false**  otherwise. 



## QueueBuffer\(\)<a name="gaa62705632557f47f9fd9632157e53a21"></a>

```
virtual void OHOS::Media::StreamCallback::QueueBuffer (size_t index, size_t offset, size_t size, int64_t timestampUs, uint32_t flags )
```

 **Description:**

Writes the filled buffer memory block into the player memory. 

**Parameters:**

<a name="table664585084827"></a>
<table><thead align="left"><tr id="row519041973084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p532190043084827"><a name="p532190043084827"></a><a name="p532190043084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1205888159084827"><a name="p1205888159084827"></a><a name="p1205888159084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1677975308084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">index</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the index of the buffer memory block. </td>
</tr>
<tr id="row899519529084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">offset</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the start offset into which the buffer memory block will be written. </td>
</tr>
<tr id="row995777526084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">size</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of the data filled in the buffer memory block. </td>
</tr>
<tr id="row418448053084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">timestampUs</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the timestamp of the frame filled in the buffer memory block. As data in AAC streams can be filled not on a frame basis, set this parameter to <strong id="b910769634084827"><a name="b910769634084827"></a><a name="b910769634084827"></a>0</strong> for AAC streams. </td>
</tr>
<tr id="row734848441084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">flags</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the type of the current buffer memory block. For details, see <a href="MultiMedia_MediaCommon.md#ga6f4847f443de5cdf3641386011335e21">BufferFlags</a>. </td>
</tr>
</tbody>
</table>

## SetParameters\(\)<a name="ga29f8c86744bda61f84920654c5f40df0"></a>

```
virtual void OHOS::Media::StreamCallback::SetParameters (const [Format](OHOS-Media-Format.md) & params)
```

 **Description:**

Sets additional information about a stream. 

**Parameters:**

<a name="table1394020402084827"></a>
<table><thead align="left"><tr id="row87536131084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1522743629084827"><a name="p1522743629084827"></a><a name="p1522743629084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p838863813084827"><a name="p838863813084827"></a><a name="p838863813084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row838225041084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">params</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameters for additional stream information. For details, see <a href="OHOS-Media-Format.md">Format</a>. </td>
</tr>
</tbody>
</table>

## SetStreamCallback\(\)<a name="ga078516891396a86226c945e02c79c1f5"></a>

```
virtual void OHOS::Media::StreamSource::SetStreamCallback (const std::shared_ptr< [StreamCallback](OHOS-Media-StreamCallback.md) > & callback)
```

 **Description:**

Sets a callback function for your application. 

**Parameters:**

<a name="table1666835986084827"></a>
<table><thead align="left"><tr id="row1771683469084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1559301451084827"><a name="p1559301451084827"></a><a name="p1559301451084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p575524603084827"><a name="p575524603084827"></a><a name="p575524603084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row520845267084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">callback</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the <a href="OHOS-Media-StreamCallback.md">StreamCallback</a> function to set. </td>
</tr>
</tbody>
</table>

## SetValue\(\) \[1/5\]<a name="gacbbf1dca947de8bce2e1a323a1c2664a"></a>

```
bool OHOS::Media::FormatData::SetValue (const std::string & val)
```

 **Description:**

Sets a string. 

**Parameters:**

<a name="table1749912443084827"></a>
<table><thead align="left"><tr id="row1017713231084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1668717586084827"><a name="p1668717586084827"></a><a name="p1668717586084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p315203462084827"><a name="p315203462084827"></a><a name="p315203462084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1263206815084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">val</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the string to set. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the setting is successful; returns  **false**  otherwise. 



## SetValue\(\) \[2/5\]<a name="ga5e9360adeb46e7b147757ca22c65c268"></a>

```
bool OHOS::Media::FormatData::SetValue (double val)
```

 **Description:**

Sets a double-precision floating-point number. 

**Parameters:**

<a name="table220087700084827"></a>
<table><thead align="left"><tr id="row225485580084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1420025553084827"><a name="p1420025553084827"></a><a name="p1420025553084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1353321550084827"><a name="p1353321550084827"></a><a name="p1353321550084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row387631089084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">val</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the double-precision floating-point number to set. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the double-precision floating-point number is successfully set; returns  **false**  otherwise. 



## SetValue\(\) \[3/5\]<a name="gaa5ca8643885118cd0b3668d5497a90da"></a>

```
bool OHOS::Media::FormatData::SetValue (float val)
```

 **Description:**

Sets a single-precision floating-point number. 

**Parameters:**

<a name="table2054500788084827"></a>
<table><thead align="left"><tr id="row1566922971084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1503413714084827"><a name="p1503413714084827"></a><a name="p1503413714084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p9046722084827"><a name="p9046722084827"></a><a name="p9046722084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1842586088084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">val</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the single-precision floating-point number to set. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the setting is successful; returns  **false**  otherwise. 



## SetValue\(\) \[4/5\]<a name="gaa1a80e9075010faca14c5c71855efe2d"></a>

```
bool OHOS::Media::FormatData::SetValue (int32_t val)
```

 **Description:**

Sets a 32-bit integer. 

**Parameters:**

<a name="table2096391454084827"></a>
<table><thead align="left"><tr id="row201446886084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2038561275084827"><a name="p2038561275084827"></a><a name="p2038561275084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p611276604084827"><a name="p611276604084827"></a><a name="p611276604084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row847963681084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">val</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the 32-bit integer to set. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the setting is successful; returns  **false**  otherwise. 



## SetValue\(\) \[5/5\]<a name="gabb73fee1739b96b402a430f7879b2ca6"></a>

```
bool OHOS::Media::FormatData::SetValue (int64_t val)
```

 **Description:**

Sets a 64-bit long integer. 

**Parameters:**

<a name="table2101402092084827"></a>
<table><thead align="left"><tr id="row1455709712084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2010697132084827"><a name="p2010697132084827"></a><a name="p2010697132084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p71713387084827"><a name="p71713387084827"></a><a name="p71713387084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1189617135084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">val</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the 64-bit long integer to set. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the setting is successful; returns  **false**  otherwise. 



## Source\(\) \[1/3\]<a name="gae3640fec3bb0f33f4076dc30e88dac61"></a>

```
OHOS::Media::Source::Source (const std::shared_ptr< [StreamSource](OHOS-Media-StreamSource.md) > & stream, const [Format](OHOS-Media-Format.md) & formats )
```

 **Description:**

A constructor used to create a  [Source](OHOS-Media-Source.md)  instance based on the stream source and format information. 

**Parameters:**

<a name="table242372173084827"></a>
<table><thead align="left"><tr id="row393154425084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p235140208084827"><a name="p235140208084827"></a><a name="p235140208084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1405494520084827"><a name="p1405494520084827"></a><a name="p1405494520084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1935164454084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the media source stream. For details, see <a href="OHOS-Media-StreamSource.md">StreamSource</a>. </td>
</tr>
<tr id="row1039576117084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">formats</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates stream data information, which is subject to the stream type. For example, the key is <strong id="b1636651062084827"><a name="b1636651062084827"></a><a name="b1636651062084827"></a>CODEC_MIME</strong>, and the value is <strong id="b2123735290084827"><a name="b2123735290084827"></a><a name="b2123735290084827"></a>MIME_AUDIO_AAC</strong>. For details, see <a href="OHOS-Media-Format.md">Format</a>. This parameter can be null if no information needs to be passed. </td>
</tr>
</tbody>
</table>

## Source\(\) \[2/3\]<a name="gab9bfa209ae382e3ba5d5242e8dfe5b20"></a>

```
OHOS::Media::Source::Source (const std::string & uri)
```

 **Description:**

A constructor used to create a  [Source](OHOS-Media-Source.md)  instance based on a specified URI. 

**Parameters:**

<a name="table31534194084827"></a>
<table><thead align="left"><tr id="row1206831346084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p859447337084827"><a name="p859447337084827"></a><a name="p859447337084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p574249877084827"><a name="p574249877084827"></a><a name="p574249877084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row913305849084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">uri</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the media source URI, which can be a network URI or local file path. </td>
</tr>
</tbody>
</table>

## Source\(\) \[3/3\]<a name="ga84e570aa39e0810815e3f90419b2a0f0"></a>

```
OHOS::Media::Source::Source (const std::string & uri, const std::map< std::string, std::string > & header )
```

 **Description:**

A constructor used to create a  [Source](OHOS-Media-Source.md)  instance based on a specified URI and header. 

If the HTTP URL header does not carry valid information for network playback, this function is equivalent to  [Source\(const std::string& uri\)](MultiMedia_MediaCommon.md#gab9bfa209ae382e3ba5d5242e8dfe5b20).

**Parameters:**

<a name="table488254059084827"></a>
<table><thead align="left"><tr id="row398967377084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1630405853084827"><a name="p1630405853084827"></a><a name="p1630405853084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p600335556084827"><a name="p600335556084827"></a><a name="p600335556084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2133477155084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">uri</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the media source URI. </td>
</tr>
<tr id="row1488521938084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">header</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the header. </td>
</tr>
</tbody>
</table>

## **Variable Documentation**<a name="section1112834779084827"></a>

## BITRATE\_MODE\_CBR<a name="gaec6a6f6857ff914973ae8dbd6d24435d"></a>

```
const int BITRATE_MODE_CBR = 2
```

 **Description:**

Indicates the constant bit rate mode. In this mode, the codec keeps the output bit rate as constant as possible. 

## BITRATE\_MODE\_CQ<a name="gaa1ea5c3322d75d18fbff0422b758d602"></a>

```
const int BITRATE_MODE_CQ = 0
```

 **Description:**

Indicates the constant quality mode. In this mode, the bit rate is not limited to guarantee the image quality to the largest extent. 

## BITRATE\_MODE\_VBR<a name="gad5d276721fde992fff0b3302a6d2c1dc"></a>

```
const int BITRATE_MODE_VBR = 1
```

 **Description:**

Indicates the variable bit rate mode. In this mode, the codec dynamically adjusts the output bit rate based on the image complexity. The codec increases the bit rate if the image is complex and decreases the bit rate if the image is simple. 

## CODEC\_MIME<a name="ga1b77959b9e9bb70ec3f3a85ddba29f81"></a>

```
const char* OHOS::Media::CODEC_MIME
```

 **Description:**

Indicates the key representing the codec type. 

## COLOR\_FORMAT\_ARGB8888\_32BIT<a name="gaf8f714899f0b11248ea310f8b682ca52"></a>

```
const int32_t COLOR_FORMAT_ARGB8888_32BIT = 16
```

 **Description:**

Indicates the ARGB8888 color format. 

## COLOR\_FORMAT\_YUV420SP<a name="ga4a599efd2466cfef88ed7c8332341f28"></a>

```
const int32_t COLOR_FORMAT_YUV420SP = 21
```

 **Description:**

Indicates the YUV420SP color format. 

## deviceId<a name="gae354490defc2b40c8aeb7b98700cbbd0"></a>

```
uint32_t AudioDeviceDesc::deviceId
```

 **Description:**

Bits 31-24: reserved bits; bits 23-16: mode ID; bits 15-8: device ID; bits 7-0: channel ID 

## deviceName<a name="gaa24e76abf7ecc4088c6888128109d3e8"></a>

```
std::string AudioDeviceDesc::deviceName
```

 **Description:**

Device name 

## ERR\_EARLY\_PREPARE<a name="ga780504ecfc7b140c8fcac6000d21d2cc"></a>

```
const int32_t OHOS::Media::ERR_EARLY_PREPARE = BASE_MEDIA_ERR_OFFSET + 3
```

 **Description:**

Early media preparation 

## ERR\_ILLEGAL\_STATE<a name="ga7d62e4ebba157bb7891397f67686da20"></a>

```
const int32_t OHOS::Media::ERR_ILLEGAL_STATE = BASE_MEDIA_ERR_OFFSET + 1
```

 **Description:**

Status error 

## ERR\_INVALID\_OPERATION<a name="gaea6d0afbc7c159296297185d13289c45"></a>

```
const int32_t OHOS::Media::ERR_INVALID_OPERATION = BASE_MEDIA_ERR_OFFSET + 5
```

 **Description:**

Invalid operation 

## ERR\_INVALID\_PARAM<a name="gab54ceb09402da2ac1bec5e93a95dd5a2"></a>

```
const int32_t OHOS::Media::ERR_INVALID_PARAM = BASE_MEDIA_ERR_OFFSET + 2
```

 **Description:**

Invalid parameter 

## ERR\_INVALID\_READ<a name="gaa3475307553e2de4dd7ef799bdc98c14"></a>

```
const int32_t OHOS::Media::ERR_INVALID_READ = -1
```

 **Description:**

Invalid data size that has been read 

## ERR\_NOFREE\_CHANNEL<a name="ga59c64e4fd1f5890b84e263cb8f1b4a86"></a>

```
const int32_t OHOS::Media::ERR_NOFREE_CHANNEL = BASE_MEDIA_ERR_OFFSET + 6
```

 **Description:**

No idle channel 

## ERR\_NOT\_STARTED<a name="ga09c48c16cb88d0f8860fb7bded0d1369"></a>

```
const int32_t OHOS::Media::ERR_NOT_STARTED = BASE_MEDIA_ERR_OFFSET + 8
```

 **Description:**

Device not started 

## ERR\_READ\_BUFFER<a name="ga93ac3a083852a72b74871883236586ca"></a>

```
const int32_t OHOS::Media::ERR_READ_BUFFER = BASE_MEDIA_ERR_OFFSET + 7
```

 **Description:**

Buffer reading failed 

## ERR\_SOURCE\_NOT\_SET<a name="gafad29c0ac3ef7729944bb907c9abc139"></a>

```
const int32_t OHOS::Media::ERR_SOURCE_NOT_SET = BASE_MEDIA_ERR_OFFSET + 4
```

 **Description:**

No media source 

## ERR\_UNKNOWN<a name="gaac1feac62b2f5501fb7ea1903c9f2cfc"></a>

```
const int32_t OHOS::Media::ERR_UNKNOWN = BASE_MEDIA_ERR_OFFSET + 200
```

 **Description:**

Unknown error 

## ERROR<a name="ga9881ac3b69915a2e0e9c401759f77952"></a>

```
const int32_t OHOS::Media::ERROR = BASE_MEDIA_ERR_OFFSET
```

 **Description:**

Fail 

## inputSourceType<a name="ga8c4f565aa744ec55a784529a843f853e"></a>

```
[AudioSourceType](MultiMedia_MediaCommon.md#gadc3158e093b995ca7b9b6aa32388ccdd) AudioDeviceDesc::inputSourceType
```

 **Description:**

Type of the audio input source 

## KEY\_IS\_SYNC\_FRAME<a name="gaa0ad827cdc16d18a73f280911c009cf1"></a>

```
const std::string KEY_IS_SYNC_FRAME = "is-sync-frame"
```

 **Description:**

Indicates that the current frame is an Instantaneous Decoder Refresh \(IDR\) frame. 

## KEY\_TIME\_US<a name="gadac31555c0ac0612c9f72356f9eb1685"></a>

```
const std::string KEY_TIME_US = "timeUs"
```

 **Description:**

Indicates the frame timestamp. 

## MIME\_AUDIO\_AAC<a name="ga9cfdd72ca1bf4a012f2307985a37871f"></a>

```
const char* OHOS::Media::MIME_AUDIO_AAC
```

 **Description:**

Indicates the codec for Advanced Audio Coding \(AAC\) streams, which is a value of the codec type key. 

## MIME\_AUDIO\_RAW<a name="ga28a526cce33c93a3c3b797ca94fe03e9"></a>

```
const char* OHOS::Media::MIME_AUDIO_RAW
```

 **Description:**

Indicates the codec for RAW audios \(not supported yet\), which is a value of the codec type key. 

## SUCCESS<a name="gaad1937270d3d6c2012ed0e014bd2dc28"></a>

```
const int32_t OHOS::Media::SUCCESS = 0
```

 **Description:**

Success 

