# OHOS::UICheckBox<a name="ZH-CN_TOPIC_0000001054479587"></a>

## **Overview**<a name="section1596385865093534"></a>

**Related Modules:**

[Graphic](Graphic.md)

**Description:**

Represents a check box. 

A check box permits users to make a binary choice.

**Since:**

1.0

**Version:**

1.0

## **Summary**<a name="section1891369728093534"></a>

## Data Structures<a name="nested-classes"></a>

<a name="table416395123093534"></a>
<table><thead align="left"><tr id="row329593020093534"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1151139609093534"><a name="p1151139609093534"></a><a name="p1151139609093534"></a>Data Structure Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2051633246093534"><a name="p2051633246093534"></a><a name="p2051633246093534"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row874576284093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p765280160093534"><a name="p765280160093534"></a><a name="p765280160093534"></a><a href="OHOS-UICheckBox-OnChangeListener.md">OnChangeListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1398100299093534"><a name="p1398100299093534"></a><a name="p1398100299093534"></a>Represents a listener for changes of a check box. </p>
</td>
</tr>
</tbody>
</table>

## Public Types<a name="pub-types"></a>

<a name="table1433914290093534"></a>
<table><thead align="left"><tr id="row1962415070093534"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1073436967093534"><a name="p1073436967093534"></a><a name="p1073436967093534"></a>Public Type Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1993878722093534"><a name="p1993878722093534"></a><a name="p1993878722093534"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row864153789093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1827006580093534"><a name="p1827006580093534"></a><a name="p1827006580093534"></a><a href="Graphic.md#ga15a3f0302aded0e4d1584ddc6002335d">UICheckBoxState</a> : uint8_t </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p113914405093534"><a name="p113914405093534"></a><a name="p113914405093534"></a>Enumerates the states of a check box. </p>
</td>
</tr>
</tbody>
</table>

## Public Member Functions<a name="pub-methods"></a>

<a name="table1638165491093534"></a>
<table><thead align="left"><tr id="row1172162000093534"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p115057146093534"><a name="p115057146093534"></a><a name="p115057146093534"></a>Public Member Function Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p377912844093534"><a name="p377912844093534"></a><a name="p377912844093534"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row600057843093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p89647485093534"><a name="p89647485093534"></a><a name="p89647485093534"></a><a href="Graphic.md#ga811085fbe237690f21a95e7df2a7c45f">UICheckBox</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p96822977093534"><a name="p96822977093534"></a><a name="p96822977093534"></a>&nbsp;</p>
<p id="p52061819093534"><a name="p52061819093534"></a><a name="p52061819093534"></a>A constructor used to create a <strong id="b71287992093534"><a name="b71287992093534"></a><a name="b71287992093534"></a><a href="OHOS-UICheckBox.md">UICheckBox</a></strong> instance. </p>
</td>
</tr>
<tr id="row171140164093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p376440529093534"><a name="p376440529093534"></a><a name="p376440529093534"></a><a href="Graphic.md#ga061c90b24caa6595b70a9da9f96c5c4e">~UICheckBox</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1962041088093534"><a name="p1962041088093534"></a><a name="p1962041088093534"></a>virtual&nbsp;</p>
<p id="p1166504285093534"><a name="p1166504285093534"></a><a name="p1166504285093534"></a>A destructor used to delete the <strong id="b351750993093534"><a name="b351750993093534"></a><a name="b351750993093534"></a><a href="OHOS-UICheckBox.md">UICheckBox</a></strong> instance. </p>
</td>
</tr>
<tr id="row2104694493093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p532926469093534"><a name="p532926469093534"></a><a name="p532926469093534"></a><a href="Graphic.md#ga6820cef1fb685db5796670ca56b6aace">GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p671911426093534"><a name="p671911426093534"></a><a name="p671911426093534"></a>UIViewType&nbsp;</p>
<p id="p1186159683093534"><a name="p1186159683093534"></a><a name="p1186159683093534"></a>Obtains the component type. </p>
</td>
</tr>
<tr id="row1300059147093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p555154726093534"><a name="p555154726093534"></a><a name="p555154726093534"></a><a href="Graphic.md#gad72c8f6a67fc3fb86da8eabffcf5315d">SetOnChangeListener</a> (<a href="OHOS-UICheckBox-OnChangeListener.md">OnChangeListener</a> *onStateChangeListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1890812952093534"><a name="p1890812952093534"></a><a name="p1890812952093534"></a>void&nbsp;</p>
<p id="p416989739093534"><a name="p416989739093534"></a><a name="p416989739093534"></a>Sets the listener for this check box. </p>
</td>
</tr>
<tr id="row1844001752093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2021926522093534"><a name="p2021926522093534"></a><a name="p2021926522093534"></a><a href="Graphic.md#ga53cc6c8f18b90c3abd96a791c8921010">OnPreDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1837687076093534"><a name="p1837687076093534"></a><a name="p1837687076093534"></a>bool&nbsp;</p>
<p id="p1187616138093534"><a name="p1187616138093534"></a><a name="p1187616138093534"></a>Do something before draw, this function will be invoked mainly to check if this view need to cover invalidate area so render manager can decide which layer to draw firstly. </p>
</td>
</tr>
<tr id="row1099769521093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p307573093534"><a name="p307573093534"></a><a name="p307573093534"></a><a href="Graphic.md#ga8e75f8411fb25e564c82573a12773189">OnDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1221058555093534"><a name="p1221058555093534"></a><a name="p1221058555093534"></a>void&nbsp;</p>
<p id="p1057409039093534"><a name="p1057409039093534"></a><a name="p1057409039093534"></a>Executes the draw action Ondraw invokes the rendering function provided by the underlying layer to draw pictures based on the selected status of the checkbox. </p>
</td>
</tr>
<tr id="row1453826996093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1287780928093534"><a name="p1287780928093534"></a><a name="p1287780928093534"></a><a href="Graphic.md#ga31d4f10f4c32b0fb284645450875ae0c">OnClickEvent</a> (const <a href="OHOS-ClickEvent.md">ClickEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1035039181093534"><a name="p1035039181093534"></a><a name="p1035039181093534"></a>void&nbsp;</p>
<p id="p2127222315093534"><a name="p2127222315093534"></a><a name="p2127222315093534"></a>Executes the click event action OnClickEvent will reverse the selected state of checkbox. Example: If the check box is selected, the checkbox status is changed to Unselected after the click action is taken. </p>
</td>
</tr>
<tr id="row893814837093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1758749104093534"><a name="p1758749104093534"></a><a name="p1758749104093534"></a><a href="Graphic.md#ga2e1ac9e3084d018febf5ac0912a27c72">SetImages</a> (const char *selectedImageSrc, const char *unselectedImageSrc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1063152366093534"><a name="p1063152366093534"></a><a name="p1063152366093534"></a>virtual void&nbsp;</p>
<p id="p434975503093534"><a name="p434975503093534"></a><a name="p434975503093534"></a>Sets the images for this check box. </p>
</td>
</tr>
<tr id="row111303514093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1425346304093534"><a name="p1425346304093534"></a><a name="p1425346304093534"></a><a href="Graphic.md#ga89eb87d02e7b31fc6517b8744751f021">SetImages</a> (const <a href="OHOS-ImageInfo.md">ImageInfo</a> *selectedImageSrc, const <a href="OHOS-ImageInfo.md">ImageInfo</a> *unselectedImageSrc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p201216338093534"><a name="p201216338093534"></a><a name="p201216338093534"></a>virtual void&nbsp;</p>
<p id="p1827726079093534"><a name="p1827726079093534"></a><a name="p1827726079093534"></a>Sets the images for this check box. </p>
</td>
</tr>
<tr id="row693754074093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p186187682093534"><a name="p186187682093534"></a><a name="p186187682093534"></a><a href="Graphic.md#gab3cddc176a6834fabc7c53912c97237c">GetState</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1155223057093534"><a name="p1155223057093534"></a><a name="p1155223057093534"></a><a href="Graphic.md#ga15a3f0302aded0e4d1584ddc6002335d">UICheckBoxState</a>&nbsp;</p>
<p id="p721086268093534"><a name="p721086268093534"></a><a name="p721086268093534"></a>Obtains the state of this check box. </p>
</td>
</tr>
<tr id="row1791116899093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1603812266093534"><a name="p1603812266093534"></a><a name="p1603812266093534"></a><a href="Graphic.md#ga32217050815d4d9129ace5ab410fb82d">SetState</a> (<a href="Graphic.md#ga15a3f0302aded0e4d1584ddc6002335d">UICheckBoxState</a> state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p954200017093534"><a name="p954200017093534"></a><a name="p954200017093534"></a>void&nbsp;</p>
<p id="p1435419808093534"><a name="p1435419808093534"></a><a name="p1435419808093534"></a>Sets the state for this check box. </p>
</td>
</tr>
<tr id="row902383106093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1873792681093534"><a name="p1873792681093534"></a><a name="p1873792681093534"></a><a href="Graphic.md#ga7aad5b50d945efe5f9304bc978b2001c">UIView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1461269326093534"><a name="p1461269326093534"></a><a name="p1461269326093534"></a>&nbsp;</p>
<p id="p40615539093534"><a name="p40615539093534"></a><a name="p40615539093534"></a>A default constructor used to create an <strong id="b1633994737093534"><a name="b1633994737093534"></a><a name="b1633994737093534"></a><a href="OHOS-UIView.md">UIView</a></strong> instance. </p>
</td>
</tr>
<tr id="row1117581484093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p539426646093534"><a name="p539426646093534"></a><a name="p539426646093534"></a><a href="Graphic.md#ga57d429bb1cd71782f3b825f1bc6b9362">UIView</a> (const char *id)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1141846203093534"><a name="p1141846203093534"></a><a name="p1141846203093534"></a>&nbsp;</p>
<p id="p83903210093534"><a name="p83903210093534"></a><a name="p83903210093534"></a>A constructor used to create an <strong id="b1479569880093534"><a name="b1479569880093534"></a><a name="b1479569880093534"></a><a href="OHOS-UIView.md">UIView</a></strong> instance. </p>
</td>
</tr>
<tr id="row1241261266093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1317844040093534"><a name="p1317844040093534"></a><a name="p1317844040093534"></a><a href="Graphic.md#ga17f0ffc1090bdcce0f88288da5962012">~UIView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1821313438093534"><a name="p1821313438093534"></a><a name="p1821313438093534"></a>virtual&nbsp;</p>
<p id="p73948499093534"><a name="p73948499093534"></a><a name="p73948499093534"></a>A destructor used to delete the <strong id="b1534106329093534"><a name="b1534106329093534"></a><a name="b1534106329093534"></a><a href="OHOS-UIView.md">UIView</a></strong> instance. </p>
</td>
</tr>
<tr id="row1051632455093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1516764578093534"><a name="p1516764578093534"></a><a name="p1516764578093534"></a><a href="Graphic.md#gab70473cd0d8fe7c9d4bb817caeee9153">OnPostDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1202410607093534"><a name="p1202410607093534"></a><a name="p1202410607093534"></a>virtual void&nbsp;</p>
<p id="p1946142443093534"><a name="p1946142443093534"></a><a name="p1946142443093534"></a>Called after a view is drawn. </p>
</td>
</tr>
<tr id="row308769496093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1584323712093534"><a name="p1584323712093534"></a><a name="p1584323712093534"></a><a href="Graphic.md#ga81726238adeda1efa989be6ed4f4fe5b">ReMeasure</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1564747456093534"><a name="p1564747456093534"></a><a name="p1564747456093534"></a>virtual void&nbsp;</p>
<p id="p1400396215093534"><a name="p1400396215093534"></a><a name="p1400396215093534"></a>Remeasures the view size. </p>
</td>
</tr>
<tr id="row1623897350093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p209902614093534"><a name="p209902614093534"></a><a name="p209902614093534"></a><a href="Graphic.md#ga2a9a38b8450fbb196277238a51fbbf99">Invalidate</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1945859595093534"><a name="p1945859595093534"></a><a name="p1945859595093534"></a>void&nbsp;</p>
<p id="p1552955670093534"><a name="p1552955670093534"></a><a name="p1552955670093534"></a>Refreshes the invalidated area of the view. </p>
</td>
</tr>
<tr id="row1239294915093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p288732355093534"><a name="p288732355093534"></a><a name="p288732355093534"></a><a href="Graphic.md#gaf0e6b65ced8b931642f2a80c195962d2">InvalidateRect</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1948476622093534"><a name="p1948476622093534"></a><a name="p1948476622093534"></a>void&nbsp;</p>
<p id="p681394250093534"><a name="p681394250093534"></a><a name="p681394250093534"></a>Refreshes a view in a specified invalidated area. </p>
</td>
</tr>
<tr id="row664365365093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1371774987093534"><a name="p1371774987093534"></a><a name="p1371774987093534"></a><a href="Graphic.md#gac311aa47301d727c35fc31f8630d016e">OnLongPressEvent</a> (const <a href="OHOS-LongPressEvent.md">LongPressEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1309998597093534"><a name="p1309998597093534"></a><a name="p1309998597093534"></a>virtual bool&nbsp;</p>
<p id="p1468218277093534"><a name="p1468218277093534"></a><a name="p1468218277093534"></a>Called when the view is long pressed. </p>
</td>
</tr>
<tr id="row1508189506093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1011485871093534"><a name="p1011485871093534"></a><a name="p1011485871093534"></a><a href="Graphic.md#gac0e10556ff99b8a92bfb11df6456d605">OnDragStartEvent</a> (const <a href="OHOS-DragEvent.md">DragEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1152380160093534"><a name="p1152380160093534"></a><a name="p1152380160093534"></a>virtual bool&nbsp;</p>
<p id="p2123634130093534"><a name="p2123634130093534"></a><a name="p2123634130093534"></a>Called when the view starts to drag. </p>
</td>
</tr>
<tr id="row1154441850093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p148618743093534"><a name="p148618743093534"></a><a name="p148618743093534"></a><a href="Graphic.md#ga46249c8caf06b81590d9450e30a31147">OnDragEvent</a> (const <a href="OHOS-DragEvent.md">DragEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2013422408093534"><a name="p2013422408093534"></a><a name="p2013422408093534"></a>virtual bool&nbsp;</p>
<p id="p840758528093534"><a name="p840758528093534"></a><a name="p840758528093534"></a>Called when the view is being dragged. </p>
</td>
</tr>
<tr id="row1282291449093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p131742033093534"><a name="p131742033093534"></a><a name="p131742033093534"></a><a href="Graphic.md#ga1799d33be73f64ed2066f50d7e65468d">OnDragEndEvent</a> (const <a href="OHOS-DragEvent.md">DragEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1283035636093534"><a name="p1283035636093534"></a><a name="p1283035636093534"></a>virtual bool&nbsp;</p>
<p id="p991723628093534"><a name="p991723628093534"></a><a name="p991723628093534"></a>Called when the view stops dragging. </p>
</td>
</tr>
<tr id="row788557468093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1966417810093534"><a name="p1966417810093534"></a><a name="p1966417810093534"></a><a href="Graphic.md#gafa544ff2d27785a9410a80689f1ad3b1">OnPressEvent</a> (const <a href="OHOS-PressEvent.md">PressEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p936156917093534"><a name="p936156917093534"></a><a name="p936156917093534"></a>virtual void&nbsp;</p>
<p id="p238910868093534"><a name="p238910868093534"></a><a name="p238910868093534"></a>Called when the view is pressed. </p>
</td>
</tr>
<tr id="row1452161732093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1117507965093534"><a name="p1117507965093534"></a><a name="p1117507965093534"></a><a href="Graphic.md#ga7bd1a74563b059b03fbf66f9add53ee3">OnReleaseEvent</a> (const <a href="OHOS-ReleaseEvent.md">ReleaseEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2134906717093534"><a name="p2134906717093534"></a><a name="p2134906717093534"></a>virtual void&nbsp;</p>
<p id="p1611369402093534"><a name="p1611369402093534"></a><a name="p1611369402093534"></a>Called when the view is released. </p>
</td>
</tr>
<tr id="row119191840093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p808538365093534"><a name="p808538365093534"></a><a name="p808538365093534"></a><a href="Graphic.md#ga8f01ff25a33b20df0758f564148e579d">OnCancelEvent</a> (const <a href="OHOS-CancelEvent.md">CancelEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1775632070093534"><a name="p1775632070093534"></a><a name="p1775632070093534"></a>virtual void&nbsp;</p>
<p id="p183906786093534"><a name="p183906786093534"></a><a name="p183906786093534"></a>Called when a click event on the view is canceled. </p>
</td>
</tr>
<tr id="row2089766077093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1403841638093534"><a name="p1403841638093534"></a><a name="p1403841638093534"></a><a href="Graphic.md#gad8e3cf5f0dd003a6aa932ef04e7b59f2">SetOnDragListener</a> (<a href="OHOS-UIView-OnDragListener.md">OnDragListener</a> *onDragListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p459159787093534"><a name="p459159787093534"></a><a name="p459159787093534"></a>void&nbsp;</p>
<p id="p1917282670093534"><a name="p1917282670093534"></a><a name="p1917282670093534"></a>Sets a drag event listener for the view. </p>
</td>
</tr>
<tr id="row424150227093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p696357084093534"><a name="p696357084093534"></a><a name="p696357084093534"></a><a href="Graphic.md#ga45a02cba4887c5c0b8e243941bcdc5cb">GetOnDragListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1170651951093534"><a name="p1170651951093534"></a><a name="p1170651951093534"></a><a href="OHOS-UIView-OnDragListener.md">OnDragListener</a> *&amp;&nbsp;</p>
<p id="p1964076991093534"><a name="p1964076991093534"></a><a name="p1964076991093534"></a>Obtains the drag event listener for the view. </p>
</td>
</tr>
<tr id="row2071598766093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p873638971093534"><a name="p873638971093534"></a><a name="p873638971093534"></a><a href="Graphic.md#ga4564bf8d8c7184e9c02bf33c9e171fa3">SetOnClickListener</a> (<a href="OHOS-UIView-OnClickListener.md">OnClickListener</a> *onClickListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1485964617093534"><a name="p1485964617093534"></a><a name="p1485964617093534"></a>void&nbsp;</p>
<p id="p12038981093534"><a name="p12038981093534"></a><a name="p12038981093534"></a>Sets a click event listener for the view. </p>
</td>
</tr>
<tr id="row1195826987093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p325228539093534"><a name="p325228539093534"></a><a name="p325228539093534"></a><a href="Graphic.md#ga35e885cb380c37245fa4305bba10cd4a">GetOnClickListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1829150891093534"><a name="p1829150891093534"></a><a name="p1829150891093534"></a><a href="OHOS-UIView-OnClickListener.md">OnClickListener</a> *&amp;&nbsp;</p>
<p id="p2078288434093534"><a name="p2078288434093534"></a><a name="p2078288434093534"></a>Obtains the click event listener for the view. </p>
</td>
</tr>
<tr id="row2094136538093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p322557011093534"><a name="p322557011093534"></a><a name="p322557011093534"></a><a href="Graphic.md#gabcbe7a0adce600424f7f0d5a7396eb5b">SetOnLongPressListener</a> (<a href="OHOS-UIView-OnLongPressListener.md">OnLongPressListener</a> *onLongPressListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p287158439093534"><a name="p287158439093534"></a><a name="p287158439093534"></a>void&nbsp;</p>
<p id="p1215372337093534"><a name="p1215372337093534"></a><a name="p1215372337093534"></a>Sets a long-press event listener for the view. </p>
</td>
</tr>
<tr id="row1277810459093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p898734720093534"><a name="p898734720093534"></a><a name="p898734720093534"></a><a href="Graphic.md#gaafd4d354f5f111e758d046109fd7f656">GetOnLongPressListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p502155719093534"><a name="p502155719093534"></a><a name="p502155719093534"></a><a href="OHOS-UIView-OnLongPressListener.md">OnLongPressListener</a> *&amp;&nbsp;</p>
<p id="p126417699093534"><a name="p126417699093534"></a><a name="p126417699093534"></a>Obtains the long-press event listener for the view. </p>
</td>
</tr>
<tr id="row380843380093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p879240308093534"><a name="p879240308093534"></a><a name="p879240308093534"></a><a href="Graphic.md#gadd697fbf481f98d9d6ca8b67390071af">SetOnTouchListener</a> (<a href="OHOS-UIView-OnTouchListener.md">OnTouchListener</a> *onTouchListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p661216025093534"><a name="p661216025093534"></a><a name="p661216025093534"></a>void&nbsp;</p>
<p id="p1781457785093534"><a name="p1781457785093534"></a><a name="p1781457785093534"></a>Sets a touch event listener for the view. </p>
</td>
</tr>
<tr id="row164178250093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1500773746093534"><a name="p1500773746093534"></a><a name="p1500773746093534"></a><a href="Graphic.md#gae7c65c68653103dae85acdcef78777a6">GetTouchListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p526583537093534"><a name="p526583537093534"></a><a name="p526583537093534"></a><a href="OHOS-UIView-OnTouchListener.md">OnTouchListener</a> *&amp;&nbsp;</p>
<p id="p905944808093534"><a name="p905944808093534"></a><a name="p905944808093534"></a>Obtains the touch event listener for the view. </p>
</td>
</tr>
<tr id="row746625815093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1148726076093534"><a name="p1148726076093534"></a><a name="p1148726076093534"></a><a href="Graphic.md#gaea9f334f2481e1c03a2cd8f3078d7c72">GetTargetView</a> (const <a href="OHOS-Point.md">Point</a> &amp;point, <a href="OHOS-UIView.md">UIView</a> **last)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p484327135093534"><a name="p484327135093534"></a><a name="p484327135093534"></a>virtual void&nbsp;</p>
<p id="p162150407093534"><a name="p162150407093534"></a><a name="p162150407093534"></a>Obtains the top-level view based on specified coordinates. </p>
</td>
</tr>
<tr id="row1916782588093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1206351827093534"><a name="p1206351827093534"></a><a name="p1206351827093534"></a><a href="Graphic.md#gaeea67a3a84b4ffe9bfeda418b82184cc">SetParent</a> (<a href="OHOS-UIView.md">UIView</a> *parent)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1922580511093534"><a name="p1922580511093534"></a><a name="p1922580511093534"></a>void&nbsp;</p>
<p id="p1948495365093534"><a name="p1948495365093534"></a><a name="p1948495365093534"></a>Sets the parent view for the view. </p>
</td>
</tr>
<tr id="row1566878271093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p618076421093534"><a name="p618076421093534"></a><a name="p618076421093534"></a><a href="Graphic.md#ga706530e4a38108615d5e0c918685ec96">GetParent</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p409114249093534"><a name="p409114249093534"></a><a name="p409114249093534"></a><a href="OHOS-UIView.md">UIView</a> *&nbsp;</p>
<p id="p1880198530093534"><a name="p1880198530093534"></a><a name="p1880198530093534"></a>Obtains the parent view of the view. </p>
</td>
</tr>
<tr id="row2137800172093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p592751298093534"><a name="p592751298093534"></a><a name="p592751298093534"></a><a href="Graphic.md#ga02bec5de07d93cabc45affba79eba4ad">SetNextSibling</a> (<a href="OHOS-UIView.md">UIView</a> *sibling)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p510042780093534"><a name="p510042780093534"></a><a name="p510042780093534"></a>void&nbsp;</p>
<p id="p70777393093534"><a name="p70777393093534"></a><a name="p70777393093534"></a>Sets the next sibling view for the view. </p>
</td>
</tr>
<tr id="row1961503683093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p47521343093534"><a name="p47521343093534"></a><a name="p47521343093534"></a><a href="Graphic.md#gab0030977b30ddc9f2e15dbc2f58937e6">GetNextSibling</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1097127840093534"><a name="p1097127840093534"></a><a name="p1097127840093534"></a><a href="OHOS-UIView.md">UIView</a> *&nbsp;</p>
<p id="p629359814093534"><a name="p629359814093534"></a><a name="p629359814093534"></a>Obtains the next sibling view of the view. </p>
</td>
</tr>
<tr id="row1139108798093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1417541512093534"><a name="p1417541512093534"></a><a name="p1417541512093534"></a><a href="Graphic.md#ga07e7e1f268bd6ce975f4f0f8487af5d0">SetVisible</a> (bool visible)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1442755055093534"><a name="p1442755055093534"></a><a name="p1442755055093534"></a>virtual void&nbsp;</p>
<p id="p2116386208093534"><a name="p2116386208093534"></a><a name="p2116386208093534"></a>Sets whether the view is visible. </p>
</td>
</tr>
<tr id="row1703366218093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1264900142093534"><a name="p1264900142093534"></a><a name="p1264900142093534"></a><a href="Graphic.md#gaee178fc0a86ac03a6bdf2ade0c1914c8">IsVisible</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1380547283093534"><a name="p1380547283093534"></a><a name="p1380547283093534"></a>bool&nbsp;</p>
<p id="p1803445808093534"><a name="p1803445808093534"></a><a name="p1803445808093534"></a>Checks whether the view is visible. </p>
</td>
</tr>
<tr id="row1651802061093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1800131577093534"><a name="p1800131577093534"></a><a name="p1800131577093534"></a><a href="Graphic.md#gaf9fb55fd9aa397f7158f1515e90bce02">SetTouchable</a> (bool touch)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p303745104093534"><a name="p303745104093534"></a><a name="p303745104093534"></a>void&nbsp;</p>
<p id="p1933766343093534"><a name="p1933766343093534"></a><a name="p1933766343093534"></a>Sets whether the view is touchable. </p>
</td>
</tr>
<tr id="row107651803093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p203088622093534"><a name="p203088622093534"></a><a name="p203088622093534"></a><a href="Graphic.md#ga502a53fb77b260fa36b5b3adf82e2340">IsTouchable</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1291503130093534"><a name="p1291503130093534"></a><a name="p1291503130093534"></a>bool&nbsp;</p>
<p id="p408786283093534"><a name="p408786283093534"></a><a name="p408786283093534"></a>Checks whether the view is touchable. </p>
</td>
</tr>
<tr id="row367216686093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p217842836093534"><a name="p217842836093534"></a><a name="p217842836093534"></a><a href="Graphic.md#gab06abe0fe824c048f3b72974f9a8f0d0">SetDraggable</a> (bool draggable)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2139787485093534"><a name="p2139787485093534"></a><a name="p2139787485093534"></a>void&nbsp;</p>
<p id="p1206583764093534"><a name="p1206583764093534"></a><a name="p1206583764093534"></a>Sets whether the view is draggable. </p>
</td>
</tr>
<tr id="row1916283616093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p420108434093534"><a name="p420108434093534"></a><a name="p420108434093534"></a><a href="Graphic.md#ga25bb796ff400c767d622cbed280fc500">IsDraggable</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p306828668093534"><a name="p306828668093534"></a><a name="p306828668093534"></a>bool&nbsp;</p>
<p id="p709102645093534"><a name="p709102645093534"></a><a name="p709102645093534"></a>Checks whether the view is draggable. </p>
</td>
</tr>
<tr id="row707764801093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1670766109093534"><a name="p1670766109093534"></a><a name="p1670766109093534"></a><a href="Graphic.md#ga6c08e49bf7a82a7ebaef0f251e7a6f85">SetDragParentInstead</a> (bool dragParentInstead)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p415601007093534"><a name="p415601007093534"></a><a name="p415601007093534"></a>void&nbsp;</p>
<p id="p103516564093534"><a name="p103516564093534"></a><a name="p103516564093534"></a>Sets whether to transfer the drag event to the parent view for processing when the view is being dragged. </p>
</td>
</tr>
<tr id="row118442107093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p712746563093534"><a name="p712746563093534"></a><a name="p712746563093534"></a><a href="Graphic.md#gaf0c462bc31e779b1898ad4cdfdad6faf">IsDragParentInstead</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1050934380093534"><a name="p1050934380093534"></a><a name="p1050934380093534"></a>bool&nbsp;</p>
<p id="p1276210221093534"><a name="p1276210221093534"></a><a name="p1276210221093534"></a>Obtains whether the view transfers a drag event to the parent view for processing. </p>
</td>
</tr>
<tr id="row697882084093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1152183881093534"><a name="p1152183881093534"></a><a name="p1152183881093534"></a><a href="Graphic.md#ga86cb8d364f18494d67636c55babced5c">GetRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1004892124093534"><a name="p1004892124093534"></a><a name="p1004892124093534"></a><a href="OHOS-Rect.md">Rect</a>&nbsp;</p>
<p id="p1716265341093534"><a name="p1716265341093534"></a><a name="p1716265341093534"></a>Obtains the absolute rectangle area of the view. When the view has deformation such as rotation, the rectangle area is the intersection set of the absolute rectangle area and deformation matrix. </p>
</td>
</tr>
<tr id="row1326276442093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p119163769093534"><a name="p119163769093534"></a><a name="p119163769093534"></a><a href="Graphic.md#ga06e79704a19f2a238982076cac3d059b">GetVisibleRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p539648545093534"><a name="p539648545093534"></a><a name="p539648545093534"></a><a href="OHOS-Rect.md">Rect</a>&nbsp;</p>
<p id="p927819636093534"><a name="p927819636093534"></a><a name="p927819636093534"></a>Obtains the visible absolute rectangle area of the view. </p>
</td>
</tr>
<tr id="row1115891776093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1932829369093534"><a name="p1932829369093534"></a><a name="p1932829369093534"></a><a href="Graphic.md#gab3f8993b3953f27bfc61d53429916cba">GetMaskedRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1230513478093534"><a name="p1230513478093534"></a><a name="p1230513478093534"></a><a href="OHOS-Rect.md">Rect</a>&nbsp;</p>
<p id="p410919570093534"><a name="p410919570093534"></a><a name="p410919570093534"></a>Obtains the valid absolute rectangle area of the view. The valid area refers to the area where the view can be displayed. Generally, the valid area is the same as the visible view area, but they may be different in the grid layout. </p>
</td>
</tr>
<tr id="row1818261922093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p938201805093534"><a name="p938201805093534"></a><a name="p938201805093534"></a><a href="Graphic.md#ga64cf308a09999def1192f9c4e0f17f0a">GetOrigRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1661890897093534"><a name="p1661890897093534"></a><a name="p1661890897093534"></a><a href="OHOS-Rect.md">Rect</a>&nbsp;</p>
<p id="p389946064093534"><a name="p389946064093534"></a><a name="p389946064093534"></a>Obtains the absolute rectangle area of the view. </p>
</td>
</tr>
<tr id="row1953497531093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1195204859093534"><a name="p1195204859093534"></a><a name="p1195204859093534"></a><a href="Graphic.md#ga9db88eae712676359d02a92be14fa316">GetContentRect</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1789321094093534"><a name="p1789321094093534"></a><a name="p1789321094093534"></a>virtual <a href="OHOS-Rect.md">Rect</a>&nbsp;</p>
<p id="p669514353093534"><a name="p669514353093534"></a><a name="p669514353093534"></a>Obtains the content of the absolute rectangle area of the view. This area excludes padding. </p>
</td>
</tr>
<tr id="row1797592740093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p698571071093534"><a name="p698571071093534"></a><a name="p698571071093534"></a><a href="Graphic.md#gae9b96837fa1d45648a2a6fbbfcc5eb4a">GetRelativeRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p523723600093534"><a name="p523723600093534"></a><a name="p523723600093534"></a><a href="OHOS-Rect.md">Rect</a>&nbsp;</p>
<p id="p1641182904093534"><a name="p1641182904093534"></a><a name="p1641182904093534"></a>Obtains the rectangular area of the view relative to the parent view, that is, the rectangular area relative to the coordinates of the parent view. </p>
</td>
</tr>
<tr id="row413007068093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1926123722093534"><a name="p1926123722093534"></a><a name="p1926123722093534"></a><a href="Graphic.md#gae6c5f3bcf99dc837bcecd60c38d3df5a">ResizeVisibleArea</a> (int16_t x, int16_t y, int16_t width, int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1139964737093534"><a name="p1139964737093534"></a><a name="p1139964737093534"></a>void&nbsp;</p>
<p id="p1451282759093534"><a name="p1451282759093534"></a><a name="p1451282759093534"></a>Adjusts the size of the visible area. This operation may affect the final display size. </p>
</td>
</tr>
<tr id="row1371092075093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p291277975093534"><a name="p291277975093534"></a><a name="p291277975093534"></a><a href="Graphic.md#ga3375ec5ef059fd88c657af4552d2fa4f">SetWidth</a> (int16_t width)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2112050104093534"><a name="p2112050104093534"></a><a name="p2112050104093534"></a>virtual void&nbsp;</p>
<p id="p1874052719093534"><a name="p1874052719093534"></a><a name="p1874052719093534"></a>Sets the width for the view. </p>
</td>
</tr>
<tr id="row1972418218093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1652120812093534"><a name="p1652120812093534"></a><a name="p1652120812093534"></a><a href="Graphic.md#ga90cf8cffb98d71c30d6fc1d118442dbd">GetWidth</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1044653890093534"><a name="p1044653890093534"></a><a name="p1044653890093534"></a>virtual int16_t&nbsp;</p>
<p id="p1048721501093534"><a name="p1048721501093534"></a><a name="p1048721501093534"></a>Obtains the width for the view. </p>
</td>
</tr>
<tr id="row1857205951093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p153539743093534"><a name="p153539743093534"></a><a name="p153539743093534"></a><a href="Graphic.md#ga9c7110620d5dc3a7bd3efe1fc2edd125">SetHeight</a> (int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p199736753093534"><a name="p199736753093534"></a><a name="p199736753093534"></a>virtual void&nbsp;</p>
<p id="p2106853360093534"><a name="p2106853360093534"></a><a name="p2106853360093534"></a>Sets the height for the view. </p>
</td>
</tr>
<tr id="row846052000093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1667774616093534"><a name="p1667774616093534"></a><a name="p1667774616093534"></a><a href="Graphic.md#ga9b35f4603a561c7a9a29b023a022ac97">GetHeight</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1455892693093534"><a name="p1455892693093534"></a><a name="p1455892693093534"></a>virtual int16_t&nbsp;</p>
<p id="p1461262407093534"><a name="p1461262407093534"></a><a name="p1461262407093534"></a>Obtains the height for the view. </p>
</td>
</tr>
<tr id="row3042347093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p513970148093534"><a name="p513970148093534"></a><a name="p513970148093534"></a><a href="Graphic.md#gae985b607d2f0701911778bf20d640ccd">Resize</a> (int16_t width, int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p536552690093534"><a name="p536552690093534"></a><a name="p536552690093534"></a>virtual void&nbsp;</p>
<p id="p659474637093534"><a name="p659474637093534"></a><a name="p659474637093534"></a>Adjusts the size of the view. </p>
</td>
</tr>
<tr id="row1582014928093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p345445844093534"><a name="p345445844093534"></a><a name="p345445844093534"></a><a href="Graphic.md#gaded403626558d28e62bf5632ccbb24b5">SetX</a> (int16_t x)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p987883879093534"><a name="p987883879093534"></a><a name="p987883879093534"></a>virtual void&nbsp;</p>
<p id="p950865463093534"><a name="p950865463093534"></a><a name="p950865463093534"></a>Sets the x-coordinate for the view. </p>
</td>
</tr>
<tr id="row411707220093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1905791926093534"><a name="p1905791926093534"></a><a name="p1905791926093534"></a><a href="Graphic.md#ga89dc5f8fb1cb4b2259dc0439185359f1">GetX</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2124013428093534"><a name="p2124013428093534"></a><a name="p2124013428093534"></a>int16_t&nbsp;</p>
<p id="p232872990093534"><a name="p232872990093534"></a><a name="p232872990093534"></a>Obtains the x-coordinate for the view. </p>
</td>
</tr>
<tr id="row675122684093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p821780399093534"><a name="p821780399093534"></a><a name="p821780399093534"></a><a href="Graphic.md#gaaa8edc224cf1c7deb2724fb225960877">SetY</a> (int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p226744034093534"><a name="p226744034093534"></a><a name="p226744034093534"></a>virtual void&nbsp;</p>
<p id="p1076648788093534"><a name="p1076648788093534"></a><a name="p1076648788093534"></a>Sets the y-coordinate for the view. </p>
</td>
</tr>
<tr id="row1339586274093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1540040960093534"><a name="p1540040960093534"></a><a name="p1540040960093534"></a><a href="Graphic.md#ga193619d649204b0e9bb854d3b30275c3">GetY</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2108582910093534"><a name="p2108582910093534"></a><a name="p2108582910093534"></a>int16_t&nbsp;</p>
<p id="p1640021242093534"><a name="p1640021242093534"></a><a name="p1640021242093534"></a>Obtains the y-coordinate for the view. </p>
</td>
</tr>
<tr id="row1624812431093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p536203632093534"><a name="p536203632093534"></a><a name="p536203632093534"></a><a href="Graphic.md#gab34233f6aeae330b025969137d03e67a">SetPosition</a> (int16_t x, int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1177102013093534"><a name="p1177102013093534"></a><a name="p1177102013093534"></a>virtual void&nbsp;</p>
<p id="p629739691093534"><a name="p629739691093534"></a><a name="p629739691093534"></a>Sets the position for the view. </p>
</td>
</tr>
<tr id="row2095784107093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p821225066093534"><a name="p821225066093534"></a><a name="p821225066093534"></a><a href="Graphic.md#gaf8ce4c009f23b7175b2b34bac4a74262">SetPosition</a> (int16_t x, int16_t y, int16_t width, int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p455270657093534"><a name="p455270657093534"></a><a name="p455270657093534"></a>virtual void&nbsp;</p>
<p id="p248709023093534"><a name="p248709023093534"></a><a name="p248709023093534"></a>Adjusts the position and size of the view. </p>
</td>
</tr>
<tr id="row661108020093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1671312335093534"><a name="p1671312335093534"></a><a name="p1671312335093534"></a><a href="Graphic.md#gab2ce8c11abbd55f40687f38a52511b11">IsViewGroup</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p790968786093534"><a name="p790968786093534"></a><a name="p790968786093534"></a>bool&nbsp;</p>
<p id="p96595388093534"><a name="p96595388093534"></a><a name="p96595388093534"></a>Checks whether the view is a container view. </p>
</td>
</tr>
<tr id="row1127044134093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p648966109093534"><a name="p648966109093534"></a><a name="p648966109093534"></a><a href="Graphic.md#ga980fc6824c64cfae6af8657aee17af88">SetIntercept</a> (bool isIntercept)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1968112368093534"><a name="p1968112368093534"></a><a name="p1968112368093534"></a>void&nbsp;</p>
<p id="p1889514197093534"><a name="p1889514197093534"></a><a name="p1889514197093534"></a>Sets whether to intercept the drag event. If intercepted, the view does not transfer the drag event to the parent view after local processing. </p>
</td>
</tr>
<tr id="row32907193093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1662728094093534"><a name="p1662728094093534"></a><a name="p1662728094093534"></a><a href="Graphic.md#ga8623abbbeff458c0cb2d7dc0d1f21e4a">SetTransformMap</a> (const <a href="OHOS-TransformMap.md">TransformMap</a> &amp;transMap)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1065604858093534"><a name="p1065604858093534"></a><a name="p1065604858093534"></a>void&nbsp;</p>
<p id="p1549535385093534"><a name="p1549535385093534"></a><a name="p1549535385093534"></a>Sets the affine transformation matrix. </p>
</td>
</tr>
<tr id="row307018061093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1748397821093534"><a name="p1748397821093534"></a><a name="p1748397821093534"></a><a href="Graphic.md#gab8cee5a7052a88722768c8ed1324abc1">GetTransformMap</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p435530665093534"><a name="p435530665093534"></a><a name="p435530665093534"></a><a href="OHOS-TransformMap.md">TransformMap</a> &amp;&nbsp;</p>
<p id="p350836374093534"><a name="p350836374093534"></a><a name="p350836374093534"></a>Obtains an affine transformation matrix. </p>
</td>
</tr>
<tr id="row1114866847093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1204975489093534"><a name="p1204975489093534"></a><a name="p1204975489093534"></a><a href="Graphic.md#ga0573aa25307c22319db4629781b5cad2">GetChildById</a> (const char *id) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1089416484093534"><a name="p1089416484093534"></a><a name="p1089416484093534"></a>virtual <a href="OHOS-UIView.md">UIView</a> *&nbsp;</p>
<p id="p390811189093534"><a name="p390811189093534"></a><a name="p390811189093534"></a>Obtains the child view of a specified ID. </p>
</td>
</tr>
<tr id="row1795109293093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1204707184093534"><a name="p1204707184093534"></a><a name="p1204707184093534"></a><a href="Graphic.md#ga0caaa15c9b304673331e778a266be77f">SetViewId</a> (const char *id)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1186347251093534"><a name="p1186347251093534"></a><a name="p1186347251093534"></a>void&nbsp;</p>
<p id="p1084317844093534"><a name="p1084317844093534"></a><a name="p1084317844093534"></a>Sets the view ID. </p>
</td>
</tr>
<tr id="row856549722093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p601324348093534"><a name="p601324348093534"></a><a name="p601324348093534"></a><a href="Graphic.md#gad6c7644bd2abfa3c92d80776b0bd1936">GetViewId</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1217927857093534"><a name="p1217927857093534"></a><a name="p1217927857093534"></a>const char *&nbsp;</p>
<p id="p2114066931093534"><a name="p2114066931093534"></a><a name="p2114066931093534"></a>Obtains the view ID. </p>
</td>
</tr>
<tr id="row2030798094093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p345440521093534"><a name="p345440521093534"></a><a name="p345440521093534"></a><a href="Graphic.md#ga77a961aa53567c5214508b4569801c16">SetViewIndex</a> (int16_t <a href="zh-cn_topic_0000001055198076.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1734277610093534"><a name="p1734277610093534"></a><a name="p1734277610093534"></a>void&nbsp;</p>
<p id="p719831009093534"><a name="p719831009093534"></a><a name="p719831009093534"></a>Sets the view index. </p>
</td>
</tr>
<tr id="row395495629093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1431139420093534"><a name="p1431139420093534"></a><a name="p1431139420093534"></a><a href="Graphic.md#ga62f51715b6d420a296ebe0296717b906">GetViewIndex</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1083865826093534"><a name="p1083865826093534"></a><a name="p1083865826093534"></a>int16_t&nbsp;</p>
<p id="p1949725043093534"><a name="p1949725043093534"></a><a name="p1949725043093534"></a>Obtains the view index. </p>
</td>
</tr>
<tr id="row706745247093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p87077693093534"><a name="p87077693093534"></a><a name="p87077693093534"></a><a href="Graphic.md#gaca871fa2f8219e7ea9388e212d1f1e69">LayoutChildren</a> (bool neeInvalidate=false)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1117110163093534"><a name="p1117110163093534"></a><a name="p1117110163093534"></a>virtual void&nbsp;</p>
<p id="p1443994808093534"><a name="p1443994808093534"></a><a name="p1443994808093534"></a>Lays out all child views according to the preset arrangement mode. </p>
</td>
</tr>
<tr id="row1249493702093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1058799703093534"><a name="p1058799703093534"></a><a name="p1058799703093534"></a><a href="Graphic.md#ga443b86ee9275b0421b37a47bad3264dc">LayoutCenterOfParent</a> (int16_t xOffSet=0, int16_t yOffset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1228439217093534"><a name="p1228439217093534"></a><a name="p1228439217093534"></a>void&nbsp;</p>
<p id="p699161526093534"><a name="p699161526093534"></a><a name="p699161526093534"></a>Lays out the view in the center of the parent view. </p>
</td>
</tr>
<tr id="row1299785730093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1362992407093534"><a name="p1362992407093534"></a><a name="p1362992407093534"></a><a href="Graphic.md#ga94999b271f27cd5d6bfaf303f7d5c708">LayoutLeftOfParent</a> (int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1342561355093534"><a name="p1342561355093534"></a><a name="p1342561355093534"></a>void&nbsp;</p>
<p id="p1568011952093534"><a name="p1568011952093534"></a><a name="p1568011952093534"></a>Lays out the view on the left of the parent view. </p>
</td>
</tr>
<tr id="row365814172093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1248352112093534"><a name="p1248352112093534"></a><a name="p1248352112093534"></a><a href="Graphic.md#ga479528ed259b5539e423955f2b60517d">LayoutRightOfParent</a> (int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1276550009093534"><a name="p1276550009093534"></a><a name="p1276550009093534"></a>void&nbsp;</p>
<p id="p537671142093534"><a name="p537671142093534"></a><a name="p537671142093534"></a>Lays out the view on the right of the parent view. </p>
</td>
</tr>
<tr id="row352283787093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1226150317093534"><a name="p1226150317093534"></a><a name="p1226150317093534"></a><a href="Graphic.md#ga859288ea61ad23ba7e381bbc07769e83">LayoutTopOfParent</a> (int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1472446744093534"><a name="p1472446744093534"></a><a name="p1472446744093534"></a>void&nbsp;</p>
<p id="p1092818409093534"><a name="p1092818409093534"></a><a name="p1092818409093534"></a>Lays out the view on the top of the parent view. </p>
</td>
</tr>
<tr id="row1149656189093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p382535979093534"><a name="p382535979093534"></a><a name="p382535979093534"></a><a href="Graphic.md#ga809aeee4792ae58218a0bcfcb94d5cdc">LayoutBottomOfParent</a> (int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1963775485093534"><a name="p1963775485093534"></a><a name="p1963775485093534"></a>void&nbsp;</p>
<p id="p764775407093534"><a name="p764775407093534"></a><a name="p764775407093534"></a>Lays out the view on the bottom of the parent view. </p>
</td>
</tr>
<tr id="row1844316671093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p7860269093534"><a name="p7860269093534"></a><a name="p7860269093534"></a><a href="Graphic.md#gac7f5f2584c716a56fee3783f8dea6246">AlignLeftToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1740976163093534"><a name="p1740976163093534"></a><a name="p1740976163093534"></a>void&nbsp;</p>
<p id="p475134697093534"><a name="p475134697093534"></a><a name="p475134697093534"></a>Aligns the view with the left of a sibling view. </p>
</td>
</tr>
<tr id="row184135844093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1898140437093534"><a name="p1898140437093534"></a><a name="p1898140437093534"></a><a href="Graphic.md#gabb1ac454cdf95593c1e387d5e272433c">AlignRightToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p666840391093534"><a name="p666840391093534"></a><a name="p666840391093534"></a>void&nbsp;</p>
<p id="p141467267093534"><a name="p141467267093534"></a><a name="p141467267093534"></a>Aligns the view with the right of a sibling view. </p>
</td>
</tr>
<tr id="row2032014020093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2051967899093534"><a name="p2051967899093534"></a><a name="p2051967899093534"></a><a href="Graphic.md#ga903d7cbc59bac06d728b7f6435c9a504">AlignTopToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1335030029093534"><a name="p1335030029093534"></a><a name="p1335030029093534"></a>void&nbsp;</p>
<p id="p185871988093534"><a name="p185871988093534"></a><a name="p185871988093534"></a>Aligns the view with the top of a sibling view. </p>
</td>
</tr>
<tr id="row101267843093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2009240718093534"><a name="p2009240718093534"></a><a name="p2009240718093534"></a><a href="Graphic.md#ga7607c3f9661932c495d080e9d92fb1a3">AlignBottomToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p783761156093534"><a name="p783761156093534"></a><a name="p783761156093534"></a>void&nbsp;</p>
<p id="p1937119810093534"><a name="p1937119810093534"></a><a name="p1937119810093534"></a>Aligns the view with the bottom of a sibling view. </p>
</td>
</tr>
<tr id="row1053504417093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p575775413093534"><a name="p575775413093534"></a><a name="p575775413093534"></a><a href="Graphic.md#gac23776dbc2fce7ff30d57438abfa5230">AlignHorCenterToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p942944386093534"><a name="p942944386093534"></a><a name="p942944386093534"></a>void&nbsp;</p>
<p id="p1648125788093534"><a name="p1648125788093534"></a><a name="p1648125788093534"></a>Aligns the view with the center of a sibling view in the x-axis. </p>
</td>
</tr>
<tr id="row163207188093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p469002697093534"><a name="p469002697093534"></a><a name="p469002697093534"></a><a href="Graphic.md#gad3caa27aa0cb73ec4656e7d23aa222de">AlignVerCenterToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p13590697093534"><a name="p13590697093534"></a><a name="p13590697093534"></a>void&nbsp;</p>
<p id="p1624972071093534"><a name="p1624972071093534"></a><a name="p1624972071093534"></a>Aligns the view with the center of a sibling view in the y-axis. </p>
</td>
</tr>
<tr id="row1942783285093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1476335822093534"><a name="p1476335822093534"></a><a name="p1476335822093534"></a><a href="Graphic.md#ga58f1a34a943c4492970f901d63bbc3d8">LayoutLeftToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1576312800093534"><a name="p1576312800093534"></a><a name="p1576312800093534"></a>void&nbsp;</p>
<p id="p153476250093534"><a name="p153476250093534"></a><a name="p153476250093534"></a>Lays out the view on the left of a sibling view. </p>
</td>
</tr>
<tr id="row788819198093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1759251044093534"><a name="p1759251044093534"></a><a name="p1759251044093534"></a><a href="Graphic.md#gac4cd64de5291759add164825a323a0d6">LayoutRightToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1454417531093534"><a name="p1454417531093534"></a><a name="p1454417531093534"></a>void&nbsp;</p>
<p id="p1384486285093534"><a name="p1384486285093534"></a><a name="p1384486285093534"></a>Lays out the view on the right of a sibling view. </p>
</td>
</tr>
<tr id="row30951504093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2104706056093534"><a name="p2104706056093534"></a><a name="p2104706056093534"></a><a href="Graphic.md#gaaa8385807e3a9bea46f8dcc326252a70">LayoutTopToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p578821305093534"><a name="p578821305093534"></a><a name="p578821305093534"></a>void&nbsp;</p>
<p id="p531919967093534"><a name="p531919967093534"></a><a name="p531919967093534"></a>Lays out the view on the above of a sibling view. </p>
</td>
</tr>
<tr id="row131341125093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2030174769093534"><a name="p2030174769093534"></a><a name="p2030174769093534"></a><a href="Graphic.md#gaa23a68e8ef0fb13b362218e71cf67ace">LayoutBottomToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p662109636093534"><a name="p662109636093534"></a><a name="p662109636093534"></a>void&nbsp;</p>
<p id="p2130000132093534"><a name="p2130000132093534"></a><a name="p2130000132093534"></a>Lays out the view on the below of a sibling view. </p>
</td>
</tr>
<tr id="row1303243228093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1034122167093534"><a name="p1034122167093534"></a><a name="p1034122167093534"></a><a href="Graphic.md#ga9c1a3db000fdcd200fec8d2c49f5a0a8">SetStyle</a> (<a href="OHOS-Style.md">Style</a> &amp;style)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p865588622093534"><a name="p865588622093534"></a><a name="p865588622093534"></a>virtual void&nbsp;</p>
<p id="p1797935868093534"><a name="p1797935868093534"></a><a name="p1797935868093534"></a>Sets the view style. </p>
</td>
</tr>
<tr id="row1128113895093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1058670520093534"><a name="p1058670520093534"></a><a name="p1058670520093534"></a><a href="Graphic.md#ga0945c2f05815dc2e466ef9ceaca2f700">SetStyle</a> (uint8_t key, int64_t value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1162555804093534"><a name="p1162555804093534"></a><a name="p1162555804093534"></a>virtual void&nbsp;</p>
<p id="p2024081207093534"><a name="p2024081207093534"></a><a name="p2024081207093534"></a>Sets a style. </p>
</td>
</tr>
<tr id="row556146307093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p295245187093534"><a name="p295245187093534"></a><a name="p295245187093534"></a><a href="Graphic.md#ga4ea19bc9f4b487946c9e29e63b54a0e6">GetStyle</a> (uint8_t key) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1950433071093534"><a name="p1950433071093534"></a><a name="p1950433071093534"></a>virtual int64_t&nbsp;</p>
<p id="p2084605385093534"><a name="p2084605385093534"></a><a name="p2084605385093534"></a>Obtains the value of a style. </p>
</td>
</tr>
<tr id="row787320235093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p377074688093534"><a name="p377074688093534"></a><a name="p377074688093534"></a><a href="Graphic.md#ga1b28213d4c2cd0f8324bce3fe56eb7bb">GetStyleConst</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p693242154093534"><a name="p693242154093534"></a><a name="p693242154093534"></a>const <a href="OHOS-Style.md">Style</a> &amp;&nbsp;</p>
<p id="p1851373072093534"><a name="p1851373072093534"></a><a name="p1851373072093534"></a>Obtains the view style. This function applies to scenarios where the style does not need to be modified, which saves memory. </p>
</td>
</tr>
<tr id="row1452149176093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2025073916093534"><a name="p2025073916093534"></a><a name="p2025073916093534"></a><a href="Graphic.md#ga4854963aa969ee20a6cd174a70f5cd23">operator new</a> (size_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1655677351093534"><a name="p1655677351093534"></a><a name="p1655677351093534"></a>void *&nbsp;</p>
<p id="p1967558452093534"><a name="p1967558452093534"></a><a name="p1967558452093534"></a>Overrides the <strong id="b1533756559093534"><a name="b1533756559093534"></a><a name="b1533756559093534"></a>new</strong> function. </p>
</td>
</tr>
<tr id="row350770884093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1124721300093534"><a name="p1124721300093534"></a><a name="p1124721300093534"></a><a href="Graphic.md#gadf1997a0f56ac2b220e7f0f8e8e0a6ef">operator delete</a> (void *p)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p603256967093534"><a name="p603256967093534"></a><a name="p603256967093534"></a>void&nbsp;</p>
<p id="p1820362454093534"><a name="p1820362454093534"></a><a name="p1820362454093534"></a>Overrides the <strong id="b1335551790093534"><a name="b1335551790093534"></a><a name="b1335551790093534"></a>delete</strong> function. </p>
</td>
</tr>
</tbody>
</table>

