# format\_type.h<a name="ZH-CN_TOPIC_0000001054918121"></a>

## **Overview**<a name="section814036891093525"></a>

**Related Modules:**

[Format](Format.md)

**Description:**

Declares format-related structures and enumerations, including custom data types for file information, programs, information about audio and video subtitle tracks, source data types, output data types, split types, and data frames. 

**Since:**

1.0

**Version:**

1.0

## **Summary**<a name="section1736444587093525"></a>

## Data Structures<a name="nested-classes"></a>

<a name="table771451110093525"></a>
<table><thead align="left"><tr id="row1306997836093525"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1106111064093525"><a name="p1106111064093525"></a><a name="p1106111064093525"></a>Data Structure Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p634720573093525"><a name="p634720573093525"></a><a name="p634720573093525"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2011502628093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1440270215093525"><a name="p1440270215093525"></a><a name="p1440270215093525"></a><a href="FormatBufferSetting.md">FormatBufferSetting</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p768034598093525"><a name="p768034598093525"></a><a name="p768034598093525"></a>Defines the buffer configuration. </p>
</td>
</tr>
<tr id="row711278165093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p31250317093525"><a name="p31250317093525"></a><a name="p31250317093525"></a><a href="FormatFrame.md">FormatFrame</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1678210242093525"><a name="p1678210242093525"></a><a name="p1678210242093525"></a>Defines the data frame, which is used for data transferring. </p>
</td>
</tr>
<tr id="row1191325342093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p514235464093525"><a name="p514235464093525"></a><a name="p514235464093525"></a><a href="AudioTrackInfo.md">AudioTrackInfo</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1420135284093525"><a name="p1420135284093525"></a><a name="p1420135284093525"></a>Defines audio track information. </p>
</td>
</tr>
<tr id="row121621675093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1505092440093525"><a name="p1505092440093525"></a><a name="p1505092440093525"></a><a href="VideoTrackInfo.md">VideoTrackInfo</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p8451656093525"><a name="p8451656093525"></a><a name="p8451656093525"></a>Defines video track information. </p>
</td>
</tr>
<tr id="row1736590620093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1576311814093525"><a name="p1576311814093525"></a><a name="p1576311814093525"></a><a href="SubImageInfo.md">SubImageInfo</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1504257550093525"><a name="p1504257550093525"></a><a name="p1504257550093525"></a>Defines image information. </p>
</td>
</tr>
<tr id="row1409368497093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1084089645093525"><a name="p1084089645093525"></a><a name="p1084089645093525"></a><a href="ImageTrackInfo.md">ImageTrackInfo</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p503244513093525"><a name="p503244513093525"></a><a name="p503244513093525"></a>Defines image stream information. </p>
</td>
</tr>
<tr id="row1431455445093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p591461984093525"><a name="p591461984093525"></a><a name="p591461984093525"></a><a href="SubtitleTrackInfo.md">SubtitleTrackInfo</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2080731548093525"><a name="p2080731548093525"></a><a name="p2080731548093525"></a>Defines subtitle stream information. </p>
</td>
</tr>
<tr id="row660872814093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p962167544093525"><a name="p962167544093525"></a><a name="p962167544093525"></a><a href="TrackInfo.md">TrackInfo</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p339263810093525"><a name="p339263810093525"></a><a name="p339263810093525"></a>Defines track information. </p>
</td>
</tr>
<tr id="row341095413093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p969298897093525"><a name="p969298897093525"></a><a name="p969298897093525"></a><a href="ProgramInfo.md">ProgramInfo</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p448329920093525"><a name="p448329920093525"></a><a name="p448329920093525"></a>Defines program information. </p>
</td>
</tr>
<tr id="row2103237475093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1779511728093525"><a name="p1779511728093525"></a><a name="p1779511728093525"></a><a href="FileInfo.md">FileInfo</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p998196974093525"><a name="p998196974093525"></a><a name="p998196974093525"></a>Defines movie file information. </p>
</td>
</tr>
<tr id="row1121902034093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1485551382093525"><a name="p1485551382093525"></a><a name="p1485551382093525"></a><a href="BufferStream.md">BufferStream</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1506662358093525"><a name="p1506662358093525"></a><a name="p1506662358093525"></a>Defines the function for reading stream data. </p>
</td>
</tr>
<tr id="row1314224277093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2058054947093525"><a name="p2058054947093525"></a><a name="p2058054947093525"></a><a href="FormatSource.md">FormatSource</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p442428462093525"><a name="p442428462093525"></a><a name="p442428462093525"></a>Defines the demuxer data source. </p>
</td>
</tr>
<tr id="row1569657444093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1641140940093525"><a name="p1641140940093525"></a><a name="p1641140940093525"></a><a href="FormatOutputConfig.md">FormatOutputConfig</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1349986758093525"><a name="p1349986758093525"></a><a name="p1349986758093525"></a>Defines the muxer output configuration. </p>
</td>
</tr>
<tr id="row1021121694093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p348744297093525"><a name="p348744297093525"></a><a name="p348744297093525"></a><a href="VideoTrackSourceInfo.md">VideoTrackSourceInfo</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p692327064093525"><a name="p692327064093525"></a><a name="p692327064093525"></a>Defines information about the muxer video source. </p>
</td>
</tr>
<tr id="row288304866093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1672265468093525"><a name="p1672265468093525"></a><a name="p1672265468093525"></a><a href="AudioTrackSourceInfo.md">AudioTrackSourceInfo</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p26522300093525"><a name="p26522300093525"></a><a name="p26522300093525"></a>Defines information about the muxer audio source. </p>
</td>
</tr>
<tr id="row1792138869093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p80280868093525"><a name="p80280868093525"></a><a name="p80280868093525"></a><a href="DataTrackSourceInfo.md">DataTrackSourceInfo</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2022552302093525"><a name="p2022552302093525"></a><a name="p2022552302093525"></a>Defines information about the muxer data source. </p>
</td>
</tr>
<tr id="row774851934093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2059739325093525"><a name="p2059739325093525"></a><a name="p2059739325093525"></a><a href="TrackSource.md">TrackSource</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p390768723093525"><a name="p390768723093525"></a><a name="p390768723093525"></a>Defines information about the muxer source. </p>
</td>
</tr>
<tr id="row1290745807093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p120603235093525"><a name="p120603235093525"></a><a name="p120603235093525"></a><a href="FormatCallback.md">FormatCallback</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1812244621093525"><a name="p1812244621093525"></a><a name="p1812244621093525"></a>Defines listener callbacks for the format. </p>
</td>
</tr>
</tbody>
</table>

## Macros<a name="define-members"></a>

<a name="table620565704093525"></a>
<table><thead align="left"><tr id="row1322484105093525"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p805856068093525"><a name="p805856068093525"></a><a name="p805856068093525"></a>Macro Name and Value</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2086274888093525"><a name="p2086274888093525"></a><a name="p2086274888093525"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row904442790093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1283755405093525"><a name="p1283755405093525"></a><a name="p1283755405093525"></a><a href="Format.md#gac2d2d077edb8e9bb9f85ab6350015c5b">FORMAT_MAX_LANGUAGE_NUM</a>&nbsp;&nbsp;&nbsp;4</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">&nbsp;</td>
</tr>
<tr id="row811917941093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1091977275093525"><a name="p1091977275093525"></a><a name="p1091977275093525"></a><a href="Format.md#gaa70508bb1089c99f9aa3d59fcbdfa8eb">FORMAT_LANGUAGE_LEN</a>&nbsp;&nbsp;&nbsp;4</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">&nbsp;</td>
</tr>
<tr id="row2026414672093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1898758508093525"><a name="p1898758508093525"></a><a name="p1898758508093525"></a><a href="Format.md#gadb635fac84a9d62e99c69e75d4de85c3">FORMAT_TITLE_LEN</a>&nbsp;&nbsp;&nbsp;64</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">&nbsp;</td>
</tr>
<tr id="row1403101859093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1154861314093525"><a name="p1154861314093525"></a><a name="p1154861314093525"></a><a href="Format.md#ga62037bb16334896e1bb6d35a71618881">FORMAT_INVALID_TRACK_ID</a>&nbsp;&nbsp;&nbsp;-1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">&nbsp;</td>
</tr>
<tr id="row977555844093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2058902237093525"><a name="p2058902237093525"></a><a name="p2058902237093525"></a><a href="Format.md#gab4007b017f1edad143959af034e32bf7">FORMAT_INVALID_PROGRAM_ID</a>&nbsp;&nbsp;&nbsp;-1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">&nbsp;</td>
</tr>
<tr id="row1942199240093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1835027460093525"><a name="p1835027460093525"></a><a name="p1835027460093525"></a><a href="Format.md#ga1ac54dd3b9b49c1800b5f502a87650be">URL_LEN</a>&nbsp;&nbsp;&nbsp;4096</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">&nbsp;</td>
</tr>
</tbody>
</table>

## Typedefs<a name="typedef-members"></a>

<a name="table1390213037093525"></a>
<table><thead align="left"><tr id="row1726320931093525"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1465768659093525"><a name="p1465768659093525"></a><a name="p1465768659093525"></a>Typedef Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p239527229093525"><a name="p239527229093525"></a><a name="p239527229093525"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1249236631093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1705648612093525"><a name="p1705648612093525"></a><a name="p1705648612093525"></a><a href="Format.md#gab928f39c359734527bda3fd160f89331">CALLBACK_HANDLE</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p873880842093525"><a name="p873880842093525"></a><a name="p873880842093525"></a>typedef void *&nbsp;</p>
<p id="p2098162423093525"><a name="p2098162423093525"></a><a name="p2098162423093525"></a>Indicates the pointer to the callback handle for listening the muxer. </p>
</td>
</tr>
</tbody>
</table>

## Enumerations<a name="enum-members"></a>

<a name="table1677379482093525"></a>
<table><thead align="left"><tr id="row652401750093525"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p321831559093525"><a name="p321831559093525"></a><a name="p321831559093525"></a>Enumeration Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2041940691093525"><a name="p2041940691093525"></a><a name="p2041940691093525"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row795744580093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p877670718093525"><a name="p877670718093525"></a><a name="p877670718093525"></a><a href="Format.md#gad495a9f61af7fff07d7e97979d1ab854">FrameType</a> { &nbsp;&nbsp;<a href="Format.md#ggad495a9f61af7fff07d7e97979d1ab854a54c4b682d718fd6c8e5f224ee2fad841">FRAME_TYPE_NONE</a>, <a href="Format.md#ggad495a9f61af7fff07d7e97979d1ab854a709dd5ff367a8ff7669fda5386291796">FRAME_TYPE_AUDIO</a>, <a href="Format.md#ggad495a9f61af7fff07d7e97979d1ab854a7670f4378c84a94fb65f6c30c4b1a096">FRAME_TYPE_VIDEO</a>, <a href="Format.md#ggad495a9f61af7fff07d7e97979d1ab854a90bb6db5c310d60ccd4a6ec1b172e9e5">FRAME_TYPE_IMAGE</a>, &nbsp;&nbsp;<a href="Format.md#ggad495a9f61af7fff07d7e97979d1ab854a3b43393b8fff68297e4daf0c32193704">FRAME_TYPE_SUB</a>, <a href="Format.md#ggad495a9f61af7fff07d7e97979d1ab854a75641aebcb420f0f661dc8acefdc9b30">FRAME_TYPE_DATA</a>, <a href="Format.md#ggad495a9f61af7fff07d7e97979d1ab854a7afc81a56325cb4a7356663ccd270931">FRAME_TYPE_BUT</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p182093673093525"><a name="p182093673093525"></a><a name="p182093673093525"></a>Enumerates data frame types. </p>
</td>
</tr>
<tr id="row440647660093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1750936692093525"><a name="p1750936692093525"></a><a name="p1750936692093525"></a><a href="Format.md#ga14aa9d18a71eff4a0b70f748f0377c94">FormatSeekMode</a> { <a href="Format.md#gga14aa9d18a71eff4a0b70f748f0377c94a59c30f44f3b65ff91ee18441315dbbcc">FORMAT_SEEK_MODE_FORWARD_KEY</a>, <a href="Format.md#gga14aa9d18a71eff4a0b70f748f0377c94a00f9ebeb7f829675bde8cad3832efcdd">FORMAT_SEEK_MODE_BACKWARD_KEY</a>, <a href="Format.md#gga14aa9d18a71eff4a0b70f748f0377c94a605cab737a9cfc0a06f911efa117646d">FORMAT_SEEK_MODE_CLOSEST_KEY</a>, <a href="Format.md#gga14aa9d18a71eff4a0b70f748f0377c94a1a87eaf0f3e52132aba4563232a6f248">SEEK_MODE_BUT</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1837075461093525"><a name="p1837075461093525"></a><a name="p1837075461093525"></a>Enumerates seek modes. </p>
</td>
</tr>
<tr id="row684080842093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1648537566093525"><a name="p1648537566093525"></a><a name="p1648537566093525"></a><a href="Format.md#gaf7ed135f15d4b218d41705bac0122ba7">CodecFormat</a> { &nbsp;&nbsp;<a href="Format.md#ggaf7ed135f15d4b218d41705bac0122ba7aa0c89a6d185559b38e63265976dde7f4">CODEC_H264</a> = 0, <a href="Format.md#ggaf7ed135f15d4b218d41705bac0122ba7a4adc0c5e441be1b1a642f481e3111cae">CODEC_H265</a>, <a href="Format.md#ggaf7ed135f15d4b218d41705bac0122ba7ab6432cb3fb17152277af1f486e182612">CODEC_JPEG</a>, <a href="Format.md#ggaf7ed135f15d4b218d41705bac0122ba7a8a0888876671d503c2c5e15059461c06">CODEC_AAC</a>, &nbsp;&nbsp;<a href="Format.md#ggaf7ed135f15d4b218d41705bac0122ba7a44fd5227148450a7870e202d50110509">CODEC_G711A</a>, <a href="Format.md#ggaf7ed135f15d4b218d41705bac0122ba7a3ac447dc6b8707c70f6fc6d4e0c552d5">CODEC_G711U</a>, <a href="Format.md#ggaf7ed135f15d4b218d41705bac0122ba7ae3014fa1161193bc92227ea0895e1dfb">CODEC_PCM</a>, <a href="Format.md#ggaf7ed135f15d4b218d41705bac0122ba7a2a0119a66bcbe797c1bac3057a802c9a">CODEC_MP3</a>, &nbsp;&nbsp;<a href="Format.md#ggaf7ed135f15d4b218d41705bac0122ba7a0bccf3a2f309d8c485283d386322f07b">CODEC_BUT</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p655534150093525"><a name="p655534150093525"></a><a name="p655534150093525"></a>Enumerates audio, video, and image encoding formats. </p>
</td>
</tr>
<tr id="row372024259093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p357860562093525"><a name="p357860562093525"></a><a name="p357860562093525"></a><a href="Format.md#gadf0700999998f587f0017c4d02977b22">AudioSampleFmt</a> { &nbsp;&nbsp;<a href="Format.md#ggadf0700999998f587f0017c4d02977b22a650b7f83085e55b6e728fd3ec5beec50">AUDIO_SAMPLE_FMT_S8</a> = 0, <a href="Format.md#ggadf0700999998f587f0017c4d02977b22a40335eaa7ca378540941909ed02b51a0">AUDIO_SAMPLE_FMT_S16</a>, <a href="Format.md#ggadf0700999998f587f0017c4d02977b22af55ab2a69453af86f0c1602d3645f5f9">AUDIO_SAMPLE_FMT_S24</a>, <a href="Format.md#ggadf0700999998f587f0017c4d02977b22ab98feafb8396c0190a4fb719a15ab7c5">AUDIO_SAMPLE_FMT_S32</a>, &nbsp;&nbsp;<a href="Format.md#ggadf0700999998f587f0017c4d02977b22ac2fb27a42b3f79e51dd71ce05b42f9db">AUDIO_SAMPLE_FMT_FLOAT</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p388891932093525"><a name="p388891932093525"></a><a name="p388891932093525"></a>Enumerates audio sampling formats. </p>
</td>
</tr>
<tr id="row595300696093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1689856941093525"><a name="p1689856941093525"></a><a name="p1689856941093525"></a><a href="Format.md#ga43b7f046e365a89697272d850b0517b7">SubtitleFrameType</a> { <a href="Format.md#gga43b7f046e365a89697272d850b0517b7a6bc8b3dca40c75f6dd22feea62cbdac7">HI_SVR_SUBTITLE_BITMAP</a> = 0x0, <a href="Format.md#gga43b7f046e365a89697272d850b0517b7a3ee7a0476e395ec2689f754e58d512a0">HI_SVR_SUBTITLE_TEXT</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p412139737093525"><a name="p412139737093525"></a><a name="p412139737093525"></a>Enumerates subtitle frame types. </p>
</td>
</tr>
<tr id="row1344457916093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p859990795093525"><a name="p859990795093525"></a><a name="p859990795093525"></a><a href="Format.md#gadac45ce4731516c262292c15433439b3">SubtitleFormat</a> { &nbsp;&nbsp;<a href="Format.md#ggadac45ce4731516c262292c15433439b3abe03cb7d3bb87dcfc197b9e9db7a66f6">FORMAT_SUB_ASS</a> = 0x0, <a href="Format.md#ggadac45ce4731516c262292c15433439b3a569e5e22b1c3bf5b9f4cc3f596cfc6db">FORMAT_SUB_LRC</a>, <a href="Format.md#ggadac45ce4731516c262292c15433439b3a26f41cfe561866b43a9757b5902c7609">FORMAT_SUB_SRT</a>, <a href="Format.md#ggadac45ce4731516c262292c15433439b3ac6665b95ccb70e7a7d87dda6370821ff">FORMAT_SUB_SMI</a>, &nbsp;&nbsp;<a href="Format.md#ggadac45ce4731516c262292c15433439b3a07a0a164bb0081359639cfdef57aa2c2">FORMAT_SUB_SUB</a>, <a href="Format.md#ggadac45ce4731516c262292c15433439b3a5ad9a3ec464416e8395e3e0f6595c253">FORMAT_SUB_TXT</a>, <a href="Format.md#ggadac45ce4731516c262292c15433439b3a9f573cd39fab8fc143480bf1eb973574">FORMAT_SUB_HDMV_PGS</a>, <a href="Format.md#ggadac45ce4731516c262292c15433439b3a641b27aab74dbbcd88d7d8612b60caad">FORMAT_SUB_DVB_SUB</a>, &nbsp;&nbsp;<a href="Format.md#ggadac45ce4731516c262292c15433439b3a91ab0e8c1931fc3b4f2350a8e18672a6">FORMAT_SUB_DVD_SUB</a>, <a href="Format.md#ggadac45ce4731516c262292c15433439b3a0750bc81000513246d5785d0ef2c0099">FORMAT_SUB_TTML</a>, <a href="Format.md#ggadac45ce4731516c262292c15433439b3ad9de45a6ae50e5443e2d0418b1cdde61">FORMAT_SUB_WEBVTT</a>, <a href="Format.md#ggadac45ce4731516c262292c15433439b3a52ed4b60bc3d33d43753555e1edf50d7">FORMAT_SUB_BUTT</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p643745532093525"><a name="p643745532093525"></a><a name="p643745532093525"></a>Enumerates subtitle file formats. </p>
</td>
</tr>
<tr id="row281712167093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p243453344093525"><a name="p243453344093525"></a><a name="p243453344093525"></a><a href="Format.md#gad80740dd555f7d3688d2c4d9f44d3b04">TrackType</a> { &nbsp;&nbsp;<a href="Format.md#ggad80740dd555f7d3688d2c4d9f44d3b04aae00a139d1f3bbfef9dbda6803497b62">TRACK_TYPE_VIDEO</a>, <a href="Format.md#ggad80740dd555f7d3688d2c4d9f44d3b04aab84be45f332c1bd8ab31d9404c6d944">TRACK_TYPE_AUDIO</a>, <a href="Format.md#ggad80740dd555f7d3688d2c4d9f44d3b04a3c834b6afb84a38aa490253a3abc5f66">TRACK_TYPE_IMAGE</a>, <a href="Format.md#ggad80740dd555f7d3688d2c4d9f44d3b04aff6cb64c75689ea5b11063e0984956f4">TRACK_TYPE_SUB</a>, &nbsp;&nbsp;<a href="Format.md#ggad80740dd555f7d3688d2c4d9f44d3b04abe0c58f8c0a492959631b8f41dbe2af7">TRACK_TYPE_DATA</a>, <a href="Format.md#ggad80740dd555f7d3688d2c4d9f44d3b04ad3a1729659a9a6453a2d2bda67cb2c22">TRACK_TYPE_BUT</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1001836156093525"><a name="p1001836156093525"></a><a name="p1001836156093525"></a>Enumerates track types. </p>
</td>
</tr>
<tr id="row744191263093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p286011208093525"><a name="p286011208093525"></a><a name="p286011208093525"></a><a href="Format.md#gacff079fdf8427c743f9197ea5be33a7f">DataFlags</a> { &nbsp;&nbsp;<a href="Format.md#ggacff079fdf8427c743f9197ea5be33a7faf5d58e6ec118e0660b53c7a7df2fdc8b">DATA_FLAG_NONE</a> = 0, <a href="Format.md#ggacff079fdf8427c743f9197ea5be33a7fad000cf60ee0b16f1ea7fedbcdb1a9fa0">DATA_FLAG_SYNCFRAME</a> = 1, <a href="Format.md#ggacff079fdf8427c743f9197ea5be33a7fa9200ae4b5fc3c72f2e70c9a49c2ebbb0">DATA_FLAG_CODECCONFIG</a> = 2, <a href="Format.md#ggacff079fdf8427c743f9197ea5be33a7fabaa169afc64ef32b743217c8194fd8b9">DATA_FLAG_EOS</a> = 4, &nbsp;&nbsp;<a href="Format.md#ggacff079fdf8427c743f9197ea5be33a7fa26019220bb1298308f5c3dcd8a071f63">DATA_FLAG_PARTIAL_FRAME</a> = 8, <a href="Format.md#ggacff079fdf8427c743f9197ea5be33a7fa5fd5b55061c6e94a8a12f9cf9d2009a7">DATA_FLAG_ENDOFFRAME</a> = 16, <a href="Format.md#ggacff079fdf8427c743f9197ea5be33a7faeb92d052f544e6cde910fb669790a804">DATA_FLAG_MUXER_DATA</a> = 32 }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1930920182093525"><a name="p1930920182093525"></a><a name="p1930920182093525"></a>Enumerates flags of raw stream data. </p>
</td>
</tr>
<tr id="row1050332520093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1932386146093525"><a name="p1932386146093525"></a><a name="p1932386146093525"></a><a href="Format.md#ga3ae727773c367ac1041d72ac770a0ab1">SourceType</a> { <a href="Format.md#gga3ae727773c367ac1041d72ac770a0ab1a126568132b92d49365d94c4aa00cdde4">SOURCE_TYPE_FD</a> = 0, <a href="Format.md#gga3ae727773c367ac1041d72ac770a0ab1a70d32ea5aeaa325764508722ba31403c">SOURCE_TYPE_URI</a>, <a href="Format.md#gga3ae727773c367ac1041d72ac770a0ab1a7f632a791d8f6dfbe5940b5648d29e6c">SOURCE_TYPE_STREAM</a>, <a href="Format.md#gga3ae727773c367ac1041d72ac770a0ab1ad41c2f0bdca46364d6cd86fc5d4710d3">SOURCE_TYPE_BUT</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p90766999093525"><a name="p90766999093525"></a><a name="p90766999093525"></a>Enumerates types of the demuxer data source. </p>
</td>
</tr>
<tr id="row816536314093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1704361012093525"><a name="p1704361012093525"></a><a name="p1704361012093525"></a><a href="Format.md#gaeb712c6c6c0a8af0dfd79f451ecb9277">OutputFormat</a> { &nbsp;&nbsp;<a href="Format.md#ggaeb712c6c6c0a8af0dfd79f451ecb9277a5a01488de2f310872db03b7a6ad26423">OUTPUT_FORMAT_MPEG_4</a> = 0, <a href="Format.md#ggaeb712c6c6c0a8af0dfd79f451ecb9277a9eaec301329c61d07d2fe19ca473abc2">OUTPUT_FORMAT_TS</a> = 1, <a href="Format.md#ggaeb712c6c6c0a8af0dfd79f451ecb9277a3a0cc99ed9dcc44245dd91591b7accac">OUTPUT_FORMAT_THREE_GPP</a> = 2, <a href="Format.md#ggaeb712c6c6c0a8af0dfd79f451ecb9277a68afc7e60f3cdacd5e1fb9a5dcf0ebdb">OUTPUT_FORMAT_HEIF</a> = 3, &nbsp;&nbsp;<a href="Format.md#ggaeb712c6c6c0a8af0dfd79f451ecb9277abb34ec8353ace07dbfd698c05343800d">OUTPUT_FORMAT_OGG</a> = 4, <a href="Format.md#ggaeb712c6c6c0a8af0dfd79f451ecb9277a00eb675fb0d802a5143f4f718ea854e3">OUTPUT_FORMAT_INVALID</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1055149808093525"><a name="p1055149808093525"></a><a name="p1055149808093525"></a>Enumerates output file formats. </p>
</td>
</tr>
<tr id="row1650183471093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1441568382093525"><a name="p1441568382093525"></a><a name="p1441568382093525"></a><a href="Format.md#ga6f00342925d3d5e586c76f8695985cad">FormatInfoType</a> { &nbsp;&nbsp;<a href="Format.md#gga6f00342925d3d5e586c76f8695985cadaf6214216fd62faa4fc5e20d0d0ba60bf">MUXER_INFO_MAX_DURATION_APPROACHING</a> = 0, <a href="Format.md#gga6f00342925d3d5e586c76f8695985cadafc74f41e73f13a29a83b3a13ea6e66e1">MUXER_INFO_MAX_FILESIZE_APPROACHING</a>, <a href="Format.md#gga6f00342925d3d5e586c76f8695985cada9722ce52063f6247d5fb17470eb9559e">MUXER_INFO_MAX_DURATION_REACHED</a>, <a href="Format.md#gga6f00342925d3d5e586c76f8695985cada71704a053cf3e30c7bf91522b27da8c2">MUXER_INFO_MAX_FILESIZE_REACHED</a>, &nbsp;&nbsp;<a href="Format.md#gga6f00342925d3d5e586c76f8695985cadae63cbc02cf7dc61073b739c08cc58ff4">MUXER_INFO_NEXT_OUTPUT_FILE_STARTED</a>, <a href="Format.md#gga6f00342925d3d5e586c76f8695985cada3cf56a06f5990ab657d61bd7e57c1783">MUXER_INFO_FILE_SPLIT_FINISHED</a>, <a href="Format.md#gga6f00342925d3d5e586c76f8695985cada5d3901c368e7a4f719134c98c4fa8313">MUXER_INFO_FILE_START_TIME_MS</a>, <a href="Format.md#gga6f00342925d3d5e586c76f8695985cadaeb00ffb6342b7ede6b5efe81fa842374">DEMUXER_INFO_PREPARED</a> = 10000, &nbsp;&nbsp;<a href="Format.md#gga6f00342925d3d5e586c76f8695985cada929a71c6b58dfcd974e960b99139a758">DEMUXER_INFO_SEEK_COMPLETE</a>, <a href="Format.md#gga6f00342925d3d5e586c76f8695985cada2c4b1c086d55b4d5bf3fedbbf115cf63">DEMUXER_INFO_NETWORK_DISCONNECTED</a>, <a href="Format.md#gga6f00342925d3d5e586c76f8695985cadac157e535a1828f3b87c9cc3e6fd8773b">DEMUXER_INFO_NETWORK_RECONNECTED</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p293474657093525"><a name="p293474657093525"></a><a name="p293474657093525"></a>Enumerates types of callback information. </p>
</td>
</tr>
<tr id="row1527354570093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1062397148093525"><a name="p1062397148093525"></a><a name="p1062397148093525"></a><a href="Format.md#ga31e7fcf42722fa15e4e5489c2fef9092">FormatErrorType</a> </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1408041888093525"><a name="p1408041888093525"></a><a name="p1408041888093525"></a>Enumerates callback error types. </p>
</td>
</tr>
<tr id="row614163701093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p608232687093525"><a name="p608232687093525"></a><a name="p608232687093525"></a><a href="Format.md#ga4e0517338e6c4a31a2addafc06d4f3a3">OutputType</a> { <a href="Format.md#gga4e0517338e6c4a31a2addafc06d4f3a3a14ea73c5ea45e0f9b6976d24ac1119e9">OUTPUT_TYPE_FD</a> = 0, <a href="Format.md#gga4e0517338e6c4a31a2addafc06d4f3a3a67f14fbe9f23ae5acd2ffc7b00fd6740">OUTPUT_TYPE_URI</a>, <a href="Format.md#gga4e0517338e6c4a31a2addafc06d4f3a3a169d19953026c9c3fed4e4433624ca7c">OUTPUT_TYPE_INVALID</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p755021844093525"><a name="p755021844093525"></a><a name="p755021844093525"></a>Enumerates muxer output types. </p>
</td>
</tr>
<tr id="row359335604093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p121173287093525"><a name="p121173287093525"></a><a name="p121173287093525"></a><a href="Format.md#ga10d9833450f29129d249c41d9acb4bc4">ManualSplitType</a> { <a href="Format.md#gga10d9833450f29129d249c41d9acb4bc4ad283396b08ef486b6615977c881a8724">MANUAL_SPLIT_POST</a> = 0, <a href="Format.md#gga10d9833450f29129d249c41d9acb4bc4ae1c9eea90aaf796ffc5932cc50548716">MANUAL_SPLIT_PRE</a>, <a href="Format.md#gga10d9833450f29129d249c41d9acb4bc4a2b3ef6d50352019e54db9736e6dde05e">MANUAL_SPLIT_NORMAL</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p374667553093525"><a name="p374667553093525"></a><a name="p374667553093525"></a>Enumerates manual split types for the muxer. </p>
</td>
</tr>
<tr id="row412202574093525"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p33742569093525"><a name="p33742569093525"></a><a name="p33742569093525"></a><a href="Format.md#ga953bc46f95d7b2d8866838d792f8f6aa">TrackSourceType</a> { <a href="Format.md#gga953bc46f95d7b2d8866838d792f8f6aaa59d8c33314397a4ae8c1ca7b9e4eb40f">TRACK_SOURCE_TYPE_VIDEO</a> = 0, <a href="Format.md#gga953bc46f95d7b2d8866838d792f8f6aaa5e9f39cae59134e444907af8b372b7a4">TRACK_SOURCE_TYPE_AUDIO</a>, <a href="Format.md#gga953bc46f95d7b2d8866838d792f8f6aaa5d0d794425327268d08990d26a21f50c">TRACK_SOURCE_TYPE_DATA</a>, <a href="Format.md#gga953bc46f95d7b2d8866838d792f8f6aaa0fae189aab417f7c9756523f15a20cca">TRACK_SOURCE_TYPE_INVALID</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1263058716093525"><a name="p1263058716093525"></a><a name="p1263058716093525"></a>Enumerates types of the muxer source track. </p>
</td>
</tr>
</tbody>
</table>

