# 发行版<a name="ZH-CN_TOPIC_0000001051770842"></a>

发行版通常是将一系列组件组合起来，成为编译可以运行的OpenHarmony解决方案镜像，里面包含了多个依赖的组件，以及脚本，用于描述如何完整编译、链接这些组件。

发行版本身通常不需要包含功能实现代码，仅包含bundle.json描述（设置publishAs为distribution）和一些编译脚本组成。

因为发行版编译的过程需要系统提供环境变量，所以发行版使用scripts脚本中内置的dist命令：

```
{
    "publishAs":"distribution",
    "scripts": {
        "dist": "script compile command"
    }
}
```

编译执行使用如下命令：

```
hpm dist 
```

重新定义一个发行版所具有的功能是一个复杂的过程，所以系统允许对发行版进行继承，从而在现有功能的基础上进行定制。继承发行版需要在bundle.json中定义base字段。

```
{
    "base": {
        "name": "dist_wifi_iot",
        "version": "1.0.0"
    }
}
```

上述定义表明当前组件继承自发行版组件dist-wifi-iot 1.0.0。

发行版由很多的依赖组件组成，通过bundle.json中的dependencies段来描述，有些依赖是必须的，有些依赖则是根据可以需求增加或删除的。bundle.json中名称前带有？的依赖表示可选依赖，继承它的发行版，可以移除掉该可选组件，再增加别的组件进行替换。

```
{
    "dependencies": {
        "?my_bundle": "1.0.0"
    }
}
```

上述声明表示my\_bundle依赖可以被移除。如果想要移除my\_bundle，在上层依赖方需要使用excludes关键字来进行定义

```
{
    "excludes": [ "my_bundle" ]
}
```

依赖被移除后，就不会参入组件的构建过程。只有标记为可选的依赖才能够被移除，强行移除未被标记的依赖会出现错误提示。

