# FS<a name="EN-US_TOPIC_0000001055069400"></a>

## **Overview**<a name="section876787693084823"></a>

Provides functions for file system, include file operations, directory operations and so on. 

**Since:**

1.0

**Version:**

1.0

## **Summary**<a name="section259432918084823"></a>

## Files<a name="files"></a>

<a name="table1591154859084823"></a>
<table><thead align="left"><tr id="row2132692720084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2041104383084823"><a name="p2041104383084823"></a><a name="p2041104383084823"></a>File Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1165803184084823"><a name="p1165803184084823"></a><a name="p1165803184084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1390357840084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p672025314084823"><a name="p672025314084823"></a><a name="p672025314084823"></a><a href="dirent-h.md">dirent.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2039761477084823"><a name="p2039761477084823"></a><a name="p2039761477084823"></a>Provides functions and structures used for performing file system operations, including file read/write, directory traversal, and file system mounting. </p>
</td>
</tr>
<tr id="row576194807084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1621619158084823"><a name="p1621619158084823"></a><a name="p1621619158084823"></a><a href="fcntl-h.md">fcntl.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p495024669084823"><a name="p495024669084823"></a><a name="p495024669084823"></a>Declares structures and functions used for file and directory operations such as opening a file, creating a file, and allocating space. </p>
</td>
</tr>
<tr id="row306243309084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2128388439084823"><a name="p2128388439084823"></a><a name="p2128388439084823"></a><a href="ftw-h.md">ftw.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1159817652084823"><a name="p1159817652084823"></a><a name="p1159817652084823"></a>Provides functions and structures related to file tree traversal. </p>
</td>
</tr>
<tr id="row1207048546084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p846113626084823"><a name="p846113626084823"></a><a name="p846113626084823"></a><a href="glob-h.md">glob.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1861377090084823"><a name="p1861377090084823"></a><a name="p1861377090084823"></a>Provides functions and structures used to find path names matching a pattern and release the memory that was applied for during the search. </p>
</td>
</tr>
<tr id="row1222351215084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p354778142084823"><a name="p354778142084823"></a><a name="p354778142084823"></a><a href="libgen-h.md">libgen.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p905483083084823"><a name="p905483083084823"></a><a name="p905483083084823"></a>Provides functions related to file management, for example, obtaining directory and file names. </p>
</td>
</tr>
<tr id="row108831278084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1654932653084823"><a name="p1654932653084823"></a><a name="p1654932653084823"></a><a href="ioctl-h.md">ioctl.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2062305002084823"><a name="p2062305002084823"></a><a name="p2062305002084823"></a>Manipulates a device. </p>
</td>
</tr>
<tr id="row1828642606084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p556058691084823"><a name="p556058691084823"></a><a name="p556058691084823"></a><a href="mount-h.md">mount.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p3300784084823"><a name="p3300784084823"></a><a name="p3300784084823"></a>Provides functions for mounting and unmounting a file system. </p>
</td>
</tr>
<tr id="row1996528652084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2111316889084823"><a name="p2111316889084823"></a><a name="p2111316889084823"></a><a href="stat-h.md">stat.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1967007365084823"><a name="p1967007365084823"></a><a name="p1967007365084823"></a>Provides functions for file and directory operations. </p>
</td>
</tr>
<tr id="row517854436084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1676306287084823"><a name="p1676306287084823"></a><a name="p1676306287084823"></a><a href="statfs-h.md">statfs.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p869871990084823"><a name="p869871990084823"></a><a name="p869871990084823"></a>Provides a function to obtain information about a file system. </p>
</td>
</tr>
<tr id="row397414598084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p698314679084823"><a name="p698314679084823"></a><a name="p698314679084823"></a><a href="statvfs-h.md">statvfs.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1994374618084823"><a name="p1994374618084823"></a><a name="p1994374618084823"></a>Provides a function and structure related to file system information operation, for example, viewing file system information. </p>
</td>
</tr>
<tr id="row1762358836084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p988224394084823"><a name="p988224394084823"></a><a name="p988224394084823"></a><a href="utime-h.md">utime.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1765614550084823"><a name="p1765614550084823"></a><a name="p1765614550084823"></a>Provides the function and structure used for setting file access time and modification time. </p>
</td>
</tr>
</tbody>
</table>

## Data Structures<a name="nested-classes"></a>

<a name="table1916270376084823"></a>
<table><thead align="left"><tr id="row339324983084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1807623259084823"><a name="p1807623259084823"></a><a name="p1807623259084823"></a>Data Structure Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1274738027084823"><a name="p1274738027084823"></a><a name="p1274738027084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row89299340084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p741567332084823"><a name="p741567332084823"></a><a name="p741567332084823"></a><a href="dirent.md">dirent</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p872802484084823"><a name="p872802484084823"></a><a name="p872802484084823"></a>Defines the content of the directory. </p>
</td>
</tr>
<tr id="row1579934962084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p270547103084823"><a name="p270547103084823"></a><a name="p270547103084823"></a><a href="ftw.md">FTW</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p196062176084823"><a name="p196062176084823"></a><a name="p196062176084823"></a>Defines the file tree walker (<a href="ftw.md">FTW</a>). </p>
</td>
</tr>
<tr id="row523611386084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1241227299084823"><a name="p1241227299084823"></a><a name="p1241227299084823"></a><a href="glob_t.md">glob_t</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1331233242084823"><a name="p1331233242084823"></a><a name="p1331233242084823"></a>Defines the search information. </p>
</td>
</tr>
<tr id="row2095856389084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p447424379084823"><a name="p447424379084823"></a><a name="p447424379084823"></a><a href="stat.md">stat</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2039071881084823"><a name="p2039071881084823"></a><a name="p2039071881084823"></a>Defines the file information structure. </p>
</td>
</tr>
<tr id="row766239585084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1969683284084823"><a name="p1969683284084823"></a><a name="p1969683284084823"></a><a href="statvfs.md">statvfs</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1553879755084823"><a name="p1553879755084823"></a><a name="p1553879755084823"></a>Describes file system information. </p>
</td>
</tr>
<tr id="row1017670933084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p155568835084823"><a name="p155568835084823"></a><a name="p155568835084823"></a><a href="utimbuf.md">utimbuf</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1068497270084823"><a name="p1068497270084823"></a><a name="p1068497270084823"></a>Defines the file access time and modification time. </p>
</td>
</tr>
</tbody>
</table>

## Macros<a name="define-members"></a>

<a name="table974907355084823"></a>
<table><thead align="left"><tr id="row2125262338084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p833171543084823"><a name="p833171543084823"></a><a name="p833171543084823"></a>Macro Name and Value</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1781330659084823"><a name="p1781330659084823"></a><a name="p1781330659084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row573320621084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1198421503084823"><a name="p1198421503084823"></a><a name="p1198421503084823"></a><em id="ga4dc4d45e07d2abc899bcaf04b2846a87"><a name="ga4dc4d45e07d2abc899bcaf04b2846a87"></a><a name="ga4dc4d45e07d2abc899bcaf04b2846a87"></a></em>O_ACCMODE    (03|O_SEARCH)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p880175750084823"><a name="p880175750084823"></a><a name="p880175750084823"></a>Access mode. </p>
</td>
</tr>
<tr id="row1740608669084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2033704326084823"><a name="p2033704326084823"></a><a name="p2033704326084823"></a><em id="ga7a68c9ffaac7dbcd652225dd7c06a54b"><a name="ga7a68c9ffaac7dbcd652225dd7c06a54b"></a><a name="ga7a68c9ffaac7dbcd652225dd7c06a54b"></a></em>O_RDONLY    00</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1437324456084823"><a name="p1437324456084823"></a><a name="p1437324456084823"></a>Read-only. </p>
</td>
</tr>
<tr id="row1299080332084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1811222734084823"><a name="p1811222734084823"></a><a name="p1811222734084823"></a><em id="ga11b644a8526139c4cc1850dac1271ced"><a name="ga11b644a8526139c4cc1850dac1271ced"></a><a name="ga11b644a8526139c4cc1850dac1271ced"></a></em>O_WRONLY    01</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p417522904084823"><a name="p417522904084823"></a><a name="p417522904084823"></a>Write-only. </p>
</td>
</tr>
<tr id="row75492959084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1196079532084823"><a name="p1196079532084823"></a><a name="p1196079532084823"></a><em id="gabb0586253488ee61072b73557eeb873b"><a name="gabb0586253488ee61072b73557eeb873b"></a><a name="gabb0586253488ee61072b73557eeb873b"></a></em>O_RDWR    02</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1070827007084823"><a name="p1070827007084823"></a><a name="p1070827007084823"></a>Read and write. </p>
</td>
</tr>
<tr id="row1948258189084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1280537606084823"><a name="p1280537606084823"></a><a name="p1280537606084823"></a><em id="ga3bc050c90515f35b4cd6cea24760110c"><a name="ga3bc050c90515f35b4cd6cea24760110c"></a><a name="ga3bc050c90515f35b4cd6cea24760110c"></a></em>fallocate64    <a href="fs.md#ga26ba05fc43886db02fe169b35e04bfdf">fallocate</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1160865276084823"><a name="p1160865276084823"></a><a name="p1160865276084823"></a>Pre-allocates space to a file. See <a href="fs.md#ga26ba05fc43886db02fe169b35e04bfdf">fallocate</a>. </p>
</td>
</tr>
<tr id="row1186855459084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1572635343084823"><a name="p1572635343084823"></a><a name="p1572635343084823"></a><em id="ga2feb73df4762e428e3967f8dfbbc8696"><a name="ga2feb73df4762e428e3967f8dfbbc8696"></a><a name="ga2feb73df4762e428e3967f8dfbbc8696"></a></em>FTW_F    1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p422208404084823"><a name="p422208404084823"></a><a name="p422208404084823"></a>Regular file. </p>
</td>
</tr>
<tr id="row485810166084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1063629997084823"><a name="p1063629997084823"></a><a name="p1063629997084823"></a><em id="gabb7c3d2c39c0f3c8c5f0f1b9caa3499a"><a name="gabb7c3d2c39c0f3c8c5f0f1b9caa3499a"></a><a name="gabb7c3d2c39c0f3c8c5f0f1b9caa3499a"></a></em>FTW_D    2</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p757618651084823"><a name="p757618651084823"></a><a name="p757618651084823"></a>Directory. </p>
</td>
</tr>
<tr id="row481711026084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p515550057084823"><a name="p515550057084823"></a><a name="p515550057084823"></a><em id="gaf38dcdf86d19736b0aa55ac4defa666e"><a name="gaf38dcdf86d19736b0aa55ac4defa666e"></a><a name="gaf38dcdf86d19736b0aa55ac4defa666e"></a></em>FTW_DNR    3</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p354369791084823"><a name="p354369791084823"></a><a name="p354369791084823"></a>Unreadable directory. Its subdirectories will not be traversed. </p>
</td>
</tr>
<tr id="row348396938084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p255789630084823"><a name="p255789630084823"></a><a name="p255789630084823"></a><em id="ga17ff288701c7c6baf075795c9a1beb86"><a name="ga17ff288701c7c6baf075795c9a1beb86"></a><a name="ga17ff288701c7c6baf075795c9a1beb86"></a></em>FTW_NS    4</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2098873477084823"><a name="p2098873477084823"></a><a name="p2098873477084823"></a>The data of the <strong id="b711258401084823"><a name="b711258401084823"></a><a name="b711258401084823"></a>stat</strong> structure cannot be obtained. The possible cause is that the permission is incorrect. </p>
</td>
</tr>
<tr id="row1619193193084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p248494262084823"><a name="p248494262084823"></a><a name="p248494262084823"></a><em id="gaeee6cd556fb6bfaf7237772e698fa48d"><a name="gaeee6cd556fb6bfaf7237772e698fa48d"></a><a name="gaeee6cd556fb6bfaf7237772e698fa48d"></a></em>FTW_SL    5</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p917327472084823"><a name="p917327472084823"></a><a name="p917327472084823"></a>Symbolic link. </p>
</td>
</tr>
<tr id="row857224515084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p143272463084823"><a name="p143272463084823"></a><a name="p143272463084823"></a><a href="fs.md#ga8b34563aa640cd03e2ddf054b0b99e49">FTW_DP</a>   6</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">&nbsp;</td>
</tr>
<tr id="row1147448925084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p872510804084823"><a name="p872510804084823"></a><a name="p872510804084823"></a><em id="gaf0e95fe567ba665873d18284d67e0f80"><a name="gaf0e95fe567ba665873d18284d67e0f80"></a><a name="gaf0e95fe567ba665873d18284d67e0f80"></a></em>FTW_SLN    7</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1780163257084823"><a name="p1780163257084823"></a><a name="p1780163257084823"></a>Symbolic link that names a non-existent file. </p>
</td>
</tr>
<tr id="row822682958084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p765518184084823"><a name="p765518184084823"></a><a name="p765518184084823"></a><em id="ga8c98a3c79a82339a189b11094032a09a"><a name="ga8c98a3c79a82339a189b11094032a09a"></a><a name="ga8c98a3c79a82339a189b11094032a09a"></a></em>FTW_PHYS    1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1700134151084823"><a name="p1700134151084823"></a><a name="p1700134151084823"></a>Symbolic links that are not traversed. If not set, symbolic links are traversed by default. </p>
</td>
</tr>
<tr id="row1180482186084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1684415531084823"><a name="p1684415531084823"></a><a name="p1684415531084823"></a><em id="ga7bbaf43efae1f2d3c8092d99a340729d"><a name="ga7bbaf43efae1f2d3c8092d99a340729d"></a><a name="ga7bbaf43efae1f2d3c8092d99a340729d"></a></em>FTW_MOUNT    2</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p185768482084823"><a name="p185768482084823"></a><a name="p185768482084823"></a>Stay within the same file system. </p>
</td>
</tr>
<tr id="row1930124914084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p937020316084823"><a name="p937020316084823"></a><a name="p937020316084823"></a><em id="gad8a9cc4cf048af5fab2c5f65ed9cb0db"><a name="gad8a9cc4cf048af5fab2c5f65ed9cb0db"></a><a name="gad8a9cc4cf048af5fab2c5f65ed9cb0db"></a></em>FTW_CHDIR    4</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1223136432084823"><a name="p1223136432084823"></a><a name="p1223136432084823"></a><a href="utils.md#ga03af571dfb595681bfa203c83385c07b">chdir</a> is called to go to the directory before reading the directory. </p>
</td>
</tr>
<tr id="row1956378018084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1090110764084823"><a name="p1090110764084823"></a><a name="p1090110764084823"></a><em id="gaf9008c0040247fbea883ec24b10cf884"><a name="gaf9008c0040247fbea883ec24b10cf884"></a><a name="gaf9008c0040247fbea883ec24b10cf884"></a></em>FTW_DEPTH    8</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1919080582084823"><a name="p1919080582084823"></a><a name="p1919080582084823"></a>All subdirectories will be traversed before the directory itself. </p>
</td>
</tr>
<tr id="row923646152084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1258172282084823"><a name="p1258172282084823"></a><a name="p1258172282084823"></a><em id="ga9e77b0b20a1c1d66cdf924a07776f360"><a name="ga9e77b0b20a1c1d66cdf924a07776f360"></a><a name="ga9e77b0b20a1c1d66cdf924a07776f360"></a></em>GLOB_ERR    0x01</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1951331821084823"><a name="p1951331821084823"></a><a name="p1951331821084823"></a>Return upon a read error. </p>
</td>
</tr>
<tr id="row659402896084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1864411057084823"><a name="p1864411057084823"></a><a name="p1864411057084823"></a><em id="gac6ec2b6ae844d895de9685a689dd27f0"><a name="gac6ec2b6ae844d895de9685a689dd27f0"></a><a name="gac6ec2b6ae844d895de9685a689dd27f0"></a></em>GLOB_MARK    0x02</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p191751315084823"><a name="p191751315084823"></a><a name="p191751315084823"></a>Append a slash (/) to each path, which corresponds to a directory. </p>
</td>
</tr>
<tr id="row1588003101084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p225887113084823"><a name="p225887113084823"></a><a name="p225887113084823"></a><em id="ga4eba6cedebdfe13f924d9b4a489bfe83"><a name="ga4eba6cedebdfe13f924d9b4a489bfe83"></a><a name="ga4eba6cedebdfe13f924d9b4a489bfe83"></a></em>GLOB_NOSORT    0x04</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p754289119084823"><a name="p754289119084823"></a><a name="p754289119084823"></a>Do not sort the returned path names. </p>
</td>
</tr>
<tr id="row6329517084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p874123008084823"><a name="p874123008084823"></a><a name="p874123008084823"></a><em id="ga8ae13e97ae5da0993fe526c406337c62"><a name="ga8ae13e97ae5da0993fe526c406337c62"></a><a name="ga8ae13e97ae5da0993fe526c406337c62"></a></em>GLOB_DOOFFS    0x08</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p696552779084823"><a name="p696552779084823"></a><a name="p696552779084823"></a>In the <strong id="b619775249084823"><a name="b619775249084823"></a><a name="b619775249084823"></a>pglob</strong> parameter of the <a href="fs.md#gae98601409da7fd3c85a9c219e1a9020c">glob()</a> function, reserve a string that has a length of <strong id="b275676281084823"><a name="b275676281084823"></a><a name="b275676281084823"></a>pglob-&gt;gl_offs</strong> and ends with <strong id="b575198481084823"><a name="b575198481084823"></a><a name="b575198481084823"></a>\0</strong> at the beginning of the string list in <strong id="b759314059084823"><a name="b759314059084823"></a><a name="b759314059084823"></a>pglob-&gt;pathv</strong>. That is, the newly matched string is appended to a position where the distance from the beginning of <strong id="b1839644518084823"><a name="b1839644518084823"></a><a name="b1839644518084823"></a>pglob-&gt;pathv</strong> is the length of <strong id="b1502642532084823"><a name="b1502642532084823"></a><a name="b1502642532084823"></a>pglob-&gt;gl_offs</strong>. </p>
</td>
</tr>
<tr id="row121113263084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p306897520084823"><a name="p306897520084823"></a><a name="p306897520084823"></a><em id="gaf183b2f40936442579be8d62b87e6fc6"><a name="gaf183b2f40936442579be8d62b87e6fc6"></a><a name="gaf183b2f40936442579be8d62b87e6fc6"></a></em>GLOB_NOCHECK    0x10</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1939874496084823"><a name="p1939874496084823"></a><a name="p1939874496084823"></a>If no pattern matches, return the original pattern. </p>
</td>
</tr>
<tr id="row1692770875084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1077141417084823"><a name="p1077141417084823"></a><a name="p1077141417084823"></a><em id="ga7e586df07bb159e904a61d8470f1fda2"><a name="ga7e586df07bb159e904a61d8470f1fda2"></a><a name="ga7e586df07bb159e904a61d8470f1fda2"></a></em>GLOB_APPEND    0x20</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1587762690084823"><a name="p1587762690084823"></a><a name="p1587762690084823"></a>Append the results of this call to the results returned by a previous call to <strong id="b2072567718084823"><a name="b2072567718084823"></a><a name="b2072567718084823"></a><a href="fs.md#gae98601409da7fd3c85a9c219e1a9020c">glob()</a></strong>. </p>
</td>
</tr>
<tr id="row1610981479084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p518326737084823"><a name="p518326737084823"></a><a name="p518326737084823"></a><em id="gad21c37825788f86d5fefea803276f746"><a name="gad21c37825788f86d5fefea803276f746"></a><a name="gad21c37825788f86d5fefea803276f746"></a></em>GLOB_NOESCAPE    0x40</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p471623503084823"><a name="p471623503084823"></a><a name="p471623503084823"></a>Do not use a backslash () as an escape character. </p>
</td>
</tr>
<tr id="row219879300084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1386305831084823"><a name="p1386305831084823"></a><a name="p1386305831084823"></a><em id="gab548aece9c1254c6c08475ce8c6274a2"><a name="gab548aece9c1254c6c08475ce8c6274a2"></a><a name="gab548aece9c1254c6c08475ce8c6274a2"></a></em>GLOB_PERIOD    0x80</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p11467349084823"><a name="p11467349084823"></a><a name="p11467349084823"></a>Allow a leading period to be matched by metacharacters. </p>
</td>
</tr>
<tr id="row1098621483084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p419545018084823"><a name="p419545018084823"></a><a name="p419545018084823"></a><em id="ga4f1c6c0dae8dfefcf3032fed1b5cd0fe"><a name="ga4f1c6c0dae8dfefcf3032fed1b5cd0fe"></a><a name="ga4f1c6c0dae8dfefcf3032fed1b5cd0fe"></a></em>GLOB_TILDE    0x1000</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1571397557084823"><a name="p1571397557084823"></a><a name="p1571397557084823"></a>Carry out tilde expansion. If a tilde (~) is the only character in the pattern, or an initial tilde is followed immediately by a slash (/), then the home directory of the caller is substituted for the tilde. </p>
</td>
</tr>
<tr id="row1964965003084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p628210081084823"><a name="p628210081084823"></a><a name="p628210081084823"></a><em id="gacf779f5283225f7a1507122f75418103"><a name="gacf779f5283225f7a1507122f75418103"></a><a name="gacf779f5283225f7a1507122f75418103"></a></em>GLOB_TILDE_CHECK    0x4000</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2042459412084823"><a name="p2042459412084823"></a><a name="p2042459412084823"></a>Similar to <a href="fs.md#ga4f1c6c0dae8dfefcf3032fed1b5cd0fe">GLOB_TILDE</a>. The difference is that if the username is invalid, or the home directory cannot be determined, <a href="fs.md#gae98601409da7fd3c85a9c219e1a9020c">glob()</a> returns <a href="fs.md#gaed760cf90fd4398067cdb679ebe60312">GLOB_NOMATCH</a> to indicate an error. </p>
</td>
</tr>
<tr id="row2048629901084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p902828927084823"><a name="p902828927084823"></a><a name="p902828927084823"></a><em id="gab53de39e075e6fb9a11678341772930b"><a name="gab53de39e075e6fb9a11678341772930b"></a><a name="gab53de39e075e6fb9a11678341772930b"></a></em>GLOB_NOSPACE    1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1499827269084823"><a name="p1499827269084823"></a><a name="p1499827269084823"></a>Memory insufficient. </p>
</td>
</tr>
<tr id="row927943282084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2006540100084823"><a name="p2006540100084823"></a><a name="p2006540100084823"></a><em id="gab5de50cedafa21283878657d05fb2ba8"><a name="gab5de50cedafa21283878657d05fb2ba8"></a><a name="gab5de50cedafa21283878657d05fb2ba8"></a></em>GLOB_ABORTED    2</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p297013810084823"><a name="p297013810084823"></a><a name="p297013810084823"></a>Read error. </p>
</td>
</tr>
<tr id="row1378856458084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p535927564084823"><a name="p535927564084823"></a><a name="p535927564084823"></a><em id="gaed760cf90fd4398067cdb679ebe60312"><a name="gaed760cf90fd4398067cdb679ebe60312"></a><a name="gaed760cf90fd4398067cdb679ebe60312"></a></em>GLOB_NOMATCH    3</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1193778639084823"><a name="p1193778639084823"></a><a name="p1193778639084823"></a>No matching item is found. </p>
</td>
</tr>
<tr id="row1838046088084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p674385349084823"><a name="p674385349084823"></a><a name="p674385349084823"></a><em id="ga121ff4729e5e2d403808f90e6a47a113"><a name="ga121ff4729e5e2d403808f90e6a47a113"></a><a name="ga121ff4729e5e2d403808f90e6a47a113"></a></em>GLOB_NOSYS    4</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p997917883084823"><a name="p997917883084823"></a><a name="p997917883084823"></a>The function is not supported. </p>
</td>
</tr>
</tbody>
</table>

## Typedefs<a name="typedef-members"></a>

<a name="table198610276084823"></a>
<table><thead align="left"><tr id="row2011553251084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1710929725084823"><a name="p1710929725084823"></a><a name="p1710929725084823"></a>Typedef Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p889303911084823"><a name="p889303911084823"></a><a name="p889303911084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1114270776084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1785185508084823"><a name="p1785185508084823"></a><a name="p1785185508084823"></a><em id="ga0ebe68390948c14bb9d82987adbfc849"><a name="ga0ebe68390948c14bb9d82987adbfc849"></a><a name="ga0ebe68390948c14bb9d82987adbfc849"></a></em>DIR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1617710624084823"><a name="p1617710624084823"></a><a name="p1617710624084823"></a><strong id="b157295028"><a name="b157295028"></a><a name="b157295028"></a></strong> typedef struct __dirstream </p>
<p id="p1476188605084823"><a name="p1476188605084823"></a><a name="p1476188605084823"></a>Opens the handle of the folder directory. </p>
</td>
</tr>
</tbody>
</table>

## Functions<a name="func-members"></a>

<a name="table525042490084823"></a>
<table><thead align="left"><tr id="row1308459120084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1064497277084823"><a name="p1064497277084823"></a><a name="p1064497277084823"></a>Function Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p303210401084823"><a name="p303210401084823"></a><a name="p303210401084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1687697342084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p58717319084823"><a name="p58717319084823"></a><a name="p58717319084823"></a><a href="fs.md#gaaeac2b41e8c2c3a5f91c9bd511a8c0a6">closedir</a> (<a href="fs.md#ga0ebe68390948c14bb9d82987adbfc849">DIR</a> *dirp)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p90481911084823"><a name="p90481911084823"></a><a name="p90481911084823"></a>int </p>
<p id="p1758183394084823"><a name="p1758183394084823"></a><a name="p1758183394084823"></a>Closes a specified directory. </p>
</td>
</tr>
<tr id="row408559202084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p862711275084823"><a name="p862711275084823"></a><a name="p862711275084823"></a><a href="fs.md#gad09dd96447776d2bc5d8321e4b499591">opendir</a> (const char *<a href="fs.md#gab1b6028f4625caec30c1020e737216e2">dirname</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1549297090084823"><a name="p1549297090084823"></a><a name="p1549297090084823"></a><a href="fs.md#ga0ebe68390948c14bb9d82987adbfc849">DIR</a> * </p>
<p id="p334670937084823"><a name="p334670937084823"></a><a name="p334670937084823"></a>Opens a specified directory. </p>
</td>
</tr>
<tr id="row2134784919084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p680655782084823"><a name="p680655782084823"></a><a name="p680655782084823"></a><a href="fs.md#ga58257faf8b13b3f14558613c632b2373">readdir</a> (<a href="fs.md#ga0ebe68390948c14bb9d82987adbfc849">DIR</a> *dirp)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1138881417084823"><a name="p1138881417084823"></a><a name="p1138881417084823"></a>struct <a href="dirent.md">dirent</a> * </p>
<p id="p1578656295084823"><a name="p1578656295084823"></a><a name="p1578656295084823"></a>Reads a specified directory. </p>
</td>
</tr>
<tr id="row1403633620084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1818172702084823"><a name="p1818172702084823"></a><a name="p1818172702084823"></a><a href="fs.md#ga9f1bc61c37394eda9e74e0c79afec872">readdir_r</a> (<a href="fs.md#ga0ebe68390948c14bb9d82987adbfc849">DIR</a> *__restrict dirp, struct <a href="dirent.md">dirent</a> *__restrict <a href="entry.md">entry</a>, struct <a href="dirent.md">dirent</a> **__restrict result)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1391534814084823"><a name="p1391534814084823"></a><a name="p1391534814084823"></a>int </p>
<p id="p908676541084823"><a name="p908676541084823"></a><a name="p908676541084823"></a>Reads a specified directory (thread-safe version). </p>
</td>
</tr>
<tr id="row1921545562084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1527649023084823"><a name="p1527649023084823"></a><a name="p1527649023084823"></a><a href="fs.md#gad4fcb58b9194b1a3c1699654de963719">rewinddir</a> (<a href="fs.md#ga0ebe68390948c14bb9d82987adbfc849">DIR</a> *dirp)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1326925956084823"><a name="p1326925956084823"></a><a name="p1326925956084823"></a>void </p>
<p id="p1148819529084823"><a name="p1148819529084823"></a><a name="p1148819529084823"></a>Resets a directory stream read position. </p>
</td>
</tr>
<tr id="row388045556084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p862481552084823"><a name="p862481552084823"></a><a name="p862481552084823"></a><a href="fs.md#ga8a52fd9a3ded793b8200ac0a5a1f10d2">alphasort</a> (const struct <a href="dirent.md">dirent</a> **a, const struct <a href="dirent.md">dirent</a> **b)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p167055304084823"><a name="p167055304084823"></a><a name="p167055304084823"></a>int </p>
<p id="p117933884084823"><a name="p117933884084823"></a><a name="p117933884084823"></a>Sorts the directory entries in alphabetical order. </p>
</td>
</tr>
<tr id="row1305766429084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p363267676084823"><a name="p363267676084823"></a><a name="p363267676084823"></a><a href="fs.md#gaca6df630e382cf13bac90ed6e5c4141c">scandir</a> (const char *dir, struct <a href="dirent.md">dirent</a> ***namelist, int(*sel)(const struct <a href="dirent.md">dirent</a> *), int(*compar)(const struct <a href="dirent.md">dirent</a> **, const struct <a href="dirent.md">dirent</a> **))</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p40902911084823"><a name="p40902911084823"></a><a name="p40902911084823"></a>int </p>
<p id="p146514864084823"><a name="p146514864084823"></a><a name="p146514864084823"></a>Scans directory to find the target entries. </p>
</td>
</tr>
<tr id="row1274992127084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1756016382084823"><a name="p1756016382084823"></a><a name="p1756016382084823"></a><a href="fs.md#gacf0a74ce364760e330619edb38eadfff">seekdir</a> (<a href="fs.md#ga0ebe68390948c14bb9d82987adbfc849">DIR</a> *dirp, long offset)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1622881982084823"><a name="p1622881982084823"></a><a name="p1622881982084823"></a>void </p>
<p id="p205992020084823"><a name="p205992020084823"></a><a name="p205992020084823"></a>Sets the position of the next <a href="fs.md#ga58257faf8b13b3f14558613c632b2373">readdir</a> call in the directory stream. </p>
</td>
</tr>
<tr id="row5268853084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p118624995084823"><a name="p118624995084823"></a><a name="p118624995084823"></a><a href="fs.md#ga4c2cd02bd612ae655782632c9f5227ec">telldir</a> (<a href="fs.md#ga0ebe68390948c14bb9d82987adbfc849">DIR</a> *dirp)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1007294599084823"><a name="p1007294599084823"></a><a name="p1007294599084823"></a>long </p>
<p id="p1064409344084823"><a name="p1064409344084823"></a><a name="p1064409344084823"></a>Obtains the current position in the specified directory stream. </p>
</td>
</tr>
<tr id="row77573831084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p426928369084823"><a name="p426928369084823"></a><a name="p426928369084823"></a><a href="fs.md#gafddc24a65767ae35f275be8ccf53e036">creat</a> (const char *path, mode_t mode)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p767412295084823"><a name="p767412295084823"></a><a name="p767412295084823"></a>int </p>
<p id="p245834595084823"><a name="p245834595084823"></a><a name="p245834595084823"></a>Creates a file or rewrites an existing file. </p>
</td>
</tr>
<tr id="row1294901598084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1572491857084823"><a name="p1572491857084823"></a><a name="p1572491857084823"></a><a href="fs.md#ga219205a58e244a5acd35b767ac50ef9c">open</a> (const char *path, int oflags,...)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p85058969084823"><a name="p85058969084823"></a><a name="p85058969084823"></a>int </p>
<p id="p1530788387084823"><a name="p1530788387084823"></a><a name="p1530788387084823"></a>Opens a file. </p>
</td>
</tr>
<tr id="row1952576997084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2004984476084823"><a name="p2004984476084823"></a><a name="p2004984476084823"></a><a href="fs.md#ga26ba05fc43886db02fe169b35e04bfdf">fallocate</a> (int fd, int mode, off_t offset, off_t len)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1537223771084823"><a name="p1537223771084823"></a><a name="p1537223771084823"></a>int </p>
<p id="p1724900730084823"><a name="p1724900730084823"></a><a name="p1724900730084823"></a>Pre-allocates space to a file. </p>
</td>
</tr>
<tr id="row1017194319084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2116676212084823"><a name="p2116676212084823"></a><a name="p2116676212084823"></a><a href="fs.md#gad39ebe4c4767eaa9a680777400cfaafe">fcntl</a> (int fd, int cmd,...)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2116321236084823"><a name="p2116321236084823"></a><a name="p2116321236084823"></a>int </p>
<p id="p1583761840084823"><a name="p1583761840084823"></a><a name="p1583761840084823"></a>Manipulates a specified file descriptor. </p>
</td>
</tr>
<tr id="row1678082232084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1182403375084823"><a name="p1182403375084823"></a><a name="p1182403375084823"></a><a href="fs.md#ga8dda75835c2b90f305d96e908dc0f84d">ftw</a> (const char *path, int(*fn)(const char *file, const struct <a href="stat.md">stat</a> *sb, int flag), int depth)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1189557847084823"><a name="p1189557847084823"></a><a name="p1189557847084823"></a>int </p>
<p id="p393287693084823"><a name="p393287693084823"></a><a name="p393287693084823"></a>Traverses a file tree. </p>
</td>
</tr>
<tr id="row917221936084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p415200173084823"><a name="p415200173084823"></a><a name="p415200173084823"></a><a href="fs.md#ga3fb6324259c86bfee53d3354798cfd43">nftw</a> (const char *path, int(*fn)(const char *file, const struct <a href="stat.md">stat</a> *sb, int flag, struct <a href="ftw.md">FTW</a> *s), int fd_limit, int flags)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1936173197084823"><a name="p1936173197084823"></a><a name="p1936173197084823"></a>int </p>
<p id="p973859808084823"><a name="p973859808084823"></a><a name="p973859808084823"></a>Traverses a file tree. </p>
</td>
</tr>
<tr id="row1246237539084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1317038652084823"><a name="p1317038652084823"></a><a name="p1317038652084823"></a><a href="fs.md#gae98601409da7fd3c85a9c219e1a9020c">glob</a> (const char *__restrict pattern, int flags, int(*errfunc)(const char *, int), <a href="glob_t.md">glob_t</a> *__restrict pglob)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1825035258084823"><a name="p1825035258084823"></a><a name="p1825035258084823"></a>int </p>
<p id="p1002387996084823"><a name="p1002387996084823"></a><a name="p1002387996084823"></a>Searches for path names that meet a specified pattern. </p>
</td>
</tr>
<tr id="row1247194530084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p664056392084823"><a name="p664056392084823"></a><a name="p664056392084823"></a><a href="fs.md#gaa43d417234c8572d6e98fb1dc12a4794">globfree</a> (<a href="glob_t.md">glob_t</a> *pglob)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1986606654084823"><a name="p1986606654084823"></a><a name="p1986606654084823"></a>void </p>
<p id="p96052283084823"><a name="p96052283084823"></a><a name="p96052283084823"></a>Frees allocated memory from a call to <strong id="b1831470071084823"><a name="b1831470071084823"></a><a name="b1831470071084823"></a><a href="fs.md#gae98601409da7fd3c85a9c219e1a9020c">glob()</a></strong>. </p>
</td>
</tr>
<tr id="row670258513084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1755772233084823"><a name="p1755772233084823"></a><a name="p1755772233084823"></a><a href="fs.md#gab1b6028f4625caec30c1020e737216e2">dirname</a> (char *path)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1852966514084823"><a name="p1852966514084823"></a><a name="p1852966514084823"></a>char * </p>
<p id="p1652762202084823"><a name="p1652762202084823"></a><a name="p1652762202084823"></a>Obtains a directory name in a specified path. </p>
</td>
</tr>
<tr id="row990018846084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1349112584084823"><a name="p1349112584084823"></a><a name="p1349112584084823"></a><a href="fs.md#gaa14fc3333d84f41eacc023626687aebd">basename</a> (char *path)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1960752560084823"><a name="p1960752560084823"></a><a name="p1960752560084823"></a>char * </p>
<p id="p311691685084823"><a name="p311691685084823"></a><a name="p311691685084823"></a>Obtains a file name (excluding the directory) in a specified path. </p>
</td>
</tr>
<tr id="row644862336084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1914622671084823"><a name="p1914622671084823"></a><a name="p1914622671084823"></a><a href="fs.md#ga28db05c84676b387c2d8cfdd317bb9bd">ioctl</a> (int fd, int cmd,...)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p248846168084823"><a name="p248846168084823"></a><a name="p248846168084823"></a>int </p>
<p id="p348840766084823"><a name="p348840766084823"></a><a name="p348840766084823"></a>Manipulates a device. </p>
</td>
</tr>
<tr id="row1313127762084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2145554678084823"><a name="p2145554678084823"></a><a name="p2145554678084823"></a><a href="fs.md#gadaaf1ec8aa37137233fa25d2b3af9fc8">mount</a> (const char *source, const char *target, const char *filesystemtype, unsigned long mountflags, const void *data)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1669224902084823"><a name="p1669224902084823"></a><a name="p1669224902084823"></a>int </p>
<p id="p2024408543084823"><a name="p2024408543084823"></a><a name="p2024408543084823"></a>Mounts a file system. </p>
</td>
</tr>
<tr id="row507550074084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p837400161084823"><a name="p837400161084823"></a><a name="p837400161084823"></a><a href="fs.md#ga44634cfa8bcc732c29bcdf5822095422">umount</a> (const char *target)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1941955556084823"><a name="p1941955556084823"></a><a name="p1941955556084823"></a>int </p>
<p id="p1227686977084823"><a name="p1227686977084823"></a><a name="p1227686977084823"></a>Unmounts a file system. </p>
</td>
</tr>
<tr id="row922507817084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2009668081084823"><a name="p2009668081084823"></a><a name="p2009668081084823"></a><a href="fs.md#ga2125a021d10f7a28a66cbc9335ad826f">umount2</a> (const char *target, int flags)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p73255784084823"><a name="p73255784084823"></a><a name="p73255784084823"></a>int </p>
<p id="p970010432084823"><a name="p970010432084823"></a><a name="p970010432084823"></a>Unmounts a file system. </p>
</td>
</tr>
<tr id="row1302348065084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1899822971084823"><a name="p1899822971084823"></a><a name="p1899822971084823"></a><a href="fs.md#gad2e0bcbe40344116102877f6268ee6ea">stat</a> (const char *__restrict path, struct <a href="stat.md">stat</a> *__restrict buf)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1927358804084823"><a name="p1927358804084823"></a><a name="p1927358804084823"></a>int </p>
<p id="p1473077205084823"><a name="p1473077205084823"></a><a name="p1473077205084823"></a>Obtains file information. </p>
</td>
</tr>
<tr id="row658778619084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2119300079084823"><a name="p2119300079084823"></a><a name="p2119300079084823"></a><a href="fs.md#ga198a57e185e8a036ad06345623b84521">fstat</a> (int fd, struct <a href="stat.md">stat</a> *buf)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p763455377084823"><a name="p763455377084823"></a><a name="p763455377084823"></a>int </p>
<p id="p1047737549084823"><a name="p1047737549084823"></a><a name="p1047737549084823"></a>Obtains file status information. </p>
</td>
</tr>
<tr id="row601844223084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1479848274084823"><a name="p1479848274084823"></a><a name="p1479848274084823"></a><a href="fs.md#ga879b7c433a19b6b07b42edcf3871c40f">lstat</a> (const char *__restrict path, struct <a href="stat.md">stat</a> *__restrict buf)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1856218640084823"><a name="p1856218640084823"></a><a name="p1856218640084823"></a>int </p>
<p id="p645390908084823"><a name="p645390908084823"></a><a name="p645390908084823"></a>Obtains file information. </p>
</td>
</tr>
<tr id="row2137591659084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2058193339084823"><a name="p2058193339084823"></a><a name="p2058193339084823"></a><a href="fs.md#gaee98bbe743c2d14dbaa67f01c3fb9ed5">mkdir</a> (const char *pathname, mode_t mode)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p231380168084823"><a name="p231380168084823"></a><a name="p231380168084823"></a>int </p>
<p id="p938926084084823"><a name="p938926084084823"></a><a name="p938926084084823"></a>Creates a directory. </p>
</td>
</tr>
<tr id="row167573311084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p651878864084823"><a name="p651878864084823"></a><a name="p651878864084823"></a><a href="fs.md#ga6b0f61de936f648da290c92ed36192c4">mkfifo</a> (const char *name, mode_t mode)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1598390346084823"><a name="p1598390346084823"></a><a name="p1598390346084823"></a>int </p>
<p id="p150885927084823"><a name="p150885927084823"></a><a name="p150885927084823"></a>Creates a named pipe to implement inter-process communication. </p>
</td>
</tr>
<tr id="row2019321307084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p617520244084823"><a name="p617520244084823"></a><a name="p617520244084823"></a><a href="fs.md#gae0b68526355956a8e3298fcb6a72e3bc">mkdirat</a> (int fd, const char *pathname, mode_t mode)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1400801394084823"><a name="p1400801394084823"></a><a name="p1400801394084823"></a>int </p>
<p id="p795355734084823"><a name="p795355734084823"></a><a name="p795355734084823"></a>Creates a directory. </p>
</td>
</tr>
<tr id="row1780648594084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1284719424084823"><a name="p1284719424084823"></a><a name="p1284719424084823"></a><a href="fs.md#ga1b893413bc424887bbe61f8d0952a0ee">chmod</a> (const char *pathname, mode_t mode)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1024325252084823"><a name="p1024325252084823"></a><a name="p1024325252084823"></a>int </p>
<p id="p27225930084823"><a name="p27225930084823"></a><a name="p27225930084823"></a>Modifies permissions for a file. </p>
</td>
</tr>
<tr id="row920417533084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p944126270084823"><a name="p944126270084823"></a><a name="p944126270084823"></a><a href="fs.md#ga556063623e479c26c64544024a046024">umask</a> (mode_t mode)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1914252951084823"><a name="p1914252951084823"></a><a name="p1914252951084823"></a>mode_t </p>
<p id="p471416936084823"><a name="p471416936084823"></a><a name="p471416936084823"></a>Sets umask for a process. </p>
</td>
</tr>
<tr id="row386074663084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1270710401084823"><a name="p1270710401084823"></a><a name="p1270710401084823"></a><a href="fs.md#gae7af18cc5fa39f42a3be1bf1eb24119d">statfs</a> (const char *path, struct statfs *buf)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1245223165084823"><a name="p1245223165084823"></a><a name="p1245223165084823"></a>int </p>
<p id="p197364518084823"><a name="p197364518084823"></a><a name="p197364518084823"></a>Obtains file system information of a file in a specified path. </p>
</td>
</tr>
<tr id="row1295072220084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2062106465084823"><a name="p2062106465084823"></a><a name="p2062106465084823"></a><a href="fs.md#ga41058769ad8ea7d7d467799f651b8b1a">statvfs</a> (const char *__restrict path, struct <a href="statvfs.md">statvfs</a> *__restrict buf)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p555321165084823"><a name="p555321165084823"></a><a name="p555321165084823"></a>int </p>
<p id="p1948326762084823"><a name="p1948326762084823"></a><a name="p1948326762084823"></a>Obtains the file system information. </p>
</td>
</tr>
<tr id="row1943625779084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1433459437084823"><a name="p1433459437084823"></a><a name="p1433459437084823"></a><a href="fs.md#ga1299674b4b1934ebf0441388d07981a6">utime</a> (const char *filename, const struct <a href="utimbuf.md">utimbuf</a> *<a href="time.md#gad8751576e987b576f4e6e42f9b42fec9">times</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p894673640084823"><a name="p894673640084823"></a><a name="p894673640084823"></a>int </p>
<p id="p684235774084823"><a name="p684235774084823"></a><a name="p684235774084823"></a>Sets the access time and modification time of a file. </p>
</td>
</tr>
</tbody>
</table>

## **Details**<a name="section2119329630084823"></a>

## **Macro Definition Documentation**<a name="section2031200459084823"></a>

## FTW\_DP<a name="ga8b34563aa640cd03e2ddf054b0b99e49"></a>

```
#define FTW_DP   6
```

 **Description:**

@briefDirectory. All subdirectories in this directory have been traversed. 

## **Function Documentation**<a name="section824285366084823"></a>

## alphasort\(\)<a name="ga8a52fd9a3ded793b8200ac0a5a1f10d2"></a>

```
int alphasort (const struct [dirent](dirent.md) ** a, const struct [dirent](dirent.md) ** b )
```

 **Description:**

Sorts the directory entries in alphabetical order. 

This function is used to sort the two directory entries passed through the input parameters in alphabetical order. Generally, these parameters are passed in  [scandir](fs.md#gaca6df630e382cf13bac90ed6e5c4141c)  as its last parameter. 

**Parameters:**

<a name="table802041970084823"></a>
<table><thead align="left"><tr id="row1414427274084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2095150411084823"><a name="p2095150411084823"></a><a name="p2095150411084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p813698618084823"><a name="p813698618084823"></a><a name="p813698618084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row255255143084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">a</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to directory entry a. </td>
</tr>
<tr id="row1898899575084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">a</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to directory entry b. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns an integer greater than, equal to, or less than  **0**, respectively, based on whether the name of the directory entry to which  **a**  points is lexically greater than, equal to, or less than the directory. 



## basename\(\)<a name="gaa14fc3333d84f41eacc023626687aebd"></a>

```
char* basename (char * path)
```

 **Description:**

Obtains a file name \(excluding the directory\) in a specified path. 

**Parameters:**

<a name="table1603425865084823"></a>
<table><thead align="left"><tr id="row1635236310084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p804857502084823"><a name="p804857502084823"></a><a name="p804857502084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1156687070084823"><a name="p1156687070084823"></a><a name="p1156687070084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1395046181084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">path</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the path. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the file name if the operation is successful; returns  **NULL**  otherwise. 



## chmod\(\)<a name="ga1b893413bc424887bbe61f8d0952a0ee"></a>

```
int chmod (const char * pathname, mode_t mode )
```

 **Description:**

Modifies permissions for a file. 

**Parameters:**

<a name="table863326076084823"></a>
<table><thead align="left"><tr id="row381958981084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1670484106084823"><a name="p1670484106084823"></a><a name="p1670484106084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p605781204084823"><a name="p605781204084823"></a><a name="p605781204084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row876549574084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">pathname</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the path of the file. </td>
</tr>
<tr id="row1686546370084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">mode</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the new file permission. </td>
</tr>
</tbody>
</table>

**Attention:**

This function can be used only in the JFFS2 file system. 

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table otherwise. 

<a name="table1346611751084823"></a>
<table><thead align="left"><tr id="row612339385084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p780811962084823"><a name="p780811962084823"></a><a name="p780811962084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1402815102084823"><a name="p1402815102084823"></a><a name="p1402815102084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1719181442084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p500878624084823"><a name="p500878624084823"></a><a name="p500878624084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p577627096084823"><a name="p577627096084823"></a><a name="p577627096084823"></a>The <strong id="b486417002084823"><a name="b486417002084823"></a><a name="b486417002084823"></a>pathname</strong> is a null pointer or an empty string. </p>
</td>
</tr>
<tr id="row1022481857084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1164715326084823"><a name="p1164715326084823"></a><a name="p1164715326084823"></a>EACCES </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p133064328084823"><a name="p133064328084823"></a><a name="p133064328084823"></a>The permission bit of the file mode does not allow the requested access, or the search permission is denied on the path prefix directory. </p>
</td>
</tr>
<tr id="row1440584400084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p158119865084823"><a name="p158119865084823"></a><a name="p158119865084823"></a>EFAULT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p66133747084823"><a name="p66133747084823"></a><a name="p66133747084823"></a>Incorrect IP address. </p>
</td>
</tr>
<tr id="row1645385029084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1334025020084823"><a name="p1334025020084823"></a><a name="p1334025020084823"></a>ENAMETOOLONG </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p120421461084823"><a name="p120421461084823"></a><a name="p120421461084823"></a>The path name length is greater than the value of <a href="utils.md#gac64541bdd81c961304b9babef1402640">NAME_MAX</a>. </p>
</td>
</tr>
<tr id="row1209549758084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1722748778084823"><a name="p1722748778084823"></a><a name="p1722748778084823"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1910911684084823"><a name="p1910911684084823"></a><a name="p1910911684084823"></a>The directory component in the path name does not exist. </p>
</td>
</tr>
<tr id="row1579825778084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1478692949084823"><a name="p1478692949084823"></a><a name="p1478692949084823"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1582428685084823"><a name="p1582428685084823"></a><a name="p1582428685084823"></a>Insufficient memory. </p>
</td>
</tr>
<tr id="row372323441084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1923589477084823"><a name="p1923589477084823"></a><a name="p1923589477084823"></a>ENOTDIR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1761427033084823"><a name="p1761427033084823"></a><a name="p1761427033084823"></a>A component of the <strong id="b837947024084823"><a name="b837947024084823"></a><a name="b837947024084823"></a>path</strong> prefix is the name of an existing file. The file is neither a directory nor a symbolic link of a directory. </p>
</td>
</tr>
<tr id="row103543658084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p895393019084823"><a name="p895393019084823"></a><a name="p895393019084823"></a>EPERM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1209012890084823"><a name="p1209012890084823"></a><a name="p1209012890084823"></a>Operation not permitted or access denied because the access is prohibited or the directory is full. </p>
</td>
</tr>
<tr id="row491885166084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1351855806084823"><a name="p1351855806084823"></a><a name="p1351855806084823"></a>EROFS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1747976733084823"><a name="p1747976733084823"></a><a name="p1747976733084823"></a>The physical drive is write-protected. </p>
</td>
</tr>
<tr id="row448411270084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1158866268084823"><a name="p1158866268084823"></a><a name="p1158866268084823"></a>EEXIST </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p175998776084823"><a name="p175998776084823"></a><a name="p175998776084823"></a>The file or directory already exists. </p>
</td>
</tr>
<tr id="row338045728084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1575669056084823"><a name="p1575669056084823"></a><a name="p1575669056084823"></a>ENOSYS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1617197063084823"><a name="p1617197063084823"></a><a name="p1617197063084823"></a>The function is not supported. </p>
</td>
</tr>
</tbody>
</table>

## closedir\(\)<a name="gaaeac2b41e8c2c3a5f91c9bd511a8c0a6"></a>

```
int closedir ([DIR](fs.md#ga0ebe68390948c14bb9d82987adbfc849) * dirp)
```

 **Description:**

Closes a specified directory. 

**Parameters:**

<a name="table496719001084823"></a>
<table><thead align="left"><tr id="row974717914084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p495559689084823"><a name="p495559689084823"></a><a name="p495559689084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1329848362084823"><a name="p1329848362084823"></a><a name="p1329848362084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1132112098084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dirp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the structure representing the directory to close. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the directory is successfully closed; returns  **-1**  and sets  **errno**  to the following value otherwise. 

<a name="table123954619084823"></a>
<table><thead align="left"><tr id="row1825048590084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p426274232084823"><a name="p426274232084823"></a><a name="p426274232084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p134758620084823"><a name="p134758620084823"></a><a name="p134758620084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1505353504084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2122958965084823"><a name="p2122958965084823"></a><a name="p2122958965084823"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1008341217084823"><a name="p1008341217084823"></a><a name="p1008341217084823"></a><strong id="b216051063084823"><a name="b216051063084823"></a><a name="b216051063084823"></a>dirp</strong> is not a valid opened directory stream. </p>
</td>
</tr>
</tbody>
</table>

## creat\(\)<a name="gafddc24a65767ae35f275be8ccf53e036"></a>

```
int creat (const char * path, mode_t mode )
```

 **Description:**

Creates a file or rewrites an existing file. 

**Parameters:**

<a name="table1242811077084823"></a>
<table><thead align="left"><tr id="row1911480996084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1861301664084823"><a name="p1861301664084823"></a><a name="p1861301664084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p278109293084823"><a name="p278109293084823"></a><a name="p278109293084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row407791245084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">path</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the name of the file to create or rewrite. </td>
</tr>
<tr id="row211724573084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">mode</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates permissions on the file. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the file is created or rewritten successfully; returns  **-1**  and sets  **errno**  to a value in the following table otherwise. 

<a name="table976591515084823"></a>
<table><thead align="left"><tr id="row560962751084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p314171571084823"><a name="p314171571084823"></a><a name="p314171571084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1055092501084823"><a name="p1055092501084823"></a><a name="p1055092501084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row32709907084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1389992904084823"><a name="p1389992904084823"></a><a name="p1389992904084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1457140269084823"><a name="p1457140269084823"></a><a name="p1457140269084823"></a><strong id="b1212413157084823"><a name="b1212413157084823"></a><a name="b1212413157084823"></a>path</strong> points to an invalid path. </p>
</td>
</tr>
<tr id="row1114992653084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1874234253084823"><a name="p1874234253084823"></a><a name="p1874234253084823"></a>ENAMETOOLONG </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p800179707084823"><a name="p800179707084823"></a><a name="p800179707084823"></a>The length of <strong id="b1851052444084823"><a name="b1851052444084823"></a><a name="b1851052444084823"></a>path</strong> is greater than the value of <a href="utils.md#gac64541bdd81c961304b9babef1402640">NAME_MAX</a>. </p>
</td>
</tr>
<tr id="row1015694689084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1941026187084823"><a name="p1941026187084823"></a><a name="p1941026187084823"></a>ENXIO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1332474927084823"><a name="p1332474927084823"></a><a name="p1332474927084823"></a>Invalid inode or the inode is not a mount point. </p>
</td>
</tr>
<tr id="row559507534084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p810436697084823"><a name="p810436697084823"></a><a name="p810436697084823"></a>EMFILE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p736625139084823"><a name="p736625139084823"></a><a name="p736625139084823"></a>All file descriptors that can be used by the process are opened. </p>
</td>
</tr>
<tr id="row2027632628084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1625439457084823"><a name="p1625439457084823"></a><a name="p1625439457084823"></a>EPERM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1695977812084823"><a name="p1695977812084823"></a><a name="p1695977812084823"></a>The file structure corresponding to the file descriptor cannot be obtained. </p>
</td>
</tr>
<tr id="row1988060417084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1271060776084823"><a name="p1271060776084823"></a><a name="p1271060776084823"></a>EACCES </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p650964123084823"><a name="p650964123084823"></a><a name="p650964123084823"></a>Access denied by the permission bit of file mode </p>
</td>
</tr>
<tr id="row917066904084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1726753709084823"><a name="p1726753709084823"></a><a name="p1726753709084823"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p946386850084823"><a name="p946386850084823"></a><a name="p946386850084823"></a>The memory is insufficient. </p>
</td>
</tr>
<tr id="row1033244507084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p854697667084823"><a name="p854697667084823"></a><a name="p854697667084823"></a>ENODEV </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1931483438084823"><a name="p1931483438084823"></a><a name="p1931483438084823"></a>The device does not exist. </p>
</td>
</tr>
<tr id="row921052476084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p990158578084823"><a name="p990158578084823"></a><a name="p990158578084823"></a>EEXIST </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p192018546084823"><a name="p192018546084823"></a><a name="p192018546084823"></a><strong id="b345838816084823"><a name="b345838816084823"></a><a name="b345838816084823"></a>O_CREAT</strong> and <strong id="b1472663547084823"><a name="b1472663547084823"></a><a name="b1472663547084823"></a>O_EXCL</strong> are set. </p>
</td>
</tr>
<tr id="row450753833084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1475795611084823"><a name="p1475795611084823"></a><a name="p1475795611084823"></a>EIO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p713907137084823"><a name="p713907137084823"></a><a name="p713907137084823"></a>A hardware error occurs at the low-level disk I/O layer. As a result, the physical drive cannot work. </p>
</td>
</tr>
<tr id="row1545212167084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1888864182084823"><a name="p1888864182084823"></a><a name="p1888864182084823"></a>ENFILE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1107559779084823"><a name="p1107559779084823"></a><a name="p1107559779084823"></a>The number of opened files in the system has reached the maximum. </p>
</td>
</tr>
<tr id="row1321191278084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p122272539084823"><a name="p122272539084823"></a><a name="p122272539084823"></a>ENOTDIR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2088349285084823"><a name="p2088349285084823"></a><a name="p2088349285084823"></a>A component of the path prefix is the name of an existing file and is not a directory. </p>
</td>
</tr>
<tr id="row257661336084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p380576155084823"><a name="p380576155084823"></a><a name="p380576155084823"></a>EBUSY </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1663810389084823"><a name="p1663810389084823"></a><a name="p1663810389084823"></a>The operation is rejected according to the file sharing policy. </p>
</td>
</tr>
<tr id="row339382135084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1197302730084823"><a name="p1197302730084823"></a><a name="p1197302730084823"></a>ENOTEMPTY </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1500048542084823"><a name="p1500048542084823"></a><a name="p1500048542084823"></a>The directory is not empty. </p>
</td>
</tr>
<tr id="row424728991084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p538563287084823"><a name="p538563287084823"></a><a name="p538563287084823"></a>ELOOP </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p380227702084823"><a name="p380227702084823"></a><a name="p380227702084823"></a>Too many symbolic links are encountered. </p>
</td>
</tr>
<tr id="row2093208506084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p574606843084823"><a name="p574606843084823"></a><a name="p574606843084823"></a>EFAULT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1867779863084823"><a name="p1867779863084823"></a><a name="p1867779863084823"></a>The IP address is incorrect. </p>
</td>
</tr>
</tbody>
</table>

## dirname\(\)<a name="gab1b6028f4625caec30c1020e737216e2"></a>

```
char* dirname (char * path)
```

 **Description:**

Obtains a directory name in a specified path. 

**Parameters:**

<a name="table2014549424084823"></a>
<table><thead align="left"><tr id="row223359953084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p590246645084823"><a name="p590246645084823"></a><a name="p590246645084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1065059278084823"><a name="p1065059278084823"></a><a name="p1065059278084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1888433734084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">path</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the path. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the directory name if the operation is successful; returns  **NULL**  otherwise. 



## fallocate\(\)<a name="ga26ba05fc43886db02fe169b35e04bfdf"></a>

```
int fallocate (int fd, int mode, off_t offset, off_t len )
```

 **Description:**

Pre-allocates space to a file. 

**Parameters:**

<a name="table1242669655084823"></a>
<table><thead align="left"><tr id="row219989480084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1651174037084823"><a name="p1651174037084823"></a><a name="p1651174037084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p586692940084823"><a name="p586692940084823"></a><a name="p586692940084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row958579428084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the file descriptor. </td>
</tr>
<tr id="row1971278733084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">mode</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the operation mode. Only <strong id="b202999801084823"><a name="b202999801084823"></a><a name="b202999801084823"></a>FALLOC_FL_KEEP_SIZE</strong> is supported. </td>
</tr>
<tr id="row1051110294084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">offset</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the offset of the file to allocate. </td>
</tr>
<tr id="row1391841247084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">len</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of the disk space to be allocated to the file. </td>
</tr>
</tbody>
</table>

**Attention:**

This function can be used only in the FAT file system. 

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table otherwise. 

<a name="table1602245746084823"></a>
<table><thead align="left"><tr id="row602743301084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p240262541084823"><a name="p240262541084823"></a><a name="p240262541084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p433085159084823"><a name="p433085159084823"></a><a name="p433085159084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1919682208084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1779575753084823"><a name="p1779575753084823"></a><a name="p1779575753084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p811706524084823"><a name="p811706524084823"></a><a name="p811706524084823"></a>The value of <strong id="b1560426773084823"><a name="b1560426773084823"></a><a name="b1560426773084823"></a>len</strong> or <strong id="b1104685039084823"><a name="b1104685039084823"></a><a name="b1104685039084823"></a>offset</strong> is less than 0 or greater than that of <a href="utils.md#ga9ec306f36d50c7375e74f0d1c55a3a67">INT_MAX</a>, or the value of <strong id="b590375630084823"><a name="b590375630084823"></a><a name="b590375630084823"></a>mode</strong> is not <strong id="b394693258084823"><a name="b394693258084823"></a><a name="b394693258084823"></a>FALLOC_FL_KEEP_SIZE</strong>. </p>
</td>
</tr>
<tr id="row1471453529084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1150350429084823"><a name="p1150350429084823"></a><a name="p1150350429084823"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1243763497084823"><a name="p1243763497084823"></a><a name="p1243763497084823"></a><strong id="b156460076084823"><a name="b156460076084823"></a><a name="b156460076084823"></a>fd</strong> is not a valid file descriptor, or the basic file system does not support this operation. </p>
</td>
</tr>
<tr id="row1270794364084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p817073436084823"><a name="p817073436084823"></a><a name="p817073436084823"></a>EAGAIN </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1498177437084823"><a name="p1498177437084823"></a><a name="p1498177437084823"></a>The file list is null. </p>
</td>
</tr>
<tr id="row119646642084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1974074520084823"><a name="p1974074520084823"></a><a name="p1974074520084823"></a>EACCES </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p211854017084823"><a name="p211854017084823"></a><a name="p211854017084823"></a>Access denied by the authority bit of file mode </p>
</td>
</tr>
<tr id="row436196876084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p121987424084823"><a name="p121987424084823"></a><a name="p121987424084823"></a>EIO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p904187636084823"><a name="p904187636084823"></a><a name="p904187636084823"></a>An I/O error occurs when data is read from or written to the file system. </p>
</td>
</tr>
<tr id="row2041758521084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p718064407084823"><a name="p718064407084823"></a><a name="p718064407084823"></a>EROFS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p864268503084823"><a name="p864268503084823"></a><a name="p864268503084823"></a>The physical drive is write-protected. </p>
</td>
</tr>
<tr id="row152989853084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p461073855084823"><a name="p461073855084823"></a><a name="p461073855084823"></a>EPERM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1924874223084823"><a name="p1924874223084823"></a><a name="p1924874223084823"></a>The operation is not allowed or the access is rejected. </p>
</td>
</tr>
<tr id="row1469161255084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1664540543084823"><a name="p1664540543084823"></a><a name="p1664540543084823"></a>EBUSY </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1641160246084823"><a name="p1641160246084823"></a><a name="p1641160246084823"></a>The operation is rejected according to the file sharing policy. </p>
</td>
</tr>
</tbody>
</table>

## fcntl\(\)<a name="gad39ebe4c4767eaa9a680777400cfaafe"></a>

```
int fcntl (int fd, int cmd,  ... )
```

 **Description:**

Manipulates a specified file descriptor. 

**Parameters:**

<a name="table285035750084823"></a>
<table><thead align="left"><tr id="row72423899084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p413391982084823"><a name="p413391982084823"></a><a name="p413391982084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p701131120084823"><a name="p701131120084823"></a><a name="p701131120084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row964333337084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the file descriptor. </td>
</tr>
<tr id="row1107738288084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">cmd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the command used to manipulate the file descriptor. </td>
</tr>
</tbody>
</table>

<a name="table255859078084823"></a>
<table><thead align="left"><tr id="row1885474933084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p844680572084823"><a name="p844680572084823"></a><a name="p844680572084823"></a>cmd </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p30475636084823"><a name="p30475636084823"></a><a name="p30475636084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row535291031084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1402963860084823"><a name="p1402963860084823"></a><a name="p1402963860084823"></a>F_DUPFD </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1895821870084823"><a name="p1895821870084823"></a><a name="p1895821870084823"></a>Copy a new file descriptor (<strong id="b1318913103084823"><a name="b1318913103084823"></a><a name="b1318913103084823"></a>fd</strong> is a file). </p>
</td>
</tr>
<tr id="row673387906084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1616657725084823"><a name="p1616657725084823"></a><a name="p1616657725084823"></a>F_GETFL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1713195357084823"><a name="p1713195357084823"></a><a name="p1713195357084823"></a>Obtain the status of the file specified by <strong id="b31108497084823"><a name="b31108497084823"></a><a name="b31108497084823"></a>fd</strong>. (<strong id="b158816155084823"><a name="b158816155084823"></a><a name="b158816155084823"></a>fd</strong> is a file or sockets are available.) </p>
</td>
</tr>
<tr id="row243336396084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1312237179084823"><a name="p1312237179084823"></a><a name="p1312237179084823"></a>F_SETFL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1438052618084823"><a name="p1438052618084823"></a><a name="p1438052618084823"></a>Set the file descriptor status. (<strong id="b141372724084823"><a name="b141372724084823"></a><a name="b141372724084823"></a>fd</strong> is a file or sockets are available.) </p>
</td>
</tr>
</tbody>
</table>

**Returns:**

Returns the value depending on  **cmd**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table otherwise. 

<a name="table1226163382084823"></a>
<table><thead align="left"><tr id="row2118251553084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1922673420084823"><a name="p1922673420084823"></a><a name="p1922673420084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p185676393084823"><a name="p185676393084823"></a><a name="p185676393084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1305139119084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p44451689084823"><a name="p44451689084823"></a><a name="p44451689084823"></a>EAGAIN </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p190924889084823"><a name="p190924889084823"></a><a name="p190924889084823"></a>The operation is prohibited. </p>
</td>
</tr>
<tr id="row2128151450084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1194458006084823"><a name="p1194458006084823"></a><a name="p1194458006084823"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1883375938084823"><a name="p1883375938084823"></a><a name="p1883375938084823"></a><strong id="b954708375084823"><a name="b954708375084823"></a><a name="b954708375084823"></a>fd</strong> is an invalid file descriptor. </p>
</td>
</tr>
<tr id="row1996117325084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p711376130084823"><a name="p711376130084823"></a><a name="p711376130084823"></a>EFAULT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1488717527084823"><a name="p1488717527084823"></a><a name="p1488717527084823"></a>Beyond the accessible address space. </p>
</td>
</tr>
<tr id="row1579268460084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2024347828084823"><a name="p2024347828084823"></a><a name="p2024347828084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p474275792084823"><a name="p474275792084823"></a><a name="p474275792084823"></a>The command specified by <strong id="b908556048084823"><a name="b908556048084823"></a><a name="b908556048084823"></a>cmd</strong> cannot be recognized. </p>
</td>
</tr>
<tr id="row1623597063084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1586903286084823"><a name="p1586903286084823"></a><a name="p1586903286084823"></a>ENOLCK </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1322815595084823"><a name="p1322815595084823"></a><a name="p1322815595084823"></a>Too many segment locks open, lock table is full, or a remote locking protocol failed. </p>
</td>
</tr>
<tr id="row1816251819084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1156556883084823"><a name="p1156556883084823"></a><a name="p1156556883084823"></a>EPERM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p172155002084823"><a name="p172155002084823"></a><a name="p172155002084823"></a>Attempt to clear the <strong id="b58394603084823"><a name="b58394603084823"></a><a name="b58394603084823"></a>O_APPEND</strong> flag on a file that has the append-only attribute set. </p>
</td>
</tr>
</tbody>
</table>

## fstat\(\)<a name="ga198a57e185e8a036ad06345623b84521"></a>

```
int fstat (int fd, struct [stat](stat.md) * buf )
```

 **Description:**

Obtains file status information. 

**Parameters:**

<a name="table412138940084823"></a>
<table><thead align="left"><tr id="row1973632749084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p290928530084823"><a name="p290928530084823"></a><a name="p290928530084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1318806354084823"><a name="p1318806354084823"></a><a name="p1318806354084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1256007160084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the file descriptor. </td>
</tr>
<tr id="row669423709084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">buf</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to a <strong id="b684374201084823"><a name="b684374201084823"></a><a name="b684374201084823"></a>stat</strong> structure into which file information is placed. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if file information is obtained successfully; returns  **-1**  and sets  **errno**  to a value in the following table otherwise. 

<a name="table69789526084823"></a>
<table><thead align="left"><tr id="row1478521117084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p847671140084823"><a name="p847671140084823"></a><a name="p847671140084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1792742283084823"><a name="p1792742283084823"></a><a name="p1792742283084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row693093735084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1294789494084823"><a name="p1294789494084823"></a><a name="p1294789494084823"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p608110140084823"><a name="p608110140084823"></a><a name="p608110140084823"></a><strong id="b241315478084823"><a name="b241315478084823"></a><a name="b241315478084823"></a>fd</strong> is an invalid file descriptor. </p>
</td>
</tr>
<tr id="row423252434084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1375873888084823"><a name="p1375873888084823"></a><a name="p1375873888084823"></a>EAGAIN </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p23361327084823"><a name="p23361327084823"></a><a name="p23361327084823"></a>The file list is null. </p>
</td>
</tr>
<tr id="row781790134084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1345607285084823"><a name="p1345607285084823"></a><a name="p1345607285084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p734298049084823"><a name="p734298049084823"></a><a name="p734298049084823"></a>Invalid parameter. </p>
</td>
</tr>
<tr id="row763137223084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p751175455084823"><a name="p751175455084823"></a><a name="p751175455084823"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p854588846084823"><a name="p854588846084823"></a><a name="p854588846084823"></a>A component of <strong id="b712966397084823"><a name="b712966397084823"></a><a name="b712966397084823"></a>path</strong> does not name an existing file or <strong id="b1985417139084823"><a name="b1985417139084823"></a><a name="b1985417139084823"></a>path</strong> is an empty string. </p>
</td>
</tr>
<tr id="row352374378084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p333081871084823"><a name="p333081871084823"></a><a name="p333081871084823"></a>ENAMETOOLONG </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p24013283084823"><a name="p24013283084823"></a><a name="p24013283084823"></a>The path name length is greater than the value of <a href="utils.md#gac64541bdd81c961304b9babef1402640">NAME_MAX</a>. </p>
</td>
</tr>
<tr id="row15972710084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2105701746084823"><a name="p2105701746084823"></a><a name="p2105701746084823"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p532177460084823"><a name="p532177460084823"></a><a name="p532177460084823"></a>Insufficient memory. </p>
</td>
</tr>
<tr id="row1705793743084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p499070438084823"><a name="p499070438084823"></a><a name="p499070438084823"></a>ENOSYS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p94601645084823"><a name="p94601645084823"></a><a name="p94601645084823"></a>The function is not supported. </p>
</td>
</tr>
<tr id="row1168482486084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p354840041084823"><a name="p354840041084823"></a><a name="p354840041084823"></a>EACCES </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p621706656084823"><a name="p621706656084823"></a><a name="p621706656084823"></a>Search permission is denied on a component of the path prefix. </p>
</td>
</tr>
<tr id="row354615825084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2021427367084823"><a name="p2021427367084823"></a><a name="p2021427367084823"></a>EIO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p414499340084823"><a name="p414499340084823"></a><a name="p414499340084823"></a>An I/O error occurs when data is read from or written to the file system. </p>
</td>
</tr>
<tr id="row850865506084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1114771905084823"><a name="p1114771905084823"></a><a name="p1114771905084823"></a>EROFS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2070523901084823"><a name="p2070523901084823"></a><a name="p2070523901084823"></a>The physical drive is write-protected. </p>
</td>
</tr>
<tr id="row168612026084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p734178005084823"><a name="p734178005084823"></a><a name="p734178005084823"></a>ENOSPC </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1593280357084823"><a name="p1593280357084823"></a><a name="p1593280357084823"></a>No available space on the device. </p>
</td>
</tr>
<tr id="row1048597056084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1118011575084823"><a name="p1118011575084823"></a><a name="p1118011575084823"></a>EISDIR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p963775001084823"><a name="p963775001084823"></a><a name="p963775001084823"></a>The named file is a directory. </p>
</td>
</tr>
<tr id="row111745512084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p11237196084823"><a name="p11237196084823"></a><a name="p11237196084823"></a>EPERM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1354709631084823"><a name="p1354709631084823"></a><a name="p1354709631084823"></a>Operation not permitted or access denied because the access is prohibited or the directory is full. </p>
</td>
</tr>
<tr id="row1101891164084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p769253055084823"><a name="p769253055084823"></a><a name="p769253055084823"></a>EBUSY </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1173536252084823"><a name="p1173536252084823"></a><a name="p1173536252084823"></a>The operation is rejected according to the file sharing policy. </p>
</td>
</tr>
<tr id="row1358487932084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1279133425084823"><a name="p1279133425084823"></a><a name="p1279133425084823"></a>EPROTO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p369734448084823"><a name="p369734448084823"></a><a name="p369734448084823"></a>The protocol in NFS is incorrect. </p>
</td>
</tr>
<tr id="row476193000084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1094175272084823"><a name="p1094175272084823"></a><a name="p1094175272084823"></a>ENODEV </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2127228381084823"><a name="p2127228381084823"></a><a name="p2127228381084823"></a>No such device. </p>
</td>
</tr>
<tr id="row804200566084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1709001169084823"><a name="p1709001169084823"></a><a name="p1709001169084823"></a>EFAULT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1640959673084823"><a name="p1640959673084823"></a><a name="p1640959673084823"></a>Incorrect IP address. </p>
</td>
</tr>
</tbody>
</table>

## ftw\(\)<a name="ga8dda75835c2b90f305d96e908dc0f84d"></a>

```
int ftw (const char * path, int(*)(const char *file, const struct [stat](stat.md) *sb, int flag) fn, int depth )
```

 **Description:**

Traverses a file tree. 

This function is used to traverse a file tree for search. 

**Parameters:**

<a name="table266882410084823"></a>
<table><thead align="left"><tr id="row1389857915084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1079159538084823"><a name="p1079159538084823"></a><a name="p1079159538084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1742675765084823"><a name="p1742675765084823"></a><a name="p1742675765084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row186106830084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">path</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file directory to traverse. </td>
</tr>
<tr id="row1040708044084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fn</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the function to be called for the found entry. For the <strong id="b1732282499084823"><a name="b1732282499084823"></a><a name="b1732282499084823"></a>fn</strong> function, <strong id="b1916808162084823"><a name="b1916808162084823"></a><a name="b1916808162084823"></a>file</strong> identifies the path of the file relative to <strong id="b187589792084823"><a name="b187589792084823"></a><a name="b187589792084823"></a>path</strong>, and <strong id="b1630308508084823"><a name="b1630308508084823"></a><a name="b1630308508084823"></a>sb</strong> indicates the pointer to the <a href="stat.md">stat</a> structure. <strong id="b1875192447084823"><a name="b1875192447084823"></a><a name="b1875192447084823"></a>flag</strong> indicates the flag. The values of <strong id="b917883867084823"><a name="b917883867084823"></a><a name="b917883867084823"></a>flag</strong> are as follows: </td>
</tr>
<tr id="row2099116297084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">depth</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of files that can be opened during traversal. </td>
</tr>
</tbody>
</table>

<a name="table1220639558084823"></a>
<table><thead align="left"><tr id="row230557278084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p102376701084823"><a name="p102376701084823"></a><a name="p102376701084823"></a>value </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1377693579084823"><a name="p1377693579084823"></a><a name="p1377693579084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1944597148084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1943666494084823"><a name="p1943666494084823"></a><a name="p1943666494084823"></a>FTW_F </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1500160037084823"><a name="p1500160037084823"></a><a name="p1500160037084823"></a>Regular file </p>
</td>
</tr>
<tr id="row484962554084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p778577034084823"><a name="p778577034084823"></a><a name="p778577034084823"></a>FTW_D </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p15014165084823"><a name="p15014165084823"></a><a name="p15014165084823"></a>Directory </p>
</td>
</tr>
<tr id="row1710438679084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2126576541084823"><a name="p2126576541084823"></a><a name="p2126576541084823"></a>FTW_DNR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p558354081084823"><a name="p558354081084823"></a><a name="p558354081084823"></a>Unreadable directory. Its subdirectories will not be traversed. </p>
</td>
</tr>
<tr id="row1170818260084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p108878885084823"><a name="p108878885084823"></a><a name="p108878885084823"></a>FTW_SL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1540276703084823"><a name="p1540276703084823"></a><a name="p1540276703084823"></a>Symbolic link </p>
</td>
</tr>
<tr id="row920546875084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p363694008084823"><a name="p363694008084823"></a><a name="p363694008084823"></a>FTW_NS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p756642895084823"><a name="p756642895084823"></a><a name="p756642895084823"></a>The data of the <strong id="b315096027084823"><a name="b315096027084823"></a><a name="b315096027084823"></a>stat</strong> structure cannot be obtained. The possible cause is that the permission is incorrect. </p>
</td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the tree is traversed; returns the value that is returned by the  **fn\(\)**  function if the traversal is interrupted; returns  **-1**  if an error occurs. 



## glob\(\)<a name="gae98601409da7fd3c85a9c219e1a9020c"></a>

```
int glob (const char *__restrict pattern, int flags, int(*)(const char *, int) errfunc, [glob_t](glob_t.md) *__restrict pglob )
```

 **Description:**

Searches for path names that meet a specified pattern. 

**Parameters:**

<a name="table938405416084823"></a>
<table><thead align="left"><tr id="row1403246357084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1306433265084823"><a name="p1306433265084823"></a><a name="p1306433265084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2031645603084823"><a name="p2031645603084823"></a><a name="p2031645603084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1050396316084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">pattern</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pattern you want to match. </td>
</tr>
<tr id="row584460123084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">flags</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the matching mode. </td>
</tr>
<tr id="row358182706084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">errfunc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the error processing callback function. If <strong id="b2129932512084823"><a name="b2129932512084823"></a><a name="b2129932512084823"></a>errfunc</strong> is not a null pointer, <strong id="b1163207873084823"><a name="b1163207873084823"></a><a name="b1163207873084823"></a>errfunc()</strong> is called when an error occurs (<a href="fs.md#gad09dd96447776d2bc5d8321e4b499591">opendir()</a>, <a href="fs.md#ga58257faf8b13b3f14558613c632b2373">readdir()</a>, or <a href="fs.md#gad2e0bcbe40344116102877f6268ee6ea">stat()</a> fails) during the search. If the function returns a non-zero value or <a href="fs.md#ga9e77b0b20a1c1d66cdf924a07776f360">GLOB_ERR</a> is set, <strong id="b525067155084823"><a name="b525067155084823"></a><a name="b525067155084823"></a><a href="fs.md#gae98601409da7fd3c85a9c219e1a9020c">glob()</a></strong> terminates the entire search process. </td>
</tr>
<tr id="row1736476287084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">pglob</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the address storing the matched path names. </td>
</tr>
</tbody>
</table>

<a name="table505141687084823"></a>
<table><thead align="left"><tr id="row1736131895084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p906422691084823"><a name="p906422691084823"></a><a name="p906422691084823"></a>flags </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1834668738084823"><a name="p1834668738084823"></a><a name="p1834668738084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row748393999084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2017102823084823"><a name="p2017102823084823"></a><a name="p2017102823084823"></a>GLOB_ERR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1412710817084823"><a name="p1412710817084823"></a><a name="p1412710817084823"></a><a href="fs.md#ga9e77b0b20a1c1d66cdf924a07776f360">GLOB_ERR</a> </p>
</td>
</tr>
<tr id="row549391754084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1014942609084823"><a name="p1014942609084823"></a><a name="p1014942609084823"></a>GLOB_MARK </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1776233306084823"><a name="p1776233306084823"></a><a name="p1776233306084823"></a><a href="fs.md#gac6ec2b6ae844d895de9685a689dd27f0">GLOB_MARK</a> </p>
</td>
</tr>
<tr id="row926050663084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p962136765084823"><a name="p962136765084823"></a><a name="p962136765084823"></a>GLOB_NOSORT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p628373685084823"><a name="p628373685084823"></a><a name="p628373685084823"></a><a href="fs.md#ga4eba6cedebdfe13f924d9b4a489bfe83">GLOB_NOSORT</a> </p>
</td>
</tr>
<tr id="row491495984084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p758671813084823"><a name="p758671813084823"></a><a name="p758671813084823"></a>GLOB_DOOFFS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1441667094084823"><a name="p1441667094084823"></a><a name="p1441667094084823"></a><a href="fs.md#ga8ae13e97ae5da0993fe526c406337c62">GLOB_DOOFFS</a> </p>
</td>
</tr>
<tr id="row234124821084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p987004468084823"><a name="p987004468084823"></a><a name="p987004468084823"></a>GLOB_NOCHECK </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1262240637084823"><a name="p1262240637084823"></a><a name="p1262240637084823"></a><a href="fs.md#gaf183b2f40936442579be8d62b87e6fc6">GLOB_NOCHECK</a> </p>
</td>
</tr>
<tr id="row27617797084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2054371410084823"><a name="p2054371410084823"></a><a name="p2054371410084823"></a>GLOB_APPEND </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p461925793084823"><a name="p461925793084823"></a><a name="p461925793084823"></a><a href="fs.md#ga7e586df07bb159e904a61d8470f1fda2">GLOB_APPEND</a> </p>
</td>
</tr>
<tr id="row2010686650084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p560767019084823"><a name="p560767019084823"></a><a name="p560767019084823"></a>GLOB_NOESCAPE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1324715888084823"><a name="p1324715888084823"></a><a name="p1324715888084823"></a><a href="fs.md#gad21c37825788f86d5fefea803276f746">GLOB_NOESCAPE</a> </p>
</td>
</tr>
<tr id="row651744860084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1272369108084823"><a name="p1272369108084823"></a><a name="p1272369108084823"></a>GLOB_PERIOD </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p773151584084823"><a name="p773151584084823"></a><a name="p773151584084823"></a><a href="fs.md#gab548aece9c1254c6c08475ce8c6274a2">GLOB_PERIOD</a> </p>
</td>
</tr>
<tr id="row1702672875084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1656997824084823"><a name="p1656997824084823"></a><a name="p1656997824084823"></a>GLOB_TILDE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p469460962084823"><a name="p469460962084823"></a><a name="p469460962084823"></a><a href="fs.md#ga4f1c6c0dae8dfefcf3032fed1b5cd0fe">GLOB_TILDE</a> </p>
</td>
</tr>
<tr id="row1031127921084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p532354802084823"><a name="p532354802084823"></a><a name="p532354802084823"></a>GLOB_TILDE_CHECK </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2716386084823"><a name="p2716386084823"></a><a name="p2716386084823"></a><a href="fs.md#gacf779f5283225f7a1507122f75418103">GLOB_TILDE_CHECK</a> </p>
</td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  on successful completion; returns  [GLOB\_NOSPACE](fs.md#gab53de39e075e6fb9a11678341772930b)  for running out of memory; returns  [GLOB\_ABORTED](fs.md#gab5de50cedafa21283878657d05fb2ba8)  for a read error; returns  [GLOB\_NOMATCH](fs.md#gaed760cf90fd4398067cdb679ebe60312)  for no match found. 



## globfree\(\)<a name="gaa43d417234c8572d6e98fb1dc12a4794"></a>

```
void globfree ([glob_t](glob_t.md) * pglob)
```

 **Description:**

Frees allocated memory from a call to  **[glob\(\)](fs.md#gae98601409da7fd3c85a9c219e1a9020c)**. 

**Parameters:**

<a name="table1203559007084823"></a>
<table><thead align="left"><tr id="row1763035248084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2125768799084823"><a name="p2125768799084823"></a><a name="p2125768799084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1434652224084823"><a name="p1434652224084823"></a><a name="p1434652224084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1093978853084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">pglob</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the address of memory dynamically allocated for a <a href="fs.md#gae98601409da7fd3c85a9c219e1a9020c">glob</a> call. </td>
</tr>
</tbody>
</table>

## ioctl\(\)<a name="ga28db05c84676b387c2d8cfdd317bb9bd"></a>

```
int ioctl (int fd, int cmd,  ... )
```

 **Description:**

Manipulates a device. 

This function is used to perform specified operations on an input device file descriptor. 

**Parameters:**

<a name="table243204361084823"></a>
<table><thead align="left"><tr id="row866011170084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p267633246084823"><a name="p267633246084823"></a><a name="p267633246084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1482466275084823"><a name="p1482466275084823"></a><a name="p1482466275084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2094726216084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the file descriptor of the device (file-related file descriptors are not supported). </td>
</tr>
<tr id="row577527614084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">cmd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the operation instruction for the device. You can define it based on the specific device. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table otherwise. 

<a name="table742428116084823"></a>
<table><thead align="left"><tr id="row274128080084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1187673180084823"><a name="p1187673180084823"></a><a name="p1187673180084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1592864277084823"><a name="p1592864277084823"></a><a name="p1592864277084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1516963028084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p542383215084823"><a name="p542383215084823"></a><a name="p542383215084823"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p53438722084823"><a name="p53438722084823"></a><a name="p53438722084823"></a><strong id="b51952236084823"><a name="b51952236084823"></a><a name="b51952236084823"></a>fd</strong> is an invalid file descriptor. </p>
</td>
</tr>
<tr id="row102421003084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p850119083084823"><a name="p850119083084823"></a><a name="p850119083084823"></a>EFAULT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1279996378084823"><a name="p1279996378084823"></a><a name="p1279996378084823"></a>An inaccessible memory area is referenced. </p>
</td>
</tr>
<tr id="row1517872256084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p900544547084823"><a name="p900544547084823"></a><a name="p900544547084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1242146179084823"><a name="p1242146179084823"></a><a name="p1242146179084823"></a>The command request is invalid. </p>
</td>
</tr>
<tr id="row1634468669084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p18274531084823"><a name="p18274531084823"></a><a name="p18274531084823"></a>ENOTTY </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2098478483084823"><a name="p2098478483084823"></a><a name="p2098478483084823"></a><strong id="b1248994066084823"><a name="b1248994066084823"></a><a name="b1248994066084823"></a>fd</strong> is not associated with a character special device. </p>
</td>
</tr>
</tbody>
</table>

## lstat\(\)<a name="ga879b7c433a19b6b07b42edcf3871c40f"></a>

```
int lstat (const char *__restrict path, struct [stat](stat.md) *__restrict buf )
```

 **Description:**

Obtains file information. 

**Parameters:**

<a name="table268396126084823"></a>
<table><thead align="left"><tr id="row1120516343084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p780341929084823"><a name="p780341929084823"></a><a name="p780341929084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p648163724084823"><a name="p648163724084823"></a><a name="p648163724084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row386641989084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">path</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the file path. </td>
</tr>
<tr id="row615713547084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">buf</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to a <strong id="b1221489255084823"><a name="b1221489255084823"></a><a name="b1221489255084823"></a>stat</strong> structure into which file information is placed. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if file information is obtained successfully; returns  **-1**  and sets  **errno**  to a value in the following table otherwise. 

<a name="table279889149084823"></a>
<table><thead align="left"><tr id="row374631793084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p746726365084823"><a name="p746726365084823"></a><a name="p746726365084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p325467013084823"><a name="p325467013084823"></a><a name="p325467013084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1307328300084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2060563584084823"><a name="p2060563584084823"></a><a name="p2060563584084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1893687719084823"><a name="p1893687719084823"></a><a name="p1893687719084823"></a>Invalid parameter. </p>
</td>
</tr>
<tr id="row474529181084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1788847947084823"><a name="p1788847947084823"></a><a name="p1788847947084823"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p154377564084823"><a name="p154377564084823"></a><a name="p154377564084823"></a>A component of <strong id="b2035416941084823"><a name="b2035416941084823"></a><a name="b2035416941084823"></a>path</strong> does not name an existing file or <strong id="b758081406084823"><a name="b758081406084823"></a><a name="b758081406084823"></a>path</strong> is an empty string. </p>
</td>
</tr>
<tr id="row726069944084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1020241647084823"><a name="p1020241647084823"></a><a name="p1020241647084823"></a>ENAMETOOLONG </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1660516525084823"><a name="p1660516525084823"></a><a name="p1660516525084823"></a>The path name length is greater than the value of <a href="utils.md#gac64541bdd81c961304b9babef1402640">NAME_MAX</a>. </p>
</td>
</tr>
<tr id="row1210245304084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p59915978084823"><a name="p59915978084823"></a><a name="p59915978084823"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p338773589084823"><a name="p338773589084823"></a><a name="p338773589084823"></a>Insufficient memory. </p>
</td>
</tr>
<tr id="row152145327084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p121923555084823"><a name="p121923555084823"></a><a name="p121923555084823"></a>ENOSYS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1802678029084823"><a name="p1802678029084823"></a><a name="p1802678029084823"></a>The function is not supported. </p>
</td>
</tr>
<tr id="row286501605084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2014866954084823"><a name="p2014866954084823"></a><a name="p2014866954084823"></a>EAGAIN </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p897539344084823"><a name="p897539344084823"></a><a name="p897539344084823"></a>The file list is null. </p>
</td>
</tr>
<tr id="row1367274515084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p195014866084823"><a name="p195014866084823"></a><a name="p195014866084823"></a>EACCES </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p954276610084823"><a name="p954276610084823"></a><a name="p954276610084823"></a>The permission bit of the file mode does not allow the requested access, or the search permission is denied on the path prefix component. </p>
</td>
</tr>
<tr id="row645161614084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p501901161084823"><a name="p501901161084823"></a><a name="p501901161084823"></a>EEXIST </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p281261857084823"><a name="p281261857084823"></a><a name="p281261857084823"></a>The file or directory already exists. </p>
</td>
</tr>
<tr id="row1479401377084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2102830351084823"><a name="p2102830351084823"></a><a name="p2102830351084823"></a>EIO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p212143104084823"><a name="p212143104084823"></a><a name="p212143104084823"></a>An I/O error occurs when data is read from or written to the file system. </p>
</td>
</tr>
<tr id="row1831136891084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1726492961084823"><a name="p1726492961084823"></a><a name="p1726492961084823"></a>EROFS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2018128070084823"><a name="p2018128070084823"></a><a name="p2018128070084823"></a>The physical drive is write-protected. </p>
</td>
</tr>
<tr id="row1727320048084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1465959831084823"><a name="p1465959831084823"></a><a name="p1465959831084823"></a>ENOSPC </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2101530970084823"><a name="p2101530970084823"></a><a name="p2101530970084823"></a>No available space on the device. </p>
</td>
</tr>
<tr id="row851226074084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1499955020084823"><a name="p1499955020084823"></a><a name="p1499955020084823"></a>ENFILE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1246185223084823"><a name="p1246185223084823"></a><a name="p1246185223084823"></a>The number of opened files in the system has reached the maximum. </p>
</td>
</tr>
<tr id="row1037888664084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p574599293084823"><a name="p574599293084823"></a><a name="p574599293084823"></a>ENOTEMPTY </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1105075987084823"><a name="p1105075987084823"></a><a name="p1105075987084823"></a>The directory is not empty. </p>
</td>
</tr>
<tr id="row414349760084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1643079239084823"><a name="p1643079239084823"></a><a name="p1643079239084823"></a>EISDIR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p231500762084823"><a name="p231500762084823"></a><a name="p231500762084823"></a>The named file is a directory. </p>
</td>
</tr>
<tr id="row1574781763084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1250848774084823"><a name="p1250848774084823"></a><a name="p1250848774084823"></a>ENOTDIR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p64815630084823"><a name="p64815630084823"></a><a name="p64815630084823"></a>A component of the <strong id="b207252826084823"><a name="b207252826084823"></a><a name="b207252826084823"></a>path</strong> prefix is the name of an existing file. The file is neither a directory nor a symbolic link of a directory. </p>
</td>
</tr>
<tr id="row177138078084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p72879097084823"><a name="p72879097084823"></a><a name="p72879097084823"></a>EPERM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p675419361084823"><a name="p675419361084823"></a><a name="p675419361084823"></a>Operation not permitted or access denied because the access is prohibited or the directory is full. </p>
</td>
</tr>
<tr id="row986878146084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1471633769084823"><a name="p1471633769084823"></a><a name="p1471633769084823"></a>EBUSY </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p557548672084823"><a name="p557548672084823"></a><a name="p557548672084823"></a>The operation is rejected according to the file sharing policy. </p>
</td>
</tr>
<tr id="row741883890084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1230875401084823"><a name="p1230875401084823"></a><a name="p1230875401084823"></a>EPROTO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1928264572084823"><a name="p1928264572084823"></a><a name="p1928264572084823"></a>The protocol in NFS is incorrect. </p>
</td>
</tr>
<tr id="row328673113084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1836812441084823"><a name="p1836812441084823"></a><a name="p1836812441084823"></a>ENODEV </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1554140980084823"><a name="p1554140980084823"></a><a name="p1554140980084823"></a>No such device. </p>
</td>
</tr>
<tr id="row171106501084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p863545296084823"><a name="p863545296084823"></a><a name="p863545296084823"></a>EFAULT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p859012615084823"><a name="p859012615084823"></a><a name="p859012615084823"></a>Incorrect IP address. </p>
</td>
</tr>
</tbody>
</table>

## mkdir\(\)<a name="gaee98bbe743c2d14dbaa67f01c3fb9ed5"></a>

```
int mkdir (const char * pathname, mode_t mode )
```

 **Description:**

Creates a directory. 

**Parameters:**

<a name="table1224780329084823"></a>
<table><thead align="left"><tr id="row1709671534084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1937732363084823"><a name="p1937732363084823"></a><a name="p1937732363084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1453416278084823"><a name="p1453416278084823"></a><a name="p1453416278084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1852121247084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">pathname</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the name of the directory to create. </td>
</tr>
<tr id="row736366434084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">mode</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the directory permission. </td>
</tr>
</tbody>
</table>

**Attention:**

This function can NOT be used in the PROC file system. 

**Returns:**

Returns  **0**  if the directory is created successfully; returns  **-1**  and sets  **errno**  to a value in the following table otherwise. 

<a name="table369918059084823"></a>
<table><thead align="left"><tr id="row929685319084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1119105046084823"><a name="p1119105046084823"></a><a name="p1119105046084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p675161962084823"><a name="p675161962084823"></a><a name="p675161962084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1632467429084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1070071926084823"><a name="p1070071926084823"></a><a name="p1070071926084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1953209594084823"><a name="p1953209594084823"></a><a name="p1953209594084823"></a>The <strong id="b578293885084823"><a name="b578293885084823"></a><a name="b578293885084823"></a>pathname</strong> is a null pointer or an empty string. </p>
</td>
</tr>
<tr id="row453677966084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2146614881084823"><a name="p2146614881084823"></a><a name="p2146614881084823"></a>EACCES </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1565483638084823"><a name="p1565483638084823"></a><a name="p1565483638084823"></a>The permission bit of the file mode does not allow the requested access, or the search permission is denied on the path prefix directory. </p>
</td>
</tr>
<tr id="row450397352084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p366984478084823"><a name="p366984478084823"></a><a name="p366984478084823"></a>ENAMETOOLONG </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1084786960084823"><a name="p1084786960084823"></a><a name="p1084786960084823"></a>The path name length is greater than the value of <a href="utils.md#gac64541bdd81c961304b9babef1402640">NAME_MAX</a>. </p>
</td>
</tr>
<tr id="row2080560028084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p323393580084823"><a name="p323393580084823"></a><a name="p323393580084823"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1405647178084823"><a name="p1405647178084823"></a><a name="p1405647178084823"></a>The directory component in the path name does not exist. </p>
</td>
</tr>
<tr id="row1446302077084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p731207392084823"><a name="p731207392084823"></a><a name="p731207392084823"></a>EEXIST </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1873920541084823"><a name="p1873920541084823"></a><a name="p1873920541084823"></a>The file or directory already exists. </p>
</td>
</tr>
<tr id="row102148670084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p54320777084823"><a name="p54320777084823"></a><a name="p54320777084823"></a>EIO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1263025370084823"><a name="p1263025370084823"></a><a name="p1263025370084823"></a>An I/O error occurs when data is read from or written to the file system. </p>
</td>
</tr>
<tr id="row742857669084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p926249907084823"><a name="p926249907084823"></a><a name="p926249907084823"></a>EROFS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p303153340084823"><a name="p303153340084823"></a><a name="p303153340084823"></a>The physical drive is write-protected. </p>
</td>
</tr>
<tr id="row2129324486084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1799117286084823"><a name="p1799117286084823"></a><a name="p1799117286084823"></a>ENOSPC </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p877108903084823"><a name="p877108903084823"></a><a name="p877108903084823"></a>No available space on the device. </p>
</td>
</tr>
<tr id="row1184637676084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2011797034084823"><a name="p2011797034084823"></a><a name="p2011797034084823"></a>EPERM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1718015866084823"><a name="p1718015866084823"></a><a name="p1718015866084823"></a>Operation not permitted or access denied because the access is prohibited or the directory is full. </p>
</td>
</tr>
<tr id="row1518687125084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1275785878084823"><a name="p1275785878084823"></a><a name="p1275785878084823"></a>EBUSY </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1849823795084823"><a name="p1849823795084823"></a><a name="p1849823795084823"></a>The operation is rejected according to the file sharing policy. </p>
</td>
</tr>
<tr id="row1555206350084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p882115118084823"><a name="p882115118084823"></a><a name="p882115118084823"></a>ENOSYS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p928141707084823"><a name="p928141707084823"></a><a name="p928141707084823"></a>The function is not supported. </p>
</td>
</tr>
<tr id="row1472171484084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p682942956084823"><a name="p682942956084823"></a><a name="p682942956084823"></a>EPROTO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1236740489084823"><a name="p1236740489084823"></a><a name="p1236740489084823"></a>The protocol in NFS is incorrect. </p>
</td>
</tr>
<tr id="row325728283084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1224698511084823"><a name="p1224698511084823"></a><a name="p1224698511084823"></a>EFAULT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1271668392084823"><a name="p1271668392084823"></a><a name="p1271668392084823"></a>Incorrect IP address. </p>
</td>
</tr>
</tbody>
</table>

## mkdirat\(\)<a name="gae0b68526355956a8e3298fcb6a72e3bc"></a>

```
int mkdirat (int fd, const char * pathname, mode_t mode )
```

 **Description:**

Creates a directory. 

**Parameters:**

<a name="table1095655770084823"></a>
<table><thead align="left"><tr id="row521488291084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p705466071084823"><a name="p705466071084823"></a><a name="p705466071084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p186341734084823"><a name="p186341734084823"></a><a name="p186341734084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row453447761084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the file descriptor of the target directory. (Currently, only <strong id="b1986911592084823"><a name="b1986911592084823"></a><a name="b1986911592084823"></a>AT_FDCWD</strong> is supported.) </td>
</tr>
<tr id="row238630594084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">pathname</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the name of the directory to create. </td>
</tr>
<tr id="row1035679260084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">mode</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the directory permission. </td>
</tr>
</tbody>
</table>

**Attention:**

This function can NOT be used in the PROC file system. 

**Returns:**

Returns  **0**  if the directory is created successfully; returns  **-1**  and sets  **errno**  to a value in the following table otherwise. 

<a name="table1300659942084823"></a>
<table><thead align="left"><tr id="row729731047084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2038655706084823"><a name="p2038655706084823"></a><a name="p2038655706084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p551912526084823"><a name="p551912526084823"></a><a name="p551912526084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row2017817754084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p561025780084823"><a name="p561025780084823"></a><a name="p561025780084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1237753653084823"><a name="p1237753653084823"></a><a name="p1237753653084823"></a>The <strong id="b485733993084823"><a name="b485733993084823"></a><a name="b485733993084823"></a>pathname</strong> is a null pointer or an empty string. </p>
</td>
</tr>
<tr id="row508871304084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p542067985084823"><a name="p542067985084823"></a><a name="p542067985084823"></a>EACCES </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2129720158084823"><a name="p2129720158084823"></a><a name="p2129720158084823"></a>The permission bit of the file mode does not allow the requested access, or the search permission is denied on the path prefix directory. </p>
</td>
</tr>
<tr id="row1783024990084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p603595649084823"><a name="p603595649084823"></a><a name="p603595649084823"></a>ENAMETOOLONG </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p592236705084823"><a name="p592236705084823"></a><a name="p592236705084823"></a>The path name length is greater than the value of <a href="utils.md#gac64541bdd81c961304b9babef1402640">NAME_MAX</a>. </p>
</td>
</tr>
<tr id="row1495156364084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p783407346084823"><a name="p783407346084823"></a><a name="p783407346084823"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p341286775084823"><a name="p341286775084823"></a><a name="p341286775084823"></a>The directory component in the path name does not exist. </p>
</td>
</tr>
<tr id="row1418749889084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1069688374084823"><a name="p1069688374084823"></a><a name="p1069688374084823"></a>EEXIST </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1937874834084823"><a name="p1937874834084823"></a><a name="p1937874834084823"></a>The file or directory already exists. </p>
</td>
</tr>
<tr id="row1513334346084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1001766295084823"><a name="p1001766295084823"></a><a name="p1001766295084823"></a>EIO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1019638712084823"><a name="p1019638712084823"></a><a name="p1019638712084823"></a>An I/O error occurs when data is read from or written to the file system. </p>
</td>
</tr>
<tr id="row645322284084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1431815939084823"><a name="p1431815939084823"></a><a name="p1431815939084823"></a>EROFS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1699581711084823"><a name="p1699581711084823"></a><a name="p1699581711084823"></a>The physical drive is write-protected. </p>
</td>
</tr>
<tr id="row2098181793084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p741595457084823"><a name="p741595457084823"></a><a name="p741595457084823"></a>ENOSPC </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p917914001084823"><a name="p917914001084823"></a><a name="p917914001084823"></a>No available space on the device. </p>
</td>
</tr>
<tr id="row1558785675084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1357004076084823"><a name="p1357004076084823"></a><a name="p1357004076084823"></a>EPERM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p483085615084823"><a name="p483085615084823"></a><a name="p483085615084823"></a>Operation not permitted or access denied because the access is prohibited or the directory is full. </p>
</td>
</tr>
<tr id="row358545316084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1239409457084823"><a name="p1239409457084823"></a><a name="p1239409457084823"></a>EBUSY </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p705537431084823"><a name="p705537431084823"></a><a name="p705537431084823"></a>The operation is rejected according to the file sharing policy. </p>
</td>
</tr>
<tr id="row1815038347084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p818866276084823"><a name="p818866276084823"></a><a name="p818866276084823"></a>ENOSYS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1662490689084823"><a name="p1662490689084823"></a><a name="p1662490689084823"></a>The function is not supported. </p>
</td>
</tr>
<tr id="row956172538084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1179624431084823"><a name="p1179624431084823"></a><a name="p1179624431084823"></a>EPROTO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1920897903084823"><a name="p1920897903084823"></a><a name="p1920897903084823"></a>The protocol in NFS is incorrect. </p>
</td>
</tr>
<tr id="row1735852133084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p214026240084823"><a name="p214026240084823"></a><a name="p214026240084823"></a>EFAULT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p783209989084823"><a name="p783209989084823"></a><a name="p783209989084823"></a>Incorrect IP address. </p>
</td>
</tr>
</tbody>
</table>

## mkfifo\(\)<a name="ga6b0f61de936f648da290c92ed36192c4"></a>

```
int mkfifo (const char * name, mode_t mode )
```

 **Description:**

Creates a named pipe to implement inter-process communication. 

**Parameters:**

<a name="table399610548084823"></a>
<table><thead align="left"><tr id="row1277754246084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1856830945084823"><a name="p1856830945084823"></a><a name="p1856830945084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p965862552084823"><a name="p965862552084823"></a><a name="p965862552084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1109662395084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">name</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the name of the pipe to create. </td>
</tr>
<tr id="row1077078314084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">mode</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Not supported. </td>
</tr>
</tbody>
</table>

**Attention:**

Permission control is not supported. The number of pipes that can be created is not limited. Pipes can be created only in the  **/dev**  directory. 

**Returns:**

Returns  **0**  if the pipe is created successfully; returns  **-1**  and sets  **errno**  to a value in the following table otherwise. 

<a name="table1762333856084823"></a>
<table><thead align="left"><tr id="row737003119084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1408565352084823"><a name="p1408565352084823"></a><a name="p1408565352084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1673978372084823"><a name="p1673978372084823"></a><a name="p1673978372084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row111685514084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p283197552084823"><a name="p283197552084823"></a><a name="p283197552084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p298116704084823"><a name="p298116704084823"></a><a name="p298116704084823"></a>Invalid input parameter (for example, empty address, file name too long or the file is not in the <strong id="b1289309610084823"><a name="b1289309610084823"></a><a name="b1289309610084823"></a>/dev</strong> directory). </p>
</td>
</tr>
<tr id="row173565132084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p583813983084823"><a name="p583813983084823"></a><a name="p583813983084823"></a>EEXIST </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p565064332084823"><a name="p565064332084823"></a><a name="p565064332084823"></a>The file already exists. </p>
</td>
</tr>
<tr id="row326242562084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1135820996084823"><a name="p1135820996084823"></a><a name="p1135820996084823"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1004094179084823"><a name="p1004094179084823"></a><a name="p1004094179084823"></a>Insufficient memory. </p>
</td>
</tr>
</tbody>
</table>

## mount\(\)<a name="gadaaf1ec8aa37137233fa25d2b3af9fc8"></a>

```
int mount (const char * source, const char * target, const char * filesystemtype, unsigned long mountflags, const void * data )
```

 **Description:**

Mounts a file system. 

Mounts a device \(referenced by a file system name\) to a specified directory. 

**Parameters:**

<a name="table947925718084823"></a>
<table><thead align="left"><tr id="row1537274123084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p192637555084823"><a name="p192637555084823"></a><a name="p192637555084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1582734970084823"><a name="p1582734970084823"></a><a name="p1582734970084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1984873167084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">source</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the device to mount. </td>
</tr>
<tr id="row143430620084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">target</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the path of the mount point. </td>
</tr>
<tr id="row118405238084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">filesystemtype</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file system type. </td>
</tr>
<tr id="row513422178084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">mountflags</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the mounting flag. </td>
</tr>
<tr id="row56049888084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">data</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the mounting data. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the mounting is successful; returns  **-1**  and sets  **errno**  to a value in the following table otherwise. 

<a name="table1021805633084823"></a>
<table><thead align="left"><tr id="row586159369084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2026239089084823"><a name="p2026239089084823"></a><a name="p2026239089084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1381581520084823"><a name="p1381581520084823"></a><a name="p1381581520084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row2002338979084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p682968287084823"><a name="p682968287084823"></a><a name="p682968287084823"></a>EACCES </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1426131231084823"><a name="p1426131231084823"></a><a name="p1426131231084823"></a>A component of the path was not searchable. </p>
</td>
</tr>
<tr id="row1242072606084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1049068191084823"><a name="p1049068191084823"></a><a name="p1049068191084823"></a>EBUSY </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p474545612084823"><a name="p474545612084823"></a><a name="p474545612084823"></a><strong id="b509151136084823"><a name="b509151136084823"></a><a name="b509151136084823"></a>source</strong> is already mounted. </p>
</td>
</tr>
<tr id="row2033527894084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1220698578084823"><a name="p1220698578084823"></a><a name="p1220698578084823"></a>EFAULT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1877078274084823"><a name="p1877078274084823"></a><a name="p1877078274084823"></a>One of the pointer parameters points outside the user address space. </p>
</td>
</tr>
<tr id="row217287509084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p987908105084823"><a name="p987908105084823"></a><a name="p987908105084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p747881236084823"><a name="p747881236084823"></a><a name="p747881236084823"></a><strong id="b68777103084823"><a name="b68777103084823"></a><a name="b68777103084823"></a>source</strong> cannot be mounted. </p>
</td>
</tr>
<tr id="row1789849384084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p496329129084823"><a name="p496329129084823"></a><a name="p496329129084823"></a>ELOOP </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p659482833084823"><a name="p659482833084823"></a><a name="p659482833084823"></a>Too many links encountered during path name resolution. </p>
</td>
</tr>
<tr id="row1870864853084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p251993430084823"><a name="p251993430084823"></a><a name="p251993430084823"></a>EMFILE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1585030402084823"><a name="p1585030402084823"></a><a name="p1585030402084823"></a>(Non-block device) Virtual device table is full. </p>
</td>
</tr>
<tr id="row965609607084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1142435933084823"><a name="p1142435933084823"></a><a name="p1142435933084823"></a>ENAMETOOLONG </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2056665972084823"><a name="p2056665972084823"></a><a name="p2056665972084823"></a>The path name length is greater than the value of <strong id="b1020356210084823"><a name="b1020356210084823"></a><a name="b1020356210084823"></a>MAXPATHLEN</strong>. </p>
</td>
</tr>
<tr id="row1446378262084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p387950314084823"><a name="p387950314084823"></a><a name="p387950314084823"></a>ENODEV </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p62740030084823"><a name="p62740030084823"></a><a name="p62740030084823"></a>No such file system type is configured in the kernel. </p>
</td>
</tr>
<tr id="row1523278426084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1560069400084823"><a name="p1560069400084823"></a><a name="p1560069400084823"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p908237171084823"><a name="p908237171084823"></a><a name="p908237171084823"></a>A path name is null or has a nonexistent component. </p>
</td>
</tr>
<tr id="row1735186194084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1812700756084823"><a name="p1812700756084823"></a><a name="p1812700756084823"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1325074303084823"><a name="p1325074303084823"></a><a name="p1325074303084823"></a>Insufficient memory. </p>
</td>
</tr>
<tr id="row430605777084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1157946926084823"><a name="p1157946926084823"></a><a name="p1157946926084823"></a>ENOTBLK </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p613508263084823"><a name="p613508263084823"></a><a name="p613508263084823"></a><strong id="b1191656373084823"><a name="b1191656373084823"></a><a name="b1191656373084823"></a>source</strong> is not a block device. </p>
</td>
</tr>
<tr id="row1773639709084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1935718338084823"><a name="p1935718338084823"></a><a name="p1935718338084823"></a>ENOTDIR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p175173149084823"><a name="p175173149084823"></a><a name="p175173149084823"></a><strong id="b2094569014084823"><a name="b2094569014084823"></a><a name="b2094569014084823"></a>target</strong> or the prefix of <strong id="b878679809084823"><a name="b878679809084823"></a><a name="b878679809084823"></a>source</strong> is not a directory. </p>
</td>
</tr>
<tr id="row1815717921084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1578515758084823"><a name="p1578515758084823"></a><a name="p1578515758084823"></a>ENGIO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p369315783084823"><a name="p369315783084823"></a><a name="p369315783084823"></a>No such device. </p>
</td>
</tr>
<tr id="row1739648175084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p448080027084823"><a name="p448080027084823"></a><a name="p448080027084823"></a>EPERM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p729426432084823"><a name="p729426432084823"></a><a name="p729426432084823"></a>No permission. </p>
</td>
</tr>
</tbody>
</table>

## nftw\(\)<a name="ga3fb6324259c86bfee53d3354798cfd43"></a>

```
int nftw (const char * path, int(*)(const char *file, const struct [stat](stat.md) *sb, int flag, struct [FTW](ftw.md) *s) fn, int fd_limit, int flags )
```

 **Description:**

Traverses a file tree. 

This function is used to traverse a file tree. It has a similar effect to  [ftw](fs.md#ga8dda75835c2b90f305d96e908dc0f84d)  except that it takes an additional parameter  **flags**. 

**Parameters:**

<a name="table1857084111084823"></a>
<table><thead align="left"><tr id="row692904797084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1064977703084823"><a name="p1064977703084823"></a><a name="p1064977703084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1553269943084823"><a name="p1553269943084823"></a><a name="p1553269943084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1032413566084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">path</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file directory to traverse. </td>
</tr>
<tr id="row651173294084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fn</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the function to be called for the found entry. For the <strong id="b82358836084823"><a name="b82358836084823"></a><a name="b82358836084823"></a>fn</strong> function, <strong id="b1909757881084823"><a name="b1909757881084823"></a><a name="b1909757881084823"></a>file</strong> identifies the path of the file relative to <strong id="b854611802084823"><a name="b854611802084823"></a><a name="b854611802084823"></a>path</strong>, and <strong id="b1021367024084823"><a name="b1021367024084823"></a><a name="b1021367024084823"></a>sb</strong> indicates the pointer to the <a href="stat.md">stat</a> structure. <strong id="b742429946084823"><a name="b742429946084823"></a><a name="b742429946084823"></a>flag</strong> indicates the flag. The values of <strong id="b913784065084823"><a name="b913784065084823"></a><a name="b913784065084823"></a>flag</strong> are as follows: The fourth argument of <strong id="b72591989084823"><a name="b72591989084823"></a><a name="b72591989084823"></a>fn()</strong> is a pointer to a <a href="ftw.md">FTW</a> structure. </td>
</tr>
<tr id="row823216327084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd_limit</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of files that can be opened during traversal. </td>
</tr>
<tr id="row195981352084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">flags</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the traversal action. It is a bitwise inclusive-OR of zero or more of the following flags: </td>
</tr>
</tbody>
</table>

<a name="table1857858157084823"></a>
<table><thead align="left"><tr id="row852071634084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2146626816084823"><a name="p2146626816084823"></a><a name="p2146626816084823"></a>value </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1494480398084823"><a name="p1494480398084823"></a><a name="p1494480398084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1147315208084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1066249231084823"><a name="p1066249231084823"></a><a name="p1066249231084823"></a>FTW_F </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p216418535084823"><a name="p216418535084823"></a><a name="p216418535084823"></a>Regular file </p>
</td>
</tr>
<tr id="row529161109084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p743253521084823"><a name="p743253521084823"></a><a name="p743253521084823"></a>FTW_D </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1902562004084823"><a name="p1902562004084823"></a><a name="p1902562004084823"></a>Directory </p>
</td>
</tr>
<tr id="row691908811084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1672495385084823"><a name="p1672495385084823"></a><a name="p1672495385084823"></a>FTW_DNR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2135790835084823"><a name="p2135790835084823"></a><a name="p2135790835084823"></a>Unreadable directory. Its subdirectories will not be traversed. </p>
</td>
</tr>
<tr id="row957593585084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p856867462084823"><a name="p856867462084823"></a><a name="p856867462084823"></a>FTW_SL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1441829311084823"><a name="p1441829311084823"></a><a name="p1441829311084823"></a>Symbolic link </p>
</td>
</tr>
<tr id="row923382453084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1090643204084823"><a name="p1090643204084823"></a><a name="p1090643204084823"></a>FTW_NS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p803758953084823"><a name="p803758953084823"></a><a name="p803758953084823"></a>The data of the <strong id="b1533272640084823"><a name="b1533272640084823"></a><a name="b1533272640084823"></a>stat</strong> structure cannot be obtained. The possible cause is that the permission is incorrect. </p>
</td>
</tr>
<tr id="row1592227314084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2004730733084823"><a name="p2004730733084823"></a><a name="p2004730733084823"></a>FTW_DP </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1613526474084823"><a name="p1613526474084823"></a><a name="p1613526474084823"></a>Directory. All subdirectories have been traversed. </p>
</td>
</tr>
<tr id="row1715805557084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1922529155084823"><a name="p1922529155084823"></a><a name="p1922529155084823"></a>FTW_SLN </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p532922072084823"><a name="p532922072084823"></a><a name="p532922072084823"></a>Symbolic link that names a non-existent file </p>
</td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the tree is traversed; returns the value that is returned by the  **fn\(\)**  function if the traversal is interrupted; returns  **-1**  if an error occurs. 



## open\(\)<a name="ga219205a58e244a5acd35b767ac50ef9c"></a>

```
int open (const char * path, int oflags,  ... )
```

 **Description:**

Opens a file. 

**Parameters:**

<a name="table1258096868084823"></a>
<table><thead align="left"><tr id="row2112588935084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1899183739084823"><a name="p1899183739084823"></a><a name="p1899183739084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p583614952084823"><a name="p583614952084823"></a><a name="p583614952084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row448827447084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">path</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the name of the file to open. </td>
</tr>
<tr id="row312156322084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">oflags</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the file access mode. Available values are as follows: </td>
</tr>
</tbody>
</table>

<a name="table1099172559084823"></a>
<table><thead align="left"><tr id="row1301520981084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1322721435084823"><a name="p1322721435084823"></a><a name="p1322721435084823"></a>oflags </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p637412247084823"><a name="p637412247084823"></a><a name="p637412247084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row243793166084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1477145243084823"><a name="p1477145243084823"></a><a name="p1477145243084823"></a>O_RDONLY </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p943005317084823"><a name="p943005317084823"></a><a name="p943005317084823"></a>Read-only </p>
</td>
</tr>
<tr id="row2009087517084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1839929605084823"><a name="p1839929605084823"></a><a name="p1839929605084823"></a>O_WRONLY </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1124816797084823"><a name="p1124816797084823"></a><a name="p1124816797084823"></a>Write-only </p>
</td>
</tr>
<tr id="row1121531817084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p786290448084823"><a name="p786290448084823"></a><a name="p786290448084823"></a>O_RDWR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p302756368084823"><a name="p302756368084823"></a><a name="p302756368084823"></a>Read and write </p>
</td>
</tr>
<tr id="row1661851217084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1846048046084823"><a name="p1846048046084823"></a><a name="p1846048046084823"></a>O_APPEND </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p41482677084823"><a name="p41482677084823"></a><a name="p41482677084823"></a>If set, the file offset will be set to the end of the file prior to each write. </p>
</td>
</tr>
<tr id="row1686721096084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1886176356084823"><a name="p1886176356084823"></a><a name="p1886176356084823"></a>O_CREAT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p129436268084823"><a name="p129436268084823"></a><a name="p129436268084823"></a>If the file does not exist, it will be created. </p>
</td>
</tr>
<tr id="row882577063084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p682722708084823"><a name="p682722708084823"></a><a name="p682722708084823"></a>O_LARGEFILE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1742181110084823"><a name="p1742181110084823"></a><a name="p1742181110084823"></a>A file exceeding 2 GB can be created. </p>
</td>
</tr>
<tr id="row397864310084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1644542639084823"><a name="p1644542639084823"></a><a name="p1644542639084823"></a>O_TRUNC </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1069210735084823"><a name="p1069210735084823"></a><a name="p1069210735084823"></a>If the file is opened successfully with <a href="fs.md#ga11b644a8526139c4cc1850dac1271ced">O_WRONLY</a> or <a href="fs.md#gabb0586253488ee61072b73557eeb873b">O_RDWR</a>, its length is truncated to 0. </p>
</td>
</tr>
<tr id="row600466440084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1536628164084823"><a name="p1536628164084823"></a><a name="p1536628164084823"></a>O_EXCL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1787832795084823"><a name="p1787832795084823"></a><a name="p1787832795084823"></a>Used together with <strong id="b1979960786084823"><a name="b1979960786084823"></a><a name="b1979960786084823"></a>O_CREAT</strong>. This function fails if the file exists. </p>
</td>
</tr>
<tr id="row473600792084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p700094003084823"><a name="p700094003084823"></a><a name="p700094003084823"></a>O_DIRECTORY </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2000821557084823"><a name="p2000821557084823"></a><a name="p2000821557084823"></a>This flag must be added for opening a directory. Otherwise, the directory fails to be opened. </p>
</td>
</tr>
</tbody>
</table>

**Attention:**

This function can NOT be used in the PROC file system to create a file. This function is used to open a file. If the file does not exist, this function creates a file and opens it. 

**Returns:**

Returns the file descriptor if the file is opened successfully; returns  **-1**  and sets  **errno**  to a value in the following table otherwise. 

<a name="table211555392084823"></a>
<table><thead align="left"><tr id="row1152500030084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2072970492084823"><a name="p2072970492084823"></a><a name="p2072970492084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p450290373084823"><a name="p450290373084823"></a><a name="p450290373084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1205173042084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p517857410084823"><a name="p517857410084823"></a><a name="p517857410084823"></a>EACCES </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1735339659084823"><a name="p1735339659084823"></a><a name="p1735339659084823"></a>Search permission is denied on a component of the path prefix. </p>
</td>
</tr>
<tr id="row925687975084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1674963478084823"><a name="p1674963478084823"></a><a name="p1674963478084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1685465954084823"><a name="p1685465954084823"></a><a name="p1685465954084823"></a>The path name format is invalid. </p>
</td>
</tr>
<tr id="row1193428286084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1650965066084823"><a name="p1650965066084823"></a><a name="p1650965066084823"></a>ENAMETOOLONG </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p714535476084823"><a name="p714535476084823"></a><a name="p714535476084823"></a>The length of <strong id="b292588275084823"><a name="b292588275084823"></a><a name="b292588275084823"></a>path</strong> is greater than the value of <a href="utils.md#gac64541bdd81c961304b9babef1402640">NAME_MAX</a>. </p>
</td>
</tr>
<tr id="row40508394084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p103481522084823"><a name="p103481522084823"></a><a name="p103481522084823"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1040949872084823"><a name="p1040949872084823"></a><a name="p1040949872084823"></a>The <strong id="b1229086028084823"><a name="b1229086028084823"></a><a name="b1229086028084823"></a>O_CREAT</strong> flag is not set and the named file does not exist. </p>
</td>
</tr>
<tr id="row1456308387084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1287836112084823"><a name="p1287836112084823"></a><a name="p1287836112084823"></a>ENXIO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1894348521084823"><a name="p1894348521084823"></a><a name="p1894348521084823"></a>Inode is invalid, not a normal character driver, or not a mount point. </p>
</td>
</tr>
<tr id="row418080330084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p964061507084823"><a name="p964061507084823"></a><a name="p964061507084823"></a>EMFILE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p833516581084823"><a name="p833516581084823"></a><a name="p833516581084823"></a>All available file descriptors of the process are opened. </p>
</td>
</tr>
<tr id="row1285728843084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1833471052084823"><a name="p1833471052084823"></a><a name="p1833471052084823"></a>EPERM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1336469443084823"><a name="p1336469443084823"></a><a name="p1336469443084823"></a>The file structure corresponding to the file descriptor cannot be obtained. </p>
</td>
</tr>
<tr id="row1804240804084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2140138935084823"><a name="p2140138935084823"></a><a name="p2140138935084823"></a>EEXIST </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p82711041084823"><a name="p82711041084823"></a><a name="p82711041084823"></a><strong id="b67937662084823"><a name="b67937662084823"></a><a name="b67937662084823"></a>O_CREAT</strong> and <strong id="b254892507084823"><a name="b254892507084823"></a><a name="b254892507084823"></a>O_EXCL</strong> are set. </p>
</td>
</tr>
<tr id="row1484908483084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p176927930084823"><a name="p176927930084823"></a><a name="p176927930084823"></a>EIO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1215628018084823"><a name="p1215628018084823"></a><a name="p1215628018084823"></a>A hardware error occurs at the low-level disk I/O layer. As a result, the physical drive cannot work. </p>
</td>
</tr>
<tr id="row445720542084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1793852445084823"><a name="p1793852445084823"></a><a name="p1793852445084823"></a>EROFS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2039649672084823"><a name="p2039649672084823"></a><a name="p2039649672084823"></a>The named file resides on a read-only file system, and either <a href="fs.md#ga11b644a8526139c4cc1850dac1271ced">O_WRONLY</a>, <a href="fs.md#gabb0586253488ee61072b73557eeb873b">O_RDWR</a>, <strong id="b1221125363084823"><a name="b1221125363084823"></a><a name="b1221125363084823"></a>O_CREAT</strong> (if file does not exist), or <strong id="b1026974375084823"><a name="b1026974375084823"></a><a name="b1026974375084823"></a>O_TRUNC</strong> is set in the <strong id="b1951269436084823"><a name="b1951269436084823"></a><a name="b1951269436084823"></a>oflags</strong> parameter. </p>
</td>
</tr>
<tr id="row320570842084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1986544882084823"><a name="p1986544882084823"></a><a name="p1986544882084823"></a>ENOSPC </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1949837400084823"><a name="p1949837400084823"></a><a name="p1949837400084823"></a>The directory or file system that would contain the new file cannot be expanded, the file does not exist, and <strong id="b1402324996084823"><a name="b1402324996084823"></a><a name="b1402324996084823"></a>O_CREAT</strong> is specified. </p>
</td>
</tr>
<tr id="row875756780084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1889837109084823"><a name="p1889837109084823"></a><a name="p1889837109084823"></a>ENFILE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1008388974084823"><a name="p1008388974084823"></a><a name="p1008388974084823"></a>The number of opened files in the system has reached the maximum. </p>
</td>
</tr>
<tr id="row1127075491084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p309179702084823"><a name="p309179702084823"></a><a name="p309179702084823"></a>EISDIR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1330503778084823"><a name="p1330503778084823"></a><a name="p1330503778084823"></a>The named file is a directory, and <strong id="b23493902084823"><a name="b23493902084823"></a><a name="b23493902084823"></a>oflags</strong> includes <a href="fs.md#ga11b644a8526139c4cc1850dac1271ced">O_WRONLY</a>, <a href="fs.md#gabb0586253488ee61072b73557eeb873b">O_RDWR</a>, or <strong id="b1241095149084823"><a name="b1241095149084823"></a><a name="b1241095149084823"></a>O_CREAT</strong> without <strong id="b567675200084823"><a name="b567675200084823"></a><a name="b567675200084823"></a>O_DIRECTORY</strong>. </p>
</td>
</tr>
<tr id="row1151461299084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1603317319084823"><a name="p1603317319084823"></a><a name="p1603317319084823"></a>ENOTDIR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p738473753084823"><a name="p738473753084823"></a><a name="p738473753084823"></a>A component of the path prefix names an existing file that is not a directory. </p>
</td>
</tr>
<tr id="row1927574708084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p266439825084823"><a name="p266439825084823"></a><a name="p266439825084823"></a>EBUSY </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1321637115084823"><a name="p1321637115084823"></a><a name="p1321637115084823"></a>The operation is rejected according to the file sharing policy. </p>
</td>
</tr>
<tr id="row248597152084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1647240196084823"><a name="p1647240196084823"></a><a name="p1647240196084823"></a>ENODEV </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p487632230084823"><a name="p487632230084823"></a><a name="p487632230084823"></a>The device does not exist. </p>
</td>
</tr>
<tr id="row274694375084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p305267686084823"><a name="p305267686084823"></a><a name="p305267686084823"></a>ENOTEMPTY </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p680045746084823"><a name="p680045746084823"></a><a name="p680045746084823"></a>The directory is not empty. </p>
</td>
</tr>
<tr id="row948466108084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p211503024084823"><a name="p211503024084823"></a><a name="p211503024084823"></a>ELOOP </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1561886703084823"><a name="p1561886703084823"></a><a name="p1561886703084823"></a>Too many symbolic links are encountered. </p>
</td>
</tr>
<tr id="row378479561084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p442158555084823"><a name="p442158555084823"></a><a name="p442158555084823"></a>EFAULT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p595459721084823"><a name="p595459721084823"></a><a name="p595459721084823"></a>The IP address is incorrect. </p>
</td>
</tr>
</tbody>
</table>

## opendir\(\)<a name="gad09dd96447776d2bc5d8321e4b499591"></a>

```
[DIR](fs.md#ga0ebe68390948c14bb9d82987adbfc849)* opendir (const char * dirname)
```

 **Description:**

Opens a specified directory. 

**Parameters:**

<a name="table984410932084823"></a>
<table><thead align="left"><tr id="row1694571030084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1015476325084823"><a name="p1015476325084823"></a><a name="p1015476325084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p451722982084823"><a name="p451722982084823"></a><a name="p451722982084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row527224114084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dirname</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the name of directory to open. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the  **DIR**  structure representing the directory if it is opened successfully; returns  **NULL**  and sets  **errno**  to a value in the following table otherwise. 

<a name="table890994148084823"></a>
<table><thead align="left"><tr id="row512500535084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p570582029084823"><a name="p570582029084823"></a><a name="p570582029084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1972514172084823"><a name="p1972514172084823"></a><a name="p1972514172084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1799025881084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1132774993084823"><a name="p1132774993084823"></a><a name="p1132774993084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1322514047084823"><a name="p1322514047084823"></a><a name="p1322514047084823"></a>The <strong id="b100551141084823"><a name="b100551141084823"></a><a name="b100551141084823"></a>dirname</strong> is empty. </p>
</td>
</tr>
<tr id="row1752854595084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1659877088084823"><a name="p1659877088084823"></a><a name="p1659877088084823"></a>ENAMETOOLONG </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p73262610084823"><a name="p73262610084823"></a><a name="p73262610084823"></a>The length of the path name string is longer than the value of <a href="utils.md#gac64541bdd81c961304b9babef1402640">NAME_MAX</a>. </p>
</td>
</tr>
<tr id="row472599423084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2052069112084823"><a name="p2052069112084823"></a><a name="p2052069112084823"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1718404615084823"><a name="p1718404615084823"></a><a name="p1718404615084823"></a>The path component does not exist. </p>
</td>
</tr>
<tr id="row2120751779084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1824501970084823"><a name="p1824501970084823"></a><a name="p1824501970084823"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p904612123084823"><a name="p904612123084823"></a><a name="p904612123084823"></a>The storage memory is insufficient. </p>
</td>
</tr>
<tr id="row1240439614084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1756184702084823"><a name="p1756184702084823"></a><a name="p1756184702084823"></a>ENOTDIR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1864155654084823"><a name="p1864155654084823"></a><a name="p1864155654084823"></a><strong id="b1831915819084823"><a name="b1831915819084823"></a><a name="b1831915819084823"></a> dirname </strong> is not a directory. </p>
</td>
</tr>
</tbody>
</table>

## readdir\(\)<a name="ga58257faf8b13b3f14558613c632b2373"></a>

```
struct [dirent](dirent.md)* readdir ([DIR](fs.md#ga0ebe68390948c14bb9d82987adbfc849) * dirp)
```

 **Description:**

Reads a specified directory. 

**Parameters:**

<a name="table1271437563084823"></a>
<table><thead align="left"><tr id="row1290950957084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1377276902084823"><a name="p1377276902084823"></a><a name="p1377276902084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1053961114084823"><a name="p1053961114084823"></a><a name="p1053961114084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row640463627084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dirp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the directory structure. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the  **dirent**  structure representing the directory if it is read successfully; returns  **NULL**  if reaching the end of the directory stream or the directory fails to be read. If the directory fails to be read, the corresponding error code is returned. 

<a name="table50263180084823"></a>
<table><thead align="left"><tr id="row710354231084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p140798947084823"><a name="p140798947084823"></a><a name="p140798947084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1056310043084823"><a name="p1056310043084823"></a><a name="p1056310043084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1771670049084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1088048796084823"><a name="p1088048796084823"></a><a name="p1088048796084823"></a>EACCES </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2074821809084823"><a name="p2074821809084823"></a><a name="p2074821809084823"></a>This feature is not supported by the file system. </p>
</td>
</tr>
<tr id="row121684132084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p129728748084823"><a name="p129728748084823"></a><a name="p129728748084823"></a>ENAMETOOLONG </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1430453879084823"><a name="p1430453879084823"></a><a name="p1430453879084823"></a>The path name length is greater than the value of <a href="utils.md#gac64541bdd81c961304b9babef1402640">NAME_MAX</a>. </p>
</td>
</tr>
<tr id="row1258822429084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p52165343084823"><a name="p52165343084823"></a><a name="p52165343084823"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p672097907084823"><a name="p672097907084823"></a><a name="p672097907084823"></a>The current position in the directory stream is invalid. </p>
</td>
</tr>
<tr id="row1249322330084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1976173305084823"><a name="p1976173305084823"></a><a name="p1976173305084823"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p253149573084823"><a name="p253149573084823"></a><a name="p253149573084823"></a><strong id="b711907156084823"><a name="b711907156084823"></a><a name="b711907156084823"></a>dirp</strong> is not an opened directory stream. </p>
</td>
</tr>
</tbody>
</table>

## readdir\_r\(\)<a name="ga9f1bc61c37394eda9e74e0c79afec872"></a>

```
int readdir_r ([DIR](fs.md#ga0ebe68390948c14bb9d82987adbfc849) *__restrict dirp, struct [dirent](dirent.md) *__restrict entry, struct [dirent](dirent.md) **__restrict result )
```

 **Description:**

Reads a specified directory \(thread-safe version\). 

**Parameters:**

<a name="table726246668084823"></a>
<table><thead align="left"><tr id="row207475856084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2011201238084823"><a name="p2011201238084823"></a><a name="p2011201238084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1975214885084823"><a name="p1975214885084823"></a><a name="p1975214885084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1043488209084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dirp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the directory structure. </td>
</tr>
<tr id="row1419214818084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">entry</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the entry read from the <strong id="b692818633084823"><a name="b692818633084823"></a><a name="b692818633084823"></a>dirp</strong> stream. </td>
</tr>
<tr id="row1612119066084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">result</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the returned buffer. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**. If the directory fails to be read,  **errno**  is sets to a value in the following table. 

<a name="table1115480735084823"></a>
<table><thead align="left"><tr id="row1767852003084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1110090443084823"><a name="p1110090443084823"></a><a name="p1110090443084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p478646563084823"><a name="p478646563084823"></a><a name="p478646563084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row23741089084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1210420680084823"><a name="p1210420680084823"></a><a name="p1210420680084823"></a>EACCES </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p436544506084823"><a name="p436544506084823"></a><a name="p436544506084823"></a>This feature is not supported by the file system. </p>
</td>
</tr>
<tr id="row748581729084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2147231101084823"><a name="p2147231101084823"></a><a name="p2147231101084823"></a>ENAMETOOLONG </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1770668361084823"><a name="p1770668361084823"></a><a name="p1770668361084823"></a>The path name length is greater than the value of <a href="utils.md#gac64541bdd81c961304b9babef1402640">NAME_MAX</a>. </p>
</td>
</tr>
<tr id="row756165550084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p630940592084823"><a name="p630940592084823"></a><a name="p630940592084823"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p931286129084823"><a name="p931286129084823"></a><a name="p931286129084823"></a>The current position in the directory stream is invalid. </p>
</td>
</tr>
<tr id="row2147311921084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1224296639084823"><a name="p1224296639084823"></a><a name="p1224296639084823"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1119601964084823"><a name="p1119601964084823"></a><a name="p1119601964084823"></a><strong id="b1074119028084823"><a name="b1074119028084823"></a><a name="b1074119028084823"></a>dirp</strong> is not an opened directory stream. </p>
</td>
</tr>
</tbody>
</table>

## rewinddir\(\)<a name="gad4fcb58b9194b1a3c1699654de963719"></a>

```
void rewinddir ([DIR](fs.md#ga0ebe68390948c14bb9d82987adbfc849) * dirp)
```

 **Description:**

Resets a directory stream read position. 

This function is used to change the current read position of the specified directory stream to the original read position \(that is, the start position after the directory stream is opened by  [opendir](fs.md#gad09dd96447776d2bc5d8321e4b499591)\). 

**Parameters:**

<a name="table585234068084823"></a>
<table><thead align="left"><tr id="row2065158967084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1655722488084823"><a name="p1655722488084823"></a><a name="p1655722488084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1347757670084823"><a name="p1347757670084823"></a><a name="p1347757670084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row717880308084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dirp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the directory stream whose read position needs to be reset. </td>
</tr>
</tbody>
</table>

<a name="table401174845084823"></a>
<table><thead align="left"><tr id="row1003001845084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p540160292084823"><a name="p540160292084823"></a><a name="p540160292084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1093539907084823"><a name="p1093539907084823"></a><a name="p1093539907084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1299011194084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p697526387084823"><a name="p697526387084823"></a><a name="p697526387084823"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p482486826084823"><a name="p482486826084823"></a><a name="p482486826084823"></a><strong id="b773855537084823"><a name="b773855537084823"></a><a name="b773855537084823"></a>dirp</strong> is not an opened directory stream. </p>
</td>
</tr>
</tbody>
</table>

## scandir\(\)<a name="gaca6df630e382cf13bac90ed6e5c4141c"></a>

```
int scandir (const char * dir, struct [dirent](dirent.md) *** namelist, int(*)(const struct [dirent](dirent.md) *) sel, int(*)(const struct [dirent](dirent.md) **, const struct [dirent](dirent.md) **) compar )
```

 **Description:**

Scans directory to find the target entries. 

**Parameters:**

<a name="table87941208084823"></a>
<table><thead align="left"><tr id="row1243050854084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1244902557084823"><a name="p1244902557084823"></a><a name="p1244902557084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1874799364084823"><a name="p1874799364084823"></a><a name="p1874799364084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row655262681084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dir</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the directory to scan. </td>
</tr>
<tr id="row1262197829084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">namelist</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the array storing the directory entries filtered by the function referenced by the <strong id="b1471195778084823"><a name="b1471195778084823"></a><a name="b1471195778084823"></a>sel</strong> parameter. </td>
</tr>
<tr id="row757939980084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">sel</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the filtering condition. You can customize the function referenced by this parameter. Value <strong id="b942756733084823"><a name="b942756733084823"></a><a name="b942756733084823"></a>0</strong> is returned if the filtering condition is not met; a non-zero value is returned otherwise. </td>
</tr>
<tr id="row1117221026084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">compar</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the function for sorting the directory entries. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of entries copied to the  **namelist**  array if the scanning is successful; returns  **-1**  and sets  **errno**  to a value in the following table otherwise. 

<a name="table474318519084823"></a>
<table><thead align="left"><tr id="row122365277084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1426113831084823"><a name="p1426113831084823"></a><a name="p1426113831084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1565447094084823"><a name="p1565447094084823"></a><a name="p1565447094084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row768540025084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p684342834084823"><a name="p684342834084823"></a><a name="p684342834084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2012533923084823"><a name="p2012533923084823"></a><a name="p2012533923084823"></a><strong id="b246828993084823"><a name="b246828993084823"></a><a name="b246828993084823"></a>dir</strong> is empty. </p>
</td>
</tr>
<tr id="row2112913924084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p164576667084823"><a name="p164576667084823"></a><a name="p164576667084823"></a>ENAMETOOLONG </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1026102062084823"><a name="p1026102062084823"></a><a name="p1026102062084823"></a>The length of the path name string is greater than the value of <a href="utils.md#gac64541bdd81c961304b9babef1402640">NAME_MAX</a>. </p>
</td>
</tr>
<tr id="row273876774084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p194926011084823"><a name="p194926011084823"></a><a name="p194926011084823"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p879331090084823"><a name="p879331090084823"></a><a name="p879331090084823"></a>The directory component does not exist. </p>
</td>
</tr>
<tr id="row1360684295084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p800227851084823"><a name="p800227851084823"></a><a name="p800227851084823"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1894583156084823"><a name="p1894583156084823"></a><a name="p1894583156084823"></a>The storage memory is insufficient. </p>
</td>
</tr>
<tr id="row1904675667084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1391118292084823"><a name="p1391118292084823"></a><a name="p1391118292084823"></a>ENOTDIR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p532495350084823"><a name="p532495350084823"></a><a name="p532495350084823"></a><strong id="b460164018084823"><a name="b460164018084823"></a><a name="b460164018084823"></a>dir</strong> is not a directory. </p>
</td>
</tr>
<tr id="row113928608084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1363419965084823"><a name="p1363419965084823"></a><a name="p1363419965084823"></a>EACCES </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p465179276084823"><a name="p465179276084823"></a><a name="p465179276084823"></a>This feature is not supported by the file system. </p>
</td>
</tr>
</tbody>
</table>

## seekdir\(\)<a name="gacf0a74ce364760e330619edb38eadfff"></a>

```
void seekdir ([DIR](fs.md#ga0ebe68390948c14bb9d82987adbfc849) * dirp, long offset )
```

 **Description:**

Sets the position of the next  [readdir](fs.md#ga58257faf8b13b3f14558613c632b2373)  call in the directory stream. 

**Parameters:**

<a name="table1914608042084823"></a>
<table><thead align="left"><tr id="row2086952549084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p294554934084823"><a name="p294554934084823"></a><a name="p294554934084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1840405862084823"><a name="p1840405862084823"></a><a name="p1840405862084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row421252557084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dirp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the directory stream in which the position of the next <a href="fs.md#ga58257faf8b13b3f14558613c632b2373">readdir</a> call needs to be set. </td>
</tr>
<tr id="row64501365084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">offset</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the offset of the position relative to the current position. </td>
</tr>
</tbody>
</table>

## stat\(\)<a name="gad2e0bcbe40344116102877f6268ee6ea"></a>

```
int [stat](stat.md) (const char *__restrict path, struct [stat](stat.md) *__restrict buf )
```

 **Description:**

Obtains file information. 

**Parameters:**

<a name="table782759289084823"></a>
<table><thead align="left"><tr id="row1542904964084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p165632287084823"><a name="p165632287084823"></a><a name="p165632287084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1060580380084823"><a name="p1060580380084823"></a><a name="p1060580380084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1587149990084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">path</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the file path. </td>
</tr>
<tr id="row306451698084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">buf</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to a <strong id="b689737128084823"><a name="b689737128084823"></a><a name="b689737128084823"></a>stat</strong> structure into which file information is placed. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if file information is obtained successfully; returns  **-1**  and sets  **errno**  to a value in the following table otherwise. 

<a name="table461785856084823"></a>
<table><thead align="left"><tr id="row1783925497084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1998925539084823"><a name="p1998925539084823"></a><a name="p1998925539084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1284239159084823"><a name="p1284239159084823"></a><a name="p1284239159084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row910110918084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p199530931084823"><a name="p199530931084823"></a><a name="p199530931084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2035025390084823"><a name="p2035025390084823"></a><a name="p2035025390084823"></a>Invalid parameter. </p>
</td>
</tr>
<tr id="row1177371803084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p890618209084823"><a name="p890618209084823"></a><a name="p890618209084823"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1287651874084823"><a name="p1287651874084823"></a><a name="p1287651874084823"></a>A component of <strong id="b968968242084823"><a name="b968968242084823"></a><a name="b968968242084823"></a>path</strong> does not name an existing file or <strong id="b1648049794084823"><a name="b1648049794084823"></a><a name="b1648049794084823"></a>path</strong> is an empty string. </p>
</td>
</tr>
<tr id="row1945737379084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1514546524084823"><a name="p1514546524084823"></a><a name="p1514546524084823"></a>ENAMETOOLONG </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1080838768084823"><a name="p1080838768084823"></a><a name="p1080838768084823"></a>The path name length is greater than the value of <a href="utils.md#gac64541bdd81c961304b9babef1402640">NAME_MAX</a>. </p>
</td>
</tr>
<tr id="row1596624375084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p78620886084823"><a name="p78620886084823"></a><a name="p78620886084823"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1618420891084823"><a name="p1618420891084823"></a><a name="p1618420891084823"></a>Insufficient memory. </p>
</td>
</tr>
<tr id="row1679767350084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p941731355084823"><a name="p941731355084823"></a><a name="p941731355084823"></a>ENOSYS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p996717391084823"><a name="p996717391084823"></a><a name="p996717391084823"></a>The function is not supported. </p>
</td>
</tr>
<tr id="row1229602534084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p879591609084823"><a name="p879591609084823"></a><a name="p879591609084823"></a>EAGAIN </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p26280357084823"><a name="p26280357084823"></a><a name="p26280357084823"></a>The file list is null. </p>
</td>
</tr>
<tr id="row213490745084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1701158789084823"><a name="p1701158789084823"></a><a name="p1701158789084823"></a>EACCES </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p413597608084823"><a name="p413597608084823"></a><a name="p413597608084823"></a>The permission bit of the file mode does not allow the requested access, or the search permission is denied on the path prefix component. </p>
</td>
</tr>
<tr id="row493346086084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2118914312084823"><a name="p2118914312084823"></a><a name="p2118914312084823"></a>EEXIST </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p741590980084823"><a name="p741590980084823"></a><a name="p741590980084823"></a>The file or directory already exists. </p>
</td>
</tr>
<tr id="row1702906269084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1219781126084823"><a name="p1219781126084823"></a><a name="p1219781126084823"></a>EIO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1897943950084823"><a name="p1897943950084823"></a><a name="p1897943950084823"></a>An I/O error occurs when data is read from or written to the file system. </p>
</td>
</tr>
<tr id="row1191419042084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1441679894084823"><a name="p1441679894084823"></a><a name="p1441679894084823"></a>EROFS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1090935169084823"><a name="p1090935169084823"></a><a name="p1090935169084823"></a>The physical drive is write-protected. </p>
</td>
</tr>
<tr id="row486880075084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p625500541084823"><a name="p625500541084823"></a><a name="p625500541084823"></a>ENOSPC </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1457771978084823"><a name="p1457771978084823"></a><a name="p1457771978084823"></a>No available space on the device. </p>
</td>
</tr>
<tr id="row384565779084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p320430164084823"><a name="p320430164084823"></a><a name="p320430164084823"></a>ENFILE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1531154947084823"><a name="p1531154947084823"></a><a name="p1531154947084823"></a>The number of opened files in the system has reached the maximum. </p>
</td>
</tr>
<tr id="row345098961084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1629252846084823"><a name="p1629252846084823"></a><a name="p1629252846084823"></a>ENOTEMPTY </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p498421607084823"><a name="p498421607084823"></a><a name="p498421607084823"></a>The directory is not empty. </p>
</td>
</tr>
<tr id="row698110927084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1582465351084823"><a name="p1582465351084823"></a><a name="p1582465351084823"></a>EISDIR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1530968535084823"><a name="p1530968535084823"></a><a name="p1530968535084823"></a>The named file is a directory. </p>
</td>
</tr>
<tr id="row2028361762084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1302741129084823"><a name="p1302741129084823"></a><a name="p1302741129084823"></a>ENOTDIR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p557512420084823"><a name="p557512420084823"></a><a name="p557512420084823"></a>A component of the <strong id="b2121997787084823"><a name="b2121997787084823"></a><a name="b2121997787084823"></a>path</strong> prefix is the name of an existing file. The file is neither a directory nor a symbolic link of a directory. </p>
</td>
</tr>
<tr id="row1831138015084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1188393765084823"><a name="p1188393765084823"></a><a name="p1188393765084823"></a>EPERM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1535403432084823"><a name="p1535403432084823"></a><a name="p1535403432084823"></a>Operation not permitted or access denied because the access is prohibited or the directory is full. </p>
</td>
</tr>
<tr id="row1685018637084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1092799769084823"><a name="p1092799769084823"></a><a name="p1092799769084823"></a>EBUSY </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1635989525084823"><a name="p1635989525084823"></a><a name="p1635989525084823"></a>The operation is rejected according to the file sharing policy. </p>
</td>
</tr>
<tr id="row1367894092084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1554192454084823"><a name="p1554192454084823"></a><a name="p1554192454084823"></a>EPROTO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1777961544084823"><a name="p1777961544084823"></a><a name="p1777961544084823"></a>The protocol in NFS is incorrect. </p>
</td>
</tr>
<tr id="row1062598493084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1549086800084823"><a name="p1549086800084823"></a><a name="p1549086800084823"></a>ENODEV </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p608356711084823"><a name="p608356711084823"></a><a name="p608356711084823"></a>No such device. </p>
</td>
</tr>
<tr id="row1390355935084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p207547716084823"><a name="p207547716084823"></a><a name="p207547716084823"></a>EFAULT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1703096455084823"><a name="p1703096455084823"></a><a name="p1703096455084823"></a>Incorrect IP address. </p>
</td>
</tr>
</tbody>
</table>

## statfs\(\)<a name="gae7af18cc5fa39f42a3be1bf1eb24119d"></a>

```
int statfs (const char * path, struct statfs * buf )
```

 **Description:**

Obtains file system information of a file in a specified path. 

**Parameters:**

<a name="table2108222004084823"></a>
<table><thead align="left"><tr id="row786147885084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p684438482084823"><a name="p684438482084823"></a><a name="p684438482084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p32092985084823"><a name="p32092985084823"></a><a name="p32092985084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1299077934084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">path</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the name of the target file. </td>
</tr>
<tr id="row595442688084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">buf</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to a <strong id="b2048159248084823"><a name="b2048159248084823"></a><a name="b2048159248084823"></a>statfs</strong> structure that stores the information about the file system. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table650704105084823"></a>
<table><thead align="left"><tr id="row149112879084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1839942204084823"><a name="p1839942204084823"></a><a name="p1839942204084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1707301852084823"><a name="p1707301852084823"></a><a name="p1707301852084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1148310592084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p427842478084823"><a name="p427842478084823"></a><a name="p427842478084823"></a>EACCES </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p236810479084823"><a name="p236810479084823"></a><a name="p236810479084823"></a>Search permission is denied on a component of the path prefix. </p>
</td>
</tr>
<tr id="row1629008035084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1927779318084823"><a name="p1927779318084823"></a><a name="p1927779318084823"></a>EFAULT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1285882145084823"><a name="p1285882145084823"></a><a name="p1285882145084823"></a><strong id="b34816864084823"><a name="b34816864084823"></a><a name="b34816864084823"></a>buf</strong> or <strong id="b194575412084823"><a name="b194575412084823"></a><a name="b194575412084823"></a>path</strong> points to an invalid address. </p>
</td>
</tr>
<tr id="row429910532084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p55048968084823"><a name="p55048968084823"></a><a name="p55048968084823"></a>EINTR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p960984273084823"><a name="p960984273084823"></a><a name="p960984273084823"></a>The function call was interrupted by a signal. </p>
</td>
</tr>
<tr id="row1975318094084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p695391258084823"><a name="p695391258084823"></a><a name="p695391258084823"></a>EIO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p960566595084823"><a name="p960566595084823"></a><a name="p960566595084823"></a>An I/O error occurred while reading from the file system. </p>
</td>
</tr>
<tr id="row1345510409084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1104454433084823"><a name="p1104454433084823"></a><a name="p1104454433084823"></a>ELOOP </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1702426648084823"><a name="p1702426648084823"></a><a name="p1702426648084823"></a>Too many symbolic links were found. </p>
</td>
</tr>
<tr id="row2052137293084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1202590451084823"><a name="p1202590451084823"></a><a name="p1202590451084823"></a>ENAMETOOLONG </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2018368867084823"><a name="p2018368867084823"></a><a name="p2018368867084823"></a><strong id="b1338208531084823"><a name="b1338208531084823"></a><a name="b1338208531084823"></a>path</strong> is too long. </p>
</td>
</tr>
<tr id="row1790066384084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p258330266084823"><a name="p258330266084823"></a><a name="p258330266084823"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1213569766084823"><a name="p1213569766084823"></a><a name="p1213569766084823"></a>The file referred to by <strong id="b2108219550084823"><a name="b2108219550084823"></a><a name="b2108219550084823"></a>path</strong> does not exist. </p>
</td>
</tr>
<tr id="row1288303446084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2069352629084823"><a name="p2069352629084823"></a><a name="p2069352629084823"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p754094156084823"><a name="p754094156084823"></a><a name="p754094156084823"></a>Insufficient memory. </p>
</td>
</tr>
<tr id="row1392880588084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1390258732084823"><a name="p1390258732084823"></a><a name="p1390258732084823"></a>ENOSYS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p801990937084823"><a name="p801990937084823"></a><a name="p801990937084823"></a>The operation is not supported. </p>
</td>
</tr>
<tr id="row87977780084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p114952616084823"><a name="p114952616084823"></a><a name="p114952616084823"></a>ENOTDIR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p177092524084823"><a name="p177092524084823"></a><a name="p177092524084823"></a>A component of the path prefix of <strong id="b377178159084823"><a name="b377178159084823"></a><a name="b377178159084823"></a>path</strong> is not a directory. </p>
</td>
</tr>
<tr id="row2126565529084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p896914387084823"><a name="p896914387084823"></a><a name="p896914387084823"></a>EOVERFLOW </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1986260732084823"><a name="p1986260732084823"></a><a name="p1986260732084823"></a>Information overflow </p>
</td>
</tr>
</tbody>
</table>

## statvfs\(\)<a name="ga41058769ad8ea7d7d467799f651b8b1a"></a>

```
int [statvfs](statvfs.md) (const char *__restrict path, struct [statvfs](statvfs.md) *__restrict buf )
```

 **Description:**

Obtains the file system information. 

**Parameters:**

<a name="table654516157084823"></a>
<table><thead align="left"><tr id="row379720716084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p246942239084823"><a name="p246942239084823"></a><a name="p246942239084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p730434334084823"><a name="p730434334084823"></a><a name="p730434334084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1084304813084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">path</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the path name of the file. </td>
</tr>
<tr id="row1706646784084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">buf</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the <strong id="b937566839084823"><a name="b937566839084823"></a><a name="b937566839084823"></a>statvfs</strong> structure that stores the obtained file system information. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the file system information is obtained successfully; returns  **-1**  and sets  **errno**  to a value in the following table otherwise. 

<a name="table201473890084823"></a>
<table><thead align="left"><tr id="row170012827084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1653540378084823"><a name="p1653540378084823"></a><a name="p1653540378084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1045242406084823"><a name="p1045242406084823"></a><a name="p1045242406084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1432193140084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1681461718084823"><a name="p1681461718084823"></a><a name="p1681461718084823"></a>EACCES </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1959071089084823"><a name="p1959071089084823"></a><a name="p1959071089084823"></a>Search permission is denied on a component of the path prefix. </p>
</td>
</tr>
<tr id="row490183514084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p71366680084823"><a name="p71366680084823"></a><a name="p71366680084823"></a>EFAULT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1139613745084823"><a name="p1139613745084823"></a><a name="p1139613745084823"></a><strong id="b1089376364084823"><a name="b1089376364084823"></a><a name="b1089376364084823"></a>buf</strong> or <strong id="b775694376084823"><a name="b775694376084823"></a><a name="b775694376084823"></a>path</strong> points to an invalid address. </p>
</td>
</tr>
<tr id="row1351989241084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p687273236084823"><a name="p687273236084823"></a><a name="p687273236084823"></a>EINTR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p964120829084823"><a name="p964120829084823"></a><a name="p964120829084823"></a>This call was interrupted by a signal. </p>
</td>
</tr>
<tr id="row1156592774084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1654591713084823"><a name="p1654591713084823"></a><a name="p1654591713084823"></a>EIO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p813932249084823"><a name="p813932249084823"></a><a name="p813932249084823"></a>An I/O error occurred while reading from the file system. </p>
</td>
</tr>
<tr id="row276144510084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1240782235084823"><a name="p1240782235084823"></a><a name="p1240782235084823"></a>ELOOP </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1478731465084823"><a name="p1478731465084823"></a><a name="p1478731465084823"></a>Too many symbolic links were found. </p>
</td>
</tr>
<tr id="row1280943176084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1446351214084823"><a name="p1446351214084823"></a><a name="p1446351214084823"></a>ENAMETOOLONG </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2140509877084823"><a name="p2140509877084823"></a><a name="p2140509877084823"></a><strong id="b89245384084823"><a name="b89245384084823"></a><a name="b89245384084823"></a>path</strong> is too long. </p>
</td>
</tr>
<tr id="row62299926084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1575519999084823"><a name="p1575519999084823"></a><a name="p1575519999084823"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1300555010084823"><a name="p1300555010084823"></a><a name="p1300555010084823"></a>The file specified by <strong id="b481849944084823"><a name="b481849944084823"></a><a name="b481849944084823"></a>path</strong> does not exist. </p>
</td>
</tr>
<tr id="row71567960084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p244043381084823"><a name="p244043381084823"></a><a name="p244043381084823"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1879940999084823"><a name="p1879940999084823"></a><a name="p1879940999084823"></a>Insufficient memory. </p>
</td>
</tr>
<tr id="row1719931287084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p237961798084823"><a name="p237961798084823"></a><a name="p237961798084823"></a>ENOSYS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1078133070084823"><a name="p1078133070084823"></a><a name="p1078133070084823"></a>The file system does not support this call. </p>
</td>
</tr>
<tr id="row1206548151084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1575700694084823"><a name="p1575700694084823"></a><a name="p1575700694084823"></a>ENOTDIR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1765918633084823"><a name="p1765918633084823"></a><a name="p1765918633084823"></a>A component of the path prefix of <strong id="b1646642217084823"><a name="b1646642217084823"></a><a name="b1646642217084823"></a>path</strong> is not a directory. </p>
</td>
</tr>
<tr id="row1945573194084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1566286096084823"><a name="p1566286096084823"></a><a name="p1566286096084823"></a>EOVERFLOW </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p257269592084823"><a name="p257269592084823"></a><a name="p257269592084823"></a>Information overflows. </p>
</td>
</tr>
</tbody>
</table>

## telldir\(\)<a name="ga4c2cd02bd612ae655782632c9f5227ec"></a>

```
long telldir ([DIR](fs.md#ga0ebe68390948c14bb9d82987adbfc849) * dirp)
```

 **Description:**

Obtains the current position in the specified directory stream. 

**Parameters:**

<a name="table913642019084823"></a>
<table><thead align="left"><tr id="row1454299147084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p118965474084823"><a name="p118965474084823"></a><a name="p118965474084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1345674937084823"><a name="p1345674937084823"></a><a name="p1345674937084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row986880716084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dirp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the directory stream. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the current position in the directory stream if the operation is successful; returns  **-1**  and sets  **errno**  to the value in the following table otherwise. 

<a name="table269078300084823"></a>
<table><thead align="left"><tr id="row1599881050084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1999979505084823"><a name="p1999979505084823"></a><a name="p1999979505084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p322664584084823"><a name="p322664584084823"></a><a name="p322664584084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row849510022084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1353515478084823"><a name="p1353515478084823"></a><a name="p1353515478084823"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p586382647084823"><a name="p586382647084823"></a><a name="p586382647084823"></a><strong id="b443050766084823"><a name="b443050766084823"></a><a name="b443050766084823"></a>drip</strong> is not an opened directory stream. </p>
</td>
</tr>
</tbody>
</table>

## umask\(\)<a name="ga556063623e479c26c64544024a046024"></a>

```
mode_t umask (mode_t mode)
```

 **Description:**

Sets umask for a process. 

This function sets the umask of the current process file and returns the previous value of the umask. umask is used to turn off permission bits corresponding to in the  **mode**  parameter. 

**Parameters:**

<a name="table222664882084823"></a>
<table><thead align="left"><tr id="row456293307084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p238749253084823"><a name="p238749253084823"></a><a name="p238749253084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p506029367084823"><a name="p506029367084823"></a><a name="p506029367084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2063462929084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">mode</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Used to specify the umask value of a process. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the previous value of the umask. This function call always succeeds. 



## umount\(\)<a name="ga44634cfa8bcc732c29bcdf5822095422"></a>

```
int umount (const char * target)
```

 **Description:**

Unmounts a file system. 

**Parameters:**

<a name="table605551983084823"></a>
<table><thead align="left"><tr id="row1955775150084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1996590150084823"><a name="p1996590150084823"></a><a name="p1996590150084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1394520065084823"><a name="p1394520065084823"></a><a name="p1394520065084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1668538120084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">target</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the path of the file system to unmount. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the file system is unmounted successfully; returns  **-1**  and sets  **errno**  to a value in the following table otherwise. 

<a name="table1781163969084823"></a>
<table><thead align="left"><tr id="row1394325400084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p841516255084823"><a name="p841516255084823"></a><a name="p841516255084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1759365244084823"><a name="p1759365244084823"></a><a name="p1759365244084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1580387646084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1795319802084823"><a name="p1795319802084823"></a><a name="p1795319802084823"></a>EBUSY </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1150614034084823"><a name="p1150614034084823"></a><a name="p1150614034084823"></a><strong id="b1011968205084823"><a name="b1011968205084823"></a><a name="b1011968205084823"></a>target</strong> could not be unmounted because it is busy. </p>
</td>
</tr>
<tr id="row201400885084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2005780541084823"><a name="p2005780541084823"></a><a name="p2005780541084823"></a>EFAULT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p534567085084823"><a name="p534567085084823"></a><a name="p534567085084823"></a><strong id="b101267275084823"><a name="b101267275084823"></a><a name="b101267275084823"></a>target</strong> points outside the user address space. </p>
</td>
</tr>
<tr id="row1445523623084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2078107061084823"><a name="p2078107061084823"></a><a name="p2078107061084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1073222593084823"><a name="p1073222593084823"></a><a name="p1073222593084823"></a><strong id="b798505286084823"><a name="b798505286084823"></a><a name="b798505286084823"></a>target</strong> is not a mount point. </p>
</td>
</tr>
<tr id="row586338773084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p858937393084823"><a name="p858937393084823"></a><a name="p858937393084823"></a>ENAMETOOLONG </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1068251789084823"><a name="p1068251789084823"></a><a name="p1068251789084823"></a>The path length is greater than the value of <strong id="b150091963084823"><a name="b150091963084823"></a><a name="b150091963084823"></a>MAXPATHLEN</strong>. </p>
</td>
</tr>
<tr id="row1520350303084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1269622075084823"><a name="p1269622075084823"></a><a name="p1269622075084823"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1130636209084823"><a name="p1130636209084823"></a><a name="p1130636209084823"></a>A path name is null or has a nonexistent component. </p>
</td>
</tr>
<tr id="row1755951417084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p962414835084823"><a name="p962414835084823"></a><a name="p962414835084823"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1882016176084823"><a name="p1882016176084823"></a><a name="p1882016176084823"></a>Insufficient memory. </p>
</td>
</tr>
<tr id="row1996962101084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p920918183084823"><a name="p920918183084823"></a><a name="p920918183084823"></a>EPERM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p646847781084823"><a name="p646847781084823"></a><a name="p646847781084823"></a>No permission. </p>
</td>
</tr>
</tbody>
</table>

## umount2\(\)<a name="ga2125a021d10f7a28a66cbc9335ad826f"></a>

```
int umount2 (const char * target, int flags )
```

 **Description:**

Unmounts a file system. 

This function is used to unmount a file system. Currently, the value of  **flags**  can only be  **0**. In this case, this function is the same as  **[umount\(\)](fs.md#ga44634cfa8bcc732c29bcdf5822095422)**. 

**Parameters:**

<a name="table498976941084823"></a>
<table><thead align="left"><tr id="row1483308455084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p418756598084823"><a name="p418756598084823"></a><a name="p418756598084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1029545467084823"><a name="p1029545467084823"></a><a name="p1029545467084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row625808245084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">target</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the path of the file system to unmount. </td>
</tr>
<tr id="row1251621792084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">flags</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the control flag. (Currently, the value of <strong id="b487516777084823"><a name="b487516777084823"></a><a name="b487516777084823"></a>flags</strong> can only be <strong id="b1580587982084823"><a name="b1580587982084823"></a><a name="b1580587982084823"></a>0</strong>. In this case, this function is the same as <strong id="b1765383620084823"><a name="b1765383620084823"></a><a name="b1765383620084823"></a><a href="fs.md#ga44634cfa8bcc732c29bcdf5822095422">umount()</a></strong>.) </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the file system is unmounted successfully; returns  **-1**  and sets  **errno**  to a value in the following table otherwise. 

<a name="table1527230910084823"></a>
<table><thead align="left"><tr id="row1497192484084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1123436824084823"><a name="p1123436824084823"></a><a name="p1123436824084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1437455560084823"><a name="p1437455560084823"></a><a name="p1437455560084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1781030861084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1804493458084823"><a name="p1804493458084823"></a><a name="p1804493458084823"></a>EBUSY </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p846835512084823"><a name="p846835512084823"></a><a name="p846835512084823"></a><strong id="b712757527084823"><a name="b712757527084823"></a><a name="b712757527084823"></a>target</strong> could not be unmounted because it is busy. </p>
</td>
</tr>
<tr id="row178752390084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1093960981084823"><a name="p1093960981084823"></a><a name="p1093960981084823"></a>EFAULT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1000058827084823"><a name="p1000058827084823"></a><a name="p1000058827084823"></a><strong id="b1591908736084823"><a name="b1591908736084823"></a><a name="b1591908736084823"></a>target</strong> points outside the user address space. </p>
</td>
</tr>
<tr id="row1686276416084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2093400474084823"><a name="p2093400474084823"></a><a name="p2093400474084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p491239592084823"><a name="p491239592084823"></a><a name="p491239592084823"></a><strong id="b1472688267084823"><a name="b1472688267084823"></a><a name="b1472688267084823"></a>target</strong> is not a mount point. </p>
</td>
</tr>
<tr id="row1158925248084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1841275724084823"><a name="p1841275724084823"></a><a name="p1841275724084823"></a>ENAMETOOLONG </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p305081560084823"><a name="p305081560084823"></a><a name="p305081560084823"></a>The path length is greater than the value of <strong id="b2083910378084823"><a name="b2083910378084823"></a><a name="b2083910378084823"></a>MAXPATHLEN</strong>. </p>
</td>
</tr>
<tr id="row1459488945084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1502887894084823"><a name="p1502887894084823"></a><a name="p1502887894084823"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p552154261084823"><a name="p552154261084823"></a><a name="p552154261084823"></a>A path name is null or has a nonexistent component. </p>
</td>
</tr>
<tr id="row504450434084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2117045531084823"><a name="p2117045531084823"></a><a name="p2117045531084823"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p564400805084823"><a name="p564400805084823"></a><a name="p564400805084823"></a>Insufficient memory. </p>
</td>
</tr>
<tr id="row1070834795084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2132519932084823"><a name="p2132519932084823"></a><a name="p2132519932084823"></a>EPERM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1439715032084823"><a name="p1439715032084823"></a><a name="p1439715032084823"></a>No permission. </p>
</td>
</tr>
<tr id="row533734512084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p311904884084823"><a name="p311904884084823"></a><a name="p311904884084823"></a>ENOSYS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1058221981084823"><a name="p1058221981084823"></a><a name="p1058221981084823"></a>The function call is not supported. (<strong id="b307783005084823"><a name="b307783005084823"></a><a name="b307783005084823"></a>flags</strong> value is not 0.) </p>
</td>
</tr>
</tbody>
</table>

## utime\(\)<a name="ga1299674b4b1934ebf0441388d07981a6"></a>

```
int utime (const char * filename, const struct [utimbuf](utimbuf.md) * times )
```

 **Description:**

Sets the access time and modification time of a file. 

**Parameters:**

<a name="table851746879084823"></a>
<table><thead align="left"><tr id="row769459486084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1412249717084823"><a name="p1412249717084823"></a><a name="p1412249717084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p375590297084823"><a name="p375590297084823"></a><a name="p375590297084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1849238906084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">filename</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the name of the file whose access time and modification time need to be set. </td>
</tr>
<tr id="row292737258084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">times</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the time to which the access time and modification time are set. If <strong id="b1890452749084823"><a name="b1890452749084823"></a><a name="b1890452749084823"></a>times</strong> is a null pointer, then the access time and modification time are set to the current time. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the access time and modification time are set successfully; returns  **-1**  and sets  **errno**  to a value in the following table otherwise. 

<a name="table1737664975084823"></a>
<table><thead align="left"><tr id="row356956159084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1801328029084823"><a name="p1801328029084823"></a><a name="p1801328029084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p78106770084823"><a name="p78106770084823"></a><a name="p78106770084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1916258485084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p561149613084823"><a name="p561149613084823"></a><a name="p561149613084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1868644526084823"><a name="p1868644526084823"></a><a name="p1868644526084823"></a><strong id="b1561625841084823"><a name="b1561625841084823"></a><a name="b1561625841084823"></a>filename</strong> is null or <strong id="b69154231084823"><a name="b69154231084823"></a><a name="b69154231084823"></a>times</strong> is invalid. </p>
</td>
</tr>
<tr id="row2137824951084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1467350959084823"><a name="p1467350959084823"></a><a name="p1467350959084823"></a>ENAMETOOLONG </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2027825823084823"><a name="p2027825823084823"></a><a name="p2027825823084823"></a>The length of the component in the path name is greater than the value of <a href="utils.md#gac64541bdd81c961304b9babef1402640">NAME_MAX</a>. </p>
</td>
</tr>
<tr id="row1982588138084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1400312450084823"><a name="p1400312450084823"></a><a name="p1400312450084823"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1486896871084823"><a name="p1486896871084823"></a><a name="p1486896871084823"></a>Some paths do not exist. </p>
</td>
</tr>
<tr id="row1830466844084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1855915541084823"><a name="p1855915541084823"></a><a name="p1855915541084823"></a>ENOSYS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p508548310084823"><a name="p508548310084823"></a><a name="p508548310084823"></a>This function is not supported. </p>
</td>
</tr>
<tr id="row501564759084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p129741499084823"><a name="p129741499084823"></a><a name="p129741499084823"></a>EACCES </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2019939711084823"><a name="p2019939711084823"></a><a name="p2019939711084823"></a>The file system is read-only. </p>
</td>
</tr>
<tr id="row794989337084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p44762991084823"><a name="p44762991084823"></a><a name="p44762991084823"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1546464177084823"><a name="p1546464177084823"></a><a name="p1546464177084823"></a>Insufficient memory. </p>
</td>
</tr>
<tr id="row625810355084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p91438543084823"><a name="p91438543084823"></a><a name="p91438543084823"></a>EIO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2013239002084823"><a name="p2013239002084823"></a><a name="p2013239002084823"></a>A hardware error occurs at the underlying disk I/O layer. </p>
</td>
</tr>
</tbody>
</table>

