# Graphic<a name="EN-US_TOPIC_0000001054799551"></a>

## **Overview**<a name="section1460811979093522"></a>

Defines a lightweight graphics system that provides basic UI and container views, including buttons, images, labels, lists, animators, scroll views, swipe views, and layouts. This system also provides the Design for X \(DFX\) capability to implement features such as view rendering, animation, and input event distribution. 

**Since:**

1.0

**Version:**

1.0

## **Summary**<a name="section239838184093522"></a>

## Files<a name="files"></a>

<a name="table2073610239093522"></a>
<table><thead align="left"><tr id="row1039025161093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1257080163093522"><a name="p1257080163093522"></a><a name="p1257080163093522"></a>File Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1889542109093522"><a name="p1889542109093522"></a><a name="p1889542109093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row402647442093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p856993144093522"><a name="p856993144093522"></a><a name="p856993144093522"></a><a href="animator-h.md">animator.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1304097544093522"><a name="p1304097544093522"></a><a name="p1304097544093522"></a>Defines the attributes and common functions of the animator module. </p>
</td>
</tr>
<tr id="row2078152003093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p631393877093522"><a name="p631393877093522"></a><a name="p631393877093522"></a><a href="easing_equation-h.md">easing_equation.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1317693847093522"><a name="p1317693847093522"></a><a name="p1317693847093522"></a>Defines the attributes and functions of the animation easing module. </p>
</td>
</tr>
<tr id="row1045720883093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p821104395093522"><a name="p821104395093522"></a><a name="p821104395093522"></a><a href="interpolation-h.md">interpolation.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1712695556093522"><a name="p1712695556093522"></a><a name="p1712695556093522"></a>Defines the functions for calculating the interpolation in computer graphics. </p>
</td>
</tr>
<tr id="row2102832931093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1274882073093522"><a name="p1274882073093522"></a><a name="p1274882073093522"></a><a href="color-h.md">color.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p655559601093522"><a name="p655559601093522"></a><a name="p655559601093522"></a>Defines color attributes for the graphics system and implements common color functions. </p>
</td>
</tr>
<tr id="row1406542146093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p201049580093522"><a name="p201049580093522"></a><a name="p201049580093522"></a><a href="image-h.md">image.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p215957693093522"><a name="p215957693093522"></a><a name="p215957693093522"></a>Declares basic image attributes, including the image type and path. </p>
</td>
</tr>
<tr id="row432036618093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1204582022093522"><a name="p1204582022093522"></a><a name="p1204582022093522"></a><a href="screen-h.md">screen.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2128677811093522"><a name="p2128677811093522"></a><a name="p2128677811093522"></a>Declares the screen information. </p>
</td>
</tr>
<tr id="row2097781226093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p951874079093522"><a name="p951874079093522"></a><a name="p951874079093522"></a><a href="task-h.md">task.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1666478032093522"><a name="p1666478032093522"></a><a name="p1666478032093522"></a>Declares the <strong id="b1780933215093522"><a name="b1780933215093522"></a><a name="b1780933215093522"></a>Task</strong> class of the graphics module, which provides functions for setting the running period and time of a task. </p>
</td>
</tr>
<tr id="row2086071140093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1651365784093522"><a name="p1651365784093522"></a><a name="p1651365784093522"></a><a href="text-h.md">text.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p789105803093522"><a name="p789105803093522"></a><a name="p789105803093522"></a>Declares the <strong id="b1378947205093522"><a name="b1378947205093522"></a><a name="b1378947205093522"></a>Text</strong> class that provides functions to set basic text attributes, such as the text direction and alignment mode. </p>
</td>
</tr>
<tr id="row419861293093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2086191556093522"><a name="p2086191556093522"></a><a name="p2086191556093522"></a><a href="abstract_adapter-h.md">abstract_adapter.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p434298480093522"><a name="p434298480093522"></a><a name="p434298480093522"></a>Defines the base class for adapters. </p>
</td>
</tr>
<tr id="row667760852093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2028230421093522"><a name="p2028230421093522"></a><a name="p2028230421093522"></a><a href="root_view-h.md">root_view.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1943336463093522"><a name="p1943336463093522"></a><a name="p1943336463093522"></a>Manages a root view. </p>
</td>
</tr>
<tr id="row296320740093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2121727871093522"><a name="p2121727871093522"></a><a name="p2121727871093522"></a><a href="text_adapter-h.md">text_adapter.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1723566887093522"><a name="p1723566887093522"></a><a name="p1723566887093522"></a>Defines a text adapter that is used to construct UILabel instances. </p>
</td>
</tr>
<tr id="row472880915093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1903854290093522"><a name="p1903854290093522"></a><a name="p1903854290093522"></a><a href="ui_abstract_clock-h.md">ui_abstract_clock.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1234191287093522"><a name="p1234191287093522"></a><a name="p1234191287093522"></a>Declares the <strong id="b355130830093522"><a name="b355130830093522"></a><a name="b355130830093522"></a>UIAbstractClock</strong> class that provides the functions related to clocks. </p>
</td>
</tr>
<tr id="row187925794093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1985303183093522"><a name="p1985303183093522"></a><a name="p1985303183093522"></a><a href="ui_abstract_progress-h.md">ui_abstract_progress.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p346724714093522"><a name="p346724714093522"></a><a name="p346724714093522"></a>Defines the base class attributes and common functions of a progress bar. </p>
</td>
</tr>
<tr id="row1863413252093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1546256958093522"><a name="p1546256958093522"></a><a name="p1546256958093522"></a><a href="ui_abstract_scroll-h.md">ui_abstract_scroll.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p568109063093522"><a name="p568109063093522"></a><a name="p568109063093522"></a>Declares the base class used to define the attributes of a scroll. The <strong id="b1827062811093522"><a name="b1827062811093522"></a><a name="b1827062811093522"></a>UIList</strong>, <strong id="b413207619093522"><a name="b413207619093522"></a><a name="b413207619093522"></a>UIScrollView</strong>, and <strong id="b1176438630093522"><a name="b1176438630093522"></a><a name="b1176438630093522"></a>UISwipeView</strong> inherit from this class. </p>
</td>
</tr>
<tr id="row1123354754093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1289015226093522"><a name="p1289015226093522"></a><a name="p1289015226093522"></a><a href="ui_analog_clock-h.md">ui_analog_clock.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p177198821093522"><a name="p177198821093522"></a><a name="p177198821093522"></a>Declares an analog clock. </p>
</td>
</tr>
<tr id="row1034016422093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1245747877093522"><a name="p1245747877093522"></a><a name="p1245747877093522"></a><a href="ui_arc_label-h.md">ui_arc_label.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1230120781093522"><a name="p1230120781093522"></a><a name="p1230120781093522"></a>Defines the attributes of an arc label. </p>
</td>
</tr>
<tr id="row1166224858093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1383094083093522"><a name="p1383094083093522"></a><a name="p1383094083093522"></a><a href="ui_axis-h.md">ui_axis.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1914949534093522"><a name="p1914949534093522"></a><a name="p1914949534093522"></a>Defines the attributes and functions of the x- and y-axises. This class is used in <strong id="b649126388093522"><a name="b649126388093522"></a><a name="b649126388093522"></a>UIChart</strong>. </p>
</td>
</tr>
<tr id="row1601960278093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p241611781093522"><a name="p241611781093522"></a><a name="p241611781093522"></a><a href="ui_box_progress-h.md">ui_box_progress.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1693834127093522"><a name="p1693834127093522"></a><a name="p1693834127093522"></a>Defines the attributes and common functions of a linear progress bar. </p>
</td>
</tr>
<tr id="row1795342825093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p975545720093522"><a name="p975545720093522"></a><a name="p975545720093522"></a><a href="ui_button-h.md">ui_button.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1489318231093522"><a name="p1489318231093522"></a><a name="p1489318231093522"></a>Defines the attributes and common functions of a button. </p>
</td>
</tr>
<tr id="row555496647093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2102328798093522"><a name="p2102328798093522"></a><a name="p2102328798093522"></a><a href="ui_canvas-h.md">ui_canvas.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p146540463093522"><a name="p146540463093522"></a><a name="p146540463093522"></a>Defines the attributes of the canvas component and provides functions for drawing rectangles, circles, and others. </p>
</td>
</tr>
<tr id="row489336741093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1119050479093522"><a name="p1119050479093522"></a><a name="p1119050479093522"></a><a href="ui_chart-h.md">ui_chart.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p28984048093522"><a name="p28984048093522"></a><a name="p28984048093522"></a>Defines the attributes of the chart component and provides functions for adding and deleting data sets to display a chart. </p>
</td>
</tr>
<tr id="row930895283093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p219492041093522"><a name="p219492041093522"></a><a name="p219492041093522"></a><a href="ui_checkbox-h.md">ui_checkbox.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1668315757093522"><a name="p1668315757093522"></a><a name="p1668315757093522"></a>Defines the attributes and common functions of a check box. </p>
</td>
</tr>
<tr id="row385147595093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p172299737093522"><a name="p172299737093522"></a><a name="p172299737093522"></a><a href="ui_circle_progress-h.md">ui_circle_progress.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p29121852093522"><a name="p29121852093522"></a><a name="p29121852093522"></a>Defines the attributes and common functions of a circular progress bar. </p>
</td>
</tr>
<tr id="row709554396093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1106991444093522"><a name="p1106991444093522"></a><a name="p1106991444093522"></a><a href="ui_dialog-h.md">ui_dialog.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1260143164093522"><a name="p1260143164093522"></a><a name="p1260143164093522"></a>Declares the UIDialog class that defines the dialog box component. </p>
</td>
</tr>
<tr id="row953870986093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1973965601093522"><a name="p1973965601093522"></a><a name="p1973965601093522"></a><a href="ui_digital_clock-h.md">ui_digital_clock.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2096041398093522"><a name="p2096041398093522"></a><a name="p2096041398093522"></a>Declares a digital clock. </p>
</td>
</tr>
<tr id="row441868481093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p516728094093522"><a name="p516728094093522"></a><a name="p516728094093522"></a><a href="ui_image_animator-h.md">ui_image_animator.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p157144294093522"><a name="p157144294093522"></a><a name="p157144294093522"></a>Defines the attributes and functions of an image animator. </p>
</td>
</tr>
<tr id="row1762977909093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1878369534093522"><a name="p1878369534093522"></a><a name="p1878369534093522"></a><a href="ui_image_view-h.md">ui_image_view.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1837565837093522"><a name="p1837565837093522"></a><a name="p1837565837093522"></a>Declares an image view. </p>
</td>
</tr>
<tr id="row1796034669093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p759237522093522"><a name="p759237522093522"></a><a name="p759237522093522"></a><a href="ui_label-h.md">ui_label.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p170870461093522"><a name="p170870461093522"></a><a name="p170870461093522"></a>Declares a <strong id="b1984360307093522"><a name="b1984360307093522"></a><a name="b1984360307093522"></a>UILabel</strong> class that represents a label. </p>
</td>
</tr>
<tr id="row1216016729093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1058466947093522"><a name="p1058466947093522"></a><a name="p1058466947093522"></a><a href="ui_label_button-h.md">ui_label_button.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p129219285093522"><a name="p129219285093522"></a><a name="p129219285093522"></a>Declares a label button. </p>
</td>
</tr>
<tr id="row1725595051093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p977323166093522"><a name="p977323166093522"></a><a name="p977323166093522"></a><a href="ui_list-h.md">ui_list.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1170513908093522"><a name="p1170513908093522"></a><a name="p1170513908093522"></a>Declares a scrollable list in the vertical or horizontal direction. * This scrollable list can be used with the adapter <strong id="b1617345624093522"><a name="b1617345624093522"></a><a name="b1617345624093522"></a>AbstractAdapter</strong> to implement scrolling, inertial scrolling, automatic alignment, and invoking of a callback when a child view at the preset position is selected as this list scrolls. It is used when there is a large number of child views with a fixed format. </p>
</td>
</tr>
<tr id="row2012123412093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1764668948093522"><a name="p1764668948093522"></a><a name="p1764668948093522"></a><a href="ui_picker-h.md">ui_picker.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1437763076093522"><a name="p1437763076093522"></a><a name="p1437763076093522"></a>Defines the attributes and functions of the <strong id="b2094281493093522"><a name="b2094281493093522"></a><a name="b2094281493093522"></a>UIPicker</strong> class. </p>
</td>
</tr>
<tr id="row1204266919093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p180815937093522"><a name="p180815937093522"></a><a name="p180815937093522"></a><a href="ui_radiobutton-h.md">ui_radiobutton.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p592676549093522"><a name="p592676549093522"></a><a name="p592676549093522"></a>Defines the attributes and common functions of a radio button. </p>
</td>
</tr>
<tr id="row1522634006093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1422092479093522"><a name="p1422092479093522"></a><a name="p1422092479093522"></a><a href="ui_scroll_view-h.md">ui_scroll_view.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p447709271093522"><a name="p447709271093522"></a><a name="p447709271093522"></a>Declares a view group that allows its child views to be displayed as scroll events occur. </p>
</td>
</tr>
<tr id="row821982219093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p936661424093522"><a name="p936661424093522"></a><a name="p936661424093522"></a><a href="ui_slider-h.md">ui_slider.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2045805473093522"><a name="p2045805473093522"></a><a name="p2045805473093522"></a>Defines the attributes and common functions of a slider. </p>
</td>
</tr>
<tr id="row1364501264093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p549872707093522"><a name="p549872707093522"></a><a name="p549872707093522"></a><a href="ui_surface_view-h.md">ui_surface_view.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1319002941093522"><a name="p1319002941093522"></a><a name="p1319002941093522"></a>Declares the surface view that interacts with the multimedia to achieve camera preview and video playback. </p>
</td>
</tr>
<tr id="row2041361733093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1458069403093522"><a name="p1458069403093522"></a><a name="p1458069403093522"></a><a href="ui_swipe_view-h.md">ui_swipe_view.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1866250432093522"><a name="p1866250432093522"></a><a name="p1866250432093522"></a>Defines the attributes and common functions of a swipe view. </p>
</td>
</tr>
<tr id="row665771742093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p937290401093522"><a name="p937290401093522"></a><a name="p937290401093522"></a><a href="ui_texture_mapper-h.md">ui_texture_mapper.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1728821850093522"><a name="p1728821850093522"></a><a name="p1728821850093522"></a>Defines the attributes and functions of a texture mapper. </p>
</td>
</tr>
<tr id="row2098300986093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p653722639093522"><a name="p653722639093522"></a><a name="p653722639093522"></a><a href="ui_time_picker-h.md">ui_time_picker.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p238882314093522"><a name="p238882314093522"></a><a name="p238882314093522"></a>Defines the attributes and functions of the <strong id="b2013194745093522"><a name="b2013194745093522"></a><a name="b2013194745093522"></a>UITimePicker</strong> class. </p>
</td>
</tr>
<tr id="row524421722093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2091607613093522"><a name="p2091607613093522"></a><a name="p2091607613093522"></a><a href="ui_toggle_button-h.md">ui_toggle_button.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p170387198093522"><a name="p170387198093522"></a><a name="p170387198093522"></a>Defines the attributes and common functions of a toggle button. </p>
</td>
</tr>
<tr id="row2067554383093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p877058965093522"><a name="p877058965093522"></a><a name="p877058965093522"></a><a href="ui_view-h.md">ui_view.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1952831647093522"><a name="p1952831647093522"></a><a name="p1952831647093522"></a>Declares the base class of a view, providing basic view attributes and operations. All views are derived from this class. </p>
</td>
</tr>
<tr id="row1571382981093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p416152480093522"><a name="p416152480093522"></a><a name="p416152480093522"></a><a href="ui_view_group-h.md">ui_view_group.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1143987996093522"><a name="p1143987996093522"></a><a name="p1143987996093522"></a>Declares a view group. </p>
</td>
</tr>
<tr id="row480642021093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1415642735093522"><a name="p1415642735093522"></a><a name="p1415642735093522"></a><a href="event_injector-h.md">event_injector.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p486583197093522"><a name="p486583197093522"></a><a name="p486583197093522"></a>Declares the function for simulating input events. </p>
</td>
</tr>
<tr id="row493333665093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1310003298093522"><a name="p1310003298093522"></a><a name="p1310003298093522"></a><a href="ui_dump_dom_tree-h.md">ui_dump_dom_tree.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p154681196093522"><a name="p154681196093522"></a><a name="p154681196093522"></a>Declares a function for exporting information about a Document Object Model (DOM) tree or DOM node. </p>
</td>
</tr>
<tr id="row1016001768093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1581293288093522"><a name="p1581293288093522"></a><a name="p1581293288093522"></a><a href="ui_screenshot-h.md">ui_screenshot.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p771359097093522"><a name="p771359097093522"></a><a name="p771359097093522"></a>Declares the screenshot function. </p>
</td>
</tr>
<tr id="row1918887441093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1136519967093522"><a name="p1136519967093522"></a><a name="p1136519967093522"></a><a href="aod_callback-h.md">aod_callback.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p119037577093522"><a name="p119037577093522"></a><a name="p119037577093522"></a>Defines the callback for the touch event notification in screen-off mode. </p>
</td>
</tr>
<tr id="row444225853093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2043403483093522"><a name="p2043403483093522"></a><a name="p2043403483093522"></a><a href="cancel_event-h.md">cancel_event.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1652053131093522"><a name="p1652053131093522"></a><a name="p1652053131093522"></a>Declares a cancel event, which usually occurs when the target view changes due to user sliding. For example, this event is triggered if you, after pressing a button, does not release the button but slides. </p>
</td>
</tr>
<tr id="row1915173206093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p80743263093522"><a name="p80743263093522"></a><a name="p80743263093522"></a><a href="click_event-h.md">click_event.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1671730687093522"><a name="p1671730687093522"></a><a name="p1671730687093522"></a>Declares a click event, which indicates that a finger is pressed on the screen and then lifted within 1 second. </p>
</td>
</tr>
<tr id="row456320976093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1818359975093522"><a name="p1818359975093522"></a><a name="p1818359975093522"></a><a href="drag_event-h.md">drag_event.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1068411235093522"><a name="p1068411235093522"></a><a name="p1068411235093522"></a>Declares a drag event, which indicates a certain movement (more than 10 pixels) after a view is pressed. </p>
</td>
</tr>
<tr id="row812380566093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1753969802093522"><a name="p1753969802093522"></a><a name="p1753969802093522"></a><a href="event-h.md">event.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p425698760093522"><a name="p425698760093522"></a><a name="p425698760093522"></a>Declares the base class of a user input event and provides functions to record information such as the event position and timestamp. </p>
</td>
</tr>
<tr id="row856524693093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1614107832093522"><a name="p1614107832093522"></a><a name="p1614107832093522"></a><a href="key_event-h.md">key_event.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1740732140093522"><a name="p1740732140093522"></a><a name="p1740732140093522"></a>Declares a key event, which indicates that a physical button is pressed or released. </p>
</td>
</tr>
<tr id="row1208292437093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1388914041093522"><a name="p1388914041093522"></a><a name="p1388914041093522"></a><a href="long_press_event-h.md">long_press_event.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1855512565093522"><a name="p1855512565093522"></a><a name="p1855512565093522"></a>Declares a long-press event, which indicates that the finger is not raised or moved within 1 second after a view is pressed. </p>
</td>
</tr>
<tr id="row921298590093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1699371018093522"><a name="p1699371018093522"></a><a name="p1699371018093522"></a><a href="press_event-h.md">press_event.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p5262746093522"><a name="p5262746093522"></a><a name="p5262746093522"></a>Declares a touch event, which indicates that the touchscreen or mouse is pressed. </p>
</td>
</tr>
<tr id="row1608431035093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p69195927093522"><a name="p69195927093522"></a><a name="p69195927093522"></a><a href="release_event-h.md">release_event.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p594584257093522"><a name="p594584257093522"></a><a name="p594584257093522"></a>Declares a release event, which indicates that the touchscreen or mouse is released. </p>
</td>
</tr>
<tr id="row1094958052093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p907238979093522"><a name="p907238979093522"></a><a name="p907238979093522"></a><a href="virtual_device_event-h.md">virtual_device_event.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p739544109093522"><a name="p739544109093522"></a><a name="p739544109093522"></a>Declares a virtual device event, which is used to receive a customized input event and call back the listening function registered. </p>
</td>
</tr>
<tr id="row1885577119093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p827827311093522"><a name="p827827311093522"></a><a name="p827827311093522"></a><a href="geometry2d-h.md">geometry2d.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1673770258093522"><a name="p1673770258093522"></a><a name="p1673770258093522"></a>Defines attributes of 2D geometries (including points, lines, rectangles, and polygons) of the lightweight graphics system and provides functions for performing operations on the geometries. </p>
</td>
</tr>
<tr id="row275731493093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1509201301093522"><a name="p1509201301093522"></a><a name="p1509201301093522"></a><a href="graphic_assert-h.md">graphic_assert.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1351342166093522"><a name="p1351342166093522"></a><a name="p1351342166093522"></a>Declares the assertion utility for the graphics module. </p>
</td>
</tr>
<tr id="row521984630093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1232043237093522"><a name="p1232043237093522"></a><a name="p1232043237093522"></a><a href="graphic_config-h.md">graphic_config.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1945205182093522"><a name="p1945205182093522"></a><a name="p1945205182093522"></a>Provides configuration items required for graphics. </p>
</td>
</tr>
<tr id="row1058995893093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1541732158093522"><a name="p1541732158093522"></a><a name="p1541732158093522"></a><a href="graphic_math-h.md">graphic_math.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1834580693093522"><a name="p1834580693093522"></a><a name="p1834580693093522"></a>Defines mathematical operation functions and types, including trigonometric functions, two-dimensional vectors, three-dimensional vectors, and matrices. </p>
</td>
</tr>
<tr id="row951585481093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1311709472093522"><a name="p1311709472093522"></a><a name="p1311709472093522"></a><a href="graphic_types-h.md">graphic_types.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1345888838093522"><a name="p1345888838093522"></a><a name="p1345888838093522"></a>Defines the common data types for the graphics system. </p>
</td>
</tr>
<tr id="row499352326093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p750623529093522"><a name="p750623529093522"></a><a name="p750623529093522"></a><a href="heap_base-h.md">heap_base.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1532716152093522"><a name="p1532716152093522"></a><a name="p1532716152093522"></a>Declares the functions for overriding the <strong id="b153397372093522"><a name="b153397372093522"></a><a name="b153397372093522"></a>new</strong> and <strong id="b59672802093522"><a name="b59672802093522"></a><a name="b59672802093522"></a>delete</strong> functions. </p>
</td>
</tr>
<tr id="row1777453071093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p481652922093522"><a name="p481652922093522"></a><a name="p481652922093522"></a><a href="image_info-h.md">image_info.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1014763906093522"><a name="p1014763906093522"></a><a name="p1014763906093522"></a>Defines image information. </p>
</td>
</tr>
<tr id="row1811849178093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1618554979093522"><a name="p1618554979093522"></a><a name="p1618554979093522"></a><a href="flex_layout-h.md">flex_layout.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1164531639093522"><a name="p1164531639093522"></a><a name="p1164531639093522"></a>Declares a flexible layout container. You can perform simple adaptive layout on child views that the container holds, for example, to evenly arrange all child views in the same row or column. </p>
</td>
</tr>
<tr id="row537850672093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p395638363093522"><a name="p395638363093522"></a><a name="p395638363093522"></a><a href="grid_layout-h.md">grid_layout.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p603148773093522"><a name="p603148773093522"></a><a name="p603148773093522"></a>Declares a grid layout container. You can perform simple grid layout on child views that the container holds. </p>
</td>
</tr>
<tr id="row1944258874093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1931807313093522"><a name="p1931807313093522"></a><a name="p1931807313093522"></a><a href="layout-h.md">layout.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p278805223093522"><a name="p278805223093522"></a><a name="p278805223093522"></a>Declares the base class of the layout, which indicates the basic data types and operations that may be used in the layout. </p>
</td>
</tr>
<tr id="row1892319336093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1279231666093522"><a name="p1279231666093522"></a><a name="p1279231666093522"></a><a href="list-h.md">list.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2054539657093522"><a name="p2054539657093522"></a><a name="p2054539657093522"></a>Defines a linked list template class, which implements the data structure of bidirectional linked list and provides basic functions such as adding, deleting, inserting, clearing, popping up, and obtaining the size of the linked list. </p>
</td>
</tr>
<tr id="row912538856093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1452364539093522"><a name="p1452364539093522"></a><a name="p1452364539093522"></a><a href="mem_api-h.md">mem_api.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p326562243093522"><a name="p326562243093522"></a><a name="p326562243093522"></a>Defines the functions for memory application and release. You can implement the <strong id="b588488646093522"><a name="b588488646093522"></a><a name="b588488646093522"></a>malloc</strong> and <strong id="b1458809523093522"><a name="b1458809523093522"></a><a name="b1458809523093522"></a>free</strong> functions to manage the memory. </p>
</td>
</tr>
<tr id="row767547527093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p8726189093522"><a name="p8726189093522"></a><a name="p8726189093522"></a><a href="rect-h.md">rect.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p62896400093522"><a name="p62896400093522"></a><a name="p62896400093522"></a>Defines a rectangle, including the position data of the four boundaries of the rectangle, and provides functions for rectangle inclusion, intersection, and aggregation. </p>
</td>
</tr>
<tr id="row341180732093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1920206157093522"><a name="p1920206157093522"></a><a name="p1920206157093522"></a><a href="style-h.md">style.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1827191804093522"><a name="p1827191804093522"></a><a name="p1827191804093522"></a>Defines the attributes and common functions of style. </p>
</td>
</tr>
<tr id="row358670137093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p653828929093522"><a name="p653828929093522"></a><a name="p653828929093522"></a><a href="sys_info-h.md">sys_info.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1438123970093522"><a name="p1438123970093522"></a><a name="p1438123970093522"></a>Declares the system information about the graphics module, including the function to obtain the information about FPS, which needs to be enabled by the <strong id="b311958218093522"><a name="b311958218093522"></a><a name="b311958218093522"></a>ENABLE_FPS_SUPPORT</strong> macro. </p>
</td>
</tr>
<tr id="row681631612093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1109957535093522"><a name="p1109957535093522"></a><a name="p1109957535093522"></a><a href="theme-h.md">theme.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1201024363093522"><a name="p1201024363093522"></a><a name="p1201024363093522"></a>Declares the base class used to define the functions related to the styles of different components. </p>
</td>
</tr>
<tr id="row1119302404093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1353296969093522"><a name="p1353296969093522"></a><a name="p1353296969093522"></a><a href="theme_manager-h.md">theme_manager.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p797676060093522"><a name="p797676060093522"></a><a name="p797676060093522"></a>Declares the singleton class used to manage the current screen theme of an application. </p>
</td>
</tr>
<tr id="row1964760073093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1504626573093522"><a name="p1504626573093522"></a><a name="p1504626573093522"></a><a href="transform-h.md">transform.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p826898728093522"><a name="p826898728093522"></a><a name="p826898728093522"></a>Provides functions to transform components, points, and line segments, including rotation and scaling. </p>
</td>
</tr>
</tbody>
</table>

## Data Structures<a name="nested-classes"></a>

<a name="table472862877093522"></a>
<table><thead align="left"><tr id="row613139938093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1606546026093522"><a name="p1606546026093522"></a><a name="p1606546026093522"></a>Data Structure Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p411372183093522"><a name="p411372183093522"></a><a name="p411372183093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1093509367093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p108431616093522"><a name="p108431616093522"></a><a name="p108431616093522"></a><a href="ohos-animatorcallback.md">OHOS::AnimatorCallback</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p675916265093522"><a name="p675916265093522"></a><a name="p675916265093522"></a>Represents the animator callback. </p>
</td>
</tr>
<tr id="row904172753093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1654195439093522"><a name="p1654195439093522"></a><a name="p1654195439093522"></a><a href="ohos-animator.md">OHOS::Animator</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p22842652093522"><a name="p22842652093522"></a><a name="p22842652093522"></a>Represents an animator. </p>
</td>
</tr>
<tr id="row177755409093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p104850626093522"><a name="p104850626093522"></a><a name="p104850626093522"></a><a href="ohos-animatormanager.md">OHOS::AnimatorManager</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1084755330093522"><a name="p1084755330093522"></a><a name="p1084755330093522"></a>Represents the animator manager. </p>
</td>
</tr>
<tr id="row1331050407093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p823696107093522"><a name="p823696107093522"></a><a name="p823696107093522"></a><a href="ohos-easingequation.md">OHOS::EasingEquation</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p143016121093522"><a name="p143016121093522"></a><a name="p143016121093522"></a>Defines functions for specifying the velocity of an animation. </p>
</td>
</tr>
<tr id="row1496776915093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2092715977093522"><a name="p2092715977093522"></a><a name="p2092715977093522"></a><a href="ohos-interpolation.md">OHOS::Interpolation</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p846817275093522"><a name="p846817275093522"></a><a name="p846817275093522"></a>Calculates the Bezier interpolation. </p>
</td>
</tr>
<tr id="row1445349470093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p771786279093522"><a name="p771786279093522"></a><a name="p771786279093522"></a><a href="ohos-color16.md">OHOS::Color16</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1478836437093522"><a name="p1478836437093522"></a><a name="p1478836437093522"></a>Defines the color attribute when the color depth is <strong id="b983199769093522"><a name="b983199769093522"></a><a name="b983199769093522"></a>16</strong>. </p>
</td>
</tr>
<tr id="row1783629537093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2134236078093522"><a name="p2134236078093522"></a><a name="p2134236078093522"></a><a href="ohos-color24.md">OHOS::Color24</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1512585414093522"><a name="p1512585414093522"></a><a name="p1512585414093522"></a>Defines the color attribute when the color depth is <strong id="b1528100165093522"><a name="b1528100165093522"></a><a name="b1528100165093522"></a>24</strong>. </p>
</td>
</tr>
<tr id="row660568334093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p39288338093522"><a name="p39288338093522"></a><a name="p39288338093522"></a><a href="ohos-color32.md">OHOS::Color32</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p968430672093522"><a name="p968430672093522"></a><a name="p968430672093522"></a>Defines the color attribute when the color depth is <strong id="b971851664093522"><a name="b971851664093522"></a><a name="b971851664093522"></a>32</strong>. </p>
</td>
</tr>
<tr id="row1322785436093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1913942244093522"><a name="p1913942244093522"></a><a name="p1913942244093522"></a><a href="ohos-color.md">OHOS::Color</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p714564756093522"><a name="p714564756093522"></a><a name="p714564756093522"></a>Converts colors in different formats and defines common colors. </p>
</td>
</tr>
<tr id="row856116220093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1952729430093522"><a name="p1952729430093522"></a><a name="p1952729430093522"></a><a href="ohos-image.md">OHOS::Image</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p562280454093522"><a name="p562280454093522"></a><a name="p562280454093522"></a>Represents basic image attributes, including the image type and path. </p>
</td>
</tr>
<tr id="row660879277093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p935741887093522"><a name="p935741887093522"></a><a name="p935741887093522"></a><a href="ohos-screen.md">OHOS::Screen</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1104223792093522"><a name="p1104223792093522"></a><a name="p1104223792093522"></a>Represents the screen info of the device. </p>
</td>
</tr>
<tr id="row994443530093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1328027301093522"><a name="p1328027301093522"></a><a name="p1328027301093522"></a><a href="ohos-task.md">OHOS::Task</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p861833048093522"><a name="p861833048093522"></a><a name="p861833048093522"></a>Represents the <strong id="b285099595093522"><a name="b285099595093522"></a><a name="b285099595093522"></a><a href="ohos-task.md">Task</a></strong> class of the graphics module. This class provides functions for setting the running period and time of a task. </p>
</td>
</tr>
<tr id="row334494878093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1296544974093522"><a name="p1296544974093522"></a><a name="p1296544974093522"></a><a href="ohos-text.md">OHOS::Text</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1683603458093522"><a name="p1683603458093522"></a><a name="p1683603458093522"></a>Represents the base class of <strong id="b820205749093522"><a name="b820205749093522"></a><a name="b820205749093522"></a><a href="ohos-text.md">Text</a></strong>, providing the text attribute setting and text drawing capabilities for components that require font display. </p>
</td>
</tr>
<tr id="row1215169202093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2122744312093522"><a name="p2122744312093522"></a><a name="p2122744312093522"></a><a href="ohos-abstractadapter.md">OHOS::AbstractAdapter</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1567702225093522"><a name="p1567702225093522"></a><a name="p1567702225093522"></a>Defines the base class for adapters. You can derive <strong id="b2052460788093522"><a name="b2052460788093522"></a><a name="b2052460788093522"></a><a href="ohos-abstractadapter.md">AbstractAdapter</a></strong> based on actual requirements and use the <strong id="b1648038049093522"><a name="b1648038049093522"></a><a name="b1648038049093522"></a><a href="graphic.md#gab155b2f4a6d8fd97755dcd1e6d3d8361">GetView()</a></strong> and <strong id="b1056743889093522"><a name="b1056743889093522"></a><a name="b1056743889093522"></a><a href="graphic.md#ga67021b360d4097c475d5e24519b5276d">GetCount()</a></strong> functions to implement adapters of different data types. For details, see <a href="ohos-textadapter.md">TextAdapter</a>. </p>
</td>
</tr>
<tr id="row847939340093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1398975316093522"><a name="p1398975316093522"></a><a name="p1398975316093522"></a><a href="ohos-rootview-onkeyactlistener.md">OHOS::RootView::OnKeyActListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p163758562093522"><a name="p163758562093522"></a><a name="p163758562093522"></a>Represents the listener for monitoring physical key events. </p>
</td>
</tr>
<tr id="row1298899300093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2063066431093522"><a name="p2063066431093522"></a><a name="p2063066431093522"></a><a href="ohos-rootview-onvirtualdeviceeventlistener.md">OHOS::RootView::OnVirtualDeviceEventListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2001327824093522"><a name="p2001327824093522"></a><a name="p2001327824093522"></a>Listens for the input events triggered by a virtual device other than human touching or physical pressing. </p>
</td>
</tr>
<tr id="row1615423681093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2078427505093522"><a name="p2078427505093522"></a><a name="p2078427505093522"></a><a href="ohos-rootview.md">OHOS::RootView</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p782446898093522"><a name="p782446898093522"></a><a name="p782446898093522"></a>Defines the functions related to a root view which contains its child views and represents the root node in a tree structure. </p>
</td>
</tr>
<tr id="row654034205093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1280543991093522"><a name="p1280543991093522"></a><a name="p1280543991093522"></a><a href="ohos-textformatter.md">OHOS::TextFormatter</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1867096985093522"><a name="p1867096985093522"></a><a name="p1867096985093522"></a>Defines a text formatter. You can inherit this class and implement the <strong id="b1215875183093522"><a name="b1215875183093522"></a><a name="b1215875183093522"></a><a href="graphic.md#ga183cac282667493fa2a008f9a7f4f9d2">Format()</a></strong> function. </p>
</td>
</tr>
<tr id="row798072069093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p873499518093522"><a name="p873499518093522"></a><a name="p873499518093522"></a><a href="ohos-textadapter.md">OHOS::TextAdapter</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p734277219093522"><a name="p734277219093522"></a><a name="p734277219093522"></a>Defines a text adapter, which implements <a href="ohos-uilabel.md">UILabel</a> instance construction and supports text data and continuous integer data. </p>
</td>
</tr>
<tr id="row179879565093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1325893010093522"><a name="p1325893010093522"></a><a name="p1325893010093522"></a><a href="ohos-uiabstractclock.md">OHOS::UIAbstractClock</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1519528880093522"><a name="p1519528880093522"></a><a name="p1519528880093522"></a>An abstract class that contains functions for converting units of time (hour, minute, and second), setting and obtaining the time. </p>
</td>
</tr>
<tr id="row167538732093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p994816495093522"><a name="p994816495093522"></a><a name="p994816495093522"></a><a href="ohos-uiabstractprogress.md">OHOS::UIAbstractProgress</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p395009682093522"><a name="p395009682093522"></a><a name="p395009682093522"></a>Represents the abstract base class which provides functions related to the progress bar. </p>
</td>
</tr>
<tr id="row1177622557093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p821935738093522"><a name="p821935738093522"></a><a name="p821935738093522"></a><a href="ohos-uiabstractscroll.md">OHOS::UIAbstractScroll</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1479822831093522"><a name="p1479822831093522"></a><a name="p1479822831093522"></a>Defines the attributes of a scroll, including the scroll direction, blank size of a scroll view, velocity and effects of a scroll animation. </p>
</td>
</tr>
<tr id="row1853643899093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p678178165093522"><a name="p678178165093522"></a><a name="p678178165093522"></a><a href="ohos-uianalogclock-hand.md">OHOS::UIAnalogClock::Hand</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p370247466093522"><a name="p370247466093522"></a><a name="p370247466093522"></a>Defines the basic attributes of the analog clock hands. This is an inner class of <strong id="b35824943093522"><a name="b35824943093522"></a><a name="b35824943093522"></a><a href="ohos-uiabstractclock.md">UIAbstractClock</a></strong>. </p>
</td>
</tr>
<tr id="row1836515610093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1620237790093522"><a name="p1620237790093522"></a><a name="p1620237790093522"></a><a href="ohos-uianalogclock.md">OHOS::UIAnalogClock</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p714736159093522"><a name="p714736159093522"></a><a name="p714736159093522"></a>Provides the functions related to an analog clock. </p>
</td>
</tr>
<tr id="row713190445093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p243268687093522"><a name="p243268687093522"></a><a name="p243268687093522"></a><a href="ohos-uiarclabel-arctextinfo.md">OHOS::UIArcLabel::ArcTextInfo</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p895125004093522"><a name="p895125004093522"></a><a name="p895125004093522"></a>Stores the attribute information about this arc text to draw. </p>
</td>
</tr>
<tr id="row1537367499093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1255529712093522"><a name="p1255529712093522"></a><a name="p1255529712093522"></a><a href="ohos-uiarclabel.md">OHOS::UIArcLabel</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1709779877093522"><a name="p1709779877093522"></a><a name="p1709779877093522"></a>Defines functions related to an arc label. </p>
</td>
</tr>
<tr id="row114347625093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1361397161093522"><a name="p1361397161093522"></a><a name="p1361397161093522"></a><a href="ohos-uiaxis.md">OHOS::UIAxis</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2044425440093522"><a name="p2044425440093522"></a><a name="p2044425440093522"></a>Represents the coordinate axis base class, which defines the basic attributes of coordinate axis, sets whether a coordinate axis is visible, and sets the number of scales on a coordinate axis. This class is used in <a href="ohos-uichart.md">UIChart</a>. </p>
</td>
</tr>
<tr id="row640113255093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1764117412093522"><a name="p1764117412093522"></a><a name="p1764117412093522"></a><a href="ohos-uixaxis.md">OHOS::UIXAxis</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1306607064093522"><a name="p1306607064093522"></a><a name="p1306607064093522"></a>Defines the unique attributes and functions for the x-axis. This class is used in <a href="ohos-uichart.md">UIChart</a>. </p>
</td>
</tr>
<tr id="row1027144541093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p567357541093522"><a name="p567357541093522"></a><a name="p567357541093522"></a><a href="ohos-uiyaxis.md">OHOS::UIYAxis</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p770272344093522"><a name="p770272344093522"></a><a name="p770272344093522"></a>Defines the unique attributes and functions for the y-axis. This class is used in <a href="ohos-uichart.md">UIChart</a>. </p>
</td>
</tr>
<tr id="row308502400093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1396776038093522"><a name="p1396776038093522"></a><a name="p1396776038093522"></a><a href="ohos-uiboxprogress.md">OHOS::UIBoxProgress</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2133728799093522"><a name="p2133728799093522"></a><a name="p2133728799093522"></a>Represents a linear progress bar. </p>
</td>
</tr>
<tr id="row1225668001093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1588986870093522"><a name="p1588986870093522"></a><a name="p1588986870093522"></a><a href="ohos-uibutton.md">OHOS::UIButton</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p786199441093522"><a name="p786199441093522"></a><a name="p786199441093522"></a>Represents a button. </p>
</td>
</tr>
<tr id="row1254618202093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p474222687093522"><a name="p474222687093522"></a><a name="p474222687093522"></a><a href="ohos-paint.md">OHOS::Paint</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1870252347093522"><a name="p1870252347093522"></a><a name="p1870252347093522"></a>Defines the basic styles of graphs drawn on canvases. </p>
</td>
</tr>
<tr id="row405774080093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1973343967093522"><a name="p1973343967093522"></a><a name="p1973343967093522"></a><a href="ohos-uicanvas-fontstyle.md">OHOS::UICanvas::FontStyle</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1667470476093522"><a name="p1667470476093522"></a><a name="p1667470476093522"></a>Defines the font style. </p>
</td>
</tr>
<tr id="row499505396093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1189243605093522"><a name="p1189243605093522"></a><a name="p1189243605093522"></a><a href="ohos-uicanvas.md">OHOS::UICanvas</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p257524961093522"><a name="p257524961093522"></a><a name="p257524961093522"></a>Defines a canvas, which is used to draw multiple types of 2D graphs. </p>
</td>
</tr>
<tr id="row923188710093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1775458550093522"><a name="p1775458550093522"></a><a name="p1775458550093522"></a><a href="ohos-uichartdataserial-pointstyle.md">OHOS::UIChartDataSerial::PointStyle</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1303244557093522"><a name="p1303244557093522"></a><a name="p1303244557093522"></a>Defines the style for the top, bottom, and frontmost points in a line chart. </p>
</td>
</tr>
<tr id="row350166739093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1487595911093522"><a name="p1487595911093522"></a><a name="p1487595911093522"></a><a href="ohos-uichartdataserial.md">OHOS::UIChartDataSerial</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p73037585093522"><a name="p73037585093522"></a><a name="p73037585093522"></a>Defines a data set and provides functions such as adding and deleting data points. </p>
</td>
</tr>
<tr id="row1171536221093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p63587694093522"><a name="p63587694093522"></a><a name="p63587694093522"></a><a href="ohos-uichart.md">OHOS::UIChart</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p374090873093522"><a name="p374090873093522"></a><a name="p374090873093522"></a>Defines the chart class and provides functions such as adding and deleting data sets to display a chart. </p>
</td>
</tr>
<tr id="row620089339093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1945629352093522"><a name="p1945629352093522"></a><a name="p1945629352093522"></a><a href="ohos-uichartpillar.md">OHOS::UIChartPillar</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p532186162093522"><a name="p532186162093522"></a><a name="p532186162093522"></a>Provides special functions for implementing a bar chart. </p>
</td>
</tr>
<tr id="row293450539093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p733661289093522"><a name="p733661289093522"></a><a name="p733661289093522"></a><a href="ohos-uichartpolyline.md">OHOS::UIChartPolyline</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2118170084093522"><a name="p2118170084093522"></a><a name="p2118170084093522"></a>Provides special functions for implementing a polyline. </p>
</td>
</tr>
<tr id="row1121441226093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p482437274093522"><a name="p482437274093522"></a><a name="p482437274093522"></a><a href="ohos-uicheckbox-onchangelistener.md">OHOS::UICheckBox::OnChangeListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p35256807093522"><a name="p35256807093522"></a><a name="p35256807093522"></a>Represents a listener for changes of a check box. </p>
</td>
</tr>
<tr id="row1359730894093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1466144788093522"><a name="p1466144788093522"></a><a name="p1466144788093522"></a><a href="ohos-uicheckbox.md">OHOS::UICheckBox</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1004781462093522"><a name="p1004781462093522"></a><a name="p1004781462093522"></a>Represents a check box. </p>
</td>
</tr>
<tr id="row657958528093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p679026686093522"><a name="p679026686093522"></a><a name="p679026686093522"></a><a href="ohos-uicircleprogress.md">OHOS::UICircleProgress</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p347314837093522"><a name="p347314837093522"></a><a name="p347314837093522"></a>Represents a circular progress bar. </p>
</td>
</tr>
<tr id="row1127528537093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p272451073093522"><a name="p272451073093522"></a><a name="p272451073093522"></a><a href="ohos-uidialog.md">OHOS::UIDialog</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p625784670093522"><a name="p625784670093522"></a><a name="p625784670093522"></a>Represents a dialog box. </p>
</td>
</tr>
<tr id="row1195248927093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p130820023093522"><a name="p130820023093522"></a><a name="p130820023093522"></a><a href="ohos-uidigitalclock.md">OHOS::UIDigitalClock</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p463073425093522"><a name="p463073425093522"></a><a name="p463073425093522"></a>Displays time digitally. </p>
</td>
</tr>
<tr id="row562315478093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2084729687093522"><a name="p2084729687093522"></a><a name="p2084729687093522"></a><a href="ohos-imageanimatorinfo.md">OHOS::ImageAnimatorInfo</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p439471171093522"><a name="p439471171093522"></a><a name="p439471171093522"></a>Provides information about the images. </p>
</td>
</tr>
<tr id="row305101208093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1160172208093522"><a name="p1160172208093522"></a><a name="p1160172208093522"></a><a href="ohos-uiimageanimatorview-animatorstoplistener.md">OHOS::UIImageAnimatorView::AnimatorStopListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1301684069093522"><a name="p1301684069093522"></a><a name="p1301684069093522"></a>Represents a listener that contains a callback to be invoked when this animator stops. </p>
</td>
</tr>
<tr id="row1996135456093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p50289180093522"><a name="p50289180093522"></a><a name="p50289180093522"></a><a href="ohos-uiimageanimatorview.md">OHOS::UIImageAnimatorView</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1926196373093522"><a name="p1926196373093522"></a><a name="p1926196373093522"></a>Represents an image animator. </p>
</td>
</tr>
<tr id="row478807044093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1488900479093522"><a name="p1488900479093522"></a><a name="p1488900479093522"></a><a href="ohos-uiimageview.md">OHOS::UIImageView</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1158490333093522"><a name="p1158490333093522"></a><a name="p1158490333093522"></a>Defines the functions related to an image view. </p>
</td>
</tr>
<tr id="row1030832845093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1268120088093522"><a name="p1268120088093522"></a><a name="p1268120088093522"></a><a href="ohos-uilabel.md">OHOS::UILabel</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2120212128093522"><a name="p2120212128093522"></a><a name="p2120212128093522"></a>Defines the functions for presenting a label in a specified area, setting the style and background color of a label, and setting the display mode of a long label text. </p>
</td>
</tr>
<tr id="row1267468852093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p606191933093522"><a name="p606191933093522"></a><a name="p606191933093522"></a><a href="ohos-uilabelbutton.md">OHOS::UILabelButton</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2013531701093522"><a name="p2013531701093522"></a><a name="p2013531701093522"></a>Provides the functions related to a label button. </p>
</td>
</tr>
<tr id="row1616267243093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1513404637093522"><a name="p1513404637093522"></a><a name="p1513404637093522"></a><a href="ohos-listscrolllistener.md">OHOS::ListScrollListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p182684007093522"><a name="p182684007093522"></a><a name="p182684007093522"></a>Represents a listener that contains a callback to be invoked when the scroll state changes or when a new child view is selected at the preset position as this list scrolls. The scroll state can be <strong id="b59308171093522"><a name="b59308171093522"></a><a name="b59308171093522"></a>SCROLL_STATE_STOP</strong> or <strong id="b61599806093522"><a name="b61599806093522"></a><a name="b61599806093522"></a>SCROLL_STATE_MOVE</strong>. </p>
</td>
</tr>
<tr id="row556929662093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p584839090093522"><a name="p584839090093522"></a><a name="p584839090093522"></a><a href="ohos-uilist.md">OHOS::UIList</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p342698395093522"><a name="p342698395093522"></a><a name="p342698395093522"></a>Represents a scrollable list which is used with the adapter <a href="ohos-abstractadapter.md">AbstractAdapter</a> to implement scrolling, inertial scrolling, automatic alignment, and invoking of a callback when a child view is selected at the preset position as this list scrolls. </p>
</td>
</tr>
<tr id="row1449031941093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p297649089093522"><a name="p297649089093522"></a><a name="p297649089093522"></a><a href="ohos-uipicker-selectedlistener.md">OHOS::UIPicker::SelectedListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2009615523093522"><a name="p2009615523093522"></a><a name="p2009615523093522"></a>Defines the listener used by a picker. This listener is triggered when an item is selected after sliding stops. </p>
</td>
</tr>
<tr id="row1285979581093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1353635118093522"><a name="p1353635118093522"></a><a name="p1353635118093522"></a><a href="ohos-uipicker.md">OHOS::UIPicker</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p851792348093522"><a name="p851792348093522"></a><a name="p851792348093522"></a>Defines a picker. Multiple texts or numbers can be put into a sliding list for selection. The selected text or numbers are highlighted. </p>
</td>
</tr>
<tr id="row1801884678093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1089219570093522"><a name="p1089219570093522"></a><a name="p1089219570093522"></a><a href="ohos-uiradiobutton.md">OHOS::UIRadioButton</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2104760600093522"><a name="p2104760600093522"></a><a name="p2104760600093522"></a>Represents a radio button. </p>
</td>
</tr>
<tr id="row1774805224093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1484049037093522"><a name="p1484049037093522"></a><a name="p1484049037093522"></a><a href="ohos-uirepeatbutton.md">OHOS::UIRepeatButton</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1585672027093522"><a name="p1585672027093522"></a><a name="p1585672027093522"></a>Represents a repeat button. </p>
</td>
</tr>
<tr id="row469111528093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p294896129093522"><a name="p294896129093522"></a><a name="p294896129093522"></a><a href="ohos-uiscrollview-onscrolllistener.md">OHOS::UIScrollView::OnScrollListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2056178868093522"><a name="p2056178868093522"></a><a name="p2056178868093522"></a>Represents a listener that contains a callback to be invoked upon scroll state changes. The state can either be <strong id="b14019326093522"><a name="b14019326093522"></a><a name="b14019326093522"></a>SCROLL_STATE_STOP</strong> or <strong id="b1908433357093522"><a name="b1908433357093522"></a><a name="b1908433357093522"></a>SCROLL_STATE_MOVE</strong>. </p>
</td>
</tr>
<tr id="row1852139707093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p758975302093522"><a name="p758975302093522"></a><a name="p758975302093522"></a><a href="ohos-uiscrollview.md">OHOS::UIScrollView</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1150275509093522"><a name="p1150275509093522"></a><a name="p1150275509093522"></a>Supports horizontal or vertical scroll of child views. This class is inherited from <a href="ohos-uiabstractscroll.md">UIAbstractScroll</a>. </p>
</td>
</tr>
<tr id="row1892496234093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1734374961093522"><a name="p1734374961093522"></a><a name="p1734374961093522"></a><a href="ohos-uislider-uislidereventlistener.md">OHOS::UISlider::UISliderEventListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p146415633093522"><a name="p146415633093522"></a><a name="p146415633093522"></a>Represents the listener for a slider change. </p>
</td>
</tr>
<tr id="row1747921257093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p633691876093522"><a name="p633691876093522"></a><a name="p633691876093522"></a><a href="ohos-uislider.md">OHOS::UISlider</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p738876197093522"><a name="p738876197093522"></a><a name="p738876197093522"></a>Represents a slider. </p>
</td>
</tr>
<tr id="row361929707093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1888344649093522"><a name="p1888344649093522"></a><a name="p1888344649093522"></a><a href="ohos-uisurfaceview.md">OHOS::UISurfaceView</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1735029041093522"><a name="p1735029041093522"></a><a name="p1735029041093522"></a>Represents a surface view that interacts with the multimedia to achieve camera preview and video playback. </p>
</td>
</tr>
<tr id="row46625571093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p310449149093522"><a name="p310449149093522"></a><a name="p310449149093522"></a><a href="ohos-uiswipeview-onswipelistener.md">OHOS::UISwipeView::OnSwipeListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1610425900093522"><a name="p1610425900093522"></a><a name="p1610425900093522"></a>Represents a listener for changes of the swipe view. </p>
</td>
</tr>
<tr id="row1608177029093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1653508220093522"><a name="p1653508220093522"></a><a name="p1653508220093522"></a><a href="ohos-uiswipeview.md">OHOS::UISwipeView</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p856057762093522"><a name="p856057762093522"></a><a name="p856057762093522"></a>Represents a swipe view. </p>
</td>
</tr>
<tr id="row1175434819093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p219324625093522"><a name="p219324625093522"></a><a name="p219324625093522"></a><a href="ohos-uitexturemapper-animatorstoplistener.md">OHOS::UITextureMapper::AnimatorStopListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2015233882093522"><a name="p2015233882093522"></a><a name="p2015233882093522"></a>Represents a listener that contains a callback to be invoked when this animator stops. </p>
</td>
</tr>
<tr id="row1930821196093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p174523364093522"><a name="p174523364093522"></a><a name="p174523364093522"></a><a href="ohos-uitexturemapper.md">OHOS::UITextureMapper</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1586177622093522"><a name="p1586177622093522"></a><a name="p1586177622093522"></a>Rotates and scales images. </p>
</td>
</tr>
<tr id="row1502917152093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p957147317093522"><a name="p957147317093522"></a><a name="p957147317093522"></a><a href="ohos-uitimepicker-selectedlistener.md">OHOS::UITimePicker::SelectedListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2068906412093522"><a name="p2068906412093522"></a><a name="p2068906412093522"></a>Defines the listener used by the time picker. This listener is triggered when an item is selected after sliding stops. </p>
</td>
</tr>
<tr id="row1247032050093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p751806700093522"><a name="p751806700093522"></a><a name="p751806700093522"></a><a href="ohos-uitimepicker.md">OHOS::UITimePicker</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p358129656093522"><a name="p358129656093522"></a><a name="p358129656093522"></a>Defines the time picker. The time is in the format of "hour:minute" or "hour:minute:second". The selected time is highlighted. </p>
</td>
</tr>
<tr id="row1025952998093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p639742452093522"><a name="p639742452093522"></a><a name="p639742452093522"></a><a href="ohos-uitogglebutton.md">OHOS::UIToggleButton</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p192650749093522"><a name="p192650749093522"></a><a name="p192650749093522"></a>Represents a toggle button. </p>
</td>
</tr>
<tr id="row1432434550093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1396513860093522"><a name="p1396513860093522"></a><a name="p1396513860093522"></a><a href="ohos-uiview-onclicklistener.md">OHOS::UIView::OnClickListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1225297932093522"><a name="p1225297932093522"></a><a name="p1225297932093522"></a>Defines a click event listener. You need to register this listener with the view to listen to click events. </p>
</td>
</tr>
<tr id="row668136695093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1002651301093522"><a name="p1002651301093522"></a><a name="p1002651301093522"></a><a href="ohos-uiview-onlongpresslistener.md">OHOS::UIView::OnLongPressListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1487902863093522"><a name="p1487902863093522"></a><a name="p1487902863093522"></a>Defines a long-press event listener. You need to register this listener with the view to listen to long-press events. </p>
</td>
</tr>
<tr id="row1106288487093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1117286248093522"><a name="p1117286248093522"></a><a name="p1117286248093522"></a><a href="ohos-uiview-ondraglistener.md">OHOS::UIView::OnDragListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1692568132093522"><a name="p1692568132093522"></a><a name="p1692568132093522"></a>Defines a drag event listener. You need to register this listener with the view to listen to drag events. </p>
</td>
</tr>
<tr id="row1409544657093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1131503800093522"><a name="p1131503800093522"></a><a name="p1131503800093522"></a><a href="ohos-uiview-ontouchlistener.md">OHOS::UIView::OnTouchListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1735821656093522"><a name="p1735821656093522"></a><a name="p1735821656093522"></a>Defines a touch event listener. You need to register this listener with the view to listen to touch events. </p>
</td>
</tr>
<tr id="row464905769093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p891847471093522"><a name="p891847471093522"></a><a name="p891847471093522"></a><a href="ohos-uiview.md">OHOS::UIView</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p173855163093522"><a name="p173855163093522"></a><a name="p173855163093522"></a>Defines the base class of a view, providing basic view attributes and operations. All views are derived from this class. </p>
</td>
</tr>
<tr id="row1058755753093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1208047367093522"><a name="p1208047367093522"></a><a name="p1208047367093522"></a><a href="ohos-uiviewgroup.md">OHOS::UIViewGroup</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p920487157093522"><a name="p920487157093522"></a><a name="p920487157093522"></a>Represents a view group that consists of its child views. </p>
</td>
</tr>
<tr id="row251318550093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p316333314093522"><a name="p316333314093522"></a><a name="p316333314093522"></a><a href="ohos-uidumpdomtree.md">OHOS::UIDumpDomTree</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1058345141093522"><a name="p1058345141093522"></a><a name="p1058345141093522"></a>Provides functions for exporting information about a specified DOM node or information about the DOM tree starting from a specified DOM node. </p>
</td>
</tr>
<tr id="row924292218093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1142391729093522"><a name="p1142391729093522"></a><a name="p1142391729093522"></a><a href="ohos-cancelevent.md">OHOS::CancelEvent</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2038631858093522"><a name="p2038631858093522"></a><a name="p2038631858093522"></a>Defines a cancel event, which usually occurs when the target view changes due to user sliding. For example, this event is triggered if you, after pressing a button, does not release the button but slides. </p>
</td>
</tr>
<tr id="row227895608093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1703126958093522"><a name="p1703126958093522"></a><a name="p1703126958093522"></a><a href="ohos-clickevent.md">OHOS::ClickEvent</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p273519117093522"><a name="p273519117093522"></a><a name="p273519117093522"></a>Defines a click event, which indicates that a finger is pressed on the screen and then lifted within 1 second. </p>
</td>
</tr>
<tr id="row1698869801093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p787248516093522"><a name="p787248516093522"></a><a name="p787248516093522"></a><a href="ohos-dragevent.md">OHOS::DragEvent</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p503496259093522"><a name="p503496259093522"></a><a name="p503496259093522"></a>Defines a drag event, which indicates a certain movement (more than 10 pixels) after a view is pressed. </p>
</td>
</tr>
<tr id="row2006808867093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1380455241093522"><a name="p1380455241093522"></a><a name="p1380455241093522"></a><a href="ohos-event.md">OHOS::Event</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1927385285093522"><a name="p1927385285093522"></a><a name="p1927385285093522"></a>Defines the base class of a user input event and provides functions to record information such as the event position and timestamp. </p>
</td>
</tr>
<tr id="row794889517093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p966778258093522"><a name="p966778258093522"></a><a name="p966778258093522"></a><a href="ohos-keyevent.md">OHOS::KeyEvent</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1770429858093522"><a name="p1770429858093522"></a><a name="p1770429858093522"></a>Defines a key event, which indicates that a physical button is pressed or released. </p>
</td>
</tr>
<tr id="row903950216093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1407952789093522"><a name="p1407952789093522"></a><a name="p1407952789093522"></a><a href="ohos-longpressevent.md">OHOS::LongPressEvent</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p935709509093522"><a name="p935709509093522"></a><a name="p935709509093522"></a>Defines a long-press event, which indicates that the finger is not raised or moved within 1 second after a view is pressed. </p>
</td>
</tr>
<tr id="row69325208093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1145403786093522"><a name="p1145403786093522"></a><a name="p1145403786093522"></a><a href="ohos-pressevent.md">OHOS::PressEvent</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p3481392093522"><a name="p3481392093522"></a><a name="p3481392093522"></a>Defines a touch event, which indicates that the touchscreen or mouse is pressed. </p>
</td>
</tr>
<tr id="row937529037093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1840773559093522"><a name="p1840773559093522"></a><a name="p1840773559093522"></a><a href="ohos-releaseevent.md">OHOS::ReleaseEvent</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1925888832093522"><a name="p1925888832093522"></a><a name="p1925888832093522"></a>Defines a release event, which indicates that the touchscreen or mouse is released. </p>
</td>
</tr>
<tr id="row720647188093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p967838239093522"><a name="p967838239093522"></a><a name="p967838239093522"></a><a href="ohos-virtualdeviceevent.md">OHOS::VirtualDeviceEvent</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1309245584093522"><a name="p1309245584093522"></a><a name="p1309245584093522"></a>Defines a virtual device event, which is used to receive a customized input event and call back the listening function registered. </p>
</td>
</tr>
<tr id="row1006134843093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1244718448093522"><a name="p1244718448093522"></a><a name="p1244718448093522"></a><a href="ohos-line.md">OHOS::Line</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p214220634093522"><a name="p214220634093522"></a><a name="p214220634093522"></a>Defines a line, which consists of the start and end points. </p>
</td>
</tr>
<tr id="row2134165484093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p28177524093522"><a name="p28177524093522"></a><a name="p28177524093522"></a><a href="ohos-polygon.md">OHOS::Polygon</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p520550368093522"><a name="p520550368093522"></a><a name="p520550368093522"></a>Defines a polygon, including vertex coordinates and the maximum number of vertices (defined by <a href="graphic.md#gafff78acb69e2b147b6f33d68e570ef54">MAX_VERTEX_NUM</a>). </p>
</td>
</tr>
<tr id="row343720841093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1030659540093522"><a name="p1030659540093522"></a><a name="p1030659540093522"></a><a href="ohos-vector2-t.md">OHOS::Vector2&lt; T &gt;</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p890119447093522"><a name="p890119447093522"></a><a name="p890119447093522"></a>Defines the two-dimensional vector, and provides basic mathematical operations such as vector assignment, scalar product, cross product, addition, and subtraction. </p>
</td>
</tr>
<tr id="row29201804093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2116971444093522"><a name="p2116971444093522"></a><a name="p2116971444093522"></a><a href="ohos-vector3-t.md">OHOS::Vector3&lt; T &gt;</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1263441624093522"><a name="p1263441624093522"></a><a name="p1263441624093522"></a>Defines the 3-dimensional vector, and provides basic operators such as [] and ==. </p>
</td>
</tr>
<tr id="row901998845093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2078620215093522"><a name="p2078620215093522"></a><a name="p2078620215093522"></a><a href="ohos-matrix3-t.md">OHOS::Matrix3&lt; T &gt;</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1573796575093522"><a name="p1573796575093522"></a><a name="p1573796575093522"></a>Defines a 3 x 3 matrix. </p>
</td>
</tr>
<tr id="row1292596085093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p594645325093522"><a name="p594645325093522"></a><a name="p594645325093522"></a><a href="ohos-point.md">OHOS::Point</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1624182555093522"><a name="p1624182555093522"></a><a name="p1624182555093522"></a>Defines a point. </p>
</td>
</tr>
<tr id="row1145877369093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1263377512093522"><a name="p1263377512093522"></a><a name="p1263377512093522"></a><a href="ohos-heapbase.md">OHOS::HeapBase</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1569795337093522"><a name="p1569795337093522"></a><a name="p1569795337093522"></a>Defines the base class, overriding the <strong id="b1225588443093522"><a name="b1225588443093522"></a><a name="b1225588443093522"></a>new</strong> and <strong id="b477203371093522"><a name="b477203371093522"></a><a name="b477203371093522"></a>delete</strong> functions. </p>
</td>
</tr>
<tr id="row170042403093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p33906176093522"><a name="p33906176093522"></a><a name="p33906176093522"></a><a href="ohos-imageheader.md">OHOS::ImageHeader</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1176473223093522"><a name="p1176473223093522"></a><a name="p1176473223093522"></a>Defines image head node information. </p>
</td>
</tr>
<tr id="row1008521303093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2041585832093522"><a name="p2041585832093522"></a><a name="p2041585832093522"></a><a href="ohos-imageinfo.md">OHOS::ImageInfo</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1426447852093522"><a name="p1426447852093522"></a><a name="p1426447852093522"></a>Defines image information. </p>
</td>
</tr>
<tr id="row683055912093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1047396392093522"><a name="p1047396392093522"></a><a name="p1047396392093522"></a><a href="ohos-flexlayout.md">OHOS::FlexLayout</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p654859997093522"><a name="p654859997093522"></a><a name="p654859997093522"></a>Defines a flexible layout container. You can perform simple adaptive layout on child views that the container holds, for example, to evenly arrange all child views in the same row or column. </p>
</td>
</tr>
<tr id="row647432387093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1642296601093522"><a name="p1642296601093522"></a><a name="p1642296601093522"></a><a href="ohos-gridlayout.md">OHOS::GridLayout</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1690949496093522"><a name="p1690949496093522"></a><a name="p1690949496093522"></a>Defines a grid layout container. You can perform simple grid layout on child views that the container holds. </p>
</td>
</tr>
<tr id="row70119205093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1900168085093522"><a name="p1900168085093522"></a><a name="p1900168085093522"></a><a href="ohos-layout.md">OHOS::Layout</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1472621726093522"><a name="p1472621726093522"></a><a name="p1472621726093522"></a>Defines the base class of the layout, which indicates the basic data types and operations that may be used in the layout. </p>
</td>
</tr>
<tr id="row1084537373093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1317584538093522"><a name="p1317584538093522"></a><a name="p1317584538093522"></a><a href="ohos-listnode-t.md">OHOS::ListNode&lt; T &gt;</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2023140829093522"><a name="p2023140829093522"></a><a name="p2023140829093522"></a>Stores linked list data and contains pointers to the previous node and the next node. </p>
</td>
</tr>
<tr id="row839438419093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p129884208093522"><a name="p129884208093522"></a><a name="p129884208093522"></a><a href="ohos-list-t.md">OHOS::List&lt; T &gt;</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p605086715093522"><a name="p605086715093522"></a><a name="p605086715093522"></a>Defines a linked list template class, which implements the data structure of bidirectional linked list and provides basic functions such as adding, deleting, inserting, clearing, popping up, and obtaining the size of the linked list. </p>
</td>
</tr>
<tr id="row979559312093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p966191132093522"><a name="p966191132093522"></a><a name="p966191132093522"></a><a href="ohos-rect.md">OHOS::Rect</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p839803678093522"><a name="p839803678093522"></a><a name="p839803678093522"></a>Defines a rectangle, including the position data of the four boundaries of the rectangle, and provides functions for rectangle inclusion, intersection, and aggregation. </p>
</td>
</tr>
<tr id="row131727372093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1334193162093522"><a name="p1334193162093522"></a><a name="p1334193162093522"></a><a href="ohos-style.md">OHOS::Style</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p404296878093522"><a name="p404296878093522"></a><a name="p404296878093522"></a>Defines the basic attributes and functions of a style. You can use this class to set different styles. </p>
</td>
</tr>
<tr id="row584034045093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p416850098093522"><a name="p416850098093522"></a><a name="p416850098093522"></a><a href="ohos-styledefault.md">OHOS::StyleDefault</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1573848972093522"><a name="p1573848972093522"></a><a name="p1573848972093522"></a>Define some default style for <a href="ohos-uiview.md">UIView</a>. </p>
</td>
</tr>
<tr id="row544332934093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1505562510093522"><a name="p1505562510093522"></a><a name="p1505562510093522"></a><a href="ohos-sysinfo-onfpschangedlistener.md">OHOS::SysInfo::OnFPSChangedListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p479187816093522"><a name="p479187816093522"></a><a name="p479187816093522"></a>Called when the FPS changes. </p>
</td>
</tr>
<tr id="row1776107265093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1564689609093522"><a name="p1564689609093522"></a><a name="p1564689609093522"></a><a href="ohos-sysinfo.md">OHOS::SysInfo</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1030220946093522"><a name="p1030220946093522"></a><a name="p1030220946093522"></a>Obtains the system information. Currently, the FPS information can be obtained. To enable the FPS feature, enable the <strong id="b353432331093522"><a name="b353432331093522"></a><a name="b353432331093522"></a>ENABLE_FPS_SUPPORT</strong> macro. </p>
</td>
</tr>
<tr id="row724052892093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1711819021093522"><a name="p1711819021093522"></a><a name="p1711819021093522"></a><a href="ohos-buttonstyle.md">OHOS::ButtonStyle</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1468869796093522"><a name="p1468869796093522"></a><a name="p1468869796093522"></a>Stores styles of a button in its different states. </p>
</td>
</tr>
<tr id="row1220999582093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1340016529093522"><a name="p1340016529093522"></a><a name="p1340016529093522"></a><a href="ohos-theme.md">OHOS::Theme</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p333042482093522"><a name="p333042482093522"></a><a name="p333042482093522"></a>Defines the theme class used to define the functions related to the styles of different components. </p>
</td>
</tr>
<tr id="row1149420498093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1342589566093522"><a name="p1342589566093522"></a><a name="p1342589566093522"></a><a href="ohos-thememanager.md">OHOS::ThemeManager</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p543693680093522"><a name="p543693680093522"></a><a name="p543693680093522"></a>Declares the singleton class used to manage the current screen theme of an application. </p>
</td>
</tr>
<tr id="row79276393093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1500457689093522"><a name="p1500457689093522"></a><a name="p1500457689093522"></a><a href="ohos-transformmap.md">OHOS::TransformMap</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p220260615093522"><a name="p220260615093522"></a><a name="p220260615093522"></a>Transforms a rectangle, including rotation and scaling. </p>
</td>
</tr>
</tbody>
</table>

## Macros<a name="define-members"></a>

<a name="table115793518093522"></a>
<table><thead align="left"><tr id="row393474665093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p636492670093522"><a name="p636492670093522"></a><a name="p636492670093522"></a>Macro Name and Value</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1262741950093522"><a name="p1262741950093522"></a><a name="p1262741950093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row608208433093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2001923174093522"><a name="p2001923174093522"></a><a name="p2001923174093522"></a><a href="graphic.md#ga2017774de578acba5afd77793c00205b">VERSION_STANDARD</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">&nbsp;</td>
</tr>
<tr id="row1379193449093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2038524262093522"><a name="p2038524262093522"></a><a name="p2038524262093522"></a><em id="ga3d83acf19f4d5c59f7a29b6b29440dd2"><a name="ga3d83acf19f4d5c59f7a29b6b29440dd2"></a><a name="ga3d83acf19f4d5c59f7a29b6b29440dd2"></a></em>ENABLE_DMA2D    0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1644898410093522"><a name="p1644898410093522"></a><a name="p1644898410093522"></a>DMA2D hardware acceleration, which does not take effect on other platforms. </p>
</td>
</tr>
<tr id="row263745553093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p968821071093522"><a name="p968821071093522"></a><a name="p968821071093522"></a><em id="gaef5d32e398c657450011db566a5fad04"><a name="gaef5d32e398c657450011db566a5fad04"></a><a name="gaef5d32e398c657450011db566a5fad04"></a></em>ENABLE_DMA2D_TEXT    0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1592321403093522"><a name="p1592321403093522"></a><a name="p1592321403093522"></a>DMA2D hardware acceleration for font rendering, which does not take effect on other platforms. </p>
</td>
</tr>
<tr id="row885123451093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1370379159093522"><a name="p1370379159093522"></a><a name="p1370379159093522"></a><em id="ga1a28113245f31cacd0afacc80c7d12c1"><a name="ga1a28113245f31cacd0afacc80c7d12c1"></a><a name="ga1a28113245f31cacd0afacc80c7d12c1"></a></em>ENABLE_ICU    0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1471244852093522"><a name="p1471244852093522"></a><a name="p1471244852093522"></a>Advanced algorithm for line breaks, which is disabled by default on other platforms. </p>
</td>
</tr>
<tr id="row1640918588093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1280170356093522"><a name="p1280170356093522"></a><a name="p1280170356093522"></a><em id="ga8fffdbb807e226013ce790500b5c88e2"><a name="ga8fffdbb807e226013ce790500b5c88e2"></a><a name="ga8fffdbb807e226013ce790500b5c88e2"></a></em>ENABLE_WINDOW    1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1460747220093522"><a name="p1460747220093522"></a><a name="p1460747220093522"></a>Multi-window, which is enabled by default on other platforms. </p>
</td>
</tr>
<tr id="row741515488093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p689879957093522"><a name="p689879957093522"></a><a name="p689879957093522"></a><em id="gaf319cb3be43a211a63f2ea97a1c3ae6d"><a name="gaf319cb3be43a211a63f2ea97a1c3ae6d"></a><a name="gaf319cb3be43a211a63f2ea97a1c3ae6d"></a></em>ENABLE_FRAME_BUFFER    0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1672224911093522"><a name="p1672224911093522"></a><a name="p1672224911093522"></a>Display buffer for rendering data refresh, which is disabled by default on other platforms. </p>
</td>
</tr>
<tr id="row1046035745093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p350147346093522"><a name="p350147346093522"></a><a name="p350147346093522"></a><em id="ga2c3acabc94a483bd191a250f67c1f43b"><a name="ga2c3acabc94a483bd191a250f67c1f43b"></a><a name="ga2c3acabc94a483bd191a250f67c1f43b"></a></em>ENABLE_VECTOR_FONT    1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p518550533093522"><a name="p518550533093522"></a><a name="p518550533093522"></a>Vector type font, which is enabled by default on other platforms.</p>
</td>
</tr>
<tr id="row1441809028093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p398490082093522"><a name="p398490082093522"></a><a name="p398490082093522"></a><em id="ga8f198e8500b353e58b618b331f768f27"><a name="ga8f198e8500b353e58b618b331f768f27"></a><a name="ga8f198e8500b353e58b618b331f768f27"></a></em>ENABLE_BUFFER_RGBA    1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p984515064093522"><a name="p984515064093522"></a><a name="p984515064093522"></a>Graphics bottom-layer RGBA, which is enabled by default. </p>
</td>
</tr>
<tr id="row1912188621093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1043805247093522"><a name="p1043805247093522"></a><a name="p1043805247093522"></a><em id="ga8508eb8cc5346dbdc552a9fbc11dbb06"><a name="ga8508eb8cc5346dbdc552a9fbc11dbb06"></a><a name="ga8508eb8cc5346dbdc552a9fbc11dbb06"></a></em>ENABLE_HARDWARE_ACCELERATION    1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1406342415093522"><a name="p1406342415093522"></a><a name="p1406342415093522"></a>Graphics rendering hardware acceleration, which is enabled by default. </p>
</td>
</tr>
<tr id="row1976623731093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2026893397093522"><a name="p2026893397093522"></a><a name="p2026893397093522"></a><em id="ga432138093c53d7580af9ec5c5dca387f"><a name="ga432138093c53d7580af9ec5c5dca387f"></a><a name="ga432138093c53d7580af9ec5c5dca387f"></a></em>ENABLE_DEBUG    1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p447919268093522"><a name="p447919268093522"></a><a name="p447919268093522"></a>Debug mode, which is disabled by default. </p>
</td>
</tr>
<tr id="row1696038756093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p843029830093522"><a name="p843029830093522"></a><a name="p843029830093522"></a><em id="gaa492b15de59b36af68c10a65952dc870"><a name="gaa492b15de59b36af68c10a65952dc870"></a><a name="gaa492b15de59b36af68c10a65952dc870"></a></em>ENABLE_MEMORY_HOOKS    0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p776854295093522"><a name="p776854295093522"></a><a name="p776854295093522"></a>Memory hook, which is enabled by default. The system memory allocation is taken over after it is enabled. </p>
</td>
</tr>
<tr id="row1704370352093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1891629698093522"><a name="p1891629698093522"></a><a name="p1891629698093522"></a><em id="ga4c1dffa1615941394d376b12a8fbdf24"><a name="ga4c1dffa1615941394d376b12a8fbdf24"></a><a name="ga4c1dffa1615941394d376b12a8fbdf24"></a></em>ENABLE_FPS_SUPPORT    0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p569846052093522"><a name="p569846052093522"></a><a name="p569846052093522"></a>Function for monitoring the image refresh frame rate, which is disabled by default. </p>
</td>
</tr>
<tr id="row1828445817093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1192320366093522"><a name="p1192320366093522"></a><a name="p1192320366093522"></a><em id="ga2e63917ecfb73182bcea30104c497bc9"><a name="ga2e63917ecfb73182bcea30104c497bc9"></a><a name="ga2e63917ecfb73182bcea30104c497bc9"></a></em>ENABLE_ANTIALIAS    1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p528656929093522"><a name="p528656929093522"></a><a name="p528656929093522"></a>Anti-aliasing, which is enabled by default. </p>
</td>
</tr>
<tr id="row2099888241093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p235271487093522"><a name="p235271487093522"></a><a name="p235271487093522"></a><em id="gaade33b264d4ea661ff8f36976908b4ba"><a name="gaade33b264d4ea661ff8f36976908b4ba"></a><a name="gaade33b264d4ea661ff8f36976908b4ba"></a></em>ENABLE_RECT_ANTIALIAS    0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p727358336093522"><a name="p727358336093522"></a><a name="p727358336093522"></a><a href="rectangle.md">Rectangle</a> anti-aliasing, which is disabled by default. </p>
</td>
</tr>
<tr id="row531749681093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1350488655093522"><a name="p1350488655093522"></a><a name="p1350488655093522"></a><em id="ga733acdcb7c5872a7b864ae108cd86413"><a name="ga733acdcb7c5872a7b864ae108cd86413"></a><a name="ga733acdcb7c5872a7b864ae108cd86413"></a></em>ENABLE_SPEC_FONT    0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p872832250093522"><a name="p872832250093522"></a><a name="p872832250093522"></a>Font color mode, which is disabled by default. After it is enabled, the font color mode is set to <strong id="b1812619873093522"><a name="b1812619873093522"></a><a name="b1812619873093522"></a>4</strong> to accelerate font rendering. </p>
</td>
</tr>
<tr id="row1378965485093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1090856101093522"><a name="p1090856101093522"></a><a name="p1090856101093522"></a><em id="ga703e1a14b7cccc8074986836c5c1de02"><a name="ga703e1a14b7cccc8074986836c5c1de02"></a><a name="ga703e1a14b7cccc8074986836c5c1de02"></a></em>ENABLE_GRAPHIC_LOG    0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p881907408093522"><a name="p881907408093522"></a><a name="p881907408093522"></a>Log function of a graphics subsystem, which is disabled by default. </p>
</td>
</tr>
<tr id="row1509252996093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1882000104093522"><a name="p1882000104093522"></a><a name="p1882000104093522"></a><em id="ga31b6586b78d550c8b08abb87c8ae8d0b"><a name="ga31b6586b78d550c8b08abb87c8ae8d0b"></a><a name="ga31b6586b78d550c8b08abb87c8ae8d0b"></a></em>ENABLE_AOD    0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p487073614093522"><a name="p487073614093522"></a><a name="p487073614093522"></a>Function for receiving input events in screen-off mode, which is disabled by default. </p>
</td>
</tr>
<tr id="row1033542215093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p888257056093522"><a name="p888257056093522"></a><a name="p888257056093522"></a><em id="gaca8a42c138892758d4d3252dddbd1373"><a name="gaca8a42c138892758d4d3252dddbd1373"></a><a name="gaca8a42c138892758d4d3252dddbd1373"></a></em>GRAPHIC_LOG_LEVEL    5</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p101842122093522"><a name="p101842122093522"></a><a name="p101842122093522"></a>Defines the log level. A smaller value indicates a higher priority. Logs whose priorities are higher than a specified level can be recorded. Log levels: NONE: disabling logs FATAL: fatal level ERROR: error level WARN: warning level INFO: info level DEBUG: debugging level. </p>
</td>
</tr>
<tr id="row1623271750093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p365335031093522"><a name="p365335031093522"></a><a name="p365335031093522"></a><em id="ga70d330906276a996f7dab090a03ce2a5"><a name="ga70d330906276a996f7dab090a03ce2a5"></a><a name="ga70d330906276a996f7dab090a03ce2a5"></a></em>COLOR_DEPTH    32</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p466376130093522"><a name="p466376130093522"></a><a name="p466376130093522"></a>Defines the color depth of graphics rendering. The default value is <strong id="b1716036151093522"><a name="b1716036151093522"></a><a name="b1716036151093522"></a>32</strong> bits. The value can be <strong id="b131382219093522"><a name="b131382219093522"></a><a name="b131382219093522"></a>16</strong> or <strong id="b72636443093522"><a name="b72636443093522"></a><a name="b72636443093522"></a>32</strong>. </p>
</td>
</tr>
<tr id="row2141750240093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p447253373093522"><a name="p447253373093522"></a><a name="p447253373093522"></a><em id="ga78a7a5cd4bd7deb45047b3ca9f088fb6"><a name="ga78a7a5cd4bd7deb45047b3ca9f088fb6"></a><a name="ga78a7a5cd4bd7deb45047b3ca9f088fb6"></a></em>DEFAULT_VECTOR_FONT_FILENAME    "SourceHanSansSC-Regular.otf"</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p226463241093522"><a name="p226463241093522"></a><a name="p226463241093522"></a>Defines the file name of default vector font. </p>
</td>
</tr>
<tr id="row1475341634093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1696838010093522"><a name="p1696838010093522"></a><a name="p1696838010093522"></a><em id="ga3e18a38ff2f4dbf813d85d14ae7cc7f6"><a name="ga3e18a38ff2f4dbf813d85d14ae7cc7f6"></a><a name="ga3e18a38ff2f4dbf813d85d14ae7cc7f6"></a></em>MATH_MAX (a, b)   ((a) &gt; (b) ? (a) : (b))</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p327931799093522"><a name="p327931799093522"></a><a name="p327931799093522"></a>Larger of a and b. </p>
</td>
</tr>
<tr id="row1841689047093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1454658705093522"><a name="p1454658705093522"></a><a name="p1454658705093522"></a><em id="ga0707ec809a1938e6b07386ce8e403313"><a name="ga0707ec809a1938e6b07386ce8e403313"></a><a name="ga0707ec809a1938e6b07386ce8e403313"></a></em>MATH_MIN (a, b)   ((a) &lt; (b) ? (a) : (b))</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p108483079093522"><a name="p108483079093522"></a><a name="p108483079093522"></a>Smaller of a and b. </p>
</td>
</tr>
<tr id="row1415269637093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p220186936093522"><a name="p220186936093522"></a><a name="p220186936093522"></a><em id="ga1336a0214be7acc7fb308f2f88542e39"><a name="ga1336a0214be7acc7fb308f2f88542e39"></a><a name="ga1336a0214be7acc7fb308f2f88542e39"></a></em>MATH_ABS (x)   ((x) &gt; 0 ? (x) : (-(x)))</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1113855261093522"><a name="p1113855261093522"></a><a name="p1113855261093522"></a>Absolute value of x. </p>
</td>
</tr>
<tr id="row464791754093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1922475870093522"><a name="p1922475870093522"></a><a name="p1922475870093522"></a><em id="ga16f420abdb8bee5c5323d203fa1ca43b"><a name="ga16f420abdb8bee5c5323d203fa1ca43b"></a><a name="ga16f420abdb8bee5c5323d203fa1ca43b"></a></em>MATH_MINUS (a, b)   ((a) &lt; (b) ? ((b) - (a)) : ((a) - (b)))</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2120406800093522"><a name="p2120406800093522"></a><a name="p2120406800093522"></a>Difference between a and b. </p>
</td>
</tr>
</tbody>
</table>

## Typedefs<a name="typedef-members"></a>

<a name="table391053505093522"></a>
<table><thead align="left"><tr id="row1919042091093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1433143623093522"><a name="p1433143623093522"></a><a name="p1433143623093522"></a>Typedef Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p997077023093522"><a name="p997077023093522"></a><a name="p997077023093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1970718579093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1489540596093522"><a name="p1489540596093522"></a><a name="p1489540596093522"></a><a href="graphic.md#gaf04c41bb7b151a6e8be2012cc9e6475b">OHOS::EasingFunc</a>) (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2049674154093522"><a name="p2049674154093522"></a><a name="p2049674154093522"></a>typedef int16_t(* </p>
<p id="p1112209437093522"><a name="p1112209437093522"></a><a name="p1112209437093522"></a>Calculates the value for the current time of an animation. </p>
</td>
</tr>
</tbody>
</table>

## Enumerations<a name="enum-members"></a>

<a name="table483473648093522"></a>
<table><thead align="left"><tr id="row1215923292093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1517450202093522"><a name="p1517450202093522"></a><a name="p1517450202093522"></a>Enumeration Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p684880512093522"><a name="p684880512093522"></a><a name="p684880512093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row482646143093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2144447281093522"><a name="p2144447281093522"></a><a name="p2144447281093522"></a>: uint8_t { <a href="graphic.md#gga7b892afa4e88ab11bf96dbd67653f134a6618a5c1c0e9e4be3acba1aaee15cb8d">OHOS::Animator::STOP</a>, <a href="graphic.md#gga7b892afa4e88ab11bf96dbd67653f134a49f9e652157f467df5de3be9e8758f91">OHOS::Animator::START</a>, <a href="graphic.md#gga7b892afa4e88ab11bf96dbd67653f134ae5db6c9a921eec21a2990d73400ff507">OHOS::Animator::PAUSE</a>, <a href="graphic.md#gga7b892afa4e88ab11bf96dbd67653f134a6ef6036766e105b2cd6bf2fb94e92e1b">OHOS::Animator::RUNNING</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p274838460093522"><a name="p274838460093522"></a><a name="p274838460093522"></a>Enumerates the states of this animator. </p>
</td>
</tr>
<tr id="row1341719625093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1049313746093522"><a name="p1049313746093522"></a><a name="p1049313746093522"></a>{ <a href="graphic.md#gga64b074985084bda79316bd0c1365ae82ad4bd10bef3f1df05fd29e023050b9cca">OHOS::OPA_TRANSPARENT</a> = 0, <a href="graphic.md#gga64b074985084bda79316bd0c1365ae82aebcfc69c18e2c29c89f800d95f32754f">OHOS::OPA_OPAQUE</a> = 255 }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p196179248093522"><a name="p196179248093522"></a><a name="p196179248093522"></a>Enumerates opacity values. </p>
</td>
</tr>
<tr id="row1940492216093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1467034877093522"><a name="p1467034877093522"></a><a name="p1467034877093522"></a><a href="graphic.md#ga3f99b58f731a37cacde72d5e0c934593">OHOS::UITextLanguageAlignment</a> : uint8_t {   <a href="graphic.md#gga3f99b58f731a37cacde72d5e0c934593a37453e521c390e6157ac2efff1197a43">OHOS::TEXT_ALIGNMENT_LEFT</a> = 0, <a href="graphic.md#gga3f99b58f731a37cacde72d5e0c934593af6fdcea7d95056a0bab016ba7bee66bd">OHOS::TEXT_ALIGNMENT_RIGHT</a>, <a href="graphic.md#gga3f99b58f731a37cacde72d5e0c934593a1dd445f9b6987a84a7022885ea13c81c">OHOS::TEXT_ALIGNMENT_CENTER</a>, <a href="graphic.md#gga3f99b58f731a37cacde72d5e0c934593a33dfd4e235bcc2f6f42f4efc8c8264a2">OHOS::TEXT_ALIGNMENT_TOP</a>,   <a href="graphic.md#gga3f99b58f731a37cacde72d5e0c934593aa7798629aa2199c86cb668e94115186c">OHOS::TEXT_ALIGNMENT_BOTTOM</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p23730203093522"><a name="p23730203093522"></a><a name="p23730203093522"></a>Enumerates text alignment modes. </p>
</td>
</tr>
<tr id="row990238796093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1766796721093522"><a name="p1766796721093522"></a><a name="p1766796721093522"></a><a href="graphic.md#ga0c108f97781843f67c101b47b6c00cf0">OHOS::UITextLanguageDirect</a> : uint8_t { <a href="graphic.md#gga0c108f97781843f67c101b47b6c00cf0a387cedfce95a736f28a1c2748086b1a9">OHOS::TEXT_DIRECT_LTR</a> = 0, <a href="graphic.md#gga0c108f97781843f67c101b47b6c00cf0a76658b82f45d4136910ded0c22afe7f8">OHOS::TEXT_DIRECT_RTL</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1749580355093522"><a name="p1749580355093522"></a><a name="p1749580355093522"></a>Enumerates text directions. </p>
</td>
</tr>
<tr id="row855427942093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p113996302093522"><a name="p113996302093522"></a><a name="p113996302093522"></a><a href="graphic.md#ga19db90932bc71e6bbced6ccf2935ac98">OHOS::UIAbstractClock::WorkMode</a> { <a href="graphic.md#gga19db90932bc71e6bbced6ccf2935ac98a2025ac1a1f63409f0b37f444547ec859">OHOS::UIAbstractClock::ALWAYS_ON</a>, <a href="graphic.md#gga19db90932bc71e6bbced6ccf2935ac98a8d32f103a422c6675618f5e9773b2eaa">OHOS::UIAbstractClock::NORMAL</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p981720693093522"><a name="p981720693093522"></a><a name="p981720693093522"></a>Enumerates the working modes of this clock. </p>
</td>
</tr>
<tr id="row1402181880093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p347146156093522"><a name="p347146156093522"></a><a name="p347146156093522"></a><a href="graphic.md#ga13cf64ea5bd39550976aaf65b1381edf">OHOS::UIAnalogClock::HandType</a> { <a href="graphic.md#gga13cf64ea5bd39550976aaf65b1381edfa2b8ab55559dff5a849bf7445f6865958">OHOS::UIAnalogClock::HandType::HOUR_HAND</a>, <a href="graphic.md#gga13cf64ea5bd39550976aaf65b1381edfa50ddc7aea61ec54878c173e1423af447">OHOS::UIAnalogClock::HandType::MINUTE_HAND</a>, <a href="graphic.md#gga13cf64ea5bd39550976aaf65b1381edfa620c615d18fdb1b23ed04df57842909d">OHOS::UIAnalogClock::HandType::SECOND_HAND</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p414850313093522"><a name="p414850313093522"></a><a name="p414850313093522"></a>Enumerates the clock hand types. </p>
</td>
</tr>
<tr id="row1542625780093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p644701364093522"><a name="p644701364093522"></a><a name="p644701364093522"></a><a href="graphic.md#ga0a595eeb50ce4e7dfff9ede16098d2db">OHOS::UIAnalogClock::DrawType</a> { <a href="graphic.md#gga0a595eeb50ce4e7dfff9ede16098d2dba6ddf16010fbdac5db23575583cb8a388">OHOS::UIAnalogClock::DrawType::DRAW_LINE</a>, <a href="graphic.md#gga0a595eeb50ce4e7dfff9ede16098d2dba5cb6a362b1dec2b19422e9e9a6bbda3c">OHOS::UIAnalogClock::DrawType::DRAW_IMAGE</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1468886682093522"><a name="p1468886682093522"></a><a name="p1468886682093522"></a>Enumerates the drawing types of a clock hand. </p>
</td>
</tr>
<tr id="row1920475380093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1997672481093522"><a name="p1997672481093522"></a><a name="p1997672481093522"></a><a href="graphic.md#ga0778527bee4a7ddd8d46395585a5cfb9">OHOS::UIArcLabel::TextOrientation</a> : uint8_t { <a href="graphic.md#gga0778527bee4a7ddd8d46395585a5cfb9a554a7418c4c0dafd902ebd377b87c80c">OHOS::UIArcLabel::TextOrientation::INSIDE</a>, <a href="graphic.md#gga0778527bee4a7ddd8d46395585a5cfb9a93da25bafef6761717afc6b25c17ea16">OHOS::UIArcLabel::TextOrientation::OUTSIDE</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2084101617093522"><a name="p2084101617093522"></a><a name="p2084101617093522"></a>Enumerates text orientations. </p>
</td>
</tr>
<tr id="row1953446379093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2100397023093522"><a name="p2100397023093522"></a><a name="p2100397023093522"></a><a href="graphic.md#ga4a7a2c192206c8b18379f42a5fd176eb">OHOS::UIBoxProgress::Direction</a> : uint8_t { <a href="graphic.md#gga4a7a2c192206c8b18379f42a5fd176eba43cb7d46f0e18f315d43b82024093b51">OHOS::UIBoxProgress::Direction::DIR_LEFT_TO_RIGHT</a>, <a href="graphic.md#gga4a7a2c192206c8b18379f42a5fd176eba49e31df5a7fc02ee8c2f85b5e15f0145">OHOS::UIBoxProgress::Direction::DIR_RIGHT_TO_LEFT</a>, <a href="graphic.md#gga4a7a2c192206c8b18379f42a5fd176eba68baeaa89ae4576fc3d9ac732f87a116">OHOS::UIBoxProgress::Direction::DIR_TOP_TO_BOTTOM</a>, <a href="graphic.md#gga4a7a2c192206c8b18379f42a5fd176eba78b28982b481790c740bc9b2c1292baa">OHOS::UIBoxProgress::Direction::DIR_BOTTOM_TO_TOP</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p220224884093522"><a name="p220224884093522"></a><a name="p220224884093522"></a>Enumerates the directions of the progress bar. </p>
</td>
</tr>
<tr id="row211368982093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2102245090093522"><a name="p2102245090093522"></a><a name="p2102245090093522"></a><a href="graphic.md#gaf9f6c0c373f090e79b9e8d847e186e92">OHOS::UIButton::ButtonImageSrc</a> : uint8_t </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p879730638093522"><a name="p879730638093522"></a><a name="p879730638093522"></a>Enumerates the images for different button states. </p>
</td>
</tr>
<tr id="row1065721674093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p310464937093522"><a name="p310464937093522"></a><a name="p310464937093522"></a><a href="graphic.md#ga188dd55c17ee44be27fa80543f13f729">OHOS::UIButton::ButtonState</a> : uint8_t </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1420315418093522"><a name="p1420315418093522"></a><a name="p1420315418093522"></a>Enumerates the states of this button. </p>
</td>
</tr>
<tr id="row1706040501093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p72664714093522"><a name="p72664714093522"></a><a name="p72664714093522"></a><a href="graphic.md#ga548320a469b7862fa416af062cad5d7a">OHOS::Paint::PaintStyle</a> { <a href="graphic.md#gga548320a469b7862fa416af062cad5d7aa16a9f85a0cca54cb2e20bb58a6a41a41">OHOS::Paint::STROKE_STYLE</a> = 1, <a href="graphic.md#gga548320a469b7862fa416af062cad5d7aa706e9d250b4f9ef43008dcd61eb67bb6">OHOS::Paint::FILL_STYLE</a>, <a href="graphic.md#gga548320a469b7862fa416af062cad5d7aa30415cae54bf38e3275e847b5ab3ef1c">OHOS::Paint::STROKE_FILL_STYLE</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p395156256093522"><a name="p395156256093522"></a><a name="p395156256093522"></a>Enumerates paint styles of a closed graph. The styles are invalid for non-closed graphs. </p>
</td>
</tr>
<tr id="row1844781897093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p285493592093522"><a name="p285493592093522"></a><a name="p285493592093522"></a><a href="graphic.md#ga15a3f0302aded0e4d1584ddc6002335d">OHOS::UICheckBox::UICheckBoxState</a> : uint8_t </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2078446120093522"><a name="p2078446120093522"></a><a name="p2078446120093522"></a>Enumerates the states of a check box. </p>
</td>
</tr>
<tr id="row1326825577093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1081341541093522"><a name="p1081341541093522"></a><a name="p1081341541093522"></a><a href="graphic.md#ga1bfefa0b46fd5a79a28d0c9a75114295">OHOS::UIDialog::DialogButtonType</a> { <a href="graphic.md#gga1bfefa0b46fd5a79a28d0c9a75114295a39ef626649e9e14c6561411867e50f00">OHOS::UIDialog::DialogButtonType::BUTTON1</a>, <a href="graphic.md#gga1bfefa0b46fd5a79a28d0c9a75114295a752441e0500e1807164a5f758ed93a8c">OHOS::UIDialog::DialogButtonType::BUTTON2</a>, <a href="graphic.md#gga1bfefa0b46fd5a79a28d0c9a75114295a86707c1d7552f48007cc25b77a2db21b">OHOS::UIDialog::DialogButtonType::BUTTON3</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1071282280093522"><a name="p1071282280093522"></a><a name="p1071282280093522"></a>Enumerates buttons in a dialog box. </p>
</td>
</tr>
<tr id="row1339126189093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p339919737093522"><a name="p339919737093522"></a><a name="p339919737093522"></a><a href="graphic.md#gabe3b64b11e5bf5d7b54e1039e40f306b">OHOS::UIDigitalClock::DisplayMode</a> { <a href="graphic.md#ggabe3b64b11e5bf5d7b54e1039e40f306bafc93e631e582de9e4128be8e6d41dbfe">OHOS::UIDigitalClock::DISPLAY_12_HOUR_NO_SECONDS</a>, <a href="graphic.md#ggabe3b64b11e5bf5d7b54e1039e40f306ba0c5adc8c80a47a33eb7bfcbcad0b4163">OHOS::UIDigitalClock::DISPLAY_24_HOUR_NO_SECONDS</a>, <a href="graphic.md#ggabe3b64b11e5bf5d7b54e1039e40f306baa5cbeab2c7366db7f33b2e95da20615b">OHOS::UIDigitalClock::DISPLAY_12_HOUR</a>, <a href="graphic.md#ggabe3b64b11e5bf5d7b54e1039e40f306ba833c0664bba32e6fe4a53a1c471d0eb8">OHOS::UIDigitalClock::DISPLAY_24_HOUR</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1170895857093522"><a name="p1170895857093522"></a><a name="p1170895857093522"></a>Enumerates the display modes of this digital clock. </p>
</td>
</tr>
<tr id="row109531669093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1949784857093522"><a name="p1949784857093522"></a><a name="p1949784857093522"></a><a href="graphic.md#gaa6aacc9ecbf5e20f22e50e542a69f472">OHOS::UIDigitalClock::TimeElement</a> { <a href="graphic.md#ggaa6aacc9ecbf5e20f22e50e542a69f472a8c15c8462a73ec9c9d9d3ad542ba4946">OHOS::UIDigitalClock::HOUR_ELEMENT</a>, <a href="graphic.md#ggaa6aacc9ecbf5e20f22e50e542a69f472ae60c24ee0bb6908798a770cb39034de2">OHOS::UIDigitalClock::MINUTE_ELEMENT</a>, <a href="graphic.md#ggaa6aacc9ecbf5e20f22e50e542a69f472a0299da12b65446f25e530d8d20881a1a">OHOS::UIDigitalClock::SECOND_ELEMENT</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1019398078093522"><a name="p1019398078093522"></a><a name="p1019398078093522"></a>Enumerates the time elements of this digital clock. </p>
</td>
</tr>
<tr id="row1921274527093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p31464539093522"><a name="p31464539093522"></a><a name="p31464539093522"></a><a href="graphic.md#gaf2ba9acac6cafffc549781ace0475cd5">OHOS::UILabel::LineBreakMode</a> : uint8_t {   <a href="graphic.md#ggaf2ba9acac6cafffc549781ace0475cd5a03a7da624ae08162b5e74ad67e50467f">OHOS::UILabel::LINE_BREAK_ADAPT</a> = 0, <a href="graphic.md#ggaf2ba9acac6cafffc549781ace0475cd5abc49de1d3936e957882efbb3259dc5be">OHOS::UILabel::LINE_BREAK_STRETCH</a>, <a href="graphic.md#ggaf2ba9acac6cafffc549781ace0475cd5a2d55ab62d9cead746eb1eaaad1e4e621">OHOS::UILabel::LINE_BREAK_WRAP</a>, <a href="graphic.md#ggaf2ba9acac6cafffc549781ace0475cd5ac15f8bb00b735e743b621f24a864b0ed">OHOS::UILabel::LINE_BREAK_ELLIPSIS</a>,   <a href="graphic.md#ggaf2ba9acac6cafffc549781ace0475cd5a6d3e13d5e53904899020e2c44f6ca82d">OHOS::UILabel::LINE_BREAK_MARQUEE</a>, <a href="graphic.md#ggaf2ba9acac6cafffc549781ace0475cd5a4111b08e919f919c314556753aa3ff46">OHOS::UILabel::LINE_BREAK_CLIP</a>, <a href="graphic.md#ggaf2ba9acac6cafffc549781ace0475cd5afb101ae817692c5bada96ba35f9a636d">OHOS::UILabel::LINE_BREAK_MAX</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1059290670093522"><a name="p1059290670093522"></a><a name="p1059290670093522"></a>Enumerates the display modes of a long text. </p>
</td>
</tr>
<tr id="row227470512093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p902861353093522"><a name="p902861353093522"></a><a name="p902861353093522"></a><em id="gaf8133740d5a3cb2f88a7f33cb11c6dbd"><a name="gaf8133740d5a3cb2f88a7f33cb11c6dbd"></a><a name="gaf8133740d5a3cb2f88a7f33cb11c6dbd"></a></em>OHOS::VirtualDeviceEvent::DeviceType </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1547233648093522"><a name="p1547233648093522"></a><a name="p1547233648093522"></a>Enumerates virtual device types. </p>
</td>
</tr>
<tr id="row710226170093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p530723237093522"><a name="p530723237093522"></a><a name="p530723237093522"></a><a href="graphic.md#ga3a3fb04ed2cda4017e6771c66b692141">OHOS::ColorMode</a> : uint8_t {   <a href="graphic.md#gga3a3fb04ed2cda4017e6771c66b692141a2f9573d43aecf2449480f8574b907683">OHOS::ARGB8888</a> = 0, <a href="graphic.md#gga3a3fb04ed2cda4017e6771c66b692141a5a962b82aadba3263c4f0de98262e30e">OHOS::RGB888</a>, <a href="graphic.md#gga3a3fb04ed2cda4017e6771c66b692141aecb2d8fad7e9b4cfcf53e5490c80651f">OHOS::RGB565</a>, <a href="graphic.md#gga3a3fb04ed2cda4017e6771c66b692141add58b331447c6b0e8963fc0f21b78033">OHOS::ARGB1555</a>,   <a href="graphic.md#gga3a3fb04ed2cda4017e6771c66b692141a21266607b0e5987609d37b52e63f5277">OHOS::ARGB4444</a>, <a href="graphic.md#gga3a3fb04ed2cda4017e6771c66b692141a6fbe6b11f436174cc18a931ae9fb85d3">OHOS::AL44</a>, <a href="graphic.md#gga3a3fb04ed2cda4017e6771c66b692141a7cc06e38b82b0bda251bfc8f0fc953b6">OHOS::AL88</a>, <a href="graphic.md#gga3a3fb04ed2cda4017e6771c66b692141a734f6e329eed35e1fe3f2f6d753665ac">OHOS::L1</a>,   <a href="graphic.md#gga3a3fb04ed2cda4017e6771c66b692141abe9263055f6c06124c0c8b513e1d87df">OHOS::L2</a>, <a href="graphic.md#gga3a3fb04ed2cda4017e6771c66b692141a493a9a5cd759369b982ad7e6ac0de13f">OHOS::L4</a>, <a href="graphic.md#gga3a3fb04ed2cda4017e6771c66b692141a8417494b1a72ed840b16752f32e7554c">OHOS::L8</a>, <a href="graphic.md#gga3a3fb04ed2cda4017e6771c66b692141a106ce1ddec51f2cb302686252d3c9560">OHOS::A1</a>,   <a href="graphic.md#gga3a3fb04ed2cda4017e6771c66b692141a365d0df177aa6e1b73fe0cddf72e88c7">OHOS::A2</a>, <a href="graphic.md#gga3a3fb04ed2cda4017e6771c66b692141ae49cb0538532ad895017e6f0d236d9da">OHOS::A4</a>, <a href="graphic.md#gga3a3fb04ed2cda4017e6771c66b692141a3b6524df7a87ae2800f8ac5b7417d5bc">OHOS::A8</a>, <a href="graphic.md#gga3a3fb04ed2cda4017e6771c66b692141a892afdfffaf015240b16b563599b0244">OHOS::UNKNOW</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p634052311093522"><a name="p634052311093522"></a><a name="p634052311093522"></a>colormode of image and font. </p>
</td>
</tr>
<tr id="row450119673093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1076876413093522"><a name="p1076876413093522"></a><a name="p1076876413093522"></a>: uint8_t {   <a href="graphic.md#ggaddb0623db8390d25f280888234d3ff2ca81f161546d7e1853d1c273e3810fe08b">OHOS::STYLE_BACKGROUND_COLOR</a>, <a href="graphic.md#ggaddb0623db8390d25f280888234d3ff2ca639cb87312225b97bde6e4d2be950b7f">OHOS::STYLE_BACKGROUND_OPA</a>, <a href="graphic.md#ggaddb0623db8390d25f280888234d3ff2ca4e61810ea3d5f385908eb8a4139027a5">OHOS::STYLE_BORDER_RADIUS</a>, <a href="graphic.md#ggaddb0623db8390d25f280888234d3ff2ca8fc5a572665a64ad6d27f70480de3b9a">OHOS::STYLE_BORDER_COLOR</a>,   <a href="graphic.md#ggaddb0623db8390d25f280888234d3ff2ca13df567903c15b369bf612bd97a9b886">OHOS::STYLE_BORDER_OPA</a>, <a href="graphic.md#ggaddb0623db8390d25f280888234d3ff2cae9bd454f8703c13e8385668b3ac19e41">OHOS::STYLE_BORDER_WIDTH</a>, <a href="graphic.md#ggaddb0623db8390d25f280888234d3ff2ca3231d33e8bb12cd0cf6911076c877892">OHOS::STYLE_PADDING_LEFT</a>, <a href="graphic.md#ggaddb0623db8390d25f280888234d3ff2ca8cc34b7c9774ce7dc940b7deeb64de1f">OHOS::STYLE_PADDING_RIGHT</a>,   <a href="graphic.md#ggaddb0623db8390d25f280888234d3ff2ca5225ed05b95d4a95a2c48250518c7c7f">OHOS::STYLE_PADDING_TOP</a>, <a href="graphic.md#ggaddb0623db8390d25f280888234d3ff2ca65e4dd92a76dc374b487cd24fa37199b">OHOS::STYLE_PADDING_BOTTOM</a>, <a href="graphic.md#ggaddb0623db8390d25f280888234d3ff2ca251e2a6ea777b9b6af8f6ccf79d060cc">OHOS::STYLE_MARGIN_LEFT</a>, <a href="graphic.md#ggaddb0623db8390d25f280888234d3ff2ca59ab9a49b6fe3f1fd42a79bf70398c70">OHOS::STYLE_MARGIN_RIGHT</a>,   <a href="graphic.md#ggaddb0623db8390d25f280888234d3ff2cad5dbc07ebf86daf81e30fcbf9051c3b6">OHOS::STYLE_MARGIN_TOP</a>, <a href="graphic.md#ggaddb0623db8390d25f280888234d3ff2ca05fa788c60b80429efd0e42fc5d3d4af">OHOS::STYLE_MARGIN_BOTTOM</a>, <a href="graphic.md#ggaddb0623db8390d25f280888234d3ff2cae63c7c001e11994f2ec952559c3a0d5f">OHOS::STYLE_IMAGE_OPA</a>, <a href="graphic.md#ggaddb0623db8390d25f280888234d3ff2ca21142f37831ece4dc6fe12a3474029a5">OHOS::STYLE_TEXT_COLOR</a>,   <a href="graphic.md#ggaddb0623db8390d25f280888234d3ff2ca7288938187d2b5c74d0d1789d73784a3">OHOS::STYLE_TEXT_FONT</a>, <a href="graphic.md#ggaddb0623db8390d25f280888234d3ff2caf705c0b077d93c8e5ee3cb4583c8ea87">OHOS::STYLE_LETTER_SPACE</a>, <a href="graphic.md#ggaddb0623db8390d25f280888234d3ff2ca06ab7c8b467da98902fe19f2b21595ba">OHOS::STYLE_LINE_SPACE</a>, <a href="graphic.md#ggaddb0623db8390d25f280888234d3ff2ca8889542f8ea0fc454895c6e245d9cfdf">OHOS::STYLE_TEXT_OPA</a>,   <a href="graphic.md#ggaddb0623db8390d25f280888234d3ff2ca59ce09cf70ef205a7ff081f10d6c1380">OHOS::STYLE_LINE_COLOR</a>, <a href="graphic.md#ggaddb0623db8390d25f280888234d3ff2cadb7984bac1deeffafc3f04169480937e">OHOS::STYLE_LINE_WIDTH</a>, <a href="graphic.md#ggaddb0623db8390d25f280888234d3ff2ca7aa7e8dfa8b88cc3ef77c4c3b23a5ea2">OHOS::STYLE_LINE_OPA</a>, <a href="graphic.md#ggaddb0623db8390d25f280888234d3ff2ca420aa5184ddfd2e95632095c92dfbee5">OHOS::STYLE_LINE_CAP</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p282209771093522"><a name="p282209771093522"></a><a name="p282209771093522"></a>Enumerates keys of styles. </p>
</td>
</tr>
<tr id="row2116895646093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p875825142093522"><a name="p875825142093522"></a><a name="p875825142093522"></a><a href="graphic.md#ga2db3928cdf793f4950245a6841dd43d6">OHOS::CapType</a> : uint8_t { <a href="graphic.md#gga2db3928cdf793f4950245a6841dd43d6a7692381654eff26893e03ac1983c8f45">OHOS::CAP_NONE</a>, <a href="graphic.md#gga2db3928cdf793f4950245a6841dd43d6ada0a5a2f0100d929e9e1d1d31ef26cce">OHOS::CAP_ROUND</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2128663002093522"><a name="p2128663002093522"></a><a name="p2128663002093522"></a>Enumerates cap styles. </p>
</td>
</tr>
<tr id="row1593014940093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p264806940093522"><a name="p264806940093522"></a><a name="p264806940093522"></a><a href="graphic.md#ga75d850e3abff6c2f617b689a0cb9a3d1">OHOS::SysInfo::FPSCalculateType</a> { <a href="graphic.md#gga75d850e3abff6c2f617b689a0cb9a3d1a26a841fb9a10881591dc79dae38e2d7f">OHOS::SysInfo::FPS_CT_FIXED_TIME</a>, <a href="graphic.md#gga75d850e3abff6c2f617b689a0cb9a3d1a17fdb75ff7e9afb4165349a3d8300f3c">OHOS::SysInfo::FPS_CT_AVERAGE_SAMPLING</a>, <a href="graphic.md#gga75d850e3abff6c2f617b689a0cb9a3d1afcc7226b2c9012f2993b7044a80cbed5">OHOS::SysInfo::FPS_CT_PRECISE_SAMPLING</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1190566102093522"><a name="p1190566102093522"></a><a name="p1190566102093522"></a>Enumerates the FPS capture types. </p>
</td>
</tr>
</tbody>
</table>

## Functions<a name="func-members"></a>

<a name="table894147120093522"></a>
<table><thead align="left"><tr id="row24246320093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1105843454093522"><a name="p1105843454093522"></a><a name="p1105843454093522"></a>Function Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p14151264093522"><a name="p14151264093522"></a><a name="p14151264093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1999620136093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1933320801093522"><a name="p1933320801093522"></a><a name="p1933320801093522"></a><a href="graphic.md#gace3debcfa4200de1951a8eae6421e5aa">OHOS::AnimatorCallback::Callback</a> (<a href="ohos-uiview.md">UIView</a> *view)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p589656140093522"><a name="p589656140093522"></a><a name="p589656140093522"></a>virtual void </p>
<p id="p1006863017093522"><a name="p1006863017093522"></a><a name="p1006863017093522"></a>Called when each frame starts. This is a pure virtual function, which needs your inheritance and implementation. </p>
</td>
</tr>
<tr id="row2038070090093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1669515558093522"><a name="p1669515558093522"></a><a name="p1669515558093522"></a><a href="graphic.md#ga33875ecdc72e4d8076be696a35667a8f">OHOS::AnimatorCallback::OnStop</a> (<a href="ohos-uiview.md">UIView</a> &amp;view)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1575011969093522"><a name="p1575011969093522"></a><a name="p1575011969093522"></a>virtual void </p>
<p id="p1178674877093522"><a name="p1178674877093522"></a><a name="p1178674877093522"></a>Called when an animator stops. This is a pure virtual function, which needs your inheritance and implementation. </p>
</td>
</tr>
<tr id="row2015019709093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p423950019093522"><a name="p423950019093522"></a><a name="p423950019093522"></a><a href="graphic.md#ga783aca5777750141552a5aba974ffdff">OHOS::AnimatorCallback::~AnimatorCallback</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2124319766093522"><a name="p2124319766093522"></a><a name="p2124319766093522"></a>virtual </p>
<p id="p1375317843093522"><a name="p1375317843093522"></a><a name="p1375317843093522"></a>A default destructor used to delete an <strong id="b1528481424093522"><a name="b1528481424093522"></a><a name="b1528481424093522"></a><a href="ohos-animatorcallback.md">AnimatorCallback</a></strong> instance. </p>
</td>
</tr>
<tr id="row1036369474093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1553291691093522"><a name="p1553291691093522"></a><a name="p1553291691093522"></a><a href="graphic.md#gabcc3afbe99010e70e3e6dbd780cb5974">OHOS::Animator::Animator</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1568359618093522"><a name="p1568359618093522"></a><a name="p1568359618093522"></a> </p>
<p id="p1277674327093522"><a name="p1277674327093522"></a><a name="p1277674327093522"></a>A default constructor used to create an <strong id="b554126999093522"><a name="b554126999093522"></a><a name="b554126999093522"></a><a href="ohos-animator.md">Animator</a></strong> instance. </p>
</td>
</tr>
<tr id="row926981432093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1067759575093522"><a name="p1067759575093522"></a><a name="p1067759575093522"></a><a href="graphic.md#ga79be500c40ba8743dd58dc633a732b53">OHOS::Animator::Animator</a> (<a href="ohos-animatorcallback.md">AnimatorCallback</a> *callback, <a href="ohos-uiview.md">UIView</a> *view, uint32_t <a href="en-us_topic_0000001054879478.md#gae7841e681c8c9d59818568d39553642c">time</a>, bool repeat)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p853718837093522"><a name="p853718837093522"></a><a name="p853718837093522"></a> </p>
<p id="p1629516210093522"><a name="p1629516210093522"></a><a name="p1629516210093522"></a>A constructor used to create an <strong id="b549493115093522"><a name="b549493115093522"></a><a name="b549493115093522"></a><a href="ohos-animator.md">Animator</a></strong> instance. </p>
</td>
</tr>
<tr id="row2016544643093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1624785868093522"><a name="p1624785868093522"></a><a name="p1624785868093522"></a><a href="graphic.md#gaee2a71f97b102654ca3b7ded4b5ce350">OHOS::Animator::~Animator</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p25547453093522"><a name="p25547453093522"></a><a name="p25547453093522"></a>virtual </p>
<p id="p834139846093522"><a name="p834139846093522"></a><a name="p834139846093522"></a>A destructor used to delete the <strong id="b920575311093522"><a name="b920575311093522"></a><a name="b920575311093522"></a><a href="ohos-animator.md">Animator</a></strong> instance. </p>
</td>
</tr>
<tr id="row1052852312093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1314927719093522"><a name="p1314927719093522"></a><a name="p1314927719093522"></a><a href="graphic.md#gad56477fe4b6d0158082e841e327c1bf6">OHOS::Animator::Start</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p758028049093522"><a name="p758028049093522"></a><a name="p758028049093522"></a>void </p>
<p id="p1570505538093522"><a name="p1570505538093522"></a><a name="p1570505538093522"></a>Starts this animator. </p>
</td>
</tr>
<tr id="row2046768606093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2135079330093522"><a name="p2135079330093522"></a><a name="p2135079330093522"></a><a href="graphic.md#gad670cee429a5535149db0f8b3828e951">OHOS::Animator::Stop</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1803010646093522"><a name="p1803010646093522"></a><a name="p1803010646093522"></a>void </p>
<p id="p1552552033093522"><a name="p1552552033093522"></a><a name="p1552552033093522"></a>Stops this animator. </p>
</td>
</tr>
<tr id="row564296266093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p916164928093522"><a name="p916164928093522"></a><a name="p916164928093522"></a><a href="graphic.md#ga4dd9d23ebff1359bd1145fd2f26e1be2">OHOS::Animator::Pause</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p507800930093522"><a name="p507800930093522"></a><a name="p507800930093522"></a>void </p>
<p id="p256662831093522"><a name="p256662831093522"></a><a name="p256662831093522"></a>Pauses this animator. </p>
</td>
</tr>
<tr id="row1815550420093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2014301808093522"><a name="p2014301808093522"></a><a name="p2014301808093522"></a><a href="graphic.md#ga645bbd33356bd708636a94c3d95c282d">OHOS::Animator::Resume</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p255455869093522"><a name="p255455869093522"></a><a name="p255455869093522"></a>void </p>
<p id="p1406450959093522"><a name="p1406450959093522"></a><a name="p1406450959093522"></a>Resumes this animator from where it was paused. </p>
</td>
</tr>
<tr id="row1471843792093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1105049261093522"><a name="p1105049261093522"></a><a name="p1105049261093522"></a><a href="graphic.md#gafd0166df63bed582022ed93175dd3179">OHOS::Animator::GetState</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p679528859093522"><a name="p679528859093522"></a><a name="p679528859093522"></a>uint8_t </p>
<p id="p342433987093522"><a name="p342433987093522"></a><a name="p342433987093522"></a>Obtains the current state of this animator. </p>
</td>
</tr>
<tr id="row1863493367093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1109213478093522"><a name="p1109213478093522"></a><a name="p1109213478093522"></a><a href="graphic.md#gab8ec3815f5e42605a51a328c1b0857dd">OHOS::Animator::SetState</a> (uint8_t state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p468323391093522"><a name="p468323391093522"></a><a name="p468323391093522"></a>void </p>
<p id="p1980225016093522"><a name="p1980225016093522"></a><a name="p1980225016093522"></a>Sets the current state for this animator. </p>
</td>
</tr>
<tr id="row909392464093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1745504866093522"><a name="p1745504866093522"></a><a name="p1745504866093522"></a><a href="graphic.md#gac05ba70bafa9887dc23ea4ba69da632d">OHOS::Animator::GetTime</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1520770593093522"><a name="p1520770593093522"></a><a name="p1520770593093522"></a>uint32_t </p>
<p id="p626297990093522"><a name="p626297990093522"></a><a name="p626297990093522"></a>Obtains the total duration of this animator. </p>
</td>
</tr>
<tr id="row553003474093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p694968341093522"><a name="p694968341093522"></a><a name="p694968341093522"></a><a href="graphic.md#ga5a2bfa5fb257b2116d08ad5ae254327c">OHOS::Animator::SetTime</a> (uint32_t <a href="en-us_topic_0000001054879478.md#gae7841e681c8c9d59818568d39553642c">time</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1122917804093522"><a name="p1122917804093522"></a><a name="p1122917804093522"></a>void </p>
<p id="p1885325913093522"><a name="p1885325913093522"></a><a name="p1885325913093522"></a>Sets the total duration for this animator. </p>
</td>
</tr>
<tr id="row183834720093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1172060271093522"><a name="p1172060271093522"></a><a name="p1172060271093522"></a><a href="graphic.md#ga18a8b8b9ceb344e6660a5c0de5a9ce1f">OHOS::Animator::GetRunTime</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1409954345093522"><a name="p1409954345093522"></a><a name="p1409954345093522"></a>uint32_t </p>
<p id="p426551862093522"><a name="p426551862093522"></a><a name="p426551862093522"></a>Obtains the running time of this animator. </p>
</td>
</tr>
<tr id="row41552297093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p903092022093522"><a name="p903092022093522"></a><a name="p903092022093522"></a><a href="graphic.md#ga4d5ff5057df28da1bc99d08070312f24">OHOS::Animator::SetRunTime</a> (uint32_t runTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p618507190093522"><a name="p618507190093522"></a><a name="p618507190093522"></a>void </p>
<p id="p554526438093522"><a name="p554526438093522"></a><a name="p554526438093522"></a>Sets the running time for this animator. </p>
</td>
</tr>
<tr id="row1365122045093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p713885862093522"><a name="p713885862093522"></a><a name="p713885862093522"></a><a href="graphic.md#gacd3c360c8a3f6b5aeffcf10c1a1588da">OHOS::Animator::IsRepeat</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1278156527093522"><a name="p1278156527093522"></a><a name="p1278156527093522"></a>bool </p>
<p id="p1944076263093522"><a name="p1944076263093522"></a><a name="p1944076263093522"></a>Checks whether this animator is repeated. </p>
</td>
</tr>
<tr id="row1702312040093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1937415334093522"><a name="p1937415334093522"></a><a name="p1937415334093522"></a><a href="graphic.md#ga3ed818079b3501922f422b150f891d13">OHOS::AnimatorManager::GetInstance</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p292314859093522"><a name="p292314859093522"></a><a name="p292314859093522"></a>static <a href="ohos-animatormanager.md">AnimatorManager</a> * </p>
<p id="p1753937666093522"><a name="p1753937666093522"></a><a name="p1753937666093522"></a>Obtains the <strong id="b2021536228093522"><a name="b2021536228093522"></a><a name="b2021536228093522"></a><a href="ohos-animatormanager.md">AnimatorManager</a></strong> instance. </p>
</td>
</tr>
<tr id="row742480559093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2106146762093522"><a name="p2106146762093522"></a><a name="p2106146762093522"></a><em id="gadfc9e9cf812f172fb1b6ca7efb7ba099"><a name="gadfc9e9cf812f172fb1b6ca7efb7ba099"></a><a name="gadfc9e9cf812f172fb1b6ca7efb7ba099"></a></em>OHOS::AnimatorManager::Init () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p727845139093522"><a name="p727845139093522"></a><a name="p727845139093522"></a><strong id="b1591149998"><a name="b1591149998"></a><a name="b1591149998"></a></strong> void </p>
<p id="p266752407093522"><a name="p266752407093522"></a><a name="p266752407093522"></a>Initializes this task. </p>
</td>
</tr>
<tr id="row1302701969093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2141319873093522"><a name="p2141319873093522"></a><a name="p2141319873093522"></a><a href="graphic.md#ga8b60ed045dc2a3370498a3e6922d5400">OHOS::AnimatorManager::Add</a> (<a href="ohos-animator.md">Animator</a> *animator)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1994703942093522"><a name="p1994703942093522"></a><a name="p1994703942093522"></a>void </p>
<p id="p39667960093522"><a name="p39667960093522"></a><a name="p39667960093522"></a>Adds the <strong id="b1502784219093522"><a name="b1502784219093522"></a><a name="b1502784219093522"></a><a href="ohos-animator.md">Animator</a></strong> instance to the <strong id="b2051416629093522"><a name="b2051416629093522"></a><a name="b2051416629093522"></a><a href="ohos-animatormanager.md">AnimatorManager</a></strong> linked list for management, so that the <strong id="b254465665093522"><a name="b254465665093522"></a><a name="b254465665093522"></a>Run</strong> function of the <strong id="b1891062493093522"><a name="b1891062493093522"></a><a name="b1891062493093522"></a><a href="ohos-animator.md">Animator</a></strong> class is called once for each frame. </p>
</td>
</tr>
<tr id="row771677277093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1248226046093522"><a name="p1248226046093522"></a><a name="p1248226046093522"></a><a href="graphic.md#ga493d53a9e4a47b79d30c0d37f96a69da">OHOS::AnimatorManager::Remove</a> (const <a href="ohos-animator.md">Animator</a> *animator)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1680896685093522"><a name="p1680896685093522"></a><a name="p1680896685093522"></a>void </p>
<p id="p1185723285093522"><a name="p1185723285093522"></a><a name="p1185723285093522"></a>Removes the <strong id="b979605410093522"><a name="b979605410093522"></a><a name="b979605410093522"></a><a href="ohos-animator.md">Animator</a></strong> instance from the <strong id="b1398976299093522"><a name="b1398976299093522"></a><a name="b1398976299093522"></a><a href="ohos-animatormanager.md">AnimatorManager</a></strong> linked list. </p>
</td>
</tr>
<tr id="row229994465093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2070747485093522"><a name="p2070747485093522"></a><a name="p2070747485093522"></a><em id="ga8a7c3d733fc2112171a2e075dd425a5c"><a name="ga8a7c3d733fc2112171a2e075dd425a5c"></a><a name="ga8a7c3d733fc2112171a2e075dd425a5c"></a></em>OHOS::AnimatorManager::Callback () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p381900827093522"><a name="p381900827093522"></a><a name="p381900827093522"></a><strong id="b449035877"><a name="b449035877"></a><a name="b449035877"></a></strong> void </p>
<p id="p1758341767093522"><a name="p1758341767093522"></a><a name="p1758341767093522"></a>Called when this task is executed. </p>
</td>
</tr>
<tr id="row690955517093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1117887518093522"><a name="p1117887518093522"></a><a name="p1117887518093522"></a><a href="graphic.md#gab7cf0e64a0d363d8b448262d719ac97a">OHOS::EasingEquation::SetBackOvershoot</a> (double overshoot)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p519028576093522"><a name="p519028576093522"></a><a name="p519028576093522"></a>static void </p>
<p id="p1689029979093522"><a name="p1689029979093522"></a><a name="p1689029979093522"></a>Sets the parameter <strong id="b1018734393093522"><a name="b1018734393093522"></a><a name="b1018734393093522"></a>s</strong> in the equation <strong id="b323192635093522"><a name="b323192635093522"></a><a name="b323192635093522"></a>(s+1)*t^3 - s*t^2</strong> for a back easing. </p>
</td>
</tr>
<tr id="row1592080289093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1614951277093522"><a name="p1614951277093522"></a><a name="p1614951277093522"></a><a href="graphic.md#ga4598524b16a33de497fa9321d887d3b1">OHOS::EasingEquation::BackEaseIn</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p606446913093522"><a name="p606446913093522"></a><a name="p606446913093522"></a>static int16_t </p>
<p id="p1033595645093522"><a name="p1033595645093522"></a><a name="p1033595645093522"></a>Eases in with an overshoot. </p>
</td>
</tr>
<tr id="row1890795330093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p442239264093522"><a name="p442239264093522"></a><a name="p442239264093522"></a><a href="graphic.md#ga7399f01f7abc33413bf25aa17a99c2f2">OHOS::EasingEquation::BackEaseOut</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p519369037093522"><a name="p519369037093522"></a><a name="p519369037093522"></a>static int16_t </p>
<p id="p663835954093522"><a name="p663835954093522"></a><a name="p663835954093522"></a>Eases out with an overshoot. </p>
</td>
</tr>
<tr id="row1124908432093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1849250230093522"><a name="p1849250230093522"></a><a name="p1849250230093522"></a><a href="graphic.md#gac7c2a9a1dfce384438a3bd9d6c0c2525">OHOS::EasingEquation::BackEaseInOut</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1894872458093522"><a name="p1894872458093522"></a><a name="p1894872458093522"></a>static int16_t </p>
<p id="p167891649093522"><a name="p167891649093522"></a><a name="p167891649093522"></a>Eases in and then out with an overshoot. </p>
</td>
</tr>
<tr id="row663114029093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1215000772093522"><a name="p1215000772093522"></a><a name="p1215000772093522"></a><a href="graphic.md#ga446c958f14b3d6de24e2c1bab171bba2">OHOS::EasingEquation::CircEaseIn</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p969590171093522"><a name="p969590171093522"></a><a name="p969590171093522"></a>static int16_t </p>
<p id="p190626762093522"><a name="p190626762093522"></a><a name="p190626762093522"></a>Eases in shaping like a circular curve. </p>
</td>
</tr>
<tr id="row1404972983093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p388098134093522"><a name="p388098134093522"></a><a name="p388098134093522"></a><a href="graphic.md#gaab8fad8664d648df7e5e224b68ee54ad">OHOS::EasingEquation::CircEaseOut</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1655901062093522"><a name="p1655901062093522"></a><a name="p1655901062093522"></a>static int16_t </p>
<p id="p627358458093522"><a name="p627358458093522"></a><a name="p627358458093522"></a>Eases out shaping like a circular curve. </p>
</td>
</tr>
<tr id="row689034058093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p528065662093522"><a name="p528065662093522"></a><a name="p528065662093522"></a><a href="graphic.md#ga68c392dad14e1bef192b085aeec6ca9b">OHOS::EasingEquation::CircEaseInOut</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p779934580093522"><a name="p779934580093522"></a><a name="p779934580093522"></a>static int16_t </p>
<p id="p1432105576093522"><a name="p1432105576093522"></a><a name="p1432105576093522"></a>Eases in and then out shaping like a circular curve. </p>
</td>
</tr>
<tr id="row1223879888093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1667467141093522"><a name="p1667467141093522"></a><a name="p1667467141093522"></a><a href="graphic.md#ga5c91a83cc424fb7e4e1f40cae6b3be66">OHOS::EasingEquation::CubicEaseIn</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1013280207093522"><a name="p1013280207093522"></a><a name="p1013280207093522"></a>static int16_t </p>
<p id="p1142691123093522"><a name="p1142691123093522"></a><a name="p1142691123093522"></a>Eases in shaping like a cubic curve. </p>
</td>
</tr>
<tr id="row1400217291093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1406860574093522"><a name="p1406860574093522"></a><a name="p1406860574093522"></a><a href="graphic.md#ga529a948d9f6711a5f2726af5f10d7a48">OHOS::EasingEquation::CubicEaseOut</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p725614615093522"><a name="p725614615093522"></a><a name="p725614615093522"></a>static int16_t </p>
<p id="p1118002016093522"><a name="p1118002016093522"></a><a name="p1118002016093522"></a>Eases out shaping like a cubic curve. </p>
</td>
</tr>
<tr id="row176339607093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1046365594093522"><a name="p1046365594093522"></a><a name="p1046365594093522"></a><a href="graphic.md#gad99ea4ed828f274f111f492eea123cb4">OHOS::EasingEquation::CubicEaseInOut</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p626302885093522"><a name="p626302885093522"></a><a name="p626302885093522"></a>static int16_t </p>
<p id="p1967747160093522"><a name="p1967747160093522"></a><a name="p1967747160093522"></a>Eases in and then out shaping like a cubic curve. </p>
</td>
</tr>
<tr id="row2080643857093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1916967968093522"><a name="p1916967968093522"></a><a name="p1916967968093522"></a><a href="graphic.md#ga8af9a1f527ffaa5006cf0ee867f7d7d0">OHOS::EasingEquation::LinearEaseNone</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2141299143093522"><a name="p2141299143093522"></a><a name="p2141299143093522"></a>static int16_t </p>
<p id="p976978921093522"><a name="p976978921093522"></a><a name="p976978921093522"></a>Displays no linear easing effects. </p>
</td>
</tr>
<tr id="row1173488804093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p462028464093522"><a name="p462028464093522"></a><a name="p462028464093522"></a><a href="graphic.md#ga72a9b93086c8466767942863a7d5cb78">OHOS::EasingEquation::QuadEaseIn</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1708503480093522"><a name="p1708503480093522"></a><a name="p1708503480093522"></a>static int16_t </p>
<p id="p1006083012093522"><a name="p1006083012093522"></a><a name="p1006083012093522"></a>Eases in shaping like a quadratic curve. </p>
</td>
</tr>
<tr id="row1869305042093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2106453063093522"><a name="p2106453063093522"></a><a name="p2106453063093522"></a><a href="graphic.md#ga0c9cd2781e17f7077b4c9d5847eb90c8">OHOS::EasingEquation::QuadEaseOut</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1855186126093522"><a name="p1855186126093522"></a><a name="p1855186126093522"></a>static int16_t </p>
<p id="p1108161216093522"><a name="p1108161216093522"></a><a name="p1108161216093522"></a>Eases out shaping like a quadratic curve. </p>
</td>
</tr>
<tr id="row939941704093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1325494814093522"><a name="p1325494814093522"></a><a name="p1325494814093522"></a><a href="graphic.md#ga8f62ddc3f1b2b33904845601108d6f64">OHOS::EasingEquation::QuadEaseInOut</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p568911821093522"><a name="p568911821093522"></a><a name="p568911821093522"></a>static int16_t </p>
<p id="p1259525189093522"><a name="p1259525189093522"></a><a name="p1259525189093522"></a>Eases in and then out shaping like a quadratic curve. </p>
</td>
</tr>
<tr id="row113765355093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1837554774093522"><a name="p1837554774093522"></a><a name="p1837554774093522"></a><a href="graphic.md#ga9ddf5221cdde5f6a37096300847a50ac">OHOS::EasingEquation::QuintEaseIn</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1148857016093522"><a name="p1148857016093522"></a><a name="p1148857016093522"></a>static int16_t </p>
<p id="p712923694093522"><a name="p712923694093522"></a><a name="p712923694093522"></a>Eases in shaping like a quintic curve. </p>
</td>
</tr>
<tr id="row940475662093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p212483301093522"><a name="p212483301093522"></a><a name="p212483301093522"></a><a href="graphic.md#gaa61e26b2bff3f69edced36d0c0d17a45">OHOS::EasingEquation::QuintEaseOut</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1508636535093522"><a name="p1508636535093522"></a><a name="p1508636535093522"></a>static int16_t </p>
<p id="p431440551093522"><a name="p431440551093522"></a><a name="p431440551093522"></a>Eases out shaping like a quintic curve. </p>
</td>
</tr>
<tr id="row1761053058093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1152339661093522"><a name="p1152339661093522"></a><a name="p1152339661093522"></a><a href="graphic.md#ga8bea02f98d26a97072f32369370a421b">OHOS::EasingEquation::QuintEaseInOut</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1195670217093522"><a name="p1195670217093522"></a><a name="p1195670217093522"></a>static int16_t </p>
<p id="p37981148093522"><a name="p37981148093522"></a><a name="p37981148093522"></a>Eases in and then out shaping like a quintic curve. </p>
</td>
</tr>
<tr id="row397345050093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1911521462093522"><a name="p1911521462093522"></a><a name="p1911521462093522"></a><a href="graphic.md#ga89ee91a569b73c6ebb29ae4dfd2777f9">OHOS::EasingEquation::SineEaseIn</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1289633611093522"><a name="p1289633611093522"></a><a name="p1289633611093522"></a>static int16_t </p>
<p id="p492294963093522"><a name="p492294963093522"></a><a name="p492294963093522"></a>Eases in shaping like a sinusoidal curve. </p>
</td>
</tr>
<tr id="row122425698093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1151835537093522"><a name="p1151835537093522"></a><a name="p1151835537093522"></a><a href="graphic.md#ga34018757e69d7920557030f33393048d">OHOS::EasingEquation::SineEaseOut</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2090983484093522"><a name="p2090983484093522"></a><a name="p2090983484093522"></a>static int16_t </p>
<p id="p551768789093522"><a name="p551768789093522"></a><a name="p551768789093522"></a>Eases out shaping like a sinusoidal curve. </p>
</td>
</tr>
<tr id="row206575919093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1054163354093522"><a name="p1054163354093522"></a><a name="p1054163354093522"></a><a href="graphic.md#ga2c3b14232a67095b0b941bae3a7b2e54">OHOS::EasingEquation::SineEaseInOut</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1346878754093522"><a name="p1346878754093522"></a><a name="p1346878754093522"></a>static int16_t </p>
<p id="p1243228550093522"><a name="p1243228550093522"></a><a name="p1243228550093522"></a>Eases in and then out shaping like a sinusoidal curve. </p>
</td>
</tr>
<tr id="row645417530093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1541118382093522"><a name="p1541118382093522"></a><a name="p1541118382093522"></a><a href="graphic.md#ga9d6eaf28db711bc05e1cd03c5df293eb">OHOS::Interpolation::GetBezierInterpolation</a> (int16_t t, int16_t u0, int16_t u1, int16_t u2, int16_t u3)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p708990126093522"><a name="p708990126093522"></a><a name="p708990126093522"></a>static int16_t </p>
<p id="p1426676517093522"><a name="p1426676517093522"></a><a name="p1426676517093522"></a>Obtains the value calculated by the cubic Bezier equation. </p>
</td>
</tr>
<tr id="row1716376648093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1710087194093522"><a name="p1710087194093522"></a><a name="p1710087194093522"></a><a href="graphic.md#gae12573eec4d4db025e96b5d9679e4b3f">OHOS::Color::GetMixColor</a> (<a href="ohos-color32.md">ColorType</a> c1, <a href="ohos-color32.md">ColorType</a> c2, uint8_t mix)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p438144778093522"><a name="p438144778093522"></a><a name="p438144778093522"></a>static <a href="ohos-color32.md">ColorType</a> </p>
<p id="p2060725629093522"><a name="p2060725629093522"></a><a name="p2060725629093522"></a>Mixes two colors (color 1 and color 2) based on a specified opacity. </p>
</td>
</tr>
<tr id="row1596047597093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1178145247093522"><a name="p1178145247093522"></a><a name="p1178145247093522"></a><a href="graphic.md#ga0c3bb99c625896eeab6eb0acbe14f437">OHOS::Color::GetColorFromRGB</a> (uint8_t r8, uint8_t g8, uint8_t b8)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p149289161093522"><a name="p149289161093522"></a><a name="p149289161093522"></a>static <a href="ohos-color32.md">ColorType</a> </p>
<p id="p1177026298093522"><a name="p1177026298093522"></a><a name="p1177026298093522"></a>Obtains the color based on the RGB color value. </p>
</td>
</tr>
<tr id="row2118650321093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p960662662093522"><a name="p960662662093522"></a><a name="p960662662093522"></a><a href="graphic.md#ga0a7e632d54e39d1d46e64c6cf20690cc">OHOS::Color::GetColorFromRGBA</a> (uint8_t r8, uint8_t g8, uint8_t b8, uint8_t alpha)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p551380726093522"><a name="p551380726093522"></a><a name="p551380726093522"></a>static <a href="ohos-color32.md">ColorType</a> </p>
<p id="p125085565093522"><a name="p125085565093522"></a><a name="p125085565093522"></a>Obtains the color based on the RGBA color value. </p>
</td>
</tr>
<tr id="row1406723792093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1000017749093522"><a name="p1000017749093522"></a><a name="p1000017749093522"></a><a href="graphic.md#ga461b46dd76842ad4b0ffdc88202223a7">OHOS::Color::ColorTo32</a> (<a href="ohos-color32.md">ColorType</a> color)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1868226090093522"><a name="p1868226090093522"></a><a name="p1868226090093522"></a>static uint32_t </p>
<p id="p1572776564093522"><a name="p1572776564093522"></a><a name="p1572776564093522"></a>Converts color data into the RGBA8888 format. </p>
</td>
</tr>
<tr id="row1723294351093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1856598246093522"><a name="p1856598246093522"></a><a name="p1856598246093522"></a><a href="graphic.md#gaaca42d51bc5f28d5dbd5b1635be50224">OHOS::Color::ColorTo32</a> (<a href="ohos-color16.md">Color16</a> color, uint8_t alpha)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p389793153093522"><a name="p389793153093522"></a><a name="p389793153093522"></a>static uint32_t </p>
<p id="p553876415093522"><a name="p553876415093522"></a><a name="p553876415093522"></a>Converts color data with the 16-bit color depth into the RGBA8888 format. </p>
</td>
</tr>
<tr id="row994871543093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1616543097093522"><a name="p1616543097093522"></a><a name="p1616543097093522"></a><a href="graphic.md#ga2a6a0bd067a05ee35793fefc8f9f4d1e">OHOS::Color::ColorTo16</a> (<a href="ohos-color32.md">Color32</a> color)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p450087757093522"><a name="p450087757093522"></a><a name="p450087757093522"></a>static uint16_t </p>
<p id="p128034146093522"><a name="p128034146093522"></a><a name="p128034146093522"></a>Converts color data from the RGBA8888 format into the RGB565 format. </p>
</td>
</tr>
<tr id="row810343205093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p420794955093522"><a name="p420794955093522"></a><a name="p420794955093522"></a><a href="graphic.md#gad98c45688cd59b11e9e766e62e24252f">OHOS::Color::White</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2072724916093522"><a name="p2072724916093522"></a><a name="p2072724916093522"></a>static <a href="ohos-color32.md">ColorType</a> </p>
<p id="p241338557093522"><a name="p241338557093522"></a><a name="p241338557093522"></a>Obtains the color data of white. </p>
</td>
</tr>
<tr id="row9048539093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1578201092093522"><a name="p1578201092093522"></a><a name="p1578201092093522"></a><a href="graphic.md#ga6dcfcd450637398b7b7d28ce7464d153">OHOS::Color::Silver</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p579008236093522"><a name="p579008236093522"></a><a name="p579008236093522"></a>static <a href="ohos-color32.md">ColorType</a> </p>
<p id="p1227915473093522"><a name="p1227915473093522"></a><a name="p1227915473093522"></a>Obtains the color data of silver. </p>
</td>
</tr>
<tr id="row1641938694093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1271568182093522"><a name="p1271568182093522"></a><a name="p1271568182093522"></a><a href="graphic.md#ga920421d6dc1d9fbc21d5002948eb43c6">OHOS::Color::Gray</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1576633409093522"><a name="p1576633409093522"></a><a name="p1576633409093522"></a>static <a href="ohos-color32.md">ColorType</a> </p>
<p id="p1903346337093522"><a name="p1903346337093522"></a><a name="p1903346337093522"></a>Obtains the color data of gray. </p>
</td>
</tr>
<tr id="row526080381093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1760026309093522"><a name="p1760026309093522"></a><a name="p1760026309093522"></a><a href="graphic.md#gac821c879969c94ec048117738e4bbef2">OHOS::Color::Black</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p410593742093522"><a name="p410593742093522"></a><a name="p410593742093522"></a>static <a href="ohos-color32.md">ColorType</a> </p>
<p id="p1653798793093522"><a name="p1653798793093522"></a><a name="p1653798793093522"></a>Obtains the color data of black. </p>
</td>
</tr>
<tr id="row1740042372093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1879740637093522"><a name="p1879740637093522"></a><a name="p1879740637093522"></a><a href="graphic.md#gac7d29e91471253cbef9d709d74bc0d78">OHOS::Color::Red</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p551199050093522"><a name="p551199050093522"></a><a name="p551199050093522"></a>static <a href="ohos-color32.md">ColorType</a> </p>
<p id="p1830173057093522"><a name="p1830173057093522"></a><a name="p1830173057093522"></a>Obtains the color data of red. </p>
</td>
</tr>
<tr id="row137681512093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p30297546093522"><a name="p30297546093522"></a><a name="p30297546093522"></a><a href="graphic.md#gaf8342e9323109066e57434445de4423e">OHOS::Color::Maroon</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p774578562093522"><a name="p774578562093522"></a><a name="p774578562093522"></a>static <a href="ohos-color32.md">ColorType</a> </p>
<p id="p1314128122093522"><a name="p1314128122093522"></a><a name="p1314128122093522"></a>Obtains the color data of maroon. </p>
</td>
</tr>
<tr id="row751729423093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1938985424093522"><a name="p1938985424093522"></a><a name="p1938985424093522"></a><a href="graphic.md#gadd545c06bdd497b259179379e6910e15">OHOS::Color::Yellow</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p241162002093522"><a name="p241162002093522"></a><a name="p241162002093522"></a>static <a href="ohos-color32.md">ColorType</a> </p>
<p id="p967856844093522"><a name="p967856844093522"></a><a name="p967856844093522"></a>Obtains the color data of yellow. </p>
</td>
</tr>
<tr id="row1655992462093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p288114318093522"><a name="p288114318093522"></a><a name="p288114318093522"></a><a href="graphic.md#ga8c8d03f5579dbb976119cee384856e3b">OHOS::Color::Olive</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2109962429093522"><a name="p2109962429093522"></a><a name="p2109962429093522"></a>static <a href="ohos-color32.md">ColorType</a> </p>
<p id="p2119077559093522"><a name="p2119077559093522"></a><a name="p2119077559093522"></a>Obtains the color data of olive. </p>
</td>
</tr>
<tr id="row63475300093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p810274311093522"><a name="p810274311093522"></a><a name="p810274311093522"></a><a href="graphic.md#ga629dc5c95263df097a06b207a36b1dca">OHOS::Color::Lime</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1785664608093522"><a name="p1785664608093522"></a><a name="p1785664608093522"></a>static <a href="ohos-color32.md">ColorType</a> </p>
<p id="p835155725093522"><a name="p835155725093522"></a><a name="p835155725093522"></a>Obtains the color data of lime. </p>
</td>
</tr>
<tr id="row1525688905093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1356607132093522"><a name="p1356607132093522"></a><a name="p1356607132093522"></a><a href="graphic.md#ga672e4e015f76e7cef0a4b819ee95f082">OHOS::Color::Green</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1600599999093522"><a name="p1600599999093522"></a><a name="p1600599999093522"></a>static <a href="ohos-color32.md">ColorType</a> </p>
<p id="p1432125431093522"><a name="p1432125431093522"></a><a name="p1432125431093522"></a>Obtains the color data of green. </p>
</td>
</tr>
<tr id="row1897996142093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p592735820093522"><a name="p592735820093522"></a><a name="p592735820093522"></a><a href="graphic.md#ga9d6b730a0799da3254543613acb0a3fa">OHOS::Color::Cyan</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1975586522093522"><a name="p1975586522093522"></a><a name="p1975586522093522"></a>static <a href="ohos-color32.md">ColorType</a> </p>
<p id="p1829273078093522"><a name="p1829273078093522"></a><a name="p1829273078093522"></a>Obtains the color data of cyan. </p>
</td>
</tr>
<tr id="row1696572318093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1798895473093522"><a name="p1798895473093522"></a><a name="p1798895473093522"></a><a href="graphic.md#ga24da6b938c938b3defeb56ff79a4c4f5">OHOS::Color::Aqua</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p347275257093522"><a name="p347275257093522"></a><a name="p347275257093522"></a>static <a href="ohos-color32.md">ColorType</a> </p>
<p id="p1412265937093522"><a name="p1412265937093522"></a><a name="p1412265937093522"></a>Obtains the color data of aqua. </p>
</td>
</tr>
<tr id="row1805317532093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2139482979093522"><a name="p2139482979093522"></a><a name="p2139482979093522"></a><a href="graphic.md#ga9f4afc8d27c8e90d5295b281a7198fe5">OHOS::Color::Teal</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p333067293093522"><a name="p333067293093522"></a><a name="p333067293093522"></a>static <a href="ohos-color32.md">ColorType</a> </p>
<p id="p1845838498093522"><a name="p1845838498093522"></a><a name="p1845838498093522"></a>Obtains the color data of teal. </p>
</td>
</tr>
<tr id="row1383490846093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2143862022093522"><a name="p2143862022093522"></a><a name="p2143862022093522"></a><a href="graphic.md#ga3b02160a068039d3801580c8e35008b4">OHOS::Color::Blue</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p886243751093522"><a name="p886243751093522"></a><a name="p886243751093522"></a>static <a href="ohos-color32.md">ColorType</a> </p>
<p id="p105569218093522"><a name="p105569218093522"></a><a name="p105569218093522"></a>Obtains the color data of blue. </p>
</td>
</tr>
<tr id="row1778566544093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2047906662093522"><a name="p2047906662093522"></a><a name="p2047906662093522"></a><a href="graphic.md#ga327d185847eab86cbe297a1e35f0d5d7">OHOS::Color::Navy</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p456612890093522"><a name="p456612890093522"></a><a name="p456612890093522"></a>static <a href="ohos-color32.md">ColorType</a> </p>
<p id="p1714740730093522"><a name="p1714740730093522"></a><a name="p1714740730093522"></a>Obtains the color data of navy. </p>
</td>
</tr>
<tr id="row1744197344093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1502035416093522"><a name="p1502035416093522"></a><a name="p1502035416093522"></a><a href="graphic.md#ga4cbaf5650de24fc1ae45f93571b92f37">OHOS::Color::Magenta</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1781358926093522"><a name="p1781358926093522"></a><a name="p1781358926093522"></a>static <a href="ohos-color32.md">ColorType</a> </p>
<p id="p673957296093522"><a name="p673957296093522"></a><a name="p673957296093522"></a>Obtains the color data of magenta. </p>
</td>
</tr>
<tr id="row879316701093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1079823179093522"><a name="p1079823179093522"></a><a name="p1079823179093522"></a><a href="graphic.md#ga7ec7f44a7a7d828641b739616b01dadb">OHOS::Color::Purple</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p959762218093522"><a name="p959762218093522"></a><a name="p959762218093522"></a>static <a href="ohos-color32.md">ColorType</a> </p>
<p id="p1114376124093522"><a name="p1114376124093522"></a><a name="p1114376124093522"></a>Obtains the color data of purple. </p>
</td>
</tr>
<tr id="row1311035053093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p178378276093522"><a name="p178378276093522"></a><a name="p178378276093522"></a><a href="graphic.md#gae127df687f7b04f9debc853498678aeb">OHOS::Color::Orange</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1809680883093522"><a name="p1809680883093522"></a><a name="p1809680883093522"></a>static <a href="ohos-color32.md">ColorType</a> </p>
<p id="p1427607307093522"><a name="p1427607307093522"></a><a name="p1427607307093522"></a>Obtains the color data of orange. </p>
</td>
</tr>
<tr id="row335494145093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p288910621093522"><a name="p288910621093522"></a><a name="p288910621093522"></a><a href="graphic.md#ga17210a2d5bb0be6d4b58efe249563d1b">OHOS::Image::Image</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p104625064093522"><a name="p104625064093522"></a><a name="p104625064093522"></a> </p>
<p id="p1010359341093522"><a name="p1010359341093522"></a><a name="p1010359341093522"></a>A constructor used to create an <strong id="b1998724400093522"><a name="b1998724400093522"></a><a name="b1998724400093522"></a><a href="ohos-image.md">Image</a></strong> instance. You can use this constructor when a component requires a map. </p>
</td>
</tr>
<tr id="row1097228919093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p540194035093522"><a name="p540194035093522"></a><a name="p540194035093522"></a><a href="graphic.md#gaf3794ceb5acb543f8c526b5d9f6a1e4e">OHOS::Image::~Image</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1540703987093522"><a name="p1540703987093522"></a><a name="p1540703987093522"></a>virtual </p>
<p id="p1948035530093522"><a name="p1948035530093522"></a><a name="p1948035530093522"></a>A destructor used to delete the <strong id="b2022547199093522"><a name="b2022547199093522"></a><a name="b2022547199093522"></a><a href="ohos-image.md">Image</a></strong> instance. </p>
</td>
</tr>
<tr id="row613159608093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p675783415093522"><a name="p675783415093522"></a><a name="p675783415093522"></a><a href="graphic.md#ga592cbeb359a9d13274a6f4972aad3d79">OHOS::Image::GetImageInfo</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1559967584093522"><a name="p1559967584093522"></a><a name="p1559967584093522"></a>const <a href="ohos-imageinfo.md">ImageInfo</a> * </p>
<p id="p898667727093522"><a name="p898667727093522"></a><a name="p898667727093522"></a>Obtains the image information in an array. </p>
</td>
</tr>
<tr id="row30053960093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p174981667093522"><a name="p174981667093522"></a><a name="p174981667093522"></a><a href="graphic.md#gaa1552ae9813d324260a580c4ef5b0c9c">OHOS::Image::GetPath</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1051649017093522"><a name="p1051649017093522"></a><a name="p1051649017093522"></a>const char * </p>
<p id="p1991496425093522"><a name="p1991496425093522"></a><a name="p1991496425093522"></a>Obtains the image path in binary. </p>
</td>
</tr>
<tr id="row858194279093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p679706711093522"><a name="p679706711093522"></a><a name="p679706711093522"></a><a href="graphic.md#gadf426b0d958898df8ef2f9b7b1d278f1">OHOS::Image::GetHeader</a> (<a href="ohos-imageheader.md">ImageHeader</a> &amp;header) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2094751820093522"><a name="p2094751820093522"></a><a name="p2094751820093522"></a>void </p>
<p id="p1862130736093522"><a name="p1862130736093522"></a><a name="p1862130736093522"></a>Obtains the basic image information, including the image format, width, and height. </p>
</td>
</tr>
<tr id="row777251631093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1953641907093522"><a name="p1953641907093522"></a><a name="p1953641907093522"></a><a href="graphic.md#ga7dc8490594e2bc7c9cf50c1237507239">OHOS::Image::GetSrcType</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2079401172093522"><a name="p2079401172093522"></a><a name="p2079401172093522"></a>uint8_t </p>
<p id="p1719917176093522"><a name="p1719917176093522"></a><a name="p1719917176093522"></a>Obtains the image type. </p>
</td>
</tr>
<tr id="row1845753948093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2087120750093522"><a name="p2087120750093522"></a><a name="p2087120750093522"></a><a href="graphic.md#ga4fe78bf99b160fc55770ba1979412c8e">OHOS::Image::SetSrc</a> (const char *src)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p547314187093522"><a name="p547314187093522"></a><a name="p547314187093522"></a>bool </p>
<p id="p1245620992093522"><a name="p1245620992093522"></a><a name="p1245620992093522"></a>Sets the image path. </p>
</td>
</tr>
<tr id="row1283387041093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p461478189093522"><a name="p461478189093522"></a><a name="p461478189093522"></a><a href="graphic.md#ga9471d489ab4d5b6848c1e50b4b7aac23">OHOS::Image::SetSrc</a> (const <a href="ohos-imageinfo.md">ImageInfo</a> *src)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1287376342093522"><a name="p1287376342093522"></a><a name="p1287376342093522"></a>bool </p>
<p id="p1655011113093522"><a name="p1655011113093522"></a><a name="p1655011113093522"></a>Sets the image information. </p>
</td>
</tr>
<tr id="row672491315093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1946681428093522"><a name="p1946681428093522"></a><a name="p1946681428093522"></a><a href="graphic.md#ga25c8efee1241f371b5d30df9817830a6">OHOS::Screen::GetInstance</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1634973669093522"><a name="p1634973669093522"></a><a name="p1634973669093522"></a>static <a href="ohos-screen.md">Screen</a> &amp; </p>
<p id="p1394967294093522"><a name="p1394967294093522"></a><a name="p1394967294093522"></a>Obtains a singleton <strong id="b1334080934093522"><a name="b1334080934093522"></a><a name="b1334080934093522"></a><a href="ohos-screen.md">Screen</a></strong> instance. </p>
</td>
</tr>
<tr id="row854259576093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p661887448093522"><a name="p661887448093522"></a><a name="p661887448093522"></a><a href="graphic.md#ga2ce903f605e04f8d42d561b72944b30b">OHOS::Screen::GetWidth</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p343193493093522"><a name="p343193493093522"></a><a name="p343193493093522"></a>uint16_t </p>
<p id="p338021396093522"><a name="p338021396093522"></a><a name="p338021396093522"></a>Obtains the width of this screen. </p>
</td>
</tr>
<tr id="row204802838093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1984229486093522"><a name="p1984229486093522"></a><a name="p1984229486093522"></a><a href="graphic.md#ga65e3a923208b28f5a5f3a4be57d12996">OHOS::Screen::GetHeight</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p935896489093522"><a name="p935896489093522"></a><a name="p935896489093522"></a>uint16_t </p>
<p id="p1320110039093522"><a name="p1320110039093522"></a><a name="p1320110039093522"></a>Obtains the height of this screen. </p>
</td>
</tr>
<tr id="row830859171093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1040139579093522"><a name="p1040139579093522"></a><a name="p1040139579093522"></a><em id="gad94964a9139150b967ad640ea2076312"><a name="gad94964a9139150b967ad640ea2076312"></a><a name="gad94964a9139150b967ad640ea2076312"></a></em>OHOS::Task::Task ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1751206108093522"><a name="p1751206108093522"></a><a name="p1751206108093522"></a><strong id="b1961048230"><a name="b1961048230"></a><a name="b1961048230"></a></strong>  </p>
<p id="p1800660260093522"><a name="p1800660260093522"></a><a name="p1800660260093522"></a>A constructor used to create a <strong id="b1975441312093522"><a name="b1975441312093522"></a><a name="b1975441312093522"></a><a href="ohos-task.md">Task</a></strong> instance. </p>
</td>
</tr>
<tr id="row1021437031093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1029714269093522"><a name="p1029714269093522"></a><a name="p1029714269093522"></a><a href="graphic.md#gaa7c50eb360b6a4478b5332b8bf565940">OHOS::Task::Task</a> (uint32_t period)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p82587847093522"><a name="p82587847093522"></a><a name="p82587847093522"></a> </p>
<p id="p860582743093522"><a name="p860582743093522"></a><a name="p860582743093522"></a>A constructor used to create a <strong id="b501135651093522"><a name="b501135651093522"></a><a name="b501135651093522"></a><a href="ohos-task.md">Task</a></strong> instance with the specified running period. </p>
</td>
</tr>
<tr id="row1030062579093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p501480990093522"><a name="p501480990093522"></a><a name="p501480990093522"></a><em id="ga293d4e1533ea98cdebbbffe1afed38ef"><a name="ga293d4e1533ea98cdebbbffe1afed38ef"></a><a name="ga293d4e1533ea98cdebbbffe1afed38ef"></a></em>OHOS::Task::~Task ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1372298400093522"><a name="p1372298400093522"></a><a name="p1372298400093522"></a><strong id="b317918220"><a name="b317918220"></a><a name="b317918220"></a></strong> virtual </p>
<p id="p486512041093522"><a name="p486512041093522"></a><a name="p486512041093522"></a>A destructor used to delete the <strong id="b939302790093522"><a name="b939302790093522"></a><a name="b939302790093522"></a><a href="ohos-task.md">Task</a></strong> instance. </p>
</td>
</tr>
<tr id="row219837930093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2036972060093522"><a name="p2036972060093522"></a><a name="p2036972060093522"></a><a href="graphic.md#gac6e9fe7bde72bf506558a6f0d0287a92">OHOS::Task::SetPeriod</a> (uint32_t period)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p963985108093522"><a name="p963985108093522"></a><a name="p963985108093522"></a>void </p>
<p id="p770692734093522"><a name="p770692734093522"></a><a name="p770692734093522"></a>Sets the running period for this task. </p>
</td>
</tr>
<tr id="row1580523619093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1579556440093522"><a name="p1579556440093522"></a><a name="p1579556440093522"></a><a href="graphic.md#gabdbfe69d5f5da3cc5bbb1749d281af62">OHOS::Task::SetLastRun</a> (uint32_t lastRun)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1844345578093522"><a name="p1844345578093522"></a><a name="p1844345578093522"></a>void </p>
<p id="p1038465353093522"><a name="p1038465353093522"></a><a name="p1038465353093522"></a>Sets the end time for this task. </p>
</td>
</tr>
<tr id="row1360287921093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p781730450093522"><a name="p781730450093522"></a><a name="p781730450093522"></a><a href="graphic.md#gabd53b86c63b41172af155b8a7f86b84c">OHOS::Task::GetPeriod</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1237483574093522"><a name="p1237483574093522"></a><a name="p1237483574093522"></a>uint32_t </p>
<p id="p461247964093522"><a name="p461247964093522"></a><a name="p461247964093522"></a>Obtains the running period of this task. </p>
</td>
</tr>
<tr id="row915143396093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1129061912093522"><a name="p1129061912093522"></a><a name="p1129061912093522"></a><a href="graphic.md#ga2d4c9fbb026686623ff4d6e0b19d4960">OHOS::Task::GetLastRun</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p777203791093522"><a name="p777203791093522"></a><a name="p777203791093522"></a>uint32_t </p>
<p id="p92357128093522"><a name="p92357128093522"></a><a name="p92357128093522"></a>Obtains the end time of this task. </p>
</td>
</tr>
<tr id="row1905092526093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1985284625093522"><a name="p1985284625093522"></a><a name="p1985284625093522"></a><em id="ga96ed6680b2b9ad667e51d60554013020"><a name="ga96ed6680b2b9ad667e51d60554013020"></a><a name="ga96ed6680b2b9ad667e51d60554013020"></a></em>OHOS::Task::TaskExecute ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p247127870093522"><a name="p247127870093522"></a><a name="p247127870093522"></a><strong id="b1258758183"><a name="b1258758183"></a><a name="b1258758183"></a></strong> void </p>
<p id="p463694396093522"><a name="p463694396093522"></a><a name="p463694396093522"></a>Executes this task. </p>
</td>
</tr>
<tr id="row344140471093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1060394467093522"><a name="p1060394467093522"></a><a name="p1060394467093522"></a><em id="gad1ddf68898304dad1f912f750ace8281"><a name="gad1ddf68898304dad1f912f750ace8281"></a><a name="gad1ddf68898304dad1f912f750ace8281"></a></em>OHOS::Task::Callback ()=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p585488562093522"><a name="p585488562093522"></a><a name="p585488562093522"></a><strong id="b2131425971"><a name="b2131425971"></a><a name="b2131425971"></a></strong> virtual void </p>
<p id="p1392471060093522"><a name="p1392471060093522"></a><a name="p1392471060093522"></a>Called when this task is executed. </p>
</td>
</tr>
<tr id="row748579409093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1387603702093522"><a name="p1387603702093522"></a><a name="p1387603702093522"></a><em id="gab9968727a3d5e8b6270f5efd0eb1cff6"><a name="gab9968727a3d5e8b6270f5efd0eb1cff6"></a><a name="gab9968727a3d5e8b6270f5efd0eb1cff6"></a></em>OHOS::Task::Init ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1351508876093522"><a name="p1351508876093522"></a><a name="p1351508876093522"></a><strong id="b570871277"><a name="b570871277"></a><a name="b570871277"></a></strong> virtual void </p>
<p id="p113893751093522"><a name="p113893751093522"></a><a name="p113893751093522"></a>Initializes this task. </p>
</td>
</tr>
<tr id="row1449724476093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1510949789093522"><a name="p1510949789093522"></a><a name="p1510949789093522"></a><a href="graphic.md#ga7ea8e1b0f5e199317c3134b575431ce6">OHOS::Text::Text</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p159390034093522"><a name="p159390034093522"></a><a name="p159390034093522"></a> </p>
<p id="p80541297093522"><a name="p80541297093522"></a><a name="p80541297093522"></a>A constructor used to create a <strong id="b735946712093522"><a name="b735946712093522"></a><a name="b735946712093522"></a><a href="ohos-text.md">Text</a></strong> instance. </p>
</td>
</tr>
<tr id="row1990689299093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1974644311093522"><a name="p1974644311093522"></a><a name="p1974644311093522"></a><a href="graphic.md#gae15585b395b286ee404a57a61baa81f1">OHOS::Text::~Text</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1510569983093522"><a name="p1510569983093522"></a><a name="p1510569983093522"></a>virtual </p>
<p id="p916623725093522"><a name="p916623725093522"></a><a name="p916623725093522"></a>A destructor used to delete the <strong id="b1966022362093522"><a name="b1966022362093522"></a><a name="b1966022362093522"></a><a href="ohos-text.md">Text</a></strong> instance. </p>
</td>
</tr>
<tr id="row936831050093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1259917253093522"><a name="p1259917253093522"></a><a name="p1259917253093522"></a><a href="graphic.md#gaf4c592a07fe20af21e0ddae2d8203d96">OHOS::Text::SetText</a> (const char *text)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p553010203093522"><a name="p553010203093522"></a><a name="p553010203093522"></a>void </p>
<p id="p114788870093522"><a name="p114788870093522"></a><a name="p114788870093522"></a>Sets the content for this text. </p>
</td>
</tr>
<tr id="row411697463093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p770236054093522"><a name="p770236054093522"></a><a name="p770236054093522"></a><a href="graphic.md#gafcc64349913763e8d7feaf7bd9cbd639">OHOS::Text::GetText</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1371990384093522"><a name="p1371990384093522"></a><a name="p1371990384093522"></a>const char * </p>
<p id="p1959573201093522"><a name="p1959573201093522"></a><a name="p1959573201093522"></a>Obtains the content of this text. </p>
</td>
</tr>
<tr id="row1769151863093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1322705320093522"><a name="p1322705320093522"></a><a name="p1322705320093522"></a><a href="graphic.md#ga1c1a26e57098662f787a1bb44bb9da8c">OHOS::Text::SetFont</a> (const char *name, uint8_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p788901264093522"><a name="p788901264093522"></a><a name="p788901264093522"></a>void </p>
<p id="p1322857890093522"><a name="p1322857890093522"></a><a name="p1322857890093522"></a>Sets the font name and size. </p>
</td>
</tr>
<tr id="row1820094528093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1014744528093522"><a name="p1014744528093522"></a><a name="p1014744528093522"></a><a href="graphic.md#gac27135182c89eabec65e22df079dc413">OHOS::Text::SetFontId</a> (uint8_t fontId)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p12363469093522"><a name="p12363469093522"></a><a name="p12363469093522"></a>void </p>
<p id="p237516175093522"><a name="p237516175093522"></a><a name="p237516175093522"></a>Sets the font ID. </p>
</td>
</tr>
<tr id="row1169150240093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1730117410093522"><a name="p1730117410093522"></a><a name="p1730117410093522"></a><a href="graphic.md#ga32ba629806e9d8553bbcd441b4e66d55">OHOS::Text::GetFontId</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p971814322093522"><a name="p971814322093522"></a><a name="p971814322093522"></a>uint8_t </p>
<p id="p27942064093522"><a name="p27942064093522"></a><a name="p27942064093522"></a>Obtains the font ID. </p>
</td>
</tr>
<tr id="row703999827093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1904599477093522"><a name="p1904599477093522"></a><a name="p1904599477093522"></a><a href="graphic.md#ga96801aa6350a8533496b0718d67f0b9c">OHOS::Text::SetDirect</a> (<a href="graphic.md#ga0c108f97781843f67c101b47b6c00cf0">UITextLanguageDirect</a> direct)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p543087713093522"><a name="p543087713093522"></a><a name="p543087713093522"></a>void </p>
<p id="p1204666527093522"><a name="p1204666527093522"></a><a name="p1204666527093522"></a>Sets the direction for this text. </p>
</td>
</tr>
<tr id="row1084788236093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p669942499093522"><a name="p669942499093522"></a><a name="p669942499093522"></a><a href="graphic.md#gacd469d16b0f3a8e7406d736f5e857996">OHOS::Text::GetDirect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1449069737093522"><a name="p1449069737093522"></a><a name="p1449069737093522"></a><a href="graphic.md#ga0c108f97781843f67c101b47b6c00cf0">UITextLanguageDirect</a> </p>
<p id="p1338831662093522"><a name="p1338831662093522"></a><a name="p1338831662093522"></a>Obtains the direction of this text. </p>
</td>
</tr>
<tr id="row1966952129093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2024970859093522"><a name="p2024970859093522"></a><a name="p2024970859093522"></a><a href="graphic.md#gad4721f5014971f6017aaaa5cc0af6845">OHOS::Text::SetAlign</a> (<a href="graphic.md#ga3f99b58f731a37cacde72d5e0c934593">UITextLanguageAlignment</a> horizontalAlign, <a href="graphic.md#ga3f99b58f731a37cacde72d5e0c934593">UITextLanguageAlignment</a> verticalAlign=TEXT_ALIGNMENT_TOP)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p235500857093522"><a name="p235500857093522"></a><a name="p235500857093522"></a>void </p>
<p id="p1670306428093522"><a name="p1670306428093522"></a><a name="p1670306428093522"></a>Sets the alignment mode for this text. </p>
</td>
</tr>
<tr id="row723053095093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1309782229093522"><a name="p1309782229093522"></a><a name="p1309782229093522"></a><a href="graphic.md#ga3c17868fb06a77f43587c67de4ca5ab6">OHOS::Text::GetHorAlign</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1317956151093522"><a name="p1317956151093522"></a><a name="p1317956151093522"></a><a href="graphic.md#ga3f99b58f731a37cacde72d5e0c934593">UITextLanguageAlignment</a> </p>
<p id="p1871203465093522"><a name="p1871203465093522"></a><a name="p1871203465093522"></a>Obtains the horizontal alignment mode. </p>
</td>
</tr>
<tr id="row464657787093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p910198162093522"><a name="p910198162093522"></a><a name="p910198162093522"></a><a href="graphic.md#gac312f642e12cfad8d974f8159984864e">OHOS::Text::GetVerAlign</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p286326865093522"><a name="p286326865093522"></a><a name="p286326865093522"></a><a href="graphic.md#ga3f99b58f731a37cacde72d5e0c934593">UITextLanguageAlignment</a> </p>
<p id="p674473229093522"><a name="p674473229093522"></a><a name="p674473229093522"></a>Obtains the vertical alignment mode. </p>
</td>
</tr>
<tr id="row557196313093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1813918490093522"><a name="p1813918490093522"></a><a name="p1813918490093522"></a><a href="graphic.md#ga2ec83b586a0a7ebe402bb70a31be2ca6">OHOS::Text::SetTextRotation</a> (LabelRotateDegree angle)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1075905993093522"><a name="p1075905993093522"></a><a name="p1075905993093522"></a>void </p>
<p id="p1424067690093522"><a name="p1424067690093522"></a><a name="p1424067690093522"></a>Sets the clockwise rotation angle for this text. </p>
</td>
</tr>
<tr id="row1812676265093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1736786425093522"><a name="p1736786425093522"></a><a name="p1736786425093522"></a><a href="graphic.md#ga2dcc364f56ffa8bada573c7f96c92b0e">OHOS::Text::GetTextRotation</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1665802774093522"><a name="p1665802774093522"></a><a name="p1665802774093522"></a>LabelRotateDegree </p>
<p id="p1303948376093522"><a name="p1303948376093522"></a><a name="p1303948376093522"></a>Obtains the clockwise rotation degree of this text. </p>
</td>
</tr>
<tr id="row827140002093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1056731817093522"><a name="p1056731817093522"></a><a name="p1056731817093522"></a><a href="graphic.md#gae36f3e226f23d8d7dff174054f60a741">OHOS::Text::GetTextRotateDegree</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1067636594093522"><a name="p1067636594093522"></a><a name="p1067636594093522"></a>uint16_t </p>
<p id="p449302241093522"><a name="p449302241093522"></a><a name="p449302241093522"></a>Obtains the number of text rotation degrees. </p>
</td>
</tr>
<tr id="row463403437093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1853340231093522"><a name="p1853340231093522"></a><a name="p1853340231093522"></a><a href="graphic.md#ga7e3e2deccb36992428d7984681329f09">OHOS::Text::GetTextSize</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1762136511093522"><a name="p1762136511093522"></a><a name="p1762136511093522"></a><a href="ohos-point.md">Point</a> </p>
<p id="p457536258093522"><a name="p457536258093522"></a><a name="p457536258093522"></a>Obtains the size of this text. </p>
</td>
</tr>
<tr id="row1930859673093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p958453243093522"><a name="p958453243093522"></a><a name="p958453243093522"></a><a href="graphic.md#ga7aa8b64ece3c4b3bf592dc88fc7c11d2">OHOS::Text::SetExpandWidth</a> (bool expand)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1383925163093522"><a name="p1383925163093522"></a><a name="p1383925163093522"></a>void </p>
<p id="p1667513091093522"><a name="p1667513091093522"></a><a name="p1667513091093522"></a>Sets whether to adapt the component width to this text. </p>
</td>
</tr>
<tr id="row874407185093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p323535618093522"><a name="p323535618093522"></a><a name="p323535618093522"></a><a href="graphic.md#gaab55ac2d3f8e45b4bfb5fd5ae07d1edd">OHOS::Text::IsExpandWidth</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p864424404093522"><a name="p864424404093522"></a><a name="p864424404093522"></a>bool </p>
<p id="p2077351926093522"><a name="p2077351926093522"></a><a name="p2077351926093522"></a>Checks whether the component width adapts to this text. </p>
</td>
</tr>
<tr id="row2086895033093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p251666235093522"><a name="p251666235093522"></a><a name="p251666235093522"></a><a href="graphic.md#gac08f297a1593424d754450c75bc47045">OHOS::Text::SetExpandHeight</a> (bool expand)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p259777719093522"><a name="p259777719093522"></a><a name="p259777719093522"></a>void </p>
<p id="p162988730093522"><a name="p162988730093522"></a><a name="p162988730093522"></a>Sets whether to adapt the component height to this text. </p>
</td>
</tr>
<tr id="row1049288391093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p201732243093522"><a name="p201732243093522"></a><a name="p201732243093522"></a><a href="graphic.md#ga09475a9cd4e86b19d4c3d4206ea5ffc6">OHOS::Text::IsExpandHeight</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1856364802093522"><a name="p1856364802093522"></a><a name="p1856364802093522"></a>bool </p>
<p id="p946189836093522"><a name="p946189836093522"></a><a name="p946189836093522"></a>Checks whether the component height adapts to this text. </p>
</td>
</tr>
<tr id="row1340492982093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1310010685093522"><a name="p1310010685093522"></a><a name="p1310010685093522"></a><a href="graphic.md#ga302dc8ff172b67c104363710f4b53cb0">OHOS::Text::GetEllipsisIndex</a> (const <a href="ohos-rect.md">Rect</a> &amp;textRect, const <a href="ohos-style.md">Style</a> &amp;style)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1275745578093522"><a name="p1275745578093522"></a><a name="p1275745578093522"></a>uint16_t </p>
<p id="p1132600062093522"><a name="p1132600062093522"></a><a name="p1132600062093522"></a>Obtains the index of the character from where text will be replaced by ellipses based on the text rectangle and style. </p>
</td>
</tr>
<tr id="row1173196671093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p106519121093522"><a name="p106519121093522"></a><a name="p106519121093522"></a><a href="graphic.md#gab60e1c77fb98352bd62e56b550d75d88">OHOS::AbstractAdapter::AbstractAdapter</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1492588476093522"><a name="p1492588476093522"></a><a name="p1492588476093522"></a> </p>
<p id="p596136332093522"><a name="p596136332093522"></a><a name="p596136332093522"></a>A constructor used to create an <strong id="b1401237978093522"><a name="b1401237978093522"></a><a name="b1401237978093522"></a><a href="ohos-abstractadapter.md">AbstractAdapter</a></strong> instance. </p>
</td>
</tr>
<tr id="row767990459093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1698632495093522"><a name="p1698632495093522"></a><a name="p1698632495093522"></a><a href="graphic.md#ga86fbbc62904d459ec4fa39bab7703af7">OHOS::AbstractAdapter::~AbstractAdapter</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p413510783093522"><a name="p413510783093522"></a><a name="p413510783093522"></a>virtual </p>
<p id="p1409441900093522"><a name="p1409441900093522"></a><a name="p1409441900093522"></a>A destructor used to delete the <strong id="b289192811093522"><a name="b289192811093522"></a><a name="b289192811093522"></a><a href="ohos-abstractadapter.md">AbstractAdapter</a></strong> instance. </p>
</td>
</tr>
<tr id="row2105210000093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p181635186093522"><a name="p181635186093522"></a><a name="p181635186093522"></a><a href="graphic.md#ga67021b360d4097c475d5e24519b5276d">OHOS::AbstractAdapter::GetCount</a> ()=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1526398538093522"><a name="p1526398538093522"></a><a name="p1526398538093522"></a>virtual uint16_t </p>
<p id="p1227029706093522"><a name="p1227029706093522"></a><a name="p1227029706093522"></a>Obtains the number of adapter data items. </p>
</td>
</tr>
<tr id="row533166243093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p299044422093522"><a name="p299044422093522"></a><a name="p299044422093522"></a><a href="graphic.md#gab155b2f4a6d8fd97755dcd1e6d3d8361">OHOS::AbstractAdapter::GetView</a> (<a href="ohos-uiview.md">UIView</a> *inView, int16_t <a href="en-us_topic_0000001055198076.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1794148808093522"><a name="p1794148808093522"></a><a name="p1794148808093522"></a>virtual <a href="ohos-uiview.md">UIView</a> * </p>
<p id="p949223213093522"><a name="p949223213093522"></a><a name="p949223213093522"></a>Obtains a <strong id="b1626241183093522"><a name="b1626241183093522"></a><a name="b1626241183093522"></a><a href="ohos-uiview.md">UIView</a></strong> instance to convert adapter data into another <strong id="b1481629013093522"><a name="b1481629013093522"></a><a name="b1481629013093522"></a><a href="ohos-uiview.md">UIView</a></strong> instance. </p>
</td>
</tr>
<tr id="row1320323646093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1226012645093522"><a name="p1226012645093522"></a><a name="p1226012645093522"></a><a href="graphic.md#ga924ce70adcad92d852ba1d1faa441ac8">OHOS::RootView::GetInstance</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p384946980093522"><a name="p384946980093522"></a><a name="p384946980093522"></a>static <a href="ohos-rootview.md">RootView</a> * </p>
<p id="p1965402974093522"><a name="p1965402974093522"></a><a name="p1965402974093522"></a>Obtains a singleton <strong id="b953813697093522"><a name="b953813697093522"></a><a name="b953813697093522"></a><a href="ohos-rootview.md">RootView</a></strong> instance. </p>
</td>
</tr>
<tr id="row1989903646093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p386645138093522"><a name="p386645138093522"></a><a name="p386645138093522"></a><a href="graphic.md#gab21e31a784cc709b1f075ae53ad81818">OHOS::RootView::OnKeyActListener::OnKeyAct</a> (<a href="ohos-uiview.md">UIView</a> &amp;view, const <a href="ohos-keyevent.md">KeyEvent</a> &amp;event)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1230769699093522"><a name="p1230769699093522"></a><a name="p1230769699093522"></a>virtual bool </p>
<p id="p431878635093522"><a name="p431878635093522"></a><a name="p431878635093522"></a>Responds to a physical key event. </p>
</td>
</tr>
<tr id="row1447724978093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2053970864093522"><a name="p2053970864093522"></a><a name="p2053970864093522"></a><a href="graphic.md#ga7b96c15cdbe0edd5045e479b3b2fe1eb">OHOS::RootView::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1078424152093522"><a name="p1078424152093522"></a><a name="p1078424152093522"></a>UIViewType </p>
<p id="p282924246093522"><a name="p282924246093522"></a><a name="p282924246093522"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row1900730341093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1978517826093522"><a name="p1978517826093522"></a><a name="p1978517826093522"></a><a href="graphic.md#gaffcd945698a2df5f3fde5342c74719a9">OHOS::RootView::OnKeyEvent</a> (const <a href="ohos-keyevent.md">KeyEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p276971234093522"><a name="p276971234093522"></a><a name="p276971234093522"></a>virtual void </p>
<p id="p1122433751093522"><a name="p1122433751093522"></a><a name="p1122433751093522"></a>Executes a physical key event. </p>
</td>
</tr>
<tr id="row1813331277093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p603426825093522"><a name="p603426825093522"></a><a name="p603426825093522"></a><a href="graphic.md#ga3c0fce0e3a6c1b83324e54468d077bb0">OHOS::RootView::SetOnKeyActListener</a> (<a href="ohos-rootview-onkeyactlistener.md">OnKeyActListener</a> *onKeyActListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p351847580093522"><a name="p351847580093522"></a><a name="p351847580093522"></a>void </p>
<p id="p251315348093522"><a name="p251315348093522"></a><a name="p251315348093522"></a>Sets the listener that contains a callback to be invoked upon a physical key event. </p>
</td>
</tr>
<tr id="row44288544093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1497897175093522"><a name="p1497897175093522"></a><a name="p1497897175093522"></a><a href="graphic.md#ga00303597af333088c06a45346f4a77f2">OHOS::RootView::ClearOnKeyActListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p875023196093522"><a name="p875023196093522"></a><a name="p875023196093522"></a>void </p>
<p id="p338949508093522"><a name="p338949508093522"></a><a name="p338949508093522"></a>Clears the listener for monitoring physical key events. </p>
</td>
</tr>
<tr id="row1448374279093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1572154599093522"><a name="p1572154599093522"></a><a name="p1572154599093522"></a><a href="graphic.md#ga548d8e9577a986223ff134c32eece547">OHOS::RootView::OnVirtualDeviceEventListener::OnVirtualDeviceEvent</a> (<a href="ohos-uiview.md">UIView</a> &amp;view, <a href="ohos-virtualdeviceevent.md">VirtualDeviceEvent</a> event)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1195763039093522"><a name="p1195763039093522"></a><a name="p1195763039093522"></a>virtual bool </p>
<p id="p495587820093522"><a name="p495587820093522"></a><a name="p495587820093522"></a>Responds to an input event triggered by a virtual device. </p>
</td>
</tr>
<tr id="row261098036093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1108388333093522"><a name="p1108388333093522"></a><a name="p1108388333093522"></a><a href="graphic.md#gae86a0b7fa1a2c4fee021cb7bed2d418c">OHOS::RootView::OnVirtualDeviceEvent</a> (const <a href="ohos-virtualdeviceevent.md">VirtualDeviceEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p473056507093522"><a name="p473056507093522"></a><a name="p473056507093522"></a>virtual void </p>
<p id="p829393100093522"><a name="p829393100093522"></a><a name="p829393100093522"></a>Executes an input event triggered by a virtual device. </p>
</td>
</tr>
<tr id="row916087095093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1238949478093522"><a name="p1238949478093522"></a><a name="p1238949478093522"></a><a href="graphic.md#gac12473c0dc9b293f6be9553afbb7c5d6">OHOS::RootView::SetOnVirtualDeviceEventListener</a> (<a href="ohos-rootview-onvirtualdeviceeventlistener.md">OnVirtualDeviceEventListener</a> *onVirtualDeviceEventListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p238452122093522"><a name="p238452122093522"></a><a name="p238452122093522"></a>void </p>
<p id="p2024201883093522"><a name="p2024201883093522"></a><a name="p2024201883093522"></a>Sets a listener for monitoring the input events of a virtual device. </p>
</td>
</tr>
<tr id="row699707457093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1806200462093522"><a name="p1806200462093522"></a><a name="p1806200462093522"></a><a href="graphic.md#ga0b550a305c0cda1dc510b2446c56ed82">OHOS::RootView::ClearOnVirtualDeviceEventListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1363804393093522"><a name="p1363804393093522"></a><a name="p1363804393093522"></a>void </p>
<p id="p2146810569093522"><a name="p2146810569093522"></a><a name="p2146810569093522"></a>Clears the listener for monitoring the input events of a virtual device. </p>
</td>
</tr>
<tr id="row376077516093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1369954073093522"><a name="p1369954073093522"></a><a name="p1369954073093522"></a><a href="graphic.md#gabb3c193eea516b09f9ed6932b298ab9a">OHOS::RootView::FindSubView</a> (const <a href="ohos-uiview.md">UIView</a> &amp;parentView, const <a href="ohos-uiview.md">UIView</a> *subView)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p673554391093522"><a name="p673554391093522"></a><a name="p673554391093522"></a>static bool </p>
<p id="p1786819012093522"><a name="p1786819012093522"></a><a name="p1786819012093522"></a>Checks whether the target view is one of the child views of the specified parent view. </p>
</td>
</tr>
<tr id="row1671485184093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p938468790093522"><a name="p938468790093522"></a><a name="p938468790093522"></a><a href="graphic.md#ga183cac282667493fa2a008f9a7f4f9d2">OHOS::TextFormatter::Format</a> (int16_t value, char *outText, uint16_t textLen)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p824123306093522"><a name="p824123306093522"></a><a name="p824123306093522"></a>virtual bool </p>
<p id="p1224823331093522"><a name="p1224823331093522"></a><a name="p1224823331093522"></a>Converts the input integer into a character string for output. </p>
</td>
</tr>
<tr id="row1898917538093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1132678238093522"><a name="p1132678238093522"></a><a name="p1132678238093522"></a><a href="graphic.md#ga38bde4aa4a0952341ad74284ff686832">OHOS::TextAdapter::TextAdapter</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p535616502093522"><a name="p535616502093522"></a><a name="p535616502093522"></a> </p>
<p id="p923300848093522"><a name="p923300848093522"></a><a name="p923300848093522"></a>A constructor used to create a <strong id="b1934747943093522"><a name="b1934747943093522"></a><a name="b1934747943093522"></a><a href="ohos-uilabel.md">UILabel</a></strong> instance. </p>
</td>
</tr>
<tr id="row449845448093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1975084640093522"><a name="p1975084640093522"></a><a name="p1975084640093522"></a><a href="graphic.md#ga1e868c845df224beff2f3c6f49593d3b">OHOS::TextAdapter::~TextAdapter</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p796634879093522"><a name="p796634879093522"></a><a name="p796634879093522"></a>virtual </p>
<p id="p129279156093522"><a name="p129279156093522"></a><a name="p129279156093522"></a>A destructor used to delete the <strong id="b406825315093522"><a name="b406825315093522"></a><a name="b406825315093522"></a><a href="ohos-uilabel.md">UILabel</a></strong> instance. </p>
</td>
</tr>
<tr id="row39221623093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1012299292093522"><a name="p1012299292093522"></a><a name="p1012299292093522"></a><a href="graphic.md#ga733211ca13eccff628bb2712c27b885e">OHOS::TextAdapter::GetView</a> (<a href="ohos-uiview.md">UIView</a> *inView, int16_t <a href="en-us_topic_0000001055198076.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p12882314093522"><a name="p12882314093522"></a><a name="p12882314093522"></a><a href="ohos-uiview.md">UIView</a> * </p>
<p id="p425671269093522"><a name="p425671269093522"></a><a name="p425671269093522"></a>Obtains a <strong id="b21061212093522"><a name="b21061212093522"></a><a name="b21061212093522"></a><a href="ohos-uilabel.md">UILabel</a></strong> instance to convert adapter data into another <strong id="b876354139093522"><a name="b876354139093522"></a><a name="b876354139093522"></a><a href="ohos-uilabel.md">UILabel</a></strong> instance. </p>
</td>
</tr>
<tr id="row2074416570093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1274983414093522"><a name="p1274983414093522"></a><a name="p1274983414093522"></a><a href="graphic.md#ga7147c1cc7f5f5ccd6bdd939082a1d88b">OHOS::TextAdapter::SetData</a> (<a href="ohos-list-t.md">List</a>&lt; const char *&gt; *data)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p15234734093522"><a name="p15234734093522"></a><a name="p15234734093522"></a>void </p>
<p id="p2102989189093522"><a name="p2102989189093522"></a><a name="p2102989189093522"></a>Sets the <a href="ohos-uilabel.md">UILabel</a> adapter data, which is a string linked list. </p>
</td>
</tr>
<tr id="row826412256093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1150907953093522"><a name="p1150907953093522"></a><a name="p1150907953093522"></a><a href="graphic.md#ga9521d17dfaf251b42deafc182aea8a1e">OHOS::TextAdapter::SetData</a> (int16_t start, int16_t end)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p899048422093522"><a name="p899048422093522"></a><a name="p899048422093522"></a>void </p>
<p id="p314439240093522"><a name="p314439240093522"></a><a name="p314439240093522"></a>Sets continuously increasing data. For example, if you need to set data <strong id="b172563014093522"><a name="b172563014093522"></a><a name="b172563014093522"></a>0</strong>, <strong id="b1358856595093522"><a name="b1358856595093522"></a><a name="b1358856595093522"></a>1</strong>, <strong id="b2061843143093522"><a name="b2061843143093522"></a><a name="b2061843143093522"></a>2</strong>, <strong id="b1652147871093522"><a name="b1652147871093522"></a><a name="b1652147871093522"></a>3</strong>, <strong id="b1153368488093522"><a name="b1153368488093522"></a><a name="b1153368488093522"></a>4</strong>, use this function to set <strong id="b815681054093522"><a name="b815681054093522"></a><a name="b815681054093522"></a>start</strong> to 0 and <strong id="b173247164093522"><a name="b173247164093522"></a><a name="b173247164093522"></a>end</strong> to 4. </p>
</td>
</tr>
<tr id="row1601529433093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2138494560093522"><a name="p2138494560093522"></a><a name="p2138494560093522"></a><a href="graphic.md#gaf0ec9f4036ed071ab95081bb3237f89a">OHOS::TextAdapter::SetFontId</a> (uint8_t fontId)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1732354457093522"><a name="p1732354457093522"></a><a name="p1732354457093522"></a>void </p>
<p id="p2112709634093522"><a name="p2112709634093522"></a><a name="p2112709634093522"></a>Sets font ID. </p>
</td>
</tr>
<tr id="row39514032093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1744300386093522"><a name="p1744300386093522"></a><a name="p1744300386093522"></a><a href="graphic.md#ga077ac9bece7019abc2a755031ddc5575">OHOS::TextAdapter::GetFontId</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1794040445093522"><a name="p1794040445093522"></a><a name="p1794040445093522"></a>uint8_t </p>
<p id="p229384237093522"><a name="p229384237093522"></a><a name="p229384237093522"></a>Obtains font ID. </p>
</td>
</tr>
<tr id="row1593921711093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p693411810093522"><a name="p693411810093522"></a><a name="p693411810093522"></a><a href="graphic.md#ga28d957b0aa0324e876a871eae1b80d3f">OHOS::TextAdapter::SetFont</a> (const char *name, uint8_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p101520651093522"><a name="p101520651093522"></a><a name="p101520651093522"></a>void </p>
<p id="p974900797093522"><a name="p974900797093522"></a><a name="p974900797093522"></a>Sets the font. </p>
</td>
</tr>
<tr id="row1514099066093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p920601748093522"><a name="p920601748093522"></a><a name="p920601748093522"></a><a href="graphic.md#gacba8806f0f63a2b0436dbe4ec1b4d01c">OHOS::TextAdapter::GetStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p159690516093522"><a name="p159690516093522"></a><a name="p159690516093522"></a><a href="ohos-style.md">Style</a> &amp; </p>
<p id="p1078934388093522"><a name="p1078934388093522"></a><a name="p1078934388093522"></a>Obtains the <a href="ohos-uilabel.md">UILabel</a> adapter style. </p>
</td>
</tr>
<tr id="row258555766093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1436971971093522"><a name="p1436971971093522"></a><a name="p1436971971093522"></a><a href="graphic.md#gaa8d1098628c391a687b08f4ccdba0a4d">OHOS::TextAdapter::GetCount</a> () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p892082981093522"><a name="p892082981093522"></a><a name="p892082981093522"></a>virtual uint16_t </p>
<p id="p1053913198093522"><a name="p1053913198093522"></a><a name="p1053913198093522"></a>Obtains the <strong id="b1242063486093522"><a name="b1242063486093522"></a><a name="b1242063486093522"></a>data</strong> size of the <a href="ohos-uilabel.md">UILabel</a> adapter. </p>
</td>
</tr>
<tr id="row262996879093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p316972160093522"><a name="p316972160093522"></a><a name="p316972160093522"></a><a href="graphic.md#gaed7f27b1dbf4f50ae8eda00cc6cb6a27">OHOS::TextAdapter::SetWidth</a> (int16_t width)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1401675670093522"><a name="p1401675670093522"></a><a name="p1401675670093522"></a>void </p>
<p id="p932162259093522"><a name="p932162259093522"></a><a name="p932162259093522"></a>Sets the width of <a href="ohos-uilabel.md">UILabel</a> constructed by the adapter. </p>
</td>
</tr>
<tr id="row904298328093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1744737255093522"><a name="p1744737255093522"></a><a name="p1744737255093522"></a><a href="graphic.md#ga618021df16f2156ddeeb12d5a8fa14f9">OHOS::TextAdapter::SetDirect</a> (<a href="graphic.md#ga0c108f97781843f67c101b47b6c00cf0">UITextLanguageDirect</a> direct)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1684613397093522"><a name="p1684613397093522"></a><a name="p1684613397093522"></a>void </p>
<p id="p1580021560093522"><a name="p1580021560093522"></a><a name="p1580021560093522"></a>Sets the direction of the <a href="ohos-uilabel.md">UILabel</a> constructed by the adapter. </p>
</td>
</tr>
<tr id="row1628024928093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1334526501093522"><a name="p1334526501093522"></a><a name="p1334526501093522"></a><a href="graphic.md#ga2c83259c064091d74deac1e4a69f834c">OHOS::TextAdapter::SetHeight</a> (int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1909525746093522"><a name="p1909525746093522"></a><a name="p1909525746093522"></a>void </p>
<p id="p651862391093522"><a name="p651862391093522"></a><a name="p651862391093522"></a>Sets the height of the <a href="ohos-uilabel.md">UILabel</a> constructed by the adapter. </p>
</td>
</tr>
<tr id="row1727769028093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p46190755093522"><a name="p46190755093522"></a><a name="p46190755093522"></a><a href="graphic.md#gafc5f3b2c909753f4a7ef53daa80b530b">OHOS::TextAdapter::SetLineBreakMode</a> (const uint8_t lineBreakMode)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p659938896093522"><a name="p659938896093522"></a><a name="p659938896093522"></a>void </p>
<p id="p770812799093522"><a name="p770812799093522"></a><a name="p770812799093522"></a>Sets the <strong id="b772584974093522"><a name="b772584974093522"></a><a name="b772584974093522"></a>LineBreakMode</strong> attribute of <a href="ohos-uilabel.md">UILabel</a> constructed by the adapter. For details about the values of <strong id="b592109664093522"><a name="b592109664093522"></a><a name="b592109664093522"></a>LineBreakMode</strong>, see <strong id="b2144850100093522"><a name="b2144850100093522"></a><a name="b2144850100093522"></a>LINE_BREAK_ADAPT</strong>, <strong id="b493173219093522"><a name="b493173219093522"></a><a name="b493173219093522"></a>LINE_BREAK_WRAP</strong>, <strong id="b15002628093522"><a name="b15002628093522"></a><a name="b15002628093522"></a>LINE_BREAK_ELLIPSIS</strong>, and <strong id="b1309541862093522"><a name="b1309541862093522"></a><a name="b1309541862093522"></a>LINE_BREAK_MARQUEE</strong>. </p>
</td>
</tr>
<tr id="row1993273355093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1272501704093522"><a name="p1272501704093522"></a><a name="p1272501704093522"></a><a href="graphic.md#ga9aa8cecae666906c7fa3d292d6c1c842">OHOS::TextAdapter::SetOnClickListener</a> (<a href="ohos-uiview-onclicklistener.md">UIView::OnClickListener</a> *clickListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1409242339093522"><a name="p1409242339093522"></a><a name="p1409242339093522"></a>void </p>
<p id="p2022921774093522"><a name="p2022921774093522"></a><a name="p2022921774093522"></a>Sets the callback function to be invoked upon a click event. </p>
</td>
</tr>
<tr id="row463828234093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1236280555093522"><a name="p1236280555093522"></a><a name="p1236280555093522"></a><a href="graphic.md#gadad75361a42fd390b5f9c5edad2f2f0b">OHOS::TextAdapter::SetTextFormatter</a> (<a href="ohos-textformatter.md">TextFormatter</a> *formatter)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1683333333093522"><a name="p1683333333093522"></a><a name="p1683333333093522"></a>void </p>
<p id="p327116608093522"><a name="p327116608093522"></a><a name="p327116608093522"></a>Sets the text formatter. </p>
</td>
</tr>
<tr id="row239884061093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1430458681093522"><a name="p1430458681093522"></a><a name="p1430458681093522"></a><a href="graphic.md#ga160a40d9f81c72b606b3c5b05168bacf">OHOS::UIAbstractClock::UIAbstractClock</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1960887086093522"><a name="p1960887086093522"></a><a name="p1960887086093522"></a> </p>
<p id="p132545178093522"><a name="p132545178093522"></a><a name="p132545178093522"></a>A default constructor used to create a <strong id="b1719070916093522"><a name="b1719070916093522"></a><a name="b1719070916093522"></a><a href="ohos-uiabstractclock.md">UIAbstractClock</a></strong> instance. </p>
</td>
</tr>
<tr id="row148664834093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p143628543093522"><a name="p143628543093522"></a><a name="p143628543093522"></a><a href="graphic.md#ga93d3d68e48a79ee7fc4b42a9c0c0ccc1">OHOS::UIAbstractClock::UIAbstractClock</a> (uint8_t hour, uint8_t minute, uint8_t second)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1217230626093522"><a name="p1217230626093522"></a><a name="p1217230626093522"></a> </p>
<p id="p257292186093522"><a name="p257292186093522"></a><a name="p257292186093522"></a>A constructor used to create a <strong id="b1377617136093522"><a name="b1377617136093522"></a><a name="b1377617136093522"></a><a href="ohos-uiabstractclock.md">UIAbstractClock</a></strong> instance with time elements (hour, minute and second). </p>
</td>
</tr>
<tr id="row769691252093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1135002877093522"><a name="p1135002877093522"></a><a name="p1135002877093522"></a><a href="graphic.md#ga0fb0c108b319f02b9d42b34c1d2c8708">OHOS::UIAbstractClock::~UIAbstractClock</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p714447300093522"><a name="p714447300093522"></a><a name="p714447300093522"></a>virtual </p>
<p id="p1550843552093522"><a name="p1550843552093522"></a><a name="p1550843552093522"></a>A destructor used to delete the <strong id="b1621037350093522"><a name="b1621037350093522"></a><a name="b1621037350093522"></a><a href="ohos-uiabstractclock.md">UIAbstractClock</a></strong> instance. </p>
</td>
</tr>
<tr id="row624375359093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1303089437093522"><a name="p1303089437093522"></a><a name="p1303089437093522"></a><a href="graphic.md#ga8f7edc9e099688b4fd2b3ed3171eac58">OHOS::UIAbstractClock::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p11812347093522"><a name="p11812347093522"></a><a name="p11812347093522"></a>UIViewType </p>
<p id="p496496089093522"><a name="p496496089093522"></a><a name="p496496089093522"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row1268763464093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p263993405093522"><a name="p263993405093522"></a><a name="p263993405093522"></a><a href="graphic.md#ga44a7312163a4192670c00bb8f9916e51">OHOS::UIAbstractClock::SetTime24Hour</a> (uint8_t hour, uint8_t minute, uint8_t second)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p212935378093522"><a name="p212935378093522"></a><a name="p212935378093522"></a>void </p>
<p id="p1836743968093522"><a name="p1836743968093522"></a><a name="p1836743968093522"></a>Sets the time in 24-hour format. </p>
</td>
</tr>
<tr id="row1182694587093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p464539922093522"><a name="p464539922093522"></a><a name="p464539922093522"></a><a href="graphic.md#ga37750dfa0b5a47c8dcb61547dd991a6a">OHOS::UIAbstractClock::SetTime12Hour</a> (uint8_t hour, uint8_t minute, uint8_t second, bool am)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1873064624093522"><a name="p1873064624093522"></a><a name="p1873064624093522"></a>void </p>
<p id="p1945218331093522"><a name="p1945218331093522"></a><a name="p1945218331093522"></a>Sets the time in 12-hour format. </p>
</td>
</tr>
<tr id="row1193899873093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1209276112093522"><a name="p1209276112093522"></a><a name="p1209276112093522"></a><a href="graphic.md#ga8cf863dfcd63410f2f20572a51f2516b">OHOS::UIAbstractClock::GetCurrentHour</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1534602804093522"><a name="p1534602804093522"></a><a name="p1534602804093522"></a>uint8_t </p>
<p id="p966350205093522"><a name="p966350205093522"></a><a name="p966350205093522"></a>Obtains the current number of hours. </p>
</td>
</tr>
<tr id="row1131768315093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1900869659093522"><a name="p1900869659093522"></a><a name="p1900869659093522"></a><a href="graphic.md#ga5f0eea09577104d9126a07bfbc0b780a">OHOS::UIAbstractClock::GetCurrentMinute</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1858368435093522"><a name="p1858368435093522"></a><a name="p1858368435093522"></a>uint8_t </p>
<p id="p1198732907093522"><a name="p1198732907093522"></a><a name="p1198732907093522"></a>Obtains the current number of minutes. </p>
</td>
</tr>
<tr id="row2049335994093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1911399679093522"><a name="p1911399679093522"></a><a name="p1911399679093522"></a><a href="graphic.md#ga7bd4d2d4631d9ea373d008ec7a5d18ff">OHOS::UIAbstractClock::GetCurrentSecond</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p340199163093522"><a name="p340199163093522"></a><a name="p340199163093522"></a>uint8_t </p>
<p id="p1175838429093522"><a name="p1175838429093522"></a><a name="p1175838429093522"></a>Obtains the current number of seconds. </p>
</td>
</tr>
<tr id="row735619333093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1647547873093522"><a name="p1647547873093522"></a><a name="p1647547873093522"></a><a href="graphic.md#gaf4c05e6acf6700d7edb69dc49cd6fef8">OHOS::UIAbstractClock::IncOneSecond</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p771036347093522"><a name="p771036347093522"></a><a name="p771036347093522"></a>void </p>
<p id="p895738249093522"><a name="p895738249093522"></a><a name="p895738249093522"></a>Increases the time by one second. </p>
</td>
</tr>
<tr id="row1758512826093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1301057950093522"><a name="p1301057950093522"></a><a name="p1301057950093522"></a><a href="graphic.md#gad7c0fba1eac5d10998954e9c1e097197">OHOS::UIAbstractClock::UpdateClock</a> (bool clockInit)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1123400818093522"><a name="p1123400818093522"></a><a name="p1123400818093522"></a>virtual void </p>
<p id="p485544203093522"><a name="p485544203093522"></a><a name="p485544203093522"></a>Updates this clock. </p>
</td>
</tr>
<tr id="row1555046326093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p927636642093522"><a name="p927636642093522"></a><a name="p927636642093522"></a><a href="graphic.md#gaafa5df66c896268de27bf335c1b72b92">OHOS::UIAbstractClock::SetWorkMode</a> (<a href="graphic.md#ga19db90932bc71e6bbced6ccf2935ac98">WorkMode</a> newMode)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1292702183093522"><a name="p1292702183093522"></a><a name="p1292702183093522"></a>virtual void </p>
<p id="p563053763093522"><a name="p563053763093522"></a><a name="p563053763093522"></a>Sets the working mode for this clock. </p>
</td>
</tr>
<tr id="row76728456093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1118534996093522"><a name="p1118534996093522"></a><a name="p1118534996093522"></a><a href="graphic.md#gad2d78422d212ef1e93bb4a23e1ee3859">OHOS::UIAbstractClock::GetWorkMode</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p313358205093522"><a name="p313358205093522"></a><a name="p313358205093522"></a>virtual <a href="graphic.md#ga19db90932bc71e6bbced6ccf2935ac98">WorkMode</a> </p>
<p id="p1952233034093522"><a name="p1952233034093522"></a><a name="p1952233034093522"></a>Obtains the working mode of this clock. </p>
</td>
</tr>
<tr id="row1736572636093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p438055322093522"><a name="p438055322093522"></a><a name="p438055322093522"></a><a href="graphic.md#ga8f9bfb4f42ee0e094501ff776e3336da">OHOS::UIAbstractProgress::UIAbstractProgress</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p930009673093522"><a name="p930009673093522"></a><a name="p930009673093522"></a> </p>
<p id="p1065903257093522"><a name="p1065903257093522"></a><a name="p1065903257093522"></a>A constructor used to create a <strong id="b184827991093522"><a name="b184827991093522"></a><a name="b184827991093522"></a><a href="ohos-uiabstractprogress.md">UIAbstractProgress</a></strong> instance. </p>
</td>
</tr>
<tr id="row1765955530093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p357593208093522"><a name="p357593208093522"></a><a name="p357593208093522"></a><a href="graphic.md#ga5c1cf7239bf0c0f7d331e63df805b518">OHOS::UIAbstractProgress::~UIAbstractProgress</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1458592699093522"><a name="p1458592699093522"></a><a name="p1458592699093522"></a>virtual </p>
<p id="p1265149282093522"><a name="p1265149282093522"></a><a name="p1265149282093522"></a>A destructor used to delete the <strong id="b473676767093522"><a name="b473676767093522"></a><a name="b473676767093522"></a><a href="ohos-uiabstractprogress.md">UIAbstractProgress</a></strong> instance. </p>
</td>
</tr>
<tr id="row1732412788093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p111674938093522"><a name="p111674938093522"></a><a name="p111674938093522"></a><a href="graphic.md#ga79885b87d1935947f6980ae56f139083">OHOS::UIAbstractProgress::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2053998708093522"><a name="p2053998708093522"></a><a name="p2053998708093522"></a>UIViewType </p>
<p id="p1486765262093522"><a name="p1486765262093522"></a><a name="p1486765262093522"></a>Obtains the component type. </p>
</td>
</tr>
<tr id="row1722773465093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p70628950093522"><a name="p70628950093522"></a><a name="p70628950093522"></a><a href="graphic.md#gacb680c1ddc9135371676df504dc6c8f2">OHOS::UIAbstractProgress::EnableBackground</a> (bool enable)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p390196383093522"><a name="p390196383093522"></a><a name="p390196383093522"></a>void </p>
<p id="p717053052093522"><a name="p717053052093522"></a><a name="p717053052093522"></a>Sets whether the background of the progress bar is visible. </p>
</td>
</tr>
<tr id="row1227904165093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2143703272093522"><a name="p2143703272093522"></a><a name="p2143703272093522"></a><a href="graphic.md#ga5f65014431a6489ffa1d4949f9c4449b">OHOS::UIAbstractProgress::SetValue</a> (int16_t value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p825939704093522"><a name="p825939704093522"></a><a name="p825939704093522"></a>void </p>
<p id="p704604086093522"><a name="p704604086093522"></a><a name="p704604086093522"></a>Sets the current value for this progress bar. </p>
</td>
</tr>
<tr id="row1292638205093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1865806174093522"><a name="p1865806174093522"></a><a name="p1865806174093522"></a><a href="graphic.md#ga6face76aa7972efeb6cbb8f525f23135">OHOS::UIAbstractProgress::GetValue</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1175344848093522"><a name="p1175344848093522"></a><a name="p1175344848093522"></a>int16_t </p>
<p id="p203568000093522"><a name="p203568000093522"></a><a name="p203568000093522"></a>Obtains the current value of this progress bar. </p>
</td>
</tr>
<tr id="row1492114733093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2015608044093522"><a name="p2015608044093522"></a><a name="p2015608044093522"></a><a href="graphic.md#ga089e3875453011499ad33ed89a44a699">OHOS::UIAbstractProgress::SetRange</a> (int16_t rangeMax, int16_t rangeMin)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p112758681093522"><a name="p112758681093522"></a><a name="p112758681093522"></a>void </p>
<p id="p997254316093522"><a name="p997254316093522"></a><a name="p997254316093522"></a>Sets the range for this progress bar. </p>
</td>
</tr>
<tr id="row580417218093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1384826070093522"><a name="p1384826070093522"></a><a name="p1384826070093522"></a><a href="graphic.md#ga68ab733afcf4224a799ccad2092d1d23">OHOS::UIAbstractProgress::GetRangeMin</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1264740689093522"><a name="p1264740689093522"></a><a name="p1264740689093522"></a>int16_t </p>
<p id="p479475276093522"><a name="p479475276093522"></a><a name="p479475276093522"></a>Obtains the minimum value of this progress bar. </p>
</td>
</tr>
<tr id="row1470185159093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1161242685093522"><a name="p1161242685093522"></a><a name="p1161242685093522"></a><a href="graphic.md#ga1840199f22d5d3e4ef58e41ac8f4febc">OHOS::UIAbstractProgress::GetRangeMax</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p704904066093522"><a name="p704904066093522"></a><a name="p704904066093522"></a>int16_t </p>
<p id="p1256247644093522"><a name="p1256247644093522"></a><a name="p1256247644093522"></a>Obtains the maximum value of this progress bar. </p>
</td>
</tr>
<tr id="row1970775669093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p286581199093522"><a name="p286581199093522"></a><a name="p286581199093522"></a><a href="graphic.md#ga5b3ec363e391f601e12bf937b9cf77db">OHOS::UIAbstractProgress::SetImage</a> (const char *foregroundImage, const char *backgroundImage=nullptr)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p405109920093522"><a name="p405109920093522"></a><a name="p405109920093522"></a>void </p>
<p id="p1101514182093522"><a name="p1101514182093522"></a><a name="p1101514182093522"></a>Sets the image for this progress bar. </p>
</td>
</tr>
<tr id="row1086696496093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1739222957093522"><a name="p1739222957093522"></a><a name="p1739222957093522"></a><a href="graphic.md#ga10723293ab9e384907dd9dacbc9ad448">OHOS::UIAbstractProgress::SetImage</a> (const <a href="ohos-imageinfo.md">ImageInfo</a> *foregroundImage, const <a href="ohos-imageinfo.md">ImageInfo</a> *backgroundImage=nullptr)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2372946093522"><a name="p2372946093522"></a><a name="p2372946093522"></a>void </p>
<p id="p1139947736093522"><a name="p1139947736093522"></a><a name="p1139947736093522"></a>Sets the image as a pixel map for this progress bar. </p>
</td>
</tr>
<tr id="row1257278707093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p966007642093522"><a name="p966007642093522"></a><a name="p966007642093522"></a><a href="graphic.md#ga747a29652b441a06d09a97a297aae9bb">OHOS::UIAbstractProgress::SetStep</a> (uint16_t step)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1486517251093522"><a name="p1486517251093522"></a><a name="p1486517251093522"></a>void </p>
<p id="p1600451270093522"><a name="p1600451270093522"></a><a name="p1600451270093522"></a>Sets the step for this progress bar. </p>
</td>
</tr>
<tr id="row692546098093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1883820083093522"><a name="p1883820083093522"></a><a name="p1883820083093522"></a><a href="graphic.md#ga9c1678604605a54c2e338d283c46866d">OHOS::UIAbstractProgress::GetStep</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1365691914093522"><a name="p1365691914093522"></a><a name="p1365691914093522"></a>uint16_t </p>
<p id="p1751869719093522"><a name="p1751869719093522"></a><a name="p1751869719093522"></a>Obtains the current step of this progress bar. </p>
</td>
</tr>
<tr id="row1079495249093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p737145824093522"><a name="p737145824093522"></a><a name="p737145824093522"></a><a href="graphic.md#ga6817b5178e93e5f16f2b420cf5a171c1">OHOS::UIAbstractProgress::SetBackgroundStyle</a> (const <a href="ohos-style.md">Style</a> &amp;style)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p881006541093522"><a name="p881006541093522"></a><a name="p881006541093522"></a>void </p>
<p id="p1675440423093522"><a name="p1675440423093522"></a><a name="p1675440423093522"></a>Sets the background style for this progress bar. </p>
</td>
</tr>
<tr id="row116640313093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1192293821093522"><a name="p1192293821093522"></a><a name="p1192293821093522"></a><a href="graphic.md#ga23acea0a42587746e35ec5f3a74af59f">OHOS::UIAbstractProgress::SetBackgroundStyle</a> (uint8_t key, int64_t value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1920128612093522"><a name="p1920128612093522"></a><a name="p1920128612093522"></a>void </p>
<p id="p933167162093522"><a name="p933167162093522"></a><a name="p933167162093522"></a>Sets a background style for this progress bar. </p>
</td>
</tr>
<tr id="row498871524093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p764678648093522"><a name="p764678648093522"></a><a name="p764678648093522"></a><a href="graphic.md#gac2ca1212c23c11405b12ae0a46c7eff1">OHOS::UIAbstractProgress::GetBackgroundStyle</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1305985061093522"><a name="p1305985061093522"></a><a name="p1305985061093522"></a>const <a href="ohos-style.md">Style</a> &amp; </p>
<p id="p236323453093522"><a name="p236323453093522"></a><a name="p236323453093522"></a>Obtains the background style of this progress bar. </p>
</td>
</tr>
<tr id="row837773025093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p998718617093522"><a name="p998718617093522"></a><a name="p998718617093522"></a><a href="graphic.md#ga946d3f2c39a79d45149118536b2557a9">OHOS::UIAbstractProgress::GetBackgroundStyle</a> (uint8_t key) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1201575641093522"><a name="p1201575641093522"></a><a name="p1201575641093522"></a>int64_t </p>
<p id="p894155848093522"><a name="p894155848093522"></a><a name="p894155848093522"></a>Obtains the value of a background style of this progress bar. </p>
</td>
</tr>
<tr id="row855854415093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p745473272093522"><a name="p745473272093522"></a><a name="p745473272093522"></a><a href="graphic.md#gaccebcfa35f98f9bc6be4bb8cc53eb11c">OHOS::UIAbstractProgress::SetForegroundStyle</a> (const <a href="ohos-style.md">Style</a> &amp;style)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p589755602093522"><a name="p589755602093522"></a><a name="p589755602093522"></a>void </p>
<p id="p478145057093522"><a name="p478145057093522"></a><a name="p478145057093522"></a>Sets the foreground style for this progress bar. </p>
</td>
</tr>
<tr id="row390859884093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p41402549093522"><a name="p41402549093522"></a><a name="p41402549093522"></a><a href="graphic.md#gae6386ca25603e42f06087f6b2ef65bae">OHOS::UIAbstractProgress::SetForegroundStyle</a> (uint8_t key, int64_t value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p197257115093522"><a name="p197257115093522"></a><a name="p197257115093522"></a>void </p>
<p id="p1938249658093522"><a name="p1938249658093522"></a><a name="p1938249658093522"></a>Sets a foreground style for this progress bar. </p>
</td>
</tr>
<tr id="row1102020100093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p269394840093522"><a name="p269394840093522"></a><a name="p269394840093522"></a><a href="graphic.md#gac77f945f375f333f80bd70254b5c1f96">OHOS::UIAbstractProgress::GetForegroundStyle</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p726451335093522"><a name="p726451335093522"></a><a name="p726451335093522"></a>const <a href="ohos-style.md">Style</a> &amp; </p>
<p id="p206883201093522"><a name="p206883201093522"></a><a name="p206883201093522"></a>Obtains the foreground style of this progress bar. </p>
</td>
</tr>
<tr id="row1956322749093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p842295255093522"><a name="p842295255093522"></a><a name="p842295255093522"></a><a href="graphic.md#ga74cd121dd1794d7e8d905b233bd98217">OHOS::UIAbstractProgress::GetForegroundStyle</a> (uint8_t key) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p510744767093522"><a name="p510744767093522"></a><a name="p510744767093522"></a>int64_t </p>
<p id="p216163805093522"><a name="p216163805093522"></a><a name="p216163805093522"></a>Obtains the value of a foreground style of this progress bar. </p>
</td>
</tr>
<tr id="row628248580093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p194089337093522"><a name="p194089337093522"></a><a name="p194089337093522"></a><a href="graphic.md#gabdc0eb4d279212ea7c3ea7a1f9a85e13">OHOS::UIAbstractProgress::SetCapType</a> (<a href="graphic.md#ga2db3928cdf793f4950245a6841dd43d6">CapType</a> cap)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1819133479093522"><a name="p1819133479093522"></a><a name="p1819133479093522"></a>void </p>
<p id="p261950923093522"><a name="p261950923093522"></a><a name="p261950923093522"></a>Sets the type of caps on the background and foreground of the progress bar. </p>
</td>
</tr>
<tr id="row1356202229093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1262088871093522"><a name="p1262088871093522"></a><a name="p1262088871093522"></a><a href="graphic.md#ga93a169fba7c98f6534692cba9e8d539b">OHOS::UIAbstractScroll::UIAbstractScroll</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p218826790093522"><a name="p218826790093522"></a><a name="p218826790093522"></a> </p>
<p id="p2066704276093522"><a name="p2066704276093522"></a><a name="p2066704276093522"></a>A constructor used to create a <strong id="b124750668093522"><a name="b124750668093522"></a><a name="b124750668093522"></a><a href="ohos-uiabstractscroll.md">UIAbstractScroll</a></strong> instance. </p>
</td>
</tr>
<tr id="row151758527093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p394469274093522"><a name="p394469274093522"></a><a name="p394469274093522"></a><a href="graphic.md#ga414798ec7357edc85409128fba0a813c">OHOS::UIAbstractScroll::~UIAbstractScroll</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1318828519093522"><a name="p1318828519093522"></a><a name="p1318828519093522"></a>virtual </p>
<p id="p1037956788093522"><a name="p1037956788093522"></a><a name="p1037956788093522"></a>A destructor used to delete the <strong id="b1921925062093522"><a name="b1921925062093522"></a><a name="b1921925062093522"></a><a href="ohos-uiabstractscroll.md">UIAbstractScroll</a></strong> instance. </p>
</td>
</tr>
<tr id="row1911623508093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1915847026093522"><a name="p1915847026093522"></a><a name="p1915847026093522"></a><a href="graphic.md#gaeb9e84901b38ef75fa650fc5a27ffc65">OHOS::UIAbstractScroll::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p368371018093522"><a name="p368371018093522"></a><a name="p368371018093522"></a>UIViewType </p>
<p id="p1320286243093522"><a name="p1320286243093522"></a><a name="p1320286243093522"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row617807087093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p564929079093522"><a name="p564929079093522"></a><a name="p564929079093522"></a><a href="graphic.md#ga443783170697bea9a933843ad2a92283">OHOS::UIAbstractScroll::GetDirection</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p242230547093522"><a name="p242230547093522"></a><a name="p242230547093522"></a>uint8_t </p>
<p id="p951476724093522"><a name="p951476724093522"></a><a name="p951476724093522"></a>Obtains the scroll direction. </p>
</td>
</tr>
<tr id="row499755823093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2110828425093522"><a name="p2110828425093522"></a><a name="p2110828425093522"></a><a href="graphic.md#gab37cea97d63ee9ca609c9a1ed0f1e281">OHOS::UIAbstractScroll::SetScrollBlankSize</a> (uint16_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p144833749093522"><a name="p144833749093522"></a><a name="p144833749093522"></a>void </p>
<p id="p596595088093522"><a name="p596595088093522"></a><a name="p596595088093522"></a>Sets the blank size for this scroll view. </p>
</td>
</tr>
<tr id="row1513984698093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p710868827093522"><a name="p710868827093522"></a><a name="p710868827093522"></a><a href="graphic.md#gae2d6f5c97a316ecd3b41fecfa35a351f">OHOS::UIAbstractScroll::SetMaxScrollDistance</a> (uint16_t distance)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p172979048093522"><a name="p172979048093522"></a><a name="p172979048093522"></a>void </p>
<p id="p871761813093522"><a name="p871761813093522"></a><a name="p871761813093522"></a>Sets the maximum scroll distance after a finger lifts the screen. </p>
</td>
</tr>
<tr id="row64411929093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p421705800093522"><a name="p421705800093522"></a><a name="p421705800093522"></a><a href="graphic.md#ga5d7fefcd2057e868a8f6c6a6000aa7ef">OHOS::UIAbstractScroll::SetReboundSize</a> (uint16_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p704567185093522"><a name="p704567185093522"></a><a name="p704567185093522"></a>void </p>
<p id="p473354084093522"><a name="p473354084093522"></a><a name="p473354084093522"></a>Sets the rebound size, which is the distance a knob moves after being released when it reaches the end of a scrollbar. </p>
</td>
</tr>
<tr id="row1370751225093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1659698828093522"><a name="p1659698828093522"></a><a name="p1659698828093522"></a><a href="graphic.md#ga71a2b17d4145479ed2e2ca000eb7e86e">OHOS::UIAbstractScroll::GetMaxScrollDistance</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1131329539093522"><a name="p1131329539093522"></a><a name="p1131329539093522"></a>uint16_t </p>
<p id="p1537573831093522"><a name="p1537573831093522"></a><a name="p1537573831093522"></a>Obtains the maximum scroll distance after a finger lifts the screen. </p>
</td>
</tr>
<tr id="row2144127274093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p291704308093522"><a name="p291704308093522"></a><a name="p291704308093522"></a><a href="graphic.md#ga957ec65a7efad6818be6df5169158aad">OHOS::UIAbstractScroll::SetDragFunc</a> (EasingFunc func)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1702258653093522"><a name="p1702258653093522"></a><a name="p1702258653093522"></a>void </p>
<p id="p554637135093522"><a name="p554637135093522"></a><a name="p554637135093522"></a>Sets the easing function that specifies a scroll animation after a finger lifts the screen. </p>
</td>
</tr>
<tr id="row2076044532093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p649605161093522"><a name="p649605161093522"></a><a name="p649605161093522"></a><a href="graphic.md#ga4dde5f89d70304e77a96d4f4679438c2">OHOS::UIAbstractScroll::SetThrowDrag</a> (bool throwDrag)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1360091724093522"><a name="p1360091724093522"></a><a name="p1360091724093522"></a>void </p>
<p id="p364919016093522"><a name="p364919016093522"></a><a name="p364919016093522"></a>Sets whether to continue scrolling after a finger lifts the screen. </p>
</td>
</tr>
<tr id="row400750722093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1965694314093522"><a name="p1965694314093522"></a><a name="p1965694314093522"></a><a href="graphic.md#ga5013215d3075616ae081849ef52bb57a">OHOS::UIAbstractScroll::MoveChildByOffset</a> (int16_t offsetX, int16_t offsetY) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1885763428093522"><a name="p1885763428093522"></a><a name="p1885763428093522"></a>void </p>
<p id="p1889834422093522"><a name="p1889834422093522"></a><a name="p1889834422093522"></a>Moves the position of all child views. </p>
</td>
</tr>
<tr id="row310082099093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p69623962093522"><a name="p69623962093522"></a><a name="p69623962093522"></a><a href="graphic.md#gad344babd5b251ed908cdf628fae55093">OHOS::UIAbstractScroll::SetDragACCLevel</a> (uint16_t value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p308195803093522"><a name="p308195803093522"></a><a name="p308195803093522"></a>void </p>
<p id="p356779528093522"><a name="p356779528093522"></a><a name="p356779528093522"></a>Sets the drag acceleration. </p>
</td>
</tr>
<tr id="row558253293093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1934880240093522"><a name="p1934880240093522"></a><a name="p1934880240093522"></a><a href="graphic.md#ga29e68195b56783f265d85506f130c664">OHOS::UIAbstractScroll::GetDragACCLevel</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p356836608093522"><a name="p356836608093522"></a><a name="p356836608093522"></a>uint8_t </p>
<p id="p159260705093522"><a name="p159260705093522"></a><a name="p159260705093522"></a>Obtains the drag acceleration. </p>
</td>
</tr>
<tr id="row1219372671093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2140949118093522"><a name="p2140949118093522"></a><a name="p2140949118093522"></a><a href="graphic.md#gafab9d1a8f5987b50f9111c733ada6341">OHOS::UIAbstractScroll::SetSwipeACCLevel</a> (uint16_t value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1449734073093522"><a name="p1449734073093522"></a><a name="p1449734073093522"></a>void </p>
<p id="p1337252035093522"><a name="p1337252035093522"></a><a name="p1337252035093522"></a>Sets the compensation distance after a finger lifts the screen. </p>
</td>
</tr>
<tr id="row1903559442093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p833918791093522"><a name="p833918791093522"></a><a name="p833918791093522"></a><a href="graphic.md#ga25dad3242949f0fbeff47d6df06053f6">OHOS::UIAbstractScroll::GetSwipeACCLevel</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1391660501093522"><a name="p1391660501093522"></a><a name="p1391660501093522"></a>uint8_t </p>
<p id="p283320300093522"><a name="p283320300093522"></a><a name="p283320300093522"></a>Obtains the compensation distance after a finger lifts the screen. </p>
</td>
</tr>
<tr id="row2046430727093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p19602641093522"><a name="p19602641093522"></a><a name="p19602641093522"></a><a href="graphic.md#ga2e986cb53c62dd015edced59450b9fff">OHOS::UIAnalogClock::UIAnalogClock</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1656227696093522"><a name="p1656227696093522"></a><a name="p1656227696093522"></a> </p>
<p id="p1688469248093522"><a name="p1688469248093522"></a><a name="p1688469248093522"></a>A default constructor used to create a <strong id="b880605718093522"><a name="b880605718093522"></a><a name="b880605718093522"></a><a href="ohos-uianalogclock.md">UIAnalogClock</a></strong> instance. </p>
</td>
</tr>
<tr id="row1218717620093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p918832088093522"><a name="p918832088093522"></a><a name="p918832088093522"></a><a href="graphic.md#ga4b06e05f003e25206d5fa772b303dcc5">OHOS::UIAnalogClock::~UIAnalogClock</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1869350041093522"><a name="p1869350041093522"></a><a name="p1869350041093522"></a>virtual </p>
<p id="p19866525093522"><a name="p19866525093522"></a><a name="p19866525093522"></a>A destructor used to delete the <strong id="b1784774652093522"><a name="b1784774652093522"></a><a name="b1784774652093522"></a><a href="ohos-uianalogclock.md">UIAnalogClock</a></strong> instance. </p>
</td>
</tr>
<tr id="row1974364072093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1388207858093522"><a name="p1388207858093522"></a><a name="p1388207858093522"></a><a href="graphic.md#gac075169429f99f60ed660a44db7f4031">OHOS::UIAnalogClock::Hand::Hand</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1572798933093522"><a name="p1572798933093522"></a><a name="p1572798933093522"></a> </p>
<p id="p320853178093522"><a name="p320853178093522"></a><a name="p320853178093522"></a>A default constructor used to create a <strong id="b1614242882093522"><a name="b1614242882093522"></a><a name="b1614242882093522"></a><a href="ohos-uianalogclock-hand.md">Hand</a></strong> instance. </p>
</td>
</tr>
<tr id="row1251887689093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p449725014093522"><a name="p449725014093522"></a><a name="p449725014093522"></a><a href="graphic.md#ga1e433482830dd12b9b40430dab92505f">OHOS::UIAnalogClock::Hand::~Hand</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p799195762093522"><a name="p799195762093522"></a><a name="p799195762093522"></a>virtual </p>
<p id="p830641674093522"><a name="p830641674093522"></a><a name="p830641674093522"></a>A destructor used to delete the <strong id="b1843782109093522"><a name="b1843782109093522"></a><a name="b1843782109093522"></a><a href="ohos-uianalogclock-hand.md">Hand</a></strong> instance. </p>
</td>
</tr>
<tr id="row1607132608093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1164255932093522"><a name="p1164255932093522"></a><a name="p1164255932093522"></a><a href="graphic.md#ga2f5123df8cbcc4f55c5192acbe30ba0d">OHOS::UIAnalogClock::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1101061055093522"><a name="p1101061055093522"></a><a name="p1101061055093522"></a>UIViewType </p>
<p id="p1644460827093522"><a name="p1644460827093522"></a><a name="p1644460827093522"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row371015522093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1706817972093522"><a name="p1706817972093522"></a><a name="p1706817972093522"></a><a href="graphic.md#ga18816e5dae6a7b79cbc408b1bc70c584">OHOS::UIAnalogClock::SetHandImage</a> (<a href="graphic.md#ga13cf64ea5bd39550976aaf65b1381edf">HandType</a> type, const <a href="ohos-uiimageview.md">UIImageView</a> &amp;img, <a href="ohos-point.md">Point</a> position, <a href="ohos-point.md">Point</a> center)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2110263851093522"><a name="p2110263851093522"></a><a name="p2110263851093522"></a>void </p>
<p id="p622767499093522"><a name="p622767499093522"></a><a name="p622767499093522"></a>Sets the image used to draw a clock hand. </p>
</td>
</tr>
<tr id="row500521616093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p613318584093522"><a name="p613318584093522"></a><a name="p613318584093522"></a><a href="graphic.md#ga271358e8076b55ed48de19350b3e55de">OHOS::UIAnalogClock::SetHandLine</a> (<a href="graphic.md#ga13cf64ea5bd39550976aaf65b1381edf">HandType</a> type, <a href="ohos-point.md">Point</a> position, <a href="ohos-point.md">Point</a> center, <a href="ohos-color32.md">ColorType</a> color, uint16_t width, uint16_t height, OpacityType opacity)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1522601599093522"><a name="p1522601599093522"></a><a name="p1522601599093522"></a>void </p>
<p id="p2089752298093522"><a name="p2089752298093522"></a><a name="p2089752298093522"></a>Sets the line used to draw a clock hand. </p>
</td>
</tr>
<tr id="row846547688093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1762929237093522"><a name="p1762929237093522"></a><a name="p1762929237093522"></a><a href="graphic.md#ga4943396addd8f88fb131aa03319e3d8a">OHOS::UIAnalogClock::GetHandRotateCenter</a> (<a href="graphic.md#ga13cf64ea5bd39550976aaf65b1381edf">HandType</a> type) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p691428474093522"><a name="p691428474093522"></a><a name="p691428474093522"></a><a href="ohos-point.md">Point</a> </p>
<p id="p832054093522"><a name="p832054093522"></a><a name="p832054093522"></a>Obtains the rotation center of a specified clock hand. </p>
</td>
</tr>
<tr id="row1273002598093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p580078547093522"><a name="p580078547093522"></a><a name="p580078547093522"></a><a href="graphic.md#ga56b260401694fce13dc5f744cb8bf471">OHOS::UIAnalogClock::GetHandPosition</a> (<a href="graphic.md#ga13cf64ea5bd39550976aaf65b1381edf">HandType</a> type) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1611668030093522"><a name="p1611668030093522"></a><a name="p1611668030093522"></a><a href="ohos-point.md">Point</a> </p>
<p id="p95896944093522"><a name="p95896944093522"></a><a name="p95896944093522"></a>Obtains the position of a specified clock hand. </p>
</td>
</tr>
<tr id="row1845763382093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p125274653093522"><a name="p125274653093522"></a><a name="p125274653093522"></a><a href="graphic.md#ga3fdfc7872768c5f5cea6627958f53ff8">OHOS::UIAnalogClock::GetHandInitAngle</a> (<a href="graphic.md#ga13cf64ea5bd39550976aaf65b1381edf">HandType</a> type) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p858354986093522"><a name="p858354986093522"></a><a name="p858354986093522"></a>uint16_t </p>
<p id="p2021865254093522"><a name="p2021865254093522"></a><a name="p2021865254093522"></a>Obtains the initial rotation angle of the specified clock hand. </p>
</td>
</tr>
<tr id="row810461010093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p742274065093522"><a name="p742274065093522"></a><a name="p742274065093522"></a><a href="graphic.md#ga4092ecd3068a58937b750d308e8eca5f">OHOS::UIAnalogClock::GetHandCurrentAngle</a> (<a href="graphic.md#ga13cf64ea5bd39550976aaf65b1381edf">HandType</a> type) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p571187353093522"><a name="p571187353093522"></a><a name="p571187353093522"></a>uint16_t </p>
<p id="p365172048093522"><a name="p365172048093522"></a><a name="p365172048093522"></a>Obtains the current rotation angle of the specified clock hand. </p>
</td>
</tr>
<tr id="row1866779359093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p638907591093522"><a name="p638907591093522"></a><a name="p638907591093522"></a><a href="graphic.md#ga3099f37f0ff8cd1229c0734098649173">OHOS::UIAnalogClock::SetInitTime24Hour</a> (uint8_t hour, uint8_t minute, uint8_t second)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1161873559093522"><a name="p1161873559093522"></a><a name="p1161873559093522"></a>void </p>
<p id="p1439201023093522"><a name="p1439201023093522"></a><a name="p1439201023093522"></a>Sets the initial time in the 24-hour format. </p>
</td>
</tr>
<tr id="row2033932002093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1875821284093522"><a name="p1875821284093522"></a><a name="p1875821284093522"></a><a href="graphic.md#gaa118c65942244bb0948b626944c0eaf9">OHOS::UIAnalogClock::SetInitTime12Hour</a> (uint8_t hour, uint8_t minute, uint8_t second, bool am)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1638118038093522"><a name="p1638118038093522"></a><a name="p1638118038093522"></a>void </p>
<p id="p844179849093522"><a name="p844179849093522"></a><a name="p844179849093522"></a>Sets the initial time in the 12-hour format. </p>
</td>
</tr>
<tr id="row2007041082093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p869416870093522"><a name="p869416870093522"></a><a name="p869416870093522"></a><a href="graphic.md#ga6c943119bd89a863ec5f05722a1fd146">OHOS::UIAnalogClock::OnDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p37987898093522"><a name="p37987898093522"></a><a name="p37987898093522"></a>void </p>
<p id="p104452892093522"><a name="p104452892093522"></a><a name="p104452892093522"></a>Draws an analog clock. </p>
</td>
</tr>
<tr id="row1649808101093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p359438158093522"><a name="p359438158093522"></a><a name="p359438158093522"></a><a href="graphic.md#ga1366a4ca45babb67f3103279a2bbc0bf">OHOS::UIAnalogClock::OnPostDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2141947619093522"><a name="p2141947619093522"></a><a name="p2141947619093522"></a>virtual void </p>
<p id="p660155940093522"><a name="p660155940093522"></a><a name="p660155940093522"></a>Performs the operations needed after the drawing. </p>
</td>
</tr>
<tr id="row1355946263093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p797704555093522"><a name="p797704555093522"></a><a name="p797704555093522"></a><a href="graphic.md#ga01d3098090d17bdd720df6e861784e13">OHOS::UIAnalogClock::SetPosition</a> (int16_t x, int16_t y) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p141629837093522"><a name="p141629837093522"></a><a name="p141629837093522"></a>void </p>
<p id="p382388797093522"><a name="p382388797093522"></a><a name="p382388797093522"></a>Sets the position for this analog clock. </p>
</td>
</tr>
<tr id="row934203900093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1895349093093522"><a name="p1895349093093522"></a><a name="p1895349093093522"></a><a href="graphic.md#gaa7fad079e41c8efd137781350b60687b">OHOS::UIAnalogClock::SetPosition</a> (int16_t x, int16_t y, int16_t width, int16_t height) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p122313173093522"><a name="p122313173093522"></a><a name="p122313173093522"></a>void </p>
<p id="p1815550065093522"><a name="p1815550065093522"></a><a name="p1815550065093522"></a>Sets the position and size for this analog clock. </p>
</td>
</tr>
<tr id="row399242188093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1781499263093522"><a name="p1781499263093522"></a><a name="p1781499263093522"></a><a href="graphic.md#ga1714e171ff1e9248932a9f2c14c82d12">OHOS::UIAnalogClock::SetWorkMode</a> (<a href="graphic.md#ga19db90932bc71e6bbced6ccf2935ac98">WorkMode</a> newMode) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1090154601093522"><a name="p1090154601093522"></a><a name="p1090154601093522"></a>void </p>
<p id="p677578343093522"><a name="p677578343093522"></a><a name="p677578343093522"></a>Sets the working mode for this analog clock. </p>
</td>
</tr>
<tr id="row666831824093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p304908879093522"><a name="p304908879093522"></a><a name="p304908879093522"></a><a href="graphic.md#ga5274a3e5b66e5f80aab899ef4e61edb2">OHOS::UIAnalogClock::UpdateClock</a> (bool clockInit) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1371853446093522"><a name="p1371853446093522"></a><a name="p1371853446093522"></a>void </p>
<p id="p1245046620093522"><a name="p1245046620093522"></a><a name="p1245046620093522"></a>Updates the time of this analog clock. </p>
</td>
</tr>
<tr id="row152622340093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p307284892093522"><a name="p307284892093522"></a><a name="p307284892093522"></a><a href="graphic.md#gaeb650e68c370ef4d09d0eb0b30e4346e">OHOS::UIArcLabel::UIArcLabel</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p98847036093522"><a name="p98847036093522"></a><a name="p98847036093522"></a> </p>
<p id="p814490195093522"><a name="p814490195093522"></a><a name="p814490195093522"></a>A default constructor used to create a <strong id="b709578799093522"><a name="b709578799093522"></a><a name="b709578799093522"></a><a href="ohos-uiarclabel.md">UIArcLabel</a></strong> instance. </p>
</td>
</tr>
<tr id="row287583248093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p961755362093522"><a name="p961755362093522"></a><a name="p961755362093522"></a><a href="graphic.md#ga89c52725ea96d25f451c2cd29f9cee22">OHOS::UIArcLabel::~UIArcLabel</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p217308195093522"><a name="p217308195093522"></a><a name="p217308195093522"></a>virtual </p>
<p id="p1397670937093522"><a name="p1397670937093522"></a><a name="p1397670937093522"></a>A destructor used to delete the <strong id="b2019500870093522"><a name="b2019500870093522"></a><a name="b2019500870093522"></a><a href="ohos-uiarclabel.md">UIArcLabel</a></strong> instance. </p>
</td>
</tr>
<tr id="row565500715093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1602354333093522"><a name="p1602354333093522"></a><a name="p1602354333093522"></a><a href="graphic.md#ga2ebe9b09e69cd04b00db686dbec8c32c">OHOS::UIArcLabel::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1729192157093522"><a name="p1729192157093522"></a><a name="p1729192157093522"></a>UIViewType </p>
<p id="p1512374156093522"><a name="p1512374156093522"></a><a name="p1512374156093522"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row698206398093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1037704127093522"><a name="p1037704127093522"></a><a name="p1037704127093522"></a><a href="graphic.md#gae2348ef2f06893325ca3366856657199">OHOS::UIArcLabel::GetWidth</a> () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p535636908093522"><a name="p535636908093522"></a><a name="p535636908093522"></a>int16_t </p>
<p id="p629779733093522"><a name="p629779733093522"></a><a name="p629779733093522"></a>Obtains the width of this arc text. </p>
</td>
</tr>
<tr id="row776869626093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1256093041093522"><a name="p1256093041093522"></a><a name="p1256093041093522"></a><a href="graphic.md#ga37dbe21b6a8206460136b18a2d0e3f65">OHOS::UIArcLabel::GetHeight</a> () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p931225849093522"><a name="p931225849093522"></a><a name="p931225849093522"></a>int16_t </p>
<p id="p678352317093522"><a name="p678352317093522"></a><a name="p678352317093522"></a>Obtains the height of this arc text. </p>
</td>
</tr>
<tr id="row719619544093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1275982401093522"><a name="p1275982401093522"></a><a name="p1275982401093522"></a><a href="graphic.md#ga6085d982d8ec3d570b2eabc7d1a58b67">OHOS::UIArcLabel::SetText</a> (const char *text)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1774620290093522"><a name="p1774620290093522"></a><a name="p1774620290093522"></a>void </p>
<p id="p1277206823093522"><a name="p1277206823093522"></a><a name="p1277206823093522"></a>Sets the text content for this arc label. </p>
</td>
</tr>
<tr id="row658814786093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p507673844093522"><a name="p507673844093522"></a><a name="p507673844093522"></a><a href="graphic.md#gaf6541786a44218c7561a9e0f38dea985">OHOS::UIArcLabel::GetText</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p931426527093522"><a name="p931426527093522"></a><a name="p931426527093522"></a>const char * </p>
<p id="p1200939731093522"><a name="p1200939731093522"></a><a name="p1200939731093522"></a>Obtains the text of this arc label. </p>
</td>
</tr>
<tr id="row1287969947093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p190699300093522"><a name="p190699300093522"></a><a name="p190699300093522"></a><a href="graphic.md#gad379123d69ceb0dbb49d4055f9abac82">OHOS::UIArcLabel::SetAlign</a> (<a href="graphic.md#ga3f99b58f731a37cacde72d5e0c934593">UITextLanguageAlignment</a> horizontalAlign)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p168124106093522"><a name="p168124106093522"></a><a name="p168124106093522"></a>void </p>
<p id="p1737506072093522"><a name="p1737506072093522"></a><a name="p1737506072093522"></a>Sets the alignment mode for this text. </p>
</td>
</tr>
<tr id="row1427206326093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p234404753093522"><a name="p234404753093522"></a><a name="p234404753093522"></a><a href="graphic.md#ga81db66fbe12615d85c68971e58201939">OHOS::UIArcLabel::GetHorAlign</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1642731622093522"><a name="p1642731622093522"></a><a name="p1642731622093522"></a><a href="graphic.md#ga3f99b58f731a37cacde72d5e0c934593">UITextLanguageAlignment</a> </p>
<p id="p902284562093522"><a name="p902284562093522"></a><a name="p902284562093522"></a>Obtains the horizontal alignment mode. </p>
</td>
</tr>
<tr id="row966545178093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1216081702093522"><a name="p1216081702093522"></a><a name="p1216081702093522"></a><a href="graphic.md#ga337ba2ef9996c1b55a99408e63f0153e">OHOS::UIArcLabel::GetDirect</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1426083832093522"><a name="p1426083832093522"></a><a name="p1426083832093522"></a><a href="graphic.md#ga0c108f97781843f67c101b47b6c00cf0">UITextLanguageDirect</a> </p>
<p id="p1226452021093522"><a name="p1226452021093522"></a><a name="p1226452021093522"></a>Obtains the direction of this text. </p>
</td>
</tr>
<tr id="row294460455093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p19448677093522"><a name="p19448677093522"></a><a name="p19448677093522"></a><a href="graphic.md#gad77dde925091bf68bb39316208a304ce">OHOS::UIArcLabel::SetFontId</a> (uint8_t fontId)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1416838610093522"><a name="p1416838610093522"></a><a name="p1416838610093522"></a>void </p>
<p id="p864086698093522"><a name="p864086698093522"></a><a name="p864086698093522"></a>Sets the font ID for this arc label. </p>
</td>
</tr>
<tr id="row21941989093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p785396910093522"><a name="p785396910093522"></a><a name="p785396910093522"></a><a href="graphic.md#gadbd5e4fae21ad3fb7dedf16b414c149d">OHOS::UIArcLabel::GetFontId</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p633902259093522"><a name="p633902259093522"></a><a name="p633902259093522"></a>uint8_t </p>
<p id="p102534875093522"><a name="p102534875093522"></a><a name="p102534875093522"></a>Obtains the font ID composed of font name and size. </p>
</td>
</tr>
<tr id="row1137205209093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p295896894093522"><a name="p295896894093522"></a><a name="p295896894093522"></a><a href="graphic.md#gaa45fef56dbe7296f3273586cbc29c7ed">OHOS::UIArcLabel::SetFont</a> (const char *name, uint8_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p148949882093522"><a name="p148949882093522"></a><a name="p148949882093522"></a>void </p>
<p id="p1510797130093522"><a name="p1510797130093522"></a><a name="p1510797130093522"></a>Sets the font for this arc label. </p>
</td>
</tr>
<tr id="row281947461093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1268520360093522"><a name="p1268520360093522"></a><a name="p1268520360093522"></a><a href="graphic.md#ga0679d838c86fbf540574a41ce0cfbdaf">OHOS::UIArcLabel::SetArcTextCenter</a> (int16_t x, int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p352067693093522"><a name="p352067693093522"></a><a name="p352067693093522"></a>void </p>
<p id="p21057072093522"><a name="p21057072093522"></a><a name="p21057072093522"></a>Sets the center position for this arc text. </p>
</td>
</tr>
<tr id="row1256436247093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1724426276093522"><a name="p1724426276093522"></a><a name="p1724426276093522"></a><a href="graphic.md#ga761fd2ed6abed4489c5dff744c03c8e7">OHOS::UIArcLabel::GetArcTextCenter</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p113982430093522"><a name="p113982430093522"></a><a name="p113982430093522"></a><a href="ohos-point.md">Point</a> </p>
<p id="p1245131277093522"><a name="p1245131277093522"></a><a name="p1245131277093522"></a>Obtains the center position of this arc text. </p>
</td>
</tr>
<tr id="row1493641923093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1352767019093522"><a name="p1352767019093522"></a><a name="p1352767019093522"></a><a href="graphic.md#ga304513546d8c396e89719725acf0a086">OHOS::UIArcLabel::SetArcTextRadius</a> (uint16_t radius)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2047815044093522"><a name="p2047815044093522"></a><a name="p2047815044093522"></a>void </p>
<p id="p1563659383093522"><a name="p1563659383093522"></a><a name="p1563659383093522"></a>Sets the radius for this arc text. </p>
</td>
</tr>
<tr id="row195932927093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p889864196093522"><a name="p889864196093522"></a><a name="p889864196093522"></a><a href="graphic.md#ga19ef3f705a2a486b8da7688ccff6f09d">OHOS::UIArcLabel::GetArcTextRadius</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2130400404093522"><a name="p2130400404093522"></a><a name="p2130400404093522"></a>uint16_t </p>
<p id="p1429937876093522"><a name="p1429937876093522"></a><a name="p1429937876093522"></a>Obtains the radius of this arc text. </p>
</td>
</tr>
<tr id="row1388685534093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p91587914093522"><a name="p91587914093522"></a><a name="p91587914093522"></a><a href="graphic.md#gaea37f7ce223d76e5b74dc098fc74cbf9">OHOS::UIArcLabel::SetArcTextAngle</a> (int16_t startAngle, int16_t endAngle)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1161583852093522"><a name="p1161583852093522"></a><a name="p1161583852093522"></a>void </p>
<p id="p1020118354093522"><a name="p1020118354093522"></a><a name="p1020118354093522"></a>Sets the start angle and end angle for this arc text. </p>
</td>
</tr>
<tr id="row1361405554093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p59133829093522"><a name="p59133829093522"></a><a name="p59133829093522"></a><a href="graphic.md#ga6f60f48c3fe4571d09bfa74cb46837fa">OHOS::UIArcLabel::GetArcTextStartAngle</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1887251731093522"><a name="p1887251731093522"></a><a name="p1887251731093522"></a>int16_t </p>
<p id="p947507726093522"><a name="p947507726093522"></a><a name="p947507726093522"></a>Obtains the start angle of this arc text. </p>
</td>
</tr>
<tr id="row1442654244093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p786732698093522"><a name="p786732698093522"></a><a name="p786732698093522"></a><a href="graphic.md#ga3ed7572ec5135e169ae1b6230dcfe7d2">OHOS::UIArcLabel::GetArcTextEndAngle</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1548561631093522"><a name="p1548561631093522"></a><a name="p1548561631093522"></a>int16_t </p>
<p id="p949365363093522"><a name="p949365363093522"></a><a name="p949365363093522"></a>Obtains the end angle of this arc text. </p>
</td>
</tr>
<tr id="row146872751093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p189324944093522"><a name="p189324944093522"></a><a name="p189324944093522"></a><a href="graphic.md#gad24333f7363f2d73988f479e73b62b92">OHOS::UIArcLabel::SetArcTextOrientation</a> (<a href="graphic.md#ga0778527bee4a7ddd8d46395585a5cfb9">TextOrientation</a> orientation)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p38315105093522"><a name="p38315105093522"></a><a name="p38315105093522"></a>void </p>
<p id="p512257035093522"><a name="p512257035093522"></a><a name="p512257035093522"></a>Sets the orientation for this arc text. </p>
</td>
</tr>
<tr id="row2117918324093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1041891672093522"><a name="p1041891672093522"></a><a name="p1041891672093522"></a><a href="graphic.md#ga34fe8930d4ff654327e45c0abaafc037">OHOS::UIArcLabel::GetArcTextOrientation</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1451974017093522"><a name="p1451974017093522"></a><a name="p1451974017093522"></a><a href="graphic.md#ga0778527bee4a7ddd8d46395585a5cfb9">TextOrientation</a> </p>
<p id="p1563081839093522"><a name="p1563081839093522"></a><a name="p1563081839093522"></a>Obtains the orientation of this arc text. </p>
</td>
</tr>
<tr id="row2007017286093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p576313541093522"><a name="p576313541093522"></a><a name="p576313541093522"></a><a href="graphic.md#ga9f3b69ad5511a4bd8f3aede212f3f374">OHOS::UIArcLabel::OnDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1526097520093522"><a name="p1526097520093522"></a><a name="p1526097520093522"></a>virtual void </p>
<p id="p1641605642093522"><a name="p1641605642093522"></a><a name="p1641605642093522"></a>Draws an arc text. </p>
</td>
</tr>
<tr id="row482518951093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2105547817093522"><a name="p2105547817093522"></a><a name="p2105547817093522"></a><a href="graphic.md#gad79f1c694abce57af451b8f7b0b17c35">OHOS::UIAxis::UIAxis</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p83679066093522"><a name="p83679066093522"></a><a name="p83679066093522"></a> </p>
<p id="p1953985814093522"><a name="p1953985814093522"></a><a name="p1953985814093522"></a>A constructor used to create a <strong id="b1721488067093522"><a name="b1721488067093522"></a><a name="b1721488067093522"></a><a href="ohos-uiaxis.md">UIAxis</a></strong> instance. </p>
</td>
</tr>
<tr id="row804107824093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1615123946093522"><a name="p1615123946093522"></a><a name="p1615123946093522"></a><a href="graphic.md#gaacc9ac178b3b235f1186297021eb98d8">OHOS::UIAxis::~UIAxis</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1056376310093522"><a name="p1056376310093522"></a><a name="p1056376310093522"></a>virtual </p>
<p id="p980387866093522"><a name="p980387866093522"></a><a name="p980387866093522"></a>A destructor used to delete the <strong id="b668568403093522"><a name="b668568403093522"></a><a name="b668568403093522"></a><a href="ohos-uiaxis.md">UIAxis</a></strong> instance. </p>
</td>
</tr>
<tr id="row1697534650093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1747326816093522"><a name="p1747326816093522"></a><a name="p1747326816093522"></a><a href="graphic.md#ga2f46b702f1543c5076a8957a94a780d3">OHOS::UIAxis::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1592269126093522"><a name="p1592269126093522"></a><a name="p1592269126093522"></a>UIViewType </p>
<p id="p216436338093522"><a name="p216436338093522"></a><a name="p216436338093522"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row512110153093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1085407618093522"><a name="p1085407618093522"></a><a name="p1085407618093522"></a><a href="graphic.md#gabb486419e729add9ff85a24371253bf8">OHOS::UIAxis::SetDataRange</a> (uint16_t min, uint16_t max)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2049570605093522"><a name="p2049570605093522"></a><a name="p2049570605093522"></a>virtual bool </p>
<p id="p1550711652093522"><a name="p1550711652093522"></a><a name="p1550711652093522"></a>Sets the value range of a coordinate axis. </p>
</td>
</tr>
<tr id="row158401768093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1801252376093522"><a name="p1801252376093522"></a><a name="p1801252376093522"></a><a href="graphic.md#gaebe68b636d2147f2e69bd658696dc4ee">OHOS::UIAxis::SetMarkNum</a> (uint16_t count)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p267880149093522"><a name="p267880149093522"></a><a name="p267880149093522"></a>virtual void </p>
<p id="p1551675297093522"><a name="p1551675297093522"></a><a name="p1551675297093522"></a>Sets the number of scales on a coordinate axis. </p>
</td>
</tr>
<tr id="row1756115173093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p172614415093522"><a name="p172614415093522"></a><a name="p172614415093522"></a><a href="graphic.md#ga8ceec5e67fa2c4f161bd9af1f0788bbe">OHOS::UIAxis::SetLineColor</a> (const <a href="ohos-color32.md">ColorType</a> &amp;color)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p330298436093522"><a name="p330298436093522"></a><a name="p330298436093522"></a>void </p>
<p id="p1824090474093522"><a name="p1824090474093522"></a><a name="p1824090474093522"></a>Sets the line color of the coordinate axis. </p>
</td>
</tr>
<tr id="row1256802368093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1379744010093522"><a name="p1379744010093522"></a><a name="p1379744010093522"></a><a href="graphic.md#ga5360803f425055de52af5f7fa1081cfe">OHOS::UIAxis::OnDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1342608584093522"><a name="p1342608584093522"></a><a name="p1342608584093522"></a>void </p>
<p id="p1580012728093522"><a name="p1580012728093522"></a><a name="p1580012728093522"></a>Called when a view is drawn. </p>
</td>
</tr>
<tr id="row810908816093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1455922753093522"><a name="p1455922753093522"></a><a name="p1455922753093522"></a><a href="graphic.md#gad1bf4d83270c0a4ba04f3cffbc67bb97">OHOS::UIAxis::OnPreDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1805201158093522"><a name="p1805201158093522"></a><a name="p1805201158093522"></a>bool </p>
<p id="p257719307093522"><a name="p257719307093522"></a><a name="p257719307093522"></a>Called before a view is drawn. This function is used to check whether the parent view of this view needs to be redrawn so as to optimize the drawing process. </p>
</td>
</tr>
<tr id="row2062874176093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p847952160093522"><a name="p847952160093522"></a><a name="p847952160093522"></a><a href="graphic.md#ga8ff3fd2953897245e4f6e3cb6bd71495">OHOS::UIAxis::TranslateToPixel</a> (int16_t &amp;value)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p490141272093522"><a name="p490141272093522"></a><a name="p490141272093522"></a>virtual void </p>
<p id="p1925090925093522"><a name="p1925090925093522"></a><a name="p1925090925093522"></a>Translates data into pixel coordinates. </p>
</td>
</tr>
<tr id="row106248666093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p511857534093522"><a name="p511857534093522"></a><a name="p511857534093522"></a><a href="graphic.md#ga8cc8e2c8249360ccfc89462fff33ca4a">OHOS::UIXAxis::UIXAxis</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p816370553093522"><a name="p816370553093522"></a><a name="p816370553093522"></a> </p>
<p id="p1262275980093522"><a name="p1262275980093522"></a><a name="p1262275980093522"></a>A constructor used to create a <strong id="b1164845991093522"><a name="b1164845991093522"></a><a name="b1164845991093522"></a><a href="ohos-uixaxis.md">UIXAxis</a></strong> instance. </p>
</td>
</tr>
<tr id="row2031491000093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p994835496093522"><a name="p994835496093522"></a><a name="p994835496093522"></a><a href="graphic.md#gaa4e8939fb25fc20dd93ed030044b019f">OHOS::UIXAxis::~UIXAxis</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1233236733093522"><a name="p1233236733093522"></a><a name="p1233236733093522"></a>virtual </p>
<p id="p2020399809093522"><a name="p2020399809093522"></a><a name="p2020399809093522"></a>A destructor used to delete the <strong id="b1989413138093522"><a name="b1989413138093522"></a><a name="b1989413138093522"></a><a href="ohos-uixaxis.md">UIXAxis</a></strong> instance. </p>
</td>
</tr>
<tr id="row441266033093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p658951002093522"><a name="p658951002093522"></a><a name="p658951002093522"></a><a href="graphic.md#ga9407ddab6d7e65fc075ca37b86163e6f">OHOS::UIXAxis::TranslateToPixel</a> (int16_t &amp;value) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2072767934093522"><a name="p2072767934093522"></a><a name="p2072767934093522"></a>void </p>
<p id="p2027803431093522"><a name="p2027803431093522"></a><a name="p2027803431093522"></a>Translates data into the x coordinate of a pixel. </p>
</td>
</tr>
<tr id="row2095241205093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1802316179093522"><a name="p1802316179093522"></a><a name="p1802316179093522"></a><a href="graphic.md#ga2181796eef584a71a5db9186399720aa">OHOS::UIXAxis::SetDataRange</a> (uint16_t min, uint16_t max) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p435103834093522"><a name="p435103834093522"></a><a name="p435103834093522"></a>bool </p>
<p id="p352808182093522"><a name="p352808182093522"></a><a name="p352808182093522"></a>Sets the value range of the X axis. </p>
</td>
</tr>
<tr id="row1990299036093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p514661473093522"><a name="p514661473093522"></a><a name="p514661473093522"></a><a href="graphic.md#ga46f4151f1379809749ab2ba364d55170">OHOS::UIXAxis::SetMarkNum</a> (uint16_t count) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p304007698093522"><a name="p304007698093522"></a><a name="p304007698093522"></a>void </p>
<p id="p1573325382093522"><a name="p1573325382093522"></a><a name="p1573325382093522"></a>Sets the number of scales on the x-axis. </p>
</td>
</tr>
<tr id="row1489034499093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1460234001093522"><a name="p1460234001093522"></a><a name="p1460234001093522"></a><a href="graphic.md#ga0f9a52b48bcd8170b4a64a891a88fb5c">OHOS::UIYAxis::UIYAxis</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1108393152093522"><a name="p1108393152093522"></a><a name="p1108393152093522"></a> </p>
<p id="p409907198093522"><a name="p409907198093522"></a><a name="p409907198093522"></a>A constructor used to create a <strong id="b1595550397093522"><a name="b1595550397093522"></a><a name="b1595550397093522"></a><a href="ohos-uiyaxis.md">UIYAxis</a></strong> instance. </p>
</td>
</tr>
<tr id="row1982786918093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2038305070093522"><a name="p2038305070093522"></a><a name="p2038305070093522"></a><a href="graphic.md#ga0dc204e8a15fa66762af58142552557c">OHOS::UIYAxis::~UIYAxis</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1867927805093522"><a name="p1867927805093522"></a><a name="p1867927805093522"></a>virtual </p>
<p id="p1287668741093522"><a name="p1287668741093522"></a><a name="p1287668741093522"></a>A destructor used to delete the <strong id="b1183521107093522"><a name="b1183521107093522"></a><a name="b1183521107093522"></a><a href="ohos-uiyaxis.md">UIYAxis</a></strong> instance. </p>
</td>
</tr>
<tr id="row918978895093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p209145343093522"><a name="p209145343093522"></a><a name="p209145343093522"></a><a href="graphic.md#gae70c8c411116746a2ab73a6f9bbd1233">OHOS::UIYAxis::TranslateToPixel</a> (int16_t &amp;value) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2012985502093522"><a name="p2012985502093522"></a><a name="p2012985502093522"></a>void </p>
<p id="p725592893093522"><a name="p725592893093522"></a><a name="p725592893093522"></a>Translates data into the y coordinate of a pixel. </p>
</td>
</tr>
<tr id="row685833268093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2135205722093522"><a name="p2135205722093522"></a><a name="p2135205722093522"></a><a href="graphic.md#gae635d27e0a4eba30002e3607c42b914a">OHOS::UIYAxis::SetDataRange</a> (uint16_t min, uint16_t max) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1876324586093522"><a name="p1876324586093522"></a><a name="p1876324586093522"></a>bool </p>
<p id="p1857192476093522"><a name="p1857192476093522"></a><a name="p1857192476093522"></a>Sets the value range of the y-axis. </p>
</td>
</tr>
<tr id="row1386827502093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1533222191093522"><a name="p1533222191093522"></a><a name="p1533222191093522"></a><a href="graphic.md#gaf67c1b25c1d1a3ba694cb47f7e9fda85">OHOS::UIYAxis::SetMarkNum</a> (uint16_t count) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1532207719093522"><a name="p1532207719093522"></a><a name="p1532207719093522"></a>void </p>
<p id="p1551841741093522"><a name="p1551841741093522"></a><a name="p1551841741093522"></a>Sets the number of scales on the Y axis. </p>
</td>
</tr>
<tr id="row892215820093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1310568301093522"><a name="p1310568301093522"></a><a name="p1310568301093522"></a><a href="graphic.md#ga315a532a3e0aa658a64d2f7739483f35">OHOS::UIBoxProgress::UIBoxProgress</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1840359645093522"><a name="p1840359645093522"></a><a name="p1840359645093522"></a> </p>
<p id="p705354760093522"><a name="p705354760093522"></a><a name="p705354760093522"></a>A constructor used to create a <strong id="b1166919793093522"><a name="b1166919793093522"></a><a name="b1166919793093522"></a><a href="ohos-uiboxprogress.md">UIBoxProgress</a></strong> instance. </p>
</td>
</tr>
<tr id="row1447883536093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p433516811093522"><a name="p433516811093522"></a><a name="p433516811093522"></a><a href="graphic.md#ga7a5eefc7d4ad253a286444e76146af7f">OHOS::UIBoxProgress::~UIBoxProgress</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1223250123093522"><a name="p1223250123093522"></a><a name="p1223250123093522"></a>virtual </p>
<p id="p1406281068093522"><a name="p1406281068093522"></a><a name="p1406281068093522"></a>A destructor used to delete the <strong id="b1012744955093522"><a name="b1012744955093522"></a><a name="b1012744955093522"></a><a href="ohos-uiboxprogress.md">UIBoxProgress</a></strong> instance. </p>
</td>
</tr>
<tr id="row247842831093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p287678962093522"><a name="p287678962093522"></a><a name="p287678962093522"></a><a href="graphic.md#gaa2d380d48776748583f51297715af0b5">OHOS::UIBoxProgress::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p836160354093522"><a name="p836160354093522"></a><a name="p836160354093522"></a>UIViewType </p>
<p id="p1376923468093522"><a name="p1376923468093522"></a><a name="p1376923468093522"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row145926742093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p514169584093522"><a name="p514169584093522"></a><a name="p514169584093522"></a><a href="graphic.md#ga4b3eeb9de2443182480a71cadb23178c">OHOS::UIBoxProgress::SetWidth</a> (int16_t width) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1815353545093522"><a name="p1815353545093522"></a><a name="p1815353545093522"></a>void </p>
<p id="p1680899667093522"><a name="p1680899667093522"></a><a name="p1680899667093522"></a>Sets the width for the view holding this progress bar. </p>
</td>
</tr>
<tr id="row1593089488093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1740422148093522"><a name="p1740422148093522"></a><a name="p1740422148093522"></a><a href="graphic.md#ga54299cb7561cee9a03d0fc9d0ddda784">OHOS::UIBoxProgress::SetHeight</a> (int16_t height) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1562202023093522"><a name="p1562202023093522"></a><a name="p1562202023093522"></a>void </p>
<p id="p330864016093522"><a name="p330864016093522"></a><a name="p330864016093522"></a>Sets the height for this view. </p>
</td>
</tr>
<tr id="row689440951093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p198314642093522"><a name="p198314642093522"></a><a name="p198314642093522"></a><a href="graphic.md#ga3e2e7d0c37b4945a3f4f456c20cb0177">OHOS::UIBoxProgress::SetDirection</a> (const <a href="graphic.md#ga4a7a2c192206c8b18379f42a5fd176eb">Direction</a> &amp;direction)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p520346174093522"><a name="p520346174093522"></a><a name="p520346174093522"></a>void </p>
<p id="p115795071093522"><a name="p115795071093522"></a><a name="p115795071093522"></a>Sets the direction for this progress bar. </p>
</td>
</tr>
<tr id="row2028932660093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1123817106093522"><a name="p1123817106093522"></a><a name="p1123817106093522"></a><a href="graphic.md#ga493699e8d0e934d7fb3d5502529a1c5e">OHOS::UIBoxProgress::GetDirection</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p577781234093522"><a name="p577781234093522"></a><a name="p577781234093522"></a><a href="graphic.md#ga4a7a2c192206c8b18379f42a5fd176eb">Direction</a> </p>
<p id="p1843378849093522"><a name="p1843378849093522"></a><a name="p1843378849093522"></a>Obtains the direction of this progress bar. </p>
</td>
</tr>
<tr id="row245527004093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1283471419093522"><a name="p1283471419093522"></a><a name="p1283471419093522"></a><a href="graphic.md#gada3cf1819e826ee0aed4a40ef00b91a6">OHOS::UIBoxProgress::SetValidWidth</a> (int16_t width)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p663297779093522"><a name="p663297779093522"></a><a name="p663297779093522"></a>void </p>
<p id="p1398499972093522"><a name="p1398499972093522"></a><a name="p1398499972093522"></a>Sets the actual width for this progress bar. </p>
</td>
</tr>
<tr id="row1488490888093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1137735135093522"><a name="p1137735135093522"></a><a name="p1137735135093522"></a><a href="graphic.md#ga6577d38d85234e08f709dd0ae131b255">OHOS::UIBoxProgress::GetValidWidth</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1178043664093522"><a name="p1178043664093522"></a><a name="p1178043664093522"></a>int16_t </p>
<p id="p1201097859093522"><a name="p1201097859093522"></a><a name="p1201097859093522"></a>Obtains the actual width of this progress bar. </p>
</td>
</tr>
<tr id="row121939096093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p685687602093522"><a name="p685687602093522"></a><a name="p685687602093522"></a><a href="graphic.md#ga6958b8273ad7a5563dfa19267cc3a13c">OHOS::UIBoxProgress::SetValidHeight</a> (int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p519854736093522"><a name="p519854736093522"></a><a name="p519854736093522"></a>void </p>
<p id="p1831295737093522"><a name="p1831295737093522"></a><a name="p1831295737093522"></a>Sets the actual height for this progress bar. </p>
</td>
</tr>
<tr id="row787922698093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p174827345093522"><a name="p174827345093522"></a><a name="p174827345093522"></a><a href="graphic.md#ga1e6c92b20c4931a058c0b7775bf180c9">OHOS::UIBoxProgress::GetValidHeight</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2106584831093522"><a name="p2106584831093522"></a><a name="p2106584831093522"></a>int16_t </p>
<p id="p1569696891093522"><a name="p1569696891093522"></a><a name="p1569696891093522"></a>Obtains the actual height of this progress bar. </p>
</td>
</tr>
<tr id="row1866746255093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1854595829093522"><a name="p1854595829093522"></a><a name="p1854595829093522"></a><a href="graphic.md#ga3321d9b9b156423bdc0abcb8e99efb0d">OHOS::UIBoxProgress::OnDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p790195514093522"><a name="p790195514093522"></a><a name="p790195514093522"></a>void </p>
<p id="p1873845653093522"><a name="p1873845653093522"></a><a name="p1873845653093522"></a>Called when a view is drawn. </p>
</td>
</tr>
<tr id="row841706408093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2085585375093522"><a name="p2085585375093522"></a><a name="p2085585375093522"></a><a href="graphic.md#ga3aee093d4c583223850a7ad80d5bed79">OHOS::UIButton::UIButton</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1556238542093522"><a name="p1556238542093522"></a><a name="p1556238542093522"></a> </p>
<p id="p1853953132093522"><a name="p1853953132093522"></a><a name="p1853953132093522"></a>A constructor used to create a <strong id="b977273631093522"><a name="b977273631093522"></a><a name="b977273631093522"></a><a href="ohos-uibutton.md">UIButton</a></strong> instance. </p>
</td>
</tr>
<tr id="row1916510240093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p906160229093522"><a name="p906160229093522"></a><a name="p906160229093522"></a><a href="graphic.md#ga33e30931e9b3557634b2b2be93bc41f6">OHOS::UIButton::UIButton</a> (const char *id)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1626915162093522"><a name="p1626915162093522"></a><a name="p1626915162093522"></a> </p>
<p id="p1042795181093522"><a name="p1042795181093522"></a><a name="p1042795181093522"></a>A constructor used to create a <strong id="b977305803093522"><a name="b977305803093522"></a><a name="b977305803093522"></a><a href="ohos-uibutton.md">UIButton</a></strong> instance based on the button ID. </p>
</td>
</tr>
<tr id="row969025787093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p790538557093522"><a name="p790538557093522"></a><a name="p790538557093522"></a><a href="graphic.md#ga0c5fbcf319fc6df8170d407a337b9d8b">OHOS::UIButton::~UIButton</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1241161407093522"><a name="p1241161407093522"></a><a name="p1241161407093522"></a>virtual </p>
<p id="p1100704047093522"><a name="p1100704047093522"></a><a name="p1100704047093522"></a>A destructor used to delete the <strong id="b1867173488093522"><a name="b1867173488093522"></a><a name="b1867173488093522"></a><a href="ohos-uibutton.md">UIButton</a></strong> instance. </p>
</td>
</tr>
<tr id="row1473870837093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p194476982093522"><a name="p194476982093522"></a><a name="p194476982093522"></a><a href="graphic.md#gad19f55fb0de64f3f39485292d0629dc7">OHOS::UIButton::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2063879602093522"><a name="p2063879602093522"></a><a name="p2063879602093522"></a>UIViewType </p>
<p id="p2031787379093522"><a name="p2031787379093522"></a><a name="p2031787379093522"></a>Obtains the component type. </p>
</td>
</tr>
<tr id="row546064585093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1729142764093522"><a name="p1729142764093522"></a><a name="p1729142764093522"></a><a href="graphic.md#gaf64d9ec1744ab9c7385dd64d30a786e4">OHOS::UIButton::OnPreDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1967211831093522"><a name="p1967211831093522"></a><a name="p1967211831093522"></a>bool </p>
<p id="p1672877936093522"><a name="p1672877936093522"></a><a name="p1672877936093522"></a>Do something before draw, this function will be invoked mainly to check if this view need to cover invalidate area so render manager can decide which layer to draw firstly. </p>
</td>
</tr>
<tr id="row2035823075093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1975304834093522"><a name="p1975304834093522"></a><a name="p1975304834093522"></a><a href="graphic.md#gae69843b87be9fcdab3e4ac776547f3bc">OHOS::UIButton::OnDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1521814680093522"><a name="p1521814680093522"></a><a name="p1521814680093522"></a>void </p>
<p id="p1157162250093522"><a name="p1157162250093522"></a><a name="p1157162250093522"></a>Executes the draw action. </p>
</td>
</tr>
<tr id="row280732658093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1030471499093522"><a name="p1030471499093522"></a><a name="p1030471499093522"></a><a href="graphic.md#ga1d887720c89170abd3c8a400a791765d">OHOS::UIButton::OnPressEvent</a> (const <a href="ohos-pressevent.md">PressEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p628042522093522"><a name="p628042522093522"></a><a name="p628042522093522"></a>void </p>
<p id="p399507046093522"><a name="p399507046093522"></a><a name="p399507046093522"></a>Executes the press event action. </p>
</td>
</tr>
<tr id="row1114403422093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p955658760093522"><a name="p955658760093522"></a><a name="p955658760093522"></a><a href="graphic.md#gadb9492eb82ff23f91f9263fc748f24de">OHOS::UIButton::OnReleaseEvent</a> (const <a href="ohos-releaseevent.md">ReleaseEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1315623934093522"><a name="p1315623934093522"></a><a name="p1315623934093522"></a>void </p>
<p id="p936350458093522"><a name="p936350458093522"></a><a name="p936350458093522"></a>Executes the press release event action. </p>
</td>
</tr>
<tr id="row462169674093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1692996880093522"><a name="p1692996880093522"></a><a name="p1692996880093522"></a><a href="graphic.md#ga4f481e0ce91f87c6b70f6e0190e4f34f">OHOS::UIButton::OnCancelEvent</a> (const <a href="ohos-cancelevent.md">CancelEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p654865182093522"><a name="p654865182093522"></a><a name="p654865182093522"></a>void </p>
<p id="p1668946697093522"><a name="p1668946697093522"></a><a name="p1668946697093522"></a>Executes the cancel event action. </p>
</td>
</tr>
<tr id="row1596405348093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p946703723093522"><a name="p946703723093522"></a><a name="p946703723093522"></a><a href="graphic.md#ga60194db1c1bba6a0ef963bdbbe9f972f">OHOS::UIButton::SetImageSrc</a> (const char *defaultImgSrc, const char *triggeredImgSrc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p498701892093522"><a name="p498701892093522"></a><a name="p498701892093522"></a>void </p>
<p id="p24722192093522"><a name="p24722192093522"></a><a name="p24722192093522"></a>Sets the image for this button. </p>
</td>
</tr>
<tr id="row563877256093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p565353248093522"><a name="p565353248093522"></a><a name="p565353248093522"></a><a href="graphic.md#gab751bc5941edb403022d65d2c605a241">OHOS::UIButton::SetImageSrc</a> (const <a href="ohos-imageinfo.md">ImageInfo</a> *defaultImgSrc, const <a href="ohos-imageinfo.md">ImageInfo</a> *triggeredImgSrc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p144945781093522"><a name="p144945781093522"></a><a name="p144945781093522"></a>void </p>
<p id="p879829774093522"><a name="p879829774093522"></a><a name="p879829774093522"></a>Sets the image for this button. </p>
</td>
</tr>
<tr id="row1802889545093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p608773856093522"><a name="p608773856093522"></a><a name="p608773856093522"></a><a href="graphic.md#ga952fcbc88905cf35ec3e09bdf01375f2">OHOS::UIButton::SetImagePosition</a> (const int16_t x, const int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1843158659093522"><a name="p1843158659093522"></a><a name="p1843158659093522"></a>void </p>
<p id="p416731709093522"><a name="p416731709093522"></a><a name="p416731709093522"></a>Sets the position for this image. </p>
</td>
</tr>
<tr id="row1683668509093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1699255868093522"><a name="p1699255868093522"></a><a name="p1699255868093522"></a><a href="graphic.md#ga4d8abf189ddcbf325c60402084d7e3c3">OHOS::UIButton::GetImageX</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p994399115093522"><a name="p994399115093522"></a><a name="p994399115093522"></a>int16_t </p>
<p id="p1120954374093522"><a name="p1120954374093522"></a><a name="p1120954374093522"></a>Obtains the x-coordinate of this image. </p>
</td>
</tr>
<tr id="row780420386093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1194166753093522"><a name="p1194166753093522"></a><a name="p1194166753093522"></a><a href="graphic.md#ga25a02afb52cc15212084fb6bc8f27afd">OHOS::UIButton::GetImageY</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p127895028093522"><a name="p127895028093522"></a><a name="p127895028093522"></a>int16_t </p>
<p id="p2060721158093522"><a name="p2060721158093522"></a><a name="p2060721158093522"></a>Obtains the y-coordinate of this image. </p>
</td>
</tr>
<tr id="row1127743155093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p882056991093522"><a name="p882056991093522"></a><a name="p882056991093522"></a><a href="graphic.md#gaf6496e4858473ab2acb80a2be6264a01">OHOS::UIButton::GetCurImageSrc</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1846617760093522"><a name="p1846617760093522"></a><a name="p1846617760093522"></a>const <a href="ohos-image.md">Image</a> * </p>
<p id="p342836477093522"><a name="p342836477093522"></a><a name="p342836477093522"></a>Obtains the image for the current button state. </p>
</td>
</tr>
<tr id="row633286864093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1520269943093522"><a name="p1520269943093522"></a><a name="p1520269943093522"></a><a href="graphic.md#ga8cb74b23f740091e59ad350a8dea436b">OHOS::UIButton::GetWidth</a> () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1752823405093522"><a name="p1752823405093522"></a><a name="p1752823405093522"></a>int16_t </p>
<p id="p932467312093522"><a name="p932467312093522"></a><a name="p932467312093522"></a>Obtains the width of this image. </p>
</td>
</tr>
<tr id="row306305367093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1747953672093522"><a name="p1747953672093522"></a><a name="p1747953672093522"></a><a href="graphic.md#ga1f8015706cfc73728696bf2bbd3e833b">OHOS::UIButton::GetHeight</a> () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1302932934093522"><a name="p1302932934093522"></a><a name="p1302932934093522"></a>int16_t </p>
<p id="p113508708093522"><a name="p113508708093522"></a><a name="p113508708093522"></a>Obtains the height of this image. </p>
</td>
</tr>
<tr id="row1081388932093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1716096853093522"><a name="p1716096853093522"></a><a name="p1716096853093522"></a><a href="graphic.md#ga420f927c473cec8c6f3265ff7c35336f">OHOS::UIButton::SetWidth</a> (int16_t width) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2009509685093522"><a name="p2009509685093522"></a><a name="p2009509685093522"></a>void </p>
<p id="p1837181384093522"><a name="p1837181384093522"></a><a name="p1837181384093522"></a>Sets the width for this image. </p>
</td>
</tr>
<tr id="row1022309810093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1830174939093522"><a name="p1830174939093522"></a><a name="p1830174939093522"></a><a href="graphic.md#ga8b6dbfcd0328753c2c3cef4d14b0ff30">OHOS::UIButton::SetHeight</a> (int16_t height) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p506576344093522"><a name="p506576344093522"></a><a name="p506576344093522"></a>void </p>
<p id="p1958393817093522"><a name="p1958393817093522"></a><a name="p1958393817093522"></a>Sets the height for this image. </p>
</td>
</tr>
<tr id="row827402976093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p753153396093522"><a name="p753153396093522"></a><a name="p753153396093522"></a><a href="graphic.md#ga93994f4d735e4f9a7d3e7d737e2c620c">OHOS::UIButton::GetContentRect</a> () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p227675136093522"><a name="p227675136093522"></a><a name="p227675136093522"></a>virtual <a href="ohos-rect.md">Rect</a> </p>
<p id="p795976590093522"><a name="p795976590093522"></a><a name="p795976590093522"></a>Obtains a rectangular area that contains coordinate information. </p>
</td>
</tr>
<tr id="row1483441128093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p768709167093522"><a name="p768709167093522"></a><a name="p768709167093522"></a><a href="graphic.md#ga37736a82bec6a01bc5a880e1d01ccccd">OHOS::UIButton::GetStyle</a> (uint8_t key) const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1192149544093522"><a name="p1192149544093522"></a><a name="p1192149544093522"></a>int64_t </p>
<p id="p1609280430093522"><a name="p1609280430093522"></a><a name="p1609280430093522"></a>Obtains the value of a style. </p>
</td>
</tr>
<tr id="row252269449093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1855795318093522"><a name="p1855795318093522"></a><a name="p1855795318093522"></a><a href="graphic.md#gaa5fdd9b28b8c919dbde0e34d8ae38caf">OHOS::UIButton::SetStyle</a> (uint8_t key, int64_t value) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1294240103093522"><a name="p1294240103093522"></a><a name="p1294240103093522"></a>void </p>
<p id="p890478206093522"><a name="p890478206093522"></a><a name="p890478206093522"></a>Sets a style. </p>
</td>
</tr>
<tr id="row1771234358093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1841365423093522"><a name="p1841365423093522"></a><a name="p1841365423093522"></a><a href="graphic.md#gaa3f74af93c91a24e58fdd06ad7d0bdf9">OHOS::UIButton::GetStyleForState</a> (uint8_t key, <a href="graphic.md#ga188dd55c17ee44be27fa80543f13f729">ButtonState</a> state) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1858105772093522"><a name="p1858105772093522"></a><a name="p1858105772093522"></a>int64_t </p>
<p id="p64983968093522"><a name="p64983968093522"></a><a name="p64983968093522"></a>Obtains the style of a button in a specific state. </p>
</td>
</tr>
<tr id="row2107771099093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1950711243093522"><a name="p1950711243093522"></a><a name="p1950711243093522"></a><a href="graphic.md#ga7ece04980fa99a277bfbb591771f47f1">OHOS::UIButton::SetStyleForState</a> (uint8_t key, int64_t value, <a href="graphic.md#ga188dd55c17ee44be27fa80543f13f729">ButtonState</a> state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1434931389093522"><a name="p1434931389093522"></a><a name="p1434931389093522"></a>void </p>
<p id="p1401551831093522"><a name="p1401551831093522"></a><a name="p1401551831093522"></a>Sets the style for a button in a specific state. </p>
</td>
</tr>
<tr id="row1700463269093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1746672717093522"><a name="p1746672717093522"></a><a name="p1746672717093522"></a><a href="graphic.md#ga283131701e907e586964189818d04411">OHOS::UIButton::Disable</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p773934130093522"><a name="p773934130093522"></a><a name="p773934130093522"></a>void </p>
<p id="p759129042093522"><a name="p759129042093522"></a><a name="p759129042093522"></a>Disables this button. </p>
</td>
</tr>
<tr id="row269082869093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1265312363093522"><a name="p1265312363093522"></a><a name="p1265312363093522"></a><a href="graphic.md#ga3185df8b60a609564f978ed9576fb813">OHOS::UIButton::Enable</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1509620417093522"><a name="p1509620417093522"></a><a name="p1509620417093522"></a>void </p>
<p id="p1857943267093522"><a name="p1857943267093522"></a><a name="p1857943267093522"></a>Enables this button. </p>
</td>
</tr>
<tr id="row977391112093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p437262168093522"><a name="p437262168093522"></a><a name="p437262168093522"></a><a href="graphic.md#ga737d850b2adf8a2977369e611764b1ae">OHOS::UIButton::SetStateForStyle</a> (<a href="graphic.md#ga188dd55c17ee44be27fa80543f13f729">ButtonState</a> state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1557460505093522"><a name="p1557460505093522"></a><a name="p1557460505093522"></a>void </p>
<p id="p1782582789093522"><a name="p1782582789093522"></a><a name="p1782582789093522"></a>Sets the state for a button. After the setting, calling <a href="graphic.md#gaa5fdd9b28b8c919dbde0e34d8ae38caf">SetStyle</a> will change the style of this button, but not its state. </p>
</td>
</tr>
<tr id="row286360225093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1285150099093522"><a name="p1285150099093522"></a><a name="p1285150099093522"></a><a href="graphic.md#ga68ecc0cb6bc379284fd1fbaebb8dcfcd">OHOS::Paint::Paint</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1343203834093522"><a name="p1343203834093522"></a><a name="p1343203834093522"></a> </p>
<p id="p1794362580093522"><a name="p1794362580093522"></a><a name="p1794362580093522"></a>A constructor used to create a <strong id="b603452785093522"><a name="b603452785093522"></a><a name="b603452785093522"></a><a href="ohos-paint.md">Paint</a></strong> instance. </p>
</td>
</tr>
<tr id="row393270927093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1811940939093522"><a name="p1811940939093522"></a><a name="p1811940939093522"></a><a href="graphic.md#ga53f5ef8053f9e468a2fcf6c81449d16d">OHOS::Paint::~Paint</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1246250716093522"><a name="p1246250716093522"></a><a name="p1246250716093522"></a>virtual </p>
<p id="p1439996094093522"><a name="p1439996094093522"></a><a name="p1439996094093522"></a>A destructor used to delete the <strong id="b1576732594093522"><a name="b1576732594093522"></a><a name="b1576732594093522"></a><a href="ohos-paint.md">Paint</a></strong> instance. </p>
</td>
</tr>
<tr id="row1554296560093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p778787029093522"><a name="p778787029093522"></a><a name="p778787029093522"></a><a href="graphic.md#gab93dc15f466a656150e62d7620d34333">OHOS::Paint::SetStyle</a> (<a href="graphic.md#ga548320a469b7862fa416af062cad5d7a">PaintStyle</a> style)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p276343681093522"><a name="p276343681093522"></a><a name="p276343681093522"></a>void </p>
<p id="p426035915093522"><a name="p426035915093522"></a><a name="p426035915093522"></a>Sets the paint style of a closed graph. </p>
</td>
</tr>
<tr id="row1235197756093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1515699740093522"><a name="p1515699740093522"></a><a name="p1515699740093522"></a><a href="graphic.md#ga18429dcf1a0dfbe0bf3e5718efa65128">OHOS::Paint::GetStyle</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p733432443093522"><a name="p733432443093522"></a><a name="p733432443093522"></a><a href="graphic.md#ga548320a469b7862fa416af062cad5d7a">PaintStyle</a> </p>
<p id="p231302817093522"><a name="p231302817093522"></a><a name="p231302817093522"></a>Obtains the paint style of a closed graph. </p>
</td>
</tr>
<tr id="row199980541093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p831500685093522"><a name="p831500685093522"></a><a name="p831500685093522"></a><a href="graphic.md#gad56b6b014e1d061ba93ba8e6c135b90a">OHOS::Paint::SetStrokeWidth</a> (uint16_t width)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1897359348093522"><a name="p1897359348093522"></a><a name="p1897359348093522"></a>void </p>
<p id="p434724420093522"><a name="p434724420093522"></a><a name="p434724420093522"></a>Sets the width of a line or border. </p>
</td>
</tr>
<tr id="row554778037093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1421660298093522"><a name="p1421660298093522"></a><a name="p1421660298093522"></a><a href="graphic.md#gaf8420a460f4a21c9208674e07893c3f0">OHOS::Paint::GetStrokeWidth</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p383943651093522"><a name="p383943651093522"></a><a name="p383943651093522"></a>uint16_t </p>
<p id="p1418295454093522"><a name="p1418295454093522"></a><a name="p1418295454093522"></a>Obtains the width of a line or border. </p>
</td>
</tr>
<tr id="row1999210258093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2116179181093522"><a name="p2116179181093522"></a><a name="p2116179181093522"></a><a href="graphic.md#gaff7464c7456b1e7caf9464ff61ab2527">OHOS::Paint::SetStrokeColor</a> (<a href="ohos-color32.md">ColorType</a> color)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1146732196093522"><a name="p1146732196093522"></a><a name="p1146732196093522"></a>void </p>
<p id="p1031087294093522"><a name="p1031087294093522"></a><a name="p1031087294093522"></a>Sets the color of a line or border. </p>
</td>
</tr>
<tr id="row630981941093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1730954931093522"><a name="p1730954931093522"></a><a name="p1730954931093522"></a><a href="graphic.md#gaf9dba05cf9c9f91853a523d961e76fb1">OHOS::Paint::GetStrokeColor</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1432329173093522"><a name="p1432329173093522"></a><a name="p1432329173093522"></a><a href="ohos-color32.md">ColorType</a> </p>
<p id="p2019377553093522"><a name="p2019377553093522"></a><a name="p2019377553093522"></a>Obtains the color of a line or border. </p>
</td>
</tr>
<tr id="row315564169093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2119018849093522"><a name="p2119018849093522"></a><a name="p2119018849093522"></a><a href="graphic.md#gab1b0e3a5e21ce2ec8454311ed31956ae">OHOS::Paint::SetFillColor</a> (<a href="ohos-color32.md">ColorType</a> color)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1660895954093522"><a name="p1660895954093522"></a><a name="p1660895954093522"></a>void </p>
<p id="p1739627686093522"><a name="p1739627686093522"></a><a name="p1739627686093522"></a>Sets fill color. </p>
</td>
</tr>
<tr id="row965377278093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p61505538093522"><a name="p61505538093522"></a><a name="p61505538093522"></a><a href="graphic.md#gadc1b88c39670f103e0c84a089e2178cf">OHOS::Paint::GetFillColor</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p535259839093522"><a name="p535259839093522"></a><a name="p535259839093522"></a><a href="ohos-color32.md">ColorType</a> </p>
<p id="p164127139093522"><a name="p164127139093522"></a><a name="p164127139093522"></a>Obtains the fill color. </p>
</td>
</tr>
<tr id="row1545929043093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1233794340093522"><a name="p1233794340093522"></a><a name="p1233794340093522"></a><a href="graphic.md#gacd329fb89bbf6f0e3fd4f9a61f4ce60f">OHOS::Paint::SetOpacity</a> (uint8_t opacity)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p325150251093522"><a name="p325150251093522"></a><a name="p325150251093522"></a>void </p>
<p id="p163897429093522"><a name="p163897429093522"></a><a name="p163897429093522"></a>Sets the opacity. </p>
</td>
</tr>
<tr id="row492870838093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1154217034093522"><a name="p1154217034093522"></a><a name="p1154217034093522"></a><a href="graphic.md#ga3a47fccd734ec0e79af89bedacdd4357">OHOS::Paint::GetOpacity</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2067705195093522"><a name="p2067705195093522"></a><a name="p2067705195093522"></a>uint8_t </p>
<p id="p1565187721093522"><a name="p1565187721093522"></a><a name="p1565187721093522"></a>Obtains the opacity. </p>
</td>
</tr>
<tr id="row171585390093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1951413756093522"><a name="p1951413756093522"></a><a name="p1951413756093522"></a><a href="graphic.md#ga60d2ed5d49ef68ae8d6f2a8b58322ed3">OHOS::UICanvas::UICanvas</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1873520457093522"><a name="p1873520457093522"></a><a name="p1873520457093522"></a> </p>
<p id="p672578068093522"><a name="p672578068093522"></a><a name="p672578068093522"></a>A constructor used to create a <strong id="b415298504093522"><a name="b415298504093522"></a><a name="b415298504093522"></a><a href="ohos-uicanvas.md">UICanvas</a></strong> instance. </p>
</td>
</tr>
<tr id="row1196907042093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p73203464093522"><a name="p73203464093522"></a><a name="p73203464093522"></a><a href="graphic.md#gaf099d1872cdb070f038c5135309b9b6b">OHOS::UICanvas::~UICanvas</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p571115126093522"><a name="p571115126093522"></a><a name="p571115126093522"></a>virtual </p>
<p id="p1570753561093522"><a name="p1570753561093522"></a><a name="p1570753561093522"></a>A destructor used to delete the <strong id="b1848317020093522"><a name="b1848317020093522"></a><a name="b1848317020093522"></a><a href="ohos-uicanvas.md">UICanvas</a></strong> instance. </p>
</td>
</tr>
<tr id="row814293157093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1951714515093522"><a name="p1951714515093522"></a><a name="p1951714515093522"></a><a href="graphic.md#ga467faebb78b4c4a753eaa44b772f0905">OHOS::UICanvas::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1852975863093522"><a name="p1852975863093522"></a><a name="p1852975863093522"></a>UIViewType </p>
<p id="p310673500093522"><a name="p310673500093522"></a><a name="p310673500093522"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row353682169093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p615731260093522"><a name="p615731260093522"></a><a name="p615731260093522"></a><a href="graphic.md#ga7e20822a6c448bee724f20afad1c69d4">OHOS::UICanvas::Clear</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p383399000093522"><a name="p383399000093522"></a><a name="p383399000093522"></a>void </p>
<p id="p1773013129093522"><a name="p1773013129093522"></a><a name="p1773013129093522"></a>Clears the entire canvas. </p>
</td>
</tr>
<tr id="row289221769093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p187028393093522"><a name="p187028393093522"></a><a name="p187028393093522"></a><a href="graphic.md#gaca35fe1a1d344eab80ecb1425a74a91a">OHOS::UICanvas::SetStartPosition</a> (const <a href="ohos-point.md">Point</a> &amp;startPoint)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1100023018093522"><a name="p1100023018093522"></a><a name="p1100023018093522"></a>void </p>
<p id="p229487752093522"><a name="p229487752093522"></a><a name="p229487752093522"></a>Sets the coordinates of the start point for drawing a line. For example, if <strong id="b1142105063093522"><a name="b1142105063093522"></a><a name="b1142105063093522"></a>startPoint</strong> is set to {50, 50}, the line is drawn from this set of coordinates on the canvas. </p>
</td>
</tr>
<tr id="row555383974093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1312309053093522"><a name="p1312309053093522"></a><a name="p1312309053093522"></a><a href="graphic.md#gad23f7db18bfa5f91e3cb814193e6932d">OHOS::UICanvas::GetStartPosition</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1001243191093522"><a name="p1001243191093522"></a><a name="p1001243191093522"></a>const <a href="ohos-point.md">Point</a> &amp; </p>
<p id="p922995237093522"><a name="p922995237093522"></a><a name="p922995237093522"></a>Obtains the coordinates of the start point of a line. </p>
</td>
</tr>
<tr id="row1492604201093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1375119126093522"><a name="p1375119126093522"></a><a name="p1375119126093522"></a><a href="graphic.md#gac97d9d39484e5a1e36273510ae47327e">OHOS::UICanvas::DrawLine</a> (const <a href="ohos-point.md">Point</a> &amp;endPoint, const <a href="ohos-paint.md">Paint</a> &amp;paint)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1134165561093522"><a name="p1134165561093522"></a><a name="p1134165561093522"></a>void </p>
<p id="p1624356878093522"><a name="p1624356878093522"></a><a name="p1624356878093522"></a>Draws a straight line. </p>
</td>
</tr>
<tr id="row1452624048093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p727721501093522"><a name="p727721501093522"></a><a name="p727721501093522"></a><a href="graphic.md#ga0c5e94526dab6a62d6db0a67385104db">OHOS::UICanvas::DrawLine</a> (const <a href="ohos-point.md">Point</a> &amp;startPoint, const <a href="ohos-point.md">Point</a> &amp;endPoint, const <a href="ohos-paint.md">Paint</a> &amp;paint)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p526385542093522"><a name="p526385542093522"></a><a name="p526385542093522"></a>void </p>
<p id="p548670087093522"><a name="p548670087093522"></a><a name="p548670087093522"></a>Draws a straight line from the coordinates of the start point. </p>
</td>
</tr>
<tr id="row1913825915093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p448547507093522"><a name="p448547507093522"></a><a name="p448547507093522"></a><a href="graphic.md#gab6557ddb74b721e4eba6cdabab954a3b">OHOS::UICanvas::DrawCurve</a> (const <a href="ohos-point.md">Point</a> &amp;control1, const <a href="ohos-point.md">Point</a> &amp;control2, const <a href="ohos-point.md">Point</a> &amp;endPoint, const <a href="ohos-paint.md">Paint</a> &amp;paint)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2127249578093522"><a name="p2127249578093522"></a><a name="p2127249578093522"></a>void </p>
<p id="p1615033756093522"><a name="p1615033756093522"></a><a name="p1615033756093522"></a>Draws a cubic Bezier curve. </p>
</td>
</tr>
<tr id="row122404092093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p509849999093522"><a name="p509849999093522"></a><a name="p509849999093522"></a><a href="graphic.md#gad186e8eab51e97a4854d3a757a3becfb">OHOS::UICanvas::DrawCurve</a> (const <a href="ohos-point.md">Point</a> &amp;startPoint, const <a href="ohos-point.md">Point</a> &amp;control1, const <a href="ohos-point.md">Point</a> &amp;control2, const <a href="ohos-point.md">Point</a> &amp;endPoint, const <a href="ohos-paint.md">Paint</a> &amp;paint)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p121456258093522"><a name="p121456258093522"></a><a name="p121456258093522"></a>void </p>
<p id="p1957562696093522"><a name="p1957562696093522"></a><a name="p1957562696093522"></a>Draws a cubic Bezier curve from the start point coordinates. </p>
</td>
</tr>
<tr id="row1417056053093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1071341166093522"><a name="p1071341166093522"></a><a name="p1071341166093522"></a><a href="graphic.md#ga1cc0bc88810cdd5554e2b1b14e68c279">OHOS::UICanvas::DrawRect</a> (const <a href="ohos-point.md">Point</a> &amp;startPoint, int16_t height, int16_t width, const <a href="ohos-paint.md">Paint</a> &amp;paint)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1923866892093522"><a name="p1923866892093522"></a><a name="p1923866892093522"></a>void </p>
<p id="p197044943093522"><a name="p197044943093522"></a><a name="p197044943093522"></a>Draws a rectangle. </p>
</td>
</tr>
<tr id="row2128172784093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1521478989093522"><a name="p1521478989093522"></a><a name="p1521478989093522"></a><a href="graphic.md#ga974544e34560d0f9d6e162c528fcd7af">OHOS::UICanvas::DrawCircle</a> (const <a href="ohos-point.md">Point</a> &amp;center, uint16_t radius, const <a href="ohos-paint.md">Paint</a> &amp;paint)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p106780735093522"><a name="p106780735093522"></a><a name="p106780735093522"></a>void </p>
<p id="p644023349093522"><a name="p644023349093522"></a><a name="p644023349093522"></a>Draws a circle. </p>
</td>
</tr>
<tr id="row2021076844093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p700688001093522"><a name="p700688001093522"></a><a name="p700688001093522"></a><a href="graphic.md#gaf14bc2633c51a16097c3ad35e8bcb314">OHOS::UICanvas::DrawSector</a> (const <a href="ohos-point.md">Point</a> &amp;center, uint16_t radius, int16_t startAngle, int16_t endAngle, const <a href="ohos-paint.md">Paint</a> &amp;paint)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1316234722093522"><a name="p1316234722093522"></a><a name="p1316234722093522"></a>void </p>
<p id="p8029062093522"><a name="p8029062093522"></a><a name="p8029062093522"></a>Draws a sector. </p>
</td>
</tr>
<tr id="row2123896882093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p288695164093522"><a name="p288695164093522"></a><a name="p288695164093522"></a><a href="graphic.md#ga620028da5c71f96416becc877331ba6c">OHOS::UICanvas::DrawArc</a> (const <a href="ohos-point.md">Point</a> &amp;center, uint16_t radius, int16_t startAngle, int16_t endAngle, const <a href="ohos-paint.md">Paint</a> &amp;paint)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1384228430093522"><a name="p1384228430093522"></a><a name="p1384228430093522"></a>void </p>
<p id="p169875707093522"><a name="p169875707093522"></a><a name="p169875707093522"></a>Draws an arc. </p>
</td>
</tr>
<tr id="row1372420609093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p918987728093522"><a name="p918987728093522"></a><a name="p918987728093522"></a><a href="graphic.md#gad5810166b3e02f41319dd4f4229c516c">OHOS::UICanvas::DrawImage</a> (const <a href="ohos-point.md">Point</a> &amp;startPoint, const char *image, const <a href="ohos-paint.md">Paint</a> &amp;paint)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p364420247093522"><a name="p364420247093522"></a><a name="p364420247093522"></a>void </p>
<p id="p1976725355093522"><a name="p1976725355093522"></a><a name="p1976725355093522"></a>Draws an image. </p>
</td>
</tr>
<tr id="row2143145661093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1394688780093522"><a name="p1394688780093522"></a><a name="p1394688780093522"></a><a href="graphic.md#ga32d815e5a459b4a866217a7c5c4bb425">OHOS::UICanvas::DrawLabel</a> (const <a href="ohos-point.md">Point</a> &amp;startPoint, const char *text, uint16_t maxWidth, const <a href="ohos-uicanvas-fontstyle.md">FontStyle</a> &amp;fontStyle, const <a href="ohos-paint.md">Paint</a> &amp;paint)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1504941697093522"><a name="p1504941697093522"></a><a name="p1504941697093522"></a>void </p>
<p id="p696449234093522"><a name="p696449234093522"></a><a name="p696449234093522"></a>Draws text. </p>
</td>
</tr>
<tr id="row1922736265093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1238240028093522"><a name="p1238240028093522"></a><a name="p1238240028093522"></a><a href="graphic.md#gac6122967d3e1f0d312eebed2f93a1369">OHOS::UICanvas::OnDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1109770166093522"><a name="p1109770166093522"></a><a name="p1109770166093522"></a>virtual void </p>
<p id="p341047976093522"><a name="p341047976093522"></a><a name="p341047976093522"></a>Called when a view is drawn. </p>
</td>
</tr>
<tr id="row81116907093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p782875908093522"><a name="p782875908093522"></a><a name="p782875908093522"></a><a href="graphic.md#ga8f1555cd3433927a650e7800a8746779">OHOS::UIChartDataSerial::UIChartDataSerial</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1545582801093522"><a name="p1545582801093522"></a><a name="p1545582801093522"></a> </p>
<p id="p499649506093522"><a name="p499649506093522"></a><a name="p499649506093522"></a>A constructor used to create a <strong id="b1041036630093522"><a name="b1041036630093522"></a><a name="b1041036630093522"></a><a href="ohos-uichartdataserial.md">UIChartDataSerial</a></strong> instance. </p>
</td>
</tr>
<tr id="row570520792093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p733741366093522"><a name="p733741366093522"></a><a name="p733741366093522"></a><a href="graphic.md#gaaf2cda0d138bb4b3a752f875f146a5bc">OHOS::UIChartDataSerial::~UIChartDataSerial</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p824051290093522"><a name="p824051290093522"></a><a name="p824051290093522"></a>virtual </p>
<p id="p68085407093522"><a name="p68085407093522"></a><a name="p68085407093522"></a>A destructor used to delete the <strong id="b1983295861093522"><a name="b1983295861093522"></a><a name="b1983295861093522"></a><a href="ohos-uichartdataserial.md">UIChartDataSerial</a></strong> instance. </p>
</td>
</tr>
<tr id="row57251452093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p962627903093522"><a name="p962627903093522"></a><a name="p962627903093522"></a><a href="graphic.md#ga81133f20156b6dc269927a5be9caf653">OHOS::UIChartDataSerial::SetMaxDataCount</a> (uint16_t maxCount)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1452681976093522"><a name="p1452681976093522"></a><a name="p1452681976093522"></a>bool </p>
<p id="p1273456328093522"><a name="p1273456328093522"></a><a name="p1273456328093522"></a>Sets the maximum number of data points that can be stored in a data set. </p>
</td>
</tr>
<tr id="row2139532552093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p35065646093522"><a name="p35065646093522"></a><a name="p35065646093522"></a><a href="graphic.md#gaa4e5a9c7d456a3753020a3fb88159c83">OHOS::UIChartDataSerial::ModifyPoint</a> (uint16_t <a href="en-us_topic_0000001055198076.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>, const <a href="ohos-point.md">Point</a> &amp;point)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1681693639093522"><a name="p1681693639093522"></a><a name="p1681693639093522"></a>bool </p>
<p id="p1808271600093522"><a name="p1808271600093522"></a><a name="p1808271600093522"></a>Modifies the value of a data point in the data set. </p>
</td>
</tr>
<tr id="row1166911807093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p516031101093522"><a name="p516031101093522"></a><a name="p516031101093522"></a><a href="graphic.md#ga32f85e7d3d9c67d491caa4105c6fa379">OHOS::UIChartDataSerial::GetPoint</a> (uint16_t <a href="en-us_topic_0000001055198076.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>, <a href="ohos-point.md">Point</a> &amp;point)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p543516190093522"><a name="p543516190093522"></a><a name="p543516190093522"></a>bool </p>
<p id="p1164542618093522"><a name="p1164542618093522"></a><a name="p1164542618093522"></a>Obtains the coordinates in the chart for a data point in the data set. </p>
</td>
</tr>
<tr id="row477648201093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1478005379093522"><a name="p1478005379093522"></a><a name="p1478005379093522"></a><a href="graphic.md#ga88d554725405cf9c501f145a25448238">OHOS::UIChartDataSerial::AddPoints</a> (const <a href="ohos-point.md">Point</a> *data, uint16_t count)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p693848145093522"><a name="p693848145093522"></a><a name="p693848145093522"></a>bool </p>
<p id="p936243742093522"><a name="p936243742093522"></a><a name="p936243742093522"></a>Adds data points. </p>
</td>
</tr>
<tr id="row253061035093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p881069610093522"><a name="p881069610093522"></a><a name="p881069610093522"></a><a href="graphic.md#ga148d9b3933a733433a96a48b95cff844">OHOS::UIChartDataSerial::ClearData</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1836678644093522"><a name="p1836678644093522"></a><a name="p1836678644093522"></a>void </p>
<p id="p534382583093522"><a name="p534382583093522"></a><a name="p534382583093522"></a>Clears all data points. </p>
</td>
</tr>
<tr id="row406709115093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1013325320093522"><a name="p1013325320093522"></a><a name="p1013325320093522"></a><a href="graphic.md#ga42b69b4725ed1d61bb8da019562c3fb2">OHOS::UIChartDataSerial::GetDataCount</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1282893963093522"><a name="p1282893963093522"></a><a name="p1282893963093522"></a>uint16_t </p>
<p id="p1030702013093522"><a name="p1030702013093522"></a><a name="p1030702013093522"></a>Obtains the number of data points available in the data set. </p>
</td>
</tr>
<tr id="row1466378449093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p779642247093522"><a name="p779642247093522"></a><a name="p779642247093522"></a><a href="graphic.md#ga9a3d5d81adbef7f847b631d03a472fbd">OHOS::UIChartDataSerial::EnableSmooth</a> (bool smooth)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1221673779093522"><a name="p1221673779093522"></a><a name="p1221673779093522"></a>void </p>
<p id="p1833163697093522"><a name="p1833163697093522"></a><a name="p1833163697093522"></a>Sets whether to smooth a polyline. </p>
</td>
</tr>
<tr id="row1708085685093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1151410190093522"><a name="p1151410190093522"></a><a name="p1151410190093522"></a><a href="graphic.md#ga5d9211f3eaee4e1c9455709a228087fe">OHOS::UIChartDataSerial::IsSmooth</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1668243756093522"><a name="p1668243756093522"></a><a name="p1668243756093522"></a>bool </p>
<p id="p297090968093522"><a name="p297090968093522"></a><a name="p297090968093522"></a>Checks whether smoothing is performed on a polyline. </p>
</td>
</tr>
<tr id="row195111110093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p631088858093522"><a name="p631088858093522"></a><a name="p631088858093522"></a><a href="graphic.md#gaa4635e5332809fc7a275c4077f9d140d">OHOS::UIChartDataSerial::EnableGradient</a> (bool enable)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p228117085093522"><a name="p228117085093522"></a><a name="p228117085093522"></a>void </p>
<p id="p1070954665093522"><a name="p1070954665093522"></a><a name="p1070954665093522"></a>Enables the fill color of a line chart. </p>
</td>
</tr>
<tr id="row1264081828093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p430534885093522"><a name="p430534885093522"></a><a name="p430534885093522"></a><a href="graphic.md#ga6188c14ea249a34db4819499f4e38133">OHOS::UIChartDataSerial::IsGradient</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p541440979093522"><a name="p541440979093522"></a><a name="p541440979093522"></a>bool </p>
<p id="p1716283901093522"><a name="p1716283901093522"></a><a name="p1716283901093522"></a>Checks whether a polyline has a fill color. </p>
</td>
</tr>
<tr id="row981669904093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2958001093522"><a name="p2958001093522"></a><a name="p2958001093522"></a><a href="graphic.md#ga60c2b77e89d616a416a05f18b5c5c055">OHOS::UIChartDataSerial::GetPeakIndex</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p113742540093522"><a name="p113742540093522"></a><a name="p113742540093522"></a>uint16_t </p>
<p id="p1486189910093522"><a name="p1486189910093522"></a><a name="p1486189910093522"></a>Obtains the index of the top point in the data set. </p>
</td>
</tr>
<tr id="row2062964014093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1681778260093522"><a name="p1681778260093522"></a><a name="p1681778260093522"></a><a href="graphic.md#ga390d7cfb4e3ced676ec6c7ac22c1ccc5">OHOS::UIChartDataSerial::GetLatestIndex</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p657534917093522"><a name="p657534917093522"></a><a name="p657534917093522"></a>uint16_t </p>
<p id="p1124063974093522"><a name="p1124063974093522"></a><a name="p1124063974093522"></a>Obtains the index of the frontmost point (the latest added or modified data point in a data set). </p>
</td>
</tr>
<tr id="row1670670567093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1505089025093522"><a name="p1505089025093522"></a><a name="p1505089025093522"></a><a href="graphic.md#ga630a7356e3dbcb212a2e88ef0c6b857d">OHOS::UIChartDataSerial::GetValleyIndex</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p507466768093522"><a name="p507466768093522"></a><a name="p507466768093522"></a>uint16_t </p>
<p id="p1044913255093522"><a name="p1044913255093522"></a><a name="p1044913255093522"></a>Obtains the index of the bottom point in a data set. </p>
</td>
</tr>
<tr id="row1053369999093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p65913048093522"><a name="p65913048093522"></a><a name="p65913048093522"></a><a href="graphic.md#gaf6c796fbd08cab47cf4fc0d41185a591">OHOS::UIChartDataSerial::GetPeakData</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p395780536093522"><a name="p395780536093522"></a><a name="p395780536093522"></a>int16_t </p>
<p id="p485429151093522"><a name="p485429151093522"></a><a name="p485429151093522"></a>Obtains the Y value of the top point in a data set. </p>
</td>
</tr>
<tr id="row971303565093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p302558201093522"><a name="p302558201093522"></a><a name="p302558201093522"></a><a href="graphic.md#gae75c525df3451cb5e863d15fd36db07e">OHOS::UIChartDataSerial::GetValleyData</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1373449844093522"><a name="p1373449844093522"></a><a name="p1373449844093522"></a>int16_t </p>
<p id="p863679474093522"><a name="p863679474093522"></a><a name="p863679474093522"></a>Obtains the Y value of the bottom point in a data set. </p>
</td>
</tr>
<tr id="row1101139691093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p133019418093522"><a name="p133019418093522"></a><a name="p133019418093522"></a><a href="graphic.md#gaa35d69c841a74505735d1acb60476f13">OHOS::UIChartDataSerial::GetLineColor</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1772692551093522"><a name="p1772692551093522"></a><a name="p1772692551093522"></a><a href="ohos-color32.md">ColorType</a> </p>
<p id="p815510255093522"><a name="p815510255093522"></a><a name="p815510255093522"></a>Obtains the polyline color of the data set in a line chart. </p>
</td>
</tr>
<tr id="row41346157093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2123041390093522"><a name="p2123041390093522"></a><a name="p2123041390093522"></a><a href="graphic.md#ga3b20df3a339aa0f41d404eb3dc1d12ca">OHOS::UIChartDataSerial::GetFillColor</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1317573757093522"><a name="p1317573757093522"></a><a name="p1317573757093522"></a><a href="ohos-color32.md">ColorType</a> </p>
<p id="p2006122649093522"><a name="p2006122649093522"></a><a name="p2006122649093522"></a>Obtains the fill color of the data set. </p>
</td>
</tr>
<tr id="row576078738093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p582113846093522"><a name="p582113846093522"></a><a name="p582113846093522"></a><a href="graphic.md#gac620b9878a5e28d066dffbcd6145539c">OHOS::UIChartDataSerial::SetFillColor</a> (const <a href="ohos-color32.md">ColorType</a> &amp;color)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1345848133093522"><a name="p1345848133093522"></a><a name="p1345848133093522"></a>void </p>
<p id="p103171501093522"><a name="p103171501093522"></a><a name="p103171501093522"></a>Sets the fill color of the data set. </p>
</td>
</tr>
<tr id="row1973015684093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1493227775093522"><a name="p1493227775093522"></a><a name="p1493227775093522"></a><a href="graphic.md#ga94beac0c71885b8546996271c876f999">OHOS::UIChartDataSerial::SetLineColor</a> (const <a href="ohos-color32.md">ColorType</a> &amp;color)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p899107153093522"><a name="p899107153093522"></a><a name="p899107153093522"></a>void </p>
<p id="p82931814093522"><a name="p82931814093522"></a><a name="p82931814093522"></a>Sets the polyline color of the data set in the line chart. </p>
</td>
</tr>
<tr id="row1886115221093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1982982100093522"><a name="p1982982100093522"></a><a name="p1982982100093522"></a><a href="graphic.md#ga02cb658da66c73863ac2a49849e23b24">OHOS::UIChartDataSerial::HidePoint</a> (uint16_t <a href="en-us_topic_0000001055198076.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>, uint16_t count)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p654422935093522"><a name="p654422935093522"></a><a name="p654422935093522"></a>void </p>
<p id="p706002836093522"><a name="p706002836093522"></a><a name="p706002836093522"></a>Hides some points in the data set. </p>
</td>
</tr>
<tr id="row1745280791093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1030327894093522"><a name="p1030327894093522"></a><a name="p1030327894093522"></a><a href="graphic.md#ga607716e734fba2eef917fdee372e43b1">OHOS::UIChartDataSerial::GetHideIndex</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p512023173093522"><a name="p512023173093522"></a><a name="p512023173093522"></a>uint16_t </p>
<p id="p1084942669093522"><a name="p1084942669093522"></a><a name="p1084942669093522"></a>Obtains the index from which the data set starts to hide. </p>
</td>
</tr>
<tr id="row1497378011093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p285273937093522"><a name="p285273937093522"></a><a name="p285273937093522"></a><a href="graphic.md#ga736907dd9f33b5335f0df5599f5cb006">OHOS::UIChartDataSerial::GetHideCount</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p948737413093522"><a name="p948737413093522"></a><a name="p948737413093522"></a>uint16_t </p>
<p id="p2047018051093522"><a name="p2047018051093522"></a><a name="p2047018051093522"></a>Obtains the number of hidden points in the data set. </p>
</td>
</tr>
<tr id="row1150850587093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1103939997093522"><a name="p1103939997093522"></a><a name="p1103939997093522"></a><a href="graphic.md#ga8fcb9d0640963ff30ff010ca5d387ff2">OHOS::UIChartDataSerial::SetHeadPointStyle</a> (const <a href="ohos-uichartdataserial-pointstyle.md">PointStyle</a> &amp;style)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1470342572093522"><a name="p1470342572093522"></a><a name="p1470342572093522"></a>void </p>
<p id="p913191658093522"><a name="p913191658093522"></a><a name="p913191658093522"></a>Sets the style of the frontmost point on a polyline. </p>
</td>
</tr>
<tr id="row97081190093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1879426735093522"><a name="p1879426735093522"></a><a name="p1879426735093522"></a><a href="graphic.md#ga91b0d5442e708e2d2bd39436b5d46baa">OHOS::UIChartDataSerial::SetTopPointStyle</a> (const <a href="ohos-uichartdataserial-pointstyle.md">PointStyle</a> &amp;style)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p174042351093522"><a name="p174042351093522"></a><a name="p174042351093522"></a>void </p>
<p id="p1271215957093522"><a name="p1271215957093522"></a><a name="p1271215957093522"></a>Sets the style of the top point of a polyline. </p>
</td>
</tr>
<tr id="row93532601093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1654985782093522"><a name="p1654985782093522"></a><a name="p1654985782093522"></a><a href="graphic.md#gab99eef3cd222625e8d3a30cca815ced2">OHOS::UIChartDataSerial::SetBottomPointStyle</a> (const <a href="ohos-uichartdataserial-pointstyle.md">PointStyle</a> &amp;style)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p194616795093522"><a name="p194616795093522"></a><a name="p194616795093522"></a>void </p>
<p id="p1528883005093522"><a name="p1528883005093522"></a><a name="p1528883005093522"></a>Sets the style of the bottom point of a polyline. </p>
</td>
</tr>
<tr id="row770261834093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p108208868093522"><a name="p108208868093522"></a><a name="p108208868093522"></a><a href="graphic.md#ga37a267a68383b41ce1d5c9072c2f7e83">OHOS::UIChartDataSerial::GetHeadPointStyle</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1867040414093522"><a name="p1867040414093522"></a><a name="p1867040414093522"></a>const <a href="ohos-uichartdataserial-pointstyle.md">PointStyle</a> &amp; </p>
<p id="p1787591821093522"><a name="p1787591821093522"></a><a name="p1787591821093522"></a>Obtains the style of the frontmost point on a polyline. </p>
</td>
</tr>
<tr id="row1912620035093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p196012104093522"><a name="p196012104093522"></a><a name="p196012104093522"></a><a href="graphic.md#ga215f5c5f8de923f0aa399a6bbdf78e18">OHOS::UIChartDataSerial::GetTopPointStyle</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1097053015093522"><a name="p1097053015093522"></a><a name="p1097053015093522"></a>const <a href="ohos-uichartdataserial-pointstyle.md">PointStyle</a> &amp; </p>
<p id="p1296726322093522"><a name="p1296726322093522"></a><a name="p1296726322093522"></a>Obtains the style of the top point of a polyline. </p>
</td>
</tr>
<tr id="row879430362093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p636661904093522"><a name="p636661904093522"></a><a name="p636661904093522"></a><a href="graphic.md#gaca803ecb139a0dae90825748bdbbf12b">OHOS::UIChartDataSerial::GetBottomPointStyle</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2048143491093522"><a name="p2048143491093522"></a><a name="p2048143491093522"></a>const <a href="ohos-uichartdataserial-pointstyle.md">PointStyle</a> &amp; </p>
<p id="p237035489093522"><a name="p237035489093522"></a><a name="p237035489093522"></a>Obtains the style of the bottom point of a polyline. </p>
</td>
</tr>
<tr id="row737900795093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p816499517093522"><a name="p816499517093522"></a><a name="p816499517093522"></a><a href="graphic.md#gaa90973e2315035570ffae0d4c3c2e976">OHOS::UIChartDataSerial::EnableHeadPoint</a> (bool enable)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p341153054093522"><a name="p341153054093522"></a><a name="p341153054093522"></a>void </p>
<p id="p461184327093522"><a name="p461184327093522"></a><a name="p461184327093522"></a>Enables the feature of drawing the frontmost point on a polyline. </p>
</td>
</tr>
<tr id="row924635853093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p234248365093522"><a name="p234248365093522"></a><a name="p234248365093522"></a><a href="graphic.md#gab97d84ead6aa301d2ae23fc68aa98a9f">OHOS::UIChartDataSerial::EnableTopPoint</a> (bool enable)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p6833093522"><a name="p6833093522"></a><a name="p6833093522"></a>void </p>
<p id="p1887840437093522"><a name="p1887840437093522"></a><a name="p1887840437093522"></a>Enables the feature of drawing the top point of a polyline. If there are multiple top points, only the first one is drawn. </p>
</td>
</tr>
<tr id="row415645198093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2093047983093522"><a name="p2093047983093522"></a><a name="p2093047983093522"></a><a href="graphic.md#ga2c0d693d31efd256cc6529255699ddd3">OHOS::UIChartDataSerial::EnableBottomPoint</a> (bool enable)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2079117643093522"><a name="p2079117643093522"></a><a name="p2079117643093522"></a>void </p>
<p id="p1776193652093522"><a name="p1776193652093522"></a><a name="p1776193652093522"></a>Enables the feature of drawing the bottom point of a polyline. If there are multiple bottom points, only the first one is drawn. </p>
</td>
</tr>
<tr id="row598533514093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p965856921093522"><a name="p965856921093522"></a><a name="p965856921093522"></a><a href="graphic.md#ga3ab02ed367123e4f84e5ab145f5ed949">OHOS::UIChart::UIChart</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p964021573093522"><a name="p964021573093522"></a><a name="p964021573093522"></a> </p>
<p id="p122688148093522"><a name="p122688148093522"></a><a name="p122688148093522"></a>A constructor used to create a <strong id="b930856710093522"><a name="b930856710093522"></a><a name="b930856710093522"></a><a href="ohos-uichart.md">UIChart</a></strong> instance. </p>
</td>
</tr>
<tr id="row520121398093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p61241047093522"><a name="p61241047093522"></a><a name="p61241047093522"></a><a href="graphic.md#gab5d79c4736d822116dcdd7ed6e45294e">OHOS::UIChart::~UIChart</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1943069164093522"><a name="p1943069164093522"></a><a name="p1943069164093522"></a>virtual </p>
<p id="p385891650093522"><a name="p385891650093522"></a><a name="p385891650093522"></a>A destructor used to delete the <strong id="b1896603855093522"><a name="b1896603855093522"></a><a name="b1896603855093522"></a><a href="ohos-uichart.md">UIChart</a></strong> instance. </p>
</td>
</tr>
<tr id="row1482769025093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p683064549093522"><a name="p683064549093522"></a><a name="p683064549093522"></a><a href="graphic.md#gaea65298b6e4a71a2de65c13e1b14ed7b">OHOS::UIChart::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p121068476093522"><a name="p121068476093522"></a><a name="p121068476093522"></a>UIViewType </p>
<p id="p530659372093522"><a name="p530659372093522"></a><a name="p530659372093522"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row34755437093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p181870021093522"><a name="p181870021093522"></a><a name="p181870021093522"></a><a href="graphic.md#ga54b3c4122ebaeefe74587ca69aa98600">OHOS::UIChart::SetHeight</a> (int16_t height) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2093308415093522"><a name="p2093308415093522"></a><a name="p2093308415093522"></a>void </p>
<p id="p1099289331093522"><a name="p1099289331093522"></a><a name="p1099289331093522"></a>Sets the height for this component. </p>
</td>
</tr>
<tr id="row1270317537093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2017943312093522"><a name="p2017943312093522"></a><a name="p2017943312093522"></a><a href="graphic.md#ga2ae317808111cd58e6ba93e030f23111">OHOS::UIChart::SetWidth</a> (int16_t width) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1946869624093522"><a name="p1946869624093522"></a><a name="p1946869624093522"></a>void </p>
<p id="p205988069093522"><a name="p205988069093522"></a><a name="p205988069093522"></a>Sets the width for this component. </p>
</td>
</tr>
<tr id="row1262412815093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p543398237093522"><a name="p543398237093522"></a><a name="p543398237093522"></a><a href="graphic.md#ga9a8287a522f00bb3dbe60af8f242054a">OHOS::UIChart::OnPreDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1984137951093522"><a name="p1984137951093522"></a><a name="p1984137951093522"></a>bool </p>
<p id="p476096571093522"><a name="p476096571093522"></a><a name="p476096571093522"></a>Called before a view is drawn. This function is used to check whether the parent view of this view needs to be redrawn so as to optimize the drawing process. </p>
</td>
</tr>
<tr id="row1202225674093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p132937127093522"><a name="p132937127093522"></a><a name="p132937127093522"></a><a href="graphic.md#ga5c101948cb2cfb8394af0bcb56f65efb">OHOS::UIChart::OnDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1136725442093522"><a name="p1136725442093522"></a><a name="p1136725442093522"></a>void </p>
<p id="p1769630073093522"><a name="p1769630073093522"></a><a name="p1769630073093522"></a>Called when a view is drawn. </p>
</td>
</tr>
<tr id="row473824753093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1245190980093522"><a name="p1245190980093522"></a><a name="p1245190980093522"></a><a href="graphic.md#gafc510047aac4e7eebd5b229e726ef762">OHOS::UIChart::AddDataSerial</a> (<a href="ohos-uichartdataserial.md">UIChartDataSerial</a> *dataSerial)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1895562759093522"><a name="p1895562759093522"></a><a name="p1895562759093522"></a>virtual bool </p>
<p id="p1336130959093522"><a name="p1336130959093522"></a><a name="p1336130959093522"></a>Adds a data set. </p>
</td>
</tr>
<tr id="row1784744304093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p836812138093522"><a name="p836812138093522"></a><a name="p836812138093522"></a><a href="graphic.md#ga2af81fbcd6a17ef250bf07e2d7606b8d">OHOS::UIChart::DeleteDataSerial</a> (<a href="ohos-uichartdataserial.md">UIChartDataSerial</a> *dataSerial)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1781286348093522"><a name="p1781286348093522"></a><a name="p1781286348093522"></a>virtual bool </p>
<p id="p13237151093522"><a name="p13237151093522"></a><a name="p13237151093522"></a>Deletes a data set. </p>
</td>
</tr>
<tr id="row1468734705093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p89500415093522"><a name="p89500415093522"></a><a name="p89500415093522"></a><a href="graphic.md#gae2752857fbcb9f1541cd811321bfc2c6">OHOS::UIChart::ClearDataSerial</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1044885506093522"><a name="p1044885506093522"></a><a name="p1044885506093522"></a>virtual void </p>
<p id="p28129510093522"><a name="p28129510093522"></a><a name="p28129510093522"></a>Clears all data sets. </p>
</td>
</tr>
<tr id="row717501610093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1731346091093522"><a name="p1731346091093522"></a><a name="p1731346091093522"></a><a href="graphic.md#gaaab35011c82308c770cf5c15641fe21c">OHOS::UIChart::RefreshChart</a> ()=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p816364755093522"><a name="p816364755093522"></a><a name="p816364755093522"></a>virtual void </p>
<p id="p972097222093522"><a name="p972097222093522"></a><a name="p972097222093522"></a>Refreshes a chart and redraws the dirty region. </p>
</td>
</tr>
<tr id="row1774529360093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p944150477093522"><a name="p944150477093522"></a><a name="p944150477093522"></a><a href="graphic.md#ga010c178e2c1dec79e4af10cbf4545257">OHOS::UIChart::GetXAxis</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2100255229093522"><a name="p2100255229093522"></a><a name="p2100255229093522"></a><a href="ohos-uixaxis.md">UIXAxis</a> &amp; </p>
<p id="p1777163172093522"><a name="p1777163172093522"></a><a name="p1777163172093522"></a>Obtains the x-axis instance. </p>
</td>
</tr>
<tr id="row1421379310093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p407425406093522"><a name="p407425406093522"></a><a name="p407425406093522"></a><a href="graphic.md#ga696227300be45585be102f6a7f66b7b1">OHOS::UIChart::GetYAxis</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p468228433093522"><a name="p468228433093522"></a><a name="p468228433093522"></a><a href="ohos-uiyaxis.md">UIYAxis</a> &amp; </p>
<p id="p606706243093522"><a name="p606706243093522"></a><a name="p606706243093522"></a>Obtains the y-axis instance. </p>
</td>
</tr>
<tr id="row309124448093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1321639019093522"><a name="p1321639019093522"></a><a name="p1321639019093522"></a><a href="graphic.md#ga7c99edd3adfb60796be92e98fd71a705">OHOS::UIChart::EnableReverse</a> (bool enable)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p957182796093522"><a name="p957182796093522"></a><a name="p957182796093522"></a>void </p>
<p id="p226461421093522"><a name="p226461421093522"></a><a name="p226461421093522"></a>Enables chart reverse. </p>
</td>
</tr>
<tr id="row665538619093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1340524101093522"><a name="p1340524101093522"></a><a name="p1340524101093522"></a><a href="graphic.md#ga5c26ce24f640f795404c8375b4043186">OHOS::UIChartPillar::UIChartPillar</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p777290464093522"><a name="p777290464093522"></a><a name="p777290464093522"></a> </p>
<p id="p1557240642093522"><a name="p1557240642093522"></a><a name="p1557240642093522"></a>A constructor used to create a <strong id="b1461350783093522"><a name="b1461350783093522"></a><a name="b1461350783093522"></a><a href="ohos-uichartpillar.md">UIChartPillar</a></strong> instance. </p>
</td>
</tr>
<tr id="row1970056156093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2036120323093522"><a name="p2036120323093522"></a><a name="p2036120323093522"></a><a href="graphic.md#ga0f1e413e8eb026f2b5746b05b48d7ca7">OHOS::UIChartPillar::~UIChartPillar</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1235834328093522"><a name="p1235834328093522"></a><a name="p1235834328093522"></a>virtual </p>
<p id="p1894486972093522"><a name="p1894486972093522"></a><a name="p1894486972093522"></a>A destructor used to delete the <strong id="b1557973348093522"><a name="b1557973348093522"></a><a name="b1557973348093522"></a><a href="ohos-uichartpillar.md">UIChartPillar</a></strong> instance. </p>
</td>
</tr>
<tr id="row996944075093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1196740977093522"><a name="p1196740977093522"></a><a name="p1196740977093522"></a><a href="graphic.md#ga0c6028474577ce99caa6d3eafaef1573">OHOS::UIChartPillar::RefreshChart</a> () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p587722215093522"><a name="p587722215093522"></a><a name="p587722215093522"></a>void </p>
<p id="p1278598365093522"><a name="p1278598365093522"></a><a name="p1278598365093522"></a>Refreshes a bar chart and redraws the dirty region. </p>
</td>
</tr>
<tr id="row1390262454093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1625759619093522"><a name="p1625759619093522"></a><a name="p1625759619093522"></a><a href="graphic.md#gaf32e6833f395ca6ac8620277531d5ea7">OHOS::UIChartPolyline::UIChartPolyline</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p9724690093522"><a name="p9724690093522"></a><a name="p9724690093522"></a> </p>
<p id="p640927920093522"><a name="p640927920093522"></a><a name="p640927920093522"></a>A constructor used to create a <strong id="b1342898775093522"><a name="b1342898775093522"></a><a name="b1342898775093522"></a><a href="ohos-uichartpolyline.md">UIChartPolyline</a></strong> instance. </p>
</td>
</tr>
<tr id="row2051050163093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p866824855093522"><a name="p866824855093522"></a><a name="p866824855093522"></a><a href="graphic.md#ga620a90ab246ec8c5c55aed8985329cb9">OHOS::UIChartPolyline::~UIChartPolyline</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1292427097093522"><a name="p1292427097093522"></a><a name="p1292427097093522"></a>virtual </p>
<p id="p1790872959093522"><a name="p1790872959093522"></a><a name="p1790872959093522"></a>A destructor used to delete the <strong id="b1305907814093522"><a name="b1305907814093522"></a><a name="b1305907814093522"></a><a href="ohos-uichartpolyline.md">UIChartPolyline</a></strong> instance. </p>
</td>
</tr>
<tr id="row1544044567093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p520519608093522"><a name="p520519608093522"></a><a name="p520519608093522"></a><a href="graphic.md#ga53594e65076b8588bcc48d4c69fbe8fd">OHOS::UIChartPolyline::RefreshChart</a> () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p915194265093522"><a name="p915194265093522"></a><a name="p915194265093522"></a>void </p>
<p id="p900294643093522"><a name="p900294643093522"></a><a name="p900294643093522"></a>Refreshes a line chart and redraws the dirty region. </p>
</td>
</tr>
<tr id="row141351457093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p186309031093522"><a name="p186309031093522"></a><a name="p186309031093522"></a><a href="graphic.md#gacf4303bade3933dcac90459fa38d6e1f">OHOS::UIChartPolyline::SetGradientOpacity</a> (uint8_t minOpa, uint8_t maxOpa)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p428609092093522"><a name="p428609092093522"></a><a name="p428609092093522"></a>void </p>
<p id="p1843464681093522"><a name="p1843464681093522"></a><a name="p1843464681093522"></a>Sets the opacity range of the fill color gradient. </p>
</td>
</tr>
<tr id="row1644562306093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1160371052093522"><a name="p1160371052093522"></a><a name="p1160371052093522"></a><a href="graphic.md#gafdab5b0f7f8563d475c5aba2aeb1e828">OHOS::UIChartPolyline::SetGradientBottom</a> (uint16_t bottom)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p592300162093522"><a name="p592300162093522"></a><a name="p592300162093522"></a>void </p>
<p id="p983702490093522"><a name="p983702490093522"></a><a name="p983702490093522"></a>Sets the distance between the bottom edge of the fill color range and the x-axis. </p>
</td>
</tr>
<tr id="row664519591093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1960666119093522"><a name="p1960666119093522"></a><a name="p1960666119093522"></a><a href="graphic.md#ga811085fbe237690f21a95e7df2a7c45f">OHOS::UICheckBox::UICheckBox</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p224755772093522"><a name="p224755772093522"></a><a name="p224755772093522"></a> </p>
<p id="p1689730186093522"><a name="p1689730186093522"></a><a name="p1689730186093522"></a>A constructor used to create a <strong id="b703876405093522"><a name="b703876405093522"></a><a name="b703876405093522"></a><a href="ohos-uicheckbox.md">UICheckBox</a></strong> instance. </p>
</td>
</tr>
<tr id="row465502309093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p925726295093522"><a name="p925726295093522"></a><a name="p925726295093522"></a><a href="graphic.md#ga061c90b24caa6595b70a9da9f96c5c4e">OHOS::UICheckBox::~UICheckBox</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2000570174093522"><a name="p2000570174093522"></a><a name="p2000570174093522"></a>virtual </p>
<p id="p993448639093522"><a name="p993448639093522"></a><a name="p993448639093522"></a>A destructor used to delete the <strong id="b279555579093522"><a name="b279555579093522"></a><a name="b279555579093522"></a><a href="ohos-uicheckbox.md">UICheckBox</a></strong> instance. </p>
</td>
</tr>
<tr id="row1258626431093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p843589805093522"><a name="p843589805093522"></a><a name="p843589805093522"></a><a href="graphic.md#ga373b76d4ce1aea6380f42ce78ecd59c3">OHOS::UICheckBox::OnChangeListener::OnChange</a> (<a href="graphic.md#ga15a3f0302aded0e4d1584ddc6002335d">UICheckBoxState</a> state)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1726837147093522"><a name="p1726837147093522"></a><a name="p1726837147093522"></a>virtual bool </p>
<p id="p256062899093522"><a name="p256062899093522"></a><a name="p256062899093522"></a>Called when the state of this check box is switched. This is a virtual function, which needs your implementation. </p>
</td>
</tr>
<tr id="row1557788059093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1642981246093522"><a name="p1642981246093522"></a><a name="p1642981246093522"></a><a href="graphic.md#gab2e7f64e07e70975baa571660687f6a1">OHOS::UICheckBox::OnChangeListener::~OnChangeListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p582032757093522"><a name="p582032757093522"></a><a name="p582032757093522"></a>virtual </p>
<p id="p595368162093522"><a name="p595368162093522"></a><a name="p595368162093522"></a>A destructor used to delete the <strong id="b488211395093522"><a name="b488211395093522"></a><a name="b488211395093522"></a><a href="ohos-uicheckbox-onchangelistener.md">OnChangeListener</a></strong> instance. </p>
</td>
</tr>
<tr id="row414396047093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1048615793093522"><a name="p1048615793093522"></a><a name="p1048615793093522"></a><a href="graphic.md#ga6820cef1fb685db5796670ca56b6aace">OHOS::UICheckBox::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1207484219093522"><a name="p1207484219093522"></a><a name="p1207484219093522"></a>UIViewType </p>
<p id="p1070788495093522"><a name="p1070788495093522"></a><a name="p1070788495093522"></a>Obtains the component type. </p>
</td>
</tr>
<tr id="row1816188814093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p471166965093522"><a name="p471166965093522"></a><a name="p471166965093522"></a><a href="graphic.md#gad72c8f6a67fc3fb86da8eabffcf5315d">OHOS::UICheckBox::SetOnChangeListener</a> (<a href="ohos-uicheckbox-onchangelistener.md">OnChangeListener</a> *onStateChangeListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p512574489093522"><a name="p512574489093522"></a><a name="p512574489093522"></a>void </p>
<p id="p410499903093522"><a name="p410499903093522"></a><a name="p410499903093522"></a>Sets the listener for this check box. </p>
</td>
</tr>
<tr id="row538880325093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p768122606093522"><a name="p768122606093522"></a><a name="p768122606093522"></a><a href="graphic.md#ga53cc6c8f18b90c3abd96a791c8921010">OHOS::UICheckBox::OnPreDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p7409503093522"><a name="p7409503093522"></a><a name="p7409503093522"></a>bool </p>
<p id="p2041232977093522"><a name="p2041232977093522"></a><a name="p2041232977093522"></a>Do something before draw, this function will be invoked mainly to check if this view need to cover invalidate area so render manager can decide which layer to draw firstly. </p>
</td>
</tr>
<tr id="row1314497411093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1082665032093522"><a name="p1082665032093522"></a><a name="p1082665032093522"></a><a href="graphic.md#ga8e75f8411fb25e564c82573a12773189">OHOS::UICheckBox::OnDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p822626003093522"><a name="p822626003093522"></a><a name="p822626003093522"></a>void </p>
<p id="p833302612093522"><a name="p833302612093522"></a><a name="p833302612093522"></a>Executes the draw action Ondraw invokes the rendering function provided by the underlying layer to draw pictures based on the selected status of the checkbox. </p>
</td>
</tr>
<tr id="row1977490109093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p576415950093522"><a name="p576415950093522"></a><a name="p576415950093522"></a><a href="graphic.md#ga31d4f10f4c32b0fb284645450875ae0c">OHOS::UICheckBox::OnClickEvent</a> (const <a href="ohos-clickevent.md">ClickEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p403765506093522"><a name="p403765506093522"></a><a name="p403765506093522"></a>void </p>
<p id="p240390538093522"><a name="p240390538093522"></a><a name="p240390538093522"></a>Executes the click event action OnClickEvent will reverse the selected state of checkbox. Example: If the check box is selected, the checkbox status is changed to Unselected after the click action is taken. </p>
</td>
</tr>
<tr id="row117923860093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p203982749093522"><a name="p203982749093522"></a><a name="p203982749093522"></a><a href="graphic.md#ga2e1ac9e3084d018febf5ac0912a27c72">OHOS::UICheckBox::SetImages</a> (const char *selectedImageSrc, const char *unselectedImageSrc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p199024598093522"><a name="p199024598093522"></a><a name="p199024598093522"></a>virtual void </p>
<p id="p1048320021093522"><a name="p1048320021093522"></a><a name="p1048320021093522"></a>Sets the images for this check box. </p>
</td>
</tr>
<tr id="row347124396093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1673910239093522"><a name="p1673910239093522"></a><a name="p1673910239093522"></a><a href="graphic.md#ga89eb87d02e7b31fc6517b8744751f021">OHOS::UICheckBox::SetImages</a> (const <a href="ohos-imageinfo.md">ImageInfo</a> *selectedImageSrc, const <a href="ohos-imageinfo.md">ImageInfo</a> *unselectedImageSrc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p779943792093522"><a name="p779943792093522"></a><a name="p779943792093522"></a>virtual void </p>
<p id="p1822061063093522"><a name="p1822061063093522"></a><a name="p1822061063093522"></a>Sets the images for this check box. </p>
</td>
</tr>
<tr id="row686671608093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p82230339093522"><a name="p82230339093522"></a><a name="p82230339093522"></a><a href="graphic.md#gab3cddc176a6834fabc7c53912c97237c">OHOS::UICheckBox::GetState</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p238891984093522"><a name="p238891984093522"></a><a name="p238891984093522"></a><a href="graphic.md#ga15a3f0302aded0e4d1584ddc6002335d">UICheckBoxState</a> </p>
<p id="p1954392606093522"><a name="p1954392606093522"></a><a name="p1954392606093522"></a>Obtains the state of this check box. </p>
</td>
</tr>
<tr id="row2062811790093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1030193004093522"><a name="p1030193004093522"></a><a name="p1030193004093522"></a><a href="graphic.md#ga32217050815d4d9129ace5ab410fb82d">OHOS::UICheckBox::SetState</a> (<a href="graphic.md#ga15a3f0302aded0e4d1584ddc6002335d">UICheckBoxState</a> state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2013878499093522"><a name="p2013878499093522"></a><a name="p2013878499093522"></a>void </p>
<p id="p493131960093522"><a name="p493131960093522"></a><a name="p493131960093522"></a>Sets the state for this check box. </p>
</td>
</tr>
<tr id="row168534257093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p518621755093522"><a name="p518621755093522"></a><a name="p518621755093522"></a><a href="graphic.md#gae6d547653f0448f9151fa257cbf9c3ac">OHOS::UICircleProgress::UICircleProgress</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p42659609093522"><a name="p42659609093522"></a><a name="p42659609093522"></a> </p>
<p id="p244694392093522"><a name="p244694392093522"></a><a name="p244694392093522"></a>A constructor used to create a <strong id="b1746122407093522"><a name="b1746122407093522"></a><a name="b1746122407093522"></a><a href="ohos-uicircleprogress.md">UICircleProgress</a></strong> instance. </p>
</td>
</tr>
<tr id="row2079048621093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p819361921093522"><a name="p819361921093522"></a><a name="p819361921093522"></a><a href="graphic.md#ga10a9da813e933b3513e22a95bb81af98">OHOS::UICircleProgress::~UICircleProgress</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p516005521093522"><a name="p516005521093522"></a><a name="p516005521093522"></a>virtual </p>
<p id="p147279230093522"><a name="p147279230093522"></a><a name="p147279230093522"></a>A destructor used to delete the <strong id="b1841882818093522"><a name="b1841882818093522"></a><a name="b1841882818093522"></a><a href="ohos-uicircleprogress.md">UICircleProgress</a></strong> instance. </p>
</td>
</tr>
<tr id="row1449851350093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p343387350093522"><a name="p343387350093522"></a><a name="p343387350093522"></a><a href="graphic.md#gab1d8fc06d4a73db344efd271d68a62e6">OHOS::UICircleProgress::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p338083757093522"><a name="p338083757093522"></a><a name="p338083757093522"></a>UIViewType </p>
<p id="p368791388093522"><a name="p368791388093522"></a><a name="p368791388093522"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row1690078327093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p307108473093522"><a name="p307108473093522"></a><a name="p307108473093522"></a><a href="graphic.md#ga98bc4ea99629e4d5c7ca5ca4b43e8e96">OHOS::UICircleProgress::OnPreDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p296874483093522"><a name="p296874483093522"></a><a name="p296874483093522"></a>bool </p>
<p id="p1481470646093522"><a name="p1481470646093522"></a><a name="p1481470646093522"></a>Called before a view is drawn. This function is used to check whether the parent view of this view needs to be redrawn so as to optimize the drawing process. </p>
</td>
</tr>
<tr id="row289795734093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1428739353093522"><a name="p1428739353093522"></a><a name="p1428739353093522"></a><a href="graphic.md#ga611f2f03c22499c428d1de3392ee4861">OHOS::UICircleProgress::OnDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p868521620093522"><a name="p868521620093522"></a><a name="p868521620093522"></a>void </p>
<p id="p1625073823093522"><a name="p1625073823093522"></a><a name="p1625073823093522"></a>Called when a view is drawn. </p>
</td>
</tr>
<tr id="row1582119467093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1156401945093522"><a name="p1156401945093522"></a><a name="p1156401945093522"></a><a href="graphic.md#ga6cf6b8ab0934ce8c0ea1821da0791317">OHOS::UICircleProgress::SetCenterPosition</a> (int16_t x, int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1577790063093522"><a name="p1577790063093522"></a><a name="p1577790063093522"></a>void </p>
<p id="p1278945239093522"><a name="p1278945239093522"></a><a name="p1278945239093522"></a>Sets the coordinates of the center point for this circular progress bar. </p>
</td>
</tr>
<tr id="row451867387093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1216868627093522"><a name="p1216868627093522"></a><a name="p1216868627093522"></a><a href="graphic.md#ga706ac374a1383cef01dfc59c5257e480">OHOS::UICircleProgress::GetCenterPosition</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p66317598093522"><a name="p66317598093522"></a><a name="p66317598093522"></a><a href="ohos-point.md">Point</a> </p>
<p id="p1095969544093522"><a name="p1095969544093522"></a><a name="p1095969544093522"></a>Obtains the coordinates of the center point for this circular progress bar. </p>
</td>
</tr>
<tr id="row300425491093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p824349164093522"><a name="p824349164093522"></a><a name="p824349164093522"></a><a href="graphic.md#ga80377fb579f6698cefd5fcf74d0cde46">OHOS::UICircleProgress::SetRadius</a> (uint16_t radius)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p559472751093522"><a name="p559472751093522"></a><a name="p559472751093522"></a>void </p>
<p id="p1421639593093522"><a name="p1421639593093522"></a><a name="p1421639593093522"></a>Sets the outer radius for this circular progress bar. </p>
</td>
</tr>
<tr id="row1963434180093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p106095404093522"><a name="p106095404093522"></a><a name="p106095404093522"></a><a href="graphic.md#gabb2869e683ccd799891a8869613ec8c7">OHOS::UICircleProgress::GetRadius</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1493135590093522"><a name="p1493135590093522"></a><a name="p1493135590093522"></a>uint16_t </p>
<p id="p561569288093522"><a name="p561569288093522"></a><a name="p561569288093522"></a>Obtains the outer radius of this circular progress bar. </p>
</td>
</tr>
<tr id="row1787137868093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1836283972093522"><a name="p1836283972093522"></a><a name="p1836283972093522"></a><a href="graphic.md#gae27e30bd77b83bc55ecc9f2a5643943a">OHOS::UICircleProgress::SetStartAngle</a> (int16_t startAngle)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1715809093093522"><a name="p1715809093093522"></a><a name="p1715809093093522"></a>void </p>
<p id="p1137049379093522"><a name="p1137049379093522"></a><a name="p1137049379093522"></a>Sets the start angle. </p>
</td>
</tr>
<tr id="row10201847093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1923474016093522"><a name="p1923474016093522"></a><a name="p1923474016093522"></a><a href="graphic.md#ga37a3e63da7a8658e48a25ae9ec73abea">OHOS::UICircleProgress::GetStartAngle</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p36624450093522"><a name="p36624450093522"></a><a name="p36624450093522"></a>int16_t </p>
<p id="p1004493801093522"><a name="p1004493801093522"></a><a name="p1004493801093522"></a>Obtains the start angle. </p>
</td>
</tr>
<tr id="row2002926511093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1922719091093522"><a name="p1922719091093522"></a><a name="p1922719091093522"></a><a href="graphic.md#ga831186bf208f8236b006b13cc122c82c">OHOS::UICircleProgress::SetEndAngle</a> (int16_t endAngle)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1735495685093522"><a name="p1735495685093522"></a><a name="p1735495685093522"></a>void </p>
<p id="p539067359093522"><a name="p539067359093522"></a><a name="p539067359093522"></a>Sets the end angle. </p>
</td>
</tr>
<tr id="row1634707683093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2090111030093522"><a name="p2090111030093522"></a><a name="p2090111030093522"></a><a href="graphic.md#gacab2327bfc24ee985818a95d468af181">OHOS::UICircleProgress::GetEndAngle</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p240073260093522"><a name="p240073260093522"></a><a name="p240073260093522"></a>int16_t </p>
<p id="p167649604093522"><a name="p167649604093522"></a><a name="p167649604093522"></a>Obtains the end angle. </p>
</td>
</tr>
<tr id="row220271326093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p22530048093522"><a name="p22530048093522"></a><a name="p22530048093522"></a><a href="graphic.md#ga62b71500ccc75673be297d2e114c0c1b">OHOS::UICircleProgress::SetProgressImagePosition</a> (int16_t x, int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2061491013093522"><a name="p2061491013093522"></a><a name="p2061491013093522"></a>void </p>
<p id="p448455321093522"><a name="p448455321093522"></a><a name="p448455321093522"></a>Sets the coordinates of the foreground image for this progress bar relative to the view. </p>
</td>
</tr>
<tr id="row1293542052093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1330542210093522"><a name="p1330542210093522"></a><a name="p1330542210093522"></a><a href="graphic.md#ga66b95a4793bc60596a56be00849b8296">OHOS::UICircleProgress::SetBackgroundImagePosition</a> (int16_t x, int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1731440014093522"><a name="p1731440014093522"></a><a name="p1731440014093522"></a>void </p>
<p id="p296990489093522"><a name="p296990489093522"></a><a name="p296990489093522"></a>Sets the coordinates of the background image for this progress bar relative to the view. </p>
</td>
</tr>
<tr id="row323460047093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1816676777093522"><a name="p1816676777093522"></a><a name="p1816676777093522"></a><a href="graphic.md#gad0453bc291f75f4864c112f9f2f474db">OHOS::UICircleProgress::SetLineColor</a> (<a href="ohos-color32.md">ColorType</a> color)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1728499521093522"><a name="p1728499521093522"></a><a name="p1728499521093522"></a>void </p>
<p id="p1367807927093522"><a name="p1367807927093522"></a><a name="p1367807927093522"></a>Sets the foreground color for this progress bar. </p>
</td>
</tr>
<tr id="row1264850107093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p406301160093522"><a name="p406301160093522"></a><a name="p406301160093522"></a><a href="graphic.md#gaeaaddc56316206d4465ce8c927a686b7">OHOS::UIDialog::UIDialog</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1320037274093522"><a name="p1320037274093522"></a><a name="p1320037274093522"></a> </p>
<p id="p200117676093522"><a name="p200117676093522"></a><a name="p200117676093522"></a>A constructor used to create a <strong id="b479149408093522"><a name="b479149408093522"></a><a name="b479149408093522"></a><a href="ohos-uidialog.md">UIDialog</a></strong> instance. </p>
</td>
</tr>
<tr id="row282651910093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1286168597093522"><a name="p1286168597093522"></a><a name="p1286168597093522"></a><a href="graphic.md#gae5b58ec7225efdbfaf9947e46bfd2616">OHOS::UIDialog::~UIDialog</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p281626619093522"><a name="p281626619093522"></a><a name="p281626619093522"></a>virtual </p>
<p id="p160452468093522"><a name="p160452468093522"></a><a name="p160452468093522"></a>A destructor used to delete the <strong id="b1489387261093522"><a name="b1489387261093522"></a><a name="b1489387261093522"></a><a href="ohos-uidialog.md">UIDialog</a></strong> instance. </p>
</td>
</tr>
<tr id="row51274649093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p141584451093522"><a name="p141584451093522"></a><a name="p141584451093522"></a><a href="graphic.md#gac0b18fe28ee4ad44814d3897d3cd5c05">OHOS::UIDialog::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1320065559093522"><a name="p1320065559093522"></a><a name="p1320065559093522"></a>UIViewType </p>
<p id="p1238334254093522"><a name="p1238334254093522"></a><a name="p1238334254093522"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row1067604120093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1737090356093522"><a name="p1737090356093522"></a><a name="p1737090356093522"></a><a href="graphic.md#ga5629d5a1e19bc38087e8b35d65292714">OHOS::UIDialog::SetTitle</a> (const char *title)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1792595420093522"><a name="p1792595420093522"></a><a name="p1792595420093522"></a>void </p>
<p id="p1197442198093522"><a name="p1197442198093522"></a><a name="p1197442198093522"></a>Sets the title for this dialog box. </p>
</td>
</tr>
<tr id="row1551064862093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2111747660093522"><a name="p2111747660093522"></a><a name="p2111747660093522"></a><a href="graphic.md#ga597e95748fba71238a99c8c17ed848a5">OHOS::UIDialog::SetText</a> (const char *text)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1067894135093522"><a name="p1067894135093522"></a><a name="p1067894135093522"></a>void </p>
<p id="p989276881093522"><a name="p989276881093522"></a><a name="p989276881093522"></a>Sets the text for this dialog box. </p>
</td>
</tr>
<tr id="row830371374093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p233101255093522"><a name="p233101255093522"></a><a name="p233101255093522"></a><a href="graphic.md#ga6b3cf14760fc07e38f51d366a8e5fdb9">OHOS::UIDialog::OnPreDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1341626821093522"><a name="p1341626821093522"></a><a name="p1341626821093522"></a>bool </p>
<p id="p818661876093522"><a name="p818661876093522"></a><a name="p818661876093522"></a>Checks whether this label needs to be covered before drawing it. </p>
</td>
</tr>
<tr id="row528138249093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p575244859093522"><a name="p575244859093522"></a><a name="p575244859093522"></a><a href="graphic.md#gaa8bcf4d2d60becd105d0b87ee2ec18af">OHOS::UIDialog::SetButton</a> (<a href="graphic.md#ga1bfefa0b46fd5a79a28d0c9a75114295">DialogButtonType</a> buttonType, const char *text, <a href="ohos-uiview-onclicklistener.md">OnClickListener</a> *listener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1852842582093522"><a name="p1852842582093522"></a><a name="p1852842582093522"></a>void </p>
<p id="p1481938342093522"><a name="p1481938342093522"></a><a name="p1481938342093522"></a>Sets a button for this dialog box. </p>
</td>
</tr>
<tr id="row386035193093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2114708293093522"><a name="p2114708293093522"></a><a name="p2114708293093522"></a><a href="graphic.md#gaf836d530b3fa9d50f70053c2b0b528d6">OHOS::UIDialog::SetVisible</a> (bool visible) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1588343865093522"><a name="p1588343865093522"></a><a name="p1588343865093522"></a>void </p>
<p id="p581129967093522"><a name="p581129967093522"></a><a name="p581129967093522"></a>Sets whether a dialog box is visible. </p>
</td>
</tr>
<tr id="row2049594821093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p888177639093522"><a name="p888177639093522"></a><a name="p888177639093522"></a><a href="graphic.md#gac89c3f554cea687e0b7d7338319c8d0b">OHOS::UIDigitalClock::UIDigitalClock</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p532347195093522"><a name="p532347195093522"></a><a name="p532347195093522"></a> </p>
<p id="p1886833397093522"><a name="p1886833397093522"></a><a name="p1886833397093522"></a>A default constructor used to create a <strong id="b141421904093522"><a name="b141421904093522"></a><a name="b141421904093522"></a><a href="ohos-uidigitalclock.md">UIDigitalClock</a></strong> instance. </p>
</td>
</tr>
<tr id="row1881083625093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p205302626093522"><a name="p205302626093522"></a><a name="p205302626093522"></a><a href="graphic.md#gaf4daabe77c9ab8264618a4f970b0a15e">OHOS::UIDigitalClock::~UIDigitalClock</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1669565505093522"><a name="p1669565505093522"></a><a name="p1669565505093522"></a>virtual </p>
<p id="p1990753184093522"><a name="p1990753184093522"></a><a name="p1990753184093522"></a>A destructor used to delete the <strong id="b408027020093522"><a name="b408027020093522"></a><a name="b408027020093522"></a><a href="ohos-uidigitalclock.md">UIDigitalClock</a></strong> instance. </p>
</td>
</tr>
<tr id="row1477482712093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1836194321093522"><a name="p1836194321093522"></a><a name="p1836194321093522"></a><a href="graphic.md#ga567a8195e8520b74b682de697cfe1d90">OHOS::UIDigitalClock::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1143458232093522"><a name="p1143458232093522"></a><a name="p1143458232093522"></a>UIViewType </p>
<p id="p2126897754093522"><a name="p2126897754093522"></a><a name="p2126897754093522"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row447851253093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1399968889093522"><a name="p1399968889093522"></a><a name="p1399968889093522"></a><a href="graphic.md#ga9013bc4fa8bfc77cf75b898db1a0fbf6">OHOS::UIDigitalClock::SetFontId</a> (uint8_t fontId)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1361156059093522"><a name="p1361156059093522"></a><a name="p1361156059093522"></a>void </p>
<p id="p1541652191093522"><a name="p1541652191093522"></a><a name="p1541652191093522"></a>Sets the dynamic font ID for this digital clock. </p>
</td>
</tr>
<tr id="row718490487093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1100814363093522"><a name="p1100814363093522"></a><a name="p1100814363093522"></a><a href="graphic.md#gaa41d0c6ab53a4451e9e90199dbaa3895">OHOS::UIDigitalClock::SetFont</a> (const char *name, uint8_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p298760602093522"><a name="p298760602093522"></a><a name="p298760602093522"></a>void </p>
<p id="p1625739675093522"><a name="p1625739675093522"></a><a name="p1625739675093522"></a>Sets the dynamic font for this digital clock. </p>
</td>
</tr>
<tr id="row1280366315093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1327059136093522"><a name="p1327059136093522"></a><a name="p1327059136093522"></a><a href="graphic.md#gaabdefd6f104682c755886594e259e810">OHOS::UIDigitalClock::SetColor</a> (<a href="ohos-color32.md">ColorType</a> color)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1599843508093522"><a name="p1599843508093522"></a><a name="p1599843508093522"></a>void </p>
<p id="p2011905784093522"><a name="p2011905784093522"></a><a name="p2011905784093522"></a>Sets the font color for this digital clock. </p>
</td>
</tr>
<tr id="row549521703093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1408418085093522"><a name="p1408418085093522"></a><a name="p1408418085093522"></a><a href="graphic.md#ga2ac4d800eb47c4238d160819e165a30a">OHOS::UIDigitalClock::SetDisplayMode</a> (<a href="graphic.md#gabe3b64b11e5bf5d7b54e1039e40f306b">DisplayMode</a> dm)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p300982176093522"><a name="p300982176093522"></a><a name="p300982176093522"></a>void </p>
<p id="p1602222215093522"><a name="p1602222215093522"></a><a name="p1602222215093522"></a>Sets the display mode for this digital clock. </p>
</td>
</tr>
<tr id="row989126587093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p406302959093522"><a name="p406302959093522"></a><a name="p406302959093522"></a><a href="graphic.md#ga14a5b4ca3e2eda9ff0f6a7ad2bc11f48">OHOS::UIDigitalClock::GetDisplayMode</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1267350974093522"><a name="p1267350974093522"></a><a name="p1267350974093522"></a><a href="graphic.md#gabe3b64b11e5bf5d7b54e1039e40f306b">DisplayMode</a> </p>
<p id="p317945807093522"><a name="p317945807093522"></a><a name="p317945807093522"></a>Obtains the display mode of this digital clock. </p>
</td>
</tr>
<tr id="row1837322525093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p441631494093522"><a name="p441631494093522"></a><a name="p441631494093522"></a><a href="graphic.md#gaf45e9196d307551e693807cae2f8b4d2">OHOS::UIDigitalClock::DisplayLeadingZero</a> (bool displayLeadingZero)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1137355162093522"><a name="p1137355162093522"></a><a name="p1137355162093522"></a>void </p>
<p id="p30039136093522"><a name="p30039136093522"></a><a name="p30039136093522"></a>Sets whether to add <strong id="b1020184190093522"><a name="b1020184190093522"></a><a name="b1020184190093522"></a>0</strong> before the hour of this digital clock. </p>
</td>
</tr>
<tr id="row988554546093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1833092401093522"><a name="p1833092401093522"></a><a name="p1833092401093522"></a><a href="graphic.md#ga1565dcdb5ab0403fa477fd74c5920b99">OHOS::UIDigitalClock::SetOpacity</a> (uint8_t opacity)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1557156684093522"><a name="p1557156684093522"></a><a name="p1557156684093522"></a>void </p>
<p id="p488152571093522"><a name="p488152571093522"></a><a name="p488152571093522"></a>Sets the opacity for this digital clock. </p>
</td>
</tr>
<tr id="row1929575003093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p576240392093522"><a name="p576240392093522"></a><a name="p576240392093522"></a><a href="graphic.md#ga713ec508a94eb05eab0aa5ab1c7f41ca">OHOS::UIDigitalClock::GetOpacity</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1436658653093522"><a name="p1436658653093522"></a><a name="p1436658653093522"></a>uint8_t </p>
<p id="p1188458044093522"><a name="p1188458044093522"></a><a name="p1188458044093522"></a>Obtains the opacity of this digital clock. </p>
</td>
</tr>
<tr id="row884196858093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1391039023093522"><a name="p1391039023093522"></a><a name="p1391039023093522"></a><a href="graphic.md#ga386c03c483ef38cb5310563b6ba9bc02">OHOS::UIDigitalClock::UpdateClock</a> (bool clockInit) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1629670858093522"><a name="p1629670858093522"></a><a name="p1629670858093522"></a>void </p>
<p id="p1324883086093522"><a name="p1324883086093522"></a><a name="p1324883086093522"></a>Updates this digital clock. </p>
</td>
</tr>
<tr id="row271129721093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2103896361093522"><a name="p2103896361093522"></a><a name="p2103896361093522"></a><a href="graphic.md#ga0506b7e6730f07b6e78371b479326b54">OHOS::UIImageAnimatorView::UIImageAnimatorView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p535094522093522"><a name="p535094522093522"></a><a name="p535094522093522"></a> </p>
<p id="p1069459731093522"><a name="p1069459731093522"></a><a name="p1069459731093522"></a>A constructor used to create a <strong id="b1598986359093522"><a name="b1598986359093522"></a><a name="b1598986359093522"></a><a href="ohos-uiimageanimatorview.md">UIImageAnimatorView</a></strong> instance. </p>
</td>
</tr>
<tr id="row2126463605093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1380287961093522"><a name="p1380287961093522"></a><a name="p1380287961093522"></a><a href="graphic.md#ga72c8450b3c27dd0429691667a6d66dd1">OHOS::UIImageAnimatorView::~UIImageAnimatorView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p244709503093522"><a name="p244709503093522"></a><a name="p244709503093522"></a>virtual </p>
<p id="p1097582055093522"><a name="p1097582055093522"></a><a name="p1097582055093522"></a>A destructor used to delete the <strong id="b547869837093522"><a name="b547869837093522"></a><a name="b547869837093522"></a><a href="ohos-uiimageanimatorview.md">UIImageAnimatorView</a></strong> instance. </p>
</td>
</tr>
<tr id="row848950781093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1895710187093522"><a name="p1895710187093522"></a><a name="p1895710187093522"></a><a href="graphic.md#ga831167c9f5000af808638eac56d6ec19">OHOS::UIImageAnimatorView::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p89083476093522"><a name="p89083476093522"></a><a name="p89083476093522"></a>UIViewType </p>
<p id="p1715573336093522"><a name="p1715573336093522"></a><a name="p1715573336093522"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row1366026226093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p555680316093522"><a name="p555680316093522"></a><a name="p555680316093522"></a><a href="graphic.md#ga6d585adbcbd0d236df848b48ff1b7ece">OHOS::UIImageAnimatorView::SetImageAnimatorSrc</a> (const char *imageSrc, uint8_t imageNum, uint16_t timeOfUpdate)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1207531600093522"><a name="p1207531600093522"></a><a name="p1207531600093522"></a>void </p>
<p id="p1743286368093522"><a name="p1743286368093522"></a><a name="p1743286368093522"></a>Sets the images and speed for this animator. </p>
</td>
</tr>
<tr id="row1540576631093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1847279646093522"><a name="p1847279646093522"></a><a name="p1847279646093522"></a><a href="graphic.md#ga4b2c4bc9d0ab881439d5ec728adc0b1a">OHOS::UIImageAnimatorView::SetImageAnimatorSrc</a> (const char *imageSrc, uint8_t imageNum)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2007780028093522"><a name="p2007780028093522"></a><a name="p2007780028093522"></a>void </p>
<p id="p1784830224093522"><a name="p1784830224093522"></a><a name="p1784830224093522"></a>Sets the images for this animator. </p>
</td>
</tr>
<tr id="row1370735833093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p599439293093522"><a name="p599439293093522"></a><a name="p599439293093522"></a><a href="graphic.md#ga0ee52a2ca252957199034c1234dc4f64">OHOS::UIImageAnimatorView::SetTimeOfUpdate</a> (uint16_t timeOfUpdate)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p499988397093522"><a name="p499988397093522"></a><a name="p499988397093522"></a>void </p>
<p id="p1750978690093522"><a name="p1750978690093522"></a><a name="p1750978690093522"></a>Sets the speed for this animator. </p>
</td>
</tr>
<tr id="row739382563093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p568489837093522"><a name="p568489837093522"></a><a name="p568489837093522"></a><a href="graphic.md#ga24411b0b4d9f619532aa879ee6ee7af1">OHOS::UIImageAnimatorView::GetTimeOfUpdate</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1544354553093522"><a name="p1544354553093522"></a><a name="p1544354553093522"></a>uint16_t </p>
<p id="p706934579093522"><a name="p706934579093522"></a><a name="p706934579093522"></a>Obtains the speed of this animator. </p>
</td>
</tr>
<tr id="row1481586737093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1345987685093522"><a name="p1345987685093522"></a><a name="p1345987685093522"></a><a href="graphic.md#gad4bd7aaf1100aac86a2cde8728ae8ee0">OHOS::UIImageAnimatorView::SetTimeOfPause</a> (uint16_t timeOfPause)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p224506097093522"><a name="p224506097093522"></a><a name="p224506097093522"></a>void </p>
<p id="p1506429199093522"><a name="p1506429199093522"></a><a name="p1506429199093522"></a>Sets the interval between two playbacks of an infinitely repeated animator. </p>
</td>
</tr>
<tr id="row2140518995093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2019936167093522"><a name="p2019936167093522"></a><a name="p2019936167093522"></a><a href="graphic.md#ga8bd6ba744209193fd1f3e630e6cf1c5a">OHOS::UIImageAnimatorView::GetTimeOfPause</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1564042911093522"><a name="p1564042911093522"></a><a name="p1564042911093522"></a>uint16_t </p>
<p id="p303738841093522"><a name="p303738841093522"></a><a name="p303738841093522"></a>Obtains the interval between two playbacks of an infinitely repeated animator. </p>
</td>
</tr>
<tr id="row1150317768093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1638910575093522"><a name="p1638910575093522"></a><a name="p1638910575093522"></a><a href="graphic.md#gadc1064a27f9b95a2797c33793b2110ee">OHOS::UIImageAnimatorView::GetImageAnimatorSrc</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p873571338093522"><a name="p873571338093522"></a><a name="p873571338093522"></a>const <a href="ohos-imageanimatorinfo.md">ImageAnimatorInfo</a> * </p>
<p id="p242508426093522"><a name="p242508426093522"></a><a name="p242508426093522"></a>Obtains the image array of this frame animator. </p>
</td>
</tr>
<tr id="row558532975093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p557203913093522"><a name="p557203913093522"></a><a name="p557203913093522"></a><a href="graphic.md#ga1da191cab1e6b4ffb3a87b50fbe4f7ed">OHOS::UIImageAnimatorView::GetImageAnimatorImageNum</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2000597637093522"><a name="p2000597637093522"></a><a name="p2000597637093522"></a>uint8_t </p>
<p id="p1663982768093522"><a name="p1663982768093522"></a><a name="p1663982768093522"></a>Obtains the number of images. </p>
</td>
</tr>
<tr id="row365676005093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1526916639093522"><a name="p1526916639093522"></a><a name="p1526916639093522"></a><a href="graphic.md#ga0e41547fd9d55ff85d6b800e59957370">OHOS::UIImageAnimatorView::SetSizeFixed</a> (bool fixed)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p26261746093522"><a name="p26261746093522"></a><a name="p26261746093522"></a>void </p>
<p id="p699989847093522"><a name="p699989847093522"></a><a name="p699989847093522"></a>Sets whether the image size is fixed to the view size. </p>
</td>
</tr>
<tr id="row1408658087093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1227441157093522"><a name="p1227441157093522"></a><a name="p1227441157093522"></a><a href="graphic.md#gabf4bad201ee9ef8aa484677b1daa3ba4">OHOS::UIImageAnimatorView::IsSizeFixed</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p339586910093522"><a name="p339586910093522"></a><a name="p339586910093522"></a>bool </p>
<p id="p667362737093522"><a name="p667362737093522"></a><a name="p667362737093522"></a>Checks whether the image size is fixed to the view size. </p>
</td>
</tr>
<tr id="row250614081093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p310224638093522"><a name="p310224638093522"></a><a name="p310224638093522"></a><a href="graphic.md#ga0368d596c01e1a6093d7476fce548a38">OHOS::UIImageAnimatorView::SetRepeat</a> (bool repeat)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2115462371093522"><a name="p2115462371093522"></a><a name="p2115462371093522"></a>void </p>
<p id="p1927146958093522"><a name="p1927146958093522"></a><a name="p1927146958093522"></a>Sets whether to play this animator for infinite times. </p>
</td>
</tr>
<tr id="row410902880093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p889244889093522"><a name="p889244889093522"></a><a name="p889244889093522"></a><a href="graphic.md#ga5e3700fe3d572ed6329237480bd4b5d2">OHOS::UIImageAnimatorView::IsRepeat</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p177662312093522"><a name="p177662312093522"></a><a name="p177662312093522"></a>bool </p>
<p id="p970865906093522"><a name="p970865906093522"></a><a name="p970865906093522"></a>Checks whether this animator is played for infinite times. </p>
</td>
</tr>
<tr id="row1760438537093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1785341790093522"><a name="p1785341790093522"></a><a name="p1785341790093522"></a><a href="graphic.md#ga8d0a02c46af6bea17323c715620b6212">OHOS::UIImageAnimatorView::SetRepeatTimes</a> (uint32_t <a href="en-us_topic_0000001054879478.md#gad8751576e987b576f4e6e42f9b42fec9">times</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p273632551093522"><a name="p273632551093522"></a><a name="p273632551093522"></a>void </p>
<p id="p970999635093522"><a name="p970999635093522"></a><a name="p970999635093522"></a>Sets the playback times for this animator. </p>
</td>
</tr>
<tr id="row1910208663093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1336399276093522"><a name="p1336399276093522"></a><a name="p1336399276093522"></a><a href="graphic.md#gae900ab627983fb255dc0d1672c1f3a03">OHOS::UIImageAnimatorView::GetRepeatTimes</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p563945063093522"><a name="p563945063093522"></a><a name="p563945063093522"></a>uint32_t </p>
<p id="p1779284706093522"><a name="p1779284706093522"></a><a name="p1779284706093522"></a>Obtains the playback times. </p>
</td>
</tr>
<tr id="row365126995093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p343079768093522"><a name="p343079768093522"></a><a name="p343079768093522"></a><a href="graphic.md#gaad46659a26146d0edccad42f45f85d6c">OHOS::UIImageAnimatorView::GetState</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p497652927093522"><a name="p497652927093522"></a><a name="p497652927093522"></a>uint8_t </p>
<p id="p677286744093522"><a name="p677286744093522"></a><a name="p677286744093522"></a>Obtains the current state of this animator. </p>
</td>
</tr>
<tr id="row859822548093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2140876202093522"><a name="p2140876202093522"></a><a name="p2140876202093522"></a><a href="graphic.md#ga38a53936c930f4d75ccd9d9c6a5b9afa">OHOS::UIImageAnimatorView::SetReverse</a> (bool reverse)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1907403279093522"><a name="p1907403279093522"></a><a name="p1907403279093522"></a>void </p>
<p id="p356598797093522"><a name="p356598797093522"></a><a name="p356598797093522"></a>Sets the playback sequence for this animator. </p>
</td>
</tr>
<tr id="row580409647093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p313790553093522"><a name="p313790553093522"></a><a name="p313790553093522"></a><a href="graphic.md#ga35b508048046b7adf938de5cc4004724">OHOS::UIImageAnimatorView::IsReverse</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p774910474093522"><a name="p774910474093522"></a><a name="p774910474093522"></a>bool </p>
<p id="p1778694128093522"><a name="p1778694128093522"></a><a name="p1778694128093522"></a>Obtains the playback sequence of this animator. </p>
</td>
</tr>
<tr id="row2077037854093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p227980772093522"><a name="p227980772093522"></a><a name="p227980772093522"></a><a href="graphic.md#ga99fb1b9b27ee65f812085f93e05330a6">OHOS::UIImageAnimatorView::Start</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p829155550093522"><a name="p829155550093522"></a><a name="p829155550093522"></a>void </p>
<p id="p856329410093522"><a name="p856329410093522"></a><a name="p856329410093522"></a>Starts this animator. </p>
</td>
</tr>
<tr id="row1261887833093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1427063154093522"><a name="p1427063154093522"></a><a name="p1427063154093522"></a><a href="graphic.md#ga1887f1afd8e85c0a9c781e182fe5afc3">OHOS::UIImageAnimatorView::Stop</a> (bool needReset=true)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1135030066093522"><a name="p1135030066093522"></a><a name="p1135030066093522"></a>void </p>
<p id="p330883184093522"><a name="p330883184093522"></a><a name="p330883184093522"></a>Stops this animator. </p>
</td>
</tr>
<tr id="row1830591386093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p260822656093522"><a name="p260822656093522"></a><a name="p260822656093522"></a><a href="graphic.md#gab8af32245cdf31fcc0a9d0a5d681774c">OHOS::UIImageAnimatorView::Pause</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p99955585093522"><a name="p99955585093522"></a><a name="p99955585093522"></a>void </p>
<p id="p991782235093522"><a name="p991782235093522"></a><a name="p991782235093522"></a>Pauses this animator at the current image. </p>
</td>
</tr>
<tr id="row869021757093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1843467061093522"><a name="p1843467061093522"></a><a name="p1843467061093522"></a><a href="graphic.md#ga051f03136d8c00295162f53acbe6da97">OHOS::UIImageAnimatorView::Resume</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p110231883093522"><a name="p110231883093522"></a><a name="p110231883093522"></a>void </p>
<p id="p1827956378093522"><a name="p1827956378093522"></a><a name="p1827956378093522"></a>Resumes this animator from the current image. </p>
</td>
</tr>
<tr id="row915076161093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p856400458093522"><a name="p856400458093522"></a><a name="p856400458093522"></a><a href="graphic.md#gaafa8a44fe38db14ab7e8f72e4d3c8581">OHOS::UIImageAnimatorView::AnimatorStopListener::~AnimatorStopListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1966279780093522"><a name="p1966279780093522"></a><a name="p1966279780093522"></a>virtual </p>
<p id="p573724597093522"><a name="p573724597093522"></a><a name="p573724597093522"></a>A destructor used to delete an <strong id="b1954927772093522"><a name="b1954927772093522"></a><a name="b1954927772093522"></a><a href="ohos-uiimageanimatorview-animatorstoplistener.md">AnimatorStopListener</a></strong> instance. </p>
</td>
</tr>
<tr id="row1502679556093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p302515901093522"><a name="p302515901093522"></a><a name="p302515901093522"></a><a href="graphic.md#gac5f2c1471f83ebf2a47d86b8f58da094">OHOS::UIImageAnimatorView::AnimatorStopListener::OnAnimatorStop</a> (<a href="ohos-uiview.md">UIView</a> &amp;view)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1661553663093522"><a name="p1661553663093522"></a><a name="p1661553663093522"></a>virtual void </p>
<p id="p529381571093522"><a name="p529381571093522"></a><a name="p529381571093522"></a>Called when this animator stops. </p>
</td>
</tr>
<tr id="row702700651093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p952769894093522"><a name="p952769894093522"></a><a name="p952769894093522"></a><a href="graphic.md#ga80b4b917c30226c1b1f7169e3eb8ed8d">OHOS::UIImageAnimatorView::SetAnimatorStopListener</a> (<a href="ohos-uiimageanimatorview-animatorstoplistener.md">AnimatorStopListener</a> *listener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p415460184093522"><a name="p415460184093522"></a><a name="p415460184093522"></a>void </p>
<p id="p1389770748093522"><a name="p1389770748093522"></a><a name="p1389770748093522"></a>Sets the listener for the stop of this animator. </p>
</td>
</tr>
<tr id="row79706122093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p531437537093522"><a name="p531437537093522"></a><a name="p531437537093522"></a><a href="graphic.md#ga3db47186dbc7a0cb996c23abcdaf2c38">OHOS::UIImageView::UIImageView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p861673532093522"><a name="p861673532093522"></a><a name="p861673532093522"></a> </p>
<p id="p1354690343093522"><a name="p1354690343093522"></a><a name="p1354690343093522"></a>A default constructor used to create a <strong id="b1509104604093522"><a name="b1509104604093522"></a><a name="b1509104604093522"></a><a href="ohos-uiimageview.md">UIImageView</a></strong> instance. </p>
</td>
</tr>
<tr id="row711189527093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p227475293093522"><a name="p227475293093522"></a><a name="p227475293093522"></a><a href="graphic.md#ga8be6fe17af73ab21f97effa26dbacaca">OHOS::UIImageView::~UIImageView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1336659920093522"><a name="p1336659920093522"></a><a name="p1336659920093522"></a>virtual </p>
<p id="p758926018093522"><a name="p758926018093522"></a><a name="p758926018093522"></a>A destructor used to delete the <strong id="b14459452093522"><a name="b14459452093522"></a><a name="b14459452093522"></a><a href="ohos-uiimageview.md">UIImageView</a></strong> instance. </p>
</td>
</tr>
<tr id="row1927353471093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p338570545093522"><a name="p338570545093522"></a><a name="p338570545093522"></a><a href="graphic.md#ga5dc99855271c582e960e0952cca8227c">OHOS::UIImageView::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p797365926093522"><a name="p797365926093522"></a><a name="p797365926093522"></a>UIViewType </p>
<p id="p1655077434093522"><a name="p1655077434093522"></a><a name="p1655077434093522"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row728571507093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2004521616093522"><a name="p2004521616093522"></a><a name="p2004521616093522"></a><a href="graphic.md#ga20ea7dd2d8ddb16cf9750ccdcc2a2803">OHOS::UIImageView::GetWidth</a> () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1909720848093522"><a name="p1909720848093522"></a><a name="p1909720848093522"></a>int16_t </p>
<p id="p22327596093522"><a name="p22327596093522"></a><a name="p22327596093522"></a>Obtains the width of this image view. </p>
</td>
</tr>
<tr id="row1776435320093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p263752066093522"><a name="p263752066093522"></a><a name="p263752066093522"></a><a href="graphic.md#gaddc6e68c67782eaad40977c6c2256cdd">OHOS::UIImageView::GetHeight</a> () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p450931356093522"><a name="p450931356093522"></a><a name="p450931356093522"></a>int16_t </p>
<p id="p183396005093522"><a name="p183396005093522"></a><a name="p183396005093522"></a>Obtains the height of this image view. </p>
</td>
</tr>
<tr id="row1580157975093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1509468820093522"><a name="p1509468820093522"></a><a name="p1509468820093522"></a><a href="graphic.md#ga5d79816831f61406c1c8bd300da9973e">OHOS::UIImageView::OnPreDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1931497791093522"><a name="p1931497791093522"></a><a name="p1931497791093522"></a>bool </p>
<p id="p752001481093522"><a name="p752001481093522"></a><a name="p752001481093522"></a>Checks whether this image view needs to be covered to optimize the drawing process. </p>
</td>
</tr>
<tr id="row268274307093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p523923649093522"><a name="p523923649093522"></a><a name="p523923649093522"></a><a href="graphic.md#ga565cecb8ac66f2009dc4783da9bdc699">OHOS::UIImageView::OnDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p426920727093522"><a name="p426920727093522"></a><a name="p426920727093522"></a>void </p>
<p id="p2002976242093522"><a name="p2002976242093522"></a><a name="p2002976242093522"></a>Draws this image view. </p>
</td>
</tr>
<tr id="row912981040093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p213284037093522"><a name="p213284037093522"></a><a name="p213284037093522"></a><a href="graphic.md#ga4e2dac4fd52a54a828f13db5ab51d110">OHOS::UIImageView::SetSrc</a> (const char *src)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p971026698093522"><a name="p971026698093522"></a><a name="p971026698093522"></a>void </p>
<p id="p569528115093522"><a name="p569528115093522"></a><a name="p569528115093522"></a>Sets the image path. </p>
</td>
</tr>
<tr id="row1225214555093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1832823867093522"><a name="p1832823867093522"></a><a name="p1832823867093522"></a><a href="graphic.md#ga18a9eed434132ac60c127ca1fc03e663">OHOS::UIImageView::SetSrc</a> (const <a href="ohos-imageinfo.md">ImageInfo</a> *src)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1615063461093522"><a name="p1615063461093522"></a><a name="p1615063461093522"></a>void </p>
<p id="p749148524093522"><a name="p749148524093522"></a><a name="p749148524093522"></a>Sets the image information. </p>
</td>
</tr>
<tr id="row2039843817093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1939673514093522"><a name="p1939673514093522"></a><a name="p1939673514093522"></a><a href="graphic.md#gab3f60d7eff9b467c64edc90293dbb21d">OHOS::UIImageView::SetAutoEnable</a> (bool enable)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2038237173093522"><a name="p2038237173093522"></a><a name="p2038237173093522"></a>void </p>
<p id="p2007173375093522"><a name="p2007173375093522"></a><a name="p2007173375093522"></a>Sets whether the image view size needs to be adaptive to the image size. </p>
</td>
</tr>
<tr id="row729054344093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1105432351093522"><a name="p1105432351093522"></a><a name="p1105432351093522"></a><a href="graphic.md#ga339c80c2f8f05ff0d79638dc61c71d5a">OHOS::UIImageView::SetBlurLevel</a> (BlurLevel level)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p180903030093522"><a name="p180903030093522"></a><a name="p180903030093522"></a>void </p>
<p id="p1132159117093522"><a name="p1132159117093522"></a><a name="p1132159117093522"></a>Sets the blur level for this image when it is rotated or scaled. </p>
</td>
</tr>
<tr id="row388120043093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1685589550093522"><a name="p1685589550093522"></a><a name="p1685589550093522"></a><a href="graphic.md#ga8c891ce7719b97f6d49b0554caa371cb">OHOS::UIImageView::GetBlurLevel</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p241437426093522"><a name="p241437426093522"></a><a name="p241437426093522"></a>BlurLevel </p>
<p id="p1097895930093522"><a name="p1097895930093522"></a><a name="p1097895930093522"></a>Obtains the blur level of this image when it is rotated or scaled. </p>
</td>
</tr>
<tr id="row733665879093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1898873133093522"><a name="p1898873133093522"></a><a name="p1898873133093522"></a><a href="graphic.md#gacd3bafd7cd7dfb83d46d4fae36eae612">OHOS::UIImageView::SetTransformAlgorithm</a> (TransformAlgorithm algorithm)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p915928667093522"><a name="p915928667093522"></a><a name="p915928667093522"></a>void </p>
<p id="p1439908913093522"><a name="p1439908913093522"></a><a name="p1439908913093522"></a>Sets the algorithm used for image rotation and scaling. </p>
</td>
</tr>
<tr id="row1791429838093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p854341861093522"><a name="p854341861093522"></a><a name="p854341861093522"></a><a href="graphic.md#gac7b75c6fa653d3ac0c8bc9062939d293">OHOS::UIImageView::GetTransformAlgorithm</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1635266501093522"><a name="p1635266501093522"></a><a name="p1635266501093522"></a>TransformAlgorithm </p>
<p id="p1491004622093522"><a name="p1491004622093522"></a><a name="p1491004622093522"></a>Obtains the algorithm used for image rotation and scaling. </p>
</td>
</tr>
<tr id="row65440731093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1189090706093522"><a name="p1189090706093522"></a><a name="p1189090706093522"></a><a href="graphic.md#ga3824befafd4f4dda003195ca2bbef399">OHOS::UIImageView::GetPath</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p12589549093522"><a name="p12589549093522"></a><a name="p12589549093522"></a>const char * </p>
<p id="p1382371775093522"><a name="p1382371775093522"></a><a name="p1382371775093522"></a>Obtains the image path.</p>
</td>
</tr>
<tr id="row403723790093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p829450542093522"><a name="p829450542093522"></a><a name="p829450542093522"></a><a href="graphic.md#gaa9fbde27be3e3ea2fc6b4dabbf588af8">OHOS::UIImageView::GetImageInfo</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1948841219093522"><a name="p1948841219093522"></a><a name="p1948841219093522"></a>const <a href="ohos-imageinfo.md">ImageInfo</a> * </p>
<p id="p1828369840093522"><a name="p1828369840093522"></a><a name="p1828369840093522"></a>Obtains image information.</p>
</td>
</tr>
<tr id="row1196449875093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1773483997093522"><a name="p1773483997093522"></a><a name="p1773483997093522"></a><a href="graphic.md#ga07da08c8507a3dbee5c21ea0de170a16">OHOS::UIImageView::GetSrcType</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p708106754093522"><a name="p708106754093522"></a><a name="p708106754093522"></a>uint8_t </p>
<p id="p2147373348093522"><a name="p2147373348093522"></a><a name="p2147373348093522"></a>Obtains the image type.</p>
</td>
</tr>
<tr id="row759388837093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p517133914093522"><a name="p517133914093522"></a><a name="p517133914093522"></a><a href="graphic.md#ga7e145ba3fb7b78ecefa1018a9540be32">OHOS::UILabel::UILabel</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1621757446093522"><a name="p1621757446093522"></a><a name="p1621757446093522"></a> </p>
<p id="p1090269443093522"><a name="p1090269443093522"></a><a name="p1090269443093522"></a>A constructor used to create a <strong id="b1291892990093522"><a name="b1291892990093522"></a><a name="b1291892990093522"></a><a href="ohos-uilabel.md">UILabel</a></strong> instance. </p>
</td>
</tr>
<tr id="row1407075277093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1492952388093522"><a name="p1492952388093522"></a><a name="p1492952388093522"></a><a href="graphic.md#ga8509fa2391e0ddd37faed27e35845fc5">OHOS::UILabel::~UILabel</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p56400817093522"><a name="p56400817093522"></a><a name="p56400817093522"></a>virtual </p>
<p id="p1983471353093522"><a name="p1983471353093522"></a><a name="p1983471353093522"></a>A destructor used to delete the <strong id="b1645211425093522"><a name="b1645211425093522"></a><a name="b1645211425093522"></a><a href="ohos-uilabel.md">UILabel</a></strong> instance. </p>
</td>
</tr>
<tr id="row995463566093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p354309765093522"><a name="p354309765093522"></a><a name="p354309765093522"></a><a href="graphic.md#gaebb514dc68a761c444af0e0e89dfcb6f">OHOS::UILabel::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p541456701093522"><a name="p541456701093522"></a><a name="p541456701093522"></a>UIViewType </p>
<p id="p1459374579093522"><a name="p1459374579093522"></a><a name="p1459374579093522"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row302685796093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1301433483093522"><a name="p1301433483093522"></a><a name="p1301433483093522"></a><a href="graphic.md#ga95bc777cda044ada4401d9c5900226c6">OHOS::UILabel::GetWidth</a> () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p93538134093522"><a name="p93538134093522"></a><a name="p93538134093522"></a>int16_t </p>
<p id="p513590757093522"><a name="p513590757093522"></a><a name="p513590757093522"></a>Obtains the width of this label. </p>
</td>
</tr>
<tr id="row1646677933093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1797925181093522"><a name="p1797925181093522"></a><a name="p1797925181093522"></a><a href="graphic.md#ga148f6d32ed06364dbee0190f6ff77b59">OHOS::UILabel::GetHeight</a> () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1744714551093522"><a name="p1744714551093522"></a><a name="p1744714551093522"></a>int16_t </p>
<p id="p1692134133093522"><a name="p1692134133093522"></a><a name="p1692134133093522"></a>Obtains the height of this label. </p>
</td>
</tr>
<tr id="row244839982093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1426778088093522"><a name="p1426778088093522"></a><a name="p1426778088093522"></a><a href="graphic.md#gaac293fb7f318e1855fba21b740147061">OHOS::UILabel::OnPreDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1512027958093522"><a name="p1512027958093522"></a><a name="p1512027958093522"></a>bool </p>
<p id="p1521001427093522"><a name="p1521001427093522"></a><a name="p1521001427093522"></a>Checks whether this label needs to be covered before drawing it. </p>
</td>
</tr>
<tr id="row964550006093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1977824211093522"><a name="p1977824211093522"></a><a name="p1977824211093522"></a><a href="graphic.md#ga911199741bf792b5de00789b4c8d780d">OHOS::UILabel::OnDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2112266043093522"><a name="p2112266043093522"></a><a name="p2112266043093522"></a>void </p>
<p id="p1200162454093522"><a name="p1200162454093522"></a><a name="p1200162454093522"></a>Draws this label. </p>
</td>
</tr>
<tr id="row561702363093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1583226631093522"><a name="p1583226631093522"></a><a name="p1583226631093522"></a><a href="graphic.md#gab1f3eafda465d09aaa886f09db7e47c1">OHOS::UILabel::SetText</a> (const char *text)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1039025530093522"><a name="p1039025530093522"></a><a name="p1039025530093522"></a>void </p>
<p id="p1714158050093522"><a name="p1714158050093522"></a><a name="p1714158050093522"></a>Sets the text content for this label. </p>
</td>
</tr>
<tr id="row2060687870093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p691028858093522"><a name="p691028858093522"></a><a name="p691028858093522"></a><a href="graphic.md#gafa76232f16f5aad2a84fedbb31c4f0f7">OHOS::UILabel::GetText</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1212952244093522"><a name="p1212952244093522"></a><a name="p1212952244093522"></a>const char * </p>
<p id="p390422353093522"><a name="p390422353093522"></a><a name="p390422353093522"></a>Obtains the text of this label. </p>
</td>
</tr>
<tr id="row1466370366093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1068001820093522"><a name="p1068001820093522"></a><a name="p1068001820093522"></a><a href="graphic.md#ga406c7972fbf4950aaa8c4cef8c86acc5">OHOS::UILabel::SetLineBreakMode</a> (const uint8_t lineBreakMode)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1391123945093522"><a name="p1391123945093522"></a><a name="p1391123945093522"></a>void </p>
<p id="p1921165388093522"><a name="p1921165388093522"></a><a name="p1921165388093522"></a>Sets the line break mode for this text. </p>
</td>
</tr>
<tr id="row131386280093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1673706673093522"><a name="p1673706673093522"></a><a name="p1673706673093522"></a><a href="graphic.md#gab8924e40668b2c882d5dac624b49c6e8">OHOS::UILabel::GetLineBreakMode</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1650245375093522"><a name="p1650245375093522"></a><a name="p1650245375093522"></a>uint8_t </p>
<p id="p48011637093522"><a name="p48011637093522"></a><a name="p48011637093522"></a>Obtains the line break mode of this text. </p>
</td>
</tr>
<tr id="row750569209093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p380688933093522"><a name="p380688933093522"></a><a name="p380688933093522"></a><a href="graphic.md#ga07e45127ac9569064beb2a63753d2673">OHOS::UILabel::SetTextColor</a> (<a href="ohos-color32.md">ColorType</a> color)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1124640720093522"><a name="p1124640720093522"></a><a name="p1124640720093522"></a>void </p>
<p id="p1688189466093522"><a name="p1688189466093522"></a><a name="p1688189466093522"></a>Sets the color for this text. </p>
</td>
</tr>
<tr id="row1942172280093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p978926413093522"><a name="p978926413093522"></a><a name="p978926413093522"></a><a href="graphic.md#ga963236ec609ea50610f7ef2bf85ea6df">OHOS::UILabel::GetTextColor</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1048473992093522"><a name="p1048473992093522"></a><a name="p1048473992093522"></a><a href="ohos-color32.md">ColorType</a> </p>
<p id="p326731422093522"><a name="p326731422093522"></a><a name="p326731422093522"></a>Obtains the color of this text. </p>
</td>
</tr>
<tr id="row1887410341093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1135618319093522"><a name="p1135618319093522"></a><a name="p1135618319093522"></a><a href="graphic.md#ga889e1adc1a74db59dc161cb7031b1f23">OHOS::UILabel::SetAlign</a> (<a href="graphic.md#ga3f99b58f731a37cacde72d5e0c934593">UITextLanguageAlignment</a> horizontalAlign, <a href="graphic.md#ga3f99b58f731a37cacde72d5e0c934593">UITextLanguageAlignment</a> verticalAlign=TEXT_ALIGNMENT_TOP)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1176593825093522"><a name="p1176593825093522"></a><a name="p1176593825093522"></a>void </p>
<p id="p898652432093522"><a name="p898652432093522"></a><a name="p898652432093522"></a>Sets the alignment mode for this text. </p>
</td>
</tr>
<tr id="row205506288093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p395883386093522"><a name="p395883386093522"></a><a name="p395883386093522"></a><a href="graphic.md#ga97a9af1537884de541336633edc54c72">OHOS::UILabel::GetHorAlign</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1829172641093522"><a name="p1829172641093522"></a><a name="p1829172641093522"></a><a href="graphic.md#ga3f99b58f731a37cacde72d5e0c934593">UITextLanguageAlignment</a> </p>
<p id="p963100053093522"><a name="p963100053093522"></a><a name="p963100053093522"></a>Obtains the horizontal alignment mode. </p>
</td>
</tr>
<tr id="row1258417495093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p460422476093522"><a name="p460422476093522"></a><a name="p460422476093522"></a><a href="graphic.md#gaf4acdd488481fe6ce0e79eb6a9d35d78">OHOS::UILabel::GetVerAlign</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p696328974093522"><a name="p696328974093522"></a><a name="p696328974093522"></a><a href="graphic.md#ga3f99b58f731a37cacde72d5e0c934593">UITextLanguageAlignment</a> </p>
<p id="p1577257360093522"><a name="p1577257360093522"></a><a name="p1577257360093522"></a>Obtains the vertical alignment mode. </p>
</td>
</tr>
<tr id="row1866971062093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p20750887093522"><a name="p20750887093522"></a><a name="p20750887093522"></a><a href="graphic.md#ga51d43cfa57f438939627066d66a3f6cb">OHOS::UILabel::SetDirect</a> (<a href="graphic.md#ga0c108f97781843f67c101b47b6c00cf0">UITextLanguageDirect</a> direct)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p702105024093522"><a name="p702105024093522"></a><a name="p702105024093522"></a>void </p>
<p id="p1494818466093522"><a name="p1494818466093522"></a><a name="p1494818466093522"></a>Sets the direction for this text. </p>
</td>
</tr>
<tr id="row550123738093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2070406702093522"><a name="p2070406702093522"></a><a name="p2070406702093522"></a><a href="graphic.md#gab7bbf711b9cd21935a29c4183c249d80">OHOS::UILabel::GetDirect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1997798995093522"><a name="p1997798995093522"></a><a name="p1997798995093522"></a><a href="graphic.md#ga0c108f97781843f67c101b47b6c00cf0">UITextLanguageDirect</a> </p>
<p id="p1734019661093522"><a name="p1734019661093522"></a><a name="p1734019661093522"></a>Obtains the direction of this text. </p>
</td>
</tr>
<tr id="row819472728093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p339966732093522"><a name="p339966732093522"></a><a name="p339966732093522"></a><a href="graphic.md#gaf8b585ae9aa99d4876e1d81c8b193300">OHOS::UILabel::SetFontId</a> (uint8_t fontId)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p442411365093522"><a name="p442411365093522"></a><a name="p442411365093522"></a>void </p>
<p id="p2084171033093522"><a name="p2084171033093522"></a><a name="p2084171033093522"></a>Sets the font ID for this label. </p>
</td>
</tr>
<tr id="row1782848507093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p558402999093522"><a name="p558402999093522"></a><a name="p558402999093522"></a><a href="graphic.md#ga8484c4167b7638b2bbaa10ba447c9a2f">OHOS::UILabel::GetFontId</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p982466512093522"><a name="p982466512093522"></a><a name="p982466512093522"></a>uint8_t </p>
<p id="p1888489014093522"><a name="p1888489014093522"></a><a name="p1888489014093522"></a>Obtains the font ID composed of font name and size. </p>
</td>
</tr>
<tr id="row1544965832093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p102814646093522"><a name="p102814646093522"></a><a name="p102814646093522"></a><a href="graphic.md#gad4b6741054c0041c6df365b1d41d49ec">OHOS::UILabel::SetFont</a> (const char *name, uint8_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1061984601093522"><a name="p1061984601093522"></a><a name="p1061984601093522"></a>void </p>
<p id="p578499819093522"><a name="p578499819093522"></a><a name="p578499819093522"></a>Sets the font for this label. </p>
</td>
</tr>
<tr id="row29604681093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1526141015093522"><a name="p1526141015093522"></a><a name="p1526141015093522"></a><a href="graphic.md#gaf95611590551b86e5e49efce1cab5069">OHOS::UILabel::SetRollSpeed</a> (uint16_t speed)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p480474275093522"><a name="p480474275093522"></a><a name="p480474275093522"></a>void </p>
<p id="p616552085093522"><a name="p616552085093522"></a><a name="p616552085093522"></a>Sets the scroll speed for this text. </p>
</td>
</tr>
<tr id="row1095192355093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1300638639093522"><a name="p1300638639093522"></a><a name="p1300638639093522"></a><a href="graphic.md#gaff1afb0c1079bbab70c0f012ba62ea88">OHOS::UILabel::GetTextWidth</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1580335318093522"><a name="p1580335318093522"></a><a name="p1580335318093522"></a>uint16_t </p>
<p id="p256713511093522"><a name="p256713511093522"></a><a name="p256713511093522"></a>Obtains the width of this text. </p>
</td>
</tr>
<tr id="row1324462752093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1448062668093522"><a name="p1448062668093522"></a><a name="p1448062668093522"></a><a href="graphic.md#gaecbce6ea5599f99b1a2b150608cfc9e3">OHOS::UILabel::GetTextHeight</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1875214465093522"><a name="p1875214465093522"></a><a name="p1875214465093522"></a>uint16_t </p>
<p id="p1514824552093522"><a name="p1514824552093522"></a><a name="p1514824552093522"></a>Obtains the height of this text. </p>
</td>
</tr>
<tr id="row987825551093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1120711020093522"><a name="p1120711020093522"></a><a name="p1120711020093522"></a><a href="graphic.md#gaeb4eb6f2b82574eb005fdbf17b0b926b">OHOS::UILabel::SetRollStartPos</a> (int16_t pos)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1916731759093522"><a name="p1916731759093522"></a><a name="p1916731759093522"></a>void </p>
<p id="p1184282130093522"><a name="p1184282130093522"></a><a name="p1184282130093522"></a>Sets the position where this text starts to roll. </p>
</td>
</tr>
<tr id="row1061547013093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1163338930093522"><a name="p1163338930093522"></a><a name="p1163338930093522"></a><a href="graphic.md#gaa2bb611ed34bcb9fc5eb2d208409ab7a">OHOS::UILabel::GetRollStartPos</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p34059809093522"><a name="p34059809093522"></a><a name="p34059809093522"></a>int16_t </p>
<p id="p428103882093522"><a name="p428103882093522"></a><a name="p428103882093522"></a>Obtains the position where this text starts to roll. </p>
</td>
</tr>
<tr id="row1820013683093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1792926760093522"><a name="p1792926760093522"></a><a name="p1792926760093522"></a><a href="graphic.md#ga4000481fca247d526961d9da6809a806">OHOS::UILabel::SetWidth</a> (int16_t width) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p206100474093522"><a name="p206100474093522"></a><a name="p206100474093522"></a>void </p>
<p id="p1246837434093522"><a name="p1246837434093522"></a><a name="p1246837434093522"></a>Sets the width for this label. </p>
</td>
</tr>
<tr id="row933238549093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1959893381093522"><a name="p1959893381093522"></a><a name="p1959893381093522"></a><a href="graphic.md#ga9998ddd0dfc0863d31f931a76f1da033">OHOS::UILabel::SetHeight</a> (int16_t height) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p747842513093522"><a name="p747842513093522"></a><a name="p747842513093522"></a>void </p>
<p id="p1376834409093522"><a name="p1376834409093522"></a><a name="p1376834409093522"></a>Sets the height for this label. </p>
</td>
</tr>
<tr id="row59751242093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p160310800093522"><a name="p160310800093522"></a><a name="p160310800093522"></a><a href="graphic.md#ga3c8eb22a51f4ec16640f5003c32d0341">OHOS::UILabel::SetTextRotation</a> (LabelRotateDegree angle)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p655871971093522"><a name="p655871971093522"></a><a name="p655871971093522"></a>void </p>
<p id="p152883567093522"><a name="p152883567093522"></a><a name="p152883567093522"></a>Sets the clockwise rotation angle for this text. </p>
</td>
</tr>
<tr id="row562119590093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1020575183093522"><a name="p1020575183093522"></a><a name="p1020575183093522"></a><a href="graphic.md#ga610cb09fe19aafbb65899b060ee3cac7">OHOS::UILabel::GetTextRotation</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p965846293093522"><a name="p965846293093522"></a><a name="p965846293093522"></a>LabelRotateDegree </p>
<p id="p237698852093522"><a name="p237698852093522"></a><a name="p237698852093522"></a>Obtains the clockwise rotation degree of this text. </p>
</td>
</tr>
<tr id="row546448037093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p29613528093522"><a name="p29613528093522"></a><a name="p29613528093522"></a><a href="graphic.md#gaef9e2e7f3a8849875e2a29e961a7e590">OHOS::UILabel::GetTextRotateDegree</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p351716941093522"><a name="p351716941093522"></a><a name="p351716941093522"></a>uint16_t </p>
<p id="p1918055627093522"><a name="p1918055627093522"></a><a name="p1918055627093522"></a>Obtains the number of text rotation degrees. </p>
</td>
</tr>
<tr id="row2017088261093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p11629494093522"><a name="p11629494093522"></a><a name="p11629494093522"></a><a href="graphic.md#gadf3e53072501ed36700dea74a3ddbd8f">OHOS::UILabelButton::UILabelButton</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p713660629093522"><a name="p713660629093522"></a><a name="p713660629093522"></a> </p>
<p id="p1016306768093522"><a name="p1016306768093522"></a><a name="p1016306768093522"></a>A constructor used to create a <strong id="b817670858093522"><a name="b817670858093522"></a><a name="b817670858093522"></a><a href="ohos-uilabelbutton.md">UILabelButton</a></strong> instance. </p>
</td>
</tr>
<tr id="row529133774093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p881537463093522"><a name="p881537463093522"></a><a name="p881537463093522"></a><a href="graphic.md#ga9c585e4c556a62f44c71d538608544ee">OHOS::UILabelButton::~UILabelButton</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1039041487093522"><a name="p1039041487093522"></a><a name="p1039041487093522"></a>virtual </p>
<p id="p2057795474093522"><a name="p2057795474093522"></a><a name="p2057795474093522"></a>A destructor used to delete the <strong id="b1338013788093522"><a name="b1338013788093522"></a><a name="b1338013788093522"></a><a href="ohos-uilabelbutton.md">UILabelButton</a></strong> instance. </p>
</td>
</tr>
<tr id="row1610174730093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1237968877093522"><a name="p1237968877093522"></a><a name="p1237968877093522"></a><a href="graphic.md#ga159c536c3f826165c26fdabdc87f498a">OHOS::UILabelButton::OnDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p790389365093522"><a name="p790389365093522"></a><a name="p790389365093522"></a>void </p>
<p id="p119958252093522"><a name="p119958252093522"></a><a name="p119958252093522"></a>Draws a label button. </p>
</td>
</tr>
<tr id="row218762111093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1394240251093522"><a name="p1394240251093522"></a><a name="p1394240251093522"></a><a href="graphic.md#ga7064f161dbf0e539bd089db62339cad8">OHOS::UILabelButton::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p451764046093522"><a name="p451764046093522"></a><a name="p451764046093522"></a>UIViewType </p>
<p id="p2110699918093522"><a name="p2110699918093522"></a><a name="p2110699918093522"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row962085624093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1521031673093522"><a name="p1521031673093522"></a><a name="p1521031673093522"></a><a href="graphic.md#ga6b5b491c9240a061fc21cf6b98bdaefc">OHOS::UILabelButton::SetText</a> (const char *text)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1817260595093522"><a name="p1817260595093522"></a><a name="p1817260595093522"></a>void </p>
<p id="p1661338443093522"><a name="p1661338443093522"></a><a name="p1661338443093522"></a>Sets the text for this label button. </p>
</td>
</tr>
<tr id="row1111164107093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1490070819093522"><a name="p1490070819093522"></a><a name="p1490070819093522"></a><a href="graphic.md#ga8d04dd052b36017d89e52be905b50d62">OHOS::UILabelButton::GetText</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1331501977093522"><a name="p1331501977093522"></a><a name="p1331501977093522"></a>const char * </p>
<p id="p922152795093522"><a name="p922152795093522"></a><a name="p922152795093522"></a>Obtains the text of this label button. </p>
</td>
</tr>
<tr id="row1166257103093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p221176444093522"><a name="p221176444093522"></a><a name="p221176444093522"></a><a href="graphic.md#gaf97dc0d36701691a001ef3fd9e6e8b4f">OHOS::UILabelButton::SetLablePosition</a> (int16_t x, int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1947746795093522"><a name="p1947746795093522"></a><a name="p1947746795093522"></a>void </p>
<p id="p1787841822093522"><a name="p1787841822093522"></a><a name="p1787841822093522"></a>Sets the position for this label relative to the button holding it. </p>
</td>
</tr>
<tr id="row1900995978093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1768265571093522"><a name="p1768265571093522"></a><a name="p1768265571093522"></a><a href="graphic.md#gaf98616000ecd2cbb458d59fa77b7fe60">OHOS::UILabelButton::GetLabelPosition</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p486701258093522"><a name="p486701258093522"></a><a name="p486701258093522"></a><a href="ohos-point.md">Point</a> </p>
<p id="p201971843093522"><a name="p201971843093522"></a><a name="p201971843093522"></a>Obtains the position of this label relative to the button holding it. </p>
</td>
</tr>
<tr id="row314242581093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1271719532093522"><a name="p1271719532093522"></a><a name="p1271719532093522"></a><a href="graphic.md#gab5625481e1a9cb77f30102c76ec76bdd">OHOS::UILabelButton::SetAlign</a> (<a href="graphic.md#ga3f99b58f731a37cacde72d5e0c934593">UITextLanguageAlignment</a> align)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p71186052093522"><a name="p71186052093522"></a><a name="p71186052093522"></a>void </p>
<p id="p1590399425093522"><a name="p1590399425093522"></a><a name="p1590399425093522"></a>Sets the alignment mode for this text. </p>
</td>
</tr>
<tr id="row1497904901093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p771483536093522"><a name="p771483536093522"></a><a name="p771483536093522"></a><a href="graphic.md#ga94001af31d34b575be3678f06b77f432">OHOS::UILabelButton::GetAlign</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1209186316093522"><a name="p1209186316093522"></a><a name="p1209186316093522"></a><a href="graphic.md#ga3f99b58f731a37cacde72d5e0c934593">UITextLanguageAlignment</a> </p>
<p id="p1158213715093522"><a name="p1158213715093522"></a><a name="p1158213715093522"></a>Obtains the alignment mode of this text. </p>
</td>
</tr>
<tr id="row1564873643093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2023948203093522"><a name="p2023948203093522"></a><a name="p2023948203093522"></a><a href="graphic.md#gabdea4ed71d6a22492ff423339cc08d5e">OHOS::UILabelButton::SetDirect</a> (<a href="graphic.md#ga0c108f97781843f67c101b47b6c00cf0">UITextLanguageDirect</a> direct)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1366254378093522"><a name="p1366254378093522"></a><a name="p1366254378093522"></a>void </p>
<p id="p1138388705093522"><a name="p1138388705093522"></a><a name="p1138388705093522"></a>Sets the direction for this text. </p>
</td>
</tr>
<tr id="row1266682094093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p982979274093522"><a name="p982979274093522"></a><a name="p982979274093522"></a><a href="graphic.md#gac39c029ba83cc256fded96108e299ff5">OHOS::UILabelButton::GetDirect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p33581813093522"><a name="p33581813093522"></a><a name="p33581813093522"></a><a href="graphic.md#ga0c108f97781843f67c101b47b6c00cf0">UITextLanguageDirect</a> </p>
<p id="p994521204093522"><a name="p994521204093522"></a><a name="p994521204093522"></a>Obtains the direction of this text. </p>
</td>
</tr>
<tr id="row1716198250093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1396437587093522"><a name="p1396437587093522"></a><a name="p1396437587093522"></a><a href="graphic.md#ga66e316e344c0165a6fd3c5083ea523f4">OHOS::UILabelButton::SetLabelStyle</a> (<a href="ohos-style.md">Style</a> &amp;labelStyle)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1312598202093522"><a name="p1312598202093522"></a><a name="p1312598202093522"></a>void </p>
<p id="p1644788621093522"><a name="p1644788621093522"></a><a name="p1644788621093522"></a>Sets the style for this label. </p>
</td>
</tr>
<tr id="row1214091827093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p560340347093522"><a name="p560340347093522"></a><a name="p560340347093522"></a><a href="graphic.md#gad1d6be2a8aec65bef4c1f598bfde7666">OHOS::UILabelButton::SetLabelStyle</a> (uint8_t key, int64_t value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1017142160093522"><a name="p1017142160093522"></a><a name="p1017142160093522"></a>void </p>
<p id="p2077379357093522"><a name="p2077379357093522"></a><a name="p2077379357093522"></a>Sets a style for this label. </p>
</td>
</tr>
<tr id="row2051293228093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1642195169093522"><a name="p1642195169093522"></a><a name="p1642195169093522"></a><a href="graphic.md#gaefaa6ceaa04329594f1539d48fa121f2">OHOS::UILabelButton::GetLabelStyle</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1918130450093522"><a name="p1918130450093522"></a><a name="p1918130450093522"></a>const <a href="ohos-style.md">Style</a> &amp; </p>
<p id="p628414725093522"><a name="p628414725093522"></a><a name="p628414725093522"></a>Obtains the style of this label. </p>
</td>
</tr>
<tr id="row725098419093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1099017902093522"><a name="p1099017902093522"></a><a name="p1099017902093522"></a><a href="graphic.md#ga21c71c654974ddb388a1890576966524">OHOS::UILabelButton::GetLabelStyle</a> (uint8_t key) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1999350687093522"><a name="p1999350687093522"></a><a name="p1999350687093522"></a>int64_t </p>
<p id="p1503672661093522"><a name="p1503672661093522"></a><a name="p1503672661093522"></a>Obtains the value of a style of this label. </p>
</td>
</tr>
<tr id="row429539172093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p700301986093522"><a name="p700301986093522"></a><a name="p700301986093522"></a><a href="graphic.md#ga55592f14dc16b1e1ae3fc9ab7ee9a976">OHOS::UILabelButton::SetTextColor</a> (<a href="ohos-color32.md">ColorType</a> color)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p444446417093522"><a name="p444446417093522"></a><a name="p444446417093522"></a>void </p>
<p id="p1600419530093522"><a name="p1600419530093522"></a><a name="p1600419530093522"></a>Sets the color for this text. </p>
</td>
</tr>
<tr id="row1423987628093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2133466519093522"><a name="p2133466519093522"></a><a name="p2133466519093522"></a><a href="graphic.md#gad84d1829e94b7ec45ab6576bc14c62d0">OHOS::UILabelButton::SetFont</a> (const char *name, uint8_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1416841042093522"><a name="p1416841042093522"></a><a name="p1416841042093522"></a>void </p>
<p id="p863634995093522"><a name="p863634995093522"></a><a name="p863634995093522"></a>Sets the font for this text. </p>
</td>
</tr>
<tr id="row1119464086093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1097464848093522"><a name="p1097464848093522"></a><a name="p1097464848093522"></a><a href="graphic.md#ga89cde9550d1bd443dad10d11c5c2fbfc">OHOS::UILabelButton::SetFontId</a> (uint8_t fontId)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p435343919093522"><a name="p435343919093522"></a><a name="p435343919093522"></a>void </p>
<p id="p454942851093522"><a name="p454942851093522"></a><a name="p454942851093522"></a>Sets the font ID. </p>
</td>
</tr>
<tr id="row812987762093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p792082405093522"><a name="p792082405093522"></a><a name="p792082405093522"></a><a href="graphic.md#ga826c13b3721c17ea43a7ca386a03253c">OHOS::UILabelButton::GetFontId</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1069882639093522"><a name="p1069882639093522"></a><a name="p1069882639093522"></a>uint8_t </p>
<p id="p816936902093522"><a name="p816936902093522"></a><a name="p816936902093522"></a>Obtains the font ID. </p>
</td>
</tr>
<tr id="row1249450642093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p516446226093522"><a name="p516446226093522"></a><a name="p516446226093522"></a><a href="graphic.md#gabed0d1b84d44874c94487796be82748f">OHOS::ListScrollListener::ListScrollListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p802457950093522"><a name="p802457950093522"></a><a name="p802457950093522"></a> </p>
<p id="p794679529093522"><a name="p794679529093522"></a><a name="p794679529093522"></a>A constructor used to create a <strong id="b1215560604093522"><a name="b1215560604093522"></a><a name="b1215560604093522"></a><a href="ohos-listscrolllistener.md">ListScrollListener</a></strong> instance with the default state <strong id="b323225635093522"><a name="b323225635093522"></a><a name="b323225635093522"></a>SCROLL_STATE_STOP</strong>. </p>
</td>
</tr>
<tr id="row723468365093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1601997083093522"><a name="p1601997083093522"></a><a name="p1601997083093522"></a><a href="graphic.md#gace5864b41e1f07feecb33b3f897fe02d">OHOS::ListScrollListener::~ListScrollListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1873320755093522"><a name="p1873320755093522"></a><a name="p1873320755093522"></a>virtual </p>
<p id="p1699731812093522"><a name="p1699731812093522"></a><a name="p1699731812093522"></a>A destructor used to delete the <strong id="b697896920093522"><a name="b697896920093522"></a><a name="b697896920093522"></a><a href="ohos-listscrolllistener.md">ListScrollListener</a></strong> instance. </p>
</td>
</tr>
<tr id="row1928007870093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p308879972093522"><a name="p308879972093522"></a><a name="p308879972093522"></a><a href="graphic.md#gae802e8b4c48f7d416d6809ba8fa89428">OHOS::ListScrollListener::OnScrollStart</a> (int16_t <a href="en-us_topic_0000001055198076.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>, <a href="ohos-uiview.md">UIView</a> *view)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p409974474093522"><a name="p409974474093522"></a><a name="p409974474093522"></a>virtual void </p>
<p id="p622792821093522"><a name="p622792821093522"></a><a name="p622792821093522"></a>Called when a scroll starts. </p>
</td>
</tr>
<tr id="row701584659093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p382182808093522"><a name="p382182808093522"></a><a name="p382182808093522"></a><a href="graphic.md#ga74cc55be27bfd4c21f10d859bc1fbd3d">OHOS::ListScrollListener::OnScrollEnd</a> (int16_t <a href="en-us_topic_0000001055198076.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>, <a href="ohos-uiview.md">UIView</a> *view)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p150654074093522"><a name="p150654074093522"></a><a name="p150654074093522"></a>virtual void </p>
<p id="p1413423886093522"><a name="p1413423886093522"></a><a name="p1413423886093522"></a>Called when a scroll ends. </p>
</td>
</tr>
<tr id="row352871845093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2118595132093522"><a name="p2118595132093522"></a><a name="p2118595132093522"></a><a href="graphic.md#gab6b77fec222bb03439d2d0a37538f1f0">OHOS::ListScrollListener::OnItemSelected</a> (int16_t <a href="en-us_topic_0000001055198076.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>, <a href="ohos-uiview.md">UIView</a> *view)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p278563252093522"><a name="p278563252093522"></a><a name="p278563252093522"></a>virtual void </p>
<p id="p430991440093522"><a name="p430991440093522"></a><a name="p430991440093522"></a>Called when a new child view is selected at the preset position as this list scrolls. For details about how to set the position, see <strong id="b301095890093522"><a name="b301095890093522"></a><a name="b301095890093522"></a>SetSelectPosition</strong>. </p>
</td>
</tr>
<tr id="row703869101093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p364801341093522"><a name="p364801341093522"></a><a name="p364801341093522"></a><a href="graphic.md#ga3710c81b7fe02708da391d23cf08ddad">OHOS::ListScrollListener::GetScrollState</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p576604496093522"><a name="p576604496093522"></a><a name="p576604496093522"></a>uint8_t </p>
<p id="p148887880093522"><a name="p148887880093522"></a><a name="p148887880093522"></a>Obtains the scroll state of this list. </p>
</td>
</tr>
<tr id="row388186238093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1460103672093522"><a name="p1460103672093522"></a><a name="p1460103672093522"></a><a href="graphic.md#ga56c15f8c21c433c8a08a151e33b521cf">OHOS::UIList::UIList</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2086539747093522"><a name="p2086539747093522"></a><a name="p2086539747093522"></a> </p>
<p id="p804008840093522"><a name="p804008840093522"></a><a name="p804008840093522"></a>A constructor used to create a <strong id="b1831449719093522"><a name="b1831449719093522"></a><a name="b1831449719093522"></a><a href="ohos-uilist.md">UIList</a></strong> instance in the vertical direction. </p>
</td>
</tr>
<tr id="row1543537861093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1659840860093522"><a name="p1659840860093522"></a><a name="p1659840860093522"></a><a href="graphic.md#ga2da1983fedabd5ea06a8a544aeb2cf04">OHOS::UIList::UIList</a> (uint8_t direction)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p534219552093522"><a name="p534219552093522"></a><a name="p534219552093522"></a> </p>
<p id="p2054215155093522"><a name="p2054215155093522"></a><a name="p2054215155093522"></a>A constructor used to create a <strong id="b924588017093522"><a name="b924588017093522"></a><a name="b924588017093522"></a><a href="ohos-uilist.md">UIList</a></strong> instance in the specified direction. </p>
</td>
</tr>
<tr id="row1068996218093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1600752024093522"><a name="p1600752024093522"></a><a name="p1600752024093522"></a><a href="graphic.md#ga84de0a8214747d118abfd3d1185ffa63">OHOS::UIList::~UIList</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1564022733093522"><a name="p1564022733093522"></a><a name="p1564022733093522"></a>virtual </p>
<p id="p1530127013093522"><a name="p1530127013093522"></a><a name="p1530127013093522"></a>A destructor used to delete the <strong id="b1107474027093522"><a name="b1107474027093522"></a><a name="b1107474027093522"></a><a href="ohos-uilist.md">UIList</a></strong> instance. </p>
</td>
</tr>
<tr id="row513278507093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1293037357093522"><a name="p1293037357093522"></a><a name="p1293037357093522"></a><a href="graphic.md#ga6e11e5de67f87ed6cf6c44f60b7d4096">OHOS::UIList::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p205282953093522"><a name="p205282953093522"></a><a name="p205282953093522"></a>UIViewType </p>
<p id="p289391774093522"><a name="p289391774093522"></a><a name="p289391774093522"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row139481484093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p546582535093522"><a name="p546582535093522"></a><a name="p546582535093522"></a><a href="graphic.md#ga7e99d1fb891879195c19c211c6de6600">OHOS::UIList::OnDragEvent</a> (const <a href="ohos-dragevent.md">DragEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p974440758093522"><a name="p974440758093522"></a><a name="p974440758093522"></a>bool </p>
<p id="p1724180943093522"><a name="p1724180943093522"></a><a name="p1724180943093522"></a>Called when the view is being dragged. </p>
</td>
</tr>
<tr id="row1481864156093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p912230972093522"><a name="p912230972093522"></a><a name="p912230972093522"></a><a href="graphic.md#ga225e59d60271c9012a017136d2aab0d6">OHOS::UIList::OnDragEndEvent</a> (const <a href="ohos-dragevent.md">DragEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2047699588093522"><a name="p2047699588093522"></a><a name="p2047699588093522"></a>bool </p>
<p id="p431945197093522"><a name="p431945197093522"></a><a name="p431945197093522"></a>Called when the view stops dragging. </p>
</td>
</tr>
<tr id="row2130201677093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1329446639093522"><a name="p1329446639093522"></a><a name="p1329446639093522"></a><a href="graphic.md#gaa6ba86e78d4a12ea47b6aaa8dd88f882">OHOS::UIList::OnPressEvent</a> (const <a href="ohos-pressevent.md">PressEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1915131580093522"><a name="p1915131580093522"></a><a name="p1915131580093522"></a>void </p>
<p id="p2114730987093522"><a name="p2114730987093522"></a><a name="p2114730987093522"></a>Called when the view is pressed. </p>
</td>
</tr>
<tr id="row140530948093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p111554322093522"><a name="p111554322093522"></a><a name="p111554322093522"></a><a href="graphic.md#gaa44fd515481de0f1de5d20a62be63267">OHOS::UIList::SetAdapter</a> (<a href="ohos-abstractadapter.md">AbstractAdapter</a> *adapter)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1983414144093522"><a name="p1983414144093522"></a><a name="p1983414144093522"></a>void </p>
<p id="p1483650173093522"><a name="p1483650173093522"></a><a name="p1483650173093522"></a>Sets the adapter for this list. The content of this list is initialized when the adapter is set. </p>
</td>
</tr>
<tr id="row1288339096093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p475712235093522"><a name="p475712235093522"></a><a name="p475712235093522"></a><a href="graphic.md#gafe121e0cc150122486049dcaf83f3c26">OHOS::UIList::MoveChildByOffset</a> (int16_t x, int16_t y) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p287302289093522"><a name="p287302289093522"></a><a name="p287302289093522"></a>virtual void </p>
<p id="p1172271921093522"><a name="p1172271921093522"></a><a name="p1172271921093522"></a>Moves the position of all child views. </p>
</td>
</tr>
<tr id="row111473350093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1197717955093522"><a name="p1197717955093522"></a><a name="p1197717955093522"></a><a href="graphic.md#ga9a760e34ff783d738d414d26af3903e5">OHOS::UIList::ScrollTo</a> (uint16_t <a href="en-us_topic_0000001055198076.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p627796422093522"><a name="p627796422093522"></a><a name="p627796422093522"></a>void </p>
<p id="p1368242926093522"><a name="p1368242926093522"></a><a name="p1368242926093522"></a>Scrolls to change the index of the first row or column of the current view. </p>
</td>
</tr>
<tr id="row1308510168093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1608167047093522"><a name="p1608167047093522"></a><a name="p1608167047093522"></a><a href="graphic.md#gaf97d599fe1147a71e44a5a107edeac77">OHOS::UIList::ScrollBy</a> (int16_t distance)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1370974895093522"><a name="p1370974895093522"></a><a name="p1370974895093522"></a>void </p>
<p id="p308543873093522"><a name="p308543873093522"></a><a name="p308543873093522"></a>Scrolls the content in this list. </p>
</td>
</tr>
<tr id="row1980081236093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p575074025093522"><a name="p575074025093522"></a><a name="p575074025093522"></a><a href="graphic.md#gaa8023e5c4e0688841263d0f576e76218">OHOS::UIList::SetStartIndex</a> (uint16_t <a href="en-us_topic_0000001055198076.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1702985048093522"><a name="p1702985048093522"></a><a name="p1702985048093522"></a>void </p>
<p id="p783349956093522"><a name="p783349956093522"></a><a name="p783349956093522"></a>Sets the start index for this list. </p>
</td>
</tr>
<tr id="row421035477093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p184052772093522"><a name="p184052772093522"></a><a name="p184052772093522"></a><a href="graphic.md#ga0ce3080df2c5226d20d446bc9c28b694">OHOS::UIList::GetStartIndex</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p32749094093522"><a name="p32749094093522"></a><a name="p32749094093522"></a>uint16_t </p>
<p id="p1568041352093522"><a name="p1568041352093522"></a><a name="p1568041352093522"></a>Obtains the start index of this list. The default value is <strong id="b1980228790093522"><a name="b1980228790093522"></a><a name="b1980228790093522"></a>0</strong>. </p>
</td>
</tr>
<tr id="row1291988001093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p842753000093522"><a name="p842753000093522"></a><a name="p842753000093522"></a><a href="graphic.md#gaa07b156ab757cd20486ec0bcbf4c17ac">OHOS::UIList::SetLoopState</a> (bool state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p164132679093522"><a name="p164132679093522"></a><a name="p164132679093522"></a>void </p>
<p id="p570473678093522"><a name="p570473678093522"></a><a name="p570473678093522"></a>Sets the loop state for this list, in which a loop scroll is possible since the top and bottom of the list are connected together. </p>
</td>
</tr>
<tr id="row1557775467093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p935883157093522"><a name="p935883157093522"></a><a name="p935883157093522"></a><a href="graphic.md#ga78d73f33cc63d0121342f52a818881d5">OHOS::UIList::GetLoopState</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1380312135093522"><a name="p1380312135093522"></a><a name="p1380312135093522"></a>bool </p>
<p id="p1973609794093522"><a name="p1973609794093522"></a><a name="p1973609794093522"></a>Checks whether this list is in a loop state. </p>
</td>
</tr>
<tr id="row1314694478093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1030825956093522"><a name="p1030825956093522"></a><a name="p1030825956093522"></a><a href="graphic.md#ga919b4f3116ca0d0971a48b7a14921954">OHOS::UIList::SetSelectPosition</a> (uint16_t position)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p278690582093522"><a name="p278690582093522"></a><a name="p278690582093522"></a>void </p>
<p id="p196787691093522"><a name="p196787691093522"></a><a name="p196787691093522"></a>Sets the position where a child view is selected as this list scrolls. </p>
</td>
</tr>
<tr id="row1997033693093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p731701676093522"><a name="p731701676093522"></a><a name="p731701676093522"></a><a href="graphic.md#ga199fdcf3ef797e5f61073a4be3b06642">OHOS::UIList::GetSelectView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p406373651093522"><a name="p406373651093522"></a><a name="p406373651093522"></a><a href="ohos-uiview.md">UIView</a> * </p>
<p id="p1909184251093522"><a name="p1909184251093522"></a><a name="p1909184251093522"></a>Obtains the child view being selected at the preset position. </p>
</td>
</tr>
<tr id="row456648967093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p923818607093522"><a name="p923818607093522"></a><a name="p923818607093522"></a><a href="graphic.md#gad6b2f7598033f4e1d0d73e30b0e41f02">OHOS::UIList::SetScrollStateListener</a> (<a href="ohos-listscrolllistener.md">ListScrollListener</a> *scrollListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1376489840093522"><a name="p1376489840093522"></a><a name="p1376489840093522"></a>void </p>
<p id="p538577821093522"><a name="p538577821093522"></a><a name="p538577821093522"></a>Sets the listener that contains a callback to be invoked when a child view is selected as this list scrolls. </p>
</td>
</tr>
<tr id="row98927049093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p277968111093522"><a name="p277968111093522"></a><a name="p277968111093522"></a><a href="graphic.md#gaf2aabfa8e8edd803d034c23efe45f57b">OHOS::UIList::RefreshList</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1364512636093522"><a name="p1364512636093522"></a><a name="p1364512636093522"></a>void </p>
<p id="p573282391093522"><a name="p573282391093522"></a><a name="p573282391093522"></a>Refreshes this list. The number of child views in the current view is fixed and the positions of those reserved child views as this list scrolls remain unchanged. </p>
</td>
</tr>
<tr id="row303045491093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1604108223093522"><a name="p1604108223093522"></a><a name="p1604108223093522"></a><a href="graphic.md#ga034799920648552008146a0d9aca3424">OHOS::UIList::EnableAutoAlign</a> (bool state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p982166532093522"><a name="p982166532093522"></a><a name="p982166532093522"></a>void </p>
<p id="p1979559605093522"><a name="p1979559605093522"></a><a name="p1979559605093522"></a>Sets the automatic alignment state for this list. When a scroll stops, a child view is selected and its position is automatically aligned with the preset position. </p>
</td>
</tr>
<tr id="row2089623744093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1033953260093522"><a name="p1033953260093522"></a><a name="p1033953260093522"></a><a href="graphic.md#gaa55aae2e8066fecc5941e021a7f30d7e">OHOS::UIList::RemoveAll</a> () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1308755869093522"><a name="p1308755869093522"></a><a name="p1308755869093522"></a>void </p>
<p id="p767010262093522"><a name="p767010262093522"></a><a name="p767010262093522"></a>Removes all child views. </p>
</td>
</tr>
<tr id="row1192464247093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1840177593093522"><a name="p1840177593093522"></a><a name="p1840177593093522"></a><a href="graphic.md#ga527215b87f48c8e4a76c1d1d7979b739">OHOS::UIPicker::UIPicker</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p951174366093522"><a name="p951174366093522"></a><a name="p951174366093522"></a> </p>
<p id="p1133961076093522"><a name="p1133961076093522"></a><a name="p1133961076093522"></a>A constructor used to create a <strong id="b1212515494093522"><a name="b1212515494093522"></a><a name="b1212515494093522"></a><a href="ohos-uipicker.md">UIPicker</a></strong> instance. </p>
</td>
</tr>
<tr id="row1287366897093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2038736925093522"><a name="p2038736925093522"></a><a name="p2038736925093522"></a><a href="graphic.md#ga7aa364d1c552eaf8b8be587e03049f59">OHOS::UIPicker::~UIPicker</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p306418372093522"><a name="p306418372093522"></a><a name="p306418372093522"></a>virtual </p>
<p id="p1976367209093522"><a name="p1976367209093522"></a><a name="p1976367209093522"></a>A destructor used to delete the <strong id="b1769598615093522"><a name="b1769598615093522"></a><a name="b1769598615093522"></a><a href="ohos-uipicker.md">UIPicker</a></strong> instance. </p>
</td>
</tr>
<tr id="row891207414093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1248893412093522"><a name="p1248893412093522"></a><a name="p1248893412093522"></a><a href="graphic.md#ga926337be55785de0b32ad57d7ee85c5c">OHOS::UIPicker::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p913378178093522"><a name="p913378178093522"></a><a name="p913378178093522"></a>UIViewType </p>
<p id="p826647229093522"><a name="p826647229093522"></a><a name="p826647229093522"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row741555486093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1612790956093522"><a name="p1612790956093522"></a><a name="p1612790956093522"></a><a href="graphic.md#ga3e2a703a10017c789366029b297969ab">OHOS::UIPicker::OnPreDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p679934397093522"><a name="p679934397093522"></a><a name="p679934397093522"></a>bool </p>
<p id="p221080315093522"><a name="p221080315093522"></a><a name="p221080315093522"></a>Called before a view is drawn. This function is used to check whether the parent view of this view needs to be redrawn so as to optimize the drawing process. </p>
</td>
</tr>
<tr id="row1805108263093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p179938098093522"><a name="p179938098093522"></a><a name="p179938098093522"></a><a href="graphic.md#ga419bb15f72b02f009a76a84e1242b37a">OHOS::UIPicker::SetValues</a> (const char *value[], uint16_t count)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1114335986093522"><a name="p1114335986093522"></a><a name="p1114335986093522"></a>bool </p>
<p id="p763435593093522"><a name="p763435593093522"></a><a name="p763435593093522"></a>Sets dynamic text data in the picker by using a string array. </p>
</td>
</tr>
<tr id="row445286841093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p410959498093522"><a name="p410959498093522"></a><a name="p410959498093522"></a><a href="graphic.md#gadc27ad0369bad90526a59d0cefdb9697">OHOS::UIPicker::SetValues</a> (int16_t start, int16_t end)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1796716682093522"><a name="p1796716682093522"></a><a name="p1796716682093522"></a>bool </p>
<p id="p410142973093522"><a name="p410142973093522"></a><a name="p410142973093522"></a>Sets the numeric data in the picker by using a given numeric range. </p>
</td>
</tr>
<tr id="row949242726093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p679664295093522"><a name="p679664295093522"></a><a name="p679664295093522"></a><a href="graphic.md#ga81e69c460191bbe3606ac540433178a1">OHOS::UIPicker::ClearValues</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p804733916093522"><a name="p804733916093522"></a><a name="p804733916093522"></a>virtual void </p>
<p id="p564024052093522"><a name="p564024052093522"></a><a name="p564024052093522"></a>Clears all values in the picker. </p>
</td>
</tr>
<tr id="row1892722958093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p735760569093522"><a name="p735760569093522"></a><a name="p735760569093522"></a><a href="graphic.md#ga11a0d71430e826f1971744e5ce1c9048">OHOS::UIPicker::SetFontId</a> (uint8_t backgroundFontId, uint8_t highlightFontId)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p665742876093522"><a name="p665742876093522"></a><a name="p665742876093522"></a>void </p>
<p id="p1031779317093522"><a name="p1031779317093522"></a><a name="p1031779317093522"></a>Sets the font IDs of dynamic text, which is the string array set through <a href="graphic.md#ga419bb15f72b02f009a76a84e1242b37a">SetValues</a>. </p>
</td>
</tr>
<tr id="row2039893253093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p733704294093522"><a name="p733704294093522"></a><a name="p733704294093522"></a><a href="graphic.md#gaaf111e4de815c455ddc35d200c1de7af">OHOS::UIPicker::GetBackgroundFontId</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p535612327093522"><a name="p535612327093522"></a><a name="p535612327093522"></a>uint16_t </p>
<p id="p224508188093522"><a name="p224508188093522"></a><a name="p224508188093522"></a>Obtains the font ID of the background text. </p>
</td>
</tr>
<tr id="row949686375093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p759615221093522"><a name="p759615221093522"></a><a name="p759615221093522"></a><a href="graphic.md#ga3a03222a252380aa738186e9c004dc1a">OHOS::UIPicker::GetHighlightFontId</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1508077570093522"><a name="p1508077570093522"></a><a name="p1508077570093522"></a>uint16_t </p>
<p id="p377214426093522"><a name="p377214426093522"></a><a name="p377214426093522"></a>Obtains the font ID of the highlighted text. </p>
</td>
</tr>
<tr id="row1941837018093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1396161224093522"><a name="p1396161224093522"></a><a name="p1396161224093522"></a><a href="graphic.md#ga281508b16585cdf4531e29872486e6c8">OHOS::UIPicker::SetTextColor</a> (<a href="ohos-color32.md">ColorType</a> backgroundColor, <a href="ohos-color32.md">ColorType</a> highlightColor)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1961404140093522"><a name="p1961404140093522"></a><a name="p1961404140093522"></a>void </p>
<p id="p795951849093522"><a name="p795951849093522"></a><a name="p795951849093522"></a>Sets the text color. </p>
</td>
</tr>
<tr id="row1083863165093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1263183613093522"><a name="p1263183613093522"></a><a name="p1263183613093522"></a><a href="graphic.md#ga2acbf79147239f60aafa2c78ccc2ff6d">OHOS::UIPicker::GetBackgroundTextColor</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p388466388093522"><a name="p388466388093522"></a><a name="p388466388093522"></a><a href="ohos-color32.md">ColorType</a> </p>
<p id="p1603998832093522"><a name="p1603998832093522"></a><a name="p1603998832093522"></a>Obtains the color of the background text. </p>
</td>
</tr>
<tr id="row526762827093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1701721106093522"><a name="p1701721106093522"></a><a name="p1701721106093522"></a><a href="graphic.md#gaf51c8e0d1defb52191bc5f0b2c960695">OHOS::UIPicker::GetHighlightTextColor</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1475516861093522"><a name="p1475516861093522"></a><a name="p1475516861093522"></a><a href="ohos-color32.md">ColorType</a> </p>
<p id="p556277516093522"><a name="p556277516093522"></a><a name="p556277516093522"></a>Obtains the color of the highlighted text. </p>
</td>
</tr>
<tr id="row2086476181093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1569987566093522"><a name="p1569987566093522"></a><a name="p1569987566093522"></a><a href="graphic.md#ga07eb2080a6052c19dba2873fcfae2c34">OHOS::UIPicker::SetSelected</a> (uint16_t <a href="en-us_topic_0000001055198076.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1667965822093522"><a name="p1667965822093522"></a><a name="p1667965822093522"></a>bool </p>
<p id="p1804991012093522"><a name="p1804991012093522"></a><a name="p1804991012093522"></a>Sets the index of the item currently selected in the picker. </p>
</td>
</tr>
<tr id="row1652509746093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1450278615093522"><a name="p1450278615093522"></a><a name="p1450278615093522"></a><a href="graphic.md#ga7c9d757790dfaae67fad110577b57ee9">OHOS::UIPicker::GetSelected</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1727109584093522"><a name="p1727109584093522"></a><a name="p1727109584093522"></a>uint16_t </p>
<p id="p110250915093522"><a name="p110250915093522"></a><a name="p110250915093522"></a>Obtains the index of the item currently selected in the picker. </p>
</td>
</tr>
<tr id="row847676604093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p653576528093522"><a name="p653576528093522"></a><a name="p653576528093522"></a><a href="graphic.md#ga6a6d9ca48f543f4f6cf6073d6cca359a">OHOS::UIPicker::SetItemHeight</a> (int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p49144712093522"><a name="p49144712093522"></a><a name="p49144712093522"></a>void </p>
<p id="p203595126093522"><a name="p203595126093522"></a><a name="p203595126093522"></a>Sets the height of each item in the picker. </p>
</td>
</tr>
<tr id="row534386886093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1474729779093522"><a name="p1474729779093522"></a><a name="p1474729779093522"></a><a href="graphic.md#ga792a345948af532f9c06cd40c05d1a2d">OHOS::UIPicker::SetWidth</a> (int16_t width) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1960307193093522"><a name="p1960307193093522"></a><a name="p1960307193093522"></a>void </p>
<p id="p1067394326093522"><a name="p1067394326093522"></a><a name="p1067394326093522"></a>Sets the width for this component. </p>
</td>
</tr>
<tr id="row1397484503093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1273142545093522"><a name="p1273142545093522"></a><a name="p1273142545093522"></a><a href="graphic.md#ga167979fe09694b0f0c09e9c676189bea">OHOS::UIPicker::SetHeight</a> (int16_t height) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p105126338093522"><a name="p105126338093522"></a><a name="p105126338093522"></a>void </p>
<p id="p80284448093522"><a name="p80284448093522"></a><a name="p80284448093522"></a>Sets the height for this component. </p>
</td>
</tr>
<tr id="row1167559144093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2063952594093522"><a name="p2063952594093522"></a><a name="p2063952594093522"></a><a href="graphic.md#ga742f27b59ae3c19dfb5d99e84ca19554">OHOS::UIPicker::SetLoopState</a> (bool state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1863568018093522"><a name="p1863568018093522"></a><a name="p1863568018093522"></a>void </p>
<p id="p1538552076093522"><a name="p1538552076093522"></a><a name="p1538552076093522"></a>Sets whether a picker can slide cyclically. </p>
</td>
</tr>
<tr id="row1550178314093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1767277312093522"><a name="p1767277312093522"></a><a name="p1767277312093522"></a><a href="graphic.md#gae386080bbc3bb3ae2bb4572b8bfbb6b0">OHOS::UIPicker::SelectedListener::SelectedListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p20283852093522"><a name="p20283852093522"></a><a name="p20283852093522"></a> </p>
<p id="p1013774546093522"><a name="p1013774546093522"></a><a name="p1013774546093522"></a>A constructor used to create a <strong id="b1412054439093522"><a name="b1412054439093522"></a><a name="b1412054439093522"></a><a href="ohos-uipicker-selectedlistener.md">SelectedListener</a></strong> instance. </p>
</td>
</tr>
<tr id="row1305633300093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p418291635093522"><a name="p418291635093522"></a><a name="p418291635093522"></a><a href="graphic.md#ga6aa15c4365ba33bc21c67cfc3e5cf06f">OHOS::UIPicker::SelectedListener::~SelectedListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p173663530093522"><a name="p173663530093522"></a><a name="p173663530093522"></a>virtual </p>
<p id="p243613231093522"><a name="p243613231093522"></a><a name="p243613231093522"></a>A destructor used to delete the <strong id="b1175145168093522"><a name="b1175145168093522"></a><a name="b1175145168093522"></a><a href="ohos-uipicker-selectedlistener.md">SelectedListener</a></strong> instance. </p>
</td>
</tr>
<tr id="row823867394093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p261643812093522"><a name="p261643812093522"></a><a name="p261643812093522"></a><a href="graphic.md#ga9cd5ee866fe730a6ae6c66344284b5e2">OHOS::UIPicker::SelectedListener::OnPickerStoped</a> (<a href="ohos-uipicker.md">UIPicker</a> &amp;picker)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1716919218093522"><a name="p1716919218093522"></a><a name="p1716919218093522"></a>virtual void </p>
<p id="p1378180423093522"><a name="p1378180423093522"></a><a name="p1378180423093522"></a>Called when an item is selected after sliding stops. This function is implemented by applications. </p>
</td>
</tr>
<tr id="row1835160045093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p726386206093522"><a name="p726386206093522"></a><a name="p726386206093522"></a><a href="graphic.md#ga70a514c87a883999a93b6c9d3713be61">OHOS::UIPicker::RegisterSelectedListener</a> (<a href="ohos-uipicker-selectedlistener.md">SelectedListener</a> *pickerListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1041245198093522"><a name="p1041245198093522"></a><a name="p1041245198093522"></a>void </p>
<p id="p925327890093522"><a name="p925327890093522"></a><a name="p925327890093522"></a>Registers a listener for a selected event. </p>
</td>
</tr>
<tr id="row211036711093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1949233607093522"><a name="p1949233607093522"></a><a name="p1949233607093522"></a><a href="graphic.md#gad0c36e1430f8db5571fd92b82d6d6bc1">OHOS::UIPicker::SetDirect</a> (<a href="graphic.md#ga0c108f97781843f67c101b47b6c00cf0">UITextLanguageDirect</a> direct)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p301969740093522"><a name="p301969740093522"></a><a name="p301969740093522"></a>void </p>
<p id="p738303270093522"><a name="p738303270093522"></a><a name="p738303270093522"></a>Sets the text direction. </p>
</td>
</tr>
<tr id="row1535128905093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p603806207093522"><a name="p603806207093522"></a><a name="p603806207093522"></a><a href="graphic.md#ga564153af81a4a41ceab63622506d25eb">OHOS::UIPicker::SetTextFormatter</a> (<a href="ohos-textformatter.md">TextFormatter</a> *formatter)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p768051834093522"><a name="p768051834093522"></a><a name="p768051834093522"></a>void </p>
<p id="p336244911093522"><a name="p336244911093522"></a><a name="p336244911093522"></a>Sets the text formatter. </p>
</td>
</tr>
<tr id="row1201161555093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2006846628093522"><a name="p2006846628093522"></a><a name="p2006846628093522"></a><a href="graphic.md#gaae79b6ffd2b156a8d42263a322985284">OHOS::UIRadioButton::UIRadioButton</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p372579936093522"><a name="p372579936093522"></a><a name="p372579936093522"></a> </p>
<p id="p1137470551093522"><a name="p1137470551093522"></a><a name="p1137470551093522"></a>A constructor used to create a <strong id="b443470920093522"><a name="b443470920093522"></a><a name="b443470920093522"></a><a href="ohos-uiradiobutton.md">UIRadioButton</a></strong> instance. </p>
</td>
</tr>
<tr id="row1593030828093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p226264108093522"><a name="p226264108093522"></a><a name="p226264108093522"></a><em id="ga9b48f8664f04f08b94dca2e0b3821595"><a name="ga9b48f8664f04f08b94dca2e0b3821595"></a><a name="ga9b48f8664f04f08b94dca2e0b3821595"></a></em>OHOS::UIRadioButton::UIRadioButton (const char *name)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p183194860093522"><a name="p183194860093522"></a><a name="p183194860093522"></a><strong id="b1841568688"><a name="b1841568688"></a><a name="b1841568688"></a></strong>  </p>
<p id="p2062081846093522"><a name="p2062081846093522"></a><a name="p2062081846093522"></a>Default constructor. </p>
</td>
</tr>
<tr id="row1287947269093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p509318145093522"><a name="p509318145093522"></a><a name="p509318145093522"></a><a href="graphic.md#ga1b9fbd5840829e912aa4013a343e7b36">OHOS::UIRadioButton::~UIRadioButton</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p321486324093522"><a name="p321486324093522"></a><a name="p321486324093522"></a>virtual </p>
<p id="p403585049093522"><a name="p403585049093522"></a><a name="p403585049093522"></a>A destructor used to delete the <strong id="b1978619533093522"><a name="b1978619533093522"></a><a name="b1978619533093522"></a><a href="ohos-uiradiobutton.md">UIRadioButton</a></strong> instance. </p>
</td>
</tr>
<tr id="row450270169093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1242385803093522"><a name="p1242385803093522"></a><a name="p1242385803093522"></a><a href="graphic.md#ga2efe6a87345903726c721fc7a9ed4365">OHOS::UIRadioButton::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p639219321093522"><a name="p639219321093522"></a><a name="p639219321093522"></a>UIViewType </p>
<p id="p532266097093522"><a name="p532266097093522"></a><a name="p532266097093522"></a>Obtains the component type. </p>
</td>
</tr>
<tr id="row1790061956093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1479611583093522"><a name="p1479611583093522"></a><a name="p1479611583093522"></a><a href="graphic.md#gade9069f6e553c6c43f7684e835b584e5">OHOS::UIRadioButton::OnPreDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p871818742093522"><a name="p871818742093522"></a><a name="p871818742093522"></a>bool </p>
<p id="p64179694093522"><a name="p64179694093522"></a><a name="p64179694093522"></a>Do something before draw, this function will be invoked mainly to check if this view need to cover invalidate area so render manager can decide which layer to draw firstly. </p>
</td>
</tr>
<tr id="row439551677093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1682646827093522"><a name="p1682646827093522"></a><a name="p1682646827093522"></a><a href="graphic.md#ga7b6849c94b9d8b90cbbe890790fedf1e">OHOS::UIRadioButton::OnClickEvent</a> (const <a href="ohos-clickevent.md">ClickEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p363418571093522"><a name="p363418571093522"></a><a name="p363418571093522"></a>void </p>
<p id="p1212193190093522"><a name="p1212193190093522"></a><a name="p1212193190093522"></a>Executes the click event action OnClickEvent will reverse the selected state of checkbox. Example: If the check box is selected, the checkbox status is changed to Unselected after the click action is taken. </p>
</td>
</tr>
<tr id="row453346985093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1853460080093522"><a name="p1853460080093522"></a><a name="p1853460080093522"></a><a href="graphic.md#gad56eb918dbfec65f8f596572a9911286">OHOS::UIRadioButton::SetName</a> (const char *name)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p567014217093522"><a name="p567014217093522"></a><a name="p567014217093522"></a>void </p>
<p id="p868037936093522"><a name="p868037936093522"></a><a name="p868037936093522"></a>Sets the name for this radio button. </p>
</td>
</tr>
<tr id="row557969356093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1099621362093522"><a name="p1099621362093522"></a><a name="p1099621362093522"></a><a href="graphic.md#ga7d2125ee509f1555888549277f31a7a7">OHOS::UIRadioButton::GetName</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1850377507093522"><a name="p1850377507093522"></a><a name="p1850377507093522"></a>const char * </p>
<p id="p2026142780093522"><a name="p2026142780093522"></a><a name="p2026142780093522"></a>Obtains the name of this radio button. </p>
</td>
</tr>
<tr id="row2140846893093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1231606432093522"><a name="p1231606432093522"></a><a name="p1231606432093522"></a><a href="graphic.md#gac43cbe638a874231842ad80c23c00b0a">OHOS::UIRepeatButton::UIRepeatButton</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1799268984093522"><a name="p1799268984093522"></a><a name="p1799268984093522"></a> </p>
<p id="p597580588093522"><a name="p597580588093522"></a><a name="p597580588093522"></a>A constructor used to create a <strong id="b1948009936093522"><a name="b1948009936093522"></a><a name="b1948009936093522"></a><a href="ohos-uirepeatbutton.md">UIRepeatButton</a></strong> instance. </p>
</td>
</tr>
<tr id="row2017157954093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p444660936093522"><a name="p444660936093522"></a><a name="p444660936093522"></a><a href="graphic.md#ga2e2a8bc2b9aa21899356dbad7a242900">OHOS::UIRepeatButton::~UIRepeatButton</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p370074669093522"><a name="p370074669093522"></a><a name="p370074669093522"></a>virtual </p>
<p id="p1198682441093522"><a name="p1198682441093522"></a><a name="p1198682441093522"></a>A destructor used to delete the <strong id="b98746385093522"><a name="b98746385093522"></a><a name="b98746385093522"></a><a href="ohos-uirepeatbutton.md">UIRepeatButton</a></strong> instance. </p>
</td>
</tr>
<tr id="row125396023093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p900440949093522"><a name="p900440949093522"></a><a name="p900440949093522"></a><a href="graphic.md#gac391336aedd68659b7f76bee59eba521">OHOS::UIRepeatButton::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2016634139093522"><a name="p2016634139093522"></a><a name="p2016634139093522"></a>UIViewType </p>
<p id="p1280495266093522"><a name="p1280495266093522"></a><a name="p1280495266093522"></a>Obtains the component type. </p>
</td>
</tr>
<tr id="row246139030093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2098280649093522"><a name="p2098280649093522"></a><a name="p2098280649093522"></a><a href="graphic.md#ga88637ae5acd7701ded0d0e88fb28227d">OHOS::UIRepeatButton::SetInterval</a> (uint16_t interval)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p663258434093522"><a name="p663258434093522"></a><a name="p663258434093522"></a>virtual void </p>
<p id="p1479638910093522"><a name="p1479638910093522"></a><a name="p1479638910093522"></a>Sets the interval between two consecutive click events. </p>
</td>
</tr>
<tr id="row1211671700093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2059109180093522"><a name="p2059109180093522"></a><a name="p2059109180093522"></a><a href="graphic.md#gad772c84a309dbaa150b66f697e5b8ed8">OHOS::UIRepeatButton::GetInterval</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p893285221093522"><a name="p893285221093522"></a><a name="p893285221093522"></a>virtual uint16_t </p>
<p id="p523335053093522"><a name="p523335053093522"></a><a name="p523335053093522"></a>Obtains the interval between two consecutive click events. </p>
</td>
</tr>
<tr id="row1242332607093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p643320537093522"><a name="p643320537093522"></a><a name="p643320537093522"></a><a href="graphic.md#gaca17d1cfa9daa35a88d387ebc1d9352c">OHOS::UIRepeatButton::OnClickEvent</a> (const <a href="ohos-clickevent.md">ClickEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1452383438093522"><a name="p1452383438093522"></a><a name="p1452383438093522"></a>virtual void </p>
<p id="p437936918093522"><a name="p437936918093522"></a><a name="p437936918093522"></a>The action of click event. </p>
</td>
</tr>
<tr id="row521041229093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p480337076093522"><a name="p480337076093522"></a><a name="p480337076093522"></a><a href="graphic.md#gadd5891c03d95d07d127558b5bc9a7bd7">OHOS::UIRepeatButton::OnReleaseEvent</a> (const <a href="ohos-releaseevent.md">ReleaseEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p194912879093522"><a name="p194912879093522"></a><a name="p194912879093522"></a>virtual void </p>
<p id="p684028775093522"><a name="p684028775093522"></a><a name="p684028775093522"></a>The action of release event. </p>
</td>
</tr>
<tr id="row1911001566093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p311016606093522"><a name="p311016606093522"></a><a name="p311016606093522"></a><a href="graphic.md#ga33de0d99700bd1c289d967458477606f">OHOS::UIRepeatButton::OnLongPressEvent</a> (const <a href="ohos-longpressevent.md">LongPressEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1570374345093522"><a name="p1570374345093522"></a><a name="p1570374345093522"></a>virtual bool </p>
<p id="p898987486093522"><a name="p898987486093522"></a><a name="p898987486093522"></a>The action of long press event. </p>
</td>
</tr>
<tr id="row171830133093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1942174992093522"><a name="p1942174992093522"></a><a name="p1942174992093522"></a><em id="gaba3c785f0e636cd1ac1317b9d3fcf430"><a name="gaba3c785f0e636cd1ac1317b9d3fcf430"></a><a name="gaba3c785f0e636cd1ac1317b9d3fcf430"></a></em>OHOS::UIRepeatButton::HandleTickEvent ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1132154753093522"><a name="p1132154753093522"></a><a name="p1132154753093522"></a><strong id="b339182244"><a name="b339182244"></a><a name="b339182244"></a></strong> void </p>
<p id="p1084087785093522"><a name="p1084087785093522"></a><a name="p1084087785093522"></a>handle the event of long pressing. </p>
</td>
</tr>
<tr id="row494152474093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1221314311093522"><a name="p1221314311093522"></a><a name="p1221314311093522"></a><a href="graphic.md#gad065bfe4e322d036b5bd9e30667754a6">OHOS::UIScrollView::OnScrollListener::OnScrollListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1434443443093522"><a name="p1434443443093522"></a><a name="p1434443443093522"></a> </p>
<p id="p1726394083093522"><a name="p1726394083093522"></a><a name="p1726394083093522"></a>A constructor used to create an <strong id="b1469541848093522"><a name="b1469541848093522"></a><a name="b1469541848093522"></a><a href="ohos-uiscrollview-onscrolllistener.md">OnScrollListener</a></strong> instance with the default scroll state <strong id="b1136060245093522"><a name="b1136060245093522"></a><a name="b1136060245093522"></a>SCROLL_STATE_STOP</strong>. </p>
</td>
</tr>
<tr id="row866043175093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1811023756093522"><a name="p1811023756093522"></a><a name="p1811023756093522"></a><a href="graphic.md#ga14fe076dffea62fdd281cd13e846de2d">OHOS::UIScrollView::OnScrollListener::~OnScrollListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2071845152093522"><a name="p2071845152093522"></a><a name="p2071845152093522"></a>virtual </p>
<p id="p273001015093522"><a name="p273001015093522"></a><a name="p273001015093522"></a>A destructor used to delete the <strong id="b2033105928093522"><a name="b2033105928093522"></a><a name="b2033105928093522"></a><a href="ohos-uiscrollview-onscrolllistener.md">OnScrollListener</a></strong> instance. </p>
</td>
</tr>
<tr id="row1278074402093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p959424348093522"><a name="p959424348093522"></a><a name="p959424348093522"></a><a href="graphic.md#ga8000c484a999483edc66e8dd1b7ceaf6">OHOS::UIScrollView::OnScrollListener::OnScrollStart</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1422488303093522"><a name="p1422488303093522"></a><a name="p1422488303093522"></a>virtual void </p>
<p id="p962447132093522"><a name="p962447132093522"></a><a name="p962447132093522"></a>Called when a scroll starts. </p>
</td>
</tr>
<tr id="row534745066093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1305417688093522"><a name="p1305417688093522"></a><a name="p1305417688093522"></a><a href="graphic.md#ga958c02ddc348eadaaf08f917f55aba63">OHOS::UIScrollView::OnScrollListener::OnScrollEnd</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1508244643093522"><a name="p1508244643093522"></a><a name="p1508244643093522"></a>virtual void </p>
<p id="p1850139192093522"><a name="p1850139192093522"></a><a name="p1850139192093522"></a>Called when a scroll ends. </p>
</td>
</tr>
<tr id="row50532410093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1886978730093522"><a name="p1886978730093522"></a><a name="p1886978730093522"></a><a href="graphic.md#ga15a8abaeb958bfa972b541b59fabd8a7">OHOS::UIScrollView::OnScrollListener::GetScrollState</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p939049242093522"><a name="p939049242093522"></a><a name="p939049242093522"></a>uint8_t </p>
<p id="p774441372093522"><a name="p774441372093522"></a><a name="p774441372093522"></a>Obtains the scroll state of this view. </p>
</td>
</tr>
<tr id="row584160475093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1159181662093522"><a name="p1159181662093522"></a><a name="p1159181662093522"></a><a href="graphic.md#ga83285fe2d337f5d2242204e739e130ab">OHOS::UIScrollView::UIScrollView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p31165204093522"><a name="p31165204093522"></a><a name="p31165204093522"></a> </p>
<p id="p1671941494093522"><a name="p1671941494093522"></a><a name="p1671941494093522"></a>A constructor used to create a <strong id="b742975769093522"><a name="b742975769093522"></a><a name="b742975769093522"></a><a href="ohos-uiscrollview.md">UIScrollView</a></strong> instance, with both horizontal and vertical scrolls supported. </p>
</td>
</tr>
<tr id="row327918336093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1126494464093522"><a name="p1126494464093522"></a><a name="p1126494464093522"></a><a href="graphic.md#ga1b5f674824f5c27038329aa1223b137b">OHOS::UIScrollView::~UIScrollView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p776404336093522"><a name="p776404336093522"></a><a name="p776404336093522"></a>virtual </p>
<p id="p1793356960093522"><a name="p1793356960093522"></a><a name="p1793356960093522"></a>A destructor used to delete the <strong id="b63418515093522"><a name="b63418515093522"></a><a name="b63418515093522"></a><a href="ohos-uiscrollview.md">UIScrollView</a></strong> instance. </p>
</td>
</tr>
<tr id="row585033231093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p707020453093522"><a name="p707020453093522"></a><a name="p707020453093522"></a><a href="graphic.md#ga1feefd393c568a12ec4e877e207d598c">OHOS::UIScrollView::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1011976349093522"><a name="p1011976349093522"></a><a name="p1011976349093522"></a>UIViewType </p>
<p id="p1444134382093522"><a name="p1444134382093522"></a><a name="p1444134382093522"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row1601383641093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2131770361093522"><a name="p2131770361093522"></a><a name="p2131770361093522"></a><a href="graphic.md#ga8a7764e5a85e40b497a67fdf54a1b4c8">OHOS::UIScrollView::OnPostDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p948604663093522"><a name="p948604663093522"></a><a name="p948604663093522"></a>void </p>
<p id="p1949706404093522"><a name="p1949706404093522"></a><a name="p1949706404093522"></a>Called after a view is drawn. </p>
</td>
</tr>
<tr id="row1696889139093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p494017449093522"><a name="p494017449093522"></a><a name="p494017449093522"></a><a href="graphic.md#ga2fde4511d743ccc257308d9a0c035076">OHOS::UIScrollView::OnDragEvent</a> (const <a href="ohos-dragevent.md">DragEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1765664153093522"><a name="p1765664153093522"></a><a name="p1765664153093522"></a>bool </p>
<p id="p349039105093522"><a name="p349039105093522"></a><a name="p349039105093522"></a>Called when the view is being dragged. </p>
</td>
</tr>
<tr id="row1707998598093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p940216812093522"><a name="p940216812093522"></a><a name="p940216812093522"></a><a href="graphic.md#ga05e30354bc97373fbd30f8c045dbbeea">OHOS::UIScrollView::OnDragEndEvent</a> (const <a href="ohos-dragevent.md">DragEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p639587253093522"><a name="p639587253093522"></a><a name="p639587253093522"></a>bool </p>
<p id="p1658269131093522"><a name="p1658269131093522"></a><a name="p1658269131093522"></a>Called when the view stops dragging. </p>
</td>
</tr>
<tr id="row1417339115093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2139266622093522"><a name="p2139266622093522"></a><a name="p2139266622093522"></a><a href="graphic.md#ga54572308575db6d19997343c65d72fbb">OHOS::UIScrollView::OnPressEvent</a> (const <a href="ohos-pressevent.md">PressEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p136842559093522"><a name="p136842559093522"></a><a name="p136842559093522"></a>void </p>
<p id="p864909928093522"><a name="p864909928093522"></a><a name="p864909928093522"></a>Called when the view is pressed. </p>
</td>
</tr>
<tr id="row530104444093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p612528128093522"><a name="p612528128093522"></a><a name="p612528128093522"></a><a href="graphic.md#ga233e426fee2ff5b0973637bb3bf545ee">OHOS::UIScrollView::ScrollBy</a> (int16_t xDistance, int16_t yDistance)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1487877298093522"><a name="p1487877298093522"></a><a name="p1487877298093522"></a>void </p>
<p id="p854095864093522"><a name="p854095864093522"></a><a name="p854095864093522"></a>Scrolls the content of this view. </p>
</td>
</tr>
<tr id="row990686746093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1318466834093522"><a name="p1318466834093522"></a><a name="p1318466834093522"></a><a href="graphic.md#ga992fe30e6840d966688154ea96c362f4">OHOS::UIScrollView::SetScrollbarWidth</a> (uint8_t width)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1448075588093522"><a name="p1448075588093522"></a><a name="p1448075588093522"></a>void </p>
<p id="p172241452093522"><a name="p172241452093522"></a><a name="p172241452093522"></a>Sets the width for this scroll bar. </p>
</td>
</tr>
<tr id="row1617759868093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1499470370093522"><a name="p1499470370093522"></a><a name="p1499470370093522"></a><a href="graphic.md#ga53a40f1c665fc7333e6aac156a1f5b81">OHOS::UIScrollView::SetHorizontalScrollState</a> (bool state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p85744340093522"><a name="p85744340093522"></a><a name="p85744340093522"></a>void </p>
<p id="p14833775093522"><a name="p14833775093522"></a><a name="p14833775093522"></a>Sets whether a horizontal scroll is enabled. </p>
</td>
</tr>
<tr id="row266829209093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1075633747093522"><a name="p1075633747093522"></a><a name="p1075633747093522"></a><a href="graphic.md#ga0549786419ae52253f832a44cad91afe">OHOS::UIScrollView::GetHorizontalScrollState</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2007194474093522"><a name="p2007194474093522"></a><a name="p2007194474093522"></a>bool </p>
<p id="p333582408093522"><a name="p333582408093522"></a><a name="p333582408093522"></a>Checks whether a horizontal scroll is enabled. </p>
</td>
</tr>
<tr id="row64374163093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1477785696093522"><a name="p1477785696093522"></a><a name="p1477785696093522"></a><a href="graphic.md#ga8a6839614c863229666675c289a5cff4">OHOS::UIScrollView::SetVerticalScrollState</a> (bool state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1838280052093522"><a name="p1838280052093522"></a><a name="p1838280052093522"></a>void </p>
<p id="p682019191093522"><a name="p682019191093522"></a><a name="p682019191093522"></a>Sets whether a vertical scroll is enabled. </p>
</td>
</tr>
<tr id="row1087450282093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p199832358093522"><a name="p199832358093522"></a><a name="p199832358093522"></a><a href="graphic.md#gac2095a64edba0fe0483a5475b11b45b2">OHOS::UIScrollView::GetVerticalScrollState</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1238166278093522"><a name="p1238166278093522"></a><a name="p1238166278093522"></a>bool </p>
<p id="p1001998872093522"><a name="p1001998872093522"></a><a name="p1001998872093522"></a>Checks whether a vertical scroll is enabled. </p>
</td>
</tr>
<tr id="row1989970803093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p197072449093522"><a name="p197072449093522"></a><a name="p197072449093522"></a><a href="graphic.md#ga011dae1414a147441e1d32d548545f24">OHOS::UIScrollView::SetXScrollBarVisible</a> (bool state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1916199060093522"><a name="p1916199060093522"></a><a name="p1916199060093522"></a>void </p>
<p id="p573174164093522"><a name="p573174164093522"></a><a name="p573174164093522"></a>Sets whether the horizontal scroll bar is visible. </p>
</td>
</tr>
<tr id="row1067111927093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1213204165093522"><a name="p1213204165093522"></a><a name="p1213204165093522"></a><a href="graphic.md#ga36fcdfce31fab72f54a37062d3f4a6f1">OHOS::UIScrollView::SetYScrollBarVisible</a> (bool state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p140912931093522"><a name="p140912931093522"></a><a name="p140912931093522"></a>void </p>
<p id="p337465562093522"><a name="p337465562093522"></a><a name="p337465562093522"></a>Sets whether the vertical scroll bar is visible. </p>
</td>
</tr>
<tr id="row336156604093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1035505212093522"><a name="p1035505212093522"></a><a name="p1035505212093522"></a><a href="graphic.md#gad66c58c77db0dd0c507e45290ad5cd24">OHOS::UIScrollView::RegisterScrollListener</a> (<a href="ohos-uiscrollview-onscrolllistener.md">OnScrollListener</a> *scrollListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p279657279093522"><a name="p279657279093522"></a><a name="p279657279093522"></a>void </p>
<p id="p715871585093522"><a name="p715871585093522"></a><a name="p715871585093522"></a>Registers a listener that contains a callback to be invoked upon scroll state changes. </p>
</td>
</tr>
<tr id="row1502712409093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p81754228093522"><a name="p81754228093522"></a><a name="p81754228093522"></a><a href="graphic.md#ga67f8d874edcd65b1610117052ceed0a6">OHOS::UISlider::UISlider</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1823768825093522"><a name="p1823768825093522"></a><a name="p1823768825093522"></a> </p>
<p id="p77646317093522"><a name="p77646317093522"></a><a name="p77646317093522"></a>A constructor used to create a <strong id="b747501809093522"><a name="b747501809093522"></a><a name="b747501809093522"></a><a href="ohos-uislider.md">UISlider</a></strong> instance. </p>
</td>
</tr>
<tr id="row1526798393093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p859358818093522"><a name="p859358818093522"></a><a name="p859358818093522"></a><a href="graphic.md#ga024c4f15347a0b70920ab745efe8d250">OHOS::UISlider::~UISlider</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p727864106093522"><a name="p727864106093522"></a><a name="p727864106093522"></a>virtual </p>
<p id="p384162454093522"><a name="p384162454093522"></a><a name="p384162454093522"></a>A destructor used to delete the <strong id="b358467635093522"><a name="b358467635093522"></a><a name="b358467635093522"></a><a href="ohos-uislider.md">UISlider</a></strong> instance. </p>
</td>
</tr>
<tr id="row1550635315093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p771887643093522"><a name="p771887643093522"></a><a name="p771887643093522"></a><a href="graphic.md#gac2070526833718284148689678c542a9">OHOS::UISlider::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p894242212093522"><a name="p894242212093522"></a><a name="p894242212093522"></a>UIViewType </p>
<p id="p1778628990093522"><a name="p1778628990093522"></a><a name="p1778628990093522"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row1553987933093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1993257034093522"><a name="p1993257034093522"></a><a name="p1993257034093522"></a><a href="graphic.md#gaf0de71e2d767ccfc3cb41679185a5529">OHOS::UISlider::SetKnobWidth</a> (int16_t width)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1178509628093522"><a name="p1178509628093522"></a><a name="p1178509628093522"></a>void </p>
<p id="p1418715952093522"><a name="p1418715952093522"></a><a name="p1418715952093522"></a>Sets the width for this knob. </p>
</td>
</tr>
<tr id="row350851703093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1904470687093522"><a name="p1904470687093522"></a><a name="p1904470687093522"></a><a href="graphic.md#ga9bac904abdf8b097778fea5febc1ec00">OHOS::UISlider::GetKnobWidth</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p372031506093522"><a name="p372031506093522"></a><a name="p372031506093522"></a>int16_t </p>
<p id="p1055087161093522"><a name="p1055087161093522"></a><a name="p1055087161093522"></a>Obtains the knob width. </p>
</td>
</tr>
<tr id="row1065067017093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1009536898093522"><a name="p1009536898093522"></a><a name="p1009536898093522"></a><a href="graphic.md#ga0685ff139a48f556a2323d06470ad301">OHOS::UISlider::SetImage</a> (const <a href="ohos-imageinfo.md">ImageInfo</a> *backgroundImage, const <a href="ohos-imageinfo.md">ImageInfo</a> *foregroundImage, const <a href="ohos-imageinfo.md">ImageInfo</a> *knobImage)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1224750682093522"><a name="p1224750682093522"></a><a name="p1224750682093522"></a>void </p>
<p id="p1426909292093522"><a name="p1426909292093522"></a><a name="p1426909292093522"></a>Sets the images as pixel maps for this slider, including the background, foreground, and knob images. </p>
</td>
</tr>
<tr id="row2000915659093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1142961427093522"><a name="p1142961427093522"></a><a name="p1142961427093522"></a><a href="graphic.md#gaea596b36fd10c26361666aeda1aca01e">OHOS::UISlider::SetImage</a> (const char *backgroundImage, const char *foregroundImage, const char *knobImage)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p311173030093522"><a name="p311173030093522"></a><a name="p311173030093522"></a>void </p>
<p id="p583177140093522"><a name="p583177140093522"></a><a name="p583177140093522"></a>Sets the images for this slider, including the background, foreground, and knob images. </p>
</td>
</tr>
<tr id="row1079375310093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p97612086093522"><a name="p97612086093522"></a><a name="p97612086093522"></a><a href="graphic.md#ga8369feb4c08ec7a01e7200a881acb94b">OHOS::UISlider::SetSliderColor</a> (const <a href="ohos-color32.md">ColorType</a> backgroundColor, const <a href="ohos-color32.md">ColorType</a> foregroundColor, const <a href="ohos-color32.md">ColorType</a> knobColor)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1834338679093522"><a name="p1834338679093522"></a><a name="p1834338679093522"></a>void </p>
<p id="p1131503734093522"><a name="p1131503734093522"></a><a name="p1131503734093522"></a>Sets the colors for this slider, including the background, foreground, and knob colors. </p>
</td>
</tr>
<tr id="row799957130093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1978199380093522"><a name="p1978199380093522"></a><a name="p1978199380093522"></a><a href="graphic.md#ga977ead9a79667465b107ca0776868712">OHOS::UISlider::SetSliderRadius</a> (int16_t backgroundRadius, int16_t foregroundRadius, int16_t knobRadius)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p966254689093522"><a name="p966254689093522"></a><a name="p966254689093522"></a>void </p>
<p id="p1784961440093522"><a name="p1784961440093522"></a><a name="p1784961440093522"></a>Sets the corner radiuses for this slider, including the background, foreground, and knob corner radiuses. </p>
</td>
</tr>
<tr id="row441459173093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p479843299093522"><a name="p479843299093522"></a><a name="p479843299093522"></a><a href="graphic.md#gac78f9aa2fe12353627a74f87fe49ef4b">OHOS::UISlider::SetKnobStyle</a> (const <a href="ohos-style.md">Style</a> &amp;style)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p583795580093522"><a name="p583795580093522"></a><a name="p583795580093522"></a>void </p>
<p id="p118630650093522"><a name="p118630650093522"></a><a name="p118630650093522"></a>Sets the knob style. </p>
</td>
</tr>
<tr id="row821856486093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1302409136093522"><a name="p1302409136093522"></a><a name="p1302409136093522"></a><a href="graphic.md#ga80c30c69e9f565269b09fc9d7ded432e">OHOS::UISlider::SetKnobStyle</a> (uint8_t key, int64_t value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1765123236093522"><a name="p1765123236093522"></a><a name="p1765123236093522"></a>void </p>
<p id="p948744366093522"><a name="p948744366093522"></a><a name="p948744366093522"></a>Sets a knob style. </p>
</td>
</tr>
<tr id="row1113811043093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1371764420093522"><a name="p1371764420093522"></a><a name="p1371764420093522"></a><a href="graphic.md#gaecf92fe00a7565d034937e89fe2cf1e6">OHOS::UISlider::GetKnobStyle</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1777300924093522"><a name="p1777300924093522"></a><a name="p1777300924093522"></a>const <a href="ohos-style.md">Style</a> &amp; </p>
<p id="p1050669634093522"><a name="p1050669634093522"></a><a name="p1050669634093522"></a>Obtains the knob style. </p>
</td>
</tr>
<tr id="row1669890386093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1942825484093522"><a name="p1942825484093522"></a><a name="p1942825484093522"></a><a href="graphic.md#ga1fef57bd5d9a11a9c1946e8efec71b61">OHOS::UISlider::GetKnobStyle</a> (uint8_t key) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1220658430093522"><a name="p1220658430093522"></a><a name="p1220658430093522"></a>int64_t </p>
<p id="p1628193122093522"><a name="p1628193122093522"></a><a name="p1628193122093522"></a>Obtains the value of a knob style. </p>
</td>
</tr>
<tr id="row1671396210093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1385620803093522"><a name="p1385620803093522"></a><a name="p1385620803093522"></a><a href="graphic.md#ga05029e55d4ccb50cd45f1cd2a53917e4">OHOS::UISlider::OnClickEvent</a> (const <a href="ohos-clickevent.md">ClickEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1900777658093522"><a name="p1900777658093522"></a><a name="p1900777658093522"></a>void </p>
<p id="p358145617093522"><a name="p358145617093522"></a><a name="p358145617093522"></a>Called when the view is clicked. </p>
</td>
</tr>
<tr id="row292721550093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p5306998093522"><a name="p5306998093522"></a><a name="p5306998093522"></a><a href="graphic.md#ga4481d4453dbf06cc808e4848a814ed7e">OHOS::UISlider::OnDragEvent</a> (const <a href="ohos-dragevent.md">DragEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2138659179093522"><a name="p2138659179093522"></a><a name="p2138659179093522"></a>bool </p>
<p id="p1527225796093522"><a name="p1527225796093522"></a><a name="p1527225796093522"></a>Called when the view is being dragged. </p>
</td>
</tr>
<tr id="row1522206297093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p426737567093522"><a name="p426737567093522"></a><a name="p426737567093522"></a><a href="graphic.md#gae9136559779057065708312fb62304bb">OHOS::UISlider::OnDragEndEvent</a> (const <a href="ohos-dragevent.md">DragEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1603693345093522"><a name="p1603693345093522"></a><a name="p1603693345093522"></a>bool </p>
<p id="p712656684093522"><a name="p712656684093522"></a><a name="p712656684093522"></a>Called when the view stops dragging. </p>
</td>
</tr>
<tr id="row1862919024093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1121205613093522"><a name="p1121205613093522"></a><a name="p1121205613093522"></a><a href="graphic.md#gaf0483e605613ee1789332e67f00f5e2d">OHOS::UISlider::OnPreDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p204139790093522"><a name="p204139790093522"></a><a name="p204139790093522"></a>bool </p>
<p id="p28672322093522"><a name="p28672322093522"></a><a name="p28672322093522"></a>Called before a view is drawn. This function is used to check whether the parent view of this view needs to be redrawn so as to optimize the drawing process. </p>
</td>
</tr>
<tr id="row1294310950093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1217092496093522"><a name="p1217092496093522"></a><a name="p1217092496093522"></a><a href="graphic.md#gad6bd59e05d77868e595d087fd2de5d00">OHOS::UISlider::OnDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p486889702093522"><a name="p486889702093522"></a><a name="p486889702093522"></a>void </p>
<p id="p35101566093522"><a name="p35101566093522"></a><a name="p35101566093522"></a>Called when a view is drawn. </p>
</td>
</tr>
<tr id="row995426263093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p389983902093522"><a name="p389983902093522"></a><a name="p389983902093522"></a><a href="graphic.md#gaf7923989ab1a8cb8a0b643ef65d02134">OHOS::UISlider::UISliderEventListener::~UISliderEventListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1328251130093522"><a name="p1328251130093522"></a><a name="p1328251130093522"></a>virtual </p>
<p id="p52892920093522"><a name="p52892920093522"></a><a name="p52892920093522"></a>A destructor used to delete the <strong id="b1022789514093522"><a name="b1022789514093522"></a><a name="b1022789514093522"></a> <a href="ohos-uislider-uislidereventlistener.md">UISliderEventListener</a> </strong> instance. </p>
</td>
</tr>
<tr id="row154887851093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p300644885093522"><a name="p300644885093522"></a><a name="p300644885093522"></a><a href="graphic.md#ga6044e7ac9a27c7a85cc855dd32e4df5e">OHOS::UISlider::UISliderEventListener::OnChange</a> (int16_t value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p417549574093522"><a name="p417549574093522"></a><a name="p417549574093522"></a>virtual void </p>
<p id="p842385719093522"><a name="p842385719093522"></a><a name="p842385719093522"></a>Called when the slider is dragged or clicked. This is a virtual function, which needs your implementation. </p>
</td>
</tr>
<tr id="row625514892093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1553324005093522"><a name="p1553324005093522"></a><a name="p1553324005093522"></a><a href="graphic.md#gaf8982c429bfa52c1a8a01d1115b596e6">OHOS::UISlider::UISliderEventListener::OnRelease</a> (int16_t value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2146614017093522"><a name="p2146614017093522"></a><a name="p2146614017093522"></a>virtual void </p>
<p id="p1738916628093522"><a name="p1738916628093522"></a><a name="p1738916628093522"></a>Called when the slider is released. This is a virtual function, which needs your implementation. </p>
</td>
</tr>
<tr id="row425521904093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p706070764093522"><a name="p706070764093522"></a><a name="p706070764093522"></a><a href="graphic.md#ga1319a5ea74ad822cb12b0f48c19ccb5d">OHOS::UISlider::SetSliderEventListener</a> (<a href="ohos-uislider-uislidereventlistener.md">UISliderEventListener</a> *listener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1258726203093522"><a name="p1258726203093522"></a><a name="p1258726203093522"></a>void </p>
<p id="p140256989093522"><a name="p140256989093522"></a><a name="p140256989093522"></a>Sets the listener for a slider change. </p>
</td>
</tr>
<tr id="row2047497515093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1450232221093522"><a name="p1450232221093522"></a><a name="p1450232221093522"></a><a href="graphic.md#gab8acc0b7172486e8e5d48c09fcd4c878">OHOS::UISurfaceView::UISurfaceView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p353414794093522"><a name="p353414794093522"></a><a name="p353414794093522"></a> </p>
<p id="p333545809093522"><a name="p333545809093522"></a><a name="p333545809093522"></a>A constructor used to create a <strong id="b40686069093522"><a name="b40686069093522"></a><a name="b40686069093522"></a><a href="ohos-uisurfaceview.md">UISurfaceView</a></strong> instance. </p>
</td>
</tr>
<tr id="row2025998567093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1078982789093522"><a name="p1078982789093522"></a><a name="p1078982789093522"></a><a href="graphic.md#gabf32743913a2a061ace3a5a3c88fe6fa">OHOS::UISurfaceView::~UISurfaceView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1381627237093522"><a name="p1381627237093522"></a><a name="p1381627237093522"></a> </p>
<p id="p2026054229093522"><a name="p2026054229093522"></a><a name="p2026054229093522"></a>A destructor used to delete the <strong id="b245520088093522"><a name="b245520088093522"></a><a name="b245520088093522"></a><a href="ohos-uisurfaceview.md">UISurfaceView</a></strong> instance. </p>
</td>
</tr>
<tr id="row1463167127093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p887706714093522"><a name="p887706714093522"></a><a name="p887706714093522"></a><a href="graphic.md#ga0d19e491e590bdfeeb2a6b3fa1a6b090">OHOS::UISurfaceView::GetSurface</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1427946581093522"><a name="p1427946581093522"></a><a name="p1427946581093522"></a><a href="ohos-surface.md">Surface</a> * </p>
<p id="p1607004160093522"><a name="p1607004160093522"></a><a name="p1607004160093522"></a>Obtains the surface, which should be used together with the camera and video modules. </p>
</td>
</tr>
<tr id="row1124689035093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p71168937093522"><a name="p71168937093522"></a><a name="p71168937093522"></a><a href="graphic.md#ga5d9af67ba074697876ff97f8ece305b7">OHOS::UISurfaceView::SetPosition</a> (int16_t x, int16_t y) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p48706869093522"><a name="p48706869093522"></a><a name="p48706869093522"></a>void </p>
<p id="p507405412093522"><a name="p507405412093522"></a><a name="p507405412093522"></a>Sets the position for this view. </p>
</td>
</tr>
<tr id="row872577749093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1682283444093522"><a name="p1682283444093522"></a><a name="p1682283444093522"></a><a href="graphic.md#ga4a505b3b207653c60161d90750f88a9d">OHOS::UISurfaceView::SetPosition</a> (int16_t x, int16_t y, int16_t width, int16_t height) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1753140081093522"><a name="p1753140081093522"></a><a name="p1753140081093522"></a>void </p>
<p id="p872888924093522"><a name="p872888924093522"></a><a name="p872888924093522"></a>Sets the position and size for this view. </p>
</td>
</tr>
<tr id="row1924014479093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1264430257093522"><a name="p1264430257093522"></a><a name="p1264430257093522"></a><a href="graphic.md#gaa860971513d96f553be4e251f25c0262">OHOS::UISurfaceView::Resize</a> (int16_t width, int16_t height) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p879182843093522"><a name="p879182843093522"></a><a name="p879182843093522"></a>void </p>
<p id="p1441937465093522"><a name="p1441937465093522"></a><a name="p1441937465093522"></a>Adjusts the size of this view. </p>
</td>
</tr>
<tr id="row395350911093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1677900753093522"><a name="p1677900753093522"></a><a name="p1677900753093522"></a><a href="graphic.md#ga87457cce8ab3daa62852815ad36e9692">OHOS::UISurfaceView::SetX</a> (int16_t x) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1421888769093522"><a name="p1421888769093522"></a><a name="p1421888769093522"></a>void </p>
<p id="p766774879093522"><a name="p766774879093522"></a><a name="p766774879093522"></a>Sets the x-coordinate for this view. </p>
</td>
</tr>
<tr id="row1058956944093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p342622494093522"><a name="p342622494093522"></a><a name="p342622494093522"></a><a href="graphic.md#gad7e27c2508753b6752594c3615b5d2fe">OHOS::UISurfaceView::SetY</a> (int16_t y) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p675145796093522"><a name="p675145796093522"></a><a name="p675145796093522"></a>void </p>
<p id="p275673677093522"><a name="p275673677093522"></a><a name="p275673677093522"></a>Sets the y-coordinate for this view. </p>
</td>
</tr>
<tr id="row743952741093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2092279921093522"><a name="p2092279921093522"></a><a name="p2092279921093522"></a><a href="graphic.md#ga54c350b75cf87ca112b3c21791f9c559">OHOS::UISurfaceView::SetWidth</a> (int16_t width) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1019729321093522"><a name="p1019729321093522"></a><a name="p1019729321093522"></a>void </p>
<p id="p968445865093522"><a name="p968445865093522"></a><a name="p968445865093522"></a>Sets the width for this view. </p>
</td>
</tr>
<tr id="row1824139033093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1106163279093522"><a name="p1106163279093522"></a><a name="p1106163279093522"></a><a href="graphic.md#gaf90ada30a3336b947951d408b685787e">OHOS::UISurfaceView::SetHeight</a> (int16_t height) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p725587362093522"><a name="p725587362093522"></a><a name="p725587362093522"></a>void </p>
<p id="p1026047756093522"><a name="p1026047756093522"></a><a name="p1026047756093522"></a>Sets the height for this view. </p>
</td>
</tr>
<tr id="row685396967093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p745489316093522"><a name="p745489316093522"></a><a name="p745489316093522"></a><a href="graphic.md#gaa6b5efec0684a2800dba70c697d3902e">OHOS::UISurfaceView::SetVisible</a> (bool visible) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p74488450093522"><a name="p74488450093522"></a><a name="p74488450093522"></a>void </p>
<p id="p416800890093522"><a name="p416800890093522"></a><a name="p416800890093522"></a>Sets whether this view is visible. </p>
</td>
</tr>
<tr id="row1040790718093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p816786248093522"><a name="p816786248093522"></a><a name="p816786248093522"></a><a href="graphic.md#gaeb15d1fb86ad2e2aabddc9c36676894a">OHOS::UISurfaceView::OnPreDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p900799253093522"><a name="p900799253093522"></a><a name="p900799253093522"></a>bool </p>
<p id="p1667006583093522"><a name="p1667006583093522"></a><a name="p1667006583093522"></a>Called before this view is drawn. This function is used to check whether the parent view of this view needs to be redrawn so that the drawing process is optimized. </p>
</td>
</tr>
<tr id="row33231480093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1252798542093522"><a name="p1252798542093522"></a><a name="p1252798542093522"></a><a href="graphic.md#ga30a99c506c6d8d8fc0e0bd81d52e2d52">OHOS::UISurfaceView::OnDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p375564737093522"><a name="p375564737093522"></a><a name="p375564737093522"></a>void </p>
<p id="p1838224952093522"><a name="p1838224952093522"></a><a name="p1838224952093522"></a>Called when this view is drawn. </p>
</td>
</tr>
<tr id="row747903248093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1104291462093522"><a name="p1104291462093522"></a><a name="p1104291462093522"></a><a href="graphic.md#ga3a460525251fde8e30c35be808151509">OHOS::UISwipeView::UISwipeView</a> (uint8_t direction=<a href="graphic.md#ga34dfbde0fad8baade31c02d9e8dd5026">HORIZONTAL</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p435155732093522"><a name="p435155732093522"></a><a name="p435155732093522"></a> </p>
<p id="p1064595018093522"><a name="p1064595018093522"></a><a name="p1064595018093522"></a>A constructor used to create a <strong id="b1545185919093522"><a name="b1545185919093522"></a><a name="b1545185919093522"></a><a href="ohos-uiswipeview.md">UISwipeView</a></strong> instance. </p>
</td>
</tr>
<tr id="row1436497293093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p414003614093522"><a name="p414003614093522"></a><a name="p414003614093522"></a><a href="graphic.md#gaf51c21b72dcbe790c3bb7b83b53b3cef">OHOS::UISwipeView::~UISwipeView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p391401394093522"><a name="p391401394093522"></a><a name="p391401394093522"></a>virtual </p>
<p id="p953917480093522"><a name="p953917480093522"></a><a name="p953917480093522"></a>A destructor used to delete the <strong id="b1404981280093522"><a name="b1404981280093522"></a><a name="b1404981280093522"></a><a href="ohos-uiswipeview.md">UISwipeView</a></strong> instance. </p>
</td>
</tr>
<tr id="row1930750382093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1873124882093522"><a name="p1873124882093522"></a><a name="p1873124882093522"></a><a href="graphic.md#ga71ae0dd892d8d9b8d277ba2b5572182d">OHOS::UISwipeView::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1129485765093522"><a name="p1129485765093522"></a><a name="p1129485765093522"></a>UIViewType </p>
<p id="p2021611192093522"><a name="p2021611192093522"></a><a name="p2021611192093522"></a>Obtains the component type. </p>
</td>
</tr>
<tr id="row1519961599093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1766000806093522"><a name="p1766000806093522"></a><a name="p1766000806093522"></a><a href="graphic.md#ga29be43640abe185baef5ead904a729cb">OHOS::UISwipeView::SetDirection</a> (uint8_t direction)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p478425501093522"><a name="p478425501093522"></a><a name="p478425501093522"></a>void </p>
<p id="p128314756093522"><a name="p128314756093522"></a><a name="p128314756093522"></a>Sets the dragging direction. </p>
</td>
</tr>
<tr id="row294612976093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2015795142093522"><a name="p2015795142093522"></a><a name="p2015795142093522"></a><a href="graphic.md#gad84dab74af54c23e6e724bdebb8b7df9">OHOS::UISwipeView::GetDirection</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p738784345093522"><a name="p738784345093522"></a><a name="p738784345093522"></a>uint8_t </p>
<p id="p2105804052093522"><a name="p2105804052093522"></a><a name="p2105804052093522"></a>Obtains the dragging direction. </p>
</td>
</tr>
<tr id="row2009642166093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1016745249093522"><a name="p1016745249093522"></a><a name="p1016745249093522"></a><a href="graphic.md#ga1cdc37a33412d6134ed7214300bc1c87">OHOS::UISwipeView::Add</a> (<a href="ohos-uiview.md">UIView</a> *view) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1155840987093522"><a name="p1155840987093522"></a><a name="p1155840987093522"></a>void </p>
<p id="p854379295093522"><a name="p854379295093522"></a><a name="p854379295093522"></a>Adds a view. </p>
</td>
</tr>
<tr id="row1883014570093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p443224557093522"><a name="p443224557093522"></a><a name="p443224557093522"></a><a href="graphic.md#ga154efaf952ba1db65e53efdd29f0027b">OHOS::UISwipeView::Insert</a> (<a href="ohos-uiview.md">UIView</a> *prevView, <a href="ohos-uiview.md">UIView</a> *insertView) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1867105137093522"><a name="p1867105137093522"></a><a name="p1867105137093522"></a>void </p>
<p id="p2063901486093522"><a name="p2063901486093522"></a><a name="p2063901486093522"></a>Inserts a view. </p>
</td>
</tr>
<tr id="row170725370093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p564711481093522"><a name="p564711481093522"></a><a name="p564711481093522"></a><a href="graphic.md#ga2a4f70938a7d2298a318dff6dff95e85">OHOS::UISwipeView::Remove</a> (<a href="ohos-uiview.md">UIView</a> *view) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p681599601093522"><a name="p681599601093522"></a><a name="p681599601093522"></a>virtual void </p>
<p id="p1622643654093522"><a name="p1622643654093522"></a><a name="p1622643654093522"></a>Deletes a view. </p>
</td>
</tr>
<tr id="row16919907093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1118498431093522"><a name="p1118498431093522"></a><a name="p1118498431093522"></a><a href="graphic.md#gaedb8649e42a712463158f42eb66efc33">OHOS::UISwipeView::SetCurrentPage</a> (uint16_t <a href="en-us_topic_0000001055198076.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>, bool needAnimator=false)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1921358224093522"><a name="p1921358224093522"></a><a name="p1921358224093522"></a>void </p>
<p id="p29583282093522"><a name="p29583282093522"></a><a name="p29583282093522"></a>Sets the index for the current tab. </p>
</td>
</tr>
<tr id="row1794975810093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p126953418093522"><a name="p126953418093522"></a><a name="p126953418093522"></a><a href="graphic.md#gaea0c52e94714dff049117227a1fd1849">OHOS::UISwipeView::GetCurrentPage</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1311445009093522"><a name="p1311445009093522"></a><a name="p1311445009093522"></a>uint16_t </p>
<p id="p1062852788093522"><a name="p1062852788093522"></a><a name="p1062852788093522"></a>Obtains the current tab index. </p>
</td>
</tr>
<tr id="row676695717093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1029251303093522"><a name="p1029251303093522"></a><a name="p1029251303093522"></a><a href="graphic.md#ga9b91ece1e4492afd3e4705e49bc511f3">OHOS::UISwipeView::GetCurrentView</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1934005175093522"><a name="p1934005175093522"></a><a name="p1934005175093522"></a><a href="ohos-uiview.md">UIView</a> * </p>
<p id="p492681227093522"><a name="p492681227093522"></a><a name="p492681227093522"></a>Obtains the current view. </p>
</td>
</tr>
<tr id="row1096809993093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1639804295093522"><a name="p1639804295093522"></a><a name="p1639804295093522"></a><a href="graphic.md#ga834d61387b0243cd0505f6d03d32a8f8">OHOS::UISwipeView::SetBlankSize</a> (uint16_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2114089685093522"><a name="p2114089685093522"></a><a name="p2114089685093522"></a>void </p>
<p id="p1959535810093522"><a name="p1959535810093522"></a><a name="p1959535810093522"></a>Sets a blank size, as defined in <a href="graphic.md#ga9d36166760a0a355b29b275404bf709e">DEFAULT_BLANK_SIZE</a>. </p>
</td>
</tr>
<tr id="row912210169093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p619954228093522"><a name="p619954228093522"></a><a name="p619954228093522"></a><a href="graphic.md#ga888ec9a6ddaa4051e7c2e5d76832565c">OHOS::UISwipeView::OnDragEvent</a> (const <a href="ohos-dragevent.md">DragEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2078245121093522"><a name="p2078245121093522"></a><a name="p2078245121093522"></a>bool </p>
<p id="p693386088093522"><a name="p693386088093522"></a><a name="p693386088093522"></a>revice drag event, Switch to specified view when drag </p>
</td>
</tr>
<tr id="row119172238093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p954503897093522"><a name="p954503897093522"></a><a name="p954503897093522"></a><a href="graphic.md#gab57d973cea1186dd90eec91cd27da1fb">OHOS::UISwipeView::OnDragEndEvent</a> (const <a href="ohos-dragevent.md">DragEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1657461352093522"><a name="p1657461352093522"></a><a name="p1657461352093522"></a>bool </p>
<p id="p2005006220093522"><a name="p2005006220093522"></a><a name="p2005006220093522"></a>Called when the view stops dragging. </p>
</td>
</tr>
<tr id="row1871936426093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1234017328093522"><a name="p1234017328093522"></a><a name="p1234017328093522"></a><a href="graphic.md#gadb01e8e5702625c3a99f383eb7ae1664">OHOS::UISwipeView::SetAnimatorTime</a> (uint16_t <a href="en-us_topic_0000001054879478.md#gae7841e681c8c9d59818568d39553642c">time</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p232715212093522"><a name="p232715212093522"></a><a name="p232715212093522"></a>void </p>
<p id="p542110102093522"><a name="p542110102093522"></a><a name="p542110102093522"></a>Sets the time for the page being animated. The page will go beyond the blank during this time. </p>
</td>
</tr>
<tr id="row817251035093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p264853086093522"><a name="p264853086093522"></a><a name="p264853086093522"></a><a href="graphic.md#ga7f7dce8193817e29c9b82af47934d788">OHOS::UISwipeView::SetLoopState</a> (bool loop)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1357208498093522"><a name="p1357208498093522"></a><a name="p1357208498093522"></a>void </p>
<p id="p1436996908093522"><a name="p1436996908093522"></a><a name="p1436996908093522"></a>Sets whether the swipe view supports a cycle swipe. </p>
</td>
</tr>
<tr id="row1121047957093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1308128007093522"><a name="p1308128007093522"></a><a name="p1308128007093522"></a><a href="graphic.md#ga3c58441c4b07cf575b96b85df5e3a3bf">OHOS::UISwipeView::GetViewByIndex</a> (uint16_t <a href="en-us_topic_0000001055198076.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p496582783093522"><a name="p496582783093522"></a><a name="p496582783093522"></a><a href="ohos-uiview.md">UIView</a> * </p>
<p id="p1067430593093522"><a name="p1067430593093522"></a><a name="p1067430593093522"></a>Obtains a view based on its index. </p>
</td>
</tr>
<tr id="row686562853093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p375518631093522"><a name="p375518631093522"></a><a name="p375518631093522"></a><a href="graphic.md#ga4c33414b3a828d1750deed3cceb86daf">OHOS::UISwipeView::GetOnSwipeListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p12291991093522"><a name="p12291991093522"></a><a name="p12291991093522"></a><a href="ohos-uiswipeview-onswipelistener.md">OnSwipeListener</a> *&amp; </p>
<p id="p549520079093522"><a name="p549520079093522"></a><a name="p549520079093522"></a>Obtains the listener set for swipe events. </p>
</td>
</tr>
<tr id="row601903456093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p53227186093522"><a name="p53227186093522"></a><a name="p53227186093522"></a><a href="graphic.md#ga7d4a3dc25f189ab19eaef4a62cd0428e">OHOS::UISwipeView::SetOnSwipeListener</a> (<a href="ohos-uiswipeview-onswipelistener.md">OnSwipeListener</a> *onSwipeListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p9502338093522"><a name="p9502338093522"></a><a name="p9502338093522"></a>void </p>
<p id="p1157492740093522"><a name="p1157492740093522"></a><a name="p1157492740093522"></a>Sets the listener that contains a callback to be invoked upon a swipe event. </p>
</td>
</tr>
<tr id="row472098142093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1444106196093522"><a name="p1444106196093522"></a><a name="p1444106196093522"></a><a href="graphic.md#ga4db88368bb4908ee05aa1137982b6d0e">OHOS::UISwipeView::MoveChildByOffset</a> (int16_t xOffset, int16_t yOffset) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1192932379093522"><a name="p1192932379093522"></a><a name="p1192932379093522"></a>void </p>
<p id="p1157837134093522"><a name="p1157837134093522"></a><a name="p1157837134093522"></a>Moves the position of all child views. </p>
</td>
</tr>
<tr id="row1121495267093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1954542938093522"><a name="p1954542938093522"></a><a name="p1954542938093522"></a><a href="graphic.md#gaff111e4883be7412bfd6a41d769d9e77">OHOS::UITextureMapper::UITextureMapper</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p829120927093522"><a name="p829120927093522"></a><a name="p829120927093522"></a> </p>
<p id="p1110353847093522"><a name="p1110353847093522"></a><a name="p1110353847093522"></a>A constructor used to create a <strong id="b39392131093522"><a name="b39392131093522"></a><a name="b39392131093522"></a><a href="ohos-uitexturemapper.md">UITextureMapper</a></strong> instance. </p>
</td>
</tr>
<tr id="row1088338009093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1467622890093522"><a name="p1467622890093522"></a><a name="p1467622890093522"></a><a href="graphic.md#ga6c7e34e3ecc1d300e647483aed10c4cf">OHOS::UITextureMapper::~UITextureMapper</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p164619362093522"><a name="p164619362093522"></a><a name="p164619362093522"></a>virtual </p>
<p id="p1245203117093522"><a name="p1245203117093522"></a><a name="p1245203117093522"></a>A destructor used to delete the <strong id="b2139698549093522"><a name="b2139698549093522"></a><a name="b2139698549093522"></a><a href="ohos-uitexturemapper.md">UITextureMapper</a></strong> instance. </p>
</td>
</tr>
<tr id="row1775137072093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1269979648093522"><a name="p1269979648093522"></a><a name="p1269979648093522"></a><a href="graphic.md#ga5cb1566d1fdd815004a37349dc458203">OHOS::UITextureMapper::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1076487810093522"><a name="p1076487810093522"></a><a name="p1076487810093522"></a>UIViewType </p>
<p id="p814083032093522"><a name="p814083032093522"></a><a name="p814083032093522"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row1034023723093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p557204454093522"><a name="p557204454093522"></a><a name="p557204454093522"></a><a href="graphic.md#ga83f0469f24917e59c3c6d7b331928014">OHOS::UITextureMapper::Start</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1890207294093522"><a name="p1890207294093522"></a><a name="p1890207294093522"></a>void </p>
<p id="p645857436093522"><a name="p645857436093522"></a><a name="p645857436093522"></a>Starts this animator. </p>
</td>
</tr>
<tr id="row74443591093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1651273606093522"><a name="p1651273606093522"></a><a name="p1651273606093522"></a><a href="graphic.md#ga98a7e074315fdf49b6a9c0663848c9aa">OHOS::UITextureMapper::SetRotateStart</a> (int16_t start)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1596418289093522"><a name="p1596418289093522"></a><a name="p1596418289093522"></a>void </p>
<p id="p624493011093522"><a name="p624493011093522"></a><a name="p624493011093522"></a>Sets the start angle of rotation for this image. </p>
</td>
</tr>
<tr id="row408611827093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p128572378093522"><a name="p128572378093522"></a><a name="p128572378093522"></a><a href="graphic.md#ga9bb2570b86ef683f8a501e98f8689ed5">OHOS::UITextureMapper::SetRotateEnd</a> (int16_t end)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p791900035093522"><a name="p791900035093522"></a><a name="p791900035093522"></a>void </p>
<p id="p2064260644093522"><a name="p2064260644093522"></a><a name="p2064260644093522"></a>Sets the end angle of rotation for this image. </p>
</td>
</tr>
<tr id="row1831738759093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p706225673093522"><a name="p706225673093522"></a><a name="p706225673093522"></a><a href="graphic.md#ga31a2295a15e2e990a1f2484f5756609b">OHOS::UITextureMapper::SetScaleStart</a> (float start)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1329445205093522"><a name="p1329445205093522"></a><a name="p1329445205093522"></a>void </p>
<p id="p914409336093522"><a name="p914409336093522"></a><a name="p914409336093522"></a>Sets the start ratio for scaling this image. </p>
</td>
</tr>
<tr id="row1540053839093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p318054142093522"><a name="p318054142093522"></a><a name="p318054142093522"></a><a href="graphic.md#ga7c7c54ce9ab139498ba286762286c0c0">OHOS::UITextureMapper::SetScaleEnd</a> (float end)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1603628592093522"><a name="p1603628592093522"></a><a name="p1603628592093522"></a>void </p>
<p id="p1959700176093522"><a name="p1959700176093522"></a><a name="p1959700176093522"></a>Sets the end ratio for scaling this image. </p>
</td>
</tr>
<tr id="row2065799026093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1813961223093522"><a name="p1813961223093522"></a><a name="p1813961223093522"></a><a href="graphic.md#gac2727b2cd7aa7abead44717cf0ce7b3c">OHOS::UITextureMapper::SetDurationTime</a> (uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1310224067093522"><a name="p1310224067093522"></a><a name="p1310224067093522"></a>void </p>
<p id="p1560961064093522"><a name="p1560961064093522"></a><a name="p1560961064093522"></a>Sets the duration for this animator, in milliseconds. </p>
</td>
</tr>
<tr id="row2061178833093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1430461524093522"><a name="p1430461524093522"></a><a name="p1430461524093522"></a><a href="graphic.md#gaa2d428cb1098dafb21e7dd24f6ba612f">OHOS::UITextureMapper::SetDelayTime</a> (uint16_t delayTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p73296480093522"><a name="p73296480093522"></a><a name="p73296480093522"></a>void </p>
<p id="p126468857093522"><a name="p126468857093522"></a><a name="p126468857093522"></a>Sets the delay time for this animator, in milliseconds. </p>
</td>
</tr>
<tr id="row540151996093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1911553763093522"><a name="p1911553763093522"></a><a name="p1911553763093522"></a><a href="graphic.md#ga0f099914c2daa13dc6acf3fb28c3f45a">OHOS::UITextureMapper::SetEasingFunc</a> (EasingFunc easingFunc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p187267646093522"><a name="p187267646093522"></a><a name="p187267646093522"></a>void </p>
<p id="p677277091093522"><a name="p677277091093522"></a><a name="p677277091093522"></a>Sets the easing function for this animator. </p>
</td>
</tr>
<tr id="row1408818629093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p674277773093522"><a name="p674277773093522"></a><a name="p674277773093522"></a><a href="graphic.md#gac838ad321786766c6d4020504b07b93b">OHOS::UITextureMapper::Cancel</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2138394862093522"><a name="p2138394862093522"></a><a name="p2138394862093522"></a>void </p>
<p id="p1646306711093522"><a name="p1646306711093522"></a><a name="p1646306711093522"></a>Cancels this animator. </p>
</td>
</tr>
<tr id="row1295259582093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p682864397093522"><a name="p682864397093522"></a><a name="p682864397093522"></a><a href="graphic.md#gac18ead79047d6f63e1ceb5fc52bbff68">OHOS::UITextureMapper::Reset</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2081838367093522"><a name="p2081838367093522"></a><a name="p2081838367093522"></a>void </p>
<p id="p1071567646093522"><a name="p1071567646093522"></a><a name="p1071567646093522"></a>Displays the original image. </p>
</td>
</tr>
<tr id="row972330353093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1114680006093522"><a name="p1114680006093522"></a><a name="p1114680006093522"></a><a href="graphic.md#ga44fa62a21869361527a8af1a10e5276e">OHOS::UITextureMapper::SetPivot</a> (int16_t x, int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p407278513093522"><a name="p407278513093522"></a><a name="p407278513093522"></a>void </p>
<p id="p513662829093522"><a name="p513662829093522"></a><a name="p513662829093522"></a>Sets the coordinates of the rotation and scaling pivots for this image. </p>
</td>
</tr>
<tr id="row1471373182093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p836944333093522"><a name="p836944333093522"></a><a name="p836944333093522"></a><a href="graphic.md#ga7165af78c57699d722f5264dcdf5d6dd">OHOS::UITextureMapper::AnimatorStopListener::~AnimatorStopListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1755507611093522"><a name="p1755507611093522"></a><a name="p1755507611093522"></a>virtual </p>
<p id="p783838002093522"><a name="p783838002093522"></a><a name="p783838002093522"></a>A destructor used to delete an <strong id="b84889096093522"><a name="b84889096093522"></a><a name="b84889096093522"></a><a href="ohos-uitexturemapper-animatorstoplistener.md">AnimatorStopListener</a></strong> instance. </p>
</td>
</tr>
<tr id="row357319421093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p403891333093522"><a name="p403891333093522"></a><a name="p403891333093522"></a><a href="graphic.md#ga20fee882d590dd429742acff4357ea67">OHOS::UITextureMapper::AnimatorStopListener::OnAnimatorStop</a> (<a href="ohos-uiview.md">UIView</a> &amp;view)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2020261502093522"><a name="p2020261502093522"></a><a name="p2020261502093522"></a>virtual void </p>
<p id="p1545620430093522"><a name="p1545620430093522"></a><a name="p1545620430093522"></a>Called when this animator stops. This is a pure virtual function, which needs your inheritance and implementation. </p>
</td>
</tr>
<tr id="row688723076093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p187857566093522"><a name="p187857566093522"></a><a name="p187857566093522"></a><a href="graphic.md#gaab25406cdcb4af33cfd2cc2c31037d27">OHOS::UITextureMapper::SetAnimatorStopListener</a> (<a href="ohos-uitexturemapper-animatorstoplistener.md">AnimatorStopListener</a> *listener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p851869573093522"><a name="p851869573093522"></a><a name="p851869573093522"></a>void </p>
<p id="p1886324262093522"><a name="p1886324262093522"></a><a name="p1886324262093522"></a>Sets the listener for the stop of this animator. </p>
</td>
</tr>
<tr id="row1213143362093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1716063128093522"><a name="p1716063128093522"></a><a name="p1716063128093522"></a><a href="graphic.md#ga125b46b02ee28c0ba6403ef024196b03">OHOS::UITimePicker::UITimePicker</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1605484327093522"><a name="p1605484327093522"></a><a name="p1605484327093522"></a> </p>
<p id="p150541536093522"><a name="p150541536093522"></a><a name="p150541536093522"></a>A constructor used to create a <strong id="b964765554093522"><a name="b964765554093522"></a><a name="b964765554093522"></a><a href="ohos-uitimepicker.md">UITimePicker</a></strong> instance. </p>
</td>
</tr>
<tr id="row1065235199093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p234785462093522"><a name="p234785462093522"></a><a name="p234785462093522"></a><a href="graphic.md#gaf5906b1a1389a599c0086f25cfc02fa0">OHOS::UITimePicker::~UITimePicker</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p456819541093522"><a name="p456819541093522"></a><a name="p456819541093522"></a>virtual </p>
<p id="p824703542093522"><a name="p824703542093522"></a><a name="p824703542093522"></a>A destructor used to delete the <strong id="b2105734633093522"><a name="b2105734633093522"></a><a name="b2105734633093522"></a><a href="ohos-uitimepicker.md">UITimePicker</a></strong> instance. </p>
</td>
</tr>
<tr id="row1726812406093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p769830109093522"><a name="p769830109093522"></a><a name="p769830109093522"></a><a href="graphic.md#gaf4770cfad2f6368b22e9ea581b12aefa">OHOS::UITimePicker::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p17772741093522"><a name="p17772741093522"></a><a name="p17772741093522"></a>UIViewType </p>
<p id="p2043215067093522"><a name="p2043215067093522"></a><a name="p2043215067093522"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row860421849093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1324550676093522"><a name="p1324550676093522"></a><a name="p1324550676093522"></a><a href="graphic.md#gaecddab27ffd11267d3f613a1cf7f1549">OHOS::UITimePicker::SetSelected</a> (const char *value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p33344520093522"><a name="p33344520093522"></a><a name="p33344520093522"></a>bool </p>
<p id="p136417702093522"><a name="p136417702093522"></a><a name="p136417702093522"></a>Sets the time currently selected in the time picker. </p>
</td>
</tr>
<tr id="row1026973056093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1371498223093522"><a name="p1371498223093522"></a><a name="p1371498223093522"></a><a href="graphic.md#gac8c1732e78fa64af294694b2bbb35366">OHOS::UITimePicker::GetSelectValue</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1242135708093522"><a name="p1242135708093522"></a><a name="p1242135708093522"></a>const char * </p>
<p id="p1032116112093522"><a name="p1032116112093522"></a><a name="p1032116112093522"></a>Obtains the time currently selected in the time picker. </p>
</td>
</tr>
<tr id="row916110899093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1210461112093522"><a name="p1210461112093522"></a><a name="p1210461112093522"></a><a href="graphic.md#gac6475a538bb4e0e839dd8f9b0e3ae200">OHOS::UITimePicker::GetSelectHour</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p510154901093522"><a name="p510154901093522"></a><a name="p510154901093522"></a>const char * </p>
<p id="p97026015093522"><a name="p97026015093522"></a><a name="p97026015093522"></a>Obtains the hour currently selected in the time picker. </p>
</td>
</tr>
<tr id="row979333280093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2021254003093522"><a name="p2021254003093522"></a><a name="p2021254003093522"></a><a href="graphic.md#ga0ccecc8d45fdda042ea0667ab9cc1181">OHOS::UITimePicker::GetSelectMinute</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1294908909093522"><a name="p1294908909093522"></a><a name="p1294908909093522"></a>const char * </p>
<p id="p681598814093522"><a name="p681598814093522"></a><a name="p681598814093522"></a>Obtains the minute currently selected in the time picker. </p>
</td>
</tr>
<tr id="row1590345373093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p347801100093522"><a name="p347801100093522"></a><a name="p347801100093522"></a><a href="graphic.md#ga2e02f298f9b9bcf0520ebd2d0ef40677">OHOS::UITimePicker::GetSelectSecond</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p600114485093522"><a name="p600114485093522"></a><a name="p600114485093522"></a>const char * </p>
<p id="p526729793093522"><a name="p526729793093522"></a><a name="p526729793093522"></a>Obtains the second currently selected in the time picker. </p>
</td>
</tr>
<tr id="row297327824093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1658526404093522"><a name="p1658526404093522"></a><a name="p1658526404093522"></a><a href="graphic.md#ga54e8588b0be58272d1fef244c5e9ba27">OHOS::UITimePicker::SetItemHeight</a> (int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1715284955093522"><a name="p1715284955093522"></a><a name="p1715284955093522"></a>void </p>
<p id="p218160033093522"><a name="p218160033093522"></a><a name="p218160033093522"></a>Sets the height of each item in the time picker. </p>
</td>
</tr>
<tr id="row1684940683093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p559840597093522"><a name="p559840597093522"></a><a name="p559840597093522"></a><a href="graphic.md#gaa2402a0538f08fb4d6857c356be7699c">OHOS::UITimePicker::EnableSecond</a> (bool state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p175136071093522"><a name="p175136071093522"></a><a name="p175136071093522"></a>void </p>
<p id="p1954509328093522"><a name="p1954509328093522"></a><a name="p1954509328093522"></a>Sets whether to enable seconds in the time picker. </p>
</td>
</tr>
<tr id="row879138668093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p55983063093522"><a name="p55983063093522"></a><a name="p55983063093522"></a><a href="graphic.md#gab1847d20b4ae671aaa512f978e043ee1">OHOS::UITimePicker::SetTextStyle</a> (uint8_t backgroundFontId, uint8_t highlightFontId, <a href="ohos-color32.md">ColorType</a> backgroundColor, <a href="ohos-color32.md">ColorType</a> highlightColor)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p732680639093522"><a name="p732680639093522"></a><a name="p732680639093522"></a>void </p>
<p id="p1873910755093522"><a name="p1873910755093522"></a><a name="p1873910755093522"></a>Sets the text format in the time picker, including the font ID and color. </p>
</td>
</tr>
<tr id="row2048593202093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p453870006093522"><a name="p453870006093522"></a><a name="p453870006093522"></a><a href="graphic.md#gad8dc3b2df7fe8aed16776a063efc8b4b">OHOS::UITimePicker::SetWidth</a> (int16_t width) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p793271978093522"><a name="p793271978093522"></a><a name="p793271978093522"></a>void </p>
<p id="p2061893844093522"><a name="p2061893844093522"></a><a name="p2061893844093522"></a>Sets the width for the time picker. </p>
</td>
</tr>
<tr id="row2095495173093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p469115180093522"><a name="p469115180093522"></a><a name="p469115180093522"></a><a href="graphic.md#ga06667e791f24098f22ef096ee6af77ad">OHOS::UITimePicker::SetHeight</a> (int16_t height) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1041315414093522"><a name="p1041315414093522"></a><a name="p1041315414093522"></a>void </p>
<p id="p594208440093522"><a name="p594208440093522"></a><a name="p594208440093522"></a>Sets the height for the time picker. </p>
</td>
</tr>
<tr id="row1862510180093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2051852432093522"><a name="p2051852432093522"></a><a name="p2051852432093522"></a><a href="graphic.md#gaf68f896c9d4e4c14a56c201d8e4b3db1">OHOS::UITimePicker::SelectedListener::SelectedListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p203757207093522"><a name="p203757207093522"></a><a name="p203757207093522"></a> </p>
<p id="p766858908093522"><a name="p766858908093522"></a><a name="p766858908093522"></a>A constructor used to create a <strong id="b1051997094093522"><a name="b1051997094093522"></a><a name="b1051997094093522"></a><a href="ohos-uitimepicker-selectedlistener.md">SelectedListener</a></strong> instance. </p>
</td>
</tr>
<tr id="row86994285093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p934140089093522"><a name="p934140089093522"></a><a name="p934140089093522"></a><a href="graphic.md#ga59db1409429fa0c598e3cf70a8ec2738">OHOS::UITimePicker::SelectedListener::~SelectedListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1249459814093522"><a name="p1249459814093522"></a><a name="p1249459814093522"></a> </p>
<p id="p1729002426093522"><a name="p1729002426093522"></a><a name="p1729002426093522"></a>A destructor used to delete the <strong id="b1400998590093522"><a name="b1400998590093522"></a><a name="b1400998590093522"></a><a href="ohos-uitimepicker-selectedlistener.md">SelectedListener</a></strong> instance. </p>
</td>
</tr>
<tr id="row1204666637093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1752796511093522"><a name="p1752796511093522"></a><a name="p1752796511093522"></a><a href="graphic.md#ga525c9a0f0c5b51e0086a53dc5b0b5301">OHOS::UITimePicker::SelectedListener::OnTimePickerStoped</a> (<a href="ohos-uitimepicker.md">UITimePicker</a> &amp;picker)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p456612181093522"><a name="p456612181093522"></a><a name="p456612181093522"></a>virtual void </p>
<p id="p1229976654093522"><a name="p1229976654093522"></a><a name="p1229976654093522"></a>Called when an item is selected after sliding stops. This function is implemented by applications. </p>
</td>
</tr>
<tr id="row262828453093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1780928597093522"><a name="p1780928597093522"></a><a name="p1780928597093522"></a><a href="graphic.md#gaa49ecf72e74e9b835c6fc19c701bf454">OHOS::UITimePicker::RegisterSelectedListener</a> (<a href="ohos-uitimepicker-selectedlistener.md">SelectedListener</a> *timePickerListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1529998737093522"><a name="p1529998737093522"></a><a name="p1529998737093522"></a>void </p>
<p id="p1479758481093522"><a name="p1479758481093522"></a><a name="p1479758481093522"></a>Registers a listener for a selected event. </p>
</td>
</tr>
<tr id="row858712916093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1512764750093522"><a name="p1512764750093522"></a><a name="p1512764750093522"></a><a href="graphic.md#ga98d6bb49e21d7748020b75a9f5f1c61d">OHOS::UIToggleButton::UIToggleButton</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1541017672093522"><a name="p1541017672093522"></a><a name="p1541017672093522"></a> </p>
<p id="p611456286093522"><a name="p611456286093522"></a><a name="p611456286093522"></a>A constructor used to create a <strong id="b98049511093522"><a name="b98049511093522"></a><a name="b98049511093522"></a><a href="ohos-uitogglebutton.md">UIToggleButton</a></strong> instance. </p>
</td>
</tr>
<tr id="row1009424319093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2045065228093522"><a name="p2045065228093522"></a><a name="p2045065228093522"></a><a href="graphic.md#ga4946fb71fed32a4f328ecdd1da3141c5">OHOS::UIToggleButton::~UIToggleButton</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1143492219093522"><a name="p1143492219093522"></a><a name="p1143492219093522"></a>virtual </p>
<p id="p1256630076093522"><a name="p1256630076093522"></a><a name="p1256630076093522"></a>A destructor used to delete the <strong id="b2047321367093522"><a name="b2047321367093522"></a><a name="b2047321367093522"></a><a href="ohos-uitogglebutton.md">UIToggleButton</a></strong> instance. </p>
</td>
</tr>
<tr id="row447330743093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1639723042093522"><a name="p1639723042093522"></a><a name="p1639723042093522"></a><a href="graphic.md#gaeb2bf2bfa7b5f229a151bec4fd046b40">OHOS::UIToggleButton::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p628925075093522"><a name="p628925075093522"></a><a name="p628925075093522"></a>UIViewType </p>
<p id="p1566854376093522"><a name="p1566854376093522"></a><a name="p1566854376093522"></a>Obtains the component type. </p>
</td>
</tr>
<tr id="row330236470093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1014292256093522"><a name="p1014292256093522"></a><a name="p1014292256093522"></a><a href="graphic.md#ga73354e99d22f2fe8b44f1c11c8d62fd0">OHOS::UIToggleButton::SetState</a> (bool state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p434207668093522"><a name="p434207668093522"></a><a name="p434207668093522"></a>void </p>
<p id="p1497195096093522"><a name="p1497195096093522"></a><a name="p1497195096093522"></a>Sets the state for this toggle button. </p>
</td>
</tr>
<tr id="row1347776553093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p37252937093522"><a name="p37252937093522"></a><a name="p37252937093522"></a><a href="graphic.md#gad46154853ea44173988a82fa366f16db">OHOS::UIToggleButton::GetState</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p207367546093522"><a name="p207367546093522"></a><a name="p207367546093522"></a>bool </p>
<p id="p1772269635093522"><a name="p1772269635093522"></a><a name="p1772269635093522"></a>Obtains the state of this toggle button. </p>
</td>
</tr>
<tr id="row177335004093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1146646401093522"><a name="p1146646401093522"></a><a name="p1146646401093522"></a><a href="graphic.md#gaea43f140dccee06b1e720b66c08c745b">OHOS::UIView::OnClickListener::OnClick</a> (<a href="ohos-uiview.md">UIView</a> &amp;view, const <a href="ohos-clickevent.md">ClickEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1035698852093522"><a name="p1035698852093522"></a><a name="p1035698852093522"></a>virtual bool </p>
<p id="p1130228671093522"><a name="p1130228671093522"></a><a name="p1130228671093522"></a>Called when a view is clicked. </p>
</td>
</tr>
<tr id="row440547635093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1226382377093522"><a name="p1226382377093522"></a><a name="p1226382377093522"></a><a href="graphic.md#ga53fcaf6484a178d452c76f0f1b493e99">OHOS::UIView::OnClickListener::~OnClickListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1633932008093522"><a name="p1633932008093522"></a><a name="p1633932008093522"></a>virtual </p>
<p id="p623896978093522"><a name="p623896978093522"></a><a name="p623896978093522"></a>A destructor used to delete the <strong id="b629774723093522"><a name="b629774723093522"></a><a name="b629774723093522"></a><a href="ohos-uiview-onclicklistener.md">OnClickListener</a></strong> instance. </p>
</td>
</tr>
<tr id="row100063905093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p393284736093522"><a name="p393284736093522"></a><a name="p393284736093522"></a><a href="graphic.md#gadd8ba1ff84abfc796ddeb9c6e5d46497">OHOS::UIView::OnLongPressListener::OnLongPress</a> (<a href="ohos-uiview.md">UIView</a> &amp;view, const <a href="ohos-longpressevent.md">LongPressEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p719058808093522"><a name="p719058808093522"></a><a name="p719058808093522"></a>virtual bool </p>
<p id="p257235274093522"><a name="p257235274093522"></a><a name="p257235274093522"></a>Called when a view is long pressed. </p>
</td>
</tr>
<tr id="row1601270694093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p649955739093522"><a name="p649955739093522"></a><a name="p649955739093522"></a><a href="graphic.md#ga80d9a933818b4ae9c3f34fe78f65a8f6">OHOS::UIView::OnLongPressListener::~OnLongPressListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1248448421093522"><a name="p1248448421093522"></a><a name="p1248448421093522"></a>virtual </p>
<p id="p2127492221093522"><a name="p2127492221093522"></a><a name="p2127492221093522"></a>A destructor used to delete the <strong id="b438068307093522"><a name="b438068307093522"></a><a name="b438068307093522"></a><a href="ohos-uiview-onlongpresslistener.md">OnLongPressListener</a></strong> instance. </p>
</td>
</tr>
<tr id="row1011665729093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p381635761093522"><a name="p381635761093522"></a><a name="p381635761093522"></a><a href="graphic.md#ga876bada94186d79c03de6da64c26e636">OHOS::UIView::OnDragListener::OnDragStart</a> (<a href="ohos-uiview.md">UIView</a> &amp;view, const <a href="ohos-dragevent.md">DragEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1405710073093522"><a name="p1405710073093522"></a><a name="p1405710073093522"></a>virtual bool </p>
<p id="p1249236922093522"><a name="p1249236922093522"></a><a name="p1249236922093522"></a>Called when a view starts to drag. </p>
</td>
</tr>
<tr id="row1022986886093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1648551073093522"><a name="p1648551073093522"></a><a name="p1648551073093522"></a><a href="graphic.md#gac112ce602c6939a52781d13440255b0c">OHOS::UIView::OnDragListener::OnDrag</a> (<a href="ohos-uiview.md">UIView</a> &amp;view, const <a href="ohos-dragevent.md">DragEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p605387143093522"><a name="p605387143093522"></a><a name="p605387143093522"></a>virtual bool </p>
<p id="p1330624692093522"><a name="p1330624692093522"></a><a name="p1330624692093522"></a>Called when a view is being dragged. </p>
</td>
</tr>
<tr id="row314096141093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p3357831093522"><a name="p3357831093522"></a><a name="p3357831093522"></a><a href="graphic.md#gab9e57971ae7e9925eaa3ccef245cbd72">OHOS::UIView::OnDragListener::OnDragEnd</a> (<a href="ohos-uiview.md">UIView</a> &amp;view, const <a href="ohos-dragevent.md">DragEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1796343626093522"><a name="p1796343626093522"></a><a name="p1796343626093522"></a>virtual bool </p>
<p id="p1351272188093522"><a name="p1351272188093522"></a><a name="p1351272188093522"></a>Called when a view stops dragging. </p>
</td>
</tr>
<tr id="row1493671414093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1898077462093522"><a name="p1898077462093522"></a><a name="p1898077462093522"></a><a href="graphic.md#ga34c01de74c319674fc94d1d74bb6e77e">OHOS::UIView::OnDragListener::~OnDragListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p224413535093522"><a name="p224413535093522"></a><a name="p224413535093522"></a>virtual </p>
<p id="p1072050324093522"><a name="p1072050324093522"></a><a name="p1072050324093522"></a>A destructor used to delete the <strong id="b1704876104093522"><a name="b1704876104093522"></a><a name="b1704876104093522"></a><a href="ohos-uiview-ondraglistener.md">OnDragListener</a></strong> instance. </p>
</td>
</tr>
<tr id="row1908297436093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p410279273093522"><a name="p410279273093522"></a><a name="p410279273093522"></a><a href="graphic.md#ga2cfaed7013dc76bcbe9a5ea5d51caac3">OHOS::UIView::OnTouchListener::OnPress</a> (<a href="ohos-uiview.md">UIView</a> &amp;view, const <a href="ohos-pressevent.md">PressEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1079098276093522"><a name="p1079098276093522"></a><a name="p1079098276093522"></a>virtual bool </p>
<p id="p194862638093522"><a name="p194862638093522"></a><a name="p194862638093522"></a>Called when a view is pressed. </p>
</td>
</tr>
<tr id="row1894072293093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1682254034093522"><a name="p1682254034093522"></a><a name="p1682254034093522"></a><a href="graphic.md#ga16fa19e254ae19fe181dba0ac9dd5d1f">OHOS::UIView::OnTouchListener::OnRelease</a> (<a href="ohos-uiview.md">UIView</a> &amp;view, const <a href="ohos-releaseevent.md">ReleaseEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1106153041093522"><a name="p1106153041093522"></a><a name="p1106153041093522"></a>virtual bool </p>
<p id="p1935385832093522"><a name="p1935385832093522"></a><a name="p1935385832093522"></a>Called when a view is released. </p>
</td>
</tr>
<tr id="row1452332498093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p752765529093522"><a name="p752765529093522"></a><a name="p752765529093522"></a><a href="graphic.md#ga7ce030676f1222599dd6367cd4b9cf7e">OHOS::UIView::OnTouchListener::OnCancel</a> (<a href="ohos-uiview.md">UIView</a> &amp;view, const <a href="ohos-cancelevent.md">CancelEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p168053852093522"><a name="p168053852093522"></a><a name="p168053852093522"></a>virtual bool </p>
<p id="p391295298093522"><a name="p391295298093522"></a><a name="p391295298093522"></a>Called when a click event on a view is canceled. </p>
</td>
</tr>
<tr id="row112518987093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1055087853093522"><a name="p1055087853093522"></a><a name="p1055087853093522"></a><a href="graphic.md#gacf19bb5f0c979bb6889d30a20b2737e1">OHOS::UIView::OnTouchListener::~OnTouchListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1542412653093522"><a name="p1542412653093522"></a><a name="p1542412653093522"></a>virtual </p>
<p id="p1818198928093522"><a name="p1818198928093522"></a><a name="p1818198928093522"></a>A destructor used to delete the <strong id="b1834515098093522"><a name="b1834515098093522"></a><a name="b1834515098093522"></a><a href="ohos-uiview-ontouchlistener.md">OnTouchListener</a></strong> instance. </p>
</td>
</tr>
<tr id="row1189414458093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1290244667093522"><a name="p1290244667093522"></a><a name="p1290244667093522"></a><a href="graphic.md#ga7aad5b50d945efe5f9304bc978b2001c">OHOS::UIView::UIView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p677171613093522"><a name="p677171613093522"></a><a name="p677171613093522"></a> </p>
<p id="p1034914085093522"><a name="p1034914085093522"></a><a name="p1034914085093522"></a>A default constructor used to create an <strong id="b1281451618093522"><a name="b1281451618093522"></a><a name="b1281451618093522"></a><a href="ohos-uiview.md">UIView</a></strong> instance. </p>
</td>
</tr>
<tr id="row1126477934093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p956273889093522"><a name="p956273889093522"></a><a name="p956273889093522"></a><a href="graphic.md#ga57d429bb1cd71782f3b825f1bc6b9362">OHOS::UIView::UIView</a> (const char *id)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p211558854093522"><a name="p211558854093522"></a><a name="p211558854093522"></a> </p>
<p id="p661972573093522"><a name="p661972573093522"></a><a name="p661972573093522"></a>A constructor used to create an <strong id="b360520624093522"><a name="b360520624093522"></a><a name="b360520624093522"></a><a href="ohos-uiview.md">UIView</a></strong> instance. </p>
</td>
</tr>
<tr id="row1070695273093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p222920339093522"><a name="p222920339093522"></a><a name="p222920339093522"></a><a href="graphic.md#ga17f0ffc1090bdcce0f88288da5962012">OHOS::UIView::~UIView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1899285412093522"><a name="p1899285412093522"></a><a name="p1899285412093522"></a>virtual </p>
<p id="p1913672389093522"><a name="p1913672389093522"></a><a name="p1913672389093522"></a>A destructor used to delete the <strong id="b2107512935093522"><a name="b2107512935093522"></a><a name="b2107512935093522"></a><a href="ohos-uiview.md">UIView</a></strong> instance. </p>
</td>
</tr>
<tr id="row551963163093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1732316001093522"><a name="p1732316001093522"></a><a name="p1732316001093522"></a><a href="graphic.md#gac295fe4851eed72f48e9a63771416d71">OHOS::UIView::OnPreDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p72509823093522"><a name="p72509823093522"></a><a name="p72509823093522"></a>virtual bool </p>
<p id="p2001810620093522"><a name="p2001810620093522"></a><a name="p2001810620093522"></a>Called before a view is drawn. This function is used to check whether the parent view of this view needs to be redrawn so as to optimize the drawing process. </p>
</td>
</tr>
<tr id="row1086917653093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1221755636093522"><a name="p1221755636093522"></a><a name="p1221755636093522"></a><a href="graphic.md#ga9a5f43bdc03cde30323b570bfb7ae425">OHOS::UIView::OnDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1133824786093522"><a name="p1133824786093522"></a><a name="p1133824786093522"></a>virtual void </p>
<p id="p946802318093522"><a name="p946802318093522"></a><a name="p946802318093522"></a>Called when a view is drawn. </p>
</td>
</tr>
<tr id="row967592662093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p779331076093522"><a name="p779331076093522"></a><a name="p779331076093522"></a><a href="graphic.md#gab70473cd0d8fe7c9d4bb817caeee9153">OHOS::UIView::OnPostDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1503475461093522"><a name="p1503475461093522"></a><a name="p1503475461093522"></a>virtual void </p>
<p id="p337095182093522"><a name="p337095182093522"></a><a name="p337095182093522"></a>Called after a view is drawn. </p>
</td>
</tr>
<tr id="row1305265338093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p407238484093522"><a name="p407238484093522"></a><a name="p407238484093522"></a><a href="graphic.md#ga81726238adeda1efa989be6ed4f4fe5b">OHOS::UIView::ReMeasure</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1188559137093522"><a name="p1188559137093522"></a><a name="p1188559137093522"></a>virtual void </p>
<p id="p149683650093522"><a name="p149683650093522"></a><a name="p149683650093522"></a>Remeasures the view size. </p>
</td>
</tr>
<tr id="row1799854882093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1399218021093522"><a name="p1399218021093522"></a><a name="p1399218021093522"></a><a href="graphic.md#ga2a9a38b8450fbb196277238a51fbbf99">OHOS::UIView::Invalidate</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p125812136093522"><a name="p125812136093522"></a><a name="p125812136093522"></a>void </p>
<p id="p2085801230093522"><a name="p2085801230093522"></a><a name="p2085801230093522"></a>Refreshes the invalidated area of the view. </p>
</td>
</tr>
<tr id="row917710146093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1061738373093522"><a name="p1061738373093522"></a><a name="p1061738373093522"></a><a href="graphic.md#gaf0e6b65ced8b931642f2a80c195962d2">OHOS::UIView::InvalidateRect</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1987600275093522"><a name="p1987600275093522"></a><a name="p1987600275093522"></a>void </p>
<p id="p252609081093522"><a name="p252609081093522"></a><a name="p252609081093522"></a>Refreshes a view in a specified invalidated area. </p>
</td>
</tr>
<tr id="row1424999351093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p924011508093522"><a name="p924011508093522"></a><a name="p924011508093522"></a><a href="graphic.md#gac311aa47301d727c35fc31f8630d016e">OHOS::UIView::OnLongPressEvent</a> (const <a href="ohos-longpressevent.md">LongPressEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p388597246093522"><a name="p388597246093522"></a><a name="p388597246093522"></a>virtual bool </p>
<p id="p2019353921093522"><a name="p2019353921093522"></a><a name="p2019353921093522"></a>Called when the view is long pressed. </p>
</td>
</tr>
<tr id="row1038148429093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1035154527093522"><a name="p1035154527093522"></a><a name="p1035154527093522"></a><a href="graphic.md#gac0e10556ff99b8a92bfb11df6456d605">OHOS::UIView::OnDragStartEvent</a> (const <a href="ohos-dragevent.md">DragEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2064426769093522"><a name="p2064426769093522"></a><a name="p2064426769093522"></a>virtual bool </p>
<p id="p74239285093522"><a name="p74239285093522"></a><a name="p74239285093522"></a>Called when the view starts to drag. </p>
</td>
</tr>
<tr id="row500977293093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p725631885093522"><a name="p725631885093522"></a><a name="p725631885093522"></a><a href="graphic.md#ga46249c8caf06b81590d9450e30a31147">OHOS::UIView::OnDragEvent</a> (const <a href="ohos-dragevent.md">DragEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p585017885093522"><a name="p585017885093522"></a><a name="p585017885093522"></a>virtual bool </p>
<p id="p2055204643093522"><a name="p2055204643093522"></a><a name="p2055204643093522"></a>Called when the view is being dragged. </p>
</td>
</tr>
<tr id="row1926199329093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1007443583093522"><a name="p1007443583093522"></a><a name="p1007443583093522"></a><a href="graphic.md#ga1799d33be73f64ed2066f50d7e65468d">OHOS::UIView::OnDragEndEvent</a> (const <a href="ohos-dragevent.md">DragEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p10267500093522"><a name="p10267500093522"></a><a name="p10267500093522"></a>virtual bool </p>
<p id="p617500415093522"><a name="p617500415093522"></a><a name="p617500415093522"></a>Called when the view stops dragging. </p>
</td>
</tr>
<tr id="row96209661093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p383034192093522"><a name="p383034192093522"></a><a name="p383034192093522"></a><a href="graphic.md#gad08697a29aae4c58267f494b66b9a547">OHOS::UIView::OnClickEvent</a> (const <a href="ohos-clickevent.md">ClickEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1095041928093522"><a name="p1095041928093522"></a><a name="p1095041928093522"></a>virtual void </p>
<p id="p1404271020093522"><a name="p1404271020093522"></a><a name="p1404271020093522"></a>Called when the view is clicked. </p>
</td>
</tr>
<tr id="row1120865841093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p290416860093522"><a name="p290416860093522"></a><a name="p290416860093522"></a><a href="graphic.md#gafa544ff2d27785a9410a80689f1ad3b1">OHOS::UIView::OnPressEvent</a> (const <a href="ohos-pressevent.md">PressEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1035760016093522"><a name="p1035760016093522"></a><a name="p1035760016093522"></a>virtual void </p>
<p id="p270891316093522"><a name="p270891316093522"></a><a name="p270891316093522"></a>Called when the view is pressed. </p>
</td>
</tr>
<tr id="row1609489835093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1544505397093522"><a name="p1544505397093522"></a><a name="p1544505397093522"></a><a href="graphic.md#ga7bd1a74563b059b03fbf66f9add53ee3">OHOS::UIView::OnReleaseEvent</a> (const <a href="ohos-releaseevent.md">ReleaseEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p668241072093522"><a name="p668241072093522"></a><a name="p668241072093522"></a>virtual void </p>
<p id="p1053595529093522"><a name="p1053595529093522"></a><a name="p1053595529093522"></a>Called when the view is released. </p>
</td>
</tr>
<tr id="row863934515093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p311584620093522"><a name="p311584620093522"></a><a name="p311584620093522"></a><a href="graphic.md#ga8f01ff25a33b20df0758f564148e579d">OHOS::UIView::OnCancelEvent</a> (const <a href="ohos-cancelevent.md">CancelEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1425280526093522"><a name="p1425280526093522"></a><a name="p1425280526093522"></a>virtual void </p>
<p id="p962168700093522"><a name="p962168700093522"></a><a name="p962168700093522"></a>Called when a click event on the view is canceled. </p>
</td>
</tr>
<tr id="row1432574514093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1907529103093522"><a name="p1907529103093522"></a><a name="p1907529103093522"></a><a href="graphic.md#gad8e3cf5f0dd003a6aa932ef04e7b59f2">OHOS::UIView::SetOnDragListener</a> (<a href="ohos-uiview-ondraglistener.md">OnDragListener</a> *onDragListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1368796068093522"><a name="p1368796068093522"></a><a name="p1368796068093522"></a>void </p>
<p id="p309262599093522"><a name="p309262599093522"></a><a name="p309262599093522"></a>Sets a drag event listener for the view. </p>
</td>
</tr>
<tr id="row521862605093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p878564865093522"><a name="p878564865093522"></a><a name="p878564865093522"></a><a href="graphic.md#ga45a02cba4887c5c0b8e243941bcdc5cb">OHOS::UIView::GetOnDragListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1172523182093522"><a name="p1172523182093522"></a><a name="p1172523182093522"></a><a href="ohos-uiview-ondraglistener.md">OnDragListener</a> *&amp; </p>
<p id="p564747059093522"><a name="p564747059093522"></a><a name="p564747059093522"></a>Obtains the drag event listener for the view. </p>
</td>
</tr>
<tr id="row847972339093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1769765469093522"><a name="p1769765469093522"></a><a name="p1769765469093522"></a><a href="graphic.md#ga4564bf8d8c7184e9c02bf33c9e171fa3">OHOS::UIView::SetOnClickListener</a> (<a href="ohos-uiview-onclicklistener.md">OnClickListener</a> *onClickListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p865766592093522"><a name="p865766592093522"></a><a name="p865766592093522"></a>void </p>
<p id="p1227378004093522"><a name="p1227378004093522"></a><a name="p1227378004093522"></a>Sets a click event listener for the view. </p>
</td>
</tr>
<tr id="row1003752531093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1303224300093522"><a name="p1303224300093522"></a><a name="p1303224300093522"></a><a href="graphic.md#ga35e885cb380c37245fa4305bba10cd4a">OHOS::UIView::GetOnClickListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p271507860093522"><a name="p271507860093522"></a><a name="p271507860093522"></a><a href="ohos-uiview-onclicklistener.md">OnClickListener</a> *&amp; </p>
<p id="p952176654093522"><a name="p952176654093522"></a><a name="p952176654093522"></a>Obtains the click event listener for the view. </p>
</td>
</tr>
<tr id="row1949277087093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2069956160093522"><a name="p2069956160093522"></a><a name="p2069956160093522"></a><a href="graphic.md#gabcbe7a0adce600424f7f0d5a7396eb5b">OHOS::UIView::SetOnLongPressListener</a> (<a href="ohos-uiview-onlongpresslistener.md">OnLongPressListener</a> *onLongPressListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p216841215093522"><a name="p216841215093522"></a><a name="p216841215093522"></a>void </p>
<p id="p441506930093522"><a name="p441506930093522"></a><a name="p441506930093522"></a>Sets a long-press event listener for the view. </p>
</td>
</tr>
<tr id="row1165725288093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1736938606093522"><a name="p1736938606093522"></a><a name="p1736938606093522"></a><a href="graphic.md#gaafd4d354f5f111e758d046109fd7f656">OHOS::UIView::GetOnLongPressListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p103185704093522"><a name="p103185704093522"></a><a name="p103185704093522"></a><a href="ohos-uiview-onlongpresslistener.md">OnLongPressListener</a> *&amp; </p>
<p id="p118295560093522"><a name="p118295560093522"></a><a name="p118295560093522"></a>Obtains the long-press event listener for the view. </p>
</td>
</tr>
<tr id="row1703507183093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2083299232093522"><a name="p2083299232093522"></a><a name="p2083299232093522"></a><a href="graphic.md#gadd697fbf481f98d9d6ca8b67390071af">OHOS::UIView::SetOnTouchListener</a> (<a href="ohos-uiview-ontouchlistener.md">OnTouchListener</a> *onTouchListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1319600705093522"><a name="p1319600705093522"></a><a name="p1319600705093522"></a>void </p>
<p id="p962544811093522"><a name="p962544811093522"></a><a name="p962544811093522"></a>Sets a touch event listener for the view. </p>
</td>
</tr>
<tr id="row1000068422093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p515470439093522"><a name="p515470439093522"></a><a name="p515470439093522"></a><a href="graphic.md#gae7c65c68653103dae85acdcef78777a6">OHOS::UIView::GetTouchListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1512314543093522"><a name="p1512314543093522"></a><a name="p1512314543093522"></a><a href="ohos-uiview-ontouchlistener.md">OnTouchListener</a> *&amp; </p>
<p id="p1434092037093522"><a name="p1434092037093522"></a><a name="p1434092037093522"></a>Obtains the touch event listener for the view. </p>
</td>
</tr>
<tr id="row1895551404093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p88144107093522"><a name="p88144107093522"></a><a name="p88144107093522"></a><a href="graphic.md#gaea9f334f2481e1c03a2cd8f3078d7c72">OHOS::UIView::GetTargetView</a> (const <a href="ohos-point.md">Point</a> &amp;point, <a href="ohos-uiview.md">UIView</a> **last)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1824354178093522"><a name="p1824354178093522"></a><a name="p1824354178093522"></a>virtual void </p>
<p id="p2049866851093522"><a name="p2049866851093522"></a><a name="p2049866851093522"></a>Obtains the top-level view based on specified coordinates. </p>
</td>
</tr>
<tr id="row1330909272093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p180194578093522"><a name="p180194578093522"></a><a name="p180194578093522"></a><a href="graphic.md#gaeea67a3a84b4ffe9bfeda418b82184cc">OHOS::UIView::SetParent</a> (<a href="ohos-uiview.md">UIView</a> *parent)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1263620906093522"><a name="p1263620906093522"></a><a name="p1263620906093522"></a>void </p>
<p id="p458363206093522"><a name="p458363206093522"></a><a name="p458363206093522"></a>Sets the parent view for the view. </p>
</td>
</tr>
<tr id="row700923491093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p404479491093522"><a name="p404479491093522"></a><a name="p404479491093522"></a><a href="graphic.md#ga706530e4a38108615d5e0c918685ec96">OHOS::UIView::GetParent</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1165263160093522"><a name="p1165263160093522"></a><a name="p1165263160093522"></a><a href="ohos-uiview.md">UIView</a> * </p>
<p id="p2097616938093522"><a name="p2097616938093522"></a><a name="p2097616938093522"></a>Obtains the parent view of the view. </p>
</td>
</tr>
<tr id="row453069063093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p459431214093522"><a name="p459431214093522"></a><a name="p459431214093522"></a><a href="graphic.md#ga02bec5de07d93cabc45affba79eba4ad">OHOS::UIView::SetNextSibling</a> (<a href="ohos-uiview.md">UIView</a> *sibling)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1511274662093522"><a name="p1511274662093522"></a><a name="p1511274662093522"></a>void </p>
<p id="p459039210093522"><a name="p459039210093522"></a><a name="p459039210093522"></a>Sets the next sibling view for the view. </p>
</td>
</tr>
<tr id="row1229144051093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p799019287093522"><a name="p799019287093522"></a><a name="p799019287093522"></a><a href="graphic.md#gab0030977b30ddc9f2e15dbc2f58937e6">OHOS::UIView::GetNextSibling</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1396377278093522"><a name="p1396377278093522"></a><a name="p1396377278093522"></a><a href="ohos-uiview.md">UIView</a> * </p>
<p id="p156712920093522"><a name="p156712920093522"></a><a name="p156712920093522"></a>Obtains the next sibling view of the view. </p>
</td>
</tr>
<tr id="row1024933998093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p427228939093522"><a name="p427228939093522"></a><a name="p427228939093522"></a><a href="graphic.md#ga07e7e1f268bd6ce975f4f0f8487af5d0">OHOS::UIView::SetVisible</a> (bool visible)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2125952931093522"><a name="p2125952931093522"></a><a name="p2125952931093522"></a>virtual void </p>
<p id="p1945618985093522"><a name="p1945618985093522"></a><a name="p1945618985093522"></a>Sets whether the view is visible. </p>
</td>
</tr>
<tr id="row1098473516093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1601740126093522"><a name="p1601740126093522"></a><a name="p1601740126093522"></a><a href="graphic.md#gaee178fc0a86ac03a6bdf2ade0c1914c8">OHOS::UIView::IsVisible</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p330006186093522"><a name="p330006186093522"></a><a name="p330006186093522"></a>bool </p>
<p id="p316897691093522"><a name="p316897691093522"></a><a name="p316897691093522"></a>Checks whether the view is visible. </p>
</td>
</tr>
<tr id="row1895171364093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1116280588093522"><a name="p1116280588093522"></a><a name="p1116280588093522"></a><a href="graphic.md#gaf9fb55fd9aa397f7158f1515e90bce02">OHOS::UIView::SetTouchable</a> (bool touch)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1186929685093522"><a name="p1186929685093522"></a><a name="p1186929685093522"></a>void </p>
<p id="p542161150093522"><a name="p542161150093522"></a><a name="p542161150093522"></a>Sets whether the view is touchable. </p>
</td>
</tr>
<tr id="row1430771592093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1214505642093522"><a name="p1214505642093522"></a><a name="p1214505642093522"></a><a href="graphic.md#ga502a53fb77b260fa36b5b3adf82e2340">OHOS::UIView::IsTouchable</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1884163001093522"><a name="p1884163001093522"></a><a name="p1884163001093522"></a>bool </p>
<p id="p373556750093522"><a name="p373556750093522"></a><a name="p373556750093522"></a>Checks whether the view is touchable. </p>
</td>
</tr>
<tr id="row2068376900093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p523772554093522"><a name="p523772554093522"></a><a name="p523772554093522"></a><a href="graphic.md#gab06abe0fe824c048f3b72974f9a8f0d0">OHOS::UIView::SetDraggable</a> (bool draggable)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p24371790093522"><a name="p24371790093522"></a><a name="p24371790093522"></a>void </p>
<p id="p428755848093522"><a name="p428755848093522"></a><a name="p428755848093522"></a>Sets whether the view is draggable. </p>
</td>
</tr>
<tr id="row1044913597093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p48948191093522"><a name="p48948191093522"></a><a name="p48948191093522"></a><a href="graphic.md#ga25bb796ff400c767d622cbed280fc500">OHOS::UIView::IsDraggable</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1365001599093522"><a name="p1365001599093522"></a><a name="p1365001599093522"></a>bool </p>
<p id="p1718317229093522"><a name="p1718317229093522"></a><a name="p1718317229093522"></a>Checks whether the view is draggable. </p>
</td>
</tr>
<tr id="row197251353093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1251353902093522"><a name="p1251353902093522"></a><a name="p1251353902093522"></a><a href="graphic.md#ga6c08e49bf7a82a7ebaef0f251e7a6f85">OHOS::UIView::SetDragParentInstead</a> (bool dragParentInstead)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p257059855093522"><a name="p257059855093522"></a><a name="p257059855093522"></a>void </p>
<p id="p1841395603093522"><a name="p1841395603093522"></a><a name="p1841395603093522"></a>Sets whether to transfer the drag event to the parent view for processing when the view is being dragged. </p>
</td>
</tr>
<tr id="row1510519426093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2113036761093522"><a name="p2113036761093522"></a><a name="p2113036761093522"></a><a href="graphic.md#gaf0c462bc31e779b1898ad4cdfdad6faf">OHOS::UIView::IsDragParentInstead</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p57769140093522"><a name="p57769140093522"></a><a name="p57769140093522"></a>bool </p>
<p id="p221246581093522"><a name="p221246581093522"></a><a name="p221246581093522"></a>Obtains whether the view transfers a drag event to the parent view for processing. </p>
</td>
</tr>
<tr id="row1476946058093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p760256452093522"><a name="p760256452093522"></a><a name="p760256452093522"></a><a href="graphic.md#ga86cb8d364f18494d67636c55babced5c">OHOS::UIView::GetRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p149284444093522"><a name="p149284444093522"></a><a name="p149284444093522"></a><a href="ohos-rect.md">Rect</a> </p>
<p id="p1461357795093522"><a name="p1461357795093522"></a><a name="p1461357795093522"></a>Obtains the absolute rectangle area of the view. When the view has deformation such as rotation, the rectangle area is the intersection set of the absolute rectangle area and deformation matrix. </p>
</td>
</tr>
<tr id="row1659785515093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1136998481093522"><a name="p1136998481093522"></a><a name="p1136998481093522"></a><a href="graphic.md#ga06e79704a19f2a238982076cac3d059b">OHOS::UIView::GetVisibleRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1516926158093522"><a name="p1516926158093522"></a><a name="p1516926158093522"></a><a href="ohos-rect.md">Rect</a> </p>
<p id="p365067812093522"><a name="p365067812093522"></a><a name="p365067812093522"></a>Obtains the visible absolute rectangle area of the view. </p>
</td>
</tr>
<tr id="row2066837164093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1552510668093522"><a name="p1552510668093522"></a><a name="p1552510668093522"></a><a href="graphic.md#gab3f8993b3953f27bfc61d53429916cba">OHOS::UIView::GetMaskedRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p507235432093522"><a name="p507235432093522"></a><a name="p507235432093522"></a><a href="ohos-rect.md">Rect</a> </p>
<p id="p712143195093522"><a name="p712143195093522"></a><a name="p712143195093522"></a>Obtains the valid absolute rectangle area of the view. The valid area refers to the area where the view can be displayed. Generally, the valid area is the same as the visible view area, but they may be different in the grid layout. </p>
</td>
</tr>
<tr id="row680403502093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p777904484093522"><a name="p777904484093522"></a><a name="p777904484093522"></a><a href="graphic.md#ga64cf308a09999def1192f9c4e0f17f0a">OHOS::UIView::GetOrigRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1188512603093522"><a name="p1188512603093522"></a><a name="p1188512603093522"></a><a href="ohos-rect.md">Rect</a> </p>
<p id="p1768292958093522"><a name="p1768292958093522"></a><a name="p1768292958093522"></a>Obtains the absolute rectangle area of the view. </p>
</td>
</tr>
<tr id="row337031323093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1660040092093522"><a name="p1660040092093522"></a><a name="p1660040092093522"></a><a href="graphic.md#ga9db88eae712676359d02a92be14fa316">OHOS::UIView::GetContentRect</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1108721669093522"><a name="p1108721669093522"></a><a name="p1108721669093522"></a>virtual <a href="ohos-rect.md">Rect</a> </p>
<p id="p770723944093522"><a name="p770723944093522"></a><a name="p770723944093522"></a>Obtains the content of the absolute rectangle area of the view. This area excludes padding. </p>
</td>
</tr>
<tr id="row1220424687093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1691171179093522"><a name="p1691171179093522"></a><a name="p1691171179093522"></a><a href="graphic.md#gae9b96837fa1d45648a2a6fbbfcc5eb4a">OHOS::UIView::GetRelativeRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1371394529093522"><a name="p1371394529093522"></a><a name="p1371394529093522"></a><a href="ohos-rect.md">Rect</a> </p>
<p id="p414915433093522"><a name="p414915433093522"></a><a name="p414915433093522"></a>Obtains the rectangular area of the view relative to the parent view, that is, the rectangular area relative to the coordinates of the parent view. </p>
</td>
</tr>
<tr id="row342061255093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1145081478093522"><a name="p1145081478093522"></a><a name="p1145081478093522"></a><a href="graphic.md#gae6c5f3bcf99dc837bcecd60c38d3df5a">OHOS::UIView::ResizeVisibleArea</a> (int16_t x, int16_t y, int16_t width, int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p886372291093522"><a name="p886372291093522"></a><a name="p886372291093522"></a>void </p>
<p id="p1952282493093522"><a name="p1952282493093522"></a><a name="p1952282493093522"></a>Adjusts the size of the visible area. This operation may affect the final display size. </p>
</td>
</tr>
<tr id="row159617599093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p284210599093522"><a name="p284210599093522"></a><a name="p284210599093522"></a><a href="graphic.md#ga3375ec5ef059fd88c657af4552d2fa4f">OHOS::UIView::SetWidth</a> (int16_t width)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1442616124093522"><a name="p1442616124093522"></a><a name="p1442616124093522"></a>virtual void </p>
<p id="p1010108201093522"><a name="p1010108201093522"></a><a name="p1010108201093522"></a>Sets the width for the view. </p>
</td>
</tr>
<tr id="row1475938619093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1040237918093522"><a name="p1040237918093522"></a><a name="p1040237918093522"></a><a href="graphic.md#ga90cf8cffb98d71c30d6fc1d118442dbd">OHOS::UIView::GetWidth</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p979263775093522"><a name="p979263775093522"></a><a name="p979263775093522"></a>virtual int16_t </p>
<p id="p1054456808093522"><a name="p1054456808093522"></a><a name="p1054456808093522"></a>Obtains the width for the view. </p>
</td>
</tr>
<tr id="row2089124325093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1077668575093522"><a name="p1077668575093522"></a><a name="p1077668575093522"></a><a href="graphic.md#ga9c7110620d5dc3a7bd3efe1fc2edd125">OHOS::UIView::SetHeight</a> (int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p255494558093522"><a name="p255494558093522"></a><a name="p255494558093522"></a>virtual void </p>
<p id="p1272575499093522"><a name="p1272575499093522"></a><a name="p1272575499093522"></a>Sets the height for the view. </p>
</td>
</tr>
<tr id="row2111282865093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p543723970093522"><a name="p543723970093522"></a><a name="p543723970093522"></a><a href="graphic.md#ga9b35f4603a561c7a9a29b023a022ac97">OHOS::UIView::GetHeight</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1337937683093522"><a name="p1337937683093522"></a><a name="p1337937683093522"></a>virtual int16_t </p>
<p id="p580461337093522"><a name="p580461337093522"></a><a name="p580461337093522"></a>Obtains the height for the view. </p>
</td>
</tr>
<tr id="row1675432269093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1108648280093522"><a name="p1108648280093522"></a><a name="p1108648280093522"></a><a href="graphic.md#gae985b607d2f0701911778bf20d640ccd">OHOS::UIView::Resize</a> (int16_t width, int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1323051573093522"><a name="p1323051573093522"></a><a name="p1323051573093522"></a>virtual void </p>
<p id="p981015733093522"><a name="p981015733093522"></a><a name="p981015733093522"></a>Adjusts the size of the view. </p>
</td>
</tr>
<tr id="row916607425093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1441437914093522"><a name="p1441437914093522"></a><a name="p1441437914093522"></a><a href="graphic.md#gaded403626558d28e62bf5632ccbb24b5">OHOS::UIView::SetX</a> (int16_t x)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2067667212093522"><a name="p2067667212093522"></a><a name="p2067667212093522"></a>virtual void </p>
<p id="p1124432080093522"><a name="p1124432080093522"></a><a name="p1124432080093522"></a>Sets the x-coordinate for the view. </p>
</td>
</tr>
<tr id="row1868708404093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p758522142093522"><a name="p758522142093522"></a><a name="p758522142093522"></a><a href="graphic.md#ga89dc5f8fb1cb4b2259dc0439185359f1">OHOS::UIView::GetX</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p963606999093522"><a name="p963606999093522"></a><a name="p963606999093522"></a>int16_t </p>
<p id="p898950899093522"><a name="p898950899093522"></a><a name="p898950899093522"></a>Obtains the x-coordinate for the view. </p>
</td>
</tr>
<tr id="row625305119093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1789935784093522"><a name="p1789935784093522"></a><a name="p1789935784093522"></a><a href="graphic.md#gaaa8edc224cf1c7deb2724fb225960877">OHOS::UIView::SetY</a> (int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p540705076093522"><a name="p540705076093522"></a><a name="p540705076093522"></a>virtual void </p>
<p id="p1902683566093522"><a name="p1902683566093522"></a><a name="p1902683566093522"></a>Sets the y-coordinate for the view. </p>
</td>
</tr>
<tr id="row258638577093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p996584322093522"><a name="p996584322093522"></a><a name="p996584322093522"></a><a href="graphic.md#ga193619d649204b0e9bb854d3b30275c3">OHOS::UIView::GetY</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1679518371093522"><a name="p1679518371093522"></a><a name="p1679518371093522"></a>int16_t </p>
<p id="p1594703033093522"><a name="p1594703033093522"></a><a name="p1594703033093522"></a>Obtains the y-coordinate for the view. </p>
</td>
</tr>
<tr id="row851046235093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1403936592093522"><a name="p1403936592093522"></a><a name="p1403936592093522"></a><a href="graphic.md#gab34233f6aeae330b025969137d03e67a">OHOS::UIView::SetPosition</a> (int16_t x, int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1575862440093522"><a name="p1575862440093522"></a><a name="p1575862440093522"></a>virtual void </p>
<p id="p1820386309093522"><a name="p1820386309093522"></a><a name="p1820386309093522"></a>Sets the position for the view. </p>
</td>
</tr>
<tr id="row401579374093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1128577121093522"><a name="p1128577121093522"></a><a name="p1128577121093522"></a><a href="graphic.md#gaf8ce4c009f23b7175b2b34bac4a74262">OHOS::UIView::SetPosition</a> (int16_t x, int16_t y, int16_t width, int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p875311336093522"><a name="p875311336093522"></a><a name="p875311336093522"></a>virtual void </p>
<p id="p1123848011093522"><a name="p1123848011093522"></a><a name="p1123848011093522"></a>Adjusts the position and size of the view. </p>
</td>
</tr>
<tr id="row895735620093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p448909256093522"><a name="p448909256093522"></a><a name="p448909256093522"></a><a href="graphic.md#gab2ce8c11abbd55f40687f38a52511b11">OHOS::UIView::IsViewGroup</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p515669129093522"><a name="p515669129093522"></a><a name="p515669129093522"></a>bool </p>
<p id="p1373712581093522"><a name="p1373712581093522"></a><a name="p1373712581093522"></a>Checks whether the view is a container view. </p>
</td>
</tr>
<tr id="row393468958093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p899332672093522"><a name="p899332672093522"></a><a name="p899332672093522"></a><a href="graphic.md#ga980fc6824c64cfae6af8657aee17af88">OHOS::UIView::SetIntercept</a> (bool isIntercept)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1293887439093522"><a name="p1293887439093522"></a><a name="p1293887439093522"></a>void </p>
<p id="p822222078093522"><a name="p822222078093522"></a><a name="p822222078093522"></a>Sets whether to intercept the drag event. If intercepted, the view does not transfer the drag event to the parent view after local processing. </p>
</td>
</tr>
<tr id="row252808063093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1390426665093522"><a name="p1390426665093522"></a><a name="p1390426665093522"></a><a href="graphic.md#ga8623abbbeff458c0cb2d7dc0d1f21e4a">OHOS::UIView::SetTransformMap</a> (const <a href="ohos-transformmap.md">TransformMap</a> &amp;transMap)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p223685023093522"><a name="p223685023093522"></a><a name="p223685023093522"></a>void </p>
<p id="p1561036153093522"><a name="p1561036153093522"></a><a name="p1561036153093522"></a>Sets the affine transformation matrix. </p>
</td>
</tr>
<tr id="row1771305384093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2087715625093522"><a name="p2087715625093522"></a><a name="p2087715625093522"></a><a href="graphic.md#gab8cee5a7052a88722768c8ed1324abc1">OHOS::UIView::GetTransformMap</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2119684922093522"><a name="p2119684922093522"></a><a name="p2119684922093522"></a><a href="ohos-transformmap.md">TransformMap</a> &amp; </p>
<p id="p1835927069093522"><a name="p1835927069093522"></a><a name="p1835927069093522"></a>Obtains an affine transformation matrix. </p>
</td>
</tr>
<tr id="row1533540795093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p644265550093522"><a name="p644265550093522"></a><a name="p644265550093522"></a><a href="graphic.md#ga0573aa25307c22319db4629781b5cad2">OHOS::UIView::GetChildById</a> (const char *id) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p647496206093522"><a name="p647496206093522"></a><a name="p647496206093522"></a>virtual <a href="ohos-uiview.md">UIView</a> * </p>
<p id="p858148876093522"><a name="p858148876093522"></a><a name="p858148876093522"></a>Obtains the child view of a specified ID. </p>
</td>
</tr>
<tr id="row1058330495093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1473531635093522"><a name="p1473531635093522"></a><a name="p1473531635093522"></a><a href="graphic.md#ga0caaa15c9b304673331e778a266be77f">OHOS::UIView::SetViewId</a> (const char *id)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p918199680093522"><a name="p918199680093522"></a><a name="p918199680093522"></a>void </p>
<p id="p669151650093522"><a name="p669151650093522"></a><a name="p669151650093522"></a>Sets the view ID. </p>
</td>
</tr>
<tr id="row409767707093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1064349176093522"><a name="p1064349176093522"></a><a name="p1064349176093522"></a><a href="graphic.md#gad6c7644bd2abfa3c92d80776b0bd1936">OHOS::UIView::GetViewId</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1143608135093522"><a name="p1143608135093522"></a><a name="p1143608135093522"></a>const char * </p>
<p id="p1774941754093522"><a name="p1774941754093522"></a><a name="p1774941754093522"></a>Obtains the view ID. </p>
</td>
</tr>
<tr id="row747294944093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p690713353093522"><a name="p690713353093522"></a><a name="p690713353093522"></a><a href="graphic.md#ga77a961aa53567c5214508b4569801c16">OHOS::UIView::SetViewIndex</a> (int16_t <a href="en-us_topic_0000001055198076.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1472709531093522"><a name="p1472709531093522"></a><a name="p1472709531093522"></a>void </p>
<p id="p1125939461093522"><a name="p1125939461093522"></a><a name="p1125939461093522"></a>Sets the view index. </p>
</td>
</tr>
<tr id="row1150120153093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p995892644093522"><a name="p995892644093522"></a><a name="p995892644093522"></a><a href="graphic.md#ga62f51715b6d420a296ebe0296717b906">OHOS::UIView::GetViewIndex</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1234416952093522"><a name="p1234416952093522"></a><a name="p1234416952093522"></a>int16_t </p>
<p id="p1279565864093522"><a name="p1279565864093522"></a><a name="p1279565864093522"></a>Obtains the view index. </p>
</td>
</tr>
<tr id="row299061159093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p209531104093522"><a name="p209531104093522"></a><a name="p209531104093522"></a><a href="graphic.md#ga6d23780da1faa1071197b716bca365e0">OHOS::UIView::GetViewType</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2061816674093522"><a name="p2061816674093522"></a><a name="p2061816674093522"></a>virtual UIViewType </p>
<p id="p936899524093522"><a name="p936899524093522"></a><a name="p936899524093522"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row1144819198093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1000482244093522"><a name="p1000482244093522"></a><a name="p1000482244093522"></a><a href="graphic.md#gaca871fa2f8219e7ea9388e212d1f1e69">OHOS::UIView::LayoutChildren</a> (bool neeInvalidate=false)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1469419259093522"><a name="p1469419259093522"></a><a name="p1469419259093522"></a>virtual void </p>
<p id="p2050565479093522"><a name="p2050565479093522"></a><a name="p2050565479093522"></a>Lays out all child views according to the preset arrangement mode. </p>
</td>
</tr>
<tr id="row583311694093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p714460257093522"><a name="p714460257093522"></a><a name="p714460257093522"></a><a href="graphic.md#ga443b86ee9275b0421b37a47bad3264dc">OHOS::UIView::LayoutCenterOfParent</a> (int16_t xOffSet=0, int16_t yOffset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1169617484093522"><a name="p1169617484093522"></a><a name="p1169617484093522"></a>void </p>
<p id="p707231642093522"><a name="p707231642093522"></a><a name="p707231642093522"></a>Lays out the view in the center of the parent view. </p>
</td>
</tr>
<tr id="row257484275093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p216626398093522"><a name="p216626398093522"></a><a name="p216626398093522"></a><a href="graphic.md#ga94999b271f27cd5d6bfaf303f7d5c708">OHOS::UIView::LayoutLeftOfParent</a> (int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1878137133093522"><a name="p1878137133093522"></a><a name="p1878137133093522"></a>void </p>
<p id="p150191857093522"><a name="p150191857093522"></a><a name="p150191857093522"></a>Lays out the view on the left of the parent view. </p>
</td>
</tr>
<tr id="row1200024566093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p381205668093522"><a name="p381205668093522"></a><a name="p381205668093522"></a><a href="graphic.md#ga479528ed259b5539e423955f2b60517d">OHOS::UIView::LayoutRightOfParent</a> (int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2070025630093522"><a name="p2070025630093522"></a><a name="p2070025630093522"></a>void </p>
<p id="p134119736093522"><a name="p134119736093522"></a><a name="p134119736093522"></a>Lays out the view on the right of the parent view. </p>
</td>
</tr>
<tr id="row627818324093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2071857707093522"><a name="p2071857707093522"></a><a name="p2071857707093522"></a><a href="graphic.md#ga859288ea61ad23ba7e381bbc07769e83">OHOS::UIView::LayoutTopOfParent</a> (int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p102886818093522"><a name="p102886818093522"></a><a name="p102886818093522"></a>void </p>
<p id="p902444084093522"><a name="p902444084093522"></a><a name="p902444084093522"></a>Lays out the view on the top of the parent view. </p>
</td>
</tr>
<tr id="row2051880367093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p526526135093522"><a name="p526526135093522"></a><a name="p526526135093522"></a><a href="graphic.md#ga809aeee4792ae58218a0bcfcb94d5cdc">OHOS::UIView::LayoutBottomOfParent</a> (int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1205611689093522"><a name="p1205611689093522"></a><a name="p1205611689093522"></a>void </p>
<p id="p203736540093522"><a name="p203736540093522"></a><a name="p203736540093522"></a>Lays out the view on the bottom of the parent view. </p>
</td>
</tr>
<tr id="row1211307775093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1589536681093522"><a name="p1589536681093522"></a><a name="p1589536681093522"></a><a href="graphic.md#gac7f5f2584c716a56fee3783f8dea6246">OHOS::UIView::AlignLeftToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p396453140093522"><a name="p396453140093522"></a><a name="p396453140093522"></a>void </p>
<p id="p1648891551093522"><a name="p1648891551093522"></a><a name="p1648891551093522"></a>Aligns the view with the left of a sibling view. </p>
</td>
</tr>
<tr id="row442465128093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p670508403093522"><a name="p670508403093522"></a><a name="p670508403093522"></a><a href="graphic.md#gabb1ac454cdf95593c1e387d5e272433c">OHOS::UIView::AlignRightToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1010491750093522"><a name="p1010491750093522"></a><a name="p1010491750093522"></a>void </p>
<p id="p883068535093522"><a name="p883068535093522"></a><a name="p883068535093522"></a>Aligns the view with the right of a sibling view. </p>
</td>
</tr>
<tr id="row1766565933093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p800384861093522"><a name="p800384861093522"></a><a name="p800384861093522"></a><a href="graphic.md#ga903d7cbc59bac06d728b7f6435c9a504">OHOS::UIView::AlignTopToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1111519128093522"><a name="p1111519128093522"></a><a name="p1111519128093522"></a>void </p>
<p id="p246208824093522"><a name="p246208824093522"></a><a name="p246208824093522"></a>Aligns the view with the top of a sibling view. </p>
</td>
</tr>
<tr id="row55279752093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p84854130093522"><a name="p84854130093522"></a><a name="p84854130093522"></a><a href="graphic.md#ga7607c3f9661932c495d080e9d92fb1a3">OHOS::UIView::AlignBottomToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2008372367093522"><a name="p2008372367093522"></a><a name="p2008372367093522"></a>void </p>
<p id="p660540235093522"><a name="p660540235093522"></a><a name="p660540235093522"></a>Aligns the view with the bottom of a sibling view. </p>
</td>
</tr>
<tr id="row1841459763093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1213841168093522"><a name="p1213841168093522"></a><a name="p1213841168093522"></a><a href="graphic.md#gac23776dbc2fce7ff30d57438abfa5230">OHOS::UIView::AlignHorCenterToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p976248889093522"><a name="p976248889093522"></a><a name="p976248889093522"></a>void </p>
<p id="p352711164093522"><a name="p352711164093522"></a><a name="p352711164093522"></a>Aligns the view with the center of a sibling view in the x-axis. </p>
</td>
</tr>
<tr id="row1929298817093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1464623707093522"><a name="p1464623707093522"></a><a name="p1464623707093522"></a><a href="graphic.md#gad3caa27aa0cb73ec4656e7d23aa222de">OHOS::UIView::AlignVerCenterToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2072422609093522"><a name="p2072422609093522"></a><a name="p2072422609093522"></a>void </p>
<p id="p1111665536093522"><a name="p1111665536093522"></a><a name="p1111665536093522"></a>Aligns the view with the center of a sibling view in the y-axis. </p>
</td>
</tr>
<tr id="row204844289093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1466208528093522"><a name="p1466208528093522"></a><a name="p1466208528093522"></a><a href="graphic.md#ga58f1a34a943c4492970f901d63bbc3d8">OHOS::UIView::LayoutLeftToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1813715155093522"><a name="p1813715155093522"></a><a name="p1813715155093522"></a>void </p>
<p id="p722524838093522"><a name="p722524838093522"></a><a name="p722524838093522"></a>Lays out the view on the left of a sibling view. </p>
</td>
</tr>
<tr id="row172575106093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1988517865093522"><a name="p1988517865093522"></a><a name="p1988517865093522"></a><a href="graphic.md#gac4cd64de5291759add164825a323a0d6">OHOS::UIView::LayoutRightToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p775590195093522"><a name="p775590195093522"></a><a name="p775590195093522"></a>void </p>
<p id="p1108969489093522"><a name="p1108969489093522"></a><a name="p1108969489093522"></a>Lays out the view on the right of a sibling view. </p>
</td>
</tr>
<tr id="row1533876201093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1402936707093522"><a name="p1402936707093522"></a><a name="p1402936707093522"></a><a href="graphic.md#gaaa8385807e3a9bea46f8dcc326252a70">OHOS::UIView::LayoutTopToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p3106502093522"><a name="p3106502093522"></a><a name="p3106502093522"></a>void </p>
<p id="p1782471383093522"><a name="p1782471383093522"></a><a name="p1782471383093522"></a>Lays out the view on the above of a sibling view. </p>
</td>
</tr>
<tr id="row2090731087093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p308771515093522"><a name="p308771515093522"></a><a name="p308771515093522"></a><a href="graphic.md#gaa23a68e8ef0fb13b362218e71cf67ace">OHOS::UIView::LayoutBottomToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p679226678093522"><a name="p679226678093522"></a><a name="p679226678093522"></a>void </p>
<p id="p1562173380093522"><a name="p1562173380093522"></a><a name="p1562173380093522"></a>Lays out the view on the below of a sibling view. </p>
</td>
</tr>
<tr id="row1360320763093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1080344088093522"><a name="p1080344088093522"></a><a name="p1080344088093522"></a><a href="graphic.md#ga9c1a3db000fdcd200fec8d2c49f5a0a8">OHOS::UIView::SetStyle</a> (<a href="ohos-style.md">Style</a> &amp;style)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1375539666093522"><a name="p1375539666093522"></a><a name="p1375539666093522"></a>virtual void </p>
<p id="p480563359093522"><a name="p480563359093522"></a><a name="p480563359093522"></a>Sets the view style. </p>
</td>
</tr>
<tr id="row584233496093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1352242305093522"><a name="p1352242305093522"></a><a name="p1352242305093522"></a><a href="graphic.md#ga0945c2f05815dc2e466ef9ceaca2f700">OHOS::UIView::SetStyle</a> (uint8_t key, int64_t value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1431224590093522"><a name="p1431224590093522"></a><a name="p1431224590093522"></a>virtual void </p>
<p id="p1447558865093522"><a name="p1447558865093522"></a><a name="p1447558865093522"></a>Sets a style. </p>
</td>
</tr>
<tr id="row2015327084093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p209304056093522"><a name="p209304056093522"></a><a name="p209304056093522"></a><a href="graphic.md#ga4ea19bc9f4b487946c9e29e63b54a0e6">OHOS::UIView::GetStyle</a> (uint8_t key) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p581176321093522"><a name="p581176321093522"></a><a name="p581176321093522"></a>virtual int64_t </p>
<p id="p145805413093522"><a name="p145805413093522"></a><a name="p145805413093522"></a>Obtains the value of a style. </p>
</td>
</tr>
<tr id="row1829106121093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p981002275093522"><a name="p981002275093522"></a><a name="p981002275093522"></a><a href="graphic.md#ga1b28213d4c2cd0f8324bce3fe56eb7bb">OHOS::UIView::GetStyleConst</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1088161536093522"><a name="p1088161536093522"></a><a name="p1088161536093522"></a>const <a href="ohos-style.md">Style</a> &amp; </p>
<p id="p1088529731093522"><a name="p1088529731093522"></a><a name="p1088529731093522"></a>Obtains the view style. This function applies to scenarios where the style does not need to be modified, which saves memory. </p>
</td>
</tr>
<tr id="row793391138093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2010279652093522"><a name="p2010279652093522"></a><a name="p2010279652093522"></a><a href="graphic.md#gadae043c6d43d5436ec0374e5d128c654">OHOS::UIViewGroup::UIViewGroup</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p750580610093522"><a name="p750580610093522"></a><a name="p750580610093522"></a> </p>
<p id="p395276965093522"><a name="p395276965093522"></a><a name="p395276965093522"></a>A default constructor used to create a <strong id="b1039217076093522"><a name="b1039217076093522"></a><a name="b1039217076093522"></a><a href="ohos-uiviewgroup.md">UIViewGroup</a></strong> instance. </p>
</td>
</tr>
<tr id="row1969090364093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p738069178093522"><a name="p738069178093522"></a><a name="p738069178093522"></a><a href="graphic.md#ga19ec065bd41a01f0925a4a9ffa450d1c">OHOS::UIViewGroup::~UIViewGroup</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1383565797093522"><a name="p1383565797093522"></a><a name="p1383565797093522"></a>virtual </p>
<p id="p139727965093522"><a name="p139727965093522"></a><a name="p139727965093522"></a>A destructor used to delete the <strong id="b1432305183093522"><a name="b1432305183093522"></a><a name="b1432305183093522"></a><a href="ohos-uiviewgroup.md">UIViewGroup</a></strong> instance. </p>
</td>
</tr>
<tr id="row157052564093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1366588196093522"><a name="p1366588196093522"></a><a name="p1366588196093522"></a><a href="graphic.md#gad5756764839a844ee9bee0c186798029">OHOS::UIViewGroup::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1652399161093522"><a name="p1652399161093522"></a><a name="p1652399161093522"></a>UIViewType </p>
<p id="p1147972798093522"><a name="p1147972798093522"></a><a name="p1147972798093522"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row1550078973093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p461058424093522"><a name="p461058424093522"></a><a name="p461058424093522"></a><a href="graphic.md#gacf5db120308ac7783c493f5437f06cee">OHOS::UIViewGroup::Add</a> (<a href="ohos-uiview.md">UIView</a> *view)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1717498147093522"><a name="p1717498147093522"></a><a name="p1717498147093522"></a>virtual void </p>
<p id="p1403577045093522"><a name="p1403577045093522"></a><a name="p1403577045093522"></a>Adds a child view. </p>
</td>
</tr>
<tr id="row1949624840093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1126839995093522"><a name="p1126839995093522"></a><a name="p1126839995093522"></a><a href="graphic.md#ga84195a993bfe50d8302435ababb63966">OHOS::UIViewGroup::Insert</a> (<a href="ohos-uiview.md">UIView</a> *prevView, <a href="ohos-uiview.md">UIView</a> *insertView)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p239811077093522"><a name="p239811077093522"></a><a name="p239811077093522"></a>virtual void </p>
<p id="p886224426093522"><a name="p886224426093522"></a><a name="p886224426093522"></a>Inserts a new child view behind the current one. </p>
</td>
</tr>
<tr id="row1951204998093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p893991989093522"><a name="p893991989093522"></a><a name="p893991989093522"></a><a href="graphic.md#ga25523928b24d6692f18aed31edb07006">OHOS::UIViewGroup::Remove</a> (<a href="ohos-uiview.md">UIView</a> *view)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1485297265093522"><a name="p1485297265093522"></a><a name="p1485297265093522"></a>virtual void </p>
<p id="p1680618824093522"><a name="p1680618824093522"></a><a name="p1680618824093522"></a>Removes a child view. </p>
</td>
</tr>
<tr id="row618864279093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p918539248093522"><a name="p918539248093522"></a><a name="p918539248093522"></a><a href="graphic.md#gaf3ee08173d92932687809049e3c11e9b">OHOS::UIViewGroup::RemoveAll</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p584943089093522"><a name="p584943089093522"></a><a name="p584943089093522"></a>virtual void </p>
<p id="p699691928093522"><a name="p699691928093522"></a><a name="p699691928093522"></a>Removes all child views. </p>
</td>
</tr>
<tr id="row2068911388093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1848681023093522"><a name="p1848681023093522"></a><a name="p1848681023093522"></a><a href="graphic.md#ga7ea54fc6ef3a8b7dec1bf88ab189f7c7">OHOS::UIViewGroup::GetTargetView</a> (const <a href="ohos-point.md">Point</a> &amp;point, <a href="ohos-uiview.md">UIView</a> **last) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p977691796093522"><a name="p977691796093522"></a><a name="p977691796093522"></a>virtual void </p>
<p id="p82383750093522"><a name="p82383750093522"></a><a name="p82383750093522"></a>Obtains the target child view that is visible and can respond to touch events based on given coordinates. </p>
</td>
</tr>
<tr id="row1334508275093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p858394947093522"><a name="p858394947093522"></a><a name="p858394947093522"></a><a href="graphic.md#ga776c6c1640cb88b537af227fa5eb0725">OHOS::UIViewGroup::MoveChildByOffset</a> (int16_t x, int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1034117398093522"><a name="p1034117398093522"></a><a name="p1034117398093522"></a>virtual void </p>
<p id="p1836926361093522"><a name="p1836926361093522"></a><a name="p1836926361093522"></a>Moves all child views. </p>
</td>
</tr>
<tr id="row144427124093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1198601046093522"><a name="p1198601046093522"></a><a name="p1198601046093522"></a><a href="graphic.md#ga6fed8238b89b013552c5a247aa2471df">OHOS::UIViewGroup::GetChildrenHead</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1583824212093522"><a name="p1583824212093522"></a><a name="p1583824212093522"></a><a href="ohos-uiview.md">UIView</a> * </p>
<p id="p451285247093522"><a name="p451285247093522"></a><a name="p451285247093522"></a>Obtains the first child view in this view group. </p>
</td>
</tr>
<tr id="row1510914230093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1839756732093522"><a name="p1839756732093522"></a><a name="p1839756732093522"></a><a href="graphic.md#ga1361baa76fbabd2fc81cc249c6868691">OHOS::UIViewGroup::GetChildrenTail</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p577696490093522"><a name="p577696490093522"></a><a name="p577696490093522"></a><a href="ohos-uiview.md">UIView</a> * </p>
<p id="p253413153093522"><a name="p253413153093522"></a><a name="p253413153093522"></a>Obtains the last child view in this view group. </p>
</td>
</tr>
<tr id="row2055284727093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1293563397093522"><a name="p1293563397093522"></a><a name="p1293563397093522"></a><a href="graphic.md#gad53c52e619a54358a413a836ae0c1861">OHOS::UIViewGroup::SetDisallowIntercept</a> (bool flag)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1712009175093522"><a name="p1712009175093522"></a><a name="p1712009175093522"></a>void </p>
<p id="p2129974551093522"><a name="p2129974551093522"></a><a name="p2129974551093522"></a>Sets whether this view group is intercepted upon touch events. </p>
</td>
</tr>
<tr id="row1285626811093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p176562821093522"><a name="p176562821093522"></a><a name="p176562821093522"></a><a href="graphic.md#gae9f6ddb5819392546463d6371147c486">OHOS::UIViewGroup::GetChildById</a> (const char *id) const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1422907336093522"><a name="p1422907336093522"></a><a name="p1422907336093522"></a><a href="ohos-uiview.md">UIView</a> * </p>
<p id="p1197788959093522"><a name="p1197788959093522"></a><a name="p1197788959093522"></a>Obtains the target child view with a specified ID. </p>
</td>
</tr>
<tr id="row1124004419093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p923782913093522"><a name="p923782913093522"></a><a name="p923782913093522"></a><a href="graphic.md#ga6442ba36114d739df1b17ca8943cc087">OHOS::UIViewGroup::SetAutoSize</a> (bool state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p772747603093522"><a name="p772747603093522"></a><a name="p772747603093522"></a>void </p>
<p id="p1236686779093522"><a name="p1236686779093522"></a><a name="p1236686779093522"></a>Sets whether the size of this view group is adaptive to that of all child views. </p>
</td>
</tr>
<tr id="row421938255093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p31614809093522"><a name="p31614809093522"></a><a name="p31614809093522"></a><a href="graphic.md#ga34fe81b667a13b06a579600827e0531b">OHOS::UIViewGroup::GetAllChildRelativeRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1428160139093522"><a name="p1428160139093522"></a><a name="p1428160139093522"></a><a href="ohos-rect.md">Rect</a> </p>
<p id="p25577592093522"><a name="p25577592093522"></a><a name="p25577592093522"></a>Obtains the rectangle area of a new view group after being adaptive to the size of all child views. </p>
</td>
</tr>
<tr id="row1166143595093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1705152820093522"><a name="p1705152820093522"></a><a name="p1705152820093522"></a><a href="graphic.md#ga06a5bd621f6532fe5c8fd08a2c1314b2">OHOS::UIViewGroup::OnChildChanged</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p801360214093522"><a name="p801360214093522"></a><a name="p801360214093522"></a>virtual void </p>
<p id="p2032894246093522"><a name="p2032894246093522"></a><a name="p2032894246093522"></a>Performs operations needed after a child view is added or removed. </p>
</td>
</tr>
<tr id="row630382746093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1639106772093522"><a name="p1639106772093522"></a><a name="p1639106772093522"></a><a href="graphic.md#ga9f1bc7dc04063baeb71a3d3106be2b51">OHOS::UIDumpDomTree::GetInstance</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1086735857093522"><a name="p1086735857093522"></a><a name="p1086735857093522"></a>static <a href="ohos-uidumpdomtree.md">UIDumpDomTree</a> * </p>
<p id="p2103301751093522"><a name="p2103301751093522"></a><a name="p2103301751093522"></a>Obtains an instance in singleton pattern. </p>
</td>
</tr>
<tr id="row1669636443093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1805794834093522"><a name="p1805794834093522"></a><a name="p1805794834093522"></a><a href="graphic.md#ga04fbff1f92851a2ac55c4575cbc132e9">OHOS::UIDumpDomTree::DumpDomTree</a> (const char *id, const char *path)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p354857287093522"><a name="p354857287093522"></a><a name="p354857287093522"></a>bool </p>
<p id="p63644013093522"><a name="p63644013093522"></a><a name="p63644013093522"></a>Exports information about a DOM tree starting from a specified DOM node and saves the information to a specified path. </p>
</td>
</tr>
<tr id="row2075710038093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p149826768093522"><a name="p149826768093522"></a><a name="p149826768093522"></a><a href="graphic.md#ga25384e441719c58d5cfdc3c67f1e8625">OHOS::UIDumpDomTree::DumpDomTree</a> (const char *id)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p947304971093522"><a name="p947304971093522"></a><a name="p947304971093522"></a>bool </p>
<p id="p1014178674093522"><a name="p1014178674093522"></a><a name="p1014178674093522"></a>Exports information about a DOM tree starting from a specified DOM node and saves the information to the default path. The default path is <strong id="b1028372876093522"><a name="b1028372876093522"></a><a name="b1028372876093522"></a>DEFAULT_DUMP_DOM_TREE_PATH</strong>. </p>
</td>
</tr>
<tr id="row214448926093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p965873015093522"><a name="p965873015093522"></a><a name="p965873015093522"></a><a href="graphic.md#ga812e123f85aa3ff687908e19d23fc54f">OHOS::UIDumpDomTree::DumpDomNode</a> (const char *id)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1050717939093522"><a name="p1050717939093522"></a><a name="p1050717939093522"></a>char * </p>
<p id="p1591593544093522"><a name="p1591593544093522"></a><a name="p1591593544093522"></a>Exports information about a specified DOM node. </p>
</td>
</tr>
<tr id="row1743863424093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1327550240093522"><a name="p1327550240093522"></a><a name="p1327550240093522"></a><a href="graphic.md#gaf3b75ee84a33ffcbc640328b2747b0a1">OHOS::CancelEvent::CancelEvent</a> (const <a href="ohos-point.md">Point</a> &amp;pos)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2092515491093522"><a name="p2092515491093522"></a><a name="p2092515491093522"></a> </p>
<p id="p852408752093522"><a name="p852408752093522"></a><a name="p852408752093522"></a>A constructor used to create a <strong id="b723372536093522"><a name="b723372536093522"></a><a name="b723372536093522"></a><a href="ohos-cancelevent.md">CancelEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row375499070093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1881644847093522"><a name="p1881644847093522"></a><a name="p1881644847093522"></a><a href="graphic.md#ga5f8a22ac27c5ffc2b8801b4687a38394">OHOS::CancelEvent::~CancelEvent</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1798429129093522"><a name="p1798429129093522"></a><a name="p1798429129093522"></a>virtual </p>
<p id="p2094816391093522"><a name="p2094816391093522"></a><a name="p2094816391093522"></a>A destructor used to delete the <strong id="b1095146045093522"><a name="b1095146045093522"></a><a name="b1095146045093522"></a><a href="ohos-cancelevent.md">CancelEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row1375610251093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2104163166093522"><a name="p2104163166093522"></a><a name="p2104163166093522"></a><a href="graphic.md#gaeb51d39715cc72b383ba6059bd0d1053">OHOS::ClickEvent::ClickEvent</a> (const <a href="ohos-point.md">Point</a> &amp;pos)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p747043724093522"><a name="p747043724093522"></a><a name="p747043724093522"></a> </p>
<p id="p1804236572093522"><a name="p1804236572093522"></a><a name="p1804236572093522"></a>A constructor used to create a <strong id="b695938196093522"><a name="b695938196093522"></a><a name="b695938196093522"></a><a href="ohos-clickevent.md">ClickEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row1906455948093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p481686663093522"><a name="p481686663093522"></a><a name="p481686663093522"></a><a href="graphic.md#ga75b3bef18631b1640c31dd1191f35ef7">OHOS::ClickEvent::~ClickEvent</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1133251142093522"><a name="p1133251142093522"></a><a name="p1133251142093522"></a>virtual </p>
<p id="p1962525605093522"><a name="p1962525605093522"></a><a name="p1962525605093522"></a>A destructor used to delete the <strong id="b697618515093522"><a name="b697618515093522"></a><a name="b697618515093522"></a><a href="ohos-clickevent.md">ClickEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row537160731093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1790714784093522"><a name="p1790714784093522"></a><a name="p1790714784093522"></a><a href="graphic.md#gae9af79f667fc1324739d2a07fdd5d94e">OHOS::DragEvent::DragEvent</a> (const <a href="ohos-point.md">Point</a> &amp;newPos, const <a href="ohos-point.md">Point</a> &amp;lastPos, const <a href="ohos-point.md">Point</a> &amp;totalLen)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1741970507093522"><a name="p1741970507093522"></a><a name="p1741970507093522"></a> </p>
<p id="p1411185450093522"><a name="p1411185450093522"></a><a name="p1411185450093522"></a>A constructor used to create a <strong id="b348449534093522"><a name="b348449534093522"></a><a name="b348449534093522"></a><a href="ohos-dragevent.md">DragEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row2022992770093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2021727929093522"><a name="p2021727929093522"></a><a name="p2021727929093522"></a><a href="graphic.md#gabed19ea6c1b15b861653485349133468">OHOS::DragEvent::~DragEvent</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1641197194093522"><a name="p1641197194093522"></a><a name="p1641197194093522"></a>virtual </p>
<p id="p2133265934093522"><a name="p2133265934093522"></a><a name="p2133265934093522"></a>A destructor used to delete the <strong id="b448660014093522"><a name="b448660014093522"></a><a name="b448660014093522"></a><a href="ohos-dragevent.md">DragEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row461839061093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1562399837093522"><a name="p1562399837093522"></a><a name="p1562399837093522"></a><a href="graphic.md#ga2b5a66f36249b23e69cccfc2859847c1">OHOS::DragEvent::GetLastPoint</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p381364229093522"><a name="p381364229093522"></a><a name="p381364229093522"></a>const <a href="ohos-point.md">Point</a> &amp; </p>
<p id="p1007986036093522"><a name="p1007986036093522"></a><a name="p1007986036093522"></a>Obtains the coordinates of the last position in the drag event. </p>
</td>
</tr>
<tr id="row279529059093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p564913359093522"><a name="p564913359093522"></a><a name="p564913359093522"></a><a href="graphic.md#gadeada49639b81e405b8b54e2629361ee">OHOS::DragEvent::GetStartPoint</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p962628205093522"><a name="p962628205093522"></a><a name="p962628205093522"></a>const <a href="ohos-point.md">Point</a> &amp; </p>
<p id="p1261418598093522"><a name="p1261418598093522"></a><a name="p1261418598093522"></a>Obtains the start coordinates in the drag event. </p>
</td>
</tr>
<tr id="row238318139093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p105238681093522"><a name="p105238681093522"></a><a name="p105238681093522"></a><a href="graphic.md#ga8399680c67bc048745257a1b56250834">OHOS::DragEvent::SetPreLastPoint</a> (const <a href="ohos-point.md">Point</a> &amp;preLastPos)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p239615501093522"><a name="p239615501093522"></a><a name="p239615501093522"></a>void </p>
<p id="p1564467539093522"><a name="p1564467539093522"></a><a name="p1564467539093522"></a>Sets the coordinates of the stay position before the last position in the drag event. </p>
</td>
</tr>
<tr id="row474360980093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p279554865093522"><a name="p279554865093522"></a><a name="p279554865093522"></a><a href="graphic.md#ga7a7198c95326af4ad0d2e2a85fb99ef6">OHOS::DragEvent::GetPreLastPoint</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p871417590093522"><a name="p871417590093522"></a><a name="p871417590093522"></a>const <a href="ohos-point.md">Point</a> &amp; </p>
<p id="p1715153771093522"><a name="p1715153771093522"></a><a name="p1715153771093522"></a>Obtains the coordinates of the stay position before the last position in the drag event. </p>
</td>
</tr>
<tr id="row1658002737093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2083001992093522"><a name="p2083001992093522"></a><a name="p2083001992093522"></a><a href="graphic.md#gaf0ab47609e2dc46109f889847d9d7f9d">OHOS::DragEvent::GetDragDirection</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p863882993093522"><a name="p863882993093522"></a><a name="p863882993093522"></a>uint8_t </p>
<p id="p1400889439093522"><a name="p1400889439093522"></a><a name="p1400889439093522"></a>Obtains the direction in the drag event. </p>
</td>
</tr>
<tr id="row1915409658093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1965004329093522"><a name="p1965004329093522"></a><a name="p1965004329093522"></a><a href="graphic.md#ga4e504ef2c5ef58bb0c79bbfdb0168d0d">OHOS::DragEvent::GetDeltaX</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1666709906093522"><a name="p1666709906093522"></a><a name="p1666709906093522"></a>int16_t </p>
<p id="p1598012574093522"><a name="p1598012574093522"></a><a name="p1598012574093522"></a>Obtains the difference between the current position and the last position of the view in the x-axis. </p>
</td>
</tr>
<tr id="row867246793093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p184342467093522"><a name="p184342467093522"></a><a name="p184342467093522"></a><a href="graphic.md#ga13e3996546917d71612b34285f8b9dd7">OHOS::DragEvent::GetDeltaY</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1060888622093522"><a name="p1060888622093522"></a><a name="p1060888622093522"></a>int16_t </p>
<p id="p1174803686093522"><a name="p1174803686093522"></a><a name="p1174803686093522"></a>Obtains the difference between the current position and the last position of the view in the y-axis. </p>
</td>
</tr>
<tr id="row725184241093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p982485801093522"><a name="p982485801093522"></a><a name="p982485801093522"></a><a href="graphic.md#ga89cd09ced5537a3479b7901ba8abc6da">OHOS::Event::Event</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p740614526093522"><a name="p740614526093522"></a><a name="p740614526093522"></a> </p>
<p id="p1536170197093522"><a name="p1536170197093522"></a><a name="p1536170197093522"></a>A default constructor used to create an <strong id="b499848056093522"><a name="b499848056093522"></a><a name="b499848056093522"></a><a href="ohos-event.md">Event</a></strong> instance. </p>
</td>
</tr>
<tr id="row377052078093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p571788115093522"><a name="p571788115093522"></a><a name="p571788115093522"></a><a href="graphic.md#ga57a9f07c8203c6a60f3b25c4edb526a0">OHOS::Event::Event</a> (const <a href="ohos-point.md">Point</a> &amp;curPos)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1513814157093522"><a name="p1513814157093522"></a><a name="p1513814157093522"></a> </p>
<p id="p1358590460093522"><a name="p1358590460093522"></a><a name="p1358590460093522"></a>A constructor used to create an <strong id="b1326610647093522"><a name="b1326610647093522"></a><a name="b1326610647093522"></a><a href="ohos-event.md">Event</a></strong> instance. </p>
</td>
</tr>
<tr id="row616821999093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p269745884093522"><a name="p269745884093522"></a><a name="p269745884093522"></a><a href="graphic.md#gabafa07a6393f4757f402bf9437561fa4">OHOS::Event::~Event</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p180860445093522"><a name="p180860445093522"></a><a name="p180860445093522"></a>virtual </p>
<p id="p1173662831093522"><a name="p1173662831093522"></a><a name="p1173662831093522"></a>A destructor used to delete the <strong id="b393994066093522"><a name="b393994066093522"></a><a name="b393994066093522"></a><a href="ohos-event.md">Event</a></strong> instance. </p>
</td>
</tr>
<tr id="row450064626093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1085238640093522"><a name="p1085238640093522"></a><a name="p1085238640093522"></a><a href="graphic.md#gaea811c661ad416d7f70912ad6fcce269">OHOS::Event::GetCurrentPos</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2100508249093522"><a name="p2100508249093522"></a><a name="p2100508249093522"></a>const <a href="ohos-point.md">Point</a> &amp; </p>
<p id="p609419217093522"><a name="p609419217093522"></a><a name="p609419217093522"></a>Obtains the position where an event occurs. </p>
</td>
</tr>
<tr id="row1323257912093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1116471337093522"><a name="p1116471337093522"></a><a name="p1116471337093522"></a><a href="graphic.md#ga7d56c2a99ab2c98eec9ebc03f67b7777">OHOS::Event::GetTimeStamp</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1517910668093522"><a name="p1517910668093522"></a><a name="p1517910668093522"></a>const TimeType &amp; </p>
<p id="p878903207093522"><a name="p878903207093522"></a><a name="p878903207093522"></a>Obtains the timestamp when an event occurs. </p>
</td>
</tr>
<tr id="row3381705093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1952644418093522"><a name="p1952644418093522"></a><a name="p1952644418093522"></a><a href="graphic.md#gabee47ba229e81c44f648cf5b3203010f">OHOS::Event::SetTimeStamp</a> (const TimeType &amp;timeStamp)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1581948119093522"><a name="p1581948119093522"></a><a name="p1581948119093522"></a>void </p>
<p id="p1216396930093522"><a name="p1216396930093522"></a><a name="p1216396930093522"></a>Sets the timestamp when an event occurs. </p>
</td>
</tr>
<tr id="row1731273256093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1611460510093522"><a name="p1611460510093522"></a><a name="p1611460510093522"></a><a href="graphic.md#ga3a52d91ac5d8fd7779baafae6ec92f9b">OHOS::KeyEvent::KeyEvent</a> (uint16_t keyId, uint16_t state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1748843920093522"><a name="p1748843920093522"></a><a name="p1748843920093522"></a> </p>
<p id="p1643333971093522"><a name="p1643333971093522"></a><a name="p1643333971093522"></a>A constructor used to create a <strong id="b2083873532093522"><a name="b2083873532093522"></a><a name="b2083873532093522"></a><a href="ohos-keyevent.md">KeyEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row87538036093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1839569118093522"><a name="p1839569118093522"></a><a name="p1839569118093522"></a><a href="graphic.md#ga468e77700a90ef155a2428af9176551e">OHOS::KeyEvent::~KeyEvent</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p354513644093522"><a name="p354513644093522"></a><a name="p354513644093522"></a> </p>
<p id="p536293585093522"><a name="p536293585093522"></a><a name="p536293585093522"></a>A destructor used to delete the <strong id="b274905292093522"><a name="b274905292093522"></a><a name="b274905292093522"></a><a href="ohos-keyevent.md">KeyEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row481914629093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p73185268093522"><a name="p73185268093522"></a><a name="p73185268093522"></a><a href="graphic.md#gae2b2b83cc3a562b3173f69c95722db99">OHOS::KeyEvent::GetKeyId</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p134402553093522"><a name="p134402553093522"></a><a name="p134402553093522"></a>uint16_t </p>
<p id="p911243347093522"><a name="p911243347093522"></a><a name="p911243347093522"></a>Obtains the key ID. </p>
</td>
</tr>
<tr id="row1062980115093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p697648763093522"><a name="p697648763093522"></a><a name="p697648763093522"></a><a href="graphic.md#gaf93661e10da4b4df75c04d8fd199a5e8">OHOS::KeyEvent::GetState</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p762985211093522"><a name="p762985211093522"></a><a name="p762985211093522"></a>uint16_t </p>
<p id="p168787296093522"><a name="p168787296093522"></a><a name="p168787296093522"></a>Obtains the key state. </p>
</td>
</tr>
<tr id="row1086628186093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2050381599093522"><a name="p2050381599093522"></a><a name="p2050381599093522"></a><a href="graphic.md#ga0ccf400cdc4f55e28ef4680a4a3c5632">OHOS::LongPressEvent::LongPressEvent</a> (const <a href="ohos-point.md">Point</a> &amp;pos, const TimeType &amp;timeStamp)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1619529119093522"><a name="p1619529119093522"></a><a name="p1619529119093522"></a> </p>
<p id="p899121637093522"><a name="p899121637093522"></a><a name="p899121637093522"></a>A constructor used to create a <strong id="b1971686003093522"><a name="b1971686003093522"></a><a name="b1971686003093522"></a><a href="ohos-longpressevent.md">LongPressEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row999356887093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p993591837093522"><a name="p993591837093522"></a><a name="p993591837093522"></a><a href="graphic.md#gab7cd91a47633f432b39da4f6056f72fc">OHOS::LongPressEvent::~LongPressEvent</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p472612792093522"><a name="p472612792093522"></a><a name="p472612792093522"></a>virtual </p>
<p id="p1171082273093522"><a name="p1171082273093522"></a><a name="p1171082273093522"></a>A destructor used to delete the <strong id="b1727080560093522"><a name="b1727080560093522"></a><a name="b1727080560093522"></a><a href="ohos-longpressevent.md">LongPressEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row1482162826093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1746132732093522"><a name="p1746132732093522"></a><a name="p1746132732093522"></a><a href="graphic.md#ga851cee6814b500741c9eb4833ae75c19">OHOS::PressEvent::PressEvent</a> (const <a href="ohos-point.md">Point</a> &amp;pos)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p137940188093522"><a name="p137940188093522"></a><a name="p137940188093522"></a> </p>
<p id="p283945060093522"><a name="p283945060093522"></a><a name="p283945060093522"></a>A constructor used to create a <strong id="b2073966907093522"><a name="b2073966907093522"></a><a name="b2073966907093522"></a><a href="ohos-pressevent.md">PressEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row1320143577093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1788353621093522"><a name="p1788353621093522"></a><a name="p1788353621093522"></a><a href="graphic.md#ga14740b5b74e00d2dfd612f2e08687884">OHOS::PressEvent::~PressEvent</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1690456619093522"><a name="p1690456619093522"></a><a name="p1690456619093522"></a>virtual </p>
<p id="p1894134636093522"><a name="p1894134636093522"></a><a name="p1894134636093522"></a>A destructor used to delete the <strong id="b842155916093522"><a name="b842155916093522"></a><a name="b842155916093522"></a><a href="ohos-pressevent.md">PressEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row1212692545093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1760622282093522"><a name="p1760622282093522"></a><a name="p1760622282093522"></a><a href="graphic.md#gae74aa5e1b3f0af7e66d55e9be15f32d1">OHOS::ReleaseEvent::ReleaseEvent</a> (const <a href="ohos-point.md">Point</a> &amp;pos)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1896803457093522"><a name="p1896803457093522"></a><a name="p1896803457093522"></a> </p>
<p id="p1438684709093522"><a name="p1438684709093522"></a><a name="p1438684709093522"></a>A constructor used to create a <strong id="b931578960093522"><a name="b931578960093522"></a><a name="b931578960093522"></a><a href="ohos-releaseevent.md">ReleaseEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row1263296992093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p473920007093522"><a name="p473920007093522"></a><a name="p473920007093522"></a><a href="graphic.md#ga4a9df65bdfd2edcb0f21be7b7e52ad56">OHOS::ReleaseEvent::~ReleaseEvent</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p604571634093522"><a name="p604571634093522"></a><a name="p604571634093522"></a>virtual </p>
<p id="p1489558448093522"><a name="p1489558448093522"></a><a name="p1489558448093522"></a>A destructor used to delete the <strong id="b792221352093522"><a name="b792221352093522"></a><a name="b792221352093522"></a><a href="ohos-releaseevent.md">ReleaseEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row1076117596093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p75221470093522"><a name="p75221470093522"></a><a name="p75221470093522"></a><a href="graphic.md#ga4832bd35eeae9c4402c1cba6294fe55b">OHOS::VirtualDeviceEvent::VirtualDeviceEvent</a> (uint16_t type, uint16_t value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1696194816093522"><a name="p1696194816093522"></a><a name="p1696194816093522"></a> </p>
<p id="p459176065093522"><a name="p459176065093522"></a><a name="p459176065093522"></a>A constructor used to create a <strong id="b331578800093522"><a name="b331578800093522"></a><a name="b331578800093522"></a><a href="ohos-virtualdeviceevent.md">VirtualDeviceEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row950567650093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1196901042093522"><a name="p1196901042093522"></a><a name="p1196901042093522"></a><a href="graphic.md#ga72e6afde17a0376e756b463e04a86ba1">OHOS::VirtualDeviceEvent::~VirtualDeviceEvent</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p245226678093522"><a name="p245226678093522"></a><a name="p245226678093522"></a> </p>
<p id="p372427706093522"><a name="p372427706093522"></a><a name="p372427706093522"></a>A destructor used to delete the <strong id="b1037551912093522"><a name="b1037551912093522"></a><a name="b1037551912093522"></a><a href="ohos-virtualdeviceevent.md">VirtualDeviceEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row1927228542093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p163326818093522"><a name="p163326818093522"></a><a name="p163326818093522"></a><a href="graphic.md#ga47a12f474dd7351a303e4959a05b17d1">OHOS::VirtualDeviceEvent::GetType</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1281867656093522"><a name="p1281867656093522"></a><a name="p1281867656093522"></a>uint16_t </p>
<p id="p633126072093522"><a name="p633126072093522"></a><a name="p633126072093522"></a>Obtains the type of the virtual device. </p>
</td>
</tr>
<tr id="row2086259223093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2090670186093522"><a name="p2090670186093522"></a><a name="p2090670186093522"></a><a href="graphic.md#gae0619e7f8b3c97548f763f281bdd8261">OHOS::VirtualDeviceEvent::GetState</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1031409592093522"><a name="p1031409592093522"></a><a name="p1031409592093522"></a>uint16_t </p>
<p id="p1615474339093522"><a name="p1615474339093522"></a><a name="p1615474339093522"></a>Obtains the state of the virtual event. </p>
</td>
</tr>
<tr id="row394951706093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2104720606093522"><a name="p2104720606093522"></a><a name="p2104720606093522"></a><a href="graphic.md#ga3c8dd952afc5a76f8628c7f702755bd8">OHOS::Line::Line</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p713519838093522"><a name="p713519838093522"></a><a name="p713519838093522"></a> </p>
<p id="p1803596029093522"><a name="p1803596029093522"></a><a name="p1803596029093522"></a>The default constructor used to create a <strong id="b1515799304093522"><a name="b1515799304093522"></a><a name="b1515799304093522"></a><a href="ohos-line.md">Line</a></strong> instance. </p>
</td>
</tr>
<tr id="row1774113671093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1302077739093522"><a name="p1302077739093522"></a><a name="p1302077739093522"></a><a href="graphic.md#ga0bda554c3c7d5950637a50ffbbec2269">OHOS::Line::Line</a> (const <a href="ohos-vector2-t.md">Vector2</a>&lt; int16_t &gt; &amp;a, const <a href="ohos-vector2-t.md">Vector2</a>&lt; int16_t &gt; &amp;b)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p606693111093522"><a name="p606693111093522"></a><a name="p606693111093522"></a> </p>
<p id="p261690971093522"><a name="p261690971093522"></a><a name="p261690971093522"></a>A constructor used to create a <strong id="b147130290093522"><a name="b147130290093522"></a><a name="b147130290093522"></a><a href="ohos-line.md">Line</a></strong> instance. </p>
</td>
</tr>
<tr id="row45636338093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p578572568093522"><a name="p578572568093522"></a><a name="p578572568093522"></a><a href="graphic.md#ga216de7fbcb274d28bb5a50d0e0692aa0">OHOS::Line::Line</a> (int16_t x1, int16_t <a href="en-us_topic_0000001055039462.md#ga369368526a105f3fba6776b11586070c">y1</a>, int16_t x2, int16_t y2)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p286044602093522"><a name="p286044602093522"></a><a name="p286044602093522"></a> </p>
<p id="p263280908093522"><a name="p263280908093522"></a><a name="p263280908093522"></a>A constructor used to create a <strong id="b921285254093522"><a name="b921285254093522"></a><a name="b921285254093522"></a><a href="ohos-line.md">Line</a></strong> instance. </p>
</td>
</tr>
<tr id="row1542025793093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1022789076093522"><a name="p1022789076093522"></a><a name="p1022789076093522"></a><a href="graphic.md#ga86d5bfc47854c5e85363adce571de167">OHOS::Line::~Line</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1331537760093522"><a name="p1331537760093522"></a><a name="p1331537760093522"></a> </p>
<p id="p1016714573093522"><a name="p1016714573093522"></a><a name="p1016714573093522"></a>A destructor used to delete the <strong id="b828218450093522"><a name="b828218450093522"></a><a name="b828218450093522"></a><a href="ohos-line.md">Line</a></strong> instance. </p>
</td>
</tr>
<tr id="row1987413699093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p138239861093522"><a name="p138239861093522"></a><a name="p138239861093522"></a><a href="graphic.md#gafeae0169d5e3e92fcbc743c09cd4f6d0">OHOS::Line::operator[]</a> (uint8_t <a href="en-us_topic_0000001055198076.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p360406842093522"><a name="p360406842093522"></a><a name="p360406842093522"></a><a href="ohos-vector2-t.md">Vector2</a>&lt; int16_t &gt; &amp; </p>
<p id="p1134554078093522"><a name="p1134554078093522"></a><a name="p1134554078093522"></a>Obtains the start or end point of the line based on the value of <strong id="b1025293135093522"><a name="b1025293135093522"></a><a name="b1025293135093522"></a>index</strong>. </p>
</td>
</tr>
<tr id="row872346328093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1096520522093522"><a name="p1096520522093522"></a><a name="p1096520522093522"></a><a href="graphic.md#ga3f747832db7335f2198c7746140a6631">OHOS::Line::operator[]</a> (uint8_t <a href="en-us_topic_0000001055198076.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1460785053093522"><a name="p1460785053093522"></a><a name="p1460785053093522"></a>const <a href="ohos-vector2-t.md">Vector2</a>&lt; int16_t &gt; </p>
<p id="p883076256093522"><a name="p883076256093522"></a><a name="p883076256093522"></a>Obtains the start or end point of the line based on the value of <strong id="b1676892412093522"><a name="b1676892412093522"></a><a name="b1676892412093522"></a>index</strong>. </p>
</td>
</tr>
<tr id="row2033051014093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p972936810093522"><a name="p972936810093522"></a><a name="p972936810093522"></a><a href="graphic.md#ga56fa89b7be39ff928c8ad488bbaddac3">OHOS::Polygon::Polygon</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1645273576093522"><a name="p1645273576093522"></a><a name="p1645273576093522"></a> </p>
<p id="p1160441498093522"><a name="p1160441498093522"></a><a name="p1160441498093522"></a>The default constructor used to create a <strong id="b71037848093522"><a name="b71037848093522"></a><a name="b71037848093522"></a><a href="ohos-polygon.md">Polygon</a></strong> instance. </p>
</td>
</tr>
<tr id="row1398906423093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p581468681093522"><a name="p581468681093522"></a><a name="p581468681093522"></a><a href="graphic.md#gaa3be3f3605efe49629c024974e56da6a">OHOS::Polygon::Polygon</a> (const <a href="ohos-rect.md">Rect</a> &amp;rect)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p190163338093522"><a name="p190163338093522"></a><a name="p190163338093522"></a> </p>
<p id="p274354430093522"><a name="p274354430093522"></a><a name="p274354430093522"></a>A constructor used to construct a <strong id="b1529690388093522"><a name="b1529690388093522"></a><a name="b1529690388093522"></a><a href="ohos-polygon.md">Polygon</a></strong> instance based on a rectangle. </p>
</td>
</tr>
<tr id="row803065629093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p371572995093522"><a name="p371572995093522"></a><a name="p371572995093522"></a><a href="graphic.md#ga54df053b5f430ed2ee7be14a898f668d">OHOS::Polygon::Polygon</a> (const <a href="ohos-vector2-t.md">Vector2</a>&lt; int16_t &gt; *vertexes, const uint8_t vertexNum)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p368362520093522"><a name="p368362520093522"></a><a name="p368362520093522"></a> </p>
<p id="p1356681640093522"><a name="p1356681640093522"></a><a name="p1356681640093522"></a>A constructor used to create a <strong id="b1402912404093522"><a name="b1402912404093522"></a><a name="b1402912404093522"></a><a href="ohos-polygon.md">Polygon</a></strong> instance based on the vertex coordinates and the number of coordinates. </p>
</td>
</tr>
<tr id="row982995889093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1377130419093522"><a name="p1377130419093522"></a><a name="p1377130419093522"></a><a href="graphic.md#gab27ef37ff8b5462c771aed96f58dcac6">OHOS::Polygon::~Polygon</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1495000827093522"><a name="p1495000827093522"></a><a name="p1495000827093522"></a> </p>
<p id="p1662600428093522"><a name="p1662600428093522"></a><a name="p1662600428093522"></a>A destructor used to delete the <strong id="b298971510093522"><a name="b298971510093522"></a><a name="b298971510093522"></a><a href="ohos-polygon.md">Polygon</a></strong> instance. </p>
</td>
</tr>
<tr id="row1304468292093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1554124929093522"><a name="p1554124929093522"></a><a name="p1554124929093522"></a><a href="graphic.md#ga73295e4e05e9063082fb33b9847f4831">OHOS::Polygon::MakeAABB</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p359459869093522"><a name="p359459869093522"></a><a name="p359459869093522"></a><a href="ohos-rect.md">Rect</a> </p>
<p id="p260210906093522"><a name="p260210906093522"></a><a name="p260210906093522"></a>Obtains the minimum rectangle that can contain the polygon. All vertices of the polygon are inside this rectangle. </p>
</td>
</tr>
<tr id="row2052665269093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2014890143093522"><a name="p2014890143093522"></a><a name="p2014890143093522"></a><a href="graphic.md#gaca0240aa7a65b24365064f296ff38a63">OHOS::Polygon::GetVertexNum</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p699467840093522"><a name="p699467840093522"></a><a name="p699467840093522"></a>uint8_t </p>
<p id="p193725382093522"><a name="p193725382093522"></a><a name="p193725382093522"></a>Obtains the number of vertices of the polygon. </p>
</td>
</tr>
<tr id="row1164305671093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1080961617093522"><a name="p1080961617093522"></a><a name="p1080961617093522"></a><a href="graphic.md#gad1990bc3055e0155d324479a2bb3baf1">OHOS::Polygon::SetVertexNum</a> (uint8_t vertexNum)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1377074069093522"><a name="p1377074069093522"></a><a name="p1377074069093522"></a>void </p>
<p id="p2010001180093522"><a name="p2010001180093522"></a><a name="p2010001180093522"></a>Sets the number of vertices of a polygon. </p>
</td>
</tr>
<tr id="row710621220093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p232238853093522"><a name="p232238853093522"></a><a name="p232238853093522"></a><a href="graphic.md#ga1779d4dd0671282d297f1693252ca9d9">OHOS::Intersect</a> (const <a href="ohos-line.md">Line</a> &amp;a, const <a href="ohos-line.md">Line</a> &amp;b, <a href="ohos-vector2-t.md">Vector2</a>&lt; int16_t &gt; &amp;out)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p820053235093522"><a name="p820053235093522"></a><a name="p820053235093522"></a>bool </p>
<p id="p135181725093522"><a name="p135181725093522"></a><a name="p135181725093522"></a>Checks whether line segment a and line segment b intersect, and returns the intersection point (if available). </p>
</td>
</tr>
<tr id="row775811086093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p297128650093522"><a name="p297128650093522"></a><a name="p297128650093522"></a><a href="graphic.md#gace8a8524c6f91aa2f0f9be73a628da20">OHOS::IsIntersect</a> (const <a href="ohos-line.md">Line</a> &amp;a, const <a href="ohos-line.md">Line</a> &amp;b)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p982682116093522"><a name="p982682116093522"></a><a name="p982682116093522"></a>bool </p>
<p id="p701733371093522"><a name="p701733371093522"></a><a name="p701733371093522"></a>Chekcs whether line segment a and line segment b intersect. </p>
</td>
</tr>
<tr id="row350184353093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2108818509093522"><a name="p2108818509093522"></a><a name="p2108818509093522"></a><a href="graphic.md#ga0001387a136a87fb2c2e2b5eb3363c72">OHOS::Clip</a> (<a href="ohos-polygon.md">Polygon</a> &amp;poly, const <a href="ohos-line.md">Line</a> &amp;line)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p33335718093522"><a name="p33335718093522"></a><a name="p33335718093522"></a>void </p>
<p id="p596961888093522"><a name="p596961888093522"></a><a name="p596961888093522"></a>Clips a polygon by using a line segment. </p>
</td>
</tr>
<tr id="row747739575093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p472032885093522"><a name="p472032885093522"></a><a name="p472032885093522"></a><a href="graphic.md#ga9fd2882e4813fbf4dbe77baa50d97b5c">OHOS::SuthHodgClip</a> (const <a href="ohos-rect.md">Rect</a> &amp;clipRect, const <a href="ohos-polygon.md">Polygon</a> &amp;polygon)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p130942173093522"><a name="p130942173093522"></a><a name="p130942173093522"></a><a href="ohos-polygon.md">Polygon</a> </p>
<p id="p603117581093522"><a name="p603117581093522"></a><a name="p603117581093522"></a>Implements Sutherland-Hodgman, an algorithm used for clipping polygons. </p>
</td>
</tr>
<tr id="row87575665093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p173887487093522"><a name="p173887487093522"></a><a name="p173887487093522"></a><a href="graphic.md#ga22219a4351530d5a6914bdc5dcf406d0">OHOS::Clip</a> (const <a href="ohos-line.md">Line</a> &amp;line, const <a href="ohos-polygon.md">Polygon</a> &amp;poly, <a href="ohos-vector2-t.md">Vector2</a>&lt; int16_t &gt; *pOut, uint8_t *pNum)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p346235554093522"><a name="p346235554093522"></a><a name="p346235554093522"></a>void </p>
<p id="p2008480529093522"><a name="p2008480529093522"></a><a name="p2008480529093522"></a>Clips a polygon by using a line segment and obtains the intersections. </p>
</td>
</tr>
<tr id="row1646289987093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p386280502093522"><a name="p386280502093522"></a><a name="p386280502093522"></a><a href="graphic.md#ga7fd378c8c6c9fcf7325fa354f182865c">OHOS::Vector2&lt; T &gt;::Vector2</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p789715972093522"><a name="p789715972093522"></a><a name="p789715972093522"></a> </p>
<p id="p981332431093522"><a name="p981332431093522"></a><a name="p981332431093522"></a>A constructor used to create a <strong id="b1573259997093522"><a name="b1573259997093522"></a><a name="b1573259997093522"></a><a href="ohos-vector2-t.md">Vector2</a></strong> instance. </p>
</td>
</tr>
<tr id="row1434560429093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p868378757093522"><a name="p868378757093522"></a><a name="p868378757093522"></a><a href="graphic.md#gada601fe3518d7bb489010370f1db9903">OHOS::Vector2&lt; T &gt;::Vector2</a> (T x, T y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1240979039093522"><a name="p1240979039093522"></a><a name="p1240979039093522"></a> </p>
<p id="p1893704099093522"><a name="p1893704099093522"></a><a name="p1893704099093522"></a>A constructor used to create a <strong id="b1907366938093522"><a name="b1907366938093522"></a><a name="b1907366938093522"></a><a href="ohos-vector2-t.md">Vector2</a></strong> instance based on the X and Y coordinates. </p>
</td>
</tr>
<tr id="row599042526093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1427095370093522"><a name="p1427095370093522"></a><a name="p1427095370093522"></a><a href="graphic.md#ga1cc5130b89192fc1403eb29dd4504cbb">OHOS::Vector2&lt; T &gt;::~Vector2</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1562608744093522"><a name="p1562608744093522"></a><a name="p1562608744093522"></a> </p>
<p id="p108389162093522"><a name="p108389162093522"></a><a name="p108389162093522"></a>A destructor used to delete the <strong id="b1755024687093522"><a name="b1755024687093522"></a><a name="b1755024687093522"></a><a href="ohos-vector2-t.md">Vector2</a></strong> instance. </p>
</td>
</tr>
<tr id="row1478219740093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1603994546093522"><a name="p1603994546093522"></a><a name="p1603994546093522"></a><a href="graphic.md#gae45c198b5bcb73ecac8d654c281bc21a">OHOS::Vector2&lt; T &gt;::Dot</a> (const <a href="ohos-vector2-t.md">Vector2</a>&lt; T &gt; &amp;other) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1337658359093522"><a name="p1337658359093522"></a><a name="p1337658359093522"></a>T </p>
<p id="p1678803706093522"><a name="p1678803706093522"></a><a name="p1678803706093522"></a>Calculates the scalar product of the two-dimensional vector and another two-dimensional vector. </p>
</td>
</tr>
<tr id="row746450609093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p236162221093522"><a name="p236162221093522"></a><a name="p236162221093522"></a><a href="graphic.md#gac1c8e01fd488d5f8aea6bddad1dec206">OHOS::Vector2&lt; T &gt;::Cross</a> (const <a href="ohos-vector2-t.md">Vector2</a>&lt; T &gt; &amp;other) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1566628096093522"><a name="p1566628096093522"></a><a name="p1566628096093522"></a>T </p>
<p id="p1559348926093522"><a name="p1559348926093522"></a><a name="p1559348926093522"></a>Calculates the cross product of the two-dimensional vector and another two-dimensional vector. </p>
</td>
</tr>
<tr id="row827476791093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p257719772093522"><a name="p257719772093522"></a><a name="p257719772093522"></a><a href="graphic.md#ga0e56d35f73116fdc410e305c1d702076">OHOS::Vector3&lt; T &gt;::Vector3</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1171949474093522"><a name="p1171949474093522"></a><a name="p1171949474093522"></a> </p>
<p id="p2024969906093522"><a name="p2024969906093522"></a><a name="p2024969906093522"></a>A constructor used to create a <strong id="b2118861533093522"><a name="b2118861533093522"></a><a name="b2118861533093522"></a><a href="ohos-vector3-t.md">Vector3</a></strong> instance. </p>
</td>
</tr>
<tr id="row1264654961093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2142697642093522"><a name="p2142697642093522"></a><a name="p2142697642093522"></a><a href="graphic.md#ga1b07727c686eb7a4d028d1052cc0fd3c">OHOS::Vector3&lt; T &gt;::Vector3</a> (T x, T y, T z)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2079050089093522"><a name="p2079050089093522"></a><a name="p2079050089093522"></a> </p>
<p id="p133938656093522"><a name="p133938656093522"></a><a name="p133938656093522"></a>Defines a <strong id="b307672249093522"><a name="b307672249093522"></a><a name="b307672249093522"></a><a href="ohos-vector3-t.md">Vector3</a></strong> instance and initializes the values of <strong id="b1796220661093522"><a name="b1796220661093522"></a><a name="b1796220661093522"></a>x</strong>, <strong id="b757993553093522"><a name="b757993553093522"></a><a name="b757993553093522"></a>y</strong>, and <strong id="b949723898093522"><a name="b949723898093522"></a><a name="b949723898093522"></a>z</strong>. </p>
</td>
</tr>
<tr id="row1459570854093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p38066226093522"><a name="p38066226093522"></a><a name="p38066226093522"></a><a href="graphic.md#ga3b5bda0743cb7968e10429b627444f20">OHOS::Vector3&lt; T &gt;::~Vector3</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1194866610093522"><a name="p1194866610093522"></a><a name="p1194866610093522"></a> </p>
<p id="p773617999093522"><a name="p773617999093522"></a><a name="p773617999093522"></a>A destructor used to delete the <strong id="b287930418093522"><a name="b287930418093522"></a><a name="b287930418093522"></a><a href="ohos-vector3-t.md">Vector3</a></strong> instance. </p>
</td>
</tr>
<tr id="row189326760093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p405011076093522"><a name="p405011076093522"></a><a name="p405011076093522"></a><a href="graphic.md#ga8fedd026cac422882e9c0a0d5d1f3b50">OHOS::Matrix3&lt; T &gt;::Matrix3</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1790061589093522"><a name="p1790061589093522"></a><a name="p1790061589093522"></a> </p>
<p id="p1193310795093522"><a name="p1193310795093522"></a><a name="p1193310795093522"></a>Defines a <strong id="b1227271475093522"><a name="b1227271475093522"></a><a name="b1227271475093522"></a><a href="ohos-matrix3-t.md">Matrix3</a></strong> instance and initializes the 3 x 3 matrix data. </p>
</td>
</tr>
<tr id="row1601541798093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p756602039093522"><a name="p756602039093522"></a><a name="p756602039093522"></a><a href="graphic.md#ga068d055d130c7c46269072bf65254082">OHOS::Matrix3&lt; T &gt;::Matrix3</a> (T m00, T m01, T m02, T m10, T m11, T m12, T m20, T m21, T m22)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p498362245093522"><a name="p498362245093522"></a><a name="p498362245093522"></a> </p>
<p id="p1466202406093522"><a name="p1466202406093522"></a><a name="p1466202406093522"></a>Defines a <strong id="b1971075971093522"><a name="b1971075971093522"></a><a name="b1971075971093522"></a><a href="ohos-matrix3-t.md">Matrix3</a></strong> instance and initializes the 3 x 3 matrix data. </p>
</td>
</tr>
<tr id="row283858967093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p726020914093522"><a name="p726020914093522"></a><a name="p726020914093522"></a><a href="graphic.md#ga9cf7c2656623468c34003bb3c4056a72">OHOS::Matrix3&lt; T &gt;::~Matrix3</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p969540714093522"><a name="p969540714093522"></a><a name="p969540714093522"></a> </p>
<p id="p397211607093522"><a name="p397211607093522"></a><a name="p397211607093522"></a>A destructor used to delete the <strong id="b1566423046093522"><a name="b1566423046093522"></a><a name="b1566423046093522"></a><a href="ohos-matrix3-t.md">Matrix3</a></strong> instance. </p>
</td>
</tr>
<tr id="row848357162093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1347557638093522"><a name="p1347557638093522"></a><a name="p1347557638093522"></a><a href="graphic.md#ga8fd60ee68cc3a51d8c7ea9d3d665323c">OHOS::Matrix3&lt; T &gt;::GetData</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p816843777093522"><a name="p816843777093522"></a><a name="p816843777093522"></a>const T * </p>
<p id="p1690847373093522"><a name="p1690847373093522"></a><a name="p1690847373093522"></a>Obtains the 3 x 3 matrix data. </p>
</td>
</tr>
<tr id="row1013457163093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1698920972093522"><a name="p1698920972093522"></a><a name="p1698920972093522"></a><a href="graphic.md#ga5464ffd57d0abbd0381b2a6cf3a7d2fb">OHOS::Matrix3&lt; T &gt;::Determinant</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1930256485093522"><a name="p1930256485093522"></a><a name="p1930256485093522"></a>T </p>
<p id="p1631238251093522"><a name="p1631238251093522"></a><a name="p1631238251093522"></a>Obtains the determinant of the matrix. </p>
</td>
</tr>
<tr id="row1289931907093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p42031892093522"><a name="p42031892093522"></a><a name="p42031892093522"></a><a href="graphic.md#gabf1edc9a01bace13596de01615ae20a2">OHOS::Matrix3&lt; T &gt;::Inverse</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1461395435093522"><a name="p1461395435093522"></a><a name="p1461395435093522"></a><a href="ohos-matrix3-t.md">Matrix3</a> </p>
<p id="p656907144093522"><a name="p656907144093522"></a><a name="p656907144093522"></a>Obtains the inverse matrix. </p>
</td>
</tr>
<tr id="row587519273093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1904741567093522"><a name="p1904741567093522"></a><a name="p1904741567093522"></a><a href="graphic.md#ga8bd72462c8fdba21d3a805a415a88d06">OHOS::Matrix3&lt; T &gt;::Rotate</a> (T angle, const <a href="ohos-vector2-t.md">Vector2</a>&lt; T &gt; &amp;pivot)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1531288932093522"><a name="p1531288932093522"></a><a name="p1531288932093522"></a>static <a href="ohos-matrix3-t.md">Matrix3</a> </p>
<p id="p721153387093522"><a name="p721153387093522"></a><a name="p721153387093522"></a>Obtains a rotation matrix. After a matrix is rotated, its data is shifted leftwards by 15 bits. Therefore, the result data needs to be shifted rightwards by 15 bits. </p>
</td>
</tr>
<tr id="row250021050093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1757041861093522"><a name="p1757041861093522"></a><a name="p1757041861093522"></a><a href="graphic.md#ga915aa59cac37c6584fafb06a06046087">OHOS::Matrix3&lt; T &gt;::Scale</a> (const <a href="ohos-vector2-t.md">Vector2</a>&lt; T &gt; &amp;scale, const <a href="ohos-vector2-t.md">Vector2</a>&lt; T &gt; &amp;fixed)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p466473459093522"><a name="p466473459093522"></a><a name="p466473459093522"></a>static <a href="ohos-matrix3-t.md">Matrix3</a> </p>
<p id="p1982896412093522"><a name="p1982896412093522"></a><a name="p1982896412093522"></a>Obtains the scaling matrix. After a matrix is scaled, its data is shifted leftwards by 8 bits. Therefore, the result data needs to be shifted rightwards by 8 bits. </p>
</td>
</tr>
<tr id="row2111000786093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1408497932093522"><a name="p1408497932093522"></a><a name="p1408497932093522"></a><a href="graphic.md#gab1cbae80ef16538294c97ba81626970e">OHOS::Matrix3&lt; T &gt;::Translate</a> (const <a href="ohos-vector2-t.md">Vector2</a>&lt; T &gt; &amp;trans)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1762564127093522"><a name="p1762564127093522"></a><a name="p1762564127093522"></a>static <a href="ohos-matrix3-t.md">Matrix3</a>&lt; T &gt; </p>
<p id="p482469110093522"><a name="p482469110093522"></a><a name="p482469110093522"></a>Obtains a matrix translation. </p>
</td>
</tr>
<tr id="row1042899162093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1773616509093522"><a name="p1773616509093522"></a><a name="p1773616509093522"></a><a href="graphic.md#ga4854963aa969ee20a6cd174a70f5cd23">OHOS::HeapBase::operator new</a> (size_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p39167843093522"><a name="p39167843093522"></a><a name="p39167843093522"></a>void * </p>
<p id="p789868122093522"><a name="p789868122093522"></a><a name="p789868122093522"></a>Overrides the <strong id="b833098815093522"><a name="b833098815093522"></a><a name="b833098815093522"></a>new</strong> function. </p>
</td>
</tr>
<tr id="row2074868946093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1663751246093522"><a name="p1663751246093522"></a><a name="p1663751246093522"></a><a href="graphic.md#gadf1997a0f56ac2b220e7f0f8e8e0a6ef">OHOS::HeapBase::operator delete</a> (void *p)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p440460569093522"><a name="p440460569093522"></a><a name="p440460569093522"></a>void </p>
<p id="p451998193093522"><a name="p451998193093522"></a><a name="p451998193093522"></a>Overrides the <strong id="b2137622852093522"><a name="b2137622852093522"></a><a name="b2137622852093522"></a>delete</strong> function. </p>
</td>
</tr>
<tr id="row1018671501093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1227071025093522"><a name="p1227071025093522"></a><a name="p1227071025093522"></a><a href="graphic.md#gac06da499194705b22e31a8a78022ceab">OHOS::FlexLayout::FlexLayout</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p686537019093522"><a name="p686537019093522"></a><a name="p686537019093522"></a> </p>
<p id="p754569345093522"><a name="p754569345093522"></a><a name="p754569345093522"></a>A default constructor used to create a <strong id="b683784910093522"><a name="b683784910093522"></a><a name="b683784910093522"></a><a href="ohos-flexlayout.md">FlexLayout</a></strong> instance. </p>
</td>
</tr>
<tr id="row1139632188093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1554611064093522"><a name="p1554611064093522"></a><a name="p1554611064093522"></a><a href="graphic.md#gada390db4ca762cf1dac06abfcd74e543">OHOS::FlexLayout::~FlexLayout</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p146265747093522"><a name="p146265747093522"></a><a name="p146265747093522"></a>virtual </p>
<p id="p1593380766093522"><a name="p1593380766093522"></a><a name="p1593380766093522"></a>A destructor used to delete the <strong id="b1598769952093522"><a name="b1598769952093522"></a><a name="b1598769952093522"></a><a href="ohos-flexlayout.md">FlexLayout</a></strong> instance. </p>
</td>
</tr>
<tr id="row300901071093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p473532788093522"><a name="p473532788093522"></a><a name="p473532788093522"></a><a href="graphic.md#gaa683d4401ecb3c19a5b5c2cea1252636">OHOS::FlexLayout::SetMajorAxisAlign</a> (const AlignType &amp;align)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1469635741093522"><a name="p1469635741093522"></a><a name="p1469635741093522"></a>void </p>
<p id="p678102628093522"><a name="p678102628093522"></a><a name="p678102628093522"></a>Sets the alignment mode of the primary axis (the axis where the layout direction is located). The child views in the layout are placed in this mode in the direction of the primary axis. </p>
</td>
</tr>
<tr id="row1354049339093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1774891859093522"><a name="p1774891859093522"></a><a name="p1774891859093522"></a><a href="graphic.md#gadb57c6de7bcd0c04cde8004019e32b32">OHOS::FlexLayout::SetSecondaryAxisAlign</a> (const AlignType &amp;align)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1341014188093522"><a name="p1341014188093522"></a><a name="p1341014188093522"></a>void </p>
<p id="p1002628719093522"><a name="p1002628719093522"></a><a name="p1002628719093522"></a>Sets the alignment mode of the secondary axis (the axis perpendicular to the set layout direction). </p>
</td>
</tr>
<tr id="row617653467093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1600132504093522"><a name="p1600132504093522"></a><a name="p1600132504093522"></a><a href="graphic.md#gade436564eb29d29e32220863a6fe94e1">OHOS::FlexLayout::SetFlexWrap</a> (uint8_t wrap)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p465005631093522"><a name="p465005631093522"></a><a name="p465005631093522"></a>void </p>
<p id="p723406007093522"><a name="p723406007093522"></a><a name="p723406007093522"></a>Sets whether to support word wrap. </p>
</td>
</tr>
<tr id="row1763709167093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p419363982093522"><a name="p419363982093522"></a><a name="p419363982093522"></a><a href="graphic.md#ga976abe5b006bef9018dd0d8ee2380526">OHOS::FlexLayout::LayoutChildren</a> (bool needInvalidate=false) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1718706966093522"><a name="p1718706966093522"></a><a name="p1718706966093522"></a>virtual void </p>
<p id="p1312030535093522"><a name="p1312030535093522"></a><a name="p1312030535093522"></a>Lays out all child views according to the preset arrangement mode. </p>
</td>
</tr>
<tr id="row1987494763093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p473847559093522"><a name="p473847559093522"></a><a name="p473847559093522"></a><a href="graphic.md#ga9c612ad9265b7031ed95844277608b3e">OHOS::GridLayout::GridLayout</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1095561969093522"><a name="p1095561969093522"></a><a name="p1095561969093522"></a> </p>
<p id="p2106033636093522"><a name="p2106033636093522"></a><a name="p2106033636093522"></a>A default constructor used to create a <strong id="b1701995129093522"><a name="b1701995129093522"></a><a name="b1701995129093522"></a><a href="ohos-gridlayout.md">GridLayout</a></strong> instance. </p>
</td>
</tr>
<tr id="row1908083214093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2026558653093522"><a name="p2026558653093522"></a><a name="p2026558653093522"></a><a href="graphic.md#ga1c2e62760fdb7032341272197f376358">OHOS::GridLayout::~GridLayout</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p788901992093522"><a name="p788901992093522"></a><a name="p788901992093522"></a>virtual </p>
<p id="p1998233351093522"><a name="p1998233351093522"></a><a name="p1998233351093522"></a>A destructor used to delete the <strong id="b1524825696093522"><a name="b1524825696093522"></a><a name="b1524825696093522"></a><a href="ohos-gridlayout.md">GridLayout</a></strong> instance. </p>
</td>
</tr>
<tr id="row630479263093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p209113950093522"><a name="p209113950093522"></a><a name="p209113950093522"></a><a href="graphic.md#gac2df1f13d5ee6d2e6993c9a51eb9a716">OHOS::GridLayout::SetRows</a> (const uint16_t &amp;rows)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1934296209093522"><a name="p1934296209093522"></a><a name="p1934296209093522"></a>void </p>
<p id="p1586051235093522"><a name="p1586051235093522"></a><a name="p1586051235093522"></a>Sets the number of rows in a grid. </p>
</td>
</tr>
<tr id="row2081285421093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2129033034093522"><a name="p2129033034093522"></a><a name="p2129033034093522"></a><a href="graphic.md#gab5737dec2f5c0bc812dee9c4bc7a796b">OHOS::GridLayout::SetCols</a> (const uint16_t &amp;cols)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p832796585093522"><a name="p832796585093522"></a><a name="p832796585093522"></a>void </p>
<p id="p404864698093522"><a name="p404864698093522"></a><a name="p404864698093522"></a>Sets the number of columns in a grid. </p>
</td>
</tr>
<tr id="row1343581288093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p466719528093522"><a name="p466719528093522"></a><a name="p466719528093522"></a><a href="graphic.md#ga449c17a9fa3898aac9ac68a2c48363a3">OHOS::GridLayout::LayoutChildren</a> (bool needInvalidate=false) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1249457973093522"><a name="p1249457973093522"></a><a name="p1249457973093522"></a>virtual void </p>
<p id="p830966555093522"><a name="p830966555093522"></a><a name="p830966555093522"></a>Lays out all child views according to the preset arrangement mode. </p>
</td>
</tr>
<tr id="row1896608336093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p72384815093522"><a name="p72384815093522"></a><a name="p72384815093522"></a><a href="graphic.md#gaba1ca0f86a85d3c5636ca543b0ed08d8">OHOS::Layout::Layout</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p617490781093522"><a name="p617490781093522"></a><a name="p617490781093522"></a> </p>
<p id="p1935291381093522"><a name="p1935291381093522"></a><a name="p1935291381093522"></a>A default constructor used to create a <strong id="b229507203093522"><a name="b229507203093522"></a><a name="b229507203093522"></a><a href="ohos-layout.md">Layout</a></strong> instance. </p>
</td>
</tr>
<tr id="row714022148093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p844395256093522"><a name="p844395256093522"></a><a name="p844395256093522"></a><a href="graphic.md#ga6c7cc7a849197fe014ea57d0534728bf">OHOS::Layout::~Layout</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1541881534093522"><a name="p1541881534093522"></a><a name="p1541881534093522"></a>virtual </p>
<p id="p1056652707093522"><a name="p1056652707093522"></a><a name="p1056652707093522"></a>A destructor used to delete the <strong id="b1260165846093522"><a name="b1260165846093522"></a><a name="b1260165846093522"></a><a href="ohos-layout.md">Layout</a></strong> instance. </p>
</td>
</tr>
<tr id="row1151299766093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p710670794093522"><a name="p710670794093522"></a><a name="p710670794093522"></a><a href="graphic.md#gada9223ec4d664c00a9640c8b9cbcacc3">OHOS::Layout::SetLayoutDirection</a> (const <a href="codec.md#ga8ef30fa9c08e08c8706653571f9f5b81">DirectionType</a> &amp;direction)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1354174539093522"><a name="p1354174539093522"></a><a name="p1354174539093522"></a>void </p>
<p id="p102113965093522"><a name="p102113965093522"></a><a name="p102113965093522"></a>Sets the layout direction. </p>
</td>
</tr>
<tr id="row1509502820093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1595083795093522"><a name="p1595083795093522"></a><a name="p1595083795093522"></a><a href="graphic.md#ga92532583f91e7cb84255ddbacc34b3e6">OHOS::List&lt; T &gt;::List</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p888242197093522"><a name="p888242197093522"></a><a name="p888242197093522"></a> </p>
<p id="p1578476776093522"><a name="p1578476776093522"></a><a name="p1578476776093522"></a>A default constructor used to create a <strong id="b1672509848093522"><a name="b1672509848093522"></a><a name="b1672509848093522"></a><a href="ohos-list-t.md">List</a></strong> instance. The initial size is <strong id="b108111540093522"><a name="b108111540093522"></a><a name="b108111540093522"></a>0</strong>. </p>
</td>
</tr>
<tr id="row1994674408093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1952266387093522"><a name="p1952266387093522"></a><a name="p1952266387093522"></a><a href="graphic.md#gae36a1bb98e3352c2b97423ca340a51a9">OHOS::List&lt; T &gt;::~List</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p28060985093522"><a name="p28060985093522"></a><a name="p28060985093522"></a>virtual </p>
<p id="p376833798093522"><a name="p376833798093522"></a><a name="p376833798093522"></a>A destructor used to delete the <strong id="b1181187154093522"><a name="b1181187154093522"></a><a name="b1181187154093522"></a><a href="ohos-list-t.md">List</a></strong> instance. </p>
</td>
</tr>
<tr id="row1064976859093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1517160440093522"><a name="p1517160440093522"></a><a name="p1517160440093522"></a><a href="graphic.md#ga5e52d77c60c7710ca70ba3720b260c6a">OHOS::List&lt; T &gt;::Front</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p687075279093522"><a name="p687075279093522"></a><a name="p687075279093522"></a>const T </p>
<p id="p962918477093522"><a name="p962918477093522"></a><a name="p962918477093522"></a>Obtains the head node data of a linked list. </p>
</td>
</tr>
<tr id="row1550389601093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1354628126093522"><a name="p1354628126093522"></a><a name="p1354628126093522"></a><a href="graphic.md#gae5c3f6272b58c45f458c475a79ebfe3d">OHOS::List&lt; T &gt;::Back</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p269668466093522"><a name="p269668466093522"></a><a name="p269668466093522"></a>const T </p>
<p id="p1776923751093522"><a name="p1776923751093522"></a><a name="p1776923751093522"></a>Obtains the tail node data of a linked list. </p>
</td>
</tr>
<tr id="row1418139453093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1701137280093522"><a name="p1701137280093522"></a><a name="p1701137280093522"></a><a href="graphic.md#gad26996a2802e32e89ecefa8311fe5d27">OHOS::List&lt; T &gt;::PushBack</a> (T data)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1390592371093522"><a name="p1390592371093522"></a><a name="p1390592371093522"></a>void </p>
<p id="p500296096093522"><a name="p500296096093522"></a><a name="p500296096093522"></a>Inserts data at the end of a linked list. </p>
</td>
</tr>
<tr id="row1358872649093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1906460059093522"><a name="p1906460059093522"></a><a name="p1906460059093522"></a><a href="graphic.md#ga5084ab98dce9aab41b216f73a04ed8b6">OHOS::List&lt; T &gt;::PushFront</a> (T data)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1831634795093522"><a name="p1831634795093522"></a><a name="p1831634795093522"></a>void </p>
<p id="p1401769029093522"><a name="p1401769029093522"></a><a name="p1401769029093522"></a>Inserts data at the start of a linked list. </p>
</td>
</tr>
<tr id="row716763887093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1333750676093522"><a name="p1333750676093522"></a><a name="p1333750676093522"></a><a href="graphic.md#ga667b81954fd60474b575b4aa9c6bc193">OHOS::List&lt; T &gt;::PopBack</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1529169056093522"><a name="p1529169056093522"></a><a name="p1529169056093522"></a>void </p>
<p id="p287892845093522"><a name="p287892845093522"></a><a name="p287892845093522"></a>Pops up a data record at the end of a linked list. </p>
</td>
</tr>
<tr id="row347035466093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1050246009093522"><a name="p1050246009093522"></a><a name="p1050246009093522"></a><a href="graphic.md#ga0fa953b7476412923f25d079431f7189">OHOS::List&lt; T &gt;::PopFront</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2094623777093522"><a name="p2094623777093522"></a><a name="p2094623777093522"></a>void </p>
<p id="p2094310387093522"><a name="p2094310387093522"></a><a name="p2094310387093522"></a>Pops up a data record at the start of a linked list. </p>
</td>
</tr>
<tr id="row1878408778093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p504546122093522"><a name="p504546122093522"></a><a name="p504546122093522"></a><a href="graphic.md#ga3bdd5d105c9e7d7e18456dfb55ba8b45">OHOS::List&lt; T &gt;::Insert</a> (<a href="ohos-listnode-t.md">ListNode</a>&lt; T &gt; *node, T data)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1908552169093522"><a name="p1908552169093522"></a><a name="p1908552169093522"></a>void </p>
<p id="p355996549093522"><a name="p355996549093522"></a><a name="p355996549093522"></a>Inserts data before a specified node, which follows the inserted data node. </p>
</td>
</tr>
<tr id="row1750979382093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1480712122093522"><a name="p1480712122093522"></a><a name="p1480712122093522"></a><a href="graphic.md#gaf3806e9581846930ad5bf063ced38367">OHOS::List&lt; T &gt;::Remove</a> (<a href="ohos-listnode-t.md">ListNode</a>&lt; T &gt; *node)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p845442232093522"><a name="p845442232093522"></a><a name="p845442232093522"></a>void </p>
<p id="p885103795093522"><a name="p885103795093522"></a><a name="p885103795093522"></a>Deletes a data node. </p>
</td>
</tr>
<tr id="row1603773919093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1221804725093522"><a name="p1221804725093522"></a><a name="p1221804725093522"></a><a href="graphic.md#ga2292866786c9f888bc722ffcebc7c831">OHOS::List&lt; T &gt;::Clear</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2004440236093522"><a name="p2004440236093522"></a><a name="p2004440236093522"></a>void </p>
<p id="p1202840208093522"><a name="p1202840208093522"></a><a name="p1202840208093522"></a>Deletes all nodes from a linked list. </p>
</td>
</tr>
<tr id="row1316313756093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1749368965093522"><a name="p1749368965093522"></a><a name="p1749368965093522"></a><a href="graphic.md#ga74dcfe1a4b37d6fabbcdb5f8049fb578">OHOS::List&lt; T &gt;::Head</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1743570328093522"><a name="p1743570328093522"></a><a name="p1743570328093522"></a><a href="ohos-listnode-t.md">ListNode</a>&lt; T &gt; * </p>
<p id="p978224023093522"><a name="p978224023093522"></a><a name="p978224023093522"></a>Obtains the head node address of a linked list. </p>
</td>
</tr>
<tr id="row588998125093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p349695851093522"><a name="p349695851093522"></a><a name="p349695851093522"></a><a href="graphic.md#gab60fda7a08504db2cf992de435ad1848">OHOS::List&lt; T &gt;::Tail</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1574841161093522"><a name="p1574841161093522"></a><a name="p1574841161093522"></a><a href="ohos-listnode-t.md">ListNode</a>&lt; T &gt; * </p>
<p id="p828320993093522"><a name="p828320993093522"></a><a name="p828320993093522"></a>Obtains the tail node address of a linked list. </p>
</td>
</tr>
<tr id="row604923033093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p305560410093522"><a name="p305560410093522"></a><a name="p305560410093522"></a><a href="graphic.md#ga8fe8647f764773c29d3fa70c9b70eb2a">OHOS::List&lt; T &gt;::Begin</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p469517054093522"><a name="p469517054093522"></a><a name="p469517054093522"></a><a href="ohos-listnode-t.md">ListNode</a>&lt; T &gt; * </p>
<p id="p1264885596093522"><a name="p1264885596093522"></a><a name="p1264885596093522"></a>Obtains the head node address of a linked list. </p>
</td>
</tr>
<tr id="row2012669096093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p200935889093522"><a name="p200935889093522"></a><a name="p200935889093522"></a><a href="graphic.md#ga839de65540644c9725b31959367355c5">OHOS::List&lt; T &gt;::End</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p786593784093522"><a name="p786593784093522"></a><a name="p786593784093522"></a>const <a href="ohos-listnode-t.md">ListNode</a>&lt; T &gt; * </p>
<p id="p1374698836093522"><a name="p1374698836093522"></a><a name="p1374698836093522"></a>Obtains the end node address of a linked list. </p>
</td>
</tr>
<tr id="row1400059278093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p265407743093522"><a name="p265407743093522"></a><a name="p265407743093522"></a><a href="graphic.md#ga93ec1e9e9b778751aa53b7afb0b67258">OHOS::List&lt; T &gt;::Next</a> (const <a href="ohos-listnode-t.md">ListNode</a>&lt; T &gt; *node) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p615447139093522"><a name="p615447139093522"></a><a name="p615447139093522"></a><a href="ohos-listnode-t.md">ListNode</a>&lt; T &gt; * </p>
<p id="p415521981093522"><a name="p415521981093522"></a><a name="p415521981093522"></a>Obtains the address of the node following the specified <strong id="b93637673093522"><a name="b93637673093522"></a><a name="b93637673093522"></a>node</strong>. </p>
</td>
</tr>
<tr id="row1332884290093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1841140177093522"><a name="p1841140177093522"></a><a name="p1841140177093522"></a><a href="graphic.md#ga48f81f9faa9f4057ae8f84e437d90442">OHOS::List&lt; T &gt;::IsEmpty</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p63544063093522"><a name="p63544063093522"></a><a name="p63544063093522"></a>bool </p>
<p id="p491400455093522"><a name="p491400455093522"></a><a name="p491400455093522"></a>Checks whether a linked list is empty. </p>
</td>
</tr>
<tr id="row802584799093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p280769905093522"><a name="p280769905093522"></a><a name="p280769905093522"></a><a href="graphic.md#gae209f40639cdee7a5b07dc6587dac170">OHOS::List&lt; T &gt;::Size</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p285013388093522"><a name="p285013388093522"></a><a name="p285013388093522"></a>uint16_t </p>
<p id="p284887515093522"><a name="p284887515093522"></a><a name="p284887515093522"></a>Obtains the size of a linked list. </p>
</td>
</tr>
<tr id="row1982344779093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p741321672093522"><a name="p741321672093522"></a><a name="p741321672093522"></a><a href="graphic.md#gaabb0ea584d8faebbdcb45fcc11447b8b">OHOS::ImageCacheMalloc</a> (<a href="ohos-imageinfo.md">ImageInfo</a> &amp;info)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1152459065093522"><a name="p1152459065093522"></a><a name="p1152459065093522"></a>void * </p>
<p id="p169147070093522"><a name="p169147070093522"></a><a name="p169147070093522"></a>Applies for the image cache memory. You can customize the memory area when loading image resources. </p>
</td>
</tr>
<tr id="row282135752093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p488729550093522"><a name="p488729550093522"></a><a name="p488729550093522"></a><a href="graphic.md#ga71fe0f3eb82083006b51fec59ad11088">OHOS::ImageCacheFree</a> (<a href="ohos-imageinfo.md">ImageInfo</a> &amp;info)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p119118435093522"><a name="p119118435093522"></a><a name="p119118435093522"></a>void </p>
<p id="p1511108859093522"><a name="p1511108859093522"></a><a name="p1511108859093522"></a>Releases the image cache memory. </p>
</td>
</tr>
<tr id="row222845790093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2097121668093522"><a name="p2097121668093522"></a><a name="p2097121668093522"></a><a href="graphic.md#gafc7b2c7d0b427079d8b04b11cc4db009">OHOS::UIMalloc</a> (uint32_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p176834728093522"><a name="p176834728093522"></a><a name="p176834728093522"></a>void * </p>
<p id="p2026410459093522"><a name="p2026410459093522"></a><a name="p2026410459093522"></a>Applies for memory for the graphics module. You can implement this function to override the <strong id="b62307966093522"><a name="b62307966093522"></a><a name="b62307966093522"></a>malloc</strong> and <strong id="b1577078031093522"><a name="b1577078031093522"></a><a name="b1577078031093522"></a>new</strong> functions. </p>
</td>
</tr>
<tr id="row69951527093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p720445393093522"><a name="p720445393093522"></a><a name="p720445393093522"></a><a href="graphic.md#ga77914ea7bc96f6cb30f65ae2014746e8">OHOS::UIFree</a> (void *buffer)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p281356770093522"><a name="p281356770093522"></a><a name="p281356770093522"></a>void </p>
<p id="p555900375093522"><a name="p555900375093522"></a><a name="p555900375093522"></a>Releases memory for the graphics module. You can implement this function to override the <strong id="b2006820940093522"><a name="b2006820940093522"></a><a name="b2006820940093522"></a>free</strong> and <strong id="b811587391093522"><a name="b811587391093522"></a><a name="b811587391093522"></a>delete</strong> functions. </p>
</td>
</tr>
<tr id="row1625015887093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1377861484093522"><a name="p1377861484093522"></a><a name="p1377861484093522"></a><a href="graphic.md#ga7d3779a5cf121ba98026ddbf36705178">OHOS::Rect::Rect</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1722951519093522"><a name="p1722951519093522"></a><a name="p1722951519093522"></a> </p>
<p id="p705684652093522"><a name="p705684652093522"></a><a name="p705684652093522"></a>A constructor used to create a <strong id="b1848652009093522"><a name="b1848652009093522"></a><a name="b1848652009093522"></a><a href="ohos-rect.md">Rect</a></strong> instance. </p>
</td>
</tr>
<tr id="row2123504298093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1452473892093522"><a name="p1452473892093522"></a><a name="p1452473892093522"></a><a href="graphic.md#ga3729aa7a7f052d182bd20707097f9db9">OHOS::Rect::~Rect</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2114652745093522"><a name="p2114652745093522"></a><a name="p2114652745093522"></a> </p>
<p id="p31644603093522"><a name="p31644603093522"></a><a name="p31644603093522"></a>A destructor used to delete the <strong id="b26023303093522"><a name="b26023303093522"></a><a name="b26023303093522"></a><a href="ohos-rect.md">Rect</a></strong> instance. </p>
</td>
</tr>
<tr id="row1205564464093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p290352697093522"><a name="p290352697093522"></a><a name="p290352697093522"></a><a href="graphic.md#gab37a12fb10478edcb5389fa0b347c46f">OHOS::Rect::Rect</a> (int16_t left, int16_t top, int16_t right, int16_t bottom)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1301198492093522"><a name="p1301198492093522"></a><a name="p1301198492093522"></a> </p>
<p id="p1968305673093522"><a name="p1968305673093522"></a><a name="p1968305673093522"></a>A constructor used to create a <strong id="b1659230879093522"><a name="b1659230879093522"></a><a name="b1659230879093522"></a><a href="ohos-rect.md">Rect</a></strong> instance based on the coordinates of the four boundaries. </p>
</td>
</tr>
<tr id="row1347120018093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1879846470093522"><a name="p1879846470093522"></a><a name="p1879846470093522"></a><a href="graphic.md#ga766eee89dbd7d4969fb88485893ea662">OHOS::Rect::Rect</a> (const <a href="ohos-rect.md">Rect</a> &amp;other)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1576755375093522"><a name="p1576755375093522"></a><a name="p1576755375093522"></a> </p>
<p id="p226390163093522"><a name="p226390163093522"></a><a name="p226390163093522"></a>A constructor used to create a <strong id="b1605164851093522"><a name="b1605164851093522"></a><a name="b1605164851093522"></a><a href="ohos-rect.md">Rect</a></strong> instance by copying another rectangle. </p>
</td>
</tr>
<tr id="row325535247093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1292014023093522"><a name="p1292014023093522"></a><a name="p1292014023093522"></a><a href="graphic.md#gabcc74bf916f06152b4a69e1a36116e3f">OHOS::Rect::Rect</a> (const <a href="ohos-rect.md">Rect</a> &amp;&amp;other)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1073259134093522"><a name="p1073259134093522"></a><a name="p1073259134093522"></a> </p>
<p id="p464819999093522"><a name="p464819999093522"></a><a name="p464819999093522"></a>A constructor used to create a <strong id="b747178252093522"><a name="b747178252093522"></a><a name="b747178252093522"></a><a href="ohos-rect.md">Rect</a></strong> instance by copying another rectangle. </p>
</td>
</tr>
<tr id="row1398831236093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2004290282093522"><a name="p2004290282093522"></a><a name="p2004290282093522"></a><a href="graphic.md#ga4423fe83ed9271d1186711dff65796cb">OHOS::Rect::SetRect</a> (int16_t left, int16_t top, int16_t right, int16_t bottom)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p840239776093522"><a name="p840239776093522"></a><a name="p840239776093522"></a>void </p>
<p id="p2133275185093522"><a name="p2133275185093522"></a><a name="p2133275185093522"></a>Sets the coordinates of the four boundaries of a rectangle. </p>
</td>
</tr>
<tr id="row1582334904093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p196567080093522"><a name="p196567080093522"></a><a name="p196567080093522"></a><a href="graphic.md#ga2f8315ea6e574aec99210950feef1b55">OHOS::Rect::GetWidth</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p33038345093522"><a name="p33038345093522"></a><a name="p33038345093522"></a>int16_t </p>
<p id="p1024404938093522"><a name="p1024404938093522"></a><a name="p1024404938093522"></a>Obtains the rectangle width. </p>
</td>
</tr>
<tr id="row596580627093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p131485816093522"><a name="p131485816093522"></a><a name="p131485816093522"></a><a href="graphic.md#ga9a1b7ee8eee0d5fa96739fd0a0bac638">OHOS::Rect::GetHeight</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p80600874093522"><a name="p80600874093522"></a><a name="p80600874093522"></a>int16_t </p>
<p id="p624128016093522"><a name="p624128016093522"></a><a name="p624128016093522"></a>Obtains the rectangle height. </p>
</td>
</tr>
<tr id="row189817214093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p561527310093522"><a name="p561527310093522"></a><a name="p561527310093522"></a><a href="graphic.md#gad0410528e93dcf552129e207dfe37aba">OHOS::Rect::GetX</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1820745275093522"><a name="p1820745275093522"></a><a name="p1820745275093522"></a>int16_t </p>
<p id="p1458077702093522"><a name="p1458077702093522"></a><a name="p1458077702093522"></a>Obtains the left boundary coordinate of the rectangle. </p>
</td>
</tr>
<tr id="row94817285093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p781921557093522"><a name="p781921557093522"></a><a name="p781921557093522"></a><a href="graphic.md#gaa3b94d5228cabba6341039e8f28fda74">OHOS::Rect::GetY</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1892041005093522"><a name="p1892041005093522"></a><a name="p1892041005093522"></a>int16_t </p>
<p id="p2019810275093522"><a name="p2019810275093522"></a><a name="p2019810275093522"></a>Obtains the top boundary coordinate of the rectangle. </p>
</td>
</tr>
<tr id="row1931677229093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1616502938093522"><a name="p1616502938093522"></a><a name="p1616502938093522"></a><a href="graphic.md#ga2f4bd954929225e2f124db4c9d2c62ec">OHOS::Rect::GetLeft</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1466322921093522"><a name="p1466322921093522"></a><a name="p1466322921093522"></a>int16_t </p>
<p id="p1560000047093522"><a name="p1560000047093522"></a><a name="p1560000047093522"></a>Obtains the left boundary coordinate of the rectangle. </p>
</td>
</tr>
<tr id="row67088528093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1653304050093522"><a name="p1653304050093522"></a><a name="p1653304050093522"></a><a href="graphic.md#ga9ab9c7eda50b517e55d608270360f0a0">OHOS::Rect::GetTop</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p384368719093522"><a name="p384368719093522"></a><a name="p384368719093522"></a>int16_t </p>
<p id="p1236048102093522"><a name="p1236048102093522"></a><a name="p1236048102093522"></a>Obtains the top boundary coordinate of the rectangle. </p>
</td>
</tr>
<tr id="row551005677093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1171301317093522"><a name="p1171301317093522"></a><a name="p1171301317093522"></a><a href="graphic.md#gab7695173ebb2f4b8e9aa58947786a379">OHOS::Rect::GetRight</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p671739647093522"><a name="p671739647093522"></a><a name="p671739647093522"></a>int16_t </p>
<p id="p2100808372093522"><a name="p2100808372093522"></a><a name="p2100808372093522"></a>Obtains the right boundary coordinate of the rectangle. </p>
</td>
</tr>
<tr id="row1332541104093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1796806239093522"><a name="p1796806239093522"></a><a name="p1796806239093522"></a><a href="graphic.md#ga6c2f9cf035a36c605e20ccc76de8fbea">OHOS::Rect::GetBottom</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2008082658093522"><a name="p2008082658093522"></a><a name="p2008082658093522"></a>int16_t </p>
<p id="p2030615054093522"><a name="p2030615054093522"></a><a name="p2030615054093522"></a>Obtains the bottom boundary coordinate of the rectangle. </p>
</td>
</tr>
<tr id="row946797015093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1045312869093522"><a name="p1045312869093522"></a><a name="p1045312869093522"></a><a href="graphic.md#ga6d14ede131d4a9445e0890632d2e4370">OHOS::Rect::SetX</a> (int16_t x)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p630720983093522"><a name="p630720983093522"></a><a name="p630720983093522"></a>void </p>
<p id="p1180468515093522"><a name="p1180468515093522"></a><a name="p1180468515093522"></a>Changes the left boundary coordinate of the rectangle without changing the rectangle width. </p>
</td>
</tr>
<tr id="row667970875093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1667110889093522"><a name="p1667110889093522"></a><a name="p1667110889093522"></a><a href="graphic.md#ga260393d7b4c514eebc2a28187ec6f8b4">OHOS::Rect::SetY</a> (int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p104950494093522"><a name="p104950494093522"></a><a name="p104950494093522"></a>void </p>
<p id="p1797318921093522"><a name="p1797318921093522"></a><a name="p1797318921093522"></a>Changes the top boundary coordinate of the rectangle without changing the rectangle height. </p>
</td>
</tr>
<tr id="row1201713276093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p608405566093522"><a name="p608405566093522"></a><a name="p608405566093522"></a><a href="graphic.md#ga723d2b5ace818a6b71e0570339689690">OHOS::Rect::SetPosition</a> (int16_t x, int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p47680614093522"><a name="p47680614093522"></a><a name="p47680614093522"></a>void </p>
<p id="p2038261446093522"><a name="p2038261446093522"></a><a name="p2038261446093522"></a>Changes the coordinates of the left and top boundaries of the rectangle without changing the rectangle width and height. </p>
</td>
</tr>
<tr id="row727908843093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1756659253093522"><a name="p1756659253093522"></a><a name="p1756659253093522"></a><a href="graphic.md#ga8a31c03ecb4a452d79374b392537f183">OHOS::Rect::SetWidth</a> (int16_t width)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p208964994093522"><a name="p208964994093522"></a><a name="p208964994093522"></a>void </p>
<p id="p1083684813093522"><a name="p1083684813093522"></a><a name="p1083684813093522"></a>Changes the width of the rectangle without changing the coordinate of the left boundary. </p>
</td>
</tr>
<tr id="row17961564093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p854506523093522"><a name="p854506523093522"></a><a name="p854506523093522"></a><a href="graphic.md#ga8e3fab1e0d6cd4671c6628b94c493d0f">OHOS::Rect::SetHeight</a> (int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1517729454093522"><a name="p1517729454093522"></a><a name="p1517729454093522"></a>void </p>
<p id="p129710908093522"><a name="p129710908093522"></a><a name="p129710908093522"></a>Changes the height of the rectangle without changing the coordinate of the top boundary. </p>
</td>
</tr>
<tr id="row1034555890093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p661671140093522"><a name="p661671140093522"></a><a name="p661671140093522"></a><a href="graphic.md#ga043a1c4f0aaf4eed2ddf99083ed993bb">OHOS::Rect::SetLeft</a> (int16_t left)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1168069602093522"><a name="p1168069602093522"></a><a name="p1168069602093522"></a>void </p>
<p id="p1116721453093522"><a name="p1116721453093522"></a><a name="p1116721453093522"></a>Sets the coordinate of the left boundary of a rectangle. </p>
</td>
</tr>
<tr id="row852260279093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1586857496093522"><a name="p1586857496093522"></a><a name="p1586857496093522"></a><a href="graphic.md#gae7c63105b7e1871f231a1a8dfad48de7">OHOS::Rect::SetTop</a> (int16_t top)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1097752816093522"><a name="p1097752816093522"></a><a name="p1097752816093522"></a>void </p>
<p id="p155365246093522"><a name="p155365246093522"></a><a name="p155365246093522"></a>Sets the coordinate of the top boundary of a rectangle. </p>
</td>
</tr>
<tr id="row1495535715093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p517673884093522"><a name="p517673884093522"></a><a name="p517673884093522"></a><a href="graphic.md#ga314f4443ef95351a80e6edaaeff11674">OHOS::Rect::SetRight</a> (int16_t right)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1462935211093522"><a name="p1462935211093522"></a><a name="p1462935211093522"></a>void </p>
<p id="p666019696093522"><a name="p666019696093522"></a><a name="p666019696093522"></a>Sets the coordinate of the right boundary of a rectangle. </p>
</td>
</tr>
<tr id="row1134581902093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1558348875093522"><a name="p1558348875093522"></a><a name="p1558348875093522"></a><a href="graphic.md#ga764001fa9f51716fd3dacac691cbca6d">OHOS::Rect::SetBottom</a> (int16_t bottom)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1927357505093522"><a name="p1927357505093522"></a><a name="p1927357505093522"></a>void </p>
<p id="p1450751985093522"><a name="p1450751985093522"></a><a name="p1450751985093522"></a>Sets the coordinate of the bottom boundary of a rectangle. </p>
</td>
</tr>
<tr id="row1213704373093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2047533884093522"><a name="p2047533884093522"></a><a name="p2047533884093522"></a><a href="graphic.md#ga6d51096b1d1b1929d8ee6a0d25c153d8">OHOS::Rect::Resize</a> (int16_t width, int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1244213097093522"><a name="p1244213097093522"></a><a name="p1244213097093522"></a>void </p>
<p id="p1589572677093522"><a name="p1589572677093522"></a><a name="p1589572677093522"></a>Sets the width and height of a rectangle. </p>
</td>
</tr>
<tr id="row1634306763093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1596967143093522"><a name="p1596967143093522"></a><a name="p1596967143093522"></a><a href="graphic.md#ga37f61dc21e0acc2ae877687f06d11e50">OHOS::Rect::GetSize</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1281958938093522"><a name="p1281958938093522"></a><a name="p1281958938093522"></a>uint32_t </p>
<p id="p550967568093522"><a name="p550967568093522"></a><a name="p550967568093522"></a>Obtains the area of a rectangle. </p>
</td>
</tr>
<tr id="row1915087093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1136688275093522"><a name="p1136688275093522"></a><a name="p1136688275093522"></a><a href="graphic.md#ga1af82c2a558d4003d5d3b19302325a73">OHOS::Rect::Intersect</a> (const <a href="ohos-rect.md">Rect</a> &amp;rect1, const <a href="ohos-rect.md">Rect</a> &amp;rect2)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1220186936093522"><a name="p1220186936093522"></a><a name="p1220186936093522"></a>bool </p>
<p id="p165363411093522"><a name="p165363411093522"></a><a name="p165363411093522"></a>Checks whether two rectangles intersect. </p>
</td>
</tr>
<tr id="row1827953212093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1377810082093522"><a name="p1377810082093522"></a><a name="p1377810082093522"></a><a href="graphic.md#ga6269289055eab8876cc3b3c946ddd4a4">OHOS::Rect::Join</a> (const <a href="ohos-rect.md">Rect</a> &amp;rect1, const <a href="ohos-rect.md">Rect</a> &amp;rect2)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1304510550093522"><a name="p1304510550093522"></a><a name="p1304510550093522"></a>void </p>
<p id="p1678402297093522"><a name="p1678402297093522"></a><a name="p1678402297093522"></a>Obtains the minimum rectangle that contains another two rectangles. </p>
</td>
</tr>
<tr id="row1818932440093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1043066659093522"><a name="p1043066659093522"></a><a name="p1043066659093522"></a><a href="graphic.md#ga1a810eb98134027556294620821c2548">OHOS::Rect::IsContains</a> (const <a href="ohos-vector2-t.md">Vector2</a>&lt; int16_t &gt; &amp;point) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1037692943093522"><a name="p1037692943093522"></a><a name="p1037692943093522"></a>bool </p>
<p id="p1536629131093522"><a name="p1536629131093522"></a><a name="p1536629131093522"></a>Checks whether the rectangle contains a coordinate point. </p>
</td>
</tr>
<tr id="row1677932101093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p48983361093522"><a name="p48983361093522"></a><a name="p48983361093522"></a><a href="graphic.md#ga5f3cb137429e00b2e7fe1e39f7e9faad">OHOS::Rect::IsContains</a> (const <a href="ohos-point.md">Point</a> &amp;point) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p161465826093522"><a name="p161465826093522"></a><a name="p161465826093522"></a>bool </p>
<p id="p519961212093522"><a name="p519961212093522"></a><a name="p519961212093522"></a>Checks whether the rectangle contains a coordinate point. </p>
</td>
</tr>
<tr id="row356168297093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1815337641093522"><a name="p1815337641093522"></a><a name="p1815337641093522"></a><a href="graphic.md#ga808a2b486872f5d1dc1f3e944352bcfb">OHOS::Rect::IsExtends</a> (const <a href="ohos-rect.md">Rect</a> &amp;other) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p284016601093522"><a name="p284016601093522"></a><a name="p284016601093522"></a>bool </p>
<p id="p35926921093522"><a name="p35926921093522"></a><a name="p35926921093522"></a>Checks whether the rectangle is adjacent to another rectangle horizontally or vertically. </p>
</td>
</tr>
<tr id="row117835095093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p267891275093522"><a name="p267891275093522"></a><a name="p267891275093522"></a><a href="graphic.md#gacc346d49f3a8ee42662d34140afcbc9e">OHOS::Rect::IsIntersect</a> (const <a href="ohos-rect.md">Rect</a> &amp;other) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1414845211093522"><a name="p1414845211093522"></a><a name="p1414845211093522"></a>bool </p>
<p id="p634993399093522"><a name="p634993399093522"></a><a name="p634993399093522"></a>Checks whether the rectangle intersects with another rectangle. </p>
</td>
</tr>
<tr id="row258265089093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p910612892093522"><a name="p910612892093522"></a><a name="p910612892093522"></a><a href="graphic.md#ga3e17c74e6eaf3b01b5e009db582da498">OHOS::Rect::IsContains</a> (const <a href="ohos-rect.md">Rect</a> &amp;other) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1897306783093522"><a name="p1897306783093522"></a><a name="p1897306783093522"></a>bool </p>
<p id="p1510031663093522"><a name="p1510031663093522"></a><a name="p1510031663093522"></a>Checks whether the rectangle contains another rectangle. </p>
</td>
</tr>
<tr id="row247620848093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p136892618093522"><a name="p136892618093522"></a><a name="p136892618093522"></a><a href="graphic.md#ga592b31b43819c40563c52fe7b45d9358">OHOS::Style::Style</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p339911799093522"><a name="p339911799093522"></a><a name="p339911799093522"></a> </p>
<p id="p88065878093522"><a name="p88065878093522"></a><a name="p88065878093522"></a>A constructor used to create a <strong id="b1917874857093522"><a name="b1917874857093522"></a><a name="b1917874857093522"></a><a href="ohos-style.md">Style</a></strong> instance. </p>
</td>
</tr>
<tr id="row649739132093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p771905454093522"><a name="p771905454093522"></a><a name="p771905454093522"></a><a href="graphic.md#ga6356d56766de8fe37d4888ef70f521ec">OHOS::Style::~Style</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p678963047093522"><a name="p678963047093522"></a><a name="p678963047093522"></a>virtual </p>
<p id="p1189897647093522"><a name="p1189897647093522"></a><a name="p1189897647093522"></a>A destructor used to delete the <strong id="b1088480905093522"><a name="b1088480905093522"></a><a name="b1088480905093522"></a><a href="ohos-style.md">Style</a></strong> instance. </p>
</td>
</tr>
<tr id="row127566681093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p67203824093522"><a name="p67203824093522"></a><a name="p67203824093522"></a><a href="graphic.md#ga31941bb1abbb6744ee832d4b0fe6e080">OHOS::Style::SetStyle</a> (uint8_t key, int64_t value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1963915368093522"><a name="p1963915368093522"></a><a name="p1963915368093522"></a>void </p>
<p id="p515643992093522"><a name="p515643992093522"></a><a name="p515643992093522"></a>Sets a style. </p>
</td>
</tr>
<tr id="row315302566093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1173651491093522"><a name="p1173651491093522"></a><a name="p1173651491093522"></a><a href="graphic.md#ga2b4b818f26822ad6a020473e6a5e5214">OHOS::Style::GetStyle</a> (uint8_t key) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2127043819093522"><a name="p2127043819093522"></a><a name="p2127043819093522"></a>int64_t </p>
<p id="p1635990936093522"><a name="p1635990936093522"></a><a name="p1635990936093522"></a>Obtains the value of a style. </p>
</td>
</tr>
<tr id="row1583762496093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1447409987093522"><a name="p1447409987093522"></a><a name="p1447409987093522"></a><a href="graphic.md#gae5bc682ac7e77c369ccdd32a68de4387">OHOS::StyleDefault::StyleDefault</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p233485663093522"><a name="p233485663093522"></a><a name="p233485663093522"></a> </p>
<p id="p1705130675093522"><a name="p1705130675093522"></a><a name="p1705130675093522"></a>A constructor used to create a <strong id="b195442881093522"><a name="b195442881093522"></a><a name="b195442881093522"></a><a href="ohos-styledefault.md">StyleDefault</a></strong> instance. </p>
</td>
</tr>
<tr id="row917625107093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1546286273093522"><a name="p1546286273093522"></a><a name="p1546286273093522"></a><a href="graphic.md#ga01ecc90591628698b0d657a60f567b09">OHOS::StyleDefault::~StyleDefault</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p46977132093522"><a name="p46977132093522"></a><a name="p46977132093522"></a> </p>
<p id="p1273540843093522"><a name="p1273540843093522"></a><a name="p1273540843093522"></a>A destructor used to delete the <strong id="b1579869465093522"><a name="b1579869465093522"></a><a name="b1579869465093522"></a><a href="ohos-styledefault.md">StyleDefault</a></strong> instance. </p>
</td>
</tr>
<tr id="row1554169395093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1578145533093522"><a name="p1578145533093522"></a><a name="p1578145533093522"></a><a href="graphic.md#gae8f75aba900bbc7119228cdc8e97e40b">OHOS::StyleDefault::GetDefaultStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p309573862093522"><a name="p309573862093522"></a><a name="p309573862093522"></a>static <a href="ohos-style.md">Style</a> &amp; </p>
<p id="p572858134093522"><a name="p572858134093522"></a><a name="p572858134093522"></a>Obtains the default style. </p>
</td>
</tr>
<tr id="row947061198093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p836462504093522"><a name="p836462504093522"></a><a name="p836462504093522"></a><a href="graphic.md#ga1463772d745bb998846daad09b11df58">OHOS::StyleDefault::GetBrightStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2025224015093522"><a name="p2025224015093522"></a><a name="p2025224015093522"></a>static <a href="ohos-style.md">Style</a> &amp; </p>
<p id="p801357864093522"><a name="p801357864093522"></a><a name="p801357864093522"></a>Obtains the bright style. </p>
</td>
</tr>
<tr id="row1659687081093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1047071922093522"><a name="p1047071922093522"></a><a name="p1047071922093522"></a><a href="graphic.md#ga1b8645b79268358000db1cc1af2f26b9">OHOS::StyleDefault::GetBrightColorStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2020678316093522"><a name="p2020678316093522"></a><a name="p2020678316093522"></a>static <a href="ohos-style.md">Style</a> &amp; </p>
<p id="p12722206093522"><a name="p12722206093522"></a><a name="p12722206093522"></a>Obtains the bright color style. </p>
</td>
</tr>
<tr id="row30152613093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1952337065093522"><a name="p1952337065093522"></a><a name="p1952337065093522"></a><a href="graphic.md#gaa2096a167e0ea9de4450ae516f88ce31">OHOS::StyleDefault::GetButtonPressedStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p354473596093522"><a name="p354473596093522"></a><a name="p354473596093522"></a>static <a href="ohos-style.md">Style</a> &amp; </p>
<p id="p1593691249093522"><a name="p1593691249093522"></a><a name="p1593691249093522"></a>Obtains the button pressed style. </p>
</td>
</tr>
<tr id="row755540527093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p921076758093522"><a name="p921076758093522"></a><a name="p921076758093522"></a><a href="graphic.md#ga694e90d027391fd114481ea91ad39011">OHOS::StyleDefault::GetButtonReleasedStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p319992521093522"><a name="p319992521093522"></a><a name="p319992521093522"></a>static <a href="ohos-style.md">Style</a> &amp; </p>
<p id="p2142812344093522"><a name="p2142812344093522"></a><a name="p2142812344093522"></a>Obtains the button released style. </p>
</td>
</tr>
<tr id="row1801655001093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1659802513093522"><a name="p1659802513093522"></a><a name="p1659802513093522"></a><a href="graphic.md#ga42f393499cc83304a2a1cfa1cacc4003">OHOS::StyleDefault::GetButtonInactivedStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p521106508093522"><a name="p521106508093522"></a><a name="p521106508093522"></a>static <a href="ohos-style.md">Style</a> &amp; </p>
<p id="p1060286196093522"><a name="p1060286196093522"></a><a name="p1060286196093522"></a>Obtains the button inactived style. </p>
</td>
</tr>
<tr id="row614041454093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p824270226093522"><a name="p824270226093522"></a><a name="p824270226093522"></a><a href="graphic.md#ga3f4f513b6dff5e245f2341890dae5ee1">OHOS::StyleDefault::GetLabelStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1032261138093522"><a name="p1032261138093522"></a><a name="p1032261138093522"></a>static <a href="ohos-style.md">Style</a> &amp; </p>
<p id="p1650478419093522"><a name="p1650478419093522"></a><a name="p1650478419093522"></a>Obtains the label style. </p>
</td>
</tr>
<tr id="row565701676093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p800473140093522"><a name="p800473140093522"></a><a name="p800473140093522"></a><a href="graphic.md#ga726fa9b4839e4a37712addd93bc91c9c">OHOS::StyleDefault::GetBackgroundTransparentStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p581554789093522"><a name="p581554789093522"></a><a name="p581554789093522"></a>static <a href="ohos-style.md">Style</a> &amp; </p>
<p id="p2048653039093522"><a name="p2048653039093522"></a><a name="p2048653039093522"></a>Obtains the background transparent style. </p>
</td>
</tr>
<tr id="row1769312822093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1508186111093522"><a name="p1508186111093522"></a><a name="p1508186111093522"></a><a href="graphic.md#gaa4c13964a439e472d5a41edfa2e5dd4f">OHOS::StyleDefault::GetProgressBackgroundStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1933517934093522"><a name="p1933517934093522"></a><a name="p1933517934093522"></a>static <a href="ohos-style.md">Style</a> &amp; </p>
<p id="p1403807903093522"><a name="p1403807903093522"></a><a name="p1403807903093522"></a>Obtains the progress background style. </p>
</td>
</tr>
<tr id="row3660274093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p709594282093522"><a name="p709594282093522"></a><a name="p709594282093522"></a><a href="graphic.md#ga6ce583a8cce5527ee812cea6fb6a6113">OHOS::StyleDefault::GetProgressForegroundStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1823695920093522"><a name="p1823695920093522"></a><a name="p1823695920093522"></a>static <a href="ohos-style.md">Style</a> &amp; </p>
<p id="p1911689821093522"><a name="p1911689821093522"></a><a name="p1911689821093522"></a>Obtains the progress foreground style. </p>
</td>
</tr>
<tr id="row779867213093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1108060670093522"><a name="p1108060670093522"></a><a name="p1108060670093522"></a><a href="graphic.md#ga9102687741cde90b659ebdc3eb773895">OHOS::StyleDefault::GetSliderKnobStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1503438772093522"><a name="p1503438772093522"></a><a name="p1503438772093522"></a>static <a href="ohos-style.md">Style</a> &amp; </p>
<p id="p1812905057093522"><a name="p1812905057093522"></a><a name="p1812905057093522"></a>Obtains the slider knob style. </p>
</td>
</tr>
<tr id="row17853089093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p634970124093522"><a name="p634970124093522"></a><a name="p634970124093522"></a><a href="graphic.md#ga39a41c86eba9feaa5a8130da6e7c8014">OHOS::StyleDefault::GetPickerBackgroundStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1885527980093522"><a name="p1885527980093522"></a><a name="p1885527980093522"></a>static <a href="ohos-style.md">Style</a> &amp; </p>
<p id="p1274409656093522"><a name="p1274409656093522"></a><a name="p1274409656093522"></a>Obtains the picker background style. </p>
</td>
</tr>
<tr id="row1999350118093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p993037837093522"><a name="p993037837093522"></a><a name="p993037837093522"></a><a href="graphic.md#gace2f6b055a11b93b1fc632c4e135043d">OHOS::StyleDefault::GetPickerHighlightStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1267468093522"><a name="p1267468093522"></a><a name="p1267468093522"></a>static <a href="ohos-style.md">Style</a> &amp; </p>
<p id="p1045659233093522"><a name="p1045659233093522"></a><a name="p1045659233093522"></a>Obtains the picker highlight style. </p>
</td>
</tr>
<tr id="row1356150120093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p307719884093522"><a name="p307719884093522"></a><a name="p307719884093522"></a><a href="graphic.md#ga3e24fe52ec7c4bf9fc9f5703982b3568">OHOS::SysInfo::OnFPSChangedListener::OnFPSChangedListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1711889385093522"><a name="p1711889385093522"></a><a name="p1711889385093522"></a> </p>
<p id="p1281548959093522"><a name="p1281548959093522"></a><a name="p1281548959093522"></a>A constructor used to create an <strong id="b1726829400093522"><a name="b1726829400093522"></a><a name="b1726829400093522"></a><a href="ohos-sysinfo-onfpschangedlistener.md">OnFPSChangedListener</a></strong> instance with the default sampling type <strong id="b2140682365093522"><a name="b2140682365093522"></a><a name="b2140682365093522"></a>FPS_CT_FIXED_TIME</strong>. </p>
</td>
</tr>
<tr id="row573003009093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p185471298093522"><a name="p185471298093522"></a><a name="p185471298093522"></a><a href="graphic.md#ga4e103243c2fd1e2e5206262280f1b80c">OHOS::SysInfo::OnFPSChangedListener::~OnFPSChangedListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p955371677093522"><a name="p955371677093522"></a><a name="p955371677093522"></a>virtual </p>
<p id="p1246154589093522"><a name="p1246154589093522"></a><a name="p1246154589093522"></a>A destructor used to delete the <strong id="b1192058145093522"><a name="b1192058145093522"></a><a name="b1192058145093522"></a><a href="ohos-sysinfo-onfpschangedlistener.md">OnFPSChangedListener</a></strong> instance. </p>
</td>
</tr>
<tr id="row1555879374093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p542608971093522"><a name="p542608971093522"></a><a name="p542608971093522"></a><a href="graphic.md#ga82a8426a18e30ff3e9d4d388c53b4af5">OHOS::SysInfo::OnFPSChangedListener::OnFPSChanged</a> (float newFPS)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p882349421093522"><a name="p882349421093522"></a><a name="p882349421093522"></a>virtual void </p>
<p id="p2103681533093522"><a name="p2103681533093522"></a><a name="p2103681533093522"></a>Called when the FPS data changes. </p>
</td>
</tr>
<tr id="row231457401093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1595269883093522"><a name="p1595269883093522"></a><a name="p1595269883093522"></a><a href="graphic.md#gaf7c8d9a4d44cee2001ad0cd40c827c47">OHOS::SysInfo::OnFPSChangedListener::GetFPSCalculateType</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1059373070093522"><a name="p1059373070093522"></a><a name="p1059373070093522"></a><a href="graphic.md#ga75d850e3abff6c2f617b689a0cb9a3d1">FPSCalculateType</a> </p>
<p id="p96888389093522"><a name="p96888389093522"></a><a name="p96888389093522"></a>Obtains the FPS sampling type. </p>
</td>
</tr>
<tr id="row201697791093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2037689015093522"><a name="p2037689015093522"></a><a name="p2037689015093522"></a><a href="graphic.md#ga5eb3d62fce38f8d2fcf2a0a4560a3640">OHOS::SysInfo::OnFPSChangedListener::SetFPSCalculateType</a> (<a href="graphic.md#ga75d850e3abff6c2f617b689a0cb9a3d1">FPSCalculateType</a> type)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1061437371093522"><a name="p1061437371093522"></a><a name="p1061437371093522"></a>void </p>
<p id="p1411239077093522"><a name="p1411239077093522"></a><a name="p1411239077093522"></a>Sets the FPS sampling type. </p>
</td>
</tr>
<tr id="row1424037268093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p811803316093522"><a name="p811803316093522"></a><a name="p811803316093522"></a><a href="graphic.md#gaa028189de9bf2968948578c8e09a9101">OHOS::SysInfo::GetFPS</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p993220556093522"><a name="p993220556093522"></a><a name="p993220556093522"></a>static float </p>
<p id="p1735936772093522"><a name="p1735936772093522"></a><a name="p1735936772093522"></a>Obtains the FPS data. </p>
</td>
</tr>
<tr id="row503346414093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1775874300093522"><a name="p1775874300093522"></a><a name="p1775874300093522"></a><a href="graphic.md#gac885a43e87f57ae57e0d8b6d213e9fa1">OHOS::SysInfo::RegisterFPSChangedListener</a> (<a href="ohos-sysinfo-onfpschangedlistener.md">OnFPSChangedListener</a> *onFPSChangedListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p509907890093522"><a name="p509907890093522"></a><a name="p509907890093522"></a>static void </p>
<p id="p330367087093522"><a name="p330367087093522"></a><a name="p330367087093522"></a>Registers the listener for notifying the FPS changes. </p>
</td>
</tr>
<tr id="row1246540645093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p587636590093522"><a name="p587636590093522"></a><a name="p587636590093522"></a><a href="graphic.md#ga375bdd5a61da0f2bc437a531c8958d70">OHOS::Theme::Theme</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p344122326093522"><a name="p344122326093522"></a><a name="p344122326093522"></a> </p>
<p id="p649744959093522"><a name="p649744959093522"></a><a name="p649744959093522"></a>A constructor used to create a <strong id="b2053698782093522"><a name="b2053698782093522"></a><a name="b2053698782093522"></a><a href="ohos-theme.md">Theme</a></strong> instance. </p>
</td>
</tr>
<tr id="row478878081093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p348476686093522"><a name="p348476686093522"></a><a name="p348476686093522"></a><a href="graphic.md#ga7de1b9b039dd5aee8493f4aad889358f">OHOS::Theme::~Theme</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1831936204093522"><a name="p1831936204093522"></a><a name="p1831936204093522"></a>virtual </p>
<p id="p2048369459093522"><a name="p2048369459093522"></a><a name="p2048369459093522"></a>A destructor used to delete the <strong id="b191124255093522"><a name="b191124255093522"></a><a name="b191124255093522"></a><a href="ohos-theme.md">Theme</a></strong> instance. </p>
</td>
</tr>
<tr id="row729781012093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p621008300093522"><a name="p621008300093522"></a><a name="p621008300093522"></a><a href="graphic.md#ga141064843f4b5524b91f3f7c3cb21d11">OHOS::Theme::GetMainStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p503876265093522"><a name="p503876265093522"></a><a name="p503876265093522"></a><a href="ohos-style.md">Style</a> &amp; </p>
<p id="p1798054294093522"><a name="p1798054294093522"></a><a name="p1798054294093522"></a>Obtains the basic style. </p>
</td>
</tr>
<tr id="row223274691093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1524000364093522"><a name="p1524000364093522"></a><a name="p1524000364093522"></a><a href="graphic.md#ga0b1ce70a05042464e32e5bbddbc8f715">OHOS::Theme::GetButtonStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p668762230093522"><a name="p668762230093522"></a><a name="p668762230093522"></a><a href="ohos-buttonstyle.md">ButtonStyle</a> &amp; </p>
<p id="p916863347093522"><a name="p916863347093522"></a><a name="p916863347093522"></a>Obtains the style of this button. </p>
</td>
</tr>
<tr id="row303931100093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p978513112093522"><a name="p978513112093522"></a><a name="p978513112093522"></a><a href="graphic.md#ga1d56911596bb1b1480a412ac9c3ff0ed">OHOS::Theme::GetLabelStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1037397111093522"><a name="p1037397111093522"></a><a name="p1037397111093522"></a><a href="ohos-style.md">Style</a> &amp; </p>
<p id="p237716264093522"><a name="p237716264093522"></a><a name="p237716264093522"></a>Obtains the style of this label. </p>
</td>
</tr>
<tr id="row464703782093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2072562652093522"><a name="p2072562652093522"></a><a name="p2072562652093522"></a><a href="graphic.md#ga17e000653498ceec378b79a1f25cf490">OHOS::Theme::GetPickerBackgroundStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1950027511093522"><a name="p1950027511093522"></a><a name="p1950027511093522"></a><a href="ohos-style.md">Style</a> &amp; </p>
<p id="p787555562093522"><a name="p787555562093522"></a><a name="p787555562093522"></a>Obtains the background style of this picker. </p>
</td>
</tr>
<tr id="row98626604093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p940287132093522"><a name="p940287132093522"></a><a name="p940287132093522"></a><a href="graphic.md#ga40c28c8cf0f19f8507b34e8c3af88c6b">OHOS::Theme::GetPickerHighlightStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p576624676093522"><a name="p576624676093522"></a><a name="p576624676093522"></a><a href="ohos-style.md">Style</a> &amp; </p>
<p id="p144060343093522"><a name="p144060343093522"></a><a name="p144060343093522"></a>Obtains the highlight style of this picker. </p>
</td>
</tr>
<tr id="row391443514093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1858582596093522"><a name="p1858582596093522"></a><a name="p1858582596093522"></a><a href="graphic.md#gafbc7c3ae50f322fbb9c12d06eb50b9bf">OHOS::Theme::GetProgressBackgroundStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p669725292093522"><a name="p669725292093522"></a><a name="p669725292093522"></a><a href="ohos-style.md">Style</a> &amp; </p>
<p id="p1885443079093522"><a name="p1885443079093522"></a><a name="p1885443079093522"></a>Obtains the background style of this progress bar. </p>
</td>
</tr>
<tr id="row1067779168093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1034370623093522"><a name="p1034370623093522"></a><a name="p1034370623093522"></a><a href="graphic.md#ga0366f405bc2221944783a96c14f89b8a">OHOS::Theme::GetProgressForegroundStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p182837302093522"><a name="p182837302093522"></a><a name="p182837302093522"></a><a href="ohos-style.md">Style</a> &amp; </p>
<p id="p1191364878093522"><a name="p1191364878093522"></a><a name="p1191364878093522"></a>Obtains the foreground style of this progress bar. </p>
</td>
</tr>
<tr id="row1866893261093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1500069879093522"><a name="p1500069879093522"></a><a name="p1500069879093522"></a><a href="graphic.md#gad528fd10d4b9bcec9d1951c1c54674ee">OHOS::Theme::GetSliderKnobStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p260522461093522"><a name="p260522461093522"></a><a name="p260522461093522"></a><a href="ohos-style.md">Style</a> &amp; </p>
<p id="p1325486165093522"><a name="p1325486165093522"></a><a name="p1325486165093522"></a>Obtains the style of this slider knob. </p>
</td>
</tr>
<tr id="row468059738093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p104197722093522"><a name="p104197722093522"></a><a name="p104197722093522"></a><a href="graphic.md#gaf98c321c61e63bdfdc1a0eed3735084b">OHOS::ThemeManager::GetInstance</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2000869755093522"><a name="p2000869755093522"></a><a name="p2000869755093522"></a>static <a href="ohos-thememanager.md">ThemeManager</a> &amp; </p>
<p id="p2105264874093522"><a name="p2105264874093522"></a><a name="p2105264874093522"></a>Obtains the singleton instance of the <strong id="b196916698093522"><a name="b196916698093522"></a><a name="b196916698093522"></a><a href="ohos-thememanager.md">ThemeManager</a></strong> class. </p>
</td>
</tr>
<tr id="row364143248093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1264329311093522"><a name="p1264329311093522"></a><a name="p1264329311093522"></a><a href="graphic.md#ga6c4963d3186afc52db0d0a18bd52820f">OHOS::ThemeManager::SetCurrent</a> (<a href="ohos-theme.md">Theme</a> *theme)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2136773133093522"><a name="p2136773133093522"></a><a name="p2136773133093522"></a>void </p>
<p id="p846726524093522"><a name="p846726524093522"></a><a name="p846726524093522"></a>Sets the current screen theme for this application. </p>
</td>
</tr>
<tr id="row655265082093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1385820334093522"><a name="p1385820334093522"></a><a name="p1385820334093522"></a><a href="graphic.md#ga6aeed87ecd925de4262763f20cd940d5">OHOS::ThemeManager::GetCurrent</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p850019976093522"><a name="p850019976093522"></a><a name="p850019976093522"></a><a href="ohos-theme.md">Theme</a> * </p>
<p id="p210154021093522"><a name="p210154021093522"></a><a name="p210154021093522"></a>Obtains the current screen theme of this application. </p>
</td>
</tr>
<tr id="row1005047665093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p799379776093522"><a name="p799379776093522"></a><a name="p799379776093522"></a><a href="graphic.md#ga3b20453b0a161da3a1a761fd75da9975">OHOS::TransformMap::TransformMap</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1899165054093522"><a name="p1899165054093522"></a><a name="p1899165054093522"></a> </p>
<p id="p528138694093522"><a name="p528138694093522"></a><a name="p528138694093522"></a>The default constructor used to create a <strong id="b840295938093522"><a name="b840295938093522"></a><a name="b840295938093522"></a><a href="ohos-transformmap.md">TransformMap</a></strong> instance. </p>
</td>
</tr>
<tr id="row824481094093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p351739261093522"><a name="p351739261093522"></a><a name="p351739261093522"></a><a href="graphic.md#ga84f0243719d4b43d0ee3a22e74c165bb">OHOS::TransformMap::TransformMap</a> (const <a href="ohos-rect.md">Rect</a> &amp;rect)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1026264633093522"><a name="p1026264633093522"></a><a name="p1026264633093522"></a> </p>
<p id="p197299006093522"><a name="p197299006093522"></a><a name="p197299006093522"></a>A constructor used to create a <strong id="b2080676019093522"><a name="b2080676019093522"></a><a name="b2080676019093522"></a><a href="ohos-transformmap.md">TransformMap</a></strong> instance. </p>
</td>
</tr>
<tr id="row1575239424093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1696665311093522"><a name="p1696665311093522"></a><a name="p1696665311093522"></a><a href="graphic.md#gaaa46c8a5a343df76b418423a9f2344ba">OHOS::TransformMap::~TransformMap</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1759944369093522"><a name="p1759944369093522"></a><a name="p1759944369093522"></a> </p>
<p id="p1701486166093522"><a name="p1701486166093522"></a><a name="p1701486166093522"></a>A destructor used to delete the <strong id="b1256532582093522"><a name="b1256532582093522"></a><a name="b1256532582093522"></a><a href="ohos-transformmap.md">TransformMap</a></strong> instance. </p>
</td>
</tr>
<tr id="row179074818093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1993720288093522"><a name="p1993720288093522"></a><a name="p1993720288093522"></a><a href="graphic.md#ga6a50a29fe85e89c6d4445822c7a2946b">OHOS::TransformMap::GetClockWise</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2026061228093522"><a name="p2026061228093522"></a><a name="p2026061228093522"></a>bool </p>
<p id="p1864577345093522"><a name="p1864577345093522"></a><a name="p1864577345093522"></a>Checks whether the vertex coordinates of a polygon are clockwise. </p>
</td>
</tr>
<tr id="row1214697771093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1413545446093522"><a name="p1413545446093522"></a><a name="p1413545446093522"></a><a href="graphic.md#gaaf0b94adde30d2ee1f3c82ef5d8c60c9">OHOS::TransformMap::SetPolygon</a> (const <a href="ohos-polygon.md">Polygon</a> &amp;polygon)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2000435724093522"><a name="p2000435724093522"></a><a name="p2000435724093522"></a>void </p>
<p id="p132831313093522"><a name="p132831313093522"></a><a name="p132831313093522"></a>Sets a polygon after rectangle transformation. </p>
</td>
</tr>
<tr id="row1795912383093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1147737693093522"><a name="p1147737693093522"></a><a name="p1147737693093522"></a><a href="graphic.md#ga84f8d315da89e7aae7bf29478dbb51df">OHOS::TransformMap::GetPolygon</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p605187981093522"><a name="p605187981093522"></a><a name="p605187981093522"></a><a href="ohos-polygon.md">Polygon</a> </p>
<p id="p1607891224093522"><a name="p1607891224093522"></a><a name="p1607891224093522"></a>Obtains the polygon after rectangle transformation. </p>
</td>
</tr>
<tr id="row58005277093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2138330148093522"><a name="p2138330148093522"></a><a name="p2138330148093522"></a><a href="graphic.md#ga8a44fb7a813f5f183307191e96e18670">OHOS::TransformMap::GetPivot</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1013770084093522"><a name="p1013770084093522"></a><a name="p1013770084093522"></a><a href="ohos-point.md">Point</a> </p>
<p id="p891076295093522"><a name="p891076295093522"></a><a name="p891076295093522"></a>Obtains the pivot for the rotation or scaling operation. </p>
</td>
</tr>
<tr id="row921270176093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p162633784093522"><a name="p162633784093522"></a><a name="p162633784093522"></a><a href="graphic.md#ga84ec8032b9c8a4121c7464e6c14c7d01">OHOS::TransformMap::IsInvalid</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1933956402093522"><a name="p1933956402093522"></a><a name="p1933956402093522"></a>bool </p>
<p id="p1328104348093522"><a name="p1328104348093522"></a><a name="p1328104348093522"></a>Checks whether the <strong id="b385435208093522"><a name="b385435208093522"></a><a name="b385435208093522"></a><a href="ohos-transformmap.md">TransformMap</a></strong> instance is invalid. When the vertices are all 0, the <strong id="b52727245093522"><a name="b52727245093522"></a><a name="b52727245093522"></a><a href="ohos-transformmap.md">TransformMap</a></strong> is invalid. </p>
</td>
</tr>
<tr id="row1622306179093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p286059830093522"><a name="p286059830093522"></a><a name="p286059830093522"></a><a href="graphic.md#gaa2d8a5d822e40757f98c2a2820efed99">OHOS::TransformMap::GetBoxRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1901363187093522"><a name="p1901363187093522"></a><a name="p1901363187093522"></a><a href="ohos-rect.md">Rect</a> </p>
<p id="p1059683413093522"><a name="p1059683413093522"></a><a name="p1059683413093522"></a>Obtains the minimum rectangle that can contain a polygon. All vertices of the polygon are inside this rectangle. </p>
</td>
</tr>
<tr id="row2060662216093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1656745293093522"><a name="p1656745293093522"></a><a name="p1656745293093522"></a><a href="graphic.md#gaea4c507789bf4c27daef3e81176c656d">OHOS::TransformMap::Rotate</a> (int16_t angle, const <a href="ohos-vector2-t.md">Vector2</a>&lt; int16_t &gt; &amp;pivot)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p923280509093522"><a name="p923280509093522"></a><a name="p923280509093522"></a>void </p>
<p id="p915031422093522"><a name="p915031422093522"></a><a name="p915031422093522"></a>Rotates the rectangle. </p>
</td>
</tr>
<tr id="row393356086093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1572004802093522"><a name="p1572004802093522"></a><a name="p1572004802093522"></a><a href="graphic.md#gae9344b31226a5a35035ccb845bf9cff2">OHOS::TransformMap::Scale</a> (const <a href="ohos-vector2-t.md">Vector2</a>&lt; float &gt; scale, const <a href="ohos-vector2-t.md">Vector2</a>&lt; int16_t &gt; &amp;pivot)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p955972150093522"><a name="p955972150093522"></a><a name="p955972150093522"></a>void </p>
<p id="p1809804584093522"><a name="p1809804584093522"></a><a name="p1809804584093522"></a>Scales the rectangle. </p>
</td>
</tr>
<tr id="row487855293093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p11060182093522"><a name="p11060182093522"></a><a name="p11060182093522"></a><a href="graphic.md#ga9bb4f3256ad01b5abdd347de1fea09ee">OHOS::Rotate</a> (const <a href="ohos-vector2-t.md">Vector2</a>&lt; int16_t &gt; &amp;point, int16_t angle, const <a href="ohos-vector2-t.md">Vector2</a>&lt; int16_t &gt; &amp;pivot, <a href="ohos-vector2-t.md">Vector2</a>&lt; int16_t &gt; &amp;out)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1745292836093522"><a name="p1745292836093522"></a><a name="p1745292836093522"></a>void </p>
<p id="p207443404093522"><a name="p207443404093522"></a><a name="p207443404093522"></a>Rotates a point around the pivot by a certain angle. </p>
</td>
</tr>
<tr id="row16978581093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2056308738093522"><a name="p2056308738093522"></a><a name="p2056308738093522"></a><a href="graphic.md#gac57d591450b239f8e375f4c7b287f0d8">OHOS::Rotate</a> (const <a href="ohos-line.md">Line</a> &amp;origLine, int16_t angle, const <a href="ohos-vector2-t.md">Vector2</a>&lt; int16_t &gt; &amp;pivot, <a href="ohos-line.md">Line</a> &amp;out)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1808654552093522"><a name="p1808654552093522"></a><a name="p1808654552093522"></a>void </p>
<p id="p686535938093522"><a name="p686535938093522"></a><a name="p686535938093522"></a>Rotates a line around the pivot by a certain angle. </p>
</td>
</tr>
<tr id="row1634957266093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p272945338093522"><a name="p272945338093522"></a><a name="p272945338093522"></a><a href="graphic.md#ga77d0dea6024cd2bb980f27f789db77c3">OHOS::Rotate</a> (const <a href="ohos-rect.md">Rect</a> &amp;origRect, int16_t angle, const <a href="ohos-vector2-t.md">Vector2</a>&lt; int16_t &gt; &amp;pivot, <a href="ohos-polygon.md">Polygon</a> &amp;out)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1217974814093522"><a name="p1217974814093522"></a><a name="p1217974814093522"></a>void </p>
<p id="p657698618093522"><a name="p657698618093522"></a><a name="p657698618093522"></a>Rotates a rectangle around the pivot by a certain angle. </p>
</td>
</tr>
<tr id="row2131533233093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2045922253093522"><a name="p2045922253093522"></a><a name="p2045922253093522"></a><a href="graphic.md#ga45704f59419f34aa75868387bf74b160">OHOS::GetVersion</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p710907769093522"><a name="p710907769093522"></a><a name="p710907769093522"></a>std::string </p>
<p id="p1453243026093522"><a name="p1453243026093522"></a><a name="p1453243026093522"></a>Obtains the version number of the graphics module. </p>
</td>
</tr>
<tr id="row810292295093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p495459041093522"><a name="p495459041093522"></a><a name="p495459041093522"></a><a href="graphic.md#ga29d7531162c23d230c617280c5c4acf2">OHOS::GetLibDsc</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2105937838093522"><a name="p2105937838093522"></a><a name="p2105937838093522"></a>std::string </p>
<p id="p240231818093522"><a name="p240231818093522"></a><a name="p240231818093522"></a>Obtains the library description of the graphics module. </p>
</td>
</tr>
</tbody>
</table>

## **Details**<a name="section310811387093522"></a>

## **Macro Definition Documentation**<a name="section904863349093522"></a>

## VERSION\_STANDARD<a name="ga2017774de578acba5afd77793c00205b"></a>

```
#define VERSION_STANDARD
```

 **Description:**

Defines three graphics library versions: lightweight, standard, and extended versions. The three versions have different requirements on the memory and hardware. The standard version is enabled by default.

The macros of the versions are defined as follows: 

## **Typedef Documentation**<a name="section1558401805093522"></a>

## EasingFunc<a name="gaf04c41bb7b151a6e8be2012cc9e6475b"></a>

```
typedef int16_t(* OHOS::EasingFunc) (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)
```

 **Description:**

Calculates the value for the current time of an animation. 

Returns the value for the current time. 

**Parameters:**

<a name="table521237973093522"></a>
<table><thead align="left"><tr id="row1405197884093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p854892860093522"><a name="p854892860093522"></a><a name="p854892860093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p620554566093522"><a name="p620554566093522"></a><a name="p620554566093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row372713591093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the start value of this animation. </td>
</tr>
<tr id="row744728365093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the end value of this animation. </td>
</tr>
<tr id="row1725429245093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">curTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the current time of this animation. </td>
</tr>
<tr id="row1406095145093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">durationTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the total duration of this animation.</td>
</tr>
</tbody>
</table>

## **Enumeration Type Documentation**<a name="section2027295942093522"></a>

## anonymous enum<a name="ga7b892afa4e88ab11bf96dbd67653f134"></a>

```
anonymous enum : uint8_t
```

 **Description:**

Enumerates the states of this animator. 

<a name="table423519727093522"></a>
<table><thead align="left"><tr id="row1916535841093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2130867489093522"><a name="p2130867489093522"></a><a name="p2130867489093522"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p588840849093522"><a name="p588840849093522"></a><a name="p588840849093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row632052772093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga7b892afa4e88ab11bf96dbd67653f134a6618a5c1c0e9e4be3acba1aaee15cb8d"><a name="gga7b892afa4e88ab11bf96dbd67653f134a6618a5c1c0e9e4be3acba1aaee15cb8d"></a><a name="gga7b892afa4e88ab11bf96dbd67653f134a6618a5c1c0e9e4be3acba1aaee15cb8d"></a></strong>STOP </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1341642567093522"><a name="p1341642567093522"></a><a name="p1341642567093522"></a>Stop </p>
 </td>
</tr>
<tr id="row1798429914093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga7b892afa4e88ab11bf96dbd67653f134a49f9e652157f467df5de3be9e8758f91"><a name="gga7b892afa4e88ab11bf96dbd67653f134a49f9e652157f467df5de3be9e8758f91"></a><a name="gga7b892afa4e88ab11bf96dbd67653f134a49f9e652157f467df5de3be9e8758f91"></a></strong>START </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1009316740093522"><a name="p1009316740093522"></a><a name="p1009316740093522"></a>Start </p>
 </td>
</tr>
<tr id="row1770811120093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga7b892afa4e88ab11bf96dbd67653f134ae5db6c9a921eec21a2990d73400ff507"><a name="gga7b892afa4e88ab11bf96dbd67653f134ae5db6c9a921eec21a2990d73400ff507"></a><a name="gga7b892afa4e88ab11bf96dbd67653f134ae5db6c9a921eec21a2990d73400ff507"></a></strong>PAUSE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1291890020093522"><a name="p1291890020093522"></a><a name="p1291890020093522"></a>Pause </p>
 </td>
</tr>
<tr id="row294304529093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga7b892afa4e88ab11bf96dbd67653f134a6ef6036766e105b2cd6bf2fb94e92e1b"><a name="gga7b892afa4e88ab11bf96dbd67653f134a6ef6036766e105b2cd6bf2fb94e92e1b"></a><a name="gga7b892afa4e88ab11bf96dbd67653f134a6ef6036766e105b2cd6bf2fb94e92e1b"></a></strong>RUNNING </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p872564567093522"><a name="p872564567093522"></a><a name="p872564567093522"></a>Running (reserved and not used currently) </p>
 </td>
</tr>
</tbody>
</table>

## anonymous enum<a name="ga64b074985084bda79316bd0c1365ae82"></a>

```
anonymous enum
```

 **Description:**

Enumerates opacity values. 

<a name="table735875579093522"></a>
<table><thead align="left"><tr id="row239140364093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2091104023093522"><a name="p2091104023093522"></a><a name="p2091104023093522"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1841968627093522"><a name="p1841968627093522"></a><a name="p1841968627093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1276700902093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga64b074985084bda79316bd0c1365ae82ad4bd10bef3f1df05fd29e023050b9cca"><a name="gga64b074985084bda79316bd0c1365ae82ad4bd10bef3f1df05fd29e023050b9cca"></a><a name="gga64b074985084bda79316bd0c1365ae82ad4bd10bef3f1df05fd29e023050b9cca"></a></strong>OPA_TRANSPARENT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p419193411093522"><a name="p419193411093522"></a><a name="p419193411093522"></a>The opacity is 0. </p>
 </td>
</tr>
<tr id="row1016013093093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga64b074985084bda79316bd0c1365ae82aebcfc69c18e2c29c89f800d95f32754f"><a name="gga64b074985084bda79316bd0c1365ae82aebcfc69c18e2c29c89f800d95f32754f"></a><a name="gga64b074985084bda79316bd0c1365ae82aebcfc69c18e2c29c89f800d95f32754f"></a></strong>OPA_OPAQUE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p947799875093522"><a name="p947799875093522"></a><a name="p947799875093522"></a>The opacity is 100%. </p>
 </td>
</tr>
</tbody>
</table>

## anonymous enum<a name="gaddb0623db8390d25f280888234d3ff2c"></a>

```
anonymous enum : uint8_t
```

 **Description:**

Enumerates keys of styles. 

<a name="table726792334093522"></a>
<table><thead align="left"><tr id="row603047102093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p941517165093522"><a name="p941517165093522"></a><a name="p941517165093522"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p263948806093522"><a name="p263948806093522"></a><a name="p263948806093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row641675311093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaddb0623db8390d25f280888234d3ff2ca81f161546d7e1853d1c273e3810fe08b"><a name="ggaddb0623db8390d25f280888234d3ff2ca81f161546d7e1853d1c273e3810fe08b"></a><a name="ggaddb0623db8390d25f280888234d3ff2ca81f161546d7e1853d1c273e3810fe08b"></a></strong>STYLE_BACKGROUND_COLOR </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1360068491093522"><a name="p1360068491093522"></a><a name="p1360068491093522"></a>Background color </p>
 </td>
</tr>
<tr id="row1056133315093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaddb0623db8390d25f280888234d3ff2ca639cb87312225b97bde6e4d2be950b7f"><a name="ggaddb0623db8390d25f280888234d3ff2ca639cb87312225b97bde6e4d2be950b7f"></a><a name="ggaddb0623db8390d25f280888234d3ff2ca639cb87312225b97bde6e4d2be950b7f"></a></strong>STYLE_BACKGROUND_OPA </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p840354917093522"><a name="p840354917093522"></a><a name="p840354917093522"></a>Background opacity </p>
 </td>
</tr>
<tr id="row1140262413093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaddb0623db8390d25f280888234d3ff2ca4e61810ea3d5f385908eb8a4139027a5"><a name="ggaddb0623db8390d25f280888234d3ff2ca4e61810ea3d5f385908eb8a4139027a5"></a><a name="ggaddb0623db8390d25f280888234d3ff2ca4e61810ea3d5f385908eb8a4139027a5"></a></strong>STYLE_BORDER_RADIUS </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1292987701093522"><a name="p1292987701093522"></a><a name="p1292987701093522"></a>Border radius </p>
 </td>
</tr>
<tr id="row215761097093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaddb0623db8390d25f280888234d3ff2ca8fc5a572665a64ad6d27f70480de3b9a"><a name="ggaddb0623db8390d25f280888234d3ff2ca8fc5a572665a64ad6d27f70480de3b9a"></a><a name="ggaddb0623db8390d25f280888234d3ff2ca8fc5a572665a64ad6d27f70480de3b9a"></a></strong>STYLE_BORDER_COLOR </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p760952674093522"><a name="p760952674093522"></a><a name="p760952674093522"></a>Border color </p>
 </td>
</tr>
<tr id="row604330934093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaddb0623db8390d25f280888234d3ff2ca13df567903c15b369bf612bd97a9b886"><a name="ggaddb0623db8390d25f280888234d3ff2ca13df567903c15b369bf612bd97a9b886"></a><a name="ggaddb0623db8390d25f280888234d3ff2ca13df567903c15b369bf612bd97a9b886"></a></strong>STYLE_BORDER_OPA </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1675998201093522"><a name="p1675998201093522"></a><a name="p1675998201093522"></a>Border opacity </p>
 </td>
</tr>
<tr id="row1810457336093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaddb0623db8390d25f280888234d3ff2cae9bd454f8703c13e8385668b3ac19e41"><a name="ggaddb0623db8390d25f280888234d3ff2cae9bd454f8703c13e8385668b3ac19e41"></a><a name="ggaddb0623db8390d25f280888234d3ff2cae9bd454f8703c13e8385668b3ac19e41"></a></strong>STYLE_BORDER_WIDTH </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1076923341093522"><a name="p1076923341093522"></a><a name="p1076923341093522"></a>Border width </p>
 </td>
</tr>
<tr id="row870612453093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaddb0623db8390d25f280888234d3ff2ca3231d33e8bb12cd0cf6911076c877892"><a name="ggaddb0623db8390d25f280888234d3ff2ca3231d33e8bb12cd0cf6911076c877892"></a><a name="ggaddb0623db8390d25f280888234d3ff2ca3231d33e8bb12cd0cf6911076c877892"></a></strong>STYLE_PADDING_LEFT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1144552897093522"><a name="p1144552897093522"></a><a name="p1144552897093522"></a>Left padding </p>
 </td>
</tr>
<tr id="row2029016560093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaddb0623db8390d25f280888234d3ff2ca8cc34b7c9774ce7dc940b7deeb64de1f"><a name="ggaddb0623db8390d25f280888234d3ff2ca8cc34b7c9774ce7dc940b7deeb64de1f"></a><a name="ggaddb0623db8390d25f280888234d3ff2ca8cc34b7c9774ce7dc940b7deeb64de1f"></a></strong>STYLE_PADDING_RIGHT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p546728550093522"><a name="p546728550093522"></a><a name="p546728550093522"></a>Right padding </p>
 </td>
</tr>
<tr id="row1853006798093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaddb0623db8390d25f280888234d3ff2ca5225ed05b95d4a95a2c48250518c7c7f"><a name="ggaddb0623db8390d25f280888234d3ff2ca5225ed05b95d4a95a2c48250518c7c7f"></a><a name="ggaddb0623db8390d25f280888234d3ff2ca5225ed05b95d4a95a2c48250518c7c7f"></a></strong>STYLE_PADDING_TOP </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1462565580093522"><a name="p1462565580093522"></a><a name="p1462565580093522"></a>Top padding </p>
 </td>
</tr>
<tr id="row1549791481093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaddb0623db8390d25f280888234d3ff2ca65e4dd92a76dc374b487cd24fa37199b"><a name="ggaddb0623db8390d25f280888234d3ff2ca65e4dd92a76dc374b487cd24fa37199b"></a><a name="ggaddb0623db8390d25f280888234d3ff2ca65e4dd92a76dc374b487cd24fa37199b"></a></strong>STYLE_PADDING_BOTTOM </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1134379807093522"><a name="p1134379807093522"></a><a name="p1134379807093522"></a>Bottom padding </p>
 </td>
</tr>
<tr id="row508873048093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaddb0623db8390d25f280888234d3ff2ca251e2a6ea777b9b6af8f6ccf79d060cc"><a name="ggaddb0623db8390d25f280888234d3ff2ca251e2a6ea777b9b6af8f6ccf79d060cc"></a><a name="ggaddb0623db8390d25f280888234d3ff2ca251e2a6ea777b9b6af8f6ccf79d060cc"></a></strong>STYLE_MARGIN_LEFT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1741423823093522"><a name="p1741423823093522"></a><a name="p1741423823093522"></a>Left margin </p>
 </td>
</tr>
<tr id="row495513001093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaddb0623db8390d25f280888234d3ff2ca59ab9a49b6fe3f1fd42a79bf70398c70"><a name="ggaddb0623db8390d25f280888234d3ff2ca59ab9a49b6fe3f1fd42a79bf70398c70"></a><a name="ggaddb0623db8390d25f280888234d3ff2ca59ab9a49b6fe3f1fd42a79bf70398c70"></a></strong>STYLE_MARGIN_RIGHT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p405129766093522"><a name="p405129766093522"></a><a name="p405129766093522"></a>Right margin </p>
 </td>
</tr>
<tr id="row1583149579093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaddb0623db8390d25f280888234d3ff2cad5dbc07ebf86daf81e30fcbf9051c3b6"><a name="ggaddb0623db8390d25f280888234d3ff2cad5dbc07ebf86daf81e30fcbf9051c3b6"></a><a name="ggaddb0623db8390d25f280888234d3ff2cad5dbc07ebf86daf81e30fcbf9051c3b6"></a></strong>STYLE_MARGIN_TOP </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1012621807093522"><a name="p1012621807093522"></a><a name="p1012621807093522"></a>Top margin </p>
 </td>
</tr>
<tr id="row1893762668093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaddb0623db8390d25f280888234d3ff2ca05fa788c60b80429efd0e42fc5d3d4af"><a name="ggaddb0623db8390d25f280888234d3ff2ca05fa788c60b80429efd0e42fc5d3d4af"></a><a name="ggaddb0623db8390d25f280888234d3ff2ca05fa788c60b80429efd0e42fc5d3d4af"></a></strong>STYLE_MARGIN_BOTTOM </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p915107997093522"><a name="p915107997093522"></a><a name="p915107997093522"></a>Bottom margin </p>
 </td>
</tr>
<tr id="row1813474586093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaddb0623db8390d25f280888234d3ff2cae63c7c001e11994f2ec952559c3a0d5f"><a name="ggaddb0623db8390d25f280888234d3ff2cae63c7c001e11994f2ec952559c3a0d5f"></a><a name="ggaddb0623db8390d25f280888234d3ff2cae63c7c001e11994f2ec952559c3a0d5f"></a></strong>STYLE_IMAGE_OPA </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p84654952093522"><a name="p84654952093522"></a><a name="p84654952093522"></a><a href="ohos-image.md">Image</a> opacity </p>
 </td>
</tr>
<tr id="row99060819093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaddb0623db8390d25f280888234d3ff2ca21142f37831ece4dc6fe12a3474029a5"><a name="ggaddb0623db8390d25f280888234d3ff2ca21142f37831ece4dc6fe12a3474029a5"></a><a name="ggaddb0623db8390d25f280888234d3ff2ca21142f37831ece4dc6fe12a3474029a5"></a></strong>STYLE_TEXT_COLOR </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p970814249093522"><a name="p970814249093522"></a><a name="p970814249093522"></a><a href="ohos-text.md">Text</a> color </p>
 </td>
</tr>
<tr id="row517926288093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaddb0623db8390d25f280888234d3ff2ca7288938187d2b5c74d0d1789d73784a3"><a name="ggaddb0623db8390d25f280888234d3ff2ca7288938187d2b5c74d0d1789d73784a3"></a><a name="ggaddb0623db8390d25f280888234d3ff2ca7288938187d2b5c74d0d1789d73784a3"></a></strong>STYLE_TEXT_FONT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1753084030093522"><a name="p1753084030093522"></a><a name="p1753084030093522"></a><a href="ohos-text.md">Text</a> font </p>
 </td>
</tr>
<tr id="row1419248007093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaddb0623db8390d25f280888234d3ff2caf705c0b077d93c8e5ee3cb4583c8ea87"><a name="ggaddb0623db8390d25f280888234d3ff2caf705c0b077d93c8e5ee3cb4583c8ea87"></a><a name="ggaddb0623db8390d25f280888234d3ff2caf705c0b077d93c8e5ee3cb4583c8ea87"></a></strong>STYLE_LETTER_SPACE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1492391005093522"><a name="p1492391005093522"></a><a name="p1492391005093522"></a>Letter spacing </p>
 </td>
</tr>
<tr id="row1786306274093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaddb0623db8390d25f280888234d3ff2ca06ab7c8b467da98902fe19f2b21595ba"><a name="ggaddb0623db8390d25f280888234d3ff2ca06ab7c8b467da98902fe19f2b21595ba"></a><a name="ggaddb0623db8390d25f280888234d3ff2ca06ab7c8b467da98902fe19f2b21595ba"></a></strong>STYLE_LINE_SPACE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1061393399093522"><a name="p1061393399093522"></a><a name="p1061393399093522"></a><a href="ohos-line.md">Line</a> spacing </p>
 </td>
</tr>
<tr id="row31374333093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaddb0623db8390d25f280888234d3ff2ca8889542f8ea0fc454895c6e245d9cfdf"><a name="ggaddb0623db8390d25f280888234d3ff2ca8889542f8ea0fc454895c6e245d9cfdf"></a><a name="ggaddb0623db8390d25f280888234d3ff2ca8889542f8ea0fc454895c6e245d9cfdf"></a></strong>STYLE_TEXT_OPA </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p549374326093522"><a name="p549374326093522"></a><a name="p549374326093522"></a><a href="ohos-text.md">Text</a> opacity </p>
 </td>
</tr>
<tr id="row42859056093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaddb0623db8390d25f280888234d3ff2ca59ce09cf70ef205a7ff081f10d6c1380"><a name="ggaddb0623db8390d25f280888234d3ff2ca59ce09cf70ef205a7ff081f10d6c1380"></a><a name="ggaddb0623db8390d25f280888234d3ff2ca59ce09cf70ef205a7ff081f10d6c1380"></a></strong>STYLE_LINE_COLOR </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2005672729093522"><a name="p2005672729093522"></a><a name="p2005672729093522"></a><a href="ohos-line.md">Line</a> color </p>
 </td>
</tr>
<tr id="row1579265612093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaddb0623db8390d25f280888234d3ff2cadb7984bac1deeffafc3f04169480937e"><a name="ggaddb0623db8390d25f280888234d3ff2cadb7984bac1deeffafc3f04169480937e"></a><a name="ggaddb0623db8390d25f280888234d3ff2cadb7984bac1deeffafc3f04169480937e"></a></strong>STYLE_LINE_WIDTH </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p217005571093522"><a name="p217005571093522"></a><a name="p217005571093522"></a><a href="ohos-line.md">Line</a> width </p>
 </td>
</tr>
<tr id="row1229881251093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaddb0623db8390d25f280888234d3ff2ca7aa7e8dfa8b88cc3ef77c4c3b23a5ea2"><a name="ggaddb0623db8390d25f280888234d3ff2ca7aa7e8dfa8b88cc3ef77c4c3b23a5ea2"></a><a name="ggaddb0623db8390d25f280888234d3ff2ca7aa7e8dfa8b88cc3ef77c4c3b23a5ea2"></a></strong>STYLE_LINE_OPA </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1627849722093522"><a name="p1627849722093522"></a><a name="p1627849722093522"></a><a href="ohos-line.md">Line</a> opacity </p>
 </td>
</tr>
<tr id="row1155239900093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaddb0623db8390d25f280888234d3ff2ca420aa5184ddfd2e95632095c92dfbee5"><a name="ggaddb0623db8390d25f280888234d3ff2ca420aa5184ddfd2e95632095c92dfbee5"></a><a name="ggaddb0623db8390d25f280888234d3ff2ca420aa5184ddfd2e95632095c92dfbee5"></a></strong>STYLE_LINE_CAP </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p527823842093522"><a name="p527823842093522"></a><a name="p527823842093522"></a><a href="ohos-line.md">Line</a> cap style </p>
 </td>
</tr>
</tbody>
</table>

## ButtonImageSrc<a name="gaf9f6c0c373f090e79b9e8d847e186e92"></a>

```
enum [OHOS::UIButton::ButtonImageSrc](graphic.md#gaf9f6c0c373f090e79b9e8d847e186e92) : uint8_t
```

 **Description:**

Enumerates the images for different button states. 

You can define a different image for each button state.

## ButtonState<a name="ga188dd55c17ee44be27fa80543f13f729"></a>

```
enum [OHOS::UIButton::ButtonState](graphic.md#ga188dd55c17ee44be27fa80543f13f729) : uint8_t
```

 **Description:**

Enumerates the states of this button. 

The button has three states.

## CapType<a name="ga2db3928cdf793f4950245a6841dd43d6"></a>

```
enum [OHOS::CapType](graphic.md#ga2db3928cdf793f4950245a6841dd43d6) : uint8_t
```

 **Description:**

Enumerates cap styles. 

<a name="table1400384976093522"></a>
<table><thead align="left"><tr id="row415745286093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1463790726093522"><a name="p1463790726093522"></a><a name="p1463790726093522"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p631116703093522"><a name="p631116703093522"></a><a name="p631116703093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1636063086093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2db3928cdf793f4950245a6841dd43d6a7692381654eff26893e03ac1983c8f45"><a name="gga2db3928cdf793f4950245a6841dd43d6a7692381654eff26893e03ac1983c8f45"></a><a name="gga2db3928cdf793f4950245a6841dd43d6a7692381654eff26893e03ac1983c8f45"></a></strong>CAP_NONE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1328362260093522"><a name="p1328362260093522"></a><a name="p1328362260093522"></a>No cap style </p>
 </td>
</tr>
<tr id="row1286521509093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2db3928cdf793f4950245a6841dd43d6ada0a5a2f0100d929e9e1d1d31ef26cce"><a name="gga2db3928cdf793f4950245a6841dd43d6ada0a5a2f0100d929e9e1d1d31ef26cce"></a><a name="gga2db3928cdf793f4950245a6841dd43d6ada0a5a2f0100d929e9e1d1d31ef26cce"></a></strong>CAP_ROUND </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p129341680093522"><a name="p129341680093522"></a><a name="p129341680093522"></a>Round cap style </p>
 </td>
</tr>
</tbody>
</table>

## ColorMode<a name="ga3a3fb04ed2cda4017e6771c66b692141"></a>

```
enum [OHOS::ColorMode](graphic.md#ga3a3fb04ed2cda4017e6771c66b692141) : uint8_t
```

 **Description:**

colormode of image and font. 

<a name="table1789804783093522"></a>
<table><thead align="left"><tr id="row1081424184093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p746556306093522"><a name="p746556306093522"></a><a name="p746556306093522"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p935941967093522"><a name="p935941967093522"></a><a name="p935941967093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row614686013093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141a2f9573d43aecf2449480f8574b907683"><a name="gga3a3fb04ed2cda4017e6771c66b692141a2f9573d43aecf2449480f8574b907683"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141a2f9573d43aecf2449480f8574b907683"></a></strong>ARGB8888 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1328649101093522"><a name="p1328649101093522"></a><a name="p1328649101093522"></a>ARGB8888 color mode </p>
 </td>
</tr>
<tr id="row1825730096093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141a5a962b82aadba3263c4f0de98262e30e"><a name="gga3a3fb04ed2cda4017e6771c66b692141a5a962b82aadba3263c4f0de98262e30e"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141a5a962b82aadba3263c4f0de98262e30e"></a></strong>RGB888 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1194648095093522"><a name="p1194648095093522"></a><a name="p1194648095093522"></a>RGB888 color mode </p>
 </td>
</tr>
<tr id="row120257206093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141aecb2d8fad7e9b4cfcf53e5490c80651f"><a name="gga3a3fb04ed2cda4017e6771c66b692141aecb2d8fad7e9b4cfcf53e5490c80651f"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141aecb2d8fad7e9b4cfcf53e5490c80651f"></a></strong>RGB565 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p343863831093522"><a name="p343863831093522"></a><a name="p343863831093522"></a>RGB565 color mode </p>
 </td>
</tr>
<tr id="row1775608750093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141add58b331447c6b0e8963fc0f21b78033"><a name="gga3a3fb04ed2cda4017e6771c66b692141add58b331447c6b0e8963fc0f21b78033"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141add58b331447c6b0e8963fc0f21b78033"></a></strong>ARGB1555 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p927593866093522"><a name="p927593866093522"></a><a name="p927593866093522"></a>ARGB1555 color mode </p>
 </td>
</tr>
<tr id="row136863015093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141a21266607b0e5987609d37b52e63f5277"><a name="gga3a3fb04ed2cda4017e6771c66b692141a21266607b0e5987609d37b52e63f5277"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141a21266607b0e5987609d37b52e63f5277"></a></strong>ARGB4444 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1717363991093522"><a name="p1717363991093522"></a><a name="p1717363991093522"></a>ARGB4444 color mode </p>
 </td>
</tr>
<tr id="row914228272093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141a6fbe6b11f436174cc18a931ae9fb85d3"><a name="gga3a3fb04ed2cda4017e6771c66b692141a6fbe6b11f436174cc18a931ae9fb85d3"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141a6fbe6b11f436174cc18a931ae9fb85d3"></a></strong>AL44 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p204040675093522"><a name="p204040675093522"></a><a name="p204040675093522"></a>AL44 color mode </p>
 </td>
</tr>
<tr id="row312012153093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141a7cc06e38b82b0bda251bfc8f0fc953b6"><a name="gga3a3fb04ed2cda4017e6771c66b692141a7cc06e38b82b0bda251bfc8f0fc953b6"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141a7cc06e38b82b0bda251bfc8f0fc953b6"></a></strong>AL88 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1842624761093522"><a name="p1842624761093522"></a><a name="p1842624761093522"></a>AL88 color mode </p>
 </td>
</tr>
<tr id="row1391254191093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141a734f6e329eed35e1fe3f2f6d753665ac"><a name="gga3a3fb04ed2cda4017e6771c66b692141a734f6e329eed35e1fe3f2f6d753665ac"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141a734f6e329eed35e1fe3f2f6d753665ac"></a></strong>L1 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p862768961093522"><a name="p862768961093522"></a><a name="p862768961093522"></a>L1 color mode </p>
 </td>
</tr>
<tr id="row525534199093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141abe9263055f6c06124c0c8b513e1d87df"><a name="gga3a3fb04ed2cda4017e6771c66b692141abe9263055f6c06124c0c8b513e1d87df"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141abe9263055f6c06124c0c8b513e1d87df"></a></strong>L2 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1975866916093522"><a name="p1975866916093522"></a><a name="p1975866916093522"></a>L2 color mode </p>
 </td>
</tr>
<tr id="row1444008346093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141a493a9a5cd759369b982ad7e6ac0de13f"><a name="gga3a3fb04ed2cda4017e6771c66b692141a493a9a5cd759369b982ad7e6ac0de13f"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141a493a9a5cd759369b982ad7e6ac0de13f"></a></strong>L4 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1864181718093522"><a name="p1864181718093522"></a><a name="p1864181718093522"></a>L4 color mode </p>
 </td>
</tr>
<tr id="row1705316789093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141a8417494b1a72ed840b16752f32e7554c"><a name="gga3a3fb04ed2cda4017e6771c66b692141a8417494b1a72ed840b16752f32e7554c"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141a8417494b1a72ed840b16752f32e7554c"></a></strong>L8 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1077676021093522"><a name="p1077676021093522"></a><a name="p1077676021093522"></a>L8 color mode </p>
 </td>
</tr>
<tr id="row899287657093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141a106ce1ddec51f2cb302686252d3c9560"><a name="gga3a3fb04ed2cda4017e6771c66b692141a106ce1ddec51f2cb302686252d3c9560"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141a106ce1ddec51f2cb302686252d3c9560"></a></strong>A1 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1290876543093522"><a name="p1290876543093522"></a><a name="p1290876543093522"></a>A1 color mode </p>
 </td>
</tr>
<tr id="row670831092093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141a365d0df177aa6e1b73fe0cddf72e88c7"><a name="gga3a3fb04ed2cda4017e6771c66b692141a365d0df177aa6e1b73fe0cddf72e88c7"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141a365d0df177aa6e1b73fe0cddf72e88c7"></a></strong>A2 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2017428698093522"><a name="p2017428698093522"></a><a name="p2017428698093522"></a>A2 color mode </p>
 </td>
</tr>
<tr id="row1333812325093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141ae49cb0538532ad895017e6f0d236d9da"><a name="gga3a3fb04ed2cda4017e6771c66b692141ae49cb0538532ad895017e6f0d236d9da"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141ae49cb0538532ad895017e6f0d236d9da"></a></strong>A4 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p35693037093522"><a name="p35693037093522"></a><a name="p35693037093522"></a>A4 color mode </p>
 </td>
</tr>
<tr id="row1514562229093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141a3b6524df7a87ae2800f8ac5b7417d5bc"><a name="gga3a3fb04ed2cda4017e6771c66b692141a3b6524df7a87ae2800f8ac5b7417d5bc"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141a3b6524df7a87ae2800f8ac5b7417d5bc"></a></strong>A8 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p439435295093522"><a name="p439435295093522"></a><a name="p439435295093522"></a>A8 color mode </p>
 </td>
</tr>
<tr id="row1986247617093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141a892afdfffaf015240b16b563599b0244"><a name="gga3a3fb04ed2cda4017e6771c66b692141a892afdfffaf015240b16b563599b0244"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141a892afdfffaf015240b16b563599b0244"></a></strong>UNKNOW </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p655156023093522"><a name="p655156023093522"></a><a name="p655156023093522"></a>unknow color mode </p>
 </td>
</tr>
</tbody>
</table>

## DialogButtonType<a name="ga1bfefa0b46fd5a79a28d0c9a75114295"></a>

```
enum [OHOS::UIDialog::DialogButtonType](graphic.md#ga1bfefa0b46fd5a79a28d0c9a75114295)
```

 **Description:**

Enumerates buttons in a dialog box. 

<a name="table1793992886093522"></a>
<table><thead align="left"><tr id="row462407666093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p173877653093522"><a name="p173877653093522"></a><a name="p173877653093522"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1052920837093522"><a name="p1052920837093522"></a><a name="p1052920837093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row398585807093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga1bfefa0b46fd5a79a28d0c9a75114295a39ef626649e9e14c6561411867e50f00"><a name="gga1bfefa0b46fd5a79a28d0c9a75114295a39ef626649e9e14c6561411867e50f00"></a><a name="gga1bfefa0b46fd5a79a28d0c9a75114295a39ef626649e9e14c6561411867e50f00"></a></strong>BUTTON1 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p258159872093522"><a name="p258159872093522"></a><a name="p258159872093522"></a>First button </p>
 </td>
</tr>
<tr id="row473003859093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga1bfefa0b46fd5a79a28d0c9a75114295a752441e0500e1807164a5f758ed93a8c"><a name="gga1bfefa0b46fd5a79a28d0c9a75114295a752441e0500e1807164a5f758ed93a8c"></a><a name="gga1bfefa0b46fd5a79a28d0c9a75114295a752441e0500e1807164a5f758ed93a8c"></a></strong>BUTTON2 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1780953351093522"><a name="p1780953351093522"></a><a name="p1780953351093522"></a>Second button </p>
 </td>
</tr>
<tr id="row333749346093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga1bfefa0b46fd5a79a28d0c9a75114295a86707c1d7552f48007cc25b77a2db21b"><a name="gga1bfefa0b46fd5a79a28d0c9a75114295a86707c1d7552f48007cc25b77a2db21b"></a><a name="gga1bfefa0b46fd5a79a28d0c9a75114295a86707c1d7552f48007cc25b77a2db21b"></a></strong>BUTTON3 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1264216075093522"><a name="p1264216075093522"></a><a name="p1264216075093522"></a>Third button </p>
 </td>
</tr>
</tbody>
</table>

## Direction<a name="ga4a7a2c192206c8b18379f42a5fd176eb"></a>

```
enum [OHOS::UIBoxProgress::Direction](graphic.md#ga4a7a2c192206c8b18379f42a5fd176eb) : uint8_t
```

 **Description:**

Enumerates the directions of the progress bar. 

<a name="table747082523093522"></a>
<table><thead align="left"><tr id="row1590809003093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p307778400093522"><a name="p307778400093522"></a><a name="p307778400093522"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1205484735093522"><a name="p1205484735093522"></a><a name="p1205484735093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row562955606093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga4a7a2c192206c8b18379f42a5fd176eba43cb7d46f0e18f315d43b82024093b51"><a name="gga4a7a2c192206c8b18379f42a5fd176eba43cb7d46f0e18f315d43b82024093b51"></a><a name="gga4a7a2c192206c8b18379f42a5fd176eba43cb7d46f0e18f315d43b82024093b51"></a></strong>DIR_LEFT_TO_RIGHT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1063721673093522"><a name="p1063721673093522"></a><a name="p1063721673093522"></a>Filling from left to right </p>
 </td>
</tr>
<tr id="row328477783093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga4a7a2c192206c8b18379f42a5fd176eba49e31df5a7fc02ee8c2f85b5e15f0145"><a name="gga4a7a2c192206c8b18379f42a5fd176eba49e31df5a7fc02ee8c2f85b5e15f0145"></a><a name="gga4a7a2c192206c8b18379f42a5fd176eba49e31df5a7fc02ee8c2f85b5e15f0145"></a></strong>DIR_RIGHT_TO_LEFT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p717250276093522"><a name="p717250276093522"></a><a name="p717250276093522"></a>Filling from right to left </p>
 </td>
</tr>
<tr id="row2048251485093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga4a7a2c192206c8b18379f42a5fd176eba68baeaa89ae4576fc3d9ac732f87a116"><a name="gga4a7a2c192206c8b18379f42a5fd176eba68baeaa89ae4576fc3d9ac732f87a116"></a><a name="gga4a7a2c192206c8b18379f42a5fd176eba68baeaa89ae4576fc3d9ac732f87a116"></a></strong>DIR_TOP_TO_BOTTOM </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p91710582093522"><a name="p91710582093522"></a><a name="p91710582093522"></a>Filling from top to bottom </p>
 </td>
</tr>
<tr id="row209025675093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga4a7a2c192206c8b18379f42a5fd176eba78b28982b481790c740bc9b2c1292baa"><a name="gga4a7a2c192206c8b18379f42a5fd176eba78b28982b481790c740bc9b2c1292baa"></a><a name="gga4a7a2c192206c8b18379f42a5fd176eba78b28982b481790c740bc9b2c1292baa"></a></strong>DIR_BOTTOM_TO_TOP </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1249022407093522"><a name="p1249022407093522"></a><a name="p1249022407093522"></a>Filling from bottom to top </p>
 </td>
</tr>
</tbody>
</table>

## DisplayMode<a name="gabe3b64b11e5bf5d7b54e1039e40f306b"></a>

```
enum [OHOS::UIDigitalClock::DisplayMode](graphic.md#gabe3b64b11e5bf5d7b54e1039e40f306b)
```

 **Description:**

Enumerates the display modes of this digital clock. 

<a name="table983099691093522"></a>
<table><thead align="left"><tr id="row880501201093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p378859224093522"><a name="p378859224093522"></a><a name="p378859224093522"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1842262273093522"><a name="p1842262273093522"></a><a name="p1842262273093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1741888314093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggabe3b64b11e5bf5d7b54e1039e40f306bafc93e631e582de9e4128be8e6d41dbfe"><a name="ggabe3b64b11e5bf5d7b54e1039e40f306bafc93e631e582de9e4128be8e6d41dbfe"></a><a name="ggabe3b64b11e5bf5d7b54e1039e40f306bafc93e631e582de9e4128be8e6d41dbfe"></a></strong>DISPLAY_12_HOUR_NO_SECONDS </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1498832938093522"><a name="p1498832938093522"></a><a name="p1498832938093522"></a>12-hour format, without seconds </p>
 </td>
</tr>
<tr id="row1808513026093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggabe3b64b11e5bf5d7b54e1039e40f306ba0c5adc8c80a47a33eb7bfcbcad0b4163"><a name="ggabe3b64b11e5bf5d7b54e1039e40f306ba0c5adc8c80a47a33eb7bfcbcad0b4163"></a><a name="ggabe3b64b11e5bf5d7b54e1039e40f306ba0c5adc8c80a47a33eb7bfcbcad0b4163"></a></strong>DISPLAY_24_HOUR_NO_SECONDS </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1793049802093522"><a name="p1793049802093522"></a><a name="p1793049802093522"></a>24-hour format, without seconds </p>
 </td>
</tr>
<tr id="row1506695278093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggabe3b64b11e5bf5d7b54e1039e40f306baa5cbeab2c7366db7f33b2e95da20615b"><a name="ggabe3b64b11e5bf5d7b54e1039e40f306baa5cbeab2c7366db7f33b2e95da20615b"></a><a name="ggabe3b64b11e5bf5d7b54e1039e40f306baa5cbeab2c7366db7f33b2e95da20615b"></a></strong>DISPLAY_12_HOUR </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p819911966093522"><a name="p819911966093522"></a><a name="p819911966093522"></a>12-hour format </p>
 </td>
</tr>
<tr id="row1213586818093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggabe3b64b11e5bf5d7b54e1039e40f306ba833c0664bba32e6fe4a53a1c471d0eb8"><a name="ggabe3b64b11e5bf5d7b54e1039e40f306ba833c0664bba32e6fe4a53a1c471d0eb8"></a><a name="ggabe3b64b11e5bf5d7b54e1039e40f306ba833c0664bba32e6fe4a53a1c471d0eb8"></a></strong>DISPLAY_24_HOUR </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1044785949093522"><a name="p1044785949093522"></a><a name="p1044785949093522"></a>24-hour format </p>
 </td>
</tr>
</tbody>
</table>

## DrawType<a name="ga0a595eeb50ce4e7dfff9ede16098d2db"></a>

```
enum [OHOS::UIAnalogClock::DrawType](graphic.md#ga0a595eeb50ce4e7dfff9ede16098d2db)
```

 **Description:**

Enumerates the drawing types of a clock hand. 

<a name="table920779777093522"></a>
<table><thead align="left"><tr id="row589586938093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p754647246093522"><a name="p754647246093522"></a><a name="p754647246093522"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p489365826093522"><a name="p489365826093522"></a><a name="p489365826093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row897415827093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga0a595eeb50ce4e7dfff9ede16098d2dba6ddf16010fbdac5db23575583cb8a388"><a name="gga0a595eeb50ce4e7dfff9ede16098d2dba6ddf16010fbdac5db23575583cb8a388"></a><a name="gga0a595eeb50ce4e7dfff9ede16098d2dba6ddf16010fbdac5db23575583cb8a388"></a></strong>DRAW_LINE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2044459252093522"><a name="p2044459252093522"></a><a name="p2044459252093522"></a>Using a line to draw a clock hand </p>
 </td>
</tr>
<tr id="row1983636032093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga0a595eeb50ce4e7dfff9ede16098d2dba5cb6a362b1dec2b19422e9e9a6bbda3c"><a name="gga0a595eeb50ce4e7dfff9ede16098d2dba5cb6a362b1dec2b19422e9e9a6bbda3c"></a><a name="gga0a595eeb50ce4e7dfff9ede16098d2dba5cb6a362b1dec2b19422e9e9a6bbda3c"></a></strong>DRAW_IMAGE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p256931212093522"><a name="p256931212093522"></a><a name="p256931212093522"></a>Using an image to draw a clock hand </p>
 </td>
</tr>
</tbody>
</table>

## FPSCalculateType<a name="ga75d850e3abff6c2f617b689a0cb9a3d1"></a>

```
enum [OHOS::SysInfo::FPSCalculateType](graphic.md#ga75d850e3abff6c2f617b689a0cb9a3d1)
```

 **Description:**

Enumerates the FPS capture types. 

<a name="table1901519653093522"></a>
<table><thead align="left"><tr id="row1891382039093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1918114778093522"><a name="p1918114778093522"></a><a name="p1918114778093522"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1831759657093522"><a name="p1831759657093522"></a><a name="p1831759657093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row65029193093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga75d850e3abff6c2f617b689a0cb9a3d1a26a841fb9a10881591dc79dae38e2d7f"><a name="gga75d850e3abff6c2f617b689a0cb9a3d1a26a841fb9a10881591dc79dae38e2d7f"></a><a name="gga75d850e3abff6c2f617b689a0cb9a3d1a26a841fb9a10881591dc79dae38e2d7f"></a></strong>FPS_CT_FIXED_TIME </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1108498178093522"><a name="p1108498178093522"></a><a name="p1108498178093522"></a>Fixed time sampling: The system collects the number of page refresh times within one second. </p>
 </td>
</tr>
<tr id="row640366357093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga75d850e3abff6c2f617b689a0cb9a3d1a17fdb75ff7e9afb4165349a3d8300f3c"><a name="gga75d850e3abff6c2f617b689a0cb9a3d1a17fdb75ff7e9afb4165349a3d8300f3c"></a><a name="gga75d850e3abff6c2f617b689a0cb9a3d1a17fdb75ff7e9afb4165349a3d8300f3c"></a></strong>FPS_CT_AVERAGE_SAMPLING </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1865916433093522"><a name="p1865916433093522"></a><a name="p1865916433093522"></a>Average sampling: The system collects statistics on the average frame rate of 100 frames. No extra space is required to store the data of each frame. The precision is not as high as that of precise sampling. </p>
 </td>
</tr>
<tr id="row1384199710093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga75d850e3abff6c2f617b689a0cb9a3d1afcc7226b2c9012f2993b7044a80cbed5"><a name="gga75d850e3abff6c2f617b689a0cb9a3d1afcc7226b2c9012f2993b7044a80cbed5"></a><a name="gga75d850e3abff6c2f617b689a0cb9a3d1afcc7226b2c9012f2993b7044a80cbed5"></a></strong>FPS_CT_PRECISE_SAMPLING </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1269022123093522"><a name="p1269022123093522"></a><a name="p1269022123093522"></a>Precise sampling: The system collects statistics on the average frame rate of the current 100 frames. Extra space is required to save the data of each frame. The result is more precise than that of average sampling. </p>
 </td>
</tr>
</tbody>
</table>

## HandType<a name="ga13cf64ea5bd39550976aaf65b1381edf"></a>

```
enum [OHOS::UIAnalogClock::HandType](graphic.md#ga13cf64ea5bd39550976aaf65b1381edf)
```

 **Description:**

Enumerates the clock hand types. 

<a name="table1455220123093522"></a>
<table><thead align="left"><tr id="row446353647093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1952047845093522"><a name="p1952047845093522"></a><a name="p1952047845093522"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p162188461093522"><a name="p162188461093522"></a><a name="p162188461093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1931795563093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga13cf64ea5bd39550976aaf65b1381edfa2b8ab55559dff5a849bf7445f6865958"><a name="gga13cf64ea5bd39550976aaf65b1381edfa2b8ab55559dff5a849bf7445f6865958"></a><a name="gga13cf64ea5bd39550976aaf65b1381edfa2b8ab55559dff5a849bf7445f6865958"></a></strong>HOUR_HAND </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p406555966093522"><a name="p406555966093522"></a><a name="p406555966093522"></a>Hour hand </p>
 </td>
</tr>
<tr id="row1303861025093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga13cf64ea5bd39550976aaf65b1381edfa50ddc7aea61ec54878c173e1423af447"><a name="gga13cf64ea5bd39550976aaf65b1381edfa50ddc7aea61ec54878c173e1423af447"></a><a name="gga13cf64ea5bd39550976aaf65b1381edfa50ddc7aea61ec54878c173e1423af447"></a></strong>MINUTE_HAND </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1838019271093522"><a name="p1838019271093522"></a><a name="p1838019271093522"></a>Minute hand </p>
 </td>
</tr>
<tr id="row359279622093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga13cf64ea5bd39550976aaf65b1381edfa620c615d18fdb1b23ed04df57842909d"><a name="gga13cf64ea5bd39550976aaf65b1381edfa620c615d18fdb1b23ed04df57842909d"></a><a name="gga13cf64ea5bd39550976aaf65b1381edfa620c615d18fdb1b23ed04df57842909d"></a></strong>SECOND_HAND </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p624698527093522"><a name="p624698527093522"></a><a name="p624698527093522"></a>Second hand </p>
 </td>
</tr>
</tbody>
</table>

## LineBreakMode<a name="gaf2ba9acac6cafffc549781ace0475cd5"></a>

```
enum [OHOS::UILabel::LineBreakMode](graphic.md#gaf2ba9acac6cafffc549781ace0475cd5) : uint8_t
```

 **Description:**

Enumerates the display modes of a long text. 

<a name="table1567501201093522"></a>
<table><thead align="left"><tr id="row1933627196093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p740474558093522"><a name="p740474558093522"></a><a name="p740474558093522"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2012209209093522"><a name="p2012209209093522"></a><a name="p2012209209093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1534569896093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaf2ba9acac6cafffc549781ace0475cd5a03a7da624ae08162b5e74ad67e50467f"><a name="ggaf2ba9acac6cafffc549781ace0475cd5a03a7da624ae08162b5e74ad67e50467f"></a><a name="ggaf2ba9acac6cafffc549781ace0475cd5a03a7da624ae08162b5e74ad67e50467f"></a></strong>LINE_BREAK_ADAPT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1171723619093522"><a name="p1171723619093522"></a><a name="p1171723619093522"></a>The label size is adaptive to the text size. </p>
 </td>
</tr>
<tr id="row920611045093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaf2ba9acac6cafffc549781ace0475cd5abc49de1d3936e957882efbb3259dc5be"><a name="ggaf2ba9acac6cafffc549781ace0475cd5abc49de1d3936e957882efbb3259dc5be"></a><a name="ggaf2ba9acac6cafffc549781ace0475cd5abc49de1d3936e957882efbb3259dc5be"></a></strong>LINE_BREAK_STRETCH </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1821376824093522"><a name="p1821376824093522"></a><a name="p1821376824093522"></a>The height of this label remains unchanged, and the width is adaptive to the text size. </p>
 </td>
</tr>
<tr id="row1764677435093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaf2ba9acac6cafffc549781ace0475cd5a2d55ab62d9cead746eb1eaaad1e4e621"><a name="ggaf2ba9acac6cafffc549781ace0475cd5a2d55ab62d9cead746eb1eaaad1e4e621"></a><a name="ggaf2ba9acac6cafffc549781ace0475cd5a2d55ab62d9cead746eb1eaaad1e4e621"></a></strong>LINE_BREAK_WRAP </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1274686002093522"><a name="p1274686002093522"></a><a name="p1274686002093522"></a>The width of this label remains unchanged, and the height is adaptive to the text size. The text switches to the next line if the text exceeds the maximum label width. </p>
 </td>
</tr>
<tr id="row1073419569093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaf2ba9acac6cafffc549781ace0475cd5ac15f8bb00b735e743b621f24a864b0ed"><a name="ggaf2ba9acac6cafffc549781ace0475cd5ac15f8bb00b735e743b621f24a864b0ed"></a><a name="ggaf2ba9acac6cafffc549781ace0475cd5ac15f8bb00b735e743b621f24a864b0ed"></a></strong>LINE_BREAK_ELLIPSIS </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1313277467093522"><a name="p1313277467093522"></a><a name="p1313277467093522"></a>The width and height of this label remain unchanged. If this text is too long, ellipsis will be used at the end. </p>
 </td>
</tr>
<tr id="row890930272093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaf2ba9acac6cafffc549781ace0475cd5a6d3e13d5e53904899020e2c44f6ca82d"><a name="ggaf2ba9acac6cafffc549781ace0475cd5a6d3e13d5e53904899020e2c44f6ca82d"></a><a name="ggaf2ba9acac6cafffc549781ace0475cd5a6d3e13d5e53904899020e2c44f6ca82d"></a></strong>LINE_BREAK_MARQUEE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1723764665093522"><a name="p1723764665093522"></a><a name="p1723764665093522"></a>The width and height of this label remain unchanged. If this text is too long, it will be rolled to display. </p>
 </td>
</tr>
<tr id="row953527529093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaf2ba9acac6cafffc549781ace0475cd5a4111b08e919f919c314556753aa3ff46"><a name="ggaf2ba9acac6cafffc549781ace0475cd5a4111b08e919f919c314556753aa3ff46"></a><a name="ggaf2ba9acac6cafffc549781ace0475cd5a4111b08e919f919c314556753aa3ff46"></a></strong>LINE_BREAK_CLIP </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p117926222093522"><a name="p117926222093522"></a><a name="p117926222093522"></a>The width and height of this label remain unchanged. If this text is too long, it will be cropped to display. </p>
 </td>
</tr>
<tr id="row38647955093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaf2ba9acac6cafffc549781ace0475cd5afb101ae817692c5bada96ba35f9a636d"><a name="ggaf2ba9acac6cafffc549781ace0475cd5afb101ae817692c5bada96ba35f9a636d"></a><a name="ggaf2ba9acac6cafffc549781ace0475cd5afb101ae817692c5bada96ba35f9a636d"></a></strong>LINE_BREAK_MAX </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p298515639093522"><a name="p298515639093522"></a><a name="p298515639093522"></a>Maximum value of the line break mode, which is used for validity check. </p>
 </td>
</tr>
</tbody>
</table>

## PaintStyle<a name="ga548320a469b7862fa416af062cad5d7a"></a>

```
enum [OHOS::Paint::PaintStyle](graphic.md#ga548320a469b7862fa416af062cad5d7a)
```

 **Description:**

Enumerates paint styles of a closed graph. The styles are invalid for non-closed graphs. 

<a name="table1772655670093522"></a>
<table><thead align="left"><tr id="row1001911608093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2124945443093522"><a name="p2124945443093522"></a><a name="p2124945443093522"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1660273200093522"><a name="p1660273200093522"></a><a name="p1660273200093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row153938264093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga548320a469b7862fa416af062cad5d7aa16a9f85a0cca54cb2e20bb58a6a41a41"><a name="gga548320a469b7862fa416af062cad5d7aa16a9f85a0cca54cb2e20bb58a6a41a41"></a><a name="gga548320a469b7862fa416af062cad5d7aa16a9f85a0cca54cb2e20bb58a6a41a41"></a></strong>STROKE_STYLE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1179707876093522"><a name="p1179707876093522"></a><a name="p1179707876093522"></a>Stroke only </p>
 </td>
</tr>
<tr id="row1245474038093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga548320a469b7862fa416af062cad5d7aa706e9d250b4f9ef43008dcd61eb67bb6"><a name="gga548320a469b7862fa416af062cad5d7aa706e9d250b4f9ef43008dcd61eb67bb6"></a><a name="gga548320a469b7862fa416af062cad5d7aa706e9d250b4f9ef43008dcd61eb67bb6"></a></strong>FILL_STYLE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p213463226093522"><a name="p213463226093522"></a><a name="p213463226093522"></a>Fill only </p>
 </td>
</tr>
<tr id="row1469574575093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga548320a469b7862fa416af062cad5d7aa30415cae54bf38e3275e847b5ab3ef1c"><a name="gga548320a469b7862fa416af062cad5d7aa30415cae54bf38e3275e847b5ab3ef1c"></a><a name="gga548320a469b7862fa416af062cad5d7aa30415cae54bf38e3275e847b5ab3ef1c"></a></strong>STROKE_FILL_STYLE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1150725009093522"><a name="p1150725009093522"></a><a name="p1150725009093522"></a>Stroke and fill </p>
 </td>
</tr>
</tbody>
</table>

## TextOrientation<a name="ga0778527bee4a7ddd8d46395585a5cfb9"></a>

```
enum [OHOS::UIArcLabel::TextOrientation](graphic.md#ga0778527bee4a7ddd8d46395585a5cfb9) : uint8_t
```

 **Description:**

Enumerates text orientations. 

<a name="table1353165191093522"></a>
<table><thead align="left"><tr id="row1796958182093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1025211522093522"><a name="p1025211522093522"></a><a name="p1025211522093522"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p67601352093522"><a name="p67601352093522"></a><a name="p67601352093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1907120348093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga0778527bee4a7ddd8d46395585a5cfb9a554a7418c4c0dafd902ebd377b87c80c"><a name="gga0778527bee4a7ddd8d46395585a5cfb9a554a7418c4c0dafd902ebd377b87c80c"></a><a name="gga0778527bee4a7ddd8d46395585a5cfb9a554a7418c4c0dafd902ebd377b87c80c"></a></strong>INSIDE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p364637028093522"><a name="p364637028093522"></a><a name="p364637028093522"></a>Inside </p>
 </td>
</tr>
<tr id="row916928462093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga0778527bee4a7ddd8d46395585a5cfb9a93da25bafef6761717afc6b25c17ea16"><a name="gga0778527bee4a7ddd8d46395585a5cfb9a93da25bafef6761717afc6b25c17ea16"></a><a name="gga0778527bee4a7ddd8d46395585a5cfb9a93da25bafef6761717afc6b25c17ea16"></a></strong>OUTSIDE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1337875751093522"><a name="p1337875751093522"></a><a name="p1337875751093522"></a>Outside </p>
 </td>
</tr>
</tbody>
</table>

## TimeElement<a name="gaa6aacc9ecbf5e20f22e50e542a69f472"></a>

```
enum [OHOS::UIDigitalClock::TimeElement](graphic.md#gaa6aacc9ecbf5e20f22e50e542a69f472)
```

 **Description:**

Enumerates the time elements of this digital clock. 

<a name="table1931578275093522"></a>
<table><thead align="left"><tr id="row1479823744093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1611680359093522"><a name="p1611680359093522"></a><a name="p1611680359093522"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1638459120093522"><a name="p1638459120093522"></a><a name="p1638459120093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1859827701093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa6aacc9ecbf5e20f22e50e542a69f472a8c15c8462a73ec9c9d9d3ad542ba4946"><a name="ggaa6aacc9ecbf5e20f22e50e542a69f472a8c15c8462a73ec9c9d9d3ad542ba4946"></a><a name="ggaa6aacc9ecbf5e20f22e50e542a69f472a8c15c8462a73ec9c9d9d3ad542ba4946"></a></strong>HOUR_ELEMENT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1594225646093522"><a name="p1594225646093522"></a><a name="p1594225646093522"></a>Clock </p>
 </td>
</tr>
<tr id="row1492511819093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa6aacc9ecbf5e20f22e50e542a69f472ae60c24ee0bb6908798a770cb39034de2"><a name="ggaa6aacc9ecbf5e20f22e50e542a69f472ae60c24ee0bb6908798a770cb39034de2"></a><a name="ggaa6aacc9ecbf5e20f22e50e542a69f472ae60c24ee0bb6908798a770cb39034de2"></a></strong>MINUTE_ELEMENT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p71964576093522"><a name="p71964576093522"></a><a name="p71964576093522"></a>Minute </p>
 </td>
</tr>
<tr id="row823384285093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa6aacc9ecbf5e20f22e50e542a69f472a0299da12b65446f25e530d8d20881a1a"><a name="ggaa6aacc9ecbf5e20f22e50e542a69f472a0299da12b65446f25e530d8d20881a1a"></a><a name="ggaa6aacc9ecbf5e20f22e50e542a69f472a0299da12b65446f25e530d8d20881a1a"></a></strong>SECOND_ELEMENT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2107831626093522"><a name="p2107831626093522"></a><a name="p2107831626093522"></a>Second </p>
 </td>
</tr>
</tbody>
</table>

## UICheckBoxState<a name="ga15a3f0302aded0e4d1584ddc6002335d"></a>

```
enum [OHOS::UICheckBox::UICheckBoxState](graphic.md#ga15a3f0302aded0e4d1584ddc6002335d) : uint8_t
```

 **Description:**

Enumerates the states of a check box. 

## UITextLanguageAlignment<a name="ga3f99b58f731a37cacde72d5e0c934593"></a>

```
enum [OHOS::UITextLanguageAlignment](graphic.md#ga3f99b58f731a37cacde72d5e0c934593) : uint8_t
```

 **Description:**

Enumerates text alignment modes. 

<a name="table1833968599093522"></a>
<table><thead align="left"><tr id="row339967627093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1645973207093522"><a name="p1645973207093522"></a><a name="p1645973207093522"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p390295423093522"><a name="p390295423093522"></a><a name="p390295423093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1648587424093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3f99b58f731a37cacde72d5e0c934593a37453e521c390e6157ac2efff1197a43"><a name="gga3f99b58f731a37cacde72d5e0c934593a37453e521c390e6157ac2efff1197a43"></a><a name="gga3f99b58f731a37cacde72d5e0c934593a37453e521c390e6157ac2efff1197a43"></a></strong>TEXT_ALIGNMENT_LEFT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p385031368093522"><a name="p385031368093522"></a><a name="p385031368093522"></a>Left-aligned </p>
 </td>
</tr>
<tr id="row869647165093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3f99b58f731a37cacde72d5e0c934593af6fdcea7d95056a0bab016ba7bee66bd"><a name="gga3f99b58f731a37cacde72d5e0c934593af6fdcea7d95056a0bab016ba7bee66bd"></a><a name="gga3f99b58f731a37cacde72d5e0c934593af6fdcea7d95056a0bab016ba7bee66bd"></a></strong>TEXT_ALIGNMENT_RIGHT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p268683927093522"><a name="p268683927093522"></a><a name="p268683927093522"></a>Right-aligned </p>
 </td>
</tr>
<tr id="row596661193093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3f99b58f731a37cacde72d5e0c934593a1dd445f9b6987a84a7022885ea13c81c"><a name="gga3f99b58f731a37cacde72d5e0c934593a1dd445f9b6987a84a7022885ea13c81c"></a><a name="gga3f99b58f731a37cacde72d5e0c934593a1dd445f9b6987a84a7022885ea13c81c"></a></strong>TEXT_ALIGNMENT_CENTER </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1883035248093522"><a name="p1883035248093522"></a><a name="p1883035248093522"></a>Centered </p>
 </td>
</tr>
<tr id="row457426095093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3f99b58f731a37cacde72d5e0c934593a33dfd4e235bcc2f6f42f4efc8c8264a2"><a name="gga3f99b58f731a37cacde72d5e0c934593a33dfd4e235bcc2f6f42f4efc8c8264a2"></a><a name="gga3f99b58f731a37cacde72d5e0c934593a33dfd4e235bcc2f6f42f4efc8c8264a2"></a></strong>TEXT_ALIGNMENT_TOP </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1786748963093522"><a name="p1786748963093522"></a><a name="p1786748963093522"></a>Top-aligned </p>
 </td>
</tr>
<tr id="row1060188403093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3f99b58f731a37cacde72d5e0c934593aa7798629aa2199c86cb668e94115186c"><a name="gga3f99b58f731a37cacde72d5e0c934593aa7798629aa2199c86cb668e94115186c"></a><a name="gga3f99b58f731a37cacde72d5e0c934593aa7798629aa2199c86cb668e94115186c"></a></strong>TEXT_ALIGNMENT_BOTTOM </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p443027762093522"><a name="p443027762093522"></a><a name="p443027762093522"></a>Bottom-aligned </p>
 </td>
</tr>
</tbody>
</table>

## UITextLanguageDirect<a name="ga0c108f97781843f67c101b47b6c00cf0"></a>

```
enum [OHOS::UITextLanguageDirect](graphic.md#ga0c108f97781843f67c101b47b6c00cf0) : uint8_t
```

 **Description:**

Enumerates text directions. 

<a name="table870988562093522"></a>
<table><thead align="left"><tr id="row1543934911093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p912020897093522"><a name="p912020897093522"></a><a name="p912020897093522"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p862962058093522"><a name="p862962058093522"></a><a name="p862962058093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row272814946093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga0c108f97781843f67c101b47b6c00cf0a387cedfce95a736f28a1c2748086b1a9"><a name="gga0c108f97781843f67c101b47b6c00cf0a387cedfce95a736f28a1c2748086b1a9"></a><a name="gga0c108f97781843f67c101b47b6c00cf0a387cedfce95a736f28a1c2748086b1a9"></a></strong>TEXT_DIRECT_LTR </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1594494864093522"><a name="p1594494864093522"></a><a name="p1594494864093522"></a>Left-to-right </p>
 </td>
</tr>
<tr id="row404965328093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga0c108f97781843f67c101b47b6c00cf0a76658b82f45d4136910ded0c22afe7f8"><a name="gga0c108f97781843f67c101b47b6c00cf0a76658b82f45d4136910ded0c22afe7f8"></a><a name="gga0c108f97781843f67c101b47b6c00cf0a76658b82f45d4136910ded0c22afe7f8"></a></strong>TEXT_DIRECT_RTL </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1081443200093522"><a name="p1081443200093522"></a><a name="p1081443200093522"></a>Right-to-left </p>
 </td>
</tr>
</tbody>
</table>

## WorkMode<a name="ga19db90932bc71e6bbced6ccf2935ac98"></a>

```
enum [OHOS::UIAbstractClock::WorkMode](graphic.md#ga19db90932bc71e6bbced6ccf2935ac98)
```

 **Description:**

Enumerates the working modes of this clock. 

<a name="table1566088764093522"></a>
<table><thead align="left"><tr id="row2047677276093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1967569917093522"><a name="p1967569917093522"></a><a name="p1967569917093522"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1580077599093522"><a name="p1580077599093522"></a><a name="p1580077599093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row666410926093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga19db90932bc71e6bbced6ccf2935ac98a2025ac1a1f63409f0b37f444547ec859"><a name="gga19db90932bc71e6bbced6ccf2935ac98a2025ac1a1f63409f0b37f444547ec859"></a><a name="gga19db90932bc71e6bbced6ccf2935ac98a2025ac1a1f63409f0b37f444547ec859"></a></strong>ALWAYS_ON </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p780573577093522"><a name="p780573577093522"></a><a name="p780573577093522"></a>Always on (drawing not updated) </p>
 </td>
</tr>
<tr id="row1933910496093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga19db90932bc71e6bbced6ccf2935ac98a8d32f103a422c6675618f5e9773b2eaa"><a name="gga19db90932bc71e6bbced6ccf2935ac98a8d32f103a422c6675618f5e9773b2eaa"></a><a name="gga19db90932bc71e6bbced6ccf2935ac98a8d32f103a422c6675618f5e9773b2eaa"></a></strong>NORMAL </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1050225727093522"><a name="p1050225727093522"></a><a name="p1050225727093522"></a>Normal (drawing updated with the time change) </p>
 </td>
</tr>
</tbody>
</table>

## **Function Documentation**<a name="section1451262422093522"></a>

## AbstractAdapter\(\)<a name="gab60e1c77fb98352bd62e56b550d75d88"></a>

```
OHOS::AbstractAdapter::AbstractAdapter ()
```

 **Description:**

A constructor used to create an  **[AbstractAdapter](ohos-abstractadapter.md)**  instance. 

## Add\(\) \[1/3\]<a name="gacf5db120308ac7783c493f5437f06cee"></a>

```
virtual void OHOS::UIViewGroup::Add ([UIView](ohos-uiview.md) * view)
```

 **Description:**

Adds a child view. 

Reimplemented in  [OHOS::UISwipeView](graphic.md#ga1cdc37a33412d6134ed7214300bc1c87).

**Parameters:**

<a name="table1861229645093522"></a>
<table><thead align="left"><tr id="row680941182093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p851099558093522"><a name="p851099558093522"></a><a name="p851099558093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p452622234093522"><a name="p452622234093522"></a><a name="p452622234093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row463117194093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">view</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the child view to add. </td>
</tr>
</tbody>
</table>

## Add\(\) \[2/3\]<a name="ga1cdc37a33412d6134ed7214300bc1c87"></a>

```
void OHOS::UISwipeView::Add ([UIView](ohos-uiview.md) * view)
```

 **Description:**

Adds a view. 

Reimplemented from  [OHOS::UIViewGroup](graphic.md#gacf5db120308ac7783c493f5437f06cee).

**Parameters:**

<a name="table1378990251093522"></a>
<table><thead align="left"><tr id="row1912967080093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p202467028093522"><a name="p202467028093522"></a><a name="p202467028093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p38558682093522"><a name="p38558682093522"></a><a name="p38558682093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1855777055093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">view</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the view to add. </td>
</tr>
</tbody>
</table>

## Add\(\) \[3/3\]<a name="ga8b60ed045dc2a3370498a3e6922d5400"></a>

```
void OHOS::AnimatorManager::Add ([Animator](ohos-animator.md) * animator)
```

 **Description:**

Adds the  **[Animator](ohos-animator.md)**  instance to the  **[AnimatorManager](ohos-animatormanager.md)**  linked list for management, so that the  **Run**  function of the  **[Animator](ohos-animator.md)**  class is called once for each frame. 

**Parameters:**

<a name="table596180936093522"></a>
<table><thead align="left"><tr id="row2108094455093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1663408060093522"><a name="p1663408060093522"></a><a name="p1663408060093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1340415323093522"><a name="p1340415323093522"></a><a name="p1340415323093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1342422142093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">animator</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the <strong id="b67407429093522"><a name="b67407429093522"></a><a name="b67407429093522"></a><a href="ohos-animator.md">Animator</a></strong> instance to add. </td>
</tr>
</tbody>
</table>

**See also:**

[Remove](graphic.md#ga493d53a9e4a47b79d30c0d37f96a69da) 

## AddDataSerial\(\)<a name="gafc510047aac4e7eebd5b229e726ef762"></a>

```
virtual bool OHOS::UIChart::AddDataSerial ([UIChartDataSerial](ohos-uichartdataserial.md) * dataSerial)
```

 **Description:**

Adds a data set. 

**Parameters:**

<a name="table1974235233093522"></a>
<table><thead align="left"><tr id="row437935777093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2045604322093522"><a name="p2045604322093522"></a><a name="p2045604322093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p749768089093522"><a name="p749768089093522"></a><a name="p749768089093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1258469903093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dataSerial</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the data set class. For details, see <a href="ohos-uichartdataserial.md">UIChartDataSerial</a>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the data set is added successfully; returns  **false**  otherwise. 

**See also:**

[DeleteDataSerial](graphic.md#ga2af81fbcd6a17ef250bf07e2d7606b8d) 

## AddPoints\(\)<a name="ga88d554725405cf9c501f145a25448238"></a>

```
bool OHOS::UIChartDataSerial::AddPoints (const [Point](ohos-point.md) * data, uint16_t count )
```

 **Description:**

Adds data points. 

The new data points are appended to the last added data. No more data points can be added if the maximum number is reached 

**Parameters:**

<a name="table1479252421093522"></a>
<table><thead align="left"><tr id="row1412558600093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2014692829093522"><a name="p2014692829093522"></a><a name="p2014692829093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1184756171093522"><a name="p1184756171093522"></a><a name="p1184756171093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1546808404093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">data</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the start address of the data point. </td>
</tr>
<tr id="row107033532093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">count</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of data points to add. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the data points are added successfully; returns  **false**  otherwise. 



## AlignBottomToSibling\(\)<a name="ga7607c3f9661932c495d080e9d92fb1a3"></a>

```
void OHOS::UIView::AlignBottomToSibling (const char * id, int16_t offset = [/topic/body/section/screen/code
     {""}) 0 (code] )
```

 **Description:**

Aligns the view with the bottom of a sibling view. 

**Parameters:**

<a name="table554971059093522"></a>
<table><thead align="left"><tr id="row1722957818093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p257520509093522"><a name="p257520509093522"></a><a name="p257520509093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p796789147093522"><a name="p796789147093522"></a><a name="p796789147093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1228215590093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the ID of the sibling view. </td>
</tr>
<tr id="row909552465093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">offset</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the offset added to the y-axis after the view is placed. A positive number indicates the offset to the top, and a negative number indicates the offset to the bottom. </td>
</tr>
</tbody>
</table>

## AlignHorCenterToSibling\(\)<a name="gac23776dbc2fce7ff30d57438abfa5230"></a>

```
void OHOS::UIView::AlignHorCenterToSibling (const char * id, int16_t offset = [/topic/body/section/screen/code
     {""}) 0 (code] )
```

 **Description:**

Aligns the view with the center of a sibling view in the x-axis. 

**Parameters:**

<a name="table1580428168093522"></a>
<table><thead align="left"><tr id="row2079562000093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1806288304093522"><a name="p1806288304093522"></a><a name="p1806288304093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p300432455093522"><a name="p300432455093522"></a><a name="p300432455093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row840939127093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the ID of the sibling view. </td>
</tr>
<tr id="row1993188217093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">offset</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the offset added to the x-axis after the view is placed. A positive number indicates the offset to the right, and a negative number indicates the offset to the left. </td>
</tr>
</tbody>
</table>

## AlignLeftToSibling\(\)<a name="gac7f5f2584c716a56fee3783f8dea6246"></a>

```
void OHOS::UIView::AlignLeftToSibling (const char * id, int16_t offset = [/topic/body/section/screen/code
     {""}) 0 (code] )
```

 **Description:**

Aligns the view with the left of a sibling view. 

**Parameters:**

<a name="table1839361835093522"></a>
<table><thead align="left"><tr id="row895686642093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p947663081093522"><a name="p947663081093522"></a><a name="p947663081093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p304264393093522"><a name="p304264393093522"></a><a name="p304264393093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1824460400093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the ID of the sibling view. </td>
</tr>
<tr id="row1388141346093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">offset</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the offset added to the x-axis after the view is placed. A positive number indicates the offset to the right, and a negative number indicates the offset to the left. </td>
</tr>
</tbody>
</table>

## AlignRightToSibling\(\)<a name="gabb1ac454cdf95593c1e387d5e272433c"></a>

```
void OHOS::UIView::AlignRightToSibling (const char * id, int16_t offset = [/topic/body/section/screen/code
     {""}) 0 (code] )
```

 **Description:**

Aligns the view with the right of a sibling view. 

**Parameters:**

<a name="table508570247093522"></a>
<table><thead align="left"><tr id="row1194781992093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1704670660093522"><a name="p1704670660093522"></a><a name="p1704670660093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1034273163093522"><a name="p1034273163093522"></a><a name="p1034273163093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row237190920093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the ID of the sibling view. </td>
</tr>
<tr id="row1564672884093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">offset</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the offset added to the x-axis after the view is placed. A positive number indicates the offset to the left, and a negative number indicates the offset to the right. </td>
</tr>
</tbody>
</table>

## AlignTopToSibling\(\)<a name="ga903d7cbc59bac06d728b7f6435c9a504"></a>

```
void OHOS::UIView::AlignTopToSibling (const char * id, int16_t offset = [/topic/body/section/screen/code
     {""}) 0 (code] )
```

 **Description:**

Aligns the view with the top of a sibling view. 

**Parameters:**

<a name="table706051027093522"></a>
<table><thead align="left"><tr id="row1848849630093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p574647136093522"><a name="p574647136093522"></a><a name="p574647136093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2025450618093522"><a name="p2025450618093522"></a><a name="p2025450618093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1011432649093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the ID of the sibling view. </td>
</tr>
<tr id="row682249085093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">offset</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the offset added to the y-axis after the view is placed. A positive number indicates the offset to the bottom, and a negative number indicates the offset to the top. </td>
</tr>
</tbody>
</table>

## AlignVerCenterToSibling\(\)<a name="gad3caa27aa0cb73ec4656e7d23aa222de"></a>

```
void OHOS::UIView::AlignVerCenterToSibling (const char * id, int16_t offset = [/topic/body/section/screen/code
     {""}) 0 (code] )
```

 **Description:**

Aligns the view with the center of a sibling view in the y-axis. 

**Parameters:**

<a name="table1889896039093522"></a>
<table><thead align="left"><tr id="row1204607749093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p647984828093522"><a name="p647984828093522"></a><a name="p647984828093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p759426702093522"><a name="p759426702093522"></a><a name="p759426702093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2126711506093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the ID of the sibling view. </td>
</tr>
<tr id="row1730532965093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">offset</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the offset added to the y-axis after the view is placed. A positive number indicates the offset to the bottom, and a negative number indicates the offset to the top. </td>
</tr>
</tbody>
</table>

## Animator\(\) \[1/2\]<a name="gabcc3afbe99010e70e3e6dbd780cb5974"></a>

```
OHOS::Animator::Animator ()
```

 **Description:**

A default constructor used to create an  **[Animator](ohos-animator.md)**  instance. 

## Animator\(\) \[2/2\]<a name="ga79be500c40ba8743dd58dc633a732b53"></a>

```
OHOS::Animator::Animator ([AnimatorCallback](ohos-animatorcallback.md) * callback, [UIView](ohos-uiview.md) * view, uint32_t time, bool repeat )
```

 **Description:**

A constructor used to create an  **[Animator](ohos-animator.md)**  instance. 

**Parameters:**

<a name="table1672688736093522"></a>
<table><thead align="left"><tr id="row1120032349093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1765712055093522"><a name="p1765712055093522"></a><a name="p1765712055093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p256690500093522"><a name="p256690500093522"></a><a name="p256690500093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1165120364093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">callback</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the animator callback for producing animator effects. For details, see <a href="ohos-animatorcallback.md">AnimatorCallback</a>. </td>
</tr>
<tr id="row1507868079093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">view</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the <strong id="b1370714835093522"><a name="b1370714835093522"></a><a name="b1370714835093522"></a><a href="ohos-uiview.md">UIView</a></strong> instance bound to an animator, which can be used when invoking the animator callback. </td>
</tr>
<tr id="row671982080093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">time</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the duration of this animator, in milliseconds. </td>
</tr>
<tr id="row668770028093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">repeat</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Specifies whether to repeat this animator. <strong id="b898077564093522"><a name="b898077564093522"></a><a name="b898077564093522"></a>true</strong> indicates the animator is repeated, and <strong id="b1079004645093522"><a name="b1079004645093522"></a><a name="b1079004645093522"></a>false</strong> (default value) indicates the animator is played once. </td>
</tr>
</tbody>
</table>

## Aqua\(\)<a name="ga24da6b938c938b3defeb56ff79a4c4f5"></a>

```
static [ColorType](ohos-color32.md) OHOS::Color::Aqua ()
```

 **Description:**

Obtains the color data of aqua. 

**Returns:**

Returns the color data. 



## Back\(\)<a name="gae5c3f6272b58c45f458c475a79ebfe3d"></a>

```
const T [OHOS::List](ohos-list-t.md)< T >::Back () const
```

 **Description:**

Obtains the tail node data of a linked list. 

**Returns:**

Returns the tail node data. 



## BackEaseIn\(\)<a name="ga4598524b16a33de497fa9321d887d3b1"></a>

```
static int16_t OHOS::EasingEquation::BackEaseIn (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime )
```

 **Description:**

Eases in with an overshoot. 

**\(s+1\)\*t^3 - s\*t^2**  is the equation for a back easing. The animation moves back slightly at the beginning and then accelerates towards the end.

**Parameters:**

<a name="table1252029626093522"></a>
<table><thead align="left"><tr id="row1101938647093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p98871934093522"><a name="p98871934093522"></a><a name="p98871934093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p135069081093522"><a name="p135069081093522"></a><a name="p135069081093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row517657150093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the start value of this animation. </td>
</tr>
<tr id="row1578995225093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the end value of this animation. </td>
</tr>
<tr id="row789938942093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">curTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the current time of this animation. </td>
</tr>
<tr id="row3810992093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">durationTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the total duration of this animation.</td>
</tr>
</tbody>
</table>

**Returns:**

Returns the value for the current time. 

**See also:**

[SetBackOvershoot](graphic.md#gab7cf0e64a0d363d8b448262d719ac97a)  |  [BackEaseOut](graphic.md#ga7399f01f7abc33413bf25aa17a99c2f2)  |  [BackEaseInOut](graphic.md#gac7c2a9a1dfce384438a3bd9d6c0c2525) 

## BackEaseInOut\(\)<a name="gac7c2a9a1dfce384438a3bd9d6c0c2525"></a>

```
static int16_t OHOS::EasingEquation::BackEaseInOut (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime )
```

 **Description:**

Eases in and then out with an overshoot. 

**\(s+1\)\*t^3 - s\*t^2**  is the equation for a back easing. The animation slightly moves back at the beginning, goes towards the end, slightly exceeds it and finally comes back.

**Parameters:**

<a name="table205144260093522"></a>
<table><thead align="left"><tr id="row1096263527093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p394111082093522"><a name="p394111082093522"></a><a name="p394111082093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2110177580093522"><a name="p2110177580093522"></a><a name="p2110177580093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2087508372093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the start value of this animation. </td>
</tr>
<tr id="row2020098677093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the end value of this animation. </td>
</tr>
<tr id="row1004602645093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">curTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the current time of this animation. </td>
</tr>
<tr id="row64615302093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">durationTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the total duration of this animation.</td>
</tr>
</tbody>
</table>

**Returns:**

Returns the value for the current time. 

**See also:**

[SetBackOvershoot](graphic.md#gab7cf0e64a0d363d8b448262d719ac97a)  |  [BackEaseIn](graphic.md#ga4598524b16a33de497fa9321d887d3b1)  |  [BackEaseOut](graphic.md#ga7399f01f7abc33413bf25aa17a99c2f2) 

## BackEaseOut\(\)<a name="ga7399f01f7abc33413bf25aa17a99c2f2"></a>

```
static int16_t OHOS::EasingEquation::BackEaseOut (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime )
```

 **Description:**

Eases out with an overshoot. 

**\(s+1\)\*t^3 - s\*t^2**  is the equation for a back easing. The animation moves towards the end, slightly exceeds it and finally comes back.

**Parameters:**

<a name="table399968035093522"></a>
<table><thead align="left"><tr id="row1137430916093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p110536996093522"><a name="p110536996093522"></a><a name="p110536996093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1369134087093522"><a name="p1369134087093522"></a><a name="p1369134087093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row716205886093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the start value of this animation. </td>
</tr>
<tr id="row1389481930093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the end value of this animation. </td>
</tr>
<tr id="row82668401093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">curTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the current time of this animation. </td>
</tr>
<tr id="row1119717174093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">durationTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the total duration of this animation.</td>
</tr>
</tbody>
</table>

**Returns:**

Returns the value for the current time. 

**See also:**

[SetBackOvershoot](graphic.md#gab7cf0e64a0d363d8b448262d719ac97a)  |  [BackEaseIn](graphic.md#ga4598524b16a33de497fa9321d887d3b1)  |  [BackEaseInOut](graphic.md#gac7c2a9a1dfce384438a3bd9d6c0c2525) 

## Begin\(\)<a name="ga8fe8647f764773c29d3fa70c9b70eb2a"></a>

```
[ListNode](ohos-listnode-t.md)<T>* [OHOS::List](ohos-list-t.md)< T >::Begin () const
```

 **Description:**

Obtains the head node address of a linked list. 

**Returns:**

Returns the head node address. 



## Black\(\)<a name="gac821c879969c94ec048117738e4bbef2"></a>

```
static [ColorType](ohos-color32.md) OHOS::Color::Black ()
```

 **Description:**

Obtains the color data of black. 

**Returns:**

Returns the color data. 



## Blue\(\)<a name="ga3b02160a068039d3801580c8e35008b4"></a>

```
static [ColorType](ohos-color32.md) OHOS::Color::Blue ()
```

 **Description:**

Obtains the color data of blue. 

**Returns:**

Returns the color data. 



## Callback\(\)<a name="gace3debcfa4200de1951a8eae6421e5aa"></a>

```
virtual void OHOS::AnimatorCallback::Callback ([UIView](ohos-uiview.md) * view)
```

 **Description:**

Called when each frame starts. This is a pure virtual function, which needs your inheritance and implementation. 

**Parameters:**

<a name="table1135136646093522"></a>
<table><thead align="left"><tr id="row1100891040093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1268899846093522"><a name="p1268899846093522"></a><a name="p1268899846093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1484030290093522"><a name="p1484030290093522"></a><a name="p1484030290093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row691972975093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">view</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the <strong id="b1548954506093522"><a name="b1548954506093522"></a><a name="b1548954506093522"></a><a href="ohos-uiview.md">UIView</a></strong> instance, which is added from the constructor of the <strong id="b1533706329093522"><a name="b1533706329093522"></a><a name="b1533706329093522"></a><a href="ohos-animator.md">Animator</a></strong> class. </td>
</tr>
</tbody>
</table>

## Cancel\(\)<a name="gac838ad321786766c6d4020504b07b93b"></a>

```
void OHOS::UITextureMapper::Cancel ()
```

 **Description:**

Cancels this animator. 

After being cancelled, the animator will stop in the current playback state.

## CancelEvent\(\)<a name="gaf3b75ee84a33ffcbc640328b2747b0a1"></a>

```
OHOS::CancelEvent::CancelEvent (const [Point](ohos-point.md) & pos)
```

 **Description:**

A constructor used to create a  **[CancelEvent](ohos-cancelevent.md)**  instance. 

**Parameters:**

<a name="table1354993867093522"></a>
<table><thead align="left"><tr id="row1306635401093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1595476947093522"><a name="p1595476947093522"></a><a name="p1595476947093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p740877984093522"><a name="p740877984093522"></a><a name="p740877984093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1353833174093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">pos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the position where the cancel event occurs. </td>
</tr>
</tbody>
</table>

## CircEaseIn\(\)<a name="ga446c958f14b3d6de24e2c1bab171bba2"></a>

```
static int16_t OHOS::EasingEquation::CircEaseIn (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime )
```

 **Description:**

Eases in shaping like a circular curve. 

**sqrt\(1-t^2\)**  is the equation for a circular easing. The animation starts slowly from zero velocity and accelerates fast towards the end. The acceleration change is similar to a circular curve.

**Parameters:**

<a name="table1208017485093522"></a>
<table><thead align="left"><tr id="row574917976093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2107868167093522"><a name="p2107868167093522"></a><a name="p2107868167093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2138121773093522"><a name="p2138121773093522"></a><a name="p2138121773093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1533572182093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the start value of this animation. </td>
</tr>
<tr id="row18514208093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the end value of this animation. </td>
</tr>
<tr id="row632555407093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">curTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the current time of this animation. </td>
</tr>
<tr id="row84275983093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">durationTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the total duration of this animation.</td>
</tr>
</tbody>
</table>

**Returns:**

Returns the value for the current time. 

**See also:**

[CircEaseOut](graphic.md#gaab8fad8664d648df7e5e224b68ee54ad)  |  [CircEaseInOut](graphic.md#ga68c392dad14e1bef192b085aeec6ca9b) 

## CircEaseInOut\(\)<a name="ga68c392dad14e1bef192b085aeec6ca9b"></a>

```
static int16_t OHOS::EasingEquation::CircEaseInOut (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime )
```

 **Description:**

Eases in and then out shaping like a circular curve. 

**sqrt\(1-t^2\)**  is the equation for a circular easing. The animation accelerates slowly until halfway and decreases slowly towards the end. The acceleration change is similar to a circular curve.

**Parameters:**

<a name="table165303854093522"></a>
<table><thead align="left"><tr id="row1937584129093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2112340434093522"><a name="p2112340434093522"></a><a name="p2112340434093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p759427692093522"><a name="p759427692093522"></a><a name="p759427692093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1253153484093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the start value of this animation. </td>
</tr>
<tr id="row272172932093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the end value of this animation. </td>
</tr>
<tr id="row561633391093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">curTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the current time of this animation. </td>
</tr>
<tr id="row818149705093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">durationTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the total duration of this animation.</td>
</tr>
</tbody>
</table>

**Returns:**

Returns the value for the current time. 

**See also:**

[CircEaseIn](graphic.md#ga446c958f14b3d6de24e2c1bab171bba2)  |  [CircEaseOut](graphic.md#gaab8fad8664d648df7e5e224b68ee54ad) 

## CircEaseOut\(\)<a name="gaab8fad8664d648df7e5e224b68ee54ad"></a>

```
static int16_t OHOS::EasingEquation::CircEaseOut (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime )
```

 **Description:**

Eases out shaping like a circular curve. 

**sqrt\(1-t^2\)**  is the equation for a circular easing. The animation starts fast and decelerates slowly towards the end. The acceleration change is similar to a circular curve.

**Parameters:**

<a name="table696605811093522"></a>
<table><thead align="left"><tr id="row1473185311093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2133640101093522"><a name="p2133640101093522"></a><a name="p2133640101093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2116655747093522"><a name="p2116655747093522"></a><a name="p2116655747093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1209186855093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the start value of this animation. </td>
</tr>
<tr id="row775393547093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the end value of this animation. </td>
</tr>
<tr id="row1698986450093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">curTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the current time of this animation. </td>
</tr>
<tr id="row263217075093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">durationTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the total duration of this animation.</td>
</tr>
</tbody>
</table>

**Returns:**

Returns the value for the current time. 

**See also:**

[CircEaseIn](graphic.md#ga446c958f14b3d6de24e2c1bab171bba2)  |  [CircEaseInOut](graphic.md#ga68c392dad14e1bef192b085aeec6ca9b) 

## Clear\(\) \[1/2\]<a name="ga2292866786c9f888bc722ffcebc7c831"></a>

```
void [OHOS::List](ohos-list-t.md)< T >::Clear ()
```

 **Description:**

Deletes all nodes from a linked list. 

## Clear\(\) \[2/2\]<a name="ga7e20822a6c448bee724f20afad1c69d4"></a>

```
void OHOS::UICanvas::Clear ()
```

 **Description:**

Clears the entire canvas. 

## ClearData\(\)<a name="ga148d9b3933a733433a96a48b95cff844"></a>

```
void OHOS::UIChartDataSerial::ClearData ()
```

 **Description:**

Clears all data points. 

## ClearDataSerial\(\)<a name="gae2752857fbcb9f1541cd811321bfc2c6"></a>

```
virtual void OHOS::UIChart::ClearDataSerial ()
```

 **Description:**

Clears all data sets. 

## ClearOnKeyActListener\(\)<a name="ga00303597af333088c06a45346f4a77f2"></a>

```
void OHOS::RootView::ClearOnKeyActListener ()
```

 **Description:**

Clears the listener for monitoring physical key events. 

## ClearOnVirtualDeviceEventListener\(\)<a name="ga0b550a305c0cda1dc510b2446c56ed82"></a>

```
void OHOS::RootView::ClearOnVirtualDeviceEventListener ()
```

 **Description:**

Clears the listener for monitoring the input events of a virtual device. 

## ClearValues\(\)<a name="ga81e69c460191bbe3606ac540433178a1"></a>

```
virtual void OHOS::UIPicker::ClearValues ()
```

 **Description:**

Clears all values in the picker. 

## ClickEvent\(\)<a name="gaeb51d39715cc72b383ba6059bd0d1053"></a>

```
OHOS::ClickEvent::ClickEvent (const [Point](ohos-point.md) & pos)
```

 **Description:**

A constructor used to create a  **[ClickEvent](ohos-clickevent.md)**  instance. 

**Parameters:**

<a name="table538311455093522"></a>
<table><thead align="left"><tr id="row1046743689093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p29274011093522"><a name="p29274011093522"></a><a name="p29274011093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p573904600093522"><a name="p573904600093522"></a><a name="p573904600093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1000233418093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">pos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the position where the click event occurs. </td>
</tr>
</tbody>
</table>

## Clip\(\) \[1/2\]<a name="ga0001387a136a87fb2c2e2b5eb3363c72"></a>

```
void OHOS::Clip ([Polygon](ohos-polygon.md) & poly, const [Line](ohos-line.md) & line )
```

 **Description:**

Clips a polygon by using a line segment. 

**Parameters:**

<a name="table58923559093522"></a>
<table><thead align="left"><tr id="row108350097093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2052177112093522"><a name="p2052177112093522"></a><a name="p2052177112093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p486617776093522"><a name="p486617776093522"></a><a name="p486617776093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row693099705093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">poly</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the polygon to clip. </td>
</tr>
<tr id="row1843148114093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">line</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the line segment used for clipping. </td>
</tr>
</tbody>
</table>

## Clip\(\) \[2/2\]<a name="ga22219a4351530d5a6914bdc5dcf406d0"></a>

```
void OHOS::Clip (const [Line](ohos-line.md) & line, const [Polygon](ohos-polygon.md) & poly, [Vector2](ohos-vector2-t.md)< int16_t > * pOut, uint8_t * pNum )
```

 **Description:**

Clips a polygon by using a line segment and obtains the intersections. 

**Parameters:**

<a name="table1605571418093522"></a>
<table><thead align="left"><tr id="row1751324212093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p393026027093522"><a name="p393026027093522"></a><a name="p393026027093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1305821156093522"><a name="p1305821156093522"></a><a name="p1305821156093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1365433357093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">line</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the line segment used for clipping. </td>
</tr>
<tr id="row384221665093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">poly</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the polygon to clip. </td>
</tr>
<tr id="row403234879093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">pOut</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the intersections. </td>
</tr>
<tr id="row92863471093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">pNum</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the number of the intersections. </td>
</tr>
</tbody>
</table>

## ColorTo16\(\)<a name="ga2a6a0bd067a05ee35793fefc8f9f4d1e"></a>

```
static uint16_t OHOS::Color::ColorTo16 ([Color32](ohos-color32.md) color)
```

 **Description:**

Converts color data from the RGBA8888 format into the RGB565 format. 

**Parameters:**

<a name="table732947506093522"></a>
<table><thead align="left"><tr id="row179336986093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p661180449093522"><a name="p661180449093522"></a><a name="p661180449093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1675872133093522"><a name="p1675872133093522"></a><a name="p1675872133093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row101909970093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">color</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the color data with the 32-bit color depth, which is defined by <a href="ohos-color32.md">Color32</a>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the RGB565 color data. 



## ColorTo32\(\) \[1/2\]<a name="ga461b46dd76842ad4b0ffdc88202223a7"></a>

```
static uint32_t OHOS::Color::ColorTo32 ([ColorType](ohos-color32.md) color)
```

 **Description:**

Converts color data into the RGBA8888 format. 

The color data definition varies according to the color depth.

**Parameters:**

<a name="table219080946093522"></a>
<table><thead align="left"><tr id="row1307423167093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1583907682093522"><a name="p1583907682093522"></a><a name="p1583907682093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1042801762093522"><a name="p1042801762093522"></a><a name="p1042801762093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row98557126093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">color</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the color data, which is defined by <strong id="b1832897390093522"><a name="b1832897390093522"></a><a name="b1832897390093522"></a>ColorType</strong>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the RGBA8888 color data. 



## ColorTo32\(\) \[2/2\]<a name="gaaca42d51bc5f28d5dbd5b1635be50224"></a>

```
static uint32_t OHOS::Color::ColorTo32 ([Color16](ohos-color16.md) color, uint8_t alpha )
```

 **Description:**

Converts color data with the 16-bit color depth into the RGBA8888 format. 

**Parameters:**

<a name="table1189776475093522"></a>
<table><thead align="left"><tr id="row1767049369093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1281582976093522"><a name="p1281582976093522"></a><a name="p1281582976093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1615407309093522"><a name="p1615407309093522"></a><a name="p1615407309093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1893682758093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">color</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the color data with the 16-bit color depth, which is defined by <a href="ohos-color16.md">Color16</a>. </td>
</tr>
<tr id="row2042554056093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">alpha</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the alpha, that is, how opaque each pixel is. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the RGBA8888 color data. 



## Cross\(\)<a name="gac1c8e01fd488d5f8aea6bddad1dec206"></a>

```
T [OHOS::Vector2](ohos-vector2-t.md)< T >::Cross (const [Vector2](ohos-vector2-t.md)< T > & other) const
```

 **Description:**

Calculates the cross product of the two-dimensional vector and another two-dimensional vector. 

**Parameters:**

<a name="table1690475711093522"></a>
<table><thead align="left"><tr id="row1033886280093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1580839273093522"><a name="p1580839273093522"></a><a name="p1580839273093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p598556255093522"><a name="p598556255093522"></a><a name="p598556255093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row93910241093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">other</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the two-dimensional vector to be used for calculation. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the cross product. 



## CubicEaseIn\(\)<a name="ga5c91a83cc424fb7e4e1f40cae6b3be66"></a>

```
static int16_t OHOS::EasingEquation::CubicEaseIn (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime )
```

 **Description:**

Eases in shaping like a cubic curve. 

**t^3**  is the equation for a cubic easing. The animation starts slowly from zero velocity and accelerates fast towards the end. The acceleration change is similar to a cubic curve.

**Parameters:**

<a name="table1799856488093522"></a>
<table><thead align="left"><tr id="row1882821760093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p653704585093522"><a name="p653704585093522"></a><a name="p653704585093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1064306718093522"><a name="p1064306718093522"></a><a name="p1064306718093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row412161343093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the start value of this animation. </td>
</tr>
<tr id="row1497379873093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the end value of this animation. </td>
</tr>
<tr id="row1845803392093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">curTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the current time of this animation. </td>
</tr>
<tr id="row1435277315093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">durationTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the total duration of this animation.</td>
</tr>
</tbody>
</table>

**Returns:**

Returns the value for the current time. 

**See also:**

[CubicEaseOut](graphic.md#ga529a948d9f6711a5f2726af5f10d7a48)  |  [CubicEaseInOut](graphic.md#gad99ea4ed828f274f111f492eea123cb4) 

## CubicEaseInOut\(\)<a name="gad99ea4ed828f274f111f492eea123cb4"></a>

```
static int16_t OHOS::EasingEquation::CubicEaseInOut (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime )
```

 **Description:**

Eases in and then out shaping like a cubic curve. 

**t^3**  is the equation for a cubic easing. The animation accelerates slowly until halfway and decelerates slowly towards the end. The acceleration change is similar to a cubic curve.

**Parameters:**

<a name="table1513419513093522"></a>
<table><thead align="left"><tr id="row336537801093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p856683200093522"><a name="p856683200093522"></a><a name="p856683200093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p474531654093522"><a name="p474531654093522"></a><a name="p474531654093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row481790325093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the start value of this animation. </td>
</tr>
<tr id="row759717718093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the end value of this animation. </td>
</tr>
<tr id="row377484737093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">curTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the current time of this animation. </td>
</tr>
<tr id="row1313577424093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">durationTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the total duration of this animation.</td>
</tr>
</tbody>
</table>

**Returns:**

Returns the value for the current time. 

**See also:**

[CubicEaseIn](graphic.md#ga5c91a83cc424fb7e4e1f40cae6b3be66)  |  [CubicEaseOut](graphic.md#ga529a948d9f6711a5f2726af5f10d7a48) 

## CubicEaseOut\(\)<a name="ga529a948d9f6711a5f2726af5f10d7a48"></a>

```
static int16_t OHOS::EasingEquation::CubicEaseOut (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime )
```

 **Description:**

Eases out shaping like a cubic curve. 

**t^3**  is the equation for a cubic easing. The animation starts fast and decelerates slowly towards the end. The acceleration change is similar to a cubic curve.

**Parameters:**

<a name="table1697382220093522"></a>
<table><thead align="left"><tr id="row1748324075093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1227998889093522"><a name="p1227998889093522"></a><a name="p1227998889093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p21863435093522"><a name="p21863435093522"></a><a name="p21863435093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row107087821093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the start value of this animation. </td>
</tr>
<tr id="row252529401093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the end value of this animation. </td>
</tr>
<tr id="row787783689093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">curTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the current time of this animation. </td>
</tr>
<tr id="row9421219093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">durationTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the total duration of this animation.</td>
</tr>
</tbody>
</table>

**Returns:**

Returns the value for the current time. 

**See also:**

[CubicEaseIn](graphic.md#ga5c91a83cc424fb7e4e1f40cae6b3be66)  |  [CubicEaseInOut](graphic.md#gad99ea4ed828f274f111f492eea123cb4) 

## Cyan\(\)<a name="ga9d6b730a0799da3254543613acb0a3fa"></a>

```
static [ColorType](ohos-color32.md) OHOS::Color::Cyan ()
```

 **Description:**

Obtains the color data of cyan. 

**Returns:**

Returns the color data. 



## DeleteDataSerial\(\)<a name="ga2af81fbcd6a17ef250bf07e2d7606b8d"></a>

```
virtual bool OHOS::UIChart::DeleteDataSerial ([UIChartDataSerial](ohos-uichartdataserial.md) * dataSerial)
```

 **Description:**

Deletes a data set. 

**Parameters:**

<a name="table851308377093522"></a>
<table><thead align="left"><tr id="row642087702093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p966386389093522"><a name="p966386389093522"></a><a name="p966386389093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1773928179093522"><a name="p1773928179093522"></a><a name="p1773928179093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row273941826093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dataSerial</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the data set class. For details, see <a href="ohos-uichartdataserial.md">UIChartDataSerial</a>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the data set is deleted successfully; returns  **false**  otherwise. 

**See also:**

[AddDataSerial](graphic.md#gafc510047aac4e7eebd5b229e726ef762) 

## Determinant\(\)<a name="ga5464ffd57d0abbd0381b2a6cf3a7d2fb"></a>

```
T [OHOS::Matrix3](ohos-matrix3-t.md)< T >::Determinant () const
```

 **Description:**

Obtains the determinant of the matrix. 

**Returns:**

Returns the determinant. 



## Disable\(\)<a name="ga283131701e907e586964189818d04411"></a>

```
void OHOS::UIButton::Disable ()
```

 **Description:**

Disables this button. 

## DisplayLeadingZero\(\)<a name="gaf45e9196d307551e693807cae2f8b4d2"></a>

```
void OHOS::UIDigitalClock::DisplayLeadingZero (bool displayLeadingZero)
```

 **Description:**

Sets whether to add  **0**  before the hour of this digital clock. 

**Parameters:**

<a name="table2043104192093522"></a>
<table><thead align="left"><tr id="row654644039093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p187860668093522"><a name="p187860668093522"></a><a name="p187860668093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1004353891093522"><a name="p1004353891093522"></a><a name="p1004353891093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row772501406093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">displayLeadingZero</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Specifies whether to add <strong id="b1649171370093522"><a name="b1649171370093522"></a><a name="b1649171370093522"></a>0</strong> before the hour of this digital clock. <strong id="b588560317093522"><a name="b588560317093522"></a><a name="b588560317093522"></a>true</strong> indicates that <strong id="b982228649093522"><a name="b982228649093522"></a><a name="b982228649093522"></a>0</strong> is added, and <strong id="b1299679779093522"><a name="b1299679779093522"></a><a name="b1299679779093522"></a>false</strong> indicates the opposite case. </td>
</tr>
</tbody>
</table>

## Dot\(\)<a name="gae45c198b5bcb73ecac8d654c281bc21a"></a>

```
T [OHOS::Vector2](ohos-vector2-t.md)< T >::Dot (const [Vector2](ohos-vector2-t.md)< T > & other) const
```

 **Description:**

Calculates the scalar product of the two-dimensional vector and another two-dimensional vector. 

**Parameters:**

<a name="table1803475246093522"></a>
<table><thead align="left"><tr id="row458173514093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p406804762093522"><a name="p406804762093522"></a><a name="p406804762093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p545847753093522"><a name="p545847753093522"></a><a name="p545847753093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1522457390093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">other</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the two-dimensional vector to be used for calculation. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the scalar product. 



## DragEvent\(\)<a name="gae9af79f667fc1324739d2a07fdd5d94e"></a>

```
OHOS::DragEvent::DragEvent (const [Point](ohos-point.md) & newPos, const [Point](ohos-point.md) & lastPos, const [Point](ohos-point.md) & totalLen )
```

 **Description:**

A constructor used to create a  **[DragEvent](ohos-dragevent.md)**  instance. 

**Parameters:**

<a name="table2091637044093522"></a>
<table><thead align="left"><tr id="row1935211418093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p621629499093522"><a name="p621629499093522"></a><a name="p621629499093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p133157664093522"><a name="p133157664093522"></a><a name="p133157664093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2043980673093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">newPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the new position in the drag event. </td>
</tr>
<tr id="row1733712073093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">lastPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the last position in the drag event. </td>
</tr>
<tr id="row376062216093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">totalLen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the distance that the view has been dragged, including the movement on the x-axis and y-axis. </td>
</tr>
</tbody>
</table>

## DrawArc\(\)<a name="ga620028da5c71f96416becc877331ba6c"></a>

```
void OHOS::UICanvas::DrawArc (const [Point](ohos-point.md) & center, uint16_t radius, int16_t startAngle, int16_t endAngle, const [Paint](ohos-paint.md) & paint )
```

 **Description:**

Draws an arc. 

Only stroke is supported. When the start angle is smaller than the end angle, the sector is drawn clockwise. Otherwise, the sector is drawn counterclockwise. 

**Parameters:**

<a name="table1608957398093522"></a>
<table><thead align="left"><tr id="row1239639631093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1332170601093522"><a name="p1332170601093522"></a><a name="p1332170601093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1371608686093522"><a name="p1371608686093522"></a><a name="p1371608686093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1752160966093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">center</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the coordinates of the arc's center. </td>
</tr>
<tr id="row1514526740093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">radius</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the radius of the arc. </td>
</tr>
<tr id="row372653267093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startAngle</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the start angle of the arc. Value <strong id="b741830231093522"><a name="b741830231093522"></a><a name="b741830231093522"></a>0</strong> indicates the 12-o'clock direction, and <strong id="b242331312093522"><a name="b242331312093522"></a><a name="b242331312093522"></a>90</strong> indicates the 3-o'clock direction. </td>
</tr>
<tr id="row85531262093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endAngle</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the end angle of the arc. Value <strong id="b1794953017093522"><a name="b1794953017093522"></a><a name="b1794953017093522"></a>0</strong> indicates the 12-o'clock direction, and <strong id="b1297593955093522"><a name="b1297593955093522"></a><a name="b1297593955093522"></a>90</strong> indicates the 3-o'clock direction. </td>
</tr>
<tr id="row1011051703093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">paint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the arc style. For details, see <a href="ohos-paint.md">Paint</a>. </td>
</tr>
</tbody>
</table>

## DrawCircle\(\)<a name="ga974544e34560d0f9d6e162c528fcd7af"></a>

```
void OHOS::UICanvas::DrawCircle (const [Point](ohos-point.md) & center, uint16_t radius, const [Paint](ohos-paint.md) & paint )
```

 **Description:**

Draws a circle. 

**Parameters:**

<a name="table170225445093522"></a>
<table><thead align="left"><tr id="row250932851093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1019364096093522"><a name="p1019364096093522"></a><a name="p1019364096093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p122289906093522"><a name="p122289906093522"></a><a name="p122289906093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2004850296093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">center</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the coordinates of the circle center. </td>
</tr>
<tr id="row383287186093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">radius</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the radius of the circle. </td>
</tr>
<tr id="row1917861087093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">paint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the circle style. For details, see <a href="ohos-paint.md">Paint</a>. </td>
</tr>
</tbody>
</table>

## DrawCurve\(\) \[1/2\]<a name="gab6557ddb74b721e4eba6cdabab954a3b"></a>

```
void OHOS::UICanvas::DrawCurve (const [Point](ohos-point.md) & control1, const [Point](ohos-point.md) & control2, const [Point](ohos-point.md) & endPoint, const [Paint](ohos-paint.md) & paint )
```

 **Description:**

Draws a cubic Bezier curve. 

If  [SetStartPosition](graphic.md#gaca35fe1a1d344eab80ecb1425a74a91a)  is not used to set the coordinates of the start point of the curve, the drawing starts from the end point of the last line. Currently, the opacity cannot be set, and the maximum line width is  **3**.

**Parameters:**

<a name="table957140633093522"></a>
<table><thead align="left"><tr id="row1178227371093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2071464344093522"><a name="p2071464344093522"></a><a name="p2071464344093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p662988593093522"><a name="p662988593093522"></a><a name="p662988593093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1434702752093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">control1</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the coordinates of the first control point of the cubic Bezier curve. </td>
</tr>
<tr id="row1591822581093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">control2</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the coordinates of the second control point of the cubic Bezier curve. </td>
</tr>
<tr id="row1499326294093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endPoint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the coordinates of the end point of the cubic Bezier curve. </td>
</tr>
<tr id="row1837379178093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">paint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the curve style. For details, see <a href="ohos-paint.md">Paint</a>. </td>
</tr>
</tbody>
</table>

## DrawCurve\(\) \[2/2\]<a name="gad186e8eab51e97a4854d3a757a3becfb"></a>

```
void OHOS::UICanvas::DrawCurve (const [Point](ohos-point.md) & startPoint, const [Point](ohos-point.md) & control1, const [Point](ohos-point.md) & control2, const [Point](ohos-point.md) & endPoint, const [Paint](ohos-paint.md) & paint )
```

 **Description:**

Draws a cubic Bezier curve from the start point coordinates. 

Currently, the opacity cannot be set, and the maximum line width is  **3**.

**Parameters:**

<a name="table1813710423093522"></a>
<table><thead align="left"><tr id="row1932172911093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p32007479093522"><a name="p32007479093522"></a><a name="p32007479093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p904577909093522"><a name="p904577909093522"></a><a name="p904577909093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row555816254093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPoint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the coordinates of the start point of the cubic Bezier curve. </td>
</tr>
<tr id="row1800478277093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">control1</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the coordinates of the first control point of the cubic Bezier curve. </td>
</tr>
<tr id="row2008411624093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">control2</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the coordinates of the second control point of the cubic Bezier curve. </td>
</tr>
<tr id="row1809819275093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endPoint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the coordinates of the end point of the cubic Bezier curve. </td>
</tr>
<tr id="row1301258431093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">paint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the curve style. For details, see <a href="ohos-paint.md">Paint</a>. </td>
</tr>
</tbody>
</table>

## DrawImage\(\)<a name="gad5810166b3e02f41319dd4f4229c516c"></a>

```
void OHOS::UICanvas::DrawImage (const [Point](ohos-point.md) & startPoint, const char * image, const [Paint](ohos-paint.md) & paint )
```

 **Description:**

Draws an image. 

**Parameters:**

<a name="table1888276406093522"></a>
<table><thead align="left"><tr id="row565774794093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p768576940093522"><a name="p768576940093522"></a><a name="p768576940093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1895691735093522"><a name="p1895691735093522"></a><a name="p1895691735093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1035898494093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPoint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the coordinates of the start point. </td>
</tr>
<tr id="row827870852093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">image</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the image source. </td>
</tr>
<tr id="row1617801929093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">paint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the image style. For details, see <a href="ohos-paint.md">Paint</a>. </td>
</tr>
</tbody>
</table>

## DrawLabel\(\)<a name="ga32d815e5a459b4a866217a7c5c4bb425"></a>

```
void OHOS::UICanvas::DrawLabel (const [Point](ohos-point.md) & startPoint, const char * text, uint16_t maxWidth, const [FontStyle](ohos-uicanvas-fontstyle.md) & fontStyle, const [Paint](ohos-paint.md) & paint )
```

 **Description:**

Draws text. 

Only fill is supported. If the text length exceeds the value of  **maxWidth**, the text will be truncated. 

**Parameters:**

<a name="table711074789093522"></a>
<table><thead align="left"><tr id="row1627604589093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p73936685093522"><a name="p73936685093522"></a><a name="p73936685093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p890317742093522"><a name="p890317742093522"></a><a name="p890317742093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1404010857093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPoint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the coordinates of the start point. </td>
</tr>
<tr id="row901312492093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">text</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the text content. </td>
</tr>
<tr id="row150995773093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">maxWidth</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the maximum width of the text that can be displayed. If the maximum width is exceeded, the text is truncated. </td>
</tr>
<tr id="row1161850321093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fontStyle</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the text layout and font style. For details, see <a href="ohos-uicanvas-fontstyle.md">FontStyle</a>. </td>
</tr>
<tr id="row1688696165093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">paint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the text style. For details, see <a href="ohos-paint.md">Paint</a>. </td>
</tr>
</tbody>
</table>

## DrawLine\(\) \[1/2\]<a name="gac97d9d39484e5a1e36273510ae47327e"></a>

```
void OHOS::UICanvas::DrawLine (const [Point](ohos-point.md) & endPoint, const [Paint](ohos-paint.md) & paint )
```

 **Description:**

Draws a straight line. 

If  [SetStartPosition](graphic.md#gaca35fe1a1d344eab80ecb1425a74a91a)  is not used to set the coordinates of the start point of the line, the drawing starts from the end point of the last line.

**Parameters:**

<a name="table1480507271093522"></a>
<table><thead align="left"><tr id="row1122545279093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p361138512093522"><a name="p361138512093522"></a><a name="p361138512093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1645524532093522"><a name="p1645524532093522"></a><a name="p1645524532093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row581758888093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endPoint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the end point of the straight line. </td>
</tr>
<tr id="row652539821093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">paint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the straight line style. For details, see <a href="ohos-paint.md">Paint</a>. </td>
</tr>
</tbody>
</table>

## DrawLine\(\) \[2/2\]<a name="ga0c5e94526dab6a62d6db0a67385104db"></a>

```
void OHOS::UICanvas::DrawLine (const [Point](ohos-point.md) & startPoint, const [Point](ohos-point.md) & endPoint, const [Paint](ohos-paint.md) & paint )
```

 **Description:**

Draws a straight line from the coordinates of the start point. 

**Parameters:**

<a name="table1216372702093522"></a>
<table><thead align="left"><tr id="row451995505093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p703415798093522"><a name="p703415798093522"></a><a name="p703415798093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1301999528093522"><a name="p1301999528093522"></a><a name="p1301999528093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row644665161093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPoint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the coordinates of the start point. </td>
</tr>
<tr id="row1327151079093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endPoint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the coordinates of the end point. </td>
</tr>
<tr id="row1850595459093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">paint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the straight line style. For details, see <a href="ohos-paint.md">Paint</a>. </td>
</tr>
</tbody>
</table>

## DrawRect\(\)<a name="ga1cc0bc88810cdd5554e2b1b14e68c279"></a>

```
void OHOS::UICanvas::DrawRect (const [Point](ohos-point.md) & startPoint, int16_t height, int16_t width, const [Paint](ohos-paint.md) & paint )
```

 **Description:**

Draws a rectangle. 

**Parameters:**

<a name="table1672703861093522"></a>
<table><thead align="left"><tr id="row550574324093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p726217623093522"><a name="p726217623093522"></a><a name="p726217623093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p59806671093522"><a name="p59806671093522"></a><a name="p59806671093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1008444266093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPoint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the coordinates of the point at the upper left corner of the rectangle. </td>
</tr>
<tr id="row2052515228093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">height</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the height of the rectangle. </td>
</tr>
<tr id="row707736946093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">width</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the width of the rectangle. </td>
</tr>
<tr id="row1953672620093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">paint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the rectangle style. For details, see <a href="ohos-paint.md">Paint</a>. </td>
</tr>
</tbody>
</table>

## DrawSector\(\)<a name="gaf14bc2633c51a16097c3ad35e8bcb314"></a>

```
void OHOS::UICanvas::DrawSector (const [Point](ohos-point.md) & center, uint16_t radius, int16_t startAngle, int16_t endAngle, const [Paint](ohos-paint.md) & paint )
```

 **Description:**

Draws a sector. 

When the start angle is smaller than the end angle, the sector is drawn clockwise. Otherwise, the sector is drawn counterclockwise.

**Parameters:**

<a name="table1113405359093522"></a>
<table><thead align="left"><tr id="row2033349782093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p643807931093522"><a name="p643807931093522"></a><a name="p643807931093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1017312041093522"><a name="p1017312041093522"></a><a name="p1017312041093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1874820570093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">center</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the coordinates of the sector's center. </td>
</tr>
<tr id="row754594506093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">radius</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the radius of the sector. </td>
</tr>
<tr id="row1117350265093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startAngle</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the start angle of the sector. Value <strong id="b1837410728093522"><a name="b1837410728093522"></a><a name="b1837410728093522"></a>0</strong> indicates the 12-o'clock direction, and <strong id="b1961819865093522"><a name="b1961819865093522"></a><a name="b1961819865093522"></a>90</strong> indicates the 3-o'clock direction. </td>
</tr>
<tr id="row2015177803093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endAngle</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the end angle of the sector. Value <strong id="b391262242093522"><a name="b391262242093522"></a><a name="b391262242093522"></a>0</strong> indicates the 12-o'clock direction, and <strong id="b330201096093522"><a name="b330201096093522"></a><a name="b330201096093522"></a>90</strong> indicates the 3-o'clock direction. </td>
</tr>
<tr id="row1707351316093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">paint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the sector style. For details, see <a href="ohos-paint.md">Paint</a>. </td>
</tr>
</tbody>
</table>

## DumpDomNode\(\)<a name="ga812e123f85aa3ff687908e19d23fc54f"></a>

```
char* OHOS::UIDumpDomTree::DumpDomNode (const char * id)
```

 **Description:**

Exports information about a specified DOM node. 

**Parameters:**

<a name="table2109699048093522"></a>
<table><thead align="left"><tr id="row530241877093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1830737738093522"><a name="p1830737738093522"></a><a name="p1830737738093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2088911750093522"><a name="p2088911750093522"></a><a name="p2088911750093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1741091572093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the DOM node ID. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a character string about the DOM node information. The character string memory is released by invoking  **cJSON\_free\(\)**. 



## DumpDomTree\(\) \[1/2\]<a name="ga04fbff1f92851a2ac55c4575cbc132e9"></a>

```
bool OHOS::UIDumpDomTree::DumpDomTree (const char * id, const char * path )
```

 **Description:**

Exports information about a DOM tree starting from a specified DOM node and saves the information to a specified path. 

**Parameters:**

<a name="table1626169819093522"></a>
<table><thead align="left"><tr id="row549311387093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1020620388093522"><a name="p1020620388093522"></a><a name="p1020620388093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1490010138093522"><a name="p1490010138093522"></a><a name="p1490010138093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2025907821093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the DOM node ID. </td>
</tr>
<tr id="row702581959093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">path</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the specified path. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the operation is successful; returns  **false**  otherwise. 



## DumpDomTree\(\) \[2/2\]<a name="ga25384e441719c58d5cfdc3c67f1e8625"></a>

```
bool OHOS::UIDumpDomTree::DumpDomTree (const char * id)
```

 **Description:**

Exports information about a DOM tree starting from a specified DOM node and saves the information to the default path. The default path is  **DEFAULT\_DUMP\_DOM\_TREE\_PATH**. 

**Parameters:**

<a name="table1557283474093522"></a>
<table><thead align="left"><tr id="row465173801093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p380890085093522"><a name="p380890085093522"></a><a name="p380890085093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1506919437093522"><a name="p1506919437093522"></a><a name="p1506919437093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row587437118093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the DOM node ID. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the operation is successful; returns  **false**  otherwise. 



## Enable\(\)<a name="ga3185df8b60a609564f978ed9576fb813"></a>

```
void OHOS::UIButton::Enable ()
```

 **Description:**

Enables this button. 

## EnableAutoAlign\(\)<a name="ga034799920648552008146a0d9aca3424"></a>

```
void OHOS::UIList::EnableAutoAlign (bool state)
```

 **Description:**

Sets the automatic alignment state for this list. When a scroll stops, a child view is selected and its position is automatically aligned with the preset position. 

**Parameters:**

<a name="table668433018093522"></a>
<table><thead align="left"><tr id="row2133046272093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p988438685093522"><a name="p988438685093522"></a><a name="p988438685093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1940142451093522"><a name="p1940142451093522"></a><a name="p1940142451093522"></a>Description</p>
</th>
</tr