# NET<a name="EN-US_TOPIC_0000001055547972"></a>

## **Overview**<a name="section753515895084823"></a>

Provides functions and data structures related to network operations. 

**Since:**

1.0

**Version:**

1.0

## **Summary**<a name="section473204189084823"></a>

## Files<a name="files"></a>

<a name="table841715872084823"></a>
<table><thead align="left"><tr id="row1047757445084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2146229792084823"><a name="p2146229792084823"></a><a name="p2146229792084823"></a>File Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1318933958084823"><a name="p1318933958084823"></a><a name="p1318933958084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1534564455084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1688042362084823"><a name="p1688042362084823"></a><a name="p1688042362084823"></a><a href="inet-h.md">inet.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1641200125084823"><a name="p1641200125084823"></a><a name="p1641200125084823"></a>Provides functions and data structures related to network operations. </p>
</td>
</tr>
<tr id="row514356347084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1587665685084823"><a name="p1587665685084823"></a><a name="p1587665685084823"></a><a href="ifaddrs-h.md">ifaddrs.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1744755110084823"><a name="p1744755110084823"></a><a name="p1744755110084823"></a>Provides functions and data structures related to network operations. </p>
</td>
</tr>
<tr id="row268044906084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p397392420084823"><a name="p397392420084823"></a><a name="p397392420084823"></a><a href="if-h.md">if.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1597332387084823"><a name="p1597332387084823"></a><a name="p1597332387084823"></a>Provides functions and data structures related to network operations. For example, you can use the functions to send and receive network data, manage network addresses, and convert bytes. </p>
</td>
</tr>
<tr id="row926278315084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2054968073084823"><a name="p2054968073084823"></a><a name="p2054968073084823"></a><a href="netdb-h.md">netdb.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1417806404084823"><a name="p1417806404084823"></a><a name="p1417806404084823"></a>Provides functions and data structures related to network operations. For example, you can use the functions to send and receive network data, manage network addresses, and convert bytes. </p>
</td>
</tr>
<tr id="row149048245084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2002061914084823"><a name="p2002061914084823"></a><a name="p2002061914084823"></a><a href="ether-h.md">ether.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p942165214084823"><a name="p942165214084823"></a><a name="p942165214084823"></a>Provides functions and data structures related to network operations. For example, you can use the functions to send and receive network data, manage network addresses, and convert bytes. </p>
</td>
</tr>
<tr id="row136094859084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p299256507084823"><a name="p299256507084823"></a><a name="p299256507084823"></a><a href="resolv-h.md">resolv.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1468128296084823"><a name="p1468128296084823"></a><a name="p1468128296084823"></a>Provides functions and data structures related to network operations. For example, you can use the functions to send and receive network data, manage network addresses, and convert bytes. </p>
</td>
</tr>
<tr id="row341046334084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p934105532084823"><a name="p934105532084823"></a><a name="p934105532084823"></a><a href="socket-h.md">socket.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1681376634084823"><a name="p1681376634084823"></a><a name="p1681376634084823"></a>Provides functions and data structures related to network operations. </p>
</td>
</tr>
</tbody>
</table>

## Data Structures<a name="nested-classes"></a>

<a name="table1962766275084823"></a>
<table><thead align="left"><tr id="row30351370084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1079662055084823"><a name="p1079662055084823"></a><a name="p1079662055084823"></a>Data Structure Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1161517302084823"><a name="p1161517302084823"></a><a name="p1161517302084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row313274883084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1021591354084823"><a name="p1021591354084823"></a><a name="p1021591354084823"></a><a href="ifaddrs.md">ifaddrs</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1642104135084823"><a name="p1642104135084823"></a><a name="p1642104135084823"></a>Defines the network interface information. </p>
</td>
</tr>
<tr id="row1785624815084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1881057384084823"><a name="p1881057384084823"></a><a name="p1881057384084823"></a><a href="if_nameindex.md">if_nameindex</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1378525544084823"><a name="p1378525544084823"></a><a name="p1378525544084823"></a>Defines the network adapter information. </p>
</td>
</tr>
<tr id="row1318869958084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p243249055084823"><a name="p243249055084823"></a><a name="p243249055084823"></a><a href="hostent.md">hostent</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1219649058084823"><a name="p1219649058084823"></a><a name="p1219649058084823"></a>Describes the host name and address information. </p>
</td>
</tr>
<tr id="row362393367084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1686475780084823"><a name="p1686475780084823"></a><a name="p1686475780084823"></a><a href="sockaddr.md">sockaddr</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1320721300084823"><a name="p1320721300084823"></a><a name="p1320721300084823"></a>Describes the socket address information. </p>
</td>
</tr>
</tbody>
</table>

## Macros<a name="define-members"></a>

<a name="table1796704320084823"></a>
<table><thead align="left"><tr id="row59204572084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1151802652084823"><a name="p1151802652084823"></a><a name="p1151802652084823"></a>Macro Name and Value</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p649792700084823"><a name="p649792700084823"></a><a name="p649792700084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1789918693084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p189589009084823"><a name="p189589009084823"></a><a name="p189589009084823"></a><em id="ga4d04a8261523c8f3473946257c12ce5b"><a name="ga4d04a8261523c8f3473946257c12ce5b"></a><a name="ga4d04a8261523c8f3473946257c12ce5b"></a></em>h_addr    h_addr_list[0]</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1172142733084823"><a name="p1172142733084823"></a><a name="p1172142733084823"></a>Defines the first address in <strong id="b2085496826084823"><a name="b2085496826084823"></a><a name="b2085496826084823"></a>h_addr_list</strong> for backward compatibility. </p>
</td>
</tr>
<tr id="row1342128992084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p94068105084823"><a name="p94068105084823"></a><a name="p94068105084823"></a><em id="ga92d045f6ee2f343d6b28830a9fec082e"><a name="ga92d045f6ee2f343d6b28830a9fec082e"></a><a name="ga92d045f6ee2f343d6b28830a9fec082e"></a></em>SOL_SOCKET    1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1645355675084823"><a name="p1645355675084823"></a><a name="p1645355675084823"></a>Defines options for socket level. </p>
</td>
</tr>
</tbody>
</table>

## Functions<a name="func-members"></a>

<a name="table69559999084823"></a>
<table><thead align="left"><tr id="row1391025972084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1738281706084823"><a name="p1738281706084823"></a><a name="p1738281706084823"></a>Function Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p306910854084823"><a name="p306910854084823"></a><a name="p306910854084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1250275585084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p800270581084823"><a name="p800270581084823"></a><a name="p800270581084823"></a><a href="net.md#gac7eed08cd3b67f42bf56063157c8fd55">htonl</a> (uint32_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1179693593084823"><a name="p1179693593084823"></a><a name="p1179693593084823"></a>uint32_t </p>
<p id="p599929673084823"><a name="p599929673084823"></a><a name="p599929673084823"></a>Converts an integer from the host byte order to the network byte order. </p>
</td>
</tr>
<tr id="row449321257084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1775991740084823"><a name="p1775991740084823"></a><a name="p1775991740084823"></a><a href="net.md#gaabce0f8d453c3380e5b8a3d4947eb48c">htons</a> (uint16_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p120715463084823"><a name="p120715463084823"></a><a name="p120715463084823"></a>uint16_t </p>
<p id="p800992846084823"><a name="p800992846084823"></a><a name="p800992846084823"></a>Converts a 16-bit integer from the host byte order to the network byte order. </p>
</td>
</tr>
<tr id="row1243646209084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1449019059084823"><a name="p1449019059084823"></a><a name="p1449019059084823"></a><a href="net.md#gae68530d41f32dfef707f20b2bbaa5a44">ntohl</a> (uint32_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1729338936084823"><a name="p1729338936084823"></a><a name="p1729338936084823"></a>uint32_t </p>
<p id="p1913367858084823"><a name="p1913367858084823"></a><a name="p1913367858084823"></a>Converts an integer from the network byte order to the host byte order. </p>
</td>
</tr>
<tr id="row914180479084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p150716387084823"><a name="p150716387084823"></a><a name="p150716387084823"></a><a href="net.md#gaf8c87af507c59bd8fef112e5e35fe537">ntohs</a> (uint16_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p503326464084823"><a name="p503326464084823"></a><a name="p503326464084823"></a>uint16_t </p>
<p id="p1057500798084823"><a name="p1057500798084823"></a><a name="p1057500798084823"></a>Converts a 16-bit integer from the network byte order to the host byte order. </p>
</td>
</tr>
<tr id="row881408541084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p610302643084823"><a name="p610302643084823"></a><a name="p610302643084823"></a><a href="net.md#ga617651ec952a1f4c9cbddbf78f4b2e2e">inet_addr</a> (const char *p)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p505064305084823"><a name="p505064305084823"></a><a name="p505064305084823"></a>in_addr_t </p>
<p id="p1964642781084823"><a name="p1964642781084823"></a><a name="p1964642781084823"></a>Converts a string from the IPv4 numbers-and-dots notation to the binary data in network byte order. </p>
</td>
</tr>
<tr id="row2007902605084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p692271414084823"><a name="p692271414084823"></a><a name="p692271414084823"></a><a href="net.md#ga6f478437c4810fce89cf0e77d94181f8">inet_network</a> (const char *p)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2004891767084823"><a name="p2004891767084823"></a><a name="p2004891767084823"></a>in_addr_t </p>
<p id="p1781649473084823"><a name="p1781649473084823"></a><a name="p1781649473084823"></a>Converts a string from the IPv4 numbers-and-dots notation to the binary data in host byte order. </p>
</td>
</tr>
<tr id="row708223344084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p797277882084823"><a name="p797277882084823"></a><a name="p797277882084823"></a><a href="net.md#ga08b9fff487151e004d9862cbf34a51ad">inet_ntoa</a> (struct in_addr in)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p185782435084823"><a name="p185782435084823"></a><a name="p185782435084823"></a>char * </p>
<p id="p263079921084823"><a name="p263079921084823"></a><a name="p263079921084823"></a>Converts a network address to a string in dotted-decimal format. </p>
</td>
</tr>
<tr id="row403912037084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1563467611084823"><a name="p1563467611084823"></a><a name="p1563467611084823"></a><a href="net.md#ga3f6e2b2dae98a409d77c6e3b0cebc04b">inet_pton</a> (int af, const char *__restrict s, void *__restrict a0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p214467040084823"><a name="p214467040084823"></a><a name="p214467040084823"></a>int </p>
<p id="p1144368463084823"><a name="p1144368463084823"></a><a name="p1144368463084823"></a>Converts a string to a network address in the specified address family. </p>
</td>
</tr>
<tr id="row1283578422084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1137766884084823"><a name="p1137766884084823"></a><a name="p1137766884084823"></a><a href="net.md#gae9a2182ca3255f16723adeea14665b55">inet_ntop</a> (int af, const void *restrict a0, char *restrict s, socklen_t l)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1587169913084823"><a name="p1587169913084823"></a><a name="p1587169913084823"></a>const char * </p>
<p id="p885335151084823"><a name="p885335151084823"></a><a name="p885335151084823"></a>Converts a network address in the specified address family to a string. </p>
</td>
</tr>
<tr id="row1806744518084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1967129962084823"><a name="p1967129962084823"></a><a name="p1967129962084823"></a><a href="net.md#ga26ee8e8e3949699a9c0e02ece272d370">inet_aton</a> (const char *s0, struct in_addr *dest)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1904699225084823"><a name="p1904699225084823"></a><a name="p1904699225084823"></a>int </p>
<p id="p658664659084823"><a name="p658664659084823"></a><a name="p658664659084823"></a>Converts an IP address from the string format to the 32-bit binary format in network byte order. </p>
</td>
</tr>
<tr id="row874352910084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1074753513084823"><a name="p1074753513084823"></a><a name="p1074753513084823"></a><a href="net.md#gab28732d1d740597f53fb65a09d97800c">inet_makeaddr</a> (in_addr_t n, in_addr_t h)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p482694725084823"><a name="p482694725084823"></a><a name="p482694725084823"></a>struct in_addr </p>
<p id="p2002819071084823"><a name="p2002819071084823"></a><a name="p2002819071084823"></a>Converts the network number and host address to the network address. </p>
</td>
</tr>
<tr id="row1684606012084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p474259138084823"><a name="p474259138084823"></a><a name="p474259138084823"></a><a href="net.md#ga1facb1380b7657ca9c72fb2633b60e3b">inet_lnaof</a> (struct in_addr in)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p416897157084823"><a name="p416897157084823"></a><a name="p416897157084823"></a>in_addr_t </p>
<p id="p1864394858084823"><a name="p1864394858084823"></a><a name="p1864394858084823"></a>Converts an IP address into a host ID in host byte order without network bits. </p>
</td>
</tr>
<tr id="row70574674084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1697956955084823"><a name="p1697956955084823"></a><a name="p1697956955084823"></a><a href="net.md#ga3a96aa4e6abe8e6959ea63fe338174dd">inet_netof</a> (struct in_addr in)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1136423648084823"><a name="p1136423648084823"></a><a name="p1136423648084823"></a>in_addr_t </p>
<p id="p1877034083084823"><a name="p1877034083084823"></a><a name="p1877034083084823"></a>Extracts the network number from the <strong id="b412966734084823"><a name="b412966734084823"></a><a name="b412966734084823"></a>in_addr</strong> structure and converts it to the host byte order. </p>
</td>
</tr>
<tr id="row1011611382084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2138947338084823"><a name="p2138947338084823"></a><a name="p2138947338084823"></a><a href="net.md#gabfdd6ca5469fe73ed88ba94bf8db57cc">freeifaddrs</a> (struct <a href="ifaddrs.md">ifaddrs</a> *ifp)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1782627935084823"><a name="p1782627935084823"></a><a name="p1782627935084823"></a>void </p>
<p id="p1626722075084823"><a name="p1626722075084823"></a><a name="p1626722075084823"></a>Frees the network interface information obtained by <strong id="b395228521084823"><a name="b395228521084823"></a><a name="b395228521084823"></a>getifaddrs</strong>. </p>
</td>
</tr>
<tr id="row1523596962084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1185162351084823"><a name="p1185162351084823"></a><a name="p1185162351084823"></a><a href="net.md#ga7fe55c04ac2116fa501338fdcb279cc9">if_freenameindex</a> (struct <a href="if_nameindex.md">if_nameindex</a> *idx)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p466150862084823"><a name="p466150862084823"></a><a name="p466150862084823"></a>void </p>
<p id="p1227864924084823"><a name="p1227864924084823"></a><a name="p1227864924084823"></a>Frees the network adapter information obtained by <a href="if_nameindex.md">if_nameindex</a>. </p>
</td>
</tr>
<tr id="row445255026084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p128079446084823"><a name="p128079446084823"></a><a name="p128079446084823"></a><a href="net.md#ga6a806414e4ae5bffb09e3a1d25d8db75">setprotoent</a> (int stayopen)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p329862635084823"><a name="p329862635084823"></a><a name="p329862635084823"></a>void </p>
<p id="p870887648084823"><a name="p870887648084823"></a><a name="p870887648084823"></a>Opens a connection to the database and sets the next entry to the first entry. </p>
</td>
</tr>
<tr id="row1325757564084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1419864832084823"><a name="p1419864832084823"></a><a name="p1419864832084823"></a><a href="net.md#gaca0da70657afbc3e723990bb229deec3">getprotoent</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1264117452084823"><a name="p1264117452084823"></a><a name="p1264117452084823"></a>struct protoent * </p>
<p id="p1441436231084823"><a name="p1441436231084823"></a><a name="p1441436231084823"></a>Retrieves the current protocol information. </p>
</td>
</tr>
<tr id="row1509314093084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p379180379084823"><a name="p379180379084823"></a><a name="p379180379084823"></a><a href="net.md#ga83ac8a97dd9d895cda658af3aa46fd55">getprotobyname</a> (const char *name)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2037369819084823"><a name="p2037369819084823"></a><a name="p2037369819084823"></a>struct protoent * </p>
<p id="p37283784084823"><a name="p37283784084823"></a><a name="p37283784084823"></a>Retrieves the information about a specified protocol. </p>
</td>
</tr>
<tr id="row1257886586084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p762204003084823"><a name="p762204003084823"></a><a name="p762204003084823"></a><a href="net.md#gac01697dc4a5b8e434522220913bd46ea">getprotobynumber</a> (int num)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1202841175084823"><a name="p1202841175084823"></a><a name="p1202841175084823"></a>struct protoent * </p>
<p id="p1417548121084823"><a name="p1417548121084823"></a><a name="p1417548121084823"></a>Retrieves the information about a protocol with the specified number. </p>
</td>
</tr>
<tr id="row831070986084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p670615805084823"><a name="p670615805084823"></a><a name="p670615805084823"></a><a href="net.md#gaa68de2578d4e0849f82d70b2f5b9af70">herror</a> (const char *msg)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p883417745084823"><a name="p883417745084823"></a><a name="p883417745084823"></a>void </p>
<p id="p1369101200084823"><a name="p1369101200084823"></a><a name="p1369101200084823"></a>Prints error information. </p>
</td>
</tr>
<tr id="row1028826760084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1213445298084823"><a name="p1213445298084823"></a><a name="p1213445298084823"></a><a href="net.md#gac1752c48d9cf2ff87e29f29df6caa585">hstrerror</a> (int ecode)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p756976133084823"><a name="p756976133084823"></a><a name="p756976133084823"></a>const char * </p>
<p id="p4806929084823"><a name="p4806929084823"></a><a name="p4806929084823"></a>Retrieves error information associated with the specified error number. </p>
</td>
</tr>
<tr id="row1186471532084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p798569354084823"><a name="p798569354084823"></a><a name="p798569354084823"></a><a href="net.md#ga07e34e6ee9e272c4799780915d11677c">ether_ntoa</a> (const struct ether_addr *p_a)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1791524032084823"><a name="p1791524032084823"></a><a name="p1791524032084823"></a>char * </p>
<p id="p1180844634084823"><a name="p1180844634084823"></a><a name="p1180844634084823"></a>Converts binary data in network byte order into a standard 48-bit Ethernet host address in the colon hexadecimal notation. </p>
</td>
</tr>
<tr id="row1652457536084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2122460199084823"><a name="p2122460199084823"></a><a name="p2122460199084823"></a><a href="net.md#gaab4c5b65c36fc0ea96a017daabc3770a">ether_aton</a> (const char *x)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1942310810084823"><a name="p1942310810084823"></a><a name="p1942310810084823"></a>struct ether_addr * </p>
<p id="p1420654844084823"><a name="p1420654844084823"></a><a name="p1420654844084823"></a>Converts a standard 48-bit Ethernet host address in the colon hexadecimal notation into binary data in network byte order. </p>
</td>
</tr>
<tr id="row238658457084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1108619190084823"><a name="p1108619190084823"></a><a name="p1108619190084823"></a><a href="net.md#ga245e21de8e82756712a5182c2674c2ad">ether_ntoa_r</a> (const struct ether_addr *p_a, char *x)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1047327804084823"><a name="p1047327804084823"></a><a name="p1047327804084823"></a>char * </p>
<p id="p1194135536084823"><a name="p1194135536084823"></a><a name="p1194135536084823"></a>Converts binary data in network byte order into a standard 48-bit Ethernet host address in the colon hexadecimal notation. This function is reentrant. </p>
</td>
</tr>
<tr id="row380346995084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p157075316084823"><a name="p157075316084823"></a><a name="p157075316084823"></a><a href="net.md#gac0954821754bace30f674e61bb9f4e5f">ether_aton_r</a> (const char *x, struct ether_addr *p_a)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p492539530084823"><a name="p492539530084823"></a><a name="p492539530084823"></a>struct ether_addr * </p>
<p id="p2059059200084823"><a name="p2059059200084823"></a><a name="p2059059200084823"></a>Converts a standard 48-bit Ethernet host address in the colon hexadecimal notation into binary data in network byte order. This function is reentrant. </p>
</td>
</tr>
<tr id="row240839655084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p518085811084823"><a name="p518085811084823"></a><a name="p518085811084823"></a><a href="net.md#ga0438570faf515401bffa1a0d9c94a266">dn_comp</a> (const char *src, unsigned char *dst, int space, unsigned char **dnptrs, unsigned char **lastdnptr)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1083627853084823"><a name="p1083627853084823"></a><a name="p1083627853084823"></a>int </p>
<p id="p643173720084823"><a name="p643173720084823"></a><a name="p643173720084823"></a>Compresses a network domain name. </p>
</td>
</tr>
<tr id="row1824161885084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1736534313084823"><a name="p1736534313084823"></a><a name="p1736534313084823"></a><a href="net.md#ga91eb2055a64b28e4942a3a760d747243">dn_expand</a> (const unsigned char *base, const unsigned char *end, const unsigned char *src, char *dest, int space)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p45439866084823"><a name="p45439866084823"></a><a name="p45439866084823"></a>int </p>
<p id="p1039444744084823"><a name="p1039444744084823"></a><a name="p1039444744084823"></a>Expands a compressed domain name to a full domain name. </p>
</td>
</tr>
<tr id="row1520625210084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p955533434084823"><a name="p955533434084823"></a><a name="p955533434084823"></a><a href="net.md#gaf4e0711877c45a41168ac677b0670ccd">socket</a> (int domain, int type, int protocol)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p4462400084823"><a name="p4462400084823"></a><a name="p4462400084823"></a>int </p>
<p id="p1156030327084823"><a name="p1156030327084823"></a><a name="p1156030327084823"></a>Creates a socket and returns its descriptor. </p>
</td>
</tr>
<tr id="row1983761446084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p60461330084823"><a name="p60461330084823"></a><a name="p60461330084823"></a><a href="net.md#ga402425b8e1ceab40ac38a949babcf1aa">shutdown</a> (int sockfd, int how)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p529463257084823"><a name="p529463257084823"></a><a name="p529463257084823"></a>int </p>
<p id="p1570123973084823"><a name="p1570123973084823"></a><a name="p1570123973084823"></a>Shuts down a socket. </p>
</td>
</tr>
<tr id="row654350451084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2102185061084823"><a name="p2102185061084823"></a><a name="p2102185061084823"></a><a href="net.md#ga82199bcd81894331533a25f08e172480">bind</a> (int sockfd, const struct <a href="sockaddr.md">sockaddr</a> *addr, socklen_t addrlen)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1091890261084823"><a name="p1091890261084823"></a><a name="p1091890261084823"></a>int </p>
<p id="p1458386264084823"><a name="p1458386264084823"></a><a name="p1458386264084823"></a>Binds a local protocol address to a socket. </p>
</td>
</tr>
<tr id="row79869139084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1689773652084823"><a name="p1689773652084823"></a><a name="p1689773652084823"></a><a href="net.md#gacdfd99b6c59c833776412fbb0c539efb">connect</a> (int sockfd, const struct <a href="sockaddr.md">sockaddr</a> *addr, socklen_t addrlen)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1873549191084823"><a name="p1873549191084823"></a><a name="p1873549191084823"></a>int </p>
<p id="p1670254800084823"><a name="p1670254800084823"></a><a name="p1670254800084823"></a>Initiates a connection to a socket. </p>
</td>
</tr>
<tr id="row374008223084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1045510782084823"><a name="p1045510782084823"></a><a name="p1045510782084823"></a><a href="net.md#ga5989c21d05cb17caba26cef496a7beea">listen</a> (int sockfd, int backlog)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1363603361084823"><a name="p1363603361084823"></a><a name="p1363603361084823"></a>int </p>
<p id="p1581751471084823"><a name="p1581751471084823"></a><a name="p1581751471084823"></a>Listens for network connections. </p>
</td>
</tr>
<tr id="row91023670084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2076186408084823"><a name="p2076186408084823"></a><a name="p2076186408084823"></a><a href="net.md#ga0807af5ac9dfc2a63624e8c3e0ae95ef">accept</a> (int sockfd, struct <a href="sockaddr.md">sockaddr</a> *__restrict addr, socklen_t *__restrict addrlen)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p536890145084823"><a name="p536890145084823"></a><a name="p536890145084823"></a>int </p>
<p id="p1756373391084823"><a name="p1756373391084823"></a><a name="p1756373391084823"></a>Accepts incoming connection requests. </p>
</td>
</tr>
<tr id="row1489447192084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1459171001084823"><a name="p1459171001084823"></a><a name="p1459171001084823"></a><a href="net.md#ga62577da7dba23abb9c99cf5c2800ab24">getsockname</a> (int fd, struct <a href="sockaddr.md">sockaddr</a> *restrict addr, socklen_t *restrict len)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2087017641084823"><a name="p2087017641084823"></a><a name="p2087017641084823"></a>int </p>
<p id="p1354254583084823"><a name="p1354254583084823"></a><a name="p1354254583084823"></a>Retrieves the local address of the specified socket. </p>
</td>
</tr>
<tr id="row1573775141084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p552955141084823"><a name="p552955141084823"></a><a name="p552955141084823"></a><a href="net.md#ga13d77555ad4ed62dfef0ce32dd16755c">getpeername</a> (int fd, struct <a href="sockaddr.md">sockaddr</a> *restrict addr, socklen_t *restrict len)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p100844166084823"><a name="p100844166084823"></a><a name="p100844166084823"></a>int </p>
<p id="p15115223084823"><a name="p15115223084823"></a><a name="p15115223084823"></a>Retrieves the peer address of the specified socket. </p>
</td>
</tr>
<tr id="row2076620619084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1336896639084823"><a name="p1336896639084823"></a><a name="p1336896639084823"></a><a href="net.md#ga4053f5c8e26fd490ef54e2a0abf5c89f">send</a> (int fd, const void *buf, size_t len, int flags)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p894134392084823"><a name="p894134392084823"></a><a name="p894134392084823"></a>ssize_t </p>
<p id="p124948650084823"><a name="p124948650084823"></a><a name="p124948650084823"></a>Sends data to another socket. </p>
</td>
</tr>
<tr id="row1892679587084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1041327232084823"><a name="p1041327232084823"></a><a name="p1041327232084823"></a><a href="net.md#ga5d049263cd0e3206b93530e68dfd7403">recv</a> (int fd, void *buf, size_t len, int flags)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1933928262084823"><a name="p1933928262084823"></a><a name="p1933928262084823"></a>ssize_t </p>
<p id="p1969969914084823"><a name="p1969969914084823"></a><a name="p1969969914084823"></a>Receives data from another socket. </p>
</td>
</tr>
<tr id="row1502978720084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p118297155084823"><a name="p118297155084823"></a><a name="p118297155084823"></a><a href="net.md#ga2587b27d2c6014c6b568a974655f41c5">sendto</a> (int fd, const void *buf, size_t len, int flags, const struct <a href="sockaddr.md">sockaddr</a> *addr, socklen_t alen)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1855557799084823"><a name="p1855557799084823"></a><a name="p1855557799084823"></a>ssize_t </p>
<p id="p321790663084823"><a name="p321790663084823"></a><a name="p321790663084823"></a>Sends data to another socket. </p>
</td>
</tr>
<tr id="row2077239603084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p133768213084823"><a name="p133768213084823"></a><a name="p133768213084823"></a><a href="net.md#ga3089d3ee59e26bd4def3ef870175540e">recvfrom</a> (int fd, void *__restrict buf, size_t len, int flags, struct <a href="sockaddr.md">sockaddr</a> *__restrict addr, socklen_t *__restrict alen)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1954533757084823"><a name="p1954533757084823"></a><a name="p1954533757084823"></a>ssize_t </p>
<p id="p954022336084823"><a name="p954022336084823"></a><a name="p954022336084823"></a>Receives data from a specified socket. </p>
</td>
</tr>
<tr id="row1683766634084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p509552132084823"><a name="p509552132084823"></a><a name="p509552132084823"></a><a href="net.md#ga70c97d3a1eab72cba4461d66a1778570">sendmsg</a> (int fd, const struct msghdr *msg, int flags)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p465140908084823"><a name="p465140908084823"></a><a name="p465140908084823"></a>ssize_t </p>
<p id="p721147421084823"><a name="p721147421084823"></a><a name="p721147421084823"></a>Sends data to another socket. </p>
</td>
</tr>
<tr id="row1173903187084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p693882787084823"><a name="p693882787084823"></a><a name="p693882787084823"></a><a href="net.md#gaaba92f19a31c01b93e3391671a8b3dd5">recvmsg</a> (int fd, struct msghdr *msg, int flags)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p190314286084823"><a name="p190314286084823"></a><a name="p190314286084823"></a>ssize_t </p>
<p id="p1584086933084823"><a name="p1584086933084823"></a><a name="p1584086933084823"></a>Receives data from a specified socket. </p>
</td>
</tr>
<tr id="row1932829784084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p891730494084823"><a name="p891730494084823"></a><a name="p891730494084823"></a><a href="net.md#gacfcf672e255123afb75ed4d326257073">getsockopt</a> (int fd, int level, int optname, void *__restrict optval, socklen_t *__restrict optlen)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1595296975084823"><a name="p1595296975084823"></a><a name="p1595296975084823"></a>int </p>
<p id="p1229495420084823"><a name="p1229495420084823"></a><a name="p1229495420084823"></a>Retrieves the socket options. </p>
</td>
</tr>
<tr id="row1356725082084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2090018333084823"><a name="p2090018333084823"></a><a name="p2090018333084823"></a><a href="net.md#ga81983de50d79d797b2ac0f0d0f28953f">setsockopt</a> (int fd, int level, int optname, const void *optval, socklen_t optlen)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1522360728084823"><a name="p1522360728084823"></a><a name="p1522360728084823"></a>int </p>
<p id="p390417633084823"><a name="p390417633084823"></a><a name="p390417633084823"></a>Sets the socket options. </p>
</td>
</tr>
</tbody>
</table>

## **Details**<a name="section1509792952084823"></a>

## **Function Documentation**<a name="section1481646333084823"></a>

## accept\(\)<a name="ga0807af5ac9dfc2a63624e8c3e0ae95ef"></a>

```
int accept (int sockfd, struct [sockaddr](sockaddr.md) *__restrict addr, socklen_t *__restrict addrlen )
```

 **Description:**

Accepts incoming connection requests. 

**Parameters:**

<a name="table1384594293084823"></a>
<table><thead align="left"><tr id="row1379205696084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1431243965084823"><a name="p1431243965084823"></a><a name="p1431243965084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p257873905084823"><a name="p257873905084823"></a><a name="p257873905084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row837867447084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">sockfd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the socket descriptor. </td>
</tr>
<tr id="row915675019084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">addr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the socket address requiring for the connection. </td>
</tr>
<tr id="row179275462084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">addrlen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the address structure pointed to by <strong id="b856271535084823"><a name="b856271535084823"></a><a name="b856271535084823"></a>addr</strong>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a valid socket if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table182089645084823"></a>
<table><thead align="left"><tr id="row1470416530084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1994239455084823"><a name="p1994239455084823"></a><a name="p1994239455084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1235562631084823"><a name="p1235562631084823"></a><a name="p1235562631084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row771062085084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1903968236084823"><a name="p1903968236084823"></a><a name="p1903968236084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1635032206084823"><a name="p1635032206084823"></a><a name="p1635032206084823"></a>Invalid input parameter </p>
</td>
</tr>
<tr id="row360202523084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2042502427084823"><a name="p2042502427084823"></a><a name="p2042502427084823"></a>EOPNOTSUPP </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p40810559084823"><a name="p40810559084823"></a><a name="p40810559084823"></a>The socket requiring for the connection is not of the <strong id="b795369128084823"><a name="b795369128084823"></a><a name="b795369128084823"></a>NETCONN_TCP</strong> type. </p>
</td>
</tr>
<tr id="row381042439084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p468525874084823"><a name="p468525874084823"></a><a name="p468525874084823"></a>EWOULDBLOCK </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p581179242084823"><a name="p581179242084823"></a><a name="p581179242084823"></a>Failure to receive events in non-blocking mode. </p>
</td>
</tr>
<tr id="row740555412084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1060675232084823"><a name="p1060675232084823"></a><a name="p1060675232084823"></a>ENFILE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1569107010084823"><a name="p1569107010084823"></a><a name="p1569107010084823"></a>Failure to creat a new socket. </p>
</td>
</tr>
<tr id="row843816412084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1484641784084823"><a name="p1484641784084823"></a><a name="p1484641784084823"></a>ECONNABORTED </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p722762628084823"><a name="p722762628084823"></a><a name="p722762628084823"></a>Failure to receive the remote information. </p>
</td>
</tr>
<tr id="row854598062084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p628578973084823"><a name="p628578973084823"></a><a name="p628578973084823"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p492437975084823"><a name="p492437975084823"></a><a name="p492437975084823"></a>Memory copy exception. </p>
</td>
</tr>
</tbody>
</table>

## bind\(\)<a name="ga82199bcd81894331533a25f08e172480"></a>

```
int bind (int sockfd, const struct [sockaddr](sockaddr.md) * addr, socklen_t addrlen )
```

 **Description:**

Binds a local protocol address to a socket. 

**Parameters:**

<a name="table1843615087084823"></a>
<table><thead align="left"><tr id="row473013099084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1928964312084823"><a name="p1928964312084823"></a><a name="p1928964312084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1222904834084823"><a name="p1222904834084823"></a><a name="p1222904834084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row913547152084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">sockfd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the socket descriptor. </td>
</tr>
<tr id="row1921267611084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">addr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the address to be bound to the socket. </td>
</tr>
<tr id="row1717112217084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">addrlen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the address structure pointed to by <strong id="b1635141293084823"><a name="b1635141293084823"></a><a name="b1635141293084823"></a>addr</strong>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1715986844084823"></a>
<table><thead align="left"><tr id="row1424912561084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1073213464084823"><a name="p1073213464084823"></a><a name="p1073213464084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p759099792084823"><a name="p759099792084823"></a><a name="p759099792084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1846451236084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1415012060084823"><a name="p1415012060084823"></a><a name="p1415012060084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p447971340084823"><a name="p447971340084823"></a><a name="p447971340084823"></a>Invalid input parameter </p>
</td>
</tr>
</tbody>
</table>

## connect\(\)<a name="gacdfd99b6c59c833776412fbb0c539efb"></a>

```
int connect (int sockfd, const struct [sockaddr](sockaddr.md) * addr, socklen_t addrlen )
```

 **Description:**

Initiates a connection to a socket. 

**Parameters:**

<a name="table190715380084823"></a>
<table><thead align="left"><tr id="row2049739153084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p162296772084823"><a name="p162296772084823"></a><a name="p162296772084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1463161408084823"><a name="p1463161408084823"></a><a name="p1463161408084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1343597221084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">sockfd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the socket descriptor. </td>
</tr>
<tr id="row1320757767084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">addr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the address to be connected. </td>
</tr>
<tr id="row750085475084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">addrlen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the address structure pointed to by <strong id="b1993078868084823"><a name="b1993078868084823"></a><a name="b1993078868084823"></a>addr</strong>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table660818283084823"></a>
<table><thead align="left"><tr id="row1988543378084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1475655049084823"><a name="p1475655049084823"></a><a name="p1475655049084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p771866223084823"><a name="p771866223084823"></a><a name="p771866223084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1256564046084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1844252288084823"><a name="p1844252288084823"></a><a name="p1844252288084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p775877436084823"><a name="p775877436084823"></a><a name="p775877436084823"></a>Invalid input parameter </p>
</td>
</tr>
<tr id="row2105239460084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1434705018084823"><a name="p1434705018084823"></a><a name="p1434705018084823"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p740702522084823"><a name="p740702522084823"></a><a name="p740702522084823"></a>Invalid socket or socket status exception </p>
</td>
</tr>
<tr id="row534047705084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1557911392084823"><a name="p1557911392084823"></a><a name="p1557911392084823"></a>EIO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1711662368084823"><a name="p1711662368084823"></a><a name="p1711662368084823"></a>Incorrect connection type obtained based on the socket descriptor </p>
</td>
</tr>
<tr id="row1605958071084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p8625727084823"><a name="p8625727084823"></a><a name="p8625727084823"></a>ECONNREFUSED </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1036924109084823"><a name="p1036924109084823"></a><a name="p1036924109084823"></a>Restart due to connection failure </p>
</td>
</tr>
<tr id="row941464218084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p484526459084823"><a name="p484526459084823"></a><a name="p484526459084823"></a>ECONNABORTED </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p323225667084823"><a name="p323225667084823"></a><a name="p323225667084823"></a>Shut-down due to connection failure </p>
</td>
</tr>
</tbody>
</table>

## dn\_comp\(\)<a name="ga0438570faf515401bffa1a0d9c94a266"></a>

```
int dn_comp (const char * src, unsigned char * dst, int space, unsigned char ** dnptrs, unsigned char ** lastdnptr )
```

 **Description:**

Compresses a network domain name. 

To reduce the size of DNS messages, domain names in the messages are compressed. For details about the compression scheme, see RFC 1035.

**Parameters:**

<a name="table583689077084823"></a>
<table><thead align="left"><tr id="row876650706084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p218745750084823"><a name="p218745750084823"></a><a name="p218745750084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1839448394084823"><a name="p1839448394084823"></a><a name="p1839448394084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row620738231084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">src</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the domain name to be compressed. </td>
</tr>
<tr id="row1486902746084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dst</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the compressed domain name. </td>
</tr>
<tr id="row160941083084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">space</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of the compressed domain name. </td>
</tr>
<tr id="row803168422084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dnptrs</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to an array of pointers to previously compressed domain names. If the value is <strong id="b1658060845084823"><a name="b1658060845084823"></a><a name="b1658060845084823"></a>NULL</strong>, the current domain name will not be compressed. </td>
</tr>
<tr id="row78966975084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">lastdnptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the last element of the array. If the value is <strong id="b1761182705084823"><a name="b1761182705084823"></a><a name="b1761182705084823"></a>NULL</strong>, the array is not updated. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the length of the compressed domain name if the operation is successful; returns  **-1**  otherwise. 



## dn\_expand\(\)<a name="ga91eb2055a64b28e4942a3a760d747243"></a>

```
int dn_expand (const unsigned char * base, const unsigned char * end, const unsigned char * src, char * dest, int space )
```

 **Description:**

Expands a compressed domain name to a full domain name. 

The compressed domain name is contained in a query or reply message.

**Parameters:**

<a name="table606804165084823"></a>
<table><thead align="left"><tr id="row280542321084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1653377328084823"><a name="p1653377328084823"></a><a name="p1653377328084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p75746575084823"><a name="p75746575084823"></a><a name="p75746575084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row604905039084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">base</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the start of the DNS message body. </td>
</tr>
<tr id="row519475699084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">end</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the end of the DNS message body. </td>
</tr>
<tr id="row774193744084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">src</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the compressed domain name. </td>
</tr>
<tr id="row1779529554084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dest</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the expanded domain name. </td>
</tr>
<tr id="row1371383957084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">space</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the memory size of the <strong id="b1201928900084823"><a name="b1201928900084823"></a><a name="b1201928900084823"></a>dest</strong> address. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the length of the compressed domain name if the operation is successful; returns  **-1**  otherwise. 



## ether\_aton\(\)<a name="gaab4c5b65c36fc0ea96a017daabc3770a"></a>

```
struct ether_addr* ether_aton (const char * x)
```

 **Description:**

Converts a standard 48-bit Ethernet host address in the colon hexadecimal notation into binary data in network byte order. 

**Parameters:**

<a name="table1645854379084823"></a>
<table><thead align="left"><tr id="row1352029745084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2014538241084823"><a name="p2014538241084823"></a><a name="p2014538241084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1371812510084823"><a name="p1371812510084823"></a><a name="p1371812510084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2140647533084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">x</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the host address to be converted. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the binary data if the operation is successful; returns  **0**  otherwise. 



## ether\_aton\_r\(\)<a name="gac0954821754bace30f674e61bb9f4e5f"></a>

```
struct ether_addr* ether_aton_r (const char * x, struct ether_addr * p_a )
```

 **Description:**

Converts a standard 48-bit Ethernet host address in the colon hexadecimal notation into binary data in network byte order. This function is reentrant. 

This function is used in multitasking scenarios. 

**Parameters:**

<a name="table1342551667084823"></a>
<table><thead align="left"><tr id="row155545281084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1925550878084823"><a name="p1925550878084823"></a><a name="p1925550878084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p11422782084823"><a name="p11422782084823"></a><a name="p11422782084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1980253129084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">x</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the host address to be converted. </td>
</tr>
<tr id="row1660147145084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">p_a</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the temporary buffer during conversion. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the binary data represented by  **ether\_addr**  if the operation is successful; returns  **0**  otherwise. 



## ether\_ntoa\(\)<a name="ga07e34e6ee9e272c4799780915d11677c"></a>

```
char* ether_ntoa (const struct ether_addr * p_a)
```

 **Description:**

Converts binary data in network byte order into a standard 48-bit Ethernet host address in the colon hexadecimal notation. 

**Parameters:**

<a name="table852516764084823"></a>
<table><thead align="left"><tr id="row1829049680084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1798489600084823"><a name="p1798489600084823"></a><a name="p1798489600084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p938957796084823"><a name="p938957796084823"></a><a name="p938957796084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1577332872084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">p_a</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the binary data to be converted. </td>
</tr>
</tbody>
</table>

**Attention:**

Different from glibc \(for example, 1:2:3:4:5:f\), 0 is prefixed and letters are capitalized \(for example, 01:02:03:04:05:0F\). 

**Returns:**

Returns the host address if the operation is successful; returns  **0**  otherwise. 



## ether\_ntoa\_r\(\)<a name="ga245e21de8e82756712a5182c2674c2ad"></a>

```
char* ether_ntoa_r (const struct ether_addr * p_a, char * x )
```

 **Description:**

Converts binary data in network byte order into a standard 48-bit Ethernet host address in the colon hexadecimal notation. This function is reentrant. 

This function is used in multitasking scenarios. 

**Parameters:**

<a name="table93591325084823"></a>
<table><thead align="left"><tr id="row1731519265084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1781089769084823"><a name="p1781089769084823"></a><a name="p1781089769084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1656034757084823"><a name="p1656034757084823"></a><a name="p1656034757084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1828162906084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">p_a</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the binary data to be converted. </td>
</tr>
<tr id="row802480538084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">x</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the temporary buffer during conversion. </td>
</tr>
</tbody>
</table>

**Attention:**

Different from glibc \(for example, 1:2:3:4:5:f\), 0 is prefixed and letters are capitalized \(for example, 01:02:03:04:05:0F\). 

**Returns:**

Returns the host address if the operation is successful; returns  **0**  otherwise. 



## freeifaddrs\(\)<a name="gabfdd6ca5469fe73ed88ba94bf8db57cc"></a>

```
void freeifaddrs (struct [ifaddrs](ifaddrs.md) * ifp)
```

 **Description:**

Frees the network interface information obtained by  **getifaddrs**. 

**Parameters:**

<a name="table1820237042084823"></a>
<table><thead align="left"><tr id="row323193891084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1114462850084823"><a name="p1114462850084823"></a><a name="p1114462850084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1136452924084823"><a name="p1136452924084823"></a><a name="p1136452924084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row152353918084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ifp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the network interface information to be freed. </td>
</tr>
</tbody>
</table>

## getpeername\(\)<a name="ga13d77555ad4ed62dfef0ce32dd16755c"></a>

```
int getpeername (int fd, struct [sockaddr](sockaddr.md) *restrict addr, socklen_t *restrict len )
```

 **Description:**

Retrieves the peer address of the specified socket. 

**Parameters:**

<a name="table1193726782084823"></a>
<table><thead align="left"><tr id="row854719437084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1455244313084823"><a name="p1455244313084823"></a><a name="p1455244313084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p523671561084823"><a name="p523671561084823"></a><a name="p523671561084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row190412682084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the socket descriptor. </td>
</tr>
<tr id="row1560374389084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">addr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the address to be retrieved. </td>
</tr>
<tr id="row1124363194084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">len</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the length of the address pointed to by <strong id="b300352150084823"><a name="b300352150084823"></a><a name="b300352150084823"></a>addr</strong>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1768605639084823"></a>
<table><thead align="left"><tr id="row1600748281084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p603033358084823"><a name="p603033358084823"></a><a name="p603033358084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1180991341084823"><a name="p1180991341084823"></a><a name="p1180991341084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row762581785084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p834625037084823"><a name="p834625037084823"></a><a name="p834625037084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p14899781084823"><a name="p14899781084823"></a><a name="p14899781084823"></a>Invalid input parameter </p>
</td>
</tr>
<tr id="row1236508396084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1428612853084823"><a name="p1428612853084823"></a><a name="p1428612853084823"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1350028215084823"><a name="p1350028215084823"></a><a name="p1350028215084823"></a>Invalid socket or socket status exception </p>
</td>
</tr>
<tr id="row1414667233084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p75413034084823"><a name="p75413034084823"></a><a name="p75413034084823"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1808224081084823"><a name="p1808224081084823"></a><a name="p1808224081084823"></a>Memory copy exception </p>
</td>
</tr>
</tbody>
</table>

## getprotobyname\(\)<a name="ga83ac8a97dd9d895cda658af3aa46fd55"></a>

```
struct protoent* getprotobyname (const char * name)
```

 **Description:**

Retrieves the information about a specified protocol. 

**Parameters:**

<a name="table188629742084823"></a>
<table><thead align="left"><tr id="row1264675564084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1426514125084823"><a name="p1426514125084823"></a><a name="p1426514125084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1936774566084823"><a name="p1936774566084823"></a><a name="p1936774566084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1617210089084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">addr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the protocol name. </td>
</tr>
</tbody>
</table>

**Attention:**

The  **/etc/protocols**  configuration file is not supported. Only the following built-in protocols are supported: ip/icmp/igmp/ggp/ipencap/st/tcp/egp/pup/udp/hmp/xns-idp/rdp/iso-tp4/xtp/ ddp/idpr-cmtp/ipv6/ipv6-route/ipv6-frag/idrp/rsvp/gre/esp/ah/skip/ipv6-icmp/ ipv6-nonxt/ipv6-opts/rspf/vmtp/ospf/ipip/encap/pim/raw \(This protocol does not have the  **aliases**  attribute, that is,  **aliases**  is empty.\) 

**Returns:**

Returns the protocol information if the operation is successful; returns  **NULL**  otherwise. 



## getprotobynumber\(\)<a name="gac01697dc4a5b8e434522220913bd46ea"></a>

```
struct protoent* getprotobynumber (int num)
```

 **Description:**

Retrieves the information about a protocol with the specified number. 

**Parameters:**

<a name="table117377580084823"></a>
<table><thead align="left"><tr id="row1123612656084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p874116607084823"><a name="p874116607084823"></a><a name="p874116607084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1673302622084823"><a name="p1673302622084823"></a><a name="p1673302622084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row204975880084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">num</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the protocol number. </td>
</tr>
</tbody>
</table>

**Attention:**

The  **/etc/protocols**  configuration file is not supported. Only the following built-in protocols are supported: ip/icmp/igmp/ggp/ipencap/st/tcp/egp/pup/udp/hmp/xns-idp/rdp/iso-tp4/xtp/ ddp/idpr-cmtp/ipv6/ipv6-route/ipv6-frag/idrp/rsvp/gre/esp/ah/skip/ipv6-icmp/ ipv6-nonxt/ipv6-opts/rspf/vmtp/ospf/ipip/encap/pim/raw \(This protocol does not have the  **aliases**  attribute, that is,  **aliases**  is empty.\) 

**Returns:**

Returns the protocol information if the operation is successful; returns  **NULL**  otherwise. 



## getprotoent\(\)<a name="gaca0da70657afbc3e723990bb229deec3"></a>

```
struct protoent* getprotoent (void )
```

 **Description:**

Retrieves the current protocol information. 

**Attention:**

The  **/etc/protocols**  configuration file is not supported. Only the following built-in protocols are supported: ip/icmp/igmp/ggp/ipencap/st/tcp/egp/pup/udp/hmp/xns-idp/rdp/iso-tp4/xtp/ ddp/idpr-cmtp/ipv6/ipv6-route/ipv6-frag/idrp/rsvp/gre/esp/ah/skip/ipv6-icmp/ ipv6-nonxt/ipv6-opts/rspf/vmtp/ospf/ipip/encap/pim/raw \(This protocol does not have the  **aliases**  attribute, that is,  **aliases**  is empty.\) 

**Returns:**

Returns the protocol information if the operation is successful; returns  **NULL**  otherwise. 



## getsockname\(\)<a name="ga62577da7dba23abb9c99cf5c2800ab24"></a>

```
int getsockname (int fd, struct [sockaddr](sockaddr.md) *restrict addr, socklen_t *restrict len )
```

 **Description:**

Retrieves the local address of the specified socket. 

**Parameters:**

<a name="table1883573430084823"></a>
<table><thead align="left"><tr id="row861828025084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p641360247084823"><a name="p641360247084823"></a><a name="p641360247084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1570034585084823"><a name="p1570034585084823"></a><a name="p1570034585084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1941736497084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the socket descriptor. </td>
</tr>
<tr id="row484955514084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">addr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the address to be retrieved. </td>
</tr>
<tr id="row1630390018084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">len</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the length of the address pointed to by <strong id="b1191222825084823"><a name="b1191222825084823"></a><a name="b1191222825084823"></a>addr</strong>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1743279755084823"></a>
<table><thead align="left"><tr id="row764667844084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1656004833084823"><a name="p1656004833084823"></a><a name="p1656004833084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2131096942084823"><a name="p2131096942084823"></a><a name="p2131096942084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1896204772084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p380882446084823"><a name="p380882446084823"></a><a name="p380882446084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1767604721084823"><a name="p1767604721084823"></a><a name="p1767604721084823"></a>Invalid input parameter </p>
</td>
</tr>
<tr id="row2090530146084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p650514981084823"><a name="p650514981084823"></a><a name="p650514981084823"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1111667326084823"><a name="p1111667326084823"></a><a name="p1111667326084823"></a>Invalid socket or socket status exception </p>
</td>
</tr>
<tr id="row1237617411084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2114351313084823"><a name="p2114351313084823"></a><a name="p2114351313084823"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2006966362084823"><a name="p2006966362084823"></a><a name="p2006966362084823"></a>Memory copy exception </p>
</td>
</tr>
</tbody>
</table>

## getsockopt\(\)<a name="gacfcf672e255123afb75ed4d326257073"></a>

```
int getsockopt (int fd, int level, int optname, void *__restrict optval, socklen_t *__restrict optlen )
```

 **Description:**

Retrieves the socket options. 

**Parameters:**

<a name="table1225969578084823"></a>
<table><thead align="left"><tr id="row2073406695084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1678414043084823"><a name="p1678414043084823"></a><a name="p1678414043084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p637706286084823"><a name="p637706286084823"></a><a name="p637706286084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1661199333084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the socket descriptor. </td>
</tr>
<tr id="row892338765084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">level</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the protocol level at which the option resides. Only <a href="net.md#ga92d045f6ee2f343d6b28830a9fec082e">SOL_SOCKET</a> is supported. </td>
</tr>
<tr id="row2098060545084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">optname</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the socket options to be retrieved, which has the following values: </td>
</tr>
<tr id="row1232255231084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">optval</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the option data. </td>
</tr>
<tr id="row1378668498084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">optlen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the size of the buffer pointed to by <strong id="b1084915117084823"><a name="b1084915117084823"></a><a name="b1084915117084823"></a>optval</strong>. </td>
</tr>
</tbody>
</table>

<a name="table1386709580084823"></a>
<table><thead align="left"><tr id="row1270987243084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1423551238084823"><a name="p1423551238084823"></a><a name="p1423551238084823"></a>value </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1790588128084823"><a name="p1790588128084823"></a><a name="p1790588128084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1922410954084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p728424243084823"><a name="p728424243084823"></a><a name="p728424243084823"></a>SO_BROADCAST </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p457094588084823"><a name="p457094588084823"></a><a name="p457094588084823"></a>Permits sending broadcast messages. </p>
</td>
</tr>
<tr id="row42210675084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1993850847084823"><a name="p1993850847084823"></a><a name="p1993850847084823"></a>SO_RCVTIMEO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2051723614084823"><a name="p2051723614084823"></a><a name="p2051723614084823"></a>Receiving data times out. </p>
</td>
</tr>
<tr id="row427969252084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1375891976084823"><a name="p1375891976084823"></a><a name="p1375891976084823"></a>SO_RCVBUF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p663086364084823"><a name="p663086364084823"></a><a name="p663086364084823"></a>Sets or gets the maximum socket receiving buffer in bytes. </p>
</td>
</tr>
<tr id="row337511287084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p277472213084823"><a name="p277472213084823"></a><a name="p277472213084823"></a>SO_TYPE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1525940346084823"><a name="p1525940346084823"></a><a name="p1525940346084823"></a>Gets the socket type. </p>
</td>
</tr>
<tr id="row1863599406084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p369845599084823"><a name="p369845599084823"></a><a name="p369845599084823"></a>SO_DONTROUTE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1723525764084823"><a name="p1723525764084823"></a><a name="p1723525764084823"></a>Prohibits messages from being sent via a gateway. </p>
</td>
</tr>
<tr id="row352867889084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1459721935084823"><a name="p1459721935084823"></a><a name="p1459721935084823"></a>SO_BINDTODEVICE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p172749770084823"><a name="p172749770084823"></a><a name="p172749770084823"></a>Binds this socket to a particular device. </p>
</td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1308116527084823"></a>
<table><thead align="left"><tr id="row2000950584084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1193869717084823"><a name="p1193869717084823"></a><a name="p1193869717084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p186614159084823"><a name="p186614159084823"></a><a name="p186614159084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row45621270084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1495501760084823"><a name="p1495501760084823"></a><a name="p1495501760084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p329710601084823"><a name="p329710601084823"></a><a name="p329710601084823"></a>Small <strong id="b211437403084823"><a name="b211437403084823"></a><a name="b211437403084823"></a>optlen</strong> </p>
</td>
</tr>
<tr id="row1323515623084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p429324251084823"><a name="p429324251084823"></a><a name="p429324251084823"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p208988945084823"><a name="p208988945084823"></a><a name="p208988945084823"></a>Invalid socket or socket status exception </p>
</td>
</tr>
<tr id="row723965395084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1179506439084823"><a name="p1179506439084823"></a><a name="p1179506439084823"></a>EFAULT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1470735365084823"><a name="p1470735365084823"></a><a name="p1470735365084823"></a>The input parameter is a null pointer. </p>
</td>
</tr>
<tr id="row133509397084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1453237817084823"><a name="p1453237817084823"></a><a name="p1453237817084823"></a>ENOBUFS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p62817107084823"><a name="p62817107084823"></a><a name="p62817107084823"></a>Retrieved length exception </p>
</td>
</tr>
<tr id="row676204255084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1714098176084823"><a name="p1714098176084823"></a><a name="p1714098176084823"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1478472875084823"><a name="p1478472875084823"></a><a name="p1478472875084823"></a>Memory copy exception </p>
</td>
</tr>
</tbody>
</table>

## herror\(\)<a name="gaa68de2578d4e0849f82d70b2f5b9af70"></a>

```
void herror (const char * msg)
```

 **Description:**

Prints error information. 

**Parameters:**

<a name="table1098599835084823"></a>
<table><thead align="left"><tr id="row97930123084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1643049107084823"><a name="p1643049107084823"></a><a name="p1643049107084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2139019972084823"><a name="p2139019972084823"></a><a name="p2139019972084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row850849804084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">msg</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string to be printed together with the error information. This parameter can be null. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table2078080747084823"></a>
<table><thead align="left"><tr id="row744741456084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p346540472084823"><a name="p346540472084823"></a><a name="p346540472084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p415931069084823"><a name="p415931069084823"></a><a name="p415931069084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row528203365084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p848515815084823"><a name="p848515815084823"></a><a name="p848515815084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2145250195084823"><a name="p2145250195084823"></a><a name="p2145250195084823"></a>Incorrect symbols or parameters </p>
</td>
</tr>
<tr id="row977816464084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1432834897084823"><a name="p1432834897084823"></a><a name="p1432834897084823"></a>EOVERFLOW </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p112747058084823"><a name="p112747058084823"></a><a name="p112747058084823"></a>Long item for printing </p>
</td>
</tr>
</tbody>
</table>

## hstrerror\(\)<a name="gac1752c48d9cf2ff87e29f29df6caa585"></a>

```
const char* hstrerror (int ecode)
```

 **Description:**

Retrieves error information associated with the specified error number. 

**Parameters:**

<a name="table1730787945084823"></a>
<table><thead align="left"><tr id="row412661491084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p475614638084823"><a name="p475614638084823"></a><a name="p475614638084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p835810698084823"><a name="p835810698084823"></a><a name="p835810698084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row720975221084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ecode</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the error number. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the string representing the error information. 



## htonl\(\)<a name="gac7eed08cd3b67f42bf56063157c8fd55"></a>

```
uint32_t htonl (uint32_t n)
```

 **Description:**

Converts an integer from the host byte order to the network byte order. 

**Parameters:**

<a name="table1031305207084823"></a>
<table><thead align="left"><tr id="row1440079419084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p153104345084823"><a name="p153104345084823"></a><a name="p153104345084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p910431910084823"><a name="p910431910084823"></a><a name="p910431910084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1022645866084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the integer in host byte order. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the original data if the system is in big-endian mode; returns the converted data otherwise. 



## htons\(\)<a name="gaabce0f8d453c3380e5b8a3d4947eb48c"></a>

```
uint16_t htons (uint16_t n)
```

 **Description:**

Converts a 16-bit integer from the host byte order to the network byte order. 

**Parameters:**

<a name="table2065105582084823"></a>
<table><thead align="left"><tr id="row1808404640084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2136296704084823"><a name="p2136296704084823"></a><a name="p2136296704084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2077050902084823"><a name="p2077050902084823"></a><a name="p2077050902084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row930057156084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the integer in host byte order. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the original data if the system is in big-endian mode; returns the converted data otherwise. 



## if\_freenameindex\(\)<a name="ga7fe55c04ac2116fa501338fdcb279cc9"></a>

```
void if_freenameindex (struct [if_nameindex](if_nameindex.md) * idx)
```

 **Description:**

Frees the network adapter information obtained by  [if\_nameindex](if_nameindex.md). 

**Parameters:**

<a name="table2057680155084823"></a>
<table><thead align="left"><tr id="row1965190918084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2051737805084823"><a name="p2051737805084823"></a><a name="p2051737805084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1238119272084823"><a name="p1238119272084823"></a><a name="p1238119272084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1838635054084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">idx</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the network adapter to be freed. </td>
</tr>
</tbody>
</table>

## inet\_addr\(\)<a name="ga617651ec952a1f4c9cbddbf78f4b2e2e"></a>

```
in_addr_t inet_addr (const char * p)
```

 **Description:**

Converts a string from the IPv4 numbers-and-dots notation to the binary data in network byte order. 

**Parameters:**

<a name="table395381799084823"></a>
<table><thead align="left"><tr id="row1829721625084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p731450631084823"><a name="p731450631084823"></a><a name="p731450631084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p37913182084823"><a name="p37913182084823"></a><a name="p37913182084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row938925970084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">p</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string to be converted. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the converted data if the operation is successful; returns  **-1**  otherwise. 



## inet\_aton\(\)<a name="ga26ee8e8e3949699a9c0e02ece272d370"></a>

```
int inet_aton (const char * s0, struct in_addr * dest )
```

 **Description:**

Converts an IP address from the string format to the 32-bit binary format in network byte order. 

**Parameters:**

<a name="table1602731446084823"></a>
<table><thead align="left"><tr id="row399736680084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p286012934084823"><a name="p286012934084823"></a><a name="p286012934084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p800344843084823"><a name="p800344843084823"></a><a name="p800344843084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1943883977084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s0</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the IP address to be converted. </td>
</tr>
<tr id="row1791642676084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dest</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the structure for conversion. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **1**  if the operation is successful; returns  **0**  otherwise. 



## inet\_lnaof\(\)<a name="ga1facb1380b7657ca9c72fb2633b60e3b"></a>

```
in_addr_t inet_lnaof (struct in_addr in)
```

 **Description:**

Converts an IP address into a host ID in host byte order without network bits. 

**Parameters:**

<a name="table774033878084823"></a>
<table><thead align="left"><tr id="row2121052250084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p410324413084823"><a name="p410324413084823"></a><a name="p410324413084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p855171767084823"><a name="p855171767084823"></a><a name="p855171767084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row897954521084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">in</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the network address structure. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the converted host address. 



## inet\_makeaddr\(\)<a name="gab28732d1d740597f53fb65a09d97800c"></a>

```
struct in_addr inet_makeaddr (in_addr_t n, in_addr_t h )
```

 **Description:**

Converts the network number and host address to the network address. 

**Parameters:**

<a name="table1634462340084823"></a>
<table><thead align="left"><tr id="row1082966079084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p346535731084823"><a name="p346535731084823"></a><a name="p346535731084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1927545299084823"><a name="p1927545299084823"></a><a name="p1927545299084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row546940565084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the network number. </td>
</tr>
<tr id="row1089395758084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">h</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the host address. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the converted network address. 



## inet\_netof\(\)<a name="ga3a96aa4e6abe8e6959ea63fe338174dd"></a>

```
in_addr_t inet_netof (struct in_addr in)
```

 **Description:**

Extracts the network number from the  **in\_addr**  structure and converts it to the host byte order. 

**Parameters:**

<a name="table84723215084823"></a>
<table><thead align="left"><tr id="row959296896084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p51623587084823"><a name="p51623587084823"></a><a name="p51623587084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1726098381084823"><a name="p1726098381084823"></a><a name="p1726098381084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row86045348084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">in</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the network address structure. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the converted network number. 



## inet\_network\(\)<a name="ga6f478437c4810fce89cf0e77d94181f8"></a>

```
in_addr_t inet_network (const char * p)
```

 **Description:**

Converts a string from the IPv4 numbers-and-dots notation to the binary data in host byte order. 

**Parameters:**

<a name="table79788016084823"></a>
<table><thead align="left"><tr id="row257407154084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p490143167084823"><a name="p490143167084823"></a><a name="p490143167084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1698866119084823"><a name="p1698866119084823"></a><a name="p1698866119084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2015648079084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">p</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string to be converted. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the converted data if the operation is successful; returns  **-1**  otherwise. 



## inet\_ntoa\(\)<a name="ga08b9fff487151e004d9862cbf34a51ad"></a>

```
char* inet_ntoa (struct in_addr in)
```

 **Description:**

Converts a network address to a string in dotted-decimal format. 

**Parameters:**

<a name="table1147438625084823"></a>
<table><thead align="left"><tr id="row1020417686084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1597252110084823"><a name="p1597252110084823"></a><a name="p1597252110084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1784922478084823"><a name="p1784922478084823"></a><a name="p1784922478084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2126892489084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">in</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the network address to be converted. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the string. 



## inet\_ntop\(\)<a name="gae9a2182ca3255f16723adeea14665b55"></a>

```
const char* inet_ntop (int af, const void *restrict a0, char *restrict s, socklen_t l )
```

 **Description:**

Converts a network address in the specified address family to a string. 

**Parameters:**

<a name="table1668955201084823"></a>
<table><thead align="left"><tr id="row1692276322084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1187774875084823"><a name="p1187774875084823"></a><a name="p1187774875084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p908834567084823"><a name="p908834567084823"></a><a name="p908834567084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1337264027084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">af</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the address family. Currently, only <strong id="b811955045084823"><a name="b811955045084823"></a><a name="b811955045084823"></a>AF_INET</strong> and <strong id="b824231380084823"><a name="b824231380084823"></a><a name="b824231380084823"></a>AF_INET6</strong> are supported. </td>
</tr>
<tr id="row1595287179084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">a0</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the data to be converted. </td>
</tr>
<tr id="row1093617940084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string to be converted. </td>
</tr>
<tr id="row541153434084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">l</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of the string to be converted. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the converted string if the operation is successful; returns  **NULL**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1917250454084823"></a>
<table><thead align="left"><tr id="row236582094084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p112226986084823"><a name="p112226986084823"></a><a name="p112226986084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1751532571084823"><a name="p1751532571084823"></a><a name="p1751532571084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1566998590084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1486345683084823"><a name="p1486345683084823"></a><a name="p1486345683084823"></a>ENOSPC </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p368548391084823"><a name="p368548391084823"></a><a name="p368548391084823"></a>Insufficient space for conversion </p>
</td>
</tr>
<tr id="row779508333084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1126422819084823"><a name="p1126422819084823"></a><a name="p1126422819084823"></a>EAFNOSUPPORT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1665481447084823"><a name="p1665481447084823"></a><a name="p1665481447084823"></a>Unsupported address family </p>
</td>
</tr>
</tbody>
</table>

## inet\_pton\(\)<a name="ga3f6e2b2dae98a409d77c6e3b0cebc04b"></a>

```
int inet_pton (int af, const char *__restrict s, void *__restrict a0 )
```

 **Description:**

Converts a string to a network address in the specified address family. 

**Parameters:**

<a name="table876633889084823"></a>
<table><thead align="left"><tr id="row677963574084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p745316743084823"><a name="p745316743084823"></a><a name="p745316743084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p107027145084823"><a name="p107027145084823"></a><a name="p107027145084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1349468179084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">af</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the address family. Currently, only <strong id="b1642124465084823"><a name="b1642124465084823"></a><a name="b1642124465084823"></a>AF_INET</strong> and <strong id="b1181342414084823"><a name="b1181342414084823"></a><a name="b1181342414084823"></a>AF_INET6</strong> are supported. </td>
</tr>
<tr id="row2019232020084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string to be converted. </td>
</tr>
<tr id="row1527222262084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">a0</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the converted data. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **1**  if the operation is successful; returns  **0**  if the input address family is invalid; returns  **-1**  if the operation fails. The error codes are set as follows: 

<a name="table972836634084823"></a>
<table><thead align="left"><tr id="row124011646084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p73348572084823"><a name="p73348572084823"></a><a name="p73348572084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p735866224084823"><a name="p735866224084823"></a><a name="p735866224084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1677782808084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2023440596084823"><a name="p2023440596084823"></a><a name="p2023440596084823"></a>EAFNOSUPPORT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p204837229084823"><a name="p204837229084823"></a><a name="p204837229084823"></a>Unsupported address family </p>
</td>
</tr>
</tbody>
</table>

## listen\(\)<a name="ga5989c21d05cb17caba26cef496a7beea"></a>

```
int listen (int sockfd, int backlog )
```

 **Description:**

Listens for network connections. 

**Parameters:**

<a name="table1866802063084823"></a>
<table><thead align="left"><tr id="row1655825864084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1923471041084823"><a name="p1923471041084823"></a><a name="p1923471041084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p737116627084823"><a name="p737116627084823"></a><a name="p737116627084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row184594625084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">sockfd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the socket descriptor. </td>
</tr>
<tr id="row1163700684084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">backlog</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the maximum length of the queue to accept incoming connection requests. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1279612609084823"></a>
<table><thead align="left"><tr id="row972888392084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p93440954084823"><a name="p93440954084823"></a><a name="p93440954084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p633113377084823"><a name="p633113377084823"></a><a name="p633113377084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1290767203084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2038771506084823"><a name="p2038771506084823"></a><a name="p2038771506084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1126909393084823"><a name="p1126909393084823"></a><a name="p1126909393084823"></a>Invalid input parameter </p>
</td>
</tr>
<tr id="row316215905084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p462483246084823"><a name="p462483246084823"></a><a name="p462483246084823"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p151625670084823"><a name="p151625670084823"></a><a name="p151625670084823"></a>Invalid socket or socket status exception </p>
</td>
</tr>
<tr id="row1258952350084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p137746405084823"><a name="p137746405084823"></a><a name="p137746405084823"></a>EIO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p278641451084823"><a name="p278641451084823"></a><a name="p278641451084823"></a>Incorrect connection type obtained based on the socket descriptor </p>
</td>
</tr>
</tbody>
</table>

## ntohl\(\)<a name="gae68530d41f32dfef707f20b2bbaa5a44"></a>

```
uint32_t ntohl (uint32_t n)
```

 **Description:**

Converts an integer from the network byte order to the host byte order. 

**Parameters:**

<a name="table284154520084823"></a>
<table><thead align="left"><tr id="row97124427084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p849941524084823"><a name="p849941524084823"></a><a name="p849941524084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p123596955084823"><a name="p123596955084823"></a><a name="p123596955084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1144785928084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the integer in network byte order. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the original data if the system is in big-endian mode; returns the converted data otherwise. 



## ntohs\(\)<a name="gaf8c87af507c59bd8fef112e5e35fe537"></a>

```
uint16_t ntohs (uint16_t n)
```

 **Description:**

Converts a 16-bit integer from the network byte order to the host byte order. 

**Parameters:**

<a name="table1665032713084823"></a>
<table><thead align="left"><tr id="row276832405084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p583881591084823"><a name="p583881591084823"></a><a name="p583881591084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1624678096084823"><a name="p1624678096084823"></a><a name="p1624678096084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row288620176084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the integer in network byte order. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the original data if the system is in big-endian mode; returns the converted data otherwise. 



## recv\(\)<a name="ga5d049263cd0e3206b93530e68dfd7403"></a>

```
ssize_t recv (int fd, void * buf, size_t len, int flags )
```

 **Description:**

Receives data from another socket. 

**Parameters:**

<a name="table1384083422084823"></a>
<table><thead align="left"><tr id="row1163876304084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p352840042084823"><a name="p352840042084823"></a><a name="p352840042084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1086023762084823"><a name="p1086023762084823"></a><a name="p1086023762084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row615477316084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the socket descriptor. </td>
</tr>
<tr id="row3737771084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">buf</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to a buffer for storing the data to be received. </td>
</tr>
<tr id="row1972974549084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">len</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the buffer pointed to by <strong id="b2004775660084823"><a name="b2004775660084823"></a><a name="b2004775660084823"></a>buf</strong>. </td>
</tr>
<tr id="row1782714043084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">flags</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the socket flags. This parameter has the following values: </td>
</tr>
</tbody>
</table>

<a name="table1302669529084823"></a>
<table><thead align="left"><tr id="row91289597084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2137452185084823"><a name="p2137452185084823"></a><a name="p2137452185084823"></a>value </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1943327084823"><a name="p1943327084823"></a><a name="p1943327084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row604178675084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1038433826084823"><a name="p1038433826084823"></a><a name="p1038433826084823"></a>MSG_DONTWAIT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p830671449084823"><a name="p830671449084823"></a><a name="p830671449084823"></a>Enables the non-blocking operation. </p>
</td>
</tr>
<tr id="row612026160084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1984247144084823"><a name="p1984247144084823"></a><a name="p1984247144084823"></a>MSG_MORE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p236668915084823"><a name="p236668915084823"></a><a name="p236668915084823"></a>The caller has more data to send. </p>
</td>
</tr>
<tr id="row1406106894084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2138572527084823"><a name="p2138572527084823"></a><a name="p2138572527084823"></a>MSG_NOSIGNAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1007842752084823"><a name="p1007842752084823"></a><a name="p1007842752084823"></a>No signals are generated. </p>
</td>
</tr>
</tbody>
</table>

**Returns:**

Returns the length of the received data if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table816103738084823"></a>
<table><thead align="left"><tr id="row1500899255084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2029456818084823"><a name="p2029456818084823"></a><a name="p2029456818084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1156605528084823"><a name="p1156605528084823"></a><a name="p1156605528084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row34585517084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p305660795084823"><a name="p305660795084823"></a><a name="p305660795084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1562829618084823"><a name="p1562829618084823"></a><a name="p1562829618084823"></a>Invalid input parameter </p>
</td>
</tr>
<tr id="row1817779288084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1921141584084823"><a name="p1921141584084823"></a><a name="p1921141584084823"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1101786070084823"><a name="p1101786070084823"></a><a name="p1101786070084823"></a>Invalid socket or socket status exception </p>
</td>
</tr>
<tr id="row2041841871084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1623262131084823"><a name="p1623262131084823"></a><a name="p1623262131084823"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p751989224084823"><a name="p751989224084823"></a><a name="p751989224084823"></a>Memory copy exception </p>
</td>
</tr>
<tr id="row1666259970084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2128685742084823"><a name="p2128685742084823"></a><a name="p2128685742084823"></a>EOPNOTSUPP </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p991468943084823"><a name="p991468943084823"></a><a name="p991468943084823"></a>Unsupported message type </p>
</td>
</tr>
<tr id="row103756202084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p223838112084823"><a name="p223838112084823"></a><a name="p223838112084823"></a>ENOTCONN </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1957682559084823"><a name="p1957682559084823"></a><a name="p1957682559084823"></a>Socket not connected </p>
</td>
</tr>
<tr id="row29796804084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1505041602084823"><a name="p1505041602084823"></a><a name="p1505041602084823"></a>EWOULDBLOCK </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1058879245084823"><a name="p1058879245084823"></a><a name="p1058879245084823"></a>Blocking operation </p>
</td>
</tr>
<tr id="row543654747084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1278033875084823"><a name="p1278033875084823"></a><a name="p1278033875084823"></a>ENOTCONN </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p154883289084823"><a name="p154883289084823"></a><a name="p154883289084823"></a>Connection closed </p>
</td>
</tr>
</tbody>
</table>

## recvfrom\(\)<a name="ga3089d3ee59e26bd4def3ef870175540e"></a>

```
ssize_t recvfrom (int fd, void *__restrict buf, size_t len, int flags, struct [sockaddr](sockaddr.md) *__restrict addr, socklen_t *__restrict alen )
```

 **Description:**

Receives data from a specified socket. 

**Parameters:**

<a name="table1355344020084823"></a>
<table><thead align="left"><tr id="row1319404319084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1622932049084823"><a name="p1622932049084823"></a><a name="p1622932049084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p398277718084823"><a name="p398277718084823"></a><a name="p398277718084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1962548363084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the socket descriptor. </td>
</tr>
<tr id="row1786370429084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">buf</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to a buffer for storing the data to be received. </td>
</tr>
<tr id="row1778602904084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">len</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the buffer pointed to by <strong id="b1780116678084823"><a name="b1780116678084823"></a><a name="b1780116678084823"></a>buf</strong>. </td>
</tr>
<tr id="row1648359073084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">flags</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the socket flags. This parameter has the following values: </td>
</tr>
<tr id="row1537786393084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">addr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the source address. </td>
</tr>
<tr id="row1755426118084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">alen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of the source address. </td>
</tr>
</tbody>
</table>

<a name="table512238583084823"></a>
<table><thead align="left"><tr id="row56305463084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p436118917084823"><a name="p436118917084823"></a><a name="p436118917084823"></a>value </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p65628955084823"><a name="p65628955084823"></a><a name="p65628955084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1929038031084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1822520146084823"><a name="p1822520146084823"></a><a name="p1822520146084823"></a>MSG_DONTWAIT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1839807378084823"><a name="p1839807378084823"></a><a name="p1839807378084823"></a>Enables the non-blocking operation. </p>
</td>
</tr>
<tr id="row1606252319084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1247180998084823"><a name="p1247180998084823"></a><a name="p1247180998084823"></a>MSG_MORE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p147767086084823"><a name="p147767086084823"></a><a name="p147767086084823"></a>The caller has more data to send. </p>
</td>
</tr>
<tr id="row257521351084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p887055788084823"><a name="p887055788084823"></a><a name="p887055788084823"></a>MSG_NOSIGNAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1602170031084823"><a name="p1602170031084823"></a><a name="p1602170031084823"></a>No signals are generated. </p>
</td>
</tr>
</tbody>
</table>

**Returns:**

Returns the length of the received data if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table151655079084823"></a>
<table><thead align="left"><tr id="row29248982084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2062467396084823"><a name="p2062467396084823"></a><a name="p2062467396084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p476316748084823"><a name="p476316748084823"></a><a name="p476316748084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row2061936245084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p921908893084823"><a name="p921908893084823"></a><a name="p921908893084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p261883851084823"><a name="p261883851084823"></a><a name="p261883851084823"></a>Invalid input parameter </p>
</td>
</tr>
<tr id="row1189373742084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1451472332084823"><a name="p1451472332084823"></a><a name="p1451472332084823"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2085536536084823"><a name="p2085536536084823"></a><a name="p2085536536084823"></a>Invalid socket or socket status exception </p>
</td>
</tr>
<tr id="row579626042084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p518839001084823"><a name="p518839001084823"></a><a name="p518839001084823"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p959502114084823"><a name="p959502114084823"></a><a name="p959502114084823"></a>Memory copy exception </p>
</td>
</tr>
<tr id="row414320888084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1596788201084823"><a name="p1596788201084823"></a><a name="p1596788201084823"></a>EOPNOTSUPP </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p996919876084823"><a name="p996919876084823"></a><a name="p996919876084823"></a>Unsupported message type </p>
</td>
</tr>
<tr id="row2083732591084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p146695039084823"><a name="p146695039084823"></a><a name="p146695039084823"></a>ENOTCONN </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1875517114084823"><a name="p1875517114084823"></a><a name="p1875517114084823"></a>Socket not connected </p>
</td>
</tr>
<tr id="row348832648084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1648065503084823"><a name="p1648065503084823"></a><a name="p1648065503084823"></a>ENOTCONN </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p340886670084823"><a name="p340886670084823"></a><a name="p340886670084823"></a>Connection closed </p>
</td>
</tr>
</tbody>
</table>

## recvmsg\(\)<a name="gaaba92f19a31c01b93e3391671a8b3dd5"></a>

```
ssize_t recvmsg (int fd, struct msghdr * msg, int flags )
```

 **Description:**

Receives data from a specified socket. 

**Parameters:**

<a name="table648875310084823"></a>
<table><thead align="left"><tr id="row401475206084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1051162356084823"><a name="p1051162356084823"></a><a name="p1051162356084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2070571511084823"><a name="p2070571511084823"></a><a name="p2070571511084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1984314152084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the socket descriptor. </td>
</tr>
<tr id="row264958519084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">msg</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the address to receive the message header. </td>
</tr>
<tr id="row1973671320084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">flags</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the socket flags. This parameter has the following values: </td>
</tr>
</tbody>
</table>

<a name="table1465742647084823"></a>
<table><thead align="left"><tr id="row798953573084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p918537835084823"><a name="p918537835084823"></a><a name="p918537835084823"></a>value </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1760117350084823"><a name="p1760117350084823"></a><a name="p1760117350084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row780251846084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1188221482084823"><a name="p1188221482084823"></a><a name="p1188221482084823"></a>MSG_DONTWAIT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p987141471084823"><a name="p987141471084823"></a><a name="p987141471084823"></a>Enables the non-blocking operation. </p>
</td>
</tr>
<tr id="row117276719084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1676852946084823"><a name="p1676852946084823"></a><a name="p1676852946084823"></a>MSG_MORE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p562460877084823"><a name="p562460877084823"></a><a name="p562460877084823"></a>The caller has more data to send. </p>
</td>
</tr>
<tr id="row652623572084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p527424179084823"><a name="p527424179084823"></a><a name="p527424179084823"></a>MSG_NOSIGNAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p475758385084823"><a name="p475758385084823"></a><a name="p475758385084823"></a>No signals are generated. </p>
</td>
</tr>
</tbody>
</table>

**Attention:**

This function does not allow sending ancillary data. Currently, the length of the array defined by  **msg\_iov**  can only be  **1**. 

**Returns:**

Returns the length of the received data if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table532416124084823"></a>
<table><thead align="left"><tr id="row862818298084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1823459342084823"><a name="p1823459342084823"></a><a name="p1823459342084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1567765943084823"><a name="p1567765943084823"></a><a name="p1567765943084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row2055403192084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p40365758084823"><a name="p40365758084823"></a><a name="p40365758084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1669692814084823"><a name="p1669692814084823"></a><a name="p1669692814084823"></a>Invalid input parameter </p>
</td>
</tr>
<tr id="row860287692084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p735425770084823"><a name="p735425770084823"></a><a name="p735425770084823"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1738366564084823"><a name="p1738366564084823"></a><a name="p1738366564084823"></a>Invalid socket or socket status exception </p>
</td>
</tr>
<tr id="row83252755084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1246498422084823"><a name="p1246498422084823"></a><a name="p1246498422084823"></a>EDESTADDRREQ </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1819975022084823"><a name="p1819975022084823"></a><a name="p1819975022084823"></a>Invalid connection </p>
</td>
</tr>
<tr id="row1365443800084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1286076022084823"><a name="p1286076022084823"></a><a name="p1286076022084823"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p996037119084823"><a name="p996037119084823"></a><a name="p996037119084823"></a>Memory copy exception </p>
</td>
</tr>
<tr id="row1086994017084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p746229764084823"><a name="p746229764084823"></a><a name="p746229764084823"></a>EIO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1329183123084823"><a name="p1329183123084823"></a><a name="p1329183123084823"></a>Incorrect connection type obtained based on the socket descriptor </p>
</td>
</tr>
</tbody>
</table>

## send\(\)<a name="ga4053f5c8e26fd490ef54e2a0abf5c89f"></a>

```
ssize_t send (int fd, const void * buf, size_t len, int flags )
```

 **Description:**

Sends data to another socket. 

**Parameters:**

<a name="table775194560084823"></a>
<table><thead align="left"><tr id="row313975403084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p79857724084823"><a name="p79857724084823"></a><a name="p79857724084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1466918099084823"><a name="p1466918099084823"></a><a name="p1466918099084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1646582446084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the socket descriptor. </td>
</tr>
<tr id="row1300296760084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">buf</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to a buffer for storing the data to be sent. </td>
</tr>
<tr id="row923953487084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">len</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the buffer pointed to by <strong id="b1791530870084823"><a name="b1791530870084823"></a><a name="b1791530870084823"></a>buf</strong>. </td>
</tr>
<tr id="row1910619424084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">flags</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the socket flags. This parameter has the following values: </td>
</tr>
</tbody>
</table>

<a name="table365798411084823"></a>
<table><thead align="left"><tr id="row66600780084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p917919754084823"><a name="p917919754084823"></a><a name="p917919754084823"></a>value </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1629773578084823"><a name="p1629773578084823"></a><a name="p1629773578084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row623905464084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p843326383084823"><a name="p843326383084823"></a><a name="p843326383084823"></a>MSG_DONTWAIT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p736760687084823"><a name="p736760687084823"></a><a name="p736760687084823"></a>Enables the non-blocking operation. </p>
</td>
</tr>
<tr id="row87888363084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1671948837084823"><a name="p1671948837084823"></a><a name="p1671948837084823"></a>MSG_MORE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1099191405084823"><a name="p1099191405084823"></a><a name="p1099191405084823"></a>The caller has more data to send. </p>
</td>
</tr>
<tr id="row463441084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1814151195084823"><a name="p1814151195084823"></a><a name="p1814151195084823"></a>MSG_NOSIGNAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p462998687084823"><a name="p462998687084823"></a><a name="p462998687084823"></a>No signals are generated. </p>
</td>
</tr>
</tbody>
</table>

**Returns:**

Returns the length of the sent data if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1579190236084823"></a>
<table><thead align="left"><tr id="row1942091784084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p218588738084823"><a name="p218588738084823"></a><a name="p218588738084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p411014553084823"><a name="p411014553084823"></a><a name="p411014553084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1057452988084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p329872793084823"><a name="p329872793084823"></a><a name="p329872793084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1257927741084823"><a name="p1257927741084823"></a><a name="p1257927741084823"></a>Invalid input parameter </p>
</td>
</tr>
<tr id="row1636907274084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2144628364084823"><a name="p2144628364084823"></a><a name="p2144628364084823"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1756250114084823"><a name="p1756250114084823"></a><a name="p1756250114084823"></a>Invalid socket or socket status exception </p>
</td>
</tr>
<tr id="row1268183035084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1332128714084823"><a name="p1332128714084823"></a><a name="p1332128714084823"></a>EDESTADDRREQ </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1475478107084823"><a name="p1475478107084823"></a><a name="p1475478107084823"></a>Invalid connection </p>
</td>
</tr>
<tr id="row481660221084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p952786110084823"><a name="p952786110084823"></a><a name="p952786110084823"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p936815030084823"><a name="p936815030084823"></a><a name="p936815030084823"></a>Memory copy exception </p>
</td>
</tr>
<tr id="row612750376084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p174745111084823"><a name="p174745111084823"></a><a name="p174745111084823"></a>EOPNOTSUPP </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1404629058084823"><a name="p1404629058084823"></a><a name="p1404629058084823"></a>Unsupported message type </p>
</td>
</tr>
<tr id="row973270265084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1636784283084823"><a name="p1636784283084823"></a><a name="p1636784283084823"></a>ENOTCONN </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1692820309084823"><a name="p1692820309084823"></a><a name="p1692820309084823"></a>Socket not connected </p>
</td>
</tr>
<tr id="row1605519786084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1191463993084823"><a name="p1191463993084823"></a><a name="p1191463993084823"></a>EIO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p736429153084823"><a name="p736429153084823"></a><a name="p736429153084823"></a>Incorrect connection type obtained based on the socket descriptor </p>
</td>
</tr>
</tbody>
</table>

## sendmsg\(\)<a name="ga70c97d3a1eab72cba4461d66a1778570"></a>

```
ssize_t sendmsg (int fd, const struct msghdr * msg, int flags )
```

 **Description:**

Sends data to another socket. 

**Parameters:**

<a name="table737641439084823"></a>
<table><thead align="left"><tr id="row350035034084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p409738972084823"><a name="p409738972084823"></a><a name="p409738972084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p891121321084823"><a name="p891121321084823"></a><a name="p891121321084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row780312861084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the socket descriptor. </td>
</tr>
<tr id="row1774613777084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">msg</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the address of the message header to be sent. </td>
</tr>
<tr id="row1828204158084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">flags</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the socket flags. This parameter has the following values: </td>
</tr>
</tbody>
</table>

<a name="table1054430512084823"></a>
<table><thead align="left"><tr id="row1119056136084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1478155124084823"><a name="p1478155124084823"></a><a name="p1478155124084823"></a>value </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p785904435084823"><a name="p785904435084823"></a><a name="p785904435084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1772173515084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p451087410084823"><a name="p451087410084823"></a><a name="p451087410084823"></a>MSG_DONTWAIT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1357820356084823"><a name="p1357820356084823"></a><a name="p1357820356084823"></a>Enables the non-blocking operation. </p>
</td>
</tr>
<tr id="row1037337379084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p804326123084823"><a name="p804326123084823"></a><a name="p804326123084823"></a>MSG_MORE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1007242175084823"><a name="p1007242175084823"></a><a name="p1007242175084823"></a>The caller has more data to send. </p>
</td>
</tr>
<tr id="row221686966084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1459107834084823"><a name="p1459107834084823"></a><a name="p1459107834084823"></a>MSG_NOSIGNAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1175087172084823"><a name="p1175087172084823"></a><a name="p1175087172084823"></a>No signals are generated. </p>
</td>
</tr>
</tbody>
</table>

**Attention:**

This function does not support ancillary data. 

**Returns:**

Returns the length of the sent data if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1122374645084823"></a>
<table><thead align="left"><tr id="row1981470304084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1147920678084823"><a name="p1147920678084823"></a><a name="p1147920678084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1055898280084823"><a name="p1055898280084823"></a><a name="p1055898280084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1318383575084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p412801910084823"><a name="p412801910084823"></a><a name="p412801910084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1319355679084823"><a name="p1319355679084823"></a><a name="p1319355679084823"></a>Invalid input parameter </p>
</td>
</tr>
<tr id="row503995057084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p607083616084823"><a name="p607083616084823"></a><a name="p607083616084823"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1547720412084823"><a name="p1547720412084823"></a><a name="p1547720412084823"></a>Invalid socket or socket status exception </p>
</td>
</tr>
<tr id="row1433702507084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p144047093084823"><a name="p144047093084823"></a><a name="p144047093084823"></a>EDESTADDRREQ </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1446127912084823"><a name="p1446127912084823"></a><a name="p1446127912084823"></a>Invalid connection </p>
</td>
</tr>
<tr id="row726508079084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1992580812084823"><a name="p1992580812084823"></a><a name="p1992580812084823"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1267064552084823"><a name="p1267064552084823"></a><a name="p1267064552084823"></a>Memory copy exception </p>
</td>
</tr>
<tr id="row1827190567084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1756727829084823"><a name="p1756727829084823"></a><a name="p1756727829084823"></a>EIO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1593228413084823"><a name="p1593228413084823"></a><a name="p1593228413084823"></a>Incorrect connection type obtained based on the socket descriptor </p>
</td>
</tr>
<tr id="row318008328084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p513954176084823"><a name="p513954176084823"></a><a name="p513954176084823"></a>EOPNOTSUPP </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p457985436084823"><a name="p457985436084823"></a><a name="p457985436084823"></a>Unsupported message type </p>
</td>
</tr>
</tbody>
</table>

## sendto\(\)<a name="ga2587b27d2c6014c6b568a974655f41c5"></a>

```
ssize_t sendto (int fd, const void * buf, size_t len, int flags, const struct [sockaddr](sockaddr.md) * addr, socklen_t alen )
```

 **Description:**

Sends data to another socket. 

**Parameters:**

<a name="table560795651084823"></a>
<table><thead align="left"><tr id="row1709866859084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p863717138084823"><a name="p863717138084823"></a><a name="p863717138084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1010540763084823"><a name="p1010540763084823"></a><a name="p1010540763084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1516871689084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the socket descriptor. </td>
</tr>
<tr id="row2135522025084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">buf</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to a buffer for storing the data to be sent. </td>
</tr>
<tr id="row2023268723084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">len</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the buffer pointed to by <strong id="b2063824771084823"><a name="b2063824771084823"></a><a name="b2063824771084823"></a>buf</strong>. </td>
</tr>
<tr id="row159267714084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">flags</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the socket flags. This parameter has the following values: </td>
</tr>
<tr id="row157978790084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">addr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the destination network address. </td>
</tr>
<tr id="row463899146084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">alen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the destination network address. </td>
</tr>
</tbody>
</table>

<a name="table513563199084823"></a>
<table><thead align="left"><tr id="row1466929067084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p225908342084823"><a name="p225908342084823"></a><a name="p225908342084823"></a>value </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p170792468084823"><a name="p170792468084823"></a><a name="p170792468084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1525658608084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1681693426084823"><a name="p1681693426084823"></a><a name="p1681693426084823"></a>MSG_DONTWAIT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p676900467084823"><a name="p676900467084823"></a><a name="p676900467084823"></a>Enables the non-blocking operation. </p>
</td>
</tr>
<tr id="row464326873084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1490178069084823"><a name="p1490178069084823"></a><a name="p1490178069084823"></a>MSG_MORE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p243473302084823"><a name="p243473302084823"></a><a name="p243473302084823"></a>The caller has more data to send. </p>
</td>
</tr>
<tr id="row368789427084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1724685453084823"><a name="p1724685453084823"></a><a name="p1724685453084823"></a>MSG_NOSIGNAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1797894348084823"><a name="p1797894348084823"></a><a name="p1797894348084823"></a>No signals are generated. </p>
</td>
</tr>
</tbody>
</table>

**Returns:**

Returns the length of the sent data if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table884746782084823"></a>
<table><thead align="left"><tr id="row1140366775084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p916945850084823"><a name="p916945850084823"></a><a name="p916945850084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p994457685084823"><a name="p994457685084823"></a><a name="p994457685084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row552704482084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p327598804084823"><a name="p327598804084823"></a><a name="p327598804084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p502903540084823"><a name="p502903540084823"></a><a name="p502903540084823"></a>Invalid input parameter </p>
</td>
</tr>
<tr id="row4467678084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1359322460084823"><a name="p1359322460084823"></a><a name="p1359322460084823"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1952322700084823"><a name="p1952322700084823"></a><a name="p1952322700084823"></a>Invalid socket or socket status exception </p>
</td>
</tr>
<tr id="row1641108362084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1920322968084823"><a name="p1920322968084823"></a><a name="p1920322968084823"></a>EDESTADDRREQ </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1484363329084823"><a name="p1484363329084823"></a><a name="p1484363329084823"></a>Invalid connection </p>
</td>
</tr>
<tr id="row816810034084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1240930781084823"><a name="p1240930781084823"></a><a name="p1240930781084823"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2060269071084823"><a name="p2060269071084823"></a><a name="p2060269071084823"></a>Memory copy exception </p>
</td>
</tr>
<tr id="row192673160084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1124741629084823"><a name="p1124741629084823"></a><a name="p1124741629084823"></a>EOPNOTSUPP </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1131599810084823"><a name="p1131599810084823"></a><a name="p1131599810084823"></a>Unsupported message type </p>
</td>
</tr>
<tr id="row839950685084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1271288903084823"><a name="p1271288903084823"></a><a name="p1271288903084823"></a>ENOTCONN </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1706069384084823"><a name="p1706069384084823"></a><a name="p1706069384084823"></a>Socket not connected </p>
</td>
</tr>
<tr id="row963753011084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p541995692084823"><a name="p541995692084823"></a><a name="p541995692084823"></a>EIO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1011496646084823"><a name="p1011496646084823"></a><a name="p1011496646084823"></a>Incorrect connection type obtained based on the socket descriptor </p>
</td>
</tr>
</tbody>
</table>

## setprotoent\(\)<a name="ga6a806414e4ae5bffb09e3a1d25d8db75"></a>

```
void setprotoent (int stayopen)
```

 **Description:**

Opens a connection to the database and sets the next entry to the first entry. 

**Parameters:**

<a name="table1103693731084823"></a>
<table><thead align="left"><tr id="row430771729084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1322024849084823"><a name="p1322024849084823"></a><a name="p1322024849084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1351099798084823"><a name="p1351099798084823"></a><a name="p1351099798084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1847017149084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stayopen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Reserved for interface compatibility (not used currently). </td>
</tr>
</tbody>
</table>

**Attention:**

The  **stayopen**  parameter does not take effect. It is equivalent to nonzero for  [getprotoent](net.md#gaca0da70657afbc3e723990bb229deec3)  and zero for  [getprotobyname](net.md#ga83ac8a97dd9d895cda658af3aa46fd55)  and  **getprotobynumbmer**. 



## setsockopt\(\)<a name="ga81983de50d79d797b2ac0f0d0f28953f"></a>

```
int setsockopt (int fd, int level, int optname, const void * optval, socklen_t optlen )
```

 **Description:**

Sets the socket options. 

**Parameters:**

<a name="table1593604822084823"></a>
<table><thead align="left"><tr id="row726508668084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2027903055084823"><a name="p2027903055084823"></a><a name="p2027903055084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1583665250084823"><a name="p1583665250084823"></a><a name="p1583665250084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1527903557084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the socket descriptor. </td>
</tr>
<tr id="row561969216084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">level</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the protocol level at which the option resides. Only <a href="net.md#ga92d045f6ee2f343d6b28830a9fec082e">SOL_SOCKET</a> is supported. </td>
</tr>
<tr id="row444237919084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">optname</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the socket options to set, which has the following values: </td>
</tr>
<tr id="row1067282564084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">optval</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the option data. </td>
</tr>
<tr id="row2070432915084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">optlen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of the buffer pointed to by <strong id="b2004498925084823"><a name="b2004498925084823"></a><a name="b2004498925084823"></a>optval</strong>. </td>
</tr>
</tbody>
</table>

<a name="table1607662015084823"></a>
<table><thead align="left"><tr id="row235443084084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p229193362084823"><a name="p229193362084823"></a><a name="p229193362084823"></a>value </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p620209141084823"><a name="p620209141084823"></a><a name="p620209141084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1501392711084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1347434284084823"><a name="p1347434284084823"></a><a name="p1347434284084823"></a>SO_BROADCAST </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1020057416084823"><a name="p1020057416084823"></a><a name="p1020057416084823"></a>Permits sending broadcast messages. </p>
</td>
</tr>
<tr id="row728421701084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p794798952084823"><a name="p794798952084823"></a><a name="p794798952084823"></a>SO_RCVTIMEO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1938914445084823"><a name="p1938914445084823"></a><a name="p1938914445084823"></a>Receiving data times out. </p>
</td>
</tr>
<tr id="row1144698986084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1307522589084823"><a name="p1307522589084823"></a><a name="p1307522589084823"></a>SO_RCVBUF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1727665959084823"><a name="p1727665959084823"></a><a name="p1727665959084823"></a>Sets or gets the maximum socket receiving buffer in bytes. </p>
</td>
</tr>
<tr id="row1973247278084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p897652198084823"><a name="p897652198084823"></a><a name="p897652198084823"></a>SO_DONTROUTE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1424788024084823"><a name="p1424788024084823"></a><a name="p1424788024084823"></a>Prohibits messages from being sent via a gateway. </p>
</td>
</tr>
<tr id="row2130639263084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p478111566084823"><a name="p478111566084823"></a><a name="p478111566084823"></a>SO_BINDTODEVICE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p949093138084823"><a name="p949093138084823"></a><a name="p949093138084823"></a>Binds this socket to a particular device. </p>
</td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1555393218084823"></a>
<table><thead align="left"><tr id="row815602092084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p457075375084823"><a name="p457075375084823"></a><a name="p457075375084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1193192064084823"><a name="p1193192064084823"></a><a name="p1193192064084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row914598168084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1173960600084823"><a name="p1173960600084823"></a><a name="p1173960600084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p228099251084823"><a name="p228099251084823"></a><a name="p228099251084823"></a>Small <strong id="b1859921318084823"><a name="b1859921318084823"></a><a name="b1859921318084823"></a>optlen</strong> </p>
</td>
</tr>
<tr id="row1860319567084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1808124713084823"><a name="p1808124713084823"></a><a name="p1808124713084823"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1969946626084823"><a name="p1969946626084823"></a><a name="p1969946626084823"></a>Invalid socket or socket status exception </p>
</td>
</tr>
<tr id="row208691854084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1503844609084823"><a name="p1503844609084823"></a><a name="p1503844609084823"></a>EFAULT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p654504611084823"><a name="p654504611084823"></a><a name="p654504611084823"></a>The input parameter is a null pointer. </p>
</td>
</tr>
<tr id="row1470691719084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p217200555084823"><a name="p217200555084823"></a><a name="p217200555084823"></a>ENOBUFS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1480014926084823"><a name="p1480014926084823"></a><a name="p1480014926084823"></a>Retrieved length exception </p>
</td>
</tr>
<tr id="row1112184819084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p300213916084823"><a name="p300213916084823"></a><a name="p300213916084823"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p421277630084823"><a name="p421277630084823"></a><a name="p421277630084823"></a>Memory copy exception </p>
</td>
</tr>
</tbody>
</table>

## shutdown\(\)<a name="ga402425b8e1ceab40ac38a949babcf1aa"></a>

```
int shutdown (int sockfd, int how )
```

 **Description:**

Shuts down a socket. 

**Parameters:**

<a name="table1380759123084823"></a>
<table><thead align="left"><tr id="row2025717216084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1863158709084823"><a name="p1863158709084823"></a><a name="p1863158709084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p215159424084823"><a name="p215159424084823"></a><a name="p215159424084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row895862934084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">sockfd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the socket descriptor. </td>
</tr>
<tr id="row1732529000084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">how</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates how to shut down the socket. You can disable either receptions by <strong id="b1973177948084823"><a name="b1973177948084823"></a><a name="b1973177948084823"></a>SHUT_RD</strong> or transmissions by <strong id="b1244742768084823"><a name="b1244742768084823"></a><a name="b1244742768084823"></a>SHUT_WR</strong>, or both by <strong id="b1340568696084823"><a name="b1340568696084823"></a><a name="b1340568696084823"></a>SHUT_RDWR</strong>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table205351645084823"></a>
<table><thead align="left"><tr id="row1843261736084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p309037107084823"><a name="p309037107084823"></a><a name="p309037107084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1649634997084823"><a name="p1649634997084823"></a><a name="p1649634997084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row424376795084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1995657207084823"><a name="p1995657207084823"></a><a name="p1995657207084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p156309129084823"><a name="p156309129084823"></a><a name="p156309129084823"></a>Invalid input parameter </p>
</td>
</tr>
<tr id="row2105450373084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p524667204084823"><a name="p524667204084823"></a><a name="p524667204084823"></a>ENOTCONN </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1841966198084823"><a name="p1841966198084823"></a><a name="p1841966198084823"></a>Socket not connected </p>
</td>
</tr>
<tr id="row1381384757084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p811790860084823"><a name="p811790860084823"></a><a name="p811790860084823"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p403083008084823"><a name="p403083008084823"></a><a name="p403083008084823"></a>Memory copy exception </p>
</td>
</tr>
<tr id="row1318100245084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1314885873084823"><a name="p1314885873084823"></a><a name="p1314885873084823"></a>EIO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p756520932084823"><a name="p756520932084823"></a><a name="p756520932084823"></a>Incorrect connection type obtained based on the socket descriptor </p>
</td>
</tr>
</tbody>
</table>

## socket\(\)<a name="gaf4e0711877c45a41168ac677b0670ccd"></a>

```
int socket (int domain, int type, int protocol )
```

 **Description:**

Creates a socket and returns its descriptor. 

**Parameters:**

<a name="table1174575720084823"></a>
<table><thead align="left"><tr id="row693173406084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p68987851084823"><a name="p68987851084823"></a><a name="p68987851084823"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p205165118084823"><a name="p205165118084823"></a><a name="p205165118084823"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row380428740084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">domain</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the socket domain. </td>
</tr>
<tr id="row1891742263084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">type</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the socket type. </td>
</tr>
<tr id="row1934315649084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">protocol</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the socket protocol. </td>
</tr>
</tbody>
</table>

**Attention:**

Only the following socket domains are supported:  **AF\_INET**,  **AF\_INET6**. Only the socket types  **SOCK\_RAW**,  **SOCK\_DGRAM**  and  **SOCK\_STREAM**  are supported, and the OR operation between the extra socket flag and the socket type is not supported. 

**Returns:**

Returns the descriptor for the new socket if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table2135276783084823"></a>
<table><thead align="left"><tr id="row767225229084823"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p85916433084823"><a name="p85916433084823"></a><a name="p85916433084823"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1178540684084823"><a name="p1178540684084823"></a><a name="p1178540684084823"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row740986349084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2074367511084823"><a name="p2074367511084823"></a><a name="p2074367511084823"></a>EAFNOSUPPORT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p281308060084823"><a name="p281308060084823"></a><a name="p281308060084823"></a>Invalid socket domain </p>
</td>
</tr>
<tr id="row1331225350084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1862857912084823"><a name="p1862857912084823"></a><a name="p1862857912084823"></a>ESOCKTNOSUPPORT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p559313948084823"><a name="p559313948084823"></a><a name="p559313948084823"></a>Unsupported socket domain </p>
</td>
</tr>
<tr id="row525864247084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1472660479084823"><a name="p1472660479084823"></a><a name="p1472660479084823"></a>EPROTONOSUPPORT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1074970073084823"><a name="p1074970073084823"></a><a name="p1074970073084823"></a>Unsupported protocol </p>
</td>
</tr>
<tr id="row388412961084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1361856284084823"><a name="p1361856284084823"></a><a name="p1361856284084823"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1524082623084823"><a name="p1524082623084823"></a><a name="p1524082623084823"></a>Invalid input parameter </p>
</td>
</tr>
<tr id="row1526417944084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p90040510084823"><a name="p90040510084823"></a><a name="p90040510084823"></a>ENOBUFS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p204277078084823"><a name="p204277078084823"></a><a name="p204277078084823"></a>Connection setup error </p>
</td>
</tr>
<tr id="row2056320679084823"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1529769463084823"><a name="p1529769463084823"></a><a name="p1529769463084823"></a>ENFILE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1766815940084823"><a name="p1766815940084823"></a><a name="p1766815940084823"></a>File table addition exception </p>
</td>
</tr>
</tbody>
</table>

