# OHOS::UIChartPillar<a name="EN-US_TOPIC_0000001055518112"></a>

## **Overview**<a name="section856906714093534"></a>

**Related Modules:**

[Graphic](graphic.md)

**Description:**

Provides special functions for implementing a bar chart. 

**Since:**

1.0

**Version:**

1.0

## **Summary**<a name="section1350245378093534"></a>

## Public Member Functions<a name="pub-methods"></a>

<a name="table1933225412093534"></a>
<table><thead align="left"><tr id="row1605950176093534"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2001519919093534"><a name="p2001519919093534"></a><a name="p2001519919093534"></a>Public Member Function Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p700308070093534"><a name="p700308070093534"></a><a name="p700308070093534"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row349756395093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p603369294093534"><a name="p603369294093534"></a><a name="p603369294093534"></a><a href="graphic.md#ga5c26ce24f640f795404c8375b4043186">UIChartPillar</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1445284016093534"><a name="p1445284016093534"></a><a name="p1445284016093534"></a> </p>
<p id="p841323318093534"><a name="p841323318093534"></a><a name="p841323318093534"></a>A constructor used to create a <strong id="b814503140093534"><a name="b814503140093534"></a><a name="b814503140093534"></a><a href="ohos-uichartpillar.md">UIChartPillar</a></strong> instance. </p>
</td>
</tr>
<tr id="row802167826093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p631814573093534"><a name="p631814573093534"></a><a name="p631814573093534"></a><a href="graphic.md#ga0f1e413e8eb026f2b5746b05b48d7ca7">~UIChartPillar</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1466630083093534"><a name="p1466630083093534"></a><a name="p1466630083093534"></a>virtual </p>
<p id="p1954298260093534"><a name="p1954298260093534"></a><a name="p1954298260093534"></a>A destructor used to delete the <strong id="b1657017971093534"><a name="b1657017971093534"></a><a name="b1657017971093534"></a><a href="ohos-uichartpillar.md">UIChartPillar</a></strong> instance. </p>
</td>
</tr>
<tr id="row1268999953093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2005890226093534"><a name="p2005890226093534"></a><a name="p2005890226093534"></a><a href="graphic.md#ga0c6028474577ce99caa6d3eafaef1573">RefreshChart</a> () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p961814465093534"><a name="p961814465093534"></a><a name="p961814465093534"></a>void </p>
<p id="p1396167818093534"><a name="p1396167818093534"></a><a name="p1396167818093534"></a>Refreshes a bar chart and redraws the dirty region. </p>
</td>
</tr>
<tr id="row212130834093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1127547350093534"><a name="p1127547350093534"></a><a name="p1127547350093534"></a><a href="graphic.md#ga3ab02ed367123e4f84e5ab145f5ed949">UIChart</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p167561578093534"><a name="p167561578093534"></a><a name="p167561578093534"></a> </p>
<p id="p1426231882093534"><a name="p1426231882093534"></a><a name="p1426231882093534"></a>A constructor used to create a <strong id="b1197615093534"><a name="b1197615093534"></a><a name="b1197615093534"></a><a href="ohos-uichart.md">UIChart</a></strong> instance. </p>
</td>
</tr>
<tr id="row1385082975093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p431880997093534"><a name="p431880997093534"></a><a name="p431880997093534"></a><a href="graphic.md#gab5d79c4736d822116dcdd7ed6e45294e">~UIChart</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p513921372093534"><a name="p513921372093534"></a><a name="p513921372093534"></a>virtual </p>
<p id="p1966984412093534"><a name="p1966984412093534"></a><a name="p1966984412093534"></a>A destructor used to delete the <strong id="b419059468093534"><a name="b419059468093534"></a><a name="b419059468093534"></a><a href="ohos-uichart.md">UIChart</a></strong> instance. </p>
</td>
</tr>
<tr id="row1499741290093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1099545200093534"><a name="p1099545200093534"></a><a name="p1099545200093534"></a><a href="graphic.md#gaea65298b6e4a71a2de65c13e1b14ed7b">GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1804510431093534"><a name="p1804510431093534"></a><a name="p1804510431093534"></a>UIViewType </p>
<p id="p1478314072093534"><a name="p1478314072093534"></a><a name="p1478314072093534"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row277545348093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1998330877093534"><a name="p1998330877093534"></a><a name="p1998330877093534"></a><a href="graphic.md#ga54b3c4122ebaeefe74587ca69aa98600">SetHeight</a> (int16_t height) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p594932541093534"><a name="p594932541093534"></a><a name="p594932541093534"></a>void </p>
<p id="p415545724093534"><a name="p415545724093534"></a><a name="p415545724093534"></a>Sets the height for this component. </p>
</td>
</tr>
<tr id="row221068156093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1410848724093534"><a name="p1410848724093534"></a><a name="p1410848724093534"></a><a href="graphic.md#ga2ae317808111cd58e6ba93e030f23111">SetWidth</a> (int16_t width) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2120639616093534"><a name="p2120639616093534"></a><a name="p2120639616093534"></a>void </p>
<p id="p141994327093534"><a name="p141994327093534"></a><a name="p141994327093534"></a>Sets the width for this component. </p>
</td>
</tr>
<tr id="row1013398290093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p84585751093534"><a name="p84585751093534"></a><a name="p84585751093534"></a><a href="graphic.md#ga9a8287a522f00bb3dbe60af8f242054a">OnPreDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1217636458093534"><a name="p1217636458093534"></a><a name="p1217636458093534"></a>bool </p>
<p id="p15204642093534"><a name="p15204642093534"></a><a name="p15204642093534"></a>Called before a view is drawn. This function is used to check whether the parent view of this view needs to be redrawn so as to optimize the drawing process. </p>
</td>
</tr>
<tr id="row848674698093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1617014378093534"><a name="p1617014378093534"></a><a name="p1617014378093534"></a><a href="graphic.md#ga5c101948cb2cfb8394af0bcb56f65efb">OnDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1768275810093534"><a name="p1768275810093534"></a><a name="p1768275810093534"></a>void </p>
<p id="p95489561093534"><a name="p95489561093534"></a><a name="p95489561093534"></a>Called when a view is drawn. </p>
</td>
</tr>
<tr id="row947762790093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1921817381093534"><a name="p1921817381093534"></a><a name="p1921817381093534"></a><a href="graphic.md#gafc510047aac4e7eebd5b229e726ef762">AddDataSerial</a> (<a href="ohos-uichartdataserial.md">UIChartDataSerial</a> *dataSerial)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p215106620093534"><a name="p215106620093534"></a><a name="p215106620093534"></a>virtual bool </p>
<p id="p1723973985093534"><a name="p1723973985093534"></a><a name="p1723973985093534"></a>Adds a data set. </p>
</td>
</tr>
<tr id="row1054113919093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1899185365093534"><a name="p1899185365093534"></a><a name="p1899185365093534"></a><a href="graphic.md#ga2af81fbcd6a17ef250bf07e2d7606b8d">DeleteDataSerial</a> (<a href="ohos-uichartdataserial.md">UIChartDataSerial</a> *dataSerial)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p369635144093534"><a name="p369635144093534"></a><a name="p369635144093534"></a>virtual bool </p>
<p id="p1881996914093534"><a name="p1881996914093534"></a><a name="p1881996914093534"></a>Deletes a data set. </p>
</td>
</tr>
<tr id="row446615395093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1505999820093534"><a name="p1505999820093534"></a><a name="p1505999820093534"></a><a href="graphic.md#gae2752857fbcb9f1541cd811321bfc2c6">ClearDataSerial</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p511824660093534"><a name="p511824660093534"></a><a name="p511824660093534"></a>virtual void </p>
<p id="p618420575093534"><a name="p618420575093534"></a><a name="p618420575093534"></a>Clears all data sets. </p>
</td>
</tr>
<tr id="row1271461512093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1212693698093534"><a name="p1212693698093534"></a><a name="p1212693698093534"></a><a href="graphic.md#ga010c178e2c1dec79e4af10cbf4545257">GetXAxis</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1491154056093534"><a name="p1491154056093534"></a><a name="p1491154056093534"></a><a href="ohos-uixaxis.md">UIXAxis</a> &amp; </p>
<p id="p479050059093534"><a name="p479050059093534"></a><a name="p479050059093534"></a>Obtains the x-axis instance. </p>
</td>
</tr>
<tr id="row1820974292093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1886258361093534"><a name="p1886258361093534"></a><a name="p1886258361093534"></a><a href="graphic.md#ga696227300be45585be102f6a7f66b7b1">GetYAxis</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p401797007093534"><a name="p401797007093534"></a><a name="p401797007093534"></a><a href="ohos-uiyaxis.md">UIYAxis</a> &amp; </p>
<p id="p1265862434093534"><a name="p1265862434093534"></a><a name="p1265862434093534"></a>Obtains the y-axis instance. </p>
</td>
</tr>
<tr id="row994019306093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1216137906093534"><a name="p1216137906093534"></a><a name="p1216137906093534"></a><a href="graphic.md#ga7c99edd3adfb60796be92e98fd71a705">EnableReverse</a> (bool enable)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1127369598093534"><a name="p1127369598093534"></a><a name="p1127369598093534"></a>void </p>
<p id="p1553437663093534"><a name="p1553437663093534"></a><a name="p1553437663093534"></a>Enables chart reverse. </p>
</td>
</tr>
<tr id="row989101295093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1707955825093534"><a name="p1707955825093534"></a><a name="p1707955825093534"></a><a href="graphic.md#gadae043c6d43d5436ec0374e5d128c654">UIViewGroup</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p455287537093534"><a name="p455287537093534"></a><a name="p455287537093534"></a> </p>
<p id="p638971349093534"><a name="p638971349093534"></a><a name="p638971349093534"></a>A default constructor used to create a <strong id="b273478678093534"><a name="b273478678093534"></a><a name="b273478678093534"></a><a href="ohos-uiviewgroup.md">UIViewGroup</a></strong> instance. </p>
</td>
</tr>
<tr id="row1786225283093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1924966972093534"><a name="p1924966972093534"></a><a name="p1924966972093534"></a><a href="graphic.md#ga19ec065bd41a01f0925a4a9ffa450d1c">~UIViewGroup</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p701289434093534"><a name="p701289434093534"></a><a name="p701289434093534"></a>virtual </p>
<p id="p482930796093534"><a name="p482930796093534"></a><a name="p482930796093534"></a>A destructor used to delete the <strong id="b1767529916093534"><a name="b1767529916093534"></a><a name="b1767529916093534"></a><a href="ohos-uiviewgroup.md">UIViewGroup</a></strong> instance. </p>
</td>
</tr>
<tr id="row1150718975093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p423549834093534"><a name="p423549834093534"></a><a name="p423549834093534"></a><a href="graphic.md#gad5756764839a844ee9bee0c186798029">GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1728718007093534"><a name="p1728718007093534"></a><a name="p1728718007093534"></a>UIViewType </p>
<p id="p1462202024093534"><a name="p1462202024093534"></a><a name="p1462202024093534"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row618917294093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p321737583093534"><a name="p321737583093534"></a><a name="p321737583093534"></a><a href="graphic.md#gacf5db120308ac7783c493f5437f06cee">Add</a> (<a href="ohos-uiview.md">UIView</a> *view)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1639743638093534"><a name="p1639743638093534"></a><a name="p1639743638093534"></a>virtual void </p>
<p id="p2109893309093534"><a name="p2109893309093534"></a><a name="p2109893309093534"></a>Adds a child view. </p>
</td>
</tr>
<tr id="row132686520093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p914300990093534"><a name="p914300990093534"></a><a name="p914300990093534"></a><a href="graphic.md#ga84195a993bfe50d8302435ababb63966">Insert</a> (<a href="ohos-uiview.md">UIView</a> *prevView, <a href="ohos-uiview.md">UIView</a> *insertView)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1733072000093534"><a name="p1733072000093534"></a><a name="p1733072000093534"></a>virtual void </p>
<p id="p1756100393093534"><a name="p1756100393093534"></a><a name="p1756100393093534"></a>Inserts a new child view behind the current one. </p>
</td>
</tr>
<tr id="row1047086093093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1208528004093534"><a name="p1208528004093534"></a><a name="p1208528004093534"></a><a href="graphic.md#ga25523928b24d6692f18aed31edb07006">Remove</a> (<a href="ohos-uiview.md">UIView</a> *view)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p390197698093534"><a name="p390197698093534"></a><a name="p390197698093534"></a>virtual void </p>
<p id="p155601735093534"><a name="p155601735093534"></a><a name="p155601735093534"></a>Removes a child view. </p>
</td>
</tr>
<tr id="row2009593649093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p385759246093534"><a name="p385759246093534"></a><a name="p385759246093534"></a><a href="graphic.md#gaf3ee08173d92932687809049e3c11e9b">RemoveAll</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1316431567093534"><a name="p1316431567093534"></a><a name="p1316431567093534"></a>virtual void </p>
<p id="p2036811914093534"><a name="p2036811914093534"></a><a name="p2036811914093534"></a>Removes all child views. </p>
</td>
</tr>
<tr id="row352318187093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1765565308093534"><a name="p1765565308093534"></a><a name="p1765565308093534"></a><a href="graphic.md#ga7ea54fc6ef3a8b7dec1bf88ab189f7c7">GetTargetView</a> (const <a href="ohos-point.md">Point</a> &amp;point, <a href="ohos-uiview.md">UIView</a> **last) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p206964796093534"><a name="p206964796093534"></a><a name="p206964796093534"></a>virtual void </p>
<p id="p1498991274093534"><a name="p1498991274093534"></a><a name="p1498991274093534"></a>Obtains the target child view that is visible and can respond to touch events based on given coordinates. </p>
</td>
</tr>
<tr id="row681231063093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1645840352093534"><a name="p1645840352093534"></a><a name="p1645840352093534"></a><a href="graphic.md#ga776c6c1640cb88b537af227fa5eb0725">MoveChildByOffset</a> (int16_t x, int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p991421034093534"><a name="p991421034093534"></a><a name="p991421034093534"></a>virtual void </p>
<p id="p905345488093534"><a name="p905345488093534"></a><a name="p905345488093534"></a>Moves all child views. </p>
</td>
</tr>
<tr id="row209416813093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1371701676093534"><a name="p1371701676093534"></a><a name="p1371701676093534"></a><a href="graphic.md#ga6fed8238b89b013552c5a247aa2471df">GetChildrenHead</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p838840348093534"><a name="p838840348093534"></a><a name="p838840348093534"></a><a href="ohos-uiview.md">UIView</a> * </p>
<p id="p1356108852093534"><a name="p1356108852093534"></a><a name="p1356108852093534"></a>Obtains the first child view in this view group. </p>
</td>
</tr>
<tr id="row154496612093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1555403576093534"><a name="p1555403576093534"></a><a name="p1555403576093534"></a><a href="graphic.md#ga1361baa76fbabd2fc81cc249c6868691">GetChildrenTail</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p458765039093534"><a name="p458765039093534"></a><a name="p458765039093534"></a><a href="ohos-uiview.md">UIView</a> * </p>
<p id="p1991843411093534"><a name="p1991843411093534"></a><a name="p1991843411093534"></a>Obtains the last child view in this view group. </p>
</td>
</tr>
<tr id="row366269157093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1664503623093534"><a name="p1664503623093534"></a><a name="p1664503623093534"></a><a href="graphic.md#gad53c52e619a54358a413a836ae0c1861">SetDisallowIntercept</a> (bool flag)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2020073664093534"><a name="p2020073664093534"></a><a name="p2020073664093534"></a>void </p>
<p id="p1674297233093534"><a name="p1674297233093534"></a><a name="p1674297233093534"></a>Sets whether this view group is intercepted upon touch events. </p>
</td>
</tr>
<tr id="row1046176572093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2142032260093534"><a name="p2142032260093534"></a><a name="p2142032260093534"></a><a href="graphic.md#gae9f6ddb5819392546463d6371147c486">GetChildById</a> (const char *id) const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1727620129093534"><a name="p1727620129093534"></a><a name="p1727620129093534"></a><a href="ohos-uiview.md">UIView</a> * </p>
<p id="p1540978233093534"><a name="p1540978233093534"></a><a name="p1540978233093534"></a>Obtains the target child view with a specified ID. </p>
</td>
</tr>
<tr id="row1844863726093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1834466199093534"><a name="p1834466199093534"></a><a name="p1834466199093534"></a><a href="graphic.md#ga6442ba36114d739df1b17ca8943cc087">SetAutoSize</a> (bool state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2076487969093534"><a name="p2076487969093534"></a><a name="p2076487969093534"></a>void </p>
<p id="p444213129093534"><a name="p444213129093534"></a><a name="p444213129093534"></a>Sets whether the size of this view group is adaptive to that of all child views. </p>
</td>
</tr>
<tr id="row1106202112093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1977275956093534"><a name="p1977275956093534"></a><a name="p1977275956093534"></a><a href="graphic.md#ga7aad5b50d945efe5f9304bc978b2001c">UIView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p649971863093534"><a name="p649971863093534"></a><a name="p649971863093534"></a> </p>
<p id="p307404565093534"><a name="p307404565093534"></a><a name="p307404565093534"></a>A default constructor used to create an <strong id="b538194061093534"><a name="b538194061093534"></a><a name="b538194061093534"></a><a href="ohos-uiview.md">UIView</a></strong> instance. </p>
</td>
</tr>
<tr id="row1633952009093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p56641694093534"><a name="p56641694093534"></a><a name="p56641694093534"></a><a href="graphic.md#ga57d429bb1cd71782f3b825f1bc6b9362">UIView</a> (const char *id)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p819318064093534"><a name="p819318064093534"></a><a name="p819318064093534"></a> </p>
<p id="p1874288381093534"><a name="p1874288381093534"></a><a name="p1874288381093534"></a>A constructor used to create an <strong id="b1216800780093534"><a name="b1216800780093534"></a><a name="b1216800780093534"></a><a href="ohos-uiview.md">UIView</a></strong> instance. </p>
</td>
</tr>
<tr id="row1354214101093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p711355259093534"><a name="p711355259093534"></a><a name="p711355259093534"></a><a href="graphic.md#ga17f0ffc1090bdcce0f88288da5962012">~UIView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1842922532093534"><a name="p1842922532093534"></a><a name="p1842922532093534"></a>virtual </p>
<p id="p1989801663093534"><a name="p1989801663093534"></a><a name="p1989801663093534"></a>A destructor used to delete the <strong id="b1873146239093534"><a name="b1873146239093534"></a><a name="b1873146239093534"></a><a href="ohos-uiview.md">UIView</a></strong> instance. </p>
</td>
</tr>
<tr id="row89717211093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p357519887093534"><a name="p357519887093534"></a><a name="p357519887093534"></a><a href="graphic.md#gab70473cd0d8fe7c9d4bb817caeee9153">OnPostDraw</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p584737386093534"><a name="p584737386093534"></a><a name="p584737386093534"></a>virtual void </p>
<p id="p1031508772093534"><a name="p1031508772093534"></a><a name="p1031508772093534"></a>Called after a view is drawn. </p>
</td>
</tr>
<tr id="row1435778713093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p385066440093534"><a name="p385066440093534"></a><a name="p385066440093534"></a><a href="graphic.md#ga81726238adeda1efa989be6ed4f4fe5b">ReMeasure</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p813529105093534"><a name="p813529105093534"></a><a name="p813529105093534"></a>virtual void </p>
<p id="p1860763618093534"><a name="p1860763618093534"></a><a name="p1860763618093534"></a>Remeasures the view size. </p>
</td>
</tr>
<tr id="row1782058386093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1418238421093534"><a name="p1418238421093534"></a><a name="p1418238421093534"></a><a href="graphic.md#ga2a9a38b8450fbb196277238a51fbbf99">Invalidate</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1338202471093534"><a name="p1338202471093534"></a><a name="p1338202471093534"></a>void </p>
<p id="p1538932399093534"><a name="p1538932399093534"></a><a name="p1538932399093534"></a>Refreshes the invalidated area of the view. </p>
</td>
</tr>
<tr id="row1235043669093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p894512553093534"><a name="p894512553093534"></a><a name="p894512553093534"></a><a href="graphic.md#gaf0e6b65ced8b931642f2a80c195962d2">InvalidateRect</a> (const <a href="ohos-rect.md">Rect</a> &amp;invalidatedArea)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p196917313093534"><a name="p196917313093534"></a><a name="p196917313093534"></a>void </p>
<p id="p1530981113093534"><a name="p1530981113093534"></a><a name="p1530981113093534"></a>Refreshes a view in a specified invalidated area. </p>
</td>
</tr>
<tr id="row1235746166093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p854905529093534"><a name="p854905529093534"></a><a name="p854905529093534"></a><a href="graphic.md#gac311aa47301d727c35fc31f8630d016e">OnLongPressEvent</a> (const <a href="ohos-longpressevent.md">LongPressEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p895827420093534"><a name="p895827420093534"></a><a name="p895827420093534"></a>virtual bool </p>
<p id="p17393375093534"><a name="p17393375093534"></a><a name="p17393375093534"></a>Called when the view is long pressed. </p>
</td>
</tr>
<tr id="row1383701319093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p76062502093534"><a name="p76062502093534"></a><a name="p76062502093534"></a><a href="graphic.md#gac0e10556ff99b8a92bfb11df6456d605">OnDragStartEvent</a> (const <a href="ohos-dragevent.md">DragEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p681743051093534"><a name="p681743051093534"></a><a name="p681743051093534"></a>virtual bool </p>
<p id="p1434585975093534"><a name="p1434585975093534"></a><a name="p1434585975093534"></a>Called when the view starts to drag. </p>
</td>
</tr>
<tr id="row1203108849093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1652678867093534"><a name="p1652678867093534"></a><a name="p1652678867093534"></a><a href="graphic.md#ga46249c8caf06b81590d9450e30a31147">OnDragEvent</a> (const <a href="ohos-dragevent.md">DragEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1629723904093534"><a name="p1629723904093534"></a><a name="p1629723904093534"></a>virtual bool </p>
<p id="p1730160093534"><a name="p1730160093534"></a><a name="p1730160093534"></a>Called when the view is being dragged. </p>
</td>
</tr>
<tr id="row2045582611093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p194802518093534"><a name="p194802518093534"></a><a name="p194802518093534"></a><a href="graphic.md#ga1799d33be73f64ed2066f50d7e65468d">OnDragEndEvent</a> (const <a href="ohos-dragevent.md">DragEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1908593066093534"><a name="p1908593066093534"></a><a name="p1908593066093534"></a>virtual bool </p>
<p id="p1590341966093534"><a name="p1590341966093534"></a><a name="p1590341966093534"></a>Called when the view stops dragging. </p>
</td>
</tr>
<tr id="row2145347444093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1867199068093534"><a name="p1867199068093534"></a><a name="p1867199068093534"></a><a href="graphic.md#gad08697a29aae4c58267f494b66b9a547">OnClickEvent</a> (const <a href="ohos-clickevent.md">ClickEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p640638332093534"><a name="p640638332093534"></a><a name="p640638332093534"></a>virtual void </p>
<p id="p974746583093534"><a name="p974746583093534"></a><a name="p974746583093534"></a>Called when the view is clicked. </p>
</td>
</tr>
<tr id="row1694780731093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1393089117093534"><a name="p1393089117093534"></a><a name="p1393089117093534"></a><a href="graphic.md#gafa544ff2d27785a9410a80689f1ad3b1">OnPressEvent</a> (const <a href="ohos-pressevent.md">PressEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2014967858093534"><a name="p2014967858093534"></a><a name="p2014967858093534"></a>virtual void </p>
<p id="p1126322082093534"><a name="p1126322082093534"></a><a name="p1126322082093534"></a>Called when the view is pressed. </p>
</td>
</tr>
<tr id="row1941565033093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1974413819093534"><a name="p1974413819093534"></a><a name="p1974413819093534"></a><a href="graphic.md#ga7bd1a74563b059b03fbf66f9add53ee3">OnReleaseEvent</a> (const <a href="ohos-releaseevent.md">ReleaseEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p32665804093534"><a name="p32665804093534"></a><a name="p32665804093534"></a>virtual void </p>
<p id="p1261829562093534"><a name="p1261829562093534"></a><a name="p1261829562093534"></a>Called when the view is released. </p>
</td>
</tr>
<tr id="row325706455093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p211681020093534"><a name="p211681020093534"></a><a name="p211681020093534"></a><a href="graphic.md#ga8f01ff25a33b20df0758f564148e579d">OnCancelEvent</a> (const <a href="ohos-cancelevent.md">CancelEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1206135433093534"><a name="p1206135433093534"></a><a name="p1206135433093534"></a>virtual void </p>
<p id="p98854362093534"><a name="p98854362093534"></a><a name="p98854362093534"></a>Called when a click event on the view is canceled. </p>
</td>
</tr>
<tr id="row854672230093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p505113074093534"><a name="p505113074093534"></a><a name="p505113074093534"></a><a href="graphic.md#gad8e3cf5f0dd003a6aa932ef04e7b59f2">SetOnDragListener</a> (<a href="ohos-uiview-ondraglistener.md">OnDragListener</a> *onDragListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1871421494093534"><a name="p1871421494093534"></a><a name="p1871421494093534"></a>void </p>
<p id="p141094211093534"><a name="p141094211093534"></a><a name="p141094211093534"></a>Sets a drag event listener for the view. </p>
</td>
</tr>
<tr id="row1434604561093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p219498934093534"><a name="p219498934093534"></a><a name="p219498934093534"></a><a href="graphic.md#ga45a02cba4887c5c0b8e243941bcdc5cb">GetOnDragListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p582901554093534"><a name="p582901554093534"></a><a name="p582901554093534"></a><a href="ohos-uiview-ondraglistener.md">OnDragListener</a> *&amp; </p>
<p id="p337558995093534"><a name="p337558995093534"></a><a name="p337558995093534"></a>Obtains the drag event listener for the view. </p>
</td>
</tr>
<tr id="row2018183102093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p851605318093534"><a name="p851605318093534"></a><a name="p851605318093534"></a><a href="graphic.md#ga4564bf8d8c7184e9c02bf33c9e171fa3">SetOnClickListener</a> (<a href="ohos-uiview-onclicklistener.md">OnClickListener</a> *onClickListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1513620661093534"><a name="p1513620661093534"></a><a name="p1513620661093534"></a>void </p>
<p id="p1360575174093534"><a name="p1360575174093534"></a><a name="p1360575174093534"></a>Sets a click event listener for the view. </p>
</td>
</tr>
<tr id="row625060525093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1968401714093534"><a name="p1968401714093534"></a><a name="p1968401714093534"></a><a href="graphic.md#ga35e885cb380c37245fa4305bba10cd4a">GetOnClickListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p729879060093534"><a name="p729879060093534"></a><a name="p729879060093534"></a><a href="ohos-uiview-onclicklistener.md">OnClickListener</a> *&amp; </p>
<p id="p1757939800093534"><a name="p1757939800093534"></a><a name="p1757939800093534"></a>Obtains the click event listener for the view. </p>
</td>
</tr>
<tr id="row1589888640093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1934763991093534"><a name="p1934763991093534"></a><a name="p1934763991093534"></a><a href="graphic.md#gabcbe7a0adce600424f7f0d5a7396eb5b">SetOnLongPressListener</a> (<a href="ohos-uiview-onlongpresslistener.md">OnLongPressListener</a> *onLongPressListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p814332497093534"><a name="p814332497093534"></a><a name="p814332497093534"></a>void </p>
<p id="p885384803093534"><a name="p885384803093534"></a><a name="p885384803093534"></a>Sets a long-press event listener for the view. </p>
</td>
</tr>
<tr id="row2020249061093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1015765530093534"><a name="p1015765530093534"></a><a name="p1015765530093534"></a><a href="graphic.md#gaafd4d354f5f111e758d046109fd7f656">GetOnLongPressListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2060326411093534"><a name="p2060326411093534"></a><a name="p2060326411093534"></a><a href="ohos-uiview-onlongpresslistener.md">OnLongPressListener</a> *&amp; </p>
<p id="p1210876578093534"><a name="p1210876578093534"></a><a name="p1210876578093534"></a>Obtains the long-press event listener for the view. </p>
</td>
</tr>
<tr id="row1662617153093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p665562492093534"><a name="p665562492093534"></a><a name="p665562492093534"></a><a href="graphic.md#gadd697fbf481f98d9d6ca8b67390071af">SetOnTouchListener</a> (<a href="ohos-uiview-ontouchlistener.md">OnTouchListener</a> *onTouchListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p277365445093534"><a name="p277365445093534"></a><a name="p277365445093534"></a>void </p>
<p id="p1014040777093534"><a name="p1014040777093534"></a><a name="p1014040777093534"></a>Sets a touch event listener for the view. </p>
</td>
</tr>
<tr id="row55253210093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1457914318093534"><a name="p1457914318093534"></a><a name="p1457914318093534"></a><a href="graphic.md#gae7c65c68653103dae85acdcef78777a6">GetTouchListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p527903111093534"><a name="p527903111093534"></a><a name="p527903111093534"></a><a href="ohos-uiview-ontouchlistener.md">OnTouchListener</a> *&amp; </p>
<p id="p1467502740093534"><a name="p1467502740093534"></a><a name="p1467502740093534"></a>Obtains the touch event listener for the view. </p>
</td>
</tr>
<tr id="row407466449093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1479241564093534"><a name="p1479241564093534"></a><a name="p1479241564093534"></a><a href="graphic.md#gaeea67a3a84b4ffe9bfeda418b82184cc">SetParent</a> (<a href="ohos-uiview.md">UIView</a> *parent)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1533038623093534"><a name="p1533038623093534"></a><a name="p1533038623093534"></a>void </p>
<p id="p785126835093534"><a name="p785126835093534"></a><a name="p785126835093534"></a>Sets the parent view for the view. </p>
</td>
</tr>
<tr id="row413507846093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p714062762093534"><a name="p714062762093534"></a><a name="p714062762093534"></a><a href="graphic.md#ga706530e4a38108615d5e0c918685ec96">GetParent</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1321020241093534"><a name="p1321020241093534"></a><a name="p1321020241093534"></a><a href="ohos-uiview.md">UIView</a> * </p>
<p id="p554988293093534"><a name="p554988293093534"></a><a name="p554988293093534"></a>Obtains the parent view of the view. </p>
</td>
</tr>
<tr id="row1807686181093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1316744176093534"><a name="p1316744176093534"></a><a name="p1316744176093534"></a><a href="graphic.md#ga02bec5de07d93cabc45affba79eba4ad">SetNextSibling</a> (<a href="ohos-uiview.md">UIView</a> *sibling)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p857110230093534"><a name="p857110230093534"></a><a name="p857110230093534"></a>void </p>
<p id="p1475012614093534"><a name="p1475012614093534"></a><a name="p1475012614093534"></a>Sets the next sibling view for the view. </p>
</td>
</tr>
<tr id="row1140744171093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1135070129093534"><a name="p1135070129093534"></a><a name="p1135070129093534"></a><a href="graphic.md#gab0030977b30ddc9f2e15dbc2f58937e6">GetNextSibling</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1599280727093534"><a name="p1599280727093534"></a><a name="p1599280727093534"></a><a href="ohos-uiview.md">UIView</a> * </p>
<p id="p635183080093534"><a name="p635183080093534"></a><a name="p635183080093534"></a>Obtains the next sibling view of the view. </p>
</td>
</tr>
<tr id="row1015883917093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1229157965093534"><a name="p1229157965093534"></a><a name="p1229157965093534"></a><a href="graphic.md#ga07e7e1f268bd6ce975f4f0f8487af5d0">SetVisible</a> (bool visible)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1868872023093534"><a name="p1868872023093534"></a><a name="p1868872023093534"></a>virtual void </p>
<p id="p459609098093534"><a name="p459609098093534"></a><a name="p459609098093534"></a>Sets whether the view is visible. </p>
</td>
</tr>
<tr id="row1139698199093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2079971865093534"><a name="p2079971865093534"></a><a name="p2079971865093534"></a><a href="graphic.md#gaee178fc0a86ac03a6bdf2ade0c1914c8">IsVisible</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1252159984093534"><a name="p1252159984093534"></a><a name="p1252159984093534"></a>bool </p>
<p id="p61696458093534"><a name="p61696458093534"></a><a name="p61696458093534"></a>Checks whether the view is visible. </p>
</td>
</tr>
<tr id="row1577019057093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p161183120093534"><a name="p161183120093534"></a><a name="p161183120093534"></a><a href="graphic.md#gaf9fb55fd9aa397f7158f1515e90bce02">SetTouchable</a> (bool touch)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1418899533093534"><a name="p1418899533093534"></a><a name="p1418899533093534"></a>void </p>
<p id="p1099997696093534"><a name="p1099997696093534"></a><a name="p1099997696093534"></a>Sets whether the view is touchable. </p>
</td>
</tr>
<tr id="row988795907093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1296154154093534"><a name="p1296154154093534"></a><a name="p1296154154093534"></a><a href="graphic.md#ga502a53fb77b260fa36b5b3adf82e2340">IsTouchable</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2043100204093534"><a name="p2043100204093534"></a><a name="p2043100204093534"></a>bool </p>
<p id="p837498162093534"><a name="p837498162093534"></a><a name="p837498162093534"></a>Checks whether the view is touchable. </p>
</td>
</tr>
<tr id="row2106832218093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1601186510093534"><a name="p1601186510093534"></a><a name="p1601186510093534"></a><a href="graphic.md#gab06abe0fe824c048f3b72974f9a8f0d0">SetDraggable</a> (bool draggable)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1214126878093534"><a name="p1214126878093534"></a><a name="p1214126878093534"></a>void </p>
<p id="p530854365093534"><a name="p530854365093534"></a><a name="p530854365093534"></a>Sets whether the view is draggable. </p>
</td>
</tr>
<tr id="row481923621093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1192981845093534"><a name="p1192981845093534"></a><a name="p1192981845093534"></a><a href="graphic.md#ga25bb796ff400c767d622cbed280fc500">IsDraggable</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p662356807093534"><a name="p662356807093534"></a><a name="p662356807093534"></a>bool </p>
<p id="p743657932093534"><a name="p743657932093534"></a><a name="p743657932093534"></a>Checks whether the view is draggable. </p>
</td>
</tr>
<tr id="row130769154093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1539456188093534"><a name="p1539456188093534"></a><a name="p1539456188093534"></a><a href="graphic.md#ga6c08e49bf7a82a7ebaef0f251e7a6f85">SetDragParentInstead</a> (bool dragParentInstead)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1630405950093534"><a name="p1630405950093534"></a><a name="p1630405950093534"></a>void </p>
<p id="p1799317614093534"><a name="p1799317614093534"></a><a name="p1799317614093534"></a>Sets whether to transfer the drag event to the parent view for processing when the view is being dragged. </p>
</td>
</tr>
<tr id="row1524299464093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1979703019093534"><a name="p1979703019093534"></a><a name="p1979703019093534"></a><a href="graphic.md#gaf0c462bc31e779b1898ad4cdfdad6faf">IsDragParentInstead</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1672254604093534"><a name="p1672254604093534"></a><a name="p1672254604093534"></a>bool </p>
<p id="p1215105120093534"><a name="p1215105120093534"></a><a name="p1215105120093534"></a>Obtains whether the view transfers a drag event to the parent view for processing. </p>
</td>
</tr>
<tr id="row870786170093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p366330727093534"><a name="p366330727093534"></a><a name="p366330727093534"></a><a href="graphic.md#ga86cb8d364f18494d67636c55babced5c">GetRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p74498713093534"><a name="p74498713093534"></a><a name="p74498713093534"></a><a href="ohos-rect.md">Rect</a> </p>
<p id="p1464896215093534"><a name="p1464896215093534"></a><a name="p1464896215093534"></a>Obtains the absolute rectangle area of the view. When the view has deformation such as rotation, the rectangle area is the intersection set of the absolute rectangle area and deformation matrix. </p>
</td>
</tr>
<tr id="row1277362346093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2102761351093534"><a name="p2102761351093534"></a><a name="p2102761351093534"></a><a href="graphic.md#ga06e79704a19f2a238982076cac3d059b">GetVisibleRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1360001617093534"><a name="p1360001617093534"></a><a name="p1360001617093534"></a><a href="ohos-rect.md">Rect</a> </p>
<p id="p113188723093534"><a name="p113188723093534"></a><a name="p113188723093534"></a>Obtains the visible absolute rectangle area of the view. </p>
</td>
</tr>
<tr id="row1235190904093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2047759629093534"><a name="p2047759629093534"></a><a name="p2047759629093534"></a><a href="graphic.md#gab3f8993b3953f27bfc61d53429916cba">GetMaskedRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p605297595093534"><a name="p605297595093534"></a><a name="p605297595093534"></a><a href="ohos-rect.md">Rect</a> </p>
<p id="p601275020093534"><a name="p601275020093534"></a><a name="p601275020093534"></a>Obtains the valid absolute rectangle area of the view. The valid area refers to the area where the view can be displayed. Generally, the valid area is the same as the visible view area, but they may be different in the grid layout. </p>
</td>
</tr>
<tr id="row1628546875093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p222582702093534"><a name="p222582702093534"></a><a name="p222582702093534"></a><a href="graphic.md#ga64cf308a09999def1192f9c4e0f17f0a">GetOrigRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p117516941093534"><a name="p117516941093534"></a><a name="p117516941093534"></a><a href="ohos-rect.md">Rect</a> </p>
<p id="p1190230323093534"><a name="p1190230323093534"></a><a name="p1190230323093534"></a>Obtains the absolute rectangle area of the view. </p>
</td>
</tr>
<tr id="row1707445046093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p868150099093534"><a name="p868150099093534"></a><a name="p868150099093534"></a><a href="graphic.md#ga9db88eae712676359d02a92be14fa316">GetContentRect</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1829183604093534"><a name="p1829183604093534"></a><a name="p1829183604093534"></a>virtual <a href="ohos-rect.md">Rect</a> </p>
<p id="p937169304093534"><a name="p937169304093534"></a><a name="p937169304093534"></a>Obtains the content of the absolute rectangle area of the view. This area excludes padding. </p>
</td>
</tr>
<tr id="row409520549093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p464478453093534"><a name="p464478453093534"></a><a name="p464478453093534"></a><a href="graphic.md#gae9b96837fa1d45648a2a6fbbfcc5eb4a">GetRelativeRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1876065938093534"><a name="p1876065938093534"></a><a name="p1876065938093534"></a><a href="ohos-rect.md">Rect</a> </p>
<p id="p1425425113093534"><a name="p1425425113093534"></a><a name="p1425425113093534"></a>Obtains the rectangular area of the view relative to the parent view, that is, the rectangular area relative to the coordinates of the parent view. </p>
</td>
</tr>
<tr id="row1859216793093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1145755878093534"><a name="p1145755878093534"></a><a name="p1145755878093534"></a><a href="graphic.md#gae6c5f3bcf99dc837bcecd60c38d3df5a">ResizeVisibleArea</a> (int16_t x, int16_t y, int16_t width, int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1051958169093534"><a name="p1051958169093534"></a><a name="p1051958169093534"></a>void </p>
<p id="p418081087093534"><a name="p418081087093534"></a><a name="p418081087093534"></a>Adjusts the size of the visible area. This operation may affect the final display size. </p>
</td>
</tr>
<tr id="row374683518093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2082580265093534"><a name="p2082580265093534"></a><a name="p2082580265093534"></a><a href="graphic.md#ga90cf8cffb98d71c30d6fc1d118442dbd">GetWidth</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1385613880093534"><a name="p1385613880093534"></a><a name="p1385613880093534"></a>virtual int16_t </p>
<p id="p1828420637093534"><a name="p1828420637093534"></a><a name="p1828420637093534"></a>Obtains the width for the view. </p>
</td>
</tr>
<tr id="row286826447093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p536760694093534"><a name="p536760694093534"></a><a name="p536760694093534"></a><a href="graphic.md#ga9b35f4603a561c7a9a29b023a022ac97">GetHeight</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1180086851093534"><a name="p1180086851093534"></a><a name="p1180086851093534"></a>virtual int16_t </p>
<p id="p1674669368093534"><a name="p1674669368093534"></a><a name="p1674669368093534"></a>Obtains the height for the view. </p>
</td>
</tr>
<tr id="row556669228093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p198787052093534"><a name="p198787052093534"></a><a name="p198787052093534"></a><a href="graphic.md#gae985b607d2f0701911778bf20d640ccd">Resize</a> (int16_t width, int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p290016516093534"><a name="p290016516093534"></a><a name="p290016516093534"></a>virtual void </p>
<p id="p626183772093534"><a name="p626183772093534"></a><a name="p626183772093534"></a>Adjusts the size of the view. </p>
</td>
</tr>
<tr id="row1956385802093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p920476590093534"><a name="p920476590093534"></a><a name="p920476590093534"></a><a href="graphic.md#gaded403626558d28e62bf5632ccbb24b5">SetX</a> (int16_t x)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1821143623093534"><a name="p1821143623093534"></a><a name="p1821143623093534"></a>virtual void </p>
<p id="p260191594093534"><a name="p260191594093534"></a><a name="p260191594093534"></a>Sets the x-coordinate for the view. </p>
</td>
</tr>
<tr id="row1910426067093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2039104448093534"><a name="p2039104448093534"></a><a name="p2039104448093534"></a><a href="graphic.md#ga89dc5f8fb1cb4b2259dc0439185359f1">GetX</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p512433446093534"><a name="p512433446093534"></a><a name="p512433446093534"></a>int16_t </p>
<p id="p1320656581093534"><a name="p1320656581093534"></a><a name="p1320656581093534"></a>Obtains the x-coordinate for the view. </p>
</td>
</tr>
<tr id="row1921824170093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p146725469093534"><a name="p146725469093534"></a><a name="p146725469093534"></a><a href="graphic.md#gaaa8edc224cf1c7deb2724fb225960877">SetY</a> (int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1551971071093534"><a name="p1551971071093534"></a><a name="p1551971071093534"></a>virtual void </p>
<p id="p633125009093534"><a name="p633125009093534"></a><a name="p633125009093534"></a>Sets the y-coordinate for the view. </p>
</td>
</tr>
<tr id="row433193098093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1667485383093534"><a name="p1667485383093534"></a><a name="p1667485383093534"></a><a href="graphic.md#ga193619d649204b0e9bb854d3b30275c3">GetY</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1104228997093534"><a name="p1104228997093534"></a><a name="p1104228997093534"></a>int16_t </p>
<p id="p454851320093534"><a name="p454851320093534"></a><a name="p454851320093534"></a>Obtains the y-coordinate for the view. </p>
</td>
</tr>
<tr id="row766929865093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p855428891093534"><a name="p855428891093534"></a><a name="p855428891093534"></a><a href="graphic.md#gab34233f6aeae330b025969137d03e67a">SetPosition</a> (int16_t x, int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p421834152093534"><a name="p421834152093534"></a><a name="p421834152093534"></a>virtual void </p>
<p id="p675332730093534"><a name="p675332730093534"></a><a name="p675332730093534"></a>Sets the position for the view. </p>
</td>
</tr>
<tr id="row933210467093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1850828812093534"><a name="p1850828812093534"></a><a name="p1850828812093534"></a><a href="graphic.md#gaf8ce4c009f23b7175b2b34bac4a74262">SetPosition</a> (int16_t x, int16_t y, int16_t width, int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p520549122093534"><a name="p520549122093534"></a><a name="p520549122093534"></a>virtual void </p>
<p id="p178038474093534"><a name="p178038474093534"></a><a name="p178038474093534"></a>Adjusts the position and size of the view. </p>
</td>
</tr>
<tr id="row1875052464093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p387560135093534"><a name="p387560135093534"></a><a name="p387560135093534"></a><a href="graphic.md#gab2ce8c11abbd55f40687f38a52511b11">IsViewGroup</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p403768962093534"><a name="p403768962093534"></a><a name="p403768962093534"></a>bool </p>
<p id="p1648064641093534"><a name="p1648064641093534"></a><a name="p1648064641093534"></a>Checks whether the view is a container view. </p>
</td>
</tr>
<tr id="row396989888093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1211177349093534"><a name="p1211177349093534"></a><a name="p1211177349093534"></a><a href="graphic.md#ga980fc6824c64cfae6af8657aee17af88">SetIntercept</a> (bool isIntercept)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p123446264093534"><a name="p123446264093534"></a><a name="p123446264093534"></a>void </p>
<p id="p221284609093534"><a name="p221284609093534"></a><a name="p221284609093534"></a>Sets whether to intercept the drag event. If intercepted, the view does not transfer the drag event to the parent view after local processing. </p>
</td>
</tr>
<tr id="row938262635093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1006868871093534"><a name="p1006868871093534"></a><a name="p1006868871093534"></a><a href="graphic.md#ga8623abbbeff458c0cb2d7dc0d1f21e4a">SetTransformMap</a> (const <a href="ohos-transformmap.md">TransformMap</a> &amp;transMap)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1747516458093534"><a name="p1747516458093534"></a><a name="p1747516458093534"></a>void </p>
<p id="p86975858093534"><a name="p86975858093534"></a><a name="p86975858093534"></a>Sets the affine transformation matrix. </p>
</td>
</tr>
<tr id="row1573453950093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1871465613093534"><a name="p1871465613093534"></a><a name="p1871465613093534"></a><a href="graphic.md#gab8cee5a7052a88722768c8ed1324abc1">GetTransformMap</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p299520635093534"><a name="p299520635093534"></a><a name="p299520635093534"></a><a href="ohos-transformmap.md">TransformMap</a> &amp; </p>
<p id="p1759917619093534"><a name="p1759917619093534"></a><a name="p1759917619093534"></a>Obtains an affine transformation matrix. </p>
</td>
</tr>
<tr id="row2103667844093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1875247770093534"><a name="p1875247770093534"></a><a name="p1875247770093534"></a><a href="graphic.md#ga0caaa15c9b304673331e778a266be77f">SetViewId</a> (const char *id)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p983589993093534"><a name="p983589993093534"></a><a name="p983589993093534"></a>void </p>
<p id="p1985477512093534"><a name="p1985477512093534"></a><a name="p1985477512093534"></a>Sets the view ID. </p>
</td>
</tr>
<tr id="row2122571517093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1456196614093534"><a name="p1456196614093534"></a><a name="p1456196614093534"></a><a href="graphic.md#gad6c7644bd2abfa3c92d80776b0bd1936">GetViewId</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p433039488093534"><a name="p433039488093534"></a><a name="p433039488093534"></a>const char * </p>
<p id="p1954259382093534"><a name="p1954259382093534"></a><a name="p1954259382093534"></a>Obtains the view ID. </p>
</td>
</tr>
<tr id="row1454751219093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p687252785093534"><a name="p687252785093534"></a><a name="p687252785093534"></a><a href="graphic.md#ga77a961aa53567c5214508b4569801c16">SetViewIndex</a> (int16_t <a href="en-us_topic_0000001055198076.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p492698616093534"><a name="p492698616093534"></a><a name="p492698616093534"></a>void </p>
<p id="p2045992196093534"><a name="p2045992196093534"></a><a name="p2045992196093534"></a>Sets the view index. </p>
</td>
</tr>
<tr id="row1527423763093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1387865140093534"><a name="p1387865140093534"></a><a name="p1387865140093534"></a><a href="graphic.md#ga62f51715b6d420a296ebe0296717b906">GetViewIndex</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p10508086093534"><a name="p10508086093534"></a><a name="p10508086093534"></a>int16_t </p>
<p id="p2002765912093534"><a name="p2002765912093534"></a><a name="p2002765912093534"></a>Obtains the view index. </p>
</td>
</tr>
<tr id="row1802645643093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p423018047093534"><a name="p423018047093534"></a><a name="p423018047093534"></a><a href="graphic.md#gaca871fa2f8219e7ea9388e212d1f1e69">LayoutChildren</a> (bool neeInvalidate=false)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1250484800093534"><a name="p1250484800093534"></a><a name="p1250484800093534"></a>virtual void </p>
<p id="p721789400093534"><a name="p721789400093534"></a><a name="p721789400093534"></a>Lays out all child views according to the preset arrangement mode. </p>
</td>
</tr>
<tr id="row242554646093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1728468386093534"><a name="p1728468386093534"></a><a name="p1728468386093534"></a><a href="graphic.md#ga443b86ee9275b0421b37a47bad3264dc">LayoutCenterOfParent</a> (int16_t xOffSet=0, int16_t yOffset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p416156735093534"><a name="p416156735093534"></a><a name="p416156735093534"></a>void </p>
<p id="p1934631216093534"><a name="p1934631216093534"></a><a name="p1934631216093534"></a>Lays out the view in the center of the parent view. </p>
</td>
</tr>
<tr id="row184851793093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p899256612093534"><a name="p899256612093534"></a><a name="p899256612093534"></a><a href="graphic.md#ga94999b271f27cd5d6bfaf303f7d5c708">LayoutLeftOfParent</a> (int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p80204815093534"><a name="p80204815093534"></a><a name="p80204815093534"></a>void </p>
<p id="p855110334093534"><a name="p855110334093534"></a><a name="p855110334093534"></a>Lays out the view on the left of the parent view. </p>
</td>
</tr>
<tr id="row1694000041093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p986227886093534"><a name="p986227886093534"></a><a name="p986227886093534"></a><a href="graphic.md#ga479528ed259b5539e423955f2b60517d">LayoutRightOfParent</a> (int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1408873965093534"><a name="p1408873965093534"></a><a name="p1408873965093534"></a>void </p>
<p id="p352175813093534"><a name="p352175813093534"></a><a name="p352175813093534"></a>Lays out the view on the right of the parent view. </p>
</td>
</tr>
<tr id="row1497358459093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p872853328093534"><a name="p872853328093534"></a><a name="p872853328093534"></a><a href="graphic.md#ga859288ea61ad23ba7e381bbc07769e83">LayoutTopOfParent</a> (int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1362536446093534"><a name="p1362536446093534"></a><a name="p1362536446093534"></a>void </p>
<p id="p1639902286093534"><a name="p1639902286093534"></a><a name="p1639902286093534"></a>Lays out the view on the top of the parent view. </p>
</td>
</tr>
<tr id="row1683302587093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1446796802093534"><a name="p1446796802093534"></a><a name="p1446796802093534"></a><a href="graphic.md#ga809aeee4792ae58218a0bcfcb94d5cdc">LayoutBottomOfParent</a> (int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p900484329093534"><a name="p900484329093534"></a><a name="p900484329093534"></a>void </p>
<p id="p1140905333093534"><a name="p1140905333093534"></a><a name="p1140905333093534"></a>Lays out the view on the bottom of the parent view. </p>
</td>
</tr>
<tr id="row430189380093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p936588775093534"><a name="p936588775093534"></a><a name="p936588775093534"></a><a href="graphic.md#gac7f5f2584c716a56fee3783f8dea6246">AlignLeftToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2138597663093534"><a name="p2138597663093534"></a><a name="p2138597663093534"></a>void </p>
<p id="p1322677479093534"><a name="p1322677479093534"></a><a name="p1322677479093534"></a>Aligns the view with the left of a sibling view. </p>
</td>
</tr>
<tr id="row83497619093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1780446827093534"><a name="p1780446827093534"></a><a name="p1780446827093534"></a><a href="graphic.md#gabb1ac454cdf95593c1e387d5e272433c">AlignRightToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1754996142093534"><a name="p1754996142093534"></a><a name="p1754996142093534"></a>void </p>
<p id="p1506888449093534"><a name="p1506888449093534"></a><a name="p1506888449093534"></a>Aligns the view with the right of a sibling view. </p>
</td>
</tr>
<tr id="row1631614787093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1307267089093534"><a name="p1307267089093534"></a><a name="p1307267089093534"></a><a href="graphic.md#ga903d7cbc59bac06d728b7f6435c9a504">AlignTopToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p924319025093534"><a name="p924319025093534"></a><a name="p924319025093534"></a>void </p>
<p id="p1538846935093534"><a name="p1538846935093534"></a><a name="p1538846935093534"></a>Aligns the view with the top of a sibling view. </p>
</td>
</tr>
<tr id="row347124484093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p805274520093534"><a name="p805274520093534"></a><a name="p805274520093534"></a><a href="graphic.md#ga7607c3f9661932c495d080e9d92fb1a3">AlignBottomToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1298928167093534"><a name="p1298928167093534"></a><a name="p1298928167093534"></a>void </p>
<p id="p1136982600093534"><a name="p1136982600093534"></a><a name="p1136982600093534"></a>Aligns the view with the bottom of a sibling view. </p>
</td>
</tr>
<tr id="row1000186625093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p191472011093534"><a name="p191472011093534"></a><a name="p191472011093534"></a><a href="graphic.md#gac23776dbc2fce7ff30d57438abfa5230">AlignHorCenterToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1602044769093534"><a name="p1602044769093534"></a><a name="p1602044769093534"></a>void </p>
<p id="p712645173093534"><a name="p712645173093534"></a><a name="p712645173093534"></a>Aligns the view with the center of a sibling view in the x-axis. </p>
</td>
</tr>
<tr id="row1903612747093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1352374123093534"><a name="p1352374123093534"></a><a name="p1352374123093534"></a><a href="graphic.md#gad3caa27aa0cb73ec4656e7d23aa222de">AlignVerCenterToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p600654299093534"><a name="p600654299093534"></a><a name="p600654299093534"></a>void </p>
<p id="p273659321093534"><a name="p273659321093534"></a><a name="p273659321093534"></a>Aligns the view with the center of a sibling view in the y-axis. </p>
</td>
</tr>
<tr id="row814528439093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1034781708093534"><a name="p1034781708093534"></a><a name="p1034781708093534"></a><a href="graphic.md#ga58f1a34a943c4492970f901d63bbc3d8">LayoutLeftToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1584697475093534"><a name="p1584697475093534"></a><a name="p1584697475093534"></a>void </p>
<p id="p2096207205093534"><a name="p2096207205093534"></a><a name="p2096207205093534"></a>Lays out the view on the left of a sibling view. </p>
</td>
</tr>
<tr id="row192734051093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p838857776093534"><a name="p838857776093534"></a><a name="p838857776093534"></a><a href="graphic.md#gac4cd64de5291759add164825a323a0d6">LayoutRightToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2145844029093534"><a name="p2145844029093534"></a><a name="p2145844029093534"></a>void </p>
<p id="p40054464093534"><a name="p40054464093534"></a><a name="p40054464093534"></a>Lays out the view on the right of a sibling view. </p>
</td>
</tr>
<tr id="row138384788093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1020394473093534"><a name="p1020394473093534"></a><a name="p1020394473093534"></a><a href="graphic.md#gaaa8385807e3a9bea46f8dcc326252a70">LayoutTopToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p315199744093534"><a name="p315199744093534"></a><a name="p315199744093534"></a>void </p>
<p id="p1100281091093534"><a name="p1100281091093534"></a><a name="p1100281091093534"></a>Lays out the view on the above of a sibling view. </p>
</td>
</tr>
<tr id="row1850355789093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p638078381093534"><a name="p638078381093534"></a><a name="p638078381093534"></a><a href="graphic.md#gaa23a68e8ef0fb13b362218e71cf67ace">LayoutBottomToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p741283066093534"><a name="p741283066093534"></a><a name="p741283066093534"></a>void </p>
<p id="p1494798595093534"><a name="p1494798595093534"></a><a name="p1494798595093534"></a>Lays out the view on the below of a sibling view. </p>
</td>
</tr>
<tr id="row252618967093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2113682206093534"><a name="p2113682206093534"></a><a name="p2113682206093534"></a><a href="graphic.md#ga9c1a3db000fdcd200fec8d2c49f5a0a8">SetStyle</a> (<a href="ohos-style.md">Style</a> &amp;style)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1863954858093534"><a name="p1863954858093534"></a><a name="p1863954858093534"></a>virtual void </p>
<p id="p320515371093534"><a name="p320515371093534"></a><a name="p320515371093534"></a>Sets the view style. </p>
</td>
</tr>
<tr id="row1498290957093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1032620868093534"><a name="p1032620868093534"></a><a name="p1032620868093534"></a><a href="graphic.md#ga0945c2f05815dc2e466ef9ceaca2f700">SetStyle</a> (uint8_t key, int64_t value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1831148780093534"><a name="p1831148780093534"></a><a name="p1831148780093534"></a>virtual void </p>
<p id="p820844500093534"><a name="p820844500093534"></a><a name="p820844500093534"></a>Sets a style. </p>
</td>
</tr>
<tr id="row2004220529093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1162186056093534"><a name="p1162186056093534"></a><a name="p1162186056093534"></a><a href="graphic.md#ga4ea19bc9f4b487946c9e29e63b54a0e6">GetStyle</a> (uint8_t key) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1308113337093534"><a name="p1308113337093534"></a><a name="p1308113337093534"></a>virtual int64_t </p>
<p id="p75179909093534"><a name="p75179909093534"></a><a name="p75179909093534"></a>Obtains the value of a style. </p>
</td>
</tr>
<tr id="row1178430672093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1424251816093534"><a name="p1424251816093534"></a><a name="p1424251816093534"></a><a href="graphic.md#ga1b28213d4c2cd0f8324bce3fe56eb7bb">GetStyleConst</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p726442829093534"><a name="p726442829093534"></a><a name="p726442829093534"></a>const <a href="ohos-style.md">Style</a> &amp; </p>
<p id="p741381125093534"><a name="p741381125093534"></a><a name="p741381125093534"></a>Obtains the view style. This function applies to scenarios where the style does not need to be modified, which saves memory. </p>
</td>
</tr>
<tr id="row515460061093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p411141672093534"><a name="p411141672093534"></a><a name="p411141672093534"></a><a href="graphic.md#ga4854963aa969ee20a6cd174a70f5cd23">operator new</a> (size_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1086530574093534"><a name="p1086530574093534"></a><a name="p1086530574093534"></a>void * </p>
<p id="p1065160708093534"><a name="p1065160708093534"></a><a name="p1065160708093534"></a>Overrides the <strong id="b613514960093534"><a name="b613514960093534"></a><a name="b613514960093534"></a>new</strong> function. </p>
</td>
</tr>
<tr id="row1653763311093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1404595056093534"><a name="p1404595056093534"></a><a name="p1404595056093534"></a><a href="graphic.md#gadf1997a0f56ac2b220e7f0f8e8e0a6ef">operator delete</a> (void *p)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p222767708093534"><a name="p222767708093534"></a><a name="p222767708093534"></a>void </p>
<p id="p1949323635093534"><a name="p1949323635093534"></a><a name="p1949323635093534"></a>Overrides the <strong id="b1566419006093534"><a name="b1566419006093534"></a><a name="b1566419006093534"></a>delete</strong> function. </p>
</td>
</tr>
</tbody>
</table>

## Additional Inherited Members<a name="inherited"></a>

<a name="table448711470093534"></a>
<table><thead align="left"><tr id="row395644661093534"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1980991389093534"><a name="p1980991389093534"></a><a name="p1980991389093534"></a>Additional Inherited Member Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1643859247093534"><a name="p1643859247093534"></a><a name="p1643859247093534"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1582306558093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p515048562093534"><a name="p515048562093534"></a><a name="p515048562093534"></a><a href="graphic.md#ga34fe81b667a13b06a579600827e0531b">GetAllChildRelativeRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1249426025093534"><a name="p1249426025093534"></a><a name="p1249426025093534"></a>Obtains the rectangle area of a new view group after being adaptive to the size of all child views. </p>
</td>
</tr>
<tr id="row1633061239093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p320525816093534"><a name="p320525816093534"></a><a name="p320525816093534"></a><a href="graphic.md#ga06a5bd621f6532fe5c8fd08a2c1314b2">OnChildChanged</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p241850554093534"><a name="p241850554093534"></a><a name="p241850554093534"></a>Performs operations needed after a child view is added or removed. </p>
</td>
</tr>
<tr id="row761303404093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1397280212093534"><a name="p1397280212093534"></a><a name="p1397280212093534"></a><a href="graphic.md#ga82ac8a2ca47014ecb5e142e1cd7d30c1">childrenHead_</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1697163347093534"><a name="p1697163347093534"></a><a name="p1697163347093534"></a>Indicates the pointer to the first child view of this view group. </p>
</td>
</tr>
<tr id="row1544431548093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1402976744093534"><a name="p1402976744093534"></a><a name="p1402976744093534"></a><a href="graphic.md#gaa0d6d1c8775e4765f8ae40d4573e0a83">childrenTail_</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1504695403093534"><a name="p1504695403093534"></a><a name="p1504695403093534"></a>Indicates the pointer to the last child view of this view group. </p>
</td>
</tr>
<tr id="row63857360093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1481950034093534"><a name="p1481950034093534"></a><a name="p1481950034093534"></a><a href="graphic.md#gaba49c636834e80a53373dd4c3687e298">childrenNum_</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1206490981093534"><a name="p1206490981093534"></a><a name="p1206490981093534"></a>Represents the number of child views. </p>
</td>
</tr>
<tr id="row1986881956093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p150133996093534"><a name="p150133996093534"></a><a name="p150133996093534"></a><a href="graphic.md#ga732108111fa141d8ad1d8a76f761307b">isDragging_</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p876679982093534"><a name="p876679982093534"></a><a name="p876679982093534"></a>Specifies the sliding state of this view group. </p>
</td>
</tr>
<tr id="row1118308635093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p25168159093534"><a name="p25168159093534"></a><a name="p25168159093534"></a><a href="graphic.md#ga712f1c3641cb16674202fbc723af8b74">disallowIntercept_</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1436491010093534"><a name="p1436491010093534"></a><a name="p1436491010093534"></a>Specifies whether this view group is intercepted upon touch events. </p>
</td>
</tr>
<tr id="row1177434575093534"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p246735888093534"><a name="p246735888093534"></a><a name="p246735888093534"></a><a href="graphic.md#ga1053e3677195fd4f98d68196d31d2cb5">isAutoSize_</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1638899360093534"><a name="p1638899360093534"></a><a name="p1638899360093534"></a>Specifies whether the size of this view group is adaptive to that of all child views. </p>
</td>
</tr>
</tbody>
</table>

