# 源码获取<a name="ZH-CN_TOPIC_0000001050769927"></a>

## OpenHarmony介绍<a name="section6370143622110"></a>

OpenHarmony是HarmonyOS的开源版，由华为捐赠给开放原子开源基金会（OpenAtom Foundation）开源。第一个开源版本支持在128KB\~128MB设备上运行，欢迎参加开源社区一起持续演进。

代码仓库地址：[https://openharmony.gitee.com](https://openharmony.gitee.com)

## 源码获取概述<a name="section12763342204"></a>

本文档将介绍如何获取OpenHarmony源码并说明OpenHarmony的源码目录结构。OpenHarmony的代码以[组件](../bundles/概述-0.md)的形式开放，开发者可以通过如下其中一种方式获取：

-   **获取方式1**：从镜像站点下载压缩文件（推荐）
-   **获取方式2**：从hpm网站组件式获取。通过[HPM](https://hpm.harmonyos.com)，查找满足需求的解决方案，挑选/裁剪组件后下载。
-   **获取方式3**：用包管理器命令行工具获取。通过[HPM](https://hpm.harmonyos.com)的hpm-cli命令行工具，执行命令下载。
-   **获取方式4**：从代码仓库获取。通过repo或git工具从代码仓库中下载。

## 获取方式1：从镜像站点获取<a name="section61172538310"></a>

为了获得更好的下载性能，您可以选择从以下站点的镜像库获取源码或者对应的解决方案。

**表 1**  源码获取路径

<a name="table9930153132517"></a>
<table><thead align="left"><tr id="row5928133152512"><th class="cellrowborder" valign="top" width="25%" id="mcps1.2.5.1.1"><p id="p1792803142518"><a name="p1792803142518"></a><a name="p1792803142518"></a>下载内容</p>
</th>
<th class="cellrowborder" valign="top" width="16.14%" id="mcps1.2.5.1.2"><p id="p0928738254"><a name="p0928738254"></a><a name="p0928738254"></a>版本信息</p>
</th>
<th class="cellrowborder" valign="top" width="24.759999999999998%" id="mcps1.2.5.1.3"><p id="p39281035251"><a name="p39281035251"></a><a name="p39281035251"></a>下载站点</p>
</th>
<th class="cellrowborder" valign="top" width="34.1%" id="mcps1.2.5.1.4"><p id="p292819322511"><a name="p292819322511"></a><a name="p292819322511"></a>SHA256校验码</p>
</th>
</tr>
</thead>
<tbody><tr id="row492963182513"><td class="cellrowborder" valign="top" width="25%" headers="mcps1.2.5.1.1 "><p id="p69292322516"><a name="p69292322516"></a><a name="p69292322516"></a><span id="text89291382513"><a name="text89291382513"></a><a name="text89291382513"></a>OpenHarmony</span>全量代码</p>
</td>
<td class="cellrowborder" valign="top" width="16.14%" headers="mcps1.2.5.1.2 "><p id="p79291938252"><a name="p79291938252"></a><a name="p79291938252"></a>1.0</p>
</td>
<td class="cellrowborder" valign="top" width="24.759999999999998%" headers="mcps1.2.5.1.3 "><p id="p10929236258"><a name="p10929236258"></a><a name="p10929236258"></a><a href="http://tools.harmonyos.com/mirrors/os/1.0/code-1.0.tar.gz" target="_blank" rel="noopener noreferrer">站点1</a>、<a href="https://mirrors.huaweicloud.com/harmonyos/os/1.0/code-1.0.tar.gz" target="_blank" rel="noopener noreferrer">站点2</a></p>
</td>
<td class="cellrowborder" valign="top" width="34.1%" headers="mcps1.2.5.1.4 "><p id="p992993202517"><a name="p992993202517"></a><a name="p992993202517"></a><a href="http://tools.harmonyos.com/mirrors/os/1.0/code-1.0.tar.gz.sha256" target="_blank" rel="noopener noreferrer">SHA256 校验码</a></p>
</td>
</tr>
<tr id="row6929934252"><td class="cellrowborder" valign="top" width="25%" headers="mcps1.2.5.1.1 "><p id="p0929163132512"><a name="p0929163132512"></a><a name="p0929163132512"></a>Hi3861解决方案</p>
</td>
<td class="cellrowborder" valign="top" width="16.14%" headers="mcps1.2.5.1.2 "><p id="p392913162517"><a name="p392913162517"></a><a name="p392913162517"></a>1.0</p>
</td>
<td class="cellrowborder" valign="top" width="24.759999999999998%" headers="mcps1.2.5.1.3 "><p id="p592912312511"><a name="p592912312511"></a><a name="p592912312511"></a><a href="http://tools.harmonyos.com/mirrors/os/1.0/wifiiot-1.0.tar.gz" target="_blank" rel="noopener noreferrer">站点1</a>、<a href="https://mirrors.huaweicloud.com/harmonyos/os/1.0/wifiiot-1.0.tar.gz" target="_blank" rel="noopener noreferrer">站点2</a></p>
</td>
<td class="cellrowborder" valign="top" width="34.1%" headers="mcps1.2.5.1.4 "><p id="p199296318252"><a name="p199296318252"></a><a name="p199296318252"></a><a href="http://tools.harmonyos.com/mirrors/os/1.0/wifiiot-1.0.tar.gz.sha256" target="_blank" rel="noopener noreferrer">SHA256 校验码</a></p>
</td>
</tr>
<tr id="row1293014352510"><td class="cellrowborder" valign="top" width="25%" headers="mcps1.2.5.1.1 "><p id="p692917311258"><a name="p692917311258"></a><a name="p692917311258"></a>Hi3518解决方案</p>
</td>
<td class="cellrowborder" valign="top" width="16.14%" headers="mcps1.2.5.1.2 "><p id="p49291935254"><a name="p49291935254"></a><a name="p49291935254"></a>1.0</p>
</td>
<td class="cellrowborder" valign="top" width="24.759999999999998%" headers="mcps1.2.5.1.3 "><p id="p1792943152517"><a name="p1792943152517"></a><a name="p1792943152517"></a><a href="http://tools.harmonyos.com/mirrors/os/1.0/ipcamera_hi3518ev300-1.0.tar.gz" target="_blank" rel="noopener noreferrer">站点1</a>、<a href="https://mirrors.huaweicloud.com/harmonyos/os/1.0/ipcamera_hi3518ev300-1.0.tar.gz" target="_blank" rel="noopener noreferrer">站点2</a></p>
</td>
<td class="cellrowborder" valign="top" width="34.1%" headers="mcps1.2.5.1.4 "><p id="p1392983162514"><a name="p1392983162514"></a><a name="p1392983162514"></a><a href="http://tools.harmonyos.com/mirrors/os/1.0/ipcamera_hi3518ev300-1.0.tar.gz.sha256" target="_blank" rel="noopener noreferrer">SHA256 校验码</a></p>
</td>
</tr>
<tr id="row199306317255"><td class="cellrowborder" valign="top" width="25%" headers="mcps1.2.5.1.1 "><p id="p1693063122511"><a name="p1693063122511"></a><a name="p1693063122511"></a>Hi3516解决方案</p>
</td>
<td class="cellrowborder" valign="top" width="16.14%" headers="mcps1.2.5.1.2 "><p id="p169301335252"><a name="p169301335252"></a><a name="p169301335252"></a>1.0</p>
</td>
<td class="cellrowborder" valign="top" width="24.759999999999998%" headers="mcps1.2.5.1.3 "><p id="p1393012302510"><a name="p1393012302510"></a><a name="p1393012302510"></a><a href="http://tools.harmonyos.com/mirrors/os/1.0/ipcamera_hi3516dv300-1.0.tar.gz" target="_blank" rel="noopener noreferrer">站点1</a>、<a href="https://mirrors.huaweicloud.com/harmonyos/os/1.0/ipcamera_hi3516dv300-1.0.tar.gz" target="_blank" rel="noopener noreferrer">站点2</a></p>
</td>
<td class="cellrowborder" valign="top" width="34.1%" headers="mcps1.2.5.1.4 "><p id="p1393083102517"><a name="p1393083102517"></a><a name="p1393083102517"></a><a href="http://tools.harmonyos.com/mirrors/os/1.0/ipcamera_hi3516dv300-1.0.tar.gz.sha256" target="_blank" rel="noopener noreferrer">SHA256 校验码</a></p>
</td>
</tr>
<tr id="row13795111119551"><td class="cellrowborder" valign="top" width="25%" headers="mcps1.2.5.1.1 "><p id="p679516111552"><a name="p679516111552"></a><a name="p679516111552"></a>RELEASE-NOTES</p>
</td>
<td class="cellrowborder" valign="top" width="16.14%" headers="mcps1.2.5.1.2 "><p id="p13796201120553"><a name="p13796201120553"></a><a name="p13796201120553"></a>1.0</p>
</td>
<td class="cellrowborder" valign="top" width="24.759999999999998%" headers="mcps1.2.5.1.3 "><p id="p8796911155518"><a name="p8796911155518"></a><a name="p8796911155518"></a><a href="http://tools.harmonyos.com/mirrors/os/1.0/RELEASE-NOTES.txt" target="_blank" rel="noopener noreferrer">站点1</a></p>
</td>
<td class="cellrowborder" valign="top" width="34.1%" headers="mcps1.2.5.1.4 "><p id="p16796011205518"><a name="p16796011205518"></a><a name="p16796011205518"></a>-</p>
</td>
</tr>
</tbody>
</table>

## 获取方式2：从hpm网站组件式获取<a name="section463013147412"></a>

## 适用场景<a name="section123926431441"></a>

对于刚接触OpenHarmony的新用户，希望能够参考一些示例解决方案从而进行快速开发。可以在[HPM](https://hpm.harmonyos.com)获取推荐的解决方案，以此为基础，增加或裁剪部分组件，快速定制系统。

## 操作步骤<a name="section1781916234118"></a>

1.  查找合适的解决方案组件包。
    1.  打开包管理页面[HPM](https://hpm.harmonyOS.com)，设定搜索的对象为“解决方案“，如下图所示。
    2.  自搜索框输入关键字搜索，如"camera"。
    3.  结果中显示匹配的解决方案，可以进一步根据组件类别等过滤条件\(如：适配的开发板，内核）精确筛选。
    4.  查找合适的解决方案，点击查看解决方案详情介绍。

        **图 1**  包管理<a name="fig838103114320"></a>  
        

        ![](figures/zh-cn_image_0000001054919529.png)


2.  定制解决方案组件包。

    1.  仔细阅读解决方案的说明，以了解该解决方案的使用场景、特性、使用方法以及如何进行定制化，如下图所示。
    2.  点击「直接下载」，将解决方案下载到本地。
    3.  点击「定制组件」，将对解决方案包含的组件进行定制。

    **图 2**  解决方案示例<a name="fig1329851510414"></a>  
    

    ![](figures/zh-cn_image_0000001054719501.png)

3.  定制组件。
    1.  进入解决方案定制页面，如下图所示。
    2.  通过关闭开关移除可选组件，或者通过“添加组件”增加新的组件。
    3.  在右边填写您的项目基本信息，包括名称、版本、描述等信息。
    4.  点击“下载“，系统会根据您的选择，生成相应的OpenHarmony代码结构文件\(如name.zip\)，保存至本地文件。
        -   下载的压缩文件并未包含源代码的原始文件，可以在IDE中导入下载的压缩包，解压后执行hpm的安装指令\(hpm install），才会将所需要的组件全部下载下来。
        -   下载的组件存在工程目录下的ohos\_bundles文件夹中。

            **图 3**  组件定制<a name="fig2448349749"></a>  
            

            ![](figures/zh-cn_image_0000001055679464.png)




## 获取方式3：用包管理器命令行获取<a name="section9459261856"></a>

## 适用场景<a name="section1854923620139"></a>

-   用户已通过组件式获取的方式获取源码，需要对源码中的某个或某几个组件进行独立升级。
-   用户已经比较熟悉OpenHarmony系统的开发并且熟练掌握命令行工具的使用。

## 准备<a name="section4451113551114"></a>

通过命令行获取，需要先安装Node.js和hpm命令行工具，安装步骤如下：

1.  安装Node.js。

    官网下载并在本地安装Node.js.

    推荐安装  [Node.js](https://nodejs.org/)  12.x \(包含 npm 6.14.4\)或更高版本 \(推荐 12.13.0+\)。

2.  通过Node.js自带的npm安装hpm命令行工具。

    打开CMD，执行以下命令：

    ```
    npm install -g @ohos/hpm-cli
    ```

3.  安装完成后执行如下命令，显示hpm版本，即安装成功。

    ```
    hpm -V 或 hpm --version
    ```

4.  如果升级hpm的版本，请执行如下命令：

    ```
    npm update -g @ohos/hpm-cli
    ```


## 操作<a name="section1445143510117"></a>

接下来将组件添加到开发项目中，假定要获取的组件名为@ohos/demo，具体操作如下：

1.  进入开发目录，执行如下命令，采用默认模板创建一个开发项目。

    ```
    hpm init -t default
    ```

2.  执行如下命令，安装组件@ohos/demo

    ```
    hpm install @ohos/demo
    ```

3.  工具会自动从服务器下载所有依赖的组件，下载成功则显示Install successfully!

    ```
    $ hpm install @ohos/demo
    Requesting: https://url.foo.bar/hpm/registry/api/bundles/@ohos/demo
    downloading @ohos/demo
    Requesting: https://lfcontentcenterdev....../bMAlLrYISLqdUTFFFCdgzA.tgz
    extract D:\demo\ohos_bundles\@ohos\demo\@ohos-demo-1.0.7.tgz
    Install successfully!
    ```


## 获取方式4：从代码仓库获取<a name="section537312010229"></a>

## 适用场景<a name="section1492115412228"></a>

-   基于OpenHarmony的稳定分支建立自己的基线，分发下游客户。

-   已经完成自身软件与OpenHarmony的对接，需要进行OpenHarmony官方认证。

-   芯片/模组/app通过OpenHarmony官方认证后，贡献代码到OpenHarmony生态。

-   修复OpenHarmony的问题。

-   学习OpenHarmony的源码。


## 准备<a name="section1076962313239"></a>

1.  注册码云gitee账号。
2.  注册码云SSH公钥，请参考码云帮助中心的公钥管理：[https://gitee.com/help/articles/4181](https://gitee.com/help/articles/4181)
3.  安装git客户端并配置用户信息。

    ```
    git config --global user.name "yourname"
    git config --global user.email "your-email-address"
    git config --global credential.helper store
    ```

4.  安装码云repo工具，可以执行如下命令。

    ```
    curl https://gitee.com/oschina/repo/raw/fork_flow/repo-py3 > /usr/local/bin/repo
    chmod a+x /usr/local/bin/repo
    pip install -i https://pypi.tuna.tsinghua.edu.cn/simple requests
    ```


## 操作<a name="section17162735266"></a>

方式一（推荐）：通过repo下载

```
repo init -u https://gitee.com/openharmony/manifest.git -b master --no-repo-verify
repo sync -c
```

方式二：通过git clone单个代码仓库

进入代码仓库主页：https://gitee.com/openharmony，选择需要克隆的代码仓库，执行命令，如：

```
git clone https://gitee.com/openharmony/manifest.git -b master
```

## 源码目录简介<a name="section1072115612811"></a>

下表是OpenHarmony源码的目录及简单说明：

**表 2**  源码目录的说明

<a name="table3815144702820"></a>
<table><thead align="left"><tr id="row198162047192810"><th class="cellrowborder" valign="top" width="50%" id="mcps1.2.3.1.1"><p id="p690319291299"><a name="p690319291299"></a><a name="p690319291299"></a>目录名</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.2.3.1.2"><p id="p5903122962918"><a name="p5903122962918"></a><a name="p5903122962918"></a>描述</p>
</th>
</tr>
</thead>
<tbody><tr id="row1981674719280"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.2.3.1.1 "><p id="p69031429162912"><a name="p69031429162912"></a><a name="p69031429162912"></a>applications</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.2.3.1.2 "><p id="p090352912914"><a name="p090352912914"></a><a name="p090352912914"></a>应用程序样例，包括wifi-iot，camera等</p>
</td>
</tr>
<tr id="row5816747132817"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.2.3.1.1 "><p id="p99031129112918"><a name="p99031129112918"></a><a name="p99031129112918"></a>base</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.2.3.1.2 "><p id="p790472962914"><a name="p790472962914"></a><a name="p790472962914"></a>基础软件服务子系统集&amp;硬件服务子系统集</p>
</td>
</tr>
<tr id="row1134218692910"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.2.3.1.1 "><p id="p4904112910295"><a name="p4904112910295"></a><a name="p4904112910295"></a>build</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.2.3.1.2 "><p id="p1090482942911"><a name="p1090482942911"></a><a name="p1090482942911"></a>组件化编译、构建和配置脚本</p>
</td>
</tr>
<tr id="row1841618902919"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.2.3.1.1 "><p id="p1390462902910"><a name="p1390462902910"></a><a name="p1390462902910"></a>domains</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.2.3.1.2 "><p id="p1390432914296"><a name="p1390432914296"></a><a name="p1390432914296"></a>增强软件服务子系统集</p>
</td>
</tr>
<tr id="row841620912298"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.2.3.1.1 "><p id="p119041629182919"><a name="p119041629182919"></a><a name="p119041629182919"></a>drivers</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.2.3.1.2 "><p id="p9904629132911"><a name="p9904629132911"></a><a name="p9904629132911"></a>驱动子系统</p>
</td>
</tr>
<tr id="row164164992915"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.2.3.1.1 "><p id="p79042298298"><a name="p79042298298"></a><a name="p79042298298"></a>foundation</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.2.3.1.2 "><p id="p18904132922915"><a name="p18904132922915"></a><a name="p18904132922915"></a>系统基础能力子系统集</p>
</td>
</tr>
<tr id="row1441610922915"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.2.3.1.1 "><p id="p490402916299"><a name="p490402916299"></a><a name="p490402916299"></a>kernel</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.2.3.1.2 "><p id="p1904112932912"><a name="p1904112932912"></a><a name="p1904112932912"></a>内核子系统</p>
</td>
</tr>
<tr id="row194175972917"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.2.3.1.1 "><p id="p1904132912910"><a name="p1904132912910"></a><a name="p1904132912910"></a>prebuilts</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.2.3.1.2 "><p id="p390492919296"><a name="p390492919296"></a><a name="p390492919296"></a>编译器及工具链子系统</p>
</td>
</tr>
<tr id="row841718942913"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.2.3.1.1 "><p id="p12904929202919"><a name="p12904929202919"></a><a name="p12904929202919"></a>test</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.2.3.1.2 "><p id="p4904152912297"><a name="p4904152912297"></a><a name="p4904152912297"></a>测试子系统</p>
</td>
</tr>
<tr id="row24175915294"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.2.3.1.1 "><p id="p13904162992916"><a name="p13904162992916"></a><a name="p13904162992916"></a>third_party</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.2.3.1.2 "><p id="p6904829112917"><a name="p6904829112917"></a><a name="p6904829112917"></a>开源第三方组件</p>
</td>
</tr>
<tr id="row334210652914"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.2.3.1.1 "><p id="p1390442918299"><a name="p1390442918299"></a><a name="p1390442918299"></a>utils</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.2.3.1.2 "><p id="p690412296297"><a name="p690412296297"></a><a name="p690412296297"></a>常用的工具集</p>
</td>
</tr>
<tr id="row73421664298"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.2.3.1.1 "><p id="p7905172920292"><a name="p7905172920292"></a><a name="p7905172920292"></a>vendor</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.2.3.1.2 "><p id="p290510290293"><a name="p290510290293"></a><a name="p290510290293"></a>厂商提供的软件</p>
</td>
</tr>
<tr id="row734319617292"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.2.3.1.1 "><p id="p09056291290"><a name="p09056291290"></a><a name="p09056291290"></a>build.py</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.2.3.1.2 "><p id="p1790542912290"><a name="p1790542912290"></a><a name="p1790542912290"></a>编译脚本文件</p>
</td>
</tr>
</tbody>
</table>

