# 开发<a name="ZH-CN_TOPIC_0000001054690948"></a>

1.  请先完成[《Hi3861快速入门》](../quick-start/Hi3861开发板介绍.md)。

    LED控制参考示例存放于applications/sample/wifi-iot/app/iothardware/led\_example.c文件中。

2.  实现IOT外设控制，首先需要通过查阅原理图明确接线关系。经过查阅，可以发现LED与功能复用管脚WIFI\_IOT\_IO\_NAME\_GPIO\_9相连。

    >![](public_sys-resources/icon-note.gif) **说明：** 
    >开发板原理图，请开发者联系Hi3861购买渠道客服获取。

3.  使用GPIO前，需要完成GPIO管脚初始化，明确管脚用途，并创建任务，使LED周期性亮灭，达到闪烁的效果。

    ```
    static void LedExampleEntry(void)
    {
        osThreadAttr_t attr;
    
        /* 管脚初始化 */
        GpioInit();
        /* 配置9号管脚作为GPIO */
        IoSetFunc(WIFI_IOT_IO_NAME_GPIO_9, WIFI_IOT_IO_FUNC_GPIO_9_GPIO);
        /* 配置9号管脚为输出方向 */
        GpioSetDir(WIFI_IOT_IO_NAME_GPIO_9, WIFI_IOT_GPIO_DIR_OUT);
    
        attr.name = "LedTask";
        attr.attr_bits = 0U;
        attr.cb_mem = NULL;
        attr.cb_size = 0U;
        attr.stack_mem = NULL;
        attr.stack_size = LED_TASK_STACK_SIZE;
        attr.priority = LED_TASK_PRIO;
    
        /* 启动任务 */
        if (osThreadNew((osThreadFunc_t)LedTask, NULL, &attr) == NULL) {
            printf("[LedExample] Falied to create LedTask!\n");
        }
    }
    ```

4.  在循环任务中通过周期性亮灭形式实现LED闪烁。

    ```
    static void *LedTask(const char *arg)
    {
        (void)arg;
        while (1) {
            switch (g_ledState) {
                case LED_ON:
                    GpioSetOutputVal(WIFI_IOT_IO_NAME_GPIO_9, 1);
                    usleep(LED_INTERVAL_TIME_US);
                    break;
                case LED_OFF:
                    GpioSetOutputVal(WIFI_IOT_IO_NAME_GPIO_9, 0);
                    usleep(LED_INTERVAL_TIME_US);
                    break;
                case LED_SPARK:
                    GpioSetOutputVal(WIFI_IOT_IO_NAME_GPIO_9, 0);
                    usleep(LED_INTERVAL_TIME_US);
                    GpioSetOutputVal(WIFI_IOT_IO_NAME_GPIO_9, 1);
                    usleep(LED_INTERVAL_TIME_US);
                    break;
                default:
                    usleep(LED_INTERVAL_TIME_US);
                    break;
            }
        }
        return NULL;
    }
    ```

5.  在代码最下方，使用OpenHarmony启动恢复模块接口SYS\_RUN\(\)启动业务。（SYS\_RUN定义在ohos\_init.h文件中）

    ```
    SYS_RUN(LedExampleEntry);
    ```

6.  修改applications/sample/wifi-iot/app/BUILD.gn文件，使led\_example.c参与编译。

    ```
    import("//build/lite/config/component/lite_component.gni")
    lite_component("app") {
        features = [
            "iothardware:led_example"
        ]
    }
    ```


